/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecordFM;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class ExtDbRecord
implements StationRecord {
    public static final int STATUS_TYPE_STA = 0;
    public static final int STATUS_TYPE_CP = 1;
    public static final int STATUS_TYPE_LIC = 2;
    public static final int STATUS_TYPE_APP = 3;
    public static final int STATUS_TYPE_OTHER = 4;
    public static final int STATUS_TYPE_EXP = 5;
    public static final int STATUS_TYPE_AMD = 6;
    public static final String[] STATUS_CODES = new String[]{"STA", "CP", "LIC", "APP", "", "EXP", "AMD"};
    public static final int FLAG_MATCH_SET = 1;
    public static final int FLAG_MATCH_CLEAR = 2;
    public static final int FLAG_MATCH_ANY = 3;
    public final ExtDb extDb;
    public final int recordType;
    public String extRecordID;
    public Service service;
    public String city;
    public String state;
    public Country country;
    public final GeoPoint location;
    public double heightAMSL;
    public double overallHAAT;
    public double peakERP;
    public String antennaID;
    public String antennaRecordID;
    public double horizontalPatternOrientation;
    public String elevationAntennaRecordID;
    public double verticalPatternElectricalTilt;
    public double verticalPatternMechanicalTilt;
    public double verticalPatternMechanicalTiltOrientation;
    public boolean isPending;
    public boolean isArchived;
    public Date sequenceDate;
    public static final String BAD_TYPE_MESSAGE = "Unknown or unsupported station data type";
    private static ArrayList<KeyedRecord> statusList = null;
    private static HashMap<String, Service> cdbsCodeCache = new HashMap();
    private static HashMap<String, Service> lmsCodeCache = new HashMap();

    public static ArrayList<KeyedRecord> getStatusList() {
        if (null == statusList) {
            statusList = new ArrayList();
            statusList.add(new KeyedRecord(2, STATUS_CODES[2]));
            statusList.add(new KeyedRecord(1, STATUS_CODES[1]));
            statusList.add(new KeyedRecord(3, STATUS_CODES[3]));
            statusList.add(new KeyedRecord(0, STATUS_CODES[0]));
            statusList.add(new KeyedRecord(6, STATUS_CODES[6]));
            statusList.add(new KeyedRecord(5, STATUS_CODES[5]));
        }
        return statusList;
    }

    public static boolean doesRecordIDExist(String string, Integer n, String string2) {
        ExtDb extDb = ExtDb.getExtDb(string, n);
        if (null == extDb) {
            return false;
        }
        return ExtDbRecord.doesRecordIDExist(extDb, string2);
    }

    public static boolean doesRecordIDExist(ExtDb extDb, String string) {
        if (extDb.canProvide(1) && ExtDbRecordTV.doesRecordIDExistTV(extDb, string)) {
            return true;
        }
        return extDb.canProvide(3) && ExtDbRecordFM.doesRecordIDExistFM(extDb, string);
    }

    public static boolean addRecordIDQuery(int n, int n2, int n3, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addRecordIDQueryTV(n, n2, string, stringBuilder, bl);
            }
            case 3: {
                return ExtDbRecordFM.addRecordIDQueryFM(n, n2, string, stringBuilder, bl);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static String[] parseFileNumber(String string) {
        String[] stringArray = new String[2];
        String string2 = string.toUpperCase();
        if (string2.startsWith("BLANK")) {
            stringArray[0] = "";
            stringArray[1] = (string = string.substring(5)).startsWith("-") ? string.substring(1) : string;
        } else if (string2.startsWith("B")) {
            StringBuilder stringBuilder = new StringBuilder();
            stringArray[1] = "";
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isDigit(c)) {
                    stringArray[1] = DbConnection.clean(string.substring(i));
                    break;
                }
                if ('-' == c) {
                    stringArray[1] = DbConnection.clean(string.substring(i + 1));
                    break;
                }
                stringBuilder.append(c);
            }
            stringArray[0] = DbConnection.clean(stringBuilder.toString());
        } else {
            stringArray[0] = "";
            stringArray[1] = string;
        }
        return stringArray;
    }

    public static boolean addFileNumberQuery(int n, int n2, int n3, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        String[] stringArray = ExtDbRecord.parseFileNumber(string);
        return ExtDbRecord.addFileNumberQuery(n, n2, n3, stringArray[0], stringArray[1], stringBuilder, bl);
    }

    public static boolean addFileNumberQuery(int n, int n2, int n3, String string, String string2, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addFileNumberQueryTV(n, n2, string, string2, stringBuilder, bl);
            }
            case 3: {
                return ExtDbRecordFM.addFileNumberQueryFM(n, n2, string, string2, stringBuilder, bl);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static boolean addFacilityIDQuery(int n, int n2, int n3, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        int n4 = 0;
        try {
            n4 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The facility ID must be a number");
        }
        return ExtDbRecord.addFacilityIDQuery(n, n2, n3, n4, stringBuilder, bl);
    }

    public static boolean addFacilityIDQuery(int n, int n2, int n3, int n4, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addFacilityIDQueryTV(n, n2, n4, stringBuilder, bl);
            }
            case 3: {
                return ExtDbRecordFM.addFacilityIDQueryFM(n, n2, n4, stringBuilder, bl);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static boolean addServiceQuery(int n, int n2, int n3, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        Service service = Service.getService(string);
        if (null == service) {
            throw new IllegalArgumentException("Unknown service code");
        }
        return ExtDbRecord.addServiceQuery(n, n2, n3, service.key, stringBuilder, bl);
    }

    public static boolean addServiceQuery(int n, int n2, int n3, int n4, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addServiceQueryTV(n, n2, n4, stringBuilder, bl);
            }
            case 3: {
                return ExtDbRecordFM.addServiceQueryFM(n, n2, n4, stringBuilder, bl);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static boolean addCallSignQuery(int n, int n2, int n3, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addCallSignQueryTV(n, n2, string, stringBuilder, bl);
            }
            case 3: {
                return ExtDbRecordFM.addCallSignQueryFM(n, n2, string, stringBuilder, bl);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static boolean addChannelQuery(int n, int n2, int n3, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        return ExtDbRecord.addChannelQuery(n, n2, n3, string, 0, 0, stringBuilder, bl);
    }

    public static boolean addChannelQuery(int n, int n2, int n3, String string, int n4, int n5, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        int n6 = 0;
        try {
            n6 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The channel must be a number");
        }
        return ExtDbRecord.addChannelQuery(n, n2, n3, n6, n4, n5, stringBuilder, bl);
    }

    public static boolean addChannelQuery(int n, int n2, int n3, int n4, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        return ExtDbRecord.addChannelQuery(n, n2, n3, n4, 0, 0, stringBuilder, bl);
    }

    public static boolean addChannelQuery(int n, int n2, int n3, int n4, int n5, int n6, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addChannelQueryTV(n, n2, n4, n5, n6, stringBuilder, bl);
            }
            case 3: {
                return ExtDbRecordFM.addChannelQueryFM(n, n2, n4, n5, n6, stringBuilder, bl);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static boolean addChannelRangeQuery(int n, int n2, int n3, int n4, int n5, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addChannelRangeQueryTV(n, n2, n4, n5, stringBuilder, bl);
            }
            case 3: {
                return ExtDbRecordFM.addChannelRangeQueryFM(n, n2, n4, n5, stringBuilder, bl);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static boolean addMultipleChannelQuery(int n, int n2, int n3, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addMultipleChannelQueryTV(n, n2, string, stringBuilder, bl);
            }
            case 3: {
                return ExtDbRecordFM.addMultipleChannelQueryFM(n, n2, string, stringBuilder, bl);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static boolean addStatusQuery(int n, int n2, int n3, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        return ExtDbRecord.addStatusQuery(n, n2, n3, ExtDbRecord.getStatusType(string), stringBuilder, bl);
    }

    public static boolean addStatusQuery(int n, int n2, int n3, int n4, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addStatusQueryTV(n, n2, n4, stringBuilder, bl);
            }
            case 3: {
                return ExtDbRecordFM.addStatusQueryFM(n, n2, n4, stringBuilder, bl);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static boolean addCityQuery(int n, int n2, int n3, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addCityQueryTV(n, n2, string, stringBuilder, bl);
            }
            case 3: {
                return ExtDbRecordFM.addCityQueryFM(n, n2, string, stringBuilder, bl);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static boolean addStateQuery(int n, int n2, int n3, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addStateQueryTV(n, n2, string, stringBuilder, bl);
            }
            case 3: {
                return ExtDbRecordFM.addStateQueryFM(n, n2, string, stringBuilder, bl);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static boolean addCountryQuery(int n, int n2, int n3, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        Country country = Country.getCountry(string);
        if (null == country) {
            throw new IllegalArgumentException("Unknown country code");
        }
        return ExtDbRecord.addCountryQuery(n, n2, n3, country, stringBuilder, bl);
    }

    public static boolean addCountryQuery(int n, int n2, int n3, int n4, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        Country country = Country.getCountry(n4);
        if (null == country) {
            throw new IllegalArgumentException("Unknown country key");
        }
        return ExtDbRecord.addCountryQuery(n, n2, n3, country, stringBuilder, bl);
    }

    public static boolean addCountryQuery(int n, int n2, int n3, Country country, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addCountryQueryTV(n, n2, country, stringBuilder, bl);
            }
            case 3: {
                return ExtDbRecordFM.addCountryQueryFM(n, n2, country, stringBuilder, bl);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static boolean addRecordTypeQuery(int n, int n2, int n3, boolean bl, StringBuilder stringBuilder, boolean bl2) {
        switch (n3) {
            case 1: {
                return ExtDbRecordTV.addRecordTypeQueryTV(n, n2, bl, stringBuilder, bl2);
            }
            case 3: {
                return ExtDbRecordFM.addRecordTypeQueryFM(n, n2, bl, stringBuilder, bl2);
            }
        }
        throw new IllegalArgumentException(BAD_TYPE_MESSAGE);
    }

    public static int getStatusType(String string) {
        for (int i = 0; i < STATUS_CODES.length; ++i) {
            if (4 == i || !STATUS_CODES[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return 4;
    }

    public static String makeMessage(StationRecord stationRecord, String string) {
        return String.format(Locale.US, "%-6.6s %-8.8s %-3.3s %-2.2s %-6.6s: %s", stationRecord.getFacilityID(), stationRecord.getCallSign(), stationRecord.getChannel(), stationRecord.getServiceCode(), stationRecord.getStatus(), string);
    }

    public static void loadCache(DbConnection dbConnection) throws SQLException {
        Service service;
        cdbsCodeCache.clear();
        lmsCodeCache.clear();
        dbConnection.query("SELECT cdbs_service_code, service_key FROM cdbs_service");
        while (dbConnection.next()) {
            service = Service.getService(dbConnection.getInt(2));
            if (null == service) continue;
            cdbsCodeCache.put(dbConnection.getString(1), service);
        }
        dbConnection.query("SELECT lms_service_code, service_key FROM lms_service");
        while (dbConnection.next()) {
            service = Service.getService(dbConnection.getInt(2));
            if (null == service) continue;
            lmsCodeCache.put(dbConnection.getString(1), service);
        }
    }

    public static Service getService(int n, String string) {
        switch (n) {
            case 1: 
            case 4: {
                return cdbsCodeCache.get(string);
            }
            case 2: 
            case 5: {
                return lmsCodeCache.get(string);
            }
        }
        return null;
    }

    public static void addServiceCodeList(int n, int n2, StringBuilder stringBuilder) {
        ExtDbRecord.addServiceCodeList(n, n2, 0, 3, 3, stringBuilder);
    }

    public static void addServiceCodeList(int n, int n2, int n3, StringBuilder stringBuilder) {
        ExtDbRecord.addServiceCodeList(n, n2, n3, 3, 3, stringBuilder);
    }

    public static void addServiceCodeList(int n, int n2, int n3, int n4, StringBuilder stringBuilder) {
        ExtDbRecord.addServiceCodeList(n, n2, 0, n3, n4, stringBuilder);
    }

    private static void addServiceCodeList(int n, int n2, int n3, int n4, int n5, StringBuilder stringBuilder) {
        stringBuilder.append("('");
        HashMap<String, Service> hashMap = null;
        switch (n) {
            case 1: 
            case 4: {
                hashMap = cdbsCodeCache;
                break;
            }
            case 2: 
            case 5: {
                hashMap = lmsCodeCache;
            }
        }
        if (null != hashMap) {
            String string = "";
            for (Map.Entry<String, Service> entry : hashMap.entrySet()) {
                Service service = entry.getValue();
                if (0 != n3 && n3 != service.key || 0 != n2 && n2 != service.serviceType.recordType || 1 == n4 && !service.isOperating || 2 == n4 && service.isOperating || 1 == n5 && !service.serviceType.digital || 2 == n5 && service.serviceType.digital) continue;
                stringBuilder.append(string);
                stringBuilder.append(entry.getKey());
                string = "','";
            }
        }
        stringBuilder.append("')");
    }

    protected ExtDbRecord(ExtDb extDb, int n) {
        this.extDb = extDb;
        this.recordType = n;
        this.location = new GeoPoint();
        this.sequenceDate = new Date();
    }

    public String toString() {
        return this.getCallSign() + " " + this.getChannel() + " " + this.getServiceCode() + " " + this.getStatus() + " " + this.getCity() + ", " + this.getState();
    }

    public String makeCommentText() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = this.getComments();
        if (null != arrayList && !arrayList.isEmpty()) {
            String string = "<HTML>";
            for (String string2 : arrayList) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
                string = "<BR>";
            }
            stringBuilder.append("</HTML>");
        }
        return stringBuilder.toString();
    }

    protected ArrayList<String> getComments() {
        return null;
    }

    @Override
    public String getRecordType() {
        return this.extDb.getTypeName();
    }

    @Override
    public boolean isSource() {
        return false;
    }

    @Override
    public boolean hasRecordID() {
        return true;
    }

    @Override
    public boolean isReplication() {
        return false;
    }

    @Override
    public String getStationData() {
        return ExtDb.getExtDbDescription(this.extDb.dbID, this.extDb.key);
    }

    @Override
    public String getRecordID() {
        return this.extRecordID;
    }

    @Override
    public String getFacilityID() {
        return "";
    }

    @Override
    public String getSortFacilityID() {
        return "0";
    }

    @Override
    public String getService() {
        return this.service.name;
    }

    @Override
    public String getServiceCode() {
        return this.service.serviceCode;
    }

    @Override
    public boolean isDigital() {
        return this.service.serviceType.digital;
    }

    @Override
    public boolean isDTS() {
        return this.service.isDTS;
    }

    @Override
    public String getSiteCount() {
        return "";
    }

    @Override
    public String getCallSign() {
        return "";
    }

    @Override
    public String getChannel() {
        return "";
    }

    @Override
    public int getChannelNumber() {
        return 0;
    }

    @Override
    public String getSortChannel() {
        return "0";
    }

    @Override
    public String getOriginalChannel() {
        return this.getChannel();
    }

    @Override
    public String getFrequency() {
        return "";
    }

    @Override
    public double getFrequencyValue() {
        return 0.0;
    }

    @Override
    public String getCity() {
        return this.city;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getCountry() {
        return this.country.name;
    }

    @Override
    public String getCountryCode() {
        return this.country.countryCode;
    }

    @Override
    public String getSortCountry() {
        return String.valueOf(this.country.key);
    }

    @Override
    public String getZone() {
        return "";
    }

    @Override
    public String getStatus() {
        return "";
    }

    @Override
    public String getSortStatus() {
        return "";
    }

    @Override
    public String getFileNumber() {
        return "";
    }

    @Override
    public String getARN() {
        return "";
    }

    @Override
    public String getSequenceDate() {
        return AppCore.formatDate(this.sequenceDate);
    }

    @Override
    public String getSortSequenceDate() {
        return String.format(Locale.US, "%013d", this.sequenceDate.getTime());
    }

    @Override
    public String getFrequencyOffset() {
        return "";
    }

    @Override
    public String getEmissionMask() {
        return "";
    }

    @Override
    public String getLatitude() {
        return AppCore.formatLatitude(this.location.latitude);
    }

    @Override
    public String getLongitude() {
        return AppCore.formatLongitude(this.location.longitude);
    }

    @Override
    public String getHeightAMSL() {
        if (-999.0 == this.heightAMSL) {
            return "(derive)";
        }
        return AppCore.formatHeight(this.heightAMSL) + " m";
    }

    @Override
    public String getOverallHAAT() {
        if (-999.0 == this.overallHAAT) {
            return "(derive)";
        }
        return AppCore.formatHeight(this.overallHAAT) + " m";
    }

    @Override
    public String getPeakERP() {
        return AppCore.formatERP(this.peakERP) + " kW";
    }

    @Override
    public boolean hasHorizontalPattern() {
        return null != this.antennaRecordID;
    }

    @Override
    public String getHorizontalPatternName() {
        if (null != this.antennaRecordID) {
            if (null != this.antennaID && this.antennaID.length() > 0) {
                return "ID " + this.antennaID;
            }
            return "unknown";
        }
        return "Omnidirectional";
    }

    @Override
    public String getHorizontalPatternOrientation() {
        if (null != this.antennaRecordID) {
            return AppCore.formatAzimuth(this.horizontalPatternOrientation) + " deg";
        }
        return "";
    }
}

