/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.core.data.ChannelBand;
import gov.fcc.tvstudy.core.data.ChannelDelta;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.FrequencyOffset;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.SignalType;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.data.Zone;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.core.editdata.TemplateEditData;
import gov.fcc.tvstudy.core.geo.Geography;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public class DbCore {
    public static final int DATABASE_VERSION = 20300012;
    public static final String DEFAULT_DB_NAME = "tvstudy";
    public static final int MAX_QUERY_LENGTH = 500000;
    public static final String DEFAULT_HOST_KEY = "host";
    public static final String DEFAULT_NAME_KEY = "name";
    public static final String DEFAULT_USER_KEY = "user";
    public static final String DB_ID_KEY_PREFIX = "db_uuid_";
    public static String mysqlSocketFile;
    public static final int NAME_MAX_LENGTH = 245;
    public static final char NAME_UNIQUE_CHAR = '#';
    public static final char[] NAME_RESERVED_CHARS;
    public static final char NAME_REPLACE_BAD_CHAR = '_';
    private static HashMap<String, DbInfo> dbs;
    private static HashMap<String, ArrayDeque<DbConnection>> dbPools;
    private static HashMap<DbConnection, String> openDbs;
    private static HashMap<Object, String> dbInUse;
    private static HashMap<String, HashMap<String, String>> propertyMaps;
    private static HashMap<String, HashMap<String, String>> changedPropertyMaps;
    private static HashMap<String, Long> lastPropertySyncTimes;
    private static final int PROPERTY_SYNC_INTERVAL = 600000;
    private static boolean didCacheLoad;
    private static boolean didCheckSocketFile;
    private static final String[] POP_FILE_BASE_NAME;
    private static final int[] POP_COUNTRY_KEY;
    private static final int[] POP_CENSUS;
    private static final String[] POP_COUNTRY_NAME;
    private static boolean[] POP_HAS_ZCTA;
    private static final int POP_TYPE_NUM = 1;
    private static final int POP_TYPE_BOOL = 2;
    private static final int POP_TYPE_CHAR = 3;
    private static final String POP_SEGMENT_TABLE_BASE = "pop";
    private static final int[] POP_SEGMENT_FIELDS;
    private static final String POP_INDEX_TABLE = "pop_table_index";
    private static final int POP_SEGMENT_MIN_ROWS = 75000;
    private static final int POP_SEGMENT_MAX_ROWS = 750000;
    private static final int POP_SEGMENT_MAX_RANGE = 18000;
    private static final String POP_TABLE = "population";
    private static final String POP_NAMES_TABLE = "population_names";
    private static final int[] POP_NAMES_FIELDS;
    private static final String POP_ZCTA_TABLE = "population_zcta";
    private static final int[] POP_ZCTA_FIELDS;

    public static boolean registerDb(DbInfo dbInfo, ErrorLogger errorLogger) {
        return DbCore.registerDb(dbInfo, null, errorLogger);
    }

    public static synchronized boolean registerDb(DbInfo dbInfo, StatusLogger statusLogger, ErrorLogger errorLogger) {
        DbConnection dbConnection;
        block30: {
            Object[] objectArray;
            Object object;
            if (null == dbInfo.db || !dbInfo.canOpen) {
                if (null != errorLogger) {
                    errorLogger.reportError(dbInfo.setupError);
                }
                return false;
            }
            if (dbs.containsKey(dbInfo.dbID)) {
                return true;
            }
            dbConnection = dbInfo.db;
            if (!didCacheLoad) {
                if (null != statusLogger) {
                    statusLogger.reportStatus("Caching root database tables, please wait...");
                }
                if (!dbConnection.connect(dbInfo.dbName, errorLogger)) {
                    return false;
                }
                try {
                    ChannelBand.loadCache(dbConnection);
                    ChannelDelta.loadCache(dbConnection);
                    Country.loadCache(dbConnection);
                    EmissionMask.loadCache(dbConnection);
                    FrequencyOffset.loadCache(dbConnection);
                    Service.loadCache(dbConnection);
                    SignalType.loadCache(dbConnection);
                    Zone.loadCache(dbConnection);
                    ExtDbRecord.loadCache(dbConnection);
                }
                catch (SQLException sQLException) {
                    dbConnection.close(false);
                    DbConnection.reportError(errorLogger, sQLException);
                    return false;
                }
                didCacheLoad = true;
                dbConnection.close();
            }
            ArrayDeque<DbConnection> arrayDeque = new ArrayDeque<DbConnection>();
            arrayDeque.push(dbConnection);
            dbPools.put(dbInfo.dbID, arrayDeque);
            propertyMaps.put(dbInfo.dbID, new HashMap());
            changedPropertyMaps.put(dbInfo.dbID, new HashMap());
            lastPropertySyncTimes.put(dbInfo.dbID, 0L);
            dbs.put(dbInfo.dbID, dbInfo);
            if (dbInfo.dbIsLocal && !didCheckSocketFile) {
                object = AppCore.getPreference("mysqlSocketFile");
                if (null != object) {
                    objectArray = ((String)object).split(":");
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        String string = objectArray[i];
                        if (!Files.exists(Paths.get(string, new String[0]), LinkOption.NOFOLLOW_LINKS)) continue;
                        mysqlSocketFile = string;
                        break;
                    }
                }
                didCheckSocketFile = true;
            }
            if (null == (dbConnection = DbCore.connectDb(dbInfo.dbID, errorLogger))) {
                return true;
            }
            try {
                if (null != statusLogger) {
                    statusLogger.reportStatus("Importing templates and geographies, please wait...");
                }
                object = new HashMap();
                dbConnection.query("SELECT file_name, mod_time, length FROM xml_import");
                while (dbConnection.next()) {
                    objectArray = new long[2];
                    ((HashMap)object).put(dbConnection.getString(1), objectArray);
                    objectArray[0] = (String)dbConnection.getLong(2);
                    objectArray[1] = (String)dbConnection.getLong(3);
                }
                File[] fileArray = AppCore.xmlDirectoryPath.toFile().listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.toLowerCase().endsWith(".xml");
                    }
                });
                if (null == fileArray || fileArray.length <= 0) break block30;
                for (File file : fileArray) {
                    String string = file.getName();
                    long l = file.lastModified() / 1000L;
                    long l2 = file.length();
                    if (0L == l || 0L == l2 || null != (objectArray = (Object[])((long[])((HashMap)object).get(string))) && l == objectArray[0] && l2 == objectArray[1]) continue;
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        Integer n = TemplateEditData.readTemplateFromXML(dbInfo.dbID, (Reader)bufferedReader, true, true);
                        if (null == n) {
                            bufferedReader.reset();
                            Geography geography = Geography.readGeographyFromXML(dbInfo.dbID, bufferedReader);
                            if (null != geography) {
                                geography.save();
                            }
                        }
                        bufferedReader.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (null != objectArray) {
                        dbConnection.update("UPDATE xml_import SET mod_time = " + l + ", length = " + l2 + " WHERE file_name = '" + DbConnection.clean(string) + "'");
                        continue;
                    }
                    dbConnection.update("INSERT INTO xml_import VALUES ('" + DbConnection.clean(string) + "', " + l + ", " + l2 + ")");
                }
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        try {
            dbConnection.query("SELECT COUNT(*) FROM ext_db WHERE db_type=" + String.valueOf(3));
            if (dbConnection.next() && dbConnection.getInt(1) > 0) {
                if (null != statusLogger) {
                    statusLogger.reportStatus("Updating legacy wireless data sets, please wait...");
                }
                ExtDb.convertWirelessExtDbs(dbInfo.dbID, dbConnection, errorLogger);
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(errorLogger, sQLException);
        }
        try {
            dbConnection.query("SELECT COUNT(*) FROM ext_db WHERE db_type=" + String.valueOf(2) + " AND index_version <> " + String.valueOf(3));
            if (dbConnection.next() && dbConnection.getInt(1) > 0) {
                if (null != statusLogger) {
                    statusLogger.reportStatus("Updating data set search index, please wait...");
                }
                ExtDb.updateAllSearchIndex(dbInfo.dbID, dbConnection, errorLogger);
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(errorLogger, sQLException);
        }
        DbCore.releaseDb(dbConnection);
        return true;
    }

    public static synchronized boolean isDbRegistered(String string) {
        return dbs.containsKey(string);
    }

    public static boolean openDb(String string, Object object) {
        if (!dbs.containsKey(string) || null == object) {
            return false;
        }
        dbInUse.put(object, string);
        return true;
    }

    public static DbConnection connectDb(String string) {
        return DbCore.connectDb(string, null);
    }

    public static synchronized DbConnection connectDb(String string, ErrorLogger errorLogger) {
        DbInfo dbInfo = dbs.get(string);
        if (null == dbInfo) {
            if (null != errorLogger) {
                errorLogger.reportError("Database connection failed, unknown database ID");
            }
            return null;
        }
        DbConnection dbConnection = dbPools.get(string).poll();
        if (null == dbConnection) {
            dbConnection = DbCore.dbs.get((Object)string).db.copy();
        }
        openDbs.put(dbConnection, string);
        if (!dbConnection.connect(errorLogger)) {
            DbCore.releaseDb(dbConnection);
            return null;
        }
        try {
            dbConnection.setDatabase(dbInfo.dbName);
        }
        catch (SQLException sQLException) {
            DbCore.releaseDb(dbConnection);
            DbConnection.reportError(errorLogger, sQLException);
            return null;
        }
        return dbConnection;
    }

    public static synchronized void releaseDb(DbConnection dbConnection) {
        dbConnection.close();
        String string = openDbs.remove(dbConnection);
        if (null != string) {
            dbPools.get(string).push(dbConnection);
        }
    }

    public static synchronized String getDbHostname(String string) {
        DbInfo dbInfo = dbs.get(string);
        if (null == dbInfo) {
            return "";
        }
        return dbInfo.dbHostname;
    }

    public static synchronized boolean getDbIsLocal(String string) {
        DbInfo dbInfo = dbs.get(string);
        if (null == dbInfo) {
            return false;
        }
        return dbInfo.dbIsLocal;
    }

    public static synchronized String getDbName(String string) {
        DbInfo dbInfo = dbs.get(string);
        if (null == dbInfo) {
            return "";
        }
        return dbInfo.dbName;
    }

    public static synchronized String getDbVersion(String string) {
        DbInfo dbInfo = dbs.get(string);
        if (null == dbInfo) {
            return "";
        }
        return AppCore.formatVersion(dbInfo.version);
    }

    public static synchronized String getDbUsername(String string) {
        DbInfo dbInfo = dbs.get(string);
        if (null == dbInfo) {
            return "";
        }
        return dbInfo.dbUsername;
    }

    public static synchronized String getDbPassword(String string) {
        DbInfo dbInfo = dbs.get(string);
        if (null == dbInfo) {
            return "";
        }
        return dbInfo.dbPassword;
    }

    public static synchronized String getHostDbName(String string) {
        DbInfo dbInfo = dbs.get(string);
        if (null == dbInfo) {
            return "unknown";
        }
        if (dbInfo.dbName.equals(DEFAULT_DB_NAME)) {
            if (dbInfo.dbIsLocal) {
                return null;
            }
            return dbInfo.dbHostname;
        }
        return dbInfo.dbHostname + "-" + dbInfo.dbName;
    }

    public static synchronized void closeDb(String string, Object object) {
        if (!dbs.containsKey(string)) {
            return;
        }
        DbCore.syncProperties(string, false);
        if (null != object) {
            dbInUse.remove(object);
        }
        if (dbInUse.containsValue(string)) {
            return;
        }
        ExtDb.closeDb(string);
        ExtDbRecordTV.closeDb(string);
        dbs.remove(string);
        propertyMaps.remove(string);
        changedPropertyMaps.remove(string);
        lastPropertySyncTimes.remove(string);
        Iterator<Map.Entry<DbConnection, String>> iterator = openDbs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<DbConnection, String> entry = iterator.next();
            if (!entry.getValue().equals(string)) continue;
            entry.getKey().close(false);
            iterator.remove();
        }
        ArrayDeque<DbConnection> arrayDeque = dbPools.remove(string);
        for (DbConnection dbConnection : arrayDeque) {
            dbConnection.close(false);
        }
    }

    public static synchronized String getProperty(String string, String string2) {
        if (null == string || 0 == string.length()) {
            return AppCore.getProperty(string2);
        }
        HashMap<String, String> hashMap = propertyMaps.get(string);
        if (null == hashMap) {
            return null;
        }
        if (System.currentTimeMillis() - lastPropertySyncTimes.get(string) > 600000L) {
            DbCore.syncProperties(string, true);
            hashMap = propertyMaps.get(string);
        }
        return hashMap.get(string2);
    }

    public static synchronized void setProperty(String string, String string2, String string3) {
        if (null == string3) {
            return;
        }
        if (null == string || 0 == string.length()) {
            AppCore.setProperty(string2, string3);
            return;
        }
        HashMap<String, String> hashMap = propertyMaps.get(string);
        if (null == hashMap) {
            return;
        }
        String string4 = hashMap.put(string2, string3);
        if (null == string4 || !string3.equals(string4)) {
            changedPropertyMaps.get(string).put(string2, string3);
        }
        if (System.currentTimeMillis() - lastPropertySyncTimes.get(string) > 600000L) {
            DbCore.syncProperties(string, true);
        }
    }

    public static Boolean getBooleanProperty(String string, String string2) {
        String string3 = DbCore.getProperty(string, string2);
        Boolean bl = null;
        if (null != string3) {
            bl = Boolean.valueOf(string3);
        }
        return bl;
    }

    public static void setBooleanProperty(String string, String string2, Boolean bl) {
        DbCore.setProperty(string, string2, bl.toString());
    }

    public static Integer getIntegerProperty(String string, String string2) {
        String string3 = DbCore.getProperty(string, string2);
        Integer n = null;
        if (null != string3) {
            try {
                n = Integer.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static void setIntegerProperty(String string, String string2, Integer n) {
        DbCore.setProperty(string, string2, n.toString());
    }

    public static synchronized int deleteProperty(String string, String string2) {
        DbCore.syncProperties(string, false);
        DbConnection dbConnection = DbCore.connectDb(string);
        int n = 0;
        if (null != dbConnection) {
            try {
                n = dbConnection.update("DELETE FROM application_property WHERE name LIKE '" + DbConnection.clean(string2) + "'");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
        }
        return n;
    }

    private static synchronized void syncProperties(String string, boolean bl) {
        DbConnection dbConnection;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Long l = System.currentTimeMillis();
        HashMap<String, String> hashMap2 = changedPropertyMaps.get(string);
        if ((!hashMap2.isEmpty() || bl) && null != (dbConnection = DbCore.connectDb(string))) {
            try {
                dbConnection.update("LOCK TABLES application_property WRITE");
                if (!hashMap2.isEmpty()) {
                    Iterator<Map.Entry<String, String>> iterator = hashMap2.entrySet().iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        Map.Entry<String, String> entry = iterator.next();
                        String string2 = "'" + DbConnection.clean(entry.getKey()) + "'";
                        String string3 = "'" + DbConnection.clean(entry.getValue()) + "'";
                        n = dbConnection.update("UPDATE application_property SET value = " + string3 + " WHERE name = " + string2);
                        if (0 != n) continue;
                        dbConnection.update("INSERT INTO application_property (name, value) VALUES (" + string2 + ", " + string3 + ")");
                    }
                    hashMap2.clear();
                }
                if (bl) {
                    dbConnection.query("SELECT name, value FROM application_property");
                    while (dbConnection.next()) {
                        hashMap.put(dbConnection.getString(1), dbConnection.getString(2));
                    }
                }
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
                hashMap = null;
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
        }
        if (null != hashMap) {
            propertyMaps.put(string, hashMap);
            if (!bl) {
                l = 0L;
            }
        }
        lastPropertySyncTimes.put(string, l);
    }

    public static boolean checkStudyName(String string, String string2, boolean bl) {
        return DbCore.checkName(true, string, string2, null, null, bl, 0, null);
    }

    public static boolean checkStudyName(String string, String string2, boolean bl, ErrorLogger errorLogger) {
        return DbCore.checkName(true, string, string2, null, null, bl, 0, errorLogger);
    }

    public static boolean checkStudyName(String string, String string2, boolean bl, int n) {
        return DbCore.checkName(true, string, string2, null, null, bl, n, null);
    }

    public static boolean checkStudyName(String string, String string2, boolean bl, int n, ErrorLogger errorLogger) {
        return DbCore.checkName(true, string, string2, null, null, bl, n, errorLogger);
    }

    public static boolean checkStudyName(String string, StudyEditData studyEditData, boolean bl) {
        return DbCore.checkName(true, string, studyEditData.dbID, studyEditData, null, bl, 0, null);
    }

    public static boolean checkStudyName(String string, StudyEditData studyEditData, boolean bl, ErrorLogger errorLogger) {
        return DbCore.checkName(true, string, studyEditData.dbID, studyEditData, null, bl, 0, errorLogger);
    }

    public static boolean checkScenarioName(String string, StudyEditData studyEditData, boolean bl) {
        return DbCore.checkName(false, string, studyEditData.dbID, studyEditData, null, bl, 0, null);
    }

    public static boolean checkScenarioName(String string, StudyEditData studyEditData, boolean bl, ErrorLogger errorLogger) {
        return DbCore.checkName(false, string, studyEditData.dbID, studyEditData, null, bl, 0, errorLogger);
    }

    public static boolean checkScenarioName(String string, ScenarioEditData scenarioEditData, boolean bl) {
        return DbCore.checkName(false, string, scenarioEditData.study.dbID, scenarioEditData.study, scenarioEditData, bl, 0, null);
    }

    public static boolean checkScenarioName(String string, ScenarioEditData scenarioEditData, boolean bl, ErrorLogger errorLogger) {
        return DbCore.checkName(false, string, scenarioEditData.study.dbID, scenarioEditData.study, scenarioEditData, bl, 0, errorLogger);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean checkName(boolean bl, String string, String string2, StudyEditData studyEditData, ScenarioEditData scenarioEditData, boolean bl2, int n, ErrorLogger errorLogger) {
        int n2;
        String string3 = bl ? "study" : "scenario";
        int n3 = 0;
        if (null != string) {
            n3 = string.length();
        }
        if (0 == n3) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Please enter a name for the " + string3);
            }
            return false;
        }
        if (bl ? null != studyEditData && studyEditData.name.equalsIgnoreCase(string) : null != scenarioEditData && scenarioEditData.name.equalsIgnoreCase(string)) {
            return true;
        }
        boolean bl3 = true;
        boolean bl4 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            char c = string.charAt(n2);
            for (char c2 : NAME_RESERVED_CHARS) {
                if (c2 != c) continue;
                bl4 = true;
                break;
            }
            if (bl4) break;
            if (!bl3 || Character.isDigit(c)) continue;
            bl3 = false;
        }
        if (bl4) {
            if (null != errorLogger) {
                void var17_27;
                StringBuilder stringBuilder = new StringBuilder("A " + string3 + " name cannot contain the characters");
                String bl5 = " ";
                char[] cArray = NAME_RESERVED_CHARS;
                int n4 = cArray.length;
                boolean bl6 = false;
                while (var17_27 < n4) {
                    void var14_17;
                    char c = cArray[var17_27];
                    stringBuilder.append((String)var14_17 + "'" + c + "'");
                    String string4 = ", ";
                    ++var17_27;
                }
                stringBuilder.append('.');
                errorLogger.reportValidationError(stringBuilder.toString());
            }
            return false;
        }
        if (bl3) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A " + string3 + " name must contain at least one non-digit character");
            }
            return false;
        }
        n2 = 245 - n;
        if (n3 > n2) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A " + string3 + " name cannot be more than " + n2 + " characters");
            }
            return false;
        }
        if (bl2) {
            void var14_21;
            if (bl) {
                int n5 = Study.getStudyKeyForName(string2, string, errorLogger);
                if (n5 < 0) {
                    return false;
                }
                boolean bl7 = n5 > 0 && (null == studyEditData || n5 != studyEditData.study.key);
            } else {
                boolean bl8;
                boolean bl9 = bl8 = null != studyEditData.scenarioData.get(string);
            }
            if (var14_21 != false) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("A " + string3 + " with that name already exists");
                }
                return false;
            }
        }
        return true;
    }

    private static boolean canUpdateDb(int n) {
        switch (n) {
            case 201000: 
            case 201001: 
            case 201002: 
            case 201003: 
            case 202000: 
            case 202001: 
            case 202002: 
            case 202003: 
            case 20200301: 
            case 20200302: 
            case 20200400: 
            case 20200401: 
            case 20200500: 
            case 20200501: 
            case 20200502: 
            case 20200600: 
            case 20200601: 
            case 20200602: 
            case 20200603: 
            case 20300000: 
            case 20300001: 
            case 20300002: 
            case 20300003: 
            case 20300004: 
            case 20300005: 
            case 20300006: 
            case 20300007: 
            case 20300008: 
            case 20300009: 
            case 20300010: 
            case 20300011: {
                return true;
            }
        }
        return false;
    }

    public static boolean installDb(DbInfo dbInfo, StatusLogger statusLogger, ErrorLogger errorLogger) {
        if (!dbInfo.canInstall) {
            return false;
        }
        if (!DbCore.checkDataFiles(errorLogger)) {
            return false;
        }
        DbConnection dbConnection = dbInfo.db;
        boolean bl = true;
        if (dbConnection.connect(errorLogger)) {
            try {
                DbCore.doInstallDb(dbInfo, statusLogger);
            }
            catch (SQLException sQLException) {
                bl = false;
                if (null != errorLogger) {
                    errorLogger.reportError("An error occurred while installing the root database.\nUninstall and try the installation again.  The error was:\n" + sQLException);
                }
                DbConnection.reportError(sQLException);
            }
            dbInfo.update();
            dbConnection.close(false);
        }
        return bl;
    }

    public static boolean updateDb(DbInfo dbInfo, StatusLogger statusLogger, ErrorLogger errorLogger) {
        if (!dbInfo.canUpdate) {
            return false;
        }
        if (!DbCore.checkDataFiles(errorLogger)) {
            return false;
        }
        DbConnection dbConnection = dbInfo.db;
        String string = null;
        if (dbConnection.connect(dbInfo.dbName, errorLogger)) {
            try {
                if (dbInfo.hasVersionTable) {
                    dbConnection.update("LOCK TABLES study WRITE, version WRITE");
                    dbConnection.query("SELECT version FROM version");
                } else {
                    dbConnection.update("LOCK TABLES study WRITE");
                    dbConnection.query("SELECT MAX(version) FROM study");
                }
                dbConnection.next();
                int n = dbConnection.getInt(1);
                if (0 != n) {
                    if (DbCore.canUpdateDb(n)) {
                        dbConnection.query("SELECT COUNT(*) FROM study WHERE study_lock <> 0");
                        dbConnection.next();
                        if (0 == dbConnection.getInt(1)) {
                            if (dbInfo.hasVersionTable) {
                                dbConnection.update("UPDATE version SET version = 0");
                            } else {
                                dbConnection.update("UPDATE study SET version = 0");
                            }
                            dbConnection.update("UNLOCK TABLES");
                            DbCore.doUpdateDb(dbInfo, n, statusLogger);
                        } else {
                            string = "The database cannot be updated, studies are currently in use";
                        }
                    } else {
                        string = 20300012 == n ? "The database has already been updated" : "The database version cannot be updated";
                    }
                } else {
                    string = "Another application is already updating the database";
                }
            }
            catch (SQLException sQLException) {
                string = "An error occurred while updating the database, it may have to be\nrepaired manually or uninstalled and re-installed.  The error was:\n" + sQLException;
                DbConnection.reportError(sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            dbInfo.update();
            dbConnection.close(false);
        }
        if (null != string) {
            if (null != errorLogger) {
                errorLogger.reportError(string);
            }
            return false;
        }
        return true;
    }

    public static boolean checkDataFiles(ErrorLogger errorLogger) {
        String[] stringArray = new String[]{"pop_us_2000.dat", "pop_us_2000_names.dat", "pop_us_2000_zcta.dat", "pop_us_2010.dat", "pop_us_2010_names.dat", "pop_us_2010_zcta.dat", "pop_us_2020.dat", "pop_us_2020_names.dat", "pop_us_2020_zcta.dat", "pop_ca_2006.dat", "pop_ca_2006_names.dat", "pop_ca_2011.dat", "pop_ca_2011_names.dat", "pop_ca_2016.dat", "pop_ca_2016_names.dat", "pop_ca_2021.dat", "pop_ca_2021_names.dat", "pop_mx_2010.dat", "pop_mx_2010_names.dat", "pop_mx_2020.dat", "pop_mx_2020_names.dat"};
        int[] nArray = new int[]{20300012, 203000, 20300009, 20300012, 203000, 20300009, 20300012, 20300008, 20300009, 20300012, 203000, 20300012, 203000, 20300012, 203000, 20300012, 20300008, 20300012, 203000, 20300012, 20300009};
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                BufferedReader bufferedReader = Files.newBufferedReader(AppCore.dataDirectoryPath.resolve(stringArray[i]), StandardCharsets.ISO_8859_1);
                int n = AppCore.getFileVersion(bufferedReader);
                bufferedReader.close();
                if (n == nArray[i]) continue;
                bl = false;
                if (null == errorLogger) break;
                errorLogger.reportError("File check failed, 'data/" + stringArray[i] + "' is the wrong version");
            }
            catch (IOException iOException) {
                bl = false;
                if (null == errorLogger) break;
                errorLogger.reportError("File check failed, 'data/" + stringArray[i] + "' could not be read");
            }
            break;
        }
        return bl;
    }

    public static boolean updateRootData(DbInfo dbInfo, ErrorLogger errorLogger) {
        if (!dbInfo.canOpen) {
            return false;
        }
        DbConnection dbConnection = dbInfo.db;
        String string = null;
        if (dbConnection.connect(dbInfo.dbName, errorLogger)) {
            try {
                dbConnection.update("LOCK TABLES study WRITE, version WRITE");
                dbConnection.query("SELECT version FROM version");
                dbConnection.next();
                int n = dbConnection.getInt(1);
                if (0 != n) {
                    dbConnection.query("SELECT COUNT(*) FROM study WHERE study_lock <> 0");
                    dbConnection.next();
                    if (0 == dbConnection.getInt(1)) {
                        dbConnection.update("UPDATE version SET version = 0");
                        dbConnection.update("UNLOCK TABLES");
                        DbCore.doUpdateRootData(dbConnection);
                        dbConnection.update("UPDATE version SET version = " + n);
                    } else {
                        string = "The data cannot be reloaded, studies are currently in use";
                    }
                } else {
                    string = "Another application is currently updating the database";
                }
            }
            catch (SQLException sQLException) {
                string = "An error occurred while reloading the data, the database may have to\nbe repaired manually or uninstalled and re-installed.  The error was:\n" + sQLException;
                DbConnection.reportError(sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            dbInfo.update();
            dbConnection.close(false);
        }
        if (null != string) {
            if (null != errorLogger) {
                errorLogger.reportError(string);
            }
            return false;
        }
        return true;
    }

    public static boolean uninstallDb(DbInfo dbInfo, ErrorLogger errorLogger) {
        if (!dbInfo.canUninstall) {
            return false;
        }
        DbConnection dbConnection = dbInfo.db;
        boolean bl = true;
        if (dbConnection.connect(errorLogger)) {
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                dbConnection.query("SHOW DATABASES LIKE '" + dbInfo.dbName + "\\_%'");
                while (dbConnection.next()) {
                    arrayList.add(dbConnection.getString(1));
                }
                for (String string : arrayList) {
                    dbConnection.update("DROP DATABASE " + string);
                }
                dbConnection.update("DROP DATABASE IF EXISTS " + dbInfo.dbName);
            }
            catch (SQLException sQLException) {
                bl = false;
                if (null != errorLogger) {
                    errorLogger.reportError("An operation cannot be completed due to a database error:\n" + sQLException);
                }
                DbConnection.reportError(sQLException);
            }
            dbInfo.update();
            dbConnection.close(false);
        }
        AppCore.deleteStudyCache(dbInfo.dbID, 0);
        return bl;
    }

    private static void doInstallDb(DbInfo dbInfo, StatusLogger statusLogger) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.update("CREATE DATABASE " + dbInfo.dbName + " CHARACTER SET latin1");
        dbConnection.setDatabase(dbInfo.dbName);
        dbInfo.dbID = UUID.randomUUID().toString();
        dbConnection.update("CREATE TABLE version (version INT NOT NULL,uuid VARCHAR(255) NOT NULL)");
        dbConnection.update("INSERT INTO version VALUES (0, '" + DbConnection.clean(dbInfo.dbID) + "')");
        if (dbInfo.dbName.equals(DEFAULT_DB_NAME)) {
            AppCore.setProperty(DB_ID_KEY_PREFIX + dbInfo.dbHostname, dbInfo.dbID);
        } else {
            AppCore.setProperty(DB_ID_KEY_PREFIX + dbInfo.dbHostname + "_" + dbInfo.dbName, dbInfo.dbID);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        dbConnection.query("SHOW DATABASES LIKE '" + dbInfo.dbName + "\\_%'");
        while (dbConnection.next()) {
            arrayList.add(dbConnection.getString(1));
        }
        for (String string : arrayList) {
            dbConnection.update("DROP DATABASE " + string);
        }
        dbConnection.update("CREATE TABLE study (study_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,description VARCHAR(10000) NOT NULL,folder_key INT NOT NULL DEFAULT 0,study_lock INT NOT NULL,lock_count INT NOT NULL,share_count INT NOT NULL,study_type INT NOT NULL,study_mode INT NOT NULL,needs_update BOOLEAN NOT NULL,has_result_tables BOOLEAN NOT NULL DEFAULT false,had_result_tables BOOLEAN NOT NULL DEFAULT false,mod_count INT NOT NULL,template_key INT NOT NULL,template_locked BOOLEAN NOT NULL,ext_db_key INT NOT NULL,point_set_key INT NOT NULL,propagation_model INT NOT NULL,study_area_mode INT NOT NULL,study_area_geo_key INT NOT NULL,output_config_file_name VARCHAR(255) NOT NULL,output_config_file_codes VARCHAR(255) NOT NULL,output_config_map_name VARCHAR(255) NOT NULL,output_config_map_codes VARCHAR(255) NOT NULL,out_directory VARCHAR(10000) NOT NULL,report_preamble MEDIUMTEXT NOT NULL,parameter_summary MEDIUMTEXT NOT NULL,ix_rule_summary MEDIUMTEXT NOT NULL,created DATETIME,modified DATETIME,last_run DATETIME)");
        dbConnection.update("CREATE TABLE study_key_sequence (study_key INT NOT NULL)");
        dbConnection.update("INSERT INTO study_key_sequence VALUES (0)");
        dbConnection.update("CREATE TABLE folder (folder_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,parent_folder_key INT NOT NULL DEFAULT 0)");
        dbConnection.update("CREATE TABLE ext_db (ext_db_key INT NOT NULL PRIMARY KEY,db_type INT NOT NULL,db_date DATETIME NOT NULL,version INT NOT NULL,index_version INT NOT NULL,id VARCHAR(255) NOT NULL,name VARCHAR(255) NOT NULL,deleted BOOLEAN NOT NULL,locked BOOLEAN NOT NULL,is_download BOOLEAN NOT NULL,bad_data BOOLEAN NOT NULL)");
        dbConnection.update("CREATE TABLE ext_db_key_sequence (ext_db_key INT NOT NULL)");
        dbConnection.update("INSERT INTO ext_db_key_sequence VALUES (0)");
        dbConnection.update("CREATE TABLE country (country_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,country_code CHAR(2) NOT NULL)");
        dbConnection.update("CREATE TABLE service_type (service_type_key INT NOT NULL PRIMARY KEY,record_type INT NOT NULL,name VARCHAR(255) NOT NULL,digital BOOLEAN NOT NULL,needs_emission_mask BOOLEAN NOT NULL)");
        dbConnection.update("CREATE TABLE signal_type (signal_type_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,is_default BOOLEAN NOT NULL)");
        dbConnection.update("CREATE TABLE service (service_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,service_code CHAR(2) NOT NULL,service_type_key INT NOT NULL,is_dts BOOLEAN NOT NULL,is_operating BOOLEAN NOT NULL,preference_rank INT NOT NULL,digital_service_key INT NOT NULL,display_order INT NOT NULL)");
        dbConnection.update("CREATE TABLE cdbs_service (cdbs_service_code CHAR(2) NOT NULL,service_key INT NOT NULL)");
        dbConnection.update("CREATE TABLE lms_service (lms_service_code CHAR(6) NOT NULL,service_key INT NOT NULL)");
        dbConnection.update("CREATE TABLE channel_band (channel_band_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,first_channel INT NOT NULL,last_channel INT NOT NULL)");
        dbConnection.update("CREATE TABLE channel_delta (channel_delta_key INT NOT NULL PRIMARY KEY,record_type INT NOT NULL,name VARCHAR(255) NOT NULL,delta INT NOT NULL,analog_only BOOLEAN NOT NULL)");
        dbConnection.update("CREATE TABLE emission_mask (emission_mask_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,emission_mask_code CHAR(1) NOT NULL,is_default BOOLEAN NOT NULL)");
        dbConnection.update("CREATE TABLE frequency_offset (frequency_offset_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,offset_code CHAR(1) NOT NULL)");
        dbConnection.update("CREATE TABLE zone (zone_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,zone_code CHAR(1) NOT NULL)");
        dbConnection.update("CREATE TABLE template (template_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,permanent BOOLEAN NOT NULL,locked BOOLEAN NOT NULL,locked_in_study BOOLEAN NOT NULL,hidden DATETIME)");
        dbConnection.update("INSERT INTO template VALUES (1, \"Default\", true, true, false, null)");
        dbConnection.update("CREATE TABLE template_key_sequence (template_key INT NOT NULL)");
        dbConnection.update("INSERT INTO template_key_sequence VALUES (1)");
        dbConnection.update("CREATE TABLE template_parameter_data (template_key INT NOT NULL,parameter_key INT NOT NULL,value_index INT NOT NULL,value VARCHAR(10000) NOT NULL,PRIMARY KEY (template_key, parameter_key, value_index))");
        dbConnection.update("CREATE TABLE template_ix_rule (template_key INT NOT NULL,ix_rule_key INT NOT NULL,country_key INT NOT NULL,service_type_key INT NOT NULL,signal_type_key INT NOT NULL,undesired_service_type_key INT NOT NULL,undesired_signal_type_key INT NOT NULL,channel_delta_key INT NOT NULL,channel_band_key INT NOT NULL,frequency_offset INT NOT NULL,emission_mask_key INT NOT NULL,distance FLOAT NOT NULL,required_du FLOAT NOT NULL,undesired_time FLOAT NOT NULL,PRIMARY KEY (template_key, ix_rule_key))");
        dbConnection.update("CREATE TABLE parameter_group (group_key INT NOT NULL PRIMARY KEY,list_order INT NOT NULL,name VARCHAR(255) NOT NULL,enabling_parameter_key INT NOT NULL)");
        dbConnection.update("CREATE TABLE parameter (parameter_key INT NOT NULL PRIMARY KEY,group_key INT NOT NULL,list_order INT NOT NULL,name VARCHAR(255) NOT NULL,type VARCHAR(255) NOT NULL,units VARCHAR(255) NOT NULL,value_list VARCHAR(255) NOT NULL,description VARCHAR(10000) NOT NULL,is_scenario_parameter BOOLEAN NOT NULL)");
        dbConnection.update("CREATE TABLE parameter_study_type (parameter_key INT NOT NULL,study_type INT NOT NULL,UNIQUE (parameter_key, study_type))");
        DbCore.doUpdateRootData(dbConnection);
        dbConnection.update("CREATE TABLE geography (geo_key INT NOT NULL PRIMARY KEY,study_key INT NOT NULL,source_key INT NOT NULL,geo_type INT NOT NULL,name VARCHAR(255) NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,radius DOUBLE NOT NULL,width DOUBLE NOT NULL,height DOUBLE NOT NULL,mod_count INT NOT NULL)");
        dbConnection.update("CREATE TABLE geo_key_sequence (geo_key INT NOT NULL)");
        dbConnection.update("INSERT INTO geo_key_sequence VALUES (0)");
        dbConnection.update("CREATE TABLE geo_point_set (geo_key INT NOT NULL,point_name VARCHAR(255) NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,receive_height DOUBLE NOT NULL,antenna_key INT NOT NULL,antenna_orientation DOUBLE NOT NULL)");
        dbConnection.update("CREATE TABLE geo_polygon (geo_key INT NOT NULL,vertex_key INT NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL)");
        dbConnection.update("CREATE TABLE geo_sectors (geo_key INT NOT NULL,azimuth DOUBLE NOT NULL,radius DOUBLE NOT NULL)");
        dbConnection.update("CREATE TABLE study_geography (study_key INT NOT NULL,geo_key INT NOT NULL,UNIQUE (study_key, geo_key))");
        dbConnection.update("CREATE TABLE receive_antenna_index (antenna_key INT NOT NULL,name VARCHAR(255) NOT NULL,gain DOUBLE NOT NULL)");
        dbConnection.update("CREATE TABLE antenna_key_sequence (antenna_key INT NOT NULL)");
        dbConnection.update("INSERT INTO antenna_key_sequence VALUES (0)");
        dbConnection.update("CREATE TABLE receive_pattern (antenna_key INT NOT NULL,frequency DOUBLE NOT NULL,azimuth DOUBLE NOT NULL,relative_field DOUBLE NOT NULL)");
        dbConnection.update("CREATE TABLE geography_receive_antenna (geo_key INT NOT NULL,antenna_key INT NOT NULL,UNIQUE (geo_key, antenna_key))");
        dbConnection.update("CREATE TABLE edit_lock (locked BOOLEAN NOT NULL)");
        dbConnection.update("INSERT INTO edit_lock VALUES (false)");
        dbConnection.update("CREATE TABLE color_map (color_map_key INT PRIMARY KEY,name VARCHAR(255) NOT NULL,permanent BOOLEAN NOT NULL)");
        dbConnection.update("CREATE TABLE color_map_data (color_map_key INT NOT NULL,level DOUBLE NOT NULL,color_r INT NOT NULL,color_g INT NOT NULL,color_b INT NOT NULL)");
        dbConnection.update("INSERT INTO color_map VALUES (1, 'Signal margin', true),(2, 'D/U margin', true),(3, 'Signal margin w/ IX', true)");
        dbConnection.update("INSERT INTO color_map_data VALUES (1, -999, 255, 255, 242),(1, -998, -1, -1, -1),(1, -997, 255, 255, 242),(1, 0, 244, 240, 198),(1, 10, 232, 232, 52),(1, 20, 255, 173, 42),(1, 30, 255, 116, 20),(1, 40, 255, 32, 0),(2, -999, -1, -1, -1),(2, -998, -1, -1, -1),(2, -997, 153, 0, 0),(2, -6, 204, 0, 0),(2, -3, 204, 113, 0),(2, 0, 158, 204, 0),(2, 3, 45, 204, 0),(2, 6, 0, 204, 79),(3, -999, 255, 255, 242),(3, -998, 51, 51, 255),(3, -997, 255, 255, 242),(3, 0, 244, 240, 198),(3, 10, 232, 232, 52),(3, 20, 255, 173, 42),(3, 30, 255, 116, 20),(3, 40, 255, 32, 0)");
        dbConnection.update("CREATE TABLE user_record (user_record_id INT PRIMARY KEY,record_type INT NOT NULL,xml_data MEDIUMTEXT NOT NULL,facility_id INT NOT NULL,service_key INT NOT NULL,call_sign CHAR(12) NOT NULL,status CHAR(6) NOT NULL,channel INT NOT NULL,city CHAR(20) NOT NULL,state CHAR(2) NOT NULL,country CHAR(2) NOT NULL,file_number VARCHAR(255) NOT NULL,comment VARCHAR(10000) NOT NULL)");
        dbConnection.update("CREATE TABLE user_record_id_sequence (user_record_id INT NOT NULL)");
        dbConnection.update("INSERT INTO user_record_id_sequence VALUES (0)");
        dbConnection.update("CREATE TABLE ix_check_status (study_name VARCHAR(255) NOT NULL,study_id VARCHAR(10000) NOT NULL,run_date DATETIME NOT NULL)");
        dbConnection.update("CREATE TABLE ix_check_name_sequence (name_key INT NOT NULL)");
        dbConnection.update("INSERT INTO ix_check_name_sequence VALUES (0)");
        dbConnection.update("CREATE TABLE output_config (type INT NOT NULL,name VARCHAR(255) NOT NULL,codes VARCHAR(255) NOT NULL)");
        dbConnection.update("CREATE TABLE ext_db_search (study_type INT NOT NULL,name VARCHAR(255) NOT NULL,record_type INT NOT NULL,search_type INT NOT NULL DEFAULT 1,disable_mx BOOLEAN NOT NULL,mx_facility_id_only BOOLEAN NOT NULL,prefer_operating BOOLEAN NOT NULL,desired_only BOOLEAN NOT NULL,service_keys VARCHAR(255) NOT NULL,country_keys VARCHAR(255) NOT NULL,status_types VARCHAR(255) NOT NULL,radius DOUBLE NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,minimum_channel INT NOT NULL DEFAULT 0,maximum_channel INT NOT NULL DEFAULT 0,include_sharing_guests BOOLEAN NOT NULL,additional_sql VARCHAR(20000) NOT NULL,auto_run BOOLEAN NOT NULL)");
        dbConnection.update("CREATE TABLE xml_import (file_name VARCHAR(255) NOT NULL, mod_time BIGINT NOT NULL, length BIGINT NOT NULL)");
        DbCore.doLoadPopulation(dbConnection, statusLogger);
        dbConnection.update("CREATE TABLE application_property (name VARCHAR(255) NOT NULL,value VARCHAR(255) NOT NULL)");
        dbConnection.update("UPDATE version SET version = 20300012");
    }

    private static void doLoadPopulation(DbConnection dbConnection, StatusLogger statusLogger) throws SQLException {
        if (null != statusLogger) {
            statusLogger.reportStatus("Loading population data, please wait...");
        }
        BufferedReader bufferedReader = null;
        HashMap hashMap = null;
        AppCore.LineCounter lineCounter = new AppCore.LineCounter();
        lineCounter.setDelimiter('|');
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        StringBuilder stringBuilder = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        dbConnection.update("CREATE TABLE pop_table_index (country_key INT NOT NULL, census INT NOT NULL, table_number INT NOT NULL, min_lon_index INT NOT NULL, max_lon_index INT NOT NULL, row_count INT NOT NULL)");
        try {
            for (int i = 0; i < POP_FILE_BASE_NAME.length; ++i) {
                String[] stringArray;
                string = POP_FILE_BASE_NAME[i] + ".dat";
                bufferedReader = Files.newBufferedReader(AppCore.dataDirectoryPath.resolve(string), StandardCharsets.ISO_8859_1);
                if (null != statusLogger) {
                    string2 = "Loading " + POP_COUNTRY_NAME[i] + " " + String.valueOf(POP_CENSUS[i]) + " census data";
                    statusLogger.reportStatus(string2 + ", please wait...");
                    hashMap = new HashMap();
                }
                lineCounter.reset();
                int n6 = -1;
                int n7 = 0;
                int n8 = 0;
                n = 0;
                n4 = 0;
                while (null != (stringArray = AppCore.readAndParseLine(bufferedReader, lineCounter, hashMap))) {
                    int n9;
                    ++n7;
                    if (POP_SEGMENT_FIELDS.length != stringArray.length) {
                        throw new IOException("Incorrect field count at line " + lineCounter.toString());
                    }
                    if (null != statusLogger) {
                        int n10;
                        if (n6 < 0) {
                            String string5 = (String)hashMap.get("rowCount");
                            if (null != string5) {
                                try {
                                    n6 = Integer.parseInt(string5);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            if (n6 < 0) {
                                n6 = 0;
                            }
                            hashMap = null;
                        }
                        if (n6 > 0 && (n10 = (int)Math.rint((double)n7 / (double)n6 * 100.0)) > n8) {
                            statusLogger.reportStatus(string2 + ", " + String.valueOf(n10) + "% done...");
                            n8 = n10;
                        }
                    }
                    if (0 == n || (n3 - n2 >= 18000 || n4 >= 750000) && n4 >= 75000 && (0 == n6 || n6 - n7 >= 75000)) {
                        if (n4 > 0) {
                            if (stringBuilder.length() > n5) {
                                stringBuilder.append(')');
                                dbConnection.update(stringBuilder.toString());
                            }
                            dbConnection.update("INSERT INTO pop_table_index VALUES (" + String.valueOf(POP_COUNTRY_KEY[i]) + "," + String.valueOf(POP_CENSUS[i]) + "," + String.valueOf(n) + "," + String.valueOf(n2) + "," + String.valueOf(n3) + "," + String.valueOf(n4) + ")");
                        }
                        n4 = 0;
                        string3 = "pop_" + String.valueOf(POP_COUNTRY_KEY[i]) + "_" + String.valueOf(POP_CENSUS[i]) + "_" + String.valueOf(++n);
                        dbConnection.update("CREATE TABLE " + string3 + " (id VARCHAR(255) NOT NULL,state INT NOT NULL,county INT NOT NULL,place INT NOT NULL,duplicate BOOLEAN NOT NULL,lat_index INT NOT NULL,lon_index INT NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,population INT NOT NULL,households INT NOT NULL,INDEX (lat_index),INDEX (lon_index))");
                        stringBuilder = new StringBuilder("INSERT INTO " + string3 + " VALUES");
                        n5 = stringBuilder.length();
                        string4 = " (";
                    }
                    try {
                        n9 = Integer.parseInt(stringArray[6]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Bad number format at line " + lineCounter.toString());
                    }
                    if (0 == n4) {
                        n2 = n9;
                    }
                    n3 = n9;
                    ++n4;
                    stringBuilder.append(string4);
                    block13: for (int j = 0; j < stringArray.length; ++j) {
                        if (j > 0) {
                            stringBuilder.append(',');
                        }
                        switch (POP_SEGMENT_FIELDS[j]) {
                            case 1: {
                                stringBuilder.append(stringArray[j]);
                                continue block13;
                            }
                            case 2: {
                                char c = stringArray[j].charAt(0);
                                if ('0' == c || 'f' == c) {
                                    stringBuilder.append("false");
                                    continue block13;
                                }
                                stringBuilder.append("true");
                                continue block13;
                            }
                            case 3: {
                                stringBuilder.append('\'');
                                stringBuilder.append(DbConnection.clean(stringArray[j]));
                                stringBuilder.append('\'');
                            }
                        }
                    }
                    if (stringBuilder.length() > 500000) {
                        stringBuilder.append(')');
                        dbConnection.update(stringBuilder.toString());
                        stringBuilder.setLength(n5);
                        string4 = " (";
                        continue;
                    }
                    string4 = "),(";
                }
                if (n4 > 0) {
                    if (stringBuilder.length() > n5) {
                        stringBuilder.append(')');
                        dbConnection.update(stringBuilder.toString());
                    }
                    dbConnection.update("INSERT INTO pop_table_index VALUES (" + String.valueOf(POP_COUNTRY_KEY[i]) + "," + String.valueOf(POP_CENSUS[i]) + "," + String.valueOf(n) + "," + String.valueOf(n2) + "," + String.valueOf(n3) + "," + String.valueOf(n4) + ")");
                }
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Data file 'data/" + string + "' could not be loaded:\n" + iOException.toString());
        }
    }

    private static void doReloadPopulation(DbConnection dbConnection, StatusLogger statusLogger) throws SQLException {
        if (null != statusLogger) {
            statusLogger.reportStatus("Loading population data, please wait...");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("pop_us_2000");
        arrayList.add("pop_us_2010");
        arrayList.add("pop_ca_2006");
        arrayList.add("pop_ca_2011");
        arrayList.add("pop_ca_2016");
        arrayList.add("pop_mx_2010");
        arrayList.add(POP_TABLE);
        arrayList.add(POP_NAMES_TABLE);
        arrayList.add(POP_ZCTA_TABLE);
        dbConnection.query("SHOW TABLES LIKE 'pop_table_index'");
        if (dbConnection.next()) {
            dbConnection.query("SELECT country_key, census, table_number FROM pop_table_index");
            while (dbConnection.next()) {
                arrayList.add("pop_" + String.valueOf(dbConnection.getInt(1)) + "_" + String.valueOf(dbConnection.getInt(2)) + "_" + String.valueOf(dbConnection.getInt(3)));
            }
            arrayList.add(POP_INDEX_TABLE);
        }
        for (String string : arrayList) {
            dbConnection.update("DROP TABLE IF EXISTS " + string);
        }
        DbCore.doLoadPopulation(dbConnection, statusLogger);
    }

    public static boolean createPopulationTables(String string, StatusLogger statusLogger, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        boolean bl = false;
        String string2 = "";
        try {
            dbConnection.query("SHOW TABLES LIKE population");
            if (dbConnection.next()) {
                DbCore.releaseDb(dbConnection);
                return true;
            }
            if (null != statusLogger) {
                statusLogger.reportStatus("Building population table, please wait...");
            }
            class SegmentTable {
                int countryKey;
                int census;
                String tableName;

                SegmentTable() {
                }
            }
            ArrayList<SegmentTable> arrayList = new ArrayList<SegmentTable>();
            dbConnection.query("SELECT country_key, census, table_number FROM pop_table_index");
            while (dbConnection.next()) {
                SegmentTable segmentTable = new SegmentTable();
                segmentTable.countryKey = dbConnection.getInt(1);
                segmentTable.census = dbConnection.getInt(2);
                segmentTable.tableName = "pop_" + String.valueOf(segmentTable.countryKey) + "_" + String.valueOf(segmentTable.census) + "_" + String.valueOf(dbConnection.getInt(3));
                arrayList.add(segmentTable);
            }
            dbConnection.update("CREATE TABLE population (country_key TINYINT NOT NULL,census INT NOT NULL,id VARCHAR(255) NOT NULL,state INT NOT NULL,county INT NOT NULL,place INT NOT NULL,lat_index INT NOT NULL,lon_index INT NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,population INT NOT NULL,households INT NOT NULL,INDEX (country_key),INDEX (census),INDEX (id),INDEX (state),INDEX (county),INDEX (place),INDEX (lat_index),INDEX (lon_index))");
            int n = 1;
            for (SegmentTable object2 : arrayList) {
                if (null != statusLogger) {
                    statusLogger.reportStatus("Building population table, segment " + String.valueOf(n++) + " of " + String.valueOf(arrayList.size()) + "...");
                }
                dbConnection.update("INSERT INTO population SELECT " + String.valueOf(object2.countryKey) + " AS country_key, " + String.valueOf(object2.census) + " AS census, id, state, county, place, lat_index, lon_index, latitude, longitude, population, households FROM " + object2.tableName + " WHERE NOT duplicate");
            }
            dbConnection.update("CREATE TABLE population_names (country_key TINYINT NOT NULL,census INT NOT NULL,state INT NOT NULL,county INT NOT NULL,place INT NOT NULL,name VARCHAR(255) NOT NULL,INDEX (country_key),INDEX (census),INDEX (state),INDEX (county),INDEX (place))");
            dbConnection.update("CREATE TABLE population_zcta (country_key TINYINT NOT NULL,census INT NOT NULL,id VARCHAR(255) NOT NULL,zcta INT NOT NULL,INDEX (country_key),INDEX (census),INDEX (id))");
            Object object3 = null;
            String string3 = "";
            BufferedReader bufferedReader = null;
            for (int i = 0; i < POP_FILE_BASE_NAME.length; ++i) {
                String string4 = "Loading " + POP_COUNTRY_NAME[i] + " " + String.valueOf(POP_CENSUS[i]) + " data";
                object3 = String.valueOf(POP_COUNTRY_KEY[i]) + "," + String.valueOf(POP_CENSUS[i]);
                string2 = POP_FILE_BASE_NAME[i] + "_names.dat";
                bufferedReader = Files.newBufferedReader(AppCore.dataDirectoryPath.resolve(string2), StandardCharsets.ISO_8859_1);
                DbCore.insertPopData(dbConnection, POP_NAMES_TABLE, (String)object3, bufferedReader, POP_NAMES_FIELDS, statusLogger, string4);
                bufferedReader.close();
                if (!POP_HAS_ZCTA[i]) continue;
                string2 = POP_FILE_BASE_NAME[i] + "_zcta.dat";
                bufferedReader = Files.newBufferedReader(AppCore.dataDirectoryPath.resolve(string2), StandardCharsets.ISO_8859_1);
                DbCore.insertPopData(dbConnection, POP_ZCTA_TABLE, (String)object3, bufferedReader, POP_ZCTA_FIELDS, statusLogger, string4);
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            if (null != errorLogger) {
                errorLogger.reportError("Data file 'data/" + string2 + "' could not be loaded:\n" + iOException.toString());
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(errorLogger, sQLException);
            bl = true;
        }
        if (bl) {
            try {
                dbConnection.update("DROP TABLE IF EXISTS population");
                dbConnection.update("DROP TABLE IF EXISTS population_names");
                dbConnection.update("DROP TABLE IF EXISTS population_zcta");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
        }
        DbCore.releaseDb(dbConnection);
        return !bl;
    }

    private static void insertPopData(DbConnection dbConnection, String string, String string2, BufferedReader bufferedReader, int[] nArray, StatusLogger statusLogger, String string3) throws IOException, SQLException {
        String[] stringArray;
        HashMap<String, String> hashMap = null;
        if (null != statusLogger) {
            statusLogger.reportStatus(string3 + ", please wait...");
            hashMap = new HashMap<String, String>();
        }
        AppCore.LineCounter lineCounter = new AppCore.LineCounter();
        lineCounter.setDelimiter('|');
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO " + string + " VALUES");
        int n = stringBuilder.length();
        String string4 = " (";
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        while (null != (stringArray = AppCore.readAndParseLine(bufferedReader, lineCounter, hashMap))) {
            ++n3;
            if (nArray.length != stringArray.length) {
                throw new IOException("Incorrect field count at line " + lineCounter.toString());
            }
            if (null != statusLogger) {
                int n5;
                if (n2 < 0) {
                    String string5 = hashMap.get("rowCount");
                    if (null != string5) {
                        try {
                            n2 = Integer.parseInt(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    hashMap = null;
                }
                if (n2 > 0 && (n5 = (int)Math.rint((double)n3 / (double)n2 * 100.0)) > n4) {
                    statusLogger.reportStatus(string3 + ", " + String.valueOf(n5) + "% done...");
                    n4 = n5;
                }
            }
            stringBuilder.append(string4);
            stringBuilder.append(string2);
            block8: for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(',');
                switch (nArray[i]) {
                    case 1: {
                        stringBuilder.append(stringArray[i]);
                        continue block8;
                    }
                    case 2: {
                        char c = stringArray[i].charAt(0);
                        if ('0' == c || 'f' == c) {
                            stringBuilder.append("false");
                            continue block8;
                        }
                        stringBuilder.append("true");
                        continue block8;
                    }
                    case 3: {
                        stringBuilder.append('\'');
                        stringBuilder.append(DbConnection.clean(stringArray[i]));
                        stringBuilder.append('\'');
                    }
                }
            }
            if (stringBuilder.length() > 500000) {
                stringBuilder.append(')');
                dbConnection.update(stringBuilder.toString());
                stringBuilder.setLength(n);
                string4 = " (";
                continue;
            }
            string4 = "),(";
        }
        if (stringBuilder.length() > n) {
            stringBuilder.append(')');
            dbConnection.update(stringBuilder.toString());
        }
    }

    private static void doUpdateRootData(DbConnection dbConnection) throws SQLException {
        dbConnection.update("DELETE FROM country");
        dbConnection.update("INSERT INTO country VALUES (1, 'U.S.', 'US'),(2, 'Canada', 'CA'),(3, 'Mexico', 'MX')");
        dbConnection.update("DELETE FROM service_type");
        dbConnection.update("INSERT INTO service_type VALUES (1, 1, 'TV Full Service digital', true, false),(2, 1, 'TV Full Service analog', false, false),(3, 1, 'TV Class A digital', true, true),(4, 1, 'TV Class A analog', false, false),(5, 1, 'TV Low Power digital', true, true),(6, 1, 'TV Low Power analog', false, false),(11, 2, 'Wireless', true, false),(21, 3, 'FM Full Service', false, false),(22, 3, 'FM Low Power', false, false),(23, 3, 'FM Translator/Booster', false, false)");
        dbConnection.query("SELECT COUNT(*) FROM signal_type");
        if (!dbConnection.next() || 0 == dbConnection.getInt(1)) {
            dbConnection.update("INSERT INTO signal_type VALUES (1, 'ATSC', true)");
        }
        dbConnection.update("DELETE FROM service");
        dbConnection.update("DELETE FROM cdbs_service");
        dbConnection.update("DELETE FROM lms_service");
        dbConnection.update("INSERT INTO service VALUES (1, 'TV digital', 'DT', 1, false, true, 80, 0, 1),(2, 'TV DTS', 'DD', 1, true, true, 90, 0, 2),(3, 'TV Class A digital', 'DC', 3, false, true, 70, 0, 3),(10, 'TV Class A DTS', 'DA', 3, true, true, 75, 0, 4),(4, 'TV Low Power/Translator digital', 'LD', 5, false, true, 60, 0, 5),(11, 'TV Low Power/Translator DTS', 'DL', 5, true, true, 65, 0, 6),(8, 'TV Aux/Rulemaking digital', 'DX', 1, false, false, 20, 0, 7),(5, 'TV analog', 'TV', 2, false, true, 50, 1, 8),(6, 'TV Class A analog', 'CA', 4, false, true, 40, 3, 9),(7, 'TV Low Power/Translator analog', 'TX', 6, false, true, 30, 4, 10),(9, 'TV Aux/Rulemaking analog', 'TS', 2, false, false, 10, 8, 11),(21, 'Wireless', 'WL', 11, false, true, 10, 0, 12),(31, 'FM', 'FM', 21, false, true, 60, 42, 13),(32, 'FM Low Power', 'FL', 22, false, true, 40, 0, 14),(33, 'FM Translator', 'FX', 23, false, true, 30, 0, 15),(34, 'FM Booster', 'FB', 23, false, true, 20, 0, 16),(35, 'FM Aux/Allot/Rulemaking', 'FS', 21, false, false, 10, 0, 17)");
        dbConnection.update("INSERT INTO cdbs_service VALUES ('DT', 1),('DD', 2),('DC', 3),('LD', 4),('DS', 1),('TV', 5),('CA', 6),('TX', 7),('TB', 7),('DX', 8),('DR', 1),('DM', 8),('DN', 8),('TS', 9),('TA', 9),('TR', 9),('NM', 9),('NN', 9),('FM', 31),('FL', 32),('FX', 33),('FB', 34),('FS', 35),('FR', 35),('FA', 35)");
        dbConnection.update("INSERT INTO lms_service VALUES ('DTV', 1),('DTS', 2),('DCA', 3),('CADTS', 10),('LPD', 4),('LPT', 4),('DRT', 4),('LDTS', 11),('TDTS', 11),('TV', 5),('ACA', 6),('LPA', 7),('LPX', 7),('DTX', 8),('TS', 9),('FM', 31),('FL', 32),('FX', 33),('FB', 34),('FS', 35),('FR', 35),('FA', 35)");
        dbConnection.update("DELETE FROM channel_band");
        dbConnection.update("INSERT INTO channel_band VALUES (1, 'VHF', 2, 13),(2, 'UHF', 14, 51)");
        dbConnection.update("DELETE FROM channel_delta");
        dbConnection.update("INSERT INTO channel_delta VALUES (1, 1, '8 below', -8, true),(2, 1, '7 below', -7, true),(3, 1, '4 below', -4, true),(4, 1, '3 below', -3, true),(5, 1, '2 below', -2, true),(6, 1, '1 below', -1, false),(7, 1, 'co-channel', 0, false),(8, 1, '1 above', 1, false),(9, 1, '2 above', 2, true),(10, 1, '3 above', 3, true),(11, 1, '4 above', 4, true),(12, 1, '7 above', 7, true),(13, 1, '8 above', 8, true),(14, 1, '14 above', 14, true),(15, 1, '15 above', 15, true),(19, 3, '54 below', -54, false),(20, 3, '53 below', -53, false),(21, 3, '3 below', -3, false),(22, 3, '2 below', -2, false),(23, 3, '1 below', -1, false),(24, 3, 'co-channel', 0, false),(25, 3, '1 above', 1, false),(26, 3, '2 above', 2, false),(27, 3, '3 above', 3, false),(28, 3, '53 above', 53, false),(29, 3, '54 above', 54, false)");
        dbConnection.update("DELETE FROM emission_mask");
        dbConnection.update("INSERT INTO emission_mask VALUES(1, 'Simple', 'S', true),(2, 'Stringent', 'T', false),(3, 'Full Service', 'F', false)");
        dbConnection.update("DELETE FROM frequency_offset");
        dbConnection.update("INSERT INTO frequency_offset VALUES(1, 'Zero', 'z'),(2, 'Plus', '+'),(3, 'Minus', '-')");
        dbConnection.update("DELETE FROM zone");
        dbConnection.update("INSERT INTO zone VALUES(1, 'I', '1'),(2, 'II', '2'),(3, 'III', '3')");
        dbConnection.update("DELETE FROM template_ix_rule WHERE template_key = 1");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,   1, 1, 2, 0, 2, 0,  7, 0, 2, 0, 300.,  28., 10),(1,   2, 1, 2, 0, 2, 0,  7, 0, 1, 0, 300.,  45., 10),(1,   3, 1, 2, 0, 2, 0,  8, 0, 0, 0, 100., -13., 10),(1,   4, 1, 2, 0, 2, 0,  9, 2, 0, 0,  35., -29., 10),(1,   5, 1, 2, 0, 2, 0, 10, 2, 0, 0,  35., -34., 10),(1,   6, 1, 2, 0, 2, 0, 11, 2, 0, 0,  35., -23., 10),(1,   7, 1, 2, 0, 2, 0, 12, 2, 0, 0, 100., -33., 10),(1,   8, 1, 2, 0, 2, 0, 13, 2, 0, 0,  35., -41., 10),(1,   9, 1, 2, 0, 2, 0,  6, 0, 0, 0, 100.,  -3., 10),(1,  10, 1, 2, 0, 2, 0,  5, 2, 0, 0,  35., -26., 10),(1,  11, 1, 2, 0, 2, 0,  4, 2, 0, 0,  35., -33., 10),(1,  12, 1, 2, 0, 2, 0,  2, 2, 0, 0, 100., -30., 10),(1,  13, 1, 2, 0, 2, 0,  1, 2, 0, 0,  35., -32., 10),(1,  14, 1, 2, 0, 2, 0, 14, 2, 0, 0, 100., -25., 10),(1,  15, 1, 2, 0, 2, 0, 15, 2, 0, 0, 125.,  -9., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  16, 1, 2, 0, 1, 1,  7, 0, 0, 0, 300.,  34., 10),(1,  17, 1, 2, 0, 1, 1,  8, 0, 0, 0, 100., -17., 10),(1,  18, 1, 2, 0, 1, 1,  9, 2, 0, 0,  35., -28., 10),(1,  19, 1, 2, 0, 1, 1, 10, 2, 0, 0,  35., -34., 10),(1,  20, 1, 2, 0, 1, 1, 11, 2, 0, 0,  35., -25., 10),(1,  21, 1, 2, 0, 1, 1, 12, 2, 0, 0,  35., -43., 10),(1,  22, 1, 2, 0, 1, 1, 13, 2, 0, 0,  35., -43., 10),(1,  23, 1, 2, 0, 1, 1,  6, 0, 0, 0, 100., -14., 10),(1,  24, 1, 2, 0, 1, 1,  5, 2, 0, 0,  35., -24., 10),(1,  25, 1, 2, 0, 1, 1,  4, 2, 0, 0,  35., -30., 10),(1,  26, 1, 2, 0, 1, 1,  3, 2, 0, 0,  35., -34., 10),(1,  27, 1, 2, 0, 1, 1,  2, 2, 0, 0,  35., -35., 10),(1,  28, 1, 2, 0, 1, 1,  1, 2, 0, 0,  35., -32., 10),(1,  29, 1, 2, 0, 1, 1, 14, 2, 0, 0,  35., -33., 10),(1,  30, 1, 2, 0, 1, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  31, 1, 2, 0, 4, 0,  7, 0, 2, 0, 300.,  28., 10),(1,  32, 1, 2, 0, 4, 0,  7, 0, 1, 0, 300.,  45., 10),(1,  33, 1, 2, 0, 4, 0,  8, 1, 0, 0, 100., -12., 50),(1,  34, 1, 2, 0, 4, 0,  8, 2, 0, 0, 100., -15., 50),(1,  35, 1, 2, 0, 4, 0,  6, 1, 0, 0, 100.,  -6., 50),(1,  36, 1, 2, 0, 4, 0,  6, 2, 0, 0, 100., -15., 50),(1,  37, 1, 2, 0, 4, 0, 14, 2, 0, 0, 100., -23., 50),(1,  38, 1, 2, 0, 4, 0, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  39, 1, 2, 0, 3, 1,  7, 0, 0, 0, 300.,  34., 10),(1,  40, 1, 2, 0, 3, 1,  8, 0, 0, 1, 100.,  10., 10),(1,  41, 1, 2, 0, 3, 1,  8, 0, 0, 2, 100.,   0., 10),(1,  42, 1, 2, 0, 3, 1,  8, 0, 0, 3, 100., -17., 10),(1,  43, 1, 2, 0, 3, 1,  9, 2, 0, 0,  35., -28., 10),(1,  44, 1, 2, 0, 3, 1, 10, 2, 0, 0,  35., -34., 10),(1,  45, 1, 2, 0, 3, 1, 11, 2, 0, 0,  35., -25., 10),(1,  46, 1, 2, 0, 3, 1, 12, 2, 0, 0,  35., -43., 10),(1,  47, 1, 2, 0, 3, 1, 13, 2, 0, 0,  35., -43., 10),(1,  48, 1, 2, 0, 3, 1,  6, 0, 0, 1, 100.,  10., 10),(1,  49, 1, 2, 0, 3, 1,  6, 0, 0, 2, 100.,   0., 10),(1,  50, 1, 2, 0, 3, 1,  6, 0, 0, 3, 100., -14., 10),(1,  51, 1, 2, 0, 3, 1,  5, 2, 0, 0,  35., -24., 10),(1,  52, 1, 2, 0, 3, 1,  4, 2, 0, 0,  35., -30., 10),(1,  53, 1, 2, 0, 3, 1,  3, 2, 0, 0,  35., -34., 10),(1,  54, 1, 2, 0, 3, 1,  2, 2, 0, 0,  35., -35., 10),(1,  55, 1, 2, 0, 3, 1,  1, 2, 0, 0,  35., -32., 10),(1,  56, 1, 2, 0, 3, 1, 14, 2, 0, 0,  35., -33., 10),(1,  57, 1, 2, 0, 3, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  58, 1, 2, 0, 6, 0,  7, 0, 2, 0, 300.,  28., 10),(1,  59, 1, 2, 0, 6, 0,  7, 0, 1, 0, 300.,  45., 10),(1,  60, 1, 2, 0, 6, 0,  8, 1, 0, 0, 100., -12., 50),(1,  61, 1, 2, 0, 6, 0,  8, 2, 0, 0, 100., -15., 50),(1,  62, 1, 2, 0, 6, 0,  6, 1, 0, 0, 100.,  -6., 50),(1,  63, 1, 2, 0, 6, 0,  6, 2, 0, 0, 100., -15., 50),(1,  64, 1, 2, 0, 6, 0, 14, 2, 0, 0, 100., -23., 50),(1,  65, 1, 2, 0, 6, 0, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  66, 1, 2, 0, 5, 1,  7, 0, 0, 0, 300.,  34., 10),(1,  67, 1, 2, 0, 5, 1,  8, 0, 0, 1, 100.,  10., 10),(1,  68, 1, 2, 0, 5, 1,  8, 0, 0, 2, 100.,   0., 10),(1,  69, 1, 2, 0, 5, 1,  8, 0, 0, 3, 100., -17., 10),(1,  70, 1, 2, 0, 5, 1,  9, 2, 0, 0,  35., -28., 10),(1,  71, 1, 2, 0, 5, 1, 10, 2, 0, 0,  35., -34., 10),(1,  72, 1, 2, 0, 5, 1, 11, 2, 0, 0,  35., -25., 10),(1,  73, 1, 2, 0, 5, 1, 12, 2, 0, 0,  35., -43., 10),(1,  74, 1, 2, 0, 5, 1, 13, 2, 0, 0,  35., -43., 10),(1,  75, 1, 2, 0, 5, 1,  6, 0, 0, 1, 100.,  10., 10),(1,  76, 1, 2, 0, 5, 1,  6, 0, 0, 2, 100.,   0., 10),(1,  77, 1, 2, 0, 5, 1,  6, 0, 0, 3, 100., -14., 10),(1,  78, 1, 2, 0, 5, 1,  5, 2, 0, 0,  35., -24., 10),(1,  79, 1, 2, 0, 5, 1,  4, 2, 0, 0,  35., -30., 10),(1,  80, 1, 2, 0, 5, 1,  3, 2, 0, 0,  35., -34., 10),(1,  81, 1, 2, 0, 5, 1,  2, 2, 0, 0,  35., -35., 10),(1,  82, 1, 2, 0, 5, 1,  1, 2, 0, 0,  35., -32., 10),(1,  83, 1, 2, 0, 5, 1, 14, 2, 0, 0,  35., -33., 10),(1,  84, 1, 2, 0, 5, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  85, 1, 1, 1, 2, 0,  7, 0, 0, 0, 300.,   2., 10),(1,  86, 1, 1, 1, 2, 0,  8, 0, 0, 0, 100., -49., 10),(1,  87, 1, 1, 1, 2, 0,  6, 0, 0, 0, 100., -48., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  88, 1, 1, 1, 1, 1,  7, 0, 0, 0, 300.,  15., 10),(1,  89, 1, 1, 1, 1, 1,  8, 0, 0, 0, 100., -26., 10),(1,  90, 1, 1, 1, 1, 1,  6, 0, 0, 0, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  91, 1, 1, 1, 4, 0,  7, 0, 0, 0, 300.,   2., 10),(1,  92, 1, 1, 1, 4, 0,  8, 0, 0, 0, 100., -49., 10),(1,  93, 1, 1, 1, 4, 0,  6, 0, 0, 0, 100., -48., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1,  94, 1, 1, 1, 3, 1,  7, 0, 0, 0, 300.,  15., 10),(1,  95, 1, 1, 1, 3, 1,  8, 0, 0, 1, 100.,  -7., 10),(1,  96, 1, 1, 1, 3, 1,  8, 0, 0, 2, 100., -12., 10),(1,  97, 1, 1, 1, 3, 1,  8, 0, 0, 3, 100., -26., 10),(1,  98, 1, 1, 1, 3, 1,  6, 0, 0, 1, 100.,  -7., 10),(1,  99, 1, 1, 1, 3, 1,  6, 0, 0, 2, 100., -12., 10),(1, 100, 1, 1, 1, 3, 1,  6, 0, 0, 3, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 101, 1, 1, 1, 6, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 102, 1, 1, 1, 6, 0,  8, 0, 0, 0, 100., -49., 50),(1, 103, 1, 1, 1, 6, 0,  6, 0, 0, 0, 100., -48., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 104, 1, 1, 1, 5, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 105, 1, 1, 1, 5, 1,  8, 0, 0, 1, 100.,  -7., 10),(1, 106, 1, 1, 1, 5, 1,  8, 0, 0, 2, 100., -12., 10),(1, 107, 1, 1, 1, 5, 1,  8, 0, 0, 3, 100., -26., 10),(1, 108, 1, 1, 1, 5, 1,  6, 0, 0, 1, 100.,  -7., 10),(1, 109, 1, 1, 1, 5, 1,  6, 0, 0, 2, 100., -12., 10),(1, 110, 1, 1, 1, 5, 1,  6, 0, 0, 3, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 111, 1, 4, 0, 2, 0,  7, 0, 2, 0, 300.,  28., 10),(1, 112, 1, 4, 0, 2, 0,  7, 0, 1, 0, 300.,  45., 10),(1, 113, 1, 4, 0, 2, 0,  8, 1, 0, 0, 100., -12., 50),(1, 114, 1, 4, 0, 2, 0,  8, 2, 0, 0, 100., -15., 50),(1, 115, 1, 4, 0, 2, 0,  6, 1, 0, 0, 100.,  -6., 50),(1, 116, 1, 4, 0, 2, 0,  6, 2, 0, 0, 100., -15., 50),(1, 117, 1, 4, 0, 2, 0, 14, 2, 0, 0, 100., -23., 50),(1, 118, 1, 4, 0, 2, 0, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 119, 1, 4, 0, 1, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 120, 1, 4, 0, 1, 1,  8, 0, 0, 0, 100., -17., 10),(1, 121, 1, 4, 0, 1, 1,  9, 2, 0, 0,  35., -28., 10),(1, 122, 1, 4, 0, 1, 1, 10, 2, 0, 0,  35., -34., 10),(1, 123, 1, 4, 0, 1, 1, 11, 2, 0, 0,  35., -25., 10),(1, 124, 1, 4, 0, 1, 1, 12, 2, 0, 0,  35., -43., 10),(1, 125, 1, 4, 0, 1, 1, 13, 2, 0, 0,  35., -43., 10),(1, 126, 1, 4, 0, 1, 1,  6, 0, 0, 0, 100., -14., 10),(1, 127, 1, 4, 0, 1, 1,  5, 2, 0, 0,  35., -24., 10),(1, 128, 1, 4, 0, 1, 1,  4, 2, 0, 0,  35., -30., 10),(1, 129, 1, 4, 0, 1, 1,  3, 2, 0, 0,  35., -34., 10),(1, 130, 1, 4, 0, 1, 1,  2, 2, 0, 0,  35., -35., 10),(1, 131, 1, 4, 0, 1, 1,  1, 2, 0, 0,  35., -32., 10),(1, 132, 1, 4, 0, 1, 1, 14, 2, 0, 0,  35., -33., 10),(1, 133, 1, 4, 0, 1, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 134, 1, 4, 0, 4, 0,  7, 0, 2, 0, 300.,  28., 10),(1, 135, 1, 4, 0, 4, 0,  7, 0, 1, 0, 300.,  45., 10),(1, 136, 1, 4, 0, 4, 0,  8, 1, 0, 0, 100., -12., 50),(1, 137, 1, 4, 0, 4, 0,  8, 2, 0, 0, 100., -15., 50),(1, 138, 1, 4, 0, 4, 0,  6, 1, 0, 0, 100.,  -6., 50),(1, 139, 1, 4, 0, 4, 0,  6, 2, 0, 0, 100., -15., 50),(1, 140, 1, 4, 0, 4, 0, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 141, 1, 4, 0, 3, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 142, 1, 4, 0, 3, 1,  8, 0, 0, 1, 100.,  10., 10),(1, 143, 1, 4, 0, 3, 1,  8, 0, 0, 2, 100.,   0., 10),(1, 144, 1, 4, 0, 3, 1,  8, 0, 0, 3, 100., -17., 10),(1, 145, 1, 4, 0, 3, 1,  9, 2, 0, 0,  35., -28., 10),(1, 146, 1, 4, 0, 3, 1, 10, 2, 0, 0,  35., -34., 10),(1, 147, 1, 4, 0, 3, 1, 11, 2, 0, 0,  35., -25., 10),(1, 148, 1, 4, 0, 3, 1, 12, 2, 0, 0,  35., -43., 10),(1, 149, 1, 4, 0, 3, 1, 13, 2, 0, 0,  35., -43., 10),(1, 150, 1, 4, 0, 3, 1,  6, 0, 0, 1, 100.,  10., 10),(1, 151, 1, 4, 0, 3, 1,  6, 0, 0, 2, 100.,   0., 10),(1, 152, 1, 4, 0, 3, 1,  6, 0, 0, 3, 100., -14., 10),(1, 153, 1, 4, 0, 3, 1,  5, 2, 0, 0,  35., -24., 10),(1, 154, 1, 4, 0, 3, 1,  4, 2, 0, 0,  35., -30., 10),(1, 155, 1, 4, 0, 3, 1,  3, 2, 0, 0,  35., -34., 10),(1, 156, 1, 4, 0, 3, 1,  2, 2, 0, 0,  35., -35., 10),(1, 157, 1, 4, 0, 3, 1,  1, 2, 0, 0,  35., -32., 10),(1, 158, 1, 4, 0, 3, 1, 14, 2, 0, 0,  35., -33., 10),(1, 159, 1, 4, 0, 3, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 160, 1, 4, 0, 6, 0,  7, 0, 2, 0, 300.,  28., 10),(1, 161, 1, 4, 0, 6, 0,  7, 0, 1, 0, 300.,  45., 10),(1, 162, 1, 4, 0, 6, 0,  8, 1, 0, 0, 100., -12., 50),(1, 163, 1, 4, 0, 6, 0,  8, 2, 0, 0, 100., -15., 50),(1, 164, 1, 4, 0, 6, 0,  6, 1, 0, 0, 100.,  -6., 50),(1, 165, 1, 4, 0, 6, 0,  6, 2, 0, 0, 100., -15., 50),(1, 166, 1, 4, 0, 6, 0, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 167, 1, 4, 0, 5, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 168, 1, 4, 0, 5, 1,  8, 0, 0, 1, 100.,  10., 10),(1, 169, 1, 4, 0, 5, 1,  8, 0, 0, 2, 100.,   0., 10),(1, 170, 1, 4, 0, 5, 1,  8, 0, 0, 3, 100., -17., 10),(1, 171, 1, 4, 0, 5, 1,  9, 2, 0, 0,  35., -28., 10),(1, 172, 1, 4, 0, 5, 1, 10, 2, 0, 0,  35., -34., 10),(1, 173, 1, 4, 0, 5, 1, 11, 2, 0, 0,  35., -25., 10),(1, 174, 1, 4, 0, 5, 1, 12, 2, 0, 0,  35., -43., 10),(1, 175, 1, 4, 0, 5, 1, 13, 2, 0, 0,  35., -43., 10),(1, 176, 1, 4, 0, 5, 1,  6, 0, 0, 1, 100.,  10., 10),(1, 177, 1, 4, 0, 5, 1,  6, 0, 0, 2, 100.,   0., 10),(1, 178, 1, 4, 0, 5, 1,  6, 0, 0, 3, 100., -14., 10),(1, 179, 1, 4, 0, 5, 1,  5, 2, 0, 0,  35., -24., 10),(1, 180, 1, 4, 0, 5, 1,  4, 2, 0, 0,  35., -30., 10),(1, 181, 1, 4, 0, 5, 1,  3, 2, 0, 0,  35., -34., 10),(1, 182, 1, 4, 0, 5, 1,  2, 2, 0, 0,  35., -35., 10),(1, 183, 1, 4, 0, 5, 1,  1, 2, 0, 0,  35., -32., 10),(1, 184, 1, 4, 0, 5, 1, 14, 2, 0, 0,  35., -33., 10),(1, 185, 1, 4, 0, 5, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 186, 1, 3, 1, 2, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 187, 1, 3, 1, 2, 0,  8, 0, 0, 0, 100., -49., 10),(1, 188, 1, 3, 1, 2, 0,  6, 0, 0, 0, 100., -48., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 189, 1, 3, 1, 1, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 190, 1, 3, 1, 1, 1,  8, 0, 0, 0, 100., -26., 10),(1, 191, 1, 3, 1, 1, 1,  6, 0, 0, 0, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 192, 1, 3, 1, 4, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 193, 1, 3, 1, 4, 0,  8, 0, 0, 0, 100., -49., 50),(1, 194, 1, 3, 1, 4, 0,  6, 0, 0, 0, 100., -48., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 195, 1, 3, 1, 3, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 196, 1, 3, 1, 3, 1,  8, 0, 0, 1, 100.,  -7., 10),(1, 197, 1, 3, 1, 3, 1,  8, 0, 0, 2, 100., -12., 10),(1, 198, 1, 3, 1, 3, 1,  8, 0, 0, 3, 100., -26., 10),(1, 199, 1, 3, 1, 3, 1,  6, 0, 0, 1, 100.,  -7., 10),(1, 200, 1, 3, 1, 3, 1,  6, 0, 0, 2, 100., -12., 10),(1, 201, 1, 3, 1, 3, 1,  6, 0, 0, 3, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 202, 1, 3, 1, 6, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 203, 1, 3, 1, 6, 0,  8, 0, 0, 0, 100., -49., 50),(1, 204, 1, 3, 1, 6, 0,  6, 0, 0, 0, 100., -48., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 205, 1, 3, 1, 5, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 206, 1, 3, 1, 5, 1,  8, 0, 0, 1, 100.,  -7., 10),(1, 207, 1, 3, 1, 5, 1,  8, 0, 0, 2, 100., -12., 10),(1, 208, 1, 3, 1, 5, 1,  8, 0, 0, 3, 100., -26., 10),(1, 209, 1, 3, 1, 5, 1,  6, 0, 0, 1, 100.,  -7., 10),(1, 210, 1, 3, 1, 5, 1,  6, 0, 0, 2, 100., -12., 10),(1, 211, 1, 3, 1, 5, 1,  6, 0, 0, 3, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 212, 1, 6, 0, 2, 0,  7, 0, 2, 0, 300.,  28., 10),(1, 213, 1, 6, 0, 2, 0,  7, 0, 1, 0, 300.,  45., 10),(1, 214, 1, 6, 0, 2, 0,  8, 1, 0, 0, 100., -12., 50),(1, 215, 1, 6, 0, 2, 0,  8, 2, 0, 0, 100., -15., 50),(1, 216, 1, 6, 0, 2, 0,  6, 1, 0, 0, 100.,  -6., 50),(1, 217, 1, 6, 0, 2, 0,  6, 2, 0, 0, 100., -15., 50),(1, 218, 1, 6, 0, 2, 0, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 219, 1, 6, 0, 1, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 220, 1, 6, 0, 1, 1,  8, 0, 0, 0, 100., -17., 50),(1, 221, 1, 6, 0, 1, 1,  6, 0, 0, 0, 100., -14., 50),(1, 222, 1, 6, 0, 1, 1, 15, 2, 0, 0,  35., -31., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 223, 1, 6, 0, 4, 0,  7, 0, 2, 0, 300.,  28., 10),(1, 224, 1, 6, 0, 4, 0,  7, 0, 1, 0, 300.,  45., 10),(1, 225, 1, 6, 0, 4, 0,  8, 1, 0, 0, 100., -12., 50),(1, 226, 1, 6, 0, 4, 0,  8, 2, 0, 0, 100., -15., 50),(1, 227, 1, 6, 0, 4, 0,  6, 1, 0, 0, 100.,  -6., 50),(1, 228, 1, 6, 0, 4, 0,  6, 2, 0, 0, 100., -15., 50),(1, 229, 1, 6, 0, 4, 0, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 230, 1, 6, 0, 3, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 231, 1, 6, 0, 3, 1,  8, 0, 0, 1, 100.,  10., 10),(1, 232, 1, 6, 0, 3, 1,  8, 0, 0, 2, 100.,   0., 10),(1, 233, 1, 6, 0, 3, 1,  8, 0, 0, 3, 100., -17., 10),(1, 234, 1, 6, 0, 3, 1,  9, 2, 0, 0,  35., -28., 10),(1, 235, 1, 6, 0, 3, 1, 10, 2, 0, 0,  35., -34., 10),(1, 236, 1, 6, 0, 3, 1, 11, 2, 0, 0,  35., -25., 10),(1, 237, 1, 6, 0, 3, 1, 12, 2, 0, 0,  35., -43., 10),(1, 238, 1, 6, 0, 3, 1, 13, 2, 0, 0,  35., -43., 10),(1, 239, 1, 6, 0, 3, 1,  6, 0, 0, 1, 100.,  10., 10),(1, 240, 1, 6, 0, 3, 1,  6, 0, 0, 2, 100.,   0., 10),(1, 241, 1, 6, 0, 3, 1,  6, 0, 0, 3, 100., -14., 10),(1, 242, 1, 6, 0, 3, 1,  5, 2, 0, 0,  35., -24., 10),(1, 243, 1, 6, 0, 3, 1,  4, 2, 0, 0,  35., -30., 10),(1, 244, 1, 6, 0, 3, 1,  3, 2, 0, 0,  35., -34., 10),(1, 245, 1, 6, 0, 3, 1,  2, 2, 0, 0,  35., -35., 10),(1, 246, 1, 6, 0, 3, 1,  1, 2, 0, 0,  35., -32., 10),(1, 247, 1, 6, 0, 3, 1, 14, 2, 0, 0,  35., -33., 10),(1, 248, 1, 6, 0, 3, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 249, 1, 6, 0, 6, 0,  7, 0, 2, 0, 300.,  28., 10),(1, 250, 1, 6, 0, 6, 0,  7, 0, 1, 0, 300.,  45., 10),(1, 251, 1, 6, 0, 6, 0,  8, 1, 0, 0, 100., -12., 50),(1, 252, 1, 6, 0, 6, 0,  8, 2, 0, 0, 100., -15., 50),(1, 253, 1, 6, 0, 6, 0,  6, 1, 0, 0, 100.,  -6., 50),(1, 254, 1, 6, 0, 6, 0,  6, 2, 0, 0, 100., -15., 50),(1, 255, 1, 6, 0, 6, 0, 15, 2, 0, 0, 125.,  -6., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 256, 1, 6, 0, 5, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 257, 1, 6, 0, 5, 1,  8, 0, 0, 1, 100.,  10., 10),(1, 258, 1, 6, 0, 5, 1,  8, 0, 0, 2, 100.,   0., 10),(1, 259, 1, 6, 0, 5, 1,  8, 0, 0, 3, 100., -17., 10),(1, 260, 1, 6, 0, 5, 1,  9, 2, 0, 0,  35., -28., 10),(1, 261, 1, 6, 0, 5, 1, 10, 2, 0, 0,  35., -34., 10),(1, 262, 1, 6, 0, 5, 1, 11, 2, 0, 0,  35., -25., 10),(1, 263, 1, 6, 0, 5, 1, 12, 2, 0, 0,  35., -43., 10),(1, 264, 1, 6, 0, 5, 1, 13, 2, 0, 0,  35., -43., 10),(1, 265, 1, 6, 0, 5, 1,  6, 0, 0, 1, 100.,  10., 10),(1, 266, 1, 6, 0, 5, 1,  6, 0, 0, 2, 100.,   0., 10),(1, 267, 1, 6, 0, 5, 1,  6, 0, 0, 3, 100., -14., 10),(1, 268, 1, 6, 0, 5, 1,  5, 2, 0, 0,  35., -24., 10),(1, 269, 1, 6, 0, 5, 1,  4, 2, 0, 0,  35., -30., 10),(1, 270, 1, 6, 0, 5, 1,  3, 2, 0, 0,  35., -34., 10),(1, 271, 1, 6, 0, 5, 1,  2, 2, 0, 0,  35., -35., 10),(1, 272, 1, 6, 0, 5, 1,  1, 2, 0, 0,  35., -32., 10),(1, 273, 1, 6, 0, 5, 1, 14, 2, 0, 0,  35., -33., 10),(1, 274, 1, 6, 0, 5, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 275, 1, 5, 1, 2, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 276, 1, 5, 1, 2, 0,  8, 0, 0, 0, 100., -49., 10),(1, 277, 1, 5, 1, 2, 0,  6, 0, 0, 0, 100., -48., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 278, 1, 5, 1, 1, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 279, 1, 5, 1, 1, 1,  8, 0, 0, 0, 100., -26., 10),(1, 280, 1, 5, 1, 1, 1,  6, 0, 0, 0, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 281, 1, 5, 1, 4, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 282, 1, 5, 1, 4, 0,  8, 0, 0, 0, 100., -49., 50),(1, 283, 1, 5, 1, 4, 0,  6, 0, 0, 0, 100., -48., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 284, 1, 5, 1, 3, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 285, 1, 5, 1, 3, 1,  8, 0, 0, 1, 100.,  -7., 10),(1, 286, 1, 5, 1, 3, 1,  8, 0, 0, 2, 100., -12., 10),(1, 287, 1, 5, 1, 3, 1,  8, 0, 0, 3, 100., -26., 10),(1, 288, 1, 5, 1, 3, 1,  6, 0, 0, 1, 100.,  -7., 10),(1, 289, 1, 5, 1, 3, 1,  6, 0, 0, 2, 100., -12., 10),(1, 290, 1, 5, 1, 3, 1,  6, 0, 0, 3, 100., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 291, 1, 5, 1, 6, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 292, 1, 5, 1, 6, 0,  8, 0, 0, 0, 100., -49., 50),(1, 293, 1, 5, 1, 6, 0,  6, 0, 0, 0, 100., -48., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 294, 1, 5, 1, 5, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 295, 1, 5, 1, 5, 1,  8, 0, 0, 1, 100.,  -7., 10),(1, 296, 1, 5, 1, 5, 1,  8, 0, 0, 2, 100., -12., 10),(1, 297, 1, 5, 1, 5, 1,  8, 0, 0, 3, 100., -26., 10),(1, 298, 1, 5, 1, 5, 1,  6, 0, 0, 1, 100.,  -7., 10),(1, 299, 1, 5, 1, 5, 1,  6, 0, 0, 2, 100., -12., 10),(1, 300, 1, 5, 1, 5, 1,  6, 0, 0, 3, 100., -26., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 301, 2, 1, 1, 1, 1,  6, 0, 0, 0, 100., -28., 10),(1, 302, 2, 1, 1, 1, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 303, 2, 1, 1, 1, 1,  8, 0, 0, 0, 100., -26., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 304, 2, 1, 1, 2, 0,  6, 0, 0, 0, 100., -48., 10),(1, 305, 2, 1, 1, 2, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 306, 2, 1, 1, 2, 0,  8, 0, 0, 0, 100., -49., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 307, 2, 1, 1, 3, 1,  6, 0, 0, 3, 100., -28., 10),(1, 308, 2, 1, 1, 3, 1,  6, 0, 0, 2, 100., -12., 10),(1, 309, 2, 1, 1, 3, 1,  6, 0, 0, 1, 100.,  -7., 10),(1, 310, 2, 1, 1, 3, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 311, 2, 1, 1, 3, 1,  8, 0, 0, 3, 100., -26., 10),(1, 312, 2, 1, 1, 3, 1,  8, 0, 0, 2, 100., -12., 10),(1, 313, 2, 1, 1, 3, 1,  8, 0, 0, 1, 100.,  -7., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 314, 2, 1, 1, 4, 0,  6, 0, 0, 0, 100., -48., 10),(1, 315, 2, 1, 1, 4, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 316, 2, 1, 1, 4, 0,  8, 0, 0, 0, 100., -49., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 317, 2, 1, 1, 5, 1,  6, 0, 0, 3, 100., -28., 10),(1, 318, 2, 1, 1, 5, 1,  6, 0, 0, 2, 100., -12., 10),(1, 319, 2, 1, 1, 5, 1,  6, 0, 0, 1, 100.,  -7., 10),(1, 320, 2, 1, 1, 5, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 321, 2, 1, 1, 5, 1,  8, 0, 0, 3, 100., -26., 10),(1, 322, 2, 1, 1, 5, 1,  8, 0, 0, 2, 100., -12., 10),(1, 323, 2, 1, 1, 5, 1,  8, 0, 0, 1, 100.,  -7., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 324, 2, 1, 1, 6, 0,  6, 0, 0, 0, 100., -48., 10),(1, 325, 2, 1, 1, 6, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 326, 2, 1, 1, 6, 0,  8, 0, 0, 0, 100., -49., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 327, 2, 2, 0, 1, 1,  1, 2, 0, 0,  35., -32., 10),(1, 328, 2, 2, 0, 1, 1,  2, 2, 0, 0,  35., -35., 10),(1, 329, 2, 2, 0, 1, 1,  3, 2, 0, 0,  35., -34., 10),(1, 330, 2, 2, 0, 1, 1,  4, 2, 0, 0,  35., -30., 10),(1, 331, 2, 2, 0, 1, 1,  5, 2, 0, 0,  35., -24., 10),(1, 332, 2, 2, 0, 1, 1,  6, 0, 0, 0, 100., -14., 10),(1, 333, 2, 2, 0, 1, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 334, 2, 2, 0, 1, 1,  8, 0, 0, 0, 100., -17., 10),(1, 335, 2, 2, 0, 1, 1,  9, 2, 0, 0,  35., -28., 10),(1, 336, 2, 2, 0, 1, 1, 10, 2, 0, 0,  35., -34., 10),(1, 337, 2, 2, 0, 1, 1, 11, 2, 0, 0,  35., -25., 10),(1, 338, 2, 2, 0, 1, 1, 12, 2, 0, 0,  35., -43., 10),(1, 339, 2, 2, 0, 1, 1, 13, 2, 0, 0,  35., -43., 10),(1, 340, 2, 2, 0, 1, 1, 14, 2, 0, 0, 100., -46., 50),(1, 341, 2, 2, 0, 1, 1, 15, 2, 0, 0, 125., -28., 50)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 342, 2, 2, 0, 2, 0,  2, 2, 0, 0, 100., -30., 10),(1, 343, 2, 2, 0, 2, 0,  4, 2, 0, 0,  35., -33., 10),(1, 344, 2, 2, 0, 2, 0,  5, 2, 0, 0,  35., -26., 10),(1, 345, 2, 2, 0, 2, 0,  6, 1, 0, 0, 100., -25., 50),(1, 346, 2, 2, 0, 2, 0,  6, 2, 0, 0, 100., -36., 10),(1, 347, 2, 2, 0, 2, 0,  7, 1, 2, 0, 300.,  15., 10),(1, 348, 2, 2, 0, 2, 0,  7, 1, 1, 0, 300.,  32., 10),(1, 349, 2, 2, 0, 2, 0,  7, 2, 2, 0, 300.,  18., 10),(1, 350, 2, 2, 0, 2, 0,  7, 2, 1, 0, 300.,  35., 10),(1, 351, 2, 2, 0, 2, 0,  8, 1, 0, 0, 100., -25., 50),(1, 352, 2, 2, 0, 2, 0,  8, 2, 0, 0, 100., -36., 10),(1, 353, 2, 2, 0, 2, 0,  9, 2, 0, 0,  35., -29., 10),(1, 354, 2, 2, 0, 2, 0, 10, 2, 0, 0,  35., -34., 10),(1, 355, 2, 2, 0, 2, 0, 11, 2, 0, 0,  35., -23., 10),(1, 356, 2, 2, 0, 2, 0, 12, 2, 0, 0, 100., -33., 10),(1, 357, 2, 2, 0, 2, 0, 14, 2, 0, 0,  35., -46., 10),(1, 358, 2, 2, 0, 2, 0, 15, 2, 0, 0,  35., -28., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 359, 2, 2, 0, 3, 1,  1, 2, 0, 0,  35., -32., 10),(1, 360, 2, 2, 0, 3, 1,  2, 2, 0, 0,  35., -35., 10),(1, 361, 2, 2, 0, 3, 1,  3, 2, 0, 0,  35., -34., 10),(1, 362, 2, 2, 0, 3, 1,  4, 2, 0, 0,  35., -30., 10),(1, 363, 2, 2, 0, 3, 1,  5, 2, 0, 0,  35., -24., 10),(1, 364, 2, 2, 0, 3, 1,  6, 0, 0, 3, 100., -14., 10),(1, 365, 2, 2, 0, 3, 1,  6, 0, 0, 2, 100.,   0., 10),(1, 366, 2, 2, 0, 3, 1,  6, 0, 0, 1, 100.,  10., 10),(1, 367, 2, 2, 0, 3, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 368, 2, 2, 0, 3, 1,  8, 0, 0, 3, 100., -17., 10),(1, 369, 2, 2, 0, 3, 1,  8, 0, 0, 2, 100.,   0., 10),(1, 370, 2, 2, 0, 3, 1,  8, 0, 0, 1, 100.,  10., 10),(1, 371, 2, 2, 0, 3, 1,  9, 2, 0, 0,  35., -28., 10),(1, 372, 2, 2, 0, 3, 1, 10, 2, 0, 0,  35., -34., 10),(1, 373, 2, 2, 0, 3, 1, 11, 2, 0, 0,  35., -25., 10),(1, 374, 2, 2, 0, 3, 1, 12, 2, 0, 0,  35., -43., 10),(1, 375, 2, 2, 0, 3, 1, 13, 2, 0, 0,  35., -43., 10),(1, 376, 2, 2, 0, 3, 1, 14, 2, 0, 0,  35., -33., 10),(1, 377, 2, 2, 0, 3, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 378, 2, 2, 0, 4, 0,  2, 2, 0, 0, 100., -30., 10),(1, 379, 2, 2, 0, 4, 0,  4, 2, 0, 0,  35., -33., 10),(1, 380, 2, 2, 0, 4, 0,  5, 2, 0, 0,  35., -26., 10),(1, 381, 2, 2, 0, 4, 0,  6, 0, 0, 0, 100., -16., 10),(1, 382, 2, 2, 0, 4, 0,  7, 1, 1, 0, 300.,  35., 10),(1, 383, 2, 2, 0, 4, 0,  7, 1, 2, 0, 300.,  25., 10),(1, 384, 2, 2, 0, 4, 0,  7, 2, 1, 0, 300.,  28., 10),(1, 385, 2, 2, 0, 4, 0,  7, 2, 2, 0, 300.,  18., 10),(1, 386, 2, 2, 0, 4, 0,  8, 0, 0, 0, 100., -16., 10),(1, 387, 2, 2, 0, 4, 0,  9, 2, 0, 0,  35., -29., 10),(1, 388, 2, 2, 0, 4, 0, 10, 2, 0, 0,  35., -34., 10),(1, 389, 2, 2, 0, 4, 0, 11, 2, 0, 0,  35., -23., 10),(1, 390, 2, 2, 0, 4, 0, 12, 2, 0, 0, 100., -33., 10),(1, 391, 2, 2, 0, 4, 0, 14, 2, 0, 0, 100., -28., 10),(1, 392, 2, 2, 0, 4, 0, 15, 2, 0, 0, 125., -10., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 393, 2, 2, 0, 5, 1,  1, 2, 0, 0,  35., -32., 10),(1, 394, 2, 2, 0, 5, 1,  2, 2, 0, 0,  35., -35., 10),(1, 395, 2, 2, 0, 5, 1,  3, 2, 0, 0,  35., -34., 10),(1, 396, 2, 2, 0, 5, 1,  4, 2, 0, 0,  35., -30., 10),(1, 397, 2, 2, 0, 5, 1,  5, 2, 0, 0,  35., -24., 10),(1, 398, 2, 2, 0, 5, 1,  6, 0, 0, 3, 100., -14., 10),(1, 399, 2, 2, 0, 5, 1,  6, 0, 0, 2, 100.,   0., 10),(1, 400, 2, 2, 0, 5, 1,  6, 0, 0, 1, 100.,  10., 10),(1, 401, 2, 2, 0, 5, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 402, 2, 2, 0, 5, 1,  8, 0, 0, 3, 100., -17., 10),(1, 403, 2, 2, 0, 5, 1,  8, 0, 0, 2, 100.,   0., 10),(1, 404, 2, 2, 0, 5, 1,  8, 0, 0, 1, 100.,  10., 10),(1, 405, 2, 2, 0, 5, 1,  9, 2, 0, 0,  35., -28., 10),(1, 406, 2, 2, 0, 5, 1, 10, 2, 0, 0,  35., -34., 10),(1, 407, 2, 2, 0, 5, 1, 11, 2, 0, 0,  35., -25., 10),(1, 408, 2, 2, 0, 5, 1, 12, 2, 0, 0,  35., -43., 10),(1, 409, 2, 2, 0, 5, 1, 13, 2, 0, 0,  35., -43., 10),(1, 410, 2, 2, 0, 5, 1, 14, 2, 0, 0,  35., -33., 10),(1, 411, 2, 2, 0, 5, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 412, 2, 2, 0, 6, 0,  2, 2, 0, 0, 100., -30., 10),(1, 413, 2, 2, 0, 6, 0,  4, 2, 0, 0,  35., -33., 10),(1, 414, 2, 2, 0, 6, 0,  5, 2, 0, 0,  35., -26., 10),(1, 415, 2, 2, 0, 6, 0,  6, 0, 0, 0, 100., -16., 10),(1, 416, 2, 2, 0, 6, 0,  7, 1, 1, 0, 300.,  35., 10),(1, 417, 2, 2, 0, 6, 0,  7, 1, 2, 0, 300.,  25., 10),(1, 418, 2, 2, 0, 6, 0,  7, 2, 1, 0, 300.,  28., 10),(1, 419, 2, 2, 0, 6, 0,  7, 2, 2, 0, 300.,  18., 10),(1, 420, 2, 2, 0, 6, 0,  8, 0, 0, 0, 100., -16., 10),(1, 421, 2, 2, 0, 6, 0,  9, 2, 0, 0,  35., -29., 10),(1, 422, 2, 2, 0, 6, 0, 10, 2, 0, 0,  35., -34., 10),(1, 423, 2, 2, 0, 6, 0, 11, 2, 0, 0,  35., -23., 10),(1, 424, 2, 2, 0, 6, 0, 12, 2, 0, 0, 100., -33., 10),(1, 425, 2, 2, 0, 6, 0, 14, 2, 0, 0, 100., -28., 10),(1, 426, 2, 2, 0, 6, 0, 15, 2, 0, 0, 125., -10., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 427, 2, 5, 1, 1, 1,  6, 0, 0, 0, 100., -28., 10),(1, 428, 2, 5, 1, 1, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 429, 2, 5, 1, 1, 1,  8, 0, 0, 0, 100., -26., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 430, 2, 5, 1, 2, 0,  6, 0, 0, 0, 100., -48., 10),(1, 431, 2, 5, 1, 2, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 432, 2, 5, 1, 2, 0,  8, 0, 0, 0, 100., -49., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 433, 2, 5, 1, 3, 1,  6, 0, 0, 3, 100., -28., 10),(1, 434, 2, 5, 1, 3, 1,  6, 0, 0, 2, 100., -12., 10),(1, 435, 2, 5, 1, 3, 1,  6, 0, 0, 1, 100.,  -7., 10),(1, 436, 2, 5, 1, 3, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 437, 2, 5, 1, 3, 1,  8, 0, 0, 3, 100., -26., 10),(1, 438, 2, 5, 1, 3, 1,  8, 0, 0, 2, 100., -12., 10),(1, 439, 2, 5, 1, 3, 1,  8, 0, 0, 1, 100.,  -7., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 440, 2, 5, 1, 4, 0,  6, 0, 0, 0, 100., -48., 10),(1, 441, 2, 5, 1, 4, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 442, 2, 5, 1, 4, 0,  8, 0, 0, 0, 100., -49., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 443, 2, 5, 1, 5, 1,  6, 0, 0, 3, 100., -28., 10),(1, 444, 2, 5, 1, 5, 1,  6, 0, 0, 2, 100., -12., 10),(1, 445, 2, 5, 1, 5, 1,  6, 0, 0, 1, 100.,  -7., 10),(1, 446, 2, 5, 1, 5, 1,  7, 0, 0, 0, 300.,  15., 10),(1, 447, 2, 5, 1, 5, 1,  8, 0, 0, 3, 100., -26., 10),(1, 448, 2, 5, 1, 5, 1,  8, 0, 0, 2, 100., -12., 10),(1, 449, 2, 5, 1, 5, 1,  8, 0, 0, 1, 100.,  -7., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 450, 2, 5, 1, 6, 0,  6, 0, 0, 0, 100., -48., 10),(1, 451, 2, 5, 1, 6, 0,  7, 0, 0, 0, 300.,   2., 10),(1, 452, 2, 5, 1, 6, 0,  8, 0, 0, 0, 100., -49., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 453, 2, 6, 0, 1, 1,  1, 2, 0, 0,  35., -32., 10),(1, 454, 2, 6, 0, 1, 1,  2, 2, 0, 0,  35., -35., 10),(1, 455, 2, 6, 0, 1, 1,  3, 2, 0, 0,  35., -34., 10),(1, 456, 2, 6, 0, 1, 1,  4, 2, 0, 0,  35., -30., 10),(1, 457, 2, 6, 0, 1, 1,  5, 2, 0, 0,  35., -24., 10),(1, 458, 2, 6, 0, 1, 1,  6, 0, 0, 0, 100., -14., 10),(1, 459, 2, 6, 0, 1, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 460, 2, 6, 0, 1, 1,  8, 0, 0, 0, 100., -17., 10),(1, 461, 2, 6, 0, 1, 1,  9, 2, 0, 0,  35., -28., 10),(1, 462, 2, 6, 0, 1, 1, 10, 2, 0, 0,  35., -34., 10),(1, 463, 2, 6, 0, 1, 1, 11, 2, 0, 0,  35., -25., 10),(1, 464, 2, 6, 0, 1, 1, 12, 2, 0, 0,  35., -43., 10),(1, 465, 2, 6, 0, 1, 1, 13, 2, 0, 0,  35., -43., 10),(1, 466, 2, 6, 0, 1, 1, 14, 2, 0, 0,  35., -33., 10),(1, 467, 2, 6, 0, 1, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 468, 2, 6, 0, 2, 0,  2, 2, 0, 0, 100., -30., 10),(1, 469, 2, 6, 0, 2, 0,  4, 2, 0, 0,  35., -33., 10),(1, 470, 2, 6, 0, 2, 0,  5, 2, 0, 0,  35., -26., 10),(1, 471, 2, 6, 0, 2, 0,  6, 0, 0, 0, 100., -16., 10),(1, 472, 2, 6, 0, 2, 0,  7, 1, 1, 0, 300.,  35., 10),(1, 473, 2, 6, 0, 2, 0,  7, 1, 2, 0, 300.,  25., 10),(1, 474, 2, 6, 0, 2, 0,  7, 2, 1, 0, 300.,  28., 10),(1, 475, 2, 6, 0, 2, 0,  7, 2, 2, 0, 300.,  18., 10),(1, 476, 2, 6, 0, 2, 0,  8, 0, 0, 0, 100., -16., 10),(1, 477, 2, 6, 0, 2, 0,  9, 2, 0, 0,  35., -29., 10),(1, 478, 2, 6, 0, 2, 0, 10, 2, 0, 0,  35., -34., 10),(1, 479, 2, 6, 0, 2, 0, 11, 2, 0, 0,  35., -23., 10),(1, 480, 2, 6, 0, 2, 0, 12, 2, 0, 0, 100., -33., 10),(1, 481, 2, 6, 0, 2, 0, 14, 2, 0, 0, 100., -28., 10),(1, 482, 2, 6, 0, 2, 0, 15, 2, 0, 0, 125., -10., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 483, 2, 6, 0, 3, 1,  1, 2, 0, 0,  35., -32., 10),(1, 484, 2, 6, 0, 3, 1,  2, 2, 0, 0,  35., -35., 10),(1, 485, 2, 6, 0, 3, 1,  3, 2, 0, 0,  35., -34., 10),(1, 486, 2, 6, 0, 3, 1,  4, 2, 0, 0,  35., -30., 10),(1, 487, 2, 6, 0, 3, 1,  5, 2, 0, 0,  35., -24., 10),(1, 488, 2, 6, 0, 3, 1,  6, 0, 0, 3, 100., -14., 10),(1, 489, 2, 6, 0, 3, 1,  6, 0, 0, 2, 100.,   0., 10),(1, 490, 2, 6, 0, 3, 1,  6, 0, 0, 1, 100.,  10., 10),(1, 491, 2, 6, 0, 3, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 492, 2, 6, 0, 3, 1,  8, 0, 0, 3, 100., -17., 10),(1, 493, 2, 6, 0, 3, 1,  8, 0, 0, 2, 100.,   0., 10),(1, 494, 2, 6, 0, 3, 1,  8, 0, 0, 1, 100.,  10., 10),(1, 495, 2, 6, 0, 3, 1,  9, 2, 0, 0,  35., -28., 10),(1, 496, 2, 6, 0, 3, 1, 10, 2, 0, 0,  35., -34., 10),(1, 497, 2, 6, 0, 3, 1, 11, 2, 0, 0,  35., -25., 10),(1, 498, 2, 6, 0, 3, 1, 12, 2, 0, 0,  35., -43., 10),(1, 499, 2, 6, 0, 3, 1, 13, 2, 0, 0,  35., -43., 10),(1, 500, 2, 6, 0, 3, 1, 14, 2, 0, 0,  35., -33., 10),(1, 501, 2, 6, 0, 3, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 502, 2, 6, 0, 4, 0,  2, 2, 0, 0, 100., -30., 10),(1, 503, 2, 6, 0, 4, 0,  4, 2, 0, 0,  35., -33., 10),(1, 504, 2, 6, 0, 4, 0,  5, 2, 0, 0,  35., -26., 10),(1, 505, 2, 6, 0, 4, 0,  6, 0, 0, 0, 100., -16., 10),(1, 506, 2, 6, 0, 4, 0,  7, 1, 1, 0, 300.,  35., 10),(1, 507, 2, 6, 0, 4, 0,  7, 1, 2, 0, 300.,  25., 10),(1, 508, 2, 6, 0, 4, 0,  7, 2, 1, 0, 300.,  28., 10),(1, 509, 2, 6, 0, 4, 0,  7, 2, 2, 0, 300.,  18., 10),(1, 510, 2, 6, 0, 4, 0,  8, 0, 0, 0, 100., -16., 10),(1, 511, 2, 6, 0, 4, 0,  9, 2, 0, 0,  35., -29., 10),(1, 512, 2, 6, 0, 4, 0, 10, 2, 0, 0,  35., -34., 10),(1, 513, 2, 6, 0, 4, 0, 11, 2, 0, 0,  35., -23., 10),(1, 514, 2, 6, 0, 4, 0, 12, 2, 0, 0, 100., -33., 10),(1, 515, 2, 6, 0, 4, 0, 14, 2, 0, 0, 100., -28., 10),(1, 516, 2, 6, 0, 4, 0, 15, 2, 0, 0, 125., -10., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 517, 2, 6, 0, 5, 1,  1, 2, 0, 0,  35., -32., 10),(1, 518, 2, 6, 0, 5, 1,  2, 2, 0, 0,  35., -35., 10),(1, 519, 2, 6, 0, 5, 1,  3, 2, 0, 0,  35., -34., 10),(1, 520, 2, 6, 0, 5, 1,  4, 2, 0, 0,  35., -30., 10),(1, 521, 2, 6, 0, 5, 1,  5, 2, 0, 0,  35., -24., 10),(1, 522, 2, 6, 0, 5, 1,  6, 0, 0, 3, 100., -14., 10),(1, 523, 2, 6, 0, 5, 1,  6, 0, 0, 2, 100.,   0., 10),(1, 524, 2, 6, 0, 5, 1,  6, 0, 0, 1, 100.,  10., 10),(1, 525, 2, 6, 0, 5, 1,  7, 0, 0, 0, 300.,  34., 10),(1, 526, 2, 6, 0, 5, 1,  8, 0, 0, 3, 100., -17., 10),(1, 527, 2, 6, 0, 5, 1,  8, 0, 0, 2, 100.,   0., 10),(1, 528, 2, 6, 0, 5, 1,  8, 0, 0, 1, 100.,  10., 10),(1, 529, 2, 6, 0, 5, 1,  9, 2, 0, 0,  35., -28., 10),(1, 530, 2, 6, 0, 5, 1, 10, 2, 0, 0,  35., -34., 10),(1, 531, 2, 6, 0, 5, 1, 11, 2, 0, 0,  35., -25., 10),(1, 532, 2, 6, 0, 5, 1, 12, 2, 0, 0,  35., -43., 10),(1, 533, 2, 6, 0, 5, 1, 13, 2, 0, 0,  35., -43., 10),(1, 534, 2, 6, 0, 5, 1, 14, 2, 0, 0,  35., -33., 10),(1, 535, 2, 6, 0, 5, 1, 15, 2, 0, 0,  35., -31., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 536, 2, 6, 0, 6, 0,  2, 2, 0, 0, 100., -30., 10),(1, 537, 2, 6, 0, 6, 0,  4, 2, 0, 0,  35., -33., 10),(1, 538, 2, 6, 0, 6, 0,  5, 2, 0, 0,  35., -26., 10),(1, 539, 2, 6, 0, 6, 0,  6, 0, 0, 0, 100., -16., 10),(1, 540, 2, 6, 0, 6, 0,  7, 1, 1, 0, 300.,  35., 10),(1, 541, 2, 6, 0, 6, 0,  7, 1, 2, 0, 300.,  25., 10),(1, 542, 2, 6, 0, 6, 0,  7, 2, 1, 0, 300.,  28., 10),(1, 543, 2, 6, 0, 6, 0,  7, 2, 2, 0, 300.,  18., 10),(1, 544, 2, 6, 0, 6, 0,  8, 0, 0, 0, 100., -16., 10),(1, 545, 2, 6, 0, 6, 0,  9, 2, 0, 0,  35., -29., 10),(1, 546, 2, 6, 0, 6, 0, 10, 2, 0, 0,  35., -34., 10),(1, 547, 2, 6, 0, 6, 0, 11, 2, 0, 0,  35., -23., 10),(1, 548, 2, 6, 0, 6, 0, 12, 2, 0, 0, 100., -33., 10),(1, 549, 2, 6, 0, 6, 0, 14, 2, 0, 0, 100., -28., 10),(1, 550, 2, 6, 0, 6, 0, 15, 2, 0, 0, 125., -10., 10)");
        dbConnection.update("INSERT INTO template_ix_rule SELECT template_key,ix_rule_key + 550,3,service_type_key,signal_type_key,undesired_service_type_key,undesired_signal_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time FROM template_ix_rule WHERE (template_key = 1) AND (service_type_key IN (1,2,3,4,5,6)) AND (country_key = 1)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 851, 1, 21, 0, 21, 0, 24, 0, 0, 0, 300.,  20., 10),(1, 852, 1, 21, 0, 21, 0, 25, 0, 0, 0, 100.,   6., 10),(1, 853, 1, 21, 0, 21, 0, 26, 0, 0, 0,  50., -40., 10),(1, 854, 1, 21, 0, 21, 0, 27, 0, 0, 0,  50., -40., 10),(1, 855, 1, 21, 0, 21, 0, 23, 0, 0, 0, 100.,   6., 10),(1, 856, 1, 21, 0, 21, 0, 22, 0, 0, 0,  50., -40., 10),(1, 857, 1, 21, 0, 21, 0, 21, 0, 0, 0,  50., -40., 10),(1, 858, 1, 21, 0, 21, 0, 28, 0, 0, 0,  50.,   0., 10),(1, 859, 1, 21, 0, 21, 0, 29, 0, 0, 0,  50.,   0., 10),(1, 860, 1, 21, 0, 21, 0, 20, 0, 0, 0,  50.,   0., 10),(1, 861, 1, 21, 0, 21, 0, 19, 0, 0, 0,  50.,   0., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 862, 1, 21, 0, 22, 0, 24, 0, 0, 0, 300.,  20., 10),(1, 863, 1, 21, 0, 22, 0, 25, 0, 0, 0, 100.,   6., 10),(1, 864, 1, 21, 0, 22, 0, 26, 0, 0, 0,  50., -40., 10),(1, 865, 1, 21, 0, 22, 0, 27, 0, 0, 0,  50., -40., 10),(1, 866, 1, 21, 0, 22, 0, 23, 0, 0, 0, 100.,   6., 10),(1, 867, 1, 21, 0, 22, 0, 22, 0, 0, 0,  50., -40., 10),(1, 868, 1, 21, 0, 22, 0, 21, 0, 0, 0,  50., -40., 10),(1, 869, 1, 21, 0, 22, 0, 28, 0, 0, 0,  50.,   0., 10),(1, 870, 1, 21, 0, 22, 0, 29, 0, 0, 0,  50.,   0., 10),(1, 871, 1, 21, 0, 22, 0, 20, 0, 0, 0,  50.,   0., 10),(1, 872, 1, 21, 0, 22, 0, 19, 0, 0, 0,  50.,   0., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 873, 1, 21, 0, 23, 0, 24, 0, 0, 0, 300.,  20., 10),(1, 874, 1, 21, 0, 23, 0, 25, 0, 0, 0, 100.,   6., 10),(1, 875, 1, 21, 0, 23, 0, 26, 0, 0, 0,  50., -40., 10),(1, 876, 1, 21, 0, 23, 0, 27, 0, 0, 0,  50., -40., 10),(1, 877, 1, 21, 0, 23, 0, 23, 0, 0, 0, 100.,   6., 10),(1, 878, 1, 21, 0, 23, 0, 22, 0, 0, 0,  50., -40., 10),(1, 879, 1, 21, 0, 23, 0, 21, 0, 0, 0,  50., -40., 10),(1, 880, 1, 21, 0, 23, 0, 28, 0, 0, 0,  50.,   0., 10),(1, 881, 1, 21, 0, 23, 0, 29, 0, 0, 0,  50.,   0., 10),(1, 882, 1, 21, 0, 23, 0, 20, 0, 0, 0,  50.,   0., 10),(1, 883, 1, 21, 0, 23, 0, 19, 0, 0, 0,  50.,   0., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 884, 1, 22, 0, 21, 0, 24, 0, 0, 0, 300.,  20., 10),(1, 885, 1, 22, 0, 21, 0, 25, 0, 0, 0, 100.,   6., 10),(1, 886, 1, 22, 0, 21, 0, 26, 0, 0, 0,  50., -40., 10),(1, 887, 1, 22, 0, 21, 0, 27, 0, 0, 0,  50., -40., 10),(1, 888, 1, 22, 0, 21, 0, 23, 0, 0, 0, 100.,   6., 10),(1, 889, 1, 22, 0, 21, 0, 22, 0, 0, 0,  50., -40., 10),(1, 890, 1, 22, 0, 21, 0, 21, 0, 0, 0,  50., -40., 10),(1, 891, 1, 22, 0, 21, 0, 28, 0, 0, 0,  50.,   0., 10),(1, 892, 1, 22, 0, 21, 0, 29, 0, 0, 0,  50.,   0., 10),(1, 893, 1, 22, 0, 21, 0, 20, 0, 0, 0,  50.,   0., 10),(1, 894, 1, 22, 0, 21, 0, 19, 0, 0, 0,  50.,   0., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 895, 1, 22, 0, 22, 0, 24, 0, 0, 0, 300.,  20., 10),(1, 896, 1, 22, 0, 22, 0, 25, 0, 0, 0, 100.,   6., 10),(1, 897, 1, 22, 0, 22, 0, 26, 0, 0, 0,  50., -40., 10),(1, 898, 1, 22, 0, 22, 0, 27, 0, 0, 0,  50., -40., 10),(1, 899, 1, 22, 0, 22, 0, 23, 0, 0, 0, 100.,   6., 10),(1, 900, 1, 22, 0, 22, 0, 22, 0, 0, 0,  50., -40., 10),(1, 901, 1, 22, 0, 22, 0, 21, 0, 0, 0,  50., -40., 10),(1, 902, 1, 22, 0, 22, 0, 28, 0, 0, 0,  50.,   0., 10),(1, 903, 1, 22, 0, 22, 0, 29, 0, 0, 0,  50.,   0., 10),(1, 904, 1, 22, 0, 22, 0, 20, 0, 0, 0,  50.,   0., 10),(1, 905, 1, 22, 0, 22, 0, 19, 0, 0, 0,  50.,   0., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 906, 1, 22, 0, 23, 0, 24, 0, 0, 0, 300.,  20., 10),(1, 907, 1, 22, 0, 23, 0, 25, 0, 0, 0, 100.,   6., 10),(1, 908, 1, 22, 0, 23, 0, 26, 0, 0, 0,  50., -40., 10),(1, 909, 1, 22, 0, 23, 0, 27, 0, 0, 0,  50., -40., 10),(1, 910, 1, 22, 0, 23, 0, 23, 0, 0, 0, 100.,   6., 10),(1, 911, 1, 22, 0, 23, 0, 22, 0, 0, 0,  50., -40., 10),(1, 912, 1, 22, 0, 23, 0, 21, 0, 0, 0,  50., -40., 10),(1, 913, 1, 22, 0, 23, 0, 28, 0, 0, 0,  50.,   0., 10),(1, 914, 1, 22, 0, 23, 0, 29, 0, 0, 0,  50.,   0., 10),(1, 915, 1, 22, 0, 23, 0, 20, 0, 0, 0,  50.,   0., 10),(1, 916, 1, 22, 0, 23, 0, 19, 0, 0, 0,  50.,   0., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 917, 1, 23, 0, 21, 0, 24, 0, 0, 0, 300.,  20., 10),(1, 918, 1, 23, 0, 21, 0, 25, 0, 0, 0, 100.,   6., 10),(1, 919, 1, 23, 0, 21, 0, 26, 0, 0, 0,  50., -40., 10),(1, 920, 1, 23, 0, 21, 0, 27, 0, 0, 0,  50., -40., 10),(1, 921, 1, 23, 0, 21, 0, 23, 0, 0, 0, 100.,   6., 10),(1, 922, 1, 23, 0, 21, 0, 22, 0, 0, 0,  50., -40., 10),(1, 923, 1, 23, 0, 21, 0, 21, 0, 0, 0,  50., -40., 10),(1, 924, 1, 23, 0, 21, 0, 28, 0, 0, 0,  50.,   0., 10),(1, 925, 1, 23, 0, 21, 0, 29, 0, 0, 0,  50.,   0., 10),(1, 926, 1, 23, 0, 21, 0, 20, 0, 0, 0,  50.,   0., 10),(1, 927, 1, 23, 0, 21, 0, 19, 0, 0, 0,  50.,   0., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 928, 1, 23, 0, 22, 0, 24, 0, 0, 0, 300.,  20., 10),(1, 929, 1, 23, 0, 22, 0, 25, 0, 0, 0, 100.,   6., 10),(1, 930, 1, 23, 0, 22, 0, 26, 0, 0, 0,  50., -40., 10),(1, 931, 1, 23, 0, 22, 0, 27, 0, 0, 0,  50., -40., 10),(1, 932, 1, 23, 0, 22, 0, 23, 0, 0, 0, 100.,   6., 10),(1, 933, 1, 23, 0, 22, 0, 22, 0, 0, 0,  50., -40., 10),(1, 934, 1, 23, 0, 22, 0, 21, 0, 0, 0,  50., -40., 10),(1, 935, 1, 23, 0, 22, 0, 28, 0, 0, 0,  50.,   0., 10),(1, 936, 1, 23, 0, 22, 0, 29, 0, 0, 0,  50.,   0., 10),(1, 937, 1, 23, 0, 22, 0, 20, 0, 0, 0,  50.,   0., 10),(1, 938, 1, 23, 0, 22, 0, 19, 0, 0, 0,  50.,   0., 10)");
        dbConnection.update("INSERT INTO template_ix_rule VALUES (1, 939, 1, 23, 0, 23, 0, 24, 0, 0, 0, 300.,  20., 10),(1, 940, 1, 23, 0, 23, 0, 25, 0, 0, 0, 100.,   6., 10),(1, 941, 1, 23, 0, 23, 0, 26, 0, 0, 0,  50., -40., 10),(1, 942, 1, 23, 0, 23, 0, 27, 0, 0, 0,  50., -40., 10),(1, 943, 1, 23, 0, 23, 0, 23, 0, 0, 0, 100.,   6., 10),(1, 944, 1, 23, 0, 23, 0, 22, 0, 0, 0,  50., -40., 10),(1, 945, 1, 23, 0, 23, 0, 21, 0, 0, 0,  50., -40., 10),(1, 946, 1, 23, 0, 23, 0, 28, 0, 0, 0,  50.,   0., 10),(1, 947, 1, 23, 0, 23, 0, 29, 0, 0, 0,  50.,   0., 10),(1, 948, 1, 23, 0, 23, 0, 20, 0, 0, 0,  50.,   0., 10),(1, 949, 1, 23, 0, 23, 0, 19, 0, 0, 0,  50.,   0., 10)");
        dbConnection.update("INSERT INTO template_ix_rule SELECT template_key,ix_rule_key + 99,2,service_type_key,signal_type_key,undesired_service_type_key,undesired_signal_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time FROM template_ix_rule WHERE (template_key = 1) AND (service_type_key IN (21,22,23)) AND (country_key = 1)");
        dbConnection.update("INSERT INTO template_ix_rule SELECT template_key,ix_rule_key + 198,3,service_type_key,signal_type_key,undesired_service_type_key,undesired_signal_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time FROM template_ix_rule WHERE (template_key = 1) AND (service_type_key IN (21,22,23)) AND (country_key = 1)");
        dbConnection.update("DELETE FROM parameter_group");
        dbConnection.update("DELETE FROM parameter");
        dbConnection.update("DELETE FROM template_parameter_data WHERE template_key = 1");
        dbConnection.update("DELETE FROM parameter_study_type");
        dbConnection.update("INSERT INTO parameter_group VALUES (13, 1, 'Analysis', 0),(2, 2, 'CDBS/LMS', 0),(11, 3, 'Search', 0),(4, 4, 'Contours', 0),(14, 5, 'FCC Contours', 0),(16, 6, 'L-R Contours', 0),(5, 7, 'TV Replication', 0),(3, 8, 'Patterns', 0),(6, 9, 'Propagation', 0),(7, 10, 'Service', 309),(8, 11, 'Clutter', 249),(12, 12, 'TV IX Check', 0),(9, 13, 'Wireless', 0),(10, 14, 'TV6 <-> FM', 0),(15, 15, 'Scenario', 0)");
        dbConnection.update("INSERT INTO parameter VALUES (2, 13, 1, 'Grid type', 'pickfrom:1:Local:2:Global', '', '', '<HTML>Type of study cell grid:<BR>Local - Each station has an independent grid used only for that station.<BR>Global - A single uniform grid is shared by all stations.</HTML>', false),(4, 13, 2, 'Cell size', 'decimal:0.1:10', 'km', '', '<HTML>Target edge size of study grid cells.<BR>Actual size will vary, cell dimensions are always integral arc-seconds.</HTML>', false),(5, 13, 3, 'Study point location', 'pickfrom:1:Population centroid:2:Cell center:3:Largest population:4:All population:5:Highest elevation', '', '', '<HTML>Method for defining study point location in each grid cell:<BR>Population centroid - Point located at the population-weighted centroid of all census points in the cell.<BR>Cell center - Point located at the geographic center of the cell.<BR>Largest population - Point at the location of the census point with the largest population in the cell.<BR>All population - Every census point creates a study point with cell area proportioned by population.<BR>Highest elevation - Point of highest terrain elevation in the cell.</HTML>', false),(6, 13, 4, 'Move study point to nearest census point', 'option', '', '', '<HTML>For centroid and center methods, use the location of the census point nearest to the centroid or center.</HTML>', false),(40, 13, 5, 'U.S. population', 'pickfrom:2020:2020:2010:2010:2000:2000:0:None', '', '', '<HTML>U.S. census population database.<BR>If \"None\" is selected, area will also not be reported separately.</HTML>', false),(42, 13, 6, 'Canadian population', 'pickfrom:2021:2021:2016:2016:2011:2011:2006:2006:0:None', '', '', '<HTML>Canadian census population database.<BR>If \"None\" is selected, area will also not be reported separately.</HTML>', false),(44, 13, 7, 'Mexican population', 'pickfrom:2020:2020:2010:2010:0:None', '', '', '<HTML>Mexican census population database.<BR>If \"None\" is selected, area will also not be reported separately.</HTML>', false),(46, 13, 8, 'Round population coordinates', 'option', '', 'U.S.:Canada:Mexico', '<HTML>Round all census centroid coordinates to the nearest integer arc-second.</HTML>', false),(199, 13, 9, 'Default service area method', 'pickfrom:1:FCC curves:8:FCC plus distance:9:FCC plus percent:2:Longley-Rice percent above:3:Longley-Rice length above:4:Longley-Rice length below:11:Longley-Rice line fit:10:Constant distance', '', 'U.S.:Canada:Mexico', '<HTML>Default method for determining service areas for TV and FM stations:<BR>FCC curves - Signal level contour using FCC propagation curves and all other parameters in this section.<BR>FCC curves plus distance - FCC curves contour plus an additional distance on each radial.<BR>FCC curves plus percent - FCC curves contour plus an additional percentage on each radial.<BR>Longley-Rice percent above - Contour based on Longley-Rice propagation, greatest distance at which specified percentage of preceding points along radial are above the contour level.<BR>Longley-Rice length above - Distance at which all following contiguous runs of points above contour level are shorter than specified length.<BR>Longley-Rice length below - Distance at which all preceding contiguous runs of points below contour level are shorter than specified length.<BR>Longley-Rice line fit: Distance at which a straight-line fit to preceding points, using least-squares method, crosses the contour level.<BR>Constant distance - Fixed-radius circle around station location.</HTML>', false),(201, 13, 10, 'Distance or percent for default method', 'decimal:0:500', 'km or %', 'U.S.:Canada:Mexico', '<HTML>Distance, run length, or percentage to use with contour method selected above.</HTML>', false),(215, 13, 11, 'Maximum desired signal distance', 'decimal:100:500', 'km', '', '<HTML>Maximum station-to-point distance for desired signal analysis in all modes.<BR>Restricts the maximum size of a Longley-Rice contour, also sets maximum calculation distance in unrestricted grid mode or points mode.</HTML>', false),(306, 13, 12, 'Cap TV D/U ramp function', 'option', '', '', '<HTML>Set a cap on the amount by which the required D/U for co-channel TV interference to digital TV is increased as the desired signal nears the service threshold.</HTML>', false),(307, 13, 13, 'TV D/U ramp function cap', 'decimal:0:36.4', 'dB', '', '<HTML>Cap value for digital TV co-channel D/U adjustment.</HTML>', false),(248, 13, 14, 'Adjust FM D/U for IBOC', 'option', '', '', '<HTML>Adjust FM adjacent-channel required D/U when undesired station is operating IBOC digital.</HTML>', false),(193, 13, 15, 'Include DTS self-interference', 'option', '', '', '<HTML>Evaluate self-interference in a DTS operation.</HTML>', false),(194, 13, 16, 'Propagation speed', 'decimal:0.28:0.3', 'km/\u00b5S', '', '<HTML>Signal propagation speed for DTS arrival time calculation, in kilometers per microsecond.</HTML>', false),(195, 13, 17, 'Pre-arrival time limit', 'decimal:-400:0', '\u00b5S', '', '<HTML>Maximum time difference for no DTS self-interference when undesired arrives before desired, in microseconds.</HTML>', false),(196, 13, 18, 'Post-arrival time limit', 'decimal:0:400', '\u00b5S', '', '<HTML>Maximum time difference for no DTS self-interference when undesired arrives after desired, in microseconds.</HTML>', false),(197, 13, 19, 'Required D/U', 'decimal:-50:50', 'dB', '', '<HTML>Required D/U for no DTS self-interference when outside the arrival time window.</HTML>', false),(154, 13, 20, 'Undesired % time', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model percent time for self-interference undesired signals.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 2, 0, '2'),(1, 4, 0, '2'),(1, 5, 0, '1'),(1, 6, 0, '0'),(1, 40, 0, '2020'),(1, 42, 0, '2021'),(1, 44, 0, '2020'),(1, 46, 0, '0'),(1, 46, 1, '0'),(1, 46, 2, '0'),(1, 199, 0, '1'),(1, 199, 1, '1'),(1, 199, 2, '1'),(1, 201, 0, '0'),(1, 201, 1, '0'),(1, 201, 2, '0'),(1, 215, 0, '300'),(1, 306, 0, '0'),(1, 307, 0, '8'),(1, 248, 0, '0'),(1, 193, 0, '0'),(1, 194, 0, '0.2997915'),(1, 195, 0, '-60'),(1, 196, 0, '60'),(1, 197, 0, '15'),(1, 154, 0, '10')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (2, 1),(2, 2),(4, 1),(4, 2),(4, 3),(4, 4),(4, 5),(5, 1),(5, 2),(5, 3),(5, 4),(5, 5),(6, 1),(6, 2),(6, 3),(6, 4),(6, 5),(40, 1),(40, 2),(40, 3),(40, 4),(40, 5),(42, 1),(42, 2),(42, 3),(42, 4),(42, 5),(44, 1),(44, 2),(44, 3),(44, 4),(44, 5),(46, 1),(46, 2),(199, 1),(199, 2),(199, 3),(199, 4),(199, 5),(201, 1),(201, 2),(201, 3),(201, 4),(201, 5),(215, 1),(215, 2),(215, 3),(215, 4),(215, 5),(306, 1),(306, 2),(306, 3),(306, 5),(307, 1),(307, 2),(307, 3),(307, 5),(248, 4),(248, 5),(193, 1),(193, 2),(193, 3),(193, 5),(194, 1),(194, 2),(194, 3),(194, 5),(195, 1),(195, 2),(195, 3),(195, 5),(196, 1),(196, 2),(196, 3),(196, 5),(197, 1),(197, 2),(197, 3),(197, 5),(154, 1),(154, 2),(154, 3),(154, 5)");
        dbConnection.update("INSERT INTO parameter VALUES (18, 2, 1, 'Respect DA flag', 'option', '', '', '<HTML>Use directional pattern data only if the DA indicator flag is set.<BR>If not selected, pattern data is used if present regardless of the flag.</HTML>', false),(334, 2, 2, 'HAAT radial count', 'integer:4:360', '', 'U.S.:Canada:Mexico', '<HTML>Number of radials used to calculate HAAT when deriving AMSL height or verifying database HAAT for TV and FM stations.</HTML>', false),(220, 2, 3, 'Mexican TV digital ERP, VHF low', 'decimal:1:2000', 'kW', '', '<HTML>Default for Mexican full-service TV records with missing data, ERP for digital VHF low band.</HTML>', false),(221, 2, 4, 'Mexican TV digital HAAT, VHF low', 'decimal:30:800', 'm', '', '<HTML>Default for Mexican full-service TV records with missing data, HAAT for digital VHF low band.</HTML>', false),(222, 2, 5, 'Mexican TV digital ERP, VHF high', 'decimal:1:2000', 'kw', '', '<HTML>Default for Mexican full-service TV records with missing data, ERP for digital VHF high band.</HTML>', false),(223, 2, 6, 'Mexican TV digital HAAT, VHF high', 'decimal:30:800', 'm', '', '<HTML>Default for Mexican full-service TV records with missing data, HAAT for digital VHF high band.</HTML>', false),(224, 2, 7, 'Mexican TV digital ERP, UHF', 'decimal:1:2000', 'kW', '', '<HTML>Default for Mexican full-service TV records with missing data, ERP for digital UHF.</HTML>', false),(225, 2, 8, 'Mexican TV digital HAAT, UHF', 'decimal:30:800', 'm', '', '<HTML>Default for Mexican full-service TV records with missing data, HAAT for digital UHF.</HTML>', false),(226, 2, 9, 'Mexican TV analog ERP, VHF low', 'decimal:1:6000', 'kW', '', '<HTML>Default for Mexican full-service TV records with missing data, ERP for analog VHF low band.</HTML>', false),(227, 2, 10, 'Mexican TV analog HAAT, VHF low', 'decimal:30:800', 'm', '', '<HTML>Default for Mexican full-service TV records with missing data, HAAT for analog VHF low band.</HTML>', false),(228, 2, 11, 'Mexican TV analog ERP, VHF high', 'decimal:1:6000', 'kW', '', '<HTML>Default for Mexican full-service TV records with missing data, ERP for analog VHF high band.</HTML>', false),(229, 2, 12, 'Mexican TV analog HAAT, VHF high', 'decimal:30:800', 'm', '', '<HTML>Default for Mexican full-service TV records with missing data, HAAT for analog VHF high band.</HTML>', false),(230, 2, 13, 'Mexican TV analog ERP, UHF', 'decimal:1:6000', 'kW', '', '<HTML>Default for Mexican full-service TV records with missing data, ERP for analog UHF.</HTML>', false),(231, 2, 14, 'Mexican TV analog HAAT, UHF', 'decimal:30:800', 'm', '', '<HTML>Default for Mexican full-service TV records with missing data, HAAT for analog UHF.</HTML>', false),(324, 2, 15, 'First TV channel', 'integer:2:69', '', '', '<HTML>Lowest allowed TV channel number, database records below this are ignored.</HTML>', false),(325, 2, 16, 'Last TV channel', 'integer:2:69', '', '', '<HTML>Highest allowed TV channel number, database records above this are ignored.</HTML>', false),(232, 2, 17, 'Mexican FM ERP, class A', 'decimal:1:200', 'kW', '', '<HTML>Default for Mexican full-service FM records with missing data, ERP for class A.</HTML>', false),(233, 2, 18, 'Mexican FM HAAT, class A', 'decimal:30:800', 'm', '', '<HTML>Default for Mexican full-service FM records with missing data, HAAT for class A.</HTML>', false),(234, 2, 19, 'Mexican FM ERP, class B', 'decimal:1:200', 'kW', '', '<HTML>Default for Mexican full-service FM records with missing data, ERP for class B.</HTML>', false),(235, 2, 20, 'Mexican FM HAAT, class B', 'decimal:30:800', 'm', '', '<HTML>Default for Mexican full-service FM records with missing data, HAAT for class B.</HTML>', false),(236, 2, 21, 'Mexican FM ERP, class B1', 'decimal:1:200', 'kW', '', '<HTML>Default for Mexican full-service FM records with missing data, ERP for class B1.</HTML>', false),(237, 2, 22, 'Mexican FM HAAT, class B1', 'decimal:30:800', 'm', '', '<HTML>Default for Mexican full-service FM records with missing data, HAAT for class B1.</HTML>', false),(238, 2, 23, 'Mexican FM ERP, class C', 'decimal:1:200', 'kW', '', '<HTML>Default for Mexican full-service FM records with missing data, ERP for class C.</HTML>', false),(239, 2, 24, 'Mexican FM HAAT, class C', 'decimal:30:800', 'm', '', '<HTML>Default for Mexican full-service FM records with missing data, HAAT for class C.</HTML>', false),(240, 2, 25, 'Mexican FM ERP, class C1', 'decimal:1:200', 'kW', '', '<HTML>Default for Mexican full-service FM records with missing data, ERP for class C1.</HTML>', false),(241, 2, 26, 'Mexican FM HAAT, class C1', 'decimal:30:800', 'm', '', '<HTML>Default for Mexican full-service FM records with missing data, HAAT for class C1.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 18, 0, '0'),(1, 334, 0, '8'),(1, 334, 1, '8'),(1, 334, 2, '8'),(1, 220, 0, '45'),(1, 221, 0, '305'),(1, 222, 0, '160'),(1, 223, 0, '305'),(1, 224, 0, '1000'),(1, 225, 0, '365'),(1, 226, 0, '100'),(1, 227, 0, '305'),(1, 228, 0, '316'),(1, 229, 0, '305'),(1, 230, 0, '5000'),(1, 231, 0, '610'),(1, 324, 0, '2'),(1, 325, 0, '69'),(1, 232, 0, '6'),(1, 233, 0, '100'),(1, 234, 0, '50'),(1, 235, 0, '150'),(1, 236, 0, '25'),(1, 237, 0, '100'),(1, 238, 0, '100'),(1, 239, 0, '600'),(1, 240, 0, '100'),(1, 241, 0, '299')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (18, 1),(18, 2),(18, 3),(18, 4),(18, 5),(334, 1),(334, 2),(334, 3),(334, 4),(334, 5),(220, 1),(220, 2),(220, 3),(220, 5),(221, 1),(221, 2),(221, 3),(221, 5),(222, 1),(222, 2),(222, 3),(222, 5),(223, 1),(223, 2),(223, 3),(223, 5),(224, 1),(224, 2),(224, 3),(224, 5),(225, 1),(225, 2),(225, 3),(225, 5),(226, 1),(226, 2),(226, 3),(226, 5),(227, 1),(227, 2),(227, 3),(227, 5),(228, 1),(228, 2),(228, 3),(228, 5),(229, 1),(229, 2),(229, 3),(229, 5),(230, 1),(230, 2),(230, 3),(230, 5),(231, 1),(231, 2),(231, 3),(231, 5),(324, 1),(324, 2),(324, 3),(324, 5),(325, 1),(325, 2),(325, 3),(325, 5),(232, 4),(232, 5),(233, 4),(233, 5),(234, 4),(234, 5),(235, 4),(235, 5),(236, 4),(236, 5),(237, 4),(237, 5),(238, 4),(238, 5),(239, 4),(239, 5),(240, 4),(240, 5),(241, 4),(241, 5)");
        dbConnection.update("INSERT INTO parameter VALUES (326, 11, 1, 'Check individual DTS transmitter distances', 'option', '', '', '<HTML>For distance checks involving a DTS station, use the coordinates of the nearest individal DTS transmitter.<BR>When not selected, distance checks always use the DTS reference point coordinates.</HTML>', false),(212, 11, 2, 'Co-channel MX distance', 'decimal:0:100', 'km', '', '<HTML>Distance within which co-channel stations are considered mutually-exclusive regardless of other conditions.<BR>Set this to 0 to disable the co-channel distance check.</HTML>', false),(335, 11, 3, 'Rule limit extra distance less than low ERP', 'decimal:50:200', 'km', '', '<HTML>Extra distance added to interference rule limits for station-to-station distance checks.<BR>Undesired stations beyond the distance are not checked for station-to-cell distance.<BR>Distance varies with peak ERP, enter distances and ERPs in following parameters.<BR>ERPs apply to full-service UHF digital, other cases are derived using differences in service contour levels.</HTML>', false),(336, 11, 4, 'Rule limit low ERP', 'decimal:0.001:1000', 'kW', '', '<HTML>See above.</HTML>', false),(337, 11, 5, 'Rule limit extra distance low to medium ERP', 'decimal:50:200', 'km', '', '<HTML>See above.</HTML>', false),(338, 11, 6, 'Rule limit medium ERP', 'decimal:0.001:1000', 'kW', '', '<HTML>See above.</HTML>', false),(339, 11, 7, 'Rule limit extra distance medium to high ERP', 'decimal:50:200', 'km', '', '<HTML>See above.</HTML>', false),(340, 11, 8, 'Rule limit high ERP', 'decimal:0.001:1000', 'kW', '', '<HTML>See above.</HTML>', false),(210, 11, 9, 'Rule limit extra distance greater than high ERP', 'decimal:50:200', 'km', '', '<HTML>See above.</HTML>', false),(189, 11, 10, 'Use maximum signal distance as rule extra', 'option', '', '', '<HTML>Use the maximum desired signal calculation distance as the rule limit extra for all conditions, ignore other parameters.</HTML>', false),(200, 11, 11, 'Spherical earth distance', 'decimal:110:112', 'km/deg', '', '<HTML>Spherical earth surface distance in kilometers per degree of arc length.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 326, 0, '0'),(1, 212, 0, '5'),(1, 335, 0, '80'),(1, 336, 0, '0.2'),(1, 337, 0, '100'),(1, 338, 0, '1.5'),(1, 339, 0, '130'),(1, 340, 0, '15'),(1, 210, 0, '178'),(1, 189, 0, '0'),(1, 200, 0, '111.15')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (326, 1),(326, 2),(326, 3),(326, 5),(212, 1),(212, 2),(212, 3),(212, 4),(212, 5),(335, 1),(335, 2),(335, 3),(335, 4),(335, 5),(336, 1),(336, 2),(336, 3),(336, 4),(336, 5),(337, 1),(337, 2),(337, 3),(337, 4),(337, 5),(338, 1),(338, 2),(338, 3),(338, 4),(338, 5),(339, 1),(339, 2),(339, 3),(339, 4),(339, 5),(340, 1),(340, 2),(340, 3),(340, 4),(340, 5),(210, 1),(210, 2),(210, 3),(210, 4),(210, 5),(189, 1),(189, 2),(189, 3),(189, 4),(189, 5),(200, 1),(200, 2),(200, 3),(200, 4),(200, 5)");
        dbConnection.update("INSERT INTO parameter VALUES (122, 4, 1, 'Contour radial count', 'integer:4:360', '', 'U.S.:Canada:Mexico', '<HTML>Number of radials to use for contour projections.</HTML>', false),(80, 4, 2, 'Digital TV full-service contour, VHF low', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, digital full-service VHF low band.</HTML>', false),(82, 4, 3, 'Digital TV full-service contour, VHF high', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, digital full-service VHF high band.</HTML>', false),(84, 4, 4, 'Digital TV full-service contour, UHF', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, digital full-service UHF (may be dipole-adjusted).</HTML>', false),(86, 4, 5, 'Digital TV Class A/LPTV contour, VHF low', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, digital LPTV/Class A VHF low band.</HTML>', false),(88, 4, 6, 'Digital TV Class A/LPTV contour, VHF high', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, digital LPTV/Class A VHF high band.</HTML>', false),(90, 4, 7, 'Digital TV Class A/LPTV contour, UHF', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, digital LPTV/Class A UHF (may be dipole-adjusted).</HTML>', false),(92, 4, 8, 'Analog TV full-service contour, VHF low', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, analog full-service VHF low band.</HTML>', false),(94, 4, 9, 'Analog TV full-service contour, VHF high', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, analog full-service VHF high band.</HTML>', false),(96, 4, 10, 'Analog TV full-service contour, UHF', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, analog full-service UHF (may be dipole-adjusted).</HTML>', false),(98, 4, 11, 'Analog TV Class A/LPTV contour, VHF low', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, analog LPTV/Class A VHF low band.</HTML>', false),(100, 4, 12, 'Analog TV Class A/LPTV contour, VHF high', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, analog LPTV/Class A VHF high band.</HTML>', false),(102, 4, 13, 'Analog TV Class A/LPTV contour, UHF', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, analog LPTV/Class A UHF (may be dipole-adjusted).</HTML>', false),(104, 4, 14, 'Use UHF dipole adjustment', 'option', '', 'U.S.:Canada:Mexico', '<HTML>Apply dipole adjustment to TV UHF contour levels.</HTML>', false),(106, 4, 15, 'Dipole center frequency', 'decimal:470:700', 'MHz', 'U.S.:Canada:Mexico', '<HTML>Center frequency for dipole adjustment of TV UHF contour levels.</HTML>', false),(357, 4, 16, 'FM full-service contour', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, FM full-service for most commercial-band classes.</HTML>', false),(358, 4, 17, 'FM full-service contour, class B', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, FM full-service class B.</HTML>', false),(359, 4, 18, 'FM full-service contour, class B1', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, FM full-service class B1.</HTML>', false),(360, 4, 19, 'FM NCE contour', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, FM non-commercial/educational band.</HTML>', false),(361, 4, 20, 'LPFM contour', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, low-power FM.</HTML>', false),(362, 4, 21, 'FM translator contour', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Contour level, FM translator.</HTML>', false),(124, 4, 22, 'TV contour maximum distance, VHF low', 'decimal:0:200', 'km', 'U.S.:Canada:Mexico', '<HTML>Maximum contour distance for TV, VHF low band and FM.  Use 0 for no limit.</HTML>', false),(126, 4, 23, 'TV contour maximum distance, VHF high', 'decimal:0:200', 'km', 'U.S.:Canada:Mexico', '<HTML>Maximum contour distance for TV, VHF high band.  Use 0 for no limit.</HTML>', false),(128, 4, 24, 'TV contour maximum distance, UHF', 'decimal:0:200', 'km', 'U.S.:Canada:Mexico', '<HTML>Maximum contour distance for TV, UHF.  Use 0 for no limit.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 122, 0, '360'),(1, 122, 1, '360'),(1, 122, 2, '360'),(1, 80, 0, '28'),(1, 80, 1, '28'),(1, 80, 2, '28'),(1, 82, 0, '36'),(1, 82, 1, '36'),(1, 82, 2, '36'),(1, 84, 0, '41'),(1, 84, 1, '41'),(1, 84, 2, '41'),(1, 86, 0, '43'),(1, 86, 1, '43'),(1, 86, 2, '43'),(1, 88, 0, '48'),(1, 88, 1, '48'),(1, 88, 2, '48'),(1, 90, 0, '51'),(1, 90, 1, '51'),(1, 90, 2, '51'),(1, 92, 0, '47'),(1, 92, 1, '47'),(1, 92, 2, '47'),(1, 94, 0, '56'),(1, 94, 1, '56'),(1, 94, 2, '56'),(1, 96, 0, '64'),(1, 96, 1, '64'),(1, 96, 2, '64'),(1, 98, 0, '62'),(1, 98, 1, '62'),(1, 98, 2, '62'),(1, 100, 0, '68'),(1, 100, 1, '68'),(1, 100, 2, '68'),(1, 102, 0, '74'),(1, 102, 1, '74'),(1, 102, 2, '74'),(1, 104, 0, '1'),(1, 104, 1, '1'),(1, 104, 2, '0'),(1, 106, 0, '615'),(1, 106, 1, '615'),(1, 106, 2, '615'),(1, 357, 0, '60'),(1, 357, 1, '60'),(1, 357, 2, '60'),(1, 358, 0, '54'),(1, 358, 1, '54'),(1, 358, 2, '54'),(1, 359, 0, '57'),(1, 359, 1, '57'),(1, 359, 2, '57'),(1, 360, 0, '60'),(1, 360, 1, '60'),(1, 360, 2, '60'),(1, 361, 0, '60'),(1, 361, 1, '60'),(1, 361, 2, '60'),(1, 362, 0, '60'),(1, 362, 1, '60'),(1, 362, 2, '60'),(1, 124, 0, '0'),(1, 124, 1, '0'),(1, 124, 2, '0'),(1, 126, 0, '0'),(1, 126, 1, '0'),(1, 126, 2, '0'),(1, 128, 0, '0'),(1, 128, 1, '0'),(1, 128, 2, '0')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (122, 1),(122, 2),(122, 3),(122, 4),(122, 5),(80, 1),(80, 2),(80, 3),(80, 5),(82, 1),(82, 2),(82, 3),(82, 5),(84, 1),(84, 2),(84, 3),(84, 5),(86, 1),(86, 2),(86, 3),(86, 5),(88, 1),(88, 2),(88, 3),(88, 5),(90, 1),(90, 2),(90, 3),(90, 5),(92, 1),(92, 2),(92, 3),(92, 5),(94, 1),(94, 2),(94, 3),(94, 5),(96, 1),(96, 2),(96, 3),(96, 5),(98, 1),(98, 2),(98, 3),(98, 5),(100, 1),(100, 2),(100, 3),(100, 5),(102, 1),(102, 2),(102, 3),(102, 5),(104, 1),(104, 2),(104, 3),(104, 5),(106, 1),(106, 2),(106, 3),(106, 5),(357, 4),(357, 5),(358, 4),(358, 5),(359, 4),(359, 5),(360, 4),(360, 5),(361, 4),(361, 5),(362, 4),(362, 5),(124, 1),(124, 2),(124, 3),(124, 5),(126, 1),(126, 2),(126, 3),(126, 5),(128, 1),(128, 2),(128, 3),(128, 5)");
        dbConnection.update("INSERT INTO parameter VALUES (20, 14, 1, 'Average terrain database', 'pickfrom:0:1/3-second:1:1-second:2:3-second:3:30-second', '', '', '<HTML>Terrain database for average terrain calculations.</HTML>', false),(22, 14, 2, 'Average terrain profile resolution', 'decimal:1:50:1', 'pts/km', 'U.S.:Canada:Mexico', '<HTML>Profile resolution in points per kilometer for average terrain calculations for TV and FM stations.</HTML>', false),(333, 14, 3, 'Use elevation patterns', 'pickfrom:0:Never:1:Full-service TV only:2:All stations', '', 'U.S.:Canada:Mexico', '<HTML>Determines when FCC contour distance projection is adjusted by an elevation pattern.</HTML>', false),(17, 14, 4, 'Use real elevation patterns', 'option', '', 'U.S.:Canada:Mexico', '<HTML>Use real elevation patterns when available for projecting FCC contours.<BR>If not selected, contour projection may use generic patterns, or no elevation pattern, per other settings.<HTML>', false),(202, 14, 5, 'Derive azimuth pattern', 'pickfrom:0:No:1:At horizontal:2:At radio horizon', '', 'U.S.:Canada:Mexico', '<HTML>Project FCC contours using an azimuth pattern derived from actual azimuth<BR>and elevation patterns and beam tilt parameters. This will be done only when a record<BR>has a real elevation pattern and mechanical beam tilt, or has a matrix elevation pattern.<BR>When selected and conditions apply, other elevation pattern settings are ignored.</HTML>', false),(107, 14, 6, 'FCC curve set, TV digital', 'pickfrom:1:F(50,50):2:F(50,10):3:F(50,90)', '', 'U.S.:Canada:Mexico', '<HTML>FCC propagation curve set for TV digital contour projection.</HTML>', false),(108, 14, 7, 'FCC curve set, TV analog', 'pickfrom:1:F(50,50):2:F(50,10):3:F(50,90)', '', 'U.S.:Canada:Mexico', '<HTML>FCC propagation curve set for TV analog contour projection.</HTML>', false),(363, 14, 8, 'FCC curve set, FM', 'pickfrom:1:F(50,50):2:F(50,10):3:F(50,90)', '', 'U.S.:Canada:Mexico', '<HTML>FCC propagation curve set for FM contour projection.</HTML>', false),(329, 14, 9, 'Lookup method below curve minimum distance', 'pickfrom:1:Free-space:2:Scaled free-space:3:None', '', '', '<HTML>Lookup method used when below the minimum-distance point on propagation curves:<BR>Free-space - Use free-space function only (discontinuity at curve end)<BR>Scaled free-space - Use free-space function scaled to match curve end<BR>None - Always return values from the last curve point.</HTML>', false),(120, 14, 10, 'Contour HAAT radial count', 'integer:4:360', '', 'U.S.:Canada:Mexico', '<HTML>Number of radials to use for HAAT lookup during contour projection for full-service and Class A TV, and FM.<BR>If different than the number of contour radials, HAAT values are interpolated between lookup radials.</HTML>', false),(158, 14, 11, 'Contour HAAT radial count, LPTV', 'integer:4:360', '', 'U.S.:Canada:Mexico', '<HTML>Number of radials to use for HAAT lookup during contour projection for LPTV.</HTML>', false),(121, 14, 12, 'Minimum HAAT', 'decimal:0:100', 'm', 'U.S.:Canada:Mexico', '<HTML>Minimum value for HAAT on any radial.</HTML>', false),(330, 14, 13, 'Average terrain start distance', 'decimal:0:100', 'km', 'U.S.:Canada:Mexico', '<HTML>Start distance for average terrain calculation on one radial.</HTML>', false),(331, 14, 14, 'Average terrain end distance', 'decimal:0:100', 'km', 'U.S.:Canada:Mexico', '<HTML>End distance for average terrain calculation on one radial.</HTML>', false),(110, 14, 15, 'Truncate DTS service area', 'option', '', '', '<HTML>Truncate DTS service by the combined area of the pre-DTS FCC service contour and a radius or sectors definition around the DTS reference point.<BR>Applies only when service area is FCC contour for all DTS transmitters.</HTML>', false),(111, 14, 16, 'DTS distance limit, VHF low Zone I', 'decimal:50:250', 'km', '', '<HTML>DTS distance limit, VHF low band in Zone I.</HTML>', false),(112, 14, 17, 'DTS distance limit, VHF low Zone II/III', 'decimal:50:250', 'km', '', '<HTML>DTS distance limit, VHF low band in Zones II and III.</HTML>', false),(113, 14, 18, 'DTS distance limit, VHF high Zone I', 'decimal:50:250', 'km', '', '<HTML>DTS distance limit, VHF high band in Zone I.</HTML>', false),(114, 14, 19, 'DTS distance limit, VHF high Zone II/III', 'decimal:50:250', 'km', '', '<HTML>DTS distance limit, VHF high band in Zones II and III.</HTML>', false),(115, 14, 20, 'DTS distance limit, UHF', 'decimal:50:250', 'km', '', '<HTML>DTS distance limit, UHF.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 20, 0, '1'),(1, 22, 0, '10'),(1, 22, 1, '10'),(1, 22, 2, '10'),(1, 333, 0, '1'),(1, 333, 1, '1'),(1, 333, 2, '1'),(1, 17, 0, '0'),(1, 17, 1, '0'),(1, 17, 2, '0'),(1, 202, 0, '0'),(1, 202, 1, '0'),(1, 202, 2, '0'),(1, 107, 0, '3'),(1, 107, 1, '3'),(1, 107, 2, '3'),(1, 108, 0, '1'),(1, 108, 1, '1'),(1, 108, 2, '1'),(1, 363, 0, '1'),(1, 363, 1, '1'),(1, 363, 2, '1'),(1, 329, 0, '1'),(1, 120, 0, '8'),(1, 120, 1, '36'),(1, 120, 2, '8'),(1, 158, 0, '360'),(1, 158, 1, '36'),(1, 158, 2, '8'),(1, 121, 0, '30.5'),(1, 121, 1, '30.5'),(1, 121, 2, '30.5'),(1, 330, 0, '3.2'),(1, 330, 1, '3.2'),(1, 330, 2, '3.2'),(1, 331, 0, '16.1'),(1, 331, 1, '16.1'),(1, 331, 2, '16.1'),(1, 110, 0, '1'),(1, 111, 0, '108'),(1, 112, 0, '128'),(1, 113, 0, '101'),(1, 114, 0, '123'),(1, 115, 0, '103')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (20, 1),(20, 2),(20, 3),(20, 4),(20, 5),(22, 1),(22, 2),(22, 3),(22, 4),(22, 5),(333, 1),(333, 2),(333, 3),(333, 4),(333, 5),(17, 1),(17, 2),(17, 3),(17, 4),(17, 5),(202, 1),(202, 2),(202, 3),(202, 4),(202, 5),(107, 1),(107, 2),(107, 3),(107, 5),(108, 1),(108, 2),(108, 3),(108, 5),(363, 4),(363, 5),(329, 1),(329, 2),(329, 3),(329, 4),(329, 5),(120, 1),(120, 2),(120, 3),(120, 4),(120, 5),(158, 1),(158, 2),(158, 3),(158, 5),(121, 1),(121, 2),(121, 3),(121, 4),(121, 5),(330, 1),(330, 2),(330, 3),(330, 4),(330, 5),(331, 1),(331, 2),(331, 3),(331, 4),(331, 5),(110, 1),(110, 2),(110, 3),(110, 5),(111, 1),(111, 2),(111, 3),(111, 5),(112, 1),(112, 2),(112, 3),(112, 5),(113, 1),(113, 2),(113, 3),(113, 5),(114, 1),(114, 2),(114, 3),(114, 5),(115, 1),(115, 2),(115, 3),(115, 5)");
        dbConnection.update("INSERT INTO parameter VALUES (175, 16, 1, 'Terrain database', 'pickfrom:0:1/3-second:1:1-second:2:3-second:3:30-second', '', '', '<HTML>Terrain database for Longley-Rice contour projections.</HTML>', false),(177, 16, 2, 'Profile resolution', 'decimal:1:50:1', 'pts/km', '', '<HTML>Profile resolution in points per kilometer for Longley-Rice contour projections.</HTML>', false),(159, 16, 3, 'Calculation distance increment', 'decimal:0.1:10', 'km', '', '<HTML>Target distance between calculated signal points along each radial used to determine contour distance.<BR>Determines an integral point increment based on the profile resolution; calculations can only occur at profile point distances.</HTML>', false),(179, 16, 4, 'Digital % location', 'decimal:0.01:99.99', '%', '', '<HTML>Percent location for digital TV Longley-Rice contour projection.</HTML>', false),(181, 16, 5, 'Digital % time', 'decimal:0.01:99.99', '%', '', '<HTML>Percent time for digital TV Longley-Rice contour projection.</HTML>', false),(183, 16, 6, 'Digital % confidence', 'decimal:0.01:99.99', '%', '', '<HTML>Percent confidence for digital TV Longley-Rice contour projection.</HTML>', false),(185, 16, 7, 'Analog % location', 'decimal:0.01:99.99', '%', '', '<HTML>Percent location for analog TV and FM Longley-Rice contour projection.</HTML>', false),(187, 16, 8, 'Analog % time', 'decimal:0.01:99.99', '%', '', '<HTML>Percent time for analog TV and FM Longley-Rice contour projection.</HTML>', false),(188, 16, 9, 'Analog % confidence', 'decimal:0.01:99.99', '%', '', '<HTML>Percent confidence for analog TV and FM Longley-Rice contour projection.</HTML>', false),(161, 16, 10, 'Receiver height AGL', 'decimal:0.5:50', 'm', '', '<HTML>Receiver antenna height above ground.</HTML>', false),(163, 16, 11, 'Signal polarization', 'pickfrom:0:Horizontal:1:Vertical', '', '', '<HTML>Signal polarization for Longley-Rice contour projections.</HTML>', false),(165, 16, 12, 'Atmospheric refractivity', 'decimal:200:450', 'N', '', '<HTML>Atmospheric refractivity referenced to mean sea level in N-units for Longley-Rice contour projections.</HTML>', false),(167, 16, 13, 'Ground permittivity', 'decimal:1:5000', '', '', '<HTML>Ground relative permittivity for Longley-Rice contour projections.', false),(169, 16, 14, 'Ground conductivity', 'decimal:0.0001:1', 'S/m', '', '<HTML>Ground conductivity in Siemens per meter for Longley-Rice contour projections.</HTML>', false),(171, 16, 15, 'Service mode', 'pickfrom:0:Single-message:1:Individual:2:Mobile:3:Broadcast', '', '', '<HTML>Service mode for Longley-Rice contour projections.</HTML>', false),(173, 16, 16, 'Climate type', 'pickfrom:1:Equatorial:2:Continental subtropical:3:Maritime subtropical:4:Desert:5:Continental temperate:6:Maritime temperate over land:7:Maritime temperate over sea', '', '', '<HTML>Climate type for Longley-Rice contour projections.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 175, 0, '1'),(1, 177, 0, '1'),(1, 159, 0, '1'),(1, 179, 0, '50'),(1, 181, 0, '90'),(1, 183, 0, '50'),(1, 185, 0, '50'),(1, 187, 0, '50'),(1, 188, 0, '50'),(1, 161, 0, '10'),(1, 163, 0, '0'),(1, 165, 0, '301'),(1, 167, 0, '15'),(1, 169, 0, '0.005'),(1, 171, 0, '3'),(1, 173, 0, '5')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (175, 1),(175, 2),(175, 3),(175, 4),(175, 5),(177, 1),(177, 2),(177, 3),(177, 4),(177, 5),(159, 1),(159, 2),(159, 3),(159, 4),(159, 5),(179, 1),(179, 2),(179, 3),(179, 4),(179, 5),(181, 1),(181, 2),(181, 3),(181, 4),(181, 5),(183, 1),(183, 2),(183, 3),(183, 4),(183, 5),(185, 1),(185, 2),(185, 3),(185, 4),(185, 5),(187, 1),(187, 2),(187, 3),(187, 4),(187, 5),(188, 1),(188, 2),(188, 3),(188, 4),(188, 5),(161, 1),(161, 2),(161, 3),(161, 4),(161, 5),(163, 1),(163, 2),(163, 3),(163, 4),(163, 5),(165, 1),(165, 2),(165, 3),(165, 4),(165, 5),(167, 1),(167, 2),(167, 3),(167, 4),(167, 5),(169, 1),(169, 2),(169, 3),(169, 4),(169, 5),(171, 1),(171, 2),(171, 3),(171, 4),(171, 5),(173, 1),(173, 2),(173, 3),(173, 4),(173, 5)");
        dbConnection.update("INSERT INTO parameter VALUES (50, 5, 1, 'Replication method', 'pickfrom:1:Derive pattern:2:Equal area', '', 'U.S.:Canada:Mexico', '<HTML>Method for performing service area replication on an alternate channel:<BR>Derive pattern - Reverse-project contour points to derive a new azimuth pattern and peak ERP.<BR>Equal area - Adjust peak ERP to match contour area using the original azimuth pattern.</HTML>', false),(52, 5, 2, 'Digital full-service minimum ERP, VHF low', 'decimal:0:200', 'kW', 'U.S.:Canada:Mexico', '<HTML>Minimum ERP for digital full-service, VHF low band (applied after contour replication).</HTML>', false),(54, 5, 3, 'Digital full-service minimum ERP, VHF high', 'decimal:0:200', 'kW', 'U.S.:Canada:Mexico', '<HTML>Minimum ERP for digital full-service, VHF high band (applied after contour replication).</HTML>', false),(56, 5, 4, 'Digital full-service minimum ERP, UHF', 'decimal:0:200', 'kW', 'U.S.:Canada:Mexico', '<HTML>Minimum ERP for digital full-service, UHF (applied after contour replication).</HTML>', false),(58, 5, 5, 'Digital full-service maximum ERP, VHF low Zone I', 'decimal:0.001:2000', 'kW', 'U.S.:Canada:Mexico', '<HTML>Maximum ERP for digital full-service, VHF low band in Zone I (applied after contour replication).</HTML>', false),(60, 5, 6, 'Digital full-service maximum ERP, VHF low Zone II/III/other', 'decimal:0.001:2000', 'kW', 'U.S.:Canada:Mexico', '<HTML>Maximum ERP for digital full-service station, VHF low band in Zones II, III,<BR>and stations not assigned to a Zone (applied after contour replication).</HTML>', false),(62, 5, 7, 'Digital full-service maximum ERP, VHF high Zone I', 'decimal:0.001:2000', 'kW', 'U.S.:Canada:Mexico', '<HTML>Maximum ERP for digital full-service station, VHF high band in Zone I (applied after contour replication).</HTML>', false),(64, 5, 8, 'Digital full-service maximum ERP, VHF high Zone II/III/other', 'decimal:0.001:2000', 'kW', 'U.S.:Canada:Mexico', '<HTML>Maximum ERP for digital full-service station, VHF high band in Zones II, III,<BR>and stations not assigned to a Zone (applied after contour replication).</HTML>', false),(66, 5, 9, 'Digital full-service maximum ERP, UHF', 'decimal:0.001:2000', 'kW', 'U.S.:Canada:Mexico', '<HTML>Maximum ERP for digital full-service, UHF (applied after contour replication).</HTML>', false),(327, 5, 10, 'Digital Class A/LPTV minimum ERP, VHF', 'decimal:0.001:2000', 'kW', 'U.S.:Canada:Mexico', '<HTML>Minimum ERP for digital Class A/LPTV, VHF (applied after contour replication).</HTML>', false),(328, 5, 11, 'Digital Class A/LPTV minimum ERP, UHF', 'decimal:0.001:2000', 'kW', 'U.S.:Canada:Mexico', '<HTML>Minimum ERP for digital Class A/LPTV, UHF (applied after contour replication).</HTML>', false),(68, 5, 12, 'Digital Class A/LPTV maximum ERP, VHF', 'decimal:0.001:2000', 'kW', 'U.S.:Canada:Mexico', '<HTML>Maximum ERP for digital Class A/LPTV, VHF (applied after contour replication).</HTML>', false),(70, 5, 13, 'Digital Class A/LPTV maximum ERP, UHF', 'decimal:0.001:2000', 'kW', 'U.S.:Canada:Mexico', '<HTML>Maximum ERP for digital Class A/LPTV, UHF (applied after contour replication).</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 50, 0, '2'),(1, 50, 1, '2'),(1, 50, 2, '2'),(1, 52, 0, '0.1'),(1, 52, 1, '0.002'),(1, 52, 2, '0.1'),(1, 54, 0, '0.1'),(1, 54, 1, '0.002'),(1, 54, 2, '0.1'),(1, 56, 0, '0.1'),(1, 56, 1, '0.002'),(1, 56, 2, '0.1'),(1, 58, 0, '10'),(1, 58, 1, '10'),(1, 58, 2, '10'),(1, 60, 0, '45'),(1, 60, 1, '45'),(1, 60, 2, '45'),(1, 62, 0, '30'),(1, 62, 1, '30'),(1, 62, 2, '30'),(1, 64, 0, '185'),(1, 64, 1, '160'),(1, 64, 2, '160'),(1, 66, 0, '1000'),(1, 66, 1, '1000'),(1, 66, 2, '1000'),(1, 327, 0, '0.024'),(1, 327, 1, '0.001'),(1, 327, 2, '0.024'),(1, 328, 0, '0.024'),(1, 328, 1, '0.001'),(1, 328, 2, '0.024'),(1, 68, 0, '3'),(1, 68, 1, '3'),(1, 68, 2, '3'),(1, 70, 0, '15'),(1, 70, 1, '15'),(1, 70, 2, '15')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (50, 1),(50, 2),(50, 3),(50, 5),(52, 1),(52, 2),(52, 3),(52, 5),(54, 1),(54, 2),(54, 3),(54, 5),(56, 1),(56, 2),(56, 3),(56, 5),(58, 1),(58, 2),(58, 3),(58, 5),(60, 1),(60, 2),(60, 3),(60, 5),(62, 1),(62, 2),(62, 3),(62, 5),(64, 1),(64, 2),(64, 3),(64, 5),(66, 1),(66, 2),(66, 3),(66, 5),(327, 1),(327, 2),(327, 3),(327, 5),(328, 1),(328, 2),(328, 3),(328, 5),(68, 1),(68, 2),(68, 3),(68, 5),(70, 1),(70, 2),(70, 3),(70, 5)");
        dbConnection.update("INSERT INTO parameter VALUES (12, 3, 1, 'Depression angle method', 'pickfrom:1:Effective height:2:True geometry', '', 'U.S.:Canada:Mexico', '<HTML>Method of computing depression angle for elevation pattern lookup for TV and FM stations:<BR>Effective height - Use transmitter HAAT or height AGL with distance-squared approximation formula.<BR>True geometry - Compute exact angle from transmitter to receiver over curved earth.</HTML>', false),(14, 3, 2, 'Use mechanical beam tilt', 'pickfrom:0:Never:1:Always:2:Real patterns only', '', 'U.S.:Canada:Mexico', '<HTML>When to apply mechanical beam tilt to elevation patterns for TV and FM stations.<BR>Electrical beam tilt is always applied to real patterns.</HTML>', false),(219, 3, 3, 'Use generic patterns by default', 'option', '', 'U.S.:Canada:Mexico', '<HTML>Determines the default setting of the option to use OET-69 generic patterns for TV and FM stations when needed.<BR>Wireless base stations always default to no.<BR>The option can be changed for any individual record in the editor.</HTML>', false),(15, 3, 4, 'Mirror generic patterns', 'pickfrom:0:Never:1:Always:2:Propagation only', '', 'U.S.:Canada:Mexico', '<HTML>Mirror generic patterns around the depression angle of the maximum for TV and FM stations.<BR>If not selected, pattern is 1.0 at angles above the maximum.<BR>Non-generic patterns are always mirrored if needed.</HTML>', false),(16, 3, 5, 'Beam tilt on generic patterns', 'pickfrom:0:None:1:Full:2:Offset', '', 'U.S.:Canada:Mexico', '<HTML>Amount of specified beam tilt applied to generic elevation patterns:<BR>None - Generic patterns have only inherent 0.75 degrees electrical tilt.<BR>Full - Apply the full amount of specified electrical tilt, and mechanical tilt if enabled.<BR>Offset - Apply specified electrical tilt with an offset of 0.75 degrees, and full mechanical tilt if enabled.</HTML>', false),(332, 3, 6, 'Double generic pattern values', 'pickfrom:0:Never:1:LPTV only:2:LPTV and Class A', '', 'U.S.:Canada:Mexico', '<HTML>Determines when relative field values from OET-69 generic elevation patterns are doubled.</HTML>', false),(19, 3, 7, 'Invert negative tilts', 'option', '', 'U.S.:Canada:Mexico', '<HTML>Change all negative values for electrical and mechanical beam tilt to positive (use absolute value).</HTML>', false),(140, 3, 8, 'Digital receive antenna f/b, VHF low', 'decimal:0:20', 'dB', '', '<HTML>Receive antenna front-to-back ratio, digital VHF low band.</HTML>', false),(142, 3, 9, 'Digital receive antenna f/b, VHF high', 'decimal:0:20', 'dB', '', '<HTML>Receive antenna front-to-back ratio, digital VHF high band.</HTML>', false),(144, 3, 10, 'Digital receive antenna f/b, UHF', 'decimal:0:20', 'dB', '', '<HTML>Receive antenna front-to-back ratio, digital UHF.</HTML>', false),(146, 3, 11, 'Analog receive antenna f/b, VHF low', 'decimal:0:20', 'dB', '', '<HTML>Receive antenna front-to-back ratio, analog VHF low band.</HTML>', false),(148, 3, 12, 'Analog receive antenna f/b, VHF high', 'decimal:0:20', 'dB', '', '<HTML>Receive antenna front-to-back ratio, analog VHF high band.</HTML>', false),(150, 3, 13, 'Analog receive antenna f/b, UHF', 'decimal:0:20', 'dB', '', '<HTML>Receive antenna front-to-back ratio, analog UHF.</HTML>', false),(151, 3, 14, 'Analog receive antenna f/b, FM', 'decimal:0:20', 'dB', '', '<HTML>Receive antenna front-to-back ratio, analog VHF low band.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 12, 0, '2'),(1, 12, 1, '2'),(1, 12, 2, '2'),(1, 14, 0, '0'),(1, 14, 1, '0'),(1, 14, 2, '0'),(1, 219, 0, '1'),(1, 219, 1, '1'),(1, 219, 2, '1'),(1, 15, 0, '0'),(1, 15, 1, '0'),(1, 15, 2, '0'),(1, 16, 0, '2'),(1, 16, 1, '2'),(1, 16, 2, '2'),(1, 332, 0, '2'),(1, 332, 1, '2'),(1, 332, 2, '2'),(1, 19, 0, '1'),(1, 19, 1, '1'),(1, 19, 2, '1'),(1, 140, 0, '10'),(1, 142, 0, '12'),(1, 144, 0, '14'),(1, 146, 0, '6'),(1, 148, 0, '6'),(1, 150, 0, '6'),(1, 151, 0, '6')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (12, 1),(12, 2),(12, 3),(12, 4),(12, 5),(14, 1),(14, 2),(14, 3),(14, 4),(14, 5),(219, 1),(219, 2),(219, 3),(219, 4),(219, 5),(15, 1),(15, 2),(15, 3),(15, 4),(15, 5),(16, 1),(16, 2),(16, 3),(16, 4),(16, 5),(332, 1),(332, 2),(332, 3),(332, 5),(19, 1),(19, 2),(19, 3),(19, 4),(19, 5),(140, 1),(140, 2),(140, 3),(140, 5),(142, 1),(142, 2),(142, 3),(142, 5),(144, 1),(144, 2),(144, 3),(144, 5),(146, 1),(146, 2),(146, 3),(146, 5),(148, 1),(148, 2),(148, 3),(148, 5),(150, 1),(150, 2),(150, 3),(150, 5),(151, 4),(151, 5)");
        dbConnection.update("INSERT INTO parameter VALUES (30, 6, 1, 'Terrain database', 'pickfrom:0:1/3-second:1:1-second:2:3-second:3:30-second', '', '', '<HTML>Terrain database for propagation calculations.</HTML>', false),(32, 6, 2, 'Profile resolution', 'decimal:1:50:1', 'pts/km', 'U.S.:Canada:Mexico', '<HTML>Profile resolution in points per kilometer for propagation calculations for TV and FM stations.</HTML>', false),(10, 6, 3, 'Model error handling', 'pickfrom:1:Disregard:2:Assume service:3:Assume interference', '', 'U.S.:Canada:Mexico', '<HTML>Behavior when an error code is returned from the propagation model:<BR>Disregard - Use returned signal regardless of error.<BR>Assume service - Error on desired is interference-free service, error on undesired is no interference.<BR>Assume interference - Error on desired is no service, error on undesired is interference.</HTML>', false),(130, 6, 4, 'Receiver height AGL', 'decimal:0.5:50', 'm', '', '<HTML>Receiver antenna height above ground.</HTML>', false),(132, 6, 5, 'Minimum transmitter height AGL', 'decimal:0.5:50', 'm', '', '<HTML>Minimum transmitter height above ground for TV and FM stations.<BR>Transmitter height AMSL is increased as needed to meet this minimum.</HTML>', false),(160, 6, 6, 'Digital desired % location', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % location for digital desired signals for TV and FM stations.</HTML>', false),(162, 6, 7, 'Digital desired % time', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % time for digital desired signals for TV and FM stations.</HTML>', false),(164, 6, 8, 'Digital desired % confidence', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % confidence for digital desired signals for TV and FM stations.</HTML>', false),(166, 6, 9, 'Digital undesired % location', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % location for digital undesired signals for TV and FM stations.<BR>(Undesired signal % time is defined by the applicable interference rule.)</HTML>', false),(168, 6, 10, 'Digital undesired % confidence', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % confidence for digital undesired signals for TV and FM stations.<BR>(Undesired signal % time is defined by the applicable interference rule.)</HTML>', false),(170, 6, 11, 'Analog desired % location', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % location for analog desired signals for TV and FM stations.</HTML>', false),(172, 6, 12, 'Analog desired % time', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % time for analog desired signals for TV and FM stations.</HTML>', false),(174, 6, 13, 'Analog desired % confidence', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % confidence for analog desired signals for TV and FM stations.</HTML>', false),(176, 6, 14, 'Analog undesired % location', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % location for analog undesired signals for TV and FM stations.<BR>(Undesired signal % time is defined by the applicable interference rule.)</HTML>', false),(178, 6, 15, 'Analog undesired % confidence', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % confidence for analog undesired signals for TV and FM stations.<BR>(Undesired signal % time is defined by the applicable interference rule.)</HTML>', false),(180, 6, 16, 'Signal polarization', 'pickfrom:0:Horizontal:1:Vertical', '', '', '<HTML>Propagation model signal polarization for TV and FM stations.</HTML>', false),(182, 6, 17, 'Atmospheric refractivity', 'decimal:200:450', 'N', '', '<HTML>Propagation model atmospheric refractivity referenced to mean sea level in N-units.</HTML>', false),(184, 6, 18, 'Ground permittivity', 'decimal:1:5000', '', '', '<HTML>Propagation model ground relative permittivity.', false),(186, 6, 19, 'Ground conductivity', 'decimal:0.0001:1', 'S/m', '', '<HTML>Propagation model ground conductivity in Siemens per meter.</HTML>', false),(190, 6, 20, 'Service mode', 'pickfrom:0:Single-message:1:Individual:2:Mobile:3:Broadcast', '', '', '<HTML>Propagation model service mode for FM and TV stations.</HTML>', false),(192, 6, 22, 'Climate type', 'pickfrom:1:Equatorial:2:Continental subtropical:3:Maritime subtropical:4:Desert:5:Continental temperate:6:Maritime temperate over land:7:Maritime temperate over sea', '', '', '<HTML>Propagation model climate type.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 30, 0, '1'),(1, 32, 0, '1'),(1, 32, 1, '1'),(1, 32, 2, '1'),(1, 10, 0, '2'),(1, 10, 1, '2'),(1, 10, 2, '2'),(1, 130, 0, '10'),(1, 132, 0, '10'),(1, 160, 0, '50'),(1, 162, 0, '90'),(1, 164, 0, '50'),(1, 166, 0, '50'),(1, 168, 0, '50'),(1, 170, 0, '50'),(1, 172, 0, '50'),(1, 174, 0, '50'),(1, 176, 0, '50'),(1, 178, 0, '50'),(1, 180, 0, '0'),(1, 182, 0, '301'),(1, 184, 0, '15'),(1, 186, 0, '0.005'),(1, 190, 0, '3'),(1, 192, 0, '5')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (30, 1),(30, 2),(30, 3),(30, 4),(30, 5),(32, 1),(32, 2),(32, 3),(32, 4),(32, 5),(10, 1),(10, 2),(10, 3),(10, 4),(10, 5),(130, 1),(130, 2),(130, 3),(130, 4),(130, 5),(132, 1),(132, 2),(132, 3),(132, 4),(132, 5),(160, 1),(160, 2),(160, 3),(160, 5),(162, 1),(162, 2),(162, 3),(162, 5),(164, 1),(164, 2),(164, 3),(164, 5),(166, 1),(166, 2),(166, 3),(166, 5),(168, 1),(168, 2),(168, 3),(168, 5),(170, 1),(170, 2),(170, 3),(170, 4),(170, 5),(172, 1),(172, 2),(172, 3),(172, 4),(172, 5),(174, 1),(174, 2),(174, 3),(174, 4),(174, 5),(176, 1),(176, 2),(176, 3),(176, 4),(176, 5),(178, 1),(178, 2),(178, 3),(178, 4),(178, 5),(180, 1),(180, 2),(180, 3),(180, 4),(180, 5),(182, 1),(182, 2),(182, 3),(182, 4),(182, 5),(184, 1),(184, 2),(184, 3),(184, 4),(184, 5),(186, 1),(186, 2),(186, 3),(186, 4),(186, 5),(190, 1),(190, 2),(190, 3),(190, 4),(190, 5),(192, 1),(192, 2),(192, 3),(192, 4),(192, 5)");
        dbConnection.update("INSERT INTO parameter VALUES (309, 7, 1, 'Set service thresholds', 'option', '', '', '<HTML>Independently set the terrain-sensitive service thresholds.<BR>If not selected, thresholds are the same as contour levels.</HTML>', false),(310, 7, 2, 'Digital TV full-service threshold, VHF low', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, digital TV full-service VHF low band.</HTML>', false),(311, 7, 3, 'Digital TV full-service threshold, VHF high', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, digital TV full-service VHF high band.</HTML>', false),(312, 7, 4, 'Digital TV full-service threshold, UHF', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, digital TV full-service UHF (may be dipole-adjusted).</HTML>', false),(313, 7, 5, 'Digital TV Class A/LPTV threshold, VHF low', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, digital LPTV/Class A VHF low band.</HTML>', false),(314, 7, 6, 'Digital TV Class A/LPTV threshold, VHF high', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, digital LPTV/Class A VHF high band.</HTML>', false),(315, 7, 7, 'Digital TV Class A/LPTV threshold, UHF', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, digital LPTV/Class A UHF (may be dipole-adjusted).</HTML>', false),(316, 7, 8, 'Analog TV full-service threshold, VHF low', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, analog TV full-service VHF low band.</HTML>', false),(317, 7, 9, 'Analog TV full-service threshold, VHF high', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, analog TV full-service VHF high band.</HTML>', false),(318, 7, 10, 'Analog TV full-service threshold, UHF', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, analog TV full-service UHF (may be dipole-adjusted).</HTML>', false),(319, 7, 11, 'Analog TV Class A/LPTV threshold, VHF low', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, analog LPTV/Class A VHF low band.</HTML>', false),(320, 7, 12, 'Analog TV Class A/LPTV threshold, VHF high', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, analog LPTV/Class A VHF high band.</HTML>', false),(321, 7, 13, 'Analog TV Class A/LPTV threshold, UHF', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, analog LPTV/Class A UHF (may be dipole-adjusted).</HTML>', false),(322, 7, 14, 'Use UHF dipole adjustment', 'option', '', 'U.S.:Canada:Mexico', '<HTML>Apply dipole adjustment to TV UHF terrain-sensitive service threshold levels.</HTML>', false),(323, 7, 15, 'Dipole center frequency', 'decimal:470:700', 'MHz', 'U.S.:Canada:Mexico', '<HTML>Center frequency for dipole adjustment of TV UHF terrain-sensitive service threshold levels.</HTML>', false),(364, 7, 16, 'FM full-service threshold', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, FM full-service for most commercial-band classes.</HTML>', false),(365, 7, 17, 'FM full-service threshold, class B', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, FM full-service class B.</HTML>', false),(366, 7, 18, 'FM full-service threshold, class B1', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, FM full-service class B1.</HTML>', false),(367, 7, 19, 'FM NCE threshold', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, FM non-commercial/educational band.</HTML>', false),(368, 7, 20, 'LPFM threshold', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, low-power FM.</HTML>', false),(369, 7, 21, 'FM translator threshold', 'decimal:0:120', 'dBu', 'U.S.:Canada:Mexico', '<HTML>Terrain-sensitive service threshold level, FM translator.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 309, 0, '0'),(1, 310, 0, '28'),(1, 310, 1, '28'),(1, 310, 2, '28'),(1, 311, 0, '36'),(1, 311, 1, '36'),(1, 311, 2, '36'),(1, 312, 0, '41'),(1, 312, 1, '41'),(1, 312, 2, '41'),(1, 313, 0, '43'),(1, 313, 1, '43'),(1, 313, 2, '43'),(1, 314, 0, '48'),(1, 314, 1, '48'),(1, 314, 2, '48'),(1, 315, 0, '51'),(1, 315, 1, '51'),(1, 315, 2, '51'),(1, 316, 0, '47'),(1, 316, 1, '47'),(1, 316, 2, '47'),(1, 317, 0, '56'),(1, 317, 1, '56'),(1, 317, 2, '56'),(1, 318, 0, '64'),(1, 318, 1, '64'),(1, 318, 2, '64'),(1, 319, 0, '62'),(1, 319, 1, '62'),(1, 319, 2, '62'),(1, 320, 0, '68'),(1, 320, 1, '68'),(1, 320, 2, '68'),(1, 321, 0, '74'),(1, 321, 1, '74'),(1, 321, 2, '74'),(1, 322, 0, '1'),(1, 322, 1, '1'),(1, 322, 2, '1'),(1, 323, 0, '615'),(1, 323, 1, '615'),(1, 323, 2, '615'),(1, 364, 0, '60'),(1, 364, 1, '60'),(1, 364, 2, '60'),(1, 365, 0, '54'),(1, 365, 1, '54'),(1, 365, 2, '54'),(1, 366, 0, '57'),(1, 366, 1, '57'),(1, 366, 2, '57'),(1, 367, 0, '60'),(1, 367, 1, '60'),(1, 367, 2, '60'),(1, 368, 0, '60'),(1, 368, 1, '60'),(1, 368, 2, '60'),(1, 369, 0, '60'),(1, 369, 1, '60'),(1, 369, 2, '60')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (309, 1),(309, 2),(309, 3),(309, 4),(309, 5),(310, 1),(310, 2),(310, 3),(310, 5),(311, 1),(311, 2),(311, 3),(311, 5),(312, 1),(312, 2),(312, 3),(312, 5),(313, 1),(313, 2),(313, 3),(313, 5),(314, 1),(314, 2),(314, 3),(314, 5),(315, 1),(315, 2),(315, 3),(315, 5),(316, 1),(316, 2),(316, 3),(316, 5),(317, 1),(317, 2),(317, 3),(317, 5),(318, 1),(318, 2),(318, 3),(318, 5),(319, 1),(319, 2),(319, 3),(319, 5),(320, 1),(320, 2),(320, 3),(320, 5),(321, 1),(321, 2),(321, 3),(321, 5),(322, 1),(322, 2),(322, 3),(322, 5),(323, 1),(323, 2),(323, 3),(323, 5),(364, 4),(364, 5),(365, 4),(365, 5),(366, 4),(366, 5),(367, 4),(367, 5),(368, 4),(368, 5),(369, 4),(369, 5)");
        dbConnection.update("INSERT INTO parameter VALUES (249, 8, 1, 'Apply clutter adjustments', 'option', '', '', '<HTML>Adjust field-strength values for receiver clutter type and channel band, based on land-cover category at study point.</HTML>', false),(205, 8, 2, 'Land cover database', 'pickfrom:2006:NLCD 2006:2011:NLCD 2011:2016:NLCD 2016:2021:NLCD 2021', '', '', '<HTML>Land cover database.</HTML>', false),(250, 8, 3, 'Open land, low VHF/FM', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(251, 8, 4, 'Open land, high VHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(252, 8, 5, 'Open land, low UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(253, 8, 6, 'Open land, high UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(254, 8, 7, 'Agricultural, low VHF/FM', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(255, 8, 8, 'Agricultural, high VHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(256, 8, 9, 'Agricultural, low UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(257, 8, 10, 'Agricultural, high UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(258, 8, 11, 'Rangeland, low VHF/FM', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(259, 8, 12, 'Rangeland, high VHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(260, 8, 13, 'Rangeland, low UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(261, 8, 14, 'Rangeland, high UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(262, 8, 15, 'Water, low VHF/FM', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(263, 8, 16, 'Water, high VHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(264, 8, 17, 'Water, low UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(265, 8, 18, 'Water, high UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(266, 8, 19, 'Forest land, low VHF/FM', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(267, 8, 20, 'Forest land, high VHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(268, 8, 21, 'Forest land, low UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(269, 8, 22, 'Forest land, high UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(270, 8, 23, 'Wetland, low VHF/FM', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(271, 8, 24, 'Wetland, high VHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(272, 8, 25, 'Wetland, low UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(273, 8, 26, 'Wetland, high UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(274, 8, 27, 'Residential, low VHF/FM', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(275, 8, 28, 'Residential, high VHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(276, 8, 29, 'Residential, low UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(277, 8, 30, 'Residential, high UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(278, 8, 31, 'Mixed Urban / Buildings, low VHF/FM', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(279, 8, 32, 'Mixed Urban / Buildings, high VHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(280, 8, 33, 'Mixed Urban / Buildings, low UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(281, 8, 34, 'Mixed Urban / Buildings, high UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(282, 8, 35, 'Commercial / Industrial, low VHF/FM', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(283, 8, 36, 'Commercial / Industrial, high VHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(284, 8, 37, 'Commercial / Industrial, low UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(285, 8, 38, 'Commercial / Industrial, high UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(286, 8, 39, 'Snow and Ice, low VHF/FM', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(287, 8, 40, 'Snow and Ice, high VHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(288, 8, 41, 'Snow and Ice, low UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(289, 8, 42, 'Snow and Ice, high UHF', 'decimal:-30:30', 'dB', 'U.S.:Canada:Mexico', '<HTML>Adjustment for clutter type and channel band.<HTML>', false),(290, 8, 43, 'Open water', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(291, 8, 44, 'Perennial ice/snow', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(292, 8, 45, 'Developed, open space', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(293, 8, 46, 'Developed, low intensity', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(294, 8, 47, 'Developed, medium intensity', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(295, 8, 48, 'Developed, high intensity', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(296, 8, 49, 'Barren land (rock/sand/clay)', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(297, 8, 50, 'Deciduous forest', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(298, 8, 51, 'Evergreen forest', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(299, 8, 52, 'Mixed forest', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(300, 8, 53, 'Shrub/scrub', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(301, 8, 54, 'Grassland/herbaceous', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(302, 8, 55, 'Pasture/hay', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(303, 8, 56, 'Cultivated crops', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(304, 8, 57, 'Woody wetlands', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false),(305, 8, 58, 'Emergent herbaceous wetlands', 'pickfrom:1:Open land:2:Agricultural:3:Rangeland:4:Water:5:Forest land:6:Wetland:7:Residential:8:Mixed Urban / Buildings:9:Commercial / Industrial:10:Snow and Ice', '', '', '<HTML>Clutter type for land-cover category.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 249, 0, '0'),(1, 205, 0, '2006'),(1, 250, 0, '0'),(1, 250, 1, '0'),(1, 250, 2, '0'),(1, 251, 0, '0'),(1, 251, 1, '0'),(1, 251, 2, '0'),(1, 252, 0, '-4'),(1, 252, 1, '-4'),(1, 252, 2, '-4'),(1, 253, 0, '-5'),(1, 253, 1, '-5'),(1, 253, 2, '-5'),(1, 254, 0, '0'),(1, 254, 1, '0'),(1, 254, 2, '0'),(1, 255, 0, '0'),(1, 255, 1, '0'),(1, 255, 2, '0'),(1, 256, 0, '-5'),(1, 256, 1, '-5'),(1, 256, 2, '-5'),(1, 257, 0, '-6'),(1, 257, 1, '-6'),(1, 257, 2, '-6'),(1, 258, 0, '0'),(1, 258, 1, '0'),(1, 258, 2, '0'),(1, 259, 0, '0'),(1, 259, 1, '0'),(1, 259, 2, '0'),(1, 260, 0, '-3'),(1, 260, 1, '-3'),(1, 260, 2, '-3'),(1, 261, 0, '-6'),(1, 261, 1, '-6'),(1, 261, 2, '-6'),(1, 262, 0, '0'),(1, 262, 1, '0'),(1, 262, 2, '0'),(1, 263, 0, '0'),(1, 263, 1, '0'),(1, 263, 2, '0'),(1, 264, 0, '0'),(1, 264, 1, '0'),(1, 264, 2, '0'),(1, 265, 0, '0'),(1, 265, 1, '0'),(1, 265, 2, '0'),(1, 266, 0, '0'),(1, 266, 1, '0'),(1, 266, 2, '0'),(1, 267, 0, '0'),(1, 267, 1, '0'),(1, 267, 2, '0'),(1, 268, 0, '-5'),(1, 268, 1, '-5'),(1, 268, 2, '-5'),(1, 269, 0, '-8'),(1, 269, 1, '-8'),(1, 269, 2, '-8'),(1, 270, 0, '0'),(1, 270, 1, '0'),(1, 270, 2, '0'),(1, 271, 0, '0'),(1, 271, 1, '0'),(1, 271, 2, '0'),(1, 272, 0, '0'),(1, 272, 1, '0'),(1, 272, 2, '0'),(1, 273, 0, '0'),(1, 273, 1, '0'),(1, 273, 2, '0'),(1, 274, 0, '0'),(1, 274, 1, '0'),(1, 274, 2, '0'),(1, 275, 0, '0'),(1, 275, 1, '0'),(1, 275, 2, '0'),(1, 276, 0, '-5'),(1, 276, 1, '-5'),(1, 276, 2, '-5'),(1, 277, 0, '-7'),(1, 277, 1, '-7'),(1, 277, 2, '-7'),(1, 278, 0, '0'),(1, 278, 1, '0'),(1, 278, 2, '0'),(1, 279, 0, '0'),(1, 279, 1, '0'),(1, 279, 2, '0'),(1, 280, 0, '-6'),(1, 280, 1, '-6'),(1, 280, 2, '-6'),(1, 281, 0, '-6'),(1, 281, 1, '-6'),(1, 281, 2, '-6'),(1, 282, 0, '0'),(1, 282, 1, '0'),(1, 282, 2, '0'),(1, 283, 0, '0'),(1, 283, 1, '0'),(1, 283, 2, '0'),(1, 284, 0, '-5'),(1, 284, 1, '-5'),(1, 284, 2, '-5'),(1, 285, 0, '-6'),(1, 285, 1, '-6'),(1, 285, 2, '-6'),(1, 286, 0, '0'),(1, 286, 1, '0'),(1, 286, 2, '0'),(1, 287, 0, '0'),(1, 287, 1, '0'),(1, 287, 2, '0'),(1, 288, 0, '0'),(1, 288, 1, '0'),(1, 288, 2, '0'),(1, 289, 0, '0'),(1, 289, 1, '0'),(1, 289, 2, '0'),(1, 290, 0, '4'),(1, 291, 0, '10'),(1, 292, 0, '1'),(1, 293, 0, '7'),(1, 294, 0, '7'),(1, 295, 0, '8'),(1, 296, 0, '1'),(1, 297, 0, '5'),(1, 298, 0, '5'),(1, 299, 0, '5'),(1, 300, 0, '3'),(1, 301, 0, '3'),(1, 302, 0, '2'),(1, 303, 0, '2'),(1, 304, 0, '5'),(1, 305, 0, '6')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (249, 1),(249, 2),(249, 3),(249, 4),(249, 5),(205, 1),(205, 2),(205, 3),(205, 4),(205, 5),(250, 1),(250, 2),(250, 3),(250, 4),(250, 5),(251, 1),(251, 2),(251, 3),(252, 1),(252, 2),(252, 3),(253, 1),(253, 2),(253, 3),(254, 1),(254, 2),(254, 3),(254, 4),(254, 5),(255, 1),(255, 2),(255, 3),(256, 1),(256, 2),(256, 3),(257, 1),(257, 2),(257, 3),(258, 1),(258, 2),(258, 3),(258, 4),(258, 5),(259, 1),(259, 2),(259, 3),(260, 1),(260, 2),(260, 3),(261, 1),(261, 2),(261, 3),(262, 1),(262, 2),(262, 3),(262, 4),(262, 5),(263, 1),(263, 2),(263, 3),(264, 1),(264, 2),(264, 3),(265, 1),(265, 2),(265, 3),(266, 1),(266, 2),(266, 3),(266, 4),(266, 5),(267, 1),(267, 2),(267, 3),(268, 1),(268, 2),(268, 3),(269, 1),(269, 2),(269, 3),(270, 1),(270, 2),(270, 3),(270, 4),(270, 5),(271, 1),(271, 2),(271, 3),(272, 1),(272, 2),(272, 3),(273, 1),(273, 2),(273, 3),(274, 1),(274, 2),(274, 3),(274, 4),(274, 5),(275, 1),(275, 2),(275, 3),(276, 1),(276, 2),(276, 3),(277, 1),(277, 2),(277, 3),(278, 1),(278, 2),(278, 3),(278, 4),(278, 5),(279, 1),(279, 2),(279, 3),(280, 1),(280, 2),(280, 3),(281, 1),(281, 2),(281, 3),(282, 1),(282, 2),(282, 3),(282, 4),(282, 5),(283, 1),(283, 2),(283, 3),(284, 1),(284, 2),(284, 3),(285, 1),(285, 2),(285, 3),(286, 1),(286, 2),(286, 3),(286, 4),(286, 5),(287, 1),(287, 2),(287, 3),(288, 1),(288, 2),(288, 3),(289, 1),(289, 2),(289, 3),(290, 1),(290, 2),(290, 3),(290, 4),(290, 5),(291, 1),(291, 2),(291, 3),(291, 4),(291, 5),(292, 1),(292, 2),(292, 3),(292, 4),(292, 5),(293, 1),(293, 2),(293, 3),(293, 4),(293, 5),(294, 1),(294, 2),(294, 3),(294, 4),(294, 5),(295, 1),(295, 2),(295, 3),(295, 4),(295, 5),(296, 1),(296, 2),(296, 3),(296, 4),(296, 5),(297, 1),(297, 2),(297, 3),(297, 4),(297, 5),(298, 1),(298, 2),(298, 3),(298, 4),(298, 5),(299, 1),(299, 2),(299, 3),(299, 4),(299, 5),(300, 1),(300, 2),(300, 3),(300, 4),(300, 5),(301, 1),(301, 2),(301, 3),(301, 4),(301, 5),(302, 1),(302, 2),(302, 3),(302, 4),(302, 5),(303, 1),(303, 2),(303, 3),(303, 4),(303, 5),(304, 1),(304, 2),(304, 3),(304, 4),(304, 5),(305, 1),(305, 2),(305, 3),(305, 4),(305, 5)");
        dbConnection.update("INSERT INTO parameter VALUES (216, 12, 1, 'Maximum new interference', 'decimal:0:10', '%', '', '<HTML>Maximum amount of new interference created to full service and Class A stations, percent of population served.</HTML>', false),(217, 12, 2, 'Maximum new interference to LPTV', 'decimal:0:10', '%', '', '<HTML>Maximum amount of new interference created to LPTV stations, percent of population served.</HTML>', false),(211, 12, 3, 'Check proposal vs. baseline', 'option', '', '', '<HTML>Compare service contour and terrain-limited population of proposal to baseline record, if any, using following parameters.</HTML>', false),(213, 12, 4, 'Maximum contour extension from baseline', 'decimal:0:10', '%', '', '<HTML>Maximum amount by which service contour may extend beyond the baseline contour, percent of contour distance.</HTML>', false),(214, 12, 5, 'Maximum population reduction from baseline', 'decimal:0:10', '%', '', '<HTML>Maximum amount by which terrain-limitied population may be reduced from baseline, percent.</HTML>', false),(153, 12, 6, 'Masked interference warning threshold', 'decimal:0:50', '%', '', '<HTML>Masked interference threshold for warning of possible undetected MX case, percent.<BR>Set to 0 to disable warning.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 216, 0, '0.5'),(1, 217, 0, '2'),(1, 211, 0, '1'),(1, 213, 0, '1'),(1, 214, 0, '5'),(1, 153, 0, '10')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (216, 2),(217, 2),(211, 2),(213, 2),(214, 2),(153, 2)");
        dbConnection.update("INSERT INTO parameter VALUES (341, 9, 1, 'Required D/U', 'decimal:-100:50', 'dB', '-5 to 0 MHz overlap:1 MHz overlap:2 MHz overlap:3 MHz overlap:4 MHz overlap:5 MHz overlap', '<HTML>Required D/U for wireless into TV interference.</HTML>', false),(247, 9, 2, 'Culling distances', 'table:8:305 m:200 m:150 m:100 m:80 m:65 m:50 m:35 m:9:5 kW:4 kW:3 kW:2 kW:1 kW:0.75 kW:0.5 kW:0.25 kW:0.1 kW:decimal:1:500', '', '-5 to 0 MHz overlap:1 MHz overlap:2 MHz overlap:3 MHz overlap:4 MHz overlap:5 MHz overlap', '<HTML>Tables of culling distances in kilometers for wireless undesired stations.</HTML>', false),(308, 9, 3, 'Cap alpha factor', 'option', '', '', '<HTML>Set a cap on the amount by which the required D/U for wireless interference to digital TV with spectral overlap >0 is increased as the desired signal nears the service threshold.</HTML>', false),(342, 9, 4, 'Alpha factor cap', 'decimal:0:36.4', 'dB', '', '<HTML>Cap value for digital TV co-channel D/U adjustment.</HTML>', false),(343, 9, 5, 'Average terrain profile resolution', 'decimal:1:50:1', 'pts/km', '', '<HTML>Profile resolution in points per kilometer for average terrain calculations for wireless stations.</HTML>', false),(344, 9, 6, 'Propagation profile resolution', 'decimal:1:50:1', 'pts/km', '', '<HTML>Profile resolution in points per kilometer for propagation calculations for wireless stations.</HTML>', false),(345, 9, 7, 'HAAT radial count', 'integer:4:360', '', '', '<HTML>Number of radials used to calculate HAAT when deriving AMSL height or verifying database HAAT for wireless stations.</HTML>', false),(346, 9, 8, 'Depression angle method', 'pickfrom:1:Effective height:2:True geometry', '', '', '<HTML>Method of computing depression angle for wireless station elevation pattern lookup:<BR>Effective height - Use transmitter HAAT or height AGL with distance-squared approximation formula.<BR>True geometry - Compute exact angle from transmitter to receiver over curved earth.</HTML>', false),(347, 9, 9, 'Use mechanical beam tilt', 'option', '', '', '<HTML>Apply mechanical beam tilt to wireless station elevation patterns.<BR>Electrical beam tilt is always applied.</HTML>', false),(348, 9, 10, 'Mirror generic patterns', 'pickfrom:0:Never:1:Always', '', '', '<HTML>Mirror generic patterns around the depression angle of the maximum for wireless stations.<BR>If not selected, pattern is 1.0 at angles above the maximum.<BR>Non-generic patterns are always mirrored if needed.</HTML>', false),(349, 9, 11, 'Minimum transmitter height AGL', 'decimal:0.5:50', 'm', '', '<HTML>Minimum transmitter height above ground for wireless stations.<BR>Transmitter height AMSL is increased as needed to meet this minimum.</HTML>', false),(350, 9, 12, 'Undesired % location', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % location for undesired signals from wireless stations.</HTML>', false),(351, 9, 13, 'Undesired % time', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % time for undesired signals from wireless stations.</HTML>', false),(352, 9, 14, 'Undesired % confidence', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % confidence for undesired signals from wireless stations.</HTML>', false),(353, 9, 15, 'Signal polarization', 'pickfrom:0:Horizontal:1:Vertical', '', '', '<HTML>Propagation model signal polarization for wireless stations.</HTML>', false),(354, 9, 16, 'Service mode', 'pickfrom:0:Single-message:1:Individual:2:Mobile:3:Broadcast', '', '', '<HTML>Propagation model service mode for wireless stations.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 341, 0, '-33'),(1, 341, 1, '9.3'),(1, 341, 2, '12.1'),(1, 341, 3, '13.8'),(1, 341, 4, '15.1'),(1, 341, 5, '16'),(1, 247, 0, '23,22,20,18,14,13,12,10,8,18,17,16,14,11,11,10,8,6,15,14,13,12,10,9,8,7,6,12,11,11,10,8,8,7,6,5,11,10,10,9,7,7,6,5,4,10,9,9,8,7,6,6,5,4,9,8,8,7,6,6,5,4,3,7,7,6,6,5,5,4,3,3'),(1, 247, 1, '176,171,165,155,138,131,122,106,90,165,160,153,143,127,120,111,95,78,159,154,147,137,121,114,105,90,72,151,146,139,128,113,106,97,82,66,148,142,135,125,109,102,93,78,63,145,139,132,122,106,99,90,75,60,141,135,128,118,102,95,86,72,57,136,131,124,115,98,92,83,68,54'),(1, 247, 2, '193,187,180,170,154,147,137,121,102,180,175,168,159,142,136,126,110,90,174,169,163,153,136,129,120,105,85,167,162,155,145,128,121,113,97,77,163,158,151,142,124,118,108,92,73,160,154,148,138,121,114,105,89,70,156,151,145,135,118,111,101,86,67,152,147,140,130,114,107,98,82,63'),(1, 247, 3, '202,197,190,179,164,157,146,130,109,189,184,177,167,151,144,135,119,98,183,178,171,162,145,138,129,113,92,177,171,164,154,137,130,121,105,84,172,167,159,150,133,126,117,101,80,169,163,156,147,130,123,114,97,77,165,160,153,144,127,120,110,94,74,161,156,149,139,123,116,106,90,71'),(1, 247, 4, '210,205,198,187,170,164,154,137,116,198,192,185,175,159,152,142,126,105,191,186,179,169,153,146,136,120,99,185,179,172,162,145,138,128,112,92,181,175,168,158,141,134,124,108,87,177,172,164,154,138,131,121,105,84,174,168,160,151,134,128,118,101,81,169,164,156,147,130,123,114,98,77'),(1, 247, 5, '215,209,202,192,174,168,159,142,120,204,197,189,179,163,157,147,130,109,196,190,183,173,157,150,141,124,104,189,184,176,166,150,143,132,117,96,185,180,172,162,146,139,129,113,91,182,176,169,159,143,136,126,109,88,178,173,165,155,139,132,122,106,85,174,168,161,151,134,128,118,102,81'),(1, 308, 0, '1'),(1, 342, 0, '8'),(1, 343, 0, '10'),(1, 344, 0, '10'),(1, 345, 0, '8'),(1, 346, 0, '2'),(1, 347, 0, '1'),(1, 348, 0, '1'),(1, 349, 0, '10'),(1, 350, 0, '50'),(1, 351, 0, '10'),(1, 352, 0, '50'),(1, 353, 0, '1'),(1, 354, 0, '3')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (341, 3),(247, 3),(308, 3),(342, 3),(343, 3),(344, 3),(345, 3),(346, 3),(347, 3),(348, 3),(349, 3),(350, 3),(351, 3),(352, 3),(353, 3),(354, 3)");
        dbConnection.update("INSERT INTO parameter VALUES (244, 10, 1, 'FM undesired culling distances', 'table:1:Dist. km:21:Ch. 200:201:202:203:204:205:206:207:208:209:210:211:212:213:214:215:216:217:218:219:220:decimal:1:500', '', '', '<HTML>Table of culling distances in km for FM to TV/DTV interference.</HTML>', false),(246, 10, 2, 'FM to TV D/U curves', 'table:44:47 dBu:48:49:50:51:52:53:54:55:56:57:58:59:60:61:62:63:64:65:66:67:68:69:70:71:72:73:74:75:76:77:78:79:80:81:82:83:84:85:86:87:88:89:90:21:Ch. 200:201:202:203:204:205:206:207:208:209:210:211:212:213:214:215:216:217:218:219:220:decimal:-50:50', '', '', '<HTML>Lookup tables defining curves of required D/U values in dB for FM to TV interference.</HTML>', false),(203, 10, 3, 'FM to DTV D/U method', 'pickfrom:1:Curves:3:Fixed', '', '', '<HTML>Method used to determine FM to DTV required D/U:<BR>Curves - FCC Rules 73.525 method, curves are extrapolated<BR>Fixed - Fixed D/U table values per FM channel.<HTML>', false),(204, 10, 4, 'FM to DTV fixed D/U table', 'table:1:D/U dB:21:Ch. 200:201:202:203:204:205:206:207:208:209:210:211:212:213:214:215:216:217:218:219:220:decimal:-50:50', '', '', '<HTML>Lookup table of required D/U values in dB for FM to DTV interference using fixed method.</HTML>', false),(245, 10, 5, 'FM undesired % time', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % time for undesired signals from FM to TV/DTV.</HTML>', false),(242, 10, 6, 'DTV undesired culling distances', 'table:1:Dist. km:21:Ch. 200:201:202:203:204:205:206:207:208:209:210:211:212:213:214:215:216:217:218:219:220:decimal:1:500', '', '', '<HTML>Table of culling distances in km for DTV to FM interference.<BR>Note: TV into FM treats TV as an FM on channel 199 then applies normal FM<->FM rules.</HTML>', false),(218, 10, 7, 'DTV to FM base D/U', 'decimal:-50:50', 'dB', '', '<HTML>Base required D/U for DTV to FM interference, adjusted by DTV emission mask and channel separation.<BR>Note: TV into FM treats TV as an FM on channel 199 then applies normal FM<->FM rules.<HTML>', false),(243, 10, 8, 'TV/DTV undesired % time', 'decimal:0.01:99.99', '%', '', '<HTML>Propagation model statistical parameter, % time for undesired signals from TV/DTV to FM.</HTML>', false)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 244, 0, '400,265,257,246,235,225,211,196,196,196,196,196,195,193,187,180,177,174,166,159,154'),(1, 246, 0, '12.5,-1,-3.8,-6.5,-9.3,-12.1,-16.5,-20.3,-20.3,-20.3,-20.3,-20.3,-21.8,-22.5,-24.7,-27,-28,-29,-32.5,-36,-39,12.8,-0.7,-3.4,-6.1,-8.8,-11.6,-15.3,-18.7,-18.7,-18.7,-18.7,-18.7,-20.3,-21.4,-22.9,-25.1,-26.3,-27.7,-31.1,-34.8,-37.7,13.2,-0.3,-3,-5.6,-8.4,-11.1,-14.2,-17.3,-17.3,-17.3,-17.3,-17.3,-19,-20.1,-21.4,-23.4,-24.6,-26.4,-29.7,-33.6,-36.3,13.5,0,-2.6,-5.2,-7.9,-10.7,-13.1,-16.1,-16.1,-16.1,-16.1,-16.1,-17.7,-18.9,-20,-21.8,-23.1,-25.1,-28.4,-32.3,-35,13.8,0.3,-2.2,-4.8,-7.5,-10.2,-12.2,-15,-15,-15,-15,-15,-16.6,-17.8,-18.7,-20.4,-21.6,-23.8,-27.1,-31.1,-33.8,14.1,0.6,-1.8,-4.3,-7.1,-9.8,-11.2,-13.9,-13.9,-13.9,-13.9,-13.9,-15.4,-16.7,-17.5,-18.9,-20.3,-22.5,-25.9,-29.9,-32.5,14.4,0.9,-1.5,-3.9,-6.6,-9.3,-10.4,-12.9,-12.9,-12.9,-12.9,-12.9,-14.4,-15.6,-16.2,-17.6,-19,-21.3,-24.6,-28.7,-31.3,14.7,1.2,-1.1,-3.5,-6.2,-8.8,-9.7,-12,-12,-12,-12,-12,-13.4,-14.6,-15,-16.4,-17.7,-20.1,-23.4,-27.5,-30.2,15,1.5,-0.8,-3.1,-5.8,-8.4,-8.9,-11.1,-11.1,-11.1,-11.1,-11.1,-12.4,-13.6,-13.9,-15.2,-16.5,-19,-22.2,-26.4,-29,15.3,1.8,-0.4,-2.7,-5.4,-8,-8.3,-10.2,-10.2,-10.2,-10.2,-10.2,-11.5,-12.7,-12.9,-14.1,-15.4,-17.9,-21.1,-25.4,-27.8,15.6,2.1,-0.1,-2.3,-4.9,-7.6,-7.7,-9.4,-9.4,-9.4,-9.4,-9.4,-10.5,-11.7,-12,-13,-14.4,-16.9,-20.1,-24.4,-26.7,15.9,2.4,0.2,-1.9,-4.5,-7.2,-7.2,-8.5,-8.5,-8.5,-8.5,-8.5,-9.6,-10.8,-11.1,-12.1,-13.4,-15.9,-19.2,-23.4,-25.7,16.2,2.7,0.6,-1.6,-4.1,-6.7,-6.6,-7.7,-7.7,-7.7,-7.7,-7.7,-8.8,-9.9,-10.3,-11.2,-12.5,-14.9,-18.3,-22.4,-24.7,16.4,2.9,0.9,-1.2,-3.7,-6.3,-6,-6.9,-6.9,-6.9,-6.9,-6.9,-8.1,-9.1,-9.5,-10.3,-11.7,-14,-17.4,-21.5,-23.7,16.7,3.2,1.2,-0.9,-3.4,-5.9,-5.5,-6.2,-6.2,-6.2,-6.2,-6.2,-7.4,-8.3,-8.8,-9.5,-10.9,-13.2,-16.6,-20.6,-22.7,16.9,3.4,1.5,-0.6,-3,-5.5,-5,-5.5,-5.5,-5.5,-5.5,-5.5,-6.7,-7.7,-8.1,-8.8,-10.2,-12.4,-15.8,-19.7,-21.8,17.2,3.7,1.7,-0.2,-2.7,-5.1,-4.5,-4.9,-4.9,-4.9,-4.9,-4.9,-6.1,-7.1,-7.4,-8.1,-9.6,-11.6,-15,-18.8,-20.8,17.4,3.9,2.1,0.1,-2.3,-4.7,-4.1,-4.4,-4.4,-4.4,-4.4,-4.4,-5.6,-6.5,-6.9,-7.5,-8.9,-10.8,-14.2,-18,-19.9,17.6,4.1,2.3,0.4,-2,-4.3,-3.7,-3.8,-3.8,-3.8,-3.8,-3.8,-5,-5.9,-6.3,-6.9,-8.3,-10.1,-13.5,-17.2,-19,17.8,4.3,2.5,0.6,-1.7,-4,-3.2,-3.3,-3.3,-3.3,-3.3,-3.3,-4.6,-5.5,-5.9,-6.4,-7.8,-9.5,-12.9,-16.6,-18.2,18,4.5,2.7,0.9,-1.4,-3.6,-2.8,-2.8,-2.8,-2.8,-2.8,-2.8,-4.2,-5.1,-5.5,-6.1,-7.4,-9,-12.4,-16.1,-17.6,18.1,4.6,2.9,1.1,-1.1,-3.3,-2.5,-2.5,-2.5,-2.5,-2.5,-2.5,-3.8,-4.7,-5.1,-5.7,-7.1,-8.6,-12,-15.7,-17.2,18.2,4.7,3.1,1.3,-0.8,-3.1,-2.2,-2.2,-2.2,-2.2,-2.2,-2.2,-3.4,-4.4,-4.9,-5.4,-6.8,-8.3,-11.7,-15.3,-16.8,18.4,4.9,3.2,1.5,-0.6,-2.8,-1.9,-1.9,-1.9,-1.9,-1.9,-1.9,-3.1,-4.1,-4.6,-5.2,-6.6,-8,-11.4,-14.9,-16.5,18.5,5,3.4,1.6,-0.4,-2.6,-1.7,-1.7,-1.7,-1.7,-1.7,-1.7,-2.8,-3.8,-4.4,-4.9,-6.4,-7.8,-11.2,-14.6,-16.3,18.6,5.1,3.5,1.8,-0.2,-2.3,-1.4,-1.4,-1.4,-1.4,-1.4,-1.4,-2.6,-3.6,-4.2,-4.8,-6.2,-7.6,-11,-14.4,-16,18.7,5.2,3.6,2,0,-2.1,-1.2,-1.2,-1.2,-1.2,-1.2,-1.2,-2.4,-3.4,-4.1,-4.6,-6,-7.4,-10.8,-14.2,-15.8,18.8,5.3,3.7,2.1,0.2,-1.8,-0.9,-0.9,-0.9,-0.9,-0.9,-0.9,-2.1,-3.2,-3.9,-4.4,-5.8,-7.3,-10.6,-14,-15.6,18.9,5.4,3.8,2.2,0.3,-1.6,-0.7,-0.7,-0.7,-0.7,-0.7,-0.7,-1.9,-3,-3.7,-4.3,-5.7,-7.1,-10.5,-13.8,-15.5,18.9,5.4,3.9,2.4,0.5,-1.4,-0.5,-0.5,-0.5,-0.5,-0.5,-0.5,-1.7,-2.8,-3.5,-4.1,-5.5,-6.9,-10.3,-13.6,-15.3,19,5.5,4,2.5,0.7,-1.3,-0.3,-0.3,-0.3,-0.3,-0.3,-0.3,-1.5,-2.6,-3.4,-3.9,-5.3,-6.7,-10.1,-13.5,-15.2,19.1,5.6,4.1,2.7,0.9,-1.1,-0.1,-0.1,-0.1,-0.1,-0.1,-0.1,-1.3,-2.4,-3.2,-3.8,-5.2,-6.6,-10,-13.4,-15,19.2,5.7,4.2,2.8,1,-0.8,0.1,0.1,0.1,0.1,0.1,0.1,-1.1,-2.2,-3,-3.6,-5,-6.4,-9.8,-13.2,-14.9,19.3,5.8,4.3,2.9,1.2,-0.6,0.3,0.3,0.3,0.3,0.3,0.3,-0.9,-2,-2.9,-3.4,-4.8,-6.3,-9.7,-13.1,-14.7,19.4,5.9,4.4,3,1.3,-0.4,0.5,0.5,0.5,0.5,0.5,0.5,-0.8,-1.8,-2.7,-3.3,-4.7,-6.1,-9.6,-13,-14.6,19.4,5.9,4.5,3.2,1.5,-0.2,0.6,0.6,0.6,0.6,0.6,0.6,-0.6,-1.6,-2.5,-3.2,-4.5,-5.9,-9.4,-12.8,-14.5,19.5,6,4.6,3.3,1.7,0,0.8,0.8,0.8,0.8,0.8,0.8,-0.4,-1.5,-2.4,-3,-4.4,-5.7,-9.3,-12.7,-14.4,19.6,6.1,4.6,3.4,1.9,0.2,1,1,1,1,1,1,-0.2,-1.3,-2.2,-2.9,-4.2,-5.6,-9.2,-12.5,-14.2,19.7,6.2,4.7,3.5,2,0.4,1.1,1.1,1.1,1.1,1.1,1.1,0,-1.1,-2,-2.7,-4.1,-5.5,-9.1,-12.4,-14.1,19.7,6.2,4.8,3.6,2.2,0.6,1.3,1.3,1.3,1.3,1.3,1.3,0.1,-1,-1.9,-2.6,-4,-5.4,-8.9,-12.3,-13.9,19.8,6.3,4.9,3.7,2.3,0.8,1.5,1.5,1.5,1.5,1.5,1.5,0.3,-0.8,-1.8,-2.4,-3.9,-5.2,-8.8,-12.2,-13.8,19.9,6.4,5,3.8,2.5,1,1.6,1.6,1.6,1.6,1.6,1.6,0.4,-0.7,-1.6,-2.3,-3.7,-5.1,-8.7,-12.1,-13.7,19.9,6.4,5,3.9,2.6,1.1,1.7,1.7,1.7,1.7,1.7,1.7,0.6,-0.5,-1.4,-2.1,-3.6,-4.9,-8.6,-12,-13.6,20,6.5,5.1,4,2.7,1.3,1.8,1.8,1.8,1.8,1.8,1.8,0.7,-0.4,-1.3,-2,-3.5,-4.8,-8.5,-11.9,-13.5'),(1, 203, 0, '1'),(1, 204, 0, '2,-20,-32,-40,-42,-43,-44,-44,-44,-45,-45,-46,-46,-46,-46,-47,-47,-48,-48,-49,-49'),(1, 245, 0, '10'),(1, 242, 0, '300,150,148,146,144,142,139,137,135,133,131,129,127,125,123,121,118,116,114,112,110'),(1, 218, 0, '20'),(1, 243, 0, '10')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (244, 5),(246, 5),(203, 5),(204, 5),(245, 5),(242, 5),(218, 5),(243, 5)");
        dbConnection.update("INSERT INTO parameter VALUES (355, 15, 1, 'Wireless frequency', 'decimal:40:10000', 'MHz', '', '<HTML>Wireless station channel center frequency.</HTML>', true),(356, 15, 2, 'Wireless bandwidth', 'decimal:0.1:20', 'MHz', '', '<HTML>Wireless station channel bandwidth.</HTML>', true)");
        dbConnection.update("INSERT INTO template_parameter_data VALUES (1, 355, 0, '650'),(1, 356, 0, '5')");
        dbConnection.update("INSERT INTO parameter_study_type VALUES (355, 3),(356, 3)");
    }

    private static void doUpdateDb(DbInfo dbInfo, int n, StatusLogger statusLogger) throws SQLException {
        if (null != statusLogger) {
            statusLogger.reportStatus("Updating to version 20300012, please wait...");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        switch (n) {
            default: {
                throw new SQLException("Unknown version number, cannot update database");
            }
            case 201000: 
            case 201001: {
                DbCore.update201002(dbInfo);
            }
            case 201002: 
            case 201003: 
            case 202000: {
                DbCore.update202001(dbInfo);
            }
            case 202001: {
                DbCore.update202002(dbInfo);
            }
            case 202002: {
                DbCore.update202003(dbInfo);
            }
            case 202003: 
            case 20200301: {
                DbCore.update20200302(dbInfo);
            }
            case 20200302: {
                DbCore.update20200400(dbInfo);
            }
            case 20200400: {
                DbCore.update20200401(dbInfo);
            }
            case 20200401: {
                DbCore.update20200500(dbInfo);
            }
            case 20200500: {
                DbCore.update20200501(dbInfo);
            }
            case 20200501: 
            case 20200502: {
                DbCore.update20200600(dbInfo);
            }
            case 20200600: {
                DbCore.update20200601(dbInfo);
            }
            case 20200601: {
                DbCore.update20200602(dbInfo);
            }
            case 20200602: {
                DbCore.update20200603(dbInfo);
            }
            case 20200603: 
            case 20300000: {
                DbCore.update20300001(dbInfo);
            }
            case 20300001: {
                DbCore.update20300002(dbInfo);
            }
            case 20300002: 
            case 20300003: {
                DbCore.update20300004(dbInfo, statusLogger);
            }
            case 20300004: 
            case 20300005: 
            case 20300006: 
            case 20300007: {
                DbCore.update20300008(dbInfo, statusLogger);
            }
            case 20300008: 
            case 20300009: {
                DbCore.update20300010(dbInfo, statusLogger);
            }
            case 20300010: {
                DbCore.update20300011(dbInfo, statusLogger);
            }
            case 20300011: 
        }
        bl = true;
        bl2 = true;
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        if (bl) {
            DbCore.doReloadPopulation(dbConnection, statusLogger);
        }
        if (bl2) {
            DbCore.doUpdateRootData(dbConnection);
        }
        if (bl3) {
            dbConnection.update("UPDATE study SET needs_update = 1");
        }
        if (bl4) {
            dbConnection.update("DELETE FROM application_property");
        }
        dbConnection.update("UPDATE version SET version = 20300012");
    }

    private static void update201002(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        dbConnection.query("SELECT study_key FROM study");
        while (dbConnection.next()) {
            arrayList.add(dbConnection.getInt(1));
        }
        for (Integer n : arrayList) {
            dbConnection.setDatabase(dbInfo.dbName + "_" + n);
            dbConnection.update("UPDATE source SET antenna_id = '', horizontal_pattern_name = (CASE WHEN has_horizontal_pattern THEN '(replication)' ELSE '' END) WHERE original_source_key <> 0");
        }
    }

    private static void update202001(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("ALTER TABLE ix_check_status CHANGE COLUMN run_date run_date DATETIME NOT NULL");
    }

    private static void update202002(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("ALTER TABLE ext_db ADD COLUMN is_download BOOLEAN NOT NULL");
        dbConnection.update("ALTER TABLE version DROP COLUMN do_import");
        dbConnection.update("CREATE TABLE xml_import (file_name VARCHAR(255) NOT NULL, mod_time BIGINT NOT NULL, length BIGINT NOT NULL)");
    }

    private static void update202003(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("ALTER TABLE user_record CHANGE COLUMN file_number file_number VARCHAR(255) NOT NULL");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        dbConnection.query("SELECT study_key FROM study");
        while (dbConnection.next()) {
            arrayList.add(dbConnection.getInt(1));
        }
        for (Integer n : arrayList) {
            dbConnection.setDatabase(dbInfo.dbName + "_" + n);
            dbConnection.update("ALTER TABLE source CHANGE COLUMN file_number file_number VARCHAR(255) NOT NULL");
        }
    }

    private static void update20200302(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("INSERT INTO color_map VALUES (6, 160, 0, 0)");
        dbConnection.update("INSERT INTO color_map_data VALUES (6, -998, 0, 80, 180),(6, 0, 220, 100, 100),(6, 10, 220, 120, 0),(6, 20, 140, 180, 0),(6, 30, 40, 180, 0),(6, 40, 0, 180, 70)");
        dbConnection.update("CREATE TABLE color_map_default (color_map_key INT PRIMARY KEY,bg_color_r INT NOT NULL,bg_color_g INT NOT NULL,bg_color_b INT NOT NULL)");
        dbConnection.update("CREATE TABLE color_map_data_default (color_map_key INT NOT NULL,level DOUBLE NOT NULL,color_r INT NOT NULL,color_g INT NOT NULL,color_b INT NOT NULL)");
        dbConnection.update("INSERT INTO color_map_default VALUES (1, 0, 80, 180),(2, 0, 80, 180),(3, 0, 80, 180),(4, 0, 80, 180),(5, 0, 80, 180),(6, 160, 0, 0)");
        dbConnection.update("INSERT INTO color_map_data_default VALUES (1, 0, 180, 0, 0),(1, 10, 180, 100, 0),(1, 20, 140, 180, 0),(1, 30, 40, 180, 0),(1, 40, 0, 180, 70),(2, -6, 180, 0, 0),(2, -3, 180, 100, 0),(2, 0, 140, 180, 0),(2, 3, 40, 180, 0),(2, 6, 0, 180, 70),(3, -6, 180, 0, 0),(3, -3, 180, 100, 0),(3, 0, 140, 180, 0),(3, 3, 40, 180, 0),(3, 6, 0, 180, 70),(4, -6, 180, 0, 0),(4, -3, 180, 100, 0),(4, 0, 140, 180, 0),(4, 3, 40, 180, 0),(4, 6, 0, 180, 68),(5, -6, 180, 0, 0),(5, -3, 180, 100, 0),(5, 0, 140, 180, 0),(5, 3, 40, 180, 0),(5, 6, 0, 180, 70),(6, -998, 0, 80, 180),(6, 0, 220, 100, 100),(6, 10, 220, 120, 0),(6, 20, 140, 180, 0),(6, 30, 40, 180, 0),(6, 40, 0, 180, 70)");
    }

    private static void update20200400(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        dbConnection.query("SELECT study_key, study_type FROM study");
        while (dbConnection.next()) {
            arrayList.add(dbConnection.getInt(1));
            arrayList2.add(dbConnection.getInt(2) == 2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n = (Integer)arrayList.get(i);
            boolean bl = (Boolean)arrayList2.get(i);
            dbConnection.setDatabase(dbInfo.dbName + "_" + n);
            dbConnection.update("ALTER TABLE scenario ADD COLUMN scenario_type INT NOT NULL DEFAULT 1 AFTER description");
            dbConnection.update("ALTER TABLE scenario ADD COLUMN parent_scenario_key INT NOT NULL DEFAULT 0");
            dbConnection.update("ALTER TABLE source ADD COLUMN attributes VARCHAR(20000) NOT NULL DEFAULT ''");
            dbConnection.update("UPDATE source SET attributes = 'isBaseline\n' WHERE status = 'BL'");
            if (!bl) continue;
            dbConnection.update("UPDATE scenario SET scenario_type = 2 WHERE scenario_key = 1");
            dbConnection.update("UPDATE scenario SET scenario_type = 3, parent_scenario_key = 1, is_permanent = false WHERE scenario_key <> 1");
            dbConnection.query("SELECT source_key FROM scenario_source WHERE scenario_key = 1 ORDER BY 1");
            if (!dbConnection.next()) continue;
            int n2 = dbConnection.getInt(1);
            dbConnection.update("UPDATE source SET attributes = CONCAT(attributes, '-isProposal\n') WHERE source_key = " + n2);
            dbConnection.query("SELECT original_source_key FROM source WHERE source_key = " + n2);
            if (!dbConnection.next() || (n2 = dbConnection.getInt(1)) <= 0) continue;
            dbConnection.update("UPDATE source SET attributes = CONCAT(attributes, '-isProposal\n') WHERE source_key = " + n2);
        }
        dbConnection.setDatabase(dbInfo.dbName);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        dbConnection.query("SELECT ext_db_key, db_type FROM ext_db WHERE db_type IN (6,7,8) AND NOT deleted");
        while (dbConnection.next()) {
            arrayList3.add(dbConnection.getInt(1));
            arrayList4.add(dbConnection.getInt(2));
        }
        for (int i = 0; i < arrayList3.size(); ++i) {
            dbConnection.setDatabase(ExtDb.makeDbName(dbInfo.dbName, (Integer)arrayList4.get(i), (Integer)arrayList3.get(i)));
            dbConnection.update("ALTER TABLE source CHANGE COLUMN file_number file_number VARCHAR(255) NOT NULL");
            dbConnection.update("ALTER TABLE source ADD COLUMN attributes VARCHAR(20000) NOT NULL DEFAULT ''");
        }
    }

    private static void update20200401(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("UPDATE country_poly SET is_border = false WHERE poly_seq = 2000 AND vertex_seq IN (1, 2, 3, 4)");
        dbConnection.update("ALTER TABLE user_record CHANGE COLUMN xml_data xml_data MEDIUMTEXT NOT NULL");
        dbConnection.update("ALTER TABLE ext_db_search ADD COLUMN search_type INT NOT NULL DEFAULT 1 AFTER is_desired");
        dbConnection.update("UPDATE ext_db_search SET search_type = 2 WHERE NOT is_desired");
        dbConnection.update("ALTER TABLE ext_db_search DROP COLUMN is_desired");
        dbConnection.update("ALTER TABLE ext_db_search ADD COLUMN minimum_channel INT NOT NULL DEFAULT 0 AFTER longitude");
        dbConnection.update("ALTER TABLE ext_db_search ADD COLUMN maximum_channel INT NOT NULL DEFAULT 0 AFTER minimum_channel");
    }

    private static void update20200500(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("ALTER TABLE ext_db ADD PRIMARY KEY (ext_db_key)");
        dbConnection.update("ALTER TABLE ext_db_search ADD COLUMN mx_facility_id_only BOOLEAN NOT NULL AFTER disable_mx");
        dbConnection.update("ALTER TABLE study ADD COLUMN folder_key INT NOT NULL DEFAULT 0 AFTER description");
        dbConnection.update("CREATE TABLE folder (folder_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,parent_folder_key INT NOT NULL DEFAULT 0)");
    }

    private static void update20200501(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("DELETE FROM study_geography WHERE study_key NOT IN (SELECT study_key FROM study)");
        dbConnection.update("DELETE FROM geography WHERE study_key > 0 AND study_key NOT IN (SELECT study_key FROM study)");
        dbConnection.update("DELETE FROM geo_point_set WHERE geo_key NOT IN (SELECT geo_key FROM geography)");
        dbConnection.update("DELETE FROM geo_polygon WHERE geo_key NOT IN (SELECT geo_key FROM geography)");
        dbConnection.update("DELETE FROM geo_sectors WHERE geo_key NOT IN (SELECT geo_key FROM geography)");
        dbConnection.update("DELETE FROM geography_receive_antenna WHERE geo_key NOT IN (SELECT geo_key FROM geography)");
    }

    private static void update20200600(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("ALTER TABLE ext_db_search ADD COLUMN include_sharing_guests BOOLEAN NOT NULL AFTER maximum_channel");
        dbConnection.update("DROP TABLE IF EXISTS country_poly");
    }

    private static void update20200601(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("ALTER TABLE study ADD COLUMN has_result_tables BOOLEAN NOT NULL DEFAULT false AFTER needs_update");
        dbConnection.update("DROP TABLE color_map");
        dbConnection.update("DROP TABLE color_map_data");
        dbConnection.update("DROP TABLE color_map_default");
        dbConnection.update("DROP TABLE color_map_data_default");
        dbConnection.update("CREATE TABLE color_map (color_map_key INT PRIMARY KEY,name VARCHAR(255) NOT NULL,permanent BOOLEAN NOT NULL)");
        dbConnection.update("CREATE TABLE color_map_data (color_map_key INT NOT NULL,level DOUBLE NOT NULL,color_r INT NOT NULL,color_g INT NOT NULL,color_b INT NOT NULL)");
        dbConnection.update("INSERT INTO color_map VALUES (1, 'Signal margin', true),(2, 'D/U margin', true),(3, 'Signal margin w/ IX', true)");
        dbConnection.update("INSERT INTO color_map_data VALUES (1, -999, 255, 255, 242),(1, -998, -1, -1, -1),(1, -997, 255, 255, 242),(1, 0, 244, 240, 198),(1, 10, 232, 232, 52),(1, 20, 255, 173, 42),(1, 30, 255, 116, 20),(1, 40, 255, 32, 0),(2, -999, -1, -1, -1),(2, -998, -1, -1, -1),(2, -997, 153, 0, 0),(2, -6, 204, 0, 0),(2, -3, 204, 113, 0),(2, 0, 158, 204, 0),(2, 3, 45, 204, 0),(2, 6, 0, 204, 79),(3, -999, 255, 255, 242),(3, -998, 51, 51, 255),(3, -997, 255, 255, 242),(3, 0, 244, 240, 198),(3, 10, 232, 232, 52),(3, 20, 255, 173, 42),(3, 30, 255, 116, 20),(3, 40, 255, 32, 0)");
    }

    private static void update20200602(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("ALTER TABLE study ADD COLUMN had_result_tables BOOLEAN NOT NULL DEFAULT false AFTER has_result_tables");
        dbConnection.update("UPDATE study SET had_result_tables = has_result_tables");
    }

    private static void update20200603(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("ALTER TABLE ext_db_search ADD COLUMN record_type INT NOT NULL AFTER name");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        dbConnection.query("SELECT DISTINCT study_type FROM ext_db_search");
        while (dbConnection.next()) {
            arrayList.add(dbConnection.getInt(1));
        }
        for (Integer n : arrayList) {
            dbConnection.update("UPDATE ext_db_search SET record_type = " + String.valueOf(Study.getDefaultRecordType(n)) + " WHERE study_type = " + String.valueOf(n));
        }
        dbConnection.update("ALTER TABLE study ADD COLUMN template_locked BOOLEAN NOT NULL AFTER template_key");
        dbConnection.update("UPDATE study SET template_locked = (SELECT locked_in_study FROM template WHERE template_key = study.template_key)");
    }

    private static void update20300001(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("ALTER TABLE study ADD COLUMN out_directory VARCHAR(10000) NOT NULL AFTER output_config_map_codes");
        Path path = Paths.get("out", new String[0]);
        if ((dbInfo.dbHostname.equals("localhost") || dbInfo.dbHostname.equals("127.0.0.1")) && dbInfo.dbName.equals(DEFAULT_DB_NAME)) {
            path = path.resolve(dbInfo.dbHostname);
        }
        dbConnection.update("UPDATE study SET out_directory = '" + DbConnection.clean(path.toString()) + "'");
    }

    private static void update20300002(DbInfo dbInfo) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("ALTER TABLE ext_db ADD COLUMN index_version INT NOT NULL AFTER version");
    }

    private static void update20300004(DbInfo dbInfo, StatusLogger statusLogger) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        dbConnection.query("SELECT study_key FROM study");
        while (dbConnection.next()) {
            arrayList.add(dbConnection.getInt(1));
        }
        for (Integer n : arrayList) {
            dbConnection.setDatabase(dbInfo.dbName + "_" + n);
            dbConnection.query("SHOW TABLES LIKE 'saved_query'");
            if (!dbConnection.next()) continue;
            dbConnection.update("ALTER TABLE saved_query ADD COLUMN no_result BOOLEAN NOT NULL");
        }
    }

    private static void update20300008(DbInfo dbInfo, StatusLogger statusLogger) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("DROP TABLE service");
        dbConnection.update("CREATE TABLE service (service_key INT NOT NULL PRIMARY KEY,name VARCHAR(255) NOT NULL,service_code CHAR(2) NOT NULL,service_type_key INT NOT NULL,is_dts BOOLEAN NOT NULL,is_operating BOOLEAN NOT NULL,preference_rank INT NOT NULL,digital_service_key INT NOT NULL,display_order INT NOT NULL)");
    }

    private static void update20300010(DbInfo dbInfo, StatusLogger statusLogger) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("ALTER TABLE ext_db ADD COLUMN bad_data BOOLEAN NOT NULL");
        dbConnection.update("ALTER TABLE template ADD COLUMN hidden DATE");
    }

    private static void update20300011(DbInfo dbInfo, StatusLogger statusLogger) throws SQLException {
        DbConnection dbConnection = dbInfo.db;
        dbConnection.setDatabase(dbInfo.dbName);
        dbConnection.update("ALTER TABLE study ADD COLUMN created DATETIME");
        dbConnection.update("ALTER TABLE study ADD COLUMN modified DATETIME");
        dbConnection.update("ALTER TABLE study ADD COLUMN last_run DATETIME");
        dbConnection.update("UPDATE xml_import SET mod_time = mod_time / 1000");
    }

    static {
        NAME_RESERVED_CHARS = new char[]{'/', '\\', ':', '#'};
        dbs = new HashMap();
        dbPools = new HashMap();
        openDbs = new HashMap();
        dbInUse = new HashMap();
        propertyMaps = new HashMap();
        changedPropertyMaps = new HashMap();
        lastPropertySyncTimes = new HashMap();
        didCacheLoad = false;
        didCheckSocketFile = false;
        POP_FILE_BASE_NAME = new String[]{"pop_us_2000", "pop_us_2010", "pop_us_2020", "pop_ca_2006", "pop_ca_2011", "pop_ca_2016", "pop_ca_2021", "pop_mx_2010", "pop_mx_2020"};
        POP_COUNTRY_KEY = new int[]{1, 1, 1, 2, 2, 2, 2, 3, 3};
        POP_CENSUS = new int[]{2000, 2010, 2020, 2006, 2011, 2016, 2021, 2010, 2020};
        POP_COUNTRY_NAME = new String[]{"U.S.", "U.S.", "U.S.", "Canada", "Canada", "Canada", "Canada", "Mexico", "Mexico"};
        POP_HAS_ZCTA = new boolean[]{true, true, true, false, false, false, false, false, false};
        POP_SEGMENT_FIELDS = new int[]{3, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1};
        POP_NAMES_FIELDS = new int[]{1, 1, 1, 3};
        POP_ZCTA_FIELDS = new int[]{3, 1};
    }

    public static class DbInfo {
        public final String dbHostname;
        public final boolean dbIsLocal;
        public final String dbName;
        public final String dbUsername;
        public final String dbPassword;
        public DbConnection db;
        public boolean hasRoot;
        public boolean hasVersionTable;
        public int version;
        public String dbID;
        public String idKey;
        public long cacheSize;
        public String setupError = "Unknown error";
        public boolean connectionFailed;
        public String lookupErrorMessage;
        public String statusText;
        public boolean needsSetup;
        public boolean canInstall;
        public boolean canUninstall;
        public boolean canUnlock;
        public boolean canUpdate;
        public boolean canOpen;

        public DbInfo(String string, String string2, String string3, String string4, ErrorLogger errorLogger) {
            this.dbHostname = string;
            this.dbIsLocal = string.equalsIgnoreCase("localhost") || string.equals("127.0.0.1");
            this.dbName = string2;
            this.dbUsername = string3;
            this.dbPassword = string4;
            this.idKey = this.dbName.equals(DbCore.DEFAULT_DB_NAME) ? DbCore.DB_ID_KEY_PREFIX + this.dbHostname : DbCore.DB_ID_KEY_PREFIX + this.dbHostname + "_" + this.dbName;
            if (this.dbUsername.length() > 0 && this.dbPassword.length() > 0) {
                this.db = new DbConnection("jdbc:mysql:", this.dbHostname, this.dbUsername, this.dbPassword);
                this.db.setConnectionProperty("characterEncoding", "latin1");
                this.db.setConnectionProperty("characterSetResults", "latin1");
                this.db.setConnectionProperty("serverTimezone", "UTC");
                this.db.setConnectionProperty("useSSL", "false");
                this.db.setConnectionProperty("sslMode", "DISABLED");
                this.db.setConnectionProperty("allowPublicKeyRetrieval", "true");
                if (this.db.connect(errorLogger)) {
                    AppCore.setProperty(DbCore.DEFAULT_HOST_KEY, this.dbHostname);
                    AppCore.setProperty(DbCore.DEFAULT_NAME_KEY, this.dbName);
                    AppCore.setProperty(DbCore.DEFAULT_USER_KEY, this.dbUsername);
                } else {
                    this.db = null;
                    this.setupError = "Cannot connect to the database server";
                    this.connectionFailed = true;
                    this.statusText = "Connection failed";
                }
            } else {
                this.statusText = "No connection";
            }
            this.update();
            if (null != this.db) {
                this.db.close();
            }
        }

        public synchronized void update() {
            this.hasRoot = false;
            this.hasVersionTable = false;
            this.version = 0;
            this.dbID = this.dbHostname;
            boolean bl = false;
            boolean bl2 = false;
            String string = AppCore.getProperty(this.idKey);
            if (null != string) {
                try {
                    UUID.fromString(string);
                    this.dbID = string;
                    bl = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.lookupErrorMessage = null;
            this.needsSetup = true;
            this.canInstall = false;
            this.canUninstall = false;
            this.canUnlock = false;
            this.canUpdate = false;
            this.canOpen = false;
            if (null == this.db) {
                return;
            }
            try {
                int n = 0;
                this.db.query("SHOW DATABASES LIKE '" + this.dbName + "'");
                this.hasRoot = this.db.next();
                if (this.hasRoot) {
                    this.version = -1;
                    this.db.setDatabase(this.dbName);
                    this.db.query("SHOW TABLES LIKE 'study'");
                    if (this.db.next()) {
                        this.db.query("SHOW CREATE TABLE study");
                        this.db.next();
                        String string2 = this.db.getString(2);
                        this.db.query("SHOW TABLES LIKE 'version'");
                        this.hasVersionTable = this.db.next();
                        if (this.hasVersionTable) {
                            this.db.query("SELECT * FROM version");
                            if (this.db.next()) {
                                this.version = this.db.getInt("version");
                                if (this.version >= 102010) {
                                    string = this.db.getString("uuid");
                                    if (!bl || !this.dbID.equals(string)) {
                                        try {
                                            UUID.fromString(string);
                                            this.dbID = string;
                                            bl = true;
                                            bl2 = true;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {}
                                    }
                                }
                            }
                        } else if (string2.contains("version")) {
                            this.db.query("SELECT MAX(version) FROM study");
                            if (this.db.next()) {
                                this.version = this.db.getInt(1);
                            }
                        }
                        if (string2.contains("study_lock")) {
                            this.db.query("SELECT COUNT(*) FROM study WHERE study_lock <> 0");
                            this.db.next();
                            n = this.db.getInt(1);
                        }
                    }
                }
                if (bl2) {
                    AppCore.setProperty(this.idKey, this.dbID);
                }
                if (this.hasRoot) {
                    this.canUninstall = true;
                    if (20300012 == this.version && bl) {
                        this.statusText = "OK";
                        this.needsSetup = false;
                        this.canUnlock = n > 0;
                        this.canOpen = true;
                    } else if (0 == this.version) {
                        this.setupError = "Database is currently being updated or installed";
                        this.statusText = "In update or install";
                    } else {
                        this.canUpdate = DbCore.canUpdateDb(this.version);
                        if (this.canUpdate) {
                            this.setupError = "Database needs to be updated";
                            this.statusText = "Needs update";
                            if (n > 0) {
                                this.canUnlock = true;
                                this.canUpdate = false;
                            }
                        } else {
                            this.setupError = "Unknown or unsupported database version";
                            this.statusText = "Unsupported";
                        }
                    }
                } else {
                    this.setupError = "Database is not installed on the server";
                    this.statusText = "Not installed";
                    this.canInstall = true;
                }
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
                this.setupError = "Database query error: " + sQLException;
                this.lookupErrorMessage = "An operation cannot be completed due to a database error:\n" + sQLException;
                this.statusText = "Query error";
            }
        }

        public synchronized void updateCacheSize() {
            this.cacheSize = AppCore.getStudyCacheSize(this.dbID);
        }
    }
}

