/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class DbConnection {
    public static final String ERROR_TEXT_PREFIX = "An operation cannot be completed due to a database error:\n";
    private static final int IDLE_CLOSE_TIME = 30000;
    public final String driver;
    public final String hostname;
    public final String username;
    public final String password;
    private Properties connectionProperties;
    private Connection connection;
    private String dbName;
    private Statement statement;
    private boolean connected;
    private ResultSet resultSet;
    private Thread inTransactionForThread;
    private boolean canLinger;
    private TimerTask closeTask;
    private static Timer closeTimer = new Timer(true);

    public DbConnection(String string, String string2, String string3, String string4) {
        this.driver = string;
        this.hostname = string2;
        this.username = string3;
        this.password = string4;
        this.connectionProperties = new Properties();
    }

    public DbConnection copy() {
        DbConnection dbConnection = new DbConnection(this.driver, this.hostname, this.username, this.password);
        dbConnection.connectionProperties.putAll((Map<?, ?>)this.connectionProperties);
        return dbConnection;
    }

    public void setConnectionProperty(String string, String string2) {
        this.connectionProperties.setProperty(string, string2);
    }

    public boolean connect() {
        return this.connect(null, null);
    }

    public boolean connect(String string) {
        return this.connect(string, null);
    }

    public boolean connect(ErrorLogger errorLogger) {
        return this.connect(null, errorLogger);
    }

    public synchronized boolean connect(String string, ErrorLogger errorLogger) {
        block10: {
            if (this.connected) {
                if (null != errorLogger) {
                    errorLogger.reportError("An operation cannot be completed because the\ndatabase server connection is already in use");
                }
                return false;
            }
            if (null != this.closeTask) {
                this.closeTask.cancel();
                this.closeTask = null;
            }
            if (null != string && 0 == (string = string.trim()).length()) {
                string = null;
            }
            if (null != this.connection && null != string && !string.equals(this.dbName)) {
                this.close(false);
            }
            if (null == this.connection) {
                try {
                    String string2 = this.driver + "//" + this.hostname;
                    if (null != string) {
                        string2 = string2 + "/" + string;
                    }
                    this.connectionProperties.setProperty("user", this.username);
                    this.connectionProperties.setProperty("password", this.password);
                    this.connection = DriverManager.getConnection(string2, this.connectionProperties);
                    this.dbName = string;
                    this.canLinger = true;
                }
                catch (SQLException sQLException) {
                    AppCore.log(3, "Database connection failed", sQLException);
                    if (null == errorLogger) break block10;
                    errorLogger.reportError("Cannot connect to the database server:\n" + sQLException);
                }
            }
        }
        if (null != this.connection) {
            this.connected = true;
        }
        return this.connected;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setDatabase(String string) throws SQLException {
        if (!this.connected) {
            return;
        }
        if (null == string) {
            return;
        }
        if (0 == (string = string.trim()).length()) {
            return;
        }
        if (string.equals(this.dbName)) {
            return;
        }
        try {
            if (null != this.statement) {
                this.resultSet = null;
                Statement statement = this.statement;
                this.statement = null;
                statement.close();
            }
            this.connection.setCatalog(string);
            this.dbName = string;
        }
        catch (SQLException sQLException) {
            this.canLinger = false;
            throw sQLException;
        }
    }

    public String getDatabase() {
        return this.dbName;
    }

    public synchronized void query(String string) throws SQLException {
        if (!this.connected) {
            throw new SQLException("DbConnection.query(): connection is not open");
        }
        if (null != this.inTransactionForThread && Thread.currentThread() != this.inTransactionForThread) {
            throw new SQLException("DbConnection.query(): transaction was opened on a different thread");
        }
        try {
            if (null == this.statement) {
                this.statement = this.connection.createStatement();
            }
            this.resultSet = this.statement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            this.canLinger = false;
            throw sQLException;
        }
    }

    public synchronized int update(String string) throws SQLException {
        if (!this.connected) {
            throw new SQLException("DbConnection.update(): connection is not open");
        }
        if (null != this.inTransactionForThread && Thread.currentThread() != this.inTransactionForThread) {
            throw new SQLException("DbConnection.update(): transaction was opened on a different thread");
        }
        int n = 0;
        try {
            if (null == this.statement) {
                this.statement = this.connection.createStatement();
            }
            n = this.statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            this.canLinger = false;
            throw sQLException;
        }
        return n;
    }

    public boolean next() throws SQLException {
        if (null == this.resultSet) {
            return false;
        }
        return this.resultSet.next();
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    public String getString(int n) throws SQLException {
        return this.resultSet.getString(n);
    }

    public String getString(String string) throws SQLException {
        return this.resultSet.getString(string);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.resultSet.getBoolean(n);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.resultSet.getBoolean(string);
    }

    public int getInt(int n) throws SQLException {
        return this.resultSet.getInt(n);
    }

    public int getInt(String string) throws SQLException {
        return this.resultSet.getInt(string);
    }

    public long getLong(int n) throws SQLException {
        return this.resultSet.getLong(n);
    }

    public long getLong(String string) throws SQLException {
        return this.resultSet.getLong(string);
    }

    public float getFloat(int n) throws SQLException {
        return this.resultSet.getFloat(n);
    }

    public float getFloat(String string) throws SQLException {
        return this.resultSet.getFloat(string);
    }

    public double getDouble(int n) throws SQLException {
        return this.resultSet.getDouble(n);
    }

    public double getDouble(String string) throws SQLException {
        return this.resultSet.getDouble(string);
    }

    public Date getDate(int n) throws SQLException {
        return this.resultSet.getDate(n);
    }

    public Date getDate(String string) throws SQLException {
        return this.resultSet.getDate(string);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.resultSet.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.resultSet.getTimestamp(string);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSet.getMetaData();
    }

    public synchronized void begin() throws SQLException {
        if (!this.connected) {
            throw new SQLException("DbConnection.begin(): connection is not open");
        }
        if (null != this.inTransactionForThread) {
            throw new SQLException("DbConnection.begin(): a transaction is already open");
        }
        try {
            this.inTransactionForThread = Thread.currentThread();
            this.connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            this.canLinger = false;
            throw sQLException;
        }
    }

    public synchronized void commit() throws SQLException {
        if (!this.connected) {
            throw new SQLException("DbConnection.commit(): connection is not open");
        }
        if (null == this.inTransactionForThread) {
            throw new SQLException("DbConnection.commit(): no transaction is open");
        }
        if (Thread.currentThread() != this.inTransactionForThread) {
            throw new SQLException("DbConnection.commit(): transaction was opened on a different thread");
        }
        try {
            this.connection.commit();
            this.connection.setAutoCommit(true);
            this.inTransactionForThread = null;
        }
        catch (SQLException sQLException) {
            this.canLinger = false;
            throw sQLException;
        }
    }

    public synchronized void rollback() throws SQLException {
        if (!this.connected) {
            throw new SQLException("DbConnection.rollback(): connection is not open");
        }
        if (null == this.inTransactionForThread) {
            throw new SQLException("DbConnection.rollback(): no transaction is open");
        }
        if (Thread.currentThread() != this.inTransactionForThread) {
            throw new SQLException("DbConnection.rollback(): transaction was opened on a different thread");
        }
        try {
            this.connection.rollback();
            this.connection.setAutoCommit(true);
            this.inTransactionForThread = null;
        }
        catch (SQLException sQLException) {
            this.canLinger = false;
            throw sQLException;
        }
    }

    public synchronized void abort() {
        if (null != this.inTransactionForThread) {
            try {
                this.connection.rollback();
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {
                this.canLinger = false;
            }
            this.inTransactionForThread = null;
        }
        if (null != this.statement) {
            this.resultSet = null;
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                this.canLinger = false;
            }
            this.statement = null;
        }
    }

    public void close() {
        this.close(true);
    }

    public synchronized void close(boolean bl) {
        if (null == this.connection || !this.connected && bl) {
            return;
        }
        this.abort();
        if (null != this.closeTask) {
            this.closeTask.cancel();
            this.closeTask = null;
        }
        if (bl && this.canLinger) {
            this.closeTask = new TimerTask(){

                @Override
                public void run() {
                    DbConnection.this.close(false);
                }
            };
            closeTimer.schedule(this.closeTask, 30000L);
        } else {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.connection = null;
            this.dbName = null;
            this.canLinger = false;
        }
        this.connected = false;
    }

    public void reportWarnings(ErrorLogger errorLogger, boolean bl) {
        if (!this.connected) {
            return;
        }
        if (null == errorLogger) {
            return;
        }
        String string = this.getWarnings();
        if (null == string) {
            if (!bl) {
                return;
            }
            string = "A database operation may have failed, but no details are available";
        } else {
            string = "A database operation returned the following message:" + string;
        }
        errorLogger.reportWarning(string);
    }

    public synchronized String getWarnings() {
        if (!this.connected) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            SQLWarning sQLWarning;
            if (null != this.resultSet) {
                this.resultSet.clearWarnings();
                for (sQLWarning = this.resultSet.getWarnings(); null != sQLWarning; sQLWarning = sQLWarning.getNextWarning()) {
                    stringBuilder.append("\n");
                    stringBuilder.append(sQLWarning.getMessage());
                }
            }
            if (null != this.statement) {
                this.statement.clearWarnings();
                for (sQLWarning = this.statement.getWarnings(); null != sQLWarning; sQLWarning = sQLWarning.getNextWarning()) {
                    stringBuilder.append("\n");
                    stringBuilder.append(sQLWarning.getMessage());
                }
            }
            if (null != this.connection) {
                this.connection.clearWarnings();
                for (sQLWarning = this.connection.getWarnings(); null != sQLWarning; sQLWarning = sQLWarning.getNextWarning()) {
                    stringBuilder.append("\n");
                    stringBuilder.append(sQLWarning.getMessage());
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    public static void reportError(ErrorLogger errorLogger, SQLException sQLException) {
        DbConnection.reportError(sQLException);
        if (null != errorLogger) {
            errorLogger.reportError(ERROR_TEXT_PREFIX + sQLException);
        }
    }

    public static void reportError(SQLException sQLException) {
        AppCore.log(3, "Database error", sQLException);
    }

    public static String clean(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    stringBuilder.append("''");
                    continue block4;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String makeKeyList(HashSet<Integer> hashSet) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Integer n : hashSet) {
            if (bl) {
                stringBuilder.append('(');
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(n);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

