/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;

public class ColorMap {
    public static final String NEW_OBJECT_NAME = "(new)";
    public static final double MIN_LEVEL = -40.0;
    public static final double MAX_LEVEL = 100.0;
    public static final double LEVEL_CODE_NO_SERVICE = -999.0;
    public static final double LEVEL_CODE_INTERFERENCE = -998.0;
    public static final double LEVEL_CODE_BACKGROUND = -997.0;
    public static final int COUNT_INCREMENT = 20;
    public static final int MAX_COUNT = 50;
    public static final Color DEFAULT_COLOR = Color.GREEN;
    public int key;
    public String name;
    public boolean isPermanent;
    public Color backgroundColor;
    public int colorCount;
    public double[] levels;
    public Color[] colors;
    public Color noServiceColor;
    public Color interferenceColor;

    public ColorMap(int n) {
        this.key = n;
        this.name = NEW_OBJECT_NAME;
        this.backgroundColor = Color.BLUE;
        this.levels = new double[20];
        this.colors = new Color[20];
        this.colorCount = 1;
        this.levels[0] = 0.0;
        this.colors[0] = DEFAULT_COLOR;
        this.noServiceColor = null;
        this.interferenceColor = null;
    }

    private ColorMap() {
    }

    public ColorMap copy() {
        ColorMap colorMap = new ColorMap();
        colorMap.name = this.name + " (copy)";
        colorMap.backgroundColor = this.backgroundColor;
        colorMap.levels = new double[this.levels.length];
        colorMap.colors = new Color[this.levels.length];
        colorMap.colorCount = this.colorCount;
        for (int i = 0; i < this.colorCount; ++i) {
            colorMap.levels[i] = this.levels[i];
            colorMap.colors[i] = this.colors[i];
        }
        colorMap.noServiceColor = this.noServiceColor;
        colorMap.interferenceColor = this.interferenceColor;
        return colorMap;
    }

    public int addColor() {
        if (50 == this.colorCount) {
            return -1;
        }
        int n = this.colorCount++;
        this.expandArrays();
        this.levels[n] = this.levels[n - 1] + 3.0;
        this.colors[n] = DEFAULT_COLOR;
        return n;
    }

    public void removeColor() {
        if (this.colorCount > 1) {
            --this.colorCount;
        }
    }

    private void expandArrays() {
        if (this.colorCount <= this.levels.length) {
            return;
        }
        int n = this.colorCount + 20;
        double[] dArray = new double[n];
        Color[] colorArray = new Color[n];
        for (int i = 0; i < this.levels.length; ++i) {
            dArray[i] = this.levels[i];
            colorArray[i] = this.colors[i];
        }
        this.levels = dArray;
        this.colors = colorArray;
    }

    public boolean save(String string) {
        return this.save(string, null);
    }

    public boolean save(String string, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        String string2 = null;
        try {
            String string3;
            dbConnection.update("LOCK TABLES color_map WRITE, color_map_data WRITE");
            boolean bl = false;
            if (this.key > 0) {
                string3 = String.valueOf(this.key);
                dbConnection.query("SELECT permanent FROM color_map WHERE color_map_key = " + string3);
                if (dbConnection.next()) {
                    this.isPermanent = dbConnection.getBoolean(1);
                } else {
                    this.isPermanent = false;
                    bl = true;
                }
            } else {
                dbConnection.query("SELECT MAX(color_map_key) FROM color_map");
                this.key = dbConnection.next() ? dbConnection.getInt(1) + 1 : 1;
                string3 = String.valueOf(this.key);
                this.isPermanent = false;
                bl = true;
            }
            if (this.isPermanent) {
                string2 = "Color map cannot be modified";
            } else if (null == this.name || this.name.equalsIgnoreCase(NEW_OBJECT_NAME)) {
                string2 = "Missing or invalid color map name";
            } else {
                dbConnection.query("SELECT color_map_key FROM color_map WHERE (UPPER(name) = '" + DbConnection.clean(this.name.toUpperCase()) + "') AND (color_map_key <> " + string3 + ")");
                if (dbConnection.next()) {
                    string2 = "Color map name already exists";
                } else {
                    if (bl) {
                        dbConnection.update("INSERT INTO color_map VALUES(" + string3 + ",'" + DbConnection.clean(this.name) + "',false)");
                    } else {
                        dbConnection.update("UPDATE color_map SET name = '" + DbConnection.clean(this.name) + "' WHERE color_map_key = " + string3);
                    }
                    dbConnection.update("DELETE FROM color_map_data WHERE color_map_key = " + string3);
                    StringBuilder stringBuilder = new StringBuilder("INSERT INTO color_map_data VALUES (");
                    Color color = this.backgroundColor;
                    stringBuilder.append(string3);
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(-997.0));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(color.getRed()));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(color.getGreen()));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(color.getBlue()));
                    stringBuilder.append("),(");
                    color = this.noServiceColor;
                    stringBuilder.append(string3);
                    stringBuilder.append(',');
                    stringBuilder.append(-999.0);
                    stringBuilder.append(',');
                    if (null == color) {
                        stringBuilder.append("-1,-1,-1");
                    } else {
                        stringBuilder.append(String.valueOf(color.getRed()));
                        stringBuilder.append(',');
                        stringBuilder.append(String.valueOf(color.getGreen()));
                        stringBuilder.append(',');
                        stringBuilder.append(String.valueOf(color.getBlue()));
                    }
                    stringBuilder.append("),(");
                    color = this.interferenceColor;
                    stringBuilder.append(string3);
                    stringBuilder.append(',');
                    stringBuilder.append(-998.0);
                    stringBuilder.append(',');
                    if (null == color) {
                        stringBuilder.append("-1,-1,-1");
                    } else {
                        stringBuilder.append(String.valueOf(color.getRed()));
                        stringBuilder.append(',');
                        stringBuilder.append(String.valueOf(color.getGreen()));
                        stringBuilder.append(',');
                        stringBuilder.append(String.valueOf(color.getBlue()));
                    }
                    for (int i = 0; i < this.colorCount; ++i) {
                        stringBuilder.append("),(");
                        color = this.colors[i];
                        stringBuilder.append(string3);
                        stringBuilder.append(',');
                        stringBuilder.append(String.valueOf(this.levels[i]));
                        stringBuilder.append(',');
                        stringBuilder.append(String.valueOf(color.getRed()));
                        stringBuilder.append(',');
                        stringBuilder.append(String.valueOf(color.getGreen()));
                        stringBuilder.append(',');
                        stringBuilder.append(String.valueOf(color.getBlue()));
                    }
                    stringBuilder.append(')');
                    dbConnection.update(stringBuilder.toString());
                }
            }
        }
        catch (SQLException sQLException) {
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string2) {
            if (null != errorLogger) {
                errorLogger.reportError(string2);
            }
            return false;
        }
        return true;
    }

    public static ArrayList<KeyedRecord> getColorMaps(String string) {
        return ColorMap.getColorMaps(string, null);
    }

    public static ArrayList<KeyedRecord> getColorMaps(String string, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        String string2 = null;
        try {
            dbConnection.query("SELECT color_map_key, name FROM color_map ORDER BY 1");
            while (dbConnection.next()) {
                arrayList.add(new KeyedRecord(dbConnection.getInt(1), dbConnection.getString(2)));
            }
        }
        catch (SQLException sQLException) {
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string2) {
            if (null != errorLogger) {
                errorLogger.reportError(string2);
            }
            return null;
        }
        return arrayList;
    }

    public static ColorMap getColorMap(String string, int n) {
        return ColorMap.getColorMap(string, n, null);
    }

    public static ColorMap getColorMap(String string, int n, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        ColorMap colorMap = new ColorMap(n);
        String string2 = null;
        try {
            dbConnection.update("LOCK TABLES color_map WRITE, color_map_data WRITE");
            String string3 = String.valueOf(n);
            dbConnection.query("SELECT name, permanent FROM color_map WHERE color_map_key = " + string3);
            if (dbConnection.next()) {
                colorMap.name = dbConnection.getString(1);
                colorMap.isPermanent = dbConnection.getBoolean(2);
                dbConnection.query("SELECT level, color_r, color_g, color_b FROM color_map_data WHERE color_map_key = " + string3 + " ORDER BY 1");
                int n2 = -1;
                while (dbConnection.next()) {
                    double d = dbConnection.getDouble(1);
                    int n3 = dbConnection.getInt(2);
                    int n4 = dbConnection.getInt(3);
                    int n5 = dbConnection.getInt(4);
                    if (-999.0 == d) {
                        if (n3 < 0 || n4 < 0 || n5 < 0) continue;
                        colorMap.noServiceColor = new Color(n3, n4, n5);
                        continue;
                    }
                    if (-998.0 == d) {
                        if (n3 < 0 || n4 < 0 || n5 < 0) continue;
                        colorMap.interferenceColor = new Color(n3, n4, n5);
                        continue;
                    }
                    if (-997.0 == d) {
                        colorMap.backgroundColor = new Color(n3, n4, n5);
                        continue;
                    }
                    if (n2 < 0) {
                        colorMap.colorCount = 0;
                    }
                    ++colorMap.colorCount;
                    colorMap.expandArrays();
                    colorMap.levels[n2] = d;
                    colorMap.colors[n2] = new Color(n3, n4, n5);
                }
            } else {
                string2 = "Color map not found";
            }
        }
        catch (SQLException sQLException) {
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string2) {
            if (null != errorLogger) {
                errorLogger.reportError(string2);
            }
            return null;
        }
        return colorMap;
    }

    public static boolean deleteColorMap(String string, int n) {
        return ColorMap.deleteColorMap(string, n, null);
    }

    public static boolean deleteColorMap(String string, int n, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        String string2 = null;
        try {
            dbConnection.update("LOCK TABLES color_map WRITE, color_map_data WRITE");
            String string3 = String.valueOf(n);
            dbConnection.query("SELECT permanent FROM color_map WHERE color_map_key = " + string3);
            if (dbConnection.next()) {
                if (dbConnection.getBoolean(1)) {
                    string2 = "Color map cannot be deleted";
                } else {
                    dbConnection.update("DELETE FROM color_map WHERE color_map_key = " + string3);
                    dbConnection.update("DELETE FROM color_map_data WHERE color_map_key = " + string3);
                }
            }
        }
        catch (SQLException sQLException) {
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string2) {
            if (null != errorLogger) {
                errorLogger.reportError(string2);
            }
            return false;
        }
        return true;
    }
}

