//
//  CoordinateCopyPastePanel.java
//  TVStudy
//
//  Copyright (c) 2018 Hammett & Edison, Inc.  All rights reserved.

package gov.fcc.tvstudy.gui;

import gov.fcc.tvstudy.gui.editor.*;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.datatransfer.*;

import javax.swing.*;
import javax.swing.text.*;

import java.net.URL;


//=====================================================================================================================
// A panel with two buttons for copying and pasting geographic coordinates into a pair of CoordinatePanel UIs.  The
// copy button is always enabled, the paste button can be enabled/disabled with setEnabled().

public class CoordinateCopyPastePanel extends AppPanel {

	private CoordinatePanel latitudePanel;
	private CoordinatePanel longitudePanel;

	private JButton pasteButton;


	//-----------------------------------------------------------------------------------------------------------------

	public CoordinateCopyPastePanel(CoordinatePanel theLatitudePanel, CoordinatePanel theLongitudePanel) {

		super(theLatitudePanel.getOriginalParent());

		latitudePanel = theLatitudePanel;
		longitudePanel = theLongitudePanel;

		JButton copyButton =  new JButton("Copy");
		copyButton.setFocusable(false);
		copyButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				doCopy();
			}
		});

		pasteButton = new JButton("Paste");
		pasteButton.setFocusable(false);
		pasteButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				doPaste();
			}
		});

		Box butBox = Box.createVerticalBox();
		butBox.add(copyButton);
		butBox.add(pasteButton);

		setLayout(new FlowLayout());
		add(butBox);
	}


	//-----------------------------------------------------------------------------------------------------------------

	public void setEnabled(boolean enabled) {

		pasteButton.setEnabled(enabled);
	}


	//-----------------------------------------------------------------------------------------------------------------

	private void doCopy() {

		StringSelection stsel = new StringSelection(String.format(Locale.US, "%.8f,%.8f",
			latitudePanel.getCoordinate(), longitudePanel.getCoordinate()));
		Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stsel, stsel);
	}


	//-----------------------------------------------------------------------------------------------------------------

	private void doPaste() {

		try {
			Transferable content = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
			if (null != content) {
				String data = (String)content.getTransferData(DataFlavor.stringFlavor);
				String[] parts = data.split(",");
				if (parts.length >= 2) {
					double lat = Double.parseDouble(parts[0]);
					double lon = Double.parseDouble(parts[1]);
					latitudePanel.setCoordinate(lat);
					longitudePanel.setCoordinate(lon);
				}
			}
		} catch (Throwable t) {
		}
	}
}
