//
//  StationRecord.java
//  TVStudy
//
//  Copyright (c) 2015-2024 Hammett & Edison, Inc.  All rights reserved.

package gov.fcc.tvstudy.core;


//=====================================================================================================================
// Interface to provide descriptive information for objects that can represent a station record, e.g. ExtDbRecord or
// SourceEditData.  Most methods return a non-null, formatted string description of a property.  For properties that
// are not set or not defined by the class an empty string is returned.  There may be a second form for some properties
// that returns a formatted string suitable for lexical sorting, as well as some that return primitive number values.
// This is used primarily in search and UI operations where different objects need to be handled generically.

public interface StationRecord {


	//-----------------------------------------------------------------------------------------------------------------

	public String getRecordType();


	//-----------------------------------------------------------------------------------------------------------------
	// True for SourceEditData subclasses, false otherwise.

	public boolean isSource();


	//-----------------------------------------------------------------------------------------------------------------
	// True if the record has a persistent ID from a data set.

	public boolean hasRecordID();


	//-----------------------------------------------------------------------------------------------------------------

	public boolean isReplication();


	//-----------------------------------------------------------------------------------------------------------------
	// Description of the data set where record originated, if any.

	public String getStationData();


	//-----------------------------------------------------------------------------------------------------------------

	public String getRecordID();


	//-----------------------------------------------------------------------------------------------------------------

	public String getFacilityID();

	public String getSortFacilityID();


	//-----------------------------------------------------------------------------------------------------------------

	public String getService();

	public String getServiceCode();


	//-----------------------------------------------------------------------------------------------------------------

	public boolean isDigital();


	//-----------------------------------------------------------------------------------------------------------------

	public boolean isDTS();


	//-----------------------------------------------------------------------------------------------------------------

	public String getSiteCount();


	//-----------------------------------------------------------------------------------------------------------------

	public String getCallSign();


	//-----------------------------------------------------------------------------------------------------------------

	public String getChannel();

	public int getChannelNumber();

	public String getSortChannel();

	public String getOriginalChannel();


	//-----------------------------------------------------------------------------------------------------------------

	public String getFrequency();

	public double getFrequencyValue();


	//-----------------------------------------------------------------------------------------------------------------

	public String getCity();


	//-----------------------------------------------------------------------------------------------------------------

	public String getState();


	//-----------------------------------------------------------------------------------------------------------------

	public String getCountry();

	public String getCountryCode();

	public String getSortCountry();


	//-----------------------------------------------------------------------------------------------------------------

	public String getZone();


	//-----------------------------------------------------------------------------------------------------------------

	public String getStatus();

	public String getSortStatus();


	//-----------------------------------------------------------------------------------------------------------------

	public String getFileNumber();

	public String getARN();


	//-----------------------------------------------------------------------------------------------------------------

	public String getSequenceDate();

	public String getSortSequenceDate();


	//-----------------------------------------------------------------------------------------------------------------

	public String getFrequencyOffset();


	//-----------------------------------------------------------------------------------------------------------------

	public String getEmissionMask();


	//-----------------------------------------------------------------------------------------------------------------

	public String getLatitude();


	//-----------------------------------------------------------------------------------------------------------------

	public String getLongitude();


	//-----------------------------------------------------------------------------------------------------------------

	public String getHeightAMSL();


	//-----------------------------------------------------------------------------------------------------------------

	public String getOverallHAAT();


	//-----------------------------------------------------------------------------------------------------------------

	public String getPeakERP();


	//-----------------------------------------------------------------------------------------------------------------

	public boolean hasHorizontalPattern();


	//-----------------------------------------------------------------------------------------------------------------

	public String getHorizontalPatternName();


	//-----------------------------------------------------------------------------------------------------------------

	public String getHorizontalPatternOrientation();
}
