/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.geo;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import gov.fcc.tvstudy.core.geo.Geography;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.xml.sax.Attributes;

public class GeoSectors
extends Geography {
    public final GeoPoint center = new GeoPoint();
    public ArrayList<Sector> sectors = new ArrayList();

    public GeoSectors(String string) {
        super(string, 5);
    }

    public String encodeAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (Sector sector : this.sectors) {
            if (bl) {
                d = sector.azimuth + 360.0;
                bl = false;
            } else {
                stringBuilder.append(String.format(Locale.US, "%f,%f,%f;", d2, d3, sector.azimuth));
            }
            d2 = sector.azimuth;
            d3 = sector.radius;
        }
        stringBuilder.append(String.format(Locale.US, "%f,%f,%f", d2, d3, d));
        return stringBuilder.toString();
    }

    public String decodeFromString(String string) {
        ArrayList<Sector> arrayList = new ArrayList<Sector>();
        String string2 = GeoSectors.parseString(string, arrayList);
        if (null == string2) {
            this.sectors = arrayList;
        }
        return string2;
    }

    public static String validateString(String string) {
        return GeoSectors.parseString(string, null);
    }

    private static String parseString(String string, ArrayList<Sector> arrayList) {
        String[] stringArray = string.split(";");
        int n = 0;
        double d = -1.0;
        double d2 = -1.0;
        for (String string2 : stringArray) {
            if (0 == string2.trim().length()) continue;
            ++n;
            String[] stringArray2 = string2.split(",");
            if (3 != stringArray2.length) {
                return "Bad format in sector list";
            }
            double d3 = -1.0;
            String string3 = stringArray2[0].trim();
            if (string3.length() > 0) {
                try {
                    d3 = Double.parseDouble(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (d3 < 0.0 || d3 > 360.0) {
                if (d < 0.0) {
                    return "Bad sector list, missing or bad start azimuth";
                }
                return "Bad sector list, missing or bad start azimuth after " + AppCore.formatAzimuth(d2);
            }
            if (d < 0.0) {
                d = d3 + 360.0;
            } else if (d3 != d2) {
                return "Bad sector list, out of sequence or gap after " + AppCore.formatAzimuth(d2);
            }
            double d4 = 0.0;
            string3 = stringArray2[1].trim();
            if (string3.length() > 0) {
                try {
                    d4 = Double.parseDouble(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (d4 < 1.0 || d4 > 3000.0) {
                return "Bad sector list, missing or bad radius at " + AppCore.formatAzimuth(d3);
            }
            d2 = -1.0;
            string3 = stringArray2[2].trim();
            if (string3.length() > 0) {
                try {
                    d2 = Double.parseDouble(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (d2 <= d3) {
                return "Bad sector list, missing or bad end azimuth at " + AppCore.formatAzimuth(d3);
            }
            if (d2 - d3 < 1.0) {
                return "Bad sector list, sector at " + AppCore.formatAzimuth(d3) + " spans less than 1 degree";
            }
            if (null == arrayList) continue;
            Sector sector = new Sector();
            sector.azimuth = d3;
            sector.radius = d4;
            arrayList.add(sector);
        }
        if (n < 2) {
            return "Bad sector list, must have at least 2 sectors";
        }
        if (d2 != d) {
            return "Bad sector list, gap at start/end";
        }
        return null;
    }

    @Override
    public boolean loadData(ErrorLogger errorLogger) {
        if (null == this.key) {
            return false;
        }
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        this.sectors = new ArrayList();
        String string = null;
        try {
            dbConnection.query("SELECT latitude, longitude FROM geography WHERE geo_key = " + this.key);
            if (dbConnection.next()) {
                this.center.setLatLon(dbConnection.getDouble(1), dbConnection.getDouble(2));
            } else {
                string = "Sectors geography data not found for key " + this.key;
            }
            if (null == string) {
                dbConnection.query("SELECT azimuth, radius FROM geo_sectors WHERE geo_key = " + this.key + " ORDER BY azimuth");
                while (dbConnection.next()) {
                    Sector sector = new Sector();
                    sector.azimuth = dbConnection.getDouble(1);
                    sector.radius = dbConnection.getDouble(2);
                    this.sectors.add(sector);
                }
                if (this.sectors.size() < 2) {
                    string = "Bad sectors geography data for key " + this.key;
                }
            }
        }
        catch (SQLException sQLException) {
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string) {
            if (null != errorLogger) {
                errorLogger.reportError(string);
            }
            return false;
        }
        return true;
    }

    @Override
    public Geography duplicate() {
        GeoSectors geoSectors = new GeoSectors(this.dbID);
        super.duplicateTo(geoSectors);
        geoSectors.center.setLatLon(this.center);
        if (null != this.sectors) {
            geoSectors.sectors = new ArrayList();
            for (Sector sector : this.sectors) {
                geoSectors.sectors.add(sector.duplicate());
            }
        }
        return geoSectors;
    }

    @Override
    public boolean isDataValid(ErrorLogger errorLogger) {
        if (!super.isDataValid(errorLogger)) {
            return false;
        }
        if (0.0 == this.center.latitude || 0.0 == this.center.longitude) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Sectors center latitude and longitude must be provided");
            }
            return false;
        }
        if (this.center.latitude < -73.0 || this.center.latitude > 73.5) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad sectors center latitude, must be -73.0 to 73.5 degrees");
            }
            return false;
        }
        if (this.center.longitude < -180.0 || this.center.longitude > 180.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad sectors center longitude, must be -180.0 to 180.0 degrees");
            }
            return false;
        }
        return this.areSectorsValid(errorLogger);
    }

    public boolean areSectorsValid(ErrorLogger errorLogger) {
        if (this.sectors.size() < 2) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad sectors, must contain at least 2 sectors");
            }
            return false;
        }
        double d = -1.0;
        for (Sector sector : this.sectors) {
            if (!sector.isDataValid(errorLogger)) {
                return false;
            }
            if (sector.azimuth <= d) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad sectors, azimuths duplicated or out of order");
                }
                return false;
            }
            if (sector.azimuth - d < 1.0) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad sectors, sector spans less than 1 degree of azimuth");
                }
                return false;
            }
            d = sector.azimuth;
        }
        return true;
    }

    @Override
    protected String saveGeography(DbConnection dbConnection) throws SQLException {
        String string = super.saveGeography(dbConnection, this.center, 0.0, 0.0, 0.0);
        if (null != string) {
            return string;
        }
        dbConnection.update("DELETE FROM geo_sectors WHERE geo_key = " + this.key);
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO geo_sectors VALUES");
        int n = stringBuilder.length();
        String string2 = " (";
        for (Sector sector : this.sectors) {
            stringBuilder.append(string2);
            stringBuilder.append(String.valueOf(this.key));
            stringBuilder.append(',');
            stringBuilder.append(String.valueOf(sector.azimuth));
            stringBuilder.append(',');
            stringBuilder.append(String.valueOf(sector.radius));
            if (stringBuilder.length() > 500000) {
                stringBuilder.append(')');
                dbConnection.update(stringBuilder.toString());
                stringBuilder.setLength(n);
                string2 = " (";
                continue;
            }
            string2 = "),(";
        }
        if (stringBuilder.length() > n) {
            stringBuilder.append(')');
            dbConnection.update(stringBuilder.toString());
        }
        return null;
    }

    @Override
    protected void writeAttributes(Writer writer) throws IOException {
        this.center.writeAttributes(writer);
    }

    @Override
    protected boolean parseAttributes(String string, Attributes attributes, ErrorLogger errorLogger) {
        return this.center.parseAttributes(string, attributes, errorLogger);
    }

    @Override
    protected boolean hasElements() {
        return true;
    }

    @Override
    protected void writeElements(Writer writer) throws IOException {
        for (Sector sector : this.sectors) {
            writer.append("<SECTOR");
            sector.writeAttributes(writer);
            writer.append("/>\n");
        }
    }

    @Override
    protected boolean parseElement(String string, Attributes attributes, String string2, ErrorLogger errorLogger) {
        if (!string.equals("SECTOR")) {
            return true;
        }
        Sector sector = new Sector();
        if (!sector.parseAttributes(string, attributes, errorLogger)) {
            return false;
        }
        this.sectors.add(sector);
        return true;
    }

    public static class Sector {
        public double azimuth;
        public double radius;

        private Sector duplicate() {
            Sector sector = new Sector();
            sector.azimuth = this.azimuth;
            sector.radius = this.radius;
            return sector;
        }

        private boolean isDataValid(ErrorLogger errorLogger) {
            if (this.azimuth < 0.0 || this.azimuth >= 360.0) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad sector azimuth, must be from 0 to less than 360 degrees");
                }
                return false;
            }
            if (this.radius < 1.0 || this.radius > 3000.0) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad sector radius, must be from 1.0 to 3000.0");
                }
                return false;
            }
            return true;
        }

        public void writeAttributes(Writer writer) throws IOException {
            writer.append(" AZIMUTH=\"");
            writer.append(AppCore.formatAzimuth(this.azimuth));
            writer.append("\" RADIUS=\"");
            writer.append(AppCore.formatDistance(this.radius));
            writer.append('\"');
        }

        public boolean parseAttributes(String string, Attributes attributes, ErrorLogger errorLogger) {
            String string2 = attributes.getValue("AZIMUTH");
            this.azimuth = -1.0;
            if (null != string2) {
                try {
                    this.azimuth = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.azimuth < 0.0 || this.azimuth >= 360.0) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad AZIMUTH attribute in " + string + " tag");
                }
                return false;
            }
            string2 = attributes.getValue("RADIUS");
            this.radius = 0.0;
            if (null != string2) {
                try {
                    this.radius = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.radius < 1.0 || this.radius > 3000.0) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad RADIUS attribute in " + string + " tag");
                }
                return false;
            }
            return true;
        }
    }
}

