/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.geo;

import gov.fcc.tvstudy.core.AntPattern;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import gov.fcc.tvstudy.core.geo.Geography;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;

public class GeoPointSet
extends Geography {
    public static final KeyedRecord GENERIC_ANTENNA = new KeyedRecord(0, "(generic)");
    public ArrayList<StudyPoint> points;
    private boolean exportReceiveAntennas;
    private int nextAntennaKey = -1;
    private HashMap<Integer, AntPattern> importedAntennas;
    private HashMap<String, KeyedRecord> findImportAntennas;
    private HashMap<String, KeyedRecord> findDbAntennas;
    private HashSet<String> antennaNamesNotFound;
    private Pattern patternParser = Pattern.compile("[,\\n]");

    public GeoPointSet(String string) {
        super(string, 1);
        this.points = new ArrayList();
    }

    @Override
    public boolean loadData(ErrorLogger errorLogger) {
        if (null == this.key) {
            return false;
        }
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        this.points = new ArrayList();
        String string = null;
        try {
            dbConnection.query("SELECT geo_point_set.point_name,geo_point_set.latitude,geo_point_set.longitude,geo_point_set.receive_height,geo_point_set.antenna_key,receive_antenna_index.name,geo_point_set.antenna_orientation FROM geo_point_set LEFT JOIN receive_antenna_index USING (antenna_key) WHERE geo_key = " + this.key + " ORDER BY point_name");
            while (dbConnection.next()) {
                StudyPoint studyPoint = new StudyPoint();
                studyPoint.name = dbConnection.getString(1);
                studyPoint.setLatLon(dbConnection.getDouble(2), dbConnection.getDouble(3));
                studyPoint.receiveHeight = dbConnection.getDouble(4);
                int n = dbConnection.getInt(5);
                String string2 = dbConnection.getString(6);
                studyPoint.antenna = 0 == n || null == string2 ? GENERIC_ANTENNA : new KeyedRecord(n, string2);
                studyPoint.antennaOrientation = dbConnection.getDouble(7);
                if (studyPoint.antennaOrientation >= 0.0) {
                    studyPoint.useAntennaOrientation = true;
                } else {
                    studyPoint.antennaOrientation = 0.0;
                }
                this.points.add(studyPoint);
            }
            if (this.points.isEmpty()) {
                string = "Point set geography data not found for key " + this.key;
            }
        }
        catch (SQLException sQLException) {
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string) {
            if (null != errorLogger) {
                errorLogger.reportError(string);
            }
            return false;
        }
        return true;
    }

    @Override
    public Geography duplicate() {
        GeoPointSet geoPointSet = new GeoPointSet(this.dbID);
        super.duplicateTo(geoPointSet);
        if (null != this.points) {
            geoPointSet.points = new ArrayList();
            for (StudyPoint studyPoint : this.points) {
                geoPointSet.points.add(studyPoint.duplicate());
            }
        }
        return geoPointSet;
    }

    @Override
    public boolean isDataValid(ErrorLogger errorLogger) {
        if (!super.isDataValid(errorLogger)) {
            return false;
        }
        if (this.points.size() < 1) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Point set must contain at least 1 point");
            }
            return false;
        }
        for (StudyPoint studyPoint : this.points) {
            if (studyPoint.isDataValid(errorLogger)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String saveGeography(DbConnection dbConnection) throws SQLException {
        Object object;
        HashSet<Integer> hashSet;
        String string = null;
        if (null != this.importedAntennas) {
            hashSet = new HashSet<Integer>();
            for (StudyPoint object2 : this.points) {
                if (null == object2.antenna || object2.antenna.key >= 0) continue;
                hashSet.add(object2.antenna.key);
            }
            for (Integer n : hashSet) {
                KeyedRecord keyedRecord;
                object = this.importedAntennas.get(n);
                AntPattern antPattern = AntPattern.loadReceiveAntenna(this.dbID, dbConnection, ((AntPattern)object).name);
                if (null != antPattern && ((AntPattern)object).equalsPattern(antPattern)) {
                    keyedRecord = new KeyedRecord(antPattern.key, antPattern.name);
                } else {
                    string = ((AntPattern)object).saveReceiveAntenna(dbConnection);
                    if (null != string) {
                        return string;
                    }
                    keyedRecord = new KeyedRecord(((AntPattern)object).key, ((AntPattern)object).name);
                }
                this.importedAntennas.remove(n);
                for (StudyPoint studyPoint : this.points) {
                    if (null == studyPoint.antenna || n != studyPoint.antenna.key) continue;
                    studyPoint.antenna = keyedRecord;
                }
            }
            this.importedAntennas = null;
        }
        if (null != (string = super.saveGeography(dbConnection, new GeoPoint(), 0.0, 0.0, 0.0))) {
            return string;
        }
        dbConnection.update("DELETE FROM geo_point_set WHERE geo_key = " + this.key);
        hashSet = new HashSet();
        object = new StringBuilder("INSERT INTO geo_point_set VALUES");
        int n = ((StringBuilder)object).length();
        Object object2 = " (";
        for (StudyPoint studyPoint : this.points) {
            int n2 = 0;
            if (null != studyPoint.antenna) {
                n2 = studyPoint.antenna.key;
                if (n2 > 0) {
                    hashSet.add(n2);
                } else if (n2 < 0) {
                    studyPoint.antenna = GENERIC_ANTENNA;
                    n2 = 0;
                }
            }
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append(String.valueOf(this.key));
            ((StringBuilder)object).append(",'");
            ((StringBuilder)object).append(DbConnection.clean(studyPoint.name));
            ((StringBuilder)object).append("',");
            ((StringBuilder)object).append(String.valueOf(studyPoint.latitude));
            ((StringBuilder)object).append(',');
            ((StringBuilder)object).append(String.valueOf(studyPoint.longitude));
            ((StringBuilder)object).append(',');
            ((StringBuilder)object).append(String.valueOf(studyPoint.receiveHeight));
            ((StringBuilder)object).append(',');
            ((StringBuilder)object).append(String.valueOf(n2));
            ((StringBuilder)object).append(',');
            ((StringBuilder)object).append(studyPoint.useAntennaOrientation ? String.valueOf(studyPoint.antennaOrientation) : "-1");
            if (((StringBuilder)object).length() > 500000) {
                ((StringBuilder)object).append(')');
                dbConnection.update(((StringBuilder)object).toString());
                ((StringBuilder)object).setLength(n);
                object2 = " (";
                continue;
            }
            object2 = "),(";
        }
        if (((StringBuilder)object).length() > n) {
            ((StringBuilder)object).append(')');
            dbConnection.update(((StringBuilder)object).toString());
        }
        dbConnection.update("DELETE FROM geography_receive_antenna WHERE geo_key = " + this.key);
        if (!hashSet.isEmpty()) {
            object = new StringBuilder("INSERT INTO geography_receive_antenna VALUES");
            int n3 = ((StringBuilder)object).length();
            object2 = " (";
            for (Integer n4 : hashSet) {
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append(String.valueOf(this.key));
                ((StringBuilder)object).append(',');
                ((StringBuilder)object).append(String.valueOf(n4));
                if (((StringBuilder)object).length() > 500000) {
                    ((StringBuilder)object).append(')');
                    dbConnection.update(((StringBuilder)object).toString());
                    ((StringBuilder)object).setLength(n3);
                    object2 = " (";
                    continue;
                }
                object2 = "),(";
            }
            if (((StringBuilder)object).length() > n3) {
                ((StringBuilder)object).append(')');
                dbConnection.update(((StringBuilder)object).toString());
            }
        }
        return null;
    }

    public boolean writeToXML(Writer writer, boolean bl) {
        return this.writeToXML(writer, bl, null);
    }

    public boolean writeToXML(Writer writer, boolean bl, ErrorLogger errorLogger) {
        this.exportReceiveAntennas = bl;
        return this.writeToXML(writer, errorLogger);
    }

    @Override
    protected boolean hasElements() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeElements(Writer writer) throws IOException {
        if (this.exportReceiveAntennas) {
            HashSet hashSet = new HashSet();
            for (StudyPoint studyPoint : this.points) {
                if (null == studyPoint.antenna || 0 == studyPoint.antenna.key) continue;
                hashSet.add(studyPoint.antenna.key);
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                void var3_8;
                Integer n = (Integer)iterator.next();
                if (n < 0) {
                    if (null != this.importedAntennas) {
                        AntPattern antPattern = this.importedAntennas.get(n);
                    } else {
                        Object var3_6 = null;
                    }
                } else {
                    AntPattern antPattern = AntPattern.getReceiveAntenna(this.dbID, n);
                }
                if (null == var3_8) continue;
                writer.append("<ANTENNA NAME=\"");
                writer.append(AppCore.xmlclean(var3_8.name));
                writer.append("\" GAIN=\"");
                writer.append(String.valueOf(var3_8.gain));
                if (var3_8.isMatrix()) {
                    writer.append("\" MULTIPAT>\n");
                    for (AntPattern.AntSlice antSlice : var3_8.getSlices()) {
                        for (AntPattern.AntPoint antPoint : antSlice.points) {
                            writer.append(String.format(Locale.US, "%.6f,%.3f,%.4f\n", antSlice.value, antPoint.angle, antPoint.relativeField));
                        }
                    }
                } else {
                    writer.append("\">\n");
                    for (AntPattern.AntPoint antPoint : var3_8.getPoints()) {
                        writer.append(String.format(Locale.US, "%.3f,%.4f\n", antPoint.angle, antPoint.relativeField));
                    }
                }
                writer.append("</ANTENNA>\n");
            }
        }
        for (StudyPoint studyPoint : this.points) {
            writer.append("<POINT");
            studyPoint.writeAttributes(writer);
            writer.append("/>\n");
        }
    }

    @Override
    protected boolean parseElement(String string, Attributes attributes, String string2, ErrorLogger errorLogger) {
        Object object;
        if (string.equals("ANTENNA")) {
            int n;
            object = attributes.getValue("NAME");
            if (null != object) {
                object = ((String)object).trim();
            }
            if (null == object || 0 == ((String)object).length()) {
                if (null != errorLogger) {
                    errorLogger.reportError("Missing NAME attribute in " + string + " tag");
                }
                return false;
            }
            String string3 = attributes.getValue("GAIN");
            double d = 0.0;
            if (null != string3) {
                try {
                    d = Double.parseDouble(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    d = -1.0;
                }
                if (d < 0.0 || d > 60.0) {
                    if (null != errorLogger) {
                        errorLogger.reportError("Bad GAIN attribute in " + string + " tag");
                    }
                    return false;
                }
            }
            boolean bl = null != attributes.getValue("MULTIPAT");
            boolean bl2 = false;
            ArrayList<AntPattern.AntSlice> arrayList = new ArrayList<AntPattern.AntSlice>();
            ArrayList<AntPattern.AntPoint> arrayList2 = null;
            double d2 = 9.0;
            String[] stringArray = this.patternParser.split(string2);
            if (bl) {
                for (n = 2; n < stringArray.length; n += 3) {
                    double d3;
                    double d4;
                    double d5;
                    try {
                        d5 = Double.parseDouble(stringArray[n - 2]);
                        d4 = Double.parseDouble(stringArray[n - 1]);
                        d3 = Double.parseDouble(stringArray[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl2 = true;
                        break;
                    }
                    if (d5 != d2) {
                        arrayList2 = new ArrayList();
                        arrayList.add(new AntPattern.AntSlice(d5, arrayList2));
                        d2 = d5;
                    }
                    arrayList2.add(new AntPattern.AntPoint(d4, d3));
                }
            } else {
                for (n = 1; n < stringArray.length; n += 2) {
                    double d6;
                    double d7;
                    try {
                        d7 = Double.parseDouble(stringArray[n - 1]);
                        d6 = Double.parseDouble(stringArray[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl2 = true;
                        break;
                    }
                    if (null == arrayList2) {
                        arrayList2 = new ArrayList<AntPattern.AntPoint>();
                    }
                    arrayList2.add(new AntPattern.AntPoint(d7, d6));
                }
            }
            if (null == arrayList2) {
                bl2 = true;
            }
            AntPattern antPattern = null;
            if (!bl2) {
                antPattern = bl ? new AntPattern(this.dbID, (String)object, 3, arrayList) : new AntPattern(this.dbID, 3, (String)object, arrayList2);
                antPattern.gain = d;
                boolean bl3 = bl2 = !antPattern.isDataValid();
            }
            if (bl2) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad data in " + string + " element");
                }
                return false;
            }
            if (null == this.importedAntennas) {
                this.importedAntennas = new HashMap();
                this.findImportAntennas = new HashMap();
            }
            KeyedRecord keyedRecord = new KeyedRecord(this.nextAntennaKey--, antPattern.name + " (imported)");
            this.importedAntennas.put(keyedRecord.key, antPattern);
            this.findImportAntennas.put(antPattern.name, keyedRecord);
        }
        if (string.equals("POINT")) {
            object = new StudyPoint();
            if (!((StudyPoint)object).parseAttributes(string, attributes, this, errorLogger)) {
                return false;
            }
            this.points.add((StudyPoint)object);
        }
        return true;
    }

    private KeyedRecord findAntenna(String string, ErrorLogger errorLogger) {
        KeyedRecord keyedRecord = null;
        if (null != this.findImportAntennas) {
            keyedRecord = this.findImportAntennas.get(string);
        }
        if (null == keyedRecord) {
            if (null == this.findDbAntennas) {
                this.findDbAntennas = new HashMap();
                this.antennaNamesNotFound = new HashSet();
                ArrayList<KeyedRecord> arrayList = AntPattern.getReceiveAntennaList(this.dbID);
                if (null != arrayList) {
                    for (KeyedRecord keyedRecord2 : arrayList) {
                        this.findDbAntennas.put(keyedRecord2.name.toUpperCase(), keyedRecord2);
                    }
                }
                this.findDbAntennas.put(GeoPointSet.GENERIC_ANTENNA.name.toUpperCase(), GENERIC_ANTENNA);
            }
            if (null == (keyedRecord = this.findDbAntennas.get(string.toUpperCase()))) {
                if (null != errorLogger && this.antennaNamesNotFound.add(string)) {
                    errorLogger.logMessage("Receive antenna '" + string + "' not found, reverting to generic");
                }
                keyedRecord = GENERIC_ANTENNA;
            }
        }
        return keyedRecord;
    }

    public ArrayList<KeyedRecord> getReceiveAntennaList(ErrorLogger errorLogger) {
        ArrayList<KeyedRecord> arrayList = AntPattern.getReceiveAntennaList(this.dbID, errorLogger);
        if (null != arrayList && null != this.importedAntennas) {
            for (Map.Entry<Integer, AntPattern> entry : this.importedAntennas.entrySet()) {
                arrayList.add(new KeyedRecord(entry.getKey(), entry.getValue().name + " (imported)"));
            }
        }
        return arrayList;
    }

    public static class StudyPoint
    extends GeoPoint {
        public String name;
        public double receiveHeight;
        public KeyedRecord antenna;
        public boolean useAntennaOrientation;
        public double antennaOrientation;

        public StudyPoint duplicate() {
            StudyPoint studyPoint = new StudyPoint();
            studyPoint.name = this.name;
            studyPoint.setLatLon(this);
            studyPoint.receiveHeight = this.receiveHeight;
            studyPoint.antenna = this.antenna;
            studyPoint.useAntennaOrientation = this.useAntennaOrientation;
            studyPoint.antennaOrientation = this.antennaOrientation;
            return studyPoint;
        }

        public boolean isDataValid(ErrorLogger errorLogger) {
            if (null == this.name) {
                this.name = "";
            }
            this.name = this.name.trim();
            if (this.name.length() > 245) {
                this.name = this.name.substring(0, 245);
            }
            if (0.0 == this.latitude || 0.0 == this.longitude) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Point latitude and longitude must be provided");
                }
                return false;
            }
            if (this.latitude < -73.0 || this.latitude > 73.5) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad point latitude, must be -73.0 to 73.5 degrees");
                }
                return false;
            }
            if (this.longitude < -180.0 || this.longitude > 180.0) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad point longitude, must be -180.0 to 180.0 degrees");
                }
                return false;
            }
            if (this.receiveHeight < 0.0 || this.receiveHeight > 1000.0) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad point receive height, must be between 0.0 and 1000.0");
                }
                return false;
            }
            if (null == this.antenna) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Receive antenna must be selected");
                }
                return false;
            }
            if (this.useAntennaOrientation && (this.antennaOrientation < 0.0 || this.antennaOrientation >= 360.0)) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("Bad antenna orientation, must be 0 to less than 360 degrees");
                }
                return false;
            }
            return true;
        }

        @Override
        public void writeAttributes(Writer writer) throws IOException {
            super.writeAttributes(writer);
            writer.append(" NAME=\"");
            writer.append(AppCore.xmlclean(this.name));
            writer.append("\" HEIGHT=\"");
            writer.append(AppCore.formatHeight(this.receiveHeight));
            writer.append('\"');
            if (null != this.antenna && this.antenna.key > 0) {
                writer.append(" ANTENNA=\"");
                writer.append(AppCore.xmlclean(this.antenna.name));
                writer.append('\"');
            }
            if (this.useAntennaOrientation) {
                writer.append(" ORIENT=\"");
                writer.append(AppCore.formatAzimuth(this.antennaOrientation));
                writer.append('\"');
            }
        }

        @Override
        public boolean parseAttributes(String string, Attributes attributes, ErrorLogger errorLogger) {
            return this.parseAttributes(string, attributes, null, errorLogger);
        }

        private boolean parseAttributes(String string, Attributes attributes, GeoPointSet geoPointSet, ErrorLogger errorLogger) {
            if (!super.parseAttributes(string, attributes, errorLogger)) {
                return false;
            }
            this.name = attributes.getValue("NAME");
            if (null == this.name) {
                this.name = "";
            }
            this.name = this.name.trim();
            if (this.name.length() > 245) {
                this.name = this.name.substring(0, 245);
            }
            String string2 = attributes.getValue("HEIGHT");
            this.receiveHeight = -1.0;
            if (null != string2) {
                try {
                    this.receiveHeight = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.receiveHeight < 0.0 || this.receiveHeight >= 1000.0) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad HEIGHT attribute in " + string + " tag");
                }
                return false;
            }
            string2 = attributes.getValue("ANTENNA");
            if (null != string2 && 0 == (string2 = string2.trim()).length()) {
                string2 = null;
            }
            this.antenna = null != string2 && null != geoPointSet ? geoPointSet.findAntenna(string2, errorLogger) : GENERIC_ANTENNA;
            string2 = attributes.getValue("ORIENT");
            if (null != string2) {
                this.useAntennaOrientation = true;
                this.antennaOrientation = -1.0;
                try {
                    this.antennaOrientation = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.antennaOrientation < 0.0 || this.antennaOrientation >= 360.0) {
                    if (null != errorLogger) {
                        errorLogger.reportError("Bad ORIENT attribute in " + string + " tag");
                    }
                    return false;
                }
            }
            return true;
        }
    }
}

