/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.geo;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.xml.sax.Attributes;

public class GeoPoint {
    public static final double PI = Math.PI;
    public static final double TWO_PI = Math.PI * 2;
    public static final double RADIANS_TO_DEGREES = 57.29577951308232;
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    public double latitude;
    public double longitude;
    public int latitudeNS;
    public int latitudeDegrees;
    public int latitudeMinutes;
    public double latitudeSeconds;
    public int longitudeWE;
    public int longitudeDegrees;
    public int longitudeMinutes;
    public double longitudeSeconds;
    private static final double A = 6378206.4;
    private static final double F = 0.003390075;
    private static final double DA = -69.4;
    private static final double DF = -3.7264639E-5;
    private static final double[] xlats = new double[]{20.0, 62.0, 56.0, 57.0, 46.0, 18.0, 17.0, 50.0, 14.0, 13.0, -15.0};
    private static final double[] xlatn = new double[]{50.0, 64.0, 57.0, 58.0, 77.0, 23.0, 19.0, 75.0, 20.0, 16.0, -14.0};
    private static final double[] xlone = new double[]{63.0, 168.0, 169.0, 169.0, 128.0, 154.0, 64.0, 51.0, 87.0, -146.0, 169.0};
    private static final double[] xlonw = new double[]{131.0, 172.0, 171.0, 171.0, 194.0, 161.0, 68.0, 128.0, 114.0, -144.0, 171.0};
    private static final int[] ialg = new int[]{1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2};
    private static final int[] ncl = new int[]{273, 81, 121, 41, 529, 281, 81, 0, 0, 0, 0};
    private static final int[] nrw = new int[]{121, 41, 61, 21, 249, 201, 41, 0, 0, 0, 0};
    private static final double[] dx = new double[]{0.25, 0.05, 0.01667, 0.05, 0.125, 0.025, 0.05, -10.0, -12.0, -100.0, -115.0};
    private static final double[] dy = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 158.0, 130.0, -248.0, 118.0};
    private static final double[] dz = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 187.0, 190.0, 259.0, 426.0};
    private static float[][][] nadla = new float[][][]{(float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null};
    private static float[][][] nadlo = new float[][][]{(float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null, (float[][])null};
    private static final String NADCON_DIR_NAME = "nadcon";
    private static final String[] lafil = new String[]{"conus_eb.las", "stlrnc_eb.las", "stgeorge_eb.las", "stpaul_eb.las", "alaska_eb.las", "hawaii_eb.las", "prvi_eb.las", "", "", "", ""};
    private static final String[] lofil = new String[]{"conus_eb.los", "stlrnc_eb.los", "stgeorge_eb.los", "stpaul_eb.los", "alaska_eb.los", "hawaii_eb.los", "prvi_eb.los", "", "", "", ""};

    public boolean equals(Object object) {
        return null != object && this.latitude == ((GeoPoint)object).latitude && this.longitude == ((GeoPoint)object).longitude;
    }

    public void setLatLon(GeoPoint geoPoint) {
        this.setLatLon(geoPoint.latitude, geoPoint.longitude);
    }

    public void setLatLon(double d, double d2) {
        this.latitude = d;
        this.longitude = d2;
        this.updateDMS();
    }

    public void updateDMS() {
        double d = Math.abs(this.latitude);
        this.latitudeDegrees = (int)d;
        this.latitudeMinutes = (int)((d - (double)this.latitudeDegrees) * 60.0);
        this.latitudeSeconds = ((d - (double)this.latitudeDegrees) * 60.0 - (double)this.latitudeMinutes) * 60.0;
        if (this.latitudeSeconds >= 59.995) {
            this.latitudeSeconds = 0.0;
            if (60 == ++this.latitudeMinutes) {
                this.latitudeMinutes = 0;
                ++this.latitudeDegrees;
            }
        }
        this.latitudeNS = this.latitude < 0.0 ? 1 : 0;
        d = Math.abs(this.longitude);
        this.longitudeDegrees = (int)d;
        this.longitudeMinutes = (int)((d - (double)this.longitudeDegrees) * 60.0);
        this.longitudeSeconds = ((d - (double)this.longitudeDegrees) * 60.0 - (double)this.longitudeMinutes) * 60.0;
        if (this.longitudeSeconds >= 59.995) {
            this.longitudeSeconds = 0.0;
            if (60 == ++this.longitudeMinutes) {
                this.longitudeMinutes = 0;
                ++this.longitudeDegrees;
            }
        }
        this.longitudeWE = this.longitude < 0.0 ? 1 : 0;
    }

    public void updateLatLon() {
        this.latitude = (double)Math.abs(this.latitudeDegrees) + (double)this.latitudeMinutes / 60.0 + this.latitudeSeconds / 3600.0;
        if (0 != this.latitudeNS) {
            this.latitude *= -1.0;
        }
        this.longitude = (double)Math.abs(this.longitudeDegrees) + (double)this.longitudeMinutes / 60.0 + this.longitudeSeconds / 3600.0;
        if (0 != this.longitudeWE) {
            this.longitude *= -1.0;
        }
    }

    public boolean convertFromNAD27() {
        int n;
        for (n = 0; !(n >= ialg.length || this.latitude >= xlats[n] && this.latitude <= xlatn[n] && this.longitude >= xlone[n] && this.longitude <= xlonw[n]); ++n) {
        }
        if (n == ialg.length) {
            return false;
        }
        double d = 0.0;
        double d2 = 0.0;
        if (1 == ialg[n]) {
            float[][] fArray = nadla[n];
            float[][] fArray2 = nadlo[n];
            if (null == fArray || null == fArray2) {
                int n2;
                int n3;
                DataInputStream dataInputStream;
                fArray = new float[nrw[n]][ncl[n]];
                Path path = AppCore.dbaseDirectoryPath.resolve(NADCON_DIR_NAME).resolve(lafil[n]);
                try {
                    dataInputStream = new DataInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
                    dataInputStream.skipBytes((ncl[n] + 1) * 4);
                    for (n3 = 0; n3 < nrw[n]; ++n3) {
                        dataInputStream.skipBytes(4);
                        for (n2 = 0; n2 < ncl[n]; ++n2) {
                            fArray[n3][n2] = dataInputStream.readFloat();
                        }
                    }
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    return false;
                }
                fArray2 = new float[nrw[n]][ncl[n]];
                path = AppCore.dbaseDirectoryPath.resolve(NADCON_DIR_NAME).resolve(lofil[n]);
                try {
                    dataInputStream = new DataInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
                    dataInputStream.skipBytes((ncl[n] + 1) * 4);
                    for (n3 = 0; n3 < nrw[n]; ++n3) {
                        dataInputStream.skipBytes(4);
                        for (n2 = 0; n2 < ncl[n]; ++n2) {
                            fArray2[n3][n2] = dataInputStream.readFloat();
                        }
                    }
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    return false;
                }
                GeoPoint.nadla[n] = fArray;
                GeoPoint.nadlo[n] = fArray2;
            }
            double d3 = (this.latitude - xlats[n]) / dx[n];
            double d4 = (xlonw[n] - this.longitude) / dx[n];
            int n4 = (int)d3;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 > nrw[n] - 2) {
                n4 = nrw[n] - 2;
            }
            int n5 = n4 + 1;
            int n6 = (int)d4;
            if (n6 < 0) {
                n6 = 0;
            }
            if (n6 > ncl[n] - 2) {
                n6 = ncl[n] - 2;
            }
            int n7 = n6 + 1;
            double d5 = fArray[n4][n6];
            double d6 = fArray[n5][n6];
            double d7 = fArray[n4][n7];
            double d8 = fArray[n5][n7];
            double d9 = d5;
            double d10 = d7 - d5;
            double d11 = d6 - d5;
            double d12 = d8 - d7 - d6 + d5;
            d5 = fArray2[n4][n6];
            d6 = fArray2[n5][n6];
            d7 = fArray2[n4][n7];
            d8 = fArray2[n5][n7];
            double d13 = d5;
            double d14 = d7 - d5;
            double d15 = d6 - d5;
            double d16 = d8 - d7 - d6 + d5;
            double d17 = d3 - (double)n4;
            double d18 = d4 - (double)n6;
            d = d9 + d10 * d18 + d11 * d17 + d12 * d18 * d17;
            d2 = -(d13 + d14 * d18 + d15 * d17 + d16 * d18 * d17);
        } else {
            double d19 = this.latitude * (Math.PI / 180);
            double d20 = -this.longitude * (Math.PI / 180);
            double d21 = Math.sin(d19);
            double d22 = Math.sin(d20);
            double d23 = Math.cos(d19);
            double d24 = Math.cos(d20);
            double d25 = 0.006768657391494375;
            double d26 = Math.sqrt(1.0 - d25 * d21 * d21);
            double d27 = 6378206.4 * (1.0 - d25) / (d26 * d26 * d26);
            double d28 = 6378206.4 / d26;
            d = (dz[n] * d23 - dx[n] * d21 * d24 - dy[n] * d21 * d22 + -237.91683016848964 * Math.sin(2.0 * d19)) / (4.848136E-6 * d27);
            d2 = (dy[n] * d24 - dx[n] * d22) / (4.848136E-6 * d28 * d23);
        }
        this.latitude += d / 3600.0;
        this.longitude -= d2 / 3600.0;
        return true;
    }

    public GeoPoint getPointInNAD27() {
        double d = this.latitude;
        double d2 = this.longitude;
        GeoPoint geoPoint = new GeoPoint();
        geoPoint.latitude = d;
        geoPoint.longitude = d2;
        if (!geoPoint.convertFromNAD27()) {
            geoPoint.updateDMS();
            return geoPoint;
        }
        double d3 = 2.0 * d - geoPoint.latitude;
        double d4 = 2.0 * d2 - geoPoint.longitude;
        int n = 0;
        while (++n < 20) {
            geoPoint.latitude = d3;
            geoPoint.longitude = d4;
            if (!geoPoint.convertFromNAD27()) break;
            double d5 = geoPoint.latitude - d;
            double d6 = geoPoint.longitude - d2;
            if (Math.abs(d5) < 1.0E-10 && Math.abs(d6) < 1.0E-10) {
                geoPoint.latitude = d3;
                geoPoint.longitude = d4;
                geoPoint.updateDMS();
                return geoPoint;
            }
            d3 -= d5;
            d4 -= d6;
        }
        geoPoint.latitude = d;
        geoPoint.longitude = d2;
        geoPoint.updateDMS();
        return geoPoint;
    }

    public void writeAttributes(Writer writer) throws IOException {
        writer.append(" LATITUDE83=\"");
        writer.append(AppCore.formatLatitude(this.latitude));
        writer.append("\" LONGITUDE83=\"");
        writer.append(AppCore.formatLongitude(this.longitude));
        writer.append('\"');
    }

    public boolean parseAttributes(String string, Attributes attributes, ErrorLogger errorLogger) {
        return this.parseAttributes(string, attributes, 0, errorLogger);
    }

    public boolean parseAttributes(String string, Attributes attributes, int n, ErrorLogger errorLogger) {
        double d = -74.0;
        double d2 = -181.0;
        String string2 = attributes.getValue("LATITUDE83");
        String string3 = attributes.getValue("LONGITUDE83");
        boolean bl = false;
        if (null == string2 || null == string3) {
            string2 = attributes.getValue("LATITUDE27");
            string3 = attributes.getValue("LONGITUDE27");
            bl = true;
            if (n > 0 && (null == string2 || null == string3)) {
                string2 = attributes.getValue("LATITUDE");
                string3 = attributes.getValue("LONGITUDE");
                boolean bl2 = bl = 2 != n;
            }
        }
        if (null != string2 && null != string3) {
            d = AppCore.parseLatitude(string2);
            d2 = AppCore.parseLongitude(string3);
        }
        if (d < -73.0 || d > 73.5 || d2 < -180.0 || d2 > 180.0) {
            if (null != errorLogger) {
                errorLogger.reportError("Missing or bad LATITUDE83/LONGITUDE83 attributes in " + string + " tag");
            }
            return false;
        }
        this.latitude = d;
        this.longitude = d2;
        if (bl) {
            this.convertFromNAD27();
        } else {
            this.updateDMS();
        }
        return true;
    }

    public double distanceTo(GeoPoint geoPoint, double d) {
        return this.distanceTo(geoPoint.latitude, geoPoint.longitude, d);
    }

    public double distanceTo(double d, double d2, double d3) {
        double d4;
        double d5 = this.latitude * (Math.PI / 180);
        double d6 = this.longitude * (Math.PI / 180);
        double d7 = d * (Math.PI / 180);
        double d8 = d2 * (Math.PI / 180);
        for (d4 = d6 - d8; d4 < -Math.PI; d4 += Math.PI * 2) {
        }
        while (d4 > Math.PI) {
            d4 -= Math.PI * 2;
        }
        double d9 = Math.sin(d5) * Math.sin(d7) + Math.cos(d5) * Math.cos(d7) * Math.cos(d4);
        if (d9 < -1.0) {
            d9 = -1.0;
        }
        if (d9 > 1.0) {
            d9 = 1.0;
        }
        return Math.acos(d9) * 57.29577951308232 * d3;
    }
}

