/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.geo;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import gov.fcc.tvstudy.core.geo.Geography;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import org.xml.sax.Attributes;

public class GeoBox
extends Geography {
    public final GeoPoint center = new GeoPoint();
    public double width;
    public double height;

    public GeoBox(String string) {
        super(string, 3);
    }

    @Override
    public boolean loadData(ErrorLogger errorLogger) {
        if (null == this.key) {
            return false;
        }
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        String string = null;
        try {
            dbConnection.query("SELECT latitude, longitude, width, height FROM geography WHERE geo_key = " + this.key);
            if (dbConnection.next()) {
                this.center.setLatLon(dbConnection.getDouble(1), dbConnection.getDouble(2));
                this.width = dbConnection.getDouble(3);
                this.height = dbConnection.getDouble(4);
            } else {
                string = "Box geography data not found for key " + this.key;
            }
        }
        catch (SQLException sQLException) {
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string) {
            if (null != errorLogger) {
                errorLogger.reportError(string);
            }
            return false;
        }
        return true;
    }

    @Override
    public Geography duplicate() {
        GeoBox geoBox = new GeoBox(this.dbID);
        super.duplicateTo(geoBox);
        geoBox.center.setLatLon(this.center);
        geoBox.width = this.width;
        geoBox.height = this.height;
        return geoBox;
    }

    @Override
    public boolean isDataValid(ErrorLogger errorLogger) {
        if (!super.isDataValid(errorLogger)) {
            return false;
        }
        if (0.0 == this.center.latitude || 0.0 == this.center.longitude) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Box center latitude and longitude must be provided");
            }
            return false;
        }
        if (this.center.latitude < -73.0 || this.center.latitude > 73.5) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad box center latitude, must be -73.0 to 73.5 degrees");
            }
            return false;
        }
        if (this.center.longitude < -180.0 || this.center.longitude > 180.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad box center longitude, must be -180.0 to 180.0 degrees");
            }
            return false;
        }
        if (this.width < 1.0 || this.width > 3000.0 || this.height < 1.0 || this.height > 3000.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Box width and height must be between 1.0 and 3000.0");
            }
            return false;
        }
        return true;
    }

    @Override
    protected String saveGeography(DbConnection dbConnection) throws SQLException {
        return super.saveGeography(dbConnection, this.center, 0.0, this.width, this.height);
    }

    @Override
    protected void writeAttributes(Writer writer) throws IOException {
        this.center.writeAttributes(writer);
        writer.append(" WIDTH=\"");
        writer.append(AppCore.formatDistance(this.width));
        writer.append("\" HEIGHT=\"");
        writer.append(AppCore.formatDistance(this.height));
        writer.append('\"');
    }

    @Override
    protected boolean parseAttributes(String string, Attributes attributes, ErrorLogger errorLogger) {
        if (!this.center.parseAttributes(string, attributes, errorLogger)) {
            return false;
        }
        String string2 = attributes.getValue("WIDTH");
        this.width = 0.0;
        if (null != string2) {
            try {
                this.width = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.width < 1.0 || this.width > 3000.0) {
            if (null != errorLogger) {
                errorLogger.reportError("Bad WIDTH attribute in " + string + " tag");
            }
            return false;
        }
        string2 = attributes.getValue("HEIGHT");
        this.height = 0.0;
        if (null != string2) {
            try {
                this.height = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.height < 1.0 || this.height > 3000.0) {
            if (null != errorLogger) {
                errorLogger.reportError("Bad HEIGHT attribute in " + string + " tag");
            }
            return false;
        }
        return true;
    }
}

