/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.editdata;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.OutputConfig;
import gov.fcc.tvstudy.core.data.IxRule;
import gov.fcc.tvstudy.core.data.Parameter;
import gov.fcc.tvstudy.core.data.Scenario;
import gov.fcc.tvstudy.core.data.Source;
import gov.fcc.tvstudy.core.data.SourceTV;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.editdata.IxRuleEditData;
import gov.fcc.tvstudy.core.editdata.IxRuleListData;
import gov.fcc.tvstudy.core.editdata.ParameterEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioListData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.geo.Geography;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class StudyEditData {
    public Study study;
    public final String dbID;
    private int newSourceKey;
    private boolean[] sourceKeyMap;
    public String name;
    public String description;
    public Integer extDbKey;
    public int studyMode;
    public int pointSetKey;
    public int propagationModel;
    public int studyAreaMode;
    public int studyAreaGeoKey;
    public OutputConfig fileOutputConfig;
    public OutputConfig mapOutputConfig;
    public String outDirectory;
    public final ArrayList<ParameterEditData> parameters;
    private HashMap<Integer, ParameterEditData> parameterMap;
    public final IxRuleListData ixRuleData;
    private HashMap<Integer, SourceEditData> sources;
    private HashSet<Integer> addedSourceKeys;
    private HashSet<Integer> deletedSourceKeys;
    private ArrayList<SourceEditData> changedSources;
    private ArrayList<Integer> replicationOriginalKeys;
    private static final Integer USER_RECORD_INDEX_KEY = -1;
    private SourceIndex userRecordIndex;
    private HashMap<Integer, SourceIndex> extDbsIndex;
    public final ScenarioListData scenarioData;
    private boolean invalidated;

    public StudyEditData(Study study) {
        this.study = study;
        this.dbID = this.study.dbID;
        this.sourceKeyMap = new boolean[65536];
        this.updateSourceKeyMap();
        this.name = this.study.name;
        this.description = this.study.description;
        this.extDbKey = this.study.extDbKey;
        this.studyMode = this.study.studyMode;
        this.pointSetKey = this.study.pointSetKey;
        this.propagationModel = this.study.propagationModel;
        this.studyAreaMode = this.study.studyAreaMode;
        this.studyAreaGeoKey = this.study.studyAreaGeoKey;
        this.fileOutputConfig = OutputConfig.getOrMakeConfig(this.dbID, 1, this.study.fileOutputConfigName, this.study.fileOutputConfigCodes);
        this.mapOutputConfig = OutputConfig.getOrMakeConfig(this.dbID, 2, this.study.mapOutputConfigName, this.study.mapOutputConfigCodes);
        this.outDirectory = this.study.outDirectory;
        this.parameters = new ArrayList();
        this.parameterMap = new HashMap();
        for (Parameter object : this.study.parameters) {
            ParameterEditData parameterEditData = new ParameterEditData(object, this.study.templateLocked);
            this.parameters.add(parameterEditData);
            this.parameterMap.put(object.key, parameterEditData);
        }
        this.ixRuleData = new IxRuleListData(this.study.ixRules, this.study.templateLocked);
        this.sources = new HashMap();
        for (Source source : this.study.sources) {
            SourceEditData sourceEditData = SourceEditData.getInstance(this, source);
            this.sources.put(sourceEditData.key, sourceEditData);
        }
        this.addedSourceKeys = new HashSet();
        this.deletedSourceKeys = new HashSet();
        this.changedSources = new ArrayList();
        this.replicationOriginalKeys = new ArrayList();
        this.userRecordIndex = new SourceIndex(USER_RECORD_INDEX_KEY);
        this.extDbsIndex = new HashMap();
        this.rebuildSourceIndex();
        this.scenarioData = new ScenarioListData(this);
    }

    public String toString() {
        return this.name;
    }

    public synchronized void invalidate() {
        this.invalidated = true;
    }

    public synchronized Integer getNewIxRuleKey() {
        if (++this.study.maxIxRuleKey <= 0) {
            this.study.maxIxRuleKey = -1;
            throw new RuntimeException("Interference rule key range exhausted");
        }
        return this.study.maxIxRuleKey;
    }

    public synchronized Integer getNewScenarioKey() {
        if (++this.study.maxScenarioKey <= 0) {
            this.study.maxScenarioKey = -1;
            throw new RuntimeException("Scenario key range exhausted");
        }
        return this.study.maxScenarioKey;
    }

    public synchronized Integer getNewSourceKey() {
        int n = this.newSourceKey;
        do {
            if (++this.newSourceKey <= 65535) continue;
            this.newSourceKey = 1;
        } while (this.sourceKeyMap[this.newSourceKey] && this.newSourceKey != n);
        if (this.newSourceKey == n) {
            return null;
        }
        this.sourceKeyMap[this.newSourceKey] = true;
        return this.newSourceKey;
    }

    private void updateSourceKeyMap() {
        this.sourceKeyMap[0] = true;
        for (int i = 1; i < 65536; ++i) {
            this.sourceKeyMap[i] = false;
        }
        this.newSourceKey = 0;
        for (Source source : this.study.sources) {
            if (source.key > this.newSourceKey) {
                this.newSourceKey = source.key;
            }
            this.sourceKeyMap[source.key] = true;
            if (1 != source.recordType) continue;
            SourceTV sourceTV = (SourceTV)source;
            if (!sourceTV.isParent) continue;
            for (SourceTV sourceTV2 : sourceTV.dtsSources) {
                if (sourceTV2.key > this.newSourceKey) {
                    this.newSourceKey = sourceTV2.key;
                }
                this.sourceKeyMap[sourceTV2.key] = true;
            }
        }
    }

    public synchronized void addOrReplaceSource(SourceEditData sourceEditData) {
        Object object;
        if (null == this.sources.put(sourceEditData.key, sourceEditData)) {
            if (!this.deletedSourceKeys.remove(sourceEditData.key)) {
                this.addedSourceKeys.add(sourceEditData.key);
            }
            if (1 == sourceEditData.recordType) {
                object = (SourceEditDataTV)sourceEditData;
                if (null != ((SourceEditDataTV)object).originalSourceKey) {
                    this.replicationOriginalKeys.add(((SourceEditDataTV)object).originalSourceKey);
                }
            }
        }
        if (sourceEditData.isLocked) {
            if (null != sourceEditData.userRecordID) {
                this.userRecordIndex.addOrReplace(sourceEditData);
            } else if (null != sourceEditData.extDbKey && null != sourceEditData.extRecordID) {
                object = this.extDbsIndex.get(sourceEditData.extDbKey);
                if (null == object) {
                    object = new SourceIndex(sourceEditData.extDbKey);
                    this.extDbsIndex.put(sourceEditData.extDbKey, (SourceIndex)object);
                }
                ((SourceIndex)object).addOrReplace(sourceEditData);
            }
        }
    }

    public synchronized SourceEditData getSource(Integer n) {
        return this.sources.get(n);
    }

    public synchronized SourceEditData findSharedSource(Integer n) {
        if (null == n) {
            return null;
        }
        return this.userRecordIndex.getSource(String.valueOf(n));
    }

    public synchronized SourceEditDataTV findSharedReplicationSource(Integer n, int n2) {
        if (null == n) {
            return null;
        }
        return this.userRecordIndex.getReplicationSource(String.valueOf(n), n2);
    }

    public synchronized SourceEditData findSharedSource(Integer n, String string) {
        if (null == n || null == string) {
            return null;
        }
        SourceIndex sourceIndex = this.extDbsIndex.get(n);
        if (null == sourceIndex) {
            return null;
        }
        return sourceIndex.getSource(string);
    }

    public synchronized SourceEditDataTV findSharedReplicationSource(Integer n, String string, int n2) {
        if (null == n || null == string) {
            return null;
        }
        SourceIndex sourceIndex = this.extDbsIndex.get(n);
        if (null == sourceIndex) {
            return null;
        }
        return sourceIndex.getReplicationSource(string, n2);
    }

    public synchronized void loadSharedSourceIndex(int n, HashMap<String, SourceEditData> hashMap, ArrayList<HashMap<String, SourceEditDataTV>> arrayList) {
        hashMap.clear();
        arrayList.clear();
        SourceIndex sourceIndex = this.extDbsIndex.get(n);
        if (null != sourceIndex) {
            hashMap.putAll(sourceIndex.sharedSources);
            for (HashMap hashMap2 : sourceIndex.sharedReplicationSources) {
                arrayList.add(new HashMap(hashMap2));
            }
        } else {
            int n2 = 68;
            for (int i = 0; i < n2; ++i) {
                arrayList.add(new HashMap());
            }
        }
    }

    public synchronized void removeSource(SourceEditData sourceEditData) {
        SourceIndex sourceIndex = null;
        if (null != sourceEditData.userRecordID) {
            sourceIndex = this.userRecordIndex;
        } else if (null != sourceEditData.extDbKey) {
            sourceIndex = this.extDbsIndex.get(sourceEditData.extDbKey);
        }
        if (null != sourceIndex && sourceIndex.contains(sourceEditData)) {
            return;
        }
        if (this.replicationOriginalKeys.contains(sourceEditData.key)) {
            return;
        }
        this.sources.remove(sourceEditData.key);
        if (!this.addedSourceKeys.remove(sourceEditData.key)) {
            this.deletedSourceKeys.add(sourceEditData.key);
        }
        if (1 == sourceEditData.recordType) {
            SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
            if (null != sourceEditDataTV.originalSourceKey) {
                this.replicationOriginalKeys.remove(sourceEditDataTV.originalSourceKey);
                SourceEditData sourceEditData2 = this.sources.get(sourceEditDataTV.originalSourceKey);
                if (null != sourceEditData2) {
                    if (null != sourceIndex && sourceIndex.contains(sourceEditData2)) {
                        return;
                    }
                    if (this.replicationOriginalKeys.contains(sourceEditData2.key)) {
                        return;
                    }
                    this.sources.remove(sourceEditData2.key);
                    if (!this.addedSourceKeys.remove(sourceEditData2.key)) {
                        this.deletedSourceKeys.add(sourceEditData2.key);
                    }
                }
            }
        }
    }

    public synchronized void removeAllUnusedSources() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (ScenarioEditData object : this.scenarioData.getRows()) {
            for (SourceEditData sourceEditData : object.sourceData.getSources()) {
                hashSet.add(sourceEditData.key);
                if (1 != sourceEditData.recordType) continue;
                SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
                if (null == sourceEditDataTV.originalSourceKey) continue;
                hashSet.add(sourceEditDataTV.originalSourceKey);
            }
        }
        Iterator<Object> iterator = this.sources.values().iterator();
        while (iterator.hasNext()) {
            SourceEditData sourceEditData = (SourceEditData)iterator.next();
            if (hashSet.contains(sourceEditData.key)) continue;
            iterator.remove();
            if (this.addedSourceKeys.remove(sourceEditData.key)) continue;
            this.deletedSourceKeys.add(sourceEditData.key);
        }
        this.rebuildSourceIndex();
    }

    public synchronized int getUnusedSourceCount() {
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (ScenarioEditData object : this.scenarioData.getRows()) {
            for (SourceEditData sourceEditData : object.sourceData.getSources()) {
                hashSet.add(sourceEditData.key);
                if (1 != sourceEditData.recordType) continue;
                SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
                if (null == sourceEditDataTV.originalSourceKey) continue;
                hashSet.add(sourceEditDataTV.originalSourceKey);
            }
        }
        for (SourceEditData sourceEditData : this.sources.values()) {
            if (hashSet.contains(sourceEditData.key)) continue;
            ++n;
        }
        return n;
    }

    private void rebuildSourceIndex() {
        this.replicationOriginalKeys.clear();
        this.userRecordIndex.clear();
        this.extDbsIndex.clear();
        for (SourceEditData sourceEditData : this.sources.values()) {
            if (1 == sourceEditData.recordType) {
                SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
                if (null != sourceEditDataTV.originalSourceKey) {
                    this.replicationOriginalKeys.add(sourceEditDataTV.originalSourceKey);
                }
            }
            if (!sourceEditData.isLocked) continue;
            if (null != sourceEditData.userRecordID) {
                this.userRecordIndex.addOrReplace(sourceEditData);
                continue;
            }
            if (null == sourceEditData.extDbKey || null == sourceEditData.extRecordID) continue;
            SourceIndex sourceIndex = this.extDbsIndex.get(sourceEditData.extDbKey);
            if (null == sourceIndex) {
                sourceIndex = new SourceIndex(sourceEditData.extDbKey);
                this.extDbsIndex.put(sourceEditData.extDbKey, sourceIndex);
            }
            sourceIndex.addOrReplace(sourceEditData);
        }
    }

    public boolean isGeographyInUse(int n) {
        if (2 == this.studyMode && n == this.pointSetKey) {
            return true;
        }
        if (2 == this.studyAreaMode && n == this.studyAreaGeoKey) {
            return true;
        }
        for (SourceEditData sourceEditData : this.sources.values()) {
            if (!sourceEditData.isGeographyInUse(n)) continue;
            return true;
        }
        return false;
    }

    public boolean isDataValid() {
        return this.isDataValid(null);
    }

    public boolean isDataValid(ErrorLogger errorLogger) {
        if (this.invalidated) {
            if (null != errorLogger) {
                errorLogger.reportError("Object has been invalidated");
            }
            return false;
        }
        if (1 != this.studyMode && 2 != this.studyMode) {
            if (null != errorLogger) {
                errorLogger.reportError("Invalid study mode");
            }
            return false;
        }
        if (1 == this.studyMode) {
            if (1 != this.studyAreaMode && 2 != this.studyAreaMode && 3 != this.studyAreaMode) {
                if (null != errorLogger) {
                    errorLogger.reportError("Invalid study area mode");
                }
                return false;
            }
            if (2 == this.studyAreaMode && this.studyAreaGeoKey <= 0) {
                if (null != errorLogger) {
                    errorLogger.reportError("A study area geography must be selected");
                }
                return false;
            }
        } else if (this.pointSetKey <= 0) {
            if (null != errorLogger) {
                errorLogger.reportError("A study point set must be selected");
            }
            return false;
        }
        if (!this.ixRuleData.isDataValid(errorLogger)) {
            return false;
        }
        if (!this.scenarioData.isDataValid(errorLogger)) {
            return false;
        }
        if (!this.fileOutputConfig.isValid()) {
            if (null != errorLogger) {
                errorLogger.reportError("Invalid output file settings");
            }
            return false;
        }
        if (!this.mapOutputConfig.isValid()) {
            if (null != errorLogger) {
                errorLogger.reportError("Invalid map output settings");
            }
            return false;
        }
        return true;
    }

    public boolean isDataChanged() {
        if (this.invalidated) {
            return false;
        }
        boolean bl = false;
        if (this.ixRuleData.isDataChanged()) {
            bl = true;
        }
        if (this.scenarioData.isDataChanged()) {
            bl = true;
        }
        this.changedSources.clear();
        for (SourceEditData object : this.sources.values()) {
            if (!object.isDataChanged() && !this.addedSourceKeys.contains(object.key)) continue;
            this.changedSources.add(object);
            bl = true;
        }
        if (bl) {
            return true;
        }
        if (!this.deletedSourceKeys.isEmpty()) {
            return true;
        }
        for (ParameterEditData parameterEditData : this.parameters) {
            if (!parameterEditData.isDataChanged()) continue;
            return true;
        }
        if (!this.name.equals(this.study.name)) {
            return true;
        }
        if (!this.description.equals(this.study.description)) {
            return true;
        }
        if (null == this.study.extDbKey) {
            if (null != this.extDbKey) {
                return true;
            }
        } else {
            if (null == this.extDbKey) {
                return true;
            }
            if (!this.extDbKey.equals(this.study.extDbKey)) {
                return true;
            }
        }
        if (this.studyMode != this.study.studyMode) {
            return true;
        }
        if (2 == this.studyMode && this.pointSetKey != this.study.pointSetKey) {
            return true;
        }
        if (this.propagationModel != this.study.propagationModel) {
            return true;
        }
        if (this.studyAreaMode != this.study.studyAreaMode) {
            return true;
        }
        if (2 == this.studyAreaMode && this.studyAreaGeoKey != this.study.studyAreaGeoKey) {
            return true;
        }
        if (this.fileOutputConfig.isNull()) {
            if (this.study.fileOutputConfigName.length() > 0) {
                return true;
            }
        } else {
            if (!this.fileOutputConfig.name.equals(this.study.fileOutputConfigName)) {
                return true;
            }
            if (this.fileOutputConfig.isUnsaved() && !this.fileOutputConfig.getCodes().equals(this.study.fileOutputConfigCodes)) {
                return true;
            }
        }
        if (this.mapOutputConfig.isNull()) {
            if (this.study.mapOutputConfigName.length() > 0) {
                return true;
            }
        } else {
            if (!this.mapOutputConfig.name.equals(this.study.mapOutputConfigName)) {
                return true;
            }
            if (this.mapOutputConfig.isUnsaved() && !this.mapOutputConfig.getCodes().equals(this.study.mapOutputConfigCodes)) {
                return true;
            }
        }
        return !this.outDirectory.equals(this.study.outDirectory);
    }

    public boolean save() {
        return this.save(null, null);
    }

    public boolean save(ErrorLogger errorLogger) {
        return this.save(errorLogger, null);
    }

    public boolean save(String string) {
        return this.save(null, string);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean save(ErrorLogger errorLogger, String string) {
        if (this.invalidated) {
            if (null == errorLogger) return false;
            errorLogger.reportError("Study save failed, object has been invalidated");
            return false;
        }
        String string2 = DbCore.getDbName(this.dbID);
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null == dbConnection) return false;
        try {
            void var25_55;
            Object object;
            int n;
            Object object2;
            Object object3;
            boolean bl = false;
            String string3 = "";
            dbConnection.query("SELECT study_lock, lock_count FROM study WHERE study_key = " + this.study.key);
            if (dbConnection.next()) {
                if (1 != dbConnection.getInt(1) || this.study.lockCount != dbConnection.getInt(2)) {
                    bl = true;
                    string3 = "Study save failed, lock has been modified";
                }
            } else {
                bl = true;
                string3 = "Study save failed, study does not exist";
            }
            if (bl) {
                DbCore.releaseDb(dbConnection);
                if (null == errorLogger) return false;
                errorLogger.reportError(string3);
                return false;
            }
            dbConnection.setDatabase(string2 + "_" + this.study.key);
            boolean bl2 = false;
            for (ParameterEditData hashSet2 : this.parameters) {
                if (!hashSet2.isDataChanged()) continue;
                dbConnection.update("DELETE FROM parameter_data WHERE parameter_key = " + hashSet2.parameter.key);
                for (int i = 0; i < hashSet2.parameter.valueCount; ++i) {
                    dbConnection.update("INSERT INTO parameter_data ( parameter_key,value_index,value) VALUES (" + hashSet2.parameter.key + "," + i + ",'" + DbConnection.clean(hashSet2.value[i]) + "')");
                }
                hashSet2.didSave();
                bl2 = true;
            }
            int n2 = this.study.modCount;
            HashSet<Integer> hashSet = this.ixRuleData.getDeletedKeys();
            if (!hashSet.isEmpty()) {
                dbConnection.update("DELETE FROM ix_rule WHERE ix_rule_key IN " + DbConnection.makeKeyList(hashSet));
                n2 = this.study.modCount + 1;
            }
            for (IxRuleEditData ixRuleEditData : this.ixRuleData.getChangedRows()) {
                if (null != ixRuleEditData.ixRule) {
                    dbConnection.update("DELETE FROM ix_rule WHERE ix_rule_key = " + ixRuleEditData.key);
                }
                dbConnection.update("INSERT INTO ix_rule (ix_rule_key,country_key,service_type_key,signal_type_key,undesired_service_type_key,undesired_signal_type_key,channel_delta_key,channel_band_key,frequency_offset,emission_mask_key,distance,required_du,undesired_time,is_active) VALUES (" + ixRuleEditData.key + "," + ixRuleEditData.country.key + "," + ixRuleEditData.serviceType.key + "," + ixRuleEditData.signalType.key + "," + ixRuleEditData.undesiredServiceType.key + "," + ixRuleEditData.undesiredSignalType.key + "," + ixRuleEditData.channelDelta.key + "," + ixRuleEditData.channelBand.key + "," + ixRuleEditData.frequencyOffset + "," + ixRuleEditData.emissionMask.key + "," + ixRuleEditData.distance + "," + ixRuleEditData.requiredDU + "," + ixRuleEditData.undesiredTime + "," + ixRuleEditData.isActive + ")");
                ixRuleEditData.didSave();
                n2 = this.study.modCount + 1;
            }
            this.ixRuleData.didSave();
            HashSet<Integer> hashSet2 = this.scenarioData.getDeletedKeys();
            if (!hashSet2.isEmpty()) {
                object3 = DbConnection.makeKeyList(hashSet2);
                dbConnection.update("DELETE FROM scenario WHERE scenario_key IN " + (String)object3);
                dbConnection.update("DELETE FROM scenario_source WHERE scenario_key IN " + (String)object3);
                dbConnection.update("DELETE FROM scenario_parameter_data WHERE scenario_key IN " + (String)object3);
                HashSet<Integer> hashSet3 = new HashSet<Integer>();
                dbConnection.query("SELECT scenario_key FROM scenario WHERE parent_scenario_key IN " + (String)object3);
                while (dbConnection.next()) {
                    hashSet3.add(dbConnection.getInt(1));
                }
                if (!hashSet3.isEmpty()) {
                    object3 = DbConnection.makeKeyList(hashSet3);
                    dbConnection.update("DELETE FROM scenario WHERE scenario_key IN " + (String)object3);
                    dbConnection.update("DELETE FROM scenario_source WHERE scenario_key IN " + (String)object3);
                    dbConnection.update("DELETE FROM scenario_parameter_data WHERE scenario_key IN " + (String)object3);
                }
            }
            for (ScenarioEditData scenarioEditData : this.scenarioData.getChangedRows()) {
                scenarioEditData.save(dbConnection);
                if (scenarioEditData.didChildScenariosChange()) {
                    for (ScenarioEditData scenarioEditData2 : scenarioEditData.getChildScenarios()) {
                        scenarioEditData2.save(dbConnection);
                    }
                }
                scenarioEditData.didSave();
            }
            ArrayList<Scenario.ScenarioPair> arrayList = this.scenarioData.getScenarioPairs();
            if (this.scenarioData.didScenarioPairsChange()) {
                dbConnection.update("DELETE FROM scenario_pair");
                StringBuilder stringBuilder = new StringBuilder("INSERT INTO scenario_pair (name, description, scenario_key_a, source_key_a, scenario_key_b, source_key_b) VALUES");
                int n3 = stringBuilder.length();
                object2 = " (";
                for (Scenario.ScenarioPair scenarioPair : arrayList) {
                    stringBuilder.append((String)object2);
                    stringBuilder.append('\'');
                    stringBuilder.append(DbConnection.clean(scenarioPair.name));
                    stringBuilder.append("','");
                    stringBuilder.append(DbConnection.clean(scenarioPair.description));
                    stringBuilder.append("',");
                    stringBuilder.append(String.valueOf(scenarioPair.scenarioKeyA));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(scenarioPair.sourceKeyA));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(scenarioPair.scenarioKeyB));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(scenarioPair.sourceKeyB));
                    if (stringBuilder.length() > 500000) {
                        stringBuilder.append(')');
                        dbConnection.update(stringBuilder.toString());
                        stringBuilder.setLength(n3);
                        object2 = " (";
                        continue;
                    }
                    object2 = "),(";
                }
                if (stringBuilder.length() > n3) {
                    stringBuilder.append(')');
                    dbConnection.update(stringBuilder.toString());
                }
            }
            this.scenarioData.didSave();
            if (!this.deletedSourceKeys.isEmpty()) {
                object3 = DbConnection.makeKeyList(this.deletedSourceKeys);
                boolean bl3 = false;
                dbConnection.query("SELECT source_key FROM source WHERE parent_source_key IN " + (String)object3);
                while (dbConnection.next()) {
                    this.deletedSourceKeys.add(dbConnection.getInt(1));
                    bl3 = true;
                }
                if (bl3) {
                    object3 = DbConnection.makeKeyList(this.deletedSourceKeys);
                }
                dbConnection.update("DELETE FROM source_horizontal_pattern WHERE source_key IN " + (String)object3);
                dbConnection.update("DELETE FROM source_vertical_pattern WHERE source_key IN " + (String)object3);
                dbConnection.update("DELETE FROM source_matrix_pattern WHERE source_key IN " + (String)object3);
                dbConnection.update("DELETE FROM source WHERE source_key IN " + (String)object3);
                Geography.deleteStudyGeographies(dbConnection, string2, this.study.key, (String)object3);
            }
            for (SourceEditData sourceEditData : this.changedSources) {
                sourceEditData.save(dbConnection);
            }
            this.addedSourceKeys.clear();
            this.deletedSourceKeys.clear();
            this.changedSources.clear();
            int n4 = 0;
            if (2 == this.studyMode) {
                n4 = this.pointSetKey;
            }
            boolean bl4 = false;
            if (2 == this.studyAreaMode) {
                n = this.studyAreaGeoKey;
            }
            if (this.studyMode != this.study.studyMode || n4 != this.study.pointSetKey || this.propagationModel != this.study.propagationModel || this.studyAreaMode != this.study.studyAreaMode || n != this.study.studyAreaGeoKey) {
                bl2 = true;
                n2 = this.study.modCount + 1;
            }
            if (bl2) {
                dbConnection.update("UPDATE source SET needs_update = true");
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            dbConnection.query("SHOW TABLES LIKE 'result\\_%'");
            while (dbConnection.next()) {
                arrayList2.add(dbConnection.getString(1));
            }
            for (String string4 : arrayList2) {
                dbConnection.update("DROP TABLE " + string4);
            }
            HashSet hashSet4 = new HashSet();
            if (n4 > 0) {
                hashSet4.add(n4);
            }
            if (n > 0) {
                hashSet4.add(n);
            }
            for (SourceEditData sourceEditData : this.sources.values()) {
                int n5 = sourceEditData.getGeographyKey();
                if (n5 <= 0) continue;
                hashSet4.add(n5);
            }
            dbConnection.setDatabase(string2);
            dbConnection.update("LOCK TABLES study_geography WRITE");
            dbConnection.update("DELETE FROM study_geography WHERE study_key = " + this.study.key);
            if (!hashSet4.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder("INSERT INTO study_geography (study_key, geo_key) VALUES");
                int n6 = stringBuilder.length();
                object2 = " (";
                object = hashSet4.iterator();
                while (object.hasNext()) {
                    Integer n7 = (Integer)object.next();
                    stringBuilder.append((String)object2);
                    stringBuilder.append(String.valueOf(this.study.key));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(n7));
                    if (stringBuilder.length() > 500000) {
                        stringBuilder.append(')');
                        dbConnection.update(stringBuilder.toString());
                        stringBuilder.setLength(n6);
                        object2 = " (";
                        continue;
                    }
                    object2 = "),(";
                }
                if (stringBuilder.length() > n6) {
                    stringBuilder.append(')');
                    dbConnection.update(stringBuilder.toString());
                }
            }
            dbConnection.update("UNLOCK TABLES");
            if (!this.name.equals(this.study.name)) {
                dbConnection.update("LOCK TABLES study WRITE");
                dbConnection.query("SELECT study_key FROM study WHERE UPPER(name) = '" + DbConnection.clean(this.name.toUpperCase()) + "' AND study_key <> " + this.study.key);
                if (dbConnection.next()) {
                    errorLogger.logMessage("Name change was not saved, a study with the new name already exists");
                    this.name = this.study.name;
                } else {
                    dbConnection.update("UPDATE study SET name = '" + DbConnection.clean(this.name) + "' WHERE study_key = " + this.study.key);
                }
                dbConnection.update("UNLOCK TABLES");
            }
            object = new ArrayList();
            for (ParameterEditData parameterEditData : this.parameters) {
                ((ArrayList)object).add(parameterEditData.parameter);
            }
            ArrayList<IxRule> arrayList3 = this.ixRuleData.getRules();
            ArrayList<Source> arrayList4 = new ArrayList<Source>();
            for (SourceEditData sourceEditData : this.sources.values()) {
                arrayList4.add(sourceEditData.getSource());
            }
            ArrayList<Scenario> arrayList5 = this.scenarioData.getScenarios();
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            if (!this.fileOutputConfig.isNull()) {
                String string9 = this.fileOutputConfig.name;
                string6 = this.fileOutputConfig.getCodes();
            }
            if (!this.mapOutputConfig.isNull()) {
                string7 = this.mapOutputConfig.name;
                string8 = this.mapOutputConfig.getCodes();
            }
            String string10 = AppCore.formatDateTime(new Date());
            dbConnection.update("UPDATE study SET description = '" + DbConnection.clean(this.description) + "',study_mode = " + this.studyMode + ",mod_count = " + n2 + ",ext_db_key = " + (null == this.extDbKey ? "0" : String.valueOf(this.extDbKey)) + ",point_set_key = " + n4 + ",propagation_model = " + this.propagationModel + ",study_area_mode = " + this.studyAreaMode + ",study_area_geo_key = " + n + ",output_config_file_name = '" + DbConnection.clean((String)var25_55) + "',output_config_file_codes = '" + DbConnection.clean(string6) + "',output_config_map_name = '" + DbConnection.clean(string7) + "',output_config_map_codes = '" + DbConnection.clean(string8) + "',out_directory = '" + DbConnection.clean(this.outDirectory) + "',parameter_summary = '" + DbConnection.clean(Parameter.makeParameterSummary((ArrayList<Parameter>)object)) + "',ix_rule_summary = '" + DbConnection.clean(IxRule.makeIxRuleSummary(arrayList3)) + "', has_result_tables = false, modified = '" + string10 + "' WHERE study_key = " + this.study.key);
            if (null != string) {
                dbConnection.update("UPDATE study SET report_preamble = '" + DbConnection.clean(string) + "' WHERE study_key = " + this.study.key);
            } else {
                string = this.study.reportPreamble;
            }
            DbCore.releaseDb(dbConnection);
            this.study = new Study(this.dbID, this.study.key, this.name, this.description, this.study.studyType, this.studyMode, this.study.templateKey, this.study.templateName, this.study.templateLocked, this.extDbKey, n4, this.propagationModel, this.studyAreaMode, n, (ArrayList<Parameter>)object, arrayList3, arrayList4, arrayList5, arrayList, this.study.scenarioParameters, string, (String)var25_55, string6, string7, string8, this.outDirectory, this.study.studyLock, this.study.lockCount, n2, this.study.created, string10, this.study.lastRun, this.study.maxIxRuleKey, this.study.maxScenarioKey);
            this.updateSourceKeyMap();
            AppCore.purgeStudyCache(this.dbID, this.study.key, this.sourceKeyMap);
            return true;
        }
        catch (SQLException sQLException) {
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException2) {
                DbConnection.reportError(sQLException2);
            }
            DbCore.releaseDb(dbConnection);
            DbConnection.reportError(errorLogger, sQLException);
            return false;
        }
    }

    public boolean writeScenariosToXML(Writer writer, ArrayList<ScenarioEditData> arrayList) {
        return this.writeScenariosToXML(writer, arrayList, null);
    }

    public boolean writeScenariosToXML(Writer writer, ArrayList<ScenarioEditData> arrayList, ErrorLogger errorLogger) {
        try {
            writer.append("<TVSTUDY VERSION=\"105000\">\n");
            for (ScenarioEditData scenarioEditData : arrayList) {
                if (scenarioEditData.writeToXML(writer, errorLogger)) continue;
                return false;
            }
            writer.append("</TVSTUDY>\n");
        }
        catch (IOException iOException) {
            if (null != errorLogger) {
                errorLogger.reportError("Could not write to the file:\n" + iOException.getMessage());
            }
            return false;
        }
        catch (Throwable throwable) {
            AppCore.log(3, "Unexpected error", throwable);
            if (null != errorLogger) {
                errorLogger.reportError("An unexpected error occurred:\n" + throwable);
            }
            return false;
        }
        return true;
    }

    public Integer readScenariosFromXML(Integer n, Integer n2, Reader reader) {
        return this.readScenariosFromXML(n, n2, reader, null);
    }

    public Integer readScenariosFromXML(Integer n, Integer n2, Reader reader, ErrorLogger errorLogger) {
        SourceEditData.SourceXMLHandler sourceXMLHandler = new SourceEditData.SourceXMLHandler(this, n, n2, errorLogger);
        if (!AppCore.parseXML(reader, sourceXMLHandler, errorLogger)) {
            return null;
        }
        if (0 == sourceXMLHandler.scenarioCount) {
            if (sourceXMLHandler.hadStudy) {
                errorLogger.reportWarning("No compatible scenarios found");
            } else {
                errorLogger.reportWarning("No recognized XML structure found");
            }
            return null;
        }
        return sourceXMLHandler.scenarioCount;
    }

    public ParameterEditData getParameter(int n) {
        return this.parameterMap.get(n);
    }

    public int getGridType() {
        return this.getIntegerParameter(2, 0);
    }

    public double getCellSize() {
        return this.getDecimalParameter(4, 0);
    }

    public double getKilometersPerDegree() {
        return this.getDecimalParameter(200, 0);
    }

    public double getMaximumDistance() {
        return this.getDecimalParameter(215, 0);
    }

    public double getContourVloDigital(int n) {
        return this.getDecimalParameter(80, n);
    }

    public double getContourVhiDigital(int n) {
        return this.getDecimalParameter(82, n);
    }

    public double getContourUhfDigital(int n) {
        return this.getDecimalParameter(84, n);
    }

    public double getContourVloDigitalLPTV(int n) {
        return this.getDecimalParameter(86, n);
    }

    public double getContourVhiDigitalLPTV(int n) {
        return this.getDecimalParameter(88, n);
    }

    public double getContourUhfDigitalLPTV(int n) {
        return this.getDecimalParameter(90, n);
    }

    public double getContourVloAnalog(int n) {
        return this.getDecimalParameter(92, n);
    }

    public double getContourVhiAnalog(int n) {
        return this.getDecimalParameter(94, n);
    }

    public double getContourUhfAnalog(int n) {
        return this.getDecimalParameter(96, n);
    }

    public double getContourVloAnalogLPTV(int n) {
        return this.getDecimalParameter(98, n);
    }

    public double getContourVhiAnalogLPTV(int n) {
        return this.getDecimalParameter(100, n);
    }

    public double getContourUhfAnalogLPTV(int n) {
        return this.getDecimalParameter(102, n);
    }

    public boolean getUseDipoleCont(int n) {
        return this.getOptionParameter(104, n);
    }

    public double getDipoleCenterFreqCont(int n) {
        return this.getDecimalParameter(106, n);
    }

    public int getCurveSetDigital(int n) {
        return this.getIntegerParameter(107, n);
    }

    public int getCurveSetAnalog(int n) {
        return this.getIntegerParameter(108, n);
    }

    public double getContourFM(int n) {
        return this.getDecimalParameter(357, n);
    }

    public double getContourFMB(int n) {
        return this.getDecimalParameter(358, n);
    }

    public double getContourFMB1(int n) {
        return this.getDecimalParameter(359, n);
    }

    public double getContourFMED(int n) {
        return this.getDecimalParameter(360, n);
    }

    public double getContourFMLP(int n) {
        return this.getDecimalParameter(361, n);
    }

    public double getContourFMTX(int n) {
        return this.getDecimalParameter(362, n);
    }

    public int getCurveSetFM(int n) {
        return this.getIntegerParameter(363, n);
    }

    public double getRuleExtraDistanceLow() {
        return this.getDecimalParameter(335, 0);
    }

    public double getRuleExtraDistanceERPLow() {
        return this.getDecimalParameter(336, 0);
    }

    public double getRuleExtraDistanceLowMedium() {
        return this.getDecimalParameter(337, 0);
    }

    public double getRuleExtraDistanceERPMedium() {
        return this.getDecimalParameter(338, 0);
    }

    public double getRuleExtraDistanceMediumHigh() {
        return this.getDecimalParameter(339, 0);
    }

    public double getRuleExtraDistanceERPHigh() {
        return this.getDecimalParameter(340, 0);
    }

    public double getRuleExtraDistanceHigh() {
        return this.getDecimalParameter(210, 0);
    }

    public boolean getUseMaxRuleExtraDistance() {
        return this.getOptionParameter(189, 0);
    }

    public double getCoChannelMxDistance() {
        return this.getDecimalParameter(212, 0);
    }

    public int getMinimumChannel() {
        return this.getIntegerParameter(324, 0);
    }

    public int getMaximumChannel() {
        return this.getIntegerParameter(325, 0);
    }

    public boolean getTrustPatternFlag() {
        return this.getOptionParameter(18, 0);
    }

    public boolean getUseGenericVpat(int n) {
        return this.getOptionParameter(219, n);
    }

    public double getDefaultMexicanDigitalVloERP() {
        return this.getDecimalParameter(220, 0);
    }

    public double getDefaultMexicanDigitalVloHAAT() {
        return this.getDecimalParameter(221, 0);
    }

    public double getDefaultMexicanDigitalVhiERP() {
        return this.getDecimalParameter(222, 0);
    }

    public double getDefaultMexicanDigitalVhiHAAT() {
        return this.getDecimalParameter(223, 0);
    }

    public double getDefaultMexicanDigitalUhfERP() {
        return this.getDecimalParameter(224, 0);
    }

    public double getDefaultMexicanDigitalUhfHAAT() {
        return this.getDecimalParameter(225, 0);
    }

    public double getDefaultMexicanAnalogVloERP() {
        return this.getDecimalParameter(226, 0);
    }

    public double getDefaultMexicanAnalogVloHAAT() {
        return this.getDecimalParameter(227, 0);
    }

    public double getDefaultMexicanAnalogVhiERP() {
        return this.getDecimalParameter(228, 0);
    }

    public double getDefaultMexicanAnalogVhiHAAT() {
        return this.getDecimalParameter(229, 0);
    }

    public double getDefaultMexicanAnalogUhfERP() {
        return this.getDecimalParameter(230, 0);
    }

    public double getDefaultMexicanAnalogUhfHAAT() {
        return this.getDecimalParameter(231, 0);
    }

    public boolean getCheckIndividualDTSDistance() {
        return this.getOptionParameter(326, 0);
    }

    public double getDefaultMexicanFMAERP() {
        return this.getDecimalParameter(232, 0);
    }

    public double getDefaultMexicanFMAHAAT() {
        return this.getDecimalParameter(233, 0);
    }

    public double getDefaultMexicanFMBERP() {
        return this.getDecimalParameter(234, 0);
    }

    public double getDefaultMexicanFMBHAAT() {
        return this.getDecimalParameter(235, 0);
    }

    public double getDefaultMexicanFMB1ERP() {
        return this.getDecimalParameter(236, 0);
    }

    public double getDefaultMexicanFMB1HAAT() {
        return this.getDecimalParameter(237, 0);
    }

    public double getDefaultMexicanFMCERP() {
        return this.getDecimalParameter(238, 0);
    }

    public double getDefaultMexicanFMCHAAT() {
        return this.getDecimalParameter(239, 0);
    }

    public double getDefaultMexicanFMC1ERP() {
        return this.getDecimalParameter(240, 0);
    }

    public double getDefaultMexicanFMC1HAAT() {
        return this.getDecimalParameter(241, 0);
    }

    public double[] getTV6FMDistance() {
        return this.getDecimalTableParameter(244, 0);
    }

    public double[] getTV6FMDistanceDtv() {
        return this.getDecimalTableParameter(242, 0);
    }

    public double[] getWirelessCullDistance(int n) {
        return this.getDecimalTableParameter(247, n);
    }

    private int getIntegerParameter(int n, int n2) {
        ParameterEditData parameterEditData = this.parameterMap.get(n);
        if (null == parameterEditData || parameterEditData.parameter.isTable || n2 < 0 || n2 >= parameterEditData.parameter.valueCount || null == parameterEditData.integerValue) {
            return 0;
        }
        return parameterEditData.integerValue[n2];
    }

    private int[] getIntegerTableParameter(int n, int n2) {
        ParameterEditData parameterEditData = this.parameterMap.get(n);
        if (null == parameterEditData || !parameterEditData.parameter.isTable || n2 < 0 || n2 >= parameterEditData.parameter.valueCount || null == parameterEditData.integerTableValue) {
            return null;
        }
        return parameterEditData.integerTableValue[n2];
    }

    private double getDecimalParameter(int n, int n2) {
        ParameterEditData parameterEditData = this.parameterMap.get(n);
        if (null == parameterEditData || parameterEditData.parameter.isTable || n2 < 0 || n2 >= parameterEditData.parameter.valueCount || null == parameterEditData.decimalValue) {
            return 0.0;
        }
        return parameterEditData.decimalValue[n2];
    }

    private double[] getDecimalTableParameter(int n, int n2) {
        ParameterEditData parameterEditData = this.parameterMap.get(n);
        if (null == parameterEditData || !parameterEditData.parameter.isTable || n2 < 0 || n2 >= parameterEditData.parameter.valueCount || null == parameterEditData.decimalTableValue) {
            return null;
        }
        return parameterEditData.decimalTableValue[n2];
    }

    private boolean getOptionParameter(int n, int n2) {
        ParameterEditData parameterEditData = this.parameterMap.get(n);
        if (null == parameterEditData || n2 < 0 || n2 >= parameterEditData.parameter.valueCount) {
            return false;
        }
        return parameterEditData.optionValue[n2];
    }

    private Date getDateParameter(int n, int n2) {
        ParameterEditData parameterEditData = this.parameterMap.get(n);
        if (null == parameterEditData || n2 < 0 || n2 >= parameterEditData.parameter.valueCount) {
            return null;
        }
        return parameterEditData.dateValue[n2];
    }

    private class SourceIndex {
        private Integer dbKey;
        private HashMap<String, SourceEditData> sharedSources;
        private ArrayList<HashMap<String, SourceEditDataTV>> sharedReplicationSources;

        private SourceIndex(Integer n) {
            this.dbKey = n;
            this.sharedSources = new HashMap();
            int n2 = 68;
            this.sharedReplicationSources = new ArrayList(n2);
            for (int i = 0; i < n2; ++i) {
                this.sharedReplicationSources.add(new HashMap());
            }
        }

        private void addOrReplace(SourceEditData sourceEditData) {
            if (!sourceEditData.isLocked) {
                return;
            }
            String string = null;
            if (this.dbKey.equals(USER_RECORD_INDEX_KEY)) {
                string = String.valueOf(sourceEditData.userRecordID);
            } else if (this.dbKey.equals(sourceEditData.extDbKey)) {
                string = sourceEditData.extRecordID;
            }
            if (null == string) {
                return;
            }
            if (1 != sourceEditData.recordType) {
                this.sharedSources.put(string, sourceEditData);
            } else {
                SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
                if (null == sourceEditDataTV.originalSourceKey) {
                    this.sharedSources.put(string, sourceEditData);
                } else {
                    SourceEditData sourceEditData2 = (SourceEditData)StudyEditData.this.sources.get(sourceEditDataTV.originalSourceKey);
                    if (null != sourceEditData2 && sourceEditData2.isLocked) {
                        this.sharedReplicationSources.get(sourceEditDataTV.channel - 2).put(string, sourceEditDataTV);
                    }
                }
            }
        }

        private boolean contains(SourceEditData sourceEditData) {
            if (!sourceEditData.isLocked) {
                return false;
            }
            String string = null;
            if (this.dbKey.equals(USER_RECORD_INDEX_KEY)) {
                string = String.valueOf(sourceEditData.userRecordID);
            } else if (this.dbKey.equals(sourceEditData.extDbKey)) {
                string = sourceEditData.extRecordID;
            }
            if (null == string) {
                return false;
            }
            if (1 != sourceEditData.recordType) {
                return this.sharedSources.containsKey(string);
            }
            SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
            if (null == sourceEditDataTV.originalSourceKey) {
                return this.sharedSources.containsKey(string);
            }
            return this.sharedReplicationSources.get(sourceEditDataTV.channel - 2).containsKey(string);
        }

        private void clear() {
            this.sharedSources.clear();
            for (HashMap<String, SourceEditDataTV> hashMap : this.sharedReplicationSources) {
                hashMap.clear();
            }
        }

        private SourceEditData getSource(String string) {
            return this.sharedSources.get(string);
        }

        private SourceEditDataTV getReplicationSource(String string, int n) {
            if (n < 2 || n > 69) {
                return null;
            }
            return this.sharedReplicationSources.get(n - 2).get(string);
        }
    }
}

