/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.editdata;

import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.data.Scenario;
import gov.fcc.tvstudy.core.editdata.ListDataChange;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;

public class SourceListData
implements ListDataChange {
    private StudyEditData study;
    private int scenarioType;
    private ArrayList<SourceItem> modelRows;
    private HashSet<Integer> addedKeys;
    private HashSet<Integer> deletedKeys;
    private int lastChange;
    private int lastRow;
    private int nextItemKey;

    public SourceListData(StudyEditData studyEditData, Scenario scenario) {
        this.doInit(studyEditData);
        if (null != scenario) {
            this.scenarioType = scenario.scenarioType;
            for (Scenario.SourceListItem sourceListItem : scenario.sourceList) {
                SourceItem sourceItem = new SourceItem(studyEditData, sourceListItem);
                if (null == sourceItem.source) {
                    this.deletedKeys.add(sourceItem.key);
                    continue;
                }
                this.modelRows.add(sourceItem);
            }
        } else {
            this.scenarioType = 1;
        }
    }

    public SourceListData(StudyEditData studyEditData, int n, ArrayList<Scenario.SourceListItem> arrayList) {
        this.doInit(studyEditData);
        this.scenarioType = n;
        if (null != arrayList) {
            for (Scenario.SourceListItem sourceListItem : arrayList) {
                SourceItem sourceItem = new SourceItem(studyEditData, sourceListItem);
                if (null == sourceItem.source) {
                    this.deletedKeys.add(sourceItem.key);
                    continue;
                }
                this.modelRows.add(sourceItem);
                this.addedKeys.add(sourceItem.key);
            }
        }
    }

    private void doInit(StudyEditData studyEditData) {
        this.study = studyEditData;
        this.modelRows = new ArrayList();
        this.addedKeys = new HashSet();
        this.deletedKeys = new HashSet();
        this.nextItemKey = 1;
    }

    public SourceListData duplicate() {
        return this.duplicate(null);
    }

    public SourceListData duplicate(ErrorLogger errorLogger) {
        ArrayList<SourceEditData> arrayList = new ArrayList<SourceEditData>();
        ArrayList<Scenario.SourceListItem> arrayList2 = new ArrayList<Scenario.SourceListItem>();
        for (SourceItem object : this.modelRows) {
            SourceEditData sourceEditData = object.source;
            if (!sourceEditData.isLocked) {
                if (null == (sourceEditData = sourceEditData.deriveSource(false, errorLogger))) {
                    return null;
                }
                arrayList.add(sourceEditData);
            } else if (1 == sourceEditData.recordType) {
                SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
                if (null != sourceEditDataTV.originalSourceKey) {
                    SourceEditData sourceEditData2 = this.study.getSource(sourceEditDataTV.originalSourceKey);
                    if (null == sourceEditData2 || 1 != sourceEditData2.recordType) {
                        if (null != errorLogger) {
                            errorLogger.reportError("An original record needed for replication does not exist");
                        }
                        return null;
                    }
                    if (!sourceEditData2.isLocked) {
                        int n = sourceEditDataTV.channel;
                        sourceEditDataTV = (SourceEditDataTV)((SourceEditDataTV)sourceEditData2).deriveSource(false, errorLogger);
                        if (null == sourceEditDataTV) {
                            return null;
                        }
                        arrayList.add(sourceEditDataTV);
                        sourceEditDataTV = sourceEditDataTV.replicate(n, errorLogger);
                        if (null == sourceEditDataTV) {
                            return null;
                        }
                        arrayList.add(sourceEditDataTV);
                        sourceEditData = sourceEditDataTV;
                    }
                }
            }
            arrayList2.add(new Scenario.SourceListItem(sourceEditData.key, object.isDesired, object.isUndesired, false));
        }
        for (SourceEditData sourceEditData : arrayList) {
            this.study.addOrReplaceSource(sourceEditData);
        }
        return new SourceListData(this.study, 1, arrayList2);
    }

    public boolean addOrReplace(SourceEditData sourceEditData, boolean bl, boolean bl2) {
        return this.addOrReplace(new SourceItem(sourceEditData, bl, bl2, false));
    }

    public boolean addOrReplace(SourceEditData sourceEditData, boolean bl, boolean bl2, boolean bl3) {
        return this.addOrReplace(new SourceItem(sourceEditData, bl, bl2, bl3));
    }

    private boolean addOrReplace(SourceItem sourceItem) {
        this.lastRow = this.modelRows.indexOf(sourceItem);
        if (this.lastRow >= 0) {
            SourceItem sourceItem2 = this.modelRows.get(this.lastRow);
            sourceItem2.source = sourceItem.source;
            if (!sourceItem2.isPermanent) {
                sourceItem2.isDesired = sourceItem.isDesired;
                sourceItem2.isUndesired = sourceItem.isUndesired;
                sourceItem2.updateSourceListItem();
            }
            this.lastChange = 3;
        } else {
            this.lastRow = this.modelRows.size();
            this.modelRows.add(sourceItem);
            if (!this.deletedKeys.remove(sourceItem.key)) {
                this.addedKeys.add(sourceItem.key);
            }
            this.lastChange = 2;
        }
        this.study.addOrReplaceSource(sourceItem.source);
        return true;
    }

    public boolean remove(int n) {
        this.lastChange = 0;
        this.lastRow = -1;
        SourceItem sourceItem = this.modelRows.get(n);
        if (sourceItem.isPermanent) {
            return false;
        }
        this.modelRows.remove(n);
        if (!this.addedKeys.remove(sourceItem.key)) {
            this.deletedKeys.add(sourceItem.key);
        }
        if (3 != this.scenarioType) {
            this.study.removeSource(sourceItem.source);
        }
        this.lastChange = 4;
        this.lastRow = n;
        return true;
    }

    public boolean remove(int[] nArray) {
        int n;
        this.lastChange = 0;
        this.lastRow = -1;
        if (0 == nArray.length) {
            return false;
        }
        if (1 == nArray.length) {
            return this.remove(nArray[0]);
        }
        for (n = 0; n < nArray.length - 1; ++n) {
            int n2 = n;
            for (int i = n + 1; i < nArray.length; ++i) {
                if (nArray[i] <= nArray[n2]) continue;
                n2 = i;
            }
            if (n2 == n) continue;
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
        }
        boolean bl = false;
        for (n = 0; n < nArray.length; ++n) {
            SourceItem sourceItem = this.modelRows.get(nArray[n]);
            if (sourceItem.isPermanent) continue;
            this.modelRows.remove(nArray[n]);
            if (!this.addedKeys.remove(sourceItem.key)) {
                this.deletedKeys.add(sourceItem.key);
            }
            if (3 != this.scenarioType) {
                this.study.removeSource(sourceItem.source);
            }
            bl = true;
        }
        if (bl) {
            this.lastChange = 1;
            this.lastRow = 0;
        }
        return bl;
    }

    public boolean set(int n, SourceEditData sourceEditData) {
        SourceItem sourceItem = this.modelRows.get(n);
        if (sourceItem.key.equals(sourceEditData.key)) {
            sourceItem.source = sourceEditData;
            this.study.addOrReplaceSource(sourceEditData);
        } else {
            SourceEditData sourceEditData2 = sourceItem.source;
            sourceItem.key = sourceEditData.key;
            sourceItem.source = sourceEditData;
            sourceItem.updateSourceListItem();
            if (!this.addedKeys.remove(sourceEditData2.key)) {
                this.deletedKeys.add(sourceEditData2.key);
            }
            if (!this.deletedKeys.remove(sourceEditData.key)) {
                this.addedKeys.add(sourceEditData.key);
            }
            this.study.addOrReplaceSource(sourceEditData);
            if (3 != this.scenarioType) {
                this.study.removeSource(sourceEditData2);
            }
        }
        this.lastChange = 3;
        this.lastRow = n;
        return true;
    }

    public boolean setIsDesired(int n, boolean bl) {
        this.lastChange = 0;
        this.lastRow = -1;
        SourceItem sourceItem = this.modelRows.get(n);
        if (sourceItem.isPermanent || 2 == ((SourceItem)sourceItem).source.recordType) {
            return false;
        }
        if (bl == sourceItem.isDesired) {
            return false;
        }
        sourceItem.isDesired = bl;
        sourceItem.updateSourceListItem();
        this.lastChange = 3;
        this.lastRow = n;
        return true;
    }

    public boolean setIsUndesired(int n, boolean bl) {
        this.lastChange = 0;
        this.lastRow = -1;
        SourceItem sourceItem = this.modelRows.get(n);
        if (sourceItem.isPermanent) {
            return false;
        }
        if (bl == sourceItem.isUndesired) {
            return false;
        }
        sourceItem.isUndesired = bl;
        sourceItem.updateSourceListItem();
        this.lastChange = 3;
        this.lastRow = n;
        return true;
    }

    public int indexOfSourceKey(Integer n) {
        for (int i = 0; i < this.modelRows.size(); ++i) {
            if (!this.modelRows.get(i).key.equals(n)) continue;
            return i;
        }
        return -1;
    }

    public Scenario.SourceListItem get(int n) {
        return this.modelRows.get(n).sourceListItem;
    }

    public SourceEditData getSource(int n) {
        return this.modelRows.get(n).source;
    }

    public int getItemKeyForSourceKey(int n) {
        for (SourceItem sourceItem : this.modelRows) {
            if (n != sourceItem.key) continue;
            return sourceItem.itemKey;
        }
        return -1;
    }

    public int getSourceKeyForItemKey(int n) {
        for (SourceItem sourceItem : this.modelRows) {
            if (n != sourceItem.itemKey) continue;
            return sourceItem.key;
        }
        return -1;
    }

    public ArrayList<Scenario.SourceListItem> getRows() {
        ArrayList<Scenario.SourceListItem> arrayList = new ArrayList<Scenario.SourceListItem>(this.modelRows.size());
        for (SourceItem sourceItem : this.modelRows) {
            arrayList.add(sourceItem.sourceListItem);
        }
        return arrayList;
    }

    public ArrayList<SourceEditData> getSources() {
        return this.getSources(0);
    }

    public ArrayList<SourceEditData> getSources(int n) {
        ArrayList<SourceEditData> arrayList = new ArrayList<SourceEditData>();
        for (SourceItem sourceItem : this.modelRows) {
            if (0 != n && ((SourceItem)sourceItem).source.recordType != n) continue;
            arrayList.add(sourceItem.source);
        }
        return arrayList;
    }

    public SourceEditData getDesiredSource() {
        return this.getDesiredSource(0);
    }

    public SourceEditData getDesiredSource(int n) {
        SourceEditData sourceEditData = null;
        for (SourceItem sourceItem : this.modelRows) {
            if (!sourceItem.isDesired || 0 != n && ((SourceItem)sourceItem).source.recordType != n) continue;
            if (null != sourceEditData) {
                sourceEditData = null;
                break;
            }
            sourceEditData = sourceItem.source;
        }
        return sourceEditData;
    }

    public ArrayList<SourceEditData> getDesiredSources() {
        return this.getDesiredSources(0);
    }

    public ArrayList<SourceEditData> getDesiredSources(int n) {
        ArrayList<SourceEditData> arrayList = new ArrayList<SourceEditData>();
        for (SourceItem sourceItem : this.modelRows) {
            if (!sourceItem.isDesired || 0 != n && ((SourceItem)sourceItem).source.recordType != n) continue;
            arrayList.add(sourceItem.source);
        }
        return arrayList;
    }

    public boolean hasDesiredSources() {
        return this.hasDesiredSources(0);
    }

    public boolean hasDesiredSources(int n) {
        for (SourceItem sourceItem : this.modelRows) {
            if (!sourceItem.isDesired || 0 != n && ((SourceItem)sourceItem).source.recordType != n) continue;
            return true;
        }
        return false;
    }

    public int getDesiredSourceCount() {
        int n = 0;
        for (SourceItem sourceItem : this.modelRows) {
            if (!sourceItem.isDesired) continue;
            ++n;
        }
        return n;
    }

    public ArrayList<SourceEditData> getUndesiredSources() {
        return this.getUndesiredSources(0);
    }

    public ArrayList<SourceEditData> getUndesiredSources(int n) {
        ArrayList<SourceEditData> arrayList = new ArrayList<SourceEditData>();
        for (SourceItem sourceItem : this.modelRows) {
            if (!sourceItem.isUndesired || 0 != n && ((SourceItem)sourceItem).source.recordType != n) continue;
            arrayList.add(sourceItem.source);
        }
        return arrayList;
    }

    public boolean hasUndesiredSources() {
        return this.hasUndesiredSources(0);
    }

    public boolean hasUndesiredSources(int n) {
        for (SourceItem sourceItem : this.modelRows) {
            if (!sourceItem.isUndesired || 0 != n && ((SourceItem)sourceItem).source.recordType != n) continue;
            return true;
        }
        return false;
    }

    public int getUndesiredSourceCount() {
        int n = 0;
        for (SourceItem sourceItem : this.modelRows) {
            if (!sourceItem.isUndesired) continue;
            ++n;
        }
        return n;
    }

    public boolean isDataValid() {
        return this.isDataValid(null);
    }

    public boolean isDataValid(ErrorLogger errorLogger) {
        if (this.modelRows.isEmpty()) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("At least one station must be added to every scenario");
            }
            return false;
        }
        for (SourceItem sourceItem : this.modelRows) {
            if (!sourceItem.isDesired) continue;
            return true;
        }
        if (null != errorLogger) {
            errorLogger.reportValidationError("At least one desired station must be in every scenario");
        }
        return false;
    }

    public boolean isDataChanged() {
        if (!this.addedKeys.isEmpty()) {
            return true;
        }
        return !this.deletedKeys.isEmpty();
    }

    public boolean isScenarioChanged() {
        return this.isDataChanged();
    }

    public void didSave() {
        this.addedKeys.clear();
        this.deletedKeys.clear();
    }

    public int getRowCount() {
        return this.modelRows.size();
    }

    @Override
    public int getLastChange() {
        return this.lastChange;
    }

    @Override
    public int getLastRowChanged() {
        return this.lastRow;
    }

    public boolean writeSourcesToXML(Writer writer) throws IOException {
        return this.writeSourcesToXML(writer, null);
    }

    public boolean writeSourcesToXML(Writer writer, ErrorLogger errorLogger) throws IOException {
        for (SourceItem sourceItem : this.modelRows) {
            if (sourceItem.source.writeToXML(writer, sourceItem.isDesired, sourceItem.isUndesired, errorLogger)) continue;
            return false;
        }
        return true;
    }

    private class SourceItem {
        private int itemKey;
        private Integer key;
        private SourceEditData source;
        private boolean isDesired;
        private boolean isUndesired;
        private final boolean isPermanent;
        private Scenario.SourceListItem sourceListItem;

        private SourceItem(StudyEditData studyEditData, Scenario.SourceListItem sourceListItem) {
            this.itemKey = SourceListData.this.nextItemKey++;
            this.key = sourceListItem.key;
            this.source = studyEditData.getSource(this.key);
            this.isDesired = sourceListItem.isDesired;
            this.isUndesired = sourceListItem.isUndesired;
            this.isPermanent = sourceListItem.isPermanent;
            this.sourceListItem = sourceListItem;
        }

        private SourceItem(SourceEditData sourceEditData, boolean bl, boolean bl2) {
            this.itemKey = SourceListData.this.nextItemKey++;
            this.key = sourceEditData.key;
            this.source = sourceEditData;
            this.isDesired = bl;
            this.isUndesired = bl2;
            this.isPermanent = false;
            this.updateSourceListItem();
        }

        private SourceItem(SourceEditData sourceEditData, boolean bl, boolean bl2, boolean bl3) {
            this.itemKey = SourceListData.this.nextItemKey++;
            this.key = sourceEditData.key;
            this.source = sourceEditData;
            this.isDesired = bl;
            this.isUndesired = bl2;
            this.isPermanent = bl3;
            this.updateSourceListItem();
        }

        private void updateSourceListItem() {
            this.sourceListItem = new Scenario.SourceListItem(this.key, this.isDesired, this.isUndesired, this.isPermanent);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            return null != object && ((SourceItem)object).key.equals(this.key);
        }
    }
}

