/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.editdata;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordFM;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.Source;
import gov.fcc.tvstudy.core.data.SourceFM;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.editdata.IxRuleEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;
import java.util.TreeMap;
import org.xml.sax.Attributes;

public class SourceEditDataFM
extends SourceEditData
implements StationRecord {
    public final int facilityID;
    public final int stationClass;
    private SourceFM source;
    public boolean isIBOC;
    public int channel;
    public String status;
    public int statusType;
    public String appARN;
    public double ibocFraction;
    public int serviceAreaMode;
    public double serviceAreaArg;
    public double serviceAreaCL;
    public int serviceAreaKey;
    public static final double DEFAULT_RULE_EXTRA_DISTANCE = 125.0;

    public SourceEditDataFM(StudyEditData studyEditData, SourceFM sourceFM) {
        super(studyEditData, sourceFM.dbID, 3, sourceFM.key, sourceFM.service, sourceFM.country, sourceFM.isLocked, sourceFM.userRecordID, sourceFM.extDbKey, sourceFM.extRecordID);
        this.source = sourceFM;
        this.facilityID = this.source.facilityID;
        this.stationClass = this.source.stationClass;
        this.isIBOC = this.source.isIBOC;
        this.callSign = this.source.callSign;
        this.channel = this.source.channel;
        this.city = this.source.city;
        this.state = this.source.state;
        this.status = this.source.status;
        this.statusType = ExtDbRecord.getStatusType(this.source.status);
        this.fileNumber = this.source.fileNumber;
        this.appARN = ExtDbRecord.parseFileNumber(this.fileNumber)[1];
        this.location.setLatLon(this.source.location);
        this.heightAMSL = this.source.heightAMSL;
        this.overallHAAT = this.source.overallHAAT;
        this.peakERP = this.source.peakERP;
        this.ibocFraction = this.source.ibocFraction;
        this.antennaID = this.source.antennaID;
        this.hasHorizontalPattern = this.source.hasHorizontalPattern;
        this.horizontalPattern = null;
        this.horizontalPatternChanged = false;
        this.horizontalPatternOrientation = this.source.horizontalPatternOrientation;
        this.hasVerticalPattern = this.source.hasVerticalPattern;
        this.verticalPattern = null;
        this.verticalPatternChanged = false;
        this.verticalPatternElectricalTilt = this.source.verticalPatternElectricalTilt;
        this.verticalPatternMechanicalTilt = this.source.verticalPatternMechanicalTilt;
        this.verticalPatternMechanicalTiltOrientation = this.source.verticalPatternMechanicalTiltOrientation;
        this.hasMatrixPattern = this.source.hasMatrixPattern;
        this.matrixPattern = null;
        this.matrixPatternChanged = false;
        this.useGenericVerticalPattern = this.source.useGenericVerticalPattern;
        this.serviceAreaMode = this.source.serviceAreaMode;
        this.serviceAreaArg = this.source.serviceAreaArg;
        this.serviceAreaCL = this.source.serviceAreaCL;
        this.serviceAreaKey = this.source.serviceAreaKey;
        this.setAllAttributes(this.source.attributes);
    }

    private SourceEditDataFM(StudyEditData studyEditData, String string, Integer n, int n2, Service service, int n3, Country country, boolean bl, Integer n4, Integer n5, String string2) {
        super(studyEditData, string, 3, n, service, country, bl, n4, n5, string2);
        this.facilityID = n2;
        this.stationClass = n3;
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    @Override
    public SourceEditDataFM copy() {
        SourceEditDataFM sourceEditDataFM = new SourceEditDataFM(this.study, this.dbID, this.key, this.facilityID, this.service, this.stationClass, this.country, this.isLocked, this.userRecordID, this.extDbKey, this.extRecordID);
        sourceEditDataFM.source = this.source;
        sourceEditDataFM.isIBOC = this.isIBOC;
        sourceEditDataFM.callSign = this.callSign;
        sourceEditDataFM.channel = this.channel;
        sourceEditDataFM.city = this.city;
        sourceEditDataFM.state = this.state;
        sourceEditDataFM.status = this.status;
        sourceEditDataFM.statusType = this.statusType;
        sourceEditDataFM.fileNumber = this.fileNumber;
        sourceEditDataFM.appARN = this.appARN;
        sourceEditDataFM.location.setLatLon(this.location);
        sourceEditDataFM.heightAMSL = this.heightAMSL;
        sourceEditDataFM.overallHAAT = this.overallHAAT;
        sourceEditDataFM.peakERP = this.peakERP;
        sourceEditDataFM.ibocFraction = this.ibocFraction;
        sourceEditDataFM.antennaID = this.antennaID;
        sourceEditDataFM.hasHorizontalPattern = this.hasHorizontalPattern;
        sourceEditDataFM.horizontalPattern = this.horizontalPattern;
        sourceEditDataFM.horizontalPatternChanged = this.horizontalPatternChanged;
        sourceEditDataFM.horizontalPatternOrientation = this.horizontalPatternOrientation;
        sourceEditDataFM.hasVerticalPattern = this.hasVerticalPattern;
        sourceEditDataFM.verticalPattern = this.verticalPattern;
        sourceEditDataFM.verticalPatternChanged = this.verticalPatternChanged;
        sourceEditDataFM.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        sourceEditDataFM.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        sourceEditDataFM.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        sourceEditDataFM.hasMatrixPattern = this.hasMatrixPattern;
        sourceEditDataFM.matrixPattern = this.matrixPattern;
        sourceEditDataFM.matrixPatternChanged = this.matrixPatternChanged;
        sourceEditDataFM.useGenericVerticalPattern = this.useGenericVerticalPattern;
        sourceEditDataFM.serviceAreaMode = this.serviceAreaMode;
        sourceEditDataFM.serviceAreaArg = this.serviceAreaArg;
        sourceEditDataFM.serviceAreaCL = this.serviceAreaCL;
        sourceEditDataFM.serviceAreaKey = this.serviceAreaKey;
        sourceEditDataFM.setAllAttributes(this.attributes);
        return sourceEditDataFM;
    }

    public static SourceEditDataFM createSource(StudyEditData studyEditData, String string, int n, Service service, int n2, Country country, boolean bl, ErrorLogger errorLogger) {
        return SourceEditDataFM.createSource(studyEditData, string, n, service, n2, country, bl, null, null, null, errorLogger);
    }

    public static SourceEditDataFM createExtSource(ExtDb extDb, int n, Service service, int n2, Country country) {
        return SourceEditDataFM.createExtSource(extDb, n, service, n2, country, null);
    }

    public static SourceEditDataFM createExtSource(ExtDb extDb, int n, Service service, int n2, Country country, ErrorLogger errorLogger) {
        if (!SourceEditDataFM.isExtDbSupported(extDb)) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot create new record, invalid record/station data type");
            }
            return null;
        }
        Integer n3 = extDb.getNewRecordKey();
        if (null == n3) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot create new record, no keys available");
            }
            return null;
        }
        return SourceEditDataFM.createSource(null, extDb.dbID, n3, n, service, n2, country, true, null, extDb.key, String.valueOf(n3));
    }

    private static SourceEditDataFM createSource(StudyEditData studyEditData, String string, int n, Service service, int n2, Country country, boolean bl, Integer n3, Integer n4, String string2, ErrorLogger errorLogger) {
        Integer n5;
        if (null != studyEditData) {
            n5 = studyEditData.getNewSourceKey();
            string = studyEditData.dbID;
        } else {
            n5 = SourceEditDataFM.getTemporaryKey();
        }
        if (null == n5) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot create new record, no keys available");
            }
            return null;
        }
        return SourceEditDataFM.createSource(studyEditData, string, n5, n, service, n2, country, bl, n3, n4, string2);
    }

    private static SourceEditDataFM createSource(StudyEditData studyEditData, String string, Integer n, int n2, Service service, int n3, Country country, boolean bl, Integer n4, Integer n5, String string2) {
        if (null == string2) {
            n5 = null;
        }
        SourceEditDataFM sourceEditDataFM = new SourceEditDataFM(studyEditData, string, n, n2, service, n3, country, bl, n4, n5, string2);
        sourceEditDataFM.isIBOC = false;
        sourceEditDataFM.callSign = "";
        sourceEditDataFM.channel = 0;
        sourceEditDataFM.city = "";
        sourceEditDataFM.state = "";
        sourceEditDataFM.status = "";
        sourceEditDataFM.statusType = 4;
        sourceEditDataFM.fileNumber = "";
        sourceEditDataFM.appARN = "";
        sourceEditDataFM.heightAMSL = 0.0;
        sourceEditDataFM.overallHAAT = 0.0;
        sourceEditDataFM.peakERP = 0.001;
        sourceEditDataFM.ibocFraction = 0.01;
        sourceEditDataFM.antennaID = null;
        sourceEditDataFM.hasHorizontalPattern = false;
        sourceEditDataFM.horizontalPattern = null;
        sourceEditDataFM.horizontalPatternChanged = false;
        sourceEditDataFM.horizontalPatternOrientation = 0.0;
        sourceEditDataFM.hasVerticalPattern = false;
        sourceEditDataFM.verticalPattern = null;
        sourceEditDataFM.verticalPatternChanged = false;
        sourceEditDataFM.verticalPatternElectricalTilt = 0.0;
        sourceEditDataFM.verticalPatternMechanicalTilt = 0.0;
        sourceEditDataFM.verticalPatternMechanicalTiltOrientation = 0.0;
        sourceEditDataFM.hasMatrixPattern = false;
        sourceEditDataFM.matrixPattern = null;
        sourceEditDataFM.matrixPatternChanged = false;
        sourceEditDataFM.useGenericVerticalPattern = true;
        sourceEditDataFM.serviceAreaMode = 0;
        sourceEditDataFM.serviceAreaCL = -999.0;
        return sourceEditDataFM;
    }

    public static SourceEditDataFM makeSourceFM(ExtDbRecordFM extDbRecordFM, StudyEditData studyEditData, boolean bl) {
        return SourceEditDataFM.makeSourceFM(extDbRecordFM, studyEditData, bl, null);
    }

    public static SourceEditDataFM makeSourceFM(ExtDbRecordFM extDbRecordFM, StudyEditData studyEditData, boolean bl, ErrorLogger errorLogger) {
        SourceEditDataFM sourceEditDataFM = SourceEditDataFM.createSource(studyEditData, extDbRecordFM.extDb.dbID, extDbRecordFM.facilityID, extDbRecordFM.service, extDbRecordFM.stationClass, extDbRecordFM.country, bl, null, extDbRecordFM.extDb.key, extDbRecordFM.extRecordID, errorLogger);
        if (null == sourceEditDataFM) {
            return null;
        }
        if (!extDbRecordFM.updateSource(sourceEditDataFM, errorLogger)) {
            return null;
        }
        return sourceEditDataFM;
    }

    public static SourceEditDataFM makeExtSourceFM(ExtDbRecordFM extDbRecordFM, ExtDb extDb) {
        return SourceEditDataFM.makeExtSourceFM(extDbRecordFM, extDb, null);
    }

    public static SourceEditDataFM makeExtSourceFM(ExtDbRecordFM extDbRecordFM, ExtDb extDb, ErrorLogger errorLogger) {
        SourceEditDataFM sourceEditDataFM = SourceEditDataFM.createExtSource(extDb, extDbRecordFM.facilityID, extDbRecordFM.service, extDbRecordFM.stationClass, extDbRecordFM.country, errorLogger);
        if (null == sourceEditDataFM) {
            return null;
        }
        if (!extDbRecordFM.updateSource(sourceEditDataFM, errorLogger)) {
            return null;
        }
        return sourceEditDataFM;
    }

    @Override
    public SourceEditData deriveSource(StudyEditData studyEditData, boolean bl, ErrorLogger errorLogger) {
        return this.deriveSourceFM(studyEditData, this.facilityID, this.service, this.stationClass, this.country, bl, false, errorLogger);
    }

    public SourceEditDataFM deriveSourceFM(int n, Service service, int n2, Country country, boolean bl) {
        return this.deriveSourceFM(this.study, n, service, n2, country, bl, true, null);
    }

    public SourceEditDataFM deriveSourceFM(int n, Service service, int n2, Country country, boolean bl, ErrorLogger errorLogger) {
        return this.deriveSourceFM(this.study, n, service, n2, country, bl, true, errorLogger);
    }

    private SourceEditDataFM deriveSourceFM(StudyEditData studyEditData, int n, Service service, int n2, Country country, boolean bl, boolean bl2, ErrorLogger errorLogger) {
        String string = this.dbID;
        Integer n3 = this.userRecordID;
        Integer n4 = this.extDbKey;
        String string2 = this.extRecordID;
        if (null != studyEditData && !studyEditData.dbID.equals(this.dbID)) {
            string = studyEditData.dbID;
            bl2 = true;
        }
        if (bl2) {
            n3 = null;
            n4 = null;
            string2 = null;
        }
        if (!this.isLocked && bl) {
            if (null != errorLogger) {
                errorLogger.reportError("Unlocked records cannot be locked again");
            }
            return null;
        }
        return this.deriveSourceFM(studyEditData, string, n, service, n2, country, bl, n3, n4, string2, errorLogger);
    }

    private SourceEditDataFM deriveSourceFM(StudyEditData studyEditData, String string, int n, Service service, int n2, Country country, boolean bl, Integer n3, Integer n4, String string2, ErrorLogger errorLogger) {
        SourceEditDataFM sourceEditDataFM = SourceEditDataFM.createSource(studyEditData, string, n, service, n2, country, bl, n3, n4, string2, errorLogger);
        if (null == sourceEditDataFM) {
            return null;
        }
        sourceEditDataFM.isIBOC = this.isIBOC;
        sourceEditDataFM.callSign = this.callSign;
        sourceEditDataFM.channel = this.channel;
        sourceEditDataFM.city = this.city;
        sourceEditDataFM.state = this.state;
        sourceEditDataFM.status = this.status;
        sourceEditDataFM.statusType = this.statusType;
        sourceEditDataFM.fileNumber = this.fileNumber;
        sourceEditDataFM.appARN = this.appARN;
        sourceEditDataFM.location.setLatLon(this.location);
        sourceEditDataFM.heightAMSL = this.heightAMSL;
        sourceEditDataFM.overallHAAT = this.overallHAAT;
        sourceEditDataFM.peakERP = this.peakERP;
        sourceEditDataFM.ibocFraction = this.ibocFraction;
        sourceEditDataFM.antennaID = this.antennaID;
        sourceEditDataFM.hasHorizontalPattern = false;
        sourceEditDataFM.horizontalPattern = null;
        sourceEditDataFM.horizontalPatternChanged = false;
        sourceEditDataFM.horizontalPatternOrientation = this.horizontalPatternOrientation;
        sourceEditDataFM.hasVerticalPattern = false;
        sourceEditDataFM.verticalPattern = null;
        sourceEditDataFM.verticalPatternChanged = false;
        sourceEditDataFM.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        sourceEditDataFM.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        sourceEditDataFM.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        sourceEditDataFM.hasMatrixPattern = false;
        sourceEditDataFM.matrixPattern = null;
        sourceEditDataFM.matrixPatternChanged = false;
        sourceEditDataFM.useGenericVerticalPattern = this.useGenericVerticalPattern;
        sourceEditDataFM.serviceAreaMode = this.serviceAreaMode;
        sourceEditDataFM.serviceAreaArg = this.serviceAreaArg;
        sourceEditDataFM.serviceAreaCL = this.serviceAreaCL;
        sourceEditDataFM.serviceAreaKey = this.serviceAreaKey;
        sourceEditDataFM.setAllAttributes(this.attributes);
        if (!sourceEditDataFM.isLocked) {
            sourceEditDataFM.removeAttribute("-isPending");
            sourceEditDataFM.removeAttribute("-isArchived");
        }
        if (this.hasHorizontalPattern) {
            if (null == this.horizontalPattern && null != this.source) {
                this.horizontalPattern = this.source.getHorizontalPattern(errorLogger);
            }
            if (null != this.horizontalPattern) {
                sourceEditDataFM.hasHorizontalPattern = true;
                sourceEditDataFM.horizontalPattern = this.horizontalPattern.copy();
                sourceEditDataFM.horizontalPatternChanged = true;
            }
        }
        if (this.hasVerticalPattern) {
            if (null == this.verticalPattern && null != this.source) {
                this.verticalPattern = this.source.getVerticalPattern(errorLogger);
            }
            if (null != this.verticalPattern) {
                sourceEditDataFM.hasVerticalPattern = true;
                sourceEditDataFM.verticalPattern = this.verticalPattern.copy();
                sourceEditDataFM.verticalPatternChanged = true;
            }
        }
        if (this.hasMatrixPattern) {
            if (null == this.matrixPattern && null != this.source) {
                this.matrixPattern = this.source.getMatrixPattern(errorLogger);
            }
            if (null != this.matrixPattern) {
                sourceEditDataFM.hasMatrixPattern = true;
                sourceEditDataFM.matrixPattern = this.matrixPattern.copy();
                sourceEditDataFM.matrixPatternChanged = true;
            }
        }
        return sourceEditDataFM;
    }

    @Override
    public boolean isGeographyInUse(int n) {
        return (5 == this.serviceAreaMode || 6 == this.serviceAreaMode) && n == this.serviceAreaKey;
    }

    @Override
    public int getGeographyKey() {
        if (5 == this.serviceAreaMode || 6 == this.serviceAreaMode) {
            return this.serviceAreaKey;
        }
        return 0;
    }

    @Override
    public boolean isDataValid(ErrorLogger errorLogger) {
        if (this.isLocked && null != this.source) {
            return true;
        }
        if (this.channel < 200 || this.channel > 300) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad channel, must be 200 to 300");
            }
            return false;
        }
        if (0 == this.city.length()) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A city name must be provided");
            }
            return false;
        }
        if (0 == this.state.length()) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A state code must be provided");
            }
            return false;
        }
        if (this.isIBOC && (this.ibocFraction < 0.01 || this.ibocFraction > 0.1)) {
            if (null != errorLogger) {
                double d = 1.0;
                double d2 = 10.0;
                errorLogger.reportValidationError(String.format("The IBOC ERP must be between %.1f%% and %.1f%% of the peak ERP", d, d2));
            }
            return false;
        }
        if ((2 == this.serviceAreaMode || 3 == this.serviceAreaMode || 4 == this.serviceAreaMode) && (this.serviceAreaArg < 0.0 || this.serviceAreaArg > 500.0)) {
            errorLogger.reportValidationError("Bad contour mode argument, must be 0.0 to 500.0");
            return false;
        }
        if ((0 == this.serviceAreaMode || 1 == this.serviceAreaMode || 2 == this.serviceAreaMode || 3 == this.serviceAreaMode || 4 == this.serviceAreaMode || 11 == this.serviceAreaMode) && this.serviceAreaCL != -999.0 && (this.serviceAreaCL < 0.0 || this.serviceAreaCL > 120.0)) {
            errorLogger.reportValidationError("Bad contour level, must be 0.0 to 120.0");
            return false;
        }
        if ((5 == this.serviceAreaMode || 6 == this.serviceAreaMode) && this.serviceAreaKey <= 0) {
            errorLogger.reportValidationError("Bad or missing service area geography");
            return false;
        }
        return super.isDataValid(errorLogger);
    }

    @Override
    public boolean isDataChanged() {
        if (null == this.source) {
            return true;
        }
        if (super.isDataChanged()) {
            return true;
        }
        if (this.isLocked) {
            return false;
        }
        if (this.facilityID != this.source.facilityID) {
            return true;
        }
        if (this.stationClass != this.source.stationClass) {
            return true;
        }
        if (this.isIBOC != this.source.isIBOC) {
            return true;
        }
        if (this.channel != this.source.channel) {
            return true;
        }
        if (!this.status.equals(this.source.status)) {
            return true;
        }
        if (this.ibocFraction != this.source.ibocFraction) {
            return true;
        }
        if (this.serviceAreaMode != this.source.serviceAreaMode) {
            return true;
        }
        if (this.serviceAreaArg != this.source.serviceAreaArg) {
            return true;
        }
        if (this.serviceAreaCL != this.source.serviceAreaCL) {
            return true;
        }
        return (5 == this.serviceAreaMode || 6 == this.serviceAreaMode) && this.serviceAreaKey != this.source.serviceAreaKey;
    }

    @Override
    public void save(DbConnection dbConnection) throws SQLException {
        dbConnection.update("DELETE FROM source WHERE source_key=" + this.key);
        int n = 0;
        if (null != this.source) {
            n = this.source.modCount + 1;
        }
        String string = "";
        if (this.hasHorizontalPattern) {
            if (null != this.horizontalPattern) {
                string = this.horizontalPattern.name;
            } else if (null != this.source) {
                string = this.source.horizontalPatternName;
            }
        }
        String string2 = "";
        if (this.hasVerticalPattern) {
            if (null != this.verticalPattern) {
                string2 = this.verticalPattern.name;
            } else if (null != this.source) {
                string2 = this.source.verticalPatternName;
            }
        }
        String string3 = "";
        if (this.hasMatrixPattern) {
            if (null != this.matrixPattern) {
                string3 = this.matrixPattern.name;
            } else if (null != this.source) {
                string3 = this.source.matrixPatternName;
            }
        }
        int n2 = 0;
        if (5 == this.serviceAreaMode || 6 == this.serviceAreaMode) {
            n2 = this.serviceAreaKey;
        }
        String string4 = this.getAllAttributes();
        dbConnection.update("INSERT INTO source (source_key,record_type,needs_update,mod_count,facility_id,service_key,is_drt,is_iboc,station_class,call_sign,sector_id,channel,city,state,country_key,zone_key,status,file_number,signal_type_key,frequency_offset_key,emission_mask_key,latitude,longitude,dts_maximum_distance,dts_sectors,height_amsl,actual_height_amsl,height_agl,overall_haat,actual_overall_haat,peak_erp,contour_erp,iboc_fraction,antenna_id,has_horizontal_pattern,horizontal_pattern_name,horizontal_pattern_orientation,has_vertical_pattern,vertical_pattern_name,vertical_pattern_electrical_tilt,vertical_pattern_mechanical_tilt,vertical_pattern_mechanical_tilt_orientation,has_matrix_pattern,matrix_pattern_name,use_generic_vertical_pattern,site_number,locked,user_record_id,ext_db_key,ext_record_id,original_source_key,parent_source_key,service_area_mode,service_area_arg,service_area_cl,service_area_key,dts_time_delay,attributes) VALUES (" + this.key + "," + this.recordType + ",true," + n + "," + this.facilityID + "," + this.service.key + ",false," + this.isIBOC + "," + this.stationClass + ",'" + DbConnection.clean(this.callSign) + "',''," + this.channel + ",'" + DbConnection.clean(this.city) + "','" + DbConnection.clean(this.state) + "'," + this.country.key + ",0,'" + DbConnection.clean(this.status) + "','" + DbConnection.clean(this.fileNumber) + "',0,0,0," + this.location.latitude + "," + this.location.longitude + ",0,''," + this.heightAMSL + "," + this.heightAMSL + ",0," + this.overallHAAT + "," + this.overallHAAT + "," + this.peakERP + "," + 10.0 * Math.log10(this.peakERP) + "," + this.ibocFraction + "," + (null == this.antennaID ? "null" : "'" + DbConnection.clean(this.antennaID) + "'") + "," + this.hasHorizontalPattern + ",'" + DbConnection.clean(string) + "'," + this.horizontalPatternOrientation + "," + this.hasVerticalPattern + ",'" + DbConnection.clean(string2) + "'," + this.verticalPatternElectricalTilt + "," + this.verticalPatternMechanicalTilt + "," + this.verticalPatternMechanicalTiltOrientation + "," + this.hasMatrixPattern + ",'" + DbConnection.clean(string3) + "'," + this.useGenericVerticalPattern + ",0," + this.isLocked + "," + (null == this.userRecordID ? "0" : this.userRecordID) + "," + (null == this.extDbKey ? "0" : this.extDbKey) + "," + (null == this.extRecordID ? "null" : "'" + DbConnection.clean(this.extRecordID) + "'") + ",0,0," + this.serviceAreaMode + "," + this.serviceAreaArg + "," + this.serviceAreaCL + "," + n2 + ",0,'" + DbConnection.clean(string4) + "')");
        this.savePatterns(dbConnection);
        this.source = new SourceFM(this.dbID, dbConnection.getDatabase(), this.key, this.facilityID, this.service, this.isIBOC, this.stationClass, this.callSign, this.channel, this.city, this.state, this.country, this.status, this.fileNumber, this.location.latitude, this.location.longitude, this.heightAMSL, this.heightAMSL, this.overallHAAT, this.overallHAAT, this.peakERP, this.ibocFraction, this.antennaID, this.hasHorizontalPattern, string, this.horizontalPatternOrientation, this.hasVerticalPattern, string2, this.verticalPatternElectricalTilt, this.verticalPatternMechanicalTilt, this.verticalPatternMechanicalTiltOrientation, this.hasMatrixPattern, string3, this.useGenericVerticalPattern, this.isLocked, this.userRecordID, this.extDbKey, this.extRecordID, n, this.serviceAreaMode, this.serviceAreaArg, this.serviceAreaCL, n2, string4);
        this.horizontalPatternChanged = false;
        this.verticalPatternChanged = false;
        this.matrixPatternChanged = false;
        this.attributesChanged = false;
    }

    public static boolean isExtDbSupported(ExtDb extDb) {
        return SourceEditData.isExtDbSupported(extDb) && extDb.canProvide(3);
    }

    public static int addRecords(ExtDb extDb, ScenarioEditData scenarioEditData, int n, String string, GeoPoint geoPoint, double d, int n2, int n3, boolean bl, boolean bl2, boolean bl3, ErrorLogger errorLogger) {
        Object object;
        int n4;
        int n5;
        Object object2;
        Cloneable cloneable;
        int n6 = scenarioEditData.study.study.studyType;
        if (!SourceEditDataFM.isExtDbSupported(extDb) || !Study.isRecordTypeAllowed(n6, 3) || (1 == n || 3 == n) && 4 != n6 && 5 != n6) {
            return 0;
        }
        double d2 = scenarioEditData.study.getCoChannelMxDistance();
        double d3 = scenarioEditData.study.getKilometersPerDegree();
        int n7 = 200;
        int n8 = 300;
        if ((1 == n || 3 == n) && 5 == n6) {
            n8 = 220;
        }
        if (n2 > n7) {
            n7 = n2;
        }
        if (n3 > 0 && n3 < n8) {
            n8 = n3;
        }
        if (n7 > n8) {
            return 0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl4 = false;
        if (null != string && string.length() > 0) {
            stringBuilder.append(string);
            bl4 = true;
        }
        ArrayList<SourceEditData> arrayList = null;
        Collection collection = null;
        if (1 == n) {
            try {
                SourceEditDataFM.addChannelRangeQuery(extDb.type, n7, n8, stringBuilder, bl4);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            if (3 == n) {
                arrayList = scenarioEditData.sourceData.getUndesiredSources(3);
                if (arrayList.isEmpty()) {
                    if (null != errorLogger) {
                        errorLogger.reportError("There are no undesired FM stations in the scenario");
                    }
                    return -1;
                }
            } else {
                arrayList = scenarioEditData.sourceData.getDesiredSources(3);
                if (arrayList.isEmpty()) {
                    if (null != errorLogger) {
                        errorLogger.reportError("There are no desired FM stations in the scenario");
                    }
                    return -1;
                }
            }
            cloneable = new HashMap();
            for (IxRuleEditData ixRuleEditData : scenarioEditData.study.ixRuleData.getActiveRows()) {
                if (3 != ixRuleEditData.serviceType.recordType) continue;
                object2 = (SearchDelta)((HashMap)cloneable).get(ixRuleEditData.channelDelta.delta);
                if (null == object2) {
                    object2 = new SearchDelta();
                    ((SearchDelta)object2).delta = ixRuleEditData.channelDelta.delta;
                    ((SearchDelta)object2).maximumDistance = ixRuleEditData.distance;
                    ((HashMap)cloneable).put(((SearchDelta)object2).delta, object2);
                    continue;
                }
                if (!(ixRuleEditData.distance > ((SearchDelta)object2).maximumDistance)) continue;
                ((SearchDelta)object2).maximumDistance = ixRuleEditData.distance;
            }
            collection = ((HashMap)cloneable).values();
            int n9 = 0;
            n5 = n8 - n7 + 1;
            boolean[] blArray = new boolean[n5];
            for (SourceEditData sourceEditData : arrayList) {
                SourceEditDataFM sourceEditDataFM = (SourceEditDataFM)sourceEditData;
                for (SearchDelta searchDelta : collection) {
                    int n10;
                    int n11;
                    if (3 != n ? (n11 = (n10 = sourceEditDataFM.channel) + searchDelta.delta) < n7 || n11 > n8 || blArray[n4 = n11 - n7] : (n10 = (n11 = sourceEditDataFM.channel) - searchDelta.delta) < n7 || n10 > n8 || blArray[n4 = n10 - n7]) continue;
                    if (blArray[n4]) continue;
                    blArray[n4] = true;
                    if (++n9 != n5) continue;
                    break;
                }
                if (n9 != n5) continue;
                break;
            }
            if (0 == n9) {
                return 0;
            }
            if (n9 < n5) {
                StringBuilder stringBuilder2 = new StringBuilder();
                int n12 = 40;
                for (n4 = 0; n4 < n5; ++n4) {
                    if (!blArray[n4]) continue;
                    stringBuilder2.append((char)n12);
                    stringBuilder2.append(String.valueOf(n4 + n7));
                    n12 = 44;
                }
                stringBuilder2.append(')');
                try {
                    SourceEditDataFM.addMultipleChannelQuery(extDb.type, stringBuilder2.toString(), stringBuilder, bl4);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                try {
                    SourceEditDataFM.addChannelRangeQuery(extDb.type, n7, n8, stringBuilder, bl4);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        cloneable = SourceEditDataFM.findImportRecords(extDb, 3, stringBuilder.toString(), geoPoint, d, d3, errorLogger);
        if (null == cloneable) {
            return -1;
        }
        if (((AbstractCollection)((Object)cloneable)).isEmpty()) {
            return 0;
        }
        SourceEditDataFM.removeAllMX(scenarioEditData, (LinkedList<SourceEditData>)cloneable, bl, bl2, d2, d3);
        if (1 != n) {
            object2 = ((LinkedList)cloneable).listIterator(0);
            while (object2.hasNext()) {
                object = (SourceEditDataFM)object2.next();
                n5 = 1;
                for (SourceEditData sourceEditData : arrayList) {
                    Object object3;
                    Object object4;
                    if (3 == n) {
                        object4 = object;
                        object3 = (SourceEditDataFM)sourceEditData;
                    } else {
                        object4 = (SourceEditDataFM)sourceEditData;
                        object3 = object;
                    }
                    n4 = ((SourceEditDataFM)object3).channel - ((SourceEditDataFM)object4).channel;
                    for (SearchDelta searchDelta : collection) {
                        if (searchDelta.delta != n4) continue;
                        double d4 = searchDelta.maximumDistance + SourceEditDataFM.getRuleExtraDistance(scenarioEditData.study, ((SourceEditDataFM)object4).service, ((SourceEditDataFM)object4).stationClass, ((SourceEditDataFM)object4).country, ((SourceEditDataFM)object4).channel, ((SourceEditDataFM)object4).peakERP);
                        if (!(((SourceEditDataFM)object4).location.distanceTo(((SourceEditDataFM)object3).location, d3) <= d4)) continue;
                        n5 = 0;
                        break;
                    }
                    if (n5 != 0) continue;
                    break;
                }
                if (n5 == 0) continue;
                object2.remove();
            }
        }
        object = new ArrayList();
        Iterator iterator = ((AbstractSequentialList)((Object)cloneable)).iterator();
        while (iterator.hasNext()) {
            SourceEditData sourceEditData = (SourceEditData)iterator.next();
            object2 = scenarioEditData.study.findSharedSource(sourceEditData.extDbKey, sourceEditData.extRecordID);
            if (null == object2 && null == (object2 = sourceEditData.deriveSource(scenarioEditData.study, true, errorLogger))) {
                return -1;
            }
            ((ArrayList)object).add(object2);
        }
        boolean bl5 = true;
        boolean bl6 = true;
        if (1 == n || 3 == n) {
            bl6 = bl ? false : bl3;
        } else {
            bl5 = false;
            if (bl) {
                bl6 = false;
            }
        }
        Iterator iterator2 = ((ArrayList)object).iterator();
        while (iterator2.hasNext()) {
            SourceEditData sourceEditData = (SourceEditData)iterator2.next();
            scenarioEditData.sourceData.addOrReplace(sourceEditData, bl5, bl6);
        }
        return ((ArrayList)object).size();
    }

    private static void removeAllMX(ScenarioEditData scenarioEditData, LinkedList<SourceEditData> linkedList, boolean bl, boolean bl2, double d, double d2) {
        SourceEditDataFM sourceEditDataFM;
        ArrayList<SourceEditData> arrayList = scenarioEditData.sourceData.getSources(3);
        ListIterator<SourceEditData> listIterator = linkedList.listIterator(0);
        block0: while (listIterator.hasNext()) {
            sourceEditDataFM = (SourceEditDataFM)listIterator.next();
            for (SourceEditData sourceEditData : arrayList) {
                SourceEditDataFM sourceEditDataFM2 = (SourceEditDataFM)sourceEditData;
                if ((!sourceEditDataFM.extDbKey.equals(sourceEditDataFM2.extDbKey) || !sourceEditDataFM.extRecordID.equals(sourceEditDataFM2.extRecordID)) && (bl || !ExtDbRecordFM.areRecordsMX(sourceEditDataFM, sourceEditDataFM2, bl2, d, d2))) continue;
                listIterator.remove();
                continue block0;
            }
        }
        if (bl) {
            return;
        }
        Comparator<SourceEditData> comparator = new Comparator<SourceEditData>(){

            @Override
            public int compare(SourceEditData sourceEditData, SourceEditData sourceEditData2) {
                if (((SourceEditDataFM)sourceEditData).isPreferredRecord((SourceEditDataFM)sourceEditData2)) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(linkedList, comparator);
        int n = linkedList.size() - 1;
        for (int i = 0; i < n; ++i) {
            sourceEditDataFM = (SourceEditDataFM)linkedList.get(i);
            listIterator = linkedList.listIterator(i + 1);
            while (listIterator.hasNext()) {
                if (!ExtDbRecordFM.areRecordsMX(sourceEditDataFM, (SourceEditDataFM)listIterator.next(), bl2, d, d2)) continue;
                listIterator.remove();
                --n;
            }
        }
    }

    private boolean isPreferredRecord(SourceEditDataFM sourceEditDataFM) {
        if (this.service.preferenceRank > sourceEditDataFM.service.preferenceRank) {
            return true;
        }
        if (this.service.preferenceRank < sourceEditDataFM.service.preferenceRank) {
            return false;
        }
        if (this.statusType < sourceEditDataFM.statusType) {
            return true;
        }
        if (this.statusType > sourceEditDataFM.statusType) {
            return false;
        }
        return this.extRecordID.compareTo(sourceEditDataFM.extRecordID) > 0;
    }

    public double getRuleExtraDistance() {
        return SourceEditDataFM.getRuleExtraDistance(this.study, this.service, this.stationClass, this.country, this.channel, this.peakERP);
    }

    public static double getRuleExtraDistance(StudyEditData studyEditData, Service service, int n, Country country, int n2, double d) {
        double d2;
        if (null == studyEditData) {
            return 125.0;
        }
        if (studyEditData.getUseMaxRuleExtraDistance()) {
            return studyEditData.getMaximumDistance();
        }
        if (d <= 0.0) {
            return 125.0;
        }
        int n3 = country.key - 1;
        int n4 = studyEditData.getCurveSetFM(n3);
        if (2 == n4) {
            return 300.0;
        }
        block0 : switch (service.serviceType.key) {
            default: {
                if (n2 > 220) {
                    switch (n) {
                        default: {
                            d2 = studyEditData.getContourFM(n3);
                            break block0;
                        }
                        case 6: {
                            d2 = studyEditData.getContourFMB(n3);
                            break block0;
                        }
                        case 7: 
                    }
                    d2 = studyEditData.getContourFMB1(n3);
                    break;
                }
                d2 = studyEditData.getContourFMED(n3);
                break;
            }
            case 22: {
                d2 = studyEditData.getContourFMLP(n3);
                break;
            }
            case 23: {
                d2 = studyEditData.getContourFMTX(n3);
            }
        }
        double d3 = 10.0 * Math.log10(d) + (studyEditData.getContourUhfDigital(0) - d2);
        int n5 = studyEditData.getCurveSetDigital(0);
        if (3 == n5) {
            if (1 == n4) {
                d3 += 8.0;
            }
        } else if (1 == n5 && 3 == n4) {
            d3 -= 8.0;
        }
        if (d3 < studyEditData.getRuleExtraDistanceERPLow()) {
            return studyEditData.getRuleExtraDistanceLow();
        }
        if (d3 < studyEditData.getRuleExtraDistanceERPMedium()) {
            return studyEditData.getRuleExtraDistanceLowMedium();
        }
        if (d3 < studyEditData.getRuleExtraDistanceERPHigh()) {
            return studyEditData.getRuleExtraDistanceMediumHigh();
        }
        return studyEditData.getRuleExtraDistanceHigh();
    }

    @Override
    protected boolean writeToXML(Writer writer, boolean bl, boolean bl2, boolean bl3, ErrorLogger errorLogger) throws IOException {
        ExtDb extDb;
        if (!this.isDataValid(errorLogger)) {
            return false;
        }
        String string = this.extRecordID;
        if (null != string && (null == (extDb = ExtDb.getExtDb(this.dbID, this.extDbKey, true)) || extDb.isGeneric())) {
            string = null;
        }
        writer.append("<SOURCE");
        if (bl) {
            writer.append(" LOCKED=\"false\"");
        } else {
            writer.append(" DESIRED=\"" + bl2 + "\"");
            writer.append(" UNDESIRED=\"" + bl3 + '\"');
            writer.append(" LOCKED=\"" + this.isLocked + '\"');
        }
        writer.append(" SERVICE=\"" + this.service.serviceCode + '\"');
        if (null != string && !bl) {
            writer.append(" RECORD_ID=\"" + string + '\"');
            if (this.isLocked) {
                writer.append("/>\n");
                return true;
            }
        }
        writer.append(" ID=\"" + this.facilityID + '\"');
        writer.append(" CLASS=\"" + AppCore.xmlclean(ExtDbRecordFM.FM_CLASS_CODES[this.stationClass]) + '\"');
        writer.append(" CALL_SIGN=\"" + AppCore.xmlclean(this.callSign) + '\"');
        writer.append(" CITY=\"" + AppCore.xmlclean(this.city) + '\"');
        writer.append(" STATE=\"" + AppCore.xmlclean(this.state) + '\"');
        writer.append(" COUNTRY=\"" + this.country.countryCode + '\"');
        writer.append(" CHANNEL=\"" + this.channel + '\"');
        writer.append(" STATUS=\"" + this.status + '\"');
        writer.append(" FILE_NUMBER=\"" + AppCore.xmlclean(this.fileNumber) + '\"');
        writer.append(" IBOC=\"" + this.isIBOC + '\"');
        if (this.isIBOC) {
            writer.append(" IBOC_ERP=\"" + AppCore.formatERP(this.peakERP * this.ibocFraction) + '\"');
        }
        this.writeAttributes(writer, errorLogger);
        writer.append("</SOURCE>\n");
        return true;
    }

    protected static SourceEditDataFM makeSourceWithAttributesFM(String string, Attributes attributes, StudyEditData studyEditData, String string2, Service service, Country country, boolean bl, Integer n, Integer n2, String string3, ErrorLogger errorLogger) {
        SourceEditDataFM sourceEditDataFM;
        int n3 = 0;
        String string4 = attributes.getValue("ID");
        if (null != string4) {
            try {
                n3 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad ID attribute in " + string + " tag");
                }
                return null;
            }
        } else {
            if (null != errorLogger) {
                errorLogger.reportError("Missing ID attribute in " + string + " tag");
            }
            return null;
        }
        int n4 = 0;
        string4 = attributes.getValue("CLASS");
        if (null != string4 && string4.length() > 0) {
            for (int i = 1; i < ExtDbRecordFM.FM_CLASS_CODES.length; ++i) {
                if (!string4.equalsIgnoreCase(ExtDbRecordFM.FM_CLASS_CODES[i])) continue;
                n4 = i;
                break;
            }
        }
        if (null == (sourceEditDataFM = SourceEditDataFM.createSource(studyEditData, string2, n3, service, n4, country, bl, n, n2, string3, errorLogger))) {
            return null;
        }
        if (!sourceEditDataFM.parseAttributesFM(string, attributes, errorLogger)) {
            return null;
        }
        return sourceEditDataFM;
    }

    protected static SourceEditDataFM makeExtSourceWithAttributesFM(String string, Attributes attributes, ExtDb extDb, Service service, Country country, ErrorLogger errorLogger) {
        SourceEditDataFM sourceEditDataFM;
        int n = 0;
        String string2 = attributes.getValue("ID");
        if (null != string2) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad ID attribute in " + string + " tag");
                }
                return null;
            }
        } else {
            if (null != errorLogger) {
                errorLogger.reportError("Missing ID attribute in " + string + " tag");
            }
            return null;
        }
        int n2 = 0;
        string2 = attributes.getValue("CLASS");
        if (null != string2 && string2.length() > 0) {
            for (int i = 1; i < ExtDbRecordFM.FM_CLASS_CODES.length; ++i) {
                if (!string2.equalsIgnoreCase(ExtDbRecordFM.FM_CLASS_CODES[i])) continue;
                n2 = i;
                break;
            }
        }
        if (null == (sourceEditDataFM = SourceEditDataFM.createExtSource(extDb, n, service, n2, country, errorLogger))) {
            return null;
        }
        if (!sourceEditDataFM.parseAttributesFM(string, attributes, errorLogger)) {
            return null;
        }
        return sourceEditDataFM;
    }

    private boolean parseAttributesFM(String string, Attributes attributes, ErrorLogger errorLogger) {
        String string2;
        this.callSign = attributes.getValue("CALL_SIGN");
        if (null == this.callSign || 0 == this.callSign.length()) {
            if (null != errorLogger) {
                errorLogger.reportError("Missing or bad CALL_SIGN attribute in " + string + " tag");
            }
            return false;
        }
        if (this.callSign.length() > 12) {
            this.callSign = this.callSign.substring(0, 12);
        }
        this.city = attributes.getValue("CITY");
        if (null == this.city || 0 == this.city.length()) {
            if (null != errorLogger) {
                errorLogger.reportError("Missing or bad CITY attribute in " + string + " tag");
            }
            return false;
        }
        if (this.city.length() > 20) {
            this.city = this.city.substring(0, 20);
        }
        this.state = attributes.getValue("STATE");
        if (null == this.state || 0 == this.state.length()) {
            if (null != errorLogger) {
                errorLogger.reportError("Missing or bad STATE attribute in " + string + " tag");
            }
            return false;
        }
        if (this.state.length() > 2) {
            this.state = this.state.substring(0, 2);
        }
        if (null != (string2 = attributes.getValue("CHANNEL"))) {
            try {
                this.channel = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.channel < 200 || this.channel > 300) {
            if (null != errorLogger) {
                errorLogger.reportError("Missing or bad CHANNEL attribute in " + string + " tag");
            }
            return false;
        }
        string2 = attributes.getValue("STATUS");
        if (null != string2) {
            this.status = string2;
            this.statusType = ExtDbRecord.getStatusType(string2);
            if (4 != this.statusType) {
                this.status = ExtDbRecord.STATUS_CODES[this.statusType];
            }
            if (this.status.length() > 6) {
                this.status = this.status.substring(0, 6);
            }
        }
        if (null != (string2 = attributes.getValue("FILE_NUMBER"))) {
            if (string2.length() > 255) {
                string2 = string2.substring(0, 255);
            }
            this.fileNumber = string2;
            this.appARN = ExtDbRecord.parseFileNumber(string2)[1];
        }
        if (!this.parseAttributes(string, attributes, errorLogger)) {
            return false;
        }
        string2 = attributes.getValue("IBOC");
        this.isIBOC = null != string2 && Boolean.parseBoolean(string2);
        this.ibocFraction = 0.01;
        if (this.isIBOC && null != (string2 = attributes.getValue("IBOC_ERP"))) {
            this.ibocFraction = 0.0;
            try {
                this.ibocFraction = Double.parseDouble(string2) / this.peakERP;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.ibocFraction < 0.01 || this.ibocFraction > 0.1) {
                if (null != errorLogger) {
                    errorLogger.reportError("Bad IBOC_ERP attribute in " + string + " tag");
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected ArrayList<String> getComments() {
        boolean bl;
        ArrayList<String> arrayList = null;
        String string = this.getAttribute("licensee");
        boolean bl2 = null != string && string.length() > 0;
        boolean bl3 = bl = null != this.getAttribute("contour73215");
        if (bl2 || bl) {
            arrayList = new ArrayList<String>();
            if (bl2) {
                arrayList.add("Licensee: " + string);
            }
            if (bl) {
                arrayList.add("73.215 contour protection requested");
            }
        }
        return arrayList;
    }

    @Override
    public String getFacilityID() {
        return String.valueOf(this.facilityID);
    }

    @Override
    public String getSortFacilityID() {
        return String.format(Locale.US, "%07d", this.facilityID);
    }

    @Override
    public String getChannel() {
        return String.valueOf(this.channel) + ExtDbRecordFM.FM_CLASS_CODES[this.stationClass];
    }

    @Override
    public int getChannelNumber() {
        return this.channel;
    }

    @Override
    public String getSortChannel() {
        return String.format(Locale.US, "%03d%02d", this.channel, this.stationClass);
    }

    @Override
    public String getFrequency() {
        return SourceEditDataFM.getFrequency(this.channel);
    }

    @Override
    public double getFrequencyValue() {
        return SourceEditDataFM.getFrequencyValue(this.channel);
    }

    public static String getFrequency(int n) {
        double d = SourceEditDataFM.getFrequencyValue(n);
        if (0.0 == d) {
            return "";
        }
        return String.format(Locale.US, "%.1f MHz", d);
    }

    public static double getFrequencyValue(int n) {
        if (0 == n) {
            return 0.0;
        }
        return 87.9 + (double)(n - 200) * 0.2;
    }

    @Override
    public String getStatus() {
        return this.status + (null != this.getAttribute("-isPending") ? " *P" : (null != this.getAttribute("-isArchived") ? " *A" : ""));
    }

    @Override
    public String getSortStatus() {
        return String.valueOf(this.statusType);
    }

    @Override
    public String getARN() {
        return this.appARN;
    }

    @Override
    public SourceEditData.RecordData getRecordData(ErrorLogger errorLogger) {
        SourceEditData.RecordData recordData = super.getRecordData(errorLogger);
        if (null == recordData) {
            return null;
        }
        TreeMap<String, String> treeMap = recordData.propertyValues;
        treeMap.put("180facilityID", this.getFacilityID());
        treeMap.put("130channel", this.getChannel());
        treeMap.put("140status", this.getStatus());
        return recordData;
    }

    private static class SearchDelta {
        int delta;
        double maximumDistance;

        private SearchDelta() {
        }
    }
}

