/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.editdata;

import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.data.Scenario;
import gov.fcc.tvstudy.core.editdata.ListDataChange;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class ScenarioListData
implements ListDataChange {
    private StudyEditData study;
    private ArrayList<ScenarioEditData> modelRows;
    private HashSet<Integer> addedKeys;
    private HashSet<Integer> deletedKeys;
    private ArrayList<ScenarioEditData> changedRows;
    private ArrayList<ScenarioPairItem> scenarioPairs;
    private boolean pairsChanged;
    private int lastChange;
    private int lastRow;

    public ScenarioListData(StudyEditData studyEditData) {
        this.study = studyEditData;
        this.modelRows = new ArrayList();
        for (Scenario object : this.study.study.scenarios) {
            this.modelRows.add(new ScenarioEditData(this.study, object));
        }
        this.addedKeys = new HashSet();
        this.deletedKeys = new HashSet();
        this.changedRows = new ArrayList();
        this.scenarioPairs = new ArrayList();
        for (Scenario.ScenarioPair scenarioPair : this.study.study.scenarioPairs) {
            ScenarioPairItem scenarioPairItem = this.createScenarioPair(scenarioPair.name, scenarioPair.description, scenarioPair.scenarioKeyA, scenarioPair.sourceKeyA, scenarioPair.scenarioKeyB, scenarioPair.sourceKeyB);
            if (null != scenarioPairItem) {
                this.scenarioPairs.add(scenarioPairItem);
                continue;
            }
            this.pairsChanged = true;
        }
        this.lastChange = 1;
        this.lastRow = 0;
    }

    public boolean addOrReplace(ScenarioEditData scenarioEditData) {
        this.lastRow = this.modelRows.indexOf(scenarioEditData);
        if (this.lastRow >= 0) {
            this.modelRows.set(this.lastRow, scenarioEditData);
            this.lastChange = 3;
        } else {
            this.lastRow = this.modelRows.size();
            this.modelRows.add(scenarioEditData);
            if (!this.deletedKeys.remove(scenarioEditData.key)) {
                this.addedKeys.add(scenarioEditData.key);
            }
            this.lastChange = 2;
        }
        return true;
    }

    public boolean remove(int n) {
        this.lastChange = 0;
        this.lastRow = -1;
        ScenarioEditData scenarioEditData = this.modelRows.get(n);
        if (scenarioEditData.isPermanent) {
            return false;
        }
        this.modelRows.remove(n);
        if (!this.addedKeys.remove(scenarioEditData.key)) {
            this.deletedKeys.add(scenarioEditData.key);
        }
        if (3 != scenarioEditData.scenarioType) {
            for (SourceEditData sourceEditData : scenarioEditData.sourceData.getSources()) {
                this.study.removeSource(sourceEditData);
            }
        }
        this.lastChange = 4;
        this.lastRow = n;
        return true;
    }

    public boolean remove(int[] nArray) {
        int n;
        this.lastChange = 0;
        this.lastRow = -1;
        if (0 == nArray.length) {
            return false;
        }
        if (1 == nArray.length) {
            return this.remove(nArray[0]);
        }
        for (n = 0; n < nArray.length - 1; ++n) {
            int n2 = n;
            for (int i = n + 1; i < nArray.length; ++i) {
                if (nArray[i] <= nArray[n2]) continue;
                n2 = i;
            }
            if (n2 == n) continue;
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
        }
        boolean bl = false;
        for (n = 0; n < nArray.length; ++n) {
            ScenarioEditData scenarioEditData = this.modelRows.get(nArray[n]);
            if (scenarioEditData.isPermanent) continue;
            this.modelRows.remove(nArray[n]);
            if (!this.addedKeys.remove(scenarioEditData.key)) {
                this.deletedKeys.add(scenarioEditData.key);
            }
            bl = true;
            if (3 == scenarioEditData.scenarioType) continue;
            for (SourceEditData sourceEditData : scenarioEditData.sourceData.getSources()) {
                this.study.removeSource(sourceEditData);
            }
        }
        if (bl) {
            this.lastChange = 1;
            this.lastRow = 0;
        }
        return bl;
    }

    private ScenarioPairItem createScenarioPair(String string, String string2, int n, int n2, int n3, int n4) {
        ScenarioPairItem scenarioPairItem = new ScenarioPairItem();
        scenarioPairItem.name = string;
        scenarioPairItem.description = string2;
        Integer n5 = n;
        ScenarioEditData scenarioEditData = null;
        for (ScenarioEditData scenarioEditData2 : this.modelRows) {
            if (scenarioEditData2.key.equals(n5)) {
                scenarioEditData = scenarioEditData2;
                break;
            }
            scenarioEditData = scenarioEditData2.getChildScenario(n5);
            if (null == scenarioEditData) continue;
            break;
        }
        if (null == scenarioEditData) {
            return null;
        }
        scenarioPairItem.scenarioA = scenarioEditData;
        n5 = n3;
        scenarioEditData = null;
        for (ScenarioEditData scenarioEditData2 : this.modelRows) {
            if (scenarioEditData2.key.equals(n5)) {
                scenarioEditData = scenarioEditData2;
                break;
            }
            scenarioEditData = scenarioEditData2.getChildScenario(n5);
            if (null == scenarioEditData) continue;
            break;
        }
        if (null == scenarioEditData) {
            return null;
        }
        scenarioPairItem.scenarioB = scenarioEditData;
        scenarioPairItem.sourceKeyA = n2;
        scenarioPairItem.itemKeyA = ((ScenarioPairItem)scenarioPairItem).scenarioA.sourceData.getItemKeyForSourceKey(n2);
        if (scenarioPairItem.itemKeyA < 0) {
            return null;
        }
        scenarioPairItem.sourceKeyB = n4;
        scenarioPairItem.itemKeyB = ((ScenarioPairItem)scenarioPairItem).scenarioB.sourceData.getItemKeyForSourceKey(n4);
        if (scenarioPairItem.itemKeyB < 0) {
            return null;
        }
        return scenarioPairItem;
    }

    public boolean addScenarioPair(String string, String string2, int n, int n2, int n3, int n4) {
        ScenarioPairItem scenarioPairItem = this.createScenarioPair(string, string2, n, n2, n3, n4);
        if (null == scenarioPairItem) {
            return false;
        }
        this.scenarioPairs.add(scenarioPairItem);
        this.pairsChanged = true;
        return true;
    }

    public ScenarioEditData get(int n) {
        return this.modelRows.get(n);
    }

    public ScenarioEditData get(String string) {
        for (ScenarioEditData scenarioEditData : this.modelRows) {
            if (!scenarioEditData.name.equalsIgnoreCase(string)) continue;
            return scenarioEditData;
        }
        return null;
    }

    public ArrayList<ScenarioEditData> getRows() {
        return new ArrayList<ScenarioEditData>(this.modelRows);
    }

    public int indexOf(ScenarioEditData scenarioEditData) {
        return this.modelRows.indexOf(scenarioEditData);
    }

    public boolean isDataValid() {
        return this.isDataValid(null);
    }

    public boolean isDataValid(ErrorLogger errorLogger) {
        for (ScenarioEditData scenarioEditData : this.modelRows) {
            if (scenarioEditData.isDataValid(errorLogger)) continue;
            return false;
        }
        return true;
    }

    public boolean isDataChanged() {
        boolean bl = false;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        this.changedRows.clear();
        for (ScenarioEditData object : this.modelRows) {
            hashSet.add(object.key);
            object.getChildScenarioKeys(hashSet);
            if (!object.isDataChanged() && !this.addedKeys.contains(object.key)) continue;
            this.changedRows.add(object);
            bl = true;
        }
        Iterator<Object> iterator = this.scenarioPairs.iterator();
        while (iterator.hasNext()) {
            ScenarioPairItem scenarioPairItem = (ScenarioPairItem)iterator.next();
            if (!hashSet.contains(((ScenarioPairItem)scenarioPairItem).scenarioA.key) || !hashSet.contains(((ScenarioPairItem)scenarioPairItem).scenarioB.key)) {
                iterator.remove();
                this.pairsChanged = true;
                continue;
            }
            int n = ((ScenarioPairItem)scenarioPairItem).scenarioA.sourceData.getSourceKeyForItemKey(scenarioPairItem.itemKeyA);
            if (n < 0) {
                iterator.remove();
                this.pairsChanged = true;
                continue;
            }
            if (n != scenarioPairItem.sourceKeyA) {
                scenarioPairItem.sourceKeyA = n;
                this.pairsChanged = true;
            }
            if ((n = ((ScenarioPairItem)scenarioPairItem).scenarioB.sourceData.getSourceKeyForItemKey(scenarioPairItem.itemKeyB)) < 0) {
                iterator.remove();
                this.pairsChanged = true;
                continue;
            }
            if (n == scenarioPairItem.sourceKeyB) continue;
            scenarioPairItem.sourceKeyB = n;
            this.pairsChanged = true;
        }
        if (bl || this.pairsChanged) {
            return true;
        }
        if (!this.addedKeys.isEmpty()) {
            return true;
        }
        return !this.deletedKeys.isEmpty();
    }

    public HashSet<Integer> getDeletedKeys() {
        return this.deletedKeys;
    }

    public ArrayList<ScenarioEditData> getChangedRows() {
        return this.changedRows;
    }

    public boolean didScenarioPairsChange() {
        return this.pairsChanged;
    }

    public void didSave() {
        this.addedKeys.clear();
        this.deletedKeys.clear();
        this.changedRows.clear();
        this.pairsChanged = false;
    }

    public ArrayList<Scenario> getScenarios() {
        ArrayList<Scenario> arrayList = new ArrayList<Scenario>();
        for (ScenarioEditData scenarioEditData : this.modelRows) {
            arrayList.add(scenarioEditData.scenario);
        }
        return arrayList;
    }

    public ArrayList<Scenario.ScenarioPair> getScenarioPairs() {
        ArrayList<Scenario.ScenarioPair> arrayList = new ArrayList<Scenario.ScenarioPair>();
        for (ScenarioPairItem scenarioPairItem : this.scenarioPairs) {
            arrayList.add(new Scenario.ScenarioPair(scenarioPairItem.name, scenarioPairItem.description, ((ScenarioPairItem)scenarioPairItem).scenarioA.key, scenarioPairItem.sourceKeyA, ((ScenarioPairItem)scenarioPairItem).scenarioB.key, scenarioPairItem.sourceKeyB));
        }
        return arrayList;
    }

    public int getRowCount() {
        return this.modelRows.size();
    }

    @Override
    public int getLastChange() {
        return this.lastChange;
    }

    @Override
    public int getLastRowChanged() {
        return this.lastRow;
    }

    private class ScenarioPairItem {
        private String name;
        private String description;
        private ScenarioEditData scenarioA;
        private int sourceKeyA;
        private int itemKeyA;
        private ScenarioEditData scenarioB;
        private int sourceKeyB;
        private int itemKeyB;

        private ScenarioPairItem() {
        }
    }
}

