/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.editdata;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecordFM;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.ExtDbSearch;
import gov.fcc.tvstudy.core.data.Parameter;
import gov.fcc.tvstudy.core.data.Scenario;
import gov.fcc.tvstudy.core.editdata.ParameterEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataFM;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.SourceEditDataWL;
import gov.fcc.tvstudy.core.editdata.SourceListData;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ScenarioEditData {
    public final StudyEditData study;
    public Scenario scenario;
    public final Integer key;
    public String name;
    public String description;
    public final int scenarioType;
    public final boolean isPermanent;
    public ArrayList<ParameterEditData> parameters;
    private HashMap<Integer, ParameterEditData> parameterMap;
    public final SourceListData sourceData;
    public final Integer parentScenarioKey;
    private HashMap<Integer, ScenarioEditData> childScenarios;
    private boolean childScenariosChanged;

    public ScenarioEditData(StudyEditData studyEditData, Scenario scenario) {
        this.study = studyEditData;
        this.scenario = scenario;
        this.key = scenario.key;
        this.name = scenario.name;
        this.description = scenario.description;
        this.scenarioType = scenario.scenarioType;
        this.isPermanent = scenario.isPermanent;
        this.doParameterSetup(scenario.parameters);
        this.sourceData = new SourceListData(studyEditData, scenario);
        this.parentScenarioKey = scenario.parentScenarioKey;
        if (null != scenario.childScenarios) {
            this.childScenarios = new HashMap(scenario.childScenarios.size());
            for (Scenario scenario2 : scenario.childScenarios) {
                this.childScenarios.put(scenario2.key, new ScenarioEditData(studyEditData, scenario2));
            }
        }
    }

    public ScenarioEditData(StudyEditData studyEditData, String string) {
        this.study = studyEditData;
        this.scenario = null;
        this.key = studyEditData.getNewScenarioKey();
        if (null != studyEditData.scenarioData.get(string)) {
            string = string + " " + '#' + String.valueOf(this.key);
        }
        this.name = string;
        this.description = "";
        this.scenarioType = 1;
        this.isPermanent = false;
        this.doParameterSetup(studyEditData.study.scenarioParameters);
        this.sourceData = new SourceListData(studyEditData, null);
        this.parentScenarioKey = null;
    }

    public ScenarioEditData(StudyEditData studyEditData, String string, String string2, ArrayList<Scenario.SourceListItem> arrayList) {
        this.study = studyEditData;
        this.scenario = null;
        this.key = studyEditData.getNewScenarioKey();
        if (null != studyEditData.scenarioData.get(string)) {
            string = string + " " + '#' + String.valueOf(this.key);
        }
        this.name = string;
        this.description = string2;
        this.scenarioType = 1;
        this.isPermanent = false;
        this.doParameterSetup(studyEditData.study.scenarioParameters);
        this.sourceData = new SourceListData(studyEditData, this.scenarioType, arrayList);
        this.parentScenarioKey = null;
    }

    public ScenarioEditData(StudyEditData studyEditData, String string, String string2, boolean bl, ArrayList<Scenario.SourceListItem> arrayList) {
        this.study = studyEditData;
        this.scenario = null;
        this.key = studyEditData.getNewScenarioKey();
        if (null != studyEditData.scenarioData.get(string)) {
            string = string + " " + '#' + String.valueOf(this.key);
        }
        this.name = string;
        this.description = string2;
        this.scenarioType = 1;
        this.isPermanent = bl;
        this.doParameterSetup(studyEditData.study.scenarioParameters);
        this.sourceData = new SourceListData(studyEditData, this.scenarioType, arrayList);
        this.parentScenarioKey = null;
    }

    public ScenarioEditData(StudyEditData studyEditData, String string, String string2, int n, boolean bl, ArrayList<Scenario.SourceListItem> arrayList) {
        this.study = studyEditData;
        this.scenario = null;
        this.key = studyEditData.getNewScenarioKey();
        if (null != studyEditData.scenarioData.get(string)) {
            string = string + " " + '#' + String.valueOf(this.key);
        }
        this.name = string;
        this.description = string2;
        this.scenarioType = n;
        this.isPermanent = bl;
        this.doParameterSetup(studyEditData.study.scenarioParameters);
        this.sourceData = new SourceListData(studyEditData, this.scenarioType, arrayList);
        this.parentScenarioKey = null;
    }

    private void doParameterSetup(ArrayList<Parameter> arrayList) {
        if (null != arrayList) {
            this.parameters = new ArrayList();
            this.parameterMap = new HashMap();
            for (Parameter parameter : arrayList) {
                ParameterEditData parameterEditData = new ParameterEditData(parameter, this.study.study.templateLocked);
                this.parameters.add(parameterEditData);
                this.parameterMap.put(parameter.key, parameterEditData);
            }
        }
    }

    private ScenarioEditData(StudyEditData studyEditData, Integer n, int n2, boolean bl, ArrayList<ParameterEditData> arrayList, SourceListData sourceListData, Integer n3) {
        this.study = studyEditData;
        this.key = n;
        this.scenarioType = n2;
        this.isPermanent = bl;
        this.parameters = arrayList;
        this.sourceData = sourceListData;
        this.parentScenarioKey = n3;
    }

    public ScenarioEditData duplicate(String string) {
        return this.duplicate(string, null);
    }

    public ScenarioEditData duplicate(String string, ErrorLogger errorLogger) {
        Object object;
        Object object2;
        ArrayList<ParameterEditData> arrayList = null;
        if (null != this.parameters) {
            arrayList = new ArrayList<ParameterEditData>();
            object2 = this.parameters.iterator();
            while (object2.hasNext()) {
                object = (ParameterEditData)object2.next();
                arrayList.add(((ParameterEditData)object).copy());
            }
        }
        if (null == (object2 = this.sourceData.duplicate(errorLogger))) {
            return null;
        }
        object = new ScenarioEditData(this.study, this.study.getNewScenarioKey(), 1, false, arrayList, (SourceListData)object2, null);
        ((ScenarioEditData)object).name = string;
        ((ScenarioEditData)object).description = this.description;
        return object;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object object) {
        return null != object && ((ScenarioEditData)object).key.equals(this.key);
    }

    public String toString() {
        return this.name;
    }

    public int addRecords(ExtDb extDb, boolean bl, ExtDbSearch extDbSearch) {
        return this.addRecords(extDb, bl, extDbSearch, null);
    }

    public int addRecords(ExtDb extDb, boolean bl, ExtDbSearch extDbSearch, ErrorLogger errorLogger) {
        String string = extDbSearch.makeQuery(extDb, bl, errorLogger);
        if (null == string) {
            return -1;
        }
        if (SourceEditData.isExtDbSupported(extDb)) {
            switch (extDbSearch.recordType) {
                case 1: {
                    return SourceEditDataTV.addRecords(extDb, this, extDbSearch.searchType, string, extDbSearch.center, extDbSearch.radius, extDbSearch.minimumChannel, extDbSearch.maximumChannel, extDbSearch.disableMX, extDbSearch.mxFacilityIDOnly, !extDbSearch.desiredOnly, errorLogger);
                }
                case 2: {
                    return SourceEditDataWL.addRecords(extDb, this, extDbSearch.searchType, string, extDbSearch.center, extDbSearch.radius, errorLogger);
                }
                case 3: {
                    return SourceEditDataFM.addRecords(extDb, this, extDbSearch.searchType, string, extDbSearch.center, extDbSearch.radius, extDbSearch.minimumChannel, extDbSearch.maximumChannel, extDbSearch.disableMX, extDbSearch.mxFacilityIDOnly, !extDbSearch.desiredOnly, errorLogger);
                }
            }
        } else {
            switch (extDbSearch.recordType) {
                case 1: {
                    return ExtDbRecordTV.addRecords(extDb, bl, this, extDbSearch.searchType, string, extDbSearch.center, extDbSearch.radius, extDbSearch.minimumChannel, extDbSearch.maximumChannel, extDbSearch.includeSharingGuests, extDbSearch.disableMX, extDbSearch.mxFacilityIDOnly, extDbSearch.preferOperating, !extDbSearch.desiredOnly, errorLogger);
                }
                case 3: {
                    return ExtDbRecordFM.addRecords(extDb, this, extDbSearch.searchType, string, extDbSearch.center, extDbSearch.radius, extDbSearch.minimumChannel, extDbSearch.maximumChannel, extDbSearch.disableMX, extDbSearch.mxFacilityIDOnly, extDbSearch.preferOperating, !extDbSearch.desiredOnly, errorLogger);
                }
            }
        }
        return 0;
    }

    public ScenarioEditData addChildScenario(String string, String string2, int n, ArrayList<Scenario.SourceListItem> arrayList) {
        if (null != this.parentScenarioKey) {
            return null;
        }
        Integer n2 = this.study.getNewScenarioKey();
        ScenarioEditData scenarioEditData = new ScenarioEditData(this.study, n2, n, false, null, new SourceListData(this.study, n, arrayList), this.key);
        if (null == this.childScenarios) {
            this.childScenarios = new HashMap();
        }
        this.childScenarios.put(n2, scenarioEditData);
        this.childScenariosChanged = true;
        scenarioEditData.name = string;
        scenarioEditData.description = string2;
        scenarioEditData.doParameterSetup(this.study.study.scenarioParameters);
        return scenarioEditData;
    }

    public ScenarioEditData getChildScenario(Integer n) {
        if (null != this.childScenarios) {
            return this.childScenarios.get(n);
        }
        return null;
    }

    public void removeAllChildScenarios() {
        if (null != this.childScenarios) {
            this.childScenarios = null;
            this.childScenariosChanged = true;
        }
    }

    public boolean didChildScenariosChange() {
        return this.childScenariosChanged;
    }

    public HashSet<Integer> getChildScenarioKeys(HashSet<Integer> hashSet) {
        if (null != this.childScenarios) {
            if (null == hashSet) {
                hashSet = new HashSet<Integer>(this.childScenarios.keySet());
            } else {
                hashSet.addAll(this.childScenarios.keySet());
            }
        }
        return hashSet;
    }

    public ArrayList<ScenarioEditData> getChildScenarios() {
        if (null != this.childScenarios) {
            return new ArrayList<ScenarioEditData>(this.childScenarios.values());
        }
        return new ArrayList<ScenarioEditData>();
    }

    public int getChildScenarioCount() {
        if (null != this.childScenarios) {
            return this.childScenarios.size();
        }
        return 0;
    }

    public boolean isDataValid() {
        return this.isDataValid(null);
    }

    public boolean isDataValid(ErrorLogger errorLogger) {
        if (!this.sourceData.isDataValid(errorLogger)) {
            return false;
        }
        if (0 == this.name.length()) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A name must be entered for every scenario");
            }
            return false;
        }
        if (null != this.childScenarios) {
            for (ScenarioEditData scenarioEditData : this.childScenarios.values()) {
                if (scenarioEditData.isDataValid(errorLogger)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDataChanged() {
        if (null == this.scenario) {
            return true;
        }
        if (!this.name.equals(this.scenario.name)) {
            return true;
        }
        if (!this.description.equals(this.scenario.description)) {
            return true;
        }
        if (null != this.parameters) {
            for (ParameterEditData object : this.parameters) {
                if (!object.isDataChanged()) continue;
                return true;
            }
        }
        if (this.sourceData.isDataChanged()) {
            return true;
        }
        int n = this.scenario.sourceList.size();
        if (this.sourceData.getRowCount() != n) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            Scenario.SourceListItem sourceListItem = this.scenario.sourceList.get(i);
            Scenario.SourceListItem sourceListItem2 = this.sourceData.get(i);
            if (sourceListItem2.isDesired == sourceListItem.isDesired && sourceListItem2.isUndesired == sourceListItem.isUndesired) continue;
            return true;
        }
        return this.childScenariosChanged;
    }

    public boolean isScenarioChanged() {
        if (null == this.scenario || null == this.childScenarios) {
            return true;
        }
        if (this.sourceData.isScenarioChanged()) {
            return true;
        }
        int n = this.scenario.sourceList.size();
        if (this.sourceData.getRowCount() != n) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            Scenario.SourceListItem sourceListItem = this.scenario.sourceList.get(i);
            Scenario.SourceListItem sourceListItem2 = this.sourceData.get(i);
            if (sourceListItem2.isDesired == sourceListItem.isDesired && sourceListItem2.isUndesired == sourceListItem.isUndesired) continue;
            return true;
        }
        return false;
    }

    public void save(DbConnection dbConnection) throws SQLException {
        if (null != this.scenario) {
            dbConnection.update("DELETE FROM scenario WHERE scenario_key = " + this.key);
            dbConnection.update("DELETE FROM scenario_source WHERE scenario_key = " + this.key);
            dbConnection.update("DELETE FROM scenario_parameter_data WHERE scenario_key = " + this.key);
            if (this.childScenariosChanged) {
                dbConnection.update("DELETE FROM scenario_source WHERE scenario_key IN (SELECT scenario_key FROM scenario WHERE parent_scenario_key = " + this.key + ")");
                dbConnection.update("DELETE FROM scenario_parameter_data WHERE scenario_key IN (SELECT scenario_key FROM scenario WHERE parent_scenario_key = " + this.key + ")");
                dbConnection.update("DELETE FROM scenario WHERE parent_scenario_key = " + this.key);
            }
        }
        dbConnection.update("INSERT INTO scenario (scenario_key, name, description, scenario_type, is_permanent, parent_scenario_key) VALUES (" + this.key + ",'" + DbConnection.clean(this.name) + "','" + DbConnection.clean(this.description) + "'," + this.scenarioType + "," + this.isPermanent + "," + (null == this.parentScenarioKey ? "0" : String.valueOf(this.parentScenarioKey)) + ")");
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO scenario_source (scenario_key, source_key, is_desired, is_undesired, is_permanent) VALUES");
        int n = stringBuilder.length();
        String string = " (";
        for (Scenario.SourceListItem object : this.sourceData.getRows()) {
            stringBuilder.append(string);
            stringBuilder.append(String.valueOf(this.key));
            stringBuilder.append(',');
            stringBuilder.append(String.valueOf(object.key));
            stringBuilder.append(',');
            stringBuilder.append(String.valueOf(object.isDesired));
            stringBuilder.append(',');
            stringBuilder.append(String.valueOf(object.isUndesired));
            stringBuilder.append(',');
            stringBuilder.append(String.valueOf(object.isPermanent));
            if (stringBuilder.length() > 500000) {
                stringBuilder.append(')');
                dbConnection.update(stringBuilder.toString());
                stringBuilder.setLength(n);
                string = " (";
                continue;
            }
            string = "),(";
        }
        if (stringBuilder.length() > n) {
            stringBuilder.append(')');
            dbConnection.update(stringBuilder.toString());
        }
        if (null != this.parameters && !this.parameters.isEmpty()) {
            stringBuilder = new StringBuilder("INSERT INTO scenario_parameter_data (scenario_key,parameter_key,value_index,value) VALUES");
            n = stringBuilder.length();
            string = " (";
            for (ParameterEditData parameterEditData : this.parameters) {
                for (int i = 0; i < parameterEditData.parameter.valueCount; ++i) {
                    stringBuilder.append(string);
                    stringBuilder.append(String.valueOf(this.key));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(parameterEditData.parameter.key));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(i));
                    stringBuilder.append(",'");
                    stringBuilder.append(DbConnection.clean(parameterEditData.value[i]));
                    stringBuilder.append('\'');
                    if (stringBuilder.length() > 500000) {
                        stringBuilder.append(')');
                        dbConnection.update(stringBuilder.toString());
                        stringBuilder.setLength(n);
                        string = " (";
                        continue;
                    }
                    string = "),(";
                }
            }
            if (stringBuilder.length() > n) {
                stringBuilder.append(')');
                dbConnection.update(stringBuilder.toString());
            }
        }
    }

    public void didSave() {
        ArrayList<Parameter> arrayList = null;
        if (null != this.parameters) {
            arrayList = new ArrayList<Parameter>();
            for (ParameterEditData object : this.parameters) {
                object.didSave();
                arrayList.add(object.parameter);
            }
        }
        Object object = null;
        if (null != this.childScenarios) {
            object = new ArrayList();
            for (ScenarioEditData scenarioEditData : this.childScenarios.values()) {
                scenarioEditData.didSave();
                ((ArrayList)object).add(scenarioEditData.scenario);
            }
        }
        this.childScenariosChanged = false;
        this.sourceData.didSave();
        this.scenario = new Scenario(this.key, this.name, this.description, this.scenarioType, this.isPermanent, arrayList, this.sourceData.getRows(), this.parentScenarioKey, (ArrayList<Scenario>)object);
    }

    public boolean writeToXML(Writer writer) throws IOException {
        return this.writeToXML(writer, null);
    }

    public boolean writeToXML(Writer writer, ErrorLogger errorLogger) throws IOException {
        if (!this.isDataValid(errorLogger)) {
            return false;
        }
        writer.append("<SCENARIO NAME=\"" + AppCore.xmlclean(this.name) + "\">\n");
        writer.append("<DESCRIPTION>" + AppCore.xmlclean(this.description) + "</DESCRIPTION>\n");
        if (null != this.parameters) {
            for (ParameterEditData parameterEditData : this.parameters) {
                writer.append("<PARAMETER KEY=\"" + parameterEditData.parameter.key + "\">\n");
                for (int i = 0; i < parameterEditData.parameter.valueCount; ++i) {
                    if (null == parameterEditData.value[i]) continue;
                    writer.append("<VALUE INDEX=\"" + i + "\">" + AppCore.xmlclean(parameterEditData.value[i]) + "</VALUE>\n");
                }
                writer.append("</PARAMETER>\n");
            }
        }
        if (!this.sourceData.writeSourcesToXML(writer, errorLogger)) {
            return false;
        }
        writer.append("</SCENARIO>\n");
        return true;
    }

    public ParameterEditData getParameter(int n) {
        return this.parameterMap.get(n);
    }
}

