/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.editdata;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.data.Parameter;
import java.util.Date;

public class ParameterEditData {
    public Parameter parameter;
    public final boolean isLocked;
    public String[] value;
    public int[][] integerTableValue;
    public double[][] decimalTableValue;
    public int[] integerValue;
    public double[] decimalValue;
    public boolean[] optionValue;
    public int[] pickfromIndex;
    public Date[] dateValue;

    public ParameterEditData(Parameter parameter, boolean bl) {
        int n;
        this.parameter = parameter;
        this.isLocked = bl;
        this.value = new String[this.parameter.valueCount];
        for (n = 0; n < this.parameter.valueCount; ++n) {
            this.value[n] = this.parameter.value[n];
        }
        if (this.parameter.isTable) {
            int n2 = this.parameter.tableRowLabels.length * this.parameter.tableColumnLabels.length;
            switch (this.parameter.type) {
                case 2: {
                    this.integerTableValue = new int[this.parameter.valueCount][n2];
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        for (int i = 0; i < n2; ++i) {
                            this.integerTableValue[n][i] = this.parameter.integerTableValue[n][i];
                        }
                    }
                    break;
                }
                case 3: {
                    this.decimalTableValue = new double[this.parameter.valueCount][n2];
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        for (int i = 0; i < n2; ++i) {
                            this.decimalTableValue[n][i] = this.parameter.decimalTableValue[n][i];
                        }
                    }
                    break;
                }
            }
        } else {
            switch (this.parameter.type) {
                case 2: {
                    this.integerValue = new int[this.parameter.valueCount];
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        this.integerValue[n] = this.parameter.integerValue[n];
                    }
                    break;
                }
                case 3: {
                    this.decimalValue = new double[this.parameter.valueCount];
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        this.decimalValue[n] = this.parameter.decimalValue[n];
                    }
                    break;
                }
                case 4: {
                    this.optionValue = new boolean[this.parameter.valueCount];
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        this.optionValue[n] = this.parameter.optionValue[n];
                    }
                    break;
                }
                case 5: {
                    this.integerValue = new int[this.parameter.valueCount];
                    this.pickfromIndex = new int[this.parameter.valueCount];
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        this.integerValue[n] = this.parameter.integerValue[n];
                        this.pickfromIndex[n] = this.parameter.pickfromIndex[n];
                    }
                    break;
                }
                case 6: {
                    this.dateValue = new Date[this.parameter.valueCount];
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        this.dateValue[n] = this.parameter.dateValue[n];
                    }
                    break;
                }
            }
        }
    }

    public ParameterEditData copy() {
        int n;
        ParameterEditData parameterEditData = new ParameterEditData(this.parameter, this.isLocked);
        for (n = 0; n < this.parameter.valueCount; ++n) {
            parameterEditData.value[n] = this.value[n];
        }
        if (this.parameter.isTable) {
            int n2 = this.parameter.tableRowLabels.length * this.parameter.tableColumnLabels.length;
            switch (this.parameter.type) {
                case 2: {
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        for (int i = 0; i < n2; ++i) {
                            parameterEditData.integerTableValue[n][i] = this.integerTableValue[n][i];
                        }
                    }
                    break;
                }
                case 3: {
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        for (int i = 0; i < n2; ++i) {
                            parameterEditData.decimalTableValue[n][i] = this.decimalTableValue[n][i];
                        }
                    }
                    break;
                }
            }
        } else {
            switch (this.parameter.type) {
                case 2: {
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        parameterEditData.integerValue[n] = this.integerValue[n];
                    }
                    break;
                }
                case 3: {
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        parameterEditData.decimalValue[n] = this.decimalValue[n];
                    }
                    break;
                }
                case 4: {
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        parameterEditData.optionValue[n] = this.optionValue[n];
                    }
                    break;
                }
                case 5: {
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        parameterEditData.integerValue[n] = this.integerValue[n];
                        parameterEditData.pickfromIndex[n] = this.pickfromIndex[n];
                    }
                    break;
                }
                case 6: {
                    for (n = 0; n < this.parameter.valueCount; ++n) {
                        parameterEditData.dateValue[n] = this.dateValue[n];
                    }
                    break;
                }
            }
        }
        return parameterEditData;
    }

    public boolean isDataChanged() {
        if (this.parameter.defaultsApplied) {
            return true;
        }
        if (this.isLocked) {
            return false;
        }
        for (int i = 0; i < this.parameter.valueCount; ++i) {
            if (this.value[i].equals(this.parameter.value[i])) continue;
            return true;
        }
        return false;
    }

    public boolean setDefaultValue(int n) {
        if (this.isLocked) {
            return false;
        }
        if (this.value[n].equals(this.parameter.defaultValue[n])) {
            return false;
        }
        this.value[n] = this.parameter.defaultValue[n];
        if (this.parameter.isTable) {
            int n2;
            int n3 = this.parameter.tableRowLabels.length * this.parameter.tableColumnLabels.length;
            String[] stringArray = this.value[n].split(",");
            block25: for (n2 = 0; n2 < stringArray.length; ++n2) {
                switch (this.parameter.type) {
                    case 2: {
                        try {
                            this.integerTableValue[n][n2] = Integer.parseInt(stringArray[n2]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.integerTableValue[n][n2] = 0;
                        }
                        continue block25;
                    }
                    case 3: {
                        try {
                            this.decimalTableValue[n][n2] = Double.parseDouble(stringArray[n2]);
                            continue block25;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.decimalTableValue[n][n2] = 0.0;
                        }
                    }
                }
            }
            while (n2 < n3) {
                switch (this.parameter.type) {
                    case 2: {
                        this.integerTableValue[n][n2] = 0;
                        break;
                    }
                    case 3: {
                        this.decimalTableValue[n][n2] = 0.0;
                    }
                }
                ++n2;
            }
        } else {
            switch (this.parameter.type) {
                case 2: {
                    try {
                        this.integerValue[n] = Integer.parseInt(this.value[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.integerValue[n] = 0;
                    }
                    break;
                }
                case 3: {
                    try {
                        this.decimalValue[n] = Double.parseDouble(this.value[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.decimalValue[n] = 0.0;
                    }
                    break;
                }
                case 4: {
                    this.optionValue[n] = this.value[n].equals("1");
                    break;
                }
                case 5: {
                    try {
                        int n4;
                        this.integerValue[n] = Integer.parseInt(this.value[n]);
                        for (n4 = this.parameter.pickfromItems.size() - 1; n4 > 0 && this.integerValue[n] != this.parameter.pickfromItems.get((int)n4).key; --n4) {
                        }
                        this.pickfromIndex[n] = n4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.pickfromIndex[n] = 0;
                    }
                    break;
                }
                case 6: {
                    if (this.value[n].length() > 0) {
                        this.dateValue[n] = AppCore.parseDate(this.value[n]);
                        if (null != this.dateValue[n]) break;
                        this.dateValue[n] = new Date(0L);
                        break;
                    }
                    this.dateValue[n] = null;
                }
            }
        }
        return true;
    }

    public void didSave() {
        this.parameter = new Parameter(this.parameter.key, this.parameter.name, this.parameter.valueName, this.parameter.units, this.value, this.parameter.defaultValue, this.parameter.description, this.parameter.groupName, this.parameter.enablesGroup, this.parameter.isScenario, this.parameter.isTable, this.parameter.tableRowLabels, this.parameter.tableColumnLabels, this.parameter.type, this.parameter.minIntegerValue, this.parameter.maxIntegerValue, this.parameter.minDecimalValue, this.parameter.maxDecimalValue, this.parameter.decimalPrecision, this.parameter.pickfromItems, this.integerTableValue, this.decimalTableValue, this.integerValue, this.decimalValue, this.optionValue, this.pickfromIndex, this.dateValue);
    }
}

