/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.editdata;

import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.data.ChannelBand;
import gov.fcc.tvstudy.core.data.ChannelDelta;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.IxRule;
import gov.fcc.tvstudy.core.data.ServiceType;
import gov.fcc.tvstudy.core.data.SignalType;

public class IxRuleEditData {
    public IxRule ixRule;
    public final boolean isLocked;
    public Integer key;
    public Country country;
    public ServiceType serviceType;
    public SignalType signalType;
    public ServiceType undesiredServiceType;
    public SignalType undesiredSignalType;
    public ChannelDelta channelDelta;
    public ChannelBand channelBand;
    public int frequencyOffset;
    public EmissionMask emissionMask;
    public double distance;
    public double requiredDU;
    public double undesiredTime;
    public boolean isActive;

    public IxRuleEditData(IxRule ixRule, boolean bl) {
        this.ixRule = ixRule;
        this.isLocked = bl;
        this.key = this.ixRule.key;
        this.country = this.ixRule.country;
        this.serviceType = this.ixRule.serviceType;
        this.signalType = this.ixRule.signalType;
        this.undesiredServiceType = this.ixRule.undesiredServiceType;
        this.undesiredSignalType = this.ixRule.undesiredSignalType;
        this.channelDelta = this.ixRule.channelDelta;
        this.channelBand = this.ixRule.channelBand;
        this.frequencyOffset = this.ixRule.frequencyOffset;
        this.emissionMask = this.ixRule.emissionMask;
        this.distance = this.ixRule.distance;
        this.requiredDU = this.ixRule.requiredDU;
        this.undesiredTime = this.ixRule.undesiredTime;
        this.isActive = this.ixRule.isActive;
    }

    public IxRuleEditData(Integer n) {
        this.ixRule = null;
        this.isLocked = false;
        this.key = n;
        this.country = Country.getInvalidObject();
        this.serviceType = ServiceType.getInvalidObject();
        this.signalType = SignalType.getNullObject();
        this.undesiredServiceType = ServiceType.getInvalidObject();
        this.undesiredSignalType = SignalType.getNullObject();
        this.channelDelta = ChannelDelta.getInvalidObject();
        this.channelBand = ChannelBand.getNullObject();
        this.frequencyOffset = 0;
        this.emissionMask = EmissionMask.getNullObject();
        this.isActive = true;
    }

    private IxRuleEditData(boolean bl) {
        this.isLocked = bl;
    }

    public IxRuleEditData copy() {
        IxRuleEditData ixRuleEditData = new IxRuleEditData(this.isLocked);
        ixRuleEditData.ixRule = this.ixRule;
        ixRuleEditData.key = this.key;
        ixRuleEditData.country = this.country;
        ixRuleEditData.serviceType = this.serviceType;
        ixRuleEditData.signalType = this.signalType;
        ixRuleEditData.undesiredServiceType = this.undesiredServiceType;
        ixRuleEditData.undesiredSignalType = this.undesiredSignalType;
        ixRuleEditData.channelDelta = this.channelDelta;
        ixRuleEditData.channelBand = this.channelBand;
        ixRuleEditData.frequencyOffset = this.frequencyOffset;
        ixRuleEditData.emissionMask = this.emissionMask;
        ixRuleEditData.distance = this.distance;
        ixRuleEditData.requiredDU = this.requiredDU;
        ixRuleEditData.undesiredTime = this.undesiredTime;
        ixRuleEditData.isActive = this.isActive;
        return ixRuleEditData;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object object) {
        return null != object && ((IxRuleEditData)object).key.equals(this.key);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        if (this.country.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.country.name);
            string = " ";
        }
        if (this.serviceType.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.serviceType.name);
            string = " ";
        }
        if (this.signalType.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.signalType.name);
            string = " ";
        }
        if (this.undesiredServiceType.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.undesiredServiceType.name);
            string = " ";
        }
        if (this.undesiredSignalType.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.undesiredSignalType.name);
            string = " ";
        }
        if (this.channelDelta.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.channelDelta.name);
            string = " ";
        }
        if (this.channelBand.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.channelBand.name);
            string = " ";
        }
        if (1 == this.frequencyOffset) {
            stringBuilder.append(string);
            stringBuilder.append("without frequency offset");
            string = " ";
        }
        if (2 == this.frequencyOffset) {
            stringBuilder.append(string);
            stringBuilder.append("with frequency offset");
            string = " ";
        }
        if (this.emissionMask.key > 0) {
            stringBuilder.append(string);
            stringBuilder.append(this.emissionMask.name);
            string = " ";
        }
        return stringBuilder.toString();
    }

    public boolean isDataValid() {
        return this.isDataValid(null);
    }

    public boolean isDataValid(ErrorLogger errorLogger) {
        if (this.country.key < 1) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A desired country must be selected");
            }
            return false;
        }
        if (this.serviceType.key < 1) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A desired service type must be selected");
            }
            return false;
        }
        if (this.serviceType.digital) {
            if (0 == this.signalType.key) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("A desired signal type must be selected");
                }
                return false;
            }
        } else if (this.signalType.key != 0) {
            this.signalType = SignalType.getNullObject();
        }
        if (this.undesiredServiceType.key < 1) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("An undesired service type must be selected");
            }
            return false;
        }
        if (this.undesiredServiceType.digital) {
            if (0 == this.undesiredSignalType.key) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("An undesired signal type must be selected");
                }
                return false;
            }
        } else if (this.undesiredSignalType.key != 0) {
            this.undesiredSignalType = SignalType.getNullObject();
        }
        if (this.undesiredServiceType.needsEmissionMask && 1 == Math.abs(this.channelDelta.delta)) {
            if (0 == this.emissionMask.key) {
                this.emissionMask = EmissionMask.getInvalidObject();
            }
        } else if (this.emissionMask.key != 0) {
            this.emissionMask = EmissionMask.getNullObject();
        }
        if (this.channelDelta.key < 1) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("An undesired channel must be selected");
            }
            return false;
        }
        if (this.channelBand.key < 0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("A channel band must be selected");
            }
            return false;
        }
        if (this.emissionMask.key < 0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("An undesired emission mask must be selected");
            }
            return false;
        }
        if (this.distance < 1.0 || this.distance > 500.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad distance limit, must be 1.0 to 500.0");
            }
            return false;
        }
        if (this.requiredDU < -60.0 || this.requiredDU > 60.0) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad required D/U, must be -60.0 to 60.0");
            }
            return false;
        }
        if (this.undesiredTime < 0.01 || this.undesiredTime > 99.99) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Bad undesired % time, must be 0.01 to 99.99");
            }
            return false;
        }
        return true;
    }

    public boolean isDataChanged() {
        if (null == this.ixRule) {
            return true;
        }
        if (this.isLocked) {
            return false;
        }
        if (this.country.key != this.ixRule.country.key) {
            return true;
        }
        if (this.serviceType.key != this.ixRule.serviceType.key) {
            return true;
        }
        if (this.signalType.key != this.ixRule.signalType.key) {
            return true;
        }
        if (this.undesiredServiceType.key != this.ixRule.undesiredServiceType.key) {
            return true;
        }
        if (this.undesiredSignalType.key != this.ixRule.undesiredSignalType.key) {
            return true;
        }
        if (this.channelDelta.key != this.ixRule.channelDelta.key) {
            return true;
        }
        if (this.channelBand.key != this.ixRule.channelBand.key) {
            return true;
        }
        if (this.frequencyOffset != this.ixRule.frequencyOffset) {
            return true;
        }
        if (this.emissionMask.key != this.ixRule.emissionMask.key) {
            return true;
        }
        if (this.distance != this.ixRule.distance) {
            return true;
        }
        if (this.requiredDU != this.ixRule.requiredDU) {
            return true;
        }
        if (this.undesiredTime != this.ixRule.undesiredTime) {
            return true;
        }
        return this.isActive != this.ixRule.isActive;
    }

    public void didSave() {
        this.ixRule = new IxRule(this.key, this.country, this.serviceType, this.signalType, this.undesiredServiceType, this.undesiredSignalType, this.channelDelta, this.channelBand, this.frequencyOffset, this.emissionMask, this.distance, this.requiredDU, this.undesiredTime, this.isActive);
    }
}

