/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.IxRule;
import gov.fcc.tvstudy.core.data.Parameter;
import java.sql.SQLException;
import java.util.ArrayList;

public class Template
extends KeyedRecord {
    public static final String DEFAULT_TEMPLATE_NAME = "Default";
    public final String dbID;
    public final boolean isPermanent;
    public final boolean isLocked;
    public final boolean isLockedInStudy;
    public final ArrayList<Parameter> parameters;
    public final ArrayList<IxRule> ixRules;

    public Template(String string, int n, String string2, boolean bl, boolean bl2, boolean bl3, ArrayList<Parameter> arrayList, ArrayList<IxRule> arrayList2) {
        super(n, string2);
        this.dbID = string;
        this.isPermanent = bl;
        this.isLocked = bl2;
        this.isLockedInStudy = bl3;
        this.parameters = arrayList;
        this.ixRules = arrayList2;
    }

    public static Template getTemplate(String string, int n) {
        return Template.getTemplate(string, n, null);
    }

    public static Template getTemplate(String string, int n, ErrorLogger errorLogger) {
        String string2 = DbCore.getDbName(string);
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        Template template = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string3 = "";
        String string4 = String.valueOf(n);
        String string5 = "";
        int n2 = 3;
        try {
            dbConnection.query("SELECT name, permanent, locked, locked_in_study FROM template WHERE (template_key = " + n + ") AND (hidden IS NULL)");
            if (dbConnection.next()) {
                string5 = dbConnection.getString(1);
                string4 = "'" + string5 + "'";
                bl2 = dbConnection.getBoolean(2);
                bl3 = dbConnection.getBoolean(3);
                bl4 = dbConnection.getBoolean(4);
                template = new Template(string, n, string5, bl2, bl3, bl4, Parameter.getParameters(dbConnection, null, string2, n, 0), IxRule.getIxRules(dbConnection, null, string2, n, 0));
            } else {
                bl = true;
                string3 = "The template does not exist";
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string3 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl) {
            if (null != errorLogger) {
                errorLogger.reportError("Could not load template " + string4 + ":\n" + string3, n2);
            }
            return null;
        }
        return template;
    }

    public static int getTemplateKeyForName(String string, String string2) {
        return Template.getTemplateKeyForName(string, string2, null);
    }

    public static int getTemplateKeyForName(String string, String string2, ErrorLogger errorLogger) {
        int n = 0;
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            try {
                boolean bl;
                boolean bl2 = true;
                do {
                    bl = false;
                    if (bl2) {
                        dbConnection.query("SELECT template_key, hidden FROM template WHERE (UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "') AND ((hidden IS NULL) OR (hidden <= NOW())) ORDER BY 1");
                    } else {
                        dbConnection.query("SELECT template_key FROM template WHERE (UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "') AND (hidden IS NULL) ORDER BY 1");
                    }
                    while (dbConnection.next()) {
                        if (bl2 && null != dbConnection.getDate(2)) {
                            bl = true;
                            break;
                        }
                        n = dbConnection.getInt(1);
                    }
                    bl2 = false;
                    if (!bl) continue;
                    Template.checkHiddenTemplates(dbConnection);
                } while (bl);
                DbCore.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                DbConnection.reportError(errorLogger, sQLException);
                n = -1;
            }
        }
        return n;
    }

    public static Info getTemplateInfo(String string, int n) {
        return Template.getTemplateInfo(string, n, null);
    }

    public static Info getTemplateInfo(String string, int n, ErrorLogger errorLogger) {
        Info info = null;
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT name, locked, locked_in_study FROM template WHERE (template_key = " + String.valueOf(n) + ") AND (hidden IS NULL)");
                if (dbConnection.next()) {
                    info = new Info(n, dbConnection.getString(1));
                    info.isLocked = dbConnection.getBoolean(2);
                    info.isLockedInStudy = dbConnection.getBoolean(3);
                }
                DbCore.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                info = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        return info;
    }

    public static ArrayList<KeyedRecord> getTemplateInfoList(String string) {
        return Template.getTemplateInfoList(string, null);
    }

    public static ArrayList<KeyedRecord> getTemplateInfoList(String string, ErrorLogger errorLogger) {
        ArrayList<Info> arrayList = null;
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            try {
                boolean bl;
                boolean bl2 = true;
                arrayList = new ArrayList<Info>();
                do {
                    bl = false;
                    arrayList.clear();
                    if (bl2) {
                        dbConnection.query("SELECT template_key, name, locked, locked_in_study, hidden FROM template WHERE (hidden IS NULL) OR (hidden <= NOW()) ORDER BY 1");
                    } else {
                        dbConnection.query("SELECT template_key, name, locked, locked_in_study FROM template WHERE (hidden IS NULL) ORDER BY 1");
                    }
                    while (dbConnection.next()) {
                        if (bl2 && null != dbConnection.getDate(5)) {
                            bl = true;
                            break;
                        }
                        Info info = new Info(dbConnection.getInt(1), dbConnection.getString(2));
                        info.isLocked = dbConnection.getBoolean(3);
                        info.isLockedInStudy = dbConnection.getBoolean(4);
                        arrayList.add(info);
                    }
                    bl2 = false;
                    if (!bl) continue;
                    Template.checkHiddenTemplates(dbConnection);
                } while (bl);
                DbCore.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                arrayList = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        return arrayList;
    }

    public static void checkHiddenTemplates(DbConnection dbConnection) {
        try {
            dbConnection.update("LOCK TABLES template WRITE");
            dbConnection.query("SELECT template_key FROM template WHERE (hidden IS NOT NULL) AND (hidden <= NOW())  ORDER BY UPPER(name), hidden");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (dbConnection.next()) {
                arrayList.add(dbConnection.getInt(1));
            }
            for (Integer n : arrayList) {
                dbConnection.query("SELECT name FROM template WHERE template_key = " + n);
                dbConnection.next();
                String string = dbConnection.getString(1);
                dbConnection.query("SELECT permanent, template_key FROM template WHERE UPPER(name) = '" + DbConnection.clean(string.toUpperCase()) + "' AND (hidden IS NULL)");
                if (dbConnection.next()) {
                    if (!dbConnection.getBoolean(1)) {
                        int n2 = dbConnection.getInt(2);
                        dbConnection.update("UPDATE template SET name = '" + DbConnection.clean(string) + " " + '#' + n2 + "' WHERE template_key = " + n2);
                    } else {
                        dbConnection.update("UPDATE template SET name = '" + DbConnection.clean(string) + " " + '#' + n + "' WHERE template_key = " + n);
                    }
                }
                dbConnection.update("UPDATE template SET hidden = null WHERE template_key = " + n);
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
    }

    public static boolean checkTemplateName(String string, String string2) {
        return Template.checkTemplateName(string, string2, null, true, null);
    }

    public static boolean checkTemplateName(String string, String string2, ErrorLogger errorLogger) {
        return Template.checkTemplateName(string, string2, null, true, errorLogger);
    }

    public static boolean checkTemplateName(String string, String string2, boolean bl) {
        return Template.checkTemplateName(string, string2, null, bl, null);
    }

    public static boolean checkTemplateName(String string, String string2, boolean bl, ErrorLogger errorLogger) {
        return Template.checkTemplateName(string, string2, null, bl, errorLogger);
    }

    public static boolean checkTemplateName(String string, String string2, String string3) {
        return Template.checkTemplateName(string, string2, string3, true, null);
    }

    public static boolean checkTemplateName(String string, String string2, String string3, ErrorLogger errorLogger) {
        return Template.checkTemplateName(string, string2, string3, true, errorLogger);
    }

    public static boolean checkTemplateName(String string, String string2, String string3, boolean bl, ErrorLogger errorLogger) {
        if (null != string3 && string3.length() > 0 && string2.equalsIgnoreCase(string3)) {
            return true;
        }
        if (0 == string2.length()) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("Please provide a name for the template");
            }
            return false;
        }
        if (string2.length() > 245) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("The template name cannot be more than 245 characters long");
            }
            return false;
        }
        if (string2.contains(String.valueOf('#'))) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("The template name cannot contain the character '#'");
            }
            return false;
        }
        if (string2.equalsIgnoreCase(DEFAULT_TEMPLATE_NAME)) {
            if (null != errorLogger) {
                errorLogger.reportValidationError("That template name cannot be used, please try again");
            }
            return false;
        }
        if (bl) {
            int n = Template.getTemplateKeyForName(string, string2, errorLogger);
            if (n < 0) {
                return false;
            }
            if (n > 0) {
                if (null != errorLogger) {
                    errorLogger.reportValidationError("That template name is already in use, please try again");
                }
                return false;
            }
        }
        return true;
    }

    public static boolean renameTemplate(String string, int n, String string2) {
        return Template.renameTemplate(string, n, string2, null);
    }

    public static boolean renameTemplate(String string, int n, String string2, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        String string3 = null;
        try {
            dbConnection.update("LOCK TABLES template WRITE");
            dbConnection.query("SELECT template_key FROM template WHERE (UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "') AND (template_key <> " + n + ") AND (hidden IS NULL)");
            if (dbConnection.next()) {
                string2 = string2 + " " + '#' + n;
            }
            dbConnection.update("UPDATE template SET name = '" + DbConnection.clean(string2) + "' WHERE (template_key = " + n + ") AND (hidden IS NULL)");
        }
        catch (SQLException sQLException) {
            string3 = "A database error occurred:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string3) {
            if (null != errorLogger) {
                errorLogger.reportError(string3);
            }
            return false;
        }
        return true;
    }

    public static Integer duplicateTemplate(String string, int n, String string2) {
        return Template.duplicateTemplate(string, n, string2, null);
    }

    public static Integer duplicateTemplate(String string, int n, String string2, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        boolean bl = false;
        String string3 = "";
        int n2 = 0;
        try {
            dbConnection.update("LOCK TABLES template WRITE, template_key_sequence WRITE, template_parameter_data WRITE, template_parameter_data AS old_param READ, template_ix_rule WRITE, template_ix_rule AS old_rule READ");
            dbConnection.query("SELECT template_key FROM template WHERE (template_key = " + n + ") AND (hidden IS NULL)");
            if (dbConnection.next()) {
                dbConnection.query("SELECT template_key FROM template WHERE (UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "') AND (hidden IS NULL)");
                boolean bl2 = dbConnection.next();
                dbConnection.update("UPDATE template_key_sequence SET template_key = template_key + 1");
                dbConnection.query("SELECT template_key FROM template_key_sequence");
                dbConnection.next();
                n2 = dbConnection.getInt(1);
                if (bl2) {
                    string2 = string2 + " " + '#' + n2;
                }
                dbConnection.update("INSERT INTO template (template_key, name, permanent, locked, locked_in_study, hidden) VALUES (" + n2 + ", '" + DbConnection.clean(string2) + "', false, false, false, null)");
                dbConnection.update("INSERT INTO template_parameter_data (template_key, parameter_key, value_index, value) SELECT " + n2 + ", old_param.parameter_key, old_param.value_index, old_param.value FROM template_parameter_data AS old_param WHERE old_param.template_key = " + n);
                dbConnection.update("INSERT INTO template_ix_rule (template_key, ix_rule_key, country_key, service_type_key, signal_type_key, undesired_service_type_key, undesired_signal_type_key, channel_delta_key, channel_band_key, frequency_offset, emission_mask_key, distance, required_du, undesired_time) SELECT " + n2 + ", old_rule.ix_rule_key, old_rule.country_key, old_rule.service_type_key, old_rule.signal_type_key, old_rule.undesired_service_type_key, old_rule.undesired_signal_type_key, old_rule.channel_delta_key, old_rule.channel_band_key, old_rule.frequency_offset, old_rule.emission_mask_key, old_rule.distance, old_rule.required_du, old_rule.undesired_time FROM template_ix_rule AS old_rule WHERE old_rule.template_key = " + n);
            } else {
                bl = true;
                string3 = "Template key " + n + "does not exist";
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string3 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            if (bl && n2 > 0) {
                dbConnection.update("DELETE FROM template WHERE template_key = " + n2);
                dbConnection.update("DELETE FROM template_parameter_data WHERE template_key = " + n2);
                dbConnection.update("DELETE FROM template_ix_rule WHERE template_key = " + n2);
            }
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl) {
            if (null != errorLogger) {
                errorLogger.reportError(string3);
            }
            return null;
        }
        return n2;
    }

    public static boolean deleteTemplate(String string, int n) {
        return Template.deleteTemplate(string, n, null);
    }

    public static boolean deleteTemplate(String string, int n, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        boolean bl = false;
        String string2 = "";
        int n2 = 0;
        try {
            dbConnection.update("LOCK TABLES template WRITE, template_parameter_data WRITE, template_ix_rule WRITE, study WRITE");
            dbConnection.query("SELECT COUNT(*) FROM study WHERE (template_key = " + n + ")");
            dbConnection.next();
            n2 = dbConnection.getInt(1);
            if (0 == n2) {
                dbConnection.query("SELECT permanent FROM template WHERE (template_key = " + n + ") AND (hidden IS NULL)");
                if (dbConnection.next()) {
                    if (!dbConnection.getBoolean(1)) {
                        dbConnection.update("DELETE FROM template WHERE template_key = " + n);
                        dbConnection.update("DELETE FROM template_parameter_data WHERE template_key = " + n);
                        dbConnection.update("DELETE FROM template_ix_rule WHERE template_key = " + n);
                    } else {
                        bl = true;
                        string2 = "The template is marked permanent and cannot be deleted";
                    }
                }
            } else {
                bl = true;
                string2 = "The template is still in use and cannot be deleted";
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl && null != errorLogger) {
            errorLogger.reportError(string2);
        }
        return !bl;
    }

    public static class Info
    extends KeyedRecord {
        public boolean isLocked;
        public boolean isLockedInStudy;

        public Info(int n, String string) {
            super(n, string);
        }
    }
}

