/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.IxRule;
import gov.fcc.tvstudy.core.data.Parameter;
import gov.fcc.tvstudy.core.data.Scenario;
import gov.fcc.tvstudy.core.data.Source;
import gov.fcc.tvstudy.core.data.SourceFM;
import gov.fcc.tvstudy.core.data.SourceTV;
import gov.fcc.tvstudy.core.data.SourceWL;
import gov.fcc.tvstudy.core.geo.Geography;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

public class Study
extends KeyedRecord {
    public static final int STUDY_TYPE_TV = 1;
    public static final int STUDY_TYPE_TV_IX = 2;
    public static final int STUDY_TYPE_TV_OET74 = 3;
    public static final int STUDY_TYPE_FM = 4;
    public static final int STUDY_TYPE_TV6_FM = 5;
    public static final int STUDY_MODE_GRID = 1;
    public static final int STUDY_MODE_POINTS = 2;
    public static final int STUDY_AREA_SERVICE = 1;
    public static final int STUDY_AREA_GEOGRAPHY = 2;
    public static final int STUDY_AREA_NO_BOUNDS = 3;
    public static final int LOCK_NONE = 0;
    public static final int LOCK_EDIT = 1;
    public static final int LOCK_RUN_EXCL = 2;
    public static final int LOCK_RUN_SHARE = 3;
    public static final int LOCK_ADMIN = 4;
    public static final String DEFAULT_STUDY_NAME = "Study";
    public final String dbID;
    public final String description;
    public final int studyType;
    public final int studyMode;
    public final int templateKey;
    public final String templateName;
    public final boolean templateLocked;
    public final Integer extDbKey;
    public final int pointSetKey;
    public final int propagationModel;
    public final int studyAreaMode;
    public final int studyAreaGeoKey;
    public final ArrayList<Parameter> parameters;
    public final ArrayList<IxRule> ixRules;
    public final ArrayList<Source> sources;
    public final ArrayList<Scenario> scenarios;
    public final ArrayList<Scenario.ScenarioPair> scenarioPairs;
    public final ArrayList<Parameter> scenarioParameters;
    public final String reportPreamble;
    public final String fileOutputConfigName;
    public final String fileOutputConfigCodes;
    public final String mapOutputConfigName;
    public final String mapOutputConfigCodes;
    public final String outDirectory;
    public int studyLock;
    public int lockCount;
    public final String created;
    public final String modified;
    public final String lastRun;
    public final int modCount;
    public int maxIxRuleKey;
    public int maxScenarioKey;

    public static String getStudyTypeName(int n) {
        switch (n) {
            case 1: {
                return "General-purpose TV";
            }
            case 2: {
                return "TV Interference Check";
            }
            case 3: {
                return "Wireless->TV Interference";
            }
            case 4: {
                return "General-purpose FM";
            }
            case 5: {
                return "TV6<->FM Interference";
            }
        }
        return "???";
    }

    public static ArrayList<KeyedRecord> getStudyTypes() {
        return Study.getStudyTypes(0);
    }

    public static ArrayList<KeyedRecord> getStudyTypes(int n) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        if (0 == n || Study.isRecordTypeAllowed(1, n)) {
            arrayList.add(new KeyedRecord(1, Study.getStudyTypeName(1)));
        }
        if (0 == n || Study.isRecordTypeAllowed(2, n)) {
            arrayList.add(new KeyedRecord(2, Study.getStudyTypeName(2)));
        }
        if (0 == n || Study.isRecordTypeAllowed(3, n)) {
            arrayList.add(new KeyedRecord(3, Study.getStudyTypeName(3)));
        }
        if (0 == n || Study.isRecordTypeAllowed(4, n)) {
            arrayList.add(new KeyedRecord(4, Study.getStudyTypeName(4)));
        }
        if (0 == n || Study.isRecordTypeAllowed(5, n)) {
            arrayList.add(new KeyedRecord(5, Study.getStudyTypeName(5)));
        }
        return arrayList;
    }

    public static int getDefaultRecordType(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 1;
            }
        }
        return 1;
    }

    public static boolean canUsePointsMode(int n) {
        switch (n) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRecordTypeAllowed(int n, int n2) {
        switch (n) {
            case 1: {
                return 1 == n2;
            }
            case 2: {
                return 1 == n2;
            }
            case 3: {
                return 1 == n2 || 2 == n2;
            }
            case 4: {
                return 3 == n2;
            }
            case 5: {
                return 1 == n2 || 3 == n2;
            }
        }
        return false;
    }

    public Study(String string, int n, String string2, String string3, int n2, int n3, int n4, String string4, boolean bl, Integer n5, int n6, int n7, int n8, int n9, ArrayList<Parameter> arrayList, ArrayList<IxRule> arrayList2, ArrayList<Source> arrayList3, ArrayList<Scenario> arrayList4, ArrayList<Scenario.ScenarioPair> arrayList5, ArrayList<Parameter> arrayList6, String string5, String string6, String string7, String string8, String string9, String string10, int n10, int n11, int n12, String string11, String string12, String string13, int n13, int n14) {
        super(n, string2);
        this.dbID = string;
        this.description = string3;
        this.studyType = n2;
        this.studyMode = n3;
        this.templateKey = n4;
        this.templateName = string4;
        this.templateLocked = bl;
        this.extDbKey = n5;
        this.pointSetKey = n6;
        this.propagationModel = n7;
        this.studyAreaMode = n8;
        this.studyAreaGeoKey = n9;
        this.parameters = arrayList;
        this.ixRules = arrayList2;
        this.sources = arrayList3;
        this.scenarios = arrayList4;
        this.scenarioPairs = arrayList5;
        this.scenarioParameters = arrayList6;
        this.reportPreamble = string5;
        this.fileOutputConfigName = string6;
        this.fileOutputConfigCodes = string7;
        this.mapOutputConfigName = string8;
        this.mapOutputConfigCodes = string9;
        this.outDirectory = string10;
        this.studyLock = n10;
        this.lockCount = n11;
        this.created = string11;
        this.modified = string12;
        this.lastRun = string13;
        this.modCount = n12;
        this.maxIxRuleKey = n13;
        this.maxScenarioKey = n14;
    }

    public static Study getStudy(String string, int n) {
        return Study.getStudy(string, n, null);
    }

    public static Study getStudy(String string, int n, ErrorLogger errorLogger) {
        String string2 = DbCore.getDbName(string);
        String string3 = Study.makeDbName(string2, n);
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        Study study = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string4 = "";
        String string5 = String.valueOf(n);
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 3;
        Integer n12 = null;
        try {
            dbConnection.update("LOCK TABLES study WRITE, version WRITE, template WRITE");
            dbConnection.query("SELECT study.name, version.version, study.study_lock, study.lock_count, study.description, study.study_type, study.study_mode, study.template_key, template.name, study.template_locked, study.ext_db_key, study.point_set_key, study.propagation_model, study.study_area_mode, study.study_area_geo_key, study.output_config_file_name, study.output_config_file_codes, study.output_config_map_name, study.output_config_map_codes, study.out_directory, study.report_preamble, study.mod_count, study.created, study.modified, study.last_run FROM study JOIN version JOIN template USING (template_key) WHERE study_key = " + n);
            if (dbConnection.next()) {
                string6 = dbConnection.getString(1);
                string5 = "'" + string6 + "'";
                if (20300012 == dbConnection.getInt(2)) {
                    if (0 == dbConnection.getInt(3)) {
                        n2 = dbConnection.getInt(4);
                        string7 = dbConnection.getString(5);
                        n3 = dbConnection.getInt(6);
                        n4 = dbConnection.getInt(7);
                        n5 = dbConnection.getInt(8);
                        string8 = dbConnection.getString(9);
                        bl3 = dbConnection.getBoolean(10);
                        int n13 = dbConnection.getInt(11);
                        if (n13 > 0) {
                            n12 = n13;
                        }
                        n8 = dbConnection.getInt(12);
                        n6 = dbConnection.getInt(13);
                        n7 = dbConnection.getInt(14);
                        n9 = dbConnection.getInt(15);
                        string10 = dbConnection.getString(16);
                        string11 = dbConnection.getString(17);
                        string12 = dbConnection.getString(18);
                        string13 = dbConnection.getString(19);
                        string14 = dbConnection.getString(20);
                        string9 = dbConnection.getString(21);
                        n10 = dbConnection.getInt(22);
                        String string15 = dbConnection.getString(23);
                        String string16 = dbConnection.getString(24);
                        String string17 = dbConnection.getString(25);
                        dbConnection.update("UPDATE study SET study_lock = 1, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
                        bl2 = true;
                        ++n2;
                        dbConnection.update("UNLOCK TABLES");
                        int n14 = 0;
                        int n15 = 0;
                        dbConnection.query("SELECT MAX(ix_rule_key) FROM " + string3 + ".ix_rule");
                        if (dbConnection.next()) {
                            n14 = dbConnection.getInt(1);
                        }
                        dbConnection.query("SELECT MAX(scenario_key) FROM " + string3 + ".scenario");
                        if (dbConnection.next()) {
                            n15 = dbConnection.getInt(1);
                        }
                        ArrayList<Parameter> arrayList = Parameter.getDefaultScenarioParameters(dbConnection, string2, n5, n3);
                        ArrayList<Source> arrayList2 = new ArrayList<Source>();
                        SourceTV.getSources(dbConnection, string, string3, arrayList2);
                        SourceWL.getSources(dbConnection, string, string3, arrayList2);
                        SourceFM.getSources(dbConnection, string, string3, arrayList2);
                        study = new Study(string, n, string6, string7, n3, n4, n5, string8, bl3, n12, n8, n6, n7, n9, Parameter.getParameters(dbConnection, string3, string2, n5, n3), IxRule.getIxRules(dbConnection, string3, string2, n5, n3), arrayList2, Scenario.getScenarios(dbConnection, string3, string2, n5, n3, arrayList), Scenario.getScenarioPairs(dbConnection, string3), arrayList, string9, string10, string11, string12, string13, string14, 1, n2, n10, string15, string16, string17, n14, n15);
                    } else {
                        bl = true;
                        string4 = "The study is in use by another application";
                        n11 = 2;
                    }
                } else {
                    bl = true;
                    string4 = "The database version is incorrect";
                }
            } else {
                bl = true;
                string4 = "The study does not exist";
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string4 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
            if (bl && bl2) {
                dbConnection.update("UPDATE " + string2 + ".study SET study_lock = " + 0 + ", lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl) {
            if (null != errorLogger) {
                errorLogger.reportError("Could not open study " + string5 + ":\n" + string4, n11);
            }
            return null;
        }
        return study;
    }

    public static Study getStudy(String string, String string2) {
        return Study.getStudy(string, string2, null);
    }

    public static Study getStudy(String string, String string2, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        boolean bl = false;
        String string3 = "";
        int n = 3;
        int n2 = 0;
        try {
            dbConnection.query("SELECT study_key FROM study WHERE name = '" + DbConnection.clean(string2) + "'");
            if (dbConnection.next()) {
                n2 = dbConnection.getInt(1);
            } else {
                bl = true;
                string3 = "Study name not found";
                n = 2;
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string3 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl) {
            if (null != errorLogger) {
                errorLogger.reportError("Could not open study '" + string2 + "':\n" + string3, n);
            }
            return null;
        }
        return Study.getStudy(string, n2, errorLogger);
    }

    public static Integer createNewStudy(String string, String string2, int n, int n2, Integer n3, Integer n4) {
        return Study.createNewStudy(string, string2, n, n2, n3, n4, null);
    }

    public static Integer createNewStudy(String string, String string2, int n, int n2, Integer n3, Integer n4, ErrorLogger errorLogger) {
        String string3 = DbCore.getDbName(string);
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        string2 = Study.cleanStudyName(string2);
        boolean bl = false;
        boolean bl2 = false;
        String string4 = "";
        int n5 = 0;
        int n6 = 3;
        try {
            dbConnection.update("LOCK TABLES study WRITE, template WRITE, study_key_sequence WRITE, folder WRITE");
            dbConnection.query("SELECT locked_in_study FROM template WHERE template_key = " + n2);
            if (!dbConnection.next()) {
                bl = true;
                string4 = "Template key " + n2 + " does not exist";
            } else {
                bl2 = dbConnection.getBoolean(1);
                dbConnection.update("UPDATE study_key_sequence SET study_key = study_key + 1");
                dbConnection.query("SELECT study_key FROM study_key_sequence");
                dbConnection.next();
                n5 = dbConnection.getInt(1);
                dbConnection.query("SELECT study_key FROM study WHERE UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "'");
                if (dbConnection.next()) {
                    string2 = string2 + " " + '#' + String.valueOf(n5);
                }
                if (null == n4) {
                    n4 = 0;
                } else if (n4 != 0) {
                    dbConnection.query("SELECT folder_key FROM folder WHERE folder_key = " + n4);
                    if (!dbConnection.next()) {
                        n4 = 0;
                    }
                }
                dbConnection.update("INSERT INTO study (study_key, name, description, folder_key, study_lock, lock_count, share_count, study_type, study_mode, needs_update, mod_count, template_key, template_locked, ext_db_key, point_set_key, propagation_model, study_area_mode, study_area_geo_key, output_config_file_name, output_config_file_codes, output_config_map_name, output_config_map_codes, out_directory, report_preamble, parameter_summary, ix_rule_summary, created) VALUES (" + n5 + ", '" + DbConnection.clean(string2) + "', '', " + n4 + ", " + 4 + ", 1, 0, " + n + ", " + 1 + ", false, 0, " + n2 + ", " + bl2 + ", " + (null != n3 ? String.valueOf(n3) : "0") + ", 0, 1, " + 1 + ", 0, '', '', '', '', '" + DbConnection.clean(AppCore.studyOutDirectory) + "', '', '', '', '" + AppCore.formatDateTime(new Date()) + "')");
                dbConnection.update("UNLOCK TABLES");
                String string5 = Study.makeDbName(string3, n5);
                dbConnection.update("CREATE DATABASE " + string5 + " CHARACTER SET latin1");
                Parameter.createTables(dbConnection, string5, string3, n2, n);
                IxRule.createTables(dbConnection, string5, string3, n2, n);
                Scenario.createTables(dbConnection, string5);
                Source.createTables(dbConnection, string5);
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string4 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        catch (Throwable throwable) {
            bl = true;
            string4 = "An unexpected error occurred:\n" + throwable;
            AppCore.log(3, "Unexpected error", throwable);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
            dbConnection.setDatabase(string3);
            if (!bl) {
                dbConnection.update("UPDATE study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n5);
            } else if (n5 > 0) {
                dbConnection.update("DELETE FROM study WHERE study_key = " + n5);
                dbConnection.update("DROP DATABASE IF EXISTS " + Study.makeDbName(string3, n5));
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl) {
            if (null != errorLogger) {
                errorLogger.reportError("Could not create new study:\n" + string4, n6);
            }
            return null;
        }
        return n5;
    }

    public static Integer duplicateStudy(String string, int n, String string2) {
        return Study.duplicateStudy(string, n, string2, null);
    }

    public static Integer duplicateStudy(String string, int n, String string2, ErrorLogger errorLogger) {
        String string3 = DbCore.getDbName(string);
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        string2 = Study.cleanStudyName(string2);
        boolean bl = false;
        boolean bl2 = false;
        String string4 = "";
        String string5 = String.valueOf(n);
        int n2 = 0;
        int n3 = 3;
        try {
            dbConnection.update("LOCK TABLES study WRITE, version WRITE, template WRITE, study_key_sequence WRITE");
            dbConnection.query("SELECT study.name, version.version, study.study_lock, study.lock_count, study.description, study.folder_key, study.study_type, study.study_mode, study.needs_update, study.template_key, study.template_locked, study.ext_db_key, study.point_set_key, study.propagation_model, study.study_area_mode, study.study_area_geo_key, study.output_config_file_name, study.output_config_file_codes, study.output_config_map_name, study.output_config_map_codes, study.out_directory, study.report_preamble, study.parameter_summary, study.ix_rule_summary FROM study JOIN version WHERE study_key = " + n);
            if (dbConnection.next()) {
                string5 = "'" + dbConnection.getString(1) + "'";
                if (20300012 == dbConnection.getInt(2)) {
                    if (0 == dbConnection.getInt(3)) {
                        int n4 = dbConnection.getInt(4);
                        GeographyKeys geographyKeys = new GeographyKeys();
                        String string6 = dbConnection.getString(5);
                        int n5 = dbConnection.getInt(6);
                        int n6 = dbConnection.getInt(7);
                        int n7 = dbConnection.getInt(8);
                        boolean bl3 = dbConnection.getBoolean(9);
                        int n8 = dbConnection.getInt(10);
                        boolean bl4 = dbConnection.getBoolean(11);
                        int n9 = dbConnection.getInt(12);
                        geographyKeys.pointSetKey = dbConnection.getInt(13);
                        int n10 = dbConnection.getInt(14);
                        int n11 = dbConnection.getInt(15);
                        geographyKeys.areaKey = dbConnection.getInt(16);
                        String string7 = dbConnection.getString(17);
                        String string8 = dbConnection.getString(18);
                        String string9 = dbConnection.getString(19);
                        String string10 = dbConnection.getString(20);
                        String string11 = dbConnection.getString(21);
                        String string12 = dbConnection.getString(22);
                        String string13 = dbConnection.getString(23);
                        String string14 = dbConnection.getString(24);
                        dbConnection.update("UPDATE study SET study_lock = 4, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
                        bl2 = true;
                        ++n4;
                        dbConnection.update("UPDATE study_key_sequence SET study_key = study_key + 1");
                        dbConnection.query("SELECT study_key FROM study_key_sequence");
                        dbConnection.next();
                        n2 = dbConnection.getInt(1);
                        dbConnection.update("UNLOCK TABLES");
                        String string15 = Study.makeDbName(string3, n2);
                        String string16 = Study.makeDbName(string3, n);
                        dbConnection.update("CREATE DATABASE " + string15 + " CHARACTER SET latin1");
                        Parameter.copyTables(dbConnection, string15, string16);
                        IxRule.copyTables(dbConnection, string15, string16);
                        Source.copyTables(dbConnection, string15, string16);
                        Scenario.copyTables(dbConnection, string15, string16);
                        dbConnection.query("SHOW TABLES IN " + string16 + " LIKE 'saved_query'");
                        if (dbConnection.next()) {
                            dbConnection.setDatabase(string15);
                            dbConnection.update("CREATE TABLE saved_query (query_key INT NOT NULL PRIMARY KEY, name VARCHAR(255) NOT NULL, description VARCHAR(255) NOT NULL, query MEDIUMTEXT NOT NULL, no_result BOOLEAN NOT NULL)");
                            dbConnection.update("INSERT INTO saved_query (query_key, name, description, query, no_result) SELECT query_key, name, description, query, no_result FROM " + string16 + ".saved_query");
                        }
                        Geography.duplicateStudyGeographies(dbConnection, string3, n2, geographyKeys);
                        dbConnection.setDatabase(string3);
                        dbConnection.update("LOCK TABLES study WRITE");
                        dbConnection.query("SELECT study_lock, lock_count FROM study WHERE study_key = " + n);
                        if (dbConnection.next()) {
                            if (dbConnection.getInt(1) == 4 && dbConnection.getInt(2) == n4) {
                                dbConnection.query("SELECT study_key FROM study WHERE UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "'");
                                if (dbConnection.next()) {
                                    string2 = string2 + " " + '#' + String.valueOf(n2);
                                }
                                dbConnection.update("INSERT INTO study (study_key, name, description, folder_key, study_lock, lock_count, share_count, study_type, study_mode, needs_update, mod_count, template_key, template_locked, ext_db_key, point_set_key, propagation_model, study_area_mode, study_area_geo_key, output_config_file_name, output_config_file_codes, output_config_map_name, output_config_map_codes, out_directory, report_preamble, parameter_summary, ix_rule_summary, created) VALUES (" + n2 + ", '" + DbConnection.clean(string2) + "', '" + DbConnection.clean(string6) + "', " + n5 + ", " + 0 + ", 0, 0, " + n6 + ", " + n7 + ", " + bl3 + ", 0, " + n8 + ", " + bl4 + ", " + n9 + ", " + geographyKeys.pointSetKey + ", " + n10 + ", " + n11 + ", " + geographyKeys.areaKey + ", '" + DbConnection.clean(string7) + "', '" + DbConnection.clean(string8) + "', '" + DbConnection.clean(string9) + "', '" + DbConnection.clean(string10) + "', '" + DbConnection.clean(string11) + "', '" + DbConnection.clean(string12) + "', '" + DbConnection.clean(string13) + "', '" + DbConnection.clean(string14) + "', '" + AppCore.formatDateTime(new Date()) + "')");
                            } else {
                                bl2 = false;
                                bl = true;
                                string4 = "The study lock was modified";
                            }
                        } else {
                            bl2 = false;
                            bl = true;
                            string4 = "The study was deleted";
                        }
                    } else {
                        bl = true;
                        string4 = "The study is in use by another application";
                        n3 = 2;
                    }
                } else {
                    bl = true;
                    string4 = "The database version is incorrect";
                }
            } else {
                bl = true;
                string4 = "The study does not exist";
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string4 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
            dbConnection.setDatabase(string3);
            if (bl2) {
                dbConnection.update("UPDATE study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
            }
            if (bl && n2 > 0) {
                dbConnection.update("DROP DATABASE IF EXISTS " + Study.makeDbName(string3, n2));
                Geography.deleteStudyGeographies(dbConnection, string3, n2, null);
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl) {
            if (null != errorLogger) {
                errorLogger.reportError("Could not duplicate study " + string5 + ":\n" + string4, n3);
            }
            return null;
        }
        return n2;
    }

    private static String cleanStudyName(String string) {
        if (null == string) {
            return DEFAULT_STUDY_NAME;
        }
        int n = (string = string.trim()).length();
        if (0 == n) {
            return DEFAULT_STUDY_NAME;
        }
        if (n > 245) {
            n = 245;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean bl2 = false;
            for (char c2 : DbCore.NAME_RESERVED_CHARS) {
                if (c2 != c) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                stringBuilder.append('_');
                bl = false;
                continue;
            }
            stringBuilder.append(c);
            if (!bl || Character.isDigit(c)) continue;
            bl = false;
        }
        if (bl) {
            if (n == 245) {
                stringBuilder.deleteCharAt(n - 1);
            }
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    public static boolean deleteStudy(String string, int n) {
        return Study.deleteStudy(string, n, 0, null);
    }

    public static boolean deleteStudy(String string, int n, int n2) {
        return Study.deleteStudy(string, n, n2, null);
    }

    public static boolean deleteStudy(String string, int n, ErrorLogger errorLogger) {
        return Study.deleteStudy(string, n, 0, errorLogger);
    }

    public static boolean deleteStudy(String string, int n, int n2, ErrorLogger errorLogger) {
        String string2 = DbCore.getDbName(string);
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        boolean bl = false;
        String string3 = "";
        String string4 = String.valueOf(n);
        int n3 = 3;
        try {
            dbConnection.update("LOCK TABLES study WRITE, study_geography WRITE");
            dbConnection.query("SELECT name, study_lock, lock_count FROM study WHERE study_key = " + n);
            if (dbConnection.next()) {
                string4 = "'" + dbConnection.getString(1) + "'";
                if (0 == n2 && 0 == dbConnection.getInt(2) || dbConnection.getInt(3) == n2) {
                    dbConnection.update("DELETE FROM study WHERE study_key = " + n);
                    dbConnection.update("DELETE FROM study_geography WHERE study_key = " + n);
                    dbConnection.update("UNLOCK TABLES");
                    dbConnection.update("DROP DATABASE IF EXISTS " + Study.makeDbName(string2, n));
                    Geography.deleteStudyGeographies(dbConnection, string2, n, null);
                } else {
                    bl = true;
                    string3 = "The study is in use by another application";
                    n3 = 2;
                }
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string3 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl) {
            if (null != errorLogger) {
                errorLogger.reportError("Could not delete study " + string4 + ":\n" + string3, n3);
            }
            return false;
        }
        AppCore.deleteStudyCache(string, n);
        return true;
    }

    public static boolean unlockStudy(String string, int n, int n2) {
        return Study.unlockStudy(string, n, n2, null);
    }

    public static boolean unlockStudy(String string, int n, int n2, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        boolean bl = false;
        String string2 = "";
        String string3 = String.valueOf(n);
        int n3 = 3;
        try {
            dbConnection.update("LOCK TABLES study WRITE");
            dbConnection.query("SELECT name, study_lock, lock_count, share_count FROM study WHERE study_key = " + n);
            if (dbConnection.next()) {
                string3 = "'" + dbConnection.getString(1) + "'";
                int n4 = dbConnection.getInt(2);
                int n5 = dbConnection.getInt(3);
                int n6 = dbConnection.getInt(4);
                if (0 != n4) {
                    if (0 == n2) {
                        dbConnection.update("UPDATE study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
                    } else if (n5 == n2) {
                        if (3 != n4 || n6 <= 1) {
                            dbConnection.update("UPDATE study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
                        } else {
                            dbConnection.update("UPDATE study SET share_count = share_count - 1 WHERE study_key = " + n);
                        }
                    } else {
                        bl = true;
                        string2 = "The study lock ID does not match";
                    }
                }
            } else {
                bl = true;
                string2 = "The study does not exist";
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl) {
            if (null != errorLogger) {
                errorLogger.reportError("Could not unlock study " + string3 + ":\n" + string2, n3);
            }
            return false;
        }
        return true;
    }

    public static String makeDbName(String string, int n) {
        return string + "_" + String.valueOf(n);
    }

    public static int getStudyKeyForName(String string, String string2) {
        return Study.getStudyKeyForName(string, string2, null);
    }

    public static int getStudyKeyForName(String string, String string2, ErrorLogger errorLogger) {
        int n = -1;
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT study_key FROM study WHERE UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "'");
                n = dbConnection.next() ? dbConnection.getInt(1) : 0;
                DbCore.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        return n;
    }

    public static class GeographyKeys {
        public int pointSetKey;
        public int areaKey;
    }
}

