/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.AntPattern;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import java.sql.SQLException;
import java.util.ArrayList;

public abstract class Source
extends KeyedRecord {
    public static final int RECORD_TYPE_TV = 1;
    public static final int RECORD_TYPE_WL = 2;
    public static final int RECORD_TYPE_FM = 3;
    public static final double LATITUDE_MIN = -73.0;
    public static final double LATITUDE_MAX = 73.5;
    public static final double LONGITUDE_MIN = -180.0;
    public static final double LONGITUDE_MAX = 180.0;
    public static final double DISTANCE_MIN = 50.0;
    public static final double DISTANCE_MAX = 200.0;
    public static final double HEIGHT_MIN = -1100.0;
    public static final double HEIGHT_MAX = 10000.0;
    public static final double HEIGHT_DERIVE = -999.0;
    public static final String HEIGHT_DERIVE_LABEL = "(derive)";
    public static final double ERP_MIN = 1.0E-5;
    public static final double ERP_MAX = 5000.0;
    public static final double ERP_DEF = 0.001;
    public static final double TIME_DELAY_MIN = -500.0;
    public static final double TIME_DELAY_MAX = 500.0;
    public static final int MAX_CALL_SIGN_LENGTH = 12;
    public static final int MAX_SECTOR_ID_LENGTH = 3;
    public static final int MAX_CITY_LENGTH = 20;
    public static final int MAX_STATE_LENGTH = 2;
    public static final int MAX_STATUS_LENGTH = 6;
    public static final int MAX_FILE_NUMBER_LENGTH = 255;
    public static final int MAX_PATTERN_NAME_LENGTH = 255;
    public static final int SERVAREA_CONTOUR_DEFAULT = 0;
    public static final int SERVAREA_CONTOUR_FCC = 1;
    public static final int SERVAREA_CONTOUR_LR_PERCENT = 2;
    public static final int SERVAREA_CONTOUR_LR_RUN_ABOVE = 3;
    public static final int SERVAREA_CONTOUR_LR_RUN_BELOW = 4;
    public static final int SERVAREA_GEOGRAPHY_FIXED = 5;
    public static final int SERVAREA_GEOGRAPHY_RELOCATED = 6;
    public static final int SERVAREA_NO_BOUNDS = 7;
    public static final int SERVAREA_CONTOUR_FCC_ADD_DIST = 8;
    public static final int SERVAREA_CONTOUR_FCC_ADD_PCNT = 9;
    public static final int SERVAREA_RADIUS = 10;
    public static final int SERVAREA_CONTOUR_LR_LINE_FIT = 11;
    public static final double SERVAREA_ARGUMENT_MIN = 0.0;
    public static final double SERVAREA_ARGUMENT_MAX = 500.0;
    public static final double SERVAREA_CL_MIN = 0.0;
    public static final double SERVAREA_CL_MAX = 120.0;
    public static final double SERVAREA_CL_DEFAULT = -999.0;
    public static final String SERVAREA_CL_DEFAULT_LABEL = "(default)";
    public static final String TRANSIENT_ATTR_PREFIX = "-";
    public static final String ATTR_SEQUENCE_DATE = "sequenceDate";
    public static final String ATTR_LICENSEE = "licensee";
    public static final String ATTR_IS_SHARING_HOST = "isSharingHost";
    public static final String ATTR_IS_BASELINE = "isBaseline";
    public static final String ATTR_CONTOUR_73_215 = "contour73215";
    public static final String ATTR_FREQUENCY = "frequency";
    public static final String ATTR_IS_PENDING = "-isPending";
    public static final String ATTR_IS_ARCHIVED = "-isArchived";
    public static final String ATTR_IS_SHARING_GUEST = "-isSharingGuest";
    public static final String ATTR_CHANNEL_SHARING_COMMENT = "-channelSharingComment";
    public static final String ATTR_IS_PRE_BASELINE = "-isPreBaseline";
    public static final String ATTR_IS_PROPOSAL = "-isProposal";
    public final String dbID;
    public final String dbName;
    public final int recordType;
    public final Service service;
    public final String callSign;
    public final String city;
    public final String state;
    public final Country country;
    public final String fileNumber;
    public final GeoPoint location;
    public final double heightAMSL;
    public final double actualHeightAMSL;
    public final double overallHAAT;
    public final double actualOverallHAAT;
    public final double peakERP;
    public final String antennaID;
    public final boolean hasHorizontalPattern;
    public final String horizontalPatternName;
    public final double horizontalPatternOrientation;
    public final boolean hasVerticalPattern;
    public final String verticalPatternName;
    public final double verticalPatternElectricalTilt;
    public final double verticalPatternMechanicalTilt;
    public final double verticalPatternMechanicalTiltOrientation;
    public final boolean hasMatrixPattern;
    public final String matrixPatternName;
    public final boolean useGenericVerticalPattern;
    public final boolean isLocked;
    public final Integer userRecordID;
    public final Integer extDbKey;
    public final String extRecordID;
    public final int modCount;
    public final String attributes;

    public static String getRecordTypeName(int n) {
        switch (n) {
            case 1: {
                return "TV";
            }
            case 2: {
                return "Wireless";
            }
            case 3: {
                return "FM";
            }
        }
        return "??";
    }

    public static ArrayList<KeyedRecord> getRecordTypes() {
        return Source.getRecordTypes(0);
    }

    public static ArrayList<KeyedRecord> getRecordTypes(int n) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        if (0 == n || Study.isRecordTypeAllowed(n, 1)) {
            arrayList.add(new KeyedRecord(1, Source.getRecordTypeName(1)));
        }
        if (0 == n || Study.isRecordTypeAllowed(n, 2)) {
            arrayList.add(new KeyedRecord(2, Source.getRecordTypeName(2)));
        }
        if (0 == n || Study.isRecordTypeAllowed(n, 3)) {
            arrayList.add(new KeyedRecord(3, Source.getRecordTypeName(3)));
        }
        return arrayList;
    }

    protected Source(String string, String string2, int n, int n2, String string3, Service service, String string4, String string5, String string6, Country country, String string7, double d, double d2, double d3, double d4, double d5, double d6, double d7, String string8, boolean bl, String string9, double d8, boolean bl2, String string10, double d9, double d10, double d11, boolean bl3, String string11, boolean bl4, boolean bl5, Integer n3, Integer n4, String string12, int n5, String string13) {
        super(n2, string3);
        this.dbID = string;
        this.dbName = string2;
        this.recordType = n;
        this.service = service;
        this.callSign = string4;
        this.city = string5;
        this.state = string6;
        this.country = country;
        this.fileNumber = string7;
        this.location = new GeoPoint();
        this.location.setLatLon(d, d2);
        this.heightAMSL = d3;
        this.actualHeightAMSL = d4;
        this.overallHAAT = d5;
        this.actualOverallHAAT = d6;
        this.peakERP = d7;
        this.antennaID = string8;
        this.hasHorizontalPattern = bl;
        this.horizontalPatternName = string9;
        this.horizontalPatternOrientation = d8;
        this.hasVerticalPattern = bl2;
        this.verticalPatternName = string10;
        this.verticalPatternElectricalTilt = d9;
        this.verticalPatternMechanicalTilt = d10;
        this.verticalPatternMechanicalTiltOrientation = d11;
        this.hasMatrixPattern = bl3;
        this.matrixPatternName = string11;
        this.useGenericVerticalPattern = bl4;
        this.isLocked = bl5;
        this.userRecordID = n3;
        this.extDbKey = n4;
        this.extRecordID = string12;
        this.modCount = n5;
        this.attributes = string13;
    }

    public AntPattern getHorizontalPattern() {
        return this.getHorizontalPattern(null);
    }

    public AntPattern getHorizontalPattern(ErrorLogger errorLogger) {
        if (!this.hasHorizontalPattern) {
            return null;
        }
        ArrayList<AntPattern.AntPoint> arrayList = null;
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.setDatabase(this.dbName);
                dbConnection.query("SELECT azimuth, relative_field FROM source_horizontal_pattern WHERE source_key = " + this.key + " ORDER BY 1");
                arrayList = new ArrayList<AntPattern.AntPoint>();
                while (dbConnection.next()) {
                    arrayList.add(new AntPattern.AntPoint(dbConnection.getDouble(1), dbConnection.getDouble(2)));
                }
                DbCore.releaseDb(dbConnection);
                if (arrayList.isEmpty()) {
                    if (null != errorLogger) {
                        errorLogger.reportError("Azimuth pattern data not found for source " + this.key);
                    }
                    arrayList = null;
                }
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                arrayList = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        if (null == arrayList) {
            return null;
        }
        return new AntPattern(this.dbID, 1, this.horizontalPatternName, arrayList);
    }

    public AntPattern getVerticalPattern() {
        return this.getVerticalPattern(null);
    }

    public AntPattern getVerticalPattern(ErrorLogger errorLogger) {
        if (!this.hasVerticalPattern) {
            return null;
        }
        ArrayList<AntPattern.AntPoint> arrayList = null;
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.setDatabase(this.dbName);
                dbConnection.query("SELECT depression_angle, relative_field FROM source_vertical_pattern WHERE source_key = " + this.key + " ORDER BY 1");
                arrayList = new ArrayList<AntPattern.AntPoint>();
                while (dbConnection.next()) {
                    arrayList.add(new AntPattern.AntPoint(dbConnection.getDouble(1), dbConnection.getDouble(2)));
                }
                DbCore.releaseDb(dbConnection);
                if (arrayList.isEmpty()) {
                    if (null != errorLogger) {
                        errorLogger.reportError("Elevation pattern data not found for source " + this.key);
                    }
                    arrayList = null;
                }
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                arrayList = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        if (null == arrayList) {
            return null;
        }
        return new AntPattern(this.dbID, 2, this.verticalPatternName, arrayList);
    }

    public AntPattern getMatrixPattern() {
        return this.getMatrixPattern(null);
    }

    public AntPattern getMatrixPattern(ErrorLogger errorLogger) {
        if (!this.hasMatrixPattern) {
            return null;
        }
        ArrayList<AntPattern.AntSlice> arrayList = null;
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.setDatabase(this.dbName);
                dbConnection.query("SELECT azimuth, depression_angle, relative_field FROM source_matrix_pattern WHERE source_key = " + this.key + " ORDER BY 1, 2");
                ArrayList<AntPattern.AntPoint> arrayList2 = null;
                double d = -1.0;
                while (dbConnection.next()) {
                    double d2 = dbConnection.getDouble(1);
                    if (d2 != d) {
                        if (null == arrayList) {
                            arrayList = new ArrayList<AntPattern.AntSlice>();
                        }
                        arrayList2 = new ArrayList<AntPattern.AntPoint>();
                        arrayList.add(new AntPattern.AntSlice(d2, arrayList2));
                        d = d2;
                    }
                    arrayList2.add(new AntPattern.AntPoint(dbConnection.getDouble(2), dbConnection.getDouble(3)));
                }
                DbCore.releaseDb(dbConnection);
                if (null == arrayList && null != errorLogger) {
                    errorLogger.reportError("Matrix pattern data not found for source " + this.key);
                }
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                arrayList = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        if (null == arrayList) {
            return null;
        }
        return new AntPattern(this.dbID, this.matrixPatternName, 2, arrayList);
    }

    public static void createTables(DbConnection dbConnection, String string) throws SQLException {
        dbConnection.setDatabase(string);
        dbConnection.update("CREATE TABLE source (source_key INT NOT NULL PRIMARY KEY,record_type INT NOT NULL,needs_update BOOLEAN NOT NULL,mod_count INT NOT NULL,facility_id INT NOT NULL,service_key INT NOT NULL,is_drt BOOLEAN NOT NULL,is_iboc BOOLEAN NOT NULL,station_class INT NOT NULL,call_sign CHAR(12) NOT NULL,sector_id CHAR(3) NOT NULL,channel INT NOT NULL,city CHAR(20) NOT NULL,state CHAR(2) NOT NULL,country_key INT NOT NULL,zone_key INT NOT NULL,status CHAR(6) NOT NULL,file_number VARCHAR(255) NOT NULL,signal_type_key INT NOT NULL,frequency_offset_key INT NOT NULL,emission_mask_key INT NOT NULL,latitude DOUBLE NOT NULL,longitude DOUBLE NOT NULL,dts_maximum_distance DOUBLE NOT NULL,dts_sectors VARCHAR(5000) NOT NULL,height_amsl FLOAT NOT NULL,actual_height_amsl FLOAT NOT NULL,height_agl DOUBLE NOT NULL,overall_haat FLOAT NOT NULL,actual_overall_haat FLOAT NOT NULL,peak_erp FLOAT NOT NULL,contour_erp DOUBLE NOT NULL,iboc_fraction FLOAT NOT NULL,antenna_id VARCHAR(255),has_horizontal_pattern BOOLEAN NOT NULL,horizontal_pattern_name VARCHAR(255) NOT NULL,horizontal_pattern_orientation FLOAT NOT NULL,has_vertical_pattern BOOLEAN NOT NULL,vertical_pattern_name VARCHAR(255) NOT NULL,vertical_pattern_electrical_tilt FLOAT NOT NULL,vertical_pattern_mechanical_tilt FLOAT NOT NULL,vertical_pattern_mechanical_tilt_orientation FLOAT NOT NULL,has_matrix_pattern BOOLEAN NOT NULL,matrix_pattern_name VARCHAR(255) NOT NULL,use_generic_vertical_pattern BOOLEAN NOT NULL,site_number INT NOT NULL,locked BOOLEAN NOT NULL,user_record_id INT NOT NULL,ext_db_key INT NOT NULL,ext_record_id VARCHAR(255),original_source_key INT NOT NULL,parent_source_key INT NOT NULL,service_area_mode INT NOT NULL,service_area_arg DOUBLE NOT NULL,service_area_cl DOUBLE NOT NULL,service_area_key INT NOT NULL,dts_time_delay DOUBLE NOT NULL,attributes VARCHAR(20000) NOT NULL DEFAULT '')");
        dbConnection.update("CREATE TABLE source_horizontal_pattern (source_key INT NOT NULL,azimuth FLOAT NOT NULL,relative_field FLOAT NOT NULL,INDEX (source_key))");
        dbConnection.update("CREATE TABLE source_vertical_pattern (source_key INT NOT NULL,depression_angle FLOAT NOT NULL,relative_field FLOAT NOT NULL,INDEX (source_key))");
        dbConnection.update("CREATE TABLE source_matrix_pattern (source_key INT NOT NULL,azimuth FLOAT NOT NULL,depression_angle FLOAT NOT NULL,relative_field FLOAT NOT NULL,INDEX (source_key))");
    }

    public static void copyTables(DbConnection dbConnection, String string, String string2) throws SQLException {
        Source.createTables(dbConnection, string);
        dbConnection.update("INSERT INTO source (source_key,record_type,needs_update,mod_count,facility_id,service_key,is_drt,is_iboc,station_class,call_sign,sector_id,channel,city,state,country_key,zone_key,status,file_number,signal_type_key,frequency_offset_key,emission_mask_key,latitude,longitude,dts_maximum_distance,dts_sectors,height_amsl,actual_height_amsl,height_agl,overall_haat,actual_overall_haat,peak_erp,contour_erp,iboc_fraction,antenna_id,has_horizontal_pattern,horizontal_pattern_name,horizontal_pattern_orientation,has_vertical_pattern,vertical_pattern_name,vertical_pattern_electrical_tilt,vertical_pattern_mechanical_tilt,vertical_pattern_mechanical_tilt_orientation,has_matrix_pattern,matrix_pattern_name,use_generic_vertical_pattern,site_number,locked,user_record_id,ext_db_key,ext_record_id,original_source_key,parent_source_key,service_area_mode,service_area_arg,service_area_cl,service_area_key,dts_time_delay,attributes) SELECT source_key,record_type,needs_update,mod_count,facility_id,service_key,is_drt,is_iboc,station_class,call_sign,sector_id,channel,city,state,country_key,zone_key,status,file_number,signal_type_key,frequency_offset_key,emission_mask_key,latitude,longitude,dts_maximum_distance,dts_sectors,height_amsl,actual_height_amsl,height_agl,overall_haat,actual_overall_haat,peak_erp,contour_erp,iboc_fraction,antenna_id,has_horizontal_pattern,horizontal_pattern_name,horizontal_pattern_orientation,has_vertical_pattern,vertical_pattern_name,vertical_pattern_electrical_tilt,vertical_pattern_mechanical_tilt,vertical_pattern_mechanical_tilt_orientation,has_matrix_pattern,matrix_pattern_name,use_generic_vertical_pattern,site_number,locked,user_record_id,ext_db_key,ext_record_id,original_source_key,parent_source_key,service_area_mode,service_area_arg,service_area_cl,service_area_key,dts_time_delay,attributes FROM " + string2 + ".source");
        dbConnection.update("INSERT INTO source_horizontal_pattern (source_key,azimuth,relative_field) SELECT source_key,azimuth,relative_field FROM " + string2 + ".source_horizontal_pattern");
        dbConnection.update("INSERT INTO source_vertical_pattern (source_key,depression_angle,relative_field) SELECT source_key,depression_angle,relative_field FROM " + string2 + ".source_vertical_pattern");
        dbConnection.update("INSERT INTO source_matrix_pattern (source_key,azimuth,depression_angle,relative_field) SELECT source_key,azimuth,depression_angle,relative_field FROM " + string2 + ".source_matrix_pattern");
    }
}

