/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.KeyedRecord;
import java.sql.SQLException;
import java.util.ArrayList;

public class SignalType
extends KeyedRecord {
    private static SignalType nullObject = new SignalType(0, "(n/a)");
    private static SignalType invalidObject = new SignalType(-1, "???");
    private static SignalType defaultObject = nullObject;
    private static ArrayList<SignalType> recordCache = new ArrayList();

    public SignalType(int n, String string) {
        super(n, string);
    }

    public static SignalType getSignalType(int n) {
        if (0 == n) {
            return nullObject;
        }
        for (SignalType signalType : recordCache) {
            if (n != signalType.key) continue;
            return signalType;
        }
        return nullObject;
    }

    public static SignalType getNullObject() {
        return nullObject;
    }

    public static SignalType getDefaultObject() {
        return defaultObject;
    }

    public static ArrayList<KeyedRecord> getSignalTypes() {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        for (SignalType signalType : recordCache) {
            arrayList.add(signalType);
        }
        return arrayList;
    }

    public static ArrayList<SignalType> getAllSignalTypes() {
        return new ArrayList<SignalType>(recordCache);
    }

    public static boolean hasMultipleOptions() {
        return recordCache.size() > 1;
    }

    public static void loadCache(DbConnection dbConnection) throws SQLException {
        recordCache.clear();
        dbConnection.query("SELECT signal_type_key, name, is_default FROM signal_type ORDER BY 1");
        while (dbConnection.next()) {
            SignalType signalType = new SignalType(dbConnection.getInt(1), dbConnection.getString(2));
            if (dbConnection.getBoolean(3)) {
                defaultObject = signalType;
            }
            recordCache.add(signalType);
        }
    }
}

