/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.KeyedRecord;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class ServiceType
extends KeyedRecord {
    public static final int SERVTYPE_DTV_FULL = 1;
    public static final int SERVTYPE_NTSC_FULL = 2;
    public static final int SERVTYPE_DTV_CLASS_A = 3;
    public static final int SERVTYPE_NTSC_CLASS_A = 4;
    public static final int SERVTYPE_DTV_LPTV = 5;
    public static final int SERVTYPE_NTSC_LPTV = 6;
    public static final int SERVTYPE_WIRELESS = 11;
    public static final int SERVTYPE_FM_FULL = 21;
    public static final int SERVTYPE_FM_LP = 22;
    public static final int SERVTYPE_FM_TX = 23;
    public final int recordType;
    public final boolean digital;
    public final boolean needsEmissionMask;
    private static ServiceType invalidObject = new ServiceType(-1, "???", 0, false, false);
    private static ArrayList<ServiceType> recordCache = new ArrayList();
    private static HashMap<Integer, ServiceType> recordKeyCache = new HashMap();

    public ServiceType(int n, String string, int n2, boolean bl, boolean bl2) {
        super(n, string);
        this.recordType = n2;
        this.digital = bl;
        this.needsEmissionMask = bl2;
    }

    public static ServiceType getServiceType(int n) {
        return recordKeyCache.get(n);
    }

    public static ServiceType getInvalidObject() {
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getServiceTypes() {
        return ServiceType.getServiceTypes(0);
    }

    public static ArrayList<KeyedRecord> getServiceTypes(int n) {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        for (ServiceType serviceType : recordCache) {
            if (0 != n && serviceType.recordType != n) continue;
            arrayList.add(serviceType);
        }
        return arrayList;
    }

    public static ArrayList<ServiceType> getAllServiceTypes() {
        return new ArrayList<ServiceType>(recordCache);
    }

    public static void loadCache(DbConnection dbConnection) throws SQLException {
        recordCache.clear();
        recordKeyCache.clear();
        dbConnection.query("SELECT service_type_key, name, record_type, digital, needs_emission_mask FROM service_type ORDER BY 1");
        while (dbConnection.next()) {
            ServiceType serviceType = new ServiceType(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getInt(3), dbConnection.getBoolean(4), dbConnection.getBoolean(5));
            recordCache.add(serviceType);
            recordKeyCache.put(serviceType.key, serviceType);
        }
    }
}

