/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.Parameter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class Scenario
extends KeyedRecord {
    public static final int SCENARIO_TYPE_DEFAULT = 1;
    public static final int SCENARIO_TYPE_TVIX_PROPOSAL = 2;
    public static final int SCENARIO_TYPE_TVIX_INTERFERENCE = 3;
    public final String description;
    public final int scenarioType;
    public final boolean isPermanent;
    public final ArrayList<Parameter> parameters;
    public final ArrayList<SourceListItem> sourceList;
    public final Integer parentScenarioKey;
    public final ArrayList<Scenario> childScenarios;

    public Scenario(int n, String string, String string2, int n2, boolean bl, ArrayList<Parameter> arrayList, ArrayList<SourceListItem> arrayList2, Integer n3, ArrayList<Scenario> arrayList3) {
        super(n, string);
        this.description = string2;
        this.scenarioType = n2;
        this.isPermanent = bl;
        this.parameters = arrayList;
        this.sourceList = arrayList2;
        this.parentScenarioKey = n3;
        this.childScenarios = arrayList3;
    }

    public static ArrayList<Scenario> getScenarios(DbConnection dbConnection, String string, String string2, int n, int n2, ArrayList<Parameter> arrayList) throws SQLException {
        ArrayList<Parameter> arrayList2;
        Integer n3;
        dbConnection.setDatabase(string);
        dbConnection.query("SELECT scenario_key, source_key, is_desired, is_undesired, is_permanent FROM scenario_source ORDER BY 1, 2");
        HashMap<Integer, ArrayList> hashMap = new HashMap<Integer, ArrayList>();
        int n4 = 0;
        ArrayList arrayList3 = null;
        while (dbConnection.next()) {
            int n5 = dbConnection.getInt(1);
            if (n5 != n4) {
                arrayList3 = new ArrayList();
                hashMap.put(n5, arrayList3);
                n4 = n5;
            }
            arrayList3.add(new SourceListItem(dbConnection.getInt(2), dbConnection.getBoolean(3), dbConnection.getBoolean(4), dbConnection.getBoolean(5)));
        }
        HashMap<Integer, ArrayList<Parameter>> hashMap2 = Parameter.getScenarioParameters(dbConnection, string, string2, n, n2);
        dbConnection.setDatabase(string);
        HashMap hashMap3 = new HashMap();
        dbConnection.query("SELECT scenario_key, name, description, scenario_type, is_permanent, parent_scenario_key FROM scenario WHERE parent_scenario_key <> 0 ORDER BY 6, 1");
        int n6 = 0;
        ArrayList<Scenario> arrayList4 = null;
        while (dbConnection.next()) {
            int n7;
            n3 = dbConnection.getInt(1);
            arrayList3 = (ArrayList)hashMap.get(n3);
            if (null == arrayList3) continue;
            arrayList2 = hashMap2.get(n3);
            if (null == arrayList2) {
                arrayList2 = arrayList;
            }
            if ((n7 = dbConnection.getInt(6)) != n6) {
                arrayList4 = new ArrayList<Scenario>();
                hashMap3.put(n7, arrayList4);
                n6 = n7;
            }
            arrayList4.add(new Scenario(n3, dbConnection.getString(2), dbConnection.getString(3), dbConnection.getInt(4), dbConnection.getBoolean(5), arrayList2, arrayList3, n7, null));
        }
        ArrayList<Scenario> arrayList5 = new ArrayList<Scenario>();
        dbConnection.setDatabase(string);
        dbConnection.query("SELECT scenario_key, name, description, scenario_type, is_permanent FROM scenario WHERE parent_scenario_key = 0 ORDER BY 1");
        while (dbConnection.next()) {
            n3 = dbConnection.getInt(1);
            arrayList3 = (ArrayList)hashMap.get(n3);
            if (null == arrayList3) continue;
            arrayList2 = hashMap2.get(n3);
            if (null == arrayList2) {
                arrayList2 = arrayList;
            }
            arrayList5.add(new Scenario(n3, dbConnection.getString(2), dbConnection.getString(3), dbConnection.getInt(4), dbConnection.getBoolean(5), arrayList2, arrayList3, null, (ArrayList)hashMap3.get(n3)));
        }
        return arrayList5;
    }

    public static ArrayList<ScenarioPair> getScenarioPairs(DbConnection dbConnection, String string) throws SQLException {
        ArrayList<ScenarioPair> arrayList = new ArrayList<ScenarioPair>();
        dbConnection.setDatabase(string);
        dbConnection.query("SELECT name, description, scenario_key_a, source_key_a, scenario_key_b, source_key_b FROM scenario_pair ORDER BY 1");
        while (dbConnection.next()) {
            arrayList.add(new ScenarioPair(dbConnection.getString(1), dbConnection.getString(2), dbConnection.getInt(3), dbConnection.getInt(4), dbConnection.getInt(5), dbConnection.getInt(6)));
        }
        return arrayList;
    }

    public static void createTables(DbConnection dbConnection, String string) throws SQLException {
        dbConnection.setDatabase(string);
        dbConnection.update("CREATE TABLE scenario (scenario_key INT NOT NULL PRIMARY KEY, name VARCHAR(255) NOT NULL, description VARCHAR(10000) NOT NULL, scenario_type INT NOT NULL DEFAULT 1, is_permanent BOOLEAN NOT NULL, parent_scenario_key INT NOT NULL DEFAULT 0)");
        dbConnection.update("CREATE TABLE scenario_source (scenario_key INT NOT NULL, source_key INT NOT NULL, is_desired BOOLEAN NOT NULL, is_undesired BOOLEAN NOT NULL, is_permanent BOOLEAN NOT NULL, PRIMARY KEY (scenario_key, source_key))");
        dbConnection.update("CREATE TABLE scenario_pair (name VARCHAR(255) NOT NULL, description VARCHAR(10000) NOT NULL, scenario_key_a INT NOT NULL, source_key_a INT NOT NULL, scenario_key_b INT NOT NULL, source_key_b INT NOT NULL)");
    }

    public static void copyTables(DbConnection dbConnection, String string, String string2) throws SQLException {
        Scenario.createTables(dbConnection, string);
        dbConnection.update("INSERT INTO scenario (scenario_key, name, description, scenario_type, is_permanent, parent_scenario_key) SELECT scenario_key, name, description, scenario_type, is_permanent, parent_scenario_key FROM " + string2 + ".scenario");
        dbConnection.update("INSERT INTO scenario_source (scenario_key, source_key, is_desired, is_undesired, is_permanent) SELECT scenario_key, source_key, is_desired, is_undesired, is_permanent FROM " + string2 + ".scenario_source");
        dbConnection.update("INSERT INTO scenario_pair (name, description, scenario_key_a, source_key_a, scenario_key_b, source_key_b) SELECT name, description, scenario_key_a, source_key_a, scenario_key_b, source_key_b FROM " + string2 + ".scenario_pair");
    }

    public static class ScenarioPair {
        public final String name;
        public final String description;
        public final int scenarioKeyA;
        public final int sourceKeyA;
        public final int scenarioKeyB;
        public final int sourceKeyB;

        public ScenarioPair(String string, String string2, int n, int n2, int n3, int n4) {
            this.name = string;
            this.description = string2;
            this.scenarioKeyA = n;
            this.sourceKeyA = n2;
            this.scenarioKeyB = n3;
            this.sourceKeyB = n4;
        }
    }

    public static class SourceListItem {
        public final int key;
        public final boolean isDesired;
        public final boolean isUndesired;
        public final boolean isPermanent;

        public SourceListItem(int n, boolean bl, boolean bl2, boolean bl3) {
            this.key = n;
            this.isDesired = bl;
            this.isUndesired = bl2;
            this.isPermanent = bl3;
        }
    }
}

