/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class Parameter
extends KeyedRecord {
    public static final int MAX_VALUE_COUNT = 6;
    public static final int PARAM_GRID_TYPE = 2;
    public static final int PARAM_CELL_SIZE = 4;
    public static final int PARAM_TRUST_DA_FLAG = 18;
    public static final int PARAM_PATH_TERR_RES = 32;
    public static final int PARAM_EARTH_SPH_DIST = 200;
    public static final int PARAM_MAX_DIST = 215;
    public static final int PARAM_CL_VLO_DTV = 80;
    public static final int PARAM_CL_VHI_DTV = 82;
    public static final int PARAM_CL_UHF_DTV = 84;
    public static final int PARAM_CL_VLO_DTV_LP = 86;
    public static final int PARAM_CL_VHI_DTV_LP = 88;
    public static final int PARAM_CL_UHF_DTV_LP = 90;
    public static final int PARAM_CL_VLO_NTSC = 92;
    public static final int PARAM_CL_VHI_NTSC = 94;
    public static final int PARAM_CL_UHF_NTSC = 96;
    public static final int PARAM_CL_VLO_NTSC_LP = 98;
    public static final int PARAM_CL_VHI_NTSC_LP = 100;
    public static final int PARAM_CL_UHF_NTSC_LP = 102;
    public static final int PARAM_USE_DIPOLE_CL = 104;
    public static final int PARAM_DIPOLE_CENTER_CL = 106;
    public static final int PARAM_CURV_DTV = 107;
    public static final int PARAM_CURV_NTSC = 108;
    public static final int PARAM_CL_FM = 357;
    public static final int PARAM_CL_FM_B = 358;
    public static final int PARAM_CL_FM_B1 = 359;
    public static final int PARAM_CL_FM_ED = 360;
    public static final int PARAM_CL_FM_LP = 361;
    public static final int PARAM_CL_FM_TX = 362;
    public static final int PARAM_CURV_FM = 363;
    public static final int PARAM_TV6_FM_DIST = 244;
    public static final int PARAM_TV6_FM_DIST_DTV = 242;
    public static final int PARAM_RUL_EXT_DST_L = 335;
    public static final int PARAM_RUL_EXT_ERP_L = 336;
    public static final int PARAM_RUL_EXT_DST_LM = 337;
    public static final int PARAM_RUL_EXT_ERP_M = 338;
    public static final int PARAM_RUL_EXT_DST_MH = 339;
    public static final int PARAM_RUL_EXT_ERP_H = 340;
    public static final int PARAM_RUL_EXT_DST_H = 210;
    public static final int PARAM_RUL_EXT_MAX = 189;
    public static final int PARAM_CO_CHAN_MX_DIST = 212;
    public static final int PARAM_GEN_VPAT = 219;
    public static final int PARAM_MEX_ERP_D_VLO = 220;
    public static final int PARAM_MEX_HAAT_D_VLO = 221;
    public static final int PARAM_MEX_ERP_D_VHI = 222;
    public static final int PARAM_MEX_HAAT_D_VHI = 223;
    public static final int PARAM_MEX_ERP_D_UHF = 224;
    public static final int PARAM_MEX_HAAT_D_UHF = 225;
    public static final int PARAM_MEX_ERP_N_VLO = 226;
    public static final int PARAM_MEX_HAAT_N_VLO = 227;
    public static final int PARAM_MEX_ERP_N_VHI = 228;
    public static final int PARAM_MEX_HAAT_N_VHI = 229;
    public static final int PARAM_MEX_ERP_N_UHF = 230;
    public static final int PARAM_MEX_HAAT_N_UHF = 231;
    public static final int PARAM_MIN_CHANNEL = 324;
    public static final int PARAM_MAX_CHANNEL = 325;
    public static final int PARAM_DTS_DIST_CHECK = 326;
    public static final int PARAM_MEX_ERP_FM_A = 232;
    public static final int PARAM_MEX_HAAT_FM_A = 233;
    public static final int PARAM_MEX_ERP_FM_B = 234;
    public static final int PARAM_MEX_HAAT_FM_B = 235;
    public static final int PARAM_MEX_ERP_FM_B1 = 236;
    public static final int PARAM_MEX_HAAT_FM_B1 = 237;
    public static final int PARAM_MEX_ERP_FM_C = 238;
    public static final int PARAM_MEX_HAAT_FM_C = 239;
    public static final int PARAM_MEX_ERP_FM_C1 = 240;
    public static final int PARAM_MEX_HAAT_FM_C1 = 241;
    public static final int PARAM_WL_CULL_DIST = 247;
    public static final int PARAM_SCEN_WL_FREQ = 355;
    public static final int PARAM_SCEN_WL_BW = 356;
    public static final int GRID_TYPE_LOCAL = 1;
    public static final int GRID_TYPE_GLOBAL = 2;
    public static final int CURVE_FCC_F50 = 1;
    public static final int CURVE_FCC_F10 = 2;
    public static final int CURVE_FCC_F90 = 3;
    public static final int WL_OVERLAP_COUNT = 6;
    public static final int WL_CULL_HAAT_COUNT = 8;
    public static final double[] wirelessCullHAAT = new double[]{305.0, 200.0, 150.0, 100.0, 80.0, 65.0, 50.0, 35.0};
    public static final int WL_CULL_ERP_COUNT = 9;
    public static final double[] wirelessCullERP = new double[]{5.0, 4.0, 3.0, 2.0, 1.0, 0.75, 0.5, 0.25, 0.1};
    public static final double MIN_CELL_SIZE = 0.1;
    public static final double MAX_CELL_SIZE = 10.0;
    public static final double MIN_PATH_TERR_RES = 1.0;
    public static final double MAX_PATH_TERR_RES = 50.0;
    public final int valueCount;
    public final String[] valueName;
    public final String units;
    public final String[] value;
    public final String[] defaultValue;
    public final String description;
    public final String groupName;
    public final boolean enablesGroup;
    public final boolean isScenario;
    public static final int TYPE_STRING = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_DECIMAL = 3;
    public static final int TYPE_OPTION = 4;
    public static final int TYPE_PICKFROM = 5;
    public static final int TYPE_DATE = 6;
    public final boolean isTable;
    public final String[] tableRowLabels;
    public final String[] tableColumnLabels;
    public final int type;
    public final int minIntegerValue;
    public final int maxIntegerValue;
    public final double minDecimalValue;
    public final double maxDecimalValue;
    public final int decimalPrecision;
    public final ArrayList<KeyedRecord> pickfromItems;
    public final int[][] integerTableValue;
    public final double[][] decimalTableValue;
    public final int[] integerValue;
    public final double[] decimalValue;
    public final boolean[] optionValue;
    public final int[] pickfromIndex;
    public final Date[] dateValue;
    public boolean defaultsApplied;

    public Parameter(int n, String string, String[] stringArray, String string2, String[] stringArray2, String[] stringArray3, String string3, String string4, boolean bl, boolean bl2, boolean bl3, String[] stringArray4, String[] stringArray5, int n2, int n3, int n4, double d, double d2, int n5, ArrayList<KeyedRecord> arrayList, int[][] nArray, double[][] dArray, int[] nArray2, double[] dArray2, boolean[] blArray, int[] nArray3, Date[] dateArray) {
        super(n, string);
        int n6;
        this.valueCount = stringArray.length;
        this.valueName = new String[this.valueCount];
        this.units = string2;
        this.value = new String[this.valueCount];
        this.defaultValue = new String[this.valueCount];
        for (n6 = 0; n6 < this.valueCount; ++n6) {
            this.valueName[n6] = stringArray[n6];
            this.value[n6] = stringArray2[n6];
            this.defaultValue[n6] = stringArray3[n6];
        }
        this.description = string3;
        this.groupName = string4;
        this.enablesGroup = bl && 1 == this.valueCount && 4 == n2;
        this.isScenario = bl2;
        this.isTable = bl3;
        this.tableRowLabels = stringArray4;
        this.tableColumnLabels = stringArray5;
        this.type = n2;
        this.minIntegerValue = n3;
        this.maxIntegerValue = n4;
        this.minDecimalValue = d;
        this.maxDecimalValue = d2;
        this.decimalPrecision = n5;
        this.pickfromItems = arrayList;
        int[][] nArray4 = null;
        double[][] dArray3 = null;
        int[] nArray5 = null;
        double[] dArray4 = null;
        boolean[] blArray2 = null;
        int[] nArray6 = null;
        Date[] dateArray2 = null;
        if (this.isTable) {
            int n7 = this.tableRowLabels.length * this.tableColumnLabels.length;
            switch (this.type) {
                case 2: {
                    nArray4 = new int[this.valueCount][n7];
                    for (n6 = 0; n6 < this.valueCount; ++n6) {
                        for (int i = 0; i < n7; ++i) {
                            nArray4[n6][i] = nArray[n6][i];
                        }
                    }
                    break;
                }
                case 3: {
                    dArray3 = new double[this.valueCount][n7];
                    for (n6 = 0; n6 < this.valueCount; ++n6) {
                        for (int i = 0; i < n7; ++i) {
                            dArray3[n6][i] = dArray[n6][i];
                        }
                    }
                    break;
                }
            }
        } else {
            switch (this.type) {
                case 2: {
                    nArray5 = new int[this.valueCount];
                    for (n6 = 0; n6 < this.valueCount; ++n6) {
                        nArray5[n6] = nArray2[n6];
                    }
                    break;
                }
                case 3: {
                    dArray4 = new double[this.valueCount];
                    for (n6 = 0; n6 < this.valueCount; ++n6) {
                        dArray4[n6] = dArray2[n6];
                    }
                    break;
                }
                case 4: {
                    blArray2 = new boolean[this.valueCount];
                    for (n6 = 0; n6 < this.valueCount; ++n6) {
                        blArray2[n6] = blArray[n6];
                    }
                    break;
                }
                case 5: {
                    nArray5 = new int[this.valueCount];
                    nArray6 = new int[this.valueCount];
                    for (n6 = 0; n6 < this.valueCount; ++n6) {
                        nArray5[n6] = nArray2[n6];
                        nArray6[n6] = nArray3[n6];
                    }
                    break;
                }
                case 6: {
                    dateArray2 = new Date[this.valueCount];
                    for (n6 = 0; n6 < this.valueCount; ++n6) {
                        dateArray2[n6] = dateArray[n6];
                    }
                    break;
                }
            }
        }
        this.integerTableValue = nArray4;
        this.decimalTableValue = dArray3;
        this.integerValue = nArray5;
        this.decimalValue = dArray4;
        this.optionValue = blArray2;
        this.pickfromIndex = nArray6;
        this.dateValue = dateArray2;
    }

    private Parameter copy() {
        return new Parameter(this.key, this.name, this.valueName, this.units, this.value, this.defaultValue, this.description, this.groupName, this.enablesGroup, this.isScenario, this.isTable, this.tableRowLabels, this.tableColumnLabels, this.type, this.minIntegerValue, this.maxIntegerValue, this.minDecimalValue, this.maxDecimalValue, this.decimalPrecision, this.pickfromItems, this.integerTableValue, this.decimalTableValue, this.integerValue, this.decimalValue, this.optionValue, this.pickfromIndex, this.dateValue);
    }

    private Parameter(int n, String string, String string2, String string3, String string4, int n2, boolean bl, String string5, String string6) {
        super(n, string);
        this.units = string2;
        this.description = string3;
        this.groupName = string4;
        this.isScenario = bl;
        boolean bl2 = false;
        String[] stringArray = null;
        String[] stringArray2 = null;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n6 = 0;
        ArrayList<KeyedRecord> arrayList = null;
        String[] stringArray3 = string5.split(":");
        int n7 = stringArray3.length;
        int n8 = 0;
        String string7 = stringArray3[n8++].trim().toLowerCase();
        if (string7.equals("table")) {
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            if (n8 < n7 && stringArray3[n8].length() > 0) {
                try {
                    n9 = Integer.parseInt(stringArray3[n8]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++n8;
                if (n9 > 0) {
                    n11 = n8;
                    if ((n8 += n9) < n7 && stringArray3[n8].length() > 0) {
                        try {
                            n10 = Integer.parseInt(stringArray3[n8]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        ++n8;
                        if (n10 > 0) {
                            n12 = n8;
                            if ((n8 += n10) < n7) {
                                bl2 = true;
                                string7 = stringArray3[n8++].trim().toLowerCase();
                                stringArray = new String[n9];
                                int n13 = 0;
                                int n14 = n11;
                                while (n13 < n9) {
                                    stringArray[n13] = stringArray3[n14];
                                    ++n13;
                                    ++n14;
                                }
                                stringArray2 = new String[n10];
                                n13 = 0;
                                n14 = n12;
                                while (n13 < n10) {
                                    stringArray2[n13] = stringArray3[n14];
                                    ++n13;
                                    ++n14;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (string7.equals("integer")) {
            n3 = 2;
            if (n8 < n7 && stringArray3[n8].length() > 0) {
                try {
                    n4 = Integer.parseInt(stringArray3[n8]);
                }
                catch (NumberFormatException numberFormatException) {
                    n4 = Integer.MIN_VALUE;
                }
                ++n8;
            } else {
                n4 = Integer.MIN_VALUE;
            }
            if (n8 < n7 && stringArray3[n8].length() > 0) {
                try {
                    n5 = Integer.parseInt(stringArray3[n8]);
                }
                catch (NumberFormatException numberFormatException) {
                    n5 = Integer.MAX_VALUE;
                }
                ++n8;
            } else {
                n5 = Integer.MAX_VALUE;
            }
        }
        if (string7.equals("decimal")) {
            n3 = 3;
            if (n8 < n7 && stringArray3[n8].length() > 0) {
                try {
                    d = Double.parseDouble(stringArray3[n8]);
                }
                catch (NumberFormatException numberFormatException) {
                    d = Double.MIN_VALUE;
                }
                ++n8;
            } else {
                d = Double.MIN_VALUE;
            }
            if (n8 < n7 && stringArray3[n8].length() > 0) {
                try {
                    d2 = Double.parseDouble(stringArray3[n8]);
                }
                catch (NumberFormatException numberFormatException) {
                    d2 = Double.MAX_VALUE;
                }
                ++n8;
            } else {
                d2 = Double.MAX_VALUE;
            }
            if (n8 < n7 && stringArray3[n8].length() > 0) {
                try {
                    n6 = Integer.parseInt(stringArray3[n8]);
                }
                catch (NumberFormatException numberFormatException) {
                    n6 = -1;
                }
                ++n8;
            } else {
                n6 = -1;
            }
        }
        if (string7.equals("option")) {
            n3 = 4;
        }
        if (string7.equals("pickfrom")) {
            arrayList = new ArrayList<KeyedRecord>();
            int n15 = 0;
            while (n8 + 1 < n7) {
                try {
                    n15 = Integer.parseInt(stringArray3[n8]);
                }
                catch (NumberFormatException numberFormatException) {
                    n8 += 2;
                    continue;
                }
                arrayList.add(new KeyedRecord(n15, stringArray3[n8 + 1]));
                n8 += 2;
            }
            if (arrayList.isEmpty()) {
                arrayList = null;
            } else {
                n3 = 5;
            }
        }
        if (string7.equals("date")) {
            n3 = 6;
        }
        if (bl2 && 2 != n3 && 3 != n3) {
            bl2 = false;
            stringArray = null;
            stringArray2 = null;
            n3 = 1;
            arrayList = null;
        }
        this.valueName = string6.split(":");
        this.valueCount = this.valueName.length;
        this.value = new String[this.valueCount];
        this.defaultValue = new String[this.valueCount];
        this.enablesGroup = n == n2 && 1 == this.valueCount && 4 == n3;
        this.isTable = bl2;
        this.tableRowLabels = stringArray;
        this.tableColumnLabels = stringArray2;
        this.type = n3;
        this.minIntegerValue = n4;
        this.maxIntegerValue = n5;
        this.minDecimalValue = d;
        this.maxDecimalValue = d2;
        this.decimalPrecision = n6;
        this.pickfromItems = arrayList;
        this.defaultsApplied = false;
        int[][] nArray = null;
        double[][] dArray = null;
        int[] nArray2 = null;
        double[] dArray2 = null;
        boolean[] blArray = null;
        int[] nArray3 = null;
        Date[] dateArray = null;
        if (this.isTable) {
            int n16 = this.tableRowLabels.length * this.tableColumnLabels.length;
            switch (this.type) {
                case 2: {
                    nArray = new int[this.valueCount][n16];
                    break;
                }
                case 3: {
                    dArray = new double[this.valueCount][n16];
                }
            }
        } else {
            switch (this.type) {
                case 2: {
                    nArray2 = new int[this.valueCount];
                    break;
                }
                case 3: {
                    dArray2 = new double[this.valueCount];
                    break;
                }
                case 4: {
                    blArray = new boolean[this.valueCount];
                    break;
                }
                case 5: {
                    nArray2 = new int[this.valueCount];
                    nArray3 = new int[this.valueCount];
                    break;
                }
                case 6: {
                    dateArray = new Date[this.valueCount];
                }
            }
        }
        this.integerTableValue = nArray;
        this.decimalTableValue = dArray;
        this.integerValue = nArray2;
        this.decimalValue = dArray2;
        this.optionValue = blArray;
        this.pickfromIndex = nArray3;
        this.dateValue = dateArray;
    }

    private boolean checkValues() {
        int n;
        for (n = 0; n < this.valueCount; ++n) {
            if (null != this.defaultValue[n]) continue;
            return false;
        }
        if (this.valueCount > 1 && null != this.value[0] && null == this.value[1]) {
            for (n = 2; n < this.valueCount && null == this.value[n]; ++n) {
            }
            if (n >= this.valueCount) {
                for (n = 1; n < this.valueCount; ++n) {
                    this.value[n] = this.value[0];
                }
                this.defaultsApplied = true;
            }
        }
        for (n = 0; n < this.valueCount && null != this.value[n]; ++n) {
        }
        if (n < this.valueCount) {
            for (n = 0; n < this.valueCount; ++n) {
                this.value[n] = this.defaultValue[n];
            }
            this.defaultsApplied = true;
        }
        if (this.isTable) {
            int n2 = this.tableRowLabels.length * this.tableColumnLabels.length;
            for (n = 0; n < this.valueCount; ++n) {
                String[] stringArray = this.value[n].split(",");
                if (stringArray.length < n2) {
                    return false;
                }
                block27: for (int i = 0; i < n2; ++i) {
                    switch (this.type) {
                        case 2: {
                            try {
                                this.integerTableValue[n][i] = Integer.parseInt(stringArray[i]);
                                continue block27;
                            }
                            catch (NumberFormatException numberFormatException) {
                                return false;
                            }
                        }
                        case 3: {
                            try {
                                this.decimalTableValue[n][i] = Double.parseDouble(stringArray[i]);
                                continue block27;
                            }
                            catch (NumberFormatException numberFormatException) {
                                return false;
                            }
                        }
                    }
                }
            }
        } else {
            block28: for (n = 0; n < this.valueCount; ++n) {
                switch (this.type) {
                    case 2: {
                        try {
                            this.integerValue[n] = Integer.parseInt(this.value[n]);
                            continue block28;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return false;
                        }
                    }
                    case 3: {
                        try {
                            this.decimalValue[n] = Double.parseDouble(this.value[n]);
                            continue block28;
                        }
                        catch (NumberFormatException numberFormatException) {
                            return false;
                        }
                    }
                    case 4: {
                        this.optionValue[n] = this.value[n].equals("1");
                        continue block28;
                    }
                    case 5: {
                        int n3;
                        try {
                            this.integerValue[n] = Integer.parseInt(this.value[n]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            return false;
                        }
                        for (n3 = this.pickfromItems.size() - 1; n3 > 0 && this.integerValue[n] != this.pickfromItems.get((int)n3).key; --n3) {
                        }
                        this.pickfromIndex[n] = n3;
                        continue block28;
                    }
                    case 6: {
                        if (this.value[n].length() <= 0) continue block28;
                        this.dateValue[n] = AppCore.parseDate(this.value[n]);
                        if (null != this.dateValue[n]) continue block28;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public static ArrayList<Parameter> getParameters(DbConnection dbConnection, String string, String string2, int n, int n2) throws SQLException {
        int n3;
        Parameter parameter;
        dbConnection.setDatabase(string2);
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        HashMap<Integer, Parameter> hashMap = new HashMap<Integer, Parameter>();
        String string3 = "";
        if (null != string) {
            string3 = "JOIN parameter_study_type USING (parameter_key) WHERE (parameter_study_type.study_type = " + n2 + ") AND NOT parameter.is_scenario_parameter ";
        }
        dbConnection.query("SELECT parameter.parameter_key, parameter.name, parameter.units, parameter.description, parameter_group.name, parameter_group.enabling_parameter_key, parameter.is_scenario_parameter, parameter.type, parameter.value_list FROM parameter JOIN parameter_group USING (group_key) " + string3 + "ORDER BY parameter_group.list_order, parameter.list_order");
        while (dbConnection.next()) {
            int n4 = dbConnection.getInt(1);
            parameter = new Parameter(n4, dbConnection.getString(2), dbConnection.getString(3), dbConnection.getString(4), dbConnection.getString(5), dbConnection.getInt(6), dbConnection.getBoolean(7), dbConnection.getString(8), dbConnection.getString(9));
            arrayList.add(parameter);
            hashMap.put(n4, parameter);
        }
        if (null != string) {
            dbConnection.setDatabase(string);
            dbConnection.query("SELECT parameter_key, value_index, value FROM parameter_data");
            while (dbConnection.next()) {
                parameter = (Parameter)hashMap.get(dbConnection.getInt(1));
                if (null == parameter || (n3 = dbConnection.getInt(2)) < 0 || n3 >= parameter.valueCount) continue;
                parameter.value[n3] = dbConnection.getString(3);
            }
        }
        dbConnection.setDatabase(string2);
        dbConnection.query("SELECT parameter_key, value_index, value FROM template_parameter_data WHERE template_key = " + n);
        while (dbConnection.next()) {
            parameter = (Parameter)hashMap.get(dbConnection.getInt(1));
            if (null == parameter || (n3 = dbConnection.getInt(2)) < 0 || n3 >= parameter.valueCount) continue;
            if (null == string) {
                parameter.value[n3] = dbConnection.getString(3);
                continue;
            }
            parameter.defaultValue[n3] = dbConnection.getString(3);
        }
        if (n > 1 || null == string) {
            dbConnection.query("SELECT parameter_key, value_index, value FROM template_parameter_data WHERE template_key = 1");
            while (dbConnection.next()) {
                parameter = (Parameter)hashMap.get(dbConnection.getInt(1));
                if (null == parameter || (n3 = dbConnection.getInt(2)) < 0 || n3 >= parameter.valueCount || null != parameter.defaultValue[n3]) continue;
                parameter.defaultValue[n3] = dbConnection.getString(3);
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            if (parameter.checkValues()) continue;
            iterator.remove();
        }
        return arrayList;
    }

    public static HashMap<Integer, ArrayList<Parameter>> getScenarioParameters(DbConnection dbConnection, String string, String string2, int n, int n2) throws SQLException {
        HashMap<Integer, ArrayList<Parameter>> hashMap = new HashMap<Integer, ArrayList<Parameter>>();
        HashMap<Integer, Parameter> hashMap2 = Parameter.getScenarioParameterMap(dbConnection, string2, n, n2);
        if (hashMap2.isEmpty()) {
            return hashMap;
        }
        dbConnection.setDatabase(string);
        dbConnection.query("SELECT scenario.scenario_key, parameter.parameter_key, scenario_parameter_data.value_index, scenario_parameter_data.value FROM scenario JOIN " + string2 + ".parameter JOIN " + string2 + ".parameter_study_type USING (parameter_key) LEFT JOIN scenario_parameter_data ON ((scenario_parameter_data.scenario_key = scenario.scenario_key)  AND (scenario_parameter_data.parameter_key = parameter.parameter_key)) WHERE (parameter_study_type.study_type = " + n2 + ") AND parameter.is_scenario_parameter ORDER BY 1, 2, 3");
        int n3 = 0;
        int n4 = 0;
        ArrayList<Parameter> arrayList = null;
        Parameter parameter = null;
        while (dbConnection.next()) {
            int n5;
            int n6;
            int n7 = dbConnection.getInt(1);
            if (n7 != n3) {
                if (null != arrayList) {
                    if (null != parameter && parameter.checkValues()) {
                        arrayList.add(parameter);
                    }
                    if (!arrayList.isEmpty()) {
                        hashMap.put(n3, arrayList);
                    }
                }
                arrayList = new ArrayList<Parameter>();
                n3 = n7;
                parameter = null;
                n4 = 0;
            }
            if ((n6 = dbConnection.getInt(2)) != n4) {
                if (null != parameter && parameter.checkValues()) {
                    arrayList.add(parameter);
                }
                if (null != (parameter = hashMap2.get(n6))) {
                    parameter = parameter.copy();
                }
                n4 = n6;
            }
            if (null == parameter || (n5 = dbConnection.getInt(3)) < 0 || n5 >= parameter.valueCount) continue;
            parameter.value[n5] = dbConnection.getString(4);
        }
        if (null != arrayList) {
            if (null != parameter && super.checkValues()) {
                arrayList.add(parameter);
            }
            if (!arrayList.isEmpty()) {
                hashMap.put(n3, arrayList);
            }
        }
        return hashMap;
    }

    public static ArrayList<Parameter> getDefaultScenarioParameters(DbConnection dbConnection, String string, int n, int n2) throws SQLException {
        HashMap<Integer, Parameter> hashMap = Parameter.getScenarioParameterMap(dbConnection, string, n, n2);
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        for (Parameter parameter : hashMap.values()) {
            if (!parameter.checkValues()) continue;
            arrayList.add(parameter);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    private static HashMap<Integer, Parameter> getScenarioParameterMap(DbConnection dbConnection, String string, int n, int n2) throws SQLException {
        int n3;
        Parameter parameter;
        dbConnection.setDatabase(string);
        HashMap<Integer, Parameter> hashMap = new HashMap<Integer, Parameter>();
        dbConnection.query("SELECT parameter.parameter_key, parameter.name, parameter.units, parameter.description, parameter_group.name, parameter_group.enabling_parameter_key, parameter.is_scenario_parameter, parameter.type, parameter.value_list FROM parameter JOIN parameter_group USING (group_key) JOIN parameter_study_type USING (parameter_key) WHERE (parameter_study_type.study_type = " + n2 + ") AND parameter.is_scenario_parameter ORDER BY parameter_group.list_order, parameter.list_order");
        while (dbConnection.next()) {
            int n4 = dbConnection.getInt(1);
            hashMap.put(n4, new Parameter(n4, dbConnection.getString(2), dbConnection.getString(3), dbConnection.getString(4), dbConnection.getString(5), dbConnection.getInt(6), dbConnection.getBoolean(7), dbConnection.getString(8), dbConnection.getString(9)));
        }
        if (hashMap.isEmpty()) {
            return hashMap;
        }
        dbConnection.query("SELECT parameter_key, value_index, value FROM template_parameter_data WHERE template_key = " + n);
        while (dbConnection.next()) {
            parameter = hashMap.get(dbConnection.getInt(1));
            if (null == parameter || (n3 = dbConnection.getInt(2)) < 0 || n3 >= parameter.valueCount) continue;
            parameter.defaultValue[n3] = dbConnection.getString(3);
        }
        if (n > 1) {
            dbConnection.query("SELECT parameter_key, value_index, value FROM template_parameter_data WHERE template_key = 1");
            while (dbConnection.next()) {
                parameter = hashMap.get(dbConnection.getInt(1));
                if (null == parameter || (n3 = dbConnection.getInt(2)) < 0 || n3 >= parameter.valueCount || null != parameter.defaultValue[n3]) continue;
                parameter.defaultValue[n3] = dbConnection.getString(3);
            }
        }
        return hashMap;
    }

    public static String getTemplateParameterValue(String string, int n, int n2, int n3) {
        return Parameter.getTemplateParameterValue(string, n, n2, n3, null);
    }

    public static String getTemplateParameterValue(String string, int n, int n2, int n3, ErrorLogger errorLogger) {
        String string2 = null;
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT value FROM template_parameter_data WHERE (template_key = " + n + ") AND (parameter_key = " + n2 + ") AND (value_index = " + n3 + ")");
                if (dbConnection.next()) {
                    string2 = dbConnection.getString(1);
                } else {
                    dbConnection.query("SELECT value FROM template_parameter_data WHERE (template_key = 1) AND (parameter_key = " + n2 + ") AND (value_index = " + n3 + ")");
                    if (dbConnection.next()) {
                        string2 = dbConnection.getString(1);
                    }
                }
                DbCore.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static String makeParameterSummary(ArrayList<Parameter> arrayList) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        for (Parameter object2 : arrayList) {
            if (object2.isTable) continue;
            n5 = object2.name.length();
            n4 = 0;
            n3 = n5;
            if (object2.valueCount > 1) {
                for (n2 = 0; n2 < object2.valueCount; ++n2) {
                    n = object2.valueName[n2].length();
                    if (n <= n4) continue;
                    n4 = n;
                }
                n3 = n5 + n4 + 2;
            }
            if (n3 <= n6) continue;
            n6 = n3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        boolean bl = false;
        for (Parameter parameter : arrayList) {
            int n7;
            void var9_10;
            if (parameter.isTable) continue;
            if (!parameter.groupName.equals(var9_10)) {
                stringBuilder.append('\n');
                stringBuilder.append(parameter.groupName);
                stringBuilder.append('\n');
                String string2 = parameter.groupName;
                bl = false;
            }
            if (bl) continue;
            n5 = parameter.name.length();
            n4 = 0;
            n3 = n5;
            if (parameter.valueCount > 1) {
                for (n2 = 0; n2 < parameter.valueCount; ++n2) {
                    n = parameter.valueName[n2].length();
                    if (n <= n4) continue;
                    n4 = n;
                }
                n3 = n5 + n4 + 2;
            }
            for (n7 = n3; n7 < n6; ++n7) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(parameter.name);
            stringBuilder.append(": ");
            for (n2 = 0; n2 < parameter.valueCount; ++n2) {
                if (parameter.valueCount > 1) {
                    for (n7 = n = parameter.valueName[n2].length(); n7 < n4; ++n7) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(parameter.valueName[n2]);
                    stringBuilder.append(": ");
                }
                switch (parameter.type) {
                    default: {
                        stringBuilder.append(parameter.value[n2]);
                        break;
                    }
                    case 4: {
                        if (parameter.optionValue[n2]) {
                            stringBuilder.append("Yes");
                            break;
                        }
                        stringBuilder.append("No");
                        if (!parameter.enablesGroup) break;
                        bl = true;
                        break;
                    }
                    case 5: {
                        stringBuilder.append(parameter.pickfromItems.get((int)parameter.pickfromIndex[n2]).name);
                    }
                }
                stringBuilder.append(' ');
                stringBuilder.append(parameter.units);
                if (n2 >= parameter.valueCount - 1) continue;
                stringBuilder.append('\n');
                for (n7 = n3; n7 < n6; ++n7) {
                    stringBuilder.append(' ');
                }
                for (n7 = 0; n7 < n5; ++n7) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append("  ");
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static void createTables(DbConnection dbConnection, String string, String string2, int n, int n2) throws SQLException {
        dbConnection.setDatabase(string);
        dbConnection.update("CREATE TABLE parameter_data (parameter_key INT NOT NULL,value_index INT NOT NULL,value VARCHAR(10000) NOT NULL,PRIMARY KEY (parameter_key, value_index))");
        dbConnection.update("CREATE TABLE scenario_parameter_data (scenario_key INT NOT NULL,parameter_key INT NOT NULL,value_index INT NOT NULL,value VARCHAR(10000) NOT NULL,PRIMARY KEY (scenario_key, parameter_key, value_index))");
        if (null != string2 && n > 0) {
            dbConnection.update("INSERT INTO parameter_data (parameter_key,value_index,value) SELECT template_parameter_data.parameter_key,template_parameter_data.value_index,template_parameter_data.value FROM " + string2 + ".template_parameter_data JOIN " + string2 + ".parameter USING (parameter_key) JOIN " + string2 + ".parameter_study_type USING (parameter_key) WHERE template_parameter_data.template_key = " + n + " AND (parameter_study_type.study_type = " + n2 + ") AND NOT parameter.is_scenario_parameter");
        }
    }

    public static void copyTables(DbConnection dbConnection, String string, String string2) throws SQLException {
        Parameter.createTables(dbConnection, string, null, 0, 0);
        dbConnection.update("INSERT INTO parameter_data (parameter_key,value_index,value) SELECT parameter_key,value_index,value FROM " + string2 + ".parameter_data");
        dbConnection.update("INSERT INTO scenario_parameter_data (scenario_key,parameter_key,value_index,value) SELECT scenario_key,parameter_key,value_index,value FROM " + string2 + ".scenario_parameter_data");
    }
}

