/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.KeyedRecord;
import java.sql.SQLException;
import java.util.ArrayList;

public class EmissionMask
extends KeyedRecord {
    public final String emissionMaskCode;
    private static EmissionMask nullObject = new EmissionMask(0, "(n/a)", "");
    private static EmissionMask invalidObject = new EmissionMask(-1, "???", "?");
    private static EmissionMask defaultObject = nullObject;
    private static ArrayList<EmissionMask> recordCache = new ArrayList();

    public EmissionMask(int n, String string, String string2) {
        super(n, string);
        this.emissionMaskCode = string2;
    }

    public static EmissionMask getEmissionMask(int n) {
        if (0 == n) {
            return nullObject;
        }
        for (EmissionMask emissionMask : recordCache) {
            if (n != emissionMask.key) continue;
            return emissionMask;
        }
        return nullObject;
    }

    public static EmissionMask getEmissionMask(String string) {
        for (EmissionMask emissionMask : recordCache) {
            if (!emissionMask.emissionMaskCode.equalsIgnoreCase(string)) continue;
            return emissionMask;
        }
        return nullObject;
    }

    public static EmissionMask getNullObject() {
        return nullObject;
    }

    public static EmissionMask getInvalidObject() {
        return invalidObject;
    }

    public static EmissionMask getDefaultObject() {
        return defaultObject;
    }

    public static ArrayList<KeyedRecord> getEmissionMasks() {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        for (EmissionMask emissionMask : recordCache) {
            arrayList.add(emissionMask);
        }
        return arrayList;
    }

    public static ArrayList<KeyedRecord> getEmissionMasksWithNull() {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        arrayList.add(nullObject);
        for (EmissionMask emissionMask : recordCache) {
            arrayList.add(emissionMask);
        }
        return arrayList;
    }

    public static ArrayList<EmissionMask> getAllEmissionMasks() {
        return new ArrayList<EmissionMask>(recordCache);
    }

    public static void loadCache(DbConnection dbConnection) throws SQLException {
        recordCache.clear();
        dbConnection.query("SELECT emission_mask_key, name, emission_mask_code, is_default FROM emission_mask ORDER BY 1");
        while (dbConnection.next()) {
            EmissionMask emissionMask = new EmissionMask(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3));
            if (dbConnection.getBoolean(4)) {
                defaultObject = emissionMask;
            }
            recordCache.add(emissionMask);
        }
    }
}

