/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core.data;

import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.KeyedRecord;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class Country
extends KeyedRecord {
    public static final String US_CODE = "US";
    public static final String CA_CODE = "CA";
    public static final String MX_CODE = "MX";
    public static final int US = 1;
    public static final int CA = 2;
    public static final int MX = 3;
    public static final int MAX_COUNTRY = 3;
    public final String countryCode;
    private static Country invalidObject = new Country(-1, "???", "??");
    private static ArrayList<Country> recordCache = new ArrayList();
    private static HashMap<Integer, Country> recordKeyCache = new HashMap();
    private static HashMap<String, Country> recordCodeCache = new HashMap();

    public Country(int n, String string, String string2) {
        super(n, string);
        this.countryCode = string2;
    }

    public static Country getCountry(int n) {
        return recordKeyCache.get(n);
    }

    public static Country getCountry(String string) {
        return recordCodeCache.get(string);
    }

    public static Country getInvalidObject() {
        return invalidObject;
    }

    public static ArrayList<KeyedRecord> getCountries() {
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        for (Country country : recordCache) {
            arrayList.add(country);
        }
        return arrayList;
    }

    public static ArrayList<Country> getAllCountries() {
        return new ArrayList<Country>(recordCache);
    }

    public static void loadCache(DbConnection dbConnection) throws SQLException {
        recordCache.clear();
        recordKeyCache.clear();
        recordCodeCache.clear();
        dbConnection.query("SELECT country_key, name, country_code FROM country ORDER BY 1");
        while (dbConnection.next()) {
            Country country = new Country(dbConnection.getInt(1), dbConnection.getString(2), dbConnection.getString(3));
            recordCache.add(country);
            recordKeyCache.put(country.key, country);
            recordCodeCache.put(country.countryCode, country);
        }
    }
}

