/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.core.StudyBuild;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.editdata.ParameterEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.SourceEditDataWL;
import gov.fcc.tvstudy.core.editdata.StudyEditData;

public class StudyBuildWireless
extends StudyBuild {
    public int templateKey;
    public ExtDb wirelessExtDb;
    public ExtDb maskingExtDb;
    public String frequency;
    public String bandwidth;

    public StudyBuildWireless(String string) {
        super(string);
    }

    public StudyBuildWireless copy() {
        StudyBuildWireless studyBuildWireless = new StudyBuildWireless(this.dbID);
        studyBuildWireless.studyDescription = this.studyDescription;
        studyBuildWireless.studyFolderKey = this.studyFolderKey;
        studyBuildWireless.source = this.source;
        studyBuildWireless.record = this.record;
        studyBuildWireless.replicate = this.replicate;
        studyBuildWireless.changeChannel = this.changeChannel;
        studyBuildWireless.studyChannel = this.studyChannel;
        studyBuildWireless.templateKey = this.templateKey;
        studyBuildWireless.wirelessExtDb = this.wirelessExtDb;
        studyBuildWireless.maskingExtDb = this.maskingExtDb;
        studyBuildWireless.frequency = this.frequency;
        studyBuildWireless.bandwidth = this.bandwidth;
        return studyBuildWireless;
    }

    @Override
    public boolean initialize(ErrorLogger errorLogger) {
        if (this.initialized) {
            return true;
        }
        if (!super.initialize(errorLogger)) {
            return false;
        }
        if (null != this.studyName) {
            this.studyName = this.studyName.trim();
        }
        if (null == this.studyName || 0 == this.studyName.length()) {
            if (null != errorLogger) {
                errorLogger.reportError("Missing study name");
            }
            return false;
        }
        if (null != this.studyDescription) {
            this.studyDescription = this.studyDescription.trim();
            if (0 == this.studyDescription.length()) {
                this.studyDescription = null;
            }
        }
        if (this.templateKey <= 0 || null == this.wirelessExtDb || !SourceEditDataWL.isExtDbSupported(this.wirelessExtDb) || null != this.maskingExtDb && !ExtDbRecordTV.isExtDbSupported(this.maskingExtDb)) {
            if (null != errorLogger) {
                errorLogger.reportError("Invalid configuration settings");
            }
            return false;
        }
        if (null != this.frequency) {
            this.frequency = this.frequency.trim();
            if (0 == this.frequency.length()) {
                this.frequency = null;
            }
        }
        if (null != this.bandwidth) {
            this.bandwidth = this.bandwidth.trim();
            if (0 == this.bandwidth.length()) {
                this.bandwidth = null;
            }
        }
        this.initialized = true;
        return true;
    }

    @Override
    public Study buildStudy(StatusLogger statusLogger, ErrorLogger errorLogger) {
        boolean bl;
        StudyEditData studyEditData;
        Study study;
        block45: {
            if (!this.initialized) {
                if (null != errorLogger) {
                    errorLogger.reportError("Object has not been initialized");
                }
                return null;
            }
            if (null != statusLogger) {
                statusLogger.reportStatus("Building study...");
                statusLogger.logMessage(this.timestampMessage("Starting study build"));
            }
            Integer n = null;
            if (null != this.record) {
                n = this.record.extDb.key;
            } else if (null != this.source && null != this.source.extDbKey) {
                n = this.source.extDbKey;
            } else if (null != this.maskingExtDb) {
                n = this.maskingExtDb.key;
            }
            Integer n2 = Study.createNewStudy(this.dbID, this.studyName, 3, this.templateKey, n, this.studyFolderKey, errorLogger);
            if (null == n2) {
                return null;
            }
            study = Study.getStudy(this.dbID, n2, errorLogger);
            if (null == study) {
                return null;
            }
            studyEditData = null;
            bl = false;
            try {
                studyEditData = new StudyEditData(study);
                SourceEditDataTV sourceEditDataTV = null;
                if (null != this.source) {
                    sourceEditDataTV = (SourceEditDataTV)this.source.deriveSource(studyEditData, this.source.isLocked, errorLogger);
                } else {
                    ExtDbRecordTV extDbRecordTV = (ExtDbRecordTV)this.record;
                    sourceEditDataTV = SourceEditDataTV.makeSourceTV(extDbRecordTV, studyEditData, true, errorLogger);
                }
                if (null != sourceEditDataTV && (this.replicate || this.changeChannel)) {
                    if (this.replicate) {
                        studyEditData.addOrReplaceSource(sourceEditDataTV);
                        sourceEditDataTV = sourceEditDataTV.replicate(this.studyChannel, errorLogger);
                    } else {
                        if (sourceEditDataTV.isLocked) {
                            studyEditData.addOrReplaceSource(sourceEditDataTV);
                            sourceEditDataTV = (SourceEditDataTV)sourceEditDataTV.deriveSource(studyEditData, false, errorLogger);
                        }
                        if (null != sourceEditDataTV) {
                            sourceEditDataTV.channel = this.studyChannel;
                        }
                    }
                }
                if (null != errorLogger && errorLogger.hasMessages()) {
                    if (null != statusLogger) {
                        statusLogger.logMessage(errorLogger.getMessages());
                    }
                    errorLogger.clearMessages();
                }
                if (null != sourceEditDataTV) {
                    int n3 = studyEditData.getMinimumChannel();
                    int n4 = studyEditData.getMaximumChannel();
                    if (sourceEditDataTV.channel < n3 || sourceEditDataTV.channel > n4) {
                        if (null != errorLogger) {
                            errorLogger.reportError("The study record channel must be in the range " + n3 + " to " + n4);
                        }
                    } else {
                        int n5;
                        ScenarioEditData scenarioEditData = new ScenarioEditData(studyEditData, sourceEditDataTV.getCallSign() + " wireless IX");
                        scenarioEditData.description = "Wireless interference to " + sourceEditDataTV.toString();
                        scenarioEditData.sourceData.addOrReplace(sourceEditDataTV, true, false, true);
                        studyEditData.scenarioData.addOrReplace(scenarioEditData);
                        studyEditData.description = null == this.studyDescription ? scenarioEditData.description : this.studyDescription;
                        ParameterEditData parameterEditData = scenarioEditData.getParameter(355);
                        if (null != parameterEditData) {
                            for (n5 = 0; n5 < parameterEditData.parameter.valueCount; ++n5) {
                                parameterEditData.value[n5] = this.frequency;
                            }
                        }
                        if (null != (parameterEditData = scenarioEditData.getParameter(356))) {
                            for (n5 = 0; n5 < parameterEditData.parameter.valueCount; ++n5) {
                                parameterEditData.value[n5] = this.bandwidth;
                            }
                        }
                        n5 = 0;
                        int n6 = 0;
                        if (!this.isCanceled()) {
                            if (null != statusLogger) {
                                statusLogger.reportStatus("Searching for wireless records...");
                                statusLogger.logMessage(this.timestampMessage("Searching for wireless records"));
                            }
                            n5 = SourceEditDataWL.addRecords(this.wirelessExtDb, scenarioEditData, 2, "", null, 0.0, errorLogger);
                            if (null != errorLogger && errorLogger.hasMessages()) {
                                if (null != statusLogger) {
                                    statusLogger.logMessage(errorLogger.getMessages());
                                }
                                errorLogger.clearMessages();
                            }
                        }
                        if (!this.isCanceled() && n5 >= 0 && null != this.maskingExtDb) {
                            if (null != statusLogger) {
                                statusLogger.reportStatus("Searching for TV records...");
                                statusLogger.logMessage(this.timestampMessage("Searching for undesired TV records"));
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            ExtDbRecordTV.addServiceTypeQueryTV(this.maskingExtDb.type, this.maskingExtDb.version, 1, 3, stringBuilder, false);
                            ExtDbRecordTV.addRecordTypeQueryTV(this.maskingExtDb.type, this.maskingExtDb.version, false, stringBuilder, true);
                            n6 = ExtDbRecordTV.addRecords(this.maskingExtDb, false, scenarioEditData, 2, stringBuilder.toString(), null, 0.0, 0, 0, false, false, true, true, true, errorLogger);
                            if (null != errorLogger && errorLogger.hasMessages()) {
                                if (null != statusLogger) {
                                    statusLogger.logMessage(errorLogger.getMessages());
                                }
                                errorLogger.clearMessages();
                            }
                        }
                        if (!this.isCanceled() && n5 >= 0 && n6 >= 0) {
                            if (null != statusLogger) {
                                statusLogger.reportStatus("Saving study...");
                                statusLogger.logMessage(this.timestampMessage("Build complete, saving study"));
                            }
                            studyEditData.isDataChanged();
                            if (studyEditData.save(errorLogger)) {
                                if (null != statusLogger) {
                                    statusLogger.logMessage(this.timestampMessage("Done"));
                                }
                                bl = true;
                                study = studyEditData.study;
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                AppCore.log(3, "Unexpected error", throwable);
                if (null == errorLogger) break block45;
                errorLogger.reportError("Unexpected error: " + throwable);
            }
        }
        if (null != studyEditData) {
            studyEditData.invalidate();
        }
        if (this.isCanceled()) {
            if (null != errorLogger) {
                errorLogger.reportError("Study build canceled");
            }
            bl = false;
        }
        if (bl) {
            return study;
        }
        Study.deleteStudy(this.dbID, study.key, study.lockCount, errorLogger);
        return null;
    }
}

