/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecordFM;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.core.StudyBuild;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.editdata.IxRuleEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataFM;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class StudyBuildTV6FM
extends StudyBuild {
    public int templateKey;
    public ExtDb fmExtDb;
    public ExtDb tvExtDb;
    private StudyEditData study;
    private SourceEditDataTV targetSource;

    public StudyBuildTV6FM(String string) {
        super(string);
    }

    @Override
    public boolean initialize(ErrorLogger errorLogger) {
        if (this.initialized) {
            return true;
        }
        if (!super.initialize(errorLogger)) {
            return false;
        }
        if (null != this.studyName) {
            this.studyName = this.studyName.trim();
        }
        if (null == this.studyName || 0 == this.studyName.length()) {
            if (null != errorLogger) {
                errorLogger.reportError("Missing study name");
            }
            return false;
        }
        if (null != this.studyDescription) {
            this.studyDescription = this.studyDescription.trim();
            if (0 == this.studyDescription.length()) {
                this.studyDescription = null;
            }
        }
        if (this.templateKey <= 0 || null == this.fmExtDb || !ExtDbRecordFM.isExtDbSupported(this.fmExtDb) || null != this.tvExtDb && !ExtDbRecordTV.isExtDbSupported(this.tvExtDb)) {
            if (null != errorLogger) {
                errorLogger.reportError("Invalid configuration settings");
            }
            return false;
        }
        this.initialized = true;
        return true;
    }

    @Override
    public Study buildStudy(StatusLogger statusLogger, ErrorLogger errorLogger) {
        boolean bl;
        Study study;
        block33: {
            if (!this.initialized) {
                if (null != errorLogger) {
                    errorLogger.reportError("Object has not been initialized");
                }
                return null;
            }
            if (null != statusLogger) {
                statusLogger.reportStatus("Building study...");
                statusLogger.logMessage(this.timestampMessage("Starting study build"));
            }
            Integer n = null;
            if (null != this.record) {
                n = this.record.extDb.key;
            } else if (null != this.source && null != this.source.extDbKey) {
                n = this.source.extDbKey;
            } else if (null != this.tvExtDb) {
                n = this.tvExtDb.key;
            }
            Integer n2 = Study.createNewStudy(this.dbID, this.studyName, 5, this.templateKey, n, this.studyFolderKey, errorLogger);
            if (null == n2) {
                return null;
            }
            study = Study.getStudy(this.dbID, n2, errorLogger);
            if (null == study) {
                return null;
            }
            bl = false;
            try {
                this.study = new StudyEditData(study);
                if (null != this.source) {
                    this.targetSource = (SourceEditDataTV)this.source.deriveSource(this.study, this.source.isLocked, errorLogger);
                } else {
                    ExtDbRecordTV extDbRecordTV = (ExtDbRecordTV)this.record;
                    this.targetSource = SourceEditDataTV.makeSourceTV(extDbRecordTV, this.study, true, errorLogger);
                }
                if (null != this.targetSource && (this.replicate || this.changeChannel)) {
                    if (this.replicate) {
                        this.study.addOrReplaceSource(this.targetSource);
                        this.targetSource = this.targetSource.replicate(this.studyChannel, errorLogger);
                    } else {
                        if (this.targetSource.isLocked) {
                            this.study.addOrReplaceSource(this.targetSource);
                            this.targetSource = (SourceEditDataTV)this.targetSource.deriveSource(this.study, false, errorLogger);
                        }
                        if (null != this.targetSource) {
                            this.targetSource.channel = this.studyChannel;
                        }
                    }
                }
                if (null != errorLogger && errorLogger.hasMessages()) {
                    if (null != statusLogger) {
                        statusLogger.logMessage(errorLogger.getMessages());
                    }
                    errorLogger.clearMessages();
                }
                if (null != this.targetSource) {
                    if (6 != this.targetSource.channel) {
                        if (null != errorLogger) {
                            errorLogger.reportError("The study record must be on channel 6");
                        }
                    } else if (this.buildScenario(statusLogger, errorLogger)) {
                        if (null != statusLogger) {
                            statusLogger.reportStatus("Saving study...");
                            statusLogger.logMessage(this.timestampMessage("Build complete, saving study"));
                        }
                        this.study.isDataChanged();
                        if (this.study.save(errorLogger)) {
                            if (null != statusLogger) {
                                statusLogger.logMessage(this.timestampMessage("Done"));
                            }
                            bl = true;
                            study = this.study.study;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                AppCore.log(3, "Unexpected error", throwable);
                if (null == errorLogger) break block33;
                errorLogger.reportError("Unexpected error: " + throwable);
            }
        }
        if (null != this.study) {
            this.study.invalidate();
        }
        if (this.isCanceled()) {
            if (null != errorLogger) {
                errorLogger.reportError("Study build canceled");
            }
            bl = false;
        }
        if (bl) {
            return study;
        }
        Study.deleteStudy(this.dbID, study.key, study.lockCount, errorLogger);
        return null;
    }

    private boolean buildScenario(StatusLogger statusLogger, ErrorLogger errorLogger) {
        double d;
        boolean bl;
        int n;
        StringBuilder stringBuilder;
        double d2 = this.study.getKilometersPerDegree();
        ScenarioEditData scenarioEditData = new ScenarioEditData(this.study, this.targetSource.getCallSign() + " and FM IX");
        scenarioEditData.description = "Interference between " + this.targetSource.toString() + " and NCE FM stations";
        scenarioEditData.sourceData.addOrReplace(this.targetSource, true, true, true);
        this.study.scenarioData.addOrReplace(scenarioEditData);
        this.study.description = null == this.studyDescription ? scenarioEditData.description : this.studyDescription;
        if (null != this.tvExtDb) {
            if (null != statusLogger) {
                statusLogger.reportStatus("Searching for TV records...");
                statusLogger.logMessage(this.timestampMessage("Searching for TV undesireds to protected TV6"));
            }
            stringBuilder = new StringBuilder();
            try {
                ExtDbRecordTV.addServiceTypeQueryTV(this.tvExtDb.type, this.tvExtDb.version, 1, 3, stringBuilder, false);
                ExtDbRecordTV.addRecordTypeQueryTV(this.tvExtDb.type, this.tvExtDb.version, false, stringBuilder, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (ExtDbRecordTV.addRecords(this.tvExtDb, false, scenarioEditData, 2, stringBuilder.toString(), null, 0.0, 0, 0, false, false, true, true, true, errorLogger) < 0) {
                return false;
            }
            if (this.isCanceled()) {
                return false;
            }
            if (null != errorLogger && errorLogger.hasMessages()) {
                if (null != statusLogger) {
                    statusLogger.logMessage(errorLogger.getMessages());
                }
                errorLogger.clearMessages();
            }
        }
        if (null != statusLogger) {
            statusLogger.reportStatus("Searching for FM records...");
            statusLogger.logMessage(this.timestampMessage("Searching for protected and undesired FM stations"));
        }
        double[] dArray = this.study.getTV6FMDistance();
        double[] dArray2 = this.study.getTV6FMDistanceDtv();
        int n2 = 101;
        double[] dArray3 = new double[n2];
        for (IxRuleEditData object2 : this.study.ixRuleData.getActiveRows()) {
            if (3 != object2.serviceType.recordType || (n = 199 + object2.channelDelta.delta - 200) < 0 || n >= n2 || !(object2.distance > dArray3[n])) continue;
            dArray3[n] = object2.distance;
        }
        Object object3 = this.targetSource.service.isDigital() ? (Object)dArray2 : (Object)dArray3;
        StringBuilder stringBuilder2 = new StringBuilder();
        int n3 = 40;
        for (n = 0; n < n2; ++n) {
            if (!(n < dArray.length && dArray[n] > 0.0) && (n >= ((Object)object3).length || !(object3[n] > 0.0))) continue;
            stringBuilder2.append((char)n3);
            stringBuilder2.append(String.valueOf(n + 200));
            n3 = 44;
        }
        stringBuilder2.append(')');
        stringBuilder = new StringBuilder();
        try {
            ExtDbRecordFM.addMultipleChannelQueryFM(this.fmExtDb.type, this.fmExtDb.version, stringBuilder2.toString(), stringBuilder, false);
            ExtDbRecordFM.addServiceTypeQueryFM(this.fmExtDb.type, this.fmExtDb.version, 1, stringBuilder, true);
            ExtDbRecordFM.addRecordTypeQueryFM(this.fmExtDb.type, this.fmExtDb.version, false, stringBuilder, true);
        }
        catch (IllegalArgumentException linkedList) {
            // empty catch block
        }
        LinkedList<ExtDbRecordFM> linkedList = ExtDbRecordFM.findRecordsFM(this.fmExtDb, stringBuilder.toString(), errorLogger);
        if (null == linkedList) {
            return false;
        }
        if (this.isCanceled()) {
            return false;
        }
        if (null != errorLogger && errorLogger.hasMessages()) {
            if (null != statusLogger) {
                statusLogger.logMessage(errorLogger.getMessages());
            }
            errorLogger.clearMessages();
        }
        Comparator<ExtDbRecordFM> comparator = new Comparator<ExtDbRecordFM>(){

            @Override
            public int compare(ExtDbRecordFM extDbRecordFM, ExtDbRecordFM extDbRecordFM2) {
                if (extDbRecordFM.isPreferredRecord(extDbRecordFM2, true)) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(linkedList, comparator);
        int n4 = linkedList.size() - 1;
        for (int d3 = 0; d3 < n4; ++d3) {
            ExtDbRecordFM extDbRecordFM = linkedList.get(d3);
            ListIterator<ExtDbRecordFM> listIterator = linkedList.listIterator(d3 + 1);
            while (listIterator.hasNext()) {
                if (!ExtDbRecordFM.areRecordsMX(extDbRecordFM, listIterator.next(), true, 0.0, 0.0)) continue;
                listIterator.remove();
                --n4;
            }
        }
        if (null != errorLogger) {
            errorLogger.clearErrors();
        } else {
            errorLogger = new ErrorLogger(null, null);
        }
        ArrayList<SourceEditDataFM> arrayList = new ArrayList<SourceEditDataFM>();
        for (ExtDbRecordFM extDbRecordFM : linkedList) {
            n = extDbRecordFM.channel - 200;
            double d5 = n < ((Object)object3).length ? (double)object3[n] : 0.0;
            double d3 = n < dArray.length ? dArray[n] : 0.0;
            bl = false;
            boolean bl2 = false;
            if (this.targetSource.isParent) {
                for (SourceEditDataTV sourceEditDataTV : this.targetSource.getDTSSources()) {
                    if (sourceEditDataTV.siteNumber <= 0) continue;
                    d = sourceEditDataTV.location.distanceTo(extDbRecordFM.location, d2);
                    if (d <= d5 + sourceEditDataTV.getRuleExtraDistance()) {
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    if (!(d <= d3)) continue;
                    bl = true;
                }
            } else {
                d = this.targetSource.location.distanceTo(extDbRecordFM.location, d2);
                if (d <= d5 + this.targetSource.getRuleExtraDistance()) {
                    bl = true;
                    bl2 = true;
                } else if (d <= d3) {
                    bl = true;
                }
            }
            if (!bl) continue;
            SourceEditDataFM sourceEditDataFM = (SourceEditDataFM)SourceEditData.makeSource(extDbRecordFM, this.study, true, errorLogger);
            if (null == sourceEditDataFM) {
                if (!errorLogger.hasErrors()) continue;
                return false;
            }
            scenarioEditData.sourceData.addOrReplace(sourceEditDataFM, bl2, true);
            if (!bl2) continue;
            arrayList.add(sourceEditDataFM);
        }
        if (this.isCanceled()) {
            return false;
        }
        if (null != errorLogger && errorLogger.hasMessages()) {
            if (null != statusLogger) {
                statusLogger.logMessage(errorLogger.getMessages());
            }
            errorLogger.clearMessages();
        }
        if (null != this.tvExtDb) {
            SourceEditDataTV sourceEditDataTV;
            if (null != statusLogger) {
                statusLogger.reportStatus("Searching for TV records...");
                statusLogger.logMessage(this.timestampMessage("Searching for TV6 undesireds to protected FM"));
            }
            stringBuilder = new StringBuilder();
            try {
                ExtDbRecordTV.addChannelQueryTV(this.tvExtDb.type, this.tvExtDb.version, 6, 0, 0, stringBuilder, false);
                ExtDbRecordTV.addServiceTypeQueryTV(this.tvExtDb.type, this.tvExtDb.version, 1, 3, stringBuilder, true);
                ExtDbRecordTV.addRecordTypeQueryTV(this.tvExtDb.type, this.tvExtDb.version, false, stringBuilder, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            LinkedList<ExtDbRecordTV> illegalArgumentException = ExtDbRecordTV.findRecordsTV(this.tvExtDb, stringBuilder.toString(), errorLogger);
            if (null == illegalArgumentException) {
                return false;
            }
            if (this.isCanceled()) {
                return false;
            }
            if (null != errorLogger && errorLogger.hasMessages()) {
                if (null != statusLogger) {
                    statusLogger.logMessage(errorLogger.getMessages());
                }
                errorLogger.clearMessages();
            }
            ArrayList<SourceEditData> arrayList2 = scenarioEditData.sourceData.getSources(1);
            Iterator<SourceEditDataTV> iterator = illegalArgumentException.listIterator(0);
            block14: while (iterator.hasNext()) {
                ExtDbRecordTV extDbRecordTV = (ExtDbRecordTV)iterator.next();
                for (SourceEditData sourceEditData : arrayList2) {
                    sourceEditDataTV = (SourceEditDataTV)sourceEditData;
                    if (!extDbRecordTV.extRecordID.equals(sourceEditDataTV.extRecordID) && !ExtDbRecordTV.areRecordsMX(extDbRecordTV, sourceEditDataTV, true, 0.0, 0.0)) continue;
                    iterator.remove();
                    continue block14;
                }
            }
            Comparator<ExtDbRecordTV> comparator2 = new Comparator<ExtDbRecordTV>(){

                @Override
                public int compare(ExtDbRecordTV extDbRecordTV, ExtDbRecordTV extDbRecordTV2) {
                    if (extDbRecordTV.isPreferredRecord(extDbRecordTV2, true)) {
                        return -1;
                    }
                    return 1;
                }
            };
            Collections.sort(illegalArgumentException, comparator2);
            n4 = illegalArgumentException.size() - 1;
            for (int i = 0; i < n4; ++i) {
                ExtDbRecordTV extDbRecordTV = (ExtDbRecordTV)illegalArgumentException.get(i);
                iterator = illegalArgumentException.listIterator(i + 1);
                while (iterator.hasNext()) {
                    if (!ExtDbRecordTV.areRecordsMX(extDbRecordTV, (ExtDbRecordTV)iterator.next(), true, 0.0, 0.0)) continue;
                    iterator.remove();
                    --n4;
                }
            }
            Iterator iterator2 = illegalArgumentException.iterator();
            while (iterator2.hasNext()) {
                ExtDbRecordTV extDbRecordTV = (ExtDbRecordTV)iterator2.next();
                object3 = extDbRecordTV.service.isDigital() ? (Object)dArray2 : (Object)dArray3;
                bl = false;
                for (SourceEditDataFM sourceEditDataFM : arrayList) {
                    n = sourceEditDataFM.channel - 200;
                    double d4 = n < ((Object)object3).length ? (double)object3[n] : 0.0;
                    if (extDbRecordTV.service.isDTS) {
                        for (ExtDbRecordTV extDbRecordTV2 : extDbRecordTV.dtsRecords) {
                            d = extDbRecordTV2.location.distanceTo(sourceEditDataFM.location, d2);
                            if (!(d <= d4 + extDbRecordTV2.getRuleExtraDistance(this.study))) continue;
                            bl = true;
                            break;
                        }
                    } else {
                        d = extDbRecordTV.location.distanceTo(sourceEditDataFM.location, d2);
                        if (d <= d4 + extDbRecordTV.getRuleExtraDistance(this.study)) {
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    break;
                }
                if (!bl) continue;
                sourceEditDataTV = (SourceEditDataTV)SourceEditData.makeSource(extDbRecordTV, this.study, true, errorLogger);
                if (null == sourceEditDataTV) {
                    if (!errorLogger.hasErrors()) continue;
                    return false;
                }
                scenarioEditData.sourceData.addOrReplace(sourceEditDataTV, false, true);
            }
            if (this.isCanceled()) {
                return false;
            }
            if (null != errorLogger && errorLogger.hasMessages()) {
                if (null != statusLogger) {
                    statusLogger.logMessage(errorLogger.getMessages());
                }
                errorLogger.clearMessages();
            }
        }
        if (null != statusLogger) {
            statusLogger.reportStatus("Searching for FM records...");
            statusLogger.logMessage(this.timestampMessage("Searching for FM undesireds to protected FM"));
        }
        stringBuilder = new StringBuilder();
        try {
            ExtDbRecordFM.addServiceTypeQueryFM(this.fmExtDb.type, this.fmExtDb.version, 1, stringBuilder, false);
            ExtDbRecordFM.addRecordTypeQueryFM(this.fmExtDb.type, this.fmExtDb.version, false, stringBuilder, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (ExtDbRecordFM.addRecords(this.fmExtDb, scenarioEditData, 2, stringBuilder.toString(), null, 0.0, 0, 0, false, true, true, true, errorLogger) < 0) {
            return false;
        }
        if (null != errorLogger && errorLogger.hasMessages()) {
            if (null != statusLogger) {
                statusLogger.logMessage(errorLogger.getMessages());
            }
            errorLogger.clearMessages();
        }
        return true;
    }
}

