/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AntPattern;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.FrequencyOffset;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.data.Zone;
import gov.fcc.tvstudy.core.editdata.IxRuleEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;

public class ExtDbRecordTV
extends ExtDbRecord
implements StationRecord {
    private static final String[] CDBS_STATUS_CODES = new String[]{"APP", "CP", "CP MOD", "LIC"};
    private static final int[] CDBS_STATUS_TYPES = new int[]{3, 1, 1, 2};
    private static final String[] LMS_APP_STATUS_CODES = new String[]{"SUB", "DIS", "WIT", "DEN", "RET", "CAN", "REC"};
    public static final int[] STATUS_TYPE_RANK = new int[]{30, 10, 20, 40, 70, 60, 50};
    public static final String BASELINE_STATUS = "BL";
    public static final String BASELINE_ID_PREFIX = "DTVBL";
    public int siteNumber;
    public int facilityID;
    public boolean isDRT;
    public String callSign;
    public int channel;
    public String zoneCode;
    public String status;
    public int statusType;
    public String filePrefix;
    public String appARN;
    public String frequencyOffsetCode;
    public String emissionMaskCode;
    public double dtsMaximumDistance;
    public double alternateERP;
    public boolean daIndicated;
    public boolean isSharingHost;
    public boolean isSharingGuest;
    public String channelSharingComment;
    public String licensee;
    public LinkedList<ExtDbRecordTV> dtsRecords;
    public String dtsAuthorizedFileNumber;
    public ExtDbRecordTV dtsAuthorizedRecord;
    public boolean isBaseline;
    public int replicateToChannel;
    private boolean inSearchRadius;
    private ArrayList<GeoPoint> dtsLocations;
    private boolean isOperatingFacility;
    private boolean operatingStatusSet;
    private static final String SHARING_GUEST_FILE_NAME = "sharing_guests.dat";
    private static HashSet<Integer> sharingGuestFacilityIDs;
    private static HashMap<String, HashSet<Integer>> licenseAppLists;

    public static boolean isExtDbSupported(ExtDb extDb) {
        return !extDb.deleted && extDb.isSupported() && extDb.canProvide(1) && (1 == extDb.type || 2 == extDb.type || 5 == extDb.type);
    }

    public static LinkedList<ExtDbRecord> findRecords(ExtDb extDb, String string, boolean bl, ErrorLogger errorLogger) {
        return ExtDbRecordTV.findRecords(extDb, string, bl, null, 0.0, 0.0, errorLogger);
    }

    public static LinkedList<ExtDbRecord> findRecords(ExtDb extDb, String string, boolean bl, GeoPoint geoPoint, double d, double d2, ErrorLogger errorLogger) {
        LinkedList<ExtDbRecordTV> linkedList = ExtDbRecordTV.findRecordsTV(extDb, string, bl, geoPoint, d, d2, null, errorLogger);
        if (null != linkedList) {
            return new LinkedList<ExtDbRecord>(linkedList);
        }
        return null;
    }

    public static LinkedList<ExtDbRecordTV> findRecordsTV(ExtDb extDb, String string) {
        return ExtDbRecordTV.findRecordsTV(extDb, string, false, null, 0.0, 0.0, null, null);
    }

    public static LinkedList<ExtDbRecordTV> findRecordsTV(ExtDb extDb, String string, ErrorLogger errorLogger) {
        return ExtDbRecordTV.findRecordsTV(extDb, string, false, null, 0.0, 0.0, null, errorLogger);
    }

    private static LinkedList<ExtDbRecordTV> findRecordsTV(ExtDb extDb, String string, boolean bl, GeoPoint geoPoint, double d, double d2, ExtDbRecordTV extDbRecordTV, ErrorLogger errorLogger) {
        Object object;
        LinkedList<ExtDbRecordTV> linkedList;
        Object object2;
        String string2;
        Object object3;
        boolean bl2;
        if (!ExtDbRecordTV.isExtDbSupported(extDb)) {
            return new LinkedList<ExtDbRecordTV>();
        }
        boolean bl3 = bl2 = 1 == extDb.type;
        if (null == sharingGuestFacilityIDs) {
            sharingGuestFacilityIDs = new HashSet();
            try {
                object3 = Files.newBufferedReader(AppCore.libDirectoryPath.resolve(SHARING_GUEST_FILE_NAME));
                while (null != (string2 = AppCore.readLineSkipComments((BufferedReader)object3))) {
                    try {
                        sharingGuestFacilityIDs.add(Integer.valueOf(string2));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ((BufferedReader)object3).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object3 = "";
        string2 = "";
        String string3 = "";
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            object3 = "SELECT (CASE WHEN (facility.fac_callsign <> '') THEN facility.fac_callsign ELSE application.fac_callsign END), (CASE WHEN (facility.comm_city <> '') THEN facility.comm_city ELSE application.comm_city END), (CASE WHEN (facility.comm_state <> '') THEN facility.comm_state ELSE application.comm_state END), tv_eng_data.fac_zone, tv_eng_data.tv_dom_status, application.file_prefix, application.app_arn, tv_eng_data.freq_offset, tv_eng_data.dt_emission_mask, tv_eng_data.lat_dir, tv_eng_data.lat_deg, tv_eng_data.lat_min, tv_eng_data.lat_sec, tv_eng_data.lon_dir, tv_eng_data.lon_deg, tv_eng_data.lon_min, tv_eng_data.lon_sec, tv_eng_data.rcamsl_horiz_mtr, tv_eng_data.haat_rc_mtr, tv_eng_data.effective_erp, tv_eng_data.max_erp_any_angle, tv_eng_data.antenna_id, tv_eng_data.ant_rotation, tv_eng_data.elevation_antenna_id, tv_eng_data.electrical_deg, tv_eng_data.mechanical_deg, tv_eng_data.true_deg, tv_eng_data.eng_record_type, tv_app_indicators.da_ind, tv_eng_data.site_number, tv_eng_data.vsd_service,facility.fac_country,tv_eng_data.application_id,tv_eng_data.facility_id,tv_eng_data.station_channel,tv_eng_data.predict_coverage_area AS dts_max_dist, facility.fac_service, application.app_type, tv_eng_data.antenna_id, tv_eng_data.electrical_deg";
            string2 = "FROM tv_eng_data JOIN facility USING (facility_id) JOIN application USING (application_id) LEFT JOIN tv_app_indicators USING (application_id, site_number) LEFT JOIN app_tracking USING (application_id) ";
        } else if (5 == extDb.type) {
            object3 = "SELECT facility.callsign, (CASE WHEN (facility.community_served_city <> '') THEN facility.community_served_city ELSE application_facility.afac_community_city END), (CASE WHEN (facility.community_served_state <> '') THEN facility.community_served_state ELSE application_facility.afac_community_state_code END), application_facility.afac_facility_zone_code, license_filing_version.current_status_code, 'BLANK' AS file_prefix, application.aapp_file_num, app_antenna_frequency.aafq_offset, app_antenna.emission_mask_code, app_location.aloc_lat_dir, (CASE WHEN TRIM(app_location.aloc_lat_deg) IN ('','null') THEN 0::FLOAT ELSE app_location.aloc_lat_deg::FLOAT END), (CASE WHEN TRIM(app_location.aloc_lat_mm) IN ('','null') THEN 0::FLOAT ELSE app_location.aloc_lat_mm::FLOAT END), (CASE WHEN TRIM(app_location.aloc_lat_ss) IN ('','null') THEN 0::FLOAT ELSE app_location.aloc_lat_ss::FLOAT END), app_location.aloc_long_dir, (CASE WHEN TRIM(app_location.aloc_long_deg) IN ('','null') THEN 0::FLOAT ELSE app_location.aloc_long_deg::FLOAT END), (CASE WHEN TRIM(app_location.aloc_long_mm) IN ('','null') THEN 0::FLOAT ELSE app_location.aloc_long_mm::FLOAT END), (CASE WHEN TRIM(app_location.aloc_long_ss) IN ('','null') THEN 0::FLOAT ELSE app_location.aloc_long_ss::FLOAT END), (CASE WHEN TRIM(app_antenna.aant_rc_amsl) IN ('','null') THEN 0::FLOAT ELSE app_antenna.aant_rc_amsl::FLOAT END), (CASE WHEN TRIM(app_antenna.aant_rc_haat) IN ('','null') THEN 0::FLOAT ELSE app_antenna.aant_rc_haat::FLOAT END), (CASE WHEN TRIM(app_antenna_frequency.aafq_power_erp_kw) IN ('','null') THEN 0::FLOAT ELSE app_antenna_frequency.aafq_power_erp_kw::FLOAT END), 0::FLOAT AS max_erp_any_angle, app_antenna.aant_antenna_record_id, (CASE WHEN TRIM(app_antenna.aant_rotation_deg) IN ('','null') THEN 0::FLOAT ELSE app_antenna.aant_rotation_deg::FLOAT END), app_antenna.aant_antenna_record_id, (CASE WHEN TRIM(app_antenna.aant_electrical_deg) IN ('','null') THEN 0::FLOAT ELSE app_antenna.aant_electrical_deg::FLOAT END), (CASE WHEN TRIM(app_antenna.aant_mechanical_deg) IN ('','null') THEN 0::FLOAT ELSE app_antenna.aant_mechanical_deg::FLOAT END), (CASE WHEN TRIM(app_antenna.aant_true_deg) IN ('','null') THEN 0::FLOAT ELSE app_antenna.aant_true_deg::FLOAT END), (CASE WHEN (application.dts_reference_ind = 'R') THEN 'N' ELSE license_filing_version.active_ind END), app_antenna.aant_antenna_type_code, app_location.aloc_loc_seq_id, license_filing_version.service_code,application_facility.country_code,app_location.aloc_aapp_application_id,application_facility.afac_facility_id,(CASE WHEN TRIM(application_facility.afac_channel) IN ('','null') THEN 0::INT ELSE application_facility.afac_channel::INT END),application.dts_waiver_distance, license_filing_version.service_code, license_filing_version.auth_type_code, app_antenna.aant_antenna_id, (CASE WHEN TRIM(app_antenna.foreign_station_beam_tilt) IN ('','null') THEN 0::FLOAT ELSE app_antenna.foreign_station_beam_tilt::FLOAT END)";
            string2 = "FROM mass_media.app_location LEFT JOIN mass_media.app_antenna ON (app_antenna.aant_aloc_loc_record_id = app_location.aloc_loc_record_id) LEFT JOIN mass_media.app_antenna_frequency ON (app_antenna_frequency.aafq_aant_antenna_record_id = app_antenna.aant_antenna_record_id) JOIN common_schema.application ON (application.aapp_application_id = app_location.aloc_aapp_application_id) JOIN common_schema.license_filing_version ON (license_filing_version.filing_version_id = app_location.aloc_aapp_application_id) JOIN common_schema.application_facility ON (application_facility.afac_application_id = app_location.aloc_aapp_application_id) JOIN common_schema.facility ON (facility.facility_id = application_facility.afac_facility_id) ";
        } else {
            object3 = "SELECT DISTINCT facility.callsign, (CASE WHEN (facility.community_served_city <> '') THEN facility.community_served_city ELSE application_facility.afac_community_city END), (CASE WHEN (facility.community_served_state <> '') THEN facility.community_served_state ELSE application_facility.afac_community_state_code END), application_facility.afac_facility_zone_code, license_filing_version.current_status_code, 'BLANK' AS file_prefix, application.aapp_file_num, app_antenna_frequency.aafq_offset, app_antenna.emission_mask_code, app_location.aloc_lat_dir, app_location.aloc_lat_deg, app_location.aloc_lat_mm, app_location.aloc_lat_ss, app_location.aloc_long_dir, app_location.aloc_long_deg, app_location.aloc_long_mm, app_location.aloc_long_ss, app_antenna.aant_rc_amsl, app_antenna.aant_rc_haat, app_antenna_frequency.aafq_power_erp_kw, 0. AS max_erp_any_angle, app_antenna.aant_antenna_record_id, app_antenna.aant_rotation_deg, app_antenna.aant_antenna_record_id, app_antenna.aant_electrical_deg, app_antenna.aant_mechanical_deg, app_antenna.aant_true_deg, (CASE WHEN (application.dts_reference_ind = 'R') THEN 'N' ELSE license_filing_version.active_ind END), app_antenna.aant_antenna_type_code, app_location.aloc_loc_seq_id, license_filing_version.service_code,application_facility.country_code,app_location.aloc_aapp_application_id,application_facility.afac_facility_id,application_facility.afac_channel,application.dts_waiver_distance, license_filing_version.service_code, license_filing_version.auth_type_code, app_antenna.aant_antenna_id";
            object3 = extDb.version > 4 ? (String)object3 + ", app_antenna.foreign_station_beam_tilt" : (String)object3 + ", app_antenna.aant_electrical_deg";
            string2 = "FROM app_location LEFT JOIN app_antenna ON (app_antenna.aant_aloc_loc_record_id = app_location.aloc_loc_record_id) LEFT JOIN app_antenna_frequency ON (app_antenna_frequency.aafq_aant_antenna_record_id = app_antenna.aant_antenna_record_id) JOIN application ON (application.aapp_application_id = app_location.aloc_aapp_application_id) JOIN license_filing_version ON (license_filing_version.filing_version_id = app_location.aloc_aapp_application_id) JOIN application_facility ON (application_facility.afac_application_id = app_location.aloc_aapp_application_id) JOIN facility ON (facility.facility_id = application_facility.afac_facility_id) ";
        }
        if (null != extDbRecordTV) {
            object3 = (String)object3 + " ";
            if (bl2) {
                stringBuilder.append("WHERE ");
                stringBuilder.append("(tv_eng_data.application_id = ");
                stringBuilder.append(extDbRecordTV.extRecordID);
                stringBuilder.append(") AND ");
                stringBuilder.append("(tv_eng_data.site_number > 0) ");
                string3 = "ORDER BY tv_eng_data.site_number";
            } else {
                stringBuilder.append("WHERE ");
                stringBuilder.append("(app_location.aloc_aapp_application_id = '");
                stringBuilder.append(extDbRecordTV.extRecordID);
                stringBuilder.append("') AND ");
                stringBuilder.append("(app_location.aloc_dts_reference_location_ind = 'N') ");
                string3 = "ORDER BY app_location.aloc_loc_seq_id";
            }
        } else {
            stringBuilder.append("WHERE ");
            if (null != string && string.length() > 0) {
                stringBuilder.append('(');
                stringBuilder.append(string);
                stringBuilder.append(") AND ");
            }
            if (bl2) {
                object3 = (String)object3 + ", facility.fac_status, (CASE WHEN (app_tracking.accepted_date IS NOT NULL AND (app_tracking.accepted_date <> '')) THEN app_tracking.accepted_date ELSE tv_eng_data.last_change_date END) AS sequence_date, 'N' AS channel_sharing_ind, '' AS licensee_name, null AS host_ind ";
                stringBuilder.append("((tv_eng_data.site_number = 0) OR (tv_eng_data.vsd_service <> 'DD')) ");
            } else {
                object3 = (String)object3 + ", facility.facility_status, application.aapp_receipt_date AS sequence_date, application.channel_sharing_ind, application_facility.licensee_name";
                if (extDb.version > 5) {
                    object3 = (String)object3 + ", shared_channel.host_ind";
                    string2 = 5 == extDb.type ? string2 + "LEFT JOIN mass_media.shared_channel ON ((shared_channel.application_id = app_location.aloc_aapp_application_id) AND (shared_channel.facility_id = application_facility.afac_facility_id)) " : string2 + "LEFT JOIN shared_channel ON ((shared_channel.application_id = app_location.aloc_aapp_application_id) AND (shared_channel.facility_id = application_facility.afac_facility_id)) ";
                } else {
                    object3 = (String)object3 + ", null AS host_ind";
                }
                if (extDb.version > 7) {
                    object3 = (String)object3 + ", facility_applicant.legal_name ";
                    string2 = 5 == extDb.type ? string2 + "LEFT JOIN common_schema.facility_applicant ON ((facility_applicant.facility_uuid = facility.facility_uuid) AND (facility_applicant.contact_ind = 'N')) " : string2 + "LEFT JOIN facility_applicant ON ((facility_applicant.facility_uuid = facility.facility_uuid) AND (facility_applicant.contact_ind = 'N')) ";
                } else {
                    object3 = (String)object3 + ", '' AS legal_name ";
                }
                if (extDb.version > 8) {
                    object3 = (String)object3 + ", app_mm_application.reference_point_file_num ";
                    string2 = 5 == extDb.type ? string2 + "LEFT JOIN mass_media.app_mm_application ON (app_mm_application.aapp_application_id = app_location.aloc_aapp_application_id) " : string2 + "LEFT JOIN app_mm_application ON (app_mm_application.aapp_application_id = app_location.aloc_aapp_application_id) ";
                } else {
                    object3 = (String)object3 + ", '' AS reference_point_file_num ";
                }
                stringBuilder.append("((CASE WHEN (license_filing_version.purpose_code = 'AMD') ");
                stringBuilder.append("THEN license_filing_version.original_purpose_code ");
                stringBuilder.append("ELSE license_filing_version.purpose_code END) IN ('CP','L2C','MOD','RUL','STA')) AND ");
                stringBuilder.append("((license_filing_version.service_code NOT IN ('DTS','CADTS','LDTS','TDTS')) OR ");
                stringBuilder.append("(app_location.aloc_dts_reference_location_ind = 'Y')) AND ");
                stringBuilder.append("(license_filing_version.current_status_code <> 'SAV') AND ");
                stringBuilder.append("(license_filing_version.service_code IN ");
                ExtDbRecordTV.addServiceCodeList(extDb.type, 1, stringBuilder);
                stringBuilder.append(')');
            }
        }
        LinkedList<ExtDbRecordTV> linkedList2 = null;
        boolean bl4 = false;
        DbConnection dbConnection = extDb.connectDb(errorLogger);
        if (null != dbConnection) {
            try {
                String string4;
                CharSequence numberFormatException;
                String string5;
                linkedList2 = new LinkedList<ExtDbRecordTV>();
                GeoPoint geoPoint2 = new GeoPoint();
                SimpleDateFormat simpleDateFormat = bl2 ? new SimpleDateFormat("MM/dd/yyyy", Locale.US) : new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                Date date = null;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                dbConnection.query((String)object3 + string2 + stringBuilder.toString() + string3);
                while (dbConnection.next()) {
                    boolean bl5;
                    boolean bl6;
                    boolean bl7;
                    boolean bl8;
                    int n;
                    String string6;
                    boolean bl9;
                    double d3;
                    int n2;
                    int n3;
                    String string7;
                    if (null != extDbRecordTV) {
                        if (!bl2 && null == dbConnection.getString(22)) continue;
                        object2 = extDbRecordTV.service;
                        linkedList = extDbRecordTV.country;
                        string7 = extDbRecordTV.extRecordID;
                        n3 = extDbRecordTV.facilityID;
                        n2 = extDbRecordTV.channel;
                        d3 = 0.0;
                        date = new Date(0L);
                        bl9 = false;
                        string6 = extDbRecordTV.status;
                        n = extDbRecordTV.statusType;
                        bl8 = extDbRecordTV.isArchived;
                        bl7 = extDbRecordTV.isPending;
                        bl6 = false;
                        bl5 = false;
                    } else {
                        object2 = ExtDbRecordTV.getService(extDb.type, dbConnection.getString(31));
                        if (null == object2 || !bl2 && !((Service)object2).isDTS && null == dbConnection.getString(22) || null == (linkedList = Country.getCountry(dbConnection.getString(32)))) continue;
                        if (bl2) {
                            int n4 = dbConnection.getInt(33);
                            if (n4 <= 0) continue;
                            string7 = String.valueOf(n4);
                        } else {
                            string7 = dbConnection.getString(33);
                            if (null == string7 || 0 == string7.length()) continue;
                        }
                        n3 = dbConnection.getInt(34);
                        n2 = dbConnection.getInt(35);
                        if (n2 < 2 || n2 > 69) continue;
                        bl6 = false;
                        bl5 = false;
                        string5 = dbConnection.getString(43);
                        if (null != string5 && string5.equalsIgnoreCase("Y") && ((Service)object2).isDigital()) {
                            string5 = dbConnection.getString(45);
                            if (null != string5) {
                                if (string5.equalsIgnoreCase("Y")) {
                                    bl6 = true;
                                } else {
                                    bl5 = true;
                                }
                            } else if (((Service)object2).isFullService() || ((Service)object2).isClassA()) {
                                if (sharingGuestFacilityIDs.contains(n3)) {
                                    bl5 = true;
                                } else {
                                    bl6 = true;
                                }
                            }
                            if (bl5 && !bl) continue;
                        }
                        d3 = 0.0;
                        if (((Service)object2).isDTS) {
                            try {
                                string5 = dbConnection.getString(36);
                                if (null != string5) {
                                    d3 = Double.parseDouble(string5);
                                }
                            }
                            catch (NumberFormatException parseException) {
                                // empty catch block
                            }
                        }
                        date = null;
                        try {
                            string5 = dbConnection.getString(42);
                            if (null != string5) {
                                date = simpleDateFormat.parse(string5);
                            }
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        if (null == date) {
                            date = new Date(0L);
                        }
                        string5 = dbConnection.getString(37);
                        bl9 = bl2 ? null != string5 && string5.equals("DT") && ((Service)object2).isLPTV() : null != string5 && string5.equals("DRT");
                        numberFormatException = dbConnection.getString(41);
                        if (null == numberFormatException) {
                            numberFormatException = "";
                        }
                        if (null == (string6 = dbConnection.getString(5))) {
                            string6 = "";
                        }
                        n = 4;
                        if (((String)numberFormatException).equals("EXPER")) {
                            n = 5;
                        } else {
                            int n4;
                            string4 = dbConnection.getString(38);
                            if (null == string4) {
                                string4 = "";
                            }
                            if (bl2) {
                                if (string4.equalsIgnoreCase("STA") || string4.equalsIgnoreCase("STAX")) {
                                    n = 0;
                                } else {
                                    for (n4 = 0; n4 < CDBS_STATUS_CODES.length; ++n4) {
                                        if (!CDBS_STATUS_CODES[n4].equalsIgnoreCase(string6)) continue;
                                        n = CDBS_STATUS_TYPES[n4];
                                        break;
                                    }
                                }
                            } else if (string4.equalsIgnoreCase("S")) {
                                n = 0;
                            } else if (string6.equalsIgnoreCase("REV")) {
                                n = 6;
                            } else if (string6.equalsIgnoreCase("PEN") && string4.equalsIgnoreCase("C")) {
                                n = 3;
                            } else {
                                for (n4 = 0; n4 < LMS_APP_STATUS_CODES.length; ++n4) {
                                    if (!LMS_APP_STATUS_CODES[n4].equalsIgnoreCase(string6)) continue;
                                    n = 3;
                                    break;
                                }
                                if (4 == n) {
                                    if (string4.equalsIgnoreCase("C")) {
                                        n = 1;
                                    } else if (string4.equalsIgnoreCase("L")) {
                                        n = 2;
                                    }
                                }
                            }
                        }
                        if (4 != n) {
                            string6 = STATUS_CODES[n];
                        }
                        bl8 = false;
                        bl7 = false;
                        if (((String)numberFormatException).equals("FVOID")) {
                            bl8 = true;
                        } else {
                            string5 = dbConnection.getString(28);
                            if (null != string5) {
                                if (bl2) {
                                    if (string5.equalsIgnoreCase("P")) {
                                        bl7 = true;
                                    } else if (string5.equalsIgnoreCase("A") || string5.equalsIgnoreCase("R")) {
                                        bl8 = true;
                                    }
                                } else if (string5.equalsIgnoreCase("N")) {
                                    bl8 = true;
                                } else {
                                    string5 = dbConnection.getString(5);
                                    if (null != string5 && string5.equalsIgnoreCase("PEN")) {
                                        bl7 = true;
                                    }
                                }
                            }
                        }
                    }
                    geoPoint2.latitudeNS = 0;
                    String string8 = dbConnection.getString(10);
                    if (null != string8 && string8.equalsIgnoreCase("S")) {
                        geoPoint2.latitudeNS = 1;
                    }
                    geoPoint2.latitudeDegrees = dbConnection.getInt(11);
                    geoPoint2.latitudeMinutes = dbConnection.getInt(12);
                    geoPoint2.latitudeSeconds = dbConnection.getDouble(13);
                    geoPoint2.longitudeWE = 0;
                    string8 = dbConnection.getString(14);
                    if (null != string8 && string8.equalsIgnoreCase("E")) {
                        geoPoint2.longitudeWE = 1;
                    }
                    geoPoint2.longitudeDegrees = dbConnection.getInt(15);
                    geoPoint2.longitudeMinutes = dbConnection.getInt(16);
                    geoPoint2.longitudeSeconds = dbConnection.getDouble(17);
                    geoPoint2.updateLatLon();
                    if (bl2) {
                        geoPoint2.convertFromNAD27();
                        geoPoint2.updateDMS();
                    }
                    if (null != geoPoint && d > 0.0) {
                        if (null != extDbRecordTV) {
                            if (geoPoint.distanceTo(geoPoint2, d2) <= d) {
                                extDbRecordTV.inSearchRadius = true;
                            }
                        } else if (!((Service)object2).isDTS && geoPoint.distanceTo(geoPoint2, d2) > d) continue;
                    }
                    object = new ExtDbRecordTV(extDb);
                    ((ExtDbRecordTV)object).extRecordID = string7;
                    ((ExtDbRecordTV)object).siteNumber = ((Service)object2).isDTS && null == extDbRecordTV ? 0 : dbConnection.getInt(30);
                    ((ExtDbRecordTV)object).facilityID = n3;
                    ((ExtDbRecordTV)object).service = object2;
                    ((ExtDbRecordTV)object).isDRT = bl9;
                    string5 = dbConnection.getString(1);
                    if (null == string5) {
                        string5 = "";
                    } else if (string5.length() > 12) {
                        string5 = string5.substring(0, 12);
                    }
                    ((ExtDbRecordTV)object).callSign = string5;
                    ((ExtDbRecordTV)object).channel = n2;
                    string5 = dbConnection.getString(2);
                    if (null == string5) {
                        string5 = "";
                    } else if (string5.length() > 20) {
                        string5 = string5.substring(0, 20);
                    }
                    ((ExtDbRecordTV)object).city = string5;
                    string5 = dbConnection.getString(3);
                    if (null == string5) {
                        string5 = "";
                    } else if (string5.length() > 2) {
                        string5 = string5.substring(0, 2);
                    }
                    ((ExtDbRecordTV)object).state = string5;
                    ((ExtDbRecordTV)object).country = linkedList;
                    ((ExtDbRecordTV)object).zoneCode = dbConnection.getString(4);
                    if (null == ((ExtDbRecordTV)object).zoneCode) {
                        ((ExtDbRecordTV)object).zoneCode = "";
                    }
                    if (string6.length() > 6) {
                        string6 = string6.substring(0, 6);
                    }
                    ((ExtDbRecordTV)object).status = string6;
                    ((ExtDbRecordTV)object).statusType = n;
                    ((ExtDbRecordTV)object).isArchived = bl8;
                    ((ExtDbRecordTV)object).isPending = bl7;
                    CharSequence charSequence = dbConnection.getString(6);
                    CharSequence charSequence2 = dbConnection.getString(7);
                    if (!bl2 && null != charSequence2 && 2 == ((CharSequence)(numberFormatException = ((String)charSequence2).split("-"))).length) {
                        charSequence = numberFormatException[0];
                        charSequence2 = numberFormatException[1];
                    }
                    if (null == charSequence2) {
                        charSequence2 = "";
                    } else if (((String)charSequence2).length() > 255) {
                        charSequence2 = ((String)charSequence2).substring(0, 255);
                    }
                    if (null == charSequence) {
                        charSequence = "";
                    } else if (((String)charSequence).length() + ((String)charSequence2).length() > 255) {
                        charSequence = ((String)charSequence).substring(0, 255 - ((String)charSequence2).length());
                    }
                    ((ExtDbRecordTV)object).filePrefix = charSequence;
                    ((ExtDbRecordTV)object).appARN = charSequence2;
                    ((ExtDbRecordTV)object).location.setLatLon(geoPoint2);
                    ((ExtDbRecordTV)object).dtsMaximumDistance = d3;
                    ((ExtDbRecordTV)object).isSharingHost = bl6;
                    ((ExtDbRecordTV)object).isSharingGuest = bl5;
                    if (null == extDbRecordTV) {
                        if (!bl2 && extDb.version > 7) {
                            string5 = dbConnection.getString(46);
                            if (null == string5 || 0 == string5.length()) {
                                string5 = dbConnection.getString(44);
                            }
                        } else {
                            string5 = dbConnection.getString(44);
                        }
                        ((ExtDbRecordTV)object).licensee = string5;
                        if (!bl2 && extDb.version > 8) {
                            ((ExtDbRecordTV)object).dtsAuthorizedFileNumber = dbConnection.getString(47);
                        }
                    }
                    if (!bl2 && ((Service)object2).isDTS && null == extDbRecordTV) {
                        ((ExtDbRecordTV)object).frequencyOffsetCode = "";
                        ((ExtDbRecordTV)object).emissionMaskCode = "";
                    } else {
                        int n5;
                        ((ExtDbRecordTV)object).frequencyOffsetCode = dbConnection.getString(8);
                        if (null == ((ExtDbRecordTV)object).frequencyOffsetCode) {
                            ((ExtDbRecordTV)object).frequencyOffsetCode = "";
                        }
                        ((ExtDbRecordTV)object).emissionMaskCode = dbConnection.getString(9);
                        if (null == ((ExtDbRecordTV)object).emissionMaskCode) {
                            ((ExtDbRecordTV)object).emissionMaskCode = "";
                        }
                        ((ExtDbRecordTV)object).heightAMSL = dbConnection.getDouble(18);
                        ((ExtDbRecordTV)object).overallHAAT = dbConnection.getDouble(19);
                        ((ExtDbRecordTV)object).peakERP = dbConnection.getDouble(20);
                        ((ExtDbRecordTV)object).alternateERP = dbConnection.getDouble(21);
                        if (bl2) {
                            n5 = dbConnection.getInt(22);
                            if (n5 > 0) {
                                ((ExtDbRecordTV)object).antennaRecordID = String.valueOf(n5);
                                ((ExtDbRecordTV)object).antennaID = dbConnection.getString(39);
                            }
                        } else {
                            string5 = dbConnection.getString(22);
                            if (null != string5 && 0 == (string5 = string5.trim()).length()) {
                                string5 = null;
                            }
                            ((ExtDbRecordTV)object).antennaRecordID = string5;
                            string5 = dbConnection.getString(39);
                            if (null != string5 && 0 == (string5 = string5.trim()).length()) {
                                string5 = null;
                            }
                            ((ExtDbRecordTV)object).antennaID = string5;
                        }
                        ((ExtDbRecordTV)object).horizontalPatternOrientation = Math.IEEEremainder(dbConnection.getDouble(23), 360.0);
                        if (((ExtDbRecordTV)object).horizontalPatternOrientation < 0.0) {
                            ((ExtDbRecordTV)object).horizontalPatternOrientation += 360.0;
                        }
                        if (bl2) {
                            n5 = dbConnection.getInt(24);
                            if (n5 > 0) {
                                ((ExtDbRecordTV)object).elevationAntennaRecordID = String.valueOf(n5);
                            }
                        } else {
                            ((ExtDbRecordTV)object).elevationAntennaRecordID = dbConnection.getString(24);
                        }
                        ((ExtDbRecordTV)object).verticalPatternElectricalTilt = dbConnection.getDouble(25);
                        if (1 != ((Country)((Object)linkedList)).key && 0.0 == ((ExtDbRecordTV)object).verticalPatternElectricalTilt) {
                            ((ExtDbRecordTV)object).verticalPatternElectricalTilt = dbConnection.getDouble(40);
                        }
                        ((ExtDbRecordTV)object).verticalPatternMechanicalTilt = dbConnection.getDouble(26);
                        ((ExtDbRecordTV)object).verticalPatternMechanicalTiltOrientation = Math.IEEEremainder(dbConnection.getDouble(27), 360.0);
                        if (((ExtDbRecordTV)object).verticalPatternMechanicalTiltOrientation < 0.0) {
                            ((ExtDbRecordTV)object).verticalPatternMechanicalTiltOrientation += 360.0;
                        }
                        if (null != (string5 = dbConnection.getString(29))) {
                            ((ExtDbRecordTV)object).daIndicated = bl2 ? string5.equalsIgnoreCase("Y") : string5.equalsIgnoreCase("DIR");
                        }
                    }
                    ((ExtDbRecordTV)object).sequenceDate = date;
                    linkedList2.add((ExtDbRecordTV)object);
                    if (((Service)object2).isDTS) {
                        bl4 = true;
                    }
                    if (null != extDbRecordTV || bl2 || extDb.version <= 5 || !bl6 && !bl5) continue;
                    hashMap.put(((ExtDbRecordTV)object).extRecordID, object);
                }
                if (!hashMap.isEmpty()) {
                    CharSequence charSequence3;
                    numberFormatException = new StringBuilder();
                    string4 = "('";
                    for (CharSequence charSequence3 : hashMap.keySet()) {
                        ((StringBuilder)numberFormatException).append(string4);
                        ((StringBuilder)numberFormatException).append((String)charSequence3);
                        string4 = "','";
                    }
                    ((StringBuilder)numberFormatException).append("')");
                    if (5 == extDb.type) {
                        dbConnection.query("SELECT shared_channel.application_id, shared_channel.host_ind, facility.callsign FROM mass_media.shared_channel JOIN common_schema.facility USING (facility_id) WHERE shared_channel.application_id IN " + numberFormatException + " ORDER BY 1, 2, 3");
                    } else {
                        dbConnection.query("SELECT shared_channel.application_id, shared_channel.host_ind, facility.callsign FROM shared_channel JOIN facility USING (facility_id) WHERE shared_channel.application_id IN " + numberFormatException + " ORDER BY 1, 2, 3");
                    }
                    Object object4 = "";
                    object = null;
                    charSequence3 = null;
                    while (dbConnection.next()) {
                        string5 = dbConnection.getString(1);
                        if (!string5.equals(object4)) {
                            if (null != object && ((StringBuilder)charSequence3).length() > 0) {
                                ((ExtDbRecordTV)object).channelSharingComment = ((StringBuilder)charSequence3).toString();
                            }
                            object = (ExtDbRecordTV)hashMap.get(string5);
                            object4 = string5;
                            if (null != object) {
                                charSequence3 = new StringBuilder();
                                String string9 = string4 = ((ExtDbRecordTV)object).isSharingHost ? "Guest(s): " : "Host: ";
                            }
                        }
                        if (null == object) continue;
                        string5 = dbConnection.getString(2);
                        if ((!((ExtDbRecordTV)object).isSharingHost || !string5.equalsIgnoreCase("N")) && (!((ExtDbRecordTV)object).isSharingGuest || !string5.equalsIgnoreCase("Y"))) continue;
                        ((StringBuilder)charSequence3).append(string4);
                        ((StringBuilder)charSequence3).append(dbConnection.getString(3));
                        string4 = ", ";
                    }
                    if (null != object && ((StringBuilder)charSequence3).length() > 0) {
                        ((ExtDbRecordTV)object).channelSharingComment = ((StringBuilder)charSequence3).toString();
                    }
                }
                extDb.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                extDb.releaseDb(dbConnection);
                linkedList2 = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        if (null != linkedList2 && null == extDbRecordTV && bl4) {
            object = linkedList2.listIterator(0);
            while (object.hasNext()) {
                Object object5;
                object2 = object.next();
                if (!((ExtDbRecordTV)object2).service.isDTS) continue;
                ((ExtDbRecordTV)object2).dtsRecords = ExtDbRecordTV.findRecordsTV(extDb, string, false, geoPoint, d, d2, (ExtDbRecordTV)object2, errorLogger);
                if (null == ((ExtDbRecordTV)object2).dtsRecords) {
                    return null;
                }
                if (((ExtDbRecordTV)object2).dtsRecords.isEmpty()) {
                    if (null != errorLogger) {
                        errorLogger.logMessage(ExtDbRecordTV.makeMessage((StationRecord)object2, "Ignored bad DTS, no records with site_number > 0"));
                    }
                    object.remove();
                    continue;
                }
                if (null != geoPoint && d > 0.0 && !((ExtDbRecordTV)object2).inSearchRadius) {
                    object.remove();
                    continue;
                }
                if (!bl2) {
                    boolean bl10 = ((ExtDbRecordTV)object2).service.serviceType.needsEmissionMask;
                    object5 = null;
                    EmissionMask emissionMask = null;
                    String string10 = null;
                    String string11 = null;
                    boolean bl11 = false;
                    boolean bl12 = false;
                    for (ExtDbRecordTV extDbRecordTV2 : ((ExtDbRecordTV)object2).dtsRecords) {
                        FrequencyOffset object6 = FrequencyOffset.getFrequencyOffset(extDbRecordTV2.frequencyOffsetCode);
                        if (object6.key > 0 && null == object5) {
                            object5 = object6;
                        }
                        if (null == string10) {
                            string10 = object6.frequencyOffsetCode;
                        } else if (!string10.equals(object6.frequencyOffsetCode)) {
                            bl11 = true;
                        }
                        if (!bl10) continue;
                        EmissionMask emissionMask2 = EmissionMask.getEmissionMask(extDbRecordTV2.emissionMaskCode);
                        if (emissionMask2.key > 0 && (null == emissionMask || emissionMask2.key < emissionMask.key)) {
                            emissionMask = emissionMask2;
                        }
                        if (null == string11) {
                            string11 = emissionMask2.emissionMaskCode;
                            continue;
                        }
                        if (string11.equals(emissionMask2.emissionMaskCode)) continue;
                        bl12 = true;
                    }
                    if (null != object5) {
                        ((ExtDbRecordTV)object2).frequencyOffsetCode = ((FrequencyOffset)object5).frequencyOffsetCode;
                        if (bl11) {
                            errorLogger.logMessage(ExtDbRecordTV.makeMessage((StationRecord)object2, "Inconsistent frequency offset on DTS transmitters, using " + ((FrequencyOffset)object5).name));
                        }
                    }
                    if (null != emissionMask) {
                        ((ExtDbRecordTV)object2).emissionMaskCode = emissionMask.emissionMaskCode;
                        if (bl12) {
                            errorLogger.logMessage(ExtDbRecordTV.makeMessage((StationRecord)object2, "Inconsistent emission mask on DTS transmitters, using " + emissionMask.name));
                        }
                    }
                }
                linkedList = null;
                if (bl2) {
                    linkedList = ExtDbRecordTV.findRecordsTV(extDb, "(tv_eng_data.vsd_service = 'DT') AND (tv_eng_data.eng_record_type IN ('C', 'R')) AND (tv_eng_data.facility_id = " + ((ExtDbRecordTV)object2).facilityID + ")", false, null, 0.0, 0.0, null, errorLogger);
                    if (null == linkedList) {
                        return null;
                    }
                } else {
                    if (null != ((ExtDbRecordTV)object2).dtsAuthorizedFileNumber && ((ExtDbRecordTV)object2).dtsAuthorizedFileNumber.length() > 0) {
                        object5 = new StringBuilder();
                        ExtDbRecordTV.addFileNumberQuery(extDb.type, extDb.version, 1, ((ExtDbRecordTV)object2).dtsAuthorizedFileNumber, (StringBuilder)object5, false);
                        linkedList = ExtDbRecordTV.findRecordsTV(extDb, ((StringBuilder)object5).toString(), false, null, 0.0, 0.0, null, errorLogger);
                        if (null == linkedList) {
                            return null;
                        }
                        if (!linkedList.isEmpty() && linkedList.getFirst().service.isDTS) {
                            errorLogger.logMessage(ExtDbRecordTV.makeMessage((StationRecord)object2, "DTS authorized facility record '" + ((ExtDbRecordTV)object2).dtsAuthorizedFileNumber + "' is also DTS, not used"));
                            linkedList = null;
                        }
                    }
                    if (null == linkedList) {
                        object5 = "= 'DTV'";
                        if (((ExtDbRecordTV)object2).service.isClassA()) {
                            object5 = "= 'DCA'";
                        } else if (((ExtDbRecordTV)object2).service.isLPTV()) {
                            object5 = "IN ('LPD','LPT')";
                        }
                        object5 = "(application_facility.afac_facility_id = " + ((ExtDbRecordTV)object2).facilityID + ") AND (license_filing_version.service_code " + (String)object5 + ")";
                        linkedList = ExtDbRecordTV.findRecordsTV(extDb, (String)object5 + " AND (application.dts_reference_ind = 'R')", false, null, 0.0, 0.0, null, errorLogger);
                        if (null == linkedList) {
                            return null;
                        }
                        if (linkedList.isEmpty() && null == (linkedList = ExtDbRecordTV.findRecordsTV(extDb, (String)object5 + " AND (license_filing_version.active_ind = 'Y') AND (license_filing_version.auth_type_code = 'L')", false, null, 0.0, 0.0, null, errorLogger))) {
                            return null;
                        }
                        if (linkedList.isEmpty() && null == (linkedList = ExtDbRecordTV.findRecordsTV(extDb, (String)object5 + " AND (license_filing_version.active_ind = 'N') AND (license_filing_version.auth_type_code = 'L')", false, null, 0.0, 0.0, null, errorLogger))) {
                            return null;
                        }
                    }
                }
                if (linkedList.isEmpty()) {
                    object5 = new StringBuilder();
                    ExtDbRecordTV.addBaselineFacilityIDQuery(extDb.type, extDb.version, ((ExtDbRecordTV)object2).facilityID, (StringBuilder)object5, false);
                    linkedList = ExtDbRecordTV.findBaselineRecords(extDb, ((StringBuilder)object5).toString(), null, 0.0, 0.0, true, errorLogger);
                    if (null == linkedList) {
                        return null;
                    }
                }
                if (!linkedList.isEmpty()) {
                    for (ExtDbRecordTV extDbRecordTV3 : linkedList) {
                        if (null != ((ExtDbRecordTV)object2).dtsAuthorizedRecord && !extDbRecordTV3.sequenceDate.after(((ExtDbRecordTV)object2).dtsAuthorizedRecord.sequenceDate)) continue;
                        ((ExtDbRecordTV)object2).dtsAuthorizedRecord = extDbRecordTV3;
                    }
                    ((ExtDbRecordTV)object2).dtsAuthorizedRecord.siteNumber = 0;
                }
                if (((ExtDbRecordTV)object2).service.isFullService()) {
                    if (null != ((ExtDbRecordTV)object2).dtsAuthorizedRecord) continue;
                    errorLogger.logMessage(ExtDbRecordTV.makeMessage((StationRecord)object2, "No DTS authorized facility found"));
                    continue;
                }
                if (null == ((ExtDbRecordTV)object2).dtsAuthorizedRecord) {
                    errorLogger.logMessage(ExtDbRecordTV.makeMessage((StationRecord)object2, "No DTS authorized facility found, record ignored"));
                    object.remove();
                    continue;
                }
                ((ExtDbRecordTV)object2).location.setLatLon(((ExtDbRecordTV)object2).dtsAuthorizedRecord.location);
            }
        }
        return linkedList2;
    }

    public static LinkedList<ExtDbRecordTV> findBaselineRecords(ExtDb extDb, String string) {
        return ExtDbRecordTV.findBaselineRecords(extDb, string, null, 0.0, 0.0, false, null);
    }

    public static LinkedList<ExtDbRecordTV> findBaselineRecords(ExtDb extDb, String string, ErrorLogger errorLogger) {
        return ExtDbRecordTV.findBaselineRecords(extDb, string, null, 0.0, 0.0, false, errorLogger);
    }

    public static LinkedList<ExtDbRecordTV> findBaselineRecords(ExtDb extDb, String string, GeoPoint geoPoint, double d, double d2) {
        return ExtDbRecordTV.findBaselineRecords(extDb, string, geoPoint, d, d2, false, null);
    }

    public static LinkedList<ExtDbRecordTV> findBaselineRecords(ExtDb extDb, String string, GeoPoint geoPoint, double d, double d2, ErrorLogger errorLogger) {
        return ExtDbRecordTV.findBaselineRecords(extDb, string, geoPoint, d, d2, false, errorLogger);
    }

    private static LinkedList<ExtDbRecordTV> findBaselineRecords(ExtDb extDb, String string, GeoPoint geoPoint, double d, double d2, boolean bl, ErrorLogger errorLogger) {
        Object object3;
        int n;
        LinkedList<ExtDbRecordTV> linkedList;
        String string2;
        if (!ExtDbRecordTV.isExtDbSupported(extDb)) {
            return new LinkedList<ExtDbRecordTV>();
        }
        boolean bl2 = 1 == extDb.type;
        Service service = null;
        Country country = null;
        if (bl2 || extDb.version < 3) {
            service = Service.getService("DT");
            if (null == service) {
                if (null != errorLogger) {
                    errorLogger.reportError("ExtDbRecordTV.findBaselineRecords(): could not find service");
                }
                return null;
            }
            country = Country.getCountry(1);
            if (null == country) {
                if (null != errorLogger) {
                    errorLogger.reportError("ExtDbRecordTV.findBaselineRecords(): could not find country");
                }
                return null;
            }
        }
        Date date = null;
        if (bl2) {
            date = new Date(0L);
        } else {
            string2 = AppCore.getPreference("lmsBaselineDate");
            if (null != string2 && string2.length() > 0) {
                date = AppCore.parseDate(string2);
            }
            if (null == date) {
                date = new Date();
            }
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (null != string && string.length() > 0) {
            string5 = " WHERE (" + string + ")";
        }
        if (bl2) {
            string3 = "SELECT dtv_channel_assignments.facility_id, dtv_channel_assignments.post_dtv_channel, (CASE WHEN (facility.fac_callsign <> '') THEN facility.fac_callsign ELSE dtv_channel_assignments.callsign END), (CASE WHEN (facility.comm_city <> '') THEN facility.comm_city ELSE dtv_channel_assignments.city END), (CASE WHEN (facility.comm_state <> '') THEN facility.comm_state ELSE dtv_channel_assignments.state END), dtv_channel_assignments.latitude, dtv_channel_assignments.longitude, dtv_channel_assignments.rcamsl, dtv_channel_assignments.haat, dtv_channel_assignments.erp, dtv_channel_assignments.da_ind, dtv_channel_assignments.antenna_id, dtv_channel_assignments.ref_azimuth";
            string4 = " FROM dtv_channel_assignments JOIN facility USING (facility_id)";
        } else {
            if (5 == extDb.type) {
                string3 = "SELECT (CASE WHEN TRIM(app_dtv_channel_assignment.adca_facility_record_id) IN ('','null') THEN 0::INT ELSE app_dtv_channel_assignment.adca_facility_record_id::INT END), lkp_dtv_allotment.rdta_digital_channel, facility.callsign, (CASE WHEN (facility.community_served_city IS NOT NULL AND (facility.community_served_city <> '' )) THEN facility.community_served_city ELSE lkp_dtv_allotment.rdta_city END), (CASE WHEN (facility.community_served_state IS NOT NULL AND (facility.community_served_state <> '' )) THEN facility.community_served_state ELSE lkp_dtv_allotment.rdta_state END), lkp_dtv_allotment.rdta_lat_dir, lkp_dtv_allotment.rdta_lat_deg, lkp_dtv_allotment.rdta_lat_min, lkp_dtv_allotment.rdta_lat_sec, lkp_dtv_allotment.rdta_lon_dir, lkp_dtv_allotment.rdta_lon_deg, lkp_dtv_allotment.rdta_lon_min, lkp_dtv_allotment.rdta_lon_sec, app_dtv_channel_assignment.rcamsl, lkp_dtv_allotment.rdta_haat, lkp_dtv_allotment.rdta_erp, app_dtv_channel_assignment.directional_antenna_ind, app_dtv_channel_assignment.antenna_id, app_dtv_channel_assignment.antenna_rotation, lkp_dtv_allotment.dts_ref_application_id";
                string4 = " FROM mass_media.app_dtv_channel_assignment JOIN mass_media.lkp_dtv_allotment ON (lkp_dtv_allotment.rdta_dtv_allotment_id = app_dtv_channel_assignment.dtv_allotment_id) LEFT JOIN common_schema.facility ON (CASE WHEN TRIM(app_dtv_channel_assignment.adca_facility_record_id) IN ('','null') THEN false ELSE (facility.facility_id = app_dtv_channel_assignment.adca_facility_record_id::INT) END)";
            } else {
                string3 = "SELECT app_dtv_channel_assignment.adca_facility_record_id, lkp_dtv_allotment.rdta_digital_channel, facility.callsign, (CASE WHEN (facility.community_served_city IS NOT NULL AND (facility.community_served_city <> '' )) THEN facility.community_served_city ELSE lkp_dtv_allotment.rdta_city END), (CASE WHEN (facility.community_served_state IS NOT NULL AND (facility.community_served_state <> '' )) THEN facility.community_served_state ELSE lkp_dtv_allotment.rdta_state END), lkp_dtv_allotment.rdta_lat_dir, lkp_dtv_allotment.rdta_lat_deg, lkp_dtv_allotment.rdta_lat_min, lkp_dtv_allotment.rdta_lat_sec, lkp_dtv_allotment.rdta_lon_dir, lkp_dtv_allotment.rdta_lon_deg, lkp_dtv_allotment.rdta_lon_min, lkp_dtv_allotment.rdta_lon_sec, app_dtv_channel_assignment.rcamsl, lkp_dtv_allotment.rdta_haat, lkp_dtv_allotment.rdta_erp, app_dtv_channel_assignment.directional_antenna_ind, app_dtv_channel_assignment.antenna_id, app_dtv_channel_assignment.antenna_rotation, lkp_dtv_allotment.dts_ref_application_id";
                string4 = " FROM app_dtv_channel_assignment JOIN lkp_dtv_allotment ON (lkp_dtv_allotment.rdta_dtv_allotment_id = app_dtv_channel_assignment.dtv_allotment_id) LEFT JOIN facility ON (facility.facility_id = app_dtv_channel_assignment.adca_facility_record_id)";
            }
            if (extDb.version > 2) {
                string3 = string3 + ", lkp_dtv_allotment.rdta_service_code, lkp_dtv_allotment.rdta_country_code";
            }
            if (extDb.version > 3) {
                string3 = string3 + ", app_dtv_channel_assignment.emission_mask_code";
            }
            if (extDb.version > 4) {
                string3 = string3 + ", app_dtv_channel_assignment.electrical_deg";
            }
        }
        HashMap<String, ExtDbRecordTV> hashMap = null;
        LinkedList<ExtDbRecordTV> linkedList2 = null;
        DbConnection dbConnection = extDb.connectDb(errorLogger);
        if (null != dbConnection) {
            try {
                ExtDbRecordTV extDbRecordTV;
                int n2;
                dbConnection.query(string3 + string4 + string5);
                linkedList = new GeoPoint();
                linkedList2 = new LinkedList<ExtDbRecordTV>();
                if (bl2) {
                    while (dbConnection.next()) {
                        int n3;
                        Object object2;
                        n2 = dbConnection.getInt(1);
                        if (n2 <= 0 || (n = dbConnection.getInt(2)) < 2 || n > 69 || null == (object3 = dbConnection.getString(6))) continue;
                        int n4 = 0;
                        if ('-' == ((String)object3).charAt(0)) {
                            n4 = 1;
                        }
                        if (null == (object2 = dbConnection.getString(7))) continue;
                        int n5 = 0;
                        if ('-' == ((String)object2).charAt(0)) {
                            n5 = 1;
                        }
                        int n6 = 2;
                        if (((String)object2).length() - n5 > 6) {
                            n6 = 3;
                        }
                        try {
                            ((GeoPoint)((Object)linkedList)).latitudeNS = n4;
                            ((GeoPoint)((Object)linkedList)).latitudeDegrees = Integer.parseInt(((String)object3).substring(n4, n4 + 2));
                            ((GeoPoint)((Object)linkedList)).latitudeMinutes = Integer.parseInt(((String)object3).substring(n4 + 2, n4 + 4));
                            ((GeoPoint)((Object)linkedList)).latitudeSeconds = Double.parseDouble(((String)object3).substring(n4 + 4));
                            ((GeoPoint)((Object)linkedList)).longitudeWE = n5;
                            ((GeoPoint)((Object)linkedList)).longitudeDegrees = Integer.parseInt(((String)object2).substring(n5, n5 + n6));
                            ((GeoPoint)((Object)linkedList)).longitudeMinutes = Integer.parseInt(((String)object2).substring(n5 + n6, n5 + n6 + 2));
                            ((GeoPoint)((Object)linkedList)).longitudeSeconds = Double.parseDouble(((String)object2).substring(n5 + n6 + 2));
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                        ((GeoPoint)((Object)linkedList)).updateLatLon();
                        ((GeoPoint)((Object)linkedList)).convertFromNAD27();
                        ((GeoPoint)((Object)linkedList)).updateDMS();
                        if (null != geoPoint && d > 0.0 && geoPoint.distanceTo((GeoPoint)((Object)linkedList), d2) > d) continue;
                        extDbRecordTV = new ExtDbRecordTV(extDb);
                        extDbRecordTV.extRecordID = BASELINE_ID_PREFIX + String.valueOf(n2);
                        extDbRecordTV.isBaseline = true;
                        extDbRecordTV.service = service;
                        string2 = dbConnection.getString(3);
                        if (null == string2) {
                            string2 = "";
                        } else if (string2.length() > 12) {
                            string2 = string2.substring(0, 12);
                        }
                        extDbRecordTV.callSign = string2;
                        string2 = dbConnection.getString(4);
                        if (null == string2) {
                            string2 = "";
                        } else if (string2.length() > 20) {
                            string2 = string2.substring(0, 20);
                        }
                        extDbRecordTV.city = string2;
                        string2 = dbConnection.getString(5);
                        if (null == string2) {
                            string2 = "";
                        } else if (string2.length() > 2) {
                            string2 = string2.substring(0, 2);
                        }
                        extDbRecordTV.state = string2;
                        extDbRecordTV.country = country;
                        extDbRecordTV.facilityID = n2;
                        extDbRecordTV.channel = n;
                        extDbRecordTV.zoneCode = "";
                        extDbRecordTV.status = BASELINE_STATUS;
                        extDbRecordTV.statusType = 4;
                        extDbRecordTV.filePrefix = BASELINE_ID_PREFIX;
                        extDbRecordTV.appARN = String.valueOf(n2);
                        extDbRecordTV.frequencyOffsetCode = "";
                        extDbRecordTV.emissionMaskCode = "";
                        extDbRecordTV.location.setLatLon((GeoPoint)((Object)linkedList));
                        extDbRecordTV.heightAMSL = dbConnection.getDouble(8);
                        extDbRecordTV.overallHAAT = dbConnection.getDouble(9);
                        extDbRecordTV.peakERP = dbConnection.getDouble(10);
                        string2 = dbConnection.getString(11);
                        if (null != string2) {
                            extDbRecordTV.daIndicated = string2.equalsIgnoreCase("Y");
                        }
                        if ((n3 = dbConnection.getInt(12)) > 0) {
                            extDbRecordTV.antennaID = extDbRecordTV.antennaRecordID = String.valueOf(n3);
                        }
                        extDbRecordTV.horizontalPatternOrientation = Math.IEEEremainder(dbConnection.getDouble(13), 360.0);
                        if (extDbRecordTV.horizontalPatternOrientation < 0.0) {
                            extDbRecordTV.horizontalPatternOrientation += 360.0;
                        }
                        extDbRecordTV.sequenceDate = date;
                        linkedList2.add(extDbRecordTV);
                    }
                } else {
                    if (!bl) {
                        hashMap = new HashMap<String, ExtDbRecordTV>();
                    }
                    while (dbConnection.next()) {
                        if (extDb.version > 2 && (null == (service = ExtDbRecordTV.getService(extDb.type, dbConnection.getString(21))) || null == (country = Country.getCountry(dbConnection.getString(22)))) || (n2 = dbConnection.getInt(1)) <= 0 || (n = dbConnection.getInt(2)) < 2 || n > 69) continue;
                        ((GeoPoint)((Object)linkedList)).latitudeNS = 0;
                        object3 = dbConnection.getString(6);
                        if (null != object3 && ((String)object3).equalsIgnoreCase("S")) {
                            ((GeoPoint)((Object)linkedList)).latitudeNS = 1;
                        }
                        ((GeoPoint)((Object)linkedList)).latitudeDegrees = dbConnection.getInt(7);
                        ((GeoPoint)((Object)linkedList)).latitudeMinutes = dbConnection.getInt(8);
                        ((GeoPoint)((Object)linkedList)).latitudeSeconds = dbConnection.getDouble(9);
                        ((GeoPoint)((Object)linkedList)).longitudeWE = 0;
                        object3 = dbConnection.getString(10);
                        if (null != object3 && ((String)object3).equalsIgnoreCase("E")) {
                            ((GeoPoint)((Object)linkedList)).longitudeWE = 1;
                        }
                        ((GeoPoint)((Object)linkedList)).longitudeDegrees = dbConnection.getInt(11);
                        ((GeoPoint)((Object)linkedList)).longitudeMinutes = dbConnection.getInt(12);
                        ((GeoPoint)((Object)linkedList)).longitudeSeconds = dbConnection.getDouble(13);
                        ((GeoPoint)((Object)linkedList)).updateLatLon();
                        if (null != geoPoint && d > 0.0 && geoPoint.distanceTo((GeoPoint)((Object)linkedList), d2) > d) continue;
                        extDbRecordTV = new ExtDbRecordTV(extDb);
                        extDbRecordTV.extRecordID = BASELINE_ID_PREFIX + String.valueOf(n2);
                        extDbRecordTV.isBaseline = true;
                        extDbRecordTV.service = service;
                        string2 = dbConnection.getString(3);
                        if (null == string2) {
                            string2 = "";
                        } else if (string2.length() > 12) {
                            string2 = string2.substring(0, 12);
                        }
                        extDbRecordTV.callSign = string2;
                        string2 = dbConnection.getString(4);
                        if (null == string2) {
                            string2 = "";
                        } else if (string2.length() > 20) {
                            string2 = string2.substring(0, 20);
                        }
                        extDbRecordTV.city = string2;
                        string2 = dbConnection.getString(5);
                        if (null == string2) {
                            string2 = "";
                        } else if (string2.length() > 2) {
                            string2 = string2.substring(0, 2);
                        }
                        extDbRecordTV.state = string2;
                        extDbRecordTV.country = country;
                        extDbRecordTV.facilityID = n2;
                        extDbRecordTV.channel = n;
                        extDbRecordTV.zoneCode = "";
                        extDbRecordTV.status = BASELINE_STATUS;
                        extDbRecordTV.statusType = 4;
                        extDbRecordTV.filePrefix = BASELINE_ID_PREFIX;
                        extDbRecordTV.appARN = String.valueOf(n2);
                        extDbRecordTV.frequencyOffsetCode = "";
                        extDbRecordTV.emissionMaskCode = extDb.version > 3 ? dbConnection.getString(23) : "";
                        extDbRecordTV.location.setLatLon((GeoPoint)((Object)linkedList));
                        extDbRecordTV.heightAMSL = dbConnection.getDouble(14);
                        extDbRecordTV.overallHAAT = dbConnection.getDouble(15);
                        extDbRecordTV.peakERP = dbConnection.getDouble(16);
                        string2 = dbConnection.getString(17);
                        if (null != string2) {
                            extDbRecordTV.daIndicated = string2.equalsIgnoreCase("Y");
                        }
                        if (null != (string2 = dbConnection.getString(18)) && 0 == (string2 = string2.trim()).length()) {
                            string2 = null;
                        }
                        extDbRecordTV.antennaID = extDbRecordTV.antennaRecordID = string2;
                        extDbRecordTV.horizontalPatternOrientation = Math.IEEEremainder(dbConnection.getDouble(19), 360.0);
                        if (extDbRecordTV.horizontalPatternOrientation < 0.0) {
                            extDbRecordTV.horizontalPatternOrientation += 360.0;
                        }
                        if (extDb.version > 4) {
                            extDbRecordTV.verticalPatternElectricalTilt = dbConnection.getDouble(24);
                        }
                        extDbRecordTV.sequenceDate = date;
                        string2 = dbConnection.getString(20);
                        if (!bl && null != string2 && string2.length() > 0) {
                            hashMap.put(string2, extDbRecordTV);
                            continue;
                        }
                        linkedList2.add(extDbRecordTV);
                    }
                }
                extDb.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                extDb.releaseDb(dbConnection);
                linkedList2 = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        if (null != linkedList2 && null != hashMap && !hashMap.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("app_location.aloc_aapp_application_id IN ");
            n = 40;
            for (Object object3 : hashMap.keySet()) {
                stringBuilder.append((char)n);
                stringBuilder.append('\'');
                stringBuilder.append((String)object3);
                stringBuilder.append('\'');
                n = 44;
            }
            stringBuilder.append(')');
            linkedList = ExtDbRecordTV.findRecordsTV(extDb, stringBuilder.toString(), false, null, 0.0, 0.0, null, errorLogger);
            if (null == linkedList) {
                linkedList2 = null;
            } else {
                for (ExtDbRecordTV extDbRecordTV : linkedList) {
                    if (!extDbRecordTV.service.isDTS || null == (object3 = (ExtDbRecordTV)hashMap.remove(extDbRecordTV.extRecordID))) continue;
                    extDbRecordTV.extRecordID = ((ExtDbRecordTV)object3).extRecordID;
                    extDbRecordTV.isBaseline = ((ExtDbRecordTV)object3).isBaseline;
                    extDbRecordTV.facilityID = ((ExtDbRecordTV)object3).facilityID;
                    if (((ExtDbRecordTV)object3).channel != extDbRecordTV.channel) {
                        extDbRecordTV.replicateToChannel = ((ExtDbRecordTV)object3).channel;
                    }
                    extDbRecordTV.status = ((ExtDbRecordTV)object3).status;
                    extDbRecordTV.statusType = ((ExtDbRecordTV)object3).statusType;
                    extDbRecordTV.filePrefix = ((ExtDbRecordTV)object3).filePrefix;
                    extDbRecordTV.appARN = ((ExtDbRecordTV)object3).appARN;
                    extDbRecordTV.isArchived = ((ExtDbRecordTV)object3).isArchived;
                    extDbRecordTV.isPending = ((ExtDbRecordTV)object3).isPending;
                    for (ExtDbRecordTV extDbRecordTV2 : extDbRecordTV.dtsRecords) {
                        extDbRecordTV2.extRecordID = extDbRecordTV.extRecordID;
                        extDbRecordTV2.isBaseline = extDbRecordTV.isBaseline;
                        extDbRecordTV2.facilityID = extDbRecordTV.facilityID;
                        extDbRecordTV2.replicateToChannel = extDbRecordTV.replicateToChannel;
                        extDbRecordTV2.status = extDbRecordTV.status;
                        extDbRecordTV2.statusType = extDbRecordTV.statusType;
                        extDbRecordTV2.filePrefix = extDbRecordTV.filePrefix;
                        extDbRecordTV2.appARN = extDbRecordTV.appARN;
                        extDbRecordTV2.isArchived = extDbRecordTV.isArchived;
                        extDbRecordTV2.isPending = extDbRecordTV.isPending;
                    }
                    linkedList2.add(extDbRecordTV);
                }
                linkedList2.addAll(hashMap.values());
            }
        }
        return linkedList2;
    }

    public static BaselineIndex getBaselineIndex(ExtDb extDb) {
        return ExtDbRecordTV.getBaselineIndex(extDb, null);
    }

    public static BaselineIndex getBaselineIndex(ExtDb extDb, ErrorLogger errorLogger) {
        BaselineIndex baselineIndex = new BaselineIndex();
        baselineIndex.index = new HashMap();
        baselineIndex.preIndex = new HashMap();
        if (!ExtDbRecordTV.isExtDbSupported(extDb)) {
            return baselineIndex;
        }
        boolean bl = 1 == extDb.type;
        DbConnection dbConnection = extDb.connectDb(errorLogger);
        if (null == dbConnection) {
            return null;
        }
        try {
            if (bl) {
                dbConnection.query("SELECT facility_id, post_dtv_channel, ntsc_channel FROM dtv_channel_assignments");
            } else if (5 == extDb.type) {
                dbConnection.query("SELECT (CASE WHEN TRIM(app_dtv_channel_assignment.adca_facility_record_id) IN ('','null') THEN 0::INT ELSE app_dtv_channel_assignment.adca_facility_record_id::INT END), lkp_dtv_allotment.rdta_digital_channel, app_dtv_channel_assignment.pre_auction_channel, lkp_dtv_allotment.rdta_country_code FROM mass_media.app_dtv_channel_assignment JOIN mass_media.lkp_dtv_allotment ON (lkp_dtv_allotment.rdta_dtv_allotment_id = app_dtv_channel_assignment.dtv_allotment_id)");
            } else {
                dbConnection.query("SELECT app_dtv_channel_assignment.adca_facility_record_id, lkp_dtv_allotment.rdta_digital_channel, app_dtv_channel_assignment.pre_auction_channel, lkp_dtv_allotment.rdta_country_code FROM app_dtv_channel_assignment JOIN lkp_dtv_allotment ON (lkp_dtv_allotment.rdta_dtv_allotment_id = app_dtv_channel_assignment.dtv_allotment_id)");
            }
            while (dbConnection.next()) {
                int n = dbConnection.getInt(1);
                if (n <= 0) continue;
                int n2 = dbConnection.getInt(2);
                if (n2 >= 2 && n2 <= 69) {
                    Country country;
                    baselineIndex.index.put(n, n2);
                    if (!bl && null != (country = Country.getCountry(dbConnection.getString(4)))) {
                        if (2 == country.key) {
                            baselineIndex.hasCA = true;
                        }
                        if (3 == country.key) {
                            baselineIndex.hasMX = true;
                        }
                    }
                }
                if ((n2 = dbConnection.getInt(3)) < 2 || n2 > 69) continue;
                baselineIndex.preIndex.put(n, n2);
            }
            extDb.releaseDb(dbConnection);
        }
        catch (SQLException sQLException) {
            extDb.releaseDb(dbConnection);
            baselineIndex = null;
            DbConnection.reportError(errorLogger, sQLException);
        }
        return baselineIndex;
    }

    public static ExtDbRecordTV findRecordTV(String string, Integer n, String string2) {
        return ExtDbRecordTV.findRecordTV(string, n, string2, null);
    }

    public static ExtDbRecordTV findRecordTV(String string, Integer n, String string2, ErrorLogger errorLogger) {
        ExtDb extDb = ExtDb.getExtDb(string, n, errorLogger);
        if (null == extDb) {
            return null;
        }
        return ExtDbRecordTV.findRecordTV(extDb, string2, errorLogger);
    }

    public static ExtDbRecordTV findRecordTV(ExtDb extDb, String string) {
        return ExtDbRecordTV.findRecordTV(extDb, string, null);
    }

    public static ExtDbRecordTV findRecordTV(ExtDb extDb, String string, ErrorLogger errorLogger) {
        if (!ExtDbRecordTV.isExtDbSupported(extDb)) {
            return null;
        }
        boolean bl = false;
        int n = 0;
        if (string.toUpperCase().startsWith(BASELINE_ID_PREFIX)) {
            try {
                n = Integer.parseInt(string.substring(BASELINE_ID_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n > 0) {
                bl = true;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (bl) {
                ExtDbRecordTV.addBaselineFacilityIDQuery(extDb.type, extDb.version, n, stringBuilder, false);
            } else {
                ExtDbRecordTV.addRecordIDQueryTV(extDb.type, extDb.version, string, stringBuilder, false);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (null != errorLogger) {
                errorLogger.logMessage(illegalArgumentException.getMessage());
            }
            return null;
        }
        LinkedList<ExtDbRecordTV> linkedList = bl ? ExtDbRecordTV.findBaselineRecords(extDb, stringBuilder.toString(), null, 0.0, 0.0, false, errorLogger) : ExtDbRecordTV.findRecordsTV(extDb, stringBuilder.toString(), true, null, 0.0, 0.0, null, errorLogger);
        if (null == linkedList) {
            return null;
        }
        if (linkedList.isEmpty()) {
            if (null != errorLogger) {
                errorLogger.logMessage("Record not found for record ID '" + string + "'");
            }
            return null;
        }
        return linkedList.getFirst();
    }

    public static HashMap<String, ExtDbRecordTV> batchFindRecordTV(ExtDb extDb, HashSet<String> hashSet) {
        return ExtDbRecordTV.batchFindRecordTV(extDb, hashSet, null);
    }

    /*
     * WARNING - void declaration
     */
    public static HashMap<String, ExtDbRecordTV> batchFindRecordTV(ExtDb extDb, HashSet<String> hashSet, ErrorLogger errorLogger) {
        LinkedList<ExtDbRecordTV> linkedList;
        HashMap<String, ExtDbRecordTV> hashMap = new HashMap<String, ExtDbRecordTV>();
        if (!ExtDbRecordTV.isExtDbSupported(extDb)) {
            return hashMap;
        }
        boolean bl = 1 == extDb.type;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "(";
        if (bl) {
            stringBuilder.append("tv_eng_data.application_id IN ");
        } else {
            stringBuilder.append("UPPER(app_location.aloc_aapp_application_id) IN ");
            string = "('";
        }
        boolean bl3 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = "(";
        if (bl) {
            stringBuilder2.append("dtv_channel_assignments.facility_id IN ");
        } else {
            stringBuilder2.append("app_dtv_channel_assignment.adca_facility_record_id IN ");
            if (5 == extDb.type) {
                string2 = "('";
            }
        }
        for (String string3 : hashSet) {
            String string4 = string3.toUpperCase();
            int n = 0;
            if (string4.startsWith(BASELINE_ID_PREFIX)) {
                try {
                    n = Integer.parseInt(string4.substring(BASELINE_ID_PREFIX.length()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n <= 0) {
                void var14_19;
                if (bl) {
                    int n2 = 0;
                    try {
                        n2 = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (n2 <= 0) continue;
                    String string5 = String.valueOf(n2);
                } else {
                    String string6 = DbConnection.clean(string4);
                }
                stringBuilder.append(string);
                stringBuilder.append((String)var14_19);
                string = bl ? "," : "','";
                bl2 = true;
                continue;
            }
            stringBuilder2.append(string2);
            stringBuilder2.append(String.valueOf(n));
            string2 = 5 == extDb.type ? "','" : ",";
            bl3 = true;
        }
        if (bl2) {
            if (bl) {
                stringBuilder.append(")");
            } else {
                stringBuilder.append("')");
            }
            linkedList = ExtDbRecordTV.findRecordsTV(extDb, stringBuilder.toString(), true, null, 0.0, 0.0, null, errorLogger);
            if (null == linkedList) {
                return null;
            }
            for (ExtDbRecordTV extDbRecordTV : linkedList) {
                hashMap.put(extDbRecordTV.extRecordID, extDbRecordTV);
            }
        }
        if (bl3) {
            if (5 == extDb.type) {
                stringBuilder2.append("')");
            } else {
                stringBuilder2.append(')');
            }
            linkedList = ExtDbRecordTV.findBaselineRecords(extDb, stringBuilder2.toString(), null, 0.0, 0.0, false, errorLogger);
            if (null == linkedList) {
                return null;
            }
            for (ExtDbRecordTV extDbRecordTV : linkedList) {
                hashMap.put(extDbRecordTV.extRecordID, extDbRecordTV);
            }
        }
        return hashMap;
    }

    public static boolean doesRecordIDExistTV(ExtDb extDb, String string) {
        if (!ExtDbRecordTV.isExtDbSupported(extDb)) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        if (string.toUpperCase().startsWith(BASELINE_ID_PREFIX)) {
            try {
                n = Integer.parseInt(string.substring(BASELINE_ID_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n > 0) {
                bl = true;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (bl) {
                ExtDbRecordTV.addBaselineFacilityIDQuery(extDb.type, extDb.version, n, stringBuilder, false);
            } else {
                ExtDbRecordTV.addRecordIDQueryTV(extDb.type, extDb.version, string, stringBuilder, false);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        DbConnection dbConnection = extDb.connectDb();
        if (null == dbConnection) {
            return false;
        }
        boolean bl2 = false;
        try {
            if (bl) {
                if (1 == extDb.type) {
                    dbConnection.query("SELECT COUNT(*) FROM dtv_channel_assignments WHERE " + stringBuilder.toString());
                } else if (5 == extDb.type) {
                    dbConnection.query("SELECT COUNT(*) FROM mass_media.app_dtv_channel_assignment WHERE " + stringBuilder.toString());
                } else {
                    dbConnection.query("SELECT COUNT(*) FROM app_dtv_channel_assignment WHERE " + stringBuilder.toString());
                }
            } else if (1 == extDb.type) {
                dbConnection.query("SELECT COUNT(*) FROM tv_eng_data WHERE " + stringBuilder.toString());
            } else if (5 == extDb.type) {
                dbConnection.query("SELECT COUNT(*) FROM mass_media.app_location WHERE " + stringBuilder.toString());
            } else {
                dbConnection.query("SELECT COUNT(*) FROM app_location WHERE " + stringBuilder.toString());
            }
            if (dbConnection.next()) {
                bl2 = dbConnection.getInt(1) > 0;
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        extDb.releaseDb(dbConnection);
        return bl2;
    }

    public static boolean addRecordIDQueryTV(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            if (1 == n) {
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("The record ID must be a number");
                }
                if (n3 <= 0) {
                    throw new IllegalArgumentException("The record ID must be greater than 0");
                }
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(tv_eng_data.application_id = ");
                stringBuilder.append(string);
                stringBuilder.append(')');
            } else {
                stringBuilder.append("(UPPER(app_location.aloc_aapp_application_id) = '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append("')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addFileNumberQueryTV(int n, int n2, String string, String string2, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                if (string.length() > 0) {
                    stringBuilder.append("((UPPER(application.file_prefix) = '");
                    stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                    stringBuilder.append("') AND (UPPER(application.app_arn) = '");
                    stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
                    stringBuilder.append("'))");
                } else {
                    stringBuilder.append("(UPPER(application.app_arn) = '");
                    stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
                    stringBuilder.append("')");
                }
            } else if (5 == n) {
                if (string.length() > 0) {
                    stringBuilder.append("(UPPER(application.aapp_file_num) = '");
                    stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                    stringBuilder.append('-');
                    stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
                } else {
                    stringBuilder.append("(UPPER(application.aapp_file_num) LIKE '%");
                    stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
                }
                stringBuilder.append("')");
            } else {
                if (string.length() > 0) {
                    stringBuilder.append("(application._search_filenum = '");
                    stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                    stringBuilder.append('-');
                    stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
                } else {
                    stringBuilder.append("(application._search_arn = '");
                    stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
                }
                stringBuilder.append("')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addFacilityIDQueryTV(int n, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(tv_eng_data.facility_id = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(')');
            } else {
                stringBuilder.append("(application_facility.afac_facility_id = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addServiceQueryTV(int n, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(tv_eng_data.vsd_service IN ");
            } else {
                stringBuilder.append("(license_filing_version.service_code IN ");
            }
            ExtDbRecordTV.addServiceCodeList(n, 1, n3, stringBuilder);
            stringBuilder.append(')');
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addServiceTypeQueryTV(int n, int n2, int n3, int n4, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(tv_eng_data.vsd_service IN ");
            } else {
                stringBuilder.append("(license_filing_version.service_code IN ");
            }
            ExtDbRecordTV.addServiceCodeList(n, 1, n3, n4, stringBuilder);
            stringBuilder.append(')');
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addCallSignQueryTV(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(UPPER(CASE WHEN (facility.fac_callsign <> '') THEN facility.fac_callsign ELSE application.fac_callsign END) REGEXP '^D*");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append(".*')");
            } else if (5 == n) {
                stringBuilder.append("(UPPER(facility.callsign) ~ '^D*");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append(".*')");
            } else {
                stringBuilder.append("(facility._search_callsign LIKE '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append("%')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addChannelQueryTV(int n, int n2, int n3, int n4, int n5, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (n4 > 0 && n5 > 0 && (n3 < n4 || n3 > n5)) {
                throw new IllegalArgumentException("The channel must be in the range " + n4 + " to " + n5);
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(tv_eng_data.station_channel = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(')');
            } else if (5 == n) {
                stringBuilder.append("(CASE WHEN TRIM(application_facility.afac_channel) IN ('','null') THEN false ELSE (application_facility.afac_channel::INT = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(") END)");
            } else {
                stringBuilder.append("(application_facility.afac_channel = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addChannelRangeQueryTV(int n, int n2, int n3, int n4, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(tv_eng_data.station_channel BETWEEN ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(" AND ");
                stringBuilder.append(String.valueOf(n4));
                stringBuilder.append(')');
            } else if (5 == n) {
                stringBuilder.append("(CASE WHEN TRIM(application_facility.afac_channel) IN ('','null') THEN false ELSE (application_facility.afac_channel::INT BETWEEN ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(" AND ");
                stringBuilder.append(String.valueOf(n4));
                stringBuilder.append(") END)");
            } else {
                stringBuilder.append("(application_facility.afac_channel BETWEEN ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(" AND ");
                stringBuilder.append(String.valueOf(n4));
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addMultipleChannelQueryTV(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(tv_eng_data.station_channel IN ");
                stringBuilder.append(string);
                stringBuilder.append(')');
            } else if (5 == n) {
                stringBuilder.append("(CASE WHEN TRIM(application_facility.afac_channel) IN ('','null') THEN false ELSE (application_facility.afac_channel::INT IN ");
                stringBuilder.append(string);
                stringBuilder.append(") END)");
            } else {
                stringBuilder.append("(application_facility.afac_channel IN ");
                stringBuilder.append(string);
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addStatusQueryTV(int n, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            switch (n3) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown status code");
                }
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                if (5 == n3) {
                    stringBuilder.append("(facility.fac_status = 'EXPER')");
                } else if (0 == n3) {
                    stringBuilder.append("(UPPER(application.app_type) IN ('STA', 'STAX'))");
                } else if (6 == n3) {
                    stringBuilder.append("(false)");
                } else {
                    stringBuilder.append("(UPPER(tv_eng_data.tv_dom_status) IN ");
                    String string = "('";
                    for (int i = 0; i < CDBS_STATUS_TYPES.length; ++i) {
                        if (CDBS_STATUS_TYPES[i] != n3) continue;
                        stringBuilder.append(string);
                        stringBuilder.append(CDBS_STATUS_CODES[i]);
                        string = "','";
                    }
                    stringBuilder.append("'))");
                }
            } else if (5 == n3) {
                stringBuilder.append("(facility.facility_status = 'EXPER')");
            } else if (0 == n3) {
                stringBuilder.append("((facility.facility_status <> 'EXPER') AND ");
                stringBuilder.append("(UPPER(license_filing_version.auth_type_code) = 'S'))");
            } else {
                stringBuilder.append("((facility.facility_status <> 'EXPER') AND ");
                stringBuilder.append("(UPPER(license_filing_version.auth_type_code) <> 'S') AND ");
                if (6 == n3) {
                    stringBuilder.append("(UPPER(license_filing_version.current_status_code = 'REV')))");
                } else {
                    if (3 == n3) {
                        stringBuilder.append("(((UPPER(license_filing_version.auth_type_code) = 'C') AND ");
                        stringBuilder.append("(UPPER(license_filing_version.current_status_code) = 'PEN')) OR ");
                        stringBuilder.append("(UPPER(license_filing_version.current_status_code) IN ");
                    } else {
                        stringBuilder.append("(((UPPER(license_filing_version.auth_type_code) <> 'C') OR ");
                        stringBuilder.append("(UPPER(license_filing_version.current_status_code) <> 'PEN')) AND ");
                        stringBuilder.append("(UPPER(license_filing_version.current_status_code) NOT IN ");
                    }
                    String string = "('";
                    for (int i = 0; i < LMS_APP_STATUS_CODES.length; ++i) {
                        stringBuilder.append(string);
                        stringBuilder.append(LMS_APP_STATUS_CODES[i]);
                        string = "','";
                    }
                    stringBuilder.append("')))");
                    if (3 == n3) {
                        stringBuilder.append(')');
                    } else if (1 == n3) {
                        stringBuilder.append(" AND (UPPER(license_filing_version.auth_type_code) = 'C'))");
                    } else if (2 == n3) {
                        stringBuilder.append(" AND (UPPER(license_filing_version.auth_type_code) = 'L'))");
                    }
                }
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addCityQueryTV(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(UPPER(CASE WHEN (facility.comm_city <> '') THEN facility.comm_city ELSE application.comm_city END) LIKE '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()).replace('*', '%'));
                stringBuilder.append("%')");
            } else if (5 == n) {
                stringBuilder.append("(UPPER(CASE WHEN (facility.community_served_city <> '') THEN facility.community_served_city ELSE application_facility.afac_community_city END) LIKE '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()).replace('*', '%'));
                stringBuilder.append("%')");
            } else {
                stringBuilder.append("(facility._search_city LIKE '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()).replace('*', '%'));
                stringBuilder.append("%')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addStateQueryTV(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(UPPER(CASE WHEN (facility.comm_state <> '') THEN facility.comm_state ELSE application.comm_state END) = '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append("')");
            } else {
                stringBuilder.append("(UPPER(CASE WHEN (facility.community_served_state <> '') THEN facility.community_served_state ELSE application_facility.afac_community_state_code END) = '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append("')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addCountryQueryTV(int n, int n2, Country country, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(UPPER(facility.fac_country) = '");
                stringBuilder.append(country.countryCode);
                stringBuilder.append("')");
            } else {
                stringBuilder.append("(UPPER(application_facility.country_code) = '");
                stringBuilder.append(country.countryCode);
                stringBuilder.append("')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addRecordTypeQueryTV(int n, int n2, boolean bl, StringBuilder stringBuilder, boolean bl2) {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                return false;
            }
            if (bl2) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("((tv_eng_data.eng_record_type NOT IN ('A','R')) AND ");
                stringBuilder.append("(facility.fac_status <> 'FVOID'))");
            } else {
                stringBuilder.append("((license_filing_version.active_ind = 'Y') AND ");
                stringBuilder.append("(application.dts_reference_ind <> 'R')");
                stringBuilder.append(" AND (facility.facility_status <> 'FVOID')");
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addBaselineRecordIDQuery(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            if (string.toUpperCase().startsWith(BASELINE_ID_PREFIX)) {
                string = string.substring(BASELINE_ID_PREFIX.length());
            }
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n3 <= 0) {
                throw new IllegalArgumentException("Invalid baseline record ID");
            }
            return ExtDbRecordTV.addBaselineFacilityIDQuery(n, n2, n3, stringBuilder, bl);
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addBaselineFacilityIDQuery(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (null == string || 0 == string.length()) {
            return false;
        }
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The facility ID must be a number");
        }
        return ExtDbRecordTV.addBaselineFacilityIDQuery(n, n2, n3, stringBuilder, bl);
    }

    public static boolean addBaselineFacilityIDQuery(int n, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (n3 <= 0) {
                stringBuilder.append("(false)");
                return true;
            }
            if (1 == n) {
                stringBuilder.append("(dtv_channel_assignments.facility_id = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(')');
            } else if (5 == n) {
                stringBuilder.append("(CASE WHEN TRIM(app_dtv_channel_assignment.adca_facility_record_id) IN ('','null') THEN false ELSE (app_dtv_channel_assignment.adca_facility_record_id::INT = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(") END)");
            } else {
                stringBuilder.append("(app_dtv_channel_assignment.adca_facility_record_id = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addBaselineServiceQuery(int n, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            Service service = Service.getService(n3);
            if (1 == n || n2 < 3) {
                if (null != service && service.serviceCode.equals("DT")) {
                    stringBuilder.append("(true)");
                } else {
                    stringBuilder.append("(false)");
                }
            } else if (null != service && service.isDTS) {
                stringBuilder.append("(lkp_dtv_allotment.dts_ref_application_id <> '')");
            } else {
                stringBuilder.append("((lkp_dtv_allotment.rdta_service_code IN ");
                ExtDbRecordTV.addServiceCodeList(n, 1, n3, stringBuilder);
                stringBuilder.append(") AND (lkp_dtv_allotment.dts_ref_application_id = ''))");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addBaselineCallSignQuery(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(UPPER(CASE WHEN (facility.fac_callsign <> '') THEN facility.fac_callsign ELSE dtv_channel_assignments.callsign END) REGEXP '^D*");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append(".*')");
            } else if (5 == n) {
                stringBuilder.append("(UPPER(facility.callsign) ~ '^D*");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append(".*')");
            } else {
                stringBuilder.append("(facility._search_callsign LIKE '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append("%')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addBaselineChannelQuery(int n, int n2, String string, int n3, int n4, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            int n5 = 0;
            try {
                n5 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("The channel must be a number");
            }
            if (n3 > 0 && n4 > 0 && (n5 < n3 || n5 > n4)) {
                throw new IllegalArgumentException("The channel must be in the range " + n3 + " to " + n4);
            }
            return ExtDbRecordTV.addBaselineChannelQuery(n, n2, n5, stringBuilder, bl);
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addBaselineChannelQuery(int n, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(dtv_channel_assignments.post_dtv_channel = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(')');
            } else {
                stringBuilder.append("(lkp_dtv_allotment.rdta_digital_channel = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addBaselineChannelRangeQuery(int n, int n2, int n3, int n4, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(dtv_channel_assignments.post_dtv_channel BETWEEN ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(" AND ");
                stringBuilder.append(String.valueOf(n4));
                stringBuilder.append(')');
            } else {
                stringBuilder.append("(lkp_dtv_allotment.rdta_digital_channel BETWEEN ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(" AND ");
                stringBuilder.append(String.valueOf(n4));
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addBaselineMultipleChannelQuery(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(dtv_channel_assignments.post_dtv_channel IN ");
                stringBuilder.append(string);
                stringBuilder.append(')');
            } else {
                stringBuilder.append("(lkp_dtv_allotment.rdta_digital_channel IN ");
                stringBuilder.append(string);
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addBaselineCityQuery(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(UPPER(CASE WHEN (facility.comm_city <> '') THEN facility.comm_city ELSE dtv_channel_assignments.city END) LIKE '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()).replace('*', '%'));
                stringBuilder.append("%')");
            } else {
                stringBuilder.append("(UPPER(CASE WHEN (facility.community_served_city <> '' ) THEN facility.community_served_city ELSE lkp_dtv_allotment.rdta_city END) LIKE '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()).replace('*', '%'));
                stringBuilder.append("%')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addBaselineStateQuery(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n) {
                stringBuilder.append("(UPPER(CASE WHEN (facility.comm_state <> '') THEN facility.comm_state ELSE dtv_channel_assignments.state END) = '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append("')");
            } else {
                stringBuilder.append("(UPPER(CASE WHEN (facility.community_served_state <> '' ) THEN facility.community_served_state ELSE lkp_dtv_allotment.rdta_state END) = '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append("')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addBaselineCountryQuery(int n, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        Country country = Country.getCountry(n3);
        if (null == country) {
            throw new IllegalArgumentException("Unknown country key");
        }
        return ExtDbRecordTV.addBaselineCountryQuery(n, n2, country, stringBuilder, bl);
    }

    public static boolean addBaselineCountryQuery(int n, int n2, Country country, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (1 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (1 == n || n2 < 3) {
                if (1 == country.key) {
                    stringBuilder.append("(true)");
                } else {
                    stringBuilder.append("(false)");
                }
            } else {
                stringBuilder.append("(UPPER(lkp_dtv_allotment.rdta_country_code) = '");
                stringBuilder.append(country.countryCode);
                stringBuilder.append("')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static int addRecords(ExtDb extDb, boolean bl, ScenarioEditData scenarioEditData, int n, String string, GeoPoint geoPoint, double d, int n2, int n3, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, ErrorLogger errorLogger) {
        Object object;
        int n4;
        Object object2;
        Cloneable cloneable;
        Collection collection;
        ArrayList<SourceEditData> arrayList;
        StringBuilder stringBuilder;
        boolean bl7;
        double d2;
        double d3;
        int n5;
        block77: {
            n5 = scenarioEditData.study.study.studyType;
            if (!ExtDbRecordTV.isExtDbSupported(extDb) || !Study.isRecordTypeAllowed(n5, 1) || (1 == n || 3 == n) && 1 != n5) {
                return 0;
            }
            d3 = scenarioEditData.study.getCoChannelMxDistance();
            d2 = scenarioEditData.study.getKilometersPerDegree();
            bl7 = scenarioEditData.study.getCheckIndividualDTSDistance();
            int n6 = scenarioEditData.study.getMinimumChannel();
            int n7 = scenarioEditData.study.getMaximumChannel();
            if (n2 > n6) {
                n6 = n2;
            }
            if (n3 > 0 && n3 < n7) {
                n7 = n3;
            }
            if (n6 > n7) {
                return 0;
            }
            stringBuilder = new StringBuilder();
            boolean bl8 = false;
            if (null != string && string.length() > 0) {
                stringBuilder.append(string);
                bl8 = true;
            }
            arrayList = null;
            collection = null;
            if (1 == n) {
                try {
                    if (bl) {
                        ExtDbRecordTV.addBaselineChannelRangeQuery(extDb.type, extDb.version, n6, n7, stringBuilder, bl8);
                        break block77;
                    }
                    ExtDbRecordTV.addChannelRangeQueryTV(extDb.type, extDb.version, n6, n7, stringBuilder, bl8);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                if (3 == n) {
                    arrayList = scenarioEditData.sourceData.getUndesiredSources(1);
                    if (arrayList.isEmpty()) {
                        if (null != errorLogger) {
                            errorLogger.reportError("There are no undesired TV stations in the scenario");
                        }
                        return -1;
                    }
                } else {
                    arrayList = scenarioEditData.sourceData.getDesiredSources(1);
                    if (arrayList.isEmpty()) {
                        if (null != errorLogger) {
                            errorLogger.reportError("There are no desired TV stations in the scenario");
                        }
                        return -1;
                    }
                }
                cloneable = new HashMap();
                for (IxRuleEditData ixRuleEditData : scenarioEditData.study.ixRuleData.getActiveRows()) {
                    if (1 != ixRuleEditData.serviceType.recordType) continue;
                    object2 = (SearchDelta)((HashMap)cloneable).get(ixRuleEditData.channelDelta.delta);
                    if (null == object2) {
                        object2 = new SearchDelta();
                        ((SearchDelta)object2).delta = ixRuleEditData.channelDelta.delta;
                        ((SearchDelta)object2).analogOnly = ixRuleEditData.channelDelta.analogOnly;
                        ((SearchDelta)object2).maximumDistance = ixRuleEditData.distance;
                        ((HashMap)cloneable).put(((SearchDelta)object2).delta, object2);
                        continue;
                    }
                    if (!(ixRuleEditData.distance > ((SearchDelta)object2).maximumDistance)) continue;
                    ((SearchDelta)object2).maximumDistance = ixRuleEditData.distance;
                }
                collection = ((HashMap)cloneable).values();
                int n8 = 0;
                int n9 = n7 - n6 + 1;
                boolean[] blArray = new boolean[n9];
                for (SourceEditData sourceEditData : arrayList) {
                    SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
                    for (SearchDelta object3 : collection) {
                        int n10;
                        int n11;
                        if (3 != n ? (n11 = (n10 = sourceEditDataTV.channel) + object3.delta) < n6 || n11 > n7 || blArray[n4 = n11 - n6] : (n10 = (n11 = sourceEditDataTV.channel) - object3.delta) < n6 || n10 > n7 || blArray[n4 = n10 - n6]) continue;
                        if (n10 < 5 ? n11 > 4 : (n10 < 7 ? n11 < 5 || n11 > 6 : (n10 < 14 ? n11 < 7 || n11 > 13 : n11 < 14))) continue;
                        blArray[n4] = true;
                        if (++n8 != n9) continue;
                        break;
                    }
                    if (n8 != n9) continue;
                    break;
                }
                if (0 == n8) {
                    return 0;
                }
                if (n8 < n9) {
                    StringBuilder stringBuilder2 = new StringBuilder();
                    int n12 = 40;
                    for (n4 = 0; n4 < n9; ++n4) {
                        if (!blArray[n4]) continue;
                        stringBuilder2.append((char)n12);
                        stringBuilder2.append(String.valueOf(n4 + n6));
                        n12 = 44;
                    }
                    stringBuilder2.append(')');
                    try {
                        if (bl) {
                            ExtDbRecordTV.addBaselineMultipleChannelQuery(extDb.type, extDb.version, stringBuilder2.toString(), stringBuilder, bl8);
                            break block77;
                        }
                        ExtDbRecordTV.addMultipleChannelQueryTV(extDb.type, extDb.version, stringBuilder2.toString(), stringBuilder, bl8);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    try {
                        if (bl) {
                            ExtDbRecordTV.addBaselineChannelRangeQuery(extDb.type, extDb.version, n6, n7, stringBuilder, bl8);
                        } else {
                            ExtDbRecordTV.addChannelRangeQueryTV(extDb.type, extDb.version, n6, n7, stringBuilder, bl8);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        cloneable = null;
        cloneable = bl ? ExtDbRecordTV.findBaselineRecords(extDb, stringBuilder.toString(), geoPoint, d, d2, false, errorLogger) : ExtDbRecordTV.findRecordsTV(extDb, stringBuilder.toString(), bl2, geoPoint, d, d2, null, errorLogger);
        if (null == cloneable) {
            return -1;
        }
        if (((AbstractCollection)((Object)cloneable)).isEmpty()) {
            return 0;
        }
        ExtDbRecordTV.removeAllMX(scenarioEditData, (LinkedList<ExtDbRecordTV>)cloneable, bl3, bl4, bl5, d3, d2);
        if (2 == n5) {
            object2 = (SourceEditDataTV)scenarioEditData.sourceData.getDesiredSource(1);
            object = null;
            ScenarioEditData scenarioEditData2 = scenarioEditData.study.scenarioData.get(0);
            if (2 == scenarioEditData2.scenarioType) {
                for (SourceEditData sourceEditData : scenarioEditData2.sourceData.getSources(1)) {
                    if (null == sourceEditData.getAttribute("-isProposal")) continue;
                    object = (SourceEditDataTV)sourceEditData;
                    break;
                }
            }
            ListIterator listIterator = ((LinkedList)cloneable).listIterator(0);
            while (listIterator.hasNext()) {
                ExtDbRecordTV extDbRecordTV = (ExtDbRecordTV)listIterator.next();
                if ((null == object2 || !ExtDbRecordTV.areRecordsMX(extDbRecordTV, (SourceEditDataTV)object2, true, 0.0, d2)) && (null == object || !ExtDbRecordTV.areRecordsMX(extDbRecordTV, (SourceEditDataTV)object, true, 0.0, d2))) continue;
                listIterator.remove();
            }
        }
        if (1 != n) {
            object2 = ((LinkedList)cloneable).listIterator(0);
            while (object2.hasNext()) {
                object = (ExtDbRecordTV)object2.next();
                boolean bl9 = true;
                for (SourceEditData sourceEditData : arrayList) {
                    boolean bl10;
                    int n13;
                    SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
                    if (3 == n) {
                        n4 = ((ExtDbRecordTV)object).replicateToChannel > 0 ? ((ExtDbRecordTV)object).replicateToChannel : ((ExtDbRecordTV)object).channel;
                        n13 = sourceEditDataTV.channel;
                        bl10 = ((ExtDbRecordTV)object).service.serviceType.digital;
                    } else {
                        n4 = sourceEditDataTV.channel;
                        n13 = ((ExtDbRecordTV)object).replicateToChannel > 0 ? ((ExtDbRecordTV)object).replicateToChannel : ((ExtDbRecordTV)object).channel;
                        bl10 = sourceEditDataTV.service.serviceType.digital;
                    }
                    if (n4 < 5 ? n13 > 4 : (n4 < 7 ? n13 < 5 || n13 > 6 : (n4 < 14 ? n13 < 7 || n13 > 13 : n13 < 14))) continue;
                    int n14 = n13 - n4;
                    for (SearchDelta searchDelta : collection) {
                        if (searchDelta.delta != n14 || searchDelta.analogOnly && bl10) continue;
                        if (3 == n) {
                            if (((ExtDbRecordTV)object).service.isDTS) {
                                for (ExtDbRecordTV extDbRecordTV : ((ExtDbRecordTV)object).dtsRecords) {
                                    double d4 = searchDelta.maximumDistance + extDbRecordTV.getRuleExtraDistance(scenarioEditData.study);
                                    if (sourceEditDataTV.isParent && bl7) {
                                        for (GeoPoint geoPoint2 : sourceEditDataTV.getDTSLocations()) {
                                            if (!(extDbRecordTV.location.distanceTo(geoPoint2, d2) <= d4)) continue;
                                            bl9 = false;
                                            break;
                                        }
                                        if (bl9) continue;
                                    } else {
                                        if (!(extDbRecordTV.location.distanceTo(sourceEditDataTV.location, d2) <= d4)) continue;
                                        bl9 = false;
                                    }
                                    break;
                                }
                            } else {
                                double d5 = searchDelta.maximumDistance + ((ExtDbRecordTV)object).getRuleExtraDistance(scenarioEditData.study);
                                if (sourceEditDataTV.isParent && bl7) {
                                    for (GeoPoint geoPoint3 : sourceEditDataTV.getDTSLocations()) {
                                        if (!(((ExtDbRecordTV)object).location.distanceTo(geoPoint3, d2) <= d5)) continue;
                                        bl9 = false;
                                        break;
                                    }
                                } else if (((ExtDbRecordTV)object).location.distanceTo(sourceEditDataTV.location, d2) <= d5) {
                                    bl9 = false;
                                }
                            }
                        } else if (sourceEditDataTV.isParent) {
                            for (SourceEditDataTV sourceEditDataTV2 : sourceEditDataTV.getDTSSources()) {
                                if (sourceEditDataTV2.siteNumber <= 0) continue;
                                double d6 = searchDelta.maximumDistance + sourceEditDataTV2.getRuleExtraDistance();
                                if (((ExtDbRecordTV)object).service.isDTS && bl7) {
                                    for (GeoPoint geoPoint2 : ((ExtDbRecordTV)object).getDTSLocations()) {
                                        if (!(sourceEditDataTV2.location.distanceTo(geoPoint2, d2) <= d6)) continue;
                                        bl9 = false;
                                        break;
                                    }
                                    if (bl9) continue;
                                } else {
                                    if (!(sourceEditDataTV2.location.distanceTo(((ExtDbRecordTV)object).location, d2) <= d6)) continue;
                                    bl9 = false;
                                }
                                break;
                            }
                        } else {
                            double d7 = searchDelta.maximumDistance + sourceEditDataTV.getRuleExtraDistance();
                            if (((ExtDbRecordTV)object).service.isDTS && bl7) {
                                for (GeoPoint geoPoint4 : ((ExtDbRecordTV)object).getDTSLocations()) {
                                    if (!(sourceEditDataTV.location.distanceTo(geoPoint4, d2) <= d7)) continue;
                                    bl9 = false;
                                    break;
                                }
                            } else if (sourceEditDataTV.location.distanceTo(((ExtDbRecordTV)object).location, d2) <= d7) {
                                bl9 = false;
                            }
                        }
                        if (bl9) continue;
                        break;
                    }
                    if (bl9) continue;
                    break;
                }
                if (!bl9) continue;
                object2.remove();
            }
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (null != errorLogger) {
            errorLogger.clearErrors();
        } else {
            errorLogger = new ErrorLogger(null, null);
        }
        Iterator iterator = ((AbstractSequentialList)((Object)cloneable)).iterator();
        while (iterator.hasNext()) {
            ExtDbRecordTV extDbRecordTV = (ExtDbRecordTV)iterator.next();
            object2 = scenarioEditData.study.findSharedSource(extDbRecordTV.extDb.key, extDbRecordTV.extRecordID);
            if (null == object2 && null == (object2 = SourceEditData.makeSource(extDbRecordTV, scenarioEditData.study, true, errorLogger))) {
                if (!errorLogger.hasErrors()) continue;
                return -1;
            }
            if (extDbRecordTV.replicateToChannel > 0) {
                object = (SourceEditDataTV)object2;
                object2 = scenarioEditData.study.findSharedReplicationSource(extDbRecordTV.extDb.key, extDbRecordTV.extRecordID, extDbRecordTV.replicateToChannel);
                if (null == object2) {
                    object2 = ((SourceEditDataTV)object).replicate(extDbRecordTV.replicateToChannel, errorLogger);
                }
                if (null == object2) {
                    if (!errorLogger.hasErrors()) continue;
                    return -1;
                }
                scenarioEditData.study.addOrReplaceSource((SourceEditData)object);
            }
            arrayList2.add(object2);
        }
        boolean bl11 = true;
        boolean bl12 = true;
        if (1 == n || 3 == n) {
            bl12 = bl3 ? false : bl6;
        } else {
            bl11 = false;
            if (bl3 && 2 != n5) {
                bl12 = false;
            }
        }
        for (SourceEditData sourceEditData : arrayList2) {
            if (null != sourceEditData.getAttribute("-isSharingGuest")) {
                scenarioEditData.sourceData.addOrReplace(sourceEditData, false, false);
                continue;
            }
            scenarioEditData.sourceData.addOrReplace(sourceEditData, bl11, bl12);
        }
        return arrayList2.size();
    }

    private static void removeAllMX(ScenarioEditData scenarioEditData, LinkedList<ExtDbRecordTV> linkedList, boolean bl, boolean bl2, boolean bl3, double d, double d2) {
        ExtDbRecordTV extDbRecordTV;
        ArrayList<SourceEditData> arrayList = scenarioEditData.sourceData.getSources(1);
        ListIterator<ExtDbRecordTV> listIterator = linkedList.listIterator(0);
        block0: while (listIterator.hasNext()) {
            extDbRecordTV = listIterator.next();
            for (SourceEditData object2 : arrayList) {
                SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)object2;
                if (!extDbRecordTV.extRecordID.equals(sourceEditDataTV.extRecordID) && (bl || !ExtDbRecordTV.areRecordsMX(extDbRecordTV, sourceEditDataTV, bl2, d, d2))) continue;
                listIterator.remove();
                continue block0;
            }
        }
        if (bl) {
            return;
        }
        final boolean bl4 = bl3;
        Comparator<ExtDbRecordTV> comparator = new Comparator<ExtDbRecordTV>(){

            @Override
            public int compare(ExtDbRecordTV extDbRecordTV, ExtDbRecordTV extDbRecordTV2) {
                if (extDbRecordTV.isPreferredRecord(extDbRecordTV2, bl4)) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(linkedList, comparator);
        int n = linkedList.size() - 1;
        for (int i = 0; i < n; ++i) {
            extDbRecordTV = linkedList.get(i);
            listIterator = linkedList.listIterator(i + 1);
            while (listIterator.hasNext()) {
                if (!ExtDbRecordTV.areRecordsMX(extDbRecordTV, listIterator.next(), bl2, d, d2)) continue;
                listIterator.remove();
                --n;
            }
        }
    }

    private ExtDbRecordTV(ExtDb extDb) {
        super(extDb, 1);
    }

    public boolean updateSource(SourceEditDataTV sourceEditDataTV) {
        return this.updateSource(sourceEditDataTV, null, null);
    }

    public boolean updateSource(SourceEditDataTV sourceEditDataTV, ErrorLogger errorLogger) {
        return this.updateSource(sourceEditDataTV, null, errorLogger);
    }

    public boolean updateSource(SourceEditDataTV sourceEditDataTV, ExtDb extDb) {
        return this.updateSource(sourceEditDataTV, extDb, null);
    }

    public boolean updateSource(SourceEditDataTV sourceEditDataTV, ExtDb extDb, ErrorLogger errorLogger) {
        Object object;
        String string;
        String string2;
        Object object2;
        boolean bl;
        if (!(this.extDb.dbID.equals(sourceEditDataTV.dbID) && this.facilityID == sourceEditDataTV.facilityID && this.service.equals(sourceEditDataTV.service) && this.country.equals(sourceEditDataTV.country))) {
            if (null != errorLogger) {
                errorLogger.reportError("ExtDbRecordTV.updateSource(): non-matching source object");
            }
            return false;
        }
        if (!ExtDbRecordTV.isExtDbSupported(this.extDb)) {
            if (null != errorLogger) {
                errorLogger.reportError("ExtDbRecordTV.updateSource(): unsupported station data type");
            }
            return false;
        }
        boolean bl2 = bl = 1 == this.extDb.type;
        if (null != errorLogger) {
            errorLogger.clearErrors();
        } else {
            errorLogger = new ErrorLogger(null, null);
        }
        boolean bl3 = false;
        sourceEditDataTV.siteNumber = this.siteNumber;
        sourceEditDataTV.callSign = this.callSign;
        sourceEditDataTV.channel = this.channel;
        sourceEditDataTV.city = this.city;
        sourceEditDataTV.state = this.state;
        sourceEditDataTV.zone = Zone.getZone(this.zoneCode);
        sourceEditDataTV.status = this.status;
        sourceEditDataTV.statusType = this.statusType;
        sourceEditDataTV.fileNumber = this.filePrefix + this.appARN;
        sourceEditDataTV.appARN = this.appARN;
        sourceEditDataTV.frequencyOffset = FrequencyOffset.getFrequencyOffset(this.frequencyOffsetCode);
        if (this.service.serviceType.needsEmissionMask) {
            sourceEditDataTV.emissionMask = EmissionMask.getEmissionMask(this.emissionMaskCode);
            if (0 == sourceEditDataTV.emissionMask.key) {
                sourceEditDataTV.emissionMask = EmissionMask.getDefaultObject();
            }
        } else {
            sourceEditDataTV.emissionMask = EmissionMask.getNullObject();
        }
        sourceEditDataTV.location.setLatLon(this.location);
        sourceEditDataTV.dtsMaximumDistance = this.dtsMaximumDistance;
        sourceEditDataTV.setAttribute("sequenceDate", AppCore.formatDate(this.sequenceDate));
        if (null != this.licensee && this.licensee.length() > 0) {
            sourceEditDataTV.setAttribute("licensee", this.licensee);
        }
        if (this.isSharingHost) {
            sourceEditDataTV.setAttribute("isSharingHost");
        }
        if (this.isSharingGuest) {
            sourceEditDataTV.setAttribute("-isSharingGuest");
        }
        if (null != this.channelSharingComment) {
            sourceEditDataTV.setAttribute("-channelSharingComment", this.channelSharingComment);
        }
        if (this.isBaseline) {
            sourceEditDataTV.setAttribute("isBaseline");
        }
        if (this.isPending) {
            sourceEditDataTV.setAttribute("-isPending");
        }
        if (this.isArchived) {
            sourceEditDataTV.setAttribute("-isArchived");
        }
        if (null != this.dtsRecords) {
            if (null == this.dtsAuthorizedRecord ? null == sourceEditDataTV.makeDTSAuthorizedSource(extDb, errorLogger) : null == sourceEditDataTV.addDTSSource(this.dtsAuthorizedRecord, extDb, errorLogger)) {
                return false;
            }
            for (ExtDbRecordTV extDbRecordTV : this.dtsRecords) {
                if (null != sourceEditDataTV.addDTSSource(extDbRecordTV, extDb, errorLogger)) continue;
                return false;
            }
            return true;
        }
        sourceEditDataTV.heightAMSL = this.heightAMSL;
        sourceEditDataTV.overallHAAT = this.overallHAAT;
        sourceEditDataTV.peakERP = this.peakERP;
        if (null != this.antennaRecordID && (this.daIndicated || null == sourceEditDataTV.study || !sourceEditDataTV.study.getTrustPatternFlag())) {
            object2 = null;
            DbConnection dbConnection = this.extDb.connectDb(errorLogger);
            if (null != dbConnection) {
                try {
                    if (bl) {
                        dbConnection.query("SELECT ant_make, ant_model_num FROM ant_make WHERE antenna_id = " + this.antennaRecordID);
                    } else if (5 == this.extDb.type) {
                        if (this.isBaseline && !this.service.isDTS) {
                            dbConnection.query("SELECT rant_make, rant_model FROM mass_media.lkp_antenna WHERE rant_antenna_id = '" + this.antennaRecordID + "'");
                        } else {
                            dbConnection.query("SELECT aant_make, aant_model FROM mass_media.app_antenna WHERE aant_antenna_record_id = '" + this.antennaRecordID + "'");
                        }
                    } else if (this.isBaseline && !this.service.isDTS) {
                        dbConnection.query("SELECT rant_make, rant_model FROM lkp_antenna WHERE rant_antenna_id = '" + this.antennaRecordID + "'");
                    } else {
                        dbConnection.query("SELECT aant_make, aant_model FROM app_antenna WHERE aant_antenna_record_id = '" + this.antennaRecordID + "'");
                    }
                    if (dbConnection.next()) {
                        string2 = dbConnection.getString(1);
                        if (null == string2) {
                            string2 = "";
                        }
                        if (null == (string = dbConnection.getString(2))) {
                            string = "";
                        }
                        if (((String)(object2 = string2 + "-" + string)).length() > 255) {
                            object2 = ((String)object2).substring(0, 255);
                        }
                    } else {
                        errorLogger.logMessage(ExtDbRecordTV.makeMessage(this, "Antenna record ID " + this.antennaRecordID + " not found"));
                    }
                    this.extDb.releaseDb(dbConnection);
                }
                catch (SQLException sQLException) {
                    this.extDb.releaseDb(dbConnection);
                    bl3 = true;
                    DbConnection.reportError(errorLogger, sQLException);
                }
            } else {
                bl3 = true;
            }
            if (bl3) {
                return false;
            }
            if (null != object2) {
                object = ExtDb.getHorizontalPattern(this, object2, errorLogger);
                if (null != object) {
                    sourceEditDataTV.antennaID = this.antennaID;
                    sourceEditDataTV.hasHorizontalPattern = true;
                    sourceEditDataTV.horizontalPattern = object;
                    sourceEditDataTV.horizontalPatternChanged = true;
                } else if (errorLogger.hasErrors()) {
                    return false;
                }
            }
        }
        sourceEditDataTV.horizontalPatternOrientation = this.horizontalPatternOrientation;
        if (null != this.elevationAntennaRecordID) {
            object2 = null;
            boolean bl4 = false;
            object = this.extDb.connectDb(errorLogger);
            if (null != object) {
                try {
                    if (bl) {
                        ((DbConnection)object).query("SELECT ant_make, ant_model_num FROM elevation_ant_make WHERE elevation_antenna_id = " + this.elevationAntennaRecordID);
                    } else if (5 == this.extDb.type) {
                        ((DbConnection)object).query("SELECT aant_make, aant_model FROM mass_media.app_antenna WHERE aant_antenna_record_id = '" + this.elevationAntennaRecordID + "'");
                    } else {
                        ((DbConnection)object).query("SELECT aant_make, aant_model FROM app_antenna WHERE aant_antenna_record_id = '" + this.elevationAntennaRecordID + "'");
                    }
                    if (((DbConnection)object).next()) {
                        string2 = ((DbConnection)object).getString(1);
                        if (null == string2) {
                            string2 = "";
                        }
                        if (null == (string = ((DbConnection)object).getString(2))) {
                            string = "";
                        }
                        if (((String)(object2 = string2 + "-" + string)).length() > 255) {
                            object2 = ((String)object2).substring(0, 255);
                        }
                        if (bl) {
                            ((DbConnection)object).query("SELECT COUNT(*) FROM elevation_pattern WHERE elevation_antenna_id = " + this.elevationAntennaRecordID + " AND field_value0 > 0.");
                            if (((DbConnection)object).next() && ((DbConnection)object).getInt(1) > 0) {
                                bl4 = true;
                            }
                        } else {
                            if (5 == this.extDb.type) {
                                ((DbConnection)object).query("SELECT MAX(aaep_azimuth) FROM mass_media.app_antenna_elevation_pattern WHERE aaep_antenna_record_id = '" + this.elevationAntennaRecordID + "'");
                            } else {
                                ((DbConnection)object).query("SELECT MAX(aaep_azimuth) FROM app_antenna_elevation_pattern WHERE aaep_antenna_record_id = '" + this.elevationAntennaRecordID + "'");
                            }
                            if (((DbConnection)object).next() && ((DbConnection)object).getDouble(1) > 0.0) {
                                bl4 = true;
                            }
                        }
                    } else {
                        errorLogger.logMessage(ExtDbRecordTV.makeMessage(this, "Elevation antenna ID " + this.elevationAntennaRecordID + " not found"));
                    }
                    this.extDb.releaseDb((DbConnection)object);
                }
                catch (SQLException sQLException) {
                    this.extDb.releaseDb((DbConnection)object);
                    bl3 = true;
                    DbConnection.reportError(errorLogger, sQLException);
                }
            } else {
                bl3 = true;
            }
            if (bl3) {
                return false;
            }
            if (null != object2) {
                if (bl4) {
                    AntPattern antPattern = ExtDb.getMatrixPattern(this, (String)object2, errorLogger);
                    if (null != antPattern) {
                        sourceEditDataTV.hasMatrixPattern = true;
                        sourceEditDataTV.matrixPattern = antPattern;
                        sourceEditDataTV.matrixPatternChanged = true;
                    } else if (errorLogger.hasErrors()) {
                        return false;
                    }
                } else {
                    AntPattern antPattern = ExtDb.getVerticalPattern(this, (String)object2, errorLogger);
                    if (null != antPattern) {
                        sourceEditDataTV.hasVerticalPattern = true;
                        sourceEditDataTV.verticalPattern = antPattern;
                        sourceEditDataTV.verticalPatternChanged = true;
                    } else if (errorLogger.hasErrors()) {
                        return false;
                    }
                }
            }
        }
        sourceEditDataTV.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
        sourceEditDataTV.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
        sourceEditDataTV.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        if (sourceEditDataTV.hasMatrixPattern && null != (object2 = sourceEditDataTV.matrixPattern.normalizeVerticalMatrix())) {
            sourceEditDataTV.horizontalPattern = object2;
            sourceEditDataTV.hasHorizontalPattern = true;
            sourceEditDataTV.horizontalPatternChanged = true;
            sourceEditDataTV.antennaID = null;
        }
        sourceEditDataTV.useGenericVerticalPattern = null == sourceEditDataTV.study ? true : sourceEditDataTV.study.getUseGenericVpat(sourceEditDataTV.country.key - 1);
        if (3 == this.country.key && this.service.isFullService() && null != sourceEditDataTV.study) {
            if (0.0 == this.peakERP) {
                sourceEditDataTV.peakERP = this.service.isDigital() ? (this.channel < 7 ? sourceEditDataTV.study.getDefaultMexicanDigitalVloERP() : (this.channel < 14 ? sourceEditDataTV.study.getDefaultMexicanDigitalVhiERP() : sourceEditDataTV.study.getDefaultMexicanDigitalUhfERP())) : (this.channel < 7 ? sourceEditDataTV.study.getDefaultMexicanAnalogVloERP() : (this.channel < 14 ? sourceEditDataTV.study.getDefaultMexicanAnalogVhiERP() : sourceEditDataTV.study.getDefaultMexicanAnalogUhfERP()));
                errorLogger.logMessage(ExtDbRecordTV.makeMessage(this, "Used default for missing ERP"));
            }
            if (0.0 == this.heightAMSL && 0.0 == this.overallHAAT) {
                sourceEditDataTV.overallHAAT = this.service.isDigital() ? (this.channel < 7 ? sourceEditDataTV.study.getDefaultMexicanDigitalVloHAAT() : (this.channel < 14 ? sourceEditDataTV.study.getDefaultMexicanDigitalVhiHAAT() : sourceEditDataTV.study.getDefaultMexicanDigitalUhfHAAT())) : (this.channel < 7 ? sourceEditDataTV.study.getDefaultMexicanAnalogVloHAAT() : (this.channel < 14 ? sourceEditDataTV.study.getDefaultMexicanAnalogVhiHAAT() : sourceEditDataTV.study.getDefaultMexicanAnalogUhfHAAT()));
                errorLogger.logMessage(ExtDbRecordTV.makeMessage(this, "Used default for missing HAAT"));
            }
        }
        if (1 != this.country.key && 0.0 == this.heightAMSL && 0.0 != this.overallHAAT) {
            sourceEditDataTV.heightAMSL = -999.0;
            errorLogger.logMessage(ExtDbRecordTV.makeMessage(this, "Derived missing AMSL from HAAT"));
        }
        if (this.peakERP <= 0.0) {
            sourceEditDataTV.peakERP = Math.pow(10.0, this.peakERP / 10.0);
            errorLogger.logMessage(ExtDbRecordTV.makeMessage(this, "Converted ERP from dBk to kilowatts"));
        }
        if (this.verticalPatternMechanicalTilt > 16.0 && this.verticalPatternMechanicalTiltOrientation <= 16.0) {
            sourceEditDataTV.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTiltOrientation;
            sourceEditDataTV.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTilt;
            errorLogger.logMessage(ExtDbRecordTV.makeMessage(this, "Transposed mechanical tilt parameters"));
        }
        if (this.verticalPatternElectricalTilt < -10.0 || this.verticalPatternElectricalTilt > 16.0) {
            sourceEditDataTV.verticalPatternElectricalTilt = 0.0;
            errorLogger.logMessage(ExtDbRecordTV.makeMessage(this, "Ignored out-of-range electrical tilt"));
        }
        if (this.verticalPatternMechanicalTilt < -10.0 || this.verticalPatternMechanicalTilt > 16.0) {
            sourceEditDataTV.verticalPatternMechanicalTilt = 0.0;
            errorLogger.logMessage(ExtDbRecordTV.makeMessage(this, "Ignored out-of-range mechanical tilt"));
        }
        if (this.verticalPatternMechanicalTilt != 0.0 && 0.0 == this.verticalPatternMechanicalTiltOrientation) {
            errorLogger.logMessage(ExtDbRecordTV.makeMessage(this, "Used 0 for missing mechanical tilt orientation"));
        }
        if (bl && 1 == this.country.key && !this.service.isFullService() && this.alternateERP > this.peakERP) {
            sourceEditDataTV.peakERP = this.alternateERP;
            errorLogger.logMessage(ExtDbRecordTV.makeMessage(this, "Using ERP value from max_erp_any_angle"));
        }
        return true;
    }

    public static boolean areRecordsMX(ExtDbRecordTV extDbRecordTV, ExtDbRecordTV extDbRecordTV2, boolean bl, double d, double d2) {
        int n;
        int n2 = extDbRecordTV.replicateToChannel > 0 ? extDbRecordTV.replicateToChannel : extDbRecordTV.channel;
        int n3 = n = extDbRecordTV2.replicateToChannel > 0 ? extDbRecordTV2.replicateToChannel : extDbRecordTV2.channel;
        if (!bl && (extDbRecordTV.isSharingGuest || extDbRecordTV2.isSharingGuest)) {
            bl = true;
        }
        return ExtDbRecordTV.areRecordsMX(extDbRecordTV.facilityID, extDbRecordTV.service.isFullService(), extDbRecordTV.isBaseline, extDbRecordTV.service.key, extDbRecordTV.siteNumber, n2, extDbRecordTV.country.key, extDbRecordTV.state, extDbRecordTV.city, extDbRecordTV.location, !bl && d > 0.0 ? extDbRecordTV.getDTSLocations() : null, extDbRecordTV2.facilityID, extDbRecordTV2.service.isFullService(), extDbRecordTV2.isBaseline, extDbRecordTV2.service.key, extDbRecordTV2.siteNumber, n, extDbRecordTV2.country.key, extDbRecordTV2.state, extDbRecordTV2.city, extDbRecordTV2.location, !bl && d > 0.0 ? extDbRecordTV2.getDTSLocations() : null, bl, d, d2);
    }

    public static boolean areRecordsMX(ExtDbRecordTV extDbRecordTV, SourceEditDataTV sourceEditDataTV, boolean bl, double d, double d2) {
        int n;
        boolean bl2 = null != sourceEditDataTV.getAttribute("isBaseline");
        int n2 = n = extDbRecordTV.replicateToChannel > 0 ? extDbRecordTV.replicateToChannel : extDbRecordTV.channel;
        if (!bl && (extDbRecordTV.isSharingGuest || null != sourceEditDataTV.getAttribute("-isSharingGuest"))) {
            bl = true;
        }
        return ExtDbRecordTV.areRecordsMX(extDbRecordTV.facilityID, extDbRecordTV.service.isFullService(), extDbRecordTV.isBaseline, extDbRecordTV.service.key, extDbRecordTV.siteNumber, n, extDbRecordTV.country.key, extDbRecordTV.state, extDbRecordTV.city, extDbRecordTV.location, !bl && d > 0.0 ? extDbRecordTV.getDTSLocations() : null, sourceEditDataTV.facilityID, sourceEditDataTV.service.isFullService(), bl2, sourceEditDataTV.service.key, sourceEditDataTV.siteNumber, sourceEditDataTV.channel, sourceEditDataTV.country.key, sourceEditDataTV.state, sourceEditDataTV.city, sourceEditDataTV.location, !bl && d > 0.0 ? sourceEditDataTV.getDTSLocations() : null, bl, d, d2);
    }

    public static boolean areRecordsMX(SourceEditDataTV sourceEditDataTV, ExtDbRecordTV extDbRecordTV, boolean bl, double d, double d2) {
        return ExtDbRecordTV.areRecordsMX(extDbRecordTV, sourceEditDataTV, bl, d, d2);
    }

    public static boolean areRecordsMX(SourceEditDataTV sourceEditDataTV, SourceEditDataTV sourceEditDataTV2, boolean bl, double d, double d2) {
        boolean bl2;
        boolean bl3 = null != sourceEditDataTV.getAttribute("isBaseline");
        boolean bl4 = bl2 = null != sourceEditDataTV2.getAttribute("isBaseline");
        if (!(bl || null == sourceEditDataTV.getAttribute("-isSharingGuest") && null == sourceEditDataTV2.getAttribute("-isSharingGuest"))) {
            bl = true;
        }
        return ExtDbRecordTV.areRecordsMX(sourceEditDataTV.facilityID, sourceEditDataTV.service.isFullService(), bl3, sourceEditDataTV.service.key, sourceEditDataTV.siteNumber, sourceEditDataTV.channel, sourceEditDataTV.country.key, sourceEditDataTV.state, sourceEditDataTV.city, sourceEditDataTV.location, !bl && d > 0.0 ? sourceEditDataTV.getDTSLocations() : null, sourceEditDataTV2.facilityID, sourceEditDataTV2.service.isFullService(), bl2, sourceEditDataTV2.service.key, sourceEditDataTV2.siteNumber, sourceEditDataTV2.channel, sourceEditDataTV2.country.key, sourceEditDataTV2.state, sourceEditDataTV2.city, sourceEditDataTV2.location, !bl && d > 0.0 ? sourceEditDataTV2.getDTSLocations() : null, bl, d, d2);
    }

    private static boolean areRecordsMX(int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5, String string, String string2, GeoPoint geoPoint, ArrayList<GeoPoint> arrayList, int n6, boolean bl3, boolean bl4, int n7, int n8, int n9, int n10, String string3, String string4, GeoPoint geoPoint2, ArrayList<GeoPoint> arrayList2, boolean bl5, double d, double d2) {
        if (n == n6) {
            if (bl) {
                return bl3;
            }
            if (bl3) {
                return false;
            }
            if (bl2 || bl4) {
                return true;
            }
            if (n2 != n7) {
                return true;
            }
            return n3 == n8;
        }
        if (bl5) {
            return false;
        }
        if (n4 != n9) {
            return false;
        }
        if (n5 != n10) {
            return false;
        }
        if (string.equalsIgnoreCase(string3) && string2.equalsIgnoreCase(string4)) {
            return true;
        }
        if (d > 0.0) {
            if (null != arrayList) {
                if (null != arrayList2) {
                    for (GeoPoint geoPoint3 : arrayList) {
                        for (GeoPoint geoPoint4 : arrayList2) {
                            if (!(geoPoint3.distanceTo(geoPoint4, d2) < d)) continue;
                            return true;
                        }
                    }
                } else {
                    for (GeoPoint geoPoint5 : arrayList) {
                        if (!(geoPoint5.distanceTo(geoPoint2, d2) < d)) continue;
                        return true;
                    }
                }
            } else if (null != arrayList2) {
                for (GeoPoint geoPoint6 : arrayList2) {
                    if (!(geoPoint.distanceTo(geoPoint6, d2) < d)) continue;
                    return true;
                }
            } else if (geoPoint.distanceTo(geoPoint2, d2) < d) {
                return true;
            }
        }
        return false;
    }

    public ArrayList<GeoPoint> getDTSLocations() {
        if (null == this.dtsRecords) {
            return null;
        }
        if (null == this.dtsLocations) {
            this.dtsLocations = new ArrayList();
            for (ExtDbRecordTV extDbRecordTV : this.dtsRecords) {
                this.dtsLocations.add(extDbRecordTV.location);
            }
        }
        return this.dtsLocations;
    }

    public boolean isPreferredRecord(ExtDbRecordTV extDbRecordTV, boolean bl) {
        if (bl) {
            if (this.isOperating()) {
                if (!extDbRecordTV.isOperating()) {
                    return true;
                }
            } else if (extDbRecordTV.isOperating()) {
                return false;
            }
        }
        if (this.service.preferenceRank > extDbRecordTV.service.preferenceRank) {
            return true;
        }
        if (this.service.preferenceRank < extDbRecordTV.service.preferenceRank) {
            return false;
        }
        if (bl) {
            if (0 == this.statusType && 0 != extDbRecordTV.statusType) {
                return true;
            }
            if (0 != this.statusType && 0 == extDbRecordTV.statusType) {
                return false;
            }
        }
        if (STATUS_TYPE_RANK[this.statusType] < STATUS_TYPE_RANK[extDbRecordTV.statusType]) {
            return true;
        }
        if (STATUS_TYPE_RANK[this.statusType] > STATUS_TYPE_RANK[extDbRecordTV.statusType]) {
            return false;
        }
        if (this.sequenceDate.after(extDbRecordTV.sequenceDate)) {
            return true;
        }
        if (this.sequenceDate.before(extDbRecordTV.sequenceDate)) {
            return false;
        }
        return this.extRecordID.compareTo(extDbRecordTV.extRecordID) > 0;
    }

    public boolean isOperating() {
        if (this.operatingStatusSet) {
            return this.isOperatingFacility;
        }
        if (!this.service.isOperating || this.isArchived) {
            this.isOperatingFacility = false;
        } else {
            switch (this.statusType) {
                case 0: 
                case 2: {
                    this.isOperatingFacility = true;
                    break;
                }
                case 1: {
                    if (1 == this.country.key) {
                        this.isOperatingFacility = ExtDbRecordTV.hasLicenseApp(this.extDb, this.facilityID);
                        break;
                    }
                    this.isOperatingFacility = true;
                    break;
                }
                case 4: {
                    if (1 == this.country.key) {
                        this.isOperatingFacility = false;
                        break;
                    }
                    this.isOperatingFacility = true;
                    break;
                }
                default: {
                    this.isOperatingFacility = false;
                }
            }
        }
        this.operatingStatusSet = true;
        return this.isOperatingFacility;
    }

    public double getRuleExtraDistance(StudyEditData studyEditData) {
        return SourceEditDataTV.getRuleExtraDistance(studyEditData, this.service, null != this.dtsRecords, this.country, this.replicateToChannel > 0 ? this.replicateToChannel : this.channel, this.peakERP);
    }

    private static synchronized boolean hasLicenseApp(ExtDb extDb, int n) {
        if (!ExtDbRecordTV.isExtDbSupported(extDb)) {
            return false;
        }
        boolean bl = 1 == extDb.type;
        String string = extDb.dbID + "_" + extDb.key;
        HashSet<Integer> hashSet = licenseAppLists.get(string);
        if (null == hashSet) {
            hashSet = new HashSet();
            DbConnection dbConnection = extDb.connectDb();
            if (null != dbConnection) {
                try {
                    if (bl) {
                        dbConnection.query("SELECT facility_id FROM tv_eng_data WHERE (tv_dom_status = 'LIC') AND (eng_record_type = 'P')");
                    } else if (5 == extDb.type) {
                        dbConnection.query("SELECT application_facility.afac_facility_id FROM common_schema.license_filing_version JOIN common_schema.application_facility ON (application_facility.afac_application_id = license_filing_version.filing_version_id) WHERE (license_filing_version.active_ind = 'Y') AND (license_filing_version.auth_type_code = 'L') AND (license_filing_version.current_status_code = 'PEN')");
                    } else {
                        dbConnection.query("SELECT application_facility.afac_facility_id FROM license_filing_version JOIN application_facility ON (application_facility.afac_application_id = license_filing_version.filing_version_id) WHERE (license_filing_version.active_ind = 'Y') AND (license_filing_version.auth_type_code = 'L') AND (license_filing_version.current_status_code = 'PEN')");
                    }
                    while (dbConnection.next()) {
                        hashSet.add(dbConnection.getInt(1));
                    }
                }
                catch (SQLException sQLException) {
                    DbConnection.reportError(sQLException);
                }
                extDb.releaseDb(dbConnection);
            }
            licenseAppLists.put(string, hashSet);
        }
        return hashSet.contains(n);
    }

    public static synchronized void closeDb(String string) {
        licenseAppLists.remove(string);
    }

    @Override
    protected ArrayList<String> getComments() {
        boolean bl;
        ArrayList<String> arrayList = null;
        boolean bl2 = bl = null != this.licensee && this.licensee.length() > 0;
        if (bl || this.isDRT || this.isSharingHost || this.isSharingGuest || this.isBaseline) {
            arrayList = new ArrayList<String>();
            if (bl) {
                arrayList.add("Licensee: " + this.licensee);
            }
            if (this.isDRT) {
                arrayList.add("Digital replacement translator");
            }
            if (this.isSharingHost) {
                arrayList.add("Shared channel host");
                if (null != this.channelSharingComment) {
                    arrayList.add(this.channelSharingComment);
                }
            }
            if (this.isSharingGuest) {
                arrayList.add("Shared channel guest");
                if (null != this.channelSharingComment) {
                    arrayList.add(this.channelSharingComment);
                }
            }
            if (this.isBaseline) {
                arrayList.add("Baseline record");
            }
        }
        return arrayList;
    }

    @Override
    public String getFacilityID() {
        return String.valueOf(this.facilityID);
    }

    @Override
    public String getSortFacilityID() {
        return String.format(Locale.US, "%07d", this.facilityID);
    }

    @Override
    public String getSiteCount() {
        if (this.service.isDTS) {
            int n = this.dtsRecords.size();
            if (n < 1) {
                n = 1;
            }
            return String.valueOf(n);
        }
        return "1";
    }

    @Override
    public String getCallSign() {
        return this.callSign;
    }

    @Override
    public String getChannel() {
        if (this.replicateToChannel > 0) {
            return "D" + String.valueOf(this.replicateToChannel) + " (" + this.getOriginalChannel() + ")";
        }
        return this.getOriginalChannel();
    }

    @Override
    public int getChannelNumber() {
        return this.channel;
    }

    @Override
    public String getSortChannel() {
        return String.format(Locale.US, "%02d%c", this.replicateToChannel > 0 ? this.replicateToChannel : this.channel, Character.valueOf(this.service.serviceType.digital ? (char)'D' : 'N'));
    }

    @Override
    public String getOriginalChannel() {
        return (this.service.serviceType.digital ? "D" : "N") + String.valueOf(this.channel) + FrequencyOffset.getFrequencyOffset((String)this.frequencyOffsetCode).frequencyOffsetCode;
    }

    @Override
    public String getFrequency() {
        return SourceEditDataTV.getFrequency(this.replicateToChannel > 0 ? this.replicateToChannel : this.channel, this.service);
    }

    @Override
    public double getFrequencyValue() {
        return SourceEditDataTV.getFrequencyValue(this.replicateToChannel > 0 ? this.replicateToChannel : this.channel, this.service);
    }

    @Override
    public String getZone() {
        Zone zone = Zone.getZone(this.zoneCode);
        if (zone.key > 0) {
            return zone.name;
        }
        return "";
    }

    @Override
    public String getStatus() {
        return this.status + (this.isPending ? " *P" : (this.isArchived ? " *A" : ""));
    }

    @Override
    public String getSortStatus() {
        return String.valueOf(this.statusType);
    }

    @Override
    public String getFileNumber() {
        return this.filePrefix + this.appARN;
    }

    @Override
    public String getARN() {
        return this.appARN;
    }

    @Override
    public String getFrequencyOffset() {
        FrequencyOffset frequencyOffset = FrequencyOffset.getFrequencyOffset(this.frequencyOffsetCode);
        if (frequencyOffset.key > 0) {
            return frequencyOffset.name;
        }
        return "";
    }

    @Override
    public String getEmissionMask() {
        if (this.service.serviceType.needsEmissionMask) {
            EmissionMask emissionMask = EmissionMask.getEmissionMask(this.emissionMaskCode);
            if (emissionMask.key > 0) {
                return emissionMask.name;
            }
        }
        return "";
    }

    @Override
    public String getPeakERP() {
        return AppCore.formatERP(this.alternateERP > this.peakERP ? this.alternateERP : this.peakERP) + " kW";
    }

    static {
        licenseAppLists = new HashMap();
    }

    private static class SearchDelta {
        int delta;
        boolean analogOnly;
        double maximumDistance;

        private SearchDelta() {
        }
    }

    public static class BaselineIndex {
        HashMap<Integer, Integer> index;
        HashMap<Integer, Integer> preIndex;
        boolean hasCA;
        boolean hasMX;
    }
}

