/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AntPattern;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.editdata.IxRuleEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataFM;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Locale;

public class ExtDbRecordFM
extends ExtDbRecord
implements StationRecord {
    private static final String[] CDBS_STATUS_CODES = new String[]{"APP", "CP", "CP MOD", "LIC", "STA"};
    private static final int[] CDBS_STATUS_TYPES = new int[]{3, 1, 1, 2, 0};
    private static final String[] LMS_APP_STATUS_CODES = new String[]{"SUB", "DIS", "WIT", "DEN", "RET", "CAN", "REC", "REV"};
    public static final int FM_CLASS_OTHER = 0;
    public static final int FM_CLASS_C = 1;
    public static final int FM_CLASS_C0 = 2;
    public static final int FM_CLASS_C1 = 3;
    public static final int FM_CLASS_C2 = 4;
    public static final int FM_CLASS_C3 = 5;
    public static final int FM_CLASS_B = 6;
    public static final int FM_CLASS_B1 = 7;
    public static final int FM_CLASS_A = 8;
    public static final int FM_CLASS_D = 9;
    public static final int FM_CLASS_L1 = 10;
    public static final int FM_CLASS_L2 = 11;
    public static final String[] FM_CLASS_CODES = new String[]{"", "C", "C0", "C1", "C2", "C3", "B", "B1", "A", "D", "L1", "L2"};
    public int facilityID;
    public boolean isIBOC;
    public double ibocFraction;
    public int stationClass;
    public String callSign;
    public int channel;
    public String status;
    public int statusType;
    public String filePrefix;
    public String appARN;
    public boolean daIndicated;
    public String licensee;
    public boolean contour73215;
    private boolean isOperatingFacility;
    private boolean operatingStatusSet;
    private static HashMap<Integer, HashMap<Integer, Double>> ibocMaps = new HashMap();

    public static boolean isExtDbSupported(ExtDb extDb) {
        return !extDb.deleted && extDb.isSupported() && extDb.canProvide(3) && (4 == extDb.type || 2 == extDb.type || 5 == extDb.type);
    }

    public static LinkedList<ExtDbRecord> findRecords(ExtDb extDb, String string, ErrorLogger errorLogger) {
        return ExtDbRecordFM.findRecords(extDb, string, null, 0.0, 0.0, errorLogger);
    }

    public static LinkedList<ExtDbRecord> findRecords(ExtDb extDb, String string, GeoPoint geoPoint, double d, double d2, ErrorLogger errorLogger) {
        LinkedList<ExtDbRecordFM> linkedList = ExtDbRecordFM.findRecordsFM(extDb, string, geoPoint, d, d2, errorLogger);
        if (null != linkedList) {
            return new LinkedList<ExtDbRecord>(linkedList);
        }
        return null;
    }

    public static LinkedList<ExtDbRecordFM> findRecordsFM(ExtDb extDb, String string) {
        return ExtDbRecordFM.findRecordsFM(extDb, string, null, 0.0, 0.0, null);
    }

    public static LinkedList<ExtDbRecordFM> findRecordsFM(ExtDb extDb, String string, ErrorLogger errorLogger) {
        return ExtDbRecordFM.findRecordsFM(extDb, string, null, 0.0, 0.0, errorLogger);
    }

    private static LinkedList<ExtDbRecordFM> findRecordsFM(ExtDb extDb, String string, GeoPoint geoPoint, double d, double d2, ErrorLogger errorLogger) {
        if (!ExtDbRecordFM.isExtDbSupported(extDb)) {
            return new LinkedList<ExtDbRecordFM>();
        }
        boolean bl = 4 == extDb.type;
        String string2 = "";
        String string3 = "";
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            string2 = "SELECT fm_eng_data.application_id,fm_eng_data.facility_id,fm_eng_data.station_class,fm_eng_data.station_channel,(CASE WHEN (facility.fac_callsign <> '') THEN facility.fac_callsign ELSE application.fac_callsign END),(CASE WHEN (facility.comm_city <> '') THEN facility.comm_city ELSE application.comm_city END),(CASE WHEN (facility.comm_state <> '') THEN facility.comm_state ELSE application.comm_state END),fm_eng_data.fm_dom_status,application.file_prefix,application.app_arn,fm_eng_data.lat_dir,fm_eng_data.lat_deg,fm_eng_data.lat_min,fm_eng_data.lat_sec,fm_eng_data.lon_dir,fm_eng_data.lon_deg,fm_eng_data.lon_min,fm_eng_data.lon_sec,fm_eng_data.rcamsl_horiz_mtr,fm_eng_data.rcamsl_vert_mtr,fm_eng_data.haat_horiz_rc_mtr,fm_eng_data.haat_vert_rc_mtr,fm_eng_data.max_horiz_erp,fm_eng_data.horiz_erp,fm_eng_data.max_vert_erp,fm_eng_data.vert_erp,fm_eng_data.antenna_id,fm_eng_data.ant_rotation,fm_eng_data.eng_record_type,fm_app_indicators.da_ind,fm_eng_data.asd_service,facility.fac_country,(CASE WHEN (app_tracking.accepted_date IS NOT NULL AND (app_tracking.accepted_date <> '')) THEN app_tracking.accepted_date ELSE fm_eng_data.last_change_date END) AS sequence_date,facility.digital_status,facility.fac_status";
            string3 = " FROM fm_eng_data JOIN facility USING (facility_id) JOIN application USING (application_id) LEFT JOIN fm_app_indicators USING (application_id) LEFT JOIN app_tracking USING (application_id)";
            if (null != string && string.length() > 0) {
                stringBuilder.append(" WHERE (");
                stringBuilder.append(string);
                stringBuilder.append(')');
            }
        } else {
            if (5 == extDb.type) {
                string2 = "SELECT app_location.aloc_aapp_application_id,application_facility.afac_facility_id,application_facility.station_class_code,(CASE WHEN TRIM(application_facility.afac_channel) IN ('','null') THEN 0::INT ELSE application_facility.afac_channel::INT END),facility.callsign,(CASE WHEN (facility.community_served_city <> '') THEN facility.community_served_city ELSE application_facility.afac_community_city END),(CASE WHEN (facility.community_served_state <> '') THEN facility.community_served_state ELSE application_facility.afac_community_state_code END),license_filing_version.current_status_code,'BLANK' AS file_prefix,application.aapp_file_num,app_location.aloc_lat_dir,(CASE WHEN TRIM(app_location.aloc_lat_deg) IN ('','null') THEN 0::FLOAT ELSE app_location.aloc_lat_deg::FLOAT END),(CASE WHEN TRIM(app_location.aloc_lat_mm) IN ('','null') THEN 0::FLOAT ELSE app_location.aloc_lat_mm::FLOAT END),(CASE WHEN TRIM(app_location.aloc_lat_ss) IN ('','null') THEN 0::FLOAT ELSE app_location.aloc_lat_ss::FLOAT END),app_location.aloc_long_dir,(CASE WHEN TRIM(app_location.aloc_long_deg) IN ('','null') THEN 0::FLOAT ELSE app_location.aloc_long_deg::FLOAT END),(CASE WHEN TRIM(app_location.aloc_long_mm) IN ('','null') THEN 0::FLOAT ELSE app_location.aloc_long_mm::FLOAT END),(CASE WHEN TRIM(app_location.aloc_long_ss) IN ('','null') THEN 0::FLOAT ELSE app_location.aloc_long_ss::FLOAT END),(CASE WHEN TRIM(app_antenna.aant_horiz_rc_amsl) IN ('','null') THEN 0::FLOAT ELSE app_antenna.aant_rc_amsl::FLOAT END),(CASE WHEN TRIM(app_antenna.aant_vert_rc_amsl) IN ('','null') THEN 0::FLOAT ELSE app_antenna.aant_vert_rc_amsl::FLOAT END),(CASE WHEN TRIM(app_antenna.aant_rc_haat) IN ('','null') THEN 0::FLOAT ELSE app_antenna.aant_rc_haat::FLOAT END),(CASE WHEN TRIM(app_antenna.aant_vert_rc_haat) IN ('','null') THEN 0::FLOAT ELSE app_antenna.aant_vert_rc_haat::FLOAT END),(CASE WHEN TRIM(app_antenna_frequency.aafq_horiz_max_erp_kw) IN ('','null') THEN 0::FLOAT ELSE app_antenna_frequency.aafq_horiz_max_erp_kw::FLOAT END),(CASE WHEN TRIM(app_antenna_frequency.aafq_horiz_erp_kw) IN ('','null') THEN 0::FLOAT ELSE app_antenna_frequency.aafq_horiz_erp_kw::FLOAT END),(CASE WHEN TRIM(app_antenna_frequency.aafq_vert_max_erp_kw) IN ('','null') THEN 0::FLOAT ELSE app_antenna_frequency.aafq_vert_max_erp_kw::FLOAT END),(CASE WHEN TRIM(app_antenna_frequency.aafq_vert_erp_kw) IN ('','null') THEN 0::FLOAT ELSE app_antenna_frequency.aafq_vert_erp_kw::FLOAT END),app_antenna.aant_antenna_record_id,(CASE WHEN TRIM(app_antenna.aant_rotation_deg) IN ('','null') THEN 0::FLOAT ELSE app_antenna.aant_rotation_deg::FLOAT END),license_filing_version.active_ind,app_antenna.aant_antenna_type_code,license_filing_version.service_code,application_facility.country_code,application.aapp_receipt_date AS sequence_date,application_facility.afac_facility_type,facility.facility_status,license_filing_version.auth_type_code,app_antenna.aant_antenna_id,facility_applicant.legal_name,app_mm_application.contour_215_protection_ind";
                string3 = " FROM mass_media.app_location LEFT JOIN mass_media.app_antenna ON (app_antenna.aant_aloc_loc_record_id = app_location.aloc_loc_record_id) LEFT JOIN mass_media.app_antenna_frequency ON (app_antenna_frequency.aafq_aant_antenna_record_id = app_antenna.aant_antenna_record_id) JOIN common_schema.application ON (application.aapp_application_id = app_location.aloc_aapp_application_id) JOIN common_schema.license_filing_version ON (license_filing_version.filing_version_id = app_location.aloc_aapp_application_id) JOIN common_schema.application_facility ON (application_facility.afac_application_id = app_location.aloc_aapp_application_id) JOIN common_schema.facility ON (facility.facility_id = application_facility.afac_facility_id) LEFT JOIN common_schema.facility_applicant ON ((facility_applicant.facility_uuid = facility.facility_uuid) AND (facility_applicant.contact_ind = 'N')) LEFT JOIN mass_media.app_mm_application ON (app_mm_application.aapp_application_id = app_location.aloc_aapp_application_id)";
            } else {
                string2 = "SELECT DISTINCT app_location.aloc_aapp_application_id,application_facility.afac_facility_id,application_facility.station_class_code,application_facility.afac_channel,facility.callsign,(CASE WHEN (facility.community_served_city <> '') THEN facility.community_served_city ELSE application_facility.afac_community_city END),(CASE WHEN (facility.community_served_state <> '') THEN facility.community_served_state ELSE application_facility.afac_community_state_code END),license_filing_version.current_status_code,'BLANK' AS file_prefix,application.aapp_file_num,app_location.aloc_lat_dir,app_location.aloc_lat_deg,app_location.aloc_lat_mm,app_location.aloc_lat_ss,app_location.aloc_long_dir,app_location.aloc_long_deg,app_location.aloc_long_mm,app_location.aloc_long_ss,app_antenna.aant_rc_amsl,app_antenna.aant_vert_rc_amsl,app_antenna.aant_rc_haat,app_antenna.aant_vert_rc_haat,app_antenna_frequency.aafq_horiz_max_erp_kw,app_antenna_frequency.aafq_horiz_erp_kw,app_antenna_frequency.aafq_vert_max_erp_kw,app_antenna_frequency.aafq_vert_erp_kw,app_antenna.aant_antenna_record_id,app_antenna.aant_rotation_deg,license_filing_version.active_ind,app_antenna.aant_antenna_type_code,license_filing_version.service_code,application_facility.country_code,application.aapp_receipt_date AS sequence_date,application_facility.afac_facility_type,facility.facility_status,license_filing_version.auth_type_code,app_antenna.aant_antenna_id";
                string3 = " FROM app_location LEFT JOIN app_antenna ON (app_antenna.aant_aloc_loc_record_id = app_location.aloc_loc_record_id) LEFT JOIN app_antenna_frequency ON (app_antenna_frequency.aafq_aant_antenna_record_id = app_antenna.aant_antenna_record_id) JOIN application ON (application.aapp_application_id = app_location.aloc_aapp_application_id) JOIN license_filing_version ON (license_filing_version.filing_version_id = app_location.aloc_aapp_application_id) JOIN application_facility ON (application_facility.afac_application_id = app_location.aloc_aapp_application_id) JOIN facility ON (facility.facility_id = application_facility.afac_facility_id)";
                if (extDb.version > 7) {
                    string2 = string2 + ", facility_applicant.legal_name";
                    string3 = string3 + " LEFT JOIN facility_applicant ON ((facility_applicant.facility_uuid = facility.facility_uuid) AND (facility_applicant.contact_ind = 'N'))";
                } else {
                    string2 = string2 + ", '' AS legal_name";
                }
                if (extDb.version > 8) {
                    string2 = string2 + ", app_mm_application.contour_215_protection_ind";
                    string3 = string3 + " LEFT JOIN app_mm_application ON (app_mm_application.aapp_application_id = app_location.aloc_aapp_application_id)";
                } else {
                    string2 = string2 + ", 'N' AS contour_215_protection_ind";
                }
            }
            stringBuilder.append(" WHERE ");
            if (null != string && string.length() > 0) {
                stringBuilder.append('(');
                stringBuilder.append(string);
                stringBuilder.append(") AND ");
            }
            stringBuilder.append("((CASE WHEN (license_filing_version.purpose_code = 'AMD') ");
            stringBuilder.append("THEN license_filing_version.original_purpose_code ");
            stringBuilder.append("ELSE license_filing_version.purpose_code END) IN ('CP','L2C','MOD','RUL','STA')) AND ");
            stringBuilder.append("(license_filing_version.current_status_code <> 'SAV') AND ");
            stringBuilder.append("(license_filing_version.service_code IN ");
            ExtDbRecordFM.addServiceCodeList(extDb.type, 3, stringBuilder);
            stringBuilder.append(')');
        }
        LinkedList<Object> linkedList = null;
        DbConnection dbConnection = extDb.connectDb(errorLogger);
        if (null != dbConnection) {
            Object object;
            Object object2;
            Object object3;
            SimpleDateFormat simpleDateFormat = bl ? new SimpleDateFormat("MM/dd/yyyy", Locale.US) : new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            HashMap<Integer, Double> hashMap = null;
            String string4 = null;
            Date date = null;
            Double d3 = null;
            if (!bl && extDb.version > 10 && null == (hashMap = ibocMaps.get(extDb.key))) {
                hashMap = new HashMap();
                ibocMaps.put(extDb.key, hashMap);
                object3 = new HashMap();
                try {
                    dbConnection.query("SELECT application_facility.afac_facility_id, application.aapp_receipt_date, digital_notification.analog_erp_kw, digital_notification.digital_erp_kw FROM digital_notification JOIN application ON (application.aapp_application_id = digital_notification.application_id) JOIN application_facility ON (application_facility.afac_application_id = digital_notification.application_id)");
                    while (dbConnection.next()) {
                        object2 = dbConnection.getInt(1);
                        date = null;
                        string4 = dbConnection.getString(2);
                        if (null != string4) {
                            try {
                                date = simpleDateFormat.parse(string4);
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        if (null == date) {
                            date = new Date(0L);
                        }
                        if ((object = (Date)((HashMap)object3).get(object2)) != null && ((Date)object).after(date)) continue;
                        double d4 = -1.0;
                        string4 = dbConnection.getString(3);
                        if (null != string4) {
                            try {
                                d4 = Double.parseDouble(string4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (d4 <= 0.0) continue;
                        double d5 = -1.0;
                        string4 = dbConnection.getString(4);
                        if (null != string4) {
                            try {
                                d5 = Double.parseDouble(string4);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (d5 <= 0.0) continue;
                        d3 = d5 / d4;
                        hashMap.put((Integer)object2, d3);
                        ((HashMap)object3).put(object2, date);
                    }
                }
                catch (SQLException sQLException) {
                    DbConnection.reportError(sQLException);
                }
            }
            try {
                linkedList = new LinkedList<Object>();
                GeoPoint geoPoint2 = new GeoPoint();
                dbConnection.query(string2 + string3 + stringBuilder.toString());
                while (dbConnection.next()) {
                    String[] stringArray;
                    int n;
                    String string5;
                    String string6;
                    int n2;
                    String string7;
                    object3 = ExtDbRecordFM.getService(extDb.type, dbConnection.getString(31));
                    if (null == object3 || null == (object = Country.getCountry(dbConnection.getString(32)))) continue;
                    if (bl) {
                        int n3 = dbConnection.getInt(1);
                        if (n3 <= 0) continue;
                        string7 = String.valueOf(n3);
                    } else {
                        string7 = dbConnection.getString(1);
                        if (null == string7 || 0 == string7.length()) continue;
                    }
                    if ((n2 = dbConnection.getInt(4)) < 200 || n2 > 300) continue;
                    date = null;
                    try {
                        string4 = dbConnection.getString(33);
                        if (null != string4) {
                            date = simpleDateFormat.parse(string4);
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (null == date) {
                        date = new Date(0L);
                    }
                    if (null == (string6 = dbConnection.getString(35))) {
                        string6 = "";
                    }
                    if (null == (string5 = dbConnection.getString(8))) {
                        string5 = "";
                    }
                    int n4 = 4;
                    if (string6.equals("EXPER")) {
                        n4 = 5;
                    } else if (bl) {
                        for (n = 0; n < CDBS_STATUS_CODES.length; ++n) {
                            if (!CDBS_STATUS_CODES[n].equalsIgnoreCase(string5)) continue;
                            n4 = CDBS_STATUS_TYPES[n];
                            break;
                        }
                    } else {
                        stringArray = dbConnection.getString(36);
                        if (stringArray.equalsIgnoreCase("S")) {
                            n4 = 0;
                        } else if (string5.equalsIgnoreCase("REV")) {
                            n4 = 6;
                        } else if (string5.equalsIgnoreCase("PEN") && stringArray.equalsIgnoreCase("C")) {
                            n4 = 3;
                        } else {
                            for (n = 0; n < LMS_APP_STATUS_CODES.length; ++n) {
                                if (!LMS_APP_STATUS_CODES[n].equalsIgnoreCase(string5)) continue;
                                n4 = 3;
                                break;
                            }
                            if (4 == n4) {
                                if (stringArray.equalsIgnoreCase("C")) {
                                    n4 = 1;
                                } else if (stringArray.equalsIgnoreCase("L")) {
                                    n4 = 2;
                                }
                            }
                        }
                    }
                    if (4 != n4) {
                        string5 = STATUS_CODES[n4];
                    }
                    geoPoint2.latitudeNS = 0;
                    String string8 = dbConnection.getString(11);
                    if (null != string8 && string8.equalsIgnoreCase("S")) {
                        geoPoint2.latitudeNS = 1;
                    }
                    geoPoint2.latitudeDegrees = dbConnection.getInt(12);
                    geoPoint2.latitudeMinutes = dbConnection.getInt(13);
                    geoPoint2.latitudeSeconds = dbConnection.getDouble(14);
                    geoPoint2.longitudeWE = 0;
                    string8 = dbConnection.getString(15);
                    if (null != string8 && string8.equalsIgnoreCase("E")) {
                        geoPoint2.longitudeWE = 1;
                    }
                    geoPoint2.longitudeDegrees = dbConnection.getInt(16);
                    geoPoint2.longitudeMinutes = dbConnection.getInt(17);
                    geoPoint2.longitudeSeconds = dbConnection.getDouble(18);
                    geoPoint2.updateLatLon();
                    if (bl) {
                        geoPoint2.convertFromNAD27();
                        geoPoint2.updateDMS();
                    }
                    if (null != geoPoint && d > 0.0 && geoPoint.distanceTo(geoPoint2, d2) > d) continue;
                    object2 = new ExtDbRecordFM(extDb);
                    ((ExtDbRecordFM)object2).service = object3;
                    ((ExtDbRecordFM)object2).country = object;
                    ((ExtDbRecordFM)object2).extRecordID = string7;
                    ((ExtDbRecordFM)object2).facilityID = dbConnection.getInt(2);
                    ((ExtDbRecordFM)object2).channel = n2;
                    ((ExtDbRecordFM)object2).stationClass = 0;
                    string4 = dbConnection.getString(3);
                    if (null != string4 && string4.length() > 0) {
                        for (int i = 1; i < FM_CLASS_CODES.length; ++i) {
                            if (!string4.equalsIgnoreCase(FM_CLASS_CODES[i])) continue;
                            ((ExtDbRecordFM)object2).stationClass = i;
                            break;
                        }
                    }
                    if (null == (string4 = dbConnection.getString(5))) {
                        string4 = "";
                    } else if (string4.length() > 12) {
                        string4 = string4.substring(0, 12);
                    }
                    ((ExtDbRecordFM)object2).callSign = string4;
                    string4 = dbConnection.getString(6);
                    if (null == string4) {
                        string4 = "";
                    } else if (string4.length() > 20) {
                        string4 = string4.substring(0, 20);
                    }
                    ((ExtDbRecordFM)object2).city = string4;
                    string4 = dbConnection.getString(7);
                    if (null == string4) {
                        string4 = "";
                    } else if (string4.length() > 2) {
                        string4 = string4.substring(0, 2);
                    }
                    ((ExtDbRecordFM)object2).state = string4;
                    if (string5.length() > 6) {
                        string5 = string5.substring(0, 6);
                    }
                    ((ExtDbRecordFM)object2).status = string5;
                    ((ExtDbRecordFM)object2).statusType = n4;
                    String string9 = dbConnection.getString(9);
                    String string10 = dbConnection.getString(10);
                    if (!bl && null != string10 && 2 == (stringArray = string10.split("-")).length) {
                        string9 = stringArray[0];
                        string10 = stringArray[1];
                    }
                    if (null == string10) {
                        string10 = "";
                    } else if (string10.length() > 255) {
                        string10 = string10.substring(0, 255);
                    }
                    if (null == string9) {
                        string9 = "";
                    } else if (string9.length() + string10.length() > 255) {
                        string9 = string9.substring(0, 255 - string10.length());
                    }
                    ((ExtDbRecordFM)object2).filePrefix = string9;
                    ((ExtDbRecordFM)object2).appARN = string10;
                    ((ExtDbRecordFM)object2).location.setLatLon(geoPoint2);
                    double d6 = dbConnection.getDouble(19);
                    double d7 = dbConnection.getDouble(20);
                    ((ExtDbRecordFM)object2).heightAMSL = d6 > d7 ? d6 : d7;
                    d6 = dbConnection.getDouble(21);
                    d7 = dbConnection.getDouble(22);
                    ((ExtDbRecordFM)object2).overallHAAT = d6 > d7 ? d6 : d7;
                    d6 = dbConnection.getDouble(23);
                    d7 = dbConnection.getDouble(24);
                    double d8 = d6 > d7 ? d6 : d7;
                    d6 = dbConnection.getDouble(25);
                    d7 = dbConnection.getDouble(26);
                    double d9 = d6 > d7 ? d6 : d7;
                    double d10 = ((ExtDbRecordFM)object2).peakERP = d8 > d9 ? d8 : d9;
                    if (bl) {
                        int n5 = dbConnection.getInt(27);
                        if (n5 > 0) {
                            ((ExtDbRecordFM)object2).antennaID = ((ExtDbRecordFM)object2).antennaRecordID = String.valueOf(n5);
                        }
                    } else {
                        string4 = dbConnection.getString(27);
                        if (null != string4 && 0 == (string4 = string4.trim()).length()) {
                            string4 = null;
                        }
                        ((ExtDbRecordFM)object2).antennaRecordID = string4;
                        string4 = dbConnection.getString(37);
                        if (null != string4 && 0 == (string4 = string4.trim()).length()) {
                            string4 = null;
                        }
                        ((ExtDbRecordFM)object2).antennaID = string4;
                    }
                    ((ExtDbRecordFM)object2).horizontalPatternOrientation = Math.IEEEremainder(dbConnection.getDouble(28), 360.0);
                    if (((ExtDbRecordFM)object2).horizontalPatternOrientation < 0.0) {
                        ((ExtDbRecordFM)object2).horizontalPatternOrientation += 360.0;
                    }
                    if (string6.equals("FVOID") || string6.equals("PRCAN") || string6.equals("LICAN")) {
                        ((ExtDbRecordFM)object2).isArchived = true;
                    } else {
                        string4 = dbConnection.getString(29);
                        if (null != string4) {
                            if (bl) {
                                if (string4.equalsIgnoreCase("P")) {
                                    ((ExtDbRecordFM)object2).isPending = true;
                                } else if (string4.equalsIgnoreCase("A")) {
                                    ((ExtDbRecordFM)object2).isArchived = true;
                                }
                            } else if (string4.equalsIgnoreCase("N")) {
                                ((ExtDbRecordFM)object2).isArchived = true;
                            } else {
                                string4 = dbConnection.getString(8);
                                if (null != string4 && string4.equalsIgnoreCase("PEN")) {
                                    ((ExtDbRecordFM)object2).isPending = true;
                                }
                            }
                        }
                    }
                    string4 = dbConnection.getString(30);
                    if (null != string4) {
                        ((ExtDbRecordFM)object2).daIndicated = bl ? string4.equalsIgnoreCase("Y") : string4.equalsIgnoreCase("DIR");
                    }
                    ((ExtDbRecordFM)object2).sequenceDate = date;
                    ((ExtDbRecordFM)object2).ibocFraction = 0.01;
                    if (bl) {
                        string4 = dbConnection.getString(34);
                        if (null != string4) {
                            ((ExtDbRecordFM)object2).isIBOC = string4.equalsIgnoreCase("H");
                        }
                    } else if (null != hashMap && null != (d3 = hashMap.get(((ExtDbRecordFM)object2).facilityID))) {
                        ((ExtDbRecordFM)object2).isIBOC = true;
                        ((ExtDbRecordFM)object2).ibocFraction = d3;
                    }
                    if (!bl) {
                        ((ExtDbRecordFM)object2).licensee = dbConnection.getString(38);
                        string4 = dbConnection.getString(39);
                        ((ExtDbRecordFM)object2).contour73215 = null != string4 && string4.equalsIgnoreCase("Y");
                    }
                    linkedList.add(object2);
                }
                extDb.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                extDb.releaseDb(dbConnection);
                linkedList = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        return linkedList;
    }

    public static ExtDbRecordFM findRecordFM(String string, Integer n, String string2) {
        return ExtDbRecordFM.findRecordFM(string, n, string2, null);
    }

    public static ExtDbRecordFM findRecordFM(String string, Integer n, String string2, ErrorLogger errorLogger) {
        ExtDb extDb = ExtDb.getExtDb(string, n, errorLogger);
        if (null == extDb) {
            return null;
        }
        return ExtDbRecordFM.findRecordFM(extDb, string2, errorLogger);
    }

    public static ExtDbRecordFM findRecordFM(ExtDb extDb, String string) {
        return ExtDbRecordFM.findRecordFM(extDb, string, null);
    }

    public static ExtDbRecordFM findRecordFM(ExtDb extDb, String string, ErrorLogger errorLogger) {
        if (!ExtDbRecordFM.isExtDbSupported(extDb)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            ExtDbRecordFM.addRecordIDQueryFM(extDb.type, extDb.version, string, stringBuilder, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (null != errorLogger) {
                errorLogger.logMessage(illegalArgumentException.getMessage());
            }
            return null;
        }
        LinkedList<ExtDbRecordFM> linkedList = ExtDbRecordFM.findRecordsFM(extDb, stringBuilder.toString(), null, 0.0, 0.0, errorLogger);
        if (null == linkedList) {
            return null;
        }
        if (linkedList.isEmpty()) {
            if (null != errorLogger) {
                errorLogger.logMessage("Record not found for record ID '" + string + "'");
            }
            return null;
        }
        return linkedList.getFirst();
    }

    public static HashMap<String, ExtDbRecordFM> batchFindRecordFM(ExtDb extDb, HashSet<String> hashSet) {
        return ExtDbRecordFM.batchFindRecordFM(extDb, hashSet, null);
    }

    /*
     * WARNING - void declaration
     */
    public static HashMap<String, ExtDbRecordFM> batchFindRecordFM(ExtDb extDb, HashSet<String> hashSet, ErrorLogger errorLogger) {
        HashMap<String, ExtDbRecordFM> hashMap = new HashMap<String, ExtDbRecordFM>();
        if (!ExtDbRecordFM.isExtDbSupported(extDb)) {
            return hashMap;
        }
        boolean bl = 4 == extDb.type;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        String string = "(";
        if (bl) {
            stringBuilder.append("fm_eng_data.application_id IN ");
        } else {
            stringBuilder.append("UPPER(app_location.aloc_aapp_application_id) IN ");
            string = "('";
        }
        for (String string2 : hashSet) {
            void var10_14;
            if (bl) {
                int n = 0;
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n <= 0) continue;
                String string3 = String.valueOf(n);
            } else {
                String string4 = DbConnection.clean(string2.toUpperCase());
            }
            stringBuilder.append(string);
            stringBuilder.append((String)var10_14);
            string = bl ? "," : "','";
            bl2 = true;
        }
        if (bl2) {
            if (bl) {
                stringBuilder.append(")");
            } else {
                stringBuilder.append("')");
            }
            LinkedList<ExtDbRecordFM> linkedList = ExtDbRecordFM.findRecordsFM(extDb, stringBuilder.toString(), null, 0.0, 0.0, errorLogger);
            if (null == linkedList) {
                return null;
            }
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                ExtDbRecordFM extDbRecordFM = (ExtDbRecordFM)iterator.next();
                hashMap.put(extDbRecordFM.extRecordID, extDbRecordFM);
            }
        }
        return hashMap;
    }

    public static boolean doesRecordIDExistFM(ExtDb extDb, String string) {
        if (!ExtDbRecordFM.isExtDbSupported(extDb)) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            ExtDbRecordFM.addRecordIDQueryFM(extDb.type, extDb.version, string, stringBuilder, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        DbConnection dbConnection = extDb.connectDb();
        if (null == dbConnection) {
            return false;
        }
        boolean bl = false;
        try {
            if (4 == extDb.type) {
                dbConnection.query("SELECT COUNT(*) FROM fm_eng_data WHERE " + stringBuilder.toString());
            } else if (5 == extDb.type) {
                dbConnection.query("SELECT COUNT(*) FROM mass_media.app_location WHERE " + stringBuilder.toString());
            } else {
                dbConnection.query("SELECT COUNT(*) FROM app_location WHERE " + stringBuilder.toString());
            }
            if (dbConnection.next()) {
                bl = dbConnection.getInt(1) > 0;
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        extDb.releaseDb(dbConnection);
        return bl;
    }

    public static boolean addRecordIDQueryFM(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            if (4 == n) {
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("The record ID must be a number");
                }
                if (n3 <= 0) {
                    throw new IllegalArgumentException("The record ID must be greater than 0");
                }
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                stringBuilder.append("(fm_eng_data.application_id = ");
                stringBuilder.append(string);
                stringBuilder.append(')');
            } else {
                stringBuilder.append("(UPPER(app_location.aloc_aapp_application_id) = '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append("')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addFileNumberQueryFM(int n, int n2, String string, String string2, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                if (string.length() > 0) {
                    stringBuilder.append("((UPPER(application.file_prefix) = '");
                    stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                    stringBuilder.append("') AND (UPPER(application.app_arn) = '");
                    stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
                    stringBuilder.append("'))");
                } else {
                    stringBuilder.append("(UPPER(application.app_arn) = '");
                    stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
                    stringBuilder.append("')");
                }
            } else if (5 == n) {
                if (string.length() > 0) {
                    stringBuilder.append("(UPPER(application.aapp_file_num) = '");
                    stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                    stringBuilder.append('-');
                    stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
                } else {
                    stringBuilder.append("(UPPER(application.aapp_file_num) LIKE '%");
                    stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
                }
                stringBuilder.append("')");
            } else {
                if (string.length() > 0) {
                    stringBuilder.append("(application._search_filenum = '");
                    stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                    stringBuilder.append('-');
                    stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
                } else {
                    stringBuilder.append("(application._search_arn = '");
                    stringBuilder.append(DbConnection.clean(string2.toUpperCase()));
                }
                stringBuilder.append("')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addFacilityIDQueryFM(int n, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                stringBuilder.append("(fm_eng_data.facility_id = ");
            } else {
                stringBuilder.append("(application_facility.afac_facility_id = ");
            }
            stringBuilder.append(String.valueOf(n3));
            stringBuilder.append(')');
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addServiceQueryFM(int n, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                stringBuilder.append("(fm_eng_data.asd_service IN ");
            } else {
                stringBuilder.append("(license_filing_version.service_code IN ");
            }
            ExtDbRecordFM.addServiceCodeList(n, 3, n3, stringBuilder);
            stringBuilder.append(')');
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addServiceTypeQueryFM(int n, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                stringBuilder.append("(fm_eng_data.asd_service IN ");
            } else {
                stringBuilder.append("(license_filing_version.service_code IN ");
            }
            ExtDbRecordFM.addServiceCodeList(n, 3, n3, 3, stringBuilder);
            stringBuilder.append(')');
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addCallSignQueryFM(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                stringBuilder.append("(UPPER(CASE WHEN (facility.fac_callsign <> '') THEN facility.fac_callsign ELSE application.fac_callsign END) REGEXP '^D*");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append(".*')");
            } else if (5 == n) {
                stringBuilder.append("(UPPER(facility.callsign) ~ '^D*");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append(".*')");
            } else {
                stringBuilder.append("(facility._search_callsign LIKE '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append("%')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addChannelQueryFM(int n, int n2, int n3, int n4, int n5, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            if (n4 > 0 && n5 > 0 && (n3 < n4 || n3 > n5)) {
                throw new IllegalArgumentException("The channel must be in the range " + n4 + " to " + n5);
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                stringBuilder.append("(fm_eng_data.station_channel = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(')');
            } else if (5 == n) {
                stringBuilder.append("(CASE WHEN TRIM(application_facility.afac_channel) IN ('','null') THEN false ELSE (application_facility.afac_channel::INT = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(") END)");
            } else {
                stringBuilder.append("(application_facility.afac_channel = ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addChannelRangeQueryFM(int n, int n2, int n3, int n4, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                stringBuilder.append("(fm_eng_data.station_channel BETWEEN ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(" AND ");
                stringBuilder.append(String.valueOf(n4));
                stringBuilder.append(')');
            } else if (5 == n) {
                stringBuilder.append("(CASE WHEN TRIM(application_facility.afac_channel) IN ('','null') THEN false ELSE (application_facility.afac_channel::INT BETWEEN ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(" AND ");
                stringBuilder.append(String.valueOf(n4));
                stringBuilder.append(") END)");
            } else {
                stringBuilder.append("(application_facility.afac_channel BETWEEN ");
                stringBuilder.append(String.valueOf(n3));
                stringBuilder.append(" AND ");
                stringBuilder.append(String.valueOf(n4));
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addMultipleChannelQueryFM(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                stringBuilder.append("(fm_eng_data.station_channel IN ");
                stringBuilder.append(string);
                stringBuilder.append(')');
            } else if (5 == n) {
                stringBuilder.append("(CASE WHEN TRIM(application_facility.afac_channel) IN ('','null') THEN false ELSE (application_facility.afac_channel::INT IN ");
                stringBuilder.append(string);
                stringBuilder.append(") END)");
            } else {
                stringBuilder.append("(application_facility.afac_channel IN ");
                stringBuilder.append(string);
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addStatusQueryFM(int n, int n2, int n3, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            switch (n3) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown status code");
                }
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                if (5 == n3) {
                    stringBuilder.append("(facility.fac_status = 'EXPER')");
                } else if (0 == n3) {
                    stringBuilder.append("(UPPER(application.app_type) IN ('STA', 'STAX'))");
                } else if (6 == n3) {
                    stringBuilder.append("(false)");
                } else {
                    stringBuilder.append("(UPPER(fm_eng_data.fm_dom_status) IN ");
                    String string = "('";
                    for (int i = 0; i < CDBS_STATUS_TYPES.length; ++i) {
                        if (CDBS_STATUS_TYPES[i] != n3) continue;
                        stringBuilder.append(string);
                        stringBuilder.append(CDBS_STATUS_CODES[i]);
                        string = "','";
                    }
                    stringBuilder.append("'))");
                }
            } else if (5 == n3) {
                stringBuilder.append("(facility.facility_status = 'EXPER')");
            } else if (0 == n3) {
                stringBuilder.append("((facility.facility_status <> 'EXPER') AND ");
                stringBuilder.append("(UPPER(license_filing_version.auth_type_code) = 'S'))");
            } else {
                stringBuilder.append("((facility.facility_status <> 'EXPER') AND ");
                stringBuilder.append("(UPPER(license_filing_version.auth_type_code) <> 'S') AND ");
                if (6 == n3) {
                    stringBuilder.append("(UPPER(license_filing_version.current_status_code = 'REV')))");
                } else {
                    if (3 == n3) {
                        stringBuilder.append("(((UPPER(license_filing_version.auth_type_code) = 'C') AND ");
                        stringBuilder.append("(UPPER(license_filing_version.current_status_code) = 'PEN')) OR ");
                        stringBuilder.append("(UPPER(license_filing_version.current_status_code) IN ");
                    } else {
                        stringBuilder.append("(((UPPER(license_filing_version.auth_type_code) <> 'C') OR ");
                        stringBuilder.append("(UPPER(license_filing_version.current_status_code) <> 'PEN')) AND ");
                        stringBuilder.append("(UPPER(license_filing_version.current_status_code) NOT IN ");
                    }
                    String string = "('";
                    for (int i = 0; i < LMS_APP_STATUS_CODES.length; ++i) {
                        stringBuilder.append(string);
                        stringBuilder.append(LMS_APP_STATUS_CODES[i]);
                        string = "','";
                    }
                    stringBuilder.append("')))");
                    if (3 == n3) {
                        stringBuilder.append(')');
                    } else if (1 == n3) {
                        stringBuilder.append(" AND (UPPER(license_filing_version.auth_type_code) = 'C'))");
                    } else if (2 == n3) {
                        stringBuilder.append(" AND (UPPER(license_filing_version.auth_type_code) = 'L'))");
                    }
                }
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addCityQueryFM(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                stringBuilder.append("(UPPER(CASE WHEN (facility.comm_city <> '') THEN facility.comm_city ELSE application.comm_city END) LIKE '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()).replace('*', '%'));
                stringBuilder.append("%')");
            } else if (5 == n) {
                stringBuilder.append("(UPPER(CASE WHEN (facility.community_served_city <> '') THEN facility.community_served_city ELSE application_facility.afac_community_city END) LIKE '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()).replace('*', '%'));
                stringBuilder.append("%')");
            } else {
                stringBuilder.append("(facility._search_city LIKE '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()).replace('*', '%'));
                stringBuilder.append("%')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addStateQueryFM(int n, int n2, String string, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            if (null == string || 0 == string.length()) {
                return false;
            }
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                stringBuilder.append("(UPPER(CASE WHEN (facility.comm_state <> '') THEN facility.comm_state ELSE application.comm_state END) = '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append("')");
            } else {
                stringBuilder.append("(UPPER(CASE WHEN (facility.community_served_state <> '') THEN facility.community_served_state ELSE application_facility.afac_community_state_code END) = '");
                stringBuilder.append(DbConnection.clean(string.toUpperCase()));
                stringBuilder.append("')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addCountryQueryFM(int n, int n2, Country country, StringBuilder stringBuilder, boolean bl) throws IllegalArgumentException {
        if (4 == n || 2 == n || 5 == n) {
            if (bl) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                stringBuilder.append("(UPPER(facility.fac_country) = '");
                stringBuilder.append(country.countryCode);
                stringBuilder.append("')");
            } else {
                stringBuilder.append("(UPPER(application_facility.country_code) = '");
                stringBuilder.append(country.countryCode);
                stringBuilder.append("')");
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static boolean addRecordTypeQueryFM(int n, int n2, boolean bl, StringBuilder stringBuilder, boolean bl2) {
        if (4 == n || 2 == n || 5 == n) {
            if (bl) {
                return false;
            }
            if (bl2) {
                stringBuilder.append(" AND ");
            }
            if (4 == n) {
                stringBuilder.append("((fm_eng_data.eng_record_type <> 'A') AND (facility.fac_status NOT IN ('FVOID', 'PRCAN', 'LICAN')))");
            } else {
                stringBuilder.append("((license_filing_version.active_ind = 'Y') AND ");
                stringBuilder.append("(facility.facility_status <> 'FVOID')");
                stringBuilder.append(')');
            }
            return true;
        }
        throw new IllegalArgumentException("Unknown or unsupported station data type");
    }

    public static int addRecords(ExtDb extDb, ScenarioEditData scenarioEditData, int n, String string, GeoPoint geoPoint, double d, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4, ErrorLogger errorLogger) {
        Object object;
        Object object2;
        Object object3;
        int n4;
        int n5;
        Object object4;
        Cloneable cloneable;
        int n6 = scenarioEditData.study.study.studyType;
        if (!ExtDbRecordFM.isExtDbSupported(extDb) || !Study.isRecordTypeAllowed(n6, 3) || (1 == n || 3 == n) && 4 != n6 && 5 != n6) {
            return 0;
        }
        double d2 = scenarioEditData.study.getCoChannelMxDistance();
        double d3 = scenarioEditData.study.getKilometersPerDegree();
        int n7 = 200;
        int n8 = 300;
        if ((1 == n || 3 == n) && 5 == n6) {
            n8 = 220;
        }
        if (n2 > n7) {
            n7 = n2;
        }
        if (n3 > 0 && n3 < n8) {
            n8 = n3;
        }
        if (n7 > n8) {
            return 0;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl5 = false;
        if (null != string && string.length() > 0) {
            stringBuilder.append(string);
            bl5 = true;
        }
        ArrayList<SourceEditData> arrayList = null;
        Collection collection = null;
        if (1 == n) {
            try {
                ExtDbRecordFM.addChannelRangeQueryFM(extDb.type, extDb.version, n7, n8, stringBuilder, bl5);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            int n9;
            if (3 == n) {
                arrayList = scenarioEditData.sourceData.getUndesiredSources(3);
                if (arrayList.isEmpty()) {
                    if (null != errorLogger) {
                        errorLogger.reportError("There are no undesired FM stations in the scenario");
                    }
                    return -1;
                }
            } else {
                arrayList = scenarioEditData.sourceData.getDesiredSources(3);
                if (arrayList.isEmpty()) {
                    if (null != errorLogger) {
                        errorLogger.reportError("There are no desired FM stations in the scenario");
                    }
                    return -1;
                }
            }
            cloneable = new HashMap();
            for (IxRuleEditData ixRuleEditData : scenarioEditData.study.ixRuleData.getActiveRows()) {
                if (3 != ixRuleEditData.serviceType.recordType) continue;
                object4 = (SearchDelta)((HashMap)cloneable).get(ixRuleEditData.channelDelta.delta);
                if (null == object4) {
                    object4 = new SearchDelta();
                    ((SearchDelta)object4).delta = ixRuleEditData.channelDelta.delta;
                    ((SearchDelta)object4).maximumDistance = ixRuleEditData.distance;
                    ((HashMap)cloneable).put(((SearchDelta)object4).delta, object4);
                    continue;
                }
                if (!(ixRuleEditData.distance > ((SearchDelta)object4).maximumDistance)) continue;
                ((SearchDelta)object4).maximumDistance = ixRuleEditData.distance;
            }
            collection = ((HashMap)cloneable).values();
            n5 = 0;
            n4 = n8 - n7 + 1;
            object3 = new boolean[n4];
            for (SourceEditData sourceEditData : arrayList) {
                SourceEditDataFM sourceEditDataFM = (SourceEditDataFM)sourceEditData;
                for (SearchDelta searchDelta : collection) {
                    int n10;
                    int n11;
                    if (3 != n ? (n11 = (n10 = sourceEditDataFM.channel) + searchDelta.delta) < n7 || n11 > n8 || object3[n9 = n11 - n7] != false : (n10 = (n11 = sourceEditDataFM.channel) - searchDelta.delta) < n7 || n10 > n8 || object3[n9 = n10 - n7] != false) continue;
                    if (object3[n9] != false) continue;
                    object3[n9] = true;
                    if (++n5 != n4) continue;
                    break;
                }
                if (n5 != n4) continue;
                break;
            }
            if (0 == n5) {
                return 0;
            }
            if (n5 < n4) {
                object2 = new StringBuilder();
                int n12 = 40;
                for (n9 = 0; n9 < n4; ++n9) {
                    if (object3[n9] == false) continue;
                    ((StringBuilder)object2).append((char)n12);
                    ((StringBuilder)object2).append(String.valueOf(n9 + n7));
                    n12 = 44;
                }
                ((StringBuilder)object2).append(')');
                try {
                    ExtDbRecordFM.addMultipleChannelQueryFM(extDb.type, extDb.version, ((StringBuilder)object2).toString(), stringBuilder, bl5);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                try {
                    ExtDbRecordFM.addChannelRangeQueryFM(extDb.type, extDb.version, n7, n8, stringBuilder, bl5);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        cloneable = ExtDbRecordFM.findRecordsFM(extDb, stringBuilder.toString(), geoPoint, d, d3, errorLogger);
        if (null == cloneable) {
            return -1;
        }
        if (((AbstractCollection)((Object)cloneable)).isEmpty()) {
            return 0;
        }
        ExtDbRecordFM.removeAllMX(scenarioEditData, (LinkedList<ExtDbRecordFM>)cloneable, bl, bl2, bl3, d2, d3);
        if (1 != n) {
            object4 = ((LinkedList)cloneable).listIterator(0);
            while (object4.hasNext()) {
                object = (ExtDbRecordFM)object4.next();
                n5 = 1;
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    object2 = (SourceEditData)object3.next();
                    SourceEditDataFM sourceEditDataFM = (SourceEditDataFM)object2;
                    n4 = 3 == n ? sourceEditDataFM.channel - ((ExtDbRecordFM)object).channel : ((ExtDbRecordFM)object).channel - sourceEditDataFM.channel;
                    for (Object object5 : collection) {
                        double d4;
                        if (((SearchDelta)object5).delta != n4) continue;
                        if (3 == n) {
                            d4 = ((SearchDelta)object5).maximumDistance + ((ExtDbRecordFM)object).getRuleExtraDistance(scenarioEditData.study);
                            if (!(((ExtDbRecordFM)object).location.distanceTo(sourceEditDataFM.location, d3) <= d4)) continue;
                            n5 = 0;
                            break;
                        }
                        d4 = ((SearchDelta)object5).maximumDistance + sourceEditDataFM.getRuleExtraDistance();
                        if (!(sourceEditDataFM.location.distanceTo(((ExtDbRecordFM)object).location, d3) <= d4)) continue;
                        n5 = 0;
                        break;
                    }
                    if (n5 != 0) continue;
                    break;
                }
                if (n5 == 0) continue;
                object4.remove();
            }
        }
        object = new ArrayList();
        if (null != errorLogger) {
            errorLogger.clearErrors();
        } else {
            errorLogger = new ErrorLogger(null, null);
        }
        Iterator iterator = ((AbstractSequentialList)((Object)cloneable)).iterator();
        while (iterator.hasNext()) {
            ExtDbRecordFM extDbRecordFM = (ExtDbRecordFM)iterator.next();
            object4 = scenarioEditData.study.findSharedSource(extDbRecordFM.extDb.key, extDbRecordFM.extRecordID);
            if (null == object4 && null == (object4 = SourceEditData.makeSource(extDbRecordFM, scenarioEditData.study, true, errorLogger))) {
                if (!errorLogger.hasErrors()) continue;
                return -1;
            }
            ((ArrayList)object).add(object4);
        }
        boolean bl6 = true;
        boolean bl7 = true;
        if (1 == n || 3 == n) {
            bl7 = bl ? false : bl4;
        } else {
            bl6 = false;
            if (bl) {
                bl7 = false;
            }
        }
        Iterator iterator2 = ((ArrayList)object).iterator();
        while (iterator2.hasNext()) {
            SourceEditData sourceEditData = (SourceEditData)iterator2.next();
            scenarioEditData.sourceData.addOrReplace(sourceEditData, bl6, bl7);
        }
        return ((ArrayList)object).size();
    }

    private static void removeAllMX(ScenarioEditData scenarioEditData, LinkedList<ExtDbRecordFM> linkedList, boolean bl, boolean bl2, boolean bl3, double d, double d2) {
        ExtDbRecordFM extDbRecordFM;
        ArrayList<SourceEditData> arrayList = scenarioEditData.sourceData.getSources(3);
        ListIterator<ExtDbRecordFM> listIterator = linkedList.listIterator(0);
        block0: while (listIterator.hasNext()) {
            extDbRecordFM = listIterator.next();
            for (SourceEditData object2 : arrayList) {
                SourceEditDataFM sourceEditDataFM = (SourceEditDataFM)object2;
                if (!extDbRecordFM.extRecordID.equals(sourceEditDataFM.extRecordID) && (bl || !ExtDbRecordFM.areRecordsMX(extDbRecordFM, sourceEditDataFM, bl2, d, d2))) continue;
                listIterator.remove();
                continue block0;
            }
        }
        if (bl) {
            return;
        }
        final boolean bl4 = bl3;
        Comparator<ExtDbRecordFM> comparator = new Comparator<ExtDbRecordFM>(){

            @Override
            public int compare(ExtDbRecordFM extDbRecordFM, ExtDbRecordFM extDbRecordFM2) {
                if (extDbRecordFM.isPreferredRecord(extDbRecordFM2, bl4)) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(linkedList, comparator);
        int n = linkedList.size() - 1;
        for (int i = 0; i < n; ++i) {
            extDbRecordFM = linkedList.get(i);
            listIterator = linkedList.listIterator(i + 1);
            while (listIterator.hasNext()) {
                if (!ExtDbRecordFM.areRecordsMX(extDbRecordFM, listIterator.next(), bl2, d, d2)) continue;
                listIterator.remove();
                --n;
            }
        }
    }

    private ExtDbRecordFM(ExtDb extDb) {
        super(extDb, 3);
    }

    public boolean updateSource(SourceEditDataFM sourceEditDataFM) {
        return this.updateSource(sourceEditDataFM, null);
    }

    public boolean updateSource(SourceEditDataFM sourceEditDataFM, ErrorLogger errorLogger) {
        Object object;
        boolean bl;
        if (!(this.extDb.dbID.equals(sourceEditDataFM.dbID) && this.facilityID == sourceEditDataFM.facilityID && this.stationClass == sourceEditDataFM.stationClass && this.service.equals(sourceEditDataFM.service) && this.country.equals(sourceEditDataFM.country))) {
            if (null != errorLogger) {
                errorLogger.reportError("ExtDbRecordFM.updateSource(): non-matching source object");
            }
            return false;
        }
        if (!ExtDbRecordFM.isExtDbSupported(this.extDb)) {
            if (null != errorLogger) {
                errorLogger.reportError("ExtDbRecordFM.updateSource(): unsupported station data type");
            }
            return false;
        }
        boolean bl2 = bl = 4 == this.extDb.type;
        if (null != errorLogger) {
            errorLogger.clearErrors();
        } else {
            errorLogger = new ErrorLogger(null, null);
        }
        boolean bl3 = false;
        sourceEditDataFM.isIBOC = this.isIBOC;
        sourceEditDataFM.ibocFraction = this.ibocFraction;
        sourceEditDataFM.callSign = this.callSign;
        sourceEditDataFM.channel = this.channel;
        sourceEditDataFM.city = this.city;
        sourceEditDataFM.state = this.state;
        sourceEditDataFM.status = this.status;
        sourceEditDataFM.statusType = this.statusType;
        sourceEditDataFM.fileNumber = this.filePrefix + this.appARN;
        sourceEditDataFM.appARN = this.appARN;
        sourceEditDataFM.location.setLatLon(this.location);
        sourceEditDataFM.heightAMSL = this.heightAMSL;
        sourceEditDataFM.overallHAAT = this.overallHAAT;
        sourceEditDataFM.peakERP = this.peakERP;
        if (this.isIBOC) {
            if (bl) {
                object = this.extDb.connectDb(errorLogger);
                if (null != object) {
                    try {
                        ((DbConnection)object).query("SELECT if_notification.digital_erp / if_notification.analog_erp FROM if_notification JOIN application USING (application_id) WHERE application.app_service = 'FD' AND application.facility_id = " + this.facilityID + " ORDER BY application.app_arn DESC LIMIT 1");
                        if (((DbConnection)object).next()) {
                            sourceEditDataFM.ibocFraction = ((DbConnection)object).getDouble(1);
                        }
                        this.extDb.releaseDb((DbConnection)object);
                    }
                    catch (SQLException sQLException) {
                        this.extDb.releaseDb((DbConnection)object);
                        bl3 = true;
                        DbConnection.reportError(errorLogger, sQLException);
                    }
                } else {
                    bl3 = true;
                }
                if (bl3) {
                    return false;
                }
            }
            if (sourceEditDataFM.ibocFraction < 0.01) {
                sourceEditDataFM.ibocFraction = 0.01;
            }
            if (sourceEditDataFM.ibocFraction > 0.1) {
                sourceEditDataFM.ibocFraction = 0.1;
            }
        }
        if (null != this.antennaRecordID && (this.daIndicated || null == sourceEditDataFM.study || !sourceEditDataFM.study.getTrustPatternFlag())) {
            object = null;
            DbConnection dbConnection = this.extDb.connectDb(errorLogger);
            if (null != dbConnection) {
                try {
                    if (bl) {
                        dbConnection.query("SELECT ant_make, ant_model_num FROM ant_make WHERE antenna_id = " + this.antennaRecordID);
                    } else if (5 == this.extDb.type) {
                        dbConnection.query("SELECT aant_make, aant_model FROM mass_media.app_antenna WHERE aant_antenna_record_id = '" + this.antennaRecordID + "'");
                    } else {
                        dbConnection.query("SELECT aant_make, aant_model FROM app_antenna WHERE aant_antenna_record_id = '" + this.antennaRecordID + "'");
                    }
                    if (dbConnection.next()) {
                        String string;
                        String string2 = dbConnection.getString(1);
                        if (null == string2) {
                            string2 = "";
                        }
                        if (null == (string = dbConnection.getString(2))) {
                            string = "";
                        }
                        if (((String)(object = string2 + "-" + string)).length() > 255) {
                            object = ((String)object).substring(0, 255);
                        }
                    } else {
                        errorLogger.logMessage(ExtDbRecordFM.makeMessage(this, "Antenna record ID " + this.antennaRecordID + " not found"));
                    }
                    this.extDb.releaseDb(dbConnection);
                }
                catch (SQLException sQLException) {
                    this.extDb.releaseDb(dbConnection);
                    bl3 = true;
                    DbConnection.reportError(errorLogger, sQLException);
                }
            } else {
                bl3 = true;
            }
            if (bl3) {
                return false;
            }
            if (null != object) {
                AntPattern antPattern = ExtDb.getHorizontalPattern(this, (String)object, errorLogger);
                if (null != antPattern) {
                    sourceEditDataFM.antennaID = this.antennaID;
                    sourceEditDataFM.hasHorizontalPattern = true;
                    sourceEditDataFM.horizontalPattern = antPattern;
                    sourceEditDataFM.horizontalPatternChanged = true;
                } else if (errorLogger.hasErrors()) {
                    return false;
                }
            }
        }
        sourceEditDataFM.horizontalPatternOrientation = this.horizontalPatternOrientation;
        sourceEditDataFM.setAttribute("sequenceDate", AppCore.formatDate(this.sequenceDate));
        if (null != this.licensee && this.licensee.length() > 0) {
            sourceEditDataFM.setAttribute("licensee", this.licensee);
        }
        if (this.isPending) {
            sourceEditDataFM.setAttribute("-isPending");
        }
        if (this.isArchived) {
            sourceEditDataFM.setAttribute("-isArchived");
        }
        if (this.contour73215) {
            sourceEditDataFM.setAttribute("contour73215");
        }
        sourceEditDataFM.useGenericVerticalPattern = null == sourceEditDataFM.study ? true : sourceEditDataFM.study.getUseGenericVpat(sourceEditDataFM.country.key - 1);
        if (3 == this.country.key && 21 == this.service.serviceType.key && null != sourceEditDataFM.study) {
            if (0.0 == this.peakERP) {
                switch (this.stationClass) {
                    default: {
                        sourceEditDataFM.peakERP = sourceEditDataFM.study.getDefaultMexicanFMAERP();
                        break;
                    }
                    case 6: {
                        sourceEditDataFM.peakERP = sourceEditDataFM.study.getDefaultMexicanFMBERP();
                        break;
                    }
                    case 7: {
                        sourceEditDataFM.peakERP = sourceEditDataFM.study.getDefaultMexicanFMB1ERP();
                        break;
                    }
                    case 1: {
                        sourceEditDataFM.peakERP = sourceEditDataFM.study.getDefaultMexicanFMCERP();
                        break;
                    }
                    case 3: {
                        sourceEditDataFM.peakERP = sourceEditDataFM.study.getDefaultMexicanFMC1ERP();
                    }
                }
                errorLogger.logMessage(ExtDbRecordFM.makeMessage(this, "Used default for missing ERP"));
            }
            if (0.0 == this.heightAMSL && 0.0 == this.overallHAAT) {
                switch (this.stationClass) {
                    default: {
                        sourceEditDataFM.overallHAAT = sourceEditDataFM.study.getDefaultMexicanFMAHAAT();
                        break;
                    }
                    case 6: {
                        sourceEditDataFM.overallHAAT = sourceEditDataFM.study.getDefaultMexicanFMBHAAT();
                        break;
                    }
                    case 7: {
                        sourceEditDataFM.overallHAAT = sourceEditDataFM.study.getDefaultMexicanFMB1HAAT();
                        break;
                    }
                    case 1: {
                        sourceEditDataFM.overallHAAT = sourceEditDataFM.study.getDefaultMexicanFMCHAAT();
                        break;
                    }
                    case 3: {
                        sourceEditDataFM.overallHAAT = sourceEditDataFM.study.getDefaultMexicanFMC1HAAT();
                    }
                }
                errorLogger.logMessage(ExtDbRecordFM.makeMessage(this, "Used default for missing HAAT"));
            }
        }
        if (1 != this.country.key && 0.0 == this.heightAMSL && 0.0 != this.overallHAAT) {
            sourceEditDataFM.heightAMSL = -999.0;
            errorLogger.logMessage(ExtDbRecordFM.makeMessage(this, "Derived missing AMSL from HAAT"));
        }
        if (0.0 == this.peakERP) {
            sourceEditDataFM.peakERP = 0.001;
            errorLogger.logMessage(ExtDbRecordFM.makeMessage(this, "Used default for missing ERP"));
        }
        if (this.peakERP < 0.0) {
            sourceEditDataFM.peakERP = Math.pow(10.0, this.peakERP / 10.0);
            errorLogger.logMessage(ExtDbRecordFM.makeMessage(this, "Converted ERP from dBk to kilowatts"));
        }
        return true;
    }

    public static boolean areRecordsMX(ExtDbRecordFM extDbRecordFM, ExtDbRecordFM extDbRecordFM2, boolean bl, double d, double d2) {
        return ExtDbRecordFM.areRecordsMX(extDbRecordFM.facilityID, extDbRecordFM.channel, extDbRecordFM.country.key, extDbRecordFM.state, extDbRecordFM.city, extDbRecordFM.location, extDbRecordFM2.facilityID, extDbRecordFM2.channel, extDbRecordFM2.country.key, extDbRecordFM2.state, extDbRecordFM2.city, extDbRecordFM2.location, bl, d, d2);
    }

    public static boolean areRecordsMX(ExtDbRecordFM extDbRecordFM, SourceEditDataFM sourceEditDataFM, boolean bl, double d, double d2) {
        return ExtDbRecordFM.areRecordsMX(extDbRecordFM.facilityID, extDbRecordFM.channel, extDbRecordFM.country.key, extDbRecordFM.state, extDbRecordFM.city, extDbRecordFM.location, sourceEditDataFM.facilityID, sourceEditDataFM.channel, sourceEditDataFM.country.key, sourceEditDataFM.state, sourceEditDataFM.city, sourceEditDataFM.location, bl, d, d2);
    }

    public static boolean areRecordsMX(SourceEditDataFM sourceEditDataFM, SourceEditDataFM sourceEditDataFM2, boolean bl, double d, double d2) {
        return ExtDbRecordFM.areRecordsMX(sourceEditDataFM.facilityID, sourceEditDataFM.channel, sourceEditDataFM.country.key, sourceEditDataFM.state, sourceEditDataFM.city, sourceEditDataFM.location, sourceEditDataFM2.facilityID, sourceEditDataFM2.channel, sourceEditDataFM2.country.key, sourceEditDataFM2.state, sourceEditDataFM2.city, sourceEditDataFM2.location, bl, d, d2);
    }

    private static boolean areRecordsMX(int n, int n2, int n3, String string, String string2, GeoPoint geoPoint, int n4, int n5, int n6, String string3, String string4, GeoPoint geoPoint2, boolean bl, double d, double d2) {
        if (n == n4) {
            return true;
        }
        if (bl) {
            return false;
        }
        if (n2 != n5) {
            return false;
        }
        if (n3 != n6) {
            return false;
        }
        if (string.equalsIgnoreCase(string3) && string2.equalsIgnoreCase(string4)) {
            return true;
        }
        return d > 0.0 && geoPoint.distanceTo(geoPoint2, d2) < d;
    }

    public boolean isPreferredRecord(ExtDbRecordFM extDbRecordFM, boolean bl) {
        if (bl) {
            if (this.isOperating()) {
                if (!extDbRecordFM.isOperating()) {
                    return true;
                }
            } else if (extDbRecordFM.isOperating()) {
                return false;
            }
        }
        if (this.service.preferenceRank > extDbRecordFM.service.preferenceRank) {
            return true;
        }
        if (this.service.preferenceRank < extDbRecordFM.service.preferenceRank) {
            return false;
        }
        if (this.statusType < extDbRecordFM.statusType) {
            return true;
        }
        if (this.statusType > extDbRecordFM.statusType) {
            return false;
        }
        if (this.sequenceDate.after(extDbRecordFM.sequenceDate)) {
            return true;
        }
        if (this.sequenceDate.before(extDbRecordFM.sequenceDate)) {
            return false;
        }
        return this.extRecordID.compareTo(extDbRecordFM.extRecordID) > 0;
    }

    public boolean isOperating() {
        if (this.operatingStatusSet) {
            return this.isOperatingFacility;
        }
        if (!this.service.isOperating || this.isArchived) {
            this.isOperatingFacility = false;
        } else {
            switch (this.statusType) {
                case 0: 
                case 2: {
                    this.isOperatingFacility = true;
                    break;
                }
                case 1: 
                case 4: {
                    if (1 == this.country.key) {
                        this.isOperatingFacility = false;
                        break;
                    }
                    this.isOperatingFacility = true;
                    break;
                }
                default: {
                    this.isOperatingFacility = false;
                }
            }
        }
        this.operatingStatusSet = true;
        return this.isOperatingFacility;
    }

    public double getRuleExtraDistance(StudyEditData studyEditData) {
        return SourceEditDataFM.getRuleExtraDistance(studyEditData, this.service, this.stationClass, this.country, this.channel, this.peakERP);
    }

    @Override
    protected ArrayList<String> getComments() {
        boolean bl;
        ArrayList<String> arrayList = null;
        boolean bl2 = bl = null != this.licensee && this.licensee.length() > 0;
        if (bl || this.contour73215) {
            arrayList = new ArrayList<String>();
            if (bl) {
                arrayList.add("Licensee: " + this.licensee);
            }
            if (this.contour73215) {
                arrayList.add("73.215 contour protection requested");
            }
        }
        return arrayList;
    }

    @Override
    public String getFacilityID() {
        return String.valueOf(this.facilityID);
    }

    @Override
    public String getSortFacilityID() {
        return String.format(Locale.US, "%07d", this.facilityID);
    }

    @Override
    public String getCallSign() {
        return this.callSign;
    }

    @Override
    public String getChannel() {
        return String.valueOf(this.channel) + FM_CLASS_CODES[this.stationClass];
    }

    @Override
    public int getChannelNumber() {
        return this.channel;
    }

    @Override
    public String getSortChannel() {
        return String.format(Locale.US, "%03d%02d", this.channel, this.stationClass);
    }

    @Override
    public String getFrequency() {
        return SourceEditDataFM.getFrequency(this.channel);
    }

    @Override
    public double getFrequencyValue() {
        return SourceEditDataFM.getFrequencyValue(this.channel);
    }

    @Override
    public String getStatus() {
        return this.status + (this.isPending ? " *P" : (this.isArchived ? " *A" : ""));
    }

    @Override
    public String getSortStatus() {
        return String.valueOf(this.statusType);
    }

    @Override
    public String getFileNumber() {
        return this.filePrefix + this.appARN;
    }

    @Override
    public String getARN() {
        return this.appARN;
    }

    private static class SearchDelta {
        int delta;
        double maximumDistance;

        private SearchDelta() {
        }
    }
}

