/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AntPattern;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDbListener;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordFM;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.FrequencyOffset;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.data.Source;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataFM;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.SourceEditDataWL;
import gov.fcc.tvstudy.core.geo.GeoPoint;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ExtDb {
    public static final int DB_TYPE_NOT_SET = -1;
    public static final int DB_TYPE_UNKNOWN = 0;
    public static final int DB_TYPE_CDBS = 1;
    public static final int DB_TYPE_LMS = 2;
    public static final int DB_TYPE_CDBS_FM = 4;
    public static final int DB_TYPE_LMS_LIVE = 5;
    public static final int DB_TYPE_GENERIC_TV = 6;
    public static final int DB_TYPE_GENERIC_WL = 7;
    public static final int DB_TYPE_GENERIC_FM = 8;
    public static final int DB_TYPE_WIRELESS = 3;
    private static final int[] DB_TYPE_ORDER = new int[]{4, 2, 999, 6, 1, 3, 5, 7};
    public static final int RESERVED_KEY_RANGE_START = 10000;
    public static final int RESERVED_KEY_RANGE_END = 19999;
    public static final int KEY_LMS_LIVE = 10005;
    public static final int KEY_MOST_RECENT_LMS = 10102;
    public static final int KEY_MOST_RECENT_CDBS = 10103;
    public static final int KEY_MOST_RECENT_CDBS_FM = 10104;
    public static final String DOWNLOAD_SET_NAME = "(download)";
    public static final int GENERIC_FORMAT_UNKNOWN = 0;
    public static final int GENERIC_FORMAT_TEXT = 1;
    public static final int GENERIC_FORMAT_DBF = 2;
    public final String dbID;
    public final Integer key;
    public final String dbName;
    public final Date dbDate;
    public final int type;
    public final int version;
    public final int indexVersion;
    public String id;
    public String name;
    public String description;
    public boolean deleted;
    public boolean isDownload;
    public boolean isLocked;
    public boolean hasBadData;
    private final boolean isLive;
    private DbConnection liveDb;
    private ArrayDeque<DbConnection> dbPool;
    private HashSet<DbConnection> openDbs;
    private boolean dbLocked;
    private int nextRecordKey;
    private static final long CACHE_UPDATE_INTERVAL = 300000L;
    private static final String CDBS_TABLE_DEFS_FILE = "cdbs_table_defs.dat";
    private static final int CDBS_VERSION = 1;
    private static final int LMS_VERSION = 11;
    private static final int CDBS_FM_VERSION = 1;
    private static final int CDBS_MIN_VERSION = 1;
    private static final int LMS_MIN_VERSION = 2;
    private static final int CDBS_FM_MIN_VERSION = 1;
    public static final int LMS_INDEX_VERSION = 3;
    private static final int DOWNLOAD_TIMEOUT = 30000;
    private static ArrayList<KeyedRecord> downloadTypes = null;
    private static ArrayList<KeyedRecord> importTypes = null;
    private static HashMap<Integer, String> reservedKeyNames = new HashMap();
    private static HashMap<String, HashSet<ExtDbListener>> listeners;
    private static HashMap<String, HashMap<Integer, ExtDb>> dbCache;
    private static HashMap<String, HashMap<Integer, ExtDb>> mrCache;
    private static HashMap<String, Long> cacheLastUpdate;
    private static HashMap<String, ExtDb> lmsLiveDbCache;
    private static boolean lmsLiveDidTryOpen;
    private static String lmsLiveDbName;
    private static DbConnection lmsLiveDb;
    private static ArrayDeque<DbConnection> lmsLiveDbPool;
    private static HashSet<DbConnection> lmsLiveOpenDbs;
    private static boolean downloadInProgress;
    private static HashMap<String, String[]> CDBSFieldNamesMap;

    private ExtDb(String string, Integer n, String string2, Date date, int n2, int n3, int n4, boolean bl) {
        this.dbID = string;
        this.key = n;
        this.dbName = string2;
        this.dbDate = date;
        this.type = n2;
        this.version = n3;
        this.indexVersion = n4;
        this.isLive = bl;
    }

    public String toString() {
        return this.description;
    }

    public int hashCode() {
        return this.key;
    }

    public boolean equals(Object object) {
        return null != object && ((ExtDb)object).key.equals(this.key);
    }

    public DbConnection connectAndLock() {
        return this.connectAndLock(null);
    }

    public DbConnection connectAndLock(ErrorLogger errorLogger) {
        if (!this.isGeneric()) {
            if (null != errorLogger) {
                errorLogger.reportError("Connect failed, station data cannot be locked");
            }
            return null;
        }
        DbConnection dbConnection = this.connectDb(true, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        this.nextRecordKey = 1;
        try {
            dbConnection.query("SELECT MAX(source_key) FROM source");
            if (dbConnection.next()) {
                this.nextRecordKey = dbConnection.getInt(1) + 1;
            }
        }
        catch (SQLException sQLException) {
            DbCore.releaseDb(dbConnection);
            dbConnection = null;
            DbConnection.reportError(errorLogger, sQLException);
        }
        return dbConnection;
    }

    public DbConnection connectDb() {
        return this.connectDb(false, null);
    }

    public DbConnection connectDb(ErrorLogger errorLogger) {
        return this.connectDb(false, errorLogger);
    }

    private synchronized DbConnection connectDb(boolean bl, ErrorLogger errorLogger) {
        if (!this.isSupported()) {
            if (null != errorLogger) {
                errorLogger.reportError("The station data version is not supported");
            }
            return null;
        }
        DbConnection dbConnection = null;
        if (this.isLive) {
            dbConnection = this.dbPool.poll();
            if (null == dbConnection) {
                dbConnection = this.liveDb.copy();
            }
            this.openDbs.add(dbConnection);
            if (!dbConnection.connect(this.dbName, errorLogger)) {
                this.releaseDb(dbConnection);
                return null;
            }
        } else {
            if (this.dbLocked) {
                if (null != errorLogger) {
                    errorLogger.reportWarning("The station data is in use");
                }
                return null;
            }
            dbConnection = DbCore.connectDb(this.dbID, errorLogger);
            if (null == dbConnection) {
                return null;
            }
            String string = DbCore.getDbName(this.dbID);
            boolean bl2 = false;
            try {
                dbConnection.setDatabase(this.dbName);
                dbConnection.update("LOCK TABLES " + string + ".ext_db WRITE");
                dbConnection.query("SELECT locked FROM " + string + ".ext_db WHERE ext_db_key = " + this.key);
                if (dbConnection.next()) {
                    bl2 = this.isLocked = dbConnection.getBoolean(1);
                }
                if (!this.isLocked && bl) {
                    dbConnection.update("UPDATE " + string + ".ext_db SET locked = true WHERE ext_db_key = " + this.key);
                    this.dbLocked = true;
                    this.isLocked = true;
                }
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                DbConnection.reportError(errorLogger, sQLException);
                return null;
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            if (bl2) {
                if (null != errorLogger) {
                    errorLogger.reportWarning("The station data is in use");
                }
                DbCore.releaseDb(dbConnection);
                dbConnection = null;
            }
        }
        return dbConnection;
    }

    public synchronized void releaseDb(DbConnection dbConnection) {
        if (this.isLive) {
            if (this.openDbs.remove(dbConnection)) {
                dbConnection.close();
                this.dbPool.push(dbConnection);
            }
        } else {
            if (this.dbLocked) {
                try {
                    dbConnection.update("UPDATE " + DbCore.getDbName(this.dbID) + ".ext_db SET locked = false WHERE ext_db_key = " + this.key);
                }
                catch (SQLException sQLException) {
                    DbConnection.reportError(sQLException);
                }
                this.dbLocked = false;
                this.isLocked = false;
            }
            DbCore.releaseDb(dbConnection);
        }
    }

    public boolean unlock() {
        return this.unlock(null);
    }

    public boolean unlock(ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null == dbConnection) {
            return this.isLocked;
        }
        try {
            dbConnection.update("LOCK TABLES ext_db WRITE");
            dbConnection.update("UPDATE ext_db SET locked = false WHERE ext_db_key = " + this.key);
            this.dbLocked = false;
            this.isLocked = false;
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(errorLogger, sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        return this.isLocked;
    }

    public Integer getNewRecordKey() {
        if (this.dbLocked) {
            return this.nextRecordKey++;
        }
        return null;
    }

    public String getTypeName() {
        return ExtDb.getTypeName(this.type);
    }

    public static String getTypeName(int n) {
        switch (n) {
            case 1: {
                return "CDBS TV";
            }
            case 2: 
            case 5: {
                return "LMS";
            }
            case 4: {
                return "CDBS FM";
            }
            case 6: {
                return "TVStudy TV";
            }
            case 7: {
                return "Wireless";
            }
            case 8: {
                return "TVStudy FM";
            }
        }
        return "??";
    }

    public static synchronized ArrayList<KeyedRecord> getDownloadTypes() {
        if (null == downloadTypes) {
            downloadTypes = new ArrayList();
            downloadTypes.add(new KeyedRecord(2, ExtDb.getTypeName(2)));
        }
        return new ArrayList<KeyedRecord>(downloadTypes);
    }

    public static synchronized ArrayList<KeyedRecord> getImportTypes() {
        if (null == importTypes) {
            importTypes = new ArrayList();
            importTypes.add(new KeyedRecord(2, ExtDb.getTypeName(2)));
            importTypes.add(new KeyedRecord(7, ExtDb.getTypeName(7)));
            importTypes.add(new KeyedRecord(6, ExtDb.getTypeName(6)));
            importTypes.add(new KeyedRecord(8, ExtDb.getTypeName(8)));
            importTypes.add(new KeyedRecord(1, ExtDb.getTypeName(1)));
            importTypes.add(new KeyedRecord(4, ExtDb.getTypeName(4)));
        }
        return new ArrayList<KeyedRecord>(importTypes);
    }

    public static synchronized String getReservedKeyName(int n) {
        String string = reservedKeyNames.get(n);
        if (null == string) {
            string = "???";
        }
        return string;
    }

    public boolean isSupported() {
        return ExtDb.isSupported(this.type, this.version, this.indexVersion);
    }

    public static boolean isSupported(int n, int n2, int n3) {
        switch (n) {
            case 1: {
                return n2 >= 1;
            }
            case 2: {
                return n2 >= 2 && 3 == n3;
            }
            case 4: {
                return n2 >= 1;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public int getDefaultRecordType() {
        return ExtDb.getDefaultRecordType(this.type, this.version);
    }

    public static int getDefaultRecordType(int n, int n2) {
        switch (n) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                return 1;
            }
            case 7: {
                return 2;
            }
            case 4: 
            case 8: {
                return 3;
            }
        }
        return 0;
    }

    public boolean canProvide(int n) {
        return ExtDb.canProvide(this.type, this.version, n);
    }

    public static boolean canProvide(int n, int n2, int n3) {
        switch (n) {
            case 1: {
                return 1 == n3;
            }
            case 2: {
                return 1 == n3 || n2 > 6 && 3 == n3;
            }
            case 4: {
                return 3 == n3;
            }
            case 5: {
                return 1 == n3;
            }
            case 6: {
                return 1 == n3;
            }
            case 7: {
                return 2 == n3;
            }
            case 8: {
                return 3 == n3;
            }
        }
        return false;
    }

    public boolean isGeneric() {
        return ExtDb.isGeneric(this.type);
    }

    public static boolean isGeneric(int n) {
        return 6 == n || 7 == n || 8 == n;
    }

    public boolean hasBaseline() {
        return 1 == this.type || 2 == this.type && this.version > 1 || 5 == this.type;
    }

    public static ExtDb getExtDb(String string, Integer n) {
        return ExtDb.getExtDb(string, n, false, null);
    }

    public static ExtDb getExtDb(String string, Integer n, ErrorLogger errorLogger) {
        return ExtDb.getExtDb(string, n, false, errorLogger);
    }

    public static ExtDb getExtDb(String string, Integer n, boolean bl) {
        return ExtDb.getExtDb(string, n, bl, null);
    }

    public static synchronized ExtDb getExtDb(String string, Integer n, boolean bl, ErrorLogger errorLogger) {
        if (10005 == n) {
            return ExtDb.getLMSLiveExtDb(string, errorLogger);
        }
        HashMap<Integer, ExtDb> hashMap = ExtDb.getCache(string, errorLogger);
        if (null == hashMap) {
            return null;
        }
        ExtDb extDb = hashMap.get(n);
        if (null == extDb && null != (hashMap = mrCache.get(string))) {
            extDb = hashMap.get(n);
        }
        if (null == extDb) {
            if (null != errorLogger) {
                errorLogger.reportError("Invalid station data key");
            }
            return null;
        }
        if (extDb.deleted && !bl) {
            if (null != errorLogger) {
                errorLogger.reportWarning("The station data has been deleted");
            }
            return null;
        }
        if (!extDb.isSupported()) {
            if (null != errorLogger) {
                errorLogger.reportWarning("The station data version is not supported");
            }
            return null;
        }
        return extDb;
    }

    public static ExtDb getExtDb(String string, String string2) {
        return ExtDb.getExtDb(string, string2, null);
    }

    public static synchronized ExtDb getExtDb(String string, String string2, ErrorLogger errorLogger) {
        HashMap<Integer, ExtDb> hashMap = ExtDb.getCache(string, errorLogger);
        if (null == hashMap) {
            return null;
        }
        ExtDb extDb = null;
        for (ExtDb extDb2 : hashMap.values()) {
            if (extDb2.deleted || !extDb2.name.equalsIgnoreCase(string2)) continue;
            extDb = extDb2;
            break;
        }
        if (null != extDb && !extDb.isSupported()) {
            if (null != errorLogger) {
                errorLogger.reportWarning("The station data version is not supported");
            }
            return null;
        }
        return extDb;
    }

    public static String getExtDbTypeName(String string, Integer n) {
        ExtDb extDb = ExtDb.getExtDb(string, n, true, null);
        if (null == extDb) {
            if (10005 == n) {
                return "LMS";
            }
            return "";
        }
        return ExtDb.getTypeName(extDb.type);
    }

    public static String getExtDbDescription(String string, Integer n) {
        ExtDb extDb = ExtDb.getExtDb(string, n, true, null);
        if (null == extDb) {
            if (10005 == n) {
                return ExtDb.getReservedKeyName(10005) + " (offline)";
            }
            return "";
        }
        return extDb.description;
    }

    public static ArrayList<ExtDb> getExtDbs(String string, boolean bl) {
        return ExtDb.getExtDbs(string, bl, null);
    }

    public static synchronized ArrayList<ExtDb> getExtDbs(String string, boolean bl, ErrorLogger errorLogger) {
        HashMap<Integer, ExtDb> hashMap = ExtDb.getCache(string, errorLogger);
        if (null == hashMap) {
            return null;
        }
        ArrayList<ExtDb> arrayList = new ArrayList<ExtDb>();
        for (ExtDb extDb : hashMap.values()) {
            if (extDb.deleted || !bl && !extDb.isSupported()) continue;
            arrayList.add(extDb);
        }
        Collections.sort(arrayList, new Comparator<ExtDb>(){

            @Override
            public int compare(ExtDb extDb, ExtDb extDb2) {
                if (DB_TYPE_ORDER[extDb.type - 1] < DB_TYPE_ORDER[extDb2.type - 1]) {
                    return -1;
                }
                if (DB_TYPE_ORDER[extDb.type - 1] > DB_TYPE_ORDER[extDb2.type - 1]) {
                    return 1;
                }
                if (extDb.key > extDb2.key) {
                    return -1;
                }
                if (extDb.key < extDb2.key) {
                    return 1;
                }
                return 0;
            }
        });
        return arrayList;
    }

    public static ArrayList<KeyedRecord> getExtDbList(String string, int n) {
        return ExtDb.getExtDbList(string, n, 0, 0, true, true, null);
    }

    public static ArrayList<KeyedRecord> getExtDbList(String string, int n, ErrorLogger errorLogger) {
        return ExtDb.getExtDbList(string, n, 0, 0, true, true, errorLogger);
    }

    public static ArrayList<KeyedRecord> getExtDbList(String string, int n, boolean bl, boolean bl2) {
        return ExtDb.getExtDbList(string, n, 0, 0, bl, bl2, null);
    }

    public static ArrayList<KeyedRecord> getExtDbList(String string, int n, boolean bl, boolean bl2, ErrorLogger errorLogger) {
        return ExtDb.getExtDbList(string, n, 0, 0, bl, bl2, errorLogger);
    }

    public static ArrayList<KeyedRecord> getExtDbList(String string, int n, int n2) {
        return ExtDb.getExtDbList(string, 0, n, n2, true, true, null);
    }

    public static ArrayList<KeyedRecord> getExtDbList(String string, int n, int n2, ErrorLogger errorLogger) {
        return ExtDb.getExtDbList(string, 0, n, n2, true, true, errorLogger);
    }

    private static synchronized ArrayList<KeyedRecord> getExtDbList(String string, int n, int n2, int n3, boolean bl, boolean bl2, ErrorLogger errorLogger) {
        HashMap<Integer, ExtDb> hashMap = ExtDb.getCache(string, errorLogger);
        if (null == hashMap) {
            return null;
        }
        ArrayList<DbListItem> arrayList = new ArrayList<DbListItem>();
        Object object = hashMap.values().iterator();
        while (object.hasNext()) {
            ExtDb extDb = object.next();
            if (extDb.deleted || !bl && extDb.isGeneric() || 0 != n && !extDb.canProvide(n) || 0 != n2 && n2 != extDb.type || extDb.version < n3 || !extDb.isSupported()) continue;
            arrayList.add(new DbListItem(extDb.key, extDb.description, extDb.type));
        }
        if (!(0 != n && 1 != n || 0 != n2 && 2 != n2 && 5 != n2 || null == (object = ExtDb.getLMSLiveExtDb(string, errorLogger)))) {
            arrayList.add(new DbListItem(((ExtDb)object).key, ((ExtDb)object).description, ((ExtDb)object).type));
        }
        if (bl2 && null != (hashMap = mrCache.get(string))) {
            for (Map.Entry<Integer, ExtDb> entry : hashMap.entrySet()) {
                object = entry.getValue();
                if (0 != n && !((ExtDb)object).canProvide(n) || 0 != n2 && n2 != ((ExtDb)object).type || ((ExtDb)object).version < n3) continue;
                int n4 = entry.getKey();
                arrayList.add(new DbListItem(n4, ExtDb.getReservedKeyName(n4), ((ExtDb)object).type));
            }
        }
        Comparator<DbListItem> comparator = new Comparator<DbListItem>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int compare(DbListItem dbListItem, DbListItem dbListItem2) {
                if (DB_TYPE_ORDER[dbListItem.type - 1] < DB_TYPE_ORDER[dbListItem2.type - 1]) {
                    return -1;
                }
                if (DB_TYPE_ORDER[dbListItem.type - 1] > DB_TYPE_ORDER[dbListItem2.type - 1]) {
                    return 1;
                }
                if (dbListItem.key >= 10000 && dbListItem.key <= 19999) {
                    if (dbListItem2.key < 10000 || dbListItem2.key > 19999) return -1;
                    if (dbListItem.key < dbListItem2.key) {
                        return -1;
                    }
                    if (dbListItem.key <= dbListItem2.key) return 0;
                    return 1;
                }
                if (dbListItem2.key >= 10000 && dbListItem2.key <= 19999) {
                    return 1;
                }
                if (dbListItem.key > dbListItem2.key) {
                    return -1;
                }
                if (dbListItem.key >= dbListItem2.key) return 0;
                return 1;
            }
        };
        Collections.sort(arrayList, comparator);
        return new ArrayList<KeyedRecord>(arrayList);
    }

    public static synchronized void addListener(ExtDbListener extDbListener) {
        String string = extDbListener.getDbID();
        HashSet<ExtDbListener> hashSet = listeners.get(string);
        if (null == hashSet) {
            hashSet = new HashSet();
            listeners.put(string, hashSet);
        }
        hashSet.add(extDbListener);
    }

    public static synchronized void removeListener(ExtDbListener extDbListener) {
        String string = extDbListener.getDbID();
        HashSet<ExtDbListener> hashSet = listeners.get(string);
        if (null != hashSet) {
            hashSet.remove(extDbListener);
        }
    }

    public static boolean checkExtDbName(String string, String string2) {
        return ExtDb.checkExtDbName(string, string2, null, null);
    }

    public static boolean checkExtDbName(String string, String string2, ErrorLogger errorLogger) {
        return ExtDb.checkExtDbName(string, string2, null, errorLogger);
    }

    public static boolean checkExtDbName(String string, String string2, String string3) {
        return ExtDb.checkExtDbName(string, string2, string3, null);
    }

    public static boolean checkExtDbName(String string, String string2, String string3, ErrorLogger errorLogger) {
        if (null != string3 && string3.length() > 0 && string2.equalsIgnoreCase(string3)) {
            return true;
        }
        if (0 == string2.length()) {
            return true;
        }
        if (string2.length() > 245) {
            if (null != errorLogger) {
                errorLogger.reportWarning("The station data name cannot be more than 245 characters long");
            }
            return false;
        }
        if (string2.contains(String.valueOf('#'))) {
            if (null != errorLogger) {
                errorLogger.reportWarning("The station data name cannot contain the character '#'");
            }
            return false;
        }
        for (String string4 : reservedKeyNames.values()) {
            if (!string2.equalsIgnoreCase(string4)) continue;
            if (null != errorLogger) {
                errorLogger.reportWarning("That station data name cannot be used, please try again");
            }
            return false;
        }
        if (string2.equalsIgnoreCase(DOWNLOAD_SET_NAME)) {
            if (null != errorLogger) {
                errorLogger.reportWarning("That station data name cannot be used, please try again");
            }
            return false;
        }
        if (null != ExtDb.getExtDb(string, string2, errorLogger)) {
            if (null != errorLogger) {
                errorLogger.reportWarning("That station data name is already in use, please try again");
            }
            return false;
        }
        return true;
    }

    public static synchronized void reloadCache(String string) {
        if (null == ExtDb.updateCache(string, null)) {
            return;
        }
        HashSet<ExtDbListener> hashSet = listeners.get(string);
        if (null != hashSet) {
            for (ExtDbListener extDbListener : hashSet) {
                extDbListener.updateExtDbList();
            }
        }
    }

    private static HashMap<Integer, ExtDb> getCache(String string, ErrorLogger errorLogger) {
        HashMap<Integer, ExtDb> hashMap = null;
        Long l = cacheLastUpdate.get(string);
        if (null != l && System.currentTimeMillis() - l < 300000L) {
            hashMap = dbCache.get(string);
        }
        if (null == hashMap) {
            hashMap = ExtDb.updateCache(string, errorLogger);
        }
        return hashMap;
    }

    private static HashMap<Integer, ExtDb> updateCache(String string, ErrorLogger errorLogger) {
        HashMap<Integer, ExtDb> hashMap = dbCache.get(string);
        HashMap<Integer, ExtDb> hashMap2 = mrCache.get(string);
        if (null == hashMap) {
            hashMap = new HashMap();
            hashMap2 = new HashMap();
            dbCache.put(string, hashMap);
            mrCache.put(string, hashMap2);
        }
        String string2 = DbCore.getDbName(string);
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT ext_db_key, db_type, db_date, version, index_version, id, name, deleted, is_download, locked, bad_data FROM ext_db ORDER BY 1 DESC");
                String string3 = "";
                hashMap2.remove(10102);
                hashMap2.remove(10103);
                hashMap2.remove(10104);
                while (dbConnection.next()) {
                    Integer n = dbConnection.getInt(1);
                    ExtDb extDb = hashMap.get(n);
                    if (null == extDb) {
                        int n2 = dbConnection.getInt(2);
                        string3 = ExtDb.makeDbName(string2, n2, n);
                        extDb = new ExtDb(string, n, string3, dbConnection.getDate(3), n2, dbConnection.getInt(4), dbConnection.getInt(5), false);
                        hashMap.put(extDb.key, extDb);
                    }
                    extDb.id = dbConnection.getString(6);
                    if (null == extDb.id) {
                        extDb.id = "";
                    }
                    extDb.name = dbConnection.getString(7);
                    if (null == extDb.name) {
                        extDb.name = "";
                    }
                    extDb.deleted = dbConnection.getBoolean(8);
                    extDb.isDownload = dbConnection.getBoolean(9);
                    extDb.isLocked = dbConnection.getBoolean(10);
                    extDb.hasBadData = dbConnection.getBoolean(11);
                    if (extDb.deleted) {
                        extDb.description = extDb.getTypeName() + " " + extDb.id + " (deleted)";
                    } else if (!extDb.isSupported()) {
                        extDb.name = extDb.name + " (unsupported)";
                        extDb.description = extDb.getTypeName() + " " + extDb.id + " (unsupported)";
                    } else {
                        extDb.description = extDb.name.length() > 0 ? extDb.getTypeName() + " " + extDb.name : extDb.getTypeName() + " " + extDb.id;
                        if (extDb.hasBadData) {
                            extDb.description = extDb.description + " (bad)";
                        }
                    }
                    if (extDb.deleted || !extDb.isSupported() || extDb.hasBadData) continue;
                    switch (extDb.type) {
                        case 2: {
                            Integer n3 = 10102;
                            ExtDb extDb2 = hashMap2.get(n3);
                            if (null != extDb2 && !extDb.dbDate.after(extDb2.dbDate)) break;
                            hashMap2.put(n3, extDb);
                            break;
                        }
                        case 1: {
                            Integer n3 = 10103;
                            ExtDb extDb2 = hashMap2.get(n3);
                            if (null != extDb2 && !extDb.dbDate.after(extDb2.dbDate)) break;
                            hashMap2.put(n3, extDb);
                            break;
                        }
                        case 4: {
                            Integer n3 = 10104;
                            ExtDb extDb2 = hashMap2.get(n3);
                            if (null != extDb2 && !extDb.dbDate.after(extDb2.dbDate)) break;
                            hashMap2.put(n3, extDb);
                        }
                    }
                }
                DbCore.releaseDb(dbConnection);
                cacheLastUpdate.put(string, System.currentTimeMillis());
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                hashMap = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        } else {
            hashMap = null;
        }
        return hashMap;
    }

    private static ExtDb getLMSLiveExtDb(String string, ErrorLogger errorLogger) {
        ExtDb extDb = lmsLiveDbCache.get(string);
        if (null != extDb) {
            return extDb;
        }
        if (!lmsLiveDidTryOpen) {
            lmsLiveDidTryOpen = true;
            Properties properties = new Properties();
            try {
                properties.load(Files.newInputStream(AppCore.libDirectoryPath.resolve("api_login.props"), new OpenOption[0]));
            }
            catch (IOException iOException) {
                return null;
            }
            String string2 = properties.getProperty("lms_driver");
            String string3 = properties.getProperty("lms_host");
            lmsLiveDbName = properties.getProperty("lms_name");
            String string4 = properties.getProperty("lms_user");
            String string5 = properties.getProperty("lms_pass");
            if (null == string2 || null == string3 || null == lmsLiveDbName || null == string4 || null == string5) {
                return null;
            }
            DbConnection dbConnection = new DbConnection(string2, string3, string4, string5);
            if (dbConnection.connect(lmsLiveDbName)) {
                dbConnection.close();
                lmsLiveDb = dbConnection;
                lmsLiveDbPool = new ArrayDeque();
                lmsLiveDbPool.push(lmsLiveDb);
                lmsLiveOpenDbs = new HashSet();
            } else if (null != errorLogger) {
                errorLogger.reportError("Cannot open live LMS connection, properties may be invalid");
            }
        }
        if (null != lmsLiveDb) {
            extDb = new ExtDb(string, 10005, lmsLiveDbName, new Date(), 5, 11, 0, true);
            extDb.id = "";
            extDb.description = extDb.name = ExtDb.getReservedKeyName(10005);
            extDb.liveDb = lmsLiveDb;
            extDb.dbPool = lmsLiveDbPool;
            extDb.openDbs = lmsLiveOpenDbs;
            lmsLiveDbCache.put(string, extDb);
        }
        return extDb;
    }

    public static ArrayList<PatternID> findPatterns(String string, Integer n, String string2, boolean bl, int n2, ErrorLogger errorLogger) {
        Object object;
        Object object2;
        String string3;
        String string4;
        Object object3;
        ExtDb extDb = ExtDb.getExtDb(string, n, errorLogger);
        if (null == extDb) {
            return null;
        }
        String string5 = DbConnection.clean(string2.trim().toUpperCase().replace('*', '%'));
        if (0 == string5.length()) {
            return new ArrayList<PatternID>();
        }
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        StringBuilder stringBuilder = new StringBuilder();
        switch (extDb.type) {
            default: {
                if (null != errorLogger) {
                    errorLogger.reportError("Unknown or unsupported station data type");
                }
                return null;
            }
            case 1: 
            case 4: {
                object3 = "";
                string4 = "";
                string3 = "";
                object2 = "";
                object = "";
                if (bl) {
                    object3 = "elevation_antenna_id";
                    string4 = "field_value0";
                    string3 = "depression_angle * (field_value + field_value0)";
                    object2 = "elevation_ant_make";
                    object = "elevation_pattern";
                } else {
                    object3 = "antenna_id";
                    string4 = "field_value";
                    string3 = "azimuth * field_value";
                    object2 = "ant_make";
                    object = "ant_pattern";
                }
                stringBuilder.append("SELECT ");
                stringBuilder.append((String)object3);
                stringBuilder.append(", ant_make, ant_model_num, MAX(");
                stringBuilder.append(string4);
                stringBuilder.append("), SUM(");
                stringBuilder.append(string3);
                stringBuilder.append(") FROM ");
                stringBuilder.append((String)object2);
                stringBuilder.append(" JOIN ");
                stringBuilder.append((String)object);
                stringBuilder.append(" USING (");
                stringBuilder.append((String)object3);
                stringBuilder.append(") WHERE ");
                if (n3 > 0) {
                    stringBuilder.append("(");
                    stringBuilder.append((String)object3);
                    stringBuilder.append(" = ");
                    stringBuilder.append(String.valueOf(n3));
                    stringBuilder.append(") OR ");
                }
                stringBuilder.append("(UPPER(ant_make) LIKE '%");
                stringBuilder.append(string5);
                stringBuilder.append("%') OR (UPPER(ant_model_num) LIKE '%");
                stringBuilder.append(string5);
                stringBuilder.append("%') GROUP BY 1, 2, 3");
                break;
            }
            case 2: 
            case 5: {
                object3 = "";
                string4 = "";
                string3 = "";
                object2 = "";
                if (bl) {
                    object3 = "aaep_azimuth";
                    string4 = "aaep_depression_angle * aaep_field_value";
                    string3 = "app_antenna_elevation_pattern";
                    object2 = "aaep_antenna_record_id";
                } else {
                    object3 = "aafv_field_value";
                    string4 = "aafv_azimuth * aafv_field_value";
                    string3 = "app_antenna_field_value";
                    object2 = "aafv_aant_antenna_record_id";
                }
                stringBuilder.append("SELECT aant_antenna_record_id, aant_make, aant_model, MAX(");
                stringBuilder.append((String)object3);
                stringBuilder.append("), SUM(");
                stringBuilder.append(string4);
                stringBuilder.append(") FROM ");
                if (5 == extDb.type) {
                    stringBuilder.append("mass_media.");
                }
                stringBuilder.append("app_antenna JOIN ");
                if (5 == extDb.type) {
                    stringBuilder.append("mass_media.");
                }
                stringBuilder.append(string3);
                stringBuilder.append(" ON (");
                stringBuilder.append((String)object2);
                stringBuilder.append(" = aant_antenna_record_id) JOIN ");
                if (5 == extDb.type) {
                    stringBuilder.append("mass_media.");
                }
                stringBuilder.append("app_location ON (aloc_loc_record_id = aant_aloc_loc_record_id) JOIN ");
                if (5 == extDb.type) {
                    stringBuilder.append("common_schema.");
                }
                stringBuilder.append("license_filing_version ON (filing_version_id = aloc_aapp_application_id) WHERE ");
                stringBuilder.append("((CASE WHEN (purpose_code = 'AMD') THEN original_purpose_code ELSE purpose_code END) ");
                stringBuilder.append("IN ('CP','L2C','MOD','RUL','STA')) AND (current_status_code <> 'SAV') AND ");
                stringBuilder.append("(service_code IN ");
                ExtDbRecord.addServiceCodeList(extDb.type, n2, stringBuilder);
                stringBuilder.append(") AND (");
                if (n3 > 0) {
                    stringBuilder.append("(aant_antenna_id = '");
                    stringBuilder.append(String.valueOf(n3));
                    stringBuilder.append("') OR ");
                }
                stringBuilder.append("(UPPER(aant_make) LIKE '%");
                stringBuilder.append(string5);
                stringBuilder.append("%') OR (UPPER(aant_model) LIKE '%");
                stringBuilder.append(string5);
                stringBuilder.append("%')) GROUP BY 1, 2, 3");
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                object3 = "horizontal_pattern_name";
                if (bl) {
                    object3 = "(CASE WHEN has_matrix_pattern THEN matrix_pattern_name ELSE vertical_pattern_name END)";
                }
                stringBuilder.append("SELECT source_key, '', ");
                stringBuilder.append((String)object3);
                if (bl) {
                    stringBuilder.append(", (CASE WHEN has_matrix_pattern THEN 1. ELSE 0. END), ");
                    stringBuilder.append("SUM(CASE WHEN has_matrix_pattern THEN ");
                    stringBuilder.append("(source_matrix_pattern.depression_angle * ");
                    stringBuilder.append("source_matrix_pattern.relative_field) ELSE ");
                    stringBuilder.append("(source_vertical_pattern.depression_angle * ");
                    stringBuilder.append("source_vertical_pattern.relative_field) END)");
                } else {
                    stringBuilder.append(", 0., SUM(azimuth * relative_field)");
                }
                stringBuilder.append(" FROM source ");
                if (bl) {
                    stringBuilder.append("LEFT JOIN source_vertical_pattern USING (source_key) ");
                    stringBuilder.append("LEFT JOIN source_matrix_pattern USING (source_key) ");
                } else {
                    stringBuilder.append("JOIN source_horizontal_pattern USING (source_key) ");
                }
                stringBuilder.append("WHERE ");
                if (n2 > 0) {
                    stringBuilder.append("(record_type = ");
                    stringBuilder.append(String.valueOf(n2));
                    stringBuilder.append(") AND ");
                }
                if (bl) {
                    stringBuilder.append("(has_matrix_pattern OR has_vertical_pattern) AND (");
                } else {
                    stringBuilder.append("has_horizontal_pattern AND (");
                }
                if (n3 > 0) {
                    stringBuilder.append("(source_key = ");
                    stringBuilder.append(string5);
                    stringBuilder.append(") OR ");
                }
                stringBuilder.append("(UPPER(");
                stringBuilder.append((String)object3);
                stringBuilder.append(") LIKE '%");
                stringBuilder.append(string5);
                stringBuilder.append("%')) GROUP BY 1, 2, 3");
                break;
            }
        }
        object3 = new TreeMap();
        object = extDb.connectDb(errorLogger);
        if (null != object) {
            try {
                ((DbConnection)object).query(stringBuilder.toString());
                while (((DbConnection)object).next()) {
                    string4 = ((DbConnection)object).getString(2);
                    string4 = string4.length() > 0 ? string4 + "-" + ((DbConnection)object).getString(3) : ((DbConnection)object).getString(3);
                    string3 = string4 + "-" + ((DbConnection)object).getString(5);
                    if (((TreeMap)object3).containsKey(string3)) continue;
                    object2 = new PatternID();
                    ((PatternID)object2).extDb = extDb;
                    ((PatternID)object2).antennaRecordID = ((DbConnection)object).getString(1);
                    ((PatternID)object2).name = string4;
                    if (bl) {
                        ((PatternID)object2).type = 2;
                        ((PatternID)object2).isMatrix = ((DbConnection)object).getDouble(4) > 0.0;
                    } else {
                        ((PatternID)object2).type = 1;
                    }
                    ((TreeMap)object3).put(string3, object2);
                }
                extDb.releaseDb((DbConnection)object);
            }
            catch (SQLException sQLException) {
                extDb.releaseDb((DbConnection)object);
                DbConnection.reportError(errorLogger, sQLException);
                return null;
            }
        } else {
            return null;
        }
        return new ArrayList<PatternID>(((TreeMap)object3).values());
    }

    public static AntPattern getPattern(PatternID patternID, ErrorLogger errorLogger) {
        if (patternID.isMatrix) {
            return ExtDb.getMatrixPattern(null, patternID.extDb, patternID.antennaRecordID, patternID.name, errorLogger);
        }
        if (2 == patternID.type) {
            return ExtDb.getVerticalPattern(null, patternID.extDb, patternID.antennaRecordID, "", patternID.name, errorLogger);
        }
        return ExtDb.getHorizontalPattern(null, patternID.extDb, patternID.antennaRecordID, patternID.name, errorLogger);
    }

    public static AntPattern getHorizontalPattern(ExtDbRecord extDbRecord, String string, ErrorLogger errorLogger) {
        return ExtDb.getHorizontalPattern(extDbRecord, extDbRecord.extDb, extDbRecord.antennaRecordID, string, errorLogger);
    }

    private static AntPattern getHorizontalPattern(ExtDbRecord extDbRecord, ExtDb extDb, String string, String string2, ErrorLogger errorLogger) {
        String string3 = "";
        switch (extDb.type) {
            case 1: 
            case 4: {
                string3 = "SELECT azimuth, field_value FROM ant_pattern WHERE antenna_id = " + string + " ORDER BY 1";
                break;
            }
            case 2: {
                if (null != extDbRecord && 1 == extDbRecord.recordType && ((ExtDbRecordTV)extDbRecord).isBaseline && !((ExtDbRecordTV)extDbRecord).service.isDTS) {
                    string3 = "SELECT lkp_antenna_field_value.rafv_azimuth, lkp_antenna_field_value.rafv_field_value FROM lkp_antenna JOIN lkp_antenna_field_value ON (lkp_antenna_field_value.rafv_antenna_record_id = lkp_antenna.rant_antenna_record_id) WHERE lkp_antenna.rant_antenna_id = '" + string + "' ORDER BY 1";
                    break;
                }
                string3 = "SELECT aafv_azimuth, aafv_field_value FROM app_antenna_field_value WHERE aafv_aant_antenna_record_id = '" + string + "' ORDER BY 1";
                break;
            }
            case 5: {
                if (null != extDbRecord && 1 == extDbRecord.recordType && ((ExtDbRecordTV)extDbRecord).isBaseline && !((ExtDbRecordTV)extDbRecord).service.isDTS) {
                    string3 = "SELECT (CASE WHEN TRIM(lkp_antenna_field_value.rafv_azimuth) IN ('','null') THEN 0::FLOAT ELSE lkp_antenna_field_value.rafv_azimuth::FLOAT END), (CASE WHEN TRIM(lkp_antenna_field_value.rafv_field_value) IN ('','null') THEN 0::FLOAT  ELSE lkp_antenna_field_value.rafv_field_value::FLOAT END) FROM mass_media.lkp_antenna JOIN mass_media.lkp_antenna_field_value ON (lkp_antenna_field_value.rafv_antenna_record_id = lkp_antenna.rant_antenna_record_id) WHERE lkp_antenna.rant_antenna_id = '" + string + "' ORDER BY 1";
                    break;
                }
                string3 = "SELECT (CASE WHEN TRIM(aafv_azimuth) IN ('','null') THEN 0::FLOAT ELSE aafv_azimuth::FLOAT END), (CASE WHEN TRIM(aafv_field_value) IN ('','null') THEN 0::FLOAT ELSE aafv_field_value::FLOAT END) FROM mass_media.app_antenna_field_value WHERE aafv_aant_antenna_record_id = '" + string + "' ORDER BY 1";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string3 = "SELECT azimuth, relative_field FROM source_horizontal_pattern WHERE source_key = " + string + " ORDER BY 1";
                break;
            }
            default: {
                return null;
            }
        }
        ArrayList<AntPattern.AntPoint> arrayList = new ArrayList<AntPattern.AntPoint>();
        boolean bl = false;
        String string4 = null;
        double d = 0.001;
        DbConnection dbConnection = extDb.connectDb(errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.query(string3);
                double d2 = -1.0;
                while (dbConnection.next()) {
                    double d3 = Math.rint(dbConnection.getDouble(1) * 1000.0) / 1000.0;
                    if (d3 < 0.0 || d3 > 359.999) {
                        bl = true;
                        string4 = "azimuth out of range";
                        break;
                    }
                    if (d3 <= d2) {
                        bl = true;
                        string4 = "duplicate azimuths";
                        break;
                    }
                    d2 = d3;
                    double d4 = Math.rint(dbConnection.getDouble(2) * 1000.0) / 1000.0;
                    if (d4 < 0.001) {
                        d4 = 0.001;
                    }
                    if (d4 > 1.0) {
                        bl = true;
                        string4 = "relative field out of range";
                        break;
                    }
                    if (d4 > d) {
                        d = d4;
                    }
                    arrayList.add(new AntPattern.AntPoint(d3, d4));
                }
                if (!bl && arrayList.size() < 2) {
                    bl = true;
                    string4 = "not enough points";
                }
                if (!bl && d < 0.5) {
                    bl = true;
                    string4 = "max value is too small";
                }
                extDb.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                extDb.releaseDb(dbConnection);
                DbConnection.reportError(errorLogger, sQLException);
                return null;
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (bl) {
            if (null != errorLogger) {
                String string5 = "Pattern for antenna record ID " + string + " is bad, " + string4;
                if (null != extDbRecord) {
                    errorLogger.logMessage(ExtDbRecord.makeMessage(extDbRecord, string5));
                } else {
                    errorLogger.reportError(string5);
                }
            }
            return null;
        }
        if (null != errorLogger && d < 0.977) {
            String string6 = "Pattern for antenna record ID " + string + " does not have a 1";
            if (null != extDbRecord) {
                string6 = ExtDbRecord.makeMessage(extDbRecord, string6);
            }
            errorLogger.logMessage(string6);
        }
        return new AntPattern(extDb.dbID, 1, string2, arrayList);
    }

    public static AntPattern getVerticalPattern(ExtDbRecord extDbRecord, String string, ErrorLogger errorLogger) {
        return ExtDb.getVerticalPattern(extDbRecord, extDbRecord.extDb, extDbRecord.elevationAntennaRecordID, "", string, errorLogger);
    }

    private static AntPattern getVerticalPattern(ExtDbRecord extDbRecord, ExtDb extDb, String string, String string2, String string3, ErrorLogger errorLogger) {
        String string4 = "";
        boolean bl = false;
        switch (extDb.type) {
            case 1: 
            case 4: {
                string4 = "SELECT depression_angle,field_value" + string2 + " FROM elevation_pattern WHERE elevation_antenna_id = " + string + " ORDER BY 1";
                bl = true;
                break;
            }
            case 2: {
                string4 = "SELECT aaep_depression_angle,aaep_field_value FROM app_antenna_elevation_pattern WHERE (aaep_antenna_record_id = '" + string + "') AND (aaep_azimuth = 0.) ORDER BY 1";
                break;
            }
            case 5: {
                string4 = "SELECT aaep_depression_angle,aaep_field_value FROM mass_media.app_antenna_elevation_pattern WHERE (aaep_antenna_record_id = '" + string + "') AND ((aaep_azimuth = 0.) OR (aaep_azimuth IS NULL)) ORDER BY 1";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string4 = "SELECT depression_angle, relative_field FROM source_vertical_pattern WHERE source_key = " + string + " ORDER BY 1";
                break;
            }
            default: {
                return null;
            }
        }
        ArrayList<AntPattern.AntPoint> arrayList = new ArrayList<AntPattern.AntPoint>();
        boolean bl2 = false;
        boolean bl3 = true;
        String string5 = null;
        double d = 0.001;
        DbConnection dbConnection = extDb.connectDb(errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.query(string4);
                double d2 = -91.0;
                while (dbConnection.next()) {
                    double d3 = Math.rint(dbConnection.getDouble(1) * 1000.0) / 1000.0;
                    if (d3 < -90.0 || d3 > 90.0) {
                        bl2 = true;
                        string5 = "vertical angle out of range";
                        break;
                    }
                    if (d3 <= d2) {
                        bl2 = true;
                        string5 = "duplicate vertical angles";
                        break;
                    }
                    d2 = d3;
                    double d4 = Math.rint(dbConnection.getDouble(2) * 1000.0) / 1000.0;
                    if (d4 < 0.001) {
                        d4 = 0.001;
                    } else {
                        bl3 = false;
                    }
                    if (d4 > 1.0) {
                        bl2 = true;
                        string5 = "relative field out of range";
                        break;
                    }
                    if (d4 > d) {
                        d = d4;
                    }
                    arrayList.add(new AntPattern.AntPoint(d3, d4));
                }
                if (!bl2 && arrayList.size() < 2) {
                    bl2 = true;
                    string5 = "not enough points";
                }
                extDb.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                extDb.releaseDb(dbConnection);
                DbConnection.reportError(errorLogger, sQLException);
                return null;
            }
        }
        if (arrayList.isEmpty() || bl3) {
            if (bl) {
                bl2 = true;
                string5 = "pattern data not found";
            } else {
                return null;
            }
        }
        if (bl2) {
            if (null != errorLogger) {
                String string6 = "Pattern for elevation antenna record ID " + string + " is bad, " + string5;
                if (null != extDbRecord) {
                    errorLogger.logMessage(ExtDbRecord.makeMessage(extDbRecord, string6));
                } else {
                    errorLogger.reportError(string6);
                }
            }
            return null;
        }
        if (null != errorLogger && string2.equals("") && d < 0.977) {
            String string7 = "Pattern for elevation antenna record ID " + string + " does not have a 1";
            if (null != extDbRecord) {
                string7 = ExtDbRecord.makeMessage(extDbRecord, string7);
            }
            errorLogger.logMessage(string7);
        }
        return new AntPattern(extDb.dbID, 2, string3, arrayList);
    }

    public static AntPattern getMatrixPattern(ExtDbRecord extDbRecord, String string, ErrorLogger errorLogger) {
        return ExtDb.getMatrixPattern(extDbRecord, extDbRecord.extDb, extDbRecord.elevationAntennaRecordID, string, errorLogger);
    }

    /*
     * WARNING - void declaration
     */
    private static AntPattern getMatrixPattern(ExtDbRecord extDbRecord, ExtDb extDb, String string, String string2, ErrorLogger errorLogger) {
        ArrayList<AntPattern.AntPoint> arrayList;
        ArrayList<AntPattern.AntSlice> arrayList2 = new ArrayList<AntPattern.AntSlice>();
        AntPattern antPattern = null;
        AntPattern.AntSlice antSlice = null;
        double d = 0.001;
        if (1 == extDb.type || 4 == extDb.type) {
            for (int i = 0; i < 360; i += 10) {
                antPattern = ExtDb.getVerticalPattern(null, extDb, string, String.valueOf(i), "", errorLogger);
                if (null == antPattern) {
                    return null;
                }
                antSlice = new AntPattern.AntSlice(i, antPattern.getPoints());
                arrayList2.add(antSlice);
                for (AntPattern.AntPoint object2 : antSlice.points) {
                    if (!(object2.relativeField > d)) continue;
                    d = object2.relativeField;
                }
            }
        }
        String string3 = "";
        switch (extDb.type) {
            case 1: 
            case 4: {
                string3 = "SELECT azimuth,depression_angle,field_value FROM elevation_pattern_addl WHERE elevation_antenna_id = " + string + " ORDER BY 1, 2";
                break;
            }
            case 2: {
                string3 = "SELECT aaep_azimuth,aaep_depression_angle,aaep_field_value FROM app_antenna_elevation_pattern WHERE aaep_antenna_record_id = '" + string + "' ORDER BY 1, 2";
                break;
            }
            case 5: {
                string3 = "SELECT aaep_azimuth,aaep_depression_angle,aaep_field_value FROM mass_media.app_antenna_elevation_pattern WHERE aaep_antenna_record_id = '" + string + "' ORDER BY 1, 2";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string3 = "SELECT azimuth, depression_angle, relative_field FROM source_matrix_pattern WHERE source_key = " + string + " ORDER BY 1, 2";
                break;
            }
            default: {
                return null;
            }
        }
        boolean bl = false;
        Object var12_14 = null;
        DbConnection dbConnection = extDb.connectDb(errorLogger);
        if (null != dbConnection) {
            try {
                dbConnection.query(string3);
                arrayList = null;
                double d2 = -1.0;
                double d3 = -91.0;
                boolean bl2 = false;
                while (dbConnection.next()) {
                    double d4;
                    int n;
                    double d5 = Math.rint(dbConnection.getDouble(1) * 1000.0) / 1000.0;
                    if (d5 < 0.0 || d5 > 359.999) {
                        bl = true;
                        String string4 = "azimuth out of range";
                        break;
                    }
                    if (d5 != d2) {
                        if (bl2 && arrayList.size() < 2) {
                            bl = true;
                            String string5 = "not enough points, at azimuth " + antSlice.value;
                            break;
                        }
                        bl2 = true;
                        for (n = 0; n < arrayList2.size(); ++n) {
                            antSlice = arrayList2.get(n);
                            if (d5 == antSlice.value) {
                                bl2 = false;
                                break;
                            }
                            if (d5 < antSlice.value) break;
                        }
                        if (bl2) {
                            antSlice = new AntPattern.AntSlice(d5);
                            arrayList2.add(n, antSlice);
                        }
                        arrayList = antSlice.points;
                        d2 = d5;
                        d3 = -91.0;
                    }
                    if ((d4 = Math.rint(dbConnection.getDouble(2) * 1000.0) / 1000.0) < -90.0 || d4 > 90.0) {
                        bl = true;
                        String string6 = "vertical angle out of range, at azimuth " + antSlice.value;
                        break;
                    }
                    if (d4 <= d3) {
                        bl = true;
                        String string7 = "duplicate vertical angles, at azimuth " + antSlice.value;
                        break;
                    }
                    d3 = d4;
                    double d6 = Math.rint(dbConnection.getDouble(3) * 1000.0) / 1000.0;
                    if (d6 < 0.001) {
                        d6 = 0.001;
                    }
                    if (d6 > 1.0) {
                        bl = true;
                        String string8 = "field value greater than 1, at azimuth " + antSlice.value;
                        break;
                    }
                    if (d6 > d) {
                        d = d6;
                    }
                    AntPattern.AntPoint antPoint = new AntPattern.AntPoint(d4, d6);
                    if (bl2) {
                        arrayList.add(antPoint);
                        continue;
                    }
                    for (n = 0; n < arrayList.size(); ++n) {
                        AntPattern.AntPoint antPoint2 = arrayList.get(n);
                        if (d4 == antPoint2.angle) {
                            bl = true;
                            String string9 = "duplicate vertical angles, at azimuth " + antSlice.value;
                            break;
                        }
                        if (d4 < antPoint2.angle) break;
                    }
                    if (bl) break;
                    arrayList.add(n, antPoint);
                }
                if (!bl && bl2 && arrayList.size() < 2) {
                    bl = true;
                    String string10 = "not enough points, at azimuth " + antSlice.value;
                }
                if (!bl && d < 0.5) {
                    bl = true;
                    String string11 = "max value is too small";
                }
                extDb.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                extDb.releaseDb(dbConnection);
                DbConnection.reportError(errorLogger, sQLException);
                return null;
            }
        }
        if (arrayList2.isEmpty()) {
            return null;
        }
        if (bl) {
            if (null != errorLogger) {
                void var12_26;
                arrayList = "Pattern for elevation antenna record ID " + string + " is bad, " + (String)var12_26;
                if (null != extDbRecord) {
                    errorLogger.logMessage(ExtDbRecord.makeMessage(extDbRecord, (String)((Object)arrayList)));
                } else {
                    errorLogger.reportError((String)((Object)arrayList));
                }
            }
            return null;
        }
        if (null != errorLogger && d < 0.977) {
            arrayList = "Pattern for elevation antenna record ID " + string + " does not have a 1";
            if (null != extDbRecord) {
                arrayList = ExtDbRecord.makeMessage(extDbRecord, (String)((Object)arrayList));
            }
            errorLogger.logMessage((String)((Object)arrayList));
        }
        return new AntPattern(extDb.dbID, string2, 2, arrayList2);
    }

    public static void checkForAMStations(ExtDb extDb, GeoPoint geoPoint, ArrayList<GeoPoint> arrayList, double d, double d2, double d3, StringBuilder stringBuilder) {
        boolean bl = false;
        DbConnection dbConnection = extDb.connectDb();
        if (null == dbConnection) {
            bl = true;
        } else {
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            GeoPoint geoPoint2 = new GeoPoint();
            boolean bl2 = false;
            boolean bl3 = false;
            try {
                switch (extDb.type) {
                    case 1: {
                        dbConnection.query("SELECT am_ant_sys.lat_dir,am_ant_sys.lat_deg,am_ant_sys.lat_min,am_ant_sys.lat_sec,am_ant_sys.lon_dir,am_ant_sys.lon_deg,am_ant_sys.lon_min,am_ant_sys.lon_sec,facility.fac_callsign, application.fac_frequency, am_ant_sys.am_dom_status,am_ant_sys.ant_mode,am_ant_sys.hours_operation,facility.comm_city, facility.comm_state, CONCAT(application.file_prefix, application.app_arn) FROM am_ant_sys JOIN application USING (application_id) JOIN facility USING (facility_id) WHERE (am_ant_sys.eng_record_type NOT IN ('P','A','R')) ORDER BY 15, 14, 9, 16");
                        break;
                    }
                    case 2: {
                        if (extDb.version > 9) {
                            dbConnection.query("SELECT DISTINCT app_am_antenna.lat_dir,app_am_antenna.lat_deg,app_am_antenna.lat_min,app_am_antenna.lat_sec,app_am_antenna.long_dir,app_am_antenna.long_deg,app_am_antenna.long_min,app_am_antenna.long_sec,facility.callsign,application_facility.am_frequency,(CASE WHEN (license_filing_version.purpose_code = 'AMD') THEN license_filing_version.original_purpose_code ELSE license_filing_version.purpose_code END),app_am_antenna.dir_ind,app_am_antenna.am_ant_mode_code,(CASE WHEN (facility.community_served_city <> '') THEN facility.community_served_city ELSE application_facility.afac_community_city END),(CASE WHEN (facility.community_served_state <> '') THEN facility.community_served_state ELSE application_facility.afac_community_state_code END),application.aapp_file_num FROM app_am_antenna JOIN license_filing_version ON (license_filing_version.filing_version_id = app_am_antenna.aapp_application_id) JOIN application_facility ON (application_facility.afac_application_id = app_am_antenna.aapp_application_id) JOIN facility ON (facility.facility_id = application_facility.afac_facility_id) JOIN application ON (application.aapp_application_id = app_am_antenna.aapp_application_id) WHERE (license_filing_version.active_ind = 'Y') AND ((CASE WHEN (license_filing_version.purpose_code = 'AMD') THEN license_filing_version.original_purpose_code ELSE license_filing_version.purpose_code END) IN ('CP','L2C','MOD','STA')) AND (license_filing_version.current_status_code <> 'SAV') AND (license_filing_version.service_code = 'AM') AND (application_facility.country_code = 'US')ORDER BY 15, 14, 9, 16");
                            break;
                        }
                        dbConnection.query("SELECT gis_am_ant_sys.lat_dir,gis_am_ant_sys.lat_deg,gis_am_ant_sys.lat_min,gis_am_ant_sys.lat_sec,gis_am_ant_sys.lon_dir,gis_am_ant_sys.lon_deg,gis_am_ant_sys.lon_min,gis_am_ant_sys.lon_sec,gis_facility.fac_callsign,gis_application.fac_frequency,gis_am_ant_sys.am_dom_status,gis_am_ant_sys.ant_mode,gis_am_ant_sys.hours_operation,gis_facility.comm_city,gis_facility.comm_state,CONCAT(gis_application.file_prefix, gis_application.app_arn) FROM gis_am_ant_sys JOIN gis_application USING (application_id) JOIN gis_facility USING (facility_id) WHERE (gis_am_ant_sys.eng_record_type NOT IN ('P','A','R')) ORDER BY 15, 14, 9, 16");
                        break;
                    }
                    case 5: {
                        dbConnection.query("SELECT app_am_antenna.lat_dir,(CASE WHEN TRIM(app_am_antenna.lat_deg) IN ('','null') THEN 0::FLOAT ELSE app_am_antenna.lat_deg::FLOAT END), (CASE WHEN TRIM(app_am_antenna.lat_min) IN ('','null') THEN 0::FLOAT ELSE app_am_antenna.lat_min::FLOAT END), (CASE WHEN TRIM(app_am_antenna.lat_sec) IN ('','null') THEN 0::FLOAT ELSE app_am_antenna.lat_sec::FLOAT END), app_am_antenna.long_dir,(CASE WHEN TRIM(app_am_antenna.long_deg) IN ('','null') THEN 0::FLOAT ELSE app_am_antenna.long_deg::FLOAT END), (CASE WHEN TRIM(app_am_antenna.long_min) IN ('','null') THEN 0::FLOAT ELSE app_am_antenna.long_min::FLOAT END), (CASE WHEN TRIM(app_am_antenna.long_sec) IN ('','null') THEN 0::FLOAT ELSE app_am_antenna.long_sec::FLOAT END), facility.callsign,application_facility.am_frequency,(CASE WHEN (license_filing_version.purpose_code = 'AMD') THEN license_filing_version.original_purpose_code ELSE license_filing_version.purpose_code END),app_am_antenna.dir_ind,app_am_antenna.am_ant_mode_code,(CASE WHEN (facility.community_served_city <> '') THEN facility.community_served_city ELSE application_facility.afac_community_city END),(CASE WHEN (facility.community_served_state <> '') THEN facility.community_served_state ELSE application_facility.afac_community_state_code END),application.aapp_file_num FROM mass_media.app_am_antenna JOIN common_schema.license_filing_version ON (license_filing_version.filing_version_id = app_am_antenna.aapp_application_id) JOIN common_schema.application_facility ON (application_facility.afac_application_id = app_am_antenna.aapp_application_id) JOIN common_schema.facility ON (facility.facility_id = application_facility.afac_facility_id) JOIN common_schema.application ON (application.aapp_application_id = app_am_antenna.aapp_application_id) WHERE (license_filing_version.active_ind = 'Y') AND ((CASE WHEN (license_filing_version.purpose_code = 'AMD') THEN license_filing_version.original_purpose_code ELSE license_filing_version.purpose_code END) IN ('CP','L2C','MOD','STA')) AND (license_filing_version.current_status_code <> 'SAV') AND (license_filing_version.service_code = 'AM') AND (application_facility.country_code = 'US')ORDER BY 15, 14, 9, 16");
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                if (!bl) {
                    while (dbConnection.next()) {
                        double d4;
                        String string;
                        String string2;
                        String string3;
                        String string4;
                        String string5;
                        String string6;
                        String string7;
                        geoPoint2.latitudeNS = 0;
                        String string8 = dbConnection.getString(1);
                        if (null != string8 && string8.equalsIgnoreCase("S")) {
                            geoPoint2.latitudeNS = 1;
                        }
                        geoPoint2.latitudeDegrees = dbConnection.getInt(2);
                        geoPoint2.latitudeMinutes = dbConnection.getInt(3);
                        geoPoint2.latitudeSeconds = dbConnection.getDouble(4);
                        geoPoint2.longitudeWE = 0;
                        string8 = dbConnection.getString(5);
                        if (null != string8 && string8.equalsIgnoreCase("E")) {
                            geoPoint2.longitudeWE = 1;
                        }
                        geoPoint2.longitudeDegrees = dbConnection.getInt(6);
                        geoPoint2.longitudeMinutes = dbConnection.getInt(7);
                        geoPoint2.longitudeSeconds = dbConnection.getDouble(8);
                        geoPoint2.updateLatLon();
                        if (0.0 == geoPoint2.latitude || 0.0 == geoPoint2.longitude) continue;
                        if (1 == extDb.type || extDb.version < 10) {
                            geoPoint2.convertFromNAD27();
                            geoPoint2.updateDMS();
                        }
                        if (null == (string7 = dbConnection.getString(9)) || null == (string6 = dbConnection.getString(10)) || null == (string5 = dbConnection.getString(11)) || null == (string4 = dbConnection.getString(12))) continue;
                        boolean bl4 = false;
                        bl4 = 1 == extDb.type || extDb.version < 10 ? string4.startsWith("DA") : string4.equals("Y");
                        String string9 = dbConnection.getString(13);
                        if (null == string9 || null == (string3 = dbConnection.getString(14)) || null == (string2 = dbConnection.getString(15)) || null == (string = dbConnection.getString(16))) continue;
                        if (null != arrayList && !arrayList.isEmpty()) {
                            d4 = 9999.0;
                            for (GeoPoint geoPoint3 : arrayList) {
                                double d5 = geoPoint3.distanceTo(geoPoint2, d3);
                                if (!(d5 < d4)) continue;
                                d4 = d5;
                            }
                        } else {
                            d4 = geoPoint.distanceTo(geoPoint2, d3);
                        }
                        if (bl4) {
                            if (!(d4 <= d2)) continue;
                            if (!bl3) {
                                stringBuilder3.append(String.format(Locale.US, "Directional AM stations within %.1f km:\n", d2));
                                bl3 = true;
                            }
                            stringBuilder3.append(string7 + " " + string6 + " " + string5 + " " + string9 + " " + string3 + ", " + string2 + " " + string + ", " + AppCore.formatDistance(d4) + " km\n");
                            continue;
                        }
                        if (!(d4 <= d)) continue;
                        if (!bl2) {
                            stringBuilder2.append(String.format(Locale.US, "Non-directional AM stations within %.1f km:\n", d));
                            bl2 = true;
                        }
                        stringBuilder2.append(string7 + " " + string6 + " " + string5 + " " + string9 + " " + string3 + ", " + string2 + " " + string + ", " + AppCore.formatDistance(d4) + " km\n");
                    }
                    if (bl2) {
                        stringBuilder2.append("\n");
                    } else {
                        stringBuilder2.append(String.format(Locale.US, "No non-directional AM stations found within %.1f km\n\n", d));
                    }
                    stringBuilder.append((CharSequence)stringBuilder2);
                    if (bl3) {
                        stringBuilder3.append("\n");
                    } else {
                        stringBuilder3.append(String.format(Locale.US, "No directional AM stations found within %.1f km\n\n", d2));
                    }
                    stringBuilder.append((CharSequence)stringBuilder3);
                }
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
                bl = true;
            }
            extDb.releaseDb(dbConnection);
        }
        if (bl) {
            stringBuilder.append("Data is not available for AM station check\n\n");
        }
    }

    public static Integer createNewGenericDatabase(String string, int n, String string2) {
        return ExtDb.createNewGenericDatabase(string, n, string2, null);
    }

    public static Integer createNewGenericDatabase(String string, int n, String string2, ErrorLogger errorLogger) {
        if (!ExtDb.isGeneric(n)) {
            if (null != errorLogger) {
                errorLogger.reportError("Cannot create station data, unknown or unsupported data type");
            }
            return null;
        }
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return null;
        }
        String string3 = null;
        String string4 = null;
        String string5 = DbCore.getDbName(string);
        boolean bl = false;
        int n2 = 0;
        try {
            dbConnection.update("LOCK TABLES ext_db_key_sequence WRITE");
            dbConnection.update("UPDATE ext_db_key_sequence SET ext_db_key = ext_db_key + 1");
            dbConnection.query("SELECT ext_db_key FROM ext_db_key_sequence");
            dbConnection.next();
            n2 = dbConnection.getInt(1);
            if (10000 == n2) {
                n2 = 20000;
                dbConnection.update("UPDATE ext_db_key_sequence SET ext_db_key = " + n2);
            }
            dbConnection.update("UNLOCK TABLES");
            string4 = ExtDb.makeDbName(string5, n, n2);
            dbConnection.update("CREATE DATABASE " + string4 + " CHARACTER SET latin1");
            Source.createTables(dbConnection, string4);
            String string6 = AppCore.formatDateTime(new Date());
            if (null == string2) {
                string2 = "";
            }
            dbConnection.setDatabase(string5);
            dbConnection.update("LOCK TABLES ext_db WRITE");
            dbConnection.query("SELECT ext_db_key FROM ext_db WHERE (id = '" + DbConnection.clean(string6) + "')");
            if (dbConnection.next()) {
                string6 = string6 + " " + String.valueOf('#') + String.valueOf(n2);
            }
            if (string2.length() > 0) {
                dbConnection.query("SELECT ext_db_key FROM ext_db WHERE (UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "')");
                if (dbConnection.next()) {
                    string2 = string2 + " " + String.valueOf('#') + String.valueOf(n2);
                }
            }
            dbConnection.update("INSERT INTO ext_db (ext_db_key, db_type, db_date, version, index_version, id, name, deleted, locked, is_download, bad_data) VALUES (" + n2 + ", " + n + ", NOW(), 0, 0, '" + DbConnection.clean(string6) + "', '" + DbConnection.clean(string2) + "', false, false, false, false)");
        }
        catch (SQLException sQLException) {
            string3 = "A database error occurred:\n" + sQLException;
            bl = true;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
            if (bl && null != string4) {
                dbConnection.update("DROP DATABASE IF EXISTS " + string4);
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string3 && null != errorLogger) {
            if (bl) {
                errorLogger.reportError(string3);
            } else {
                errorLogger.reportWarning(string3);
            }
        }
        if (bl) {
            return null;
        }
        ExtDb.reloadCache(string);
        return n2;
    }

    public static int importToGenericDatabase(ExtDb extDb, int n, File file, File file2, ErrorLogger errorLogger) {
        return ExtDb.importToGenericDatabase(extDb, n, file, file2, null, null, null);
    }

    public static int importToGenericDatabase(ExtDb extDb, int n, File file, File file2, Integer n2, Integer n3, ErrorLogger errorLogger) {
        if (!extDb.isGeneric()) {
            if (null != errorLogger) {
                errorLogger.reportError("Unknown or unsupported station data type");
            }
            return -1;
        }
        DbConnection dbConnection = extDb.connectAndLock(errorLogger);
        if (null == dbConnection) {
            return -1;
        }
        int n4 = 0;
        switch (n) {
            default: {
                if (null != errorLogger) {
                    errorLogger.reportError("Unknown import file type");
                }
                n4 = -1;
                break;
            }
            case 1: {
                try {
                    ArrayList<SourceEditData> arrayList = SourceEditData.readFromText(extDb, file, file2, errorLogger);
                    if (null == arrayList) {
                        n4 = -1;
                        break;
                    }
                    for (SourceEditData sourceEditData : arrayList) {
                        sourceEditData.isDataChanged();
                        sourceEditData.save(dbConnection);
                        ++n4;
                    }
                    break;
                }
                catch (SQLException sQLException) {
                    if (null == errorLogger) break;
                    DbConnection.reportError(errorLogger, sQLException);
                    break;
                }
                catch (Throwable throwable) {
                    AppCore.log(3, "Unexpected error", throwable);
                    if (null != errorLogger) {
                        errorLogger.reportError("An unexpected error occurred:\n" + throwable);
                    }
                    n4 = -1;
                    break;
                }
            }
            case 2: {
                File file3 = file;
                if (!file3.isDirectory()) {
                    file3 = file3.getParentFile();
                }
                try {
                    ArrayList<SourceEditData> arrayList;
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    int n5 = 0;
                    dbConnection.query("SELECT facility_id, call_sign FROM source");
                    while (dbConnection.next()) {
                        int n6 = dbConnection.getInt(1);
                        hashMap.put(dbConnection.getString(2), n6);
                        if (n6 <= n5) continue;
                        n5 = n6;
                    }
                    if (null == (arrayList = ExtDb.readFromDBF(extDb, file3, hashMap, ++n5, errorLogger))) {
                        n4 = -1;
                        break;
                    }
                    for (SourceEditData sourceEditData : arrayList) {
                        sourceEditData.isDataChanged();
                        sourceEditData.save(dbConnection);
                        ++n4;
                    }
                    break;
                }
                catch (SQLException sQLException) {
                    if (null == errorLogger) break;
                    DbConnection.reportError(errorLogger, sQLException);
                    break;
                }
                catch (Throwable throwable) {
                    AppCore.log(3, "Unexpected error", throwable);
                    if (null != errorLogger) {
                        errorLogger.reportError("An unexpected error occurred:\n" + throwable);
                    }
                    n4 = -1;
                    break;
                }
            }
        }
        extDb.releaseDb(dbConnection);
        return n4;
    }

    private static ArrayList<SourceEditData> readFromDBF(ExtDb extDb, File file, HashMap<String, Integer> hashMap, int n, ErrorLogger errorLogger) {
        Object object2;
        AntPattern antPattern;
        Integer n2;
        String string;
        String[] stringArray;
        int n3;
        if (6 != extDb.type && 8 != extDb.type) {
            if (null != errorLogger) {
                errorLogger.reportError("Unsupported import format for station data type");
            }
            return null;
        }
        AppCore.DBFData dBFData = AppCore.readDBFData(new File(file, "apatstat.dbf"), true, errorLogger);
        if (null == dBFData) {
            return null;
        }
        if (dBFData.fieldCount < 2) {
            if (null != errorLogger) {
                errorLogger.reportError("Bad field count in data file '" + dBFData.fileName + "'");
            }
            return null;
        }
        AppCore.DBFData dBFData2 = AppCore.readDBFData(new File(file, "apatdesc.dbf"), true, errorLogger);
        if (null == dBFData2) {
            return null;
        }
        if (dBFData2.fieldCount < 7) {
            if (null != errorLogger) {
                errorLogger.reportError("Bad field count in data file '" + dBFData2.fileName + "'");
            }
            return null;
        }
        AppCore.DBFData dBFData3 = AppCore.readDBFData(new File(file, "apatdat.dbf"), true, errorLogger);
        if (null == dBFData3) {
            return null;
        }
        if (dBFData3.fieldCount < 3) {
            if (null != errorLogger) {
                errorLogger.reportError("Bad field count in data file '" + dBFData3.fileName + "'");
            }
            return null;
        }
        File file2 = null;
        int n4 = 0;
        if (6 == extDb.type) {
            file2 = new File(file, "tvstatio.dbf");
            n4 = 41;
        } else {
            file2 = new File(file, "fmstatio.dbf");
            n4 = 37;
        }
        AppCore.DBFData dBFData4 = AppCore.readDBFData(file2, true, errorLogger);
        if (null == dBFData4) {
            return null;
        }
        if (dBFData4.fieldCount < n4) {
            if (null != errorLogger) {
                errorLogger.reportError("Bad field count in data file '" + dBFData4.fileName + "'");
            }
            return null;
        }
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>();
        for (n3 = 0; n3 < dBFData.fieldData.size(); ++n3) {
            stringArray = dBFData.fieldData.get(n3);
            string = stringArray[0].substring(0, 12).trim().toUpperCase() + "-" + stringArray[0].substring(12).toUpperCase();
            try {
                hashMap2.put(Integer.valueOf(stringArray[1]), string);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        HashMap<Integer, AntPattern> hashMap3 = new HashMap<Integer, AntPattern>();
        for (n3 = 0; n3 < dBFData2.fieldData.size(); ++n3) {
            stringArray = dBFData2.fieldData.get(n3);
            try {
                n2 = Integer.valueOf(stringArray[0]);
                string = (String)hashMap2.get(n2);
                if (null == string) continue;
                antPattern = stringArray[1].equalsIgnoreCase("V") ? new AntPattern(extDb.dbID, 2, string) : new AntPattern(extDb.dbID, 1, string);
                hashMap3.put(n2, antPattern);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Integer n5 = null;
        double d = 999.0;
        int n6 = 0;
        antPattern = null;
        ArrayList<AntPattern.AntPoint> arrayList = null;
        for (n3 = 0; n3 < dBFData3.fieldData.size(); ++n3) {
            stringArray = dBFData3.fieldData.get(n3);
            n2 = null;
            try {
                int n7;
                n2 = Integer.valueOf(stringArray[0]);
                if (!n2.equals(n5)) {
                    antPattern = (AntPattern)hashMap3.get(n2);
                    arrayList = null != antPattern ? antPattern.getPoints() : null;
                    n5 = n2;
                    d = 999.0;
                }
                if (null == antPattern) continue;
                double d2 = Double.parseDouble(stringArray[1]);
                double d3 = Math.pow(10.0, Double.parseDouble(stringArray[2]) / 20.0);
                if (d3 < 0.001) {
                    d3 = 0.001;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                AntPattern.AntPoint antPoint = new AntPattern.AntPoint(d2, d3);
                if (d2 > d) {
                    arrayList.add(antPoint);
                    d = d2;
                    continue;
                }
                for (n7 = 0; n7 < arrayList.size() && !(d2 > arrayList.get((int)n7).angle); ++n7) {
                }
                if (n7 == arrayList.size()) {
                    d = d2;
                }
                arrayList.add(n7, antPoint);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (null != n2) {
                    hashMap3.remove(n2);
                    antPattern = null;
                    arrayList = null;
                }
                ++n6;
            }
        }
        HashMap<String, AntPattern> hashMap4 = new HashMap<String, AntPattern>();
        HashMap<String, AntPattern> hashMap5 = new HashMap<String, AntPattern>();
        for (Object object2 : hashMap3.values()) {
            if (((AntPattern)object2).isDataValid()) {
                if (1 == ((AntPattern)object2).type) {
                    hashMap4.put(((AntPattern)object2).name, (AntPattern)object2);
                    continue;
                }
                hashMap5.put(((AntPattern)object2).name, (AntPattern)object2);
                continue;
            }
            ++n6;
        }
        ArrayList arrayList2 = new ArrayList();
        object2 = null;
        SourceEditDataTV sourceEditDataTV = null;
        SourceEditDataFM sourceEditDataFM = null;
        int n8 = 0;
        String string2 = AppCore.formatDate(new Date());
        for (n3 = 0; n3 < dBFData4.fieldData.size(); ++n3) {
            stringArray = dBFData4.fieldData.get(n3);
            try {
                Service service;
                int n9;
                string = stringArray[2].toUpperCase() + "-" + stringArray[7].toUpperCase();
                String string3 = stringArray[2];
                Integer n10 = hashMap.get(string3);
                if (null == n10) {
                    n10 = n++;
                    hashMap.put(string3, n10);
                }
                String string4 = stringArray[7].toUpperCase();
                String string5 = stringArray[4].toUpperCase();
                String string6 = stringArray[0].toUpperCase();
                Country country = string6.equals("AB") || string6.equals("BC") || string6.equals("MB") || string6.equals("NB") || string6.equals("NF") || string6.equals("NS") || string6.equals("NT") || string6.equals("NU") || string6.equals("ON") || string6.equals("PE") || string6.equals("QC") || string6.equals("SK") || string6.equals("YT") ? Country.getCountry(2) : Country.getCountry(1);
                int n11 = 4;
                if (string4.equals("IC") || string4.equals("PC") || string4.equals("RE") || string4.equals("TP") || string4.equals("UC") || string4.equals("UN") || string4.equals("UX")) {
                    n11 = 3;
                } else if (string4.equals("AP") || string4.equals("AU") || string4.equals("CP")) {
                    n11 = 1;
                } else if (string4.equals("AX") || string4.equals("OP")) {
                    n11 = 2;
                } else if (string4.equals("TO")) {
                    n11 = 0;
                }
                String string7 = 4 != n11 ? ExtDbRecord.STATUS_CODES[n11] : string4;
                if (6 == extDb.type) {
                    n9 = Integer.parseInt(stringArray[40]);
                    if (n9 > 69) continue;
                    service = 0 == Integer.parseInt(stringArray[36]) ? (string4.equals("AX") || string4.equals("UX") ? Service.getService("TS") : (string5.equals("LP") || string5.equals("VLP") ? Service.getService("TX") : (string5.equals("A") ? Service.getService("CA") : Service.getService("TV")))) : (string4.equals("AX") || string4.equals("UX") ? Service.getService("DX") : (string5.equals("LP") || string5.equals("VLP") ? Service.getService("LD") : (string5.equals("A") ? Service.getService("DC") : Service.getService("DT"))));
                    sourceEditDataTV = SourceEditDataTV.createExtSource(extDb, n10, service, false, country, errorLogger);
                    if (null == sourceEditDataTV) {
                        return null;
                    }
                    object2 = sourceEditDataTV;
                    sourceEditDataTV.appARN = "CANADA" + n10 + "-" + string4;
                    sourceEditDataTV.fileNumber = "BLANK" + sourceEditDataTV.appARN;
                    sourceEditDataTV.channel = n9;
                    sourceEditDataTV.status = string7;
                    sourceEditDataTV.statusType = n11;
                    sourceEditDataTV.frequencyOffset = FrequencyOffset.getFrequencyOffset(stringArray[12]);
                    sourceEditDataTV.emissionMask = EmissionMask.getDefaultObject();
                    sourceEditDataTV.heightAMSL = stringArray[39].length() > 0 ? Double.parseDouble(stringArray[39]) : -999.0;
                    if (stringArray[30].length() > 0) {
                        sourceEditDataTV.overallHAAT = Double.parseDouble(stringArray[30]);
                        if (sourceEditDataTV.overallHAAT < -1100.0) {
                            sourceEditDataTV.overallHAAT = -999.0;
                        }
                    } else {
                        sourceEditDataTV.overallHAAT = -999.0;
                    }
                    sourceEditDataTV.peakERP = stringArray[32].length() > 0 ? Double.parseDouble(stringArray[32]) / 1000.0 : 0.001;
                    if (stringArray[29].length() > 0) {
                        sourceEditDataTV.verticalPatternElectricalTilt = Double.parseDouble(stringArray[29]);
                    }
                } else {
                    int n12;
                    n9 = Integer.parseInt(stringArray[36]);
                    int n13 = 0;
                    if (string4.equals("AX") || string4.equals("UX")) {
                        service = Service.getService("FS");
                    } else if (string5.equals("LP")) {
                        service = Service.getService("FL");
                        n13 = 10;
                    } else if (string5.equals("VLP")) {
                        service = Service.getService("FL");
                        n13 = 11;
                    } else {
                        service = Service.getService("FM");
                        if (string5.equals("A1")) {
                            n13 = 8;
                        }
                    }
                    if (0 == n13) {
                        for (n12 = 1; n12 < ExtDbRecordFM.FM_CLASS_CODES.length; ++n12) {
                            if (!string5.equals(ExtDbRecordFM.FM_CLASS_CODES[n12])) continue;
                            n13 = n12;
                            break;
                        }
                    }
                    if (null == (sourceEditDataFM = SourceEditDataFM.createExtSource(extDb, n10, service, n13, country, errorLogger))) {
                        return null;
                    }
                    object2 = sourceEditDataFM;
                    sourceEditDataFM.appARN = "CANADA" + n10;
                    sourceEditDataFM.fileNumber = "BLANK" + sourceEditDataFM.appARN;
                    sourceEditDataFM.channel = n9;
                    sourceEditDataFM.status = string7;
                    sourceEditDataFM.statusType = n11;
                    sourceEditDataFM.heightAMSL = stringArray[35].length() > 0 ? Double.parseDouble(stringArray[35]) : -999.0;
                    if (stringArray[28].length() > 0) {
                        sourceEditDataFM.overallHAAT = Double.parseDouble(stringArray[28]);
                        if (sourceEditDataFM.overallHAAT < -1100.0) {
                            sourceEditDataFM.overallHAAT = -999.0;
                        }
                    } else {
                        sourceEditDataFM.heightAMSL = -999.0;
                    }
                    sourceEditDataFM.peakERP = 0.001;
                    for (n12 = 29; n12 <= 32; ++n12) {
                        double d4;
                        if (stringArray[n12].length() <= 0 || !((d4 = Double.parseDouble(stringArray[n12]) / 1000.0) > sourceEditDataFM.peakERP)) continue;
                        sourceEditDataFM.peakERP = d4;
                    }
                    if (stringArray[27].length() > 0) {
                        sourceEditDataFM.verticalPatternElectricalTilt = Double.parseDouble(stringArray[27]);
                    }
                }
                ((SourceEditData)object2).callSign = string3;
                ((SourceEditData)object2).state = string6;
                ((SourceEditData)object2).city = stringArray[1];
                int n14 = Integer.parseInt(stringArray[5]);
                int n15 = n14 / 10000;
                int n16 = n14 % 10000 / 100;
                int n17 = n14 % 100;
                double d5 = (double)n15 + (double)n16 / 60.0 + (double)n17 / 3600.0;
                n14 = Integer.parseInt(stringArray[6]);
                n15 = n14 / 10000;
                n16 = n14 % 10000 / 100;
                n17 = n14 % 100;
                double d6 = (double)n15 + (double)n16 / 60.0 + (double)n17 / 3600.0;
                ((SourceEditData)object2).location.setLatLon(d5, d6);
                antPattern = (AntPattern)hashMap4.get(string);
                if (null != antPattern) {
                    ((SourceEditData)object2).hasHorizontalPattern = true;
                    ((SourceEditData)object2).horizontalPattern = antPattern;
                    ((SourceEditData)object2).horizontalPatternChanged = true;
                }
                if (null != (antPattern = (AntPattern)hashMap5.get(string))) {
                    ((SourceEditData)object2).hasVerticalPattern = true;
                    ((SourceEditData)object2).verticalPattern = antPattern;
                    ((SourceEditData)object2).verticalPatternChanged = true;
                }
                ((SourceEditData)object2).setAttribute("sequenceDate", string2);
                if (((SourceEditData)object2).isDataValid()) {
                    arrayList2.add(object2);
                    continue;
                }
                ++n8;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                ++n8;
            }
        }
        if (null != errorLogger && (n6 > 0 || n8 > 0)) {
            errorLogger.reportMessage("");
            if (n6 > 0) {
                errorLogger.reportWarning(String.valueOf(n6) + " antenna patterns were ignored due to bad data");
            }
            if (n8 > 0) {
                errorLogger.reportWarning(String.valueOf(n8) + " station records were ignored due to bad data");
            }
        }
        return arrayList2;
    }

    public static boolean convertWirelessExtDbs(String string, DbConnection dbConnection, ErrorLogger errorLogger) throws SQLException {
        String string2 = dbConnection.getDatabase();
        dbConnection.update("UPDATE ext_db SET db_type=" + String.valueOf(7) + " WHERE db_type=" + String.valueOf(3) + " AND deleted");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        dbConnection.query("SELECT ext_db_key FROM ext_db WHERE db_type=" + String.valueOf(3));
        while (dbConnection.next()) {
            arrayList.add(dbConnection.getInt(1));
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        Service service = Service.getService("WL");
        if (null == service) {
            if (null != errorLogger) {
                errorLogger.reportError("Wireless station data conversion failed, missing service");
            }
            return false;
        }
        Country country = Country.getCountry(1);
        if (null == country) {
            if (null != errorLogger) {
                errorLogger.reportError("Wireless station data conversion failed, missing country");
            }
            return false;
        }
        String string3 = null;
        ExtDb extDb = null;
        DbConnection dbConnection2 = null;
        ArrayList arrayList2 = new ArrayList();
        boolean bl = true;
        try {
            for (Integer n : arrayList) {
                String string4 = string2 + "_wireless_" + String.valueOf(n);
                dbConnection.setDatabase(string4);
                ArrayList arrayList3 = ExtDbRecordWL.getAllRecords(dbConnection, service, country);
                string3 = ExtDb.makeDbName(string2, 7, n);
                dbConnection.update("CREATE DATABASE " + string3 + " CHARACTER SET latin1");
                Source.createTables(dbConnection, string3);
                dbConnection.setDatabase(string4);
                extDb = new ExtDb(string, n, string3, new Date(), 7, 0, 0, false);
                extDb.id = "";
                extDb.name = "";
                extDb.description = "";
                dbConnection2 = extDb.connectAndLock(errorLogger);
                if (null == dbConnection2) {
                    bl = false;
                    break;
                }
                for (ExtDbRecordWL extDbRecordWL : arrayList3) {
                    SourceEditDataWL sourceEditDataWL = SourceEditDataWL.createExtSource(extDb, extDbRecordWL.service, extDbRecordWL.country);
                    extDbRecordWL.updateSource(dbConnection, sourceEditDataWL);
                    sourceEditDataWL.isDataChanged();
                    sourceEditDataWL.save(dbConnection2);
                }
                extDb.releaseDb(dbConnection2);
                dbConnection2 = null;
                dbConnection.setDatabase(string2);
                dbConnection.update("UPDATE ext_db SET db_type=" + String.valueOf(7) + " WHERE ext_db_key=" + String.valueOf(n));
                string3 = null;
                dbConnection.update("DROP DATABASE " + string4);
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(errorLogger, sQLException);
            bl = false;
        }
        catch (Throwable throwable) {
            if (null != errorLogger) {
                errorLogger.reportError("An unexpected error occurred:\n" + throwable);
            }
            bl = false;
        }
        if (null != dbConnection2) {
            extDb.releaseDb(dbConnection2);
        }
        if (null != string3) {
            dbConnection.update("DROP DATABASE IF EXISTS " + string3);
        }
        return bl;
    }

    public static boolean isDownloadInProgress() {
        return downloadInProgress;
    }

    private static synchronized boolean checkDownloadInProgress() {
        if (downloadInProgress) {
            return true;
        }
        downloadInProgress = true;
        return false;
    }

    public static Integer downloadDatabase(String string, int n, String string2) {
        return ExtDb.downloadDatabase(string, n, string2, null, null);
    }

    public static Integer downloadDatabase(String string, int n, String string2, ErrorLogger errorLogger) {
        return ExtDb.downloadDatabase(string, n, string2, null, errorLogger);
    }

    public static Integer downloadDatabase(String string, int n, String string2, StatusLogger statusLogger) {
        return ExtDb.downloadDatabase(string, n, string2, statusLogger, null);
    }

    public static Integer downloadDatabase(String string, int n, String string2, StatusLogger statusLogger, ErrorLogger errorLogger) {
        Integer n2;
        File file;
        block20: {
            if (ExtDb.checkDownloadInProgress()) {
                if (null != errorLogger) {
                    errorLogger.reportError("Download is already in progress");
                }
                return null;
            }
            file = null;
            n2 = null;
            try {
                String string3 = null;
                switch (n) {
                    case 2: {
                        string3 = AppCore.getPreference("lmsDownloadURL");
                        break;
                    }
                    default: {
                        if (null != errorLogger) {
                            errorLogger.reportError("Unknown or unsupported station data type");
                        }
                        downloadInProgress = false;
                        return null;
                    }
                }
                if (null == string3) {
                    if (null != errorLogger) {
                        errorLogger.reportError("Configuration error, no URL for station data download");
                    }
                    downloadInProgress = false;
                    return null;
                }
                URL uRL = new URL(string3);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setConnectTimeout(30000);
                uRLConnection.setReadTimeout(30000);
                uRLConnection.connect();
                InputStream inputStream = uRLConnection.getInputStream();
                file = File.createTempFile("dbdata", ".zip");
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                byte[] byArray = new byte[65536];
                int n3 = 0;
                int n4 = 0;
                long l = uRLConnection.getContentLengthLong();
                long l2 = 0L;
                boolean bl = false;
                if (null != statusLogger) {
                    statusLogger.reportStatus("Downloading, 0% done");
                    statusLogger.showMessage("Downloading [------------------------------] 0%");
                }
                while ((n3 = inputStream.read(byArray)) >= 0) {
                    int n5;
                    if (n3 <= 0) continue;
                    bufferedOutputStream.write(byArray, 0, n3);
                    l2 += (long)n3;
                    if (null == statusLogger) continue;
                    if (statusLogger.isCanceled()) {
                        bl = true;
                        statusLogger.logMessage("Download canceled");
                        break;
                    }
                    int n6 = (int)((double)l2 / (double)l * 30.0);
                    if (n6 <= n4) continue;
                    String string4 = String.format(Locale.US, "%d%%", (int)Math.rint((double)l2 / (double)l * 100.0));
                    statusLogger.reportStatus("Downloading, " + string4 + " done");
                    StringBuilder stringBuilder = new StringBuilder("Downloading [");
                    for (n5 = 0; n5 < n6; ++n5) {
                        stringBuilder.append('#');
                    }
                    while (n5 < 30) {
                        stringBuilder.append('-');
                        ++n5;
                    }
                    stringBuilder.append("] ");
                    stringBuilder.append(string4);
                    statusLogger.showMessage(stringBuilder.toString());
                    n4 = n6;
                }
                inputStream.close();
                bufferedOutputStream.close();
                if (!bl && l2 < l) {
                    bl = true;
                    if (null != statusLogger) {
                        statusLogger.logMessage("Download incomplete, import canceled");
                    }
                }
                if (!bl) {
                    if (null != statusLogger) {
                        statusLogger.reportStatus("Importing");
                        statusLogger.logMessage("Download complete, importing data files...");
                    }
                    n2 = ExtDb.createNewDatabase(string, n, file, string2, statusLogger, true, errorLogger);
                }
            }
            catch (Throwable throwable) {
                if (null == errorLogger) break block20;
                errorLogger.reportError(throwable.toString());
            }
        }
        if (null != file) {
            file.delete();
        }
        downloadInProgress = false;
        return n2;
    }

    public static Integer createNewDatabase(String string, int n, File file, String string2) {
        return ExtDb.createNewDatabase(string, n, file, string2, null, false, null);
    }

    public static Integer createNewDatabase(String string, int n, File file, String string2, ErrorLogger errorLogger) {
        return ExtDb.createNewDatabase(string, n, file, string2, null, false, errorLogger);
    }

    public static Integer createNewDatabase(String string, int n, File file, String string2, StatusLogger statusLogger) {
        return ExtDb.createNewDatabase(string, n, file, string2, statusLogger, false, null);
    }

    public static Integer createNewDatabase(String string, int n, File file, String string2, StatusLogger statusLogger, ErrorLogger errorLogger) {
        return ExtDb.createNewDatabase(string, n, file, string2, statusLogger, false, errorLogger);
    }

    /*
     * WARNING - void declaration
     */
    private static Integer createNewDatabase(String string, int n, File file, String string2, StatusLogger statusLogger, boolean bl, ErrorLogger errorLogger) {
        File file2 = null;
        ZipFile zipFile = null;
        if (file.isDirectory()) {
            file2 = file;
        } else {
            try {
                zipFile = new ZipFile(file);
            }
            catch (IOException iOException) {
                if (null != errorLogger) {
                    errorLogger.reportError(iOException.toString());
                }
                return null;
            }
        }
        ArrayList<TableFile> arrayList = null;
        switch (n) {
            case 1: {
                arrayList = ExtDb.openCDBSTableFiles(file2, zipFile, errorLogger);
                break;
            }
            case 2: {
                arrayList = ExtDb.openLMSTableFiles(file2, zipFile, errorLogger);
                break;
            }
            case 4: {
                arrayList = ExtDb.openCDBSFMTableFiles(file2, zipFile, errorLogger);
                break;
            }
            default: {
                if (null == errorLogger) break;
                errorLogger.reportError("Unknown or unsupported station data type");
            }
        }
        if (null == arrayList) {
            if (null != zipFile) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            if (null != zipFile) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
        String string3 = null;
        String string4 = null;
        String string5 = DbCore.getDbName(string);
        boolean bl2 = false;
        int n2 = 0;
        try {
            dbConnection.update("LOCK TABLES ext_db_key_sequence WRITE");
            dbConnection.update("UPDATE ext_db_key_sequence SET ext_db_key = ext_db_key + 1");
            dbConnection.query("SELECT ext_db_key FROM ext_db_key_sequence");
            dbConnection.next();
            n2 = dbConnection.getInt(1);
            if (10000 == n2) {
                n2 = 20000;
                dbConnection.update("UPDATE ext_db_key_sequence SET ext_db_key = " + n2);
            }
            dbConnection.update("UNLOCK TABLES");
            string4 = ExtDb.makeDbName(string5, n, n2);
            Object object = null;
            int n3 = 0;
            switch (n) {
                case 1: {
                    object = new DateCounter("MM/dd/yyyy");
                    n3 = 1;
                    break;
                }
                case 2: {
                    object = new DateCounter("yyyy-MM-dd");
                    n3 = 11;
                    break;
                }
                case 4: {
                    object = new DateCounter("MM/dd/yyyy");
                    n3 = 1;
                }
            }
            dbConnection.update("CREATE DATABASE " + string4 + " CHARACTER SET latin1");
            dbConnection.setDatabase(string4);
            if (null != statusLogger) {
                statusLogger.reportStatus("Importing");
            }
            for (TableFile object2 : arrayList) {
                if (null != object2.reader) {
                    if (null != statusLogger) {
                        if (statusLogger.isCanceled()) {
                            bl2 = true;
                            statusLogger.logMessage("Import canceled");
                            break;
                        }
                        statusLogger.logMessage("Importing data file " + object2.fileName + "...");
                    }
                    if (null != (string3 = ExtDb.createAndCopyTable(dbConnection, object2, (DateCounter)object, statusLogger))) {
                        bl2 = true;
                        break;
                    }
                    object2.createAllIndex(dbConnection);
                    for (TableField tableField : object2.requiredFields) {
                        if (tableField.version <= 0 || tableField.index >= 0 || tableField.version > n3) continue;
                        n3 = tableField.version - 1;
                    }
                    continue;
                }
                if (object2.version <= 0 || object2.version > n3) continue;
                n3 = object2.version - 1;
            }
            int n4 = 0;
            if (!bl2 && 2 == n) {
                if (null != statusLogger && statusLogger.isCanceled()) {
                    bl2 = true;
                    statusLogger.logMessage("Import canceled");
                } else {
                    if (null != statusLogger) {
                        statusLogger.logMessage("Building search index...");
                    }
                    ExtDb.updateSearchIndex(dbConnection, 0);
                    n4 = 3;
                }
            }
            if (!bl2) {
                void var19_34;
                void var19_32;
                String string6 = "";
                Object object2 = "NOW()";
                switch (n) {
                    case 1: {
                        String string7 = ((DateCounter)object).getDate();
                        object2 = "'" + AppCore.formatDateTime(((DateCounter)object).getDbDate()) + "'";
                        break;
                    }
                    case 2: {
                        String string8 = ((DateCounter)object).getDate();
                        object2 = "'" + AppCore.formatDateTime(((DateCounter)object).getDbDate()) + "'";
                        break;
                    }
                    case 4: {
                        String string9 = ((DateCounter)object).getDate();
                        object2 = "'" + AppCore.formatDateTime(((DateCounter)object).getDbDate()) + "'";
                    }
                }
                if (null == string2) {
                    string2 = "";
                }
                dbConnection.setDatabase(string5);
                dbConnection.update("LOCK TABLES ext_db WRITE");
                dbConnection.query("SELECT ext_db_key FROM ext_db WHERE (id = '" + DbConnection.clean((String)var19_32) + "')");
                if (dbConnection.next()) {
                    String string10 = (String)var19_32 + " " + String.valueOf('#') + String.valueOf(n2);
                }
                if (string2.length() > 0) {
                    dbConnection.query("SELECT ext_db_key FROM ext_db WHERE (UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "')");
                    if (dbConnection.next()) {
                        string2 = string2 + " " + String.valueOf('#') + String.valueOf(n2);
                    }
                }
                dbConnection.update("INSERT INTO ext_db (ext_db_key, db_type, db_date, version, index_version, id, name, deleted, locked, is_download, bad_data) VALUES (" + n2 + ", " + n + ", " + (String)object2 + ", " + n3 + ", " + n4 + ", '" + DbConnection.clean((String)var19_34) + "', '" + DbConnection.clean(string2) + "', false, false, " + bl + ", false)");
                string4 = null;
                dbConnection.update("UNLOCK TABLES");
                string3 = ExtDb.checkImport(dbConnection, string5, n, bl, n2, (String)object2, arrayList);
            }
        }
        catch (SQLException sQLException) {
            string3 = "A database error occurred:\n" + sQLException;
            bl2 = true;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
            if (bl2 && null != string4) {
                dbConnection.update("DROP DATABASE IF EXISTS " + string4);
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        for (TableFile tableFile : arrayList) {
            tableFile.closeFile();
        }
        if (null != zipFile) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (null != string3 && null != errorLogger) {
            if (bl2) {
                errorLogger.reportError(string3);
            } else {
                errorLogger.reportWarning(string3);
            }
        }
        ExtDb.reloadCache(string);
        if (bl2) {
            return null;
        }
        statusLogger.logMessage("Import complete");
        return n2;
    }

    public static boolean updateAllSearchIndex(String string, DbConnection dbConnection, ErrorLogger errorLogger) throws SQLException {
        String string2 = dbConnection.getDatabase();
        dbConnection.update("UPDATE ext_db SET index_version=" + String.valueOf(3) + " WHERE db_type=" + String.valueOf(2) + " AND deleted");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        dbConnection.query("SELECT ext_db_key, index_version FROM ext_db WHERE db_type=" + String.valueOf(2) + " AND index_version <> " + String.valueOf(3));
        while (dbConnection.next()) {
            arrayList.add(dbConnection.getInt(1));
            arrayList2.add(dbConnection.getInt(2));
        }
        if (arrayList.isEmpty()) {
            return true;
        }
        boolean bl = true;
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                Integer n = (Integer)arrayList.get(i);
                Integer n2 = (Integer)arrayList2.get(i);
                dbConnection.setDatabase(ExtDb.makeDbName(string2, 2, n));
                ExtDb.updateSearchIndex(dbConnection, n2);
                dbConnection.setDatabase(string2);
                dbConnection.update("UPDATE ext_db SET index_version=" + String.valueOf(3) + " WHERE ext_db_key=" + String.valueOf(n));
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(errorLogger, sQLException);
            bl = false;
        }
        catch (Throwable throwable) {
            if (null != errorLogger) {
                errorLogger.reportError("An unexpected error occurred:\n" + throwable);
            }
            bl = false;
        }
        return bl;
    }

    private static void updateSearchIndex(DbConnection dbConnection, int n) throws SQLException {
        switch (n) {
            case 0: {
                HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                dbConnection.query("SELECT facility_id, callsign FROM facility");
                while (dbConnection.next()) {
                    int n2;
                    int n3;
                    Integer n4 = dbConnection.getInt(1);
                    String string = dbConnection.getString(2);
                    if (null == string || 0 == (n3 = (string = string.trim().toUpperCase()).length())) continue;
                    for (n2 = 0; string.charAt(n2) == 'D' && n2 < n3; ++n2) {
                    }
                    if (n2 >= n3) continue;
                    if (n2 > 0) {
                        string = string.substring(n2);
                    }
                    hashMap.put(n4, string);
                }
                dbConnection.update("CREATE TEMPORARY TABLE temp_callsign (facility_id INT, callsign CHAR(12))");
                StringBuilder stringBuilder = new StringBuilder("INSERT INTO temp_callsign VALUES");
                int n5 = stringBuilder.length();
                String string = " (";
                for (Map.Entry entry : hashMap.entrySet()) {
                    stringBuilder.append(string);
                    stringBuilder.append(String.valueOf(entry.getKey()));
                    stringBuilder.append(",'");
                    stringBuilder.append(DbConnection.clean((String)entry.getValue()));
                    if (stringBuilder.length() > 500000) {
                        stringBuilder.append("')");
                        dbConnection.update(stringBuilder.toString());
                        stringBuilder.setLength(n5);
                        string = " (";
                        continue;
                    }
                    string = "'),(";
                }
                if (stringBuilder.length() > n5) {
                    stringBuilder.append("')");
                    dbConnection.update(stringBuilder.toString());
                }
                dbConnection.update("ALTER TABLE facility ADD COLUMN _search_callsign CHAR(12)");
                dbConnection.update("UPDATE facility JOIN temp_callsign USING (facility_id) SET facility._search_callsign = temp_callsign.callsign");
                dbConnection.update("CREATE INDEX search_callsign_index ON facility (_search_callsign)");
            }
            case 1: {
                dbConnection.update("ALTER TABLE application ADD COLUMN _search_filenum CHAR(20)");
                dbConnection.update("UPDATE application SET _search_filenum = UPPER(aapp_file_num)");
                dbConnection.update("CREATE INDEX search_filenum_index ON application (_search_filenum)");
                dbConnection.update("ALTER TABLE facility ADD COLUMN _search_city VARCHAR(255)");
                dbConnection.update("UPDATE facility JOIN application_facility ON (facility.facility_id = application_facility.afac_facility_id) SET facility._search_city = (UPPER(CASE WHEN (facility.community_served_city <> '') THEN facility.community_served_city ELSE application_facility.afac_community_city END))");
                dbConnection.update("CREATE INDEX search_city_index ON facility (_search_city)");
            }
            case 2: {
                dbConnection.update("ALTER TABLE application ADD COLUMN _search_arn CHAR(20)");
                dbConnection.update("UPDATE application SET _search_arn = UPPER(CASE WHEN (LOCATE('-', aapp_file_num) > 0) THEN SUBSTRING_INDEX(aapp_file_num, '-', -1) ELSE aapp_file_num END)");
                dbConnection.update("CREATE INDEX search_arn_index ON application (_search_arn)");
            }
        }
    }

    private static String checkImport(DbConnection dbConnection, String string, int n, boolean bl, int n2, String string2, ArrayList<TableFile> arrayList) throws SQLException {
        boolean bl2 = false;
        String string3 = null;
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            TableFile tableFile = object.next();
            if (0 != tableFile.rowCount) continue;
            bl2 = true;
            string3 = "Some imported tables are empty, the data set may be damaged.\nThe data set will be flagged and will not be used automatically.  If\ndata is valid, the flag can be cleared in the data manager.";
            break;
        }
        if (!bl2) {
            dbConnection.query("SELECT ext_db_key FROM ext_db WHERE db_type = " + n + " AND ext_db_key <> " + n2 + " AND db_date < " + string2 + " AND NOT bad_data AND NOT deleted ORDER BY db_date DESC LIMIT 1");
            if (dbConnection.next()) {
                dbConnection.setDatabase(ExtDb.makeDbName(string, n, dbConnection.getInt(1)));
                for (TableFile tableFile : arrayList) {
                    if (null == tableFile.keyField || tableFile.rowCount <= 0) continue;
                    dbConnection.query("SELECT COUNT(*) FROM " + tableFile.tableName);
                    if (!dbConnection.next()) continue;
                    int n3 = dbConnection.getInt(1);
                    int n4 = n3 + n3 / 5;
                    if (tableFile.rowCount >= n3 && tableFile.rowCount <= n4) continue;
                    bl2 = true;
                    string3 = "Imported table row counts are inconsistent with older imports, the\ndata set may be damaged.  The data set will be flagged and will not be used\nautomatically.  If data is valid, the flag can be cleared in the data manager.";
                    break;
                }
                dbConnection.setDatabase(string);
            }
        }
        if (bl2) {
            dbConnection.update("UPDATE ext_db SET bad_data = true WHERE ext_db_key = " + n2);
            return string3;
        }
        if (bl && null != (object = AppCore.getPreference("autoDeletePreviousDownload")) && Boolean.valueOf((String)object).booleanValue()) {
            dbConnection.update("UPDATE ext_db SET is_download = false, deleted = true WHERE db_type = " + n + " AND ext_db_key <> " + n2 + " AND is_download AND NOT locked");
        }
        return null;
    }

    public static String makeDbName(String string, int n, Integer n2) {
        switch (n) {
            case 1: {
                return string + "_cdbs_" + n2;
            }
            case 2: {
                return string + "_lms_" + n2;
            }
            case 4: {
                return string + "_cdbs_fm_" + n2;
            }
            case 6: {
                return string + "_import_tv_" + n2;
            }
            case 7: {
                return string + "_import_wl_" + n2;
            }
            case 8: {
                return string + "_import_fm_" + n2;
            }
        }
        return "";
    }

    private static ArrayList<String> getDbBaseNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cdbs");
        arrayList.add("lms");
        arrayList.add("import");
        return arrayList;
    }

    private static void loadCDBSFieldNames() {
        if (null != CDBSFieldNamesMap) {
            return;
        }
        CDBSFieldNamesMap = new HashMap();
        try {
            String string;
            BufferedReader bufferedReader = Files.newBufferedReader(AppCore.libDirectoryPath.resolve(CDBS_TABLE_DEFS_FILE));
            do {
                String[] stringArray;
                if (null == (string = AppCore.readLineSkipComments(bufferedReader)) || null == (stringArray = AppCore.readAndParseLine(bufferedReader)) || string.length() <= 3 || stringArray.length <= 2) continue;
                CDBSFieldNamesMap.put(string, stringArray);
            } while (null != string);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static ArrayList<TableFile> openCDBSTableFiles(File file, ZipFile zipFile, ErrorLogger errorLogger) {
        ExtDb.loadCDBSFieldNames();
        ArrayList<TableFile> arrayList = new ArrayList<TableFile>();
        String string = "application";
        TableFile tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("application_id", "INT", false));
        tableFile.addRequiredField("fac_callsign", "CHAR(12)", true);
        tableFile.addRequiredField("comm_city", "CHAR(20)", true);
        tableFile.addRequiredField("comm_state", "CHAR(2)", true);
        tableFile.addRequiredField("file_prefix", "CHAR(10)", true);
        tableFile.addRequiredField("app_arn", "CHAR(12)", true);
        tableFile.setDateField(tableFile.addRequiredField("last_change_date", "CHAR(20)", true));
        arrayList.add(tableFile);
        string = "app_tracking";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("application_id", "INT", false);
        tableFile.addRequiredField("accepted_date", "CHAR(20)", true);
        tableFile.setDateField(tableFile.addRequiredField("last_change_date", "CHAR(20)", true));
        arrayList.add(tableFile);
        string = "facility";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("facility_id", "INT", false));
        tableFile.addRequiredField("fac_callsign", "CHAR(12)", true);
        tableFile.addRequiredField("comm_city", "CHAR(20)", true);
        tableFile.addRequiredField("comm_state", "CHAR(2)", true);
        tableFile.addRequiredField("fac_service", "CHAR(2)", true);
        tableFile.addRequiredField("fac_country", "CHAR(2)", true);
        tableFile.setDateField(tableFile.addRequiredField("last_change_date", "CHAR(20)", true));
        arrayList.add(tableFile);
        string = "tv_eng_data";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.addRequiredField("application_id", "INT", false);
        tableFile.addRequiredField("site_number", "TINYINT", false);
        tableFile.setExtraDefinitions("UNIQUE (application_id,site_number)");
        tableFile.addRequiredFieldWithIndex("facility_id", "INT", false);
        tableFile.addRequiredField("eng_record_type", "CHAR(1)", true);
        tableFile.addRequiredField("vsd_service", "CHAR(2)", true);
        tableFile.addRequiredField("station_channel", "INT", false);
        tableFile.addRequiredField("tv_dom_status", "CHAR(6)", true);
        tableFile.addRequiredField("fac_zone", "CHAR(3)", true);
        tableFile.addRequiredField("freq_offset", "CHAR(1)", true);
        tableFile.addRequiredField("dt_emission_mask", "CHAR(1)", true);
        tableFile.addRequiredField("lat_dir", "CHAR(1)", true);
        tableFile.addRequiredField("lat_deg", "INT", false);
        tableFile.addRequiredField("lat_min", "INT", false);
        tableFile.addRequiredField("lat_sec", "FLOAT", false);
        tableFile.addRequiredField("lon_dir", "CHAR(1)", true);
        tableFile.addRequiredField("lon_deg", "INT", false);
        tableFile.addRequiredField("lon_min", "INT", false);
        tableFile.addRequiredField("lon_sec", "FLOAT", false);
        tableFile.addRequiredField("rcamsl_horiz_mtr", "FLOAT", false);
        tableFile.addRequiredField("haat_rc_mtr", "FLOAT", false);
        tableFile.addRequiredField("effective_erp", "FLOAT", false);
        tableFile.addRequiredField("max_erp_any_angle", "FLOAT", false);
        tableFile.addRequiredField("antenna_id", "INT", false);
        tableFile.addRequiredField("ant_rotation", "FLOAT", false);
        tableFile.addRequiredField("elevation_antenna_id", "INT", false);
        tableFile.addRequiredField("electrical_deg", "FLOAT", false);
        tableFile.addRequiredField("mechanical_deg", "FLOAT", false);
        tableFile.addRequiredField("true_deg", "FLOAT", false);
        tableFile.addRequiredField("predict_coverage_area", "FLOAT", false);
        tableFile.setDateField(tableFile.addRequiredField("last_change_date", "CHAR(20)", true));
        arrayList.add(tableFile);
        string = "tv_app_indicators";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.addRequiredField("application_id", "INT", false);
        tableFile.addRequiredField("site_number", "TINYINT", false);
        tableFile.setExtraDefinitions("UNIQUE (application_id,site_number)");
        tableFile.addRequiredField("da_ind", "CHAR(1)", true);
        arrayList.add(tableFile);
        string = "dtv_channel_assignments";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("facility_id", "INT", false));
        tableFile.addRequiredField("callsign", "CHAR(12)", true);
        tableFile.addRequiredField("city", "CHAR(20)", true);
        tableFile.addRequiredField("state", "CHAR(2)", true);
        tableFile.addRequiredField("post_dtv_channel", "INT", false);
        tableFile.addRequiredField("latitude", "CHAR(10)", true);
        tableFile.addRequiredField("longitude", "CHAR(11)", true);
        tableFile.addRequiredField("rcamsl", "INT", false);
        tableFile.addRequiredField("haat", "FLOAT", false);
        tableFile.addRequiredField("erp", "FLOAT", false);
        tableFile.addRequiredField("da_ind", "CHAR(1)", true);
        tableFile.addRequiredField("antenna_id", "INT", false);
        tableFile.addRequiredField("ref_azimuth", "INT", false);
        arrayList.add(tableFile);
        string = "ant_make";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("antenna_id", "INT", false));
        tableFile.addRequiredField("ant_make", "CHAR(3)", true);
        tableFile.addRequiredField("ant_model_num", "CHAR(60)", true);
        arrayList.add(tableFile);
        string = "ant_pattern";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("antenna_id", "INT", false);
        tableFile.addRequiredField("azimuth", "FLOAT", false);
        tableFile.addRequiredField("field_value", "FLOAT", false);
        arrayList.add(tableFile);
        string = "elevation_ant_make";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("elevation_antenna_id", "INT", false));
        tableFile.addRequiredField("ant_make", "CHAR(3)", true);
        tableFile.addRequiredField("ant_model_num", "CHAR(60)", true);
        arrayList.add(tableFile);
        string = "elevation_pattern";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("elevation_antenna_id", "INT", false);
        tableFile.addRequiredField("depression_angle", "FLOAT", false);
        tableFile.addRequiredField("field_value", "FLOAT", false);
        tableFile.addRequiredField("field_value0", "FLOAT", false);
        tableFile.addRequiredField("field_value10", "FLOAT", false);
        tableFile.addRequiredField("field_value20", "FLOAT", false);
        tableFile.addRequiredField("field_value30", "FLOAT", false);
        tableFile.addRequiredField("field_value40", "FLOAT", false);
        tableFile.addRequiredField("field_value50", "FLOAT", false);
        tableFile.addRequiredField("field_value60", "FLOAT", false);
        tableFile.addRequiredField("field_value70", "FLOAT", false);
        tableFile.addRequiredField("field_value80", "FLOAT", false);
        tableFile.addRequiredField("field_value90", "FLOAT", false);
        tableFile.addRequiredField("field_value100", "FLOAT", false);
        tableFile.addRequiredField("field_value110", "FLOAT", false);
        tableFile.addRequiredField("field_value120", "FLOAT", false);
        tableFile.addRequiredField("field_value130", "FLOAT", false);
        tableFile.addRequiredField("field_value140", "FLOAT", false);
        tableFile.addRequiredField("field_value150", "FLOAT", false);
        tableFile.addRequiredField("field_value160", "FLOAT", false);
        tableFile.addRequiredField("field_value170", "FLOAT", false);
        tableFile.addRequiredField("field_value180", "FLOAT", false);
        tableFile.addRequiredField("field_value190", "FLOAT", false);
        tableFile.addRequiredField("field_value200", "FLOAT", false);
        tableFile.addRequiredField("field_value210", "FLOAT", false);
        tableFile.addRequiredField("field_value220", "FLOAT", false);
        tableFile.addRequiredField("field_value230", "FLOAT", false);
        tableFile.addRequiredField("field_value240", "FLOAT", false);
        tableFile.addRequiredField("field_value250", "FLOAT", false);
        tableFile.addRequiredField("field_value260", "FLOAT", false);
        tableFile.addRequiredField("field_value270", "FLOAT", false);
        tableFile.addRequiredField("field_value280", "FLOAT", false);
        tableFile.addRequiredField("field_value290", "FLOAT", false);
        tableFile.addRequiredField("field_value300", "FLOAT", false);
        tableFile.addRequiredField("field_value310", "FLOAT", false);
        tableFile.addRequiredField("field_value320", "FLOAT", false);
        tableFile.addRequiredField("field_value330", "FLOAT", false);
        tableFile.addRequiredField("field_value340", "FLOAT", false);
        tableFile.addRequiredField("field_value350", "FLOAT", false);
        arrayList.add(tableFile);
        string = "elevation_pattern_addl";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("elevation_antenna_id", "INT", false);
        tableFile.addRequiredField("azimuth", "FLOAT", false);
        tableFile.addRequiredField("depression_angle", "FLOAT", false);
        tableFile.addRequiredField("field_value", "FLOAT", false);
        arrayList.add(tableFile);
        string = "am_ant_sys";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, false);
        tableFile.addRequiredField("application_id", "INT", false);
        tableFile.addRequiredField("eng_record_type", "CHAR(1)", true);
        tableFile.addRequiredField("am_dom_status", "CHAR(1)", true);
        tableFile.addRequiredField("ant_mode", "CHAR(3)", true);
        tableFile.addRequiredField("lat_dir", "CHAR(1)", true);
        tableFile.addRequiredField("lat_deg", "INT", false);
        tableFile.addRequiredField("lat_min", "INT", false);
        tableFile.addRequiredField("lat_sec", "FLOAT", false);
        tableFile.addRequiredField("lon_dir", "CHAR(1)", true);
        tableFile.addRequiredField("lon_deg", "INT", false);
        tableFile.addRequiredField("lon_min", "INT", false);
        tableFile.addRequiredField("lon_sec", "FLOAT", false);
        arrayList.add(tableFile);
        String string2 = null;
        for (TableFile tableFile2 : arrayList) {
            if (null == tableFile2.fieldNames) {
                string2 = "Field name list not found for table '" + tableFile2.tableName + "'";
                break;
            }
            if (tableFile2.openFile()) continue;
            tableFile2.rowCount = -1;
            if (!tableFile2.required) continue;
            string2 = "Data file '" + tableFile2.fileName + "' could not be opened";
            break;
        }
        if (null != string2) {
            for (TableFile tableFile2 : arrayList) {
                tableFile2.closeFile();
            }
            if (null != errorLogger) {
                errorLogger.reportError(string2);
            }
            return null;
        }
        return arrayList;
    }

    private static ArrayList<TableFile> openLMSTableFiles(File file, ZipFile zipFile, ErrorLogger errorLogger) {
        ArrayList<TableFile> arrayList = new ArrayList<TableFile>();
        TableFile tableFile = new TableFile("application", null, file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("aapp_application_id", "CHAR(36)", true));
        tableFile.addRequiredField("aapp_callsign", "CHAR(12)", true);
        tableFile.addRequiredField("aapp_receipt_date", "CHAR(20)", true);
        tableFile.addRequiredField("aapp_file_num", "CHAR(20)", true);
        tableFile.addRequiredField("dts_reference_ind", "CHAR(1)", true);
        tableFile.addRequiredField("dts_waiver_distance", "VARCHAR(255)", true);
        tableFile.setDateField(tableFile.addRequiredField("last_update_ts", "CHAR(30)", true));
        tableFile.addRequiredField("channel_sharing_ind", "CHAR(1)", true);
        arrayList.add(tableFile);
        tableFile = new TableFile("license_filing_version", null, file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("filing_version_id", "CHAR(36)", true));
        tableFile.addRequiredField("active_ind", "CHAR(1)", true);
        tableFile.addRequiredFieldWithIndex("purpose_code", "CHAR(6)", true);
        tableFile.addRequiredField("original_purpose_code", "CHAR(6)", true);
        tableFile.addRequiredFieldWithIndex("service_code", "CHAR(6)", true);
        tableFile.addRequiredField("auth_type_code", "CHAR(6)", true);
        tableFile.addRequiredField("current_status_code", "CHAR(6)", true);
        tableFile.setDateField(tableFile.addRequiredField("last_update_ts", "CHAR(30)", true));
        arrayList.add(tableFile);
        tableFile = new TableFile("application_facility", null, file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("afac_application_id", "CHAR(36)", true));
        tableFile.addRequiredFieldWithIndex("afac_facility_id", "INT", false);
        tableFile.addRequiredField("afac_channel", "INT", false);
        tableFile.addRequiredField("afac_community_city", "VARCHAR(255)", true);
        tableFile.addRequiredField("afac_community_state_code", "VARCHAR(255)", true);
        tableFile.addRequiredFieldWithIndex("country_code", "CHAR(3)", true);
        tableFile.setDateField(tableFile.addRequiredField("last_update_ts", "CHAR(30)", true));
        tableFile.addRequiredField("licensee_name", "VARCHAR(255)", true);
        tableFile.addRequiredField("station_class_code", "CHAR(6)", true, 7);
        tableFile.addRequiredField("afac_facility_type", "VARCHAR(255)", true);
        tableFile.addRequiredField("am_frequency", "VARCHAR(255)", true, 10);
        arrayList.add(tableFile);
        tableFile = new TableFile("facility", null, file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("facility_id", "INT", false);
        tableFile.addRequiredField("callsign", "CHAR(12)", true);
        tableFile.addRequiredField("community_served_city", "VARCHAR(255)", true);
        tableFile.addRequiredField("community_served_state", "VARCHAR(255)", true);
        tableFile.addRequiredField("facility_status", "CHAR(6)", true);
        tableFile.addRequiredFieldWithIndex("facility_uuid", "CHAR(36)", true);
        arrayList.add(tableFile);
        tableFile = new TableFile("facility_applicant", null, file, zipFile, 8);
        tableFile.addRequiredFieldWithIndex("facility_uuid", "CHAR(36)", true);
        tableFile.addRequiredField("active_ind", "CHAR(1)", true);
        tableFile.addRequiredFieldWithIndex("contact_ind", "CHAR(1)", true);
        tableFile.addRequiredField("legal_name", "VARCHAR(255)", true);
        arrayList.add(tableFile);
        tableFile = new TableFile("app_mm_application", null, file, zipFile, 9);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("aapp_application_id", "CHAR(36)", true));
        tableFile.addRequiredField("contour_215_protection_ind", "CHAR(1)", true);
        arrayList.add(tableFile);
        tableFile = new TableFile("app_location", null, file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("aloc_aapp_application_id", "CHAR(36)", true);
        tableFile.addRequiredFieldWithIndex("aloc_loc_record_id", "CHAR(36)", true);
        tableFile.addRequiredField("aloc_loc_seq_id", "INT", false);
        tableFile.addRequiredField("aloc_dts_reference_location_ind", "CHAR(1)", true);
        tableFile.addRequiredField("aloc_lat_dir", "CHAR(1)", true);
        tableFile.addRequiredField("aloc_lat_deg", "INT", false);
        tableFile.addRequiredField("aloc_lat_mm", "INT", false);
        tableFile.addRequiredField("aloc_lat_ss", "FLOAT", false);
        tableFile.addRequiredField("aloc_long_dir", "CHAR(1)", true);
        tableFile.addRequiredField("aloc_long_deg", "INT", false);
        tableFile.addRequiredField("aloc_long_mm", "INT", false);
        tableFile.addRequiredField("aloc_long_ss", "FLOAT", false);
        arrayList.add(tableFile);
        tableFile = new TableFile("app_antenna", null, file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("aant_aloc_loc_record_id", "CHAR(36)", true);
        tableFile.addRequiredFieldWithIndex("aant_antenna_record_id", "CHAR(36)", true);
        tableFile.addRequiredField("aant_antenna_type_code", "VARCHAR(255)", true);
        tableFile.addRequiredField("aant_rc_amsl", "FLOAT", false);
        tableFile.addRequiredField("aant_rc_haat", "FLOAT", false);
        tableFile.addRequiredField("aant_rotation_deg", "FLOAT", false);
        tableFile.addRequiredField("aant_electrical_deg", "FLOAT", false);
        tableFile.addRequiredField("aant_mechanical_deg", "FLOAT", false);
        tableFile.addRequiredField("aant_true_deg", "FLOAT", false);
        tableFile.addRequiredField("emission_mask_code", "CHAR(6)", true);
        tableFile.addRequiredField("aant_antenna_id", "VARCHAR(255)", true);
        tableFile.addRequiredField("aant_make", "VARCHAR(255)", true);
        tableFile.addRequiredField("aant_model", "VARCHAR(255)", true);
        tableFile.addRequiredField("foreign_station_beam_tilt", "FLOAT", false, 5);
        tableFile.addRequiredField("aant_horiz_rc_amsl", "FLOAT", false);
        tableFile.addRequiredField("aant_vert_rc_amsl", "FLOAT", false);
        tableFile.addRequiredField("aant_horiz_rc_haat", "FLOAT", false);
        tableFile.addRequiredField("aant_vert_rc_haat", "FLOAT", false);
        arrayList.add(tableFile);
        tableFile = new TableFile("app_antenna_frequency", null, file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("aafq_aant_antenna_record_id", "CHAR(36)", true);
        tableFile.addRequiredField("aafq_power_erp_kw", "FLOAT", false);
        tableFile.addRequiredField("aafq_offset", "VARCHAR(255)", true);
        tableFile.addRequiredField("aafq_horiz_max_erp_kw", "FLOAT", false);
        tableFile.addRequiredField("aafq_horiz_erp_kw", "FLOAT", false);
        tableFile.addRequiredField("aafq_vert_max_erp_kw", "FLOAT", false);
        tableFile.addRequiredField("aafq_vert_erp_kw", "FLOAT", false);
        arrayList.add(tableFile);
        tableFile = new TableFile("app_antenna_field_value", null, file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("aafv_aant_antenna_record_id", "CHAR(36)", true);
        tableFile.addRequiredField("aafv_azimuth", "FLOAT", false);
        tableFile.addRequiredField("aafv_field_value", "FLOAT", false);
        arrayList.add(tableFile);
        tableFile = new TableFile("app_antenna_elevation_pattern", null, file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("aaep_antenna_record_id", "CHAR(36)", true);
        tableFile.addRequiredField("aaep_azimuth", "FLOAT", false);
        tableFile.addRequiredField("aaep_depression_angle", "FLOAT", false);
        tableFile.addRequiredField("aaep_field_value", "FLOAT", false);
        arrayList.add(tableFile);
        tableFile = new TableFile("app_dtv_channel_assignment", null, file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("adca_facility_record_id", "INT", false);
        tableFile.addRequiredField("dtv_allotment_id", "CHAR(36)", true);
        tableFile.addRequiredField("callsign", "CHAR(12)", true);
        tableFile.addRequiredField("rcamsl", "FLOAT", false);
        tableFile.addRequiredField("directional_antenna_ind", "CHAR(1)", true);
        tableFile.addRequiredField("antenna_id", "CHAR(36)", true);
        tableFile.addRequiredField("antenna_rotation", "FLOAT", false);
        tableFile.addRequiredField("emission_mask_code", "VARCHAR(255)", true, 4);
        tableFile.addRequiredField("electrical_deg", "FLOAT", false, 5);
        tableFile.addRequiredField("pre_auction_channel", "INT", false);
        arrayList.add(tableFile);
        tableFile = new TableFile("lkp_dtv_allotment", null, file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("rdta_dtv_allotment_id", "CHAR(36)", true);
        tableFile.addRequiredField("rdta_service_code", "CHAR(6)", true, 3);
        tableFile.addRequiredField("rdta_city", "VARCHAR(255)", true);
        tableFile.addRequiredField("rdta_state", "CHAR(2)", true);
        tableFile.addRequiredField("rdta_country_code", "CHAR(3)", true, 3);
        tableFile.addRequiredField("rdta_digital_channel", "INT", false);
        tableFile.addRequiredField("rdta_erp", "FLOAT", false);
        tableFile.addRequiredField("rdta_haat", "FLOAT", false);
        tableFile.addRequiredField("rdta_lat_dir", "CHAR(1)", true);
        tableFile.addRequiredField("rdta_lat_deg", "INT", false);
        tableFile.addRequiredField("rdta_lat_min", "INT", false);
        tableFile.addRequiredField("rdta_lat_sec", "FLOAT", false);
        tableFile.addRequiredField("rdta_lon_dir", "CHAR(1)", true);
        tableFile.addRequiredField("rdta_lon_deg", "INT", false);
        tableFile.addRequiredField("rdta_lon_min", "INT", false);
        tableFile.addRequiredField("rdta_lon_sec", "FLOAT", false);
        tableFile.addRequiredField("dts_ref_application_id", "CHAR(36)", true);
        arrayList.add(tableFile);
        tableFile = new TableFile("lkp_antenna", null, file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("rant_antenna_id", "CHAR(36)", true);
        tableFile.addRequiredField("rant_antenna_record_id", "CHAR(36)", true);
        tableFile.addRequiredField("rant_make", "VARCHAR(255)", true);
        tableFile.addRequiredField("rant_model", "VARCHAR(255)", true);
        arrayList.add(tableFile);
        tableFile = new TableFile("lkp_antenna_field_value", null, file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("rafv_antenna_record_id", "CHAR(36)", true);
        tableFile.addRequiredField("rafv_azimuth", "FLOAT", false);
        tableFile.addRequiredField("rafv_field_value", "FLOAT", false);
        arrayList.add(tableFile);
        tableFile = new TableFile("shared_channel", null, file, zipFile, 6);
        tableFile.addRequiredFieldWithIndex("application_id", "CHAR(36)", true);
        tableFile.addRequiredFieldWithIndex("facility_id", "INT", false);
        tableFile.addRequiredField("host_ind", "CHAR(1)", true);
        arrayList.add(tableFile);
        tableFile = new TableFile("app_am_antenna", null, file, zipFile, 10);
        tableFile.addRequiredFieldWithIndex("aapp_application_id", "CHAR(36)", true);
        tableFile.addRequiredField("am_ant_mode_code", "CHAR(6)", true);
        tableFile.addRequiredField("dir_ind", "CHAR(1)", true);
        tableFile.addRequiredField("lat_dir", "CHAR(1)", true);
        tableFile.addRequiredField("lat_deg", "INT", false);
        tableFile.addRequiredField("lat_min", "INT", false);
        tableFile.addRequiredField("lat_sec", "FLOAT", false);
        tableFile.addRequiredField("long_dir", "CHAR(1)", true);
        tableFile.addRequiredField("long_deg", "INT", false);
        tableFile.addRequiredField("long_min", "INT", false);
        tableFile.addRequiredField("long_sec", "FLOAT", false);
        arrayList.add(tableFile);
        tableFile = new TableFile("digital_notification", null, file, zipFile, 11);
        tableFile.addRequiredFieldWithIndex("application_id", "VARCHAR(36)", true);
        tableFile.addRequiredField("analog_erp_kw", "VARCHAR(10)", true);
        tableFile.addRequiredField("digital_erp_kw", "VARCHAR(10)", true);
        arrayList.add(tableFile);
        String string = null;
        for (TableFile tableFile2 : arrayList) {
            if (tableFile2.openFile()) continue;
            tableFile2.rowCount = -1;
            if (!tableFile2.required) continue;
            string = "Data file '" + tableFile2.fileName + "' could not be opened";
            break;
        }
        if (null != string) {
            for (TableFile tableFile2 : arrayList) {
                tableFile2.closeFile();
            }
            if (null != errorLogger) {
                errorLogger.reportError(string);
            }
            return null;
        }
        return arrayList;
    }

    private static ArrayList<TableFile> openCDBSFMTableFiles(File file, ZipFile zipFile, ErrorLogger errorLogger) {
        ExtDb.loadCDBSFieldNames();
        ArrayList<TableFile> arrayList = new ArrayList<TableFile>();
        String string = "application";
        TableFile tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("application_id", "INT", false));
        tableFile.addRequiredField("file_prefix", "CHAR(10)", true);
        tableFile.addRequiredField("app_arn", "CHAR(12)", true);
        tableFile.setDateField(tableFile.addRequiredField("last_change_date", "CHAR(20)", true));
        arrayList.add(tableFile);
        string = "app_tracking";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("application_id", "INT", false);
        tableFile.addRequiredField("accepted_date", "CHAR(20)", true);
        tableFile.setDateField(tableFile.addRequiredField("last_change_date", "CHAR(20)", true));
        arrayList.add(tableFile);
        string = "facility";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("facility_id", "INT", false));
        tableFile.addRequiredField("fac_callsign", "CHAR(12)", true);
        tableFile.addRequiredField("fac_service", "CHAR(2)", true);
        tableFile.addRequiredField("comm_city", "CHAR(20)", true);
        tableFile.addRequiredField("comm_state", "CHAR(2)", true);
        tableFile.addRequiredField("fac_country", "CHAR(2)", true);
        tableFile.addRequiredField("digital_status", "CHAR(1)", true);
        tableFile.setDateField(tableFile.addRequiredField("last_change_date", "CHAR(20)", true));
        arrayList.add(tableFile);
        string = "fm_eng_data";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("application_id", "INT", false);
        tableFile.addRequiredFieldWithIndex("facility_id", "INT", false);
        tableFile.addRequiredField("eng_record_type", "CHAR(1)", true);
        tableFile.addRequiredField("asd_service", "CHAR(2)", true);
        tableFile.addRequiredField("station_channel", "INT", false);
        tableFile.addRequiredField("fm_dom_status", "CHAR(6)", true);
        tableFile.addRequiredField("lat_dir", "CHAR(1)", true);
        tableFile.addRequiredField("lat_deg", "INT", false);
        tableFile.addRequiredField("lat_min", "INT", false);
        tableFile.addRequiredField("lat_sec", "FLOAT", false);
        tableFile.addRequiredField("lon_dir", "CHAR(1)", true);
        tableFile.addRequiredField("lon_deg", "INT", false);
        tableFile.addRequiredField("lon_min", "INT", false);
        tableFile.addRequiredField("lon_sec", "FLOAT", false);
        tableFile.addRequiredField("rcamsl_horiz_mtr", "FLOAT", false);
        tableFile.addRequiredField("rcamsl_vert_mtr", "FLOAT", false);
        tableFile.addRequiredField("haat_horiz_rc_mtr", "FLOAT", false);
        tableFile.addRequiredField("haat_vert_rc_mtr", "FLOAT", false);
        tableFile.addRequiredField("max_horiz_erp", "FLOAT", false);
        tableFile.addRequiredField("horiz_erp", "FLOAT", false);
        tableFile.addRequiredField("max_vert_erp", "FLOAT", false);
        tableFile.addRequiredField("vert_erp", "FLOAT", false);
        tableFile.addRequiredField("antenna_id", "INT", false);
        tableFile.addRequiredField("ant_rotation", "FLOAT", false);
        tableFile.setDateField(tableFile.addRequiredField("last_change_date", "CHAR(20)", true));
        arrayList.add(tableFile);
        string = "fm_app_indicators";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("application_id", "INT", false));
        tableFile.addRequiredField("da_ind", "CHAR(1)", true);
        arrayList.add(tableFile);
        string = "if_notification";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("application_id", "INT", false));
        tableFile.addRequiredField("analog_erp", "FLOAT", false);
        tableFile.addRequiredField("digital_erp", "FLOAT", false);
        arrayList.add(tableFile);
        string = "ant_make";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("antenna_id", "INT", false));
        tableFile.addRequiredField("ant_make", "CHAR(3)", true);
        tableFile.addRequiredField("ant_model_num", "CHAR(60)", true);
        arrayList.add(tableFile);
        string = "ant_pattern";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("antenna_id", "INT", false);
        tableFile.addRequiredField("azimuth", "FLOAT", false);
        tableFile.addRequiredField("field_value", "FLOAT", false);
        arrayList.add(tableFile);
        string = "elevation_ant_make";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.setKeyField(tableFile.addRequiredFieldWithIndex("elevation_antenna_id", "INT", false));
        tableFile.addRequiredField("ant_make", "CHAR(3)", true);
        tableFile.addRequiredField("ant_model_num", "CHAR(60)", true);
        arrayList.add(tableFile);
        string = "elevation_pattern";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("elevation_antenna_id", "INT", false);
        tableFile.addRequiredField("depression_angle", "FLOAT", false);
        tableFile.addRequiredField("field_value", "FLOAT", false);
        tableFile.addRequiredField("field_value0", "FLOAT", false);
        tableFile.addRequiredField("field_value10", "FLOAT", false);
        tableFile.addRequiredField("field_value20", "FLOAT", false);
        tableFile.addRequiredField("field_value30", "FLOAT", false);
        tableFile.addRequiredField("field_value40", "FLOAT", false);
        tableFile.addRequiredField("field_value50", "FLOAT", false);
        tableFile.addRequiredField("field_value60", "FLOAT", false);
        tableFile.addRequiredField("field_value70", "FLOAT", false);
        tableFile.addRequiredField("field_value80", "FLOAT", false);
        tableFile.addRequiredField("field_value90", "FLOAT", false);
        tableFile.addRequiredField("field_value100", "FLOAT", false);
        tableFile.addRequiredField("field_value110", "FLOAT", false);
        tableFile.addRequiredField("field_value120", "FLOAT", false);
        tableFile.addRequiredField("field_value130", "FLOAT", false);
        tableFile.addRequiredField("field_value140", "FLOAT", false);
        tableFile.addRequiredField("field_value150", "FLOAT", false);
        tableFile.addRequiredField("field_value160", "FLOAT", false);
        tableFile.addRequiredField("field_value170", "FLOAT", false);
        tableFile.addRequiredField("field_value180", "FLOAT", false);
        tableFile.addRequiredField("field_value190", "FLOAT", false);
        tableFile.addRequiredField("field_value200", "FLOAT", false);
        tableFile.addRequiredField("field_value210", "FLOAT", false);
        tableFile.addRequiredField("field_value220", "FLOAT", false);
        tableFile.addRequiredField("field_value230", "FLOAT", false);
        tableFile.addRequiredField("field_value240", "FLOAT", false);
        tableFile.addRequiredField("field_value250", "FLOAT", false);
        tableFile.addRequiredField("field_value260", "FLOAT", false);
        tableFile.addRequiredField("field_value270", "FLOAT", false);
        tableFile.addRequiredField("field_value280", "FLOAT", false);
        tableFile.addRequiredField("field_value290", "FLOAT", false);
        tableFile.addRequiredField("field_value300", "FLOAT", false);
        tableFile.addRequiredField("field_value310", "FLOAT", false);
        tableFile.addRequiredField("field_value320", "FLOAT", false);
        tableFile.addRequiredField("field_value330", "FLOAT", false);
        tableFile.addRequiredField("field_value340", "FLOAT", false);
        tableFile.addRequiredField("field_value350", "FLOAT", false);
        arrayList.add(tableFile);
        string = "elevation_pattern_addl";
        tableFile = new TableFile(string, CDBSFieldNamesMap.get(string), file, zipFile, true);
        tableFile.addRequiredFieldWithIndex("elevation_antenna_id", "INT", false);
        tableFile.addRequiredField("azimuth", "FLOAT", false);
        tableFile.addRequiredField("depression_angle", "FLOAT", false);
        tableFile.addRequiredField("field_value", "FLOAT", false);
        arrayList.add(tableFile);
        String string2 = null;
        for (TableFile tableFile2 : arrayList) {
            if (null == tableFile2.fieldNames) {
                string2 = "Field name list not found for table '" + tableFile2.tableName + "'";
                break;
            }
            if (tableFile2.openFile()) continue;
            tableFile2.rowCount = -1;
            if (!tableFile2.required) continue;
            string2 = "Data file '" + tableFile2.fileName + "' could not be opened";
            break;
        }
        if (null != string2) {
            for (TableFile tableFile2 : arrayList) {
                tableFile2.closeFile();
            }
            if (null != errorLogger) {
                errorLogger.reportError(string2);
            }
            return null;
        }
        return arrayList;
    }

    private static String createAndCopyTable(DbConnection dbConnection, TableFile tableFile, DateCounter dateCounter, StatusLogger statusLogger) {
        String string = null;
        int n = 1;
        int n2 = 0;
        boolean bl = false;
        try {
            Object object2;
            int n3;
            String[] stringArray = tableFile.fieldNames;
            int n4 = 0;
            if (null == stringArray) {
                stringArray = tableFile.reader.readLine().split("\\|");
                ++n;
                n4 = stringArray.length - 1;
            } else {
                n4 = stringArray.length;
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (n3 = 0; n3 < n4; ++n3) {
                if (stringArray[n3].length() < 3) {
                    n4 = -1;
                } else {
                    stringArray[n3] = stringArray[n3].toLowerCase();
                    for (int i = 0; i < stringArray[n3].length(); ++i) {
                        char c = stringArray[n3].charAt(i);
                        if (Character.isLetterOrDigit(c) || '_' == c) continue;
                        n4 = -1;
                        break;
                    }
                }
                if (n4 < 0) break;
                if (hashSet.add(stringArray[n3])) continue;
                stringArray[n3] = stringArray[n3] + String.valueOf(n3);
            }
            if (n4 < 2) {
                return "Missing or bad field names for data file '" + tableFile.fileName + "'";
            }
            for (Object object2 : tableFile.requiredFields) {
                ((TableField)object2).index = -1;
            }
            Object object3 = new boolean[n4];
            object2 = new StringBuilder("CREATE TABLE ");
            ((StringBuilder)object2).append(tableFile.tableName);
            ((StringBuilder)object2).append(' ');
            int n5 = 40;
            for (n3 = 0; n3 < n4; ++n3) {
                String string2 = "VARCHAR(255)";
                object3[n3] = true;
                for (TableField tableField : tableFile.requiredFields) {
                    if (tableField.index >= 0 || !tableField.name.equals(stringArray[n3])) continue;
                    string2 = tableField.type;
                    object3[n3] = tableField.isText;
                    tableField.index = n3;
                    break;
                }
                ((StringBuilder)object2).append((char)n5);
                ((StringBuilder)object2).append(stringArray[n3]);
                ((StringBuilder)object2).append(' ');
                ((StringBuilder)object2).append(string2);
                n5 = 44;
            }
            for (TableField tableField : tableFile.requiredFields) {
                if (0 != tableField.version || tableField.index >= 0) continue;
                return "Required field '" + tableField.name + "' not found in data file '" + tableFile.fileName + "'";
            }
            if (null != tableFile.extraDefinitions && tableFile.extraDefinitions.length() > 0) {
                ((StringBuilder)object2).append((char)n5);
                ((StringBuilder)object2).append(tableFile.extraDefinitions);
            }
            ((StringBuilder)object2).append(')');
            dbConnection.update(((StringBuilder)object2).toString());
            bl = true;
            ((StringBuilder)object2).setLength(0);
            ((StringBuilder)object2).append("INSERT INTO " + tableFile.tableName + " VALUES (");
            int n6 = ((StringBuilder)object2).length();
            n2 = n;
            int n7 = 0;
            int n8 = -1;
            int n9 = 0;
            int n10 = -1;
            int n11 = -1;
            int n12 = 0;
            int n13 = 0;
            char c = '\u0000';
            boolean bl2 = true;
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = null;
            StringBuilder stringBuilder3 = null;
            HashSet<String> hashSet2 = null;
            if (null != dateCounter && null != tableFile.dateField) {
                n10 = tableFile.dateField.index;
                stringBuilder2 = new StringBuilder();
            }
            if (null != tableFile.keyField) {
                n11 = tableFile.keyField.index;
                stringBuilder3 = new StringBuilder();
                hashSet2 = new HashSet<String>();
            }
            while (true) {
                if ((n8 = tableFile.reader.read()) < 0) {
                    if (!(n7 <= 0 && bl2 || null == statusLogger)) {
                        statusLogger.logMessage("Partial row ignored at end of file");
                    }
                    if (((StringBuilder)object2).length() <= n6) break;
                    dbConnection.update(((StringBuilder)object2).toString());
                    break;
                }
                c = (char)n8;
                if ('|' == c) {
                    n9 = 2 == n9 ? 3 : 1;
                } else if (1 == n9) {
                    if ('^' == c) {
                        n9 = 2;
                        continue;
                    }
                    n9 = 0;
                } else {
                    n9 = 2 == n9 ? -1 : 0;
                }
                if (3 == n9) {
                    if (null != statusLogger && statusLogger.isCanceled()) {
                        string = "Import canceled";
                        break;
                    }
                    if (0 == n7 && bl2) continue;
                    if (n7 != n4) {
                        if (null != statusLogger) {
                            statusLogger.logMessage("Row ignored at line " + n + ", bad field count");
                        }
                        if (++n13 > 50) {
                            string = "Too many bad rows in data file '" + tableFile.fileName + "' at line " + n;
                            break;
                        }
                    } else if (bl3) {
                        if (n12 < 10 && null != statusLogger) {
                            statusLogger.logMessage("Row ignored at line " + n + ", duplicate key");
                        }
                        ++n12;
                    } else {
                        if (((StringBuilder)object2).length() > n6) {
                            ((StringBuilder)object2).append(",(");
                        }
                        ((StringBuilder)object2).append((CharSequence)stringBuilder);
                        ((StringBuilder)object2).append(')');
                        tableFile.rowCount++;
                        if (((StringBuilder)object2).length() > 500000) {
                            dbConnection.update(((StringBuilder)object2).toString());
                            ((StringBuilder)object2).setLength(n6);
                            n2 = n;
                        }
                    }
                    n7 = 0;
                    bl2 = true;
                    stringBuilder.setLength(0);
                    n9 = 0;
                    continue;
                }
                if (1 == n9) {
                    if (n7 < n4) {
                        if (bl2) {
                            if (object3[n7] != false) {
                                stringBuilder.append("''");
                            } else {
                                stringBuilder.append('0');
                            }
                        } else if (object3[n7] != false) {
                            stringBuilder.append('\'');
                        }
                        if (n7 < n4 - 1) {
                            stringBuilder.append(',');
                        }
                        if (n10 == n7) {
                            dateCounter.add(stringBuilder2.toString());
                            stringBuilder2.setLength(0);
                        }
                        if (n11 == n7) {
                            bl3 = !hashSet2.add(stringBuilder3.toString());
                            stringBuilder3.setLength(0);
                        }
                    }
                    ++n7;
                    bl2 = true;
                    continue;
                }
                if ('\n' != c && '\r' != c && n7 < n4) {
                    if (bl2 && object3[n7] != false) {
                        stringBuilder.append('\'');
                    }
                    if (-1 == n9) {
                        stringBuilder.append('^');
                        n9 = 0;
                    }
                    switch (c) {
                        case '\'': {
                            stringBuilder.append("''");
                            break;
                        }
                        case '\\': {
                            stringBuilder.append("\\\\");
                            break;
                        }
                        default: {
                            stringBuilder.append(c);
                        }
                    }
                    if (n10 == n7) {
                        stringBuilder2.append(c);
                    }
                    if (n11 == n7) {
                        stringBuilder3.append(c);
                    }
                    bl2 = false;
                    continue;
                }
                if ('\n' != c) continue;
                ++n;
            }
            if (n12 > 10 && null != statusLogger) {
                statusLogger.logMessage(String.valueOf(n12) + " rows total ignored with duplicate keys");
            }
        }
        catch (IOException iOException) {
            string = "An I/O error occurred on data file '" + tableFile.fileName + "' at line " + n + ":\n" + iOException;
        }
        catch (SQLException sQLException) {
            string = n2 > 0 ? "A database error occurred on data file '" + tableFile.fileName + "' between lines " + n2 + " and " + n + ":\n" + sQLException : "A database error occurred on data file '" + tableFile.fileName + "' at line " + n + ":\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        catch (Throwable throwable) {
            string = "An unexpected error occurred on data file '" + tableFile.fileName + "' at line " + n + ":\n" + throwable;
            AppCore.log(3, "Unexpected error", throwable);
        }
        if (null != string && bl) {
            try {
                dbConnection.update("DROP TABLE " + tableFile.tableName);
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
        }
        return string;
    }

    public static void renameDatabase(String string, Integer n, String string2) {
        ExtDb.renameDatabase(string, n, string2, null);
    }

    public static void renameDatabase(String string, Integer n, String string2, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return;
        }
        boolean bl = false;
        String string3 = null;
        try {
            dbConnection.update("LOCK TABLES ext_db WRITE");
            if (string2.length() > 0) {
                dbConnection.query("SELECT ext_db_key FROM ext_db WHERE NOT deleted AND UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "' AND ext_db_key <> " + n);
                if (dbConnection.next()) {
                    string2 = string2 + " " + String.valueOf('#') + String.valueOf(n);
                }
                dbConnection.update("UPDATE ext_db SET name = '" + DbConnection.clean(string2) + "', is_download = false WHERE ext_db_key = " + n);
            } else {
                dbConnection.update("UPDATE ext_db SET name = '', is_download = false WHERE ext_db_key = " + n);
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string3 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl && null != errorLogger) {
            errorLogger.reportError(string3);
        }
        ExtDb.reloadCache(string);
    }

    public static void clearBadDataFlag(String string, Integer n) {
        ExtDb.renameDatabase(string, n, null);
    }

    public static void clearBadDataFlag(String string, Integer n, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return;
        }
        boolean bl = false;
        String string2 = null;
        try {
            dbConnection.update("LOCK TABLES ext_db WRITE");
            dbConnection.update("UPDATE ext_db SET bad_data = false WHERE ext_db_key = " + n);
        }
        catch (SQLException sQLException) {
            bl = true;
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl && null != errorLogger) {
            errorLogger.reportError(string2);
        }
        ExtDb.reloadCache(string);
    }

    public static void deleteDatabase(String string, Integer n) {
        ExtDb.deleteDatabase(string, n, null);
    }

    public static void deleteDatabase(String string, Integer n, ErrorLogger errorLogger) {
        if (n >= 10000 && n <= 19999) {
            return;
        }
        ExtDb extDb = ExtDb.getExtDb(string, n, errorLogger);
        if (null == extDb || extDb.deleted) {
            return;
        }
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return;
        }
        boolean bl = false;
        String string2 = "";
        try {
            dbConnection.update("LOCK TABLES ext_db WRITE");
            dbConnection.query("SELECT locked, deleted FROM ext_db WHERE ext_db_key = " + n);
            if (dbConnection.next()) {
                if (dbConnection.getBoolean(1)) {
                    string2 = "The station data is in use and cannot be deleted";
                    bl = true;
                } else if (!dbConnection.getBoolean(2)) {
                    dbConnection.update("UPDATE ext_db SET deleted = true, is_download = false, name = '' WHERE ext_db_key = " + n);
                }
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (bl && null != errorLogger) {
            errorLogger.reportError(string2);
        }
        ExtDb.reloadCache(string);
    }

    public static synchronized void closeDb(String string) {
        DbConnection dbConnection = DbCore.connectDb(string);
        if (null != dbConnection) {
            try {
                String string2 = DbCore.getDbName(string);
                HashSet<String> hashSet = new HashSet<String>();
                for (String string3 : ExtDb.getDbBaseNames()) {
                    dbConnection.query("SHOW DATABASES LIKE '" + string2 + "\\_" + string3 + "%'");
                    while (dbConnection.next()) {
                        hashSet.add(dbConnection.getString(1));
                    }
                }
                dbConnection.update("LOCK TABLES ext_db WRITE");
                HashSet hashSet2 = new HashSet();
                dbConnection.query("SELECT ext_db_key, db_type, locked FROM ext_db WHERE NOT deleted");
                while (dbConnection.next()) {
                    int n = dbConnection.getInt(1);
                    if (hashSet.remove(ExtDb.makeDbName(string2, dbConnection.getInt(2), n))) continue;
                    hashSet2.add(n);
                }
                if (!hashSet2.isEmpty()) {
                    dbConnection.update("UPDATE ext_db SET deleted = true, is_download = false, name = '' WHERE ext_db_key IN " + DbConnection.makeKeyList(hashSet2));
                }
                dbConnection.update("UNLOCK TABLES");
                for (String string4 : hashSet) {
                    dbConnection.update("DROP DATABASE IF EXISTS " + string4);
                }
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError(sQLException);
            }
            DbCore.releaseDb(dbConnection);
        }
        dbCache.remove(string);
        mrCache.remove(string);
        lmsLiveDbCache.remove(string);
    }

    static {
        reservedKeyNames.put(10102, "Most recent LMS");
        reservedKeyNames.put(10103, "Most recent CDBS TV");
        reservedKeyNames.put(10104, "Most recent CDBS FM");
        reservedKeyNames.put(10005, "LMS live server");
        listeners = new HashMap();
        dbCache = new HashMap();
        mrCache = new HashMap();
        cacheLastUpdate = new HashMap();
        lmsLiveDbCache = new HashMap();
        downloadInProgress = false;
        CDBSFieldNamesMap = null;
    }

    private static class DateCounter {
        private SimpleDateFormat dateFormat;
        private Date latestDate;
        private int latestDateCount;

        private DateCounter(String string) {
            this.dateFormat = new SimpleDateFormat(string, Locale.US);
            this.latestDate = new Date(0L);
            this.latestDateCount = 0;
        }

        private void add(String string) {
            Date date = null;
            try {
                date = this.dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (null != date && !date.before(this.latestDate)) {
                if (date.after(this.latestDate)) {
                    this.latestDate.setTime(date.getTime());
                    this.latestDateCount = 1;
                } else {
                    ++this.latestDateCount;
                }
            }
        }

        private String getDate() {
            if (this.latestDateCount > 0) {
                return this.dateFormat.format(this.latestDate);
            }
            return "(unknown)";
        }

        private String getCount() {
            return String.valueOf(this.latestDateCount);
        }

        private Date getDbDate() {
            return this.latestDate;
        }
    }

    private static class TableField {
        private String name;
        private String type;
        private boolean isText;
        private int version;
        private int index;

        private TableField(String string, String string2, boolean bl, int n) {
            this.name = string;
            this.type = string2;
            this.isText = bl;
            this.version = n;
            this.index = -1;
        }
    }

    private static class TableFile {
        private static final char SEPARATOR = '|';
        private static final char TERMINATOR = '^';
        private static final int MAX_ROWS_IGNORED = 50;
        private static final int MAX_DUPLICATES_LOGGED = 10;
        private String tableName;
        private String[] fieldNames;
        private String extraDefinitions;
        private TableField dateField;
        private TableField keyField;
        private boolean required;
        private int version;
        private ArrayList<TableField> requiredFields;
        private ArrayList<TableField> indexFields;
        private String fileName;
        private File dataFile;
        private InputStream zipStream;
        private BufferedReader reader;
        private int rowCount;

        private TableFile(String string, String[] stringArray, File file, ZipFile zipFile, boolean bl) {
            this.required = bl;
            this.doInit(string, stringArray, file, zipFile);
        }

        private TableFile(String string, String[] stringArray, File file, ZipFile zipFile, int n) {
            this.version = n;
            this.doInit(string, stringArray, file, zipFile);
        }

        private void doInit(String string, String[] stringArray, File file, ZipFile zipFile) {
            this.tableName = string;
            this.fieldNames = stringArray;
            this.requiredFields = new ArrayList();
            this.indexFields = new ArrayList();
            this.fileName = string + ".dat";
            if (null != file) {
                this.dataFile = new File(file, this.fileName);
            } else if (null != zipFile) {
                try {
                    ZipEntry zipEntry = zipFile.getEntry(this.fileName);
                    if (null != zipEntry) {
                        this.zipStream = zipFile.getInputStream(zipEntry);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void setExtraDefinitions(String string) {
            this.extraDefinitions = string;
        }

        private void setDateField(TableField tableField) {
            this.dateField = tableField;
        }

        private void setKeyField(TableField tableField) {
            this.keyField = tableField;
        }

        private TableField addRequiredField(String string, String string2, boolean bl) {
            TableField tableField = new TableField(string, string2, bl, 0);
            this.requiredFields.add(tableField);
            return tableField;
        }

        private TableField addRequiredField(String string, String string2, boolean bl, int n) {
            TableField tableField = new TableField(string, string2, bl, n);
            this.requiredFields.add(tableField);
            return tableField;
        }

        private TableField addRequiredFieldWithIndex(String string, String string2, boolean bl) {
            TableField tableField = new TableField(string, string2, bl, 0);
            this.requiredFields.add(tableField);
            this.indexFields.add(tableField);
            return tableField;
        }

        private boolean openFile() {
            block4: {
                this.closeFile();
                try {
                    if (null != this.dataFile) {
                        this.reader = new BufferedReader(new FileReader(this.dataFile));
                        break block4;
                    }
                    if (null != this.zipStream) {
                        this.reader = new BufferedReader(new InputStreamReader(this.zipStream));
                        break block4;
                    }
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            return true;
        }

        private void closeFile() {
            if (null != this.reader) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.reader = null;
            }
        }

        private void createAllIndex(DbConnection dbConnection) throws SQLException {
            for (TableField tableField : this.indexFields) {
                dbConnection.update("CREATE INDEX " + this.tableName + "_" + tableField.name + " ON " + this.tableName + " (" + tableField.name + ")");
            }
        }
    }

    private static class ExtDbRecordWL
    extends ExtDbRecord {
        private static final String WIRELESS_BASE_TABLE = "base_station";
        private static final String WIRELESS_INDEX_TABLE = "antenna_index";
        private static final String WIRELESS_PATTERN_TABLE = "antenna_pattern";
        private String cellSiteID;
        private String sectorID;
        private String referenceNumber;

        private static ArrayList<ExtDbRecordWL> getAllRecords(DbConnection dbConnection, Service service, Country country) throws SQLException {
            ArrayList<ExtDbRecordWL> arrayList = new ArrayList<ExtDbRecordWL>();
            dbConnection.query("SELECT cell_key,cell_site_id,sector_id,cell_lat,cell_lon,rc_amsl,haat,erp,az_ant_id,orientation,el_ant_id,e_tilt,m_tilt, m_tilt_orientation, reference_number, city, state, country FROM base_station");
            while (dbConnection.next()) {
                int n = dbConnection.getInt(1);
                if (n <= 0) continue;
                String string = String.valueOf(n);
                double d = dbConnection.getDouble(4);
                double d2 = dbConnection.getDouble(5);
                ExtDbRecordWL extDbRecordWL = new ExtDbRecordWL();
                extDbRecordWL.extRecordID = string;
                extDbRecordWL.service = service;
                String string2 = dbConnection.getString(2);
                if (null == string2) {
                    string2 = "";
                } else if (string2.length() > 12) {
                    string2 = string2.substring(0, 12);
                }
                extDbRecordWL.cellSiteID = string2;
                string2 = dbConnection.getString(3);
                if (null == string2) {
                    string2 = "";
                } else if (string2.length() > 3) {
                    string2 = string2.substring(0, 3);
                }
                extDbRecordWL.sectorID = string2;
                extDbRecordWL.location.setLatLon(d, d2);
                extDbRecordWL.heightAMSL = dbConnection.getDouble(6);
                extDbRecordWL.overallHAAT = dbConnection.getDouble(7);
                extDbRecordWL.peakERP = dbConnection.getDouble(8);
                int n2 = dbConnection.getInt(9);
                if (n2 > 0) {
                    extDbRecordWL.antennaID = extDbRecordWL.antennaRecordID = String.valueOf(n2);
                }
                extDbRecordWL.horizontalPatternOrientation = Math.IEEEremainder(dbConnection.getDouble(10), 360.0);
                if (extDbRecordWL.horizontalPatternOrientation < 0.0) {
                    extDbRecordWL.horizontalPatternOrientation += 360.0;
                }
                if ((n2 = dbConnection.getInt(11)) > 0) {
                    extDbRecordWL.elevationAntennaRecordID = String.valueOf(n2);
                }
                extDbRecordWL.verticalPatternElectricalTilt = dbConnection.getDouble(12);
                extDbRecordWL.verticalPatternMechanicalTilt = dbConnection.getDouble(13);
                extDbRecordWL.verticalPatternMechanicalTiltOrientation = Math.IEEEremainder(dbConnection.getDouble(14), 360.0);
                if (extDbRecordWL.verticalPatternMechanicalTiltOrientation < 0.0) {
                    extDbRecordWL.verticalPatternMechanicalTiltOrientation += 360.0;
                }
                extDbRecordWL.referenceNumber = dbConnection.getString(15);
                extDbRecordWL.city = dbConnection.getString(16);
                extDbRecordWL.state = dbConnection.getString(17);
                extDbRecordWL.country = Country.getCountry(dbConnection.getString(18));
                if (null == extDbRecordWL.country) {
                    extDbRecordWL.country = country;
                }
                arrayList.add(extDbRecordWL);
            }
            return arrayList;
        }

        private static ArrayList<AntPattern.AntPoint> getAntennaPatternWL(DbConnection dbConnection, String string) throws SQLException {
            ArrayList<AntPattern.AntPoint> arrayList = new ArrayList<AntPattern.AntPoint>();
            dbConnection.query("SELECT degree, relative_field FROM antenna_pattern WHERE ant_id = " + string + " ORDER BY 1");
            double d = -1.0;
            double d2 = 0.001;
            boolean bl = false;
            while (dbConnection.next()) {
                double d3 = Math.rint(dbConnection.getDouble(1) * 1000.0) / 1000.0;
                if (d3 < 0.0 || d3 > 359.999) {
                    bl = true;
                    break;
                }
                if (d3 <= d) {
                    bl = true;
                    break;
                }
                d = d3;
                double d4 = Math.rint(dbConnection.getDouble(2) * 1000.0) / 1000.0;
                if (d4 < 0.001) {
                    d4 = 0.001;
                }
                if (d4 > 1.0) {
                    bl = true;
                    break;
                }
                if (d4 > d2) {
                    d2 = d4;
                }
                arrayList.add(new AntPattern.AntPoint(d3, d4));
            }
            if (bl || arrayList.size() < 2 || d2 < 0.5) {
                arrayList = null;
            }
            return arrayList;
        }

        private static ArrayList<AntPattern.AntPoint> getElevationPatternWL(DbConnection dbConnection, String string) throws SQLException {
            ArrayList<AntPattern.AntPoint> arrayList = new ArrayList<AntPattern.AntPoint>();
            dbConnection.query("SELECT degree, relative_field FROM antenna_pattern WHERE ant_id = " + string + " ORDER BY 1");
            double d = -91.0;
            double d2 = 0.001;
            boolean bl = false;
            boolean bl2 = true;
            while (dbConnection.next()) {
                double d3 = Math.rint(dbConnection.getDouble(1) * 1000.0) / 1000.0;
                if (d3 < -90.0 || d3 > 90.0) {
                    bl = true;
                    break;
                }
                if (d3 <= d) {
                    bl = true;
                    break;
                }
                d = d3;
                double d4 = Math.rint(dbConnection.getDouble(2) * 1000.0) / 1000.0;
                if (d4 < 0.001) {
                    d4 = 0.001;
                } else {
                    bl2 = false;
                }
                if (d4 > 1.0) {
                    bl = true;
                    break;
                }
                if (d4 > d2) {
                    d2 = d4;
                }
                arrayList.add(new AntPattern.AntPoint(d3, d4));
            }
            if (bl || arrayList.size() < 2 || d2 < 0.5 || bl2) {
                arrayList = null;
            }
            return arrayList;
        }

        private ExtDbRecordWL() {
            super(null, 2);
        }

        private void updateSource(DbConnection dbConnection, SourceEditDataWL sourceEditDataWL) throws SQLException {
            ArrayList<AntPattern.AntPoint> arrayList;
            String string;
            sourceEditDataWL.callSign = this.cellSiteID;
            sourceEditDataWL.sectorID = this.sectorID;
            sourceEditDataWL.city = this.city;
            sourceEditDataWL.state = this.state;
            sourceEditDataWL.fileNumber = this.referenceNumber;
            sourceEditDataWL.location.setLatLon(this.location);
            sourceEditDataWL.heightAMSL = this.heightAMSL;
            sourceEditDataWL.overallHAAT = this.overallHAAT;
            sourceEditDataWL.peakERP = this.peakERP;
            if (null != this.antennaRecordID) {
                string = null;
                dbConnection.query("SELECT name FROM antenna_index WHERE ant_id = " + this.antennaRecordID);
                if (dbConnection.next() && (string = dbConnection.getString(1)).length() > 255) {
                    string = string.substring(0, 255);
                }
                if (null != string && null != (arrayList = ExtDbRecordWL.getAntennaPatternWL(dbConnection, this.antennaRecordID))) {
                    sourceEditDataWL.antennaID = this.antennaID;
                    sourceEditDataWL.hasHorizontalPattern = true;
                    sourceEditDataWL.horizontalPattern = new AntPattern(sourceEditDataWL.dbID, 1, string, arrayList);
                    sourceEditDataWL.horizontalPatternChanged = true;
                }
            }
            sourceEditDataWL.horizontalPatternOrientation = this.horizontalPatternOrientation;
            if (null != this.elevationAntennaRecordID) {
                string = null;
                dbConnection.query("SELECT name FROM antenna_index WHERE ant_id = " + this.elevationAntennaRecordID);
                if (dbConnection.next() && (string = dbConnection.getString(1)).length() > 255) {
                    string = string.substring(0, 255);
                }
                if (null != string && null != (arrayList = ExtDbRecordWL.getElevationPatternWL(dbConnection, this.elevationAntennaRecordID))) {
                    sourceEditDataWL.hasVerticalPattern = true;
                    sourceEditDataWL.verticalPattern = new AntPattern(sourceEditDataWL.dbID, 2, string, arrayList);
                    sourceEditDataWL.verticalPatternChanged = true;
                }
            }
            sourceEditDataWL.verticalPatternElectricalTilt = this.verticalPatternElectricalTilt;
            sourceEditDataWL.verticalPatternMechanicalTilt = this.verticalPatternMechanicalTilt;
            sourceEditDataWL.verticalPatternMechanicalTiltOrientation = this.verticalPatternMechanicalTiltOrientation;
        }
    }

    public static class PatternID {
        public ExtDb extDb;
        public String antennaRecordID;
        public int type;
        public boolean isMatrix;
        public String name;
    }

    private static class DbListItem
    extends KeyedRecord {
        private final int type;

        private DbListItem(int n, String string, int n2) {
            super(n, string);
            this.type = n2;
        }
    }
}

