/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import java.io.PrintStream;

public class ErrorLogger {
    protected PrintStream errorStream;
    protected StringBuilder errorLog;
    protected boolean errorsReported;
    protected int lastErrorType = 1;
    protected StringBuilder messageLog;

    public ErrorLogger() {
        this.errorLog = new StringBuilder();
    }

    public ErrorLogger(StringBuilder stringBuilder) {
        this.errorLog = stringBuilder;
    }

    public ErrorLogger(PrintStream printStream) {
        this.errorStream = printStream;
        this.errorLog = new StringBuilder();
    }

    public ErrorLogger(PrintStream printStream, StringBuilder stringBuilder) {
        this.errorStream = printStream;
        this.errorLog = stringBuilder;
    }

    public synchronized void closeStream() {
        if (null != this.errorStream) {
            try {
                this.errorStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.errorStream = null;
        }
    }

    public void reportError(String string, int n) {
        this.doReportError(string, n);
    }

    public void reportError(String string) {
        this.doReportError(string, 3);
    }

    public void reportWarning(String string) {
        this.doReportError(string, 2);
    }

    public void reportMessage(String string) {
        this.doReportError(string, 1);
    }

    protected synchronized void doReportError(String string, int n) {
        if (null != this.errorStream || null != this.errorLog) {
            StringBuilder stringBuilder = new StringBuilder();
            switch (n) {
                case 3: {
                    stringBuilder.append("ERROR: ");
                    break;
                }
                case 2: {
                    stringBuilder.append("Warning: ");
                }
            }
            stringBuilder.append(string);
            stringBuilder.append('\n');
            if (null != this.errorStream) {
                this.errorStream.append(stringBuilder);
            }
            if (null != this.errorLog) {
                this.errorLog.append((CharSequence)stringBuilder);
            }
        }
        this.errorsReported = true;
        this.lastErrorType = n;
    }

    public void reportValidationError(String string) {
        this.doReportError(string, 2);
    }

    public synchronized String toString() {
        if (null != this.errorLog) {
            return this.errorLog.toString();
        }
        return "";
    }

    public synchronized void clearErrors() {
        this.errorsReported = false;
        this.lastErrorType = 1;
    }

    public synchronized boolean hasErrors() {
        return this.errorsReported;
    }

    public synchronized int getLastErrorType() {
        return this.lastErrorType;
    }

    public synchronized void logMessage(String string) {
        if (null == this.messageLog) {
            this.messageLog = new StringBuilder(string);
        } else {
            this.messageLog.append('\n');
            this.messageLog.append(string);
        }
    }

    public synchronized boolean hasMessages() {
        return null != this.messageLog;
    }

    public synchronized String getMessages() {
        if (null == this.messageLog) {
            return "";
        }
        return this.messageLog.toString();
    }

    public synchronized void clearMessages() {
        this.messageLog = null;
    }
}

