/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AppCore;
import java.util.ArrayList;

public class AppTask {
    public static final long MAX_WAIT_TIME = 2000L;
    private static final double MAX_MEMORY_LOAD = 1.001;
    private static ArrayList<AppTask> waitingQueue = new ArrayList();
    private static ArrayList<AppTask> runningList = new ArrayList();
    private static double currentMemoryLoad = 0.0;
    private static int currentCPULoad = 0;
    private double memoryLoad;
    private int cpuLoad;
    private long lastPollTime;

    public static synchronized boolean canTaskStart(AppTask appTask) {
        long l;
        if (runningList.contains(appTask)) {
            return true;
        }
        appTask.lastPollTime = l = System.currentTimeMillis();
        boolean bl = true;
        int n = waitingQueue.indexOf(appTask);
        if (currentMemoryLoad + appTask.memoryLoad <= 1.001 && currentCPULoad + appTask.cpuLoad <= AppCore.availableCPUCount) {
            if (!waitingQueue.isEmpty() && 0 != n) {
                int n2 = n < 0 ? waitingQueue.size() : n;
                for (int i = 0; i < n2; ++i) {
                    AppTask appTask2 = waitingQueue.get(i);
                    if (l - appTask2.lastPollTime > 2000L) {
                        waitingQueue.remove(i);
                        --i;
                        --n2;
                        continue;
                    }
                    if (!(currentMemoryLoad + appTask2.memoryLoad <= 1.001) || currentCPULoad + appTask2.cpuLoad > AppCore.availableCPUCount) continue;
                    bl = false;
                    break;
                }
            }
        } else {
            bl = false;
        }
        if (bl) {
            if (n >= 0) {
                waitingQueue.remove(n);
            }
            currentMemoryLoad += appTask.memoryLoad;
            currentCPULoad += appTask.cpuLoad;
            runningList.add(appTask);
        } else if (n < 0) {
            waitingQueue.add(appTask);
        }
        return bl;
    }

    public static synchronized void bumpTask(AppTask appTask) {
        if (runningList.contains(appTask)) {
            return;
        }
        appTask.lastPollTime = System.currentTimeMillis();
        waitingQueue.remove(appTask);
        waitingQueue.add(0, appTask);
    }

    public static synchronized void taskDone(AppTask appTask) {
        waitingQueue.remove(appTask);
        if (runningList.remove(appTask)) {
            if (runningList.isEmpty()) {
                currentMemoryLoad = 0.0;
                currentCPULoad = 0;
            } else {
                currentMemoryLoad -= appTask.memoryLoad;
                currentCPULoad -= appTask.cpuLoad;
            }
        }
    }

    public static boolean isResourceAvailable(double d) {
        return AppTask.isResourceAvailable(d, 1);
    }

    public static boolean isResourceAvailable(double d, int n) {
        return currentMemoryLoad + d <= 1.001 && currentCPULoad + n <= AppCore.availableCPUCount;
    }

    public AppTask(double d) {
        this.memoryLoad = d;
        if (this.memoryLoad < 0.0) {
            this.memoryLoad = 0.0;
        }
        if (this.memoryLoad > 1.0) {
            this.memoryLoad = 1.0;
        }
        this.cpuLoad = 1;
    }

    public AppTask(double d, int n) {
        this.memoryLoad = d;
        if (this.memoryLoad < 0.0) {
            this.memoryLoad = 0.0;
        }
        if (this.memoryLoad > 1.0) {
            this.memoryLoad = 1.0;
        }
        this.cpuLoad = n;
        if (this.cpuLoad < 1) {
            this.cpuLoad = 1;
        }
        if (this.cpuLoad > AppCore.availableCPUCount) {
            this.cpuLoad = AppCore.availableCPUCount;
        }
    }
}

