/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AppCore {
    public static final String APP_VERSION_STRING = "2.3.0";
    public static final int APP_VERSION = 203000;
    public static String appVersionString = "2.3.0 (PH1km1)";
    public static final int XML_VERSION = 105000;
    public static final String STUDY_ENGINE_NAME = "tvstudy";
    public static final String STUDY_ENGINE_REPORT = "tvstudy.txt";
    public static final String ENGINE_PROMPT_PREFIX = "#*#*#";
    public static final String ENGINE_MESSAGE_PREFIX = "$$";
    public static final int ENGINE_MESSAGE_PREFIX_LENGTH = 2;
    public static final String ENGINE_PROGRESS_KEY = "progress";
    public static final String ENGINE_FILE_KEY = "outfile";
    public static final String ENGINE_REPORT_KEY = "report";
    public static final String ENGINE_RUNCOUNT_KEY = "runcount";
    public static final String ENGINE_RESULT_KEY = "result";
    public static final String ENGINE_PID_KEY = "pid";
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int ERROR_MESSAGE = 3;
    public static boolean Debug = null != System.getProperty("DEBUG");
    public static boolean showImageOptions = false;
    public static Path workingDirectoryPath;
    public static final String LIB_DIRECTORY_NAME = "lib";
    public static final String DATA_DIRECTORY_NAME = "data";
    public static final String XML_DIRECTORY_NAME = "xml";
    public static final String DBASE_DIRECTORY_NAME = "dbase";
    public static final String CACHE_DIRECTORY_NAME = "cache";
    public static final String HELP_DIRECTORY_NAME = "help";
    public static final String OUT_DIRECTORY_NAME = "out";
    public static Path libDirectoryPath;
    public static Path dataDirectoryPath;
    public static Path xmlDirectoryPath;
    public static Path dbaseDirectoryPath;
    public static Path cacheDirectoryPath;
    public static Path helpDirectoryPath;
    public static Path outDirectoryPath;
    public static String studyOutDirectory;
    private static final String LOGGER_NAME = "gov.fcc.tvstudy";
    private static final String LOG_FILE_NAME = "tvstudy_err.log";
    private static Logger logger;
    private static final String CONFIG_FILE_NAME = "config.props";
    private static Properties configProperties;
    public static final String CONFIG_SHOW_DB_NAME = "showDbName";
    public static final String CONFIG_MYSQL_SOCKET_FILE = "mysqlSocketFile";
    public static final String CONFIG_SHOW_CREATE_RESULT_TABLES = "showCreateResultTables";
    public static final String CONFIG_HIDE_USER_RECORD_DELETE = "hideUserRecordDelete";
    public static final String CONFIG_ALLOW_FREQUENCY_EDIT = "allowFrequencyEdit";
    public static final String CONFIG_LMS_DOWNLOAD_URL = "lmsDownloadURL";
    public static final String CONFIG_AUTO_DELETE_PREVIOUS_DOWNLOAD = "autoDeletePreviousDownload";
    public static final String CONFIG_LMS_BASELINE_DATE = "lmsBaselineDate";
    public static final String CONFIG_TVIX_WINDOW_END_DATE = "ixCheckFilingWindowEndDate";
    public static final String CONFIG_TVIX_PROTECT_PRE_BASELINE_DEFAULT = "ixCheckProtectPreBaselineDefault";
    public static final String CONFIG_TVIX_INCLUDE_FOREIGN_DEFAULT = "ixCheckIncludeForeignDefault";
    public static final String CONFIG_TVIX_DEFAULT_CELL_SIZE = "ixCheckDefaultCellSize";
    public static final String CONFIG_TVIX_DEFAULT_PROFILE_RESOLUTION = "ixCheckDefaultProfileResolution";
    public static final String CONFIG_TVIX_DEFAULT_CELL_SIZE_LPTV = "ixCheckDefaultCellSizeLPTV";
    public static final String CONFIG_TVIX_DEFAULT_PROFILE_RESOLUTION_LPTV = "ixCheckDefaultProfileResolutionLPTV";
    public static final String CONFIG_TVIX_AM_SEARCH_DISTANCE_ND = "ixCheckAMSearchDistanceND";
    public static final String CONFIG_TVIX_AM_SEARCH_DISTANCE_DA = "ixCheckAMSearchDistanceDA";
    private static final String PROPS_FILE_NAME = "tvstudy.props";
    private static Properties localProperties;
    private static Path propsPath;
    public static final String PREF_CACHE_DIRECTORY = "cacheDirectory";
    public static final String PREF_OUT_DIRECTORY = "outDirectory";
    public static final String PREF_DEFAULT_ENGINE_MEMORY_LIMIT = "defaultEngineMemoryLimit";
    public static final String PREF_TVIX_DEFAULT_CP_EXCLUDES_BL = "ixCheckDefaultCPExcludesBL";
    public static final String PREF_TVIX_DEFAULT_EXCLUDE_NEW_LPTV = "ixCheckDefaultExcludeNewLPTV";
    public static final String PREF_STUDY_MANAGER_NAME_COLUMN_FIRST = "studyManagerNameColumnFirst";
    public static final String PREF_USE_SCREEN_MENU_BAR = "useScreenMenuBar";
    public static final String LAST_FILE_DIRECTORY_KEY = "last_file_directory";
    public static final String API_PROPS_FILE_NAME = "api_login.props";
    private static final long SOURCE_CACHE_SPACE_NEEDED = 2000000L;
    public static int availableCPUCount;
    public static String engineVersionString;
    public static int maxEngineProcessCount;
    public static ArrayList<KeyedRecord> propagationModels;
    public static final char[] TEXT_FILE_COMMENT_PREFIX;
    public static final char TEXT_FILE_METADATA_PREFIX = '$';
    public static final char TEXT_FILE_METADATA_SEPARATOR = '=';
    private static final String FILE_VERSION_COMMENT_PREFIX = "#";
    private static final String FILE_VERSION_PREFIX = "#$version=";
    private static final String FILE_VERSION_XML_COMMENT_PREFIX = "<!--";
    private static final String FILE_VERSION_XML_PREFIX = "<!--$version=";
    public static final String FILE_CHECK_LIST_FILE = "versions.dat";
    public static final int FILE_CHECK_MINIMUM_VERSION = 16;
    public static int fileCheckVersion;
    public static String fileCheckID;
    public static String fileCheckError;
    public static final String FILE_PATH_SEPARATOR = "/";
    private static boolean didInit;
    private static Pattern latLonPattern;
    public static final int MAX_DECIMAL_PREC = 8;
    private static NumberFormat decimalFormatter;
    private static NumberFormat iCountFormatter;
    private static NumberFormat dCountFormatter;
    private static final DateFormat dateTimeFormatter;
    private static final DateFormat dateFormatter;
    private static final DateFormat[] dateParsers;
    private static final DateFormat dayFormatter;
    private static SimpleDateFormat timestampFormatter;
    private static SAXParserFactory parserFactory;

    public static synchronized void initialize(String string, boolean bl, boolean bl2) {
        int n;
        Object object;
        BufferedReader bufferedReader;
        block42: {
            if (didInit) {
                return;
            }
            didInit = true;
            workingDirectoryPath = Paths.get(string, new String[0]).toAbsolutePath();
            libDirectoryPath = workingDirectoryPath.resolve(LIB_DIRECTORY_NAME);
            dataDirectoryPath = workingDirectoryPath.resolve(DATA_DIRECTORY_NAME);
            xmlDirectoryPath = workingDirectoryPath.resolve(XML_DIRECTORY_NAME);
            dbaseDirectoryPath = workingDirectoryPath.resolve(DBASE_DIRECTORY_NAME);
            cacheDirectoryPath = workingDirectoryPath.resolve(CACHE_DIRECTORY_NAME);
            helpDirectoryPath = workingDirectoryPath.resolve(HELP_DIRECTORY_NAME);
            outDirectoryPath = workingDirectoryPath.resolve(OUT_DIRECTORY_NAME);
            studyOutDirectory = OUT_DIRECTORY_NAME;
            OutputStream outputStream = null;
            try {
                outputStream = Files.newOutputStream(libDirectoryPath.resolve(LOG_FILE_NAME), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                logger.addHandler(new StreamHandler(outputStream, new LogFormatter()));
            }
            catch (Throwable throwable) {
                AppCore.log(3, "Could not initialize logger: ", throwable);
            }
            if (null != outputStream && bl) {
                System.setErr(new PrintStream(outputStream, true));
            }
            String string2 = null;
            bufferedReader = null;
            try {
                String string3;
                string2 = string3 = "lib/versions.dat";
                try {
                    bufferedReader = Files.newBufferedReader(libDirectoryPath.resolve(FILE_CHECK_LIST_FILE));
                }
                catch (IOException iOException) {
                    throw new FileNotFoundException(iOException.getMessage());
                }
                fileCheckVersion = AppCore.getFileVersion(bufferedReader);
                if (fileCheckVersion < 16) {
                    fileCheckError = "File check failed, '" + string3 + "' is the wrong version";
                    break block42;
                }
                fileCheckID = AppCore.readLineSkipComments(bufferedReader);
                if (null == fileCheckID) {
                    fileCheckError = "File check failed, bad format in '" + string3 + "'";
                    break block42;
                }
                while (null != (string2 = AppCore.readLineSkipComments(bufferedReader))) {
                    object = AppCore.readLineSkipComments(bufferedReader);
                    int n2 = 0;
                    if (null != object) {
                        try {
                            n2 = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (n2 <= 0) {
                        fileCheckError = "File check failed, bad format in '" + string3 + "'";
                    } else {
                        n = string2.toLowerCase().endsWith(".xml") ? AppCore.getXMLFileVersion(AppCore.getSupportFilePath(string2)) : AppCore.getFileVersion(AppCore.getSupportFilePath(string2));
                        if (n == n2) continue;
                        fileCheckError = "File check failed, '" + string2 + "' is the wrong version";
                    }
                    break;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileCheckError = "File check failed, '" + string2 + "' not found";
            }
            catch (IOException iOException) {
                fileCheckError = "File check failed, I/O error:\n" + iOException.getMessage();
            }
        }
        try {
            if (null != bufferedReader) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null != fileCheckError) {
            fileCheckVersion = 0;
            fileCheckID = "(failed)";
        }
        try {
            object = Files.newInputStream(libDirectoryPath.resolve(CONFIG_FILE_NAME), new OpenOption[0]);
            configProperties.load((InputStream)object);
            ((InputStream)object).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        propsPath = libDirectoryPath.resolve(PROPS_FILE_NAME);
        try {
            object = Files.newInputStream(propsPath, new OpenOption[0]);
            localProperties.load((InputStream)object);
            ((InputStream)object).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string4 = AppCore.getPreference(PREF_CACHE_DIRECTORY);
        if (null != string4 && !(cacheDirectoryPath = Paths.get(string4, new String[0])).isAbsolute()) {
            cacheDirectoryPath = workingDirectoryPath.resolve(string4);
        }
        if (null != (string4 = AppCore.getPreference(PREF_OUT_DIRECTORY))) {
            studyOutDirectory = string4;
            outDirectoryPath = Paths.get(string4, new String[0]);
            if (!outDirectoryPath.isAbsolute()) {
                outDirectoryPath = workingDirectoryPath.resolve(string4);
            }
        }
        if (!bl2) {
            return;
        }
        maxEngineProcessCount = -1;
        n = 1;
        try {
            String string5;
            ProcessBuilder processBuilder = new ProcessBuilder(libDirectoryPath.resolve(STUDY_ENGINE_NAME).toString(), "-q");
            Map<String, String> map = processBuilder.environment();
            String string6 = map.get("DYLD_LIBRARY_PATH");
            if (null == string6) {
                string6 = map.get("LD_LIBRARY_PATH");
            }
            string6 = null == string6 ? libDirectoryPath.toString() : string6 + ":" + libDirectoryPath.toString();
            map.put("DYLD_LIBRARY_PATH", string6);
            map.put("LD_LIBRARY_PATH", string6);
            Process process = processBuilder.start();
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getInputStream()));
            int n3 = 0;
            block26: while (null != (string5 = bufferedReader2.readLine())) {
                switch (++n3) {
                    case 1: {
                        engineVersionString = string5;
                        continue block26;
                    }
                    case 2: {
                        try {
                            n = Integer.parseInt(string5);
                            int n4 = availableCPUCount;
                            if (n4 < 2) {
                                n4 = 2;
                            }
                            maxEngineProcessCount = n < n4 ? n : n4;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue block26;
                    }
                }
                String[] stringArray = string5.split("=");
                if (2 != stringArray.length) continue;
                int n5 = 0;
                try {
                    n5 = Integer.parseInt(stringArray[0].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n5 <= 0) continue;
                propagationModels.add(new KeyedRecord(n5, stringArray[1].trim()));
            }
        }
        catch (Throwable throwable) {
            AppCore.log(3, "Unexpected error", throwable);
        }
        showImageOptions = Files.exists(libDirectoryPath.resolve("gs"), new LinkOption[0]);
    }

    public static void log(int n, String string) {
        Level level = Level.INFO;
        if (3 == n) {
            level = Level.SEVERE;
        } else if (2 == n) {
            level = Level.WARNING;
        }
        logger.log(level, string);
    }

    public static void log(int n, String string, Throwable throwable) {
        Level level = Level.INFO;
        if (3 == n) {
            level = Level.SEVERE;
        } else if (2 == n) {
            level = Level.WARNING;
        }
        logger.log(level, string, throwable);
    }

    public static String getProperty(String string) {
        return localProperties.getProperty(string);
    }

    public static void setProperty(String string, String string2) {
        if (null == string2) {
            return;
        }
        localProperties.setProperty(string, string2);
    }

    public static void saveProperties() {
        if (null != propsPath) {
            try {
                localProperties.store(Files.newOutputStream(propsPath, new OpenOption[0]), "");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static String getPreference(String string) {
        String string2 = localProperties.getProperty(string);
        if (null == string2) {
            string2 = configProperties.getProperty(string);
        }
        return string2;
    }

    public static void setPreference(String string, String string2) {
        if (null == string2) {
            localProperties.remove(string);
        } else {
            localProperties.setProperty(string, string2);
        }
    }

    public static void setCacheDirectoryPath(Path path) {
        Path path2;
        Path path3 = path2 = workingDirectoryPath.resolve(CACHE_DIRECTORY_NAME);
        if (null != path && (path3 = path.toAbsolutePath()).equals(path2)) {
            path = null;
            path3 = path2;
        }
        cacheDirectoryPath = path3;
        if (null == path) {
            AppCore.setPreference(PREF_CACHE_DIRECTORY, null);
        } else {
            if (path3.startsWith(workingDirectoryPath)) {
                path3 = workingDirectoryPath.relativize(path3);
            }
            AppCore.setPreference(PREF_CACHE_DIRECTORY, path3.toString());
        }
    }

    public static void setOutDirectoryPath(Path path) {
        Path path2;
        Path path3 = path2 = workingDirectoryPath.resolve(OUT_DIRECTORY_NAME);
        if (null != path && (path3 = path.toAbsolutePath()).equals(path2)) {
            path = null;
            path3 = path2;
        }
        outDirectoryPath = path3;
        studyOutDirectory = path3.startsWith(workingDirectoryPath) ? workingDirectoryPath.relativize(path3).toString() : path3.toString();
        if (null == path) {
            AppCore.setPreference(PREF_OUT_DIRECTORY, null);
        } else {
            AppCore.setPreference(PREF_OUT_DIRECTORY, studyOutDirectory);
        }
    }

    public static long getStudyCacheSize(String string) {
        return AppCore.getStudyCacheSize(string, 0);
    }

    public static long getStudyCacheSize(String string, int n) {
        long l = 0L;
        File file = n > 0 ? cacheDirectoryPath.resolve(string).resolve(String.valueOf(n)).toFile() : cacheDirectoryPath.resolve(string).toFile();
        if (file.exists() && file.isDirectory()) {
            l = AppCore.sizeOfDirectoryContents(file);
        }
        return l;
    }

    public static FreeSpaceInfo getFreeSpace(String string) {
        Object object;
        FreeSpaceInfo freeSpaceInfo = new FreeSpaceInfo(string);
        FileStore fileStore = null;
        FileStore fileStore2 = null;
        try {
            object = cacheDirectoryPath.resolve(string);
            if (!Files.exists((Path)object, new LinkOption[0]) && !Files.exists((Path)(object = cacheDirectoryPath), new LinkOption[0])) {
                object = workingDirectoryPath;
            }
            fileStore = Files.getFileStore((Path)object);
            freeSpaceInfo.cacheFreeSpace = fileStore.getUsableSpace();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (freeSpaceInfo.cacheFreeSpace <= 0L) {
            freeSpaceInfo.cacheFreeSpace = -1L;
        }
        try {
            object = DbCore.getHostDbName(string);
            Path path = null;
            if (null != object) {
                path = outDirectoryPath.resolve((String)object);
                if (!Files.exists(path, new LinkOption[0])) {
                    path = outDirectoryPath;
                }
            } else {
                path = outDirectoryPath;
            }
            if (!Files.exists(path, new LinkOption[0])) {
                path = workingDirectoryPath;
            }
            fileStore2 = Files.getFileStore(path);
            freeSpaceInfo.outputFreeSpace = fileStore2.getUsableSpace();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (freeSpaceInfo.outputFreeSpace <= 0L) {
            freeSpaceInfo.outputFreeSpace = -1L;
        }
        if (null != fileStore && null != fileStore2) {
            freeSpaceInfo.sameFileStore = fileStore.equals(fileStore2);
        }
        freeSpaceInfo.totalFreeSpace = freeSpaceInfo.sameFileStore ? freeSpaceInfo.cacheFreeSpace : (freeSpaceInfo.cacheFreeSpace > 0L && freeSpaceInfo.outputFreeSpace > 0L ? freeSpaceInfo.cacheFreeSpace + freeSpaceInfo.outputFreeSpace : -1L);
        return freeSpaceInfo;
    }

    public static boolean isFreeSpaceAvailable(String string, int n, long l) {
        long l2 = (long)n * 2000000L;
        FreeSpaceInfo freeSpaceInfo = AppCore.getFreeSpace(string);
        if (freeSpaceInfo.sameFileStore) {
            return l2 + l < freeSpaceInfo.totalFreeSpace;
        }
        boolean bl = true;
        boolean bl2 = true;
        if (l2 > 0L) {
            boolean bl3 = bl = l2 < freeSpaceInfo.cacheFreeSpace;
        }
        if (l > 0L) {
            bl2 = l < freeSpaceInfo.outputFreeSpace;
        }
        return bl && bl2;
    }

    public static boolean deleteStudyCache(String string, int n) {
        boolean bl = false;
        File file = n > 0 ? cacheDirectoryPath.resolve(string).resolve(String.valueOf(n)).toFile() : cacheDirectoryPath.resolve(string).toFile();
        if (file.exists() && file.isDirectory()) {
            bl = AppCore.deleteDirectoryAndContents(file);
        }
        return bl;
    }

    public static boolean purgeStudyCache(String string, int n, boolean[] blArray) {
        boolean bl = false;
        File file = cacheDirectoryPath.resolve(string).resolve(String.valueOf(n)).toFile();
        if (file.exists() && file.isDirectory()) {
            bl = AppCore.deleteUnusedCacheFiles(file, blArray);
        }
        return bl;
    }

    private static boolean deleteUnusedCacheFiles(File file, boolean[] blArray) {
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                if (AppCore.deleteUnusedCacheFiles(fileArray[i], blArray)) continue;
                bl = false;
                continue;
            }
            String string = fileArray[i].getName();
            int n = string.indexOf(95);
            if (n > 0) {
                string = string.substring(0, n);
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 <= 0 || n2 < blArray.length && blArray[n2] || fileArray[i].delete()) continue;
            bl = false;
        }
        return bl;
    }

    public static long sizeOfDirectoryContents(File file) {
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            return 0L;
        }
        long l = 0L;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                l += AppCore.sizeOfDirectoryContents(fileArray[i]);
                continue;
            }
            l += fileArray[i].length();
        }
        return l;
    }

    public static boolean deleteDirectoryAndContents(File file) {
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                if (AppCore.deleteDirectoryAndContents(fileArray[i])) continue;
                bl = false;
                continue;
            }
            if (fileArray[i].delete()) continue;
            bl = false;
        }
        if (bl && !file.delete()) {
            bl = false;
        }
        return bl;
    }

    public static String formatLatitude(double d) {
        if (d < 0.0) {
            return AppCore.formatLatLon(-d) + " S";
        }
        return AppCore.formatLatLon(d) + " N";
    }

    public static String formatLongitude(double d) {
        if (d < 0.0) {
            return AppCore.formatLatLon(-d) + " E";
        }
        return AppCore.formatLatLon(d) + " W";
    }

    private static String formatLatLon(double d) {
        int n = (int)d;
        int n2 = (int)((d - (double)n) * 60.0);
        double d2 = ((d - (double)n) * 60.0 - (double)n2) * 60.0;
        if (d2 >= 59.995) {
            d2 = 0.0;
            if (60 == ++n2) {
                n2 = 0;
                ++n;
            }
        }
        return String.format(Locale.US, "%3d %02d %05.2f", n, n2, d2);
    }

    public static double parseLatitude(String string) {
        return AppCore.parseLatLon(string, -74.0, "S");
    }

    public static double parseLongitude(String string) {
        return AppCore.parseLatLon(string, -181.0, "E");
    }

    private static double parseLatLon(String string, double d, String string2) {
        if (null == string) {
            return d;
        }
        double d2 = d;
        String[] stringArray = latLonPattern.split(string.trim());
        if (1 == stringArray.length) {
            try {
                d2 = Double.parseDouble(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (3 == stringArray.length || 4 == stringArray.length) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                double d3 = Double.parseDouble(stringArray[2]);
                d2 = (double)n + (double)n2 / 60.0 + d3 / 3600.0;
                if (4 == stringArray.length && stringArray[3].equalsIgnoreCase(string2)) {
                    d2 = -d2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d2;
    }

    public static String formatDecimal(double d, int n) {
        return AppCore.formatDecimal(d, n, n);
    }

    public static synchronized String formatDecimal(double d, int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 8) {
            n2 = 8;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > n2) {
            n = n2;
        }
        decimalFormatter.setMinimumFractionDigits(n);
        decimalFormatter.setMaximumFractionDigits(n2);
        return decimalFormatter.format(d);
    }

    public static String formatSeconds(double d) {
        return AppCore.formatDecimal(d, 2, 2);
    }

    public static String formatHeight(double d) {
        return AppCore.formatDecimal(d, 1, 1);
    }

    public static String formatDistance(double d) {
        return AppCore.formatDecimal(d, 2, 2);
    }

    public static String formatAzimuth(double d) {
        return AppCore.formatDecimal(d, 1, 1);
    }

    public static String formatDepression(double d) {
        return AppCore.formatDecimal(d, 2, 2);
    }

    public static String formatERP(double d) {
        if (d < 0.001) {
            return String.valueOf(d);
        }
        if (d < 0.9995) {
            return AppCore.formatDecimal(d, 3, 3);
        }
        if (d < 9.995) {
            return AppCore.formatDecimal(d, 2, 2);
        }
        if (d < 99.95) {
            return AppCore.formatDecimal(d, 1, 1);
        }
        return AppCore.formatDecimal(d, 0, 0);
    }

    public static String formatRelativeField(double d) {
        if (d < 0.001) {
            return String.valueOf(d);
        }
        return AppCore.formatDecimal(d, 3, 3);
    }

    public static String formatField(double d) {
        return AppCore.formatDecimal(d, 1, 1);
    }

    public static String formatDU(double d) {
        return AppCore.formatDecimal(d, 1, 1);
    }

    public static String formatPercent(double d) {
        return AppCore.formatDecimal(d, 2, 2);
    }

    public static synchronized String formatCount(int n) {
        return iCountFormatter.format(n);
    }

    public static synchronized String formatCount(double d) {
        return dCountFormatter.format(d);
    }

    public static int parseVersion(String string) {
        if (null == string) {
            return -1;
        }
        if (0 == (string = string.trim()).length()) {
            return -1;
        }
        String[] stringArray = string.split("\\.");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
            if (stringArray.length > 1) {
                n2 = Integer.parseInt(stringArray[1]);
            }
            if (stringArray.length > 2) {
                n3 = Integer.parseInt(stringArray[2]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (n < 1 || n2 < 0 || n2 > 99 || n3 < 0 || n3 > 999) {
            return -1;
        }
        return n * 100000 + n2 * 1000 + n3;
    }

    public static String formatVersion(int n) {
        if (n <= 0) {
            return "";
        }
        int n2 = 0;
        if (n > 9999999) {
            n2 = n % 100;
            n /= 100;
        }
        int n3 = n / 100000;
        int n4 = n % 100000 / 1000;
        int n5 = n % 1000;
        if (n2 > 0) {
            return String.format(Locale.US, "%d.%d.%d.%d", n3, n4, n5, n2);
        }
        return String.format(Locale.US, "%d.%d.%d", n3, n4, n5);
    }

    public static synchronized String formatDateTime(Date date) {
        if (null != date) {
            return dateTimeFormatter.format(date);
        }
        return "";
    }

    public static synchronized String formatDate(Date date) {
        if (null != date) {
            return dateFormatter.format(date);
        }
        return "";
    }

    public static synchronized Date parseDate(String string) {
        if (null == string) {
            return null;
        }
        Date date = null;
        for (DateFormat dateFormat : dateParsers) {
            try {
                date = dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (null != date) break;
        }
        return date;
    }

    public static synchronized String formatDay(Date date) {
        if (null != date) {
            return dayFormatter.format(date);
        }
        return "";
    }

    public static synchronized String formatTimestamp(long l) {
        return timestampFormatter.format(new Date(l));
    }

    public static String formatBytes(long l) {
        if (l < 0L) {
            return "(unknown)";
        }
        if (l >= 995000000L) {
            return String.format(Locale.US, "%.2f GB", (double)l / 1.0E9);
        }
        if (l >= 950000L) {
            return String.format(Locale.US, "%.1f MB", (double)l / 1000000.0);
        }
        if (l > 0L) {
            return String.format(Locale.US, "%.0f kB", (double)l / 1000.0);
        }
        return "-";
    }

    public static boolean parseXML(Reader reader, DefaultHandler defaultHandler, ErrorLogger errorLogger) {
        try {
            parserFactory.newSAXParser().parse(new InputSource(reader), defaultHandler);
        }
        catch (SAXException sAXException) {
            String string;
            if (null != errorLogger && null != (string = sAXException.getMessage()) && string.length() > 0) {
                errorLogger.reportError("XML error: " + string);
            }
            return false;
        }
        catch (Throwable throwable) {
            AppCore.log(3, "Unexpected error", throwable);
            if (null != errorLogger) {
                errorLogger.reportError("An unexpected error occurred:\n" + throwable);
            }
            return false;
        }
        return true;
    }

    public static String xmlclean(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBFData readDBFData(File file, boolean bl, ErrorLogger errorLogger) {
        String string = file.getName();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            if (null != errorLogger) {
                errorLogger.reportError("Could not open file '" + string + "':\n" + iOException.getMessage());
            }
            return null;
        }
        DBFData dBFData = new DBFData();
        dBFData.fileName = string;
        byte[] byArray = new byte[65536];
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        String string2 = null;
        try {
            int n2;
            int n3;
            if (32 != bufferedInputStream.read(byArray, 0, 32)) {
                string2 = "Unexpected end-of-file";
                DBFData dBFData2 = null;
                return dBFData2;
            }
            dBFData.fieldCount = ((byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8) - 33) / 32;
            if (dBFData.fieldCount <= 0 || dBFData.fieldCount > 255) {
                string2 = "Bad field count in file header";
                DBFData dBFData3 = null;
                return dBFData3;
            }
            dBFData.fieldName = new String[dBFData.fieldCount];
            dBFData.fieldType = new char[dBFData.fieldCount];
            dBFData.fieldLength = new int[dBFData.fieldCount];
            n = 1;
            for (n3 = 0; n3 < dBFData.fieldCount; ++n3) {
                if (32 != bufferedInputStream.read(byArray, 0, 32)) {
                    string2 = "Unexpected end-of-file";
                    DBFData dBFData4 = null;
                    return dBFData4;
                }
                stringBuilder.setLength(0);
                for (n2 = 0; n2 < 11 && 0 != byArray[n2]; ++n2) {
                    stringBuilder.append((char)byArray[n2]);
                }
                dBFData.fieldName[n3] = bl ? stringBuilder.toString().trim() : stringBuilder.toString();
                dBFData.fieldType[n3] = (char)byArray[11];
                dBFData.fieldLength[n3] = byArray[16] & 0xFF;
                n += dBFData.fieldLength[n3];
            }
            bufferedInputStream.read(byArray, 0, 1);
            dBFData.fieldData = new ArrayList();
            while (bufferedInputStream.read(byArray, 0, n) == n) {
                int n4;
                if (bl2) {
                    if (10 == byArray[0]) {
                        for (n4 = 1; n4 < n; ++n4) {
                            byArray[n4 - 1] = byArray[n4];
                        }
                        bufferedInputStream.read(byArray, n - 1, 1);
                    }
                    bl2 = false;
                }
                String[] stringArray = new String[dBFData.fieldCount];
                dBFData.fieldData.add(stringArray);
                n4 = 1;
                for (n3 = 0; n3 < dBFData.fieldCount; ++n3) {
                    stringBuilder.setLength(0);
                    for (n2 = 0; n2 < dBFData.fieldLength[n3]; ++n2) {
                        stringBuilder.append((char)byArray[n4++]);
                    }
                    stringArray[n3] = bl ? stringBuilder.toString().trim() : stringBuilder.toString();
                }
            }
            if (bl2) {
                string2 = "No records found in file";
                DBFData dBFData5 = null;
                return dBFData5;
            }
            DBFData dBFData6 = dBFData;
            return dBFData6;
        }
        catch (IOException iOException) {
            if (null != errorLogger) {
                errorLogger.reportError("An I/O error occurred reading '" + string + "':\n" + iOException);
            }
            DBFData dBFData7 = null;
            return dBFData7;
        }
        catch (Throwable throwable) {
            AppCore.log(3, "Unexpected error", throwable);
            if (null != errorLogger) {
                errorLogger.reportError("An unexpected error occurred reading '" + string + "':\n" + throwable);
            }
            DBFData dBFData8 = null;
            return dBFData8;
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
            if (null != string2 && null != errorLogger) {
                errorLogger.reportError("An error occurred reading '" + string + "': " + string2);
            }
        }
    }

    public static String readLineSkipComments(BufferedReader bufferedReader) throws IOException {
        return AppCore.readLineSkipComments(bufferedReader, null, null);
    }

    public static String readLineSkipComments(BufferedReader bufferedReader, LineCounter lineCounter) throws IOException {
        return AppCore.readLineSkipComments(bufferedReader, lineCounter, null);
    }

    public static String readLineSkipComments(BufferedReader bufferedReader, LineCounter lineCounter, HashMap<String, String> hashMap) throws IOException {
        String string;
        boolean bl = false;
        block0: do {
            if (null == (string = bufferedReader.readLine())) {
                return null;
            }
            if (null != lineCounter) {
                lineCounter.increment();
            }
            bl = false;
            int n = string.length();
            if (n <= 0) continue;
            char c = string.charAt(0);
            for (int i = 0; i < TEXT_FILE_COMMENT_PREFIX.length; ++i) {
                if (c != TEXT_FILE_COMMENT_PREFIX[i]) continue;
                bl = true;
                if (null == hashMap || n <= 2 || '$' != string.charAt(1)) continue block0;
                String string2 = "";
                String string3 = "";
                int n2 = string.indexOf(61);
                if (n2 < 0) {
                    string2 = string.substring(2).trim();
                } else {
                    string2 = string.substring(2, n2).trim();
                    string3 = string.substring(n2 + 1).trim();
                }
                if (string2.length() <= 0) continue block0;
                hashMap.put(string2, string3);
                continue block0;
            }
        } while (bl);
        return string;
    }

    public static String[] readAndParseLine(BufferedReader bufferedReader) throws IOException {
        return AppCore.readAndParseLine(bufferedReader, null, null);
    }

    public static String[] readAndParseLine(BufferedReader bufferedReader, LineCounter lineCounter) throws IOException {
        return AppCore.readAndParseLine(bufferedReader, lineCounter, null);
    }

    public static String[] readAndParseLine(BufferedReader bufferedReader, LineCounter lineCounter, HashMap<String, String> hashMap) throws IOException {
        String string = AppCore.readLineSkipComments(bufferedReader, lineCounter, hashMap);
        if (null == string) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = '\u0000';
        if (null != lineCounter) {
            c = lineCounter.getDelimiter();
        }
        char c2 = '\u0000';
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c3 = c2;
            c2 = string.charAt(i);
            if ('\\' != c3) {
                if (!bl) {
                    if ('\u0000' == c && (',' == c2 || '\t' == c2 || '|' == c2)) {
                        c = c2;
                        if (null != lineCounter) {
                            lineCounter.setDelimiter(c2);
                        }
                    }
                    if (c2 == c) {
                        if (n > 0) {
                            stringBuilder.setLength(stringBuilder.length() - n);
                        }
                        if (stringBuilder.length() > 0) {
                            while (n2 > 0) {
                                arrayList.add("");
                                --n2;
                            }
                            arrayList.add(stringBuilder.toString());
                            stringBuilder.setLength(0);
                        } else {
                            ++n2;
                        }
                        bl2 = false;
                        n = 0;
                        continue;
                    }
                }
                if ('\\' == c2) continue;
                if ('\"' == c2) {
                    bl = !bl;
                    continue;
                }
            }
            if (Character.isWhitespace(c2)) {
                if (!bl2) continue;
                ++n;
            } else {
                n = 0;
            }
            bl2 = true;
            stringBuilder.append(c2);
        }
        if (n > 0) {
            stringBuilder.setLength(stringBuilder.length() - n);
        }
        if (stringBuilder.length() > 0) {
            while (n2 > 0) {
                arrayList.add("");
                --n2;
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void writeTextMetadata(String string, String string2, Writer writer) throws IOException {
        writer.write(TEXT_FILE_COMMENT_PREFIX[0]);
        writer.write(36);
        writer.write(string);
        writer.write(61);
        writer.write(string2);
        writer.write(10);
    }

    private static Path getSupportFilePath(String string) {
        String string2 = null;
        String string3 = string;
        int n = string.indexOf(FILE_PATH_SEPARATOR);
        if (n >= 0) {
            if (n > 0) {
                string2 = string.substring(0, n);
            }
            if (0 == (string3 = string.substring(n + 1)).length() && null != string2) {
                string3 = string2;
                string2 = null;
            }
        }
        Path path = null != string2 ? (string2.equals(LIB_DIRECTORY_NAME) ? libDirectoryPath : (string2.equals(DATA_DIRECTORY_NAME) ? dataDirectoryPath : (string2.equals(XML_DIRECTORY_NAME) ? xmlDirectoryPath : (string2.equals(DBASE_DIRECTORY_NAME) ? dbaseDirectoryPath : (string2.equals(HELP_DIRECTORY_NAME) ? helpDirectoryPath : workingDirectoryPath.resolve(string2)))))) : workingDirectoryPath;
        return path.resolve(string3);
    }

    public static int getFileVersion(Path path) throws FileNotFoundException {
        return AppCore.getFileVersion(path, FILE_VERSION_COMMENT_PREFIX, FILE_VERSION_PREFIX);
    }

    public static int getXMLFileVersion(Path path) throws FileNotFoundException {
        return AppCore.getFileVersion(path, FILE_VERSION_XML_COMMENT_PREFIX, FILE_VERSION_XML_PREFIX);
    }

    private static int getFileVersion(Path path, String string, String string2) throws FileNotFoundException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = Files.newBufferedReader(path);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        int n = AppCore.getFileVersion(bufferedReader, string, string2);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n;
    }

    public static int getFileVersion(BufferedReader bufferedReader) {
        return AppCore.getFileVersion(bufferedReader, FILE_VERSION_COMMENT_PREFIX, FILE_VERSION_PREFIX);
    }

    private static int getFileVersion(BufferedReader bufferedReader, String string, String string2) {
        int n = 0;
        String string3 = null;
        do {
            int n2;
            int n3;
            try {
                bufferedReader.mark(10000);
                string3 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                string3 = null;
                break;
            }
            if (null == string3 || !string3.startsWith(string2)) continue;
            int n4 = string3.length();
            for (n3 = n2 = string2.length(); n3 < n4 && Character.isDigit(string3.charAt(n3)); ++n3) {
            }
            try {
                n = Integer.parseInt(string3.substring(n2, n3));
                if (n < 0) {
                    n = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string3 = null;
            break;
        } while (null != string3 && string3.startsWith(string));
        if (null != string3) {
            try {
                bufferedReader.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n;
    }

    static {
        availableCPUCount = Runtime.getRuntime().availableProcessors();
        engineVersionString = "(unknown)";
        maxEngineProcessCount = -1;
        propagationModels = new ArrayList();
        TEXT_FILE_COMMENT_PREFIX = new char[]{'#', '%'};
        fileCheckID = "(unknown)";
        logger = Logger.getLogger(LOGGER_NAME);
        logger.setUseParentHandlers(false);
        if (Debug) {
            logger.setLevel(Level.ALL);
        } else {
            logger.setLevel(Level.SEVERE);
        }
        configProperties = new Properties();
        localProperties = new Properties();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AppCore.saveProperties();
            }
        });
        didInit = false;
        latLonPattern = Pattern.compile("\\s");
        decimalFormatter = null;
        decimalFormatter = NumberFormat.getInstance(Locale.US);
        decimalFormatter.setMinimumIntegerDigits(1);
        decimalFormatter.setGroupingUsed(false);
        iCountFormatter = null;
        dCountFormatter = null;
        iCountFormatter = NumberFormat.getIntegerInstance(Locale.US);
        iCountFormatter.setGroupingUsed(true);
        dCountFormatter = NumberFormat.getInstance(Locale.US);
        dCountFormatter.setMinimumFractionDigits(1);
        dCountFormatter.setMaximumFractionDigits(1);
        dCountFormatter.setMinimumIntegerDigits(1);
        dCountFormatter.setGroupingUsed(true);
        dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        dateParsers = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("M/d/yyyy"), new SimpleDateFormat("ddMMMyyyy")};
        dayFormatter = new SimpleDateFormat("EEEEEEEEE");
        timestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        parserFactory = SAXParserFactory.newInstance();
    }

    public static class LineCounter {
        private int count;
        private char delimiter;

        public void set(int n) {
            this.count = n;
        }

        public int get() {
            return this.count;
        }

        public int increment() {
            return ++this.count;
        }

        public int decrement() {
            return --this.count;
        }

        public void setDelimiter(char c) {
            this.delimiter = c;
        }

        public void setDelimiterForFile(File file) {
            String string = file.getName().toLowerCase();
            if (string.endsWith(".csv")) {
                this.delimiter = (char)44;
            } else if (string.endsWith(".txt")) {
                this.delimiter = (char)9;
            } else if (string.endsWith(".dat")) {
                this.delimiter = (char)124;
            }
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public boolean hasDelimiter() {
            return '\u0000' != this.delimiter;
        }

        public void reset() {
            this.count = 0;
            this.delimiter = '\u0000';
        }

        public String toString() {
            return String.valueOf(this.count);
        }
    }

    public static class DBFData {
        public String fileName;
        public int fieldCount;
        public String[] fieldName;
        public char[] fieldType;
        public int[] fieldLength;
        public ArrayList<String[]> fieldData;
    }

    public static class FreeSpaceInfo {
        public static String dbID;
        public long totalFreeSpace;
        public boolean sameFileStore;
        public long cacheFreeSpace;
        public long outputFreeSpace;

        public FreeSpaceInfo(String string) {
            dbID = string;
        }
    }

    private static class LogFormatter
    extends Formatter {
        private LogFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringWriter stringWriter = new StringWriter();
            stringWriter.write(AppCore.formatTimestamp(logRecord.getMillis()));
            stringWriter.write(" ");
            stringWriter.write(logRecord.getLoggerName());
            stringWriter.write(" [");
            stringWriter.write(logRecord.getLevel().getLocalizedName());
            stringWriter.write("] : ");
            stringWriter.write(logRecord.getMessage());
            stringWriter.write("\n");
            Throwable throwable = logRecord.getThrown();
            if (null != throwable) {
                throwable.printStackTrace(new PrintWriter(stringWriter));
            }
            return stringWriter.toString();
        }
    }
}

