/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.core;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;

public class AntPattern {
    public static final double AZIMUTH_MIN = 0.0;
    public static final double AZIMUTH_MAX = 359.999;
    public static final double AZIMUTH_ROUND = 1000.0;
    public static final double FREQUENCY_MIN = 10.0;
    public static final double FREQUENCY_MAX = 5000.0;
    public static final double DEPRESSION_MIN = -90.0;
    public static final double DEPRESSION_MAX = 90.0;
    public static final double DEPRESSION_ROUND = 1000.0;
    public static final double FIELD_MIN = 0.001;
    public static final double FIELD_MAX = 1.0;
    public static final double FIELD_ROUND = 1000.0;
    public static final double FIELD_MAX_CHECK = 0.977;
    public static final int PATTERN_REQUIRED_POINTS = 2;
    public static final double TILT_MIN = -10.0;
    public static final double TILT_MAX = 16.0;
    public static final double GAIN_MIN = 0.0;
    public static final double GAIN_MAX = 60.0;
    public static final int PATTERN_TYPE_HORIZONTAL = 1;
    public static final int PATTERN_TYPE_VERTICAL = 2;
    public static final int PATTERN_TYPE_RECEIVE = 3;
    public static final String NEW_ANTENNA_NAME = "(new)";
    public static final String GENERIC_ANTENNA_NAME = "(generic)";
    public static final String TEXT_META_KEY_NAME = "name";
    public static final String TEXT_META_KEY_GAIN = "gain";
    public static final String TEXT_META_KEY_DB = "dbvalues";
    public final String dbID;
    public final int type;
    public Integer key;
    public String name;
    public double gain;
    private ArrayList<AntPoint> points;
    private TreeMap<Double, AntSlice> slices;

    public AntPattern(String string, int n, String string2) {
        this.dbID = string;
        this.type = n;
        this.name = string2;
        this.points = new ArrayList();
    }

    public AntPattern(String string, int n, String string2, ArrayList<AntPoint> arrayList) {
        this.dbID = string;
        this.type = n;
        this.name = string2;
        this.points = arrayList;
    }

    public AntPattern(String string, String string2, int n, ArrayList<AntSlice> arrayList) {
        this.dbID = string;
        this.type = n;
        this.name = string2;
        if (1 == this.type || arrayList.size() < 2) {
            this.points = !arrayList.isEmpty() ? arrayList.get((int)0).points : new ArrayList();
        } else {
            this.slices = new TreeMap();
            for (AntSlice antSlice : arrayList) {
                this.slices.put(antSlice.value, antSlice);
            }
        }
    }

    public AntPattern copy() {
        AntPattern antPattern;
        if (null != this.points) {
            ArrayList<AntPoint> arrayList = new ArrayList<AntPoint>();
            for (AntPoint antPoint : this.points) {
                arrayList.add(antPoint.copy());
            }
            antPattern = new AntPattern(this.dbID, this.type, this.name, arrayList);
        } else {
            ArrayList<AntSlice> arrayList = new ArrayList<AntSlice>();
            for (AntSlice antSlice : this.slices.values()) {
                arrayList.add(antSlice.copy());
            }
            antPattern = new AntPattern(this.dbID, this.name, this.type, arrayList);
        }
        antPattern.key = this.key;
        antPattern.gain = this.gain;
        return antPattern;
    }

    public AntPattern duplicate() {
        AntPattern antPattern = this.copy();
        antPattern.key = null;
        antPattern.name = "";
        return antPattern;
    }

    public boolean isSimple() {
        return null != this.points;
    }

    public ArrayList<AntPoint> getPoints() {
        return this.points;
    }

    public boolean isMatrix() {
        return null != this.slices;
    }

    public double minimumValue() {
        if (null != this.slices) {
            return this.slices.firstEntry().getValue().value;
        }
        return -1.0;
    }

    public double maximumValue() {
        if (null != this.slices) {
            return this.slices.lastEntry().getValue().value;
        }
        return -1.0;
    }

    public Collection<AntSlice> getSlices() {
        if (null == this.slices) {
            return null;
        }
        return this.slices.values();
    }

    public boolean convertToMatrix(Double d, Double d2) {
        return this.convertToMatrix(d, d2, null);
    }

    public boolean convertToMatrix(Double d, Double d2, ArrayList<AntPoint> arrayList) {
        if (1 == this.type || null == this.points || d.equals(d2)) {
            return false;
        }
        this.slices = new TreeMap();
        AntSlice antSlice = new AntSlice(d, this.points);
        this.slices.put(d, antSlice);
        this.points = null;
        antSlice = null != arrayList ? new AntSlice(d2, arrayList) : new AntSlice(d2);
        this.slices.put(d2, antSlice);
        return true;
    }

    public void convertToSimple() {
        if (null == this.slices) {
            return;
        }
        this.points = this.slices.firstEntry().getValue().points;
        this.slices = null;
    }

    public ArrayList<Double> getSliceValues() {
        if (null == this.slices) {
            return null;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (AntSlice antSlice : this.slices.values()) {
            arrayList.add(antSlice.value);
        }
        return arrayList;
    }

    public boolean containsSlice(Double d) {
        if (null == this.slices) {
            return false;
        }
        return this.slices.containsKey(d);
    }

    public ArrayList<AntPoint> getSlice(Double d) {
        if (null == this.slices) {
            return null;
        }
        AntSlice antSlice = this.slices.get(d);
        if (null == antSlice) {
            return null;
        }
        return antSlice.points;
    }

    public boolean changeSliceValue(Double d, Double d2) {
        if (null == this.slices || !this.slices.containsKey(d) || this.slices.containsKey(d2)) {
            return false;
        }
        AntSlice antSlice = this.slices.remove(d);
        antSlice.value = d2;
        this.slices.put(d2, antSlice);
        return true;
    }

    public ArrayList<AntPoint> addSlice(Double d) {
        return this.addSlice(d, null);
    }

    public ArrayList<AntPoint> addSlice(Double d, ArrayList<AntPoint> arrayList) {
        AntSlice antSlice;
        if (null == this.slices) {
            if (1 == this.type || !this.points.isEmpty()) {
                return null;
            }
            this.points = null;
            this.slices = new TreeMap();
        }
        if (null == (antSlice = this.slices.get(d))) {
            antSlice = null != arrayList ? new AntSlice(d, arrayList) : new AntSlice(d);
            this.slices.put(d, antSlice);
        } else if (null != arrayList) {
            antSlice.points = arrayList;
        }
        return antSlice.points;
    }

    public boolean removeSlice(Double d) {
        boolean bl;
        if (null == this.slices) {
            return false;
        }
        boolean bl2 = bl = null != this.slices.remove(d);
        if (1 == this.slices.size()) {
            this.points = this.slices.firstEntry().getValue().points;
            this.slices = null;
        }
        return bl;
    }

    public AntPattern normalizeVerticalMatrix() {
        if (2 != this.type || null == this.slices) {
            return null;
        }
        ArrayList<AntPoint> arrayList = new ArrayList<AntPoint>();
        boolean bl = false;
        for (AntSlice antSlice : this.slices.values()) {
            AntPoint object = null;
            for (AntPoint object2 : antSlice.points) {
                if (null != object && !(object2.relativeField > object.relativeField)) continue;
                object = object2;
            }
            arrayList.add(new AntPoint(antSlice.value, object.relativeField));
            if (!(object.relativeField < 1.0)) continue;
            bl = true;
        }
        if (bl) {
            int n = 0;
            for (AntSlice antSlice : this.slices.values()) {
                AntPoint antPoint = (AntPoint)arrayList.get(n++);
                for (AntPoint antPoint2 : antSlice.points) {
                    antPoint2.relativeField /= antPoint.relativeField;
                }
            }
            return new AntPattern(this.dbID, 1, "(matrix derived)", arrayList);
        }
        return null;
    }

    public boolean equalsPattern(AntPattern antPattern) {
        if (this.type != antPattern.type) {
            return false;
        }
        if (3 == this.type && this.gain != antPattern.gain) {
            return false;
        }
        if (null != this.points && null == antPattern.points) {
            return false;
        }
        if (null != this.slices && null == antPattern.slices) {
            return false;
        }
        if (null != this.points) {
            if (this.points.size() != antPattern.points.size()) {
                return false;
            }
            for (int i = 0; i < this.points.size(); ++i) {
                AntPoint antPoint = this.points.get(i);
                AntPoint antPoint2 = antPattern.points.get(i);
                if (antPoint.angle != antPoint2.angle) {
                    return false;
                }
                if (antPoint.relativeField == antPoint2.relativeField) continue;
                return false;
            }
        } else {
            if (this.slices.size() != antPattern.slices.size()) {
                return false;
            }
            Iterator<AntSlice> iterator = this.slices.values().iterator();
            Iterator<AntSlice> iterator2 = antPattern.slices.values().iterator();
            while (iterator.hasNext()) {
                AntSlice antSlice = iterator.next();
                AntSlice antSlice2 = iterator2.next();
                if (antSlice.value != antSlice2.value) {
                    return false;
                }
                if (antSlice.points.size() != antSlice2.points.size()) {
                    return false;
                }
                for (int i = 0; i < antSlice.points.size(); ++i) {
                    AntPoint antPoint = antSlice.points.get(i);
                    AntPoint antPoint3 = antSlice2.points.get(i);
                    if (antPoint.angle != antPoint3.angle) {
                        return false;
                    }
                    if (antPoint.relativeField == antPoint3.relativeField) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isDataValid() {
        return this.isDataValid(null);
    }

    public boolean isDataValid(ErrorLogger errorLogger) {
        switch (this.type) {
            case 1: {
                if (this.points.size() < 2) {
                    if (null != errorLogger) {
                        errorLogger.reportValidationError("Bad azimuth pattern, must have 2 or more points");
                    }
                    return false;
                }
                double d = -1.0;
                for (AntPoint antPoint : this.points) {
                    if (antPoint.angle < 0.0 || antPoint.angle > 359.999) {
                        if (null != errorLogger) {
                            errorLogger.reportValidationError("Bad pattern point azimuth, must be 0.0 to 359.999");
                        }
                        return false;
                    }
                    if (antPoint.angle <= d) {
                        if (null != errorLogger) {
                            errorLogger.reportValidationError("Bad azimuth pattern, duplicate or out-of-order points");
                        }
                        return false;
                    }
                    d = antPoint.angle;
                    if (!(antPoint.relativeField < 0.001) && !(antPoint.relativeField > 1.0)) continue;
                    if (null != errorLogger) {
                        errorLogger.reportValidationError("Bad pattern point relative field, must be 0.001 to 1.0");
                    }
                    return false;
                }
                return true;
            }
            case 2: {
                Collection<Object> collection;
                if (null == this.slices) {
                    if (this.points.size() < 2) {
                        if (null != errorLogger) {
                            errorLogger.reportValidationError("Bad elevation pattern, must have 2 or more points");
                        }
                        return false;
                    }
                    collection = new ArrayList();
                    collection.add(new AntSlice(0.0, this.points));
                } else {
                    if (this.slices.size() < 2) {
                        if (null != errorLogger) {
                            errorLogger.reportValidationError("Bad matrix elevation pattern, must have 2 or more azimuths");
                        }
                        return false;
                    }
                    collection = this.slices.values();
                }
                double d = 0.0;
                for (AntSlice antSlice : collection) {
                    if (antSlice.value < 0.0 || antSlice.value > 359.999) {
                        if (null != errorLogger) {
                            errorLogger.reportValidationError("Bad matrix elevation pattern azimuth, must be 0.0 to 359.999");
                        }
                        return false;
                    }
                    if (antSlice.points.size() < 2) {
                        if (null != errorLogger) {
                            errorLogger.reportValidationError("Bad elevation pattern, must have 2 or more points");
                        }
                        return false;
                    }
                    d = -91.0;
                    for (AntPoint antPoint : antSlice.points) {
                        if (antPoint.angle < -90.0 || antPoint.angle > 90.0) {
                            if (null != errorLogger) {
                                errorLogger.reportValidationError("Bad pattern point vertical angle, must be -90.0 to 90.0");
                            }
                            return false;
                        }
                        if (antPoint.angle <= d) {
                            if (null != errorLogger) {
                                errorLogger.reportValidationError("Bad elevation pattern, duplicate or out-of-order points");
                            }
                            return false;
                        }
                        d = antPoint.angle;
                        if (!(antPoint.relativeField < 0.001) && !(antPoint.relativeField > 1.0)) continue;
                        if (null != errorLogger) {
                            errorLogger.reportValidationError("Bad pattern point relative field, must be 0.001 to 1.0");
                        }
                        return false;
                    }
                }
                return true;
            }
            case 3: {
                Collection<Object> collection;
                if (this.gain < 0.0 || this.gain > 60.0) {
                    if (null != errorLogger) {
                        errorLogger.reportValidationError("Bad receive antenna gain, must be 0.0 to 60.0");
                    }
                    return false;
                }
                if (null == this.slices) {
                    if (this.points.size() < 2) {
                        if (null != errorLogger) {
                            errorLogger.reportValidationError("Bad receive pattern, must have 2 or more points");
                        }
                        return false;
                    }
                    collection = new ArrayList();
                    collection.add(new AntSlice(10.0, this.points));
                } else {
                    if (this.slices.size() < 2) {
                        if (null != errorLogger) {
                            errorLogger.reportValidationError("Bad receive pattern, must have 2 or more frequencies");
                        }
                        return false;
                    }
                    collection = this.slices.values();
                }
                double d = 0.0;
                double d2 = 0.0;
                for (AntSlice antSlice : collection) {
                    if (antSlice.value < 10.0 || antSlice.value > 5000.0) {
                        if (null != errorLogger) {
                            errorLogger.reportValidationError("Bad receive pattern frequency, must be 10.0 to 5000.0");
                        }
                        return false;
                    }
                    if (antSlice.points.size() < 2) {
                        if (null != errorLogger) {
                            errorLogger.reportValidationError("Bad receive pattern, must have 2 or more points");
                        }
                        return false;
                    }
                    d = -1.0;
                    for (AntPoint antPoint : antSlice.points) {
                        if (antPoint.angle < 0.0 || antPoint.angle > 359.999) {
                            if (null != errorLogger) {
                                errorLogger.reportValidationError("Bad pattern point azimuth, must be 0.0 to 359.999");
                            }
                            return false;
                        }
                        if (antPoint.angle <= d) {
                            if (null != errorLogger) {
                                errorLogger.reportValidationError("Bad receive pattern, duplicate or out-of-order points");
                            }
                            return false;
                        }
                        d = antPoint.angle;
                        if (antPoint.relativeField < 0.001 || antPoint.relativeField > 1.0) {
                            if (null != errorLogger) {
                                errorLogger.reportValidationError("Bad pattern point relative field, must be 0.001 to 1.0");
                            }
                            return false;
                        }
                        if (!(antPoint.relativeField > d2)) continue;
                        d2 = antPoint.relativeField;
                    }
                }
                if (d2 < 1.0) {
                    if (null != errorLogger) {
                        errorLogger.reportValidationError("Bad receive antenna, pattern must have a 1");
                    }
                    return false;
                }
                return true;
            }
        }
        if (null != errorLogger) {
            errorLogger.reportValidationError("Bad pattern, unknown type");
        }
        return false;
    }

    public void export(File file, ErrorLogger errorLogger) {
        this.export(file, false, errorLogger);
    }

    public void export(File file, boolean bl, ErrorLogger errorLogger) {
        Object object;
        int n;
        block48: {
            Object object2;
            if (2 != this.type) {
                bl = false;
            }
            boolean bl2 = null != this.slices;
            TreeMap<Object, Object> treeMap = null;
            if (bl2) {
                treeMap = new TreeMap<Object, Object>();
                n = 0;
                for (AntSlice antSlice : this.slices.values()) {
                    for (AntPoint antPoint : antSlice.points) {
                        object2 = antPoint.angle;
                        object = (AntSlice)treeMap.get(object2);
                        if (null == object) {
                            object = new AntSlice(antPoint.angle);
                            for (int i = 0; i < this.slices.size(); ++i) {
                                ((AntSlice)object).points.add(null);
                            }
                            treeMap.put(object2, object);
                        }
                        ((AntSlice)object).points.set(n, new AntPoint(antSlice.value, antPoint.relativeField));
                    }
                    ++n;
                }
            }
            object2 = null;
            try {
                object2 = new FileWriter(file);
            }
            catch (IOException iOException) {
                if (null != errorLogger) {
                    errorLogger.reportError("Could not open the file:\n" + iOException.getMessage());
                }
                return;
            }
            object = new BufferedWriter((Writer)object2);
            n = 0;
            try {
                if (bl) {
                    ((Writer)object).write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<elevationPattern xmlns=\"http://mb.fcc.gov/elevationPattern\">\n");
                } else {
                    AppCore.writeTextMetadata(TEXT_META_KEY_NAME, this.name, (Writer)object);
                    if (3 == this.type) {
                        AppCore.writeTextMetadata(TEXT_META_KEY_GAIN, AppCore.formatDecimal(this.gain, 2), (Writer)object);
                    }
                }
                if (bl2) {
                    if (bl) {
                        for (AntSlice antSlice : treeMap.values()) {
                            ((Writer)object).write(String.format(Locale.US, "<elevationData>\n<depressionAgle>%.3f</depressionAgle>\n", antSlice.value));
                            for (AntPoint antPoint : antSlice.points) {
                                if (null == antPoint) {
                                    n = 1;
                                    continue;
                                }
                                ((Writer)object).write(String.format(Locale.US, "<fieldValues><azimuth>%.3f</azimuth><fieldValue>%.4f</fieldValue></fieldValues>\n", antPoint.angle, antPoint.relativeField));
                            }
                            ((Writer)object).write("</elevationData>\n");
                        }
                    } else {
                        for (AntSlice antSlice : this.slices.values()) {
                            ((Writer)object).write(String.format(Locale.US, ",%.3f", antSlice.value));
                        }
                        ((BufferedWriter)object).write(10);
                        for (AntSlice antSlice : treeMap.values()) {
                            ((Writer)object).write(String.format(Locale.US, "%.3f", antSlice.value));
                            for (AntPoint antPoint : antSlice.points) {
                                if (null == antPoint) {
                                    ((BufferedWriter)object).write(44);
                                    continue;
                                }
                                ((Writer)object).write(String.format(Locale.US, ",%.4f", antPoint.relativeField));
                            }
                            ((BufferedWriter)object).write(10);
                        }
                    }
                } else {
                    for (AntPoint antPoint : this.points) {
                        if (bl) {
                            ((Writer)object).write(String.format(Locale.US, "<elevationData>\n<depressionAgle>%.3f</depressionAgle><fieldValue>%.4f</fieldValue>\n</elevationData>\n", antPoint.angle, antPoint.relativeField));
                            continue;
                        }
                        ((Writer)object).write(String.format(Locale.US, "%.3f,%.4f\n", antPoint.angle, antPoint.relativeField));
                    }
                }
                if (bl) {
                    ((Writer)object).write("</elevationPattern>\n");
                }
            }
            catch (IOException iOException) {
                if (null == errorLogger) break block48;
                errorLogger.reportError("Could not write to the file:\n" + iOException.getMessage());
            }
        }
        try {
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl && null != errorLogger && !errorLogger.hasErrors()) {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            double d = 0.0;
            for (AntSlice antSlice : this.slices.values()) {
                boolean bl9 = false;
                boolean bl10 = false;
                boolean bl11 = false;
                for (AntPoint antPoint : antSlice.points) {
                    if (antPoint.angle < -10.0 || antPoint.angle > 90.0) {
                        bl5 = true;
                    }
                    if (-10.0 == antPoint.angle) {
                        bl10 = true;
                    }
                    if (90.0 == antPoint.angle) {
                        bl11 = true;
                    }
                    if (bl9) {
                        double d2 = antPoint.angle - d;
                        if (d < -5.0 || d >= 10.0) {
                            if (d2 > 5.0) {
                                bl4 = true;
                            }
                        } else if (d2 > 0.5) {
                            bl3 = true;
                        }
                    }
                    d = antPoint.angle;
                    bl9 = true;
                }
                if (bl10 && bl11) continue;
                bl2 = true;
            }
            if (bl5 || bl2 || bl4 || bl3 || n != 0) {
                Object object3 = "The XML file does not comply with LMS requirements:\n";
                if (bl5) {
                    object3 = (String)object3 + "Vertical angles are outside -10 to 90 degrees\n";
                } else if (bl2) {
                    object3 = (String)object3 + "Vertical angles do not span -10 to 90 degrees\n";
                }
                if (bl4) {
                    object3 = (String)object3 + "Vertical angles are more than 5 degrees apart\n";
                }
                if (bl3) {
                    object3 = (String)object3 + "Vertical angles are more than 0.5 degrees apart between -5 and 10 degrees\n";
                }
                if (n != 0) {
                    object3 = (String)object3 + "Matrix pattern elevation slices do not have matching vertical angles\n";
                }
                errorLogger.reportWarning((String)object3);
            }
        }
    }

    public boolean save() {
        return this.save(null);
    }

    public boolean save(ErrorLogger errorLogger) {
        if (3 != this.type) {
            if (null != errorLogger) {
                errorLogger.reportError("Antenna save failed, invalid pattern type");
            }
            return false;
        }
        DbConnection dbConnection = DbCore.connectDb(this.dbID, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        String string = null;
        try {
            dbConnection.update("LOCK TABLES receive_antenna_index WRITE, antenna_key_sequence WRITE, receive_pattern WRITE, geography_receive_antenna WRITE, study_geography WRITE, study WRITE");
            string = this.saveReceiveAntenna(dbConnection);
        }
        catch (SQLException sQLException) {
            string = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string) {
            if (null != errorLogger) {
                errorLogger.reportError(string);
            }
            return false;
        }
        return true;
    }

    public String saveReceiveAntenna(DbConnection dbConnection) throws SQLException {
        if (3 != this.type) {
            return "Antenna save failed, invalid pattern type";
        }
        if (null != this.key) {
            dbConnection.query("SELECT COUNT(*) FROM geography_receive_antenna JOIN study_geography USING (geo_key)JOIN study USING (study_key) WHERE (geography_receive_antenna.antenna_key = " + this.key + ") AND (study.study_lock IN (" + 2 + "," + 3 + "))");
            if (dbConnection.next() && dbConnection.getInt(1) > 0) {
                return "Changes cannot be saved now, the antenna is in use by a running study";
            }
        }
        dbConnection.query("SELECT antenna_key FROM receive_antenna_index WHERE UPPER(name) = '" + DbConnection.clean(this.name.toUpperCase()) + "'");
        if (dbConnection.next() && (null == this.key || dbConnection.getInt(1) != this.key.intValue())) {
            this.name = this.name + " " + String.valueOf('#') + String.valueOf(this.key);
        }
        if (null == this.key) {
            dbConnection.update("UPDATE antenna_key_sequence SET antenna_key = antenna_key + 1");
            dbConnection.query("SELECT antenna_key FROM antenna_key_sequence");
            dbConnection.next();
            this.key = dbConnection.getInt(1);
        } else {
            dbConnection.update("DELETE FROM receive_antenna_index WHERE antenna_key = " + this.key);
            dbConnection.update("DELETE FROM receive_pattern WHERE antenna_key = " + this.key);
        }
        dbConnection.update("INSERT INTO receive_antenna_index VALUES (" + this.key + ",'" + DbConnection.clean(this.name) + "'," + this.gain + ")");
        StringBuilder stringBuilder = new StringBuilder("INSERT INTO receive_pattern VALUES");
        int n = stringBuilder.length();
        String string = " (";
        if (null != this.points) {
            for (AntPoint antPoint : this.points) {
                stringBuilder.append(string);
                stringBuilder.append(String.valueOf(this.key));
                stringBuilder.append(",-1,");
                stringBuilder.append(String.valueOf(antPoint.angle));
                stringBuilder.append(',');
                stringBuilder.append(String.valueOf(antPoint.relativeField));
                if (stringBuilder.length() > 500000) {
                    stringBuilder.append(')');
                    dbConnection.update(stringBuilder.toString());
                    stringBuilder.setLength(n);
                    string = " (";
                    continue;
                }
                string = "),(";
            }
        } else {
            for (AntSlice antSlice : this.slices.values()) {
                for (AntPoint antPoint : antSlice.points) {
                    stringBuilder.append(string);
                    stringBuilder.append(String.valueOf(this.key));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(antSlice.value));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(antPoint.angle));
                    stringBuilder.append(',');
                    stringBuilder.append(String.valueOf(antPoint.relativeField));
                    if (stringBuilder.length() > 500000) {
                        stringBuilder.append(')');
                        dbConnection.update(stringBuilder.toString());
                        stringBuilder.setLength(n);
                        string = " (";
                        continue;
                    }
                    string = "),(";
                }
            }
        }
        if (stringBuilder.length() > n) {
            stringBuilder.append(')');
            dbConnection.update(stringBuilder.toString());
        }
        return null;
    }

    public static boolean checkReceiveAntennaName(String string, String string2) {
        return AntPattern.checkReceiveAntennaName(string, string2, null, null);
    }

    public static boolean checkReceiveAntennaName(String string, String string2, ErrorLogger errorLogger) {
        return AntPattern.checkReceiveAntennaName(string, string2, null, errorLogger);
    }

    public static boolean checkReceiveAntennaName(String string, String string2, String string3) {
        return AntPattern.checkReceiveAntennaName(string, string2, string3, null);
    }

    public static boolean checkReceiveAntennaName(String string, String string2, String string3, ErrorLogger errorLogger) {
        if (null != string3 && string3.length() > 0 && string2.equalsIgnoreCase(string3)) {
            return true;
        }
        if (0 == string2.length()) {
            if (null != errorLogger) {
                errorLogger.reportWarning("An antenna name must be provided");
            }
            return false;
        }
        if (string2.length() > 245) {
            if (null != errorLogger) {
                errorLogger.reportWarning("The antenna name cannot be more than 245 characters long");
            }
            return false;
        }
        if (string2.contains(String.valueOf('#'))) {
            if (null != errorLogger) {
                errorLogger.reportWarning("The antenna name cannot contain the character '#'");
            }
            return false;
        }
        if (string2.equalsIgnoreCase(NEW_ANTENNA_NAME) || string2.equalsIgnoreCase(GENERIC_ANTENNA_NAME)) {
            if (null != errorLogger) {
                errorLogger.reportWarning("That antenna name cannot be used, please try again");
            }
            return false;
        }
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            boolean bl = false;
            try {
                dbConnection.query("SELECT antenna_key FROM receive_antenna_index WHERE UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "'");
                bl = dbConnection.next();
                DbCore.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                DbConnection.reportError(errorLogger, sQLException);
                return false;
            }
            if (bl) {
                if (null != errorLogger) {
                    errorLogger.reportWarning("That antenna name is already in use, please try again");
                }
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static ArrayList<KeyedRecord> getReceiveAntennaList(String string) {
        return AntPattern.getReceiveAntennaList(string, null);
    }

    public static ArrayList<KeyedRecord> getReceiveAntennaList(String string, ErrorLogger errorLogger) {
        ArrayList<KeyedRecord> arrayList = null;
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            try {
                arrayList = new ArrayList<KeyedRecord>();
                dbConnection.query("SELECT antenna_key, name FROM receive_antenna_index ORDER BY 2");
                while (dbConnection.next()) {
                    arrayList.add(new KeyedRecord(dbConnection.getInt(1), dbConnection.getString(2)));
                }
                DbCore.releaseDb(dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                arrayList = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        return arrayList;
    }

    public static AntPattern getReceiveAntenna(String string, int n) {
        return AntPattern.getReceiveAntenna(string, n, null, null);
    }

    public static AntPattern getReceiveAntenna(String string, int n, ErrorLogger errorLogger) {
        return AntPattern.getReceiveAntenna(string, n, null, errorLogger);
    }

    public static AntPattern getReceiveAntenna(String string, String string2) {
        return AntPattern.getReceiveAntenna(string, 0, string2, null);
    }

    public static AntPattern getReceiveAntenna(String string, String string2, ErrorLogger errorLogger) {
        return AntPattern.getReceiveAntenna(string, 0, string2, errorLogger);
    }

    private static AntPattern getReceiveAntenna(String string, int n, String string2, ErrorLogger errorLogger) {
        AntPattern antPattern = null;
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null != dbConnection) {
            try {
                antPattern = AntPattern.loadReceiveAntenna(string, dbConnection, n, string2);
                DbCore.releaseDb(dbConnection);
                if (null == antPattern && null != errorLogger && null == string2) {
                    errorLogger.reportError("Receive antenna not found for key " + n);
                }
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb(dbConnection);
                antPattern = null;
                DbConnection.reportError(errorLogger, sQLException);
            }
        }
        return antPattern;
    }

    public static AntPattern loadReceiveAntenna(String string, DbConnection dbConnection, int n) throws SQLException {
        return AntPattern.loadReceiveAntenna(string, dbConnection, n, null);
    }

    public static AntPattern loadReceiveAntenna(String string, DbConnection dbConnection, String string2) throws SQLException {
        return AntPattern.loadReceiveAntenna(string, dbConnection, 0, string2);
    }

    private static AntPattern loadReceiveAntenna(String string, DbConnection dbConnection, int n, String string2) throws SQLException {
        AntPattern antPattern = null;
        double d = 0.0;
        ArrayList<AntSlice> arrayList = null;
        if (null == string2) {
            dbConnection.query("SELECT antenna_key, name, gain FROM receive_antenna_index WHERE antenna_key = " + n);
        } else {
            dbConnection.query("SELECT antenna_key, name, gain FROM receive_antenna_index WHERE UPPER(name) = '" + DbConnection.clean(string2.toUpperCase()) + "'");
        }
        if (dbConnection.next()) {
            n = dbConnection.getInt(1);
            string2 = dbConnection.getString(2);
            d = dbConnection.getDouble(3);
            dbConnection.query("SELECT frequency, azimuth, relative_field FROM receive_pattern WHERE antenna_key = " + n + " ORDER BY 1, 2");
            ArrayList<AntPoint> arrayList2 = null;
            double d2 = 9.0;
            while (dbConnection.next()) {
                double d3 = dbConnection.getDouble(1);
                if (d3 != d2) {
                    if (null == arrayList) {
                        arrayList = new ArrayList<AntSlice>();
                    }
                    arrayList2 = new ArrayList<AntPoint>();
                    arrayList.add(new AntSlice(d3, arrayList2));
                    d2 = d3;
                }
                arrayList2.add(new AntPoint(dbConnection.getDouble(2), dbConnection.getDouble(3)));
            }
            antPattern = 1 == arrayList.size() ? new AntPattern(string, 3, string2, ((AntSlice)arrayList.get((int)0)).points) : new AntPattern(string, string2, 3, arrayList);
            antPattern.key = n;
            antPattern.gain = d;
        }
        return antPattern;
    }

    public static boolean deleteReceiveAntenna(String string, int n) {
        return AntPattern.deleteReceiveAntenna(string, n, null);
    }

    public static boolean deleteReceiveAntenna(String string, int n, ErrorLogger errorLogger) {
        DbConnection dbConnection = DbCore.connectDb(string, errorLogger);
        if (null == dbConnection) {
            return false;
        }
        String string2 = null;
        int n2 = 0;
        int n3 = 3;
        try {
            dbConnection.update("LOCK TABLES receive_antenna_index WRITE, receive_pattern WRITE, geography_receive_antenna WRITE");
            dbConnection.query("SELECT COUNT(*) FROM geography_receive_antenna WHERE antenna_key = " + n);
            dbConnection.next();
            n2 = dbConnection.getInt(1);
            if (0 == n2) {
                dbConnection.update("DELETE FROM receive_antenna_index WHERE antenna_key = " + n);
                dbConnection.update("DELETE FROM receive_pattern WHERE antenna_key = " + n);
            } else {
                string2 = "The antenna is in use and cannot be deleted";
                n3 = 2;
            }
        }
        catch (SQLException sQLException) {
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError(sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
        }
        catch (SQLException sQLException) {
            DbConnection.reportError(sQLException);
        }
        DbCore.releaseDb(dbConnection);
        if (null != string2) {
            if (null != errorLogger) {
                errorLogger.reportError(string2, n3);
            }
            return false;
        }
        return true;
    }

    public static AntPattern readFromText(String string, int n, File file, ErrorLogger errorLogger) {
        Object object;
        Object object2;
        double d;
        String string2;
        String string3;
        double d2;
        double d3;
        double d4;
        double d5;
        String string4;
        String string5;
        double d6;
        double d7;
        double d8;
        double d9;
        switch (n) {
            case 1: {
                d9 = 0.0;
                d8 = 0.0;
                d7 = 0.0;
                d6 = 0.0;
                string5 = "";
                string4 = "";
                d5 = 0.0;
                d4 = 359.999;
                d3 = -1.0;
                d2 = 1000.0;
                string3 = "Azimuth";
                string2 = "azimuth";
                break;
            }
            case 2: {
                d9 = 0.0;
                d8 = 359.999;
                d7 = -1.0;
                d6 = 1000.0;
                string5 = "Azimuth";
                string4 = "azimuth";
                d5 = -90.0;
                d4 = 90.0;
                d3 = -91.0;
                d2 = 1000.0;
                string3 = "Vertical angle";
                string2 = "vertical angle";
                break;
            }
            case 3: {
                d9 = 10.0;
                d8 = 5000.0;
                d7 = 9.0;
                d6 = 0.0;
                string5 = "Frequency";
                string4 = "frequency";
                d5 = 0.0;
                d4 = 359.999;
                d3 = -1.0;
                d2 = 1000.0;
                string3 = "Azimuth";
                string2 = "azimuth";
                break;
            }
            default: {
                if (null != errorLogger) {
                    errorLogger.reportError("Unknown or unsupported pattern type");
                }
                return null;
            }
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
        }
        catch (IOException iOException) {
            if (null != errorLogger) {
                errorLogger.reportError("Could not open file:\n" + iOException.getMessage());
            }
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        AppCore.LineCounter lineCounter = new AppCore.LineCounter();
        lineCounter.setDelimiterForFile(file);
        ArrayList<AntSlice> arrayList = new ArrayList<AntSlice>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = false;
        String string6 = "";
        AntSlice antSlice = null;
        ArrayList<AntPoint> arrayList2 = null;
        double d10 = d3;
        double d11 = 999.0;
        double d12 = -999.0;
        int n2 = 1;
        int n3 = 0;
        try {
            double d13;
            int n4;
            String[] stringArray = AppCore.readAndParseLine(bufferedReader, lineCounter, hashMap);
            if (null == stringArray) {
                bl = true;
                string6 = "Could not read first data line from file";
            } else if (stringArray.length < 2) {
                bl = true;
                string6 = "Bad data format, missing values";
            } else if (stringArray.length > 3) {
                n2 = 2;
            } else if (0 == stringArray[0].length()) {
                n2 = 2;
            } else if (3 == stringArray.length) {
                n2 = 3;
            }
            if (!bl && 1 == n && 1 != n2) {
                bl = true;
                string6 = "Bad data format, too many values";
            }
            if (!bl) {
                switch (n2) {
                    case 1: {
                        antSlice = new AntSlice(0.0);
                        arrayList.add(antSlice);
                        arrayList2 = antSlice.points;
                        break;
                    }
                    case 2: {
                        n3 = stringArray.length - 1;
                        for (n4 = 0; n4 < n3; ++n4) {
                            try {
                                d13 = Double.parseDouble(stringArray[n4 + 1]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                bl = true;
                                string6 = "Bad number format for " + string4;
                                break;
                            }
                            if (d6 > 0.0) {
                                d13 = Math.rint(d13 * d6) / d6;
                            }
                            if (d13 < d9 || d13 > d8) {
                                bl = true;
                                string6 = string5 + " out of range";
                                break;
                            }
                            if (d13 <= d7) {
                                bl = true;
                                string6 = string5 + " out of sequence or duplicated";
                                break;
                            }
                            d7 = d13;
                            antSlice = new AntSlice(d13);
                            arrayList.add(antSlice);
                        }
                        if (bl) break;
                        stringArray = AppCore.readAndParseLine(bufferedReader, lineCounter, hashMap);
                    }
                }
            }
            while (!bl && null != stringArray) {
                double d14;
                switch (n2) {
                    default: {
                        if (2 == stringArray.length) break;
                        bl = true;
                        break;
                    }
                    case 2: {
                        if (stringArray.length >= 1 && stringArray.length <= n3 + 1) break;
                        bl = true;
                        break;
                    }
                    case 3: {
                        if (3 == stringArray.length) break;
                        bl = true;
                    }
                }
                if (bl) {
                    string6 = "Bad data format, missing or extra values";
                    break;
                }
                int n5 = 0;
                if (3 == n2) {
                    n5 = 1;
                    try {
                        d13 = Double.parseDouble(stringArray[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = true;
                        string6 = "Bad number format for " + string4;
                        break;
                    }
                    if (d6 > 0.0) {
                        d13 = Math.rint(d13 * d6) / d6;
                    }
                    if (d13 < d9 || d13 > d8) {
                        bl = true;
                        string6 = string5 + " out of range";
                        break;
                    }
                    if (d13 != d7) {
                        if (d13 < d7) {
                            bl = true;
                            string6 = string5 + " out of sequence";
                            break;
                        }
                        antSlice = new AntSlice(d13);
                        arrayList.add(antSlice);
                        arrayList2 = antSlice.points;
                        d7 = d13;
                        d10 = d3;
                    }
                }
                try {
                    d14 = Double.parseDouble(stringArray[n5]);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                    string6 = "Bad number format for " + string2;
                    break;
                }
                d14 = Math.rint(d14 * d2) / d2;
                if (d14 < d5 || d14 > d4) {
                    bl = true;
                    string6 = string3 + " out of range";
                    break;
                }
                if (d14 <= d10) {
                    bl = true;
                    string6 = string3 + " out of sequence or duplicated";
                    break;
                }
                d10 = d14;
                if (2 == n2) {
                    for (n4 = 0; n4 < stringArray.length - 1; ++n4) {
                        if (0 == stringArray[n4 + 1].length()) continue;
                        try {
                            d = Double.parseDouble(stringArray[n4 + 1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = true;
                            string6 = "Bad number format for field";
                            break;
                        }
                        if (d < d11) {
                            d11 = d;
                        }
                        if (d > d12) {
                            d12 = d;
                        }
                        arrayList.get((int)n4).points.add(new AntPoint(d14, d));
                    }
                    if (bl) {
                        break;
                    }
                } else {
                    try {
                        d = Double.parseDouble(stringArray[n5 + 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = true;
                        string6 = "Bad number format for field";
                        break;
                    }
                    if (d < d11) {
                        d11 = d;
                    }
                    if (d > d12) {
                        d12 = d;
                    }
                    arrayList2.add(new AntPoint(d14, d));
                }
                stringArray = AppCore.readAndParseLine(bufferedReader, lineCounter, hashMap);
            }
            if (!bl) {
                if (1 == n2) {
                    if (arrayList2.size() < 2) {
                        bl = true;
                        string6 = "Not enough points in pattern";
                    }
                } else {
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        antSlice = (AntSlice)iterator.next();
                        if (antSlice.points.isEmpty()) {
                            iterator.remove();
                            continue;
                        }
                        if (antSlice.points.size() >= 2) continue;
                        bl = true;
                        string6 = "Not enough points in pattern, for " + string4 + " " + String.valueOf(antSlice.value);
                        break;
                    }
                    if (!bl && 0 == arrayList.size()) {
                        bl = true;
                        string6 = "No pattern slices found in file";
                    }
                    if (1 == arrayList.size()) {
                        n2 = 1;
                        arrayList2 = ((AntSlice)arrayList.get((int)0)).points;
                    }
                }
                if (bl) {
                    lineCounter.reset();
                }
            }
        }
        catch (IOException iOException) {
            bl = true;
            string6 = "Could not read from file:\n" + iOException.getMessage();
            lineCounter.reset();
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean bl2 = false;
        if (hashMap.containsKey(TEXT_META_KEY_DB)) {
            bl2 = true;
        } else {
            boolean bl3 = bl2 = d11 < 0.0 || d12 > 1.0;
        }
        if (!bl && !bl2 && d12 < 0.5) {
            bl = true;
            string6 = "Pattern maximum value is too small";
            lineCounter.reset();
        }
        if (bl) {
            if (null != errorLogger) {
                if (lineCounter.get() > 0) {
                    string6 = string6 + " at line " + lineCounter;
                }
                errorLogger.reportError(string6);
            }
            return null;
        }
        Object object3 = arrayList.iterator();
        while (object3.hasNext()) {
            object2 = (AntSlice)object3.next();
            object = ((AntSlice)object2).points.iterator();
            while (object.hasNext()) {
                AntPoint antPoint = object.next();
                d = antPoint.relativeField;
                if (bl2) {
                    d = Math.pow(10.0, (d - d12) / 20.0);
                }
                if ((d = Math.rint(d * 1000.0) / 1000.0) < 0.001) {
                    d = 0.001;
                }
                antPoint.relativeField = d;
            }
        }
        if (null != errorLogger) {
            if (bl2) {
                errorLogger.reportMessage("Pattern values converted from dB to relative field");
            } else if (d12 < 0.977) {
                errorLogger.reportWarning("Pattern does not have a 1");
            }
        }
        if (null == (object3 = hashMap.get(TEXT_META_KEY_NAME))) {
            object3 = "";
        }
        object2 = null;
        object2 = 1 == n2 ? new AntPattern(string, n, (String)object3, arrayList2) : new AntPattern(string, (String)object3, n, arrayList);
        if (3 == n) {
            if (bl2) {
                ((AntPattern)object2).gain = d12;
            }
            if (null != (object = hashMap.get(TEXT_META_KEY_GAIN))) {
                double d15 = -1.0;
                try {
                    d15 = Double.parseDouble((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (d15 < 0.0 || d15 > 60.0) {
                    if (null != errorLogger) {
                        errorLogger.reportWarning("Bad receive pattern gain value, ignored");
                    }
                } else {
                    ((AntPattern)object2).gain = d15;
                }
            }
        }
        return object2;
    }

    public static class AntSlice {
        public double value;
        public ArrayList<AntPoint> points;

        public AntSlice(double d) {
            this.value = d;
            this.points = new ArrayList();
        }

        public AntSlice(double d, ArrayList<AntPoint> arrayList) {
            this.value = d;
            this.points = arrayList;
        }

        public AntSlice copy() {
            ArrayList<AntPoint> arrayList = new ArrayList<AntPoint>();
            for (AntPoint antPoint : this.points) {
                arrayList.add(antPoint.copy());
            }
            return new AntSlice(this.value, arrayList);
        }
    }

    public static class AntPoint {
        public double angle;
        public double relativeField;

        public AntPoint(double d, double d2) {
            this.angle = d;
            this.relativeField = d2;
        }

        public AntPoint copy() {
            return new AntPoint(this.angle, this.relativeField);
        }
    }
}

