/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.api;

import gov.fcc.tvstudy.api.APIOperation;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.StationRecord;
import gov.fcc.tvstudy.core.data.Service;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;

public class SearchAPI
extends APIOperation {
    public static final String OP_START = "search";
    public static final String OP_RUN = "searchrun";
    public static final String OP_SHOW = "searchshow";
    public static final String KEY_USER_RECORD_ID = "user_record_id";
    public static final String KEY_EXT_DB_KEY = "ext_db_key";
    public static final String KEY_EXT_RECORD_ID = "ext_record_id";
    public static final String KEY_RECORD_ID = "record_id";
    public static final String KEY_FILE_NUMBER = "file_number";
    public static final String KEY_INCLUDE_ARCHIVED = "include_archived";
    private static final int MAX_RECORDS = 200;
    private ErrorLogger errors = new ErrorLogger();

    public static boolean canHandleOperation(String string) {
        return OP_START.equals(string) || OP_RUN.equals(string) || OP_SHOW.equals(string);
    }

    public SearchAPI(String string, HashMap<String, String> hashMap, String string2) {
        super(string, hashMap, string2);
        this.dispatchOperation(string);
    }

    @Override
    protected void dispatchOperation(String string) {
        if (OP_START.equals(string)) {
            this.doOpStart();
            return;
        }
        if (OP_RUN.equals(string)) {
            this.doOpRun();
            return;
        }
        if (OP_SHOW.equals(string)) {
            this.doOpShow();
            return;
        }
        super.dispatchOperation(string);
    }

    private void doOpStart() {
        StringBuilder stringBuilder = new StringBuilder();
        SearchAPI.addPageHeader(stringBuilder, "TVStudy - Record Search", 0, this.errorMessage);
        SearchAPI.addFormStart(stringBuilder, OP_RUN, OP_START, "New Search", OP_SHOW);
        Integer n = -1;
        String string = (String)this.parameters.get(KEY_EXT_DB_KEY);
        if (null != string) {
            try {
                n = Integer.valueOf(string);
                if (0 == n) {
                    n = null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!SearchAPI.addSearchFields(stringBuilder, this.parameters, n, this.errors)) {
            this.handleError(this.errors.toString(), this.backOp);
            return;
        }
        SearchAPI.addFormEnd(stringBuilder, "Search");
        SearchAPI.addPageFooter(stringBuilder);
        this.resultPage = stringBuilder.toString();
        this.status = 2;
    }

    private void doOpRun() {
        String string;
        AbstractList abstractList;
        if (null == this.backOp) {
            this.backOp = OP_START;
            this.backOpLabel = "New Search";
        }
        if (null == this.nextOp) {
            this.nextOp = OP_SHOW;
        }
        if (null != this.parameters.get(KEY_USER_RECORD_ID) || null != this.parameters.get(KEY_EXT_RECORD_ID)) {
            this.chainToOperation(this.nextOp);
            return;
        }
        ExtDb extDb = null;
        Integer n = null;
        String string2 = (String)this.parameters.get(KEY_EXT_DB_KEY);
        if (null != string2) {
            try {
                n = Integer.valueOf(string2);
                if (0 == n) {
                    n = null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.handleError("ERROR: Invalid station data key", this.backOp);
                return;
            }
        }
        if (null != n) {
            extDb = ExtDb.getExtDb((String)dbID, (Integer)n, (ErrorLogger)this.errors);
            if (null == extDb) {
                this.handleError(this.errors.toString(), this.backOp);
                return;
            }
            if (!extDb.canProvide(1)) {
                this.handleError("ERROR: Invalid station data key", this.backOp);
                return;
            }
        }
        int n2 = -1;
        int n3 = 0;
        boolean bl = true;
        if (null != extDb) {
            n2 = extDb.type;
            n3 = extDb.version;
            bl = extDb.isGeneric();
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl) {
                if (SourceEditData.addRecordIDQuery((int)n2, (String)((String)this.parameters.get(KEY_RECORD_ID)), (StringBuilder)stringBuilder, (boolean)false)) {
                    bl2 = true;
                }
            } else if (ExtDbRecord.addRecordIDQuery((int)n2, (int)n3, (int)1, (String)((String)this.parameters.get(KEY_RECORD_ID)), (StringBuilder)stringBuilder, (boolean)false)) {
                bl2 = true;
            }
            if (!bl2) {
                if (bl) {
                    if (SourceEditData.addFileNumberQuery((int)n2, (String)((String)this.parameters.get(KEY_FILE_NUMBER)), (StringBuilder)stringBuilder, (boolean)false)) {
                        bl2 = true;
                    }
                } else if (ExtDbRecord.addFileNumberQuery((int)n2, (int)n3, (int)1, (String)((String)this.parameters.get(KEY_FILE_NUMBER)), (StringBuilder)stringBuilder, (boolean)false)) {
                    bl2 = true;
                }
            }
            if (!bl2) {
                if (bl) {
                    if (SourceEditData.addFacilityIDQuery((int)n2, (String)((String)this.parameters.get("facility_id")), (StringBuilder)stringBuilder, (boolean)false)) {
                        bl2 = true;
                    }
                } else if (ExtDbRecord.addFacilityIDQuery((int)n2, (int)n3, (int)1, (String)((String)this.parameters.get("facility_id")), (StringBuilder)stringBuilder, (boolean)false)) {
                    bl2 = true;
                }
                if (bl) {
                    if (SourceEditData.addServiceQuery((int)n2, (String)((String)this.parameters.get("service")), (StringBuilder)stringBuilder, (boolean)bl2)) {
                        bl2 = true;
                    }
                } else if (ExtDbRecord.addServiceQuery((int)n2, (int)n3, (int)1, (String)((String)this.parameters.get("service")), (StringBuilder)stringBuilder, (boolean)bl2)) {
                    bl2 = true;
                }
                if (bl) {
                    if (SourceEditData.addCallSignQuery((int)n2, (String)((String)this.parameters.get("call_sign")), (StringBuilder)stringBuilder, (boolean)bl2)) {
                        bl2 = true;
                    }
                } else if (ExtDbRecord.addCallSignQuery((int)n2, (int)n3, (int)1, (String)((String)this.parameters.get("call_sign")), (StringBuilder)stringBuilder, (boolean)bl2)) {
                    bl2 = true;
                }
                if (bl) {
                    if (SourceEditData.addChannelQuery((int)n2, (String)((String)this.parameters.get("channel")), (StringBuilder)stringBuilder, (boolean)bl2)) {
                        bl3 = true;
                        bl2 = true;
                    }
                } else if (ExtDbRecord.addChannelQuery((int)n2, (int)n3, (int)1, (String)((String)this.parameters.get("channel")), (StringBuilder)stringBuilder, (boolean)bl2)) {
                    bl3 = true;
                    bl2 = true;
                }
                if (bl) {
                    if (SourceEditData.addStatusQuery((int)n2, (String)((String)this.parameters.get("status")), (StringBuilder)stringBuilder, (boolean)bl2)) {
                        bl2 = true;
                    }
                } else if (ExtDbRecord.addStatusQuery((int)n2, (int)n3, (int)1, (String)((String)this.parameters.get("status")), (StringBuilder)stringBuilder, (boolean)bl2)) {
                    bl2 = true;
                }
                if (bl) {
                    if (SourceEditData.addCityQuery((int)n2, (String)((String)this.parameters.get("city")), (StringBuilder)stringBuilder, (boolean)bl2)) {
                        bl2 = true;
                    }
                } else if (ExtDbRecord.addCityQuery((int)n2, (int)n3, (int)1, (String)((String)this.parameters.get("city")), (StringBuilder)stringBuilder, (boolean)bl2)) {
                    bl2 = true;
                }
                if (bl) {
                    if (SourceEditData.addStateQuery((int)n2, (String)((String)this.parameters.get("state")), (StringBuilder)stringBuilder, (boolean)bl2)) {
                        bl2 = true;
                    }
                } else if (ExtDbRecord.addStateQuery((int)n2, (int)n3, (int)1, (String)((String)this.parameters.get("state")), (StringBuilder)stringBuilder, (boolean)bl2)) {
                    bl2 = true;
                }
                if (!bl2) {
                    this.handleError("Please provide at least one search condition", this.backOp);
                    return;
                }
            }
            if (!bl3) {
                if (bl) {
                    SourceEditData.addChannelRangeQuery((int)n2, (int)2, (int)69, (StringBuilder)stringBuilder, (boolean)true);
                } else {
                    ExtDbRecord.addChannelRangeQuery((int)n2, (int)n3, (int)1, (int)2, (int)69, (StringBuilder)stringBuilder, (boolean)true);
                }
            }
            if (!bl) {
                string2 = (String)this.parameters.get(KEY_INCLUDE_ARCHIVED);
                boolean bl4 = null != string2 && Boolean.valueOf(string2) != false;
                ExtDbRecord.addRecordTypeQuery((int)n2, (int)n3, (int)1, (boolean)bl4, (StringBuilder)stringBuilder, (boolean)true);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.handleError("ERROR: " + illegalArgumentException.getMessage(), this.backOp);
            return;
        }
        ArrayList arrayList = new ArrayList();
        if (bl) {
            abstractList = null;
            abstractList = -1 == n2 ? SourceEditData.findUserRecords((String)dbID, (int)1, (String)stringBuilder.toString(), (ErrorLogger)this.errors) : SourceEditData.findImportRecords((ExtDb)extDb, (int)1, (String)stringBuilder.toString(), (ErrorLogger)this.errors);
            if (null == abstractList) {
                this.handleError(this.errors.toString(), this.backOp);
                return;
            }
            arrayList.addAll(abstractList);
        } else {
            abstractList = ExtDbRecordTV.findRecordsTV((ExtDb)extDb, (String)stringBuilder.toString(), (ErrorLogger)this.errors);
            if (null == abstractList) {
                this.handleError(this.errors.toString(), this.backOp);
                return;
            }
            arrayList.addAll(abstractList);
        }
        int n4 = arrayList.size();
        if (0 == n4) {
            this.handleError("Search did not find any matching records", this.backOp);
            return;
        }
        if (1 == n4) {
            if (null == extDb) {
                this.parameters.put(KEY_USER_RECORD_ID, ((StationRecord)arrayList.get(0)).getRecordID());
            } else {
                this.parameters.put(KEY_EXT_DB_KEY, String.valueOf(extDb.key));
                this.parameters.put(KEY_EXT_RECORD_ID, ((StationRecord)arrayList.get(0)).getRecordID());
            }
            this.chainToOperation(this.nextOp);
            return;
        }
        Collections.sort(arrayList, new Comparator<StationRecord>(){

            @Override
            public int compare(StationRecord stationRecord, StationRecord stationRecord2) {
                int n = stationRecord.getSortCountry().compareTo(stationRecord2.getSortCountry());
                if (0 == n && 0 == (n = stationRecord.getState().compareTo(stationRecord2.getState())) && 0 == (n = stationRecord.getCity().compareTo(stationRecord2.getCity())) && 0 == (n = stationRecord.getSortChannel().compareTo(stationRecord2.getSortChannel()))) {
                    n = stationRecord.getSortStatus().compareTo(stationRecord2.getSortStatus());
                }
                return n;
            }
        });
        StringBuilder stringBuilder2 = new StringBuilder();
        SearchAPI.addPageHeader(stringBuilder2, "TVStudy - Search Results", 0, this.errorMessage);
        SearchAPI.addFormStart(stringBuilder2, this.nextOp, this.backOp, this.backOpLabel, null);
        if (null == extDb) {
            string = KEY_USER_RECORD_ID;
        } else {
            string = KEY_EXT_RECORD_ID;
            stringBuilder2.append("<input type=\"hidden\" name=\"ext_db_key\" value=\"" + extDb.key + "\">\n");
        }
        if (n4 > 200) {
            stringBuilder2.append("<br>Too many records, only the first 200 are shown.<br>\n");
        }
        stringBuilder2.append("<br>Choose record:<br><br>\n");
        int n5 = 0;
        for (StationRecord stationRecord : arrayList) {
            if (++n5 > 200) break;
            stringBuilder2.append("<input type=\"radio\" name=\"" + string + "\" value=\"" + stationRecord.getRecordID() + "\">");
            SearchAPI.addRecordInfo(stringBuilder2, stationRecord);
        }
        stringBuilder2.append("<br>\n");
        SearchAPI.addHiddenFields(stringBuilder2, this.parameters);
        SearchAPI.addFormEnd(stringBuilder2, "Choose");
        SearchAPI.addFormStart(stringBuilder2, this.backOp);
        SearchAPI.addHiddenFields(stringBuilder2, this.parameters);
        SearchAPI.addFormEnd(stringBuilder2, this.backOpLabel);
        SearchAPI.addPageFooter(stringBuilder2);
        this.resultPage = stringBuilder2.toString();
        this.status = 2;
    }

    private void doOpShow() {
        if (null == this.backOp) {
            this.backOp = OP_START;
            this.backOpLabel = "New Search";
        }
        SearchResult searchResult = SearchAPI.getSearchResult(this.parameters);
        if (null != searchResult.errorMessage) {
            this.handleError(searchResult.errorMessage, this.backOp);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        SearchAPI.addPageHeader(stringBuilder, "TVStudy - Record Found", 0, this.errorMessage);
        SearchAPI.addResultSummary(stringBuilder, searchResult);
        SearchAPI.addFormStart(stringBuilder, this.backOp);
        SearchAPI.addHiddenFields(stringBuilder, this.parameters);
        SearchAPI.addFormEnd(stringBuilder, this.backOpLabel);
        SearchAPI.addPageFooter(stringBuilder);
        this.resultPage = stringBuilder.toString();
        this.status = 2;
    }

    public static boolean addSearchFields(StringBuilder stringBuilder, HashMap<String, String> hashMap, Integer n) {
        return SearchAPI.addSearchFields(stringBuilder, hashMap, n, null);
    }

    public static boolean addSearchFields(StringBuilder stringBuilder, HashMap<String, String> hashMap, Integer n, ErrorLogger errorLogger) {
        stringBuilder.append("<br>Station data:<br><br>");
        stringBuilder.append("<select name=\"ext_db_key\">\n");
        ArrayList arrayList = ExtDb.getExtDbList((String)dbID, (int)1, (ErrorLogger)errorLogger);
        if (null == arrayList) {
            return false;
        }
        boolean bl = true;
        for (Object object : arrayList) {
            if (bl && (((KeyedRecord)object).key < 10000 || ((KeyedRecord)object).key > 19999)) {
                if (null == n) {
                    stringBuilder.append("<option value=\"0\" selected>User records</option>\n");
                } else {
                    stringBuilder.append("<option value=\"0\">User records</option>\n");
                }
                bl = false;
            }
            if (null != n && n == ((KeyedRecord)object).key) {
                stringBuilder.append("<option value=\"" + ((KeyedRecord)object).key + "\" selected>" + ((KeyedRecord)object).name + "</option>\n");
                continue;
            }
            stringBuilder.append("<option value=\"" + ((KeyedRecord)object).key + "\">" + ((KeyedRecord)object).name + "</option>\n");
        }
        if (bl) {
            if (null == n) {
                stringBuilder.append("<option value=\"0\" selected>User records</option>\n");
            } else {
                stringBuilder.append("<option value=\"0\">User records</option>\n");
            }
        }
        stringBuilder.append("</select><br>\n");
        stringBuilder.append("<br>Search for records:<br><br>\n");
        stringBuilder.append("<table>\n");
        stringBuilder.append("<tr><td>Record ID</td>\n");
        Object object = hashMap.get(KEY_RECORD_ID);
        if (null != object) {
            stringBuilder.append("<td><input type=\"text\" name=\"record_id\" value=\"" + (String)object + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"record_id\"></td>\n");
        }
        stringBuilder.append("<tr><td>File number</td>\n");
        object = hashMap.get(KEY_FILE_NUMBER);
        if (null != object) {
            stringBuilder.append("<td><input type=\"text\" name=\"file_number\" value=\"" + (String)object + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"file_number\"></td>\n");
        }
        object = hashMap.get("facility_id");
        stringBuilder.append("<tr><td>Facility ID</td>\n");
        if (null != object) {
            stringBuilder.append("<td><input type=\"text\" name=\"facility_id\" value=\"" + (String)object + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"facility_id\"></td>\n");
        }
        object = hashMap.get("call_sign");
        stringBuilder.append("<tr><td>Call sign</td>\n");
        if (null != object) {
            stringBuilder.append("<td><input type=\"text\" name=\"call_sign\" value=\"" + (String)object + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"call_sign\"></td>\n");
        }
        object = hashMap.get("channel");
        stringBuilder.append("<tr><td>Channel</td>\n");
        if (null != object) {
            stringBuilder.append("<td><input type=\"text\" name=\"channel\" value=\"" + (String)object + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"channel\"></td>\n");
        }
        object = hashMap.get("service");
        stringBuilder.append("<tr><td>Service</td>");
        stringBuilder.append("<td><select name=\"service\">\n");
        stringBuilder.append("<option value=\"\">(any)</option>\n");
        for (Service service : Service.getAllServices()) {
            if (service.serviceCode.equals(object)) {
                stringBuilder.append("<option value=\"" + service.serviceCode + "\" selected>" + service.name + "</option>\n");
                continue;
            }
            stringBuilder.append("<option value=\"" + service.serviceCode + "\">" + service.name + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        object = hashMap.get("status");
        stringBuilder.append("<tr><td>Status</td>\n");
        stringBuilder.append("<td><select name=\"status\">\n");
        stringBuilder.append("<option value=\"\">(any)</option>\n");
        for (Service service : ExtDbRecord.getStatusList()) {
            if (service.name.equals(object)) {
                stringBuilder.append("<option value=\"" + service.name + "\" selected>" + service.name + "</option>\n");
                continue;
            }
            stringBuilder.append("<option value=\"" + service.name + "\">" + service.name + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        object = hashMap.get("city");
        stringBuilder.append("<tr><td>City</td>\n");
        if (null != object) {
            stringBuilder.append("<td><input type=\"text\" name=\"city\" value=\"" + (String)object + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"city\"></td>\n");
        }
        object = hashMap.get("state");
        stringBuilder.append("<tr><td>State</td>\n");
        if (null != object) {
            stringBuilder.append("<td><input type=\"text\" name=\"state\" value=\"" + (String)object + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"state\"></td>\n");
        }
        SearchAPI.addYesNoSelect(stringBuilder, KEY_INCLUDE_ARCHIVED, hashMap.get(KEY_INCLUDE_ARCHIVED), false, "Include archived records");
        stringBuilder.append("</table><br>\n");
        return true;
    }

    public static void addHiddenFields(StringBuilder stringBuilder, HashMap<String, String> hashMap) {
        String string = hashMap.get(KEY_EXT_DB_KEY);
        if (null != string) {
            stringBuilder.append("<input type=\"hidden\" name=\"ext_db_key\" value=\"" + string + "\">\n");
        }
        if (null != (string = hashMap.get("call_sign"))) {
            stringBuilder.append("<input type=\"hidden\" name=\"call_sign\" value=\"" + string + "\">\n");
        }
        if (null != (string = hashMap.get("channel"))) {
            stringBuilder.append("<input type=\"hidden\" name=\"channel\" value=\"" + string + "\">\n");
        }
        if (null != (string = hashMap.get("service"))) {
            stringBuilder.append("<input type=\"hidden\" name=\"service\" value=\"" + string + "\">\n");
        }
        if (null != (string = hashMap.get("status"))) {
            stringBuilder.append("<input type=\"hidden\" name=\"status\" value=\"" + string + "\">\n");
        }
        if (null != (string = hashMap.get("city"))) {
            stringBuilder.append("<input type=\"hidden\" name=\"city\" value=\"" + string + "\">\n");
        }
        if (null != (string = hashMap.get("state"))) {
            stringBuilder.append("<input type=\"hidden\" name=\"state\" value=\"" + string + "\">\n");
        }
        if (null != (string = hashMap.get("facility_id"))) {
            stringBuilder.append("<input type=\"hidden\" name=\"facility_id\" value=\"" + string + "\">\n");
        }
        if (null != (string = hashMap.get(KEY_INCLUDE_ARCHIVED))) {
            stringBuilder.append("<input type=\"hidden\" name=\"include_archived\" value=\"" + string + "\">\n");
        }
    }

    public static void addRecordInfo(StringBuilder stringBuilder, StationRecord stationRecord) {
        stringBuilder.append(stationRecord.getCallSign());
        stringBuilder.append(' ');
        stringBuilder.append(stationRecord.getChannel());
        stringBuilder.append(' ');
        stringBuilder.append(stationRecord.getServiceCode());
        stringBuilder.append(' ');
        String string = stationRecord.getStatus();
        if (string.length() > 0) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        }
        stringBuilder.append(stationRecord.getCity());
        stringBuilder.append(", ");
        stringBuilder.append(stationRecord.getState());
        stringBuilder.append("<br>\n");
    }

    public static SearchResult getSearchResult(HashMap<String, String> hashMap) {
        StringBuilder stringBuilder = new StringBuilder();
        ErrorLogger errorLogger = new ErrorLogger();
        SearchResult searchResult = new SearchResult();
        String string = hashMap.get(KEY_USER_RECORD_ID);
        if (null != string) {
            try {
                SourceEditData.addRecordIDQuery((int)-1, (String)string, (StringBuilder)stringBuilder, (boolean)false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                searchResult.errorMessage = "ERROR: " + illegalArgumentException.toString();
                return searchResult;
            }
            ArrayList arrayList = SourceEditData.findUserRecords((String)dbID, (int)1, (String)stringBuilder.toString(), (ErrorLogger)errorLogger);
            if (null == arrayList) {
                searchResult.errorMessage = errorLogger.toString();
            } else if (arrayList.isEmpty()) {
                searchResult.errorMessage = "ERROR: Record not found";
            } else {
                searchResult.source = (SourceEditDataTV)arrayList.get(0);
            }
            return searchResult;
        }
        int n = 0;
        string = hashMap.get(KEY_EXT_DB_KEY);
        if (null != string) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n <= 0) {
            searchResult.errorMessage = "ERROR: Missing or invalid station data key";
            return searchResult;
        }
        ExtDb extDb = ExtDb.getExtDb((String)dbID, (Integer)n, (ErrorLogger)errorLogger);
        if (null == extDb) {
            searchResult.errorMessage = errorLogger.toString();
            return searchResult;
        }
        if (!extDb.canProvide(1)) {
            searchResult.errorMessage = "ERROR: Invalid station data key";
            return searchResult;
        }
        string = hashMap.get(KEY_EXT_RECORD_ID);
        if (null != string) {
            try {
                if (extDb.isGeneric()) {
                    SourceEditData.addRecordIDQuery((int)extDb.type, (String)string, (StringBuilder)stringBuilder, (boolean)false);
                }
                ExtDbRecord.addRecordIDQuery((int)extDb.type, (int)extDb.version, (int)1, (String)string, (StringBuilder)stringBuilder, (boolean)false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                searchResult.errorMessage = "ERROR: " + illegalArgumentException.getMessage();
                return searchResult;
            }
        } else {
            string = hashMap.get(KEY_FILE_NUMBER);
            if (null != string) {
                try {
                    if (extDb.isGeneric()) {
                        SourceEditData.addFileNumberQuery((int)extDb.type, (String)string, (StringBuilder)stringBuilder, (boolean)false);
                    }
                    ExtDbRecord.addFileNumberQuery((int)extDb.type, (int)extDb.version, (int)1, (String)string, (StringBuilder)stringBuilder, (boolean)false);
                    ExtDbRecord.addRecordTypeQuery((int)extDb.type, (int)extDb.version, (int)1, (boolean)false, (StringBuilder)stringBuilder, (boolean)true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    searchResult.errorMessage = "ERROR: " + illegalArgumentException.getMessage();
                    return searchResult;
                }
            } else {
                searchResult.errorMessage = "ERROR: Missing record ID or file number";
                return searchResult;
            }
        }
        if (extDb.isGeneric()) {
            LinkedList linkedList = SourceEditData.findImportRecords((ExtDb)extDb, (int)1, (String)stringBuilder.toString(), (ErrorLogger)errorLogger);
            if (null == linkedList) {
                searchResult.errorMessage = errorLogger.toString();
            } else if (linkedList.isEmpty()) {
                searchResult.errorMessage = "ERROR: Record not found";
            } else if (linkedList.size() > 1) {
                searchResult.errorMessage = "ERROR: ID or file number matches more than one record";
            } else {
                searchResult.source = (SourceEditDataTV)linkedList.getFirst();
            }
        } else {
            LinkedList linkedList = ExtDbRecordTV.findRecordsTV((ExtDb)extDb, (String)stringBuilder.toString(), (ErrorLogger)errorLogger);
            if (null == linkedList) {
                searchResult.errorMessage = errorLogger.toString();
            } else if (linkedList.isEmpty()) {
                searchResult.errorMessage = "ERROR: Record not found";
            } else if (linkedList.size() > 1) {
                searchResult.errorMessage = "ERROR: ID or file number matches more than one record";
            } else {
                searchResult.record = (ExtDbRecordTV)linkedList.getFirst();
            }
        }
        return searchResult;
    }

    public static void addResultSummary(StringBuilder stringBuilder, SearchResult searchResult) {
        if (null != searchResult.source) {
            SearchAPI.doSummary(stringBuilder, (StationRecord)searchResult.source, SourceEditData.getSourceComment((SourceEditData)searchResult.source));
        } else if (null != searchResult.record) {
            SearchAPI.doSummary(stringBuilder, (StationRecord)searchResult.record, "");
        } else {
            stringBuilder.append("<br><b>" + searchResult.errorMessage + "</b><br><br>\n");
        }
    }

    private static void doSummary(StringBuilder stringBuilder, StationRecord stationRecord, String string) {
        stringBuilder.append("<table>\n");
        stringBuilder.append("<tr><td>Call sign</td><td>");
        stringBuilder.append(stationRecord.getCallSign());
        stringBuilder.append("</td>\n");
        stringBuilder.append("<tr><td>Channel</td><td>");
        stringBuilder.append(stationRecord.getChannel());
        stringBuilder.append("</td>\n");
        stringBuilder.append("<tr><td>Service</td><td>");
        stringBuilder.append(stationRecord.getService());
        stringBuilder.append("</td>\n");
        String string2 = stationRecord.getStatus();
        if (string2.length() > 0) {
            stringBuilder.append("<tr><td>Status</td><td>");
            stringBuilder.append(string2);
            stringBuilder.append("</td>\n");
        }
        stringBuilder.append("<tr><td>City</td><td>");
        stringBuilder.append(stationRecord.getCity());
        stringBuilder.append("</td>\n");
        stringBuilder.append("<tr><td>State</td><td>");
        stringBuilder.append(stationRecord.getState());
        stringBuilder.append("</td>\n");
        stringBuilder.append("<tr><td>Facility ID</td><td>");
        stringBuilder.append(stationRecord.getFacilityID());
        stringBuilder.append("</td>\n");
        if (stationRecord.hasRecordID()) {
            stringBuilder.append("<tr><td>Station data</td><td>");
            stringBuilder.append(stationRecord.getStationData());
            stringBuilder.append("</td>\n");
            stringBuilder.append("<tr><td>Record ID</td><td>");
            stringBuilder.append(stationRecord.getRecordID());
            stringBuilder.append("</td>\n");
        }
        if ((string2 = stationRecord.getFileNumber()).length() > 0) {
            stringBuilder.append("<tr><td>File number</td><td>");
            stringBuilder.append(string2);
            stringBuilder.append("</td>\n");
        }
        stringBuilder.append("<tr><td>Country</td><td>");
        stringBuilder.append(stationRecord.getCountry());
        stringBuilder.append("</td>\n");
        string2 = stationRecord.getZone();
        if (string2.length() > 0) {
            stringBuilder.append("<tr><td>Zone</td><td>");
            stringBuilder.append(string2);
            stringBuilder.append("</td>\n");
        }
        if ((string2 = stationRecord.getFrequencyOffset()).length() > 0) {
            stringBuilder.append("<tr><td>Frequency offset</td><td>");
            stringBuilder.append(string2);
            stringBuilder.append("</td>\n");
        }
        if ((string2 = stationRecord.getEmissionMask()).length() > 0) {
            stringBuilder.append("<tr><td>Emission mask</td><td>");
            stringBuilder.append(string2);
            stringBuilder.append("</td>\n");
        }
        stringBuilder.append("<tr><td>Latitude</td><td>");
        stringBuilder.append(stationRecord.getLatitude());
        stringBuilder.append("</td>\n");
        stringBuilder.append("<tr><td>Longitude</td><td>");
        stringBuilder.append(stationRecord.getLongitude());
        stringBuilder.append("</td>\n");
        if (stationRecord.isDTS()) {
            stringBuilder.append("<tr><td># DTS sites</td><td>");
            stringBuilder.append(stationRecord.getSiteCount());
            stringBuilder.append("</td>\n");
        } else {
            stringBuilder.append("<tr><td>Height AMSL</td><td>");
            stringBuilder.append(stationRecord.getHeightAMSL());
            stringBuilder.append("</td>\n");
            stringBuilder.append("<tr><td>HAAT</td><td>");
            stringBuilder.append(stationRecord.getOverallHAAT());
            stringBuilder.append("</td>\n");
            stringBuilder.append("<tr><td>Peak ERP</td><td>");
            stringBuilder.append(stationRecord.getPeakERP());
            stringBuilder.append("</td>\n");
            if (stationRecord.hasHorizontalPattern()) {
                stringBuilder.append("<tr><td>Azimuth pattern</td><td>");
                stringBuilder.append(stationRecord.getHorizontalPatternName());
                stringBuilder.append("</td>\n");
                stringBuilder.append("<tr><td>Orientation</td><td>");
                stringBuilder.append(stationRecord.getHorizontalPatternOrientation());
                stringBuilder.append("</td>\n");
            }
        }
        if (null != string && string.length() > 0) {
            stringBuilder.append("<tr><td>Comment</td><td width=\"200\">");
            stringBuilder.append(string);
            stringBuilder.append("</td>\n");
        }
        stringBuilder.append("</table><br>\n");
    }

    public static class SearchResult {
        public SourceEditDataTV source;
        public ExtDbRecordTV record;
        public String errorMessage;

        public boolean isDigital() {
            if (null != this.source) {
                return this.source.service.isDigital();
            }
            if (null != this.record) {
                return this.record.service.isDigital();
            }
            return false;
        }

        public boolean isLPTV() {
            if (null != this.source) {
                return this.source.service.isLPTV();
            }
            if (null != this.record) {
                return this.record.service.isLPTV();
            }
            return false;
        }

        public boolean isClassA() {
            if (null != this.source) {
                return this.source.service.isClassA();
            }
            if (null != this.record) {
                return this.record.service.isClassA();
            }
            return false;
        }

        public Date getSequenceDate() {
            if (null != this.source) {
                Date date = AppCore.parseDate((String)this.source.getAttribute("sequenceDate"));
                if (null == date) {
                    date = new Date();
                }
                return date;
            }
            if (null != this.record) {
                return this.record.sequenceDate;
            }
            return null;
        }
    }
}

