/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.api;

import gov.fcc.tvstudy.api.APIOperation;
import gov.fcc.tvstudy.api.SearchAPI;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.OutputConfig;
import gov.fcc.tvstudy.core.StatusLogger;
import gov.fcc.tvstudy.core.StudyBuildIxCheck;
import gov.fcc.tvstudy.core.data.Template;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeSet;

public class IxCheckAPI
extends APIOperation
implements StatusLogger {
    public static final String OP_START = "ixcheck";
    public static final String OP_SETUP = "ixchecksetup";
    public static final String OP_RUN = "ixcheckrun";
    public static final String KEY_REPLICATION_CHANNEL = "replication_channel";
    public static final String KEY_TEMPLATE_KEY = "template_key";
    public static final String KEY_STUDY_EXT_DB_KEY = "study_ext_db_key";
    public static final String KEY_OUTPUT_CONFIG = "output_config";
    public static final String KEY_MAP_OUTPUT_CONFIG = "map_output_config";
    public static final String KEY_CELL_SIZE = "cell_size";
    public static final String KEY_PROFILE_PPK = "profile_ppk";
    public static final String KEY_PROFILE_PT_INC = "profile_pt_inc";
    public static final String KEY_PROTECT_NON_BL = "protect_non_bl";
    public static final String KEY_LPTV_PROTECT_BL = "lptv_protect_bl";
    public static final String KEY_CLASS_A_PROTECT_LPTV = "class_a_protect_lptv";
    public static final String KEY_INCLUDE_FOREIGN = "include_foreign";
    public static final String KEY_INCLUDE_USERIDS = "include_userids";
    public static final String KEY_CP_EXCLUDES_BASELINE = "cp_excludes_baseline";
    public static final String KEY_EXCLUDE_APPS = "ignore_apps";
    public static final String KEY_INCLUDE_AMD = "include_amd";
    public static final String KEY_EXCLUDE_PENDING = "ignore_pending";
    public static final String KEY_EXCLUDE_POST_TRANSITION = "ignore_post_trans";
    public static final String KEY_EXCLUDE_NEW_LPTV = "ignore_new_lptv";
    public static final String KEY_EXCLUDE_ARNS = "exclude_arns";
    public static final String KEY_FILING_CUTOFF = "filing_cutoff";
    public static final String KEY_RERUN = "rerun";
    public static final String KEY_SHOWPAST = "showpast";
    public static final String OP_CACHE = "ixcheckcache";
    public static final String KEY_ACTION = "cache_action";
    public static final String ACTION_CLEANUP = "cleanup";
    public static final String ACTION_DELETE = "delete";
    public static final String KEY_DAYS = "delete_days";
    private static Path outPath = outRootPath.resolve("out");
    private ErrorLogger errors;
    private StudyBuildIxCheck ixCheck;
    private IxCheckAPI outerThis;

    protected static void servletStartup(String string) {
        StudyBuildIxCheck.cacheCleanup((String)string, (Path)outPath, null);
    }

    public static boolean canHandleOperation(String string) {
        return OP_START.equals(string) || OP_SETUP.equals(string) || OP_RUN.equals(string) || OP_CACHE.equals(string);
    }

    public IxCheckAPI(String string, HashMap<String, String> hashMap, String string2) {
        block2: {
            block3: {
                block4: {
                    super(string, hashMap, string2);
                    this.outerThis = this;
                    this.errors = new ErrorLogger();
                    if (OP_CACHE.equals(string)) break block2;
                    this.ixCheck = new StudyBuildIxCheck(dbID);
                    this.ixCheck.outPath = outPath;
                    this.ixCheck.indexFileName = "index.html";
                    this.ixCheck.logFileName = "log.txt";
                    this.ixCheck.loadDefaults();
                    if (this.ixCheck.templateKey <= 0) break block3;
                    if (null == this.ixCheck.extDb) break block4;
                    if (!StudyBuildIxCheck.isExtDbSupported((ExtDb)this.ixCheck.extDb)) break block3;
                }
                if (null != this.ixCheck.fileOutputConfig && this.ixCheck.fileOutputConfig.isValid() && null != this.ixCheck.mapOutputConfig && this.ixCheck.mapOutputConfig.isValid()) break block2;
            }
            this.handleError("ERROR: Could not load default study settings", this.backOp);
            return;
        }
        this.dispatchOperation(string);
    }

    @Override
    protected void dispatchOperation(String string) {
        if (OP_START.equals(string)) {
            this.doOpStart();
            return;
        }
        if (OP_SETUP.equals(string)) {
            this.doOpSetup();
            return;
        }
        if (OP_RUN.equals(string)) {
            this.doOpRun();
            return;
        }
        if (OP_CACHE.equals(string)) {
            this.doOpCache();
            return;
        }
        super.dispatchOperation(string);
    }

    private void doOpStart() {
        StringBuilder stringBuilder = new StringBuilder();
        IxCheckAPI.addPageHeader(stringBuilder, "TVStudy - Interference Check", 0, this.errorMessage);
        stringBuilder.append("Find record for interference check study<br>");
        IxCheckAPI.addFormStart(stringBuilder, "searchrun", OP_START, "New Search", OP_SETUP);
        Integer n = -1;
        if (null != this.ixCheck.extDb) {
            n = this.ixCheck.extDb.key;
        }
        if (!SearchAPI.addSearchFields(stringBuilder, this.parameters, n, this.errors)) {
            this.handleError(this.errors.toString(), this.backOp);
            return;
        }
        IxCheckAPI.addFormEnd(stringBuilder, "Search");
        IxCheckAPI.addFormStart(stringBuilder, "record", OP_START, "Cancel", OP_SETUP);
        SearchAPI.addHiddenFields(stringBuilder, this.parameters);
        IxCheckAPI.addFormEnd(stringBuilder, "Create New Record");
        IxCheckAPI.addPageFooter(stringBuilder);
        this.resultPage = stringBuilder.toString();
        this.status = 2;
    }

    private void doOpSetup() {
        if (null == this.backOp) {
            this.backOp = OP_START;
            this.backOpLabel = "New Search";
        }
        if (null == this.parameters.get("ext_db_key") && null != this.ixCheck.extDb) {
            this.parameters.put("ext_db_key", String.valueOf(this.ixCheck.extDb.key));
        }
        SearchAPI.SearchResult searchResult = SearchAPI.getSearchResult(this.parameters);
        if (null != searchResult.errorMessage) {
            this.handleError(searchResult.errorMessage, this.backOp);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        IxCheckAPI.addPageHeader(stringBuilder, "TVStudy Interference Check", 0, this.errorMessage);
        stringBuilder.append("<br>Selected record<br><br>\n");
        SearchAPI.addResultSummary(stringBuilder, searchResult);
        stringBuilder.append("<br>Study settings:<br><br>\n");
        IxCheckAPI.addFormStart(stringBuilder, OP_RUN, this.backOp, this.backOpLabel, null);
        if (null != searchResult.source) {
            stringBuilder.append("<input type=\"hidden\" name=\"user_record_id\" value=\"" + searchResult.source.userRecordID + "\">\n");
        } else {
            stringBuilder.append("<input type=\"hidden\" name=\"ext_db_key\" value=\"" + searchResult.record.extDb.key + "\">\n");
            stringBuilder.append("<input type=\"hidden\" name=\"ext_record_id\" value=\"" + searchResult.record.extRecordID + "\">\n");
        }
        stringBuilder.append("<input type=\"hidden\" name=\"showpast\" value=\"true\">\n");
        stringBuilder.append("<table>\n");
        stringBuilder.append("<tr><td>Replicate to channel</td>\n");
        String string = (String)this.parameters.get(KEY_REPLICATION_CHANNEL);
        if (null != string) {
            stringBuilder.append("<td><input type=\"text\" name=\"replication_channel\" value=\"" + string + "\"></td>\n");
        } else if (null != searchResult.record && searchResult.record.replicateToChannel > 0) {
            stringBuilder.append("<td><input type=\"text\" name=\"replication_channel\" value=\"" + String.valueOf(searchResult.record.replicateToChannel) + "\"></td>\n");
        } else {
            stringBuilder.append("<td><input type=\"text\" name=\"replication_channel\"></td>\n");
        }
        stringBuilder.append("<tr><td>Template</td>\n");
        stringBuilder.append("<td><select name=\"template_key\">\n");
        ArrayList arrayList = Template.getTemplateInfoList((String)dbID, (ErrorLogger)this.errors);
        if (null == arrayList) {
            this.handleError(this.errors.toString(), this.backOp);
            return;
        }
        for (Object object : arrayList) {
            Template.Info info = (Template.Info)object;
            if (!info.isLocked || info.isLockedInStudy) continue;
            if (info.key == this.ixCheck.templateKey) {
                stringBuilder.append("<option value=\"" + info.key + "\" selected>" + info.name + "</option>\n");
                continue;
            }
            stringBuilder.append("<option value=\"" + info.key + "\">" + info.name + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        stringBuilder.append("<tr><td>Study station data</td>\n");
        stringBuilder.append("<td><select name=\"study_ext_db_key\">\n");
        arrayList = ExtDb.getExtDbList((String)dbID, (int)2, (int)6, (ErrorLogger)this.errors);
        if (null == arrayList) {
            this.handleError(this.errors.toString(), this.backOp);
            return;
        }
        int n = -1;
        if (null != searchResult.record) {
            n = searchResult.record.extDb.key;
        } else if (null != this.ixCheck.extDb) {
            n = this.ixCheck.extDb.key;
        }
        for (Object object : arrayList) {
            if (n == ((KeyedRecord)object).key) {
                stringBuilder.append("<option value=\"" + ((KeyedRecord)object).key + "\" selected>" + ((KeyedRecord)object).name + "</option>\n");
                continue;
            }
            stringBuilder.append("<option value=\"" + ((KeyedRecord)object).key + "\">" + ((KeyedRecord)object).name + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        stringBuilder.append("<tr><td>Output file settings</td>\n");
        stringBuilder.append("<td><select name=\"output_config\">\n");
        boolean bl = false;
        for (OutputConfig outputConfig : OutputConfig.getConfigs((String)dbID, (int)1)) {
            if (outputConfig.equals((Object)this.ixCheck.fileOutputConfig)) {
                stringBuilder.append("<option value=\"" + outputConfig.getCodes() + "\"selected>" + outputConfig.name + "</option>\n");
                bl = true;
                continue;
            }
            stringBuilder.append("<option value=\"" + outputConfig.getCodes() + "\">" + outputConfig.name + "</option>\n");
        }
        if (!bl) {
            stringBuilder.append("<option value=\"" + this.ixCheck.fileOutputConfig.getCodes() + "\"selected>" + this.ixCheck.fileOutputConfig.name + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        stringBuilder.append("<tr><td>Map output settings</td>\n");
        stringBuilder.append("<td><select name=\"output_config\">\n");
        bl = false;
        for (OutputConfig outputConfig : OutputConfig.getConfigs((String)dbID, (int)2)) {
            if (outputConfig.equals((Object)this.ixCheck.mapOutputConfig)) {
                stringBuilder.append("<option value=\"" + outputConfig.getCodes() + "\"selected>" + outputConfig.name + "</option>\n");
                bl = true;
                continue;
            }
            stringBuilder.append("<option value=\"" + outputConfig.getCodes() + "\">" + outputConfig.name + "</option>\n");
        }
        if (!bl) {
            stringBuilder.append("<option value=\"" + this.ixCheck.mapOutputConfig.getCodes() + "\"selected>" + this.ixCheck.mapOutputConfig.name + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        boolean bl2 = searchResult.isLPTV();
        boolean bl3 = searchResult.isClassA();
        boolean bl4 = null != this.ixCheck.filingWindowEndDate && null != searchResult.getSequenceDate() && searchResult.getSequenceDate().after(this.ixCheck.filingWindowEndDate);
        string = (String)this.parameters.get(KEY_CELL_SIZE);
        if (null == string && null == (string = this.ixCheck.cellSize) && null == (string = bl2 || bl3 && bl4 ? this.ixCheck.defaultCellSizeLPTV : this.ixCheck.defaultCellSize)) {
            string = "";
        }
        double d = StudyBuildIxCheck.CELL_SIZES[0];
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        stringBuilder.append("<tr><td>Cell size, km</td>\n");
        stringBuilder.append("<td><select name=\"cell_size\">\n");
        for (double d2 : StudyBuildIxCheck.CELL_SIZES) {
            String string2 = AppCore.formatDecimal((double)d2, (int)1);
            if (d >= d2) {
                stringBuilder.append("<option value=\"" + string2 + "\"selected>" + string2 + "</option>\n");
                d = 0.0;
                continue;
            }
            stringBuilder.append("<option value=\"" + string2 + "\">" + string2 + "</option>\n");
        }
        stringBuilder.append("</select></td>\n");
        string = (String)this.parameters.get(KEY_PROFILE_PT_INC);
        if (null == string) {
            string = (String)this.parameters.get(KEY_PROFILE_PPK);
            if (null == string && null == (string = this.ixCheck.profilePpk) && null == (string = bl2 || bl3 && bl4 ? this.ixCheck.defaultProfilePpkLPTV : this.ixCheck.defaultProfilePpk)) {
                string = "";
            }
            try {
                double d3 = Double.parseDouble(string);
                if (d3 > 0.0) {
                    string = AppCore.formatDecimal((double)(1.0 / d3), (int)2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        stringBuilder.append("<tr><td>Profile point spacing, km</td>\n");
        stringBuilder.append("<td><input type=\"text\" name=\"profile_pt_inc\" value=\"" + string + "\"></td>\n");
        IxCheckAPI.addYesNoSelect(stringBuilder, KEY_PROTECT_NON_BL, (String)this.parameters.get(KEY_PROTECT_NON_BL), this.ixCheck.protectPreBaseline || bl2, "Protect records not on baseline channel");
        if (bl2) {
            IxCheckAPI.addYesNoSelect(stringBuilder, KEY_LPTV_PROTECT_BL, (String)this.parameters.get(KEY_LPTV_PROTECT_BL), this.ixCheck.protectBaselineFromLPTV, "Protect baseline records from LPTV");
        }
        if (bl3 && !bl4) {
            IxCheckAPI.addYesNoSelect(stringBuilder, KEY_CLASS_A_PROTECT_LPTV, (String)this.parameters.get(KEY_CLASS_A_PROTECT_LPTV), this.ixCheck.protectLPTVFromClassA, "Protect LPTV records from Class A");
        }
        IxCheckAPI.addYesNoSelect(stringBuilder, KEY_INCLUDE_FOREIGN, (String)this.parameters.get(KEY_INCLUDE_FOREIGN), this.ixCheck.includeForeign, "Include non-U.S. records");
        string = (String)this.parameters.get(KEY_INCLUDE_USERIDS);
        if (null == string) {
            string = "";
        }
        stringBuilder.append("<tr><td>User records to include</td>\n");
        stringBuilder.append("<td><textarea rows=\"4\" cols=\"18\" name=\"include_userids\">" + string + "</textarea></td>\n");
        IxCheckAPI.addYesNoSelect(stringBuilder, KEY_CP_EXCLUDES_BASELINE, (String)this.parameters.get(KEY_CP_EXCLUDES_BASELINE), this.ixCheck.cpExcludesBaseline, "CP excludes station's baseline");
        IxCheckAPI.addYesNoSelect(stringBuilder, KEY_EXCLUDE_APPS, (String)this.parameters.get(KEY_EXCLUDE_APPS), this.ixCheck.excludeApps, "Exclude all APP records");
        IxCheckAPI.addYesNoSelect(stringBuilder, KEY_INCLUDE_AMD, (String)this.parameters.get(KEY_INCLUDE_AMD), this.ixCheck.includeAmendments, "Include all AMD records");
        IxCheckAPI.addYesNoSelect(stringBuilder, KEY_EXCLUDE_PENDING, (String)this.parameters.get(KEY_EXCLUDE_PENDING), this.ixCheck.excludePending, "Exclude pending license records");
        IxCheckAPI.addYesNoSelect(stringBuilder, KEY_EXCLUDE_POST_TRANSITION, (String)this.parameters.get(KEY_EXCLUDE_POST_TRANSITION), this.ixCheck.excludePostTransition, "Exclude all post-transition CP, APP, and BL records");
        IxCheckAPI.addYesNoSelect(stringBuilder, KEY_EXCLUDE_NEW_LPTV, (String)this.parameters.get(KEY_EXCLUDE_NEW_LPTV), this.ixCheck.excludeNewLPTV, "Exclude records for new LPTV stations");
        string = (String)this.parameters.get(KEY_EXCLUDE_ARNS);
        if (null == string) {
            string = "";
        }
        stringBuilder.append("<tr><td>Record to exclude (ARNs)</td>\n");
        stringBuilder.append("<td><textarea rows=\"4\" cols=\"18\" name=\"exclude_arns\">" + string + "</textarea></td>\n");
        string = (String)this.parameters.get(KEY_FILING_CUTOFF);
        if (null == string) {
            string = null != this.ixCheck.filingCutoffDate ? AppCore.formatDate((Date)this.ixCheck.filingCutoffDate) : "";
        }
        stringBuilder.append("<tr><td>Filing cutoff date</td>\n");
        stringBuilder.append("<td><input type=\"text\" name=\"filing_cutoff\" value=\"" + string + "\"></td>\n");
        stringBuilder.append("</table>\n");
        IxCheckAPI.addFormEnd(stringBuilder, "Run Study");
        IxCheckAPI.addFormStart(stringBuilder, this.backOp);
        SearchAPI.addHiddenFields(stringBuilder, this.parameters);
        IxCheckAPI.addFormEnd(stringBuilder, this.backOpLabel);
        IxCheckAPI.addPageFooter(stringBuilder);
        this.resultPage = stringBuilder.toString();
        this.status = 2;
    }

    private void doOpRun() {
        String string;
        boolean bl;
        SearchAPI.SearchResult searchResult;
        block83: {
            block80: {
                String[] stringArray;
                block82: {
                    block81: {
                        int n;
                        int n2;
                        boolean bl2;
                        if (null == this.parameters.get("ext_db_key") && null != this.ixCheck.extDb) {
                            this.parameters.put("ext_db_key", String.valueOf(this.ixCheck.extDb.key));
                        }
                        searchResult = SearchAPI.getSearchResult(this.parameters);
                        if (null != searchResult.errorMessage) {
                            this.handleError(searchResult.errorMessage, this.backOp);
                            return;
                        }
                        this.ixCheck.source = searchResult.source;
                        this.ixCheck.record = searchResult.record;
                        if (null != searchResult.source) {
                            bl = searchResult.source.service.isLPTV();
                            bl2 = searchResult.source.service.isDigital();
                            n2 = searchResult.source.channel;
                        } else {
                            bl = searchResult.record.service.isLPTV();
                            bl2 = searchResult.record.service.isDigital();
                            n2 = searchResult.record.channel;
                        }
                        string = (String)this.parameters.get(KEY_REPLICATION_CHANNEL);
                        if (null != string) {
                            n = 0;
                            try {
                                n = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n < 2 || n > 69) {
                                this.handleError("ERROR: Invalid replication channel", OP_SETUP);
                                return;
                            }
                            if (n != n2 || !bl2) {
                                this.ixCheck.replicate = true;
                                this.ixCheck.studyChannel = n;
                            }
                        }
                        if (null != (string = (String)this.parameters.get(KEY_TEMPLATE_KEY))) {
                            n = 0;
                            try {
                                n = Integer.parseInt(string);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            stringArray = null;
                            if (n > 0) {
                                stringArray = Template.getTemplateInfo((String)dbID, (int)n);
                            }
                            if (null == stringArray || !stringArray.isLocked || stringArray.isLockedInStudy) {
                                this.handleError("ERROR: Invalid study template selection", OP_SETUP);
                                return;
                            }
                            this.ixCheck.templateKey = n;
                        }
                        if (null == (string = (String)this.parameters.get(KEY_STUDY_EXT_DB_KEY))) break block80;
                        n = 0;
                        try {
                            n = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        stringArray = null;
                        if (n > 0) {
                            stringArray = ExtDb.getExtDb((String)dbID, (Integer)n);
                        }
                        if (null == stringArray) break block81;
                        if (StudyBuildIxCheck.isExtDbSupported((ExtDb)stringArray)) break block82;
                    }
                    this.handleError("ERROR: Invalid station data set selection", OP_SETUP);
                    return;
                }
                this.ixCheck.extDb = stringArray;
                break block83;
            }
            if (null != searchResult.record) {
                this.ixCheck.extDb = searchResult.record.extDb;
            }
        }
        if (null == this.ixCheck.extDb) {
            this.handleError("ERROR: No station data available", this.backOp);
            return;
        }
        string = (String)this.parameters.get(KEY_OUTPUT_CONFIG);
        if (null != string) {
            this.ixCheck.fileOutputConfig = new OutputConfig(1, string);
        }
        if (null != (string = (String)this.parameters.get(KEY_MAP_OUTPUT_CONFIG))) {
            this.ixCheck.mapOutputConfig = new OutputConfig(2, string);
        }
        if (null != (string = (String)this.parameters.get(KEY_CELL_SIZE))) {
            double d = -0.9;
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (d < 0.1 || d > 10.0) {
                this.handleError("ERROR: Bad cell size", OP_SETUP);
                return;
            }
            this.ixCheck.cellSize = string;
        }
        if (null != (string = (String)this.parameters.get(KEY_PROFILE_PT_INC))) {
            double d = 0.0;
            try {
                d = Double.parseDouble(string);
                if (d > 0.0) {
                    d = 1.0 / d;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (d < 1.0 || d > 50.0) {
                this.handleError("ERROR: Bad profile point spacing", OP_SETUP);
                return;
            }
            this.ixCheck.profilePpk = String.valueOf(d);
        } else {
            string = (String)this.parameters.get(KEY_PROFILE_PPK);
            if (null != string) {
                double d = 0.0;
                try {
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (d < 1.0 || d > 50.0) {
                    this.handleError("ERROR: Bad profile resolution", OP_SETUP);
                    return;
                }
                this.ixCheck.profilePpk = string;
            }
        }
        string = (String)this.parameters.get(KEY_PROTECT_NON_BL);
        this.ixCheck.protectPreBaseline = null != string ? Boolean.valueOf(string) : bl;
        string = (String)this.parameters.get(KEY_LPTV_PROTECT_BL);
        if (null != string) {
            this.ixCheck.protectBaselineFromLPTV = Boolean.valueOf(string);
        }
        if (null != (string = (String)this.parameters.get(KEY_CLASS_A_PROTECT_LPTV))) {
            this.ixCheck.protectLPTVFromClassA = Boolean.valueOf(string);
        }
        if (null != (string = (String)this.parameters.get(KEY_INCLUDE_FOREIGN))) {
            this.ixCheck.includeForeign = Boolean.valueOf(string);
        }
        this.ixCheck.includeUserRecords = null;
        string = (String)this.parameters.get(KEY_INCLUDE_USERIDS);
        if (null != string) {
            this.ixCheck.includeUserRecords = new TreeSet();
            for (String iterator : string.split("\\s+")) {
                int n = 0;
                try {
                    n = Integer.parseInt(iterator);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n <= 0) {
                    this.handleError("ERROR: Bad user record ID in include list", OP_SETUP);
                    return;
                }
                this.ixCheck.includeUserRecords.add(n);
            }
        }
        if (null != (string = (String)this.parameters.get(KEY_CP_EXCLUDES_BASELINE))) {
            this.ixCheck.cpExcludesBaseline = Boolean.valueOf(string);
        }
        if (null != (string = (String)this.parameters.get(KEY_EXCLUDE_APPS))) {
            this.ixCheck.excludeApps = Boolean.valueOf(string);
        }
        if (null != (string = (String)this.parameters.get(KEY_INCLUDE_AMD))) {
            this.ixCheck.includeAmendments = Boolean.valueOf(string);
        }
        if (null != (string = (String)this.parameters.get(KEY_EXCLUDE_PENDING))) {
            this.ixCheck.excludePending = Boolean.valueOf(string);
        }
        if (null != (string = (String)this.parameters.get(KEY_EXCLUDE_POST_TRANSITION))) {
            this.ixCheck.excludePostTransition = Boolean.valueOf(string);
        }
        if (null != (string = (String)this.parameters.get(KEY_EXCLUDE_NEW_LPTV))) {
            this.ixCheck.excludeNewLPTV = Boolean.valueOf(string);
        }
        this.ixCheck.excludeCommands = null;
        string = (String)this.parameters.get(KEY_EXCLUDE_ARNS);
        if (null != string) {
            this.ixCheck.excludeCommands = new TreeSet();
            for (String string2 : string.split("\\s+")) {
                this.ixCheck.excludeCommands.add(string2);
            }
        }
        if (null != (string = (String)this.parameters.get(KEY_FILING_CUTOFF))) {
            this.ixCheck.filingCutoffDate = AppCore.parseDate((String)string);
            if (null == this.ixCheck.filingCutoffDate) {
                this.handleError("ERROR: Bad cutoff date, use format YYYY-MM-DD or MM/DD/YYYY", OP_SETUP);
                return;
            }
        }
        if (!this.ixCheck.initialize(this.errors)) {
            this.handleError(this.errors.toString(), OP_SETUP);
            return;
        }
        string = (String)this.parameters.get(KEY_RERUN);
        if (null == string || !Boolean.valueOf(string).booleanValue()) {
            ArrayList arrayList = this.ixCheck.getPastRuns(this.errors);
            if (null == arrayList) {
                this.handleError(this.errors.toString(), OP_SETUP);
                return;
            }
            if (!arrayList.isEmpty()) {
                string = (String)this.parameters.get(KEY_SHOWPAST);
                if (null == string || !Boolean.valueOf(string).booleanValue()) {
                    this.resultURL = this.ixCheck.getIndexURLPath();
                    this.status = 3;
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    IxCheckAPI.addPageHeader(stringBuilder, "TVStudy - Past Study Results", 0, null);
                    stringBuilder.append("<br>");
                    stringBuilder.append(this.ixCheck.getStudyDescription());
                    stringBuilder.append("<br>\n");
                    stringBuilder.append("<br>Past study results<br><br>\n");
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, Locale.US);
                    for (StudyBuildIxCheck.RunIndex runIndex : arrayList) {
                        stringBuilder.append("<a href=\"");
                        stringBuilder.append(runIndex.indexURLPath);
                        stringBuilder.append("\">");
                        stringBuilder.append(dateFormat.format(runIndex.runDate));
                        stringBuilder.append("</a><br>\n");
                    }
                    stringBuilder.append("<br><a href=\"/tvstudy/api?op=");
                    stringBuilder.append(OP_RUN);
                    if (null != searchResult.source) {
                        stringBuilder.append('&');
                        stringBuilder.append("user_record_id");
                        stringBuilder.append('=');
                        stringBuilder.append(String.valueOf(searchResult.source.userRecordID));
                    } else {
                        stringBuilder.append('&');
                        stringBuilder.append("ext_db_key");
                        stringBuilder.append('=');
                        stringBuilder.append(String.valueOf(searchResult.record.extDb.key));
                        stringBuilder.append('&');
                        stringBuilder.append("ext_record_id");
                        stringBuilder.append('=');
                        stringBuilder.append(searchResult.record.extRecordID);
                    }
                    if (this.ixCheck.replicate) {
                        stringBuilder.append('&');
                        stringBuilder.append(KEY_REPLICATION_CHANNEL);
                        stringBuilder.append('=');
                        stringBuilder.append(String.valueOf(this.ixCheck.studyChannel));
                    }
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_TEMPLATE_KEY);
                    stringBuilder.append('=');
                    stringBuilder.append(String.valueOf(this.ixCheck.templateKey));
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_STUDY_EXT_DB_KEY);
                    stringBuilder.append('=');
                    stringBuilder.append(String.valueOf(this.ixCheck.extDb.key));
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_OUTPUT_CONFIG);
                    stringBuilder.append('=');
                    stringBuilder.append(this.ixCheck.fileOutputConfig.getCodes());
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_MAP_OUTPUT_CONFIG);
                    stringBuilder.append('=');
                    stringBuilder.append(this.ixCheck.mapOutputConfig.getCodes());
                    if (null != this.ixCheck.cellSize) {
                        stringBuilder.append('&');
                        stringBuilder.append(KEY_CELL_SIZE);
                        stringBuilder.append('=');
                        stringBuilder.append(this.ixCheck.cellSize);
                    }
                    if (null != this.ixCheck.profilePpk) {
                        stringBuilder.append('&');
                        stringBuilder.append(KEY_PROFILE_PPK);
                        stringBuilder.append('=');
                        stringBuilder.append(this.ixCheck.profilePpk);
                    }
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_PROTECT_NON_BL);
                    stringBuilder.append(this.ixCheck.protectPreBaseline ? "=true" : "=false");
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_LPTV_PROTECT_BL);
                    stringBuilder.append(this.ixCheck.protectBaselineFromLPTV ? "=true" : "=false");
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_CLASS_A_PROTECT_LPTV);
                    stringBuilder.append(this.ixCheck.protectLPTVFromClassA ? "=true" : "=false");
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_INCLUDE_FOREIGN);
                    stringBuilder.append('=');
                    stringBuilder.append(String.valueOf(this.ixCheck.includeForeign));
                    if (null != this.ixCheck.includeUserRecords) {
                        stringBuilder.append('&');
                        stringBuilder.append(KEY_INCLUDE_USERIDS);
                        int n = 61;
                        for (Object object : this.ixCheck.includeUserRecords) {
                            stringBuilder.append((char)n);
                            stringBuilder.append(String.valueOf(object));
                            n = 43;
                        }
                    }
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_CP_EXCLUDES_BASELINE);
                    stringBuilder.append('=');
                    stringBuilder.append(String.valueOf(this.ixCheck.cpExcludesBaseline));
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_EXCLUDE_APPS);
                    stringBuilder.append('=');
                    stringBuilder.append(String.valueOf(this.ixCheck.excludeApps));
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_INCLUDE_AMD);
                    stringBuilder.append('=');
                    stringBuilder.append(String.valueOf(this.ixCheck.includeAmendments));
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_EXCLUDE_PENDING);
                    stringBuilder.append('=');
                    stringBuilder.append(String.valueOf(this.ixCheck.excludePending));
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_EXCLUDE_POST_TRANSITION);
                    stringBuilder.append('=');
                    stringBuilder.append(String.valueOf(this.ixCheck.excludePostTransition));
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_EXCLUDE_NEW_LPTV);
                    stringBuilder.append('=');
                    stringBuilder.append(String.valueOf(this.ixCheck.excludeNewLPTV));
                    if (null != this.ixCheck.excludeCommands) {
                        stringBuilder.append('&');
                        stringBuilder.append(KEY_EXCLUDE_ARNS);
                        int n = 61;
                        for (Object object : this.ixCheck.excludeCommands) {
                            stringBuilder.append((char)n);
                            try {
                                stringBuilder.append(URLEncoder.encode((String)object, "UTF-8"));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            n = 43;
                        }
                    }
                    if (null != this.ixCheck.filingCutoffDate) {
                        stringBuilder.append('&');
                        stringBuilder.append(KEY_FILING_CUTOFF);
                        stringBuilder.append('=');
                        stringBuilder.append(AppCore.formatDate((Date)this.ixCheck.filingCutoffDate));
                    }
                    stringBuilder.append('&');
                    stringBuilder.append(KEY_RERUN);
                    stringBuilder.append("=true");
                    stringBuilder.append("\">Re-run study now</a><br>\n");
                    IxCheckAPI.addPageFooter(stringBuilder);
                    this.resultPage = stringBuilder.toString();
                    this.status = 2;
                }
                return;
            }
        }
        if (!this.ixCheck.willRunStudy(this.errors)) {
            this.handleError(this.errors.toString(), OP_SETUP);
            return;
        }
        try {
            IxCheckAPI.writeInProgressIndex(this.ixCheck.getStudyOutDirectoryPath(), this.ixCheck.getStudyDescription(), "Study queued, waiting to start...");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new Thread(){

            @Override
            public void run() {
                String string = "Study complete";
                IxCheckAPI.this.errors.clearErrors();
                if (!IxCheckAPI.this.ixCheck.runStudy((StatusLogger)IxCheckAPI.this.outerThis, IxCheckAPI.this.errors)) {
                    string = IxCheckAPI.this.errors.hasErrors() ? IxCheckAPI.this.errors.toString() : "Errors occurred during the study run, see log file for details";
                }
                try {
                    APIOperation.writeFileIndex(IxCheckAPI.this.ixCheck.getStudyOutDirectoryPath(), IxCheckAPI.this.ixCheck.getStudyDescription(), string, IxCheckAPI.this.ixCheck.getStudyReport(), IxCheckAPI.this.ixCheck.getOutputFiles());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        this.resultURL = this.ixCheck.getIndexURLPath();
        this.status = 3;
    }

    public synchronized void reportStatus(String string) {
        try {
            IxCheckAPI.writeInProgressIndex(this.ixCheck.getStudyOutDirectoryPath(), this.ixCheck.getStudyDescription(), string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void logMessage(String string) {
    }

    public void showMessage(String string) {
    }

    public boolean isCanceled() {
        return false;
    }

    private void doOpCache() {
        StringBuilder stringBuilder = new StringBuilder();
        IxCheckAPI.addPageHeader(stringBuilder, "TVStudy Interference Check Cache Maintenance", 0, this.errorMessage);
        String string = (String)this.parameters.get(KEY_ACTION);
        if (null != string) {
            IxCheckAPI.addFormStart(stringBuilder, OP_CACHE);
            if (ACTION_DELETE.equals(string)) {
                int n = 60;
                string = (String)this.parameters.get(KEY_DAYS);
                if (null != string) {
                    try {
                        int n2 = Integer.parseInt(string);
                        if (n2 >= 0) {
                            n = n2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                StudyBuildIxCheck.cacheDelete((String)dbID, (Path)outPath, (int)n, (StringBuilder)stringBuilder);
            } else if (ACTION_CLEANUP.equals(string)) {
                StudyBuildIxCheck.cacheCleanup((String)dbID, (Path)outPath, (StringBuilder)stringBuilder);
            } else {
                stringBuilder.append("<br><b>ERROR: Unknown cache maintenance action '" + string + "'</b><br><br>\n");
            }
            IxCheckAPI.addFormEnd(stringBuilder, "OK");
        } else {
            StudyBuildIxCheck.cacheReport((String)dbID, (Path)outPath, (StringBuilder)stringBuilder);
            IxCheckAPI.addFormStart(stringBuilder, OP_CACHE);
            stringBuilder.append("<input type=\"hidden\" name=\"cache_action\" value=\"delete\">\n");
            stringBuilder.append("Delete study output older than&nbsp;\n");
            stringBuilder.append("<input type=\"text\" name=\"delete_days\" size=\"8\" value=\"60\">\n");
            stringBuilder.append("&nbsp;days.<br>\n");
            IxCheckAPI.addFormEnd(stringBuilder, "Delete");
            IxCheckAPI.addFormStart(stringBuilder, OP_CACHE);
            stringBuilder.append("<input type=\"hidden\" name=\"cache_action\" value=\"cleanup\">\n");
            stringBuilder.append("Cache cleanup repairs the cache index and removes inaccessible output.<br>\n");
            stringBuilder.append("A cleanup may be needed if 'Page not found' errors are appearing.<br>\n");
            IxCheckAPI.addFormEnd(stringBuilder, "Cleanup");
        }
        IxCheckAPI.addPageFooter(stringBuilder);
        this.resultPage = stringBuilder.toString();
        this.status = 2;
    }
}

