/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.api;

import gov.fcc.tvstudy.api.IxCheckAPI;
import gov.fcc.tvstudy.api.RecordAPI;
import gov.fcc.tvstudy.api.SearchAPI;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class APIOperation {
    public static final String INDEX_FILE_NAME = "index.html";
    public static final String LOG_FILE_NAME = "log.txt";
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_ERROR = 1;
    public static final int STATUS_PAGE = 2;
    public static final int STATUS_URL = 3;
    public static final int STATUS_CHAIN = 4;
    public static final String KEY_OP = "op";
    public static final String KEY_BACK_OP = "back_op";
    public static final String KEY_BACK_OP_LABEL = "back_op_label";
    public static final String KEY_NEXT_OP = "next_op";
    public static final String OP_MENU = "menu";
    public static final String OP_PREFS = "prefs";
    private static final HashSet<Object> servlets = new HashSet();
    protected static String dbID;
    protected static Path outRootPath;
    protected HashMap<String, String> parameters;
    protected String backOp;
    protected String backOpLabel;
    protected String nextOp;
    protected String errorMessage;
    protected int status;
    protected String resultPage;
    protected String resultURL;
    protected APIOperation chainOperation;
    protected static final int IN_PROGRESS_RELOAD_TIME = 3;
    private static boolean didCoreInit;

    public static synchronized String servletInit(Object object, String string, String string2) {
        boolean bl;
        if (servlets.contains(object)) {
            return "ERROR: Servlet instance has already been initialized";
        }
        boolean bl2 = false;
        if (!didCoreInit) {
            bl2 = true;
            try {
                Class.forName("com.mysql.jdbc.Driver").newInstance();
                Class.forName("org.postgresql.Driver").newInstance();
            }
            catch (Throwable throwable) {
                return "ERROR: Could not load database driver: " + throwable;
            }
            AppCore.initialize((String)string, (boolean)false, (boolean)true);
            didCoreInit = true;
        } else {
            bl = false;
            try {
                bl = Files.isSameFile(Paths.get(string, new String[0]), AppCore.workingDirectoryPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl) {
                return "ERROR: Cannot change working directory";
            }
        }
        if (null != AppCore.fileCheckError) {
            return "ERROR: " + AppCore.fileCheckError;
        }
        if (AppCore.maxEngineProcessCount < 0) {
            return "ERROR: Study engine is not installed or not functioning";
        }
        if (0 == AppCore.maxEngineProcessCount) {
            return "ERROR: Insufficient memory available, study engine cannot run";
        }
        if (!servlets.isEmpty()) {
            bl = false;
            try {
                bl = Files.isSameFile(Paths.get(string2, new String[0]), outRootPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl) {
                return "ERROR: Cannot change output directory";
            }
            servlets.add(object);
            DbCore.openDb((String)dbID, (Object)object);
            return null;
        }
        outRootPath = Paths.get(string2, new String[0]).toAbsolutePath();
        Properties properties = new Properties();
        try {
            properties.load(Files.newInputStream(AppCore.libDirectoryPath.resolve("api_login.props"), new OpenOption[0]));
        }
        catch (IOException iOException) {
            return "ERROR: Could not load database login properties: " + iOException;
        }
        String string3 = properties.getProperty("host");
        String string4 = properties.getProperty("name");
        String string5 = properties.getProperty("user");
        String string6 = properties.getProperty("pass");
        if (null == string3 || null == string5 || null == string6) {
            return "ERROR: Missing database login properties";
        }
        if (null == string4) {
            string4 = "tvstudy";
        }
        ErrorLogger errorLogger = new ErrorLogger();
        DbCore.DbInfo dbInfo = new DbCore.DbInfo(string3, string4, string5, string6, errorLogger);
        if (dbInfo.connectionFailed) {
            if (errorLogger.hasErrors()) {
                return errorLogger.toString();
            }
            return "ERROR: " + dbInfo.setupError;
        }
        if (!DbCore.registerDb((DbCore.DbInfo)dbInfo, (ErrorLogger)errorLogger)) {
            return errorLogger.toString();
        }
        if (bl2) {
            IxCheckAPI.servletStartup(dbInfo.dbID);
        }
        dbID = dbInfo.dbID;
        servlets.add(object);
        DbCore.openDb((String)dbID, (Object)object);
        return null;
    }

    public static synchronized void servletDestroy(Object object) {
        DbCore.closeDb((String)dbID, (Object)object);
        servlets.remove(object);
    }

    public static APIOperation getOperation(Map<String, String[]> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        if (null == dbID) {
            return new APIOperation(string, hashMap, "ERROR: Database connection has not been initialized");
        }
        for (String string2 : map.keySet()) {
            String string3;
            String[] stringArray = map.get(string2);
            if (null == stringArray || stringArray.length <= 0 || (string3 = stringArray[0].trim()).length() <= 0) continue;
            if (KEY_OP.equals(string2)) {
                string = string3;
                continue;
            }
            hashMap.put(string2, string3);
        }
        return APIOperation.getOperation(string, hashMap, null);
    }

    protected static APIOperation getOperation(String string, HashMap<String, String> hashMap, String string2) {
        if (null == string) {
            return new APIOperation(OP_MENU, hashMap, string2);
        }
        if (APIOperation.canHandleOperation(string)) {
            return new APIOperation(string, hashMap, string2);
        }
        if (SearchAPI.canHandleOperation(string)) {
            return new SearchAPI(string, hashMap, string2);
        }
        if (RecordAPI.canHandleOperation(string)) {
            return new RecordAPI(string, hashMap, string2);
        }
        if (IxCheckAPI.canHandleOperation(string)) {
            return new IxCheckAPI(string, hashMap, string2);
        }
        return new APIOperation(OP_MENU, hashMap, "ERROR: Unknown operation '" + string + "'");
    }

    public static boolean canHandleOperation(String string) {
        return OP_MENU.equals(string) || OP_PREFS.equals(string);
    }

    public APIOperation(String string, HashMap<String, String> hashMap, String string2) {
        this.parameters = hashMap;
        this.errorMessage = string2;
        if (OP_MENU.equals(string)) {
            this.doOpMenu();
            return;
        }
        if (OP_PREFS.equals(string)) {
            this.doOpPrefs();
            return;
        }
        this.backOp = this.parameters.get(KEY_BACK_OP);
        if (null != this.backOp) {
            if (this.backOp.equals(string)) {
                this.backOp = null;
            } else {
                this.backOpLabel = this.parameters.get(KEY_BACK_OP_LABEL);
                if (null == this.backOpLabel) {
                    this.backOpLabel = "Back";
                }
            }
        }
        this.nextOp = this.parameters.get(KEY_NEXT_OP);
        if (null != this.nextOp && this.nextOp.equals(string)) {
            this.nextOp = null;
        }
        this.status = null != this.errorMessage ? 1 : 0;
    }

    private void doOpMenu() {
        StringBuilder stringBuilder = new StringBuilder();
        APIOperation.addPageHeader(stringBuilder, "TVStudy - Main Menu", 0, this.errorMessage);
        stringBuilder.append("TVStudy Main Menu<br><br>\n");
        stringBuilder.append("<a href=\"/tvstudy/api?op=ixcheck\">Interference check study</a><br>\n");
        stringBuilder.append("<a href=\"/tvstudy/api?op=search\">Station data search</a><br>\n");
        stringBuilder.append("<a href=\"/tvstudy/api?op=record\">Create user record</a><br>\n");
        stringBuilder.append("<br><a href=\"/tvstudy/api?op=ixcheckcache\">Interference check cache maintenance</a><br>\n");
        stringBuilder.append("<br><a href=\"/tvstudy/api?op=prefs\">Preferences</a><br>\n");
        stringBuilder.append("<br>TVStudy v");
        stringBuilder.append(AppCore.appVersionString);
        stringBuilder.append(", study engine v");
        stringBuilder.append(AppCore.engineVersionString);
        stringBuilder.append("<br>\n");
        APIOperation.addPageFooter(stringBuilder, false);
        this.resultPage = stringBuilder.toString();
        this.status = 2;
    }

    private void doOpPrefs() {
        StringBuilder stringBuilder = new StringBuilder();
        APIOperation.addPageHeader(stringBuilder, "TVStudy Preferences", 0, this.errorMessage);
        stringBuilder.append("Interference Check Default Settings<br><br>\n");
        APIOperation.addFormStart(stringBuilder, OP_PREFS);
        stringBuilder.append("<table>\n");
        String string = this.parameters.get("include_foreign");
        if (null == string) {
            string = AppCore.getPreference((String)"ixCheckIncludeForeignDefault");
        } else {
            AppCore.setPreference((String)"ixCheckIncludeForeignDefault", (String)string);
        }
        APIOperation.addYesNoSelect(stringBuilder, "include_foreign", string, false, "Include non-U.S. records");
        string = this.parameters.get("cp_excludes_baseline");
        if (null == string) {
            string = AppCore.getPreference((String)"ixCheckDefaultCPExcludesBL");
        } else {
            AppCore.setPreference((String)"ixCheckDefaultCPExcludesBL", (String)string);
        }
        APIOperation.addYesNoSelect(stringBuilder, "cp_excludes_baseline", string, false, "CP excludes station's baseline");
        string = this.parameters.get("ignore_new_lptv");
        if (null == string) {
            string = AppCore.getPreference((String)"ixCheckDefaultExcludeNewLPTV");
        } else {
            AppCore.setPreference((String)"ixCheckDefaultExcludeNewLPTV", (String)string);
        }
        APIOperation.addYesNoSelect(stringBuilder, "ignore_new_lptv", string, false, "Exclude records for new LPTV stations");
        stringBuilder.append("</table>\n");
        APIOperation.addFormEnd(stringBuilder, "Save");
        APIOperation.addPageFooter(stringBuilder);
        this.resultPage = stringBuilder.toString();
        this.status = 2;
    }

    protected void dispatchOperation(String string) {
        if (null == this.errorMessage) {
            this.errorMessage = null != string ? "ERROR: Unknown operation '" + string + "'" : "ERROR: No operation specified";
        }
        this.status = 1;
    }

    protected void chainToOperation(String string) {
        if (APIOperation.canHandleOperation(string)) {
            this.dispatchOperation(string);
        } else {
            this.chainOperation = APIOperation.getOperation(string, this.parameters, this.errorMessage);
            this.status = 4;
        }
    }

    protected void handleError(String string, String string2) {
        this.errorMessage = null != string ? string : "ERROR: handleError() called with no error message";
        if (null != string2) {
            this.chainToOperation(string2);
        } else {
            this.status = 1;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getResultPage() {
        return this.resultPage;
    }

    public String getResultURL() {
        return this.resultURL;
    }

    public APIOperation getChainOperation() {
        return this.chainOperation;
    }

    public static String makeErrorPage(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        APIOperation.addPageHeader(stringBuilder, "TVStudy - Error", 0, string);
        APIOperation.addPageFooter(stringBuilder);
        return stringBuilder.toString();
    }

    protected static void writeInProgressIndex(Path path, String string, String string2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        APIOperation.addPageHeader(stringBuilder, "TVStudy - Study In Progress", 3, null);
        stringBuilder.append("<br>" + string + "<br>\n");
        if (null != string2) {
            stringBuilder.append("<br>" + string2 + "<br>\n");
        } else {
            stringBuilder.append("<br>Study running<br>\n");
        }
        APIOperation.addPageFooter(stringBuilder);
        Files.createDirectories(path, new FileAttribute[0]);
        BufferedWriter bufferedWriter = Files.newBufferedWriter(path.resolve(INDEX_FILE_NAME), new OpenOption[0]);
        bufferedWriter.write(stringBuilder.toString());
        bufferedWriter.close();
    }

    protected static void writeFileIndex(Path path, String string, String string2, String string3, ArrayList<String> arrayList) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        APIOperation.addPageHeader(stringBuilder, "TVStudy - Study Results", 0, null);
        if (null != string && string.length() > 0) {
            stringBuilder.append("<br>" + string + "<br>\n");
        }
        if (null != string2 && string2.length() > 0) {
            stringBuilder.append("<br>" + string2 + "<br>\n");
        }
        stringBuilder.append("<br><a href=\"" + APIOperation.urlclean(LOG_FILE_NAME) + "\">" + LOG_FILE_NAME + "</a><br>\n");
        if (null != string3 && string3.length() > 0) {
            stringBuilder.append("<br><pre>\n");
            stringBuilder.append(string3);
            stringBuilder.append("</pre>\n");
        }
        if (null != arrayList && arrayList.size() > 0) {
            stringBuilder.append("<br>Output files<br><br>\n");
            for (String string4 : arrayList) {
                stringBuilder.append("<a href=\"" + APIOperation.urlclean(string4) + "\">" + string4 + "</a><br>\n");
            }
        }
        APIOperation.addPageFooter(stringBuilder);
        Files.createDirectories(path, new FileAttribute[0]);
        BufferedWriter bufferedWriter = Files.newBufferedWriter(path.resolve(INDEX_FILE_NAME), new OpenOption[0]);
        bufferedWriter.write(stringBuilder.toString());
        bufferedWriter.close();
    }

    protected static void addPageHeader(StringBuilder stringBuilder, String string, int n, String string2) {
        stringBuilder.append("<html>\n");
        stringBuilder.append("<head>\n");
        if (n > 0) {
            stringBuilder.append("<meta http-equiv=\"refresh\" content=\"" + n + "\"/>\n");
        }
        stringBuilder.append("<title>" + string + "</title>\n");
        stringBuilder.append("</head>\n");
        stringBuilder.append("<body>\n");
        if (null != string2) {
            stringBuilder.append("<br><b>" + string2 + "</b><br><br>\n");
        }
    }

    protected static void addFormStart(StringBuilder stringBuilder, String string) {
        APIOperation.addFormStart(stringBuilder, string, null, null, null, false);
    }

    protected static void addFormStart(StringBuilder stringBuilder, String string, boolean bl) {
        APIOperation.addFormStart(stringBuilder, string, null, null, null, bl);
    }

    protected static void addFormStart(StringBuilder stringBuilder, String string, String string2, String string3, String string4) {
        APIOperation.addFormStart(stringBuilder, string, string2, string3, string4, false);
    }

    protected static void addFormStart(StringBuilder stringBuilder, String string, String string2, String string3, String string4, boolean bl) {
        if (bl) {
            stringBuilder.append("<form action=\"api\" method=\"post\">\n");
        } else {
            stringBuilder.append("<form action=\"api\" method=\"get\">\n");
        }
        stringBuilder.append("<input type=\"hidden\" name=\"op\" value=\"" + string + "\">\n");
        if (null != string2) {
            stringBuilder.append("<input type=\"hidden\" name=\"back_op\" value=\"" + string2 + "\">\n");
        }
        if (null != string3) {
            stringBuilder.append("<input type=\"hidden\" name=\"back_op_label\" value=\"" + string3 + "\">\n");
        }
        if (null != string4) {
            stringBuilder.append("<input type=\"hidden\" name=\"next_op\" value=\"" + string4 + "\">\n");
        }
    }

    protected static void addYesNoSelect(StringBuilder stringBuilder, String string, String string2, boolean bl, String string3) {
        if (null != string3) {
            stringBuilder.append("<tr><td>" + string3 + "</td>\n");
            stringBuilder.append("<td><select name=\"" + string + "\">\n");
        } else {
            stringBuilder.append("<select name=\"" + string + "\">\n");
        }
        if (null != string2 && Boolean.valueOf(string2).booleanValue() || null == string2 && bl) {
            stringBuilder.append("<option value=\"false\">No</option>\n");
            stringBuilder.append("<option value=\"true\" selected>Yes</option>\n");
        } else {
            stringBuilder.append("<option value=\"false\" selected>No</option>\n");
            stringBuilder.append("<option value=\"true\">Yes</option>\n");
        }
        if (null != string3) {
            stringBuilder.append("</select></td>\n");
        } else {
            stringBuilder.append("</select>\n");
        }
    }

    protected static void addFormEnd(StringBuilder stringBuilder, String string) {
        stringBuilder.append("<input type=\"submit\" value=\"" + string + "\"><br>\n");
        stringBuilder.append("</form>\n");
    }

    protected static void addPageFooter(StringBuilder stringBuilder) {
        APIOperation.addPageFooter(stringBuilder, true);
    }

    protected static void addPageFooter(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            stringBuilder.append("<br><a href=\"/tvstudy/api?op=menu\">Main menu</a><br>\n");
        }
        stringBuilder.append("</body>\n");
        stringBuilder.append("</html>\n");
    }

    public static String urlclean(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    stringBuilder.append('+');
                    continue block9;
                }
                case '#': {
                    stringBuilder.append("%23");
                    continue block9;
                }
                case '(': {
                    stringBuilder.append("%28");
                    continue block9;
                }
                case ')': {
                    stringBuilder.append("%29");
                    continue block9;
                }
                case '+': {
                    stringBuilder.append("%2b");
                    continue block9;
                }
                case '<': {
                    stringBuilder.append("%3c");
                    continue block9;
                }
                case '>': {
                    stringBuilder.append("%3e");
                    continue block9;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    static {
        didCoreInit = false;
    }
}

