/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.run;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.OutputConfig;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.StudyLockHolder;
import gov.fcc.tvstudy.gui.StudyManager;
import gov.fcc.tvstudy.gui.run.RunPanel;
import gov.fcc.tvstudy.gui.run.RunPanelStudy;
import gov.fcc.tvstudy.gui.run.RunStart;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class RunStartStudy
extends RunStart {
    public static final String WINDOW_TITLE = "Run Study";
    private RunPanelStudy runPanel;
    private ScenarioListTableModel scenarioListModel;
    private JTable scenarioListTable;
    private JCheckBox createResultTablesCheckBox;
    private int runAllCount;

    public RunStartStudy(StudyManager studyManager) {
        super(studyManager, WINDOW_TITLE);
        JPanel jPanel;
        this.runPanel = new RunPanelStudy(studyManager, studyManager.getDbID());
        this.scenarioListModel = new ScenarioListTableModel();
        this.scenarioListTable = this.scenarioListModel.createTable();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Select scenario(s) to study"));
        jPanel2.add((Component)AppController.createScrollPane(this.scenarioListTable), "Center");
        Box box = Box.createVerticalBox();
        box.add(this.optionsPanel);
        String string = AppCore.getPreference((String)"showCreateResultTables");
        if (null != string && Boolean.valueOf(string).booleanValue()) {
            this.createResultTablesCheckBox = new JCheckBox("Save results in database tables");
            jPanel = new JPanel();
            jPanel.add(this.createResultTablesCheckBox);
            box.add(jPanel);
        }
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)box, "South");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        container.add((Component)this.buttonPanel, "South");
        this.pack();
        Dimension dimension = this.getSize();
        dimension.height = 400;
        this.setSize(dimension);
        this.setMinimumSize(dimension);
    }

    @Override
    public boolean setStudy(int n, ErrorReporter errorReporter) {
        if (this.isVisible() || this.runPanel.studyKey > 0) {
            return false;
        }
        DbConnection dbConnection = DbCore.connectDb((String)this.getDbID(), (ErrorLogger)errorReporter);
        if (null == dbConnection) {
            return false;
        }
        String string = DbCore.getDbName((String)this.getDbID());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "";
        String string3 = String.valueOf(n);
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = null;
        Object var17_17 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 3;
        int n7 = 0;
        ArrayList<ScenarioListItem> arrayList = null;
        try {
            dbConnection.update("LOCK TABLES study WRITE, version WRITE");
            dbConnection.query("SELECT study.name, version.version, study.study_lock, study.lock_count, study.share_count, study.study_type, study.output_config_file_name, study.output_config_file_codes, study.output_config_map_name, study.output_config_map_codes, study.out_directory, study.report_preamble, study.study_mode, study.had_result_tables FROM study JOIN version WHERE study_key = " + n);
            if (dbConnection.next()) {
                string4 = dbConnection.getString(1);
                string3 = "'" + string4 + "'";
                if (20300012 == dbConnection.getInt(2)) {
                    n2 = dbConnection.getInt(3);
                    n3 = dbConnection.getInt(4);
                    if (0 == n2 || 3 == n2) {
                        n4 = dbConnection.getInt(5);
                        n5 = dbConnection.getInt(6);
                        string5 = dbConnection.getString(7);
                        string6 = dbConnection.getString(8);
                        string7 = dbConnection.getString(9);
                        string8 = dbConnection.getString(10);
                        string9 = dbConnection.getString(11);
                        string10 = dbConnection.getString(12);
                        n7 = dbConnection.getInt(13);
                        bl3 = dbConnection.getBoolean(14);
                        if (0 == n2) {
                            dbConnection.update("UPDATE study SET study_lock = 2, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
                            bl2 = true;
                            n2 = 2;
                            ++n3;
                        } else {
                            dbConnection.update("UPDATE study SET share_count = share_count + 1 WHERE study_key = " + n);
                            bl2 = true;
                            ++n4;
                        }
                        dbConnection.update("UNLOCK TABLES");
                        this.runAllCount = 0;
                        if (2 == n5) {
                            dbConnection.query("SELECT COUNT(*) FROM " + string + "_" + n + ".scenario_source WHERE scenario_key = 1 AND is_desired");
                            if (dbConnection.next()) {
                                this.runAllCount = dbConnection.getInt(1);
                            }
                            dbConnection.query("SELECT parent.scenario_key, parent.name, parent.description, COUNT(*) FROM " + string + "_" + n + ".scenario AS parent JOIN " + string + "_" + n + ".scenario AS child ON (child.parent_scenario_key = parent.scenario_key) JOIN " + string + "_" + n + ".scenario_source ON (scenario_source.scenario_key = child.scenario_key) WHERE scenario_source.is_desired GROUP BY 1, 2, 3 ORDER BY 1");
                        } else {
                            dbConnection.query("SELECT scenario_key, name, description, COUNT(*) FROM " + string + "_" + n + ".scenario JOIN " + string + "_" + n + ".scenario_source USING (scenario_key) WHERE scenario_source.is_desired AND (scenario.parent_scenario_key = 0) GROUP BY 1, 2, 3 ORDER BY 1");
                        }
                        arrayList = new ArrayList<ScenarioListItem>();
                        while (dbConnection.next()) {
                            ScenarioListItem scenarioListItem = new ScenarioListItem();
                            scenarioListItem.key = dbConnection.getInt(1);
                            scenarioListItem.name = dbConnection.getString(2);
                            scenarioListItem.description = dbConnection.getString(3);
                            scenarioListItem.sourceCount = dbConnection.getInt(4);
                            arrayList.add(scenarioListItem);
                            this.runAllCount += scenarioListItem.sourceCount;
                        }
                        if (0 == this.runAllCount) {
                            bl = true;
                            string2 = "There are no desired stations in the study";
                            n6 = 2;
                        }
                    } else {
                        bl = true;
                        string2 = "The study is in use by another application";
                        n6 = 2;
                    }
                } else {
                    bl = true;
                    string2 = "The database version is incorrect";
                }
            } else {
                bl = true;
                string2 = "The study does not exist";
            }
        }
        catch (SQLException sQLException) {
            bl = true;
            string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
            DbConnection.reportError((SQLException)sQLException);
        }
        try {
            dbConnection.update("UNLOCK TABLES");
            if (bl && bl2) {
                if (2 == n2 || --n4 <= 0) {
                    dbConnection.update("UPDATE study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + n);
                } else {
                    dbConnection.update("UPDATE study SET share_count = share_count - 1 WHERE study_key = " + n);
                }
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError((SQLException)sQLException);
        }
        DbCore.releaseDb((DbConnection)dbConnection);
        if (bl) {
            if (null != errorReporter) {
                errorReporter.reportError("Cannot run study " + string3 + ":\n" + string2, n6);
            }
            return false;
        }
        this.runPanel.studyKey = n;
        this.runPanel.studyName = string4;
        this.runPanel.studyType = n5;
        this.runPanel.studyLock = n2;
        this.runPanel.lockCount = n3;
        this.runPanel.outDirectoryPath = Paths.get(string9, new String[0]);
        if (!this.runPanel.outDirectoryPath.isAbsolute()) {
            this.runPanel.outDirectoryPath = AppCore.workingDirectoryPath.resolve(string9);
        }
        this.runPanel.runName = string4;
        this.optionsPanel.defaultFileOutputConfig = OutputConfig.getOrMakeConfig((String)this.getDbID(), (int)1, (String)string5, (String)string6);
        this.optionsPanel.defaultMapOutputConfig = OutputConfig.getOrMakeConfig((String)this.getDbID(), (int)2, (String)string7, (String)string8);
        this.runPanel.reportPreamble = string10;
        this.scenarioListModel.setItems(arrayList);
        if (this.scenarioListModel.getRowCount() > 0) {
            this.scenarioListTable.setRowSelectionInterval(0, this.scenarioListModel.getRowCount() - 1);
        }
        if (2 == this.runPanel.studyType) {
            AppController.setComponentEnabled(this.scenarioListTable, false);
        } else {
            AppController.setComponentEnabled(this.scenarioListTable, true);
        }
        if (null != this.createResultTablesCheckBox) {
            if (1 == n7 && (1 == this.runPanel.studyType || 4 == this.runPanel.studyType)) {
                this.createResultTablesCheckBox.setVisible(true);
                this.createResultTablesCheckBox.setSelected(bl3);
            } else {
                this.createResultTablesCheckBox.setVisible(false);
                this.createResultTablesCheckBox.setSelected(false);
            }
        }
        this.updateDocumentName();
        return true;
    }

    @Override
    public RunPanel getRunPanel() {
        return this.runPanel;
    }

    @Override
    public StudyLockHolder getStudyLockHolder() {
        return this.runPanel;
    }

    @Override
    protected void doReset() {
        super.doReset();
        this.scenarioListTable.clearSelection();
    }

    @Override
    protected boolean validateInput() {
        if (!super.validateInput()) {
            return false;
        }
        this.runPanel.fileOutputConfig = this.optionsPanel.fileOutputConfig;
        this.runPanel.mapOutputConfig = this.optionsPanel.mapOutputConfig;
        if (2 == this.runPanel.studyType) {
            this.runPanel.totalSourceCount = this.runAllCount;
        } else {
            this.runPanel.scenarioKeys = new ArrayList();
            this.runPanel.totalSourceCount = 0;
            for (int n : this.scenarioListTable.getSelectedRows()) {
                ScenarioListItem scenarioListItem = this.scenarioListModel.get(this.scenarioListTable.convertRowIndexToModel(n));
                this.runPanel.scenarioKeys.add(scenarioListItem.key);
                this.runPanel.totalSourceCount += scenarioListItem.sourceCount;
            }
        }
        if (null != this.createResultTablesCheckBox) {
            this.runPanel.createResultTables = this.createResultTablesCheckBox.isSelected();
        }
        return true;
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        super.windowWillClose();
        this.runPanel = null;
        this.scenarioListModel.setItems(null);
    }

    private class ScenarioListTableModel
    extends AbstractTableModel {
        private static final String SCENARIO_NAME_COLUMN = "Name";
        private static final String SCENARIO_DESCRIPTION_COLUMN = "Description";
        private String[] columnNames = new String[]{"Name", "Description"};
        private static final int SCENARIO_NAME_INDEX = 0;
        private static final int SCENARIO_DESCRIPTION_INDEX = 1;
        private ArrayList<ScenarioListItem> modelRows = new ArrayList();

        private ScenarioListTableModel() {
        }

        private JTable createTable() {
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable);
            jTable.setSelectionMode(2);
            jTable.setAutoCreateRowSorter(true);
            TableColumn tableColumn = jTable.getColumn(SCENARIO_NAME_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[15]);
            tableColumn = jTable.getColumn(SCENARIO_DESCRIPTION_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[30]);
            return jTable;
        }

        private void setItems(ArrayList<ScenarioListItem> arrayList) {
            this.modelRows.clear();
            if (null != arrayList) {
                this.modelRows.addAll(arrayList);
            }
            this.fireTableDataChanged();
        }

        private ScenarioListItem get(int n) {
            return this.modelRows.get(n);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.modelRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ScenarioListItem scenarioListItem = this.modelRows.get(n);
            switch (n2) {
                case 0: {
                    return scenarioListItem.name;
                }
                case 1: {
                    return scenarioListItem.description;
                }
            }
            return "";
        }
    }

    private class ScenarioListItem {
        private int key;
        private String name;
        private String description;
        private int sourceCount;

        private ScenarioListItem() {
        }
    }
}

