/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.run;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.AppTask;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.OutputConfig;
import gov.fcc.tvstudy.core.StudyBuildPair;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.StudyLockHolder;
import gov.fcc.tvstudy.gui.StudyManager;
import gov.fcc.tvstudy.gui.run.ProcessPanel;
import gov.fcc.tvstudy.gui.run.RunPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class RunPanelPairStudy
extends RunPanel
implements StudyLockHolder,
ProcessPanel.Handler {
    private StudyManager studyManager;
    private String dbID;
    public StudyBuildPair studyBuild;
    public int studyKey;
    public String studyName;
    public int studyType;
    public int studyLock;
    public int lockCount;
    public Path outDirectoryPath;
    public OutputConfig fileOutputConfig;
    public OutputConfig mapOutputConfig;
    private int runCount;
    private JTabbedPane tabPane;
    private JLabel statusLabel;
    private JButton cancelButton;
    private static final int RUN_STATE_INIT = 0;
    private static final int RUN_STATE_WAIT = 1;
    private static final int RUN_STATE_BUILD = 2;
    private static final int RUN_STATE_PRERUN = 3;
    private static final int RUN_STATE_RUNNING = 4;
    private static final int RUN_STATE_POSTRUN = 5;
    private static final int RUN_STATE_RESTORE = 6;
    private static final int RUN_STATE_EXITING = 7;
    private static final int RUN_STATE_EXIT = 8;
    private int runState;
    private boolean runFailed;
    private boolean runCanceled;
    private String runFailedMessage;
    private AppTask task;
    private boolean taskWaiting;
    private Thread buildThread;
    private boolean buildFailed;
    private ArrayDeque<StudyBuildPair.ScenarioSortItem> scenarioRunList;
    private ArrayList<ProcessPanel> studyRuns;
    private HashMap<ProcessPanel, StudyBuildPair.ScenarioSortItem> studyRunsPending;
    private HashSet<ProcessPanel> ignoreFailedRuns;
    private boolean hasOutput;
    private Thread restoreThread;
    private Path filePath;
    private ArrayList<File> outFiles;
    private ProcessPanel baselinePanel;
    private long runStatusStartTime;
    private int runStatusTotalCount;
    private int runStatusRunningCount;
    private int runStatusDoneCount;
    private boolean updateRunStatus;
    private static final long SOURCE_OUTPUT_SPACE_NEEDED = 3000000L;

    public RunPanelPairStudy(StudyManager studyManager, String string) {
        this.studyManager = studyManager;
        this.dbID = string;
        this.studyBuild = new StudyBuildPair(this.dbID);
    }

    @Override
    public boolean initialize(ErrorReporter errorReporter) {
        if (this.initialized) {
            return true;
        }
        if (0 != this.runState) {
            this.runState = 8;
            this.runFailed = true;
            return false;
        }
        this.runState = 8;
        this.runFailed = true;
        if (!super.initialize(errorReporter)) {
            return false;
        }
        if (null == this.fileOutputConfig || this.fileOutputConfig.isNull() || !this.fileOutputConfig.isValid()) {
            if (null != errorReporter) {
                errorReporter.reportError("Cannot run study, missing or invalid output file settings");
            }
            return false;
        }
        if (null == this.mapOutputConfig || this.mapOutputConfig.isNull() || !this.mapOutputConfig.isValid()) {
            if (null != errorReporter) {
                errorReporter.reportError("Cannot run study, missing or invalid map output settings");
            }
            return false;
        }
        this.autoSaveOutput = 1 == this.fileOutputConfig.flags[14] || 3 == this.fileOutputConfig.flags[14];
        this.fileOutputConfig.flags[6] = 1;
        this.fileOutputConfig.flags[13] = 1;
        if (!this.studyBuild.initialize((ErrorLogger)errorReporter)) {
            return false;
        }
        if (!DbCore.openDb((String)this.dbID, (Object)this)) {
            errorReporter.reportError("Invalid database connection ID");
            return false;
        }
        this.runCount = this.studyBuild.runCount;
        if (AppCore.maxEngineProcessCount > 0) {
            double d = 1.0 / (double)AppCore.maxEngineProcessCount;
            if (this.memoryFraction < d) {
                this.memoryFraction = d;
            }
            if (this.runCount > 1 && this.memoryFraction < 1.0) {
                int n = (int)(this.memoryFraction * (double)AppCore.maxEngineProcessCount);
                if (n < 1) {
                    n = 1;
                }
                if (this.runCount > n) {
                    this.runCount = n;
                }
            }
        }
        this.task = new AppTask(this.memoryFraction, this.runCount);
        if (this.studyKey <= 0 || 0 == this.studyLock || this.lockCount <= 0) {
            errorReporter.reportError("Cannot run study, missing or invalid lock state");
            return false;
        }
        this.outDirectoryPath = Paths.get(this.studyBuild.baseStudy.outDirectory, new String[0]);
        if (!this.outDirectoryPath.isAbsolute()) {
            this.outDirectoryPath = AppCore.workingDirectoryPath.resolve(this.studyBuild.baseStudy.outDirectory);
        }
        this.runName = "Run pair study '" + this.studyName + "'";
        String string = DbCore.getHostDbName((String)this.dbID);
        this.filePath = null == string ? this.outDirectoryPath.resolve(this.studyName) : this.outDirectoryPath.resolve(string).resolve(this.studyName);
        this.outFiles = new ArrayList();
        this.studyRuns = new ArrayList();
        this.studyRunsPending = new HashMap();
        this.ignoreFailedRuns = new HashSet();
        this.statusLabel = new JLabel();
        this.statusLabel.setPreferredSize(AppController.labelSize[60]);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunPanelPairStudy.this.cancel();
            }
        });
        this.cancelButton.setEnabled(false);
        this.baselinePanel = new ProcessPanel(this, "Study", null);
        this.baselinePanel.setProcessHandler(this);
        this.baselinePanel.setStatusPanelVisible(false);
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Baseline", this.baselinePanel);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.cancelButton);
        jPanel.add(this.statusLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabPane, "Center");
        this.add((Component)jPanel, "South");
        this.runState = 1;
        this.runFailed = false;
        this.initialized = true;
        return true;
    }

    @Override
    public String getDbID() {
        return this.dbID;
    }

    @Override
    public int getStudyKey() {
        return this.studyKey;
    }

    @Override
    public String getStudyName() {
        return this.studyName;
    }

    @Override
    public int getStudyLock() {
        return this.studyLock;
    }

    @Override
    public int getLockCount() {
        return this.lockCount;
    }

    @Override
    public void toFront() {
        if (null != this.parent) {
            this.parent.getWindow().toFront();
        }
    }

    @Override
    public boolean closeWithoutSave() {
        return false;
    }

    @Override
    public boolean studyManagerClosing() {
        this.studyManager = null;
        return true;
    }

    @Override
    public boolean isDiskSpaceAvailable() {
        long l = (long)(this.studyBuild.baselineSourceCount * this.studyBuild.studyChannels.length) * 3000000L;
        return AppCore.isFreeSpaceAvailable((String)this.dbID, (int)this.studyBuild.baselineSourceCount, (long)l);
    }

    @Override
    public void poll() {
        if (!this.initialized) {
            return;
        }
        if (8 == this.runState) {
            if (null != this.task) {
                AppTask.taskDone((AppTask)this.task);
                this.task = null;
                DbCore.closeDb((String)this.dbID, (Object)this);
            }
            return;
        }
        this.cancelButton.setEnabled(!this.runCanceled && this.canCancel());
        if (1 == this.runState) {
            this.baselinePanel.poll();
            if (!AppTask.canTaskStart((AppTask)this.task)) {
                if (!this.taskWaiting) {
                    this.taskWaiting = true;
                    this.statusLabel.setText("Waiting for other runs to complete...");
                }
                return;
            }
            this.taskWaiting = false;
            this.runState = 2;
        }
        if (2 == this.runState) {
            this.baselinePanel.poll();
            if (null == this.buildThread) {
                this.buildThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            RunPanelPairStudy.this.buildStudy();
                        }
                        catch (Throwable throwable) {
                            AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
                            RunPanelPairStudy.this.buildFailed = true;
                        }
                    }
                };
                this.buildThread.start();
                this.statusLabel.setText("Building pair study scenarios...");
                return;
            }
            if (this.buildThread.isAlive()) {
                return;
            }
            this.buildThread = null;
            if (this.buildFailed) {
                this.runState = 7;
                if (this.studyBuild.isCanceled()) {
                    this.runCanceled = true;
                    this.runFailedMessage = "Study setup canceled";
                } else {
                    this.runFailed = true;
                    this.runFailedMessage = "Study setup failed";
                }
                this.cancelButton.setEnabled(false);
            } else if (this.runCanceled) {
                this.runState = 6;
                this.cancelButton.setEnabled(false);
            } else {
                this.runState = 3;
                this.statusLabel.setText("Running baseline scenario");
                this.startPrerun();
                if (null != this.studyManager) {
                    this.studyManager.applyEditsFrom(this);
                }
            }
        }
        if (!this.studyRuns.isEmpty()) {
            Iterator<Serializable> iterator = this.studyRuns.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                ProcessPanel serializable = iterator.next();
                if ((this.runFailed || this.runCanceled) && !serializable.isCanceled()) {
                    serializable.cancel();
                }
                if (bl = serializable.poll()) continue;
                iterator.remove();
                if (serializable.hasOutput()) {
                    this.hasOutput = true;
                }
                if (this.runFailed || this.runCanceled || !serializable.didProcessFail() || this.ignoreFailedRuns.contains(serializable)) continue;
                this.runFailed = true;
                this.runFailedMessage = "Study process failed";
                this.cancelButton.setEnabled(false);
            }
            if (!this.studyRuns.isEmpty() && this.updateRunStatus) {
                int n = 0;
                int n2 = 0;
                if (3 == this.runState) {
                    n = this.runStatusTotalCount;
                    n2 = this.runStatusDoneCount;
                } else if (4 == this.runState) {
                    n = this.studyBuild.scenarioCount;
                    n2 = this.studyBuild.scenarioCount - this.scenarioRunList.size();
                }
                if (n > 0) {
                    String string;
                    String string2 = AppCore.formatCount((int)n2) + " of " + AppCore.formatCount((int)n) + " items done";
                    if (n2 == n) {
                        string = string2 + ", running";
                    } else if (0L == this.runStatusStartTime) {
                        string = string2 + ", running";
                    } else {
                        double d = (double)this.runStatusDoneCount / (double)this.runStatusTotalCount;
                        double d2 = (double)(System.currentTimeMillis() - this.runStatusStartTime) / 60000.0;
                        if (d < 0.1 && d2 < 2.0) {
                            string = string2 + ", running";
                        } else {
                            int n3;
                            double d3 = d2 * (1.0 / d - 1.0);
                            if (d < 0.5) {
                                d3 *= 1.5 - d;
                            }
                            if (d3 < 1.0) {
                                string = string2 + ", less than 1 minute remaining";
                            } else if (d3 < 60.0) {
                                n3 = (int)Math.rint(d3);
                                string = string2 + ", about " + n3 + (1 == n3 ? " minute" : " minutes") + " remaining";
                            } else {
                                n3 = (int)Math.rint(d3 / 60.0);
                                string = string2 + ", about " + n3 + (1 == n3 ? " hour" : " hours") + " remaining";
                            }
                        }
                    }
                    this.statusLabel.setText(string);
                }
                this.updateRunStatus = false;
            }
            if (!this.studyRuns.isEmpty()) {
                return;
            }
            if (!(4 != this.runState || this.runFailed || this.runCanceled || this.scenarioRunList.isEmpty())) {
                this.runFailed = true;
                this.runFailedMessage = "Study failed, did not process all scenarios";
                this.runState = 6;
                this.cancelButton.setEnabled(false);
            } else if (this.runFailed || this.runCanceled || 5 == this.runState) {
                this.runState = 6;
                this.cancelButton.setEnabled(false);
            } else {
                if (3 == this.runState) {
                    this.runState = 4;
                    this.statusLabel.setText("Running pair study scenarios");
                    this.startRunning();
                    return;
                }
                if (4 == this.runState) {
                    this.runState = 5;
                    this.statusLabel.setText("Post-processing study results");
                    this.cancelButton.setEnabled(false);
                    this.startPostrun();
                    return;
                }
            }
        }
        if (6 == this.runState) {
            if (null == this.restoreThread) {
                this.statusLabel.setText("Restoring study database");
                this.restoreThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            RunPanelPairStudy.this.restoreStudy();
                        }
                        catch (Throwable throwable) {
                            AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
                        }
                    }
                };
                this.restoreThread.start();
                return;
            }
            if (this.restoreThread.isAlive()) {
                return;
            }
            this.restoreThread = null;
            this.runState = 7;
            this.statusLabel.setText("Study complete");
        }
        this.runState = 8;
        if (this.runFailed || this.runCanceled) {
            this.statusLabel.setText(this.runFailedMessage);
        }
        this.cancelButton.setEnabled(false);
        if (null != this.studyManager) {
            this.studyManager.editorClosing(this);
        }
        for (File file : this.outFiles) {
            file.delete();
        }
        this.outFiles.clear();
        if (null != this.task) {
            AppTask.taskDone((AppTask)this.task);
            this.task = null;
            DbCore.closeDb((String)this.dbID, (Object)this);
        }
    }

    private void buildStudy() {
        Object object;
        if (2 != this.runState) {
            this.buildFailed = true;
            return;
        }
        String string = "";
        ErrorLogger errorLogger = new ErrorLogger();
        Study study = this.studyBuild.buildStudy(errorLogger);
        if (null == study) {
            this.buildFailed = true;
        } else {
            if (errorLogger.hasMessages()) {
                errorLogger.reportMessage(errorLogger.getMessages());
                errorLogger.clearMessages();
            }
            if (null != (object = DbCore.connectDb((String)this.dbID, (ErrorLogger)errorLogger))) {
                try {
                    object.update("LOCK TABLES study WRITE");
                    object.query("SELECT study_lock, lock_count FROM study WHERE study_key = " + study.key);
                    if (object.next()) {
                        if (object.getInt(1) == this.studyLock && object.getInt(2) == this.lockCount) {
                            object.update("UPDATE study SET study_lock = 2, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + this.studyKey);
                            this.studyLock = 2;
                            ++this.lockCount;
                        } else {
                            this.buildFailed = true;
                            string = "Could not update study lock, the lock was modified";
                        }
                    } else {
                        this.buildFailed = true;
                        string = "Could not update study lock, the study was deleted";
                    }
                }
                catch (SQLException sQLException) {
                    this.buildFailed = true;
                    string = "An operation cannot be completed due to a database error:\n" + sQLException;
                    DbConnection.reportError((SQLException)sQLException);
                }
                try {
                    object.update("UNLOCK TABLES");
                }
                catch (SQLException sQLException) {
                    DbConnection.reportError((SQLException)sQLException);
                }
                DbCore.releaseDb((DbConnection)object);
                if (this.buildFailed) {
                    errorLogger.reportError(string);
                }
            } else {
                this.buildFailed = true;
            }
        }
        if (errorLogger.hasErrors()) {
            object = "\n" + errorLogger.toString() + "\n";
            SwingUtilities.invokeLater(new Runnable((String)object){
                final /* synthetic */ String val$message;
                {
                    this.val$message = string;
                }

                @Override
                public void run() {
                    RunPanelPairStudy.this.baselinePanel.displayLogMessage(this.val$message);
                }
            });
        }
    }

    private void startPrerun() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = String.valueOf(this.lockCount);
        File file = this.filePath.resolve("outtemp_" + string + "_0").toFile();
        arrayList.add(AppCore.libDirectoryPath.resolve("tvstudy").toString());
        if (AppCore.Debug) {
            arrayList.add("-d");
        }
        arrayList.add("-w");
        arrayList.add(AppCore.workingDirectoryPath.toString());
        arrayList.add("-z");
        arrayList.add(AppCore.cacheDirectoryPath.toString());
        arrayList.add("-o");
        arrayList.add(this.outDirectoryPath.toString());
        arrayList.add("-i");
        arrayList.add("-h");
        arrayList.add(DbCore.getDbHostname((String)this.dbID));
        arrayList.add("-b");
        arrayList.add(DbCore.getDbName((String)this.dbID));
        arrayList.add("-u");
        arrayList.add(DbCore.getDbUsername((String)this.dbID));
        arrayList.add("-l");
        arrayList.add(string);
        arrayList.add("-k");
        arrayList.add("-n");
        arrayList.add(string);
        arrayList.add("-f");
        arrayList.add(this.fileOutputConfig.getCodes());
        arrayList.add("-e");
        arrayList.add(this.mapOutputConfig.getCodes());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Pair study baseline run\n");
        stringBuilder.append("Study country: ");
        if (null == this.studyBuild.studyCountry) {
            stringBuilder.append("All");
        } else {
            stringBuilder.append(this.studyBuild.studyCountry.name);
        }
        stringBuilder.append('\n');
        stringBuilder.append("Study channels:");
        for (int n : this.studyBuild.studyChannels) {
            stringBuilder.append(' ');
            stringBuilder.append(String.valueOf(n));
        }
        stringBuilder.append('\n');
        stringBuilder.append(this.runComment);
        arrayList.add("-c");
        arrayList.add(stringBuilder.toString());
        arrayList.add(String.valueOf(this.studyKey));
        arrayList.add(String.valueOf(this.studyBuild.baselineScenarioKey));
        this.baselinePanel.setProcessArguments(arrayList, DbCore.getDbPassword((String)this.dbID));
        this.studyRuns.add(this.baselinePanel);
        this.outFiles.add(file);
        this.runStatusStartTime = 0L;
        this.runStatusTotalCount = this.studyBuild.baselineSourceCount;
        this.runStatusRunningCount = 0;
        this.runStatusDoneCount = 0;
    }

    private void startRunning() {
        this.scenarioRunList = this.studyBuild.getScenarioRunList();
        boolean bl = false;
        String string = "";
        DbConnection dbConnection = DbCore.connectDb((String)this.dbID);
        if (null != dbConnection) {
            try {
                dbConnection.update("LOCK TABLES study WRITE");
                dbConnection.query("SELECT study_lock, lock_count FROM study WHERE study_key = " + this.studyKey);
                if (dbConnection.next()) {
                    if (dbConnection.getInt(1) == this.studyLock && dbConnection.getInt(2) == this.lockCount) {
                        dbConnection.update("UPDATE study SET study_lock = 3, lock_count = lock_count + 1, share_count = 1 WHERE study_key = " + this.studyKey);
                        this.studyLock = 3;
                        ++this.lockCount;
                    } else {
                        bl = true;
                        string = "The study lock was modified";
                    }
                } else {
                    bl = true;
                    string = "The study was deleted";
                }
            }
            catch (SQLException sQLException) {
                bl = true;
                string = "Error: " + sQLException;
                DbConnection.reportError((SQLException)sQLException);
            }
            try {
                dbConnection.update("UNLOCK TABLES");
            }
            catch (SQLException sQLException) {
                DbConnection.reportError((SQLException)sQLException);
            }
            DbCore.releaseDb((DbConnection)dbConnection);
        } else {
            bl = true;
            string = "Could not open database connection";
        }
        if (!bl) {
            String string2 = String.valueOf((int)Math.rint((double)this.runCount / this.memoryFraction));
            String string3 = DbCore.getDbHostname((String)this.dbID);
            String string4 = DbCore.getDbName((String)this.dbID);
            String string5 = DbCore.getDbUsername((String)this.dbID);
            String string6 = String.valueOf(this.lockCount);
            OutputConfig outputConfig = new OutputConfig(1, "");
            outputConfig.flags[6] = 1;
            String string7 = outputConfig.getCodes();
            for (int i = 0; i < this.runCount; ++i) {
                String object = String.valueOf(this.lockCount * this.runCount + i);
                Serializable serializable = this.filePath.resolve("outtemp_" + object + "_0").toFile();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(AppCore.libDirectoryPath.resolve("tvstudy").toString());
                if (AppCore.Debug) {
                    arrayList.add("-d");
                }
                arrayList.add("-w");
                arrayList.add(AppCore.workingDirectoryPath.toString());
                arrayList.add("-z");
                arrayList.add(AppCore.cacheDirectoryPath.toString());
                arrayList.add("-o");
                arrayList.add(this.outDirectoryPath.toString());
                arrayList.add("-i");
                arrayList.add("-h");
                arrayList.add(string3);
                arrayList.add("-b");
                arrayList.add(string4);
                arrayList.add("-u");
                arrayList.add(string5);
                arrayList.add("-l");
                arrayList.add(string6);
                arrayList.add("-k");
                arrayList.add("-n");
                arrayList.add(object);
                arrayList.add("-x");
                arrayList.add("-m");
                arrayList.add(string2);
                arrayList.add("-f");
                arrayList.add(string7);
                arrayList.add("-e");
                arrayList.add("_");
                arrayList.add(String.valueOf(this.studyKey));
                arrayList.add("*");
                ProcessPanel processPanel = new ProcessPanel(this, "Study", null);
                processPanel.setProcessHandler(this);
                processPanel.setStatusPanelVisible(false);
                processPanel.setProcessArguments(arrayList, DbCore.getDbPassword((String)this.dbID));
                this.studyRuns.add(processPanel);
                this.outFiles.add((File)serializable);
            }
        }
        if (bl) {
            this.runFailed = true;
            this.runFailedMessage = string;
            this.runState = 6;
            this.cancelButton.setEnabled(false);
            for (ProcessPanel processPanel : this.studyRuns) {
                processPanel.cancel();
            }
            this.studyRuns.clear();
            return;
        }
        int n = 1;
        for (Serializable serializable : this.studyRuns) {
            this.tabPane.addTab("Run " + n++, (Component)serializable);
        }
        this.runStatusStartTime = 0L;
        this.runStatusTotalCount = this.studyBuild.scenarioSourceCount;
        this.runStatusRunningCount = 0;
        this.runStatusDoneCount = 0;
    }

    private void startPostrun() {
        boolean bl = false;
        String string = null;
        int n = 0;
        BufferedWriter bufferedWriter = null;
        String string2 = DbCore.getDbName((String)this.dbID);
        DbConnection dbConnection = DbCore.connectDb((String)this.dbID);
        if (null != dbConnection) {
            try {
                bufferedWriter = Files.newBufferedWriter(this.filePath.resolve("stations.csv"), new OpenOption[0]);
                dbConnection.setDatabase(string2 + "_" + this.studyKey);
                dbConnection.query("SELECT source.facility_id, source.channel, scenario_source.is_desired, scenario_source.is_undesired, service.service_code, source.call_sign, source.city, source.state, country.country_code, source.status, source.file_number, source.latitude, source.longitude FROM scenario_source JOIN source USING (source_key) JOIN " + string2 + ".service USING (service_key) JOIN " + string2 + ".country USING (country_key) WHERE scenario_source.scenario_key = " + this.studyBuild.baselineScenarioKey + " AND (scenario_source.is_desired OR scenario_source.is_undesired) ORDER BY source.country_key, source.state, source.city, source.channel");
                while (dbConnection.next()) {
                    int n2 = dbConnection.getInt(1);
                    if (n2 > n) {
                        n = n2;
                    }
                    bufferedWriter.write(String.format(Locale.US, "%d,%d,%d,%d,%s,\"%s\",\"%s\",%s,%s,%s,\"%.22s\",%f,%f\n", n2, dbConnection.getInt(2), dbConnection.getInt(3), dbConnection.getInt(4), dbConnection.getString(5), dbConnection.getString(6), dbConnection.getString(7), dbConnection.getString(8), dbConnection.getString(9), dbConnection.getString(10), dbConnection.getString(11), dbConnection.getDouble(12), dbConnection.getDouble(13)));
                }
            }
            catch (SQLException sQLException) {
                bl = true;
                string = "Error: " + sQLException;
                DbConnection.reportError((SQLException)sQLException);
            }
            catch (IOException iOException) {
                bl = true;
                string = "Error: " + iOException;
            }
            DbCore.releaseDb((DbConnection)dbConnection);
            if (null != bufferedWriter) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            bl = true;
            string = "Could not open database connection";
        }
        if (bl) {
            this.runFailed = true;
            this.runFailedMessage = string;
            this.runState = 6;
            this.cancelButton.setEnabled(false);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(AppCore.libDirectoryPath.resolve("pair_study_post").toString());
        arrayList.add(this.filePath.toString());
        arrayList.add(String.valueOf(n));
        for (File serializable2 : this.outFiles) {
            arrayList.add(serializable2.getName());
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add("Completed ");
        ProcessPanel processPanel = new ProcessPanel(this, "Process", arrayList2);
        processPanel.setProcessHandler(this);
        processPanel.setStatusPanelVisible(false);
        processPanel.setProcessArguments(arrayList, null);
        this.studyRuns.add(processPanel);
        this.tabPane.addTab("Post", processPanel);
    }

    private void restoreStudy() {
        String string;
        if (6 != this.runState) {
            return;
        }
        this.studyBuild.baseStudy.studyLock = this.studyLock;
        this.studyBuild.baseStudy.lockCount = this.lockCount;
        ErrorLogger errorLogger = new ErrorLogger();
        boolean bl = !this.studyBuild.restoreStudy(errorLogger);
        this.studyLock = this.studyBuild.baseStudy.studyLock;
        this.lockCount = this.studyBuild.baseStudy.lockCount;
        if (!bl) {
            string = "";
            DbConnection dbConnection = DbCore.connectDb((String)this.dbID);
            if (null != dbConnection) {
                try {
                    dbConnection.update("LOCK TABLES study WRITE");
                    dbConnection.query("SELECT study_lock, lock_count FROM study WHERE study_key=" + this.studyKey);
                    if (dbConnection.next()) {
                        if (dbConnection.getInt(1) == this.studyLock && dbConnection.getInt(2) == this.lockCount) {
                            dbConnection.update("UPDATE study SET study_lock = 0, lock_count = lock_count + 1, share_count = 0 WHERE study_key = " + this.studyKey);
                            this.studyLock = 0;
                            ++this.lockCount;
                        } else {
                            bl = true;
                            string = "Could not unlock study, the lock was modified";
                        }
                    } else {
                        bl = true;
                        string = "Could not unlock study, the study was deleted";
                    }
                }
                catch (SQLException sQLException) {
                    bl = true;
                    string = "An operation cannot be completed due to a database error:\n" + sQLException;
                    DbConnection.reportError((SQLException)sQLException);
                }
                try {
                    dbConnection.update("UNLOCK TABLES");
                }
                catch (SQLException sQLException) {
                    DbConnection.reportError((SQLException)sQLException);
                }
                DbCore.releaseDb((DbConnection)dbConnection);
            } else {
                bl = true;
                string = "Could not open database connection";
            }
            if (bl) {
                errorLogger.reportError(string);
            }
        }
        if (bl) {
            string = "\n" + errorLogger.toString() + "\n";
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RunPanelPairStudy.this.baselinePanel.displayLogMessage(string);
                }
            });
        }
    }

    @Override
    public String getProcessResponse(ProcessPanel processPanel, String string) {
        if (4 != this.runState) {
            return null;
        }
        if (!this.studyRuns.contains(processPanel) || this.studyRunsPending.containsKey(processPanel)) {
            return null;
        }
        if (0L == this.runStatusStartTime) {
            this.runStatusStartTime = System.currentTimeMillis();
        }
        StudyBuildPair.ScenarioSortItem scenarioSortItem = this.scenarioRunList.poll();
        this.studyRunsPending.put(processPanel, scenarioSortItem);
        if (null == scenarioSortItem) {
            return "#*#*#";
        }
        return String.valueOf(scenarioSortItem.key);
    }

    @Override
    public void processResponseConfirmed(ProcessPanel processPanel) {
        if (4 != this.runState) {
            return;
        }
        StudyBuildPair.ScenarioSortItem scenarioSortItem = this.studyRunsPending.remove(processPanel);
        if (null != scenarioSortItem) {
            this.runStatusDoneCount += scenarioSortItem.sourceCount;
            this.updateRunStatus = true;
        }
    }

    @Override
    public void processFailed(ProcessPanel processPanel) {
        if (4 != this.runState) {
            return;
        }
        if (!this.studyRuns.contains(processPanel)) {
            return;
        }
        if (this.studyRunsPending.containsKey(processPanel)) {
            StudyBuildPair.ScenarioSortItem scenarioSortItem = this.studyRunsPending.remove(processPanel);
            if (null == scenarioSortItem) {
                this.ignoreFailedRuns.add(processPanel);
            } else {
                boolean bl = false;
                for (ProcessPanel processPanel2 : this.studyRuns) {
                    if (!processPanel2.isProcessRunning()) continue;
                    if (this.studyRunsPending.containsKey(processPanel2)) {
                        if (null == this.studyRunsPending.get(processPanel2)) continue;
                        bl = true;
                        break;
                    }
                    bl = true;
                    break;
                }
                if (bl) {
                    this.scenarioRunList.push(scenarioSortItem);
                    this.ignoreFailedRuns.add(processPanel);
                } else {
                    this.scenarioRunList.clear();
                }
            }
        } else {
            this.scenarioRunList.clear();
        }
    }

    @Override
    public void processComplete(ProcessPanel processPanel) {
        if (4 != this.runState) {
            return;
        }
        StudyBuildPair.ScenarioSortItem scenarioSortItem = this.studyRunsPending.remove(processPanel);
        if (null != scenarioSortItem) {
            this.scenarioRunList.push(scenarioSortItem);
        }
    }

    @Override
    public void processStatusMessage(ProcessPanel processPanel, String string, String string2) {
        if (3 != this.runState) {
            return;
        }
        if (string.equals("runcount")) {
            if (0L == this.runStatusStartTime) {
                this.runStatusStartTime = System.currentTimeMillis();
                this.updateRunStatus = true;
            }
            if (this.runStatusRunningCount > 0) {
                this.runStatusDoneCount += this.runStatusRunningCount;
                this.runStatusRunningCount = 0;
                this.updateRunStatus = true;
            }
            try {
                this.runStatusRunningCount = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setStatusMessage(String string) {
    }

    @Override
    public boolean isRunning() {
        return 8 != this.runState;
    }

    @Override
    public boolean isWaiting() {
        return 1 == this.runState;
    }

    @Override
    public void bumpTask() {
        if (1 == this.runState && null != this.task) {
            AppTask.bumpTask((AppTask)this.task);
        }
    }

    @Override
    public boolean runFailed() {
        return this.runFailed;
    }

    @Override
    public boolean canCancel() {
        return 1 == this.runState || 2 == this.runState || 3 == this.runState || 4 == this.runState;
    }

    @Override
    public void cancel() {
        if (this.runCanceled || !this.canCancel()) {
            return;
        }
        this.runCanceled = true;
        this.runFailedMessage = "Study canceled";
        this.cancelButton.setEnabled(false);
        if (1 == this.runState || 2 == this.runState && null == this.buildThread) {
            this.runState = 7;
            return;
        }
        if (2 == this.runState) {
            if (!this.studyBuild.isCanceled()) {
                this.studyBuild.cancel();
            }
            return;
        }
        for (ProcessPanel processPanel : this.studyRuns) {
            processPanel.cancel();
        }
    }

    @Override
    public String getStatus() {
        switch (this.runState) {
            case 0: 
            case 1: {
                return "Waiting";
            }
            case 2: {
                return "Building study";
            }
            case 3: {
                if (this.runStatusTotalCount > 0) {
                    return "Baseline, " + AppCore.formatCount((int)this.runStatusDoneCount) + " of " + AppCore.formatCount((int)this.runStatusTotalCount) + " done";
                }
                return "Baseline";
            }
            case 4: {
                if (this.studyBuild.scenarioCount > 0) {
                    return "Running, " + AppCore.formatCount((int)(this.studyBuild.scenarioCount - this.scenarioRunList.size())) + " of " + AppCore.formatCount((int)this.studyBuild.scenarioCount) + " done";
                }
                return "Running";
            }
            case 5: 
            case 6: {
                return "Post-process";
            }
            case 7: {
                return "Exiting";
            }
            case 8: {
                if (this.runCanceled) {
                    return "Canceled";
                }
                if (this.runFailed) {
                    return "Failed";
                }
                return "Complete";
            }
        }
        return "Unknown";
    }

    @Override
    public boolean hasOutput() {
        if (8 == this.runState) {
            return this.hasOutput;
        }
        return false;
    }

    @Override
    public void writeOutputTo(Writer writer) throws IOException {
        if (8 != this.runState || !this.hasOutput) {
            return;
        }
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            ProcessPanel processPanel;
            Component component = this.tabPane.getComponentAt(i);
            if (!(component instanceof ProcessPanel) || !(processPanel = (ProcessPanel)component).hasOutput()) continue;
            writer.write("\n\n------------------------ Output from " + this.tabPane.getTitleAt(i) + " ------------------------\n\n");
            processPanel.writeOutputTo(writer);
        }
    }

    @Override
    public Path getOutDirectoryPath() {
        return this.filePath;
    }
}

