/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.run;

import gov.fcc.tvstudy.core.ProcessRun;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppPanel;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;

public class ProcessPanel
extends AppPanel
implements ProcessRun.Handler {
    public static final int TEXT_AREA_ROWS = 15;
    public static final int TEXT_AREA_COLUMNS = 80;
    private String processName;
    private ProcessRun processRun;
    private boolean processStarted;
    private boolean processExited;
    private Handler handler;
    private File outputFile;
    private boolean outputFileOpened;
    private FileWriter outputFileWriter;
    private boolean hasOutput;
    private static final int COPY_BUFFER_SIZE = 0x100000;
    private JTextArea outputArea;
    private ArrayList<String> mergeLineStrings;
    private int lastOutputLineType;
    private static final int CR_LINE = -1;
    private int lastOutputLineStart;
    private int scrollbackLineCount;
    private static final int MAX_SCROLLBACK_LINES = 15000;
    private JViewport outputViewport;
    private int autoScrollState;
    private boolean autoScrollLock;
    private JLabel statusLabel;
    private JButton cancelButton;
    private JPanel statusPanel;
    private boolean canceled;
    private ProcessPanel outerThis = this;

    public ProcessPanel(AppEditor appEditor, String string, ArrayList<String> arrayList) {
        super(appEditor);
        this.processName = null == string ? "Process" : string;
        if (null != arrayList && !arrayList.isEmpty()) {
            this.mergeLineStrings = new ArrayList<String>(arrayList);
        }
        this.outputArea = new JTextArea(15, 80);
        this.outputArea.setFont(new Font("Monospaced", 0, 12));
        AppController.fixKeyBindings(this.outputArea);
        this.outputArea.setEditable(false);
        this.outputArea.setLineWrap(true);
        ((DefaultCaret)this.outputArea.getCaret()).setUpdatePolicy(1);
        JScrollPane jScrollPane = AppController.createScrollPane(this.outputArea);
        this.outputViewport = jScrollPane.getViewport();
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                boolean bl;
                if (ProcessPanel.this.autoScrollLock) {
                    return;
                }
                if (((ProcessPanel)ProcessPanel.this).outputViewport.getViewSize().height <= ((ProcessPanel)ProcessPanel.this).outputViewport.getExtentSize().height) {
                    ProcessPanel.this.autoScrollState = 0;
                }
                if (0 == ProcessPanel.this.autoScrollState) {
                    return;
                }
                Adjustable adjustable = adjustmentEvent.getAdjustable();
                boolean bl2 = bl = adjustable.getMaximum() - adjustable.getVisibleAmount() - adjustmentEvent.getValue() < 10;
                if (1 == ProcessPanel.this.autoScrollState) {
                    if (!bl) {
                        ProcessPanel.this.autoScrollState = 2;
                    }
                } else if (bl) {
                    ProcessPanel.this.autoScrollState = 1;
                }
            }
        });
        this.statusLabel = new JLabel(this.processName + " starting");
        this.statusLabel.setPreferredSize(AppController.labelSize[60]);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProcessPanel.this.cancel();
            }
        });
        this.cancelButton.setEnabled(false);
        this.statusPanel = new JPanel(new FlowLayout(0));
        this.statusPanel.add(this.cancelButton);
        this.statusPanel.add(this.statusLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.statusPanel, "South");
    }

    public void finalize() {
        if (null != this.outputFile) {
            if (null != this.outputFileWriter) {
                try {
                    this.outputFileWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.outputFileWriter = null;
            }
            this.outputFile.delete();
            this.outputFile = null;
            this.hasOutput = false;
        }
    }

    public void setProcessHandler(Handler handler) {
        this.handler = handler;
    }

    public void setStatusPanelVisible(boolean bl) {
        this.statusPanel.setVisible(bl);
    }

    public void setStatusMessage(String string) {
        this.statusLabel.setText(string);
        if (null != this.handler) {
            this.handler.setStatusMessage(string);
        }
    }

    public void displayLogMessage(String string) {
        if (null == string) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        String string2 = null;
        while (n < n3) {
            char c;
            while ('\n' != (c = string.charAt(n2)) && '\r' != c && ++n2 < n3) {
            }
            if (n2 > n) {
                string2 = string.substring(n, n2);
                if (n2 < n3) {
                    // empty if block
                }
            } else {
                n = ++n2;
                continue;
            }
            n = ++n2;
            if ('\r' == c) {
                n4 = -1;
            } else {
                this.writeLine(string2);
                n4 = 0;
                if (null != this.mergeLineStrings) {
                    for (int i = 0; i < this.mergeLineStrings.size(); ++i) {
                        if (!string2.contains(this.mergeLineStrings.get(i))) continue;
                        n4 = i + 1;
                        break;
                    }
                }
            }
            this.displayLine(string2, n4);
        }
        this.updateScroll();
    }

    public void setProcessArguments(ArrayList<String> arrayList, String string) {
        if (null == this.processRun && !this.processStarted) {
            this.processRun = new ProcessRun(arrayList, string);
            this.processRun.setHandler((ProcessRun.Handler)this);
        }
    }

    public boolean poll() {
        if (this.processExited) {
            return false;
        }
        this.cancelButton.setEnabled(!this.canceled && (null == this.handler || this.handler.canCancel()));
        if (!this.processStarted) {
            if (null == this.processRun) {
                return true;
            }
            this.processStarted = true;
            if (this.processRun.poll()) {
                this.setStatusMessage(this.processName + " running");
            } else {
                this.processExited = true;
                this.setStatusMessage(this.processName + " startup failed");
                this.cancelButton.setEnabled(false);
            }
        } else if (!this.processRun.poll()) {
            this.processExited = true;
            if (this.canceled) {
                this.setStatusMessage(this.processName + " canceled");
            } else if (this.processRun.wasStopped()) {
                this.setStatusMessage(this.processName + " aborted");
            } else if (this.processRun.didFail()) {
                this.setStatusMessage(this.processName + " exited with error");
            } else {
                this.setStatusMessage(this.processName + " complete");
            }
            this.cancelButton.setEnabled(false);
        }
        return !this.processExited;
    }

    public void processOutput(ProcessRun processRun, String string, boolean bl) {
        if (processRun != this.processRun) {
            return;
        }
        int n = 0;
        if (bl) {
            n = -1;
        } else {
            this.writeLine(string);
            if (null != this.mergeLineStrings) {
                for (int i = 0; i < this.mergeLineStrings.size(); ++i) {
                    if (!string.contains(this.mergeLineStrings.get(i))) continue;
                    n = i + 1;
                    break;
                }
            }
        }
        this.displayLine(string, n);
        this.updateScroll();
    }

    public void processMessage(ProcessRun processRun, String string, String string2) {
        if (processRun != this.processRun) {
            return;
        }
        if (string.equals("progress")) {
            this.displayLine(string2, -1);
            this.updateScroll();
        } else if (null != this.handler) {
            this.handler.processStatusMessage(this, string, string2);
        }
    }

    public String getProcessResponse(ProcessRun processRun, String string) {
        if (processRun == this.processRun && null != this.handler) {
            return this.handler.getProcessResponse(this, string);
        }
        return null;
    }

    public void processResponseConfirmed(ProcessRun processRun) {
        if (processRun == this.processRun && null != this.handler) {
            this.handler.processResponseConfirmed(this);
        }
    }

    public void processFailed(ProcessRun processRun) {
        if (processRun == this.processRun && null != this.handler) {
            this.handler.processFailed(this);
        }
    }

    public void processComplete(ProcessRun processRun) {
        if (processRun == this.processRun && null != this.handler) {
            this.handler.processComplete(this);
        }
    }

    private void displayLine(String string, int n) {
        int n2 = this.outputArea.getDocument().getLength();
        if (0 != n && n == this.lastOutputLineType || -1 == this.lastOutputLineType) {
            this.outputArea.replaceRange(string, this.lastOutputLineStart, n2);
        } else {
            this.lastOutputLineStart = n2;
            this.outputArea.append(string);
            ++this.scrollbackLineCount;
        }
        this.outputArea.append("\n");
        this.lastOutputLineType = n;
    }

    private void updateScroll() {
        if (this.scrollbackLineCount > 15000) {
            try {
                int n = this.scrollbackLineCount / 10;
                int n2 = this.outputArea.getLineEndOffset(n);
                this.outputArea.getDocument().remove(0, n2);
                this.scrollbackLineCount -= n;
                this.lastOutputLineStart -= n2;
            }
            catch (BadLocationException badLocationException) {
                this.outputArea.setText("");
                this.scrollbackLineCount = 0;
                this.lastOutputLineStart = 0;
                this.lastOutputLineType = 0;
            }
        }
        this.autoScrollLock = true;
        this.outputViewport.validate();
        if (this.outputViewport.getViewSize().height <= this.outputViewport.getExtentSize().height) {
            this.autoScrollState = 0;
        } else {
            if (0 == this.autoScrollState) {
                this.autoScrollState = 1;
            }
            if (1 == this.autoScrollState) {
                this.outputViewport.scrollRectToVisible(new Rectangle(0, this.outputViewport.getViewSize().height - 1, 1, 1));
            }
        }
        this.autoScrollLock = false;
    }

    private void writeLine(String string) {
        try {
            if (!this.outputFileOpened) {
                this.outputFileOpened = true;
                this.outputFile = File.createTempFile(this.processName, ".log");
                this.outputFileWriter = new FileWriter(this.outputFile);
            }
            if (null != this.outputFileWriter) {
                this.outputFileWriter.write(string);
                this.outputFileWriter.write(10);
                this.hasOutput = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void cancel() {
        if (this.canceled || null != this.handler && !this.handler.canCancel()) {
            return;
        }
        this.canceled = true;
        this.cancelButton.setEnabled(false);
        if (!this.processStarted) {
            this.processStarted = true;
            this.processExited = true;
            this.setStatusMessage(this.processName + " canceled");
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isProcessRunning() {
        if (null != this.processRun) {
            return this.processRun.isRunning();
        }
        return !this.processExited;
    }

    public boolean didProcessFail() {
        if (null != this.processRun) {
            return this.processRun.didFail();
        }
        return this.processExited;
    }

    public boolean hasOutput() {
        return !this.isProcessRunning() && this.hasOutput;
    }

    public void writeOutputTo(Writer writer) throws IOException {
        if (this.isProcessRunning() || !this.hasOutput) {
            return;
        }
        if (null != this.outputFileWriter) {
            try {
                this.outputFileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputFileWriter = null;
        }
        IOException iOException = null;
        try {
            int n;
            FileReader fileReader = new FileReader(this.outputFile);
            char[] cArray = new char[0x100000];
            do {
                if ((n = fileReader.read(cArray, 0, 0x100000)) <= 0) continue;
                writer.write(cArray, 0, n);
            } while (n >= 0);
            fileReader.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (null != iOException) {
            throw iOException;
        }
    }

    public static interface Handler {
        public void processStatusMessage(ProcessPanel var1, String var2, String var3);

        public String getProcessResponse(ProcessPanel var1, String var2);

        public void processResponseConfirmed(ProcessPanel var1);

        public void processFailed(ProcessPanel var1);

        public void processComplete(ProcessPanel var1);

        public boolean canCancel();

        public void setStatusMessage(String var1);
    }
}

