/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.run;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.Scenario;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppFrame;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import gov.fcc.tvstudy.gui.StudyLockHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AnalyzeRunResult
extends AppFrame
implements StudyLockHolder {
    public static final String WINDOW_TITLE = "Analyze Run Result";
    private static final int KEY_COVERAGE = -1;
    private static final int KEY_COVERAGE_LOSS = -2;
    private static final int KEY_COVERAGE_GAIN = -3;
    private static final int KEY_COVERAGE_OVERLAP = -4;
    private static final int KEY_CUSTOM_QUERY = -5;
    private static final String NAME_COVERAGE = "Coverage";
    private static final String NAME_COVERAGE_LOSS = "Coverage loss";
    private static final String NAME_COVERAGE_GAIN = "Coverage gain";
    private static final String NAME_COVERAGE_OVERLAP = "Coverage overlap";
    private Study study;
    private ArrayList<KeyedRecord> scenarioList = new ArrayList();
    private HashMap<Integer, ScenarioResult> scenarioMap = new HashMap();
    private HashMap<Integer, SavedQuery> queryMap;
    private KeyedRecordMenu queryMenu;
    private JButton editButton;
    private JMenuItem editMenuItem;
    private JMenuItem deleteMenuItem;
    private KeyedRecordMenu scenarioAMenu;
    private KeyedRecordMenu scenarioBMenu;
    private KeyedRecordMenu countryMenu;
    private JCheckBox excludeZeroPopCheckBox;
    private JButton modifyButton;
    private JMenuItem modifyMenuItem;
    private JButton newButton;
    private JMenuItem newMenuItem;
    private JButton runButton;
    private JMenuItem runMenuItem;
    private JButton viewButton;
    private JMenuItem viewMenuItem;
    private JButton saveCSVButton;
    private JMenuItem saveCSVMenuItem;
    private JButton saveKMLButton;
    private JMenuItem saveKMLMenuItem;
    private JButton closeButton;
    private QueryEditDialog editDialog;
    private SavedQuery customQuery;
    private String runDescription = "";
    private String runQuery = "";
    private boolean noResult;
    private Integer baseKey;
    private int baseCountry;
    private String pointQuery;
    private QueryRunner queryRunner;
    private boolean queryRunning;
    private Thread queryThread;
    private static final int TIMER_INTERVAL = 200;
    private Timer queryTimer;
    private JButton cancelButton;
    private JTextArea resultArea;
    private ResultTableModel tableModel;
    private boolean didRun;
    private ArrayList<String[]> results;
    private String[] resultColumnNames;
    private int resultNameColumn = -1;
    private int resultLatitudeColumn = -1;
    private int resultLongitudeColumn = -1;
    private boolean canSaveKML;

    public AnalyzeRunResult(AppEditor appEditor) {
        super(appEditor, WINDOW_TITLE);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AnalyzeRunResult.this.queryRunning) {
                    return;
                }
                if (AnalyzeRunResult.this.blockActions()) {
                    AnalyzeRunResult.this.clearResult();
                    AnalyzeRunResult.this.blockActionsEnd();
                }
            }
        };
        this.queryMap = new HashMap();
        this.queryMenu = new KeyedRecordMenu();
        this.queryMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXyXyXyXy"));
        this.queryMenu.addActionListener(actionListener);
        this.scenarioAMenu = new KeyedRecordMenu();
        this.scenarioAMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXyXyXyXy"));
        this.scenarioAMenu.addActionListener(actionListener);
        this.scenarioBMenu = new KeyedRecordMenu();
        this.scenarioBMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXyXyXyXy"));
        this.scenarioBMenu.addActionListener(actionListener);
        ArrayList arrayList = Country.getCountries();
        arrayList.add(0, new KeyedRecord(0, "(all)"));
        this.countryMenu = new KeyedRecordMenu(arrayList);
        this.countryMenu.addActionListener(actionListener);
        this.excludeZeroPopCheckBox = new JCheckBox("Exclude zero-pop points");
        this.excludeZeroPopCheckBox.addActionListener(actionListener);
        this.excludeZeroPopCheckBox.setSelected(true);
        this.editDialog = new QueryEditDialog(this);
        this.resultArea = new JTextArea(8, 40);
        this.resultArea.setFont(new Font("Monospaced", 0, 12));
        AppController.fixKeyBindings(this.resultArea);
        this.resultArea.setEditable(false);
        this.resultArea.setLineWrap(true);
        this.tableModel = new ResultTableModel();
        this.editButton = new JButton("Edit");
        this.editButton.setFocusable(false);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doEdit();
            }
        });
        this.modifyButton = new JButton("Modify Query");
        this.modifyButton.setFocusable(false);
        this.modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doModify();
            }
        });
        this.newButton = new JButton("New Query");
        this.newButton.setFocusable(false);
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doNew();
            }
        });
        this.runButton = new JButton("Run");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doRun();
            }
        });
        this.viewButton = new JButton("View");
        this.viewButton.setFocusable(false);
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doView();
            }
        });
        this.saveCSVButton = new JButton("Save CSV");
        this.saveCSVButton.setFocusable(false);
        this.saveCSVButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doSaveCSV();
            }
        });
        this.saveKMLButton = new JButton("Save KML");
        this.saveKMLButton.setFocusable(false);
        this.saveKMLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doSaveKML();
            }
        });
        this.closeButton = new JButton("Close");
        this.closeButton.setFocusable(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.closeWithoutSave();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setFocusable(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.cancelQuery();
            }
        });
        this.cancelButton.setEnabled(false);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("Query"));
        jPanel.add(this.queryMenu);
        jPanel.add(this.editButton);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel("Scenario A"));
        jPanel2.add(this.scenarioAMenu);
        jPanel2.add(new JLabel("Country"));
        jPanel2.add(this.countryMenu);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(new JLabel("Scenario B"));
        jPanel3.add(this.scenarioBMenu);
        jPanel3.add(this.excludeZeroPopCheckBox);
        Box box = Box.createVerticalBox();
        box.add(this.modifyButton);
        box.add(this.newButton);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(box);
        Box box2 = Box.createVerticalBox();
        box2.add(this.saveCSVButton);
        box2.add(this.saveKMLButton);
        JPanel jPanel5 = new JPanel(new FlowLayout(2));
        jPanel5.add(this.runButton);
        jPanel5.add(this.viewButton);
        jPanel5.add(box2);
        Box box3 = Box.createHorizontalBox();
        box3.add(jPanel4);
        box3.add(jPanel5);
        Box box4 = Box.createVerticalBox();
        box4.add(jPanel);
        box4.add(jPanel2);
        box4.add(jPanel3);
        box4.add(box3);
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        jPanel6.add(this.cancelButton);
        JPanel jPanel7 = new JPanel(new FlowLayout(2));
        jPanel7.add(this.closeButton);
        Box box5 = Box.createHorizontalBox();
        box5.add(jPanel6);
        box5.add(jPanel7);
        this.setLayout(new BorderLayout());
        this.add((Component)box4, "North");
        this.add((Component)AppController.createScrollPane(this.resultArea), "Center");
        this.add((Component)box5, "South");
        this.getRootPane().setDefaultButton(this.runButton);
        this.setResizable(true);
        this.setLocationSaved(true);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.fileMenu.removeAll();
        this.editMenuItem = new JMenuItem("Edit");
        this.editMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppController.MENU_SHORTCUT_KEY_MASK));
        this.editMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doEdit();
            }
        });
        this.fileMenu.add(this.editMenuItem);
        this.deleteMenuItem = new JMenuItem("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doDelete();
            }
        });
        this.fileMenu.add(this.deleteMenuItem);
        this.fileMenu.addSeparator();
        this.modifyMenuItem = new JMenuItem("Modify");
        this.modifyMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, AppController.MENU_SHORTCUT_KEY_MASK));
        this.modifyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doModify();
            }
        });
        this.fileMenu.add(this.modifyMenuItem);
        this.newMenuItem = new JMenuItem("New");
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, AppController.MENU_SHORTCUT_KEY_MASK));
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doNew();
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.fileMenu.addSeparator();
        this.runMenuItem = new JMenuItem("Run");
        this.runMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, AppController.MENU_SHORTCUT_KEY_MASK));
        this.runMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doRun();
            }
        });
        this.fileMenu.add(this.runMenuItem);
        this.fileMenu.addSeparator();
        this.viewMenuItem = new JMenuItem("View Table");
        this.viewMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, AppController.MENU_SHORTCUT_KEY_MASK));
        this.viewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doView();
            }
        });
        this.fileMenu.add(this.viewMenuItem);
        this.saveCSVMenuItem = new JMenuItem("Save CSV File");
        this.saveCSVMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, AppController.MENU_SHORTCUT_KEY_MASK));
        this.saveCSVMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doSaveCSV();
            }
        });
        this.fileMenu.add(this.saveCSVMenuItem);
        this.saveKMLMenuItem = new JMenuItem("Save KML File");
        this.saveKMLMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, AppController.MENU_SHORTCUT_KEY_MASK));
        this.saveKMLMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.doSaveKML();
            }
        });
        this.fileMenu.add(this.saveKMLMenuItem);
        this.queryTimer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnalyzeRunResult.this.checkQuery();
            }
        });
    }

    @Override
    protected String getFileMenuName() {
        return "Query";
    }

    @Override
    public void updateDocumentName() {
        String string = this.parent.getDocumentName();
        if (null != this.study) {
            string = null == string ? this.study.name : string + "/" + this.study.name;
        }
        this.setDocumentName(string);
    }

    public boolean setStudy(Study study, ErrorReporter errorReporter) {
        Object object;
        ScenarioResult scenarioResult;
        if (this.isVisible() || null != this.study) {
            return false;
        }
        DbConnection dbConnection = DbCore.connectDb((String)study.dbID, (ErrorLogger)errorReporter);
        if (null == dbConnection) {
            return false;
        }
        this.scenarioList.clear();
        this.scenarioMap.clear();
        for (Object object2 : study.scenarios) {
            scenarioResult = new ScenarioResult();
            scenarioResult.key = ((Scenario)object2).key;
            scenarioResult.name = ((Scenario)object2).name;
            this.scenarioMap.put(scenarioResult.key, scenarioResult);
        }
        try {
            object = DbCore.getDbName((String)study.dbID) + "_" + String.valueOf(study.key);
            dbConnection.query("SHOW TABLES IN " + (String)object + " LIKE 'result\\_%'");
            while (dbConnection.next()) {
                Object object2;
                object2 = dbConnection.getString(1);
                Integer n = null;
                try {
                    n = Integer.valueOf(((String)object2).substring(7));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (null == n || null == (scenarioResult = this.scenarioMap.get(n))) continue;
                scenarioResult.hasTable = true;
                this.scenarioList.add(new KeyedRecord(n.intValue(), scenarioResult.name));
            }
            dbConnection.query("SHOW TABLES IN " + (String)object + " LIKE 'saved_query'");
            if (!dbConnection.next()) {
                dbConnection.update("CREATE TABLE " + (String)object + ".saved_query (query_key INT NOT NULL PRIMARY KEY, name VARCHAR(255) NOT NULL, description VARCHAR(255) NOT NULL, query MEDIUMTEXT NOT NULL, no_result BOOLEAN NOT NULL)");
            }
        }
        catch (SQLException sQLException) {
            DbCore.releaseDb((DbConnection)dbConnection);
            DbConnection.reportError((ErrorLogger)errorReporter, (SQLException)sQLException);
            return false;
        }
        DbCore.releaseDb((DbConnection)dbConnection);
        if (this.scenarioList.isEmpty()) {
            errorReporter.reportWarning("The study does not have any result data to analyze");
            return false;
        }
        this.study = study;
        object = new Comparator<KeyedRecord>(){

            @Override
            public int compare(KeyedRecord keyedRecord, KeyedRecord keyedRecord2) {
                if (keyedRecord.key < keyedRecord2.key) {
                    return -1;
                }
                if (keyedRecord.key > keyedRecord2.key) {
                    return 1;
                }
                return 0;
            }
        };
        this.scenarioList.sort((Comparator<KeyedRecord>)object);
        this.editDialog.setScenarios(this.scenarioList);
        this.scenarioAMenu.addAllItems(this.scenarioList);
        this.scenarioBMenu.addAllItems(this.scenarioList);
        if (this.scenarioList.size() > 1) {
            this.scenarioBMenu.setSelectedIndex(1);
        }
        this.updateDocumentName();
        this.updateMenu(null);
        return true;
    }

    private void updateControls(SavedQuery savedQuery) {
        if (this.queryRunning) {
            AppController.setComponentEnabled(this.queryMenu, false);
            this.editButton.setEnabled(false);
            this.editMenuItem.setEnabled(false);
            this.deleteMenuItem.setEnabled(false);
            AppController.setComponentEnabled(this.scenarioAMenu, false);
            AppController.setComponentEnabled(this.scenarioBMenu, false);
            AppController.setComponentEnabled(this.countryMenu, false);
            AppController.setComponentEnabled(this.excludeZeroPopCheckBox, false);
            this.modifyButton.setEnabled(false);
            this.modifyMenuItem.setEnabled(false);
            this.newButton.setEnabled(false);
            this.newMenuItem.setEnabled(false);
            this.runButton.setEnabled(false);
            this.runMenuItem.setEnabled(false);
            this.viewButton.setEnabled(false);
            this.viewMenuItem.setEnabled(false);
            this.saveCSVButton.setEnabled(false);
            this.saveCSVMenuItem.setEnabled(false);
            this.saveKMLButton.setEnabled(false);
            this.saveKMLMenuItem.setEnabled(false);
            this.closeButton.setEnabled(false);
        } else {
            int n = null != savedQuery ? savedQuery.key.intValue() : this.queryMenu.getSelectedKey();
            AppController.setComponentEnabled(this.queryMenu, true);
            boolean bl = n > 0;
            this.editButton.setEnabled(bl);
            this.editMenuItem.setEnabled(bl);
            this.deleteMenuItem.setEnabled(bl);
            bl = -1 == n || -2 == n || -3 == n || -4 == n;
            AppController.setComponentEnabled(this.scenarioAMenu, bl);
            AppController.setComponentEnabled(this.countryMenu, bl);
            AppController.setComponentEnabled(this.excludeZeroPopCheckBox, bl);
            bl = -2 == n || -3 == n || -4 == n;
            AppController.setComponentEnabled(this.scenarioBMenu, bl);
            this.modifyButton.setEnabled(true);
            this.modifyMenuItem.setEnabled(true);
            this.newButton.setEnabled(true);
            this.newMenuItem.setEnabled(true);
            this.runButton.setEnabled(!this.didRun);
            this.runMenuItem.setEnabled(!this.didRun);
            bl = this.didRun && null != this.results;
            this.viewButton.setEnabled(bl);
            this.viewMenuItem.setEnabled(bl);
            this.saveCSVButton.setEnabled(bl);
            this.saveCSVMenuItem.setEnabled(bl);
            this.saveKMLButton.setEnabled(bl && this.canSaveKML);
            this.saveKMLMenuItem.setEnabled(bl & this.canSaveKML);
            this.closeButton.setEnabled(true);
        }
    }

    private void updateMenu(SavedQuery savedQuery) {
        if (this.queryRunning) {
            return;
        }
        this.blockActionsStart();
        this.queryMap.clear();
        int n = -1;
        if (null == savedQuery && this.queryMenu.getItemCount() > 0) {
            n = this.queryMenu.getSelectedKey();
        }
        this.queryMenu.removeAllItems();
        this.queryMenu.addItem(new KeyedRecord(-1, NAME_COVERAGE));
        this.queryMenu.addItem(new KeyedRecord(-2, NAME_COVERAGE_LOSS));
        this.queryMenu.addItem(new KeyedRecord(-3, NAME_COVERAGE_GAIN));
        this.queryMenu.addItem(new KeyedRecord(-4, NAME_COVERAGE_OVERLAP));
        DbConnection dbConnection = DbCore.connectDb((String)this.study.dbID);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT query_key, name, description, query, no_result FROM " + DbCore.getDbName((String)this.study.dbID) + "_" + String.valueOf(this.study.key) + ".saved_query ORDER BY 1");
                while (dbConnection.next()) {
                    SavedQuery savedQuery2 = new SavedQuery();
                    savedQuery2.key = dbConnection.getInt(1);
                    savedQuery2.name = dbConnection.getString(2);
                    savedQuery2.description = dbConnection.getString(3);
                    savedQuery2.query = dbConnection.getString(4);
                    savedQuery2.noResult = dbConnection.getBoolean(5);
                    this.queryMap.put(savedQuery2.key, savedQuery2);
                    this.queryMenu.addItem(new KeyedRecord(savedQuery2.key.intValue(), savedQuery2.name));
                }
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb((DbConnection)dbConnection);
                DbConnection.reportError((SQLException)sQLException);
            }
            DbCore.releaseDb((DbConnection)dbConnection);
        }
        if (null != savedQuery) {
            this.queryMenu.setSelectedItem(new KeyedRecord(savedQuery.key.intValue(), savedQuery.name));
        } else if (this.queryMenu.containsKey(n)) {
            this.queryMenu.setSelectedKey(n);
        }
        this.clearResult(savedQuery);
        this.blockActionsEnd();
    }

    private void doNew() {
        if (!this.isVisible() || null == this.study || this.queryRunning) {
            return;
        }
        this.editDialog.setQuery(0);
        AppController.showWindow(this.editDialog);
        if (this.editDialog.canceled) {
            return;
        }
        this.customQuery = this.editDialog.getQuery();
        this.updateMenu(this.customQuery);
    }

    private void doModify() {
        if (!this.isVisible() || null == this.study || !this.buildQuery() || this.queryRunning) {
            return;
        }
        boolean bl = false;
        if (null != this.pointQuery) {
            Object[] objectArray = new String[]{"Cancel", "View/Save query", "Summary query"};
            switch (JOptionPane.showOptionDialog(this, "There are separate queries for summary and\nfor view/save output, which do you want to modify?", "Choose Query", -1, 3, null, objectArray, null)) {
                default: {
                    return;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = false;
                }
            }
        }
        this.editDialog.setQuery(-5, bl);
        AppController.showWindow(this.editDialog);
        if (this.editDialog.canceled) {
            return;
        }
        this.customQuery = this.editDialog.getQuery();
        this.updateMenu(this.customQuery);
    }

    private void doEdit() {
        if (!this.isVisible() || null == this.study || this.queryRunning) {
            return;
        }
        this.editDialog.setQuery(this.queryMenu.getSelectedKey());
        AppController.showWindow(this.editDialog);
        if (this.editDialog.canceled) {
            return;
        }
        this.updateMenu(this.editDialog.getQuery());
    }

    private void doDelete() {
        if (!this.isVisible() || null == this.study || this.queryRunning) {
            return;
        }
        int n = this.queryMenu.getSelectedKey();
        SavedQuery savedQuery = this.queryMap.get(n);
        if (null == savedQuery) {
            return;
        }
        String string = "Delete Query";
        this.errorReporter.setTitle(string);
        AppController.beep();
        if (0 != JOptionPane.showConfirmDialog(this, "Are you sure you want to delete query '" + savedQuery.name + "'?", string, 0, 2)) {
            return;
        }
        DbConnection dbConnection = DbCore.connectDb((String)this.study.dbID, (ErrorLogger)this.errorReporter);
        if (null == dbConnection) {
            return;
        }
        try {
            dbConnection.update("DELETE FROM " + DbCore.getDbName((String)this.study.dbID) + "_" + String.valueOf(this.study.key) + ".saved_query WHERE query_key = " + String.valueOf(savedQuery.key));
        }
        catch (SQLException sQLException) {
            DbCore.releaseDb((DbConnection)dbConnection);
            DbConnection.reportError((ErrorLogger)this.errorReporter, (SQLException)sQLException);
            return;
        }
        DbCore.releaseDb((DbConnection)dbConnection);
        this.updateMenu(null);
    }

    private boolean buildQuery() {
        if (this.queryRunning) {
            return false;
        }
        String string = "Build Query";
        this.errorReporter.setTitle(string);
        int n = this.queryMenu.getSelectedKey();
        switch (n) {
            case -1: {
                int n2 = this.scenarioAMenu.getSelectedKey();
                if (n2 <= 0) {
                    this.errorReporter.reportWarning("Please select a scenario");
                    return false;
                }
                this.runDescription = this.queryMenu.getSelectedName();
                this.runQuery = "SELECT\n  SUM(area) AS area,\n  SUM(population) AS population,\n  SUM(households) AS households\nFROM\n  result_" + n2 + "\nWHERE\n  (result = 1)\n";
                this.noResult = false;
                this.baseKey = null;
                this.baseCountry = 0;
                this.pointQuery = "SELECT\n  country_key,\n  lat_index,\n  lon_index,\n  latitude,\n  longitude,\n  area,\n  population,\n  households,\n  source_key,\n  (margin / 100.) AS service_margin\nFROM\n  result_" + n2 + "\nWHERE\n  (result = 1)\n";
                int n3 = this.countryMenu.getSelectedKey();
                if (n3 > 0) {
                    this.runQuery = this.runQuery + "  AND (country_key = " + n3 + ")\n";
                    this.pointQuery = this.pointQuery + "  AND (country_key = " + n3 + ")\n";
                }
                if (!this.excludeZeroPopCheckBox.isSelected()) break;
                this.pointQuery = this.pointQuery + "  AND (result_" + n2 + ".population > 0)\n";
                break;
            }
            case -3: 
            case -2: {
                int n4;
                int n5;
                int n6 = this.scenarioAMenu.getSelectedKey();
                int n7 = this.scenarioBMenu.getSelectedKey();
                if (n6 <= 0 || n7 <= 0 || n6 == n7) {
                    this.errorReporter.reportWarning("Please select two different scenarios to compare");
                    return false;
                }
                if (-2 == n) {
                    n5 = n6;
                    n4 = n7;
                } else {
                    n5 = n7;
                    n4 = n6;
                }
                this.runDescription = this.queryMenu.getSelectedName();
                this.runQuery = "SELECT\n  SUM(result_" + n5 + ".area) AS area,\n  SUM(result_" + n5 + ".population) AS population,\n  SUM(result_" + n5 + ".households) AS households\nFROM\n  result_" + n5 + "\n  LEFT JOIN result_" + n4 + " USING (country_key, lat_index, lon_index)\nWHERE\n  (result_" + n5 + ".result = 1)\n  AND ((result_" + n4 + ".result IS NULL)\n    OR (result_" + n4 + ".result <> 1))\n";
                this.noResult = false;
                this.baseKey = n5;
                this.baseCountry = 0;
                this.pointQuery = "SELECT\n  result_" + n5 + ".country_key,\n  result_" + n5 + ".lat_index,\n  result_" + n5 + ".lon_index,\n  result_" + n5 + ".latitude,\n  result_" + n5 + ".longitude,\n  result_" + n5 + ".area,\n  result_" + n5 + ".population,\n  result_" + n5 + ".households\nFROM\n  result_" + n5 + "\n  LEFT JOIN result_" + n4 + " USING (country_key, lat_index, lon_index)\nWHERE\n  (result_" + n5 + ".result = 1)\n  AND ((result_" + n4 + ".result IS NULL)\n    OR (result_" + n4 + ".result <> 1))\n";
                int n8 = this.countryMenu.getSelectedKey();
                if (n8 > 0) {
                    this.runQuery = this.runQuery + "  AND (country_key = " + n8 + ")\n";
                    this.baseCountry = n8;
                    this.pointQuery = this.pointQuery + " AND (country_key = " + n8 + ")";
                }
                if (!this.excludeZeroPopCheckBox.isSelected()) break;
                this.pointQuery = this.pointQuery + " AND (result_" + n5 + ".population > 0)";
                break;
            }
            case -4: {
                int n9 = this.scenarioAMenu.getSelectedKey();
                int n10 = this.scenarioBMenu.getSelectedKey();
                if (n9 <= 0 || n10 <= 0 || n9 == n10) {
                    this.errorReporter.reportWarning("Please select two different scenarios to compare");
                    return false;
                }
                this.runDescription = this.queryMenu.getSelectedName();
                this.runQuery = "SELECT\n  SUM(result_" + n9 + ".area) AS area,\n  SUM(result_" + n9 + ".population) AS population,\n  SUM(result_" + n9 + ".households) AS households\nFROM\n  result_" + n9 + "\n  JOIN result_" + n10 + " USING (country_key, lat_index, lon_index)\nWHERE\n  (result_" + n9 + ".result = 1)\n  AND (result_" + n10 + ".result = 1)\n";
                this.noResult = false;
                this.baseKey = null;
                this.baseCountry = 0;
                this.pointQuery = "SELECT\n  result_" + n9 + ".country_key,\n  result_" + n9 + ".lat_index,\n  result_" + n9 + ".lon_index,\n  result_" + n9 + ".latitude,\n  result_" + n9 + ".longitude,\n  result_" + n9 + ".area,\n  result_" + n9 + ".population,\n  result_" + n9 + ".households\nFROM\n  result_" + n9 + "\n  JOIN result_" + n10 + " USING (country_key, lat_index, lon_index)\nWHERE\n  (result_" + n9 + ".result = 1)\n  AND (result_" + n10 + ".result = 1)\n";
                int n11 = this.countryMenu.getSelectedKey();
                if (n11 > 0) {
                    this.runQuery = this.runQuery + "  AND (country_key = " + n11 + ")\n";
                    this.pointQuery = this.pointQuery + "  AND (country_key = " + n11 + ")\n";
                }
                if (!this.excludeZeroPopCheckBox.isSelected()) break;
                this.pointQuery = this.pointQuery + "  AND (result_" + n9 + ".population > 0)\n";
                break;
            }
            case -5: {
                if (null == this.customQuery) {
                    return false;
                }
                this.runDescription = this.customQuery.description;
                if (0 == this.runDescription.length()) {
                    this.runDescription = this.customQuery.name;
                }
                this.runQuery = this.customQuery.query;
                this.noResult = this.customQuery.noResult;
                this.baseKey = null;
                this.baseCountry = 0;
                this.pointQuery = null;
                break;
            }
            default: {
                SavedQuery savedQuery = this.queryMap.get(n);
                if (null == savedQuery) {
                    return false;
                }
                this.runDescription = savedQuery.description;
                if (0 == this.runDescription.length()) {
                    this.runDescription = savedQuery.name;
                }
                this.runQuery = savedQuery.query;
                this.noResult = savedQuery.noResult;
                this.baseKey = null;
                this.baseCountry = 0;
                this.pointQuery = null;
                break;
            }
        }
        return true;
    }

    private void doRun() {
        if (!this.isVisible() || null == this.study || !this.buildQuery() || this.queryRunning) {
            return;
        }
        this.errorReporter.setTitle("Run Query");
        this.queryRunner = new QueryRunner();
        this.queryThread = new Thread(this.queryRunner);
        this.queryThread.start();
        this.queryRunning = true;
        this.queryTimer.start();
        this.cancelButton.setEnabled(true);
        this.clearResult();
        this.resultArea.setText("Query running...");
    }

    private void cancelQuery() {
        if (!this.queryRunning || null == this.queryRunner.db || this.queryRunner.canceled) {
            return;
        }
        this.queryRunner.canceled = true;
        this.cancelButton.setEnabled(false);
        String string = ((QueryRunner)this.queryRunner).db.username;
        String string2 = this.queryRunner.db.getDatabase();
        if (null == string2) {
            return;
        }
        DbConnection dbConnection = DbCore.connectDb((String)this.study.dbID, (ErrorLogger)this.errorReporter);
        if (null == dbConnection) {
            return;
        }
        try {
            dbConnection.query("SHOW PROCESSLIST");
            int n = 0;
            while (dbConnection.next()) {
                if (!"Query".equals(dbConnection.getString("Command")) || !string.equals(dbConnection.getString("User")) || !string2.equals(dbConnection.getString("db"))) continue;
                n = dbConnection.getInt("Id");
                break;
            }
            if (n > 0) {
                dbConnection.update("KILL QUERY " + String.valueOf(n));
            }
        }
        catch (SQLException sQLException) {
            DbConnection.reportError((ErrorLogger)this.errorReporter, (SQLException)sQLException);
        }
        DbCore.releaseDb((DbConnection)dbConnection);
    }

    private void checkQuery() {
        if (!this.queryRunning) {
            this.queryTimer.stop();
            return;
        }
        if (this.queryThread.isAlive()) {
            return;
        }
        this.queryThread = null;
        this.queryRunning = false;
        this.queryTimer.stop();
        this.cancelButton.setEnabled(false);
        if (this.queryRunner.errors.hasErrors()) {
            this.resultArea.setText(this.queryRunner.errors.toString());
        } else if (this.queryRunner.canceled) {
            this.resultArea.setText("Query canceled\n");
        } else {
            this.didRun = true;
            this.resultArea.setText(this.runDescription);
            this.resultArea.append("\n");
            if (this.noResult) {
                this.resultArea.append("\nQuery modified " + String.valueOf(this.queryRunner.updateCount) + " rows\n");
            } else if (!this.queryRunner.hasOutput) {
                this.resultArea.append("\nQuery returned empty result\n");
            } else {
                int n;
                this.resultArea.append("\n");
                for (n = 0; n < this.queryRunner.outputLabels.length; ++n) {
                    this.resultArea.append(String.format("%20s  %s\n", this.queryRunner.outputLabels[n], this.queryRunner.outputValues[n]));
                }
                if (null != this.queryRunner.newResults && !this.queryRunner.newResults.isEmpty()) {
                    this.results = this.queryRunner.newResults;
                    this.resultColumnNames = this.queryRunner.columnNames;
                    for (n = 0; n < this.resultColumnNames.length; ++n) {
                        if (this.resultColumnNames[n].equalsIgnoreCase("name")) {
                            this.resultNameColumn = n;
                        }
                        if (this.resultColumnNames[n].equalsIgnoreCase("latitude")) {
                            this.resultLatitudeColumn = n;
                        }
                        if (!this.resultColumnNames[n].equalsIgnoreCase("longitude")) continue;
                        this.resultLongitudeColumn = n;
                    }
                    this.canSaveKML = this.resultLatitudeColumn >= 0 && this.resultLongitudeColumn >= 0;
                    this.resultArea.append("\n");
                    this.resultArea.append(String.valueOf(this.results.size()));
                    this.resultArea.append(" rows in result\n");
                }
            }
            if (this.queryRunner.errors.hasMessages()) {
                this.resultArea.append("\n");
                this.resultArea.append(this.queryRunner.errors.getMessages());
            }
        }
        this.queryRunner = null;
        this.updateControls(null);
    }

    private void doView() {
        if (!this.isVisible() || null == this.study || this.queryRunning || null == this.results) {
            return;
        }
        AppDialog appDialog = new AppDialog(this, "Query Results", Dialog.ModalityType.DOCUMENT_MODAL){

            @Override
            public void windowWillOpen() {
                this.blockActionsClear();
            }

            @Override
            public void windowWillClose() {
                this.blockActionsSet();
            }
        };
        appDialog.setLayout(new BorderLayout());
        appDialog.add((Component)AppController.createScrollPane(this.tableModel.createTable(), 22, 32), "Center");
        appDialog.setResizable(true);
        appDialog.setLocationSaved(true);
        appDialog.pack();
        appDialog.setMinimumSize(appDialog.getSize());
        AppController.showWindow(appDialog);
    }

    private void doSaveCSV() {
        if (!this.isVisible() || null == this.study || this.queryRunning || null == this.results) {
            return;
        }
        String string = "Save results to CSV file";
        this.errorReporter.setTitle(string);
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("CSV (*.csv)", "csv"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        do {
            if (0 != jFileChooser.showDialog(this, "Save")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            String string2 = file.getName().toLowerCase();
            if (!string2.endsWith(".csv")) {
                file = new File(file.getAbsolutePath() + ".csv");
            }
            if (!file.exists()) continue;
            AppController.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("File could not be created:\n" + iOException.getMessage());
            return;
        }
        try {
            String string3 = "";
            for (String string4 : this.resultColumnNames) {
                bufferedWriter.write(string3);
                bufferedWriter.write(string4);
                string3 = ",";
            }
            bufferedWriter.write("\n");
            for (String[] stringArray : this.results) {
                string3 = "";
                for (String string5 : stringArray) {
                    bufferedWriter.write(string3);
                    bufferedWriter.write(string5);
                    string3 = ",";
                }
                bufferedWriter.write("\n");
            }
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Error writing to file:\n" + iOException.getMessage());
            return;
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doSaveKML() {
        if (!this.isVisible() || null == this.study || this.queryRunning || null == this.results || !this.canSaveKML) {
            return;
        }
        String string = "Save results to KML file";
        this.errorReporter.setTitle(string);
        File file = null;
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("KML (*.kml)", "kml"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        do {
            if (0 != jFileChooser.showDialog(this, "Save")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            String string2 = file.getName().toLowerCase();
            if (!string2.endsWith(".kml")) {
                file = new File(file.getAbsolutePath() + ".kml");
            }
            if (!file.exists()) continue;
            AppController.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("File could not be created:\n" + iOException.getMessage());
            return;
        }
        int n = this.resultColumnNames.length;
        boolean bl = false;
        bl = this.resultNameColumn >= 0 ? this.resultColumnNames.length > 3 : this.resultColumnNames.length > 2;
        try {
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
            bufferedWriter.write("<kml xmlns=\"http://www.opengis.net/kml/2.2\">\n");
            bufferedWriter.write("<Document>\n<name>");
            bufferedWriter.write(AppCore.xmlclean((String)this.runDescription));
            bufferedWriter.write("</name>\n");
            bufferedWriter.write("<Style id=\"styles\">\n");
            bufferedWriter.write("<IconStyle><color>ffff0000</color><scale>0.5</scale></IconStyle>\n");
            bufferedWriter.write("<LineStyle><color>ff00ff00</color><width>3</width></LineStyle>\n");
            bufferedWriter.write("<PolyStyle><outline>1</outline><fill>0</fill></PolyStyle>\n");
            bufferedWriter.write("</Style>\n");
            for (String[] stringArray : this.results) {
                bufferedWriter.write("<Placemark>\n");
                bufferedWriter.write("<styleUrl>#styles</styleUrl>\n");
                if (this.resultNameColumn >= 0) {
                    bufferedWriter.write("<name>");
                    bufferedWriter.write(AppCore.xmlclean((String)stringArray[this.resultNameColumn]));
                    bufferedWriter.write("</name>\n");
                }
                if (bl) {
                    bufferedWriter.write("<ExtendedData>\n");
                    for (int i = 0; i < n; ++i) {
                        if (i == this.resultNameColumn || i == this.resultLatitudeColumn || i == this.resultLongitudeColumn) continue;
                        bufferedWriter.write("<Data name=\"");
                        bufferedWriter.write(this.resultColumnNames[i]);
                        bufferedWriter.write("\"><value>");
                        if (null != stringArray[i]) {
                            bufferedWriter.write(stringArray[i]);
                        }
                        bufferedWriter.write("</value></Data>\n");
                    }
                    bufferedWriter.write("</ExtendedData>\n");
                }
                bufferedWriter.write("<Point>\n<coordinates>");
                String string3 = stringArray[this.resultLongitudeColumn];
                if (string3.startsWith("-")) {
                    string3 = string3.substring(1);
                } else {
                    bufferedWriter.write("-");
                }
                bufferedWriter.write(string3);
                bufferedWriter.write(44);
                bufferedWriter.write(stringArray[this.resultLatitudeColumn]);
                bufferedWriter.write("</coordinates>\n</Point>\n");
                bufferedWriter.write("</Placemark>\n");
            }
            bufferedWriter.write("</Document>\n</kml>\n");
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Error writing to file:\n" + iOException.getMessage());
            return;
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void clearResult() {
        this.clearResult(null);
    }

    private void clearResult(SavedQuery savedQuery) {
        this.didRun = false;
        this.results = null;
        this.resultColumnNames = null;
        this.resultNameColumn = -1;
        this.resultLatitudeColumn = -1;
        this.resultLongitudeColumn = -1;
        this.canSaveKML = false;
        this.resultArea.setText("");
        this.updateControls(savedQuery);
    }

    @Override
    public int getStudyKey() {
        if (null != this.study) {
            return this.study.key;
        }
        return 0;
    }

    @Override
    public String getStudyName() {
        if (null != this.study) {
            return this.study.name;
        }
        return "";
    }

    @Override
    public int getStudyLock() {
        if (null != this.study) {
            return this.study.studyLock;
        }
        return 0;
    }

    @Override
    public int getLockCount() {
        if (null != this.study) {
            return this.study.lockCount;
        }
        return 0;
    }

    @Override
    public void toFront() {
        super.toFront();
    }

    @Override
    public boolean closeWithoutSave() {
        if (this.windowShouldClose()) {
            AppController.hideWindow(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean studyManagerClosing() {
        return false;
    }

    @Override
    public void windowWillOpen() {
        this.blockActionsClear();
    }

    @Override
    public boolean windowShouldClose() {
        if (this.queryRunning) {
            this.toFront();
            AppController.beep();
            this.errorReporter.reportMessage("This window can't be closed while a query is running");
            return false;
        }
        if (this.editDialog.isVisible()) {
            return this.editDialog.cancel();
        }
        return true;
    }

    @Override
    public void windowWillClose() {
        if (this.queryRunning) {
            return;
        }
        this.blockActionsSet();
        this.queryTimer.stop();
        this.parent.editorClosing(this);
        this.study = null;
    }

    private class ResultTableModel
    extends AbstractTableModel {
        private ResultTableModel() {
        }

        private JTable createTable() {
            int n;
            int n2;
            if (null == AnalyzeRunResult.this.results) {
                return null;
            }
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable, null);
            jTable.setAutoCreateRowSorter(true);
            jTable.setAutoResizeMode(0);
            int n3 = AnalyzeRunResult.this.resultColumnNames.length;
            int[] nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                n = AnalyzeRunResult.this.resultColumnNames[n2].length() / 2;
                nArray[n2] = n < 5 ? 5 : n;
            }
            for (Object object : AnalyzeRunResult.this.results) {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (null == object[n2] || (n = object[n2].length() / 2) <= nArray[n2]) continue;
                    nArray[n2] = n;
                }
            }
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            for (n2 = 0; n2 < n3; ++n2) {
                Object object;
                object = tableColumnModel.getColumn(n2);
                ((TableColumn)object).setMinWidth(AppController.textFieldWidth[5]);
                ((TableColumn)object).setPreferredWidth(AppController.textFieldWidth[nArray[n2]]);
            }
            return jTable;
        }

        @Override
        public int getColumnCount() {
            if (null == AnalyzeRunResult.this.results) {
                return 0;
            }
            return AnalyzeRunResult.this.resultColumnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            if (null == AnalyzeRunResult.this.results) {
                return "";
            }
            return AnalyzeRunResult.this.resultColumnNames[n];
        }

        @Override
        public int getRowCount() {
            if (null == AnalyzeRunResult.this.results) {
                return 0;
            }
            return AnalyzeRunResult.this.results.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (null == AnalyzeRunResult.this.results) {
                return "";
            }
            return ((String[])AnalyzeRunResult.this.results.get(n))[n2];
        }
    }

    private class QueryRunner
    implements Runnable {
        private ErrorLogger errors = new ErrorLogger(new StringBuilder());
        private DbConnection db;
        private int updateCount;
        private boolean hasOutput;
        private String[] outputLabels;
        private String[] outputValues;
        private ArrayList<String[]> newResults;
        private String[] columnNames;
        private boolean canceled;

        private QueryRunner() {
        }

        @Override
        public void run() {
            block27: {
                this.db = DbCore.connectDb((String)((AnalyzeRunResult)AnalyzeRunResult.this).study.dbID, (ErrorLogger)this.errors);
                if (null == this.db) {
                    this.cleanup();
                    return;
                }
                try {
                    String string;
                    Object object;
                    this.db.setDatabase(DbCore.getDbName((String)((AnalyzeRunResult)AnalyzeRunResult.this).study.dbID) + "_" + String.valueOf(((AnalyzeRunResult)AnalyzeRunResult.this).study.key));
                    if (AnalyzeRunResult.this.noResult) {
                        this.updateCount = this.db.update(AnalyzeRunResult.this.runQuery);
                        this.cleanup();
                        return;
                    }
                    Object object2 = null;
                    if (null != AnalyzeRunResult.this.baseKey && null != (object = (ScenarioResult)AnalyzeRunResult.this.scenarioMap.get(AnalyzeRunResult.this.baseKey)) && ((ScenarioResult)object).hasTable) {
                        if (((ScenarioResult)object).hasResult && ((ScenarioResult)object).resultCountry == AnalyzeRunResult.this.baseCountry) {
                            object2 = object;
                        } else {
                            string = "SELECT SUM(area), SUM(population), SUM(households) FROM result_" + AnalyzeRunResult.this.baseKey + " WHERE (result = 1)";
                            if (AnalyzeRunResult.this.baseCountry > 0) {
                                string = string + " AND (country_key = " + AnalyzeRunResult.this.baseCountry + ")";
                            }
                            this.db.query(string);
                            if (this.db.next()) {
                                ((ScenarioResult)object).area = this.db.getDouble(1);
                                ((ScenarioResult)object).population = this.db.getInt(2);
                                ((ScenarioResult)object).households = this.db.getInt(3);
                                ((ScenarioResult)object).hasResult = true;
                                ((ScenarioResult)object).resultCountry = AnalyzeRunResult.this.baseCountry;
                                object2 = object;
                            }
                        }
                    }
                    int n = 0;
                    boolean bl = null != AnalyzeRunResult.this.pointQuery;
                    string = AnalyzeRunResult.this.runQuery;
                    while (true) {
                        this.db.query(string);
                        object = this.db.getMetaData();
                        n = object.getColumnCount();
                        while (this.db.next() && !this.canceled) {
                            int n2;
                            if (!this.hasOutput) {
                                this.hasOutput = true;
                                this.outputLabels = new String[n];
                                this.outputValues = new String[n];
                                for (n2 = 1; n2 <= n; ++n2) {
                                    String string2;
                                    this.outputLabels[n2 - 1] = object.getColumnLabel(n2);
                                    String string3 = object.getColumnName(n2);
                                    if (string3.equals("area")) {
                                        double d = this.db.getDouble(n2);
                                        string2 = AppCore.formatCount((double)d);
                                        if (null != object2 && ((ScenarioResult)object2).area > 0.0) {
                                            string2 = string2 + String.format(Locale.US, " (%.2f%%)", d / ((ScenarioResult)object2).area * 100.0);
                                        }
                                    } else if (string3.equals("population")) {
                                        int n3 = this.db.getInt(n2);
                                        string2 = AppCore.formatCount((int)n3);
                                        if (null != object2 && ((ScenarioResult)object2).population > 0) {
                                            string2 = string2 + String.format(Locale.US, " (%.2f%%)", (double)n3 / (double)((ScenarioResult)object2).population * 100.0);
                                        }
                                    } else if (string3.equals("households")) {
                                        int n4 = this.db.getInt(n2);
                                        string2 = AppCore.formatCount((int)n4);
                                        if (null != object2 && ((ScenarioResult)object2).households > 0) {
                                            string2 = string2 + String.format(Locale.US, " (%.2f%%)", (double)n4 / (double)((ScenarioResult)object2).households * 100.0);
                                        }
                                    } else {
                                        string2 = this.db.getString(n2);
                                        if (null == string2) {
                                            string2 = "";
                                        }
                                    }
                                    this.outputValues[n2 - 1] = string2;
                                }
                            }
                            if (bl) continue;
                            if (null == this.newResults) {
                                this.newResults = new ArrayList();
                                this.columnNames = new String[n];
                                for (n2 = 1; n2 <= n; ++n2) {
                                    this.columnNames[n2 - 1] = object.getColumnLabel(n2);
                                }
                            }
                            String[] stringArray = new String[n];
                            for (n2 = 1; n2 <= n; ++n2) {
                                stringArray[n2 - 1] = this.db.getString(n2);
                            }
                            this.newResults.add(stringArray);
                        }
                        if (!this.canceled && bl) {
                            string = AnalyzeRunResult.this.pointQuery;
                            bl = false;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    if (this.canceled) break block27;
                    AppCore.log((int)3, (String)"Unexpected error", (Throwable)exception);
                    this.errors.reportError(exception.toString());
                }
            }
            this.cleanup();
        }

        private void cleanup() {
            if (null != this.db) {
                DbCore.releaseDb((DbConnection)this.db);
                this.db = null;
            }
        }
    }

    private class QueryEditDialog
    extends AppDialog {
        private ScenarioModel scenarioModel;
        private SavedQuery query;
        private JTextField nameField;
        private JTextArea descriptionArea;
        private JTextArea queryArea;
        private JCheckBox noResultCheckBox;
        private JButton okButton;
        private boolean canceled;

        private QueryEditDialog(AppEditor appEditor) {
            super(appEditor, null, "Edit Query", Dialog.ModalityType.APPLICATION_MODAL);
            this.scenarioModel = new ScenarioModel();
            this.nameField = new JTextField(30);
            AppController.fixKeyBindings(this.nameField);
            this.descriptionArea = new JTextArea(6, 30);
            AppController.fixKeyBindings(this.descriptionArea);
            this.descriptionArea.setLineWrap(true);
            this.descriptionArea.setWrapStyleWord(true);
            this.queryArea = new JTextArea(25, 50);
            AppController.fixKeyBindings(this.queryArea);
            this.queryArea.setLineWrap(true);
            this.queryArea.setWrapStyleWord(true);
            this.noResultCheckBox = new JCheckBox("Update query (does not return a result set)");
            this.okButton = new JButton("OK");
            this.okButton.setFocusable(false);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    QueryEditDialog.this.doOK();
                }
            });
            JButton jButton = new JButton("Save");
            jButton.setFocusable(false);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    QueryEditDialog.this.doSave();
                }
            });
            JButton jButton2 = new JButton("Cancel");
            jButton2.setFocusable(false);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    QueryEditDialog.this.canceled = QueryEditDialog.this.cancel();
                }
            });
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createTitledBorder("Name"));
            jPanel.add(this.nameField);
            JPanel jPanel2 = new JPanel(new FlowLayout(2));
            jPanel2.add(jButton2);
            jPanel2.add(jButton);
            jPanel2.add(this.okButton);
            Box box = Box.createHorizontalBox();
            box.add(jPanel);
            box.add(jPanel2);
            JScrollPane jScrollPane = AppController.createScrollPane(this.descriptionArea);
            jScrollPane.setBorder(BorderFactory.createTitledBorder("Description"));
            JScrollPane jScrollPane2 = AppController.createScrollPane(this.scenarioModel.table);
            jScrollPane2.setBorder(BorderFactory.createTitledBorder("Scenarios"));
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel3.add((Component)box, "North");
            jPanel3.add((Component)jScrollPane, "Center");
            jPanel3.add((Component)jScrollPane2, "East");
            JScrollPane jScrollPane3 = AppController.createScrollPane(this.queryArea);
            jScrollPane3.setBorder(BorderFactory.createTitledBorder("Query"));
            JPanel jPanel4 = new JPanel(new FlowLayout(0));
            jPanel4.add(this.noResultCheckBox);
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel3, "North");
            this.add((Component)jScrollPane3, "Center");
            this.add((Component)jPanel4, "South");
            this.setResizable(true);
            this.setLocationSaved(true);
            this.pack();
            this.setMinimumSize(this.getSize());
        }

        private void setScenarios(ArrayList<KeyedRecord> arrayList) {
            this.scenarioModel.setScenarios(arrayList);
        }

        private void setQuery(int n) {
            this.setQuery(n, false);
        }

        private void setQuery(int n, boolean bl) {
            if (this.isVisible()) {
                return;
            }
            this.query = new SavedQuery();
            if (n <= 0) {
                this.query.name = "";
                if (n < 0) {
                    this.query.description = AnalyzeRunResult.this.runDescription;
                    this.query.query = bl ? AnalyzeRunResult.this.pointQuery : AnalyzeRunResult.this.runQuery;
                    this.query.noResult = AnalyzeRunResult.this.noResult;
                } else {
                    this.query.description = "";
                    this.query.query = "";
                }
            } else {
                SavedQuery savedQuery = (SavedQuery)AnalyzeRunResult.this.queryMap.get(n);
                if (null == savedQuery) {
                    this.query.name = "";
                    this.query.description = "";
                    this.query.query = "";
                } else {
                    this.query.key = savedQuery.key;
                    this.query.name = savedQuery.name;
                    this.query.description = savedQuery.description;
                    this.query.query = savedQuery.query;
                    this.query.noResult = savedQuery.noResult;
                }
            }
            this.okButton.setVisible(n <= 0);
            this.setDocumentName(this.query.name);
            this.nameField.setText(this.query.name);
            this.descriptionArea.setText(this.query.description);
            this.queryArea.setText(this.query.query);
            this.noResultCheckBox.setSelected(this.query.noResult);
        }

        private SavedQuery getQuery() {
            return this.query;
        }

        private void doOK() {
            if (null != this.query.key) {
                return;
            }
            this.query.query = this.queryArea.getText().trim();
            if (0 == this.query.query.length()) {
                this.errorReporter.reportWarning("Please provide the query");
                return;
            }
            this.query.noResult = this.noResultCheckBox.isSelected();
            this.query.key = -5;
            this.query.name = "(custom)";
            this.query.description = this.descriptionArea.getText();
            AppController.hideWindow(this);
            this.canceled = false;
        }

        private void doSave() {
            String string = "Save Query";
            this.errorReporter.setTitle(string);
            this.query.name = this.nameField.getText().trim();
            if (0 == this.query.name.length()) {
                this.errorReporter.reportWarning("Please provide a name");
                return;
            }
            if (this.query.name.length() > 40) {
                this.errorReporter.reportWarning("The name is too long");
                return;
            }
            if (this.query.name.equalsIgnoreCase(AnalyzeRunResult.NAME_COVERAGE) || this.query.name.equalsIgnoreCase(AnalyzeRunResult.NAME_COVERAGE_LOSS) || this.query.name.equalsIgnoreCase(AnalyzeRunResult.NAME_COVERAGE_GAIN) || this.query.name.equalsIgnoreCase(AnalyzeRunResult.NAME_COVERAGE_OVERLAP)) {
                this.errorReporter.reportWarning("The name cannot be used");
                return;
            }
            this.query.description = this.descriptionArea.getText();
            this.query.query = this.queryArea.getText().trim();
            if (0 == this.query.query.length()) {
                this.errorReporter.reportWarning("Please provide the query");
                return;
            }
            this.query.noResult = this.noResultCheckBox.isSelected();
            DbConnection dbConnection = DbCore.connectDb((String)((AnalyzeRunResult)AnalyzeRunResult.this).study.dbID, (ErrorLogger)this.errorReporter);
            if (null == dbConnection) {
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            try {
                String string2 = DbCore.getDbName((String)((AnalyzeRunResult)AnalyzeRunResult.this).study.dbID) + "_" + String.valueOf(((AnalyzeRunResult)AnalyzeRunResult.this).study.key) + ".saved_query";
                if (null == this.query.key) {
                    dbConnection.query("SELECT query_key FROM " + string2 + " WHERE UPPER(name) = '" + DbConnection.clean((String)this.query.name.toUpperCase()) + "'");
                    if (dbConnection.next()) {
                        bl = true;
                    } else {
                        dbConnection.query("SELECT MAX(query_key) FROM " + string2);
                        dbConnection.next();
                        this.query.key = dbConnection.getInt(1) + 1;
                        dbConnection.update("INSERT INTO " + string2 + " (query_key, name, description, query, no_result) VALUES (" + String.valueOf(this.query.key) + ", '" + DbConnection.clean((String)this.query.name) + "', '" + DbConnection.clean((String)this.query.description) + "', '" + DbConnection.clean((String)this.query.query) + "', " + String.valueOf(this.query.noResult) + ")");
                    }
                } else {
                    dbConnection.update("UPDATE " + string2 + " SET name = '" + DbConnection.clean((String)this.query.name) + "', description = '" + DbConnection.clean((String)this.query.description) + "', query = '" + DbConnection.clean((String)this.query.query) + "', no_result = " + String.valueOf(this.query.noResult) + " WHERE query_key = " + String.valueOf(this.query.key));
                }
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb((DbConnection)dbConnection);
                DbConnection.reportError((ErrorLogger)this.errorReporter, (SQLException)sQLException);
                return;
            }
            DbCore.releaseDb((DbConnection)dbConnection);
            if (bl) {
                this.errorReporter.reportWarning("The name is already in use");
                return;
            }
            AppController.hideWindow(this);
            this.canceled = false;
        }

        @Override
        public void windowWillOpen() {
            this.blockActionsClear();
        }

        @Override
        public void windowWillClose() {
            this.blockActionsSet();
            this.canceled = true;
        }

        private class ScenarioModel
        extends AbstractTableModel {
            private ArrayList<KeyedRecord> modelRows = new ArrayList();
            private JTable table = new JTable(this);

            private ScenarioModel() {
                AppController.configureTable(this.table);
                this.table.setRowSelectionAllowed(false);
                TableColumn tableColumn = this.table.getColumn(this.getColumnName(0));
                tableColumn.setMinWidth(AppController.textFieldWidth[2]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[3]);
                tableColumn = this.table.getColumn(this.getColumnName(1));
                tableColumn.setMinWidth(AppController.textFieldWidth[5]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[15]);
                this.table.setPreferredScrollableViewportSize(new Dimension(this.table.getPreferredSize().width, this.table.getRowHeight() * 5));
            }

            private void setScenarios(ArrayList<KeyedRecord> arrayList) {
                this.modelRows.clear();
                this.modelRows.addAll(arrayList);
                this.fireTableDataChanged();
            }

            private KeyedRecord get(int n) {
                return this.modelRows.get(n);
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int n) {
                switch (n) {
                    case 0: {
                        return "Key";
                    }
                    case 1: {
                        return "Name";
                    }
                }
                return "";
            }

            @Override
            public int getRowCount() {
                return this.modelRows.size();
            }

            @Override
            public Object getValueAt(int n, int n2) {
                KeyedRecord keyedRecord = this.modelRows.get(n);
                switch (n2) {
                    case 0: {
                        return String.valueOf(keyedRecord.key);
                    }
                    case 1: {
                        return keyedRecord.name;
                    }
                }
                return "";
            }
        }
    }

    private static class SavedQuery {
        Integer key;
        String name;
        String description;
        String query;
        boolean noResult;

        private SavedQuery() {
        }
    }

    private static class ScenarioResult {
        Integer key;
        String name;
        boolean hasTable;
        boolean hasResult;
        int resultCountry;
        double area;
        int population;
        int households;

        private ScenarioResult() {
        }
    }
}

