/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppPanel;
import gov.fcc.tvstudy.gui.editor.TableFilterModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class TableFilterPanel
extends AppPanel {
    public static final int MAX_FILTER_CHOICES = 30;
    private TableFilterModel tableModel;
    private int columnCount;
    private ColumnFilter[] columnFilters;
    private JButton clearButton;
    private JPanel layoutPanel;
    public int[] forwardIndex;
    public int[] reverseIndex;

    public TableFilterPanel(AppEditor appEditor, TableFilterModel tableFilterModel) {
        super(appEditor);
        this.tableModel = tableFilterModel;
        this.clearButton = new JButton("Clear");
        this.clearButton.setFocusable(false);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableFilterPanel.this.clearFilter();
                TableFilterPanel.this.tableModel.filterDidChange();
            }
        });
        this.layoutPanel = new JPanel();
        this.layoutPanel.setLayout(new BoxLayout(this.layoutPanel, 0));
        this.add(this.layoutPanel);
        this.columnsDidChange();
    }

    public void columnsDidChange() {
        this.columnCount = this.tableModel.getColumnCount();
        this.columnFilters = new ColumnFilter[this.columnCount];
        this.layoutPanel.removeAll();
        boolean bl = false;
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnFilter columnFilter;
            this.columnFilters[i] = columnFilter = new ColumnFilter();
            columnFilter.doFilter = this.tableModel.filterByColumn(i);
            if (!columnFilter.doFilter) continue;
            columnFilter.collapseChoices = this.tableModel.collapseFilterChoices(i);
            columnFilter.filterMenu = new JComboBox();
            columnFilter.filterMenu.setFocusable(false);
            columnFilter.allItem = "(all " + this.tableModel.getColumnName(i) + ")";
            columnFilter.filterMenu.addItem(columnFilter.allItem);
            this.layoutPanel.add(columnFilter.filterMenu);
            final int n = i;
            columnFilter.filterMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TableFilterPanel.this.blockActions()) {
                        TableFilterPanel.this.updateFilter(n);
                        TableFilterPanel.this.tableModel.filterDidChange();
                        TableFilterPanel.this.blockActionsEnd();
                    }
                }
            });
        }
        this.layoutPanel.add(this.clearButton);
        this.updateFilter();
    }

    public void updateFilter() {
        this.blockActionsStart();
        this.updateFilter(-1);
        this.blockActionsEnd();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateFilter(int n) {
        int n2;
        Object object;
        String string3;
        int n3;
        int n4;
        ColumnFilter columnFilter;
        if (n >= 0) {
            columnFilter = this.columnFilters[n];
            if (!columnFilter.doFilter) return;
            n4 = columnFilter.filterMenu.getSelectedIndex();
            if (columnFilter.isFiltered && 0 == n4) {
                columnFilter.isFiltered = false;
                columnFilter.filterMenuString = null;
                columnFilter.filterString = null;
                columnFilter.menuCollapsed = false;
                columnFilter.prefixLength = 0;
            } else {
                if ((columnFilter.isFiltered || n4 <= 0) && n4 <= 1) return;
                columnFilter.isFiltered = true;
                columnFilter.filterMenuString = (String)columnFilter.filterMenu.getSelectedItem();
                if (columnFilter.menuCollapsed) {
                    columnFilter.filterString = columnFilter.filterMenuString.substring(0, columnFilter.prefixLength);
                    columnFilter.prefixLength++;
                } else {
                    columnFilter.filterString = columnFilter.filterMenuString;
                }
            }
        }
        int n5 = this.tableModel.getUnfilteredRowCount();
        boolean bl = true;
        for (n4 = 0; n4 < this.columnCount; ++n4) {
            columnFilter = this.columnFilters[n4];
            if (columnFilter.doFilter && n5 > 0) {
                if (columnFilter.isFiltered) {
                    bl = false;
                }
                columnFilter.rowValues = new TreeSet();
                continue;
            }
            columnFilter.isFiltered = false;
            columnFilter.filterMenuString = null;
            columnFilter.filterString = null;
            columnFilter.menuCollapsed = false;
            columnFilter.prefixLength = 0;
        }
        if (bl) {
            this.forwardIndex = new int[n5];
            this.reverseIndex = new int[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                this.forwardIndex[n3] = n3;
                this.reverseIndex[n3] = n3;
                for (n4 = 0; n4 < this.columnCount; ++n4) {
                    columnFilter = this.columnFilters[n4];
                    if (!columnFilter.doFilter || null == (string3 = this.tableModel.getUnfilteredValueAt(n3, n4))) continue;
                    columnFilter.rowValues.add(string3);
                }
            }
        } else {
            object = new String[this.columnCount];
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n3 = 0; n3 < n5; ++n3) {
                boolean bl2 = true;
                for (n4 = 0; n4 < this.columnCount; ++n4) {
                    columnFilter = this.columnFilters[n4];
                    if (!columnFilter.doFilter) continue;
                    object[n4] = string3 = this.tableModel.getUnfilteredValueAt(n3, n4);
                    if (!columnFilter.isFiltered || null != string3 && 0 != string3.length() && (!columnFilter.menuCollapsed || string3.startsWith(columnFilter.filterString)) && (columnFilter.menuCollapsed || string3.equals(columnFilter.filterString))) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                arrayList.add(n3);
                for (n4 = 0; n4 < this.columnCount; ++n4) {
                    columnFilter = this.columnFilters[n4];
                    if (!columnFilter.doFilter || null == object[n4]) continue;
                    columnFilter.rowValues.add(object[n4]);
                }
            }
            this.reverseIndex = new int[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                this.reverseIndex[n3] = -1;
            }
            n5 = arrayList.size();
            this.forwardIndex = new int[n5];
            n3 = 0;
            while (n3 < n5) {
                this.forwardIndex[n3] = n2 = ((Integer)arrayList.get(n3)).intValue();
                this.reverseIndex[n2] = n3++;
            }
        }
        boolean bl3 = false;
        for (n4 = 0; n4 < this.columnCount; ++n4) {
            columnFilter = this.columnFilters[n4];
            if (!columnFilter.doFilter) continue;
            columnFilter.filterMenu.removeAllItems();
            columnFilter.filterMenu.addItem(columnFilter.allItem);
            if (!columnFilter.isFiltered) {
                columnFilter.menuCollapsed = false;
                columnFilter.prefixLength = 0;
            }
            if (null == (object = columnFilter.rowValues)) continue;
            if (columnFilter.menuCollapsed || object.size() > 30 && columnFilter.collapseChoices) {
                if (!columnFilter.menuCollapsed) {
                    columnFilter.menuCollapsed = true;
                    columnFilter.prefixLength = 1;
                }
                object = new ArrayList();
                while (true) {
                    int n6 = columnFilter.prefixLength;
                    String string2 = null;
                    boolean bl4 = false;
                    boolean bl5 = true;
                    for (String string3 : columnFilter.rowValues) {
                        n2 = string3.length();
                        if (n2 < n6) continue;
                        if (null == string2) {
                            string2 = string3.substring(0, n6);
                            bl4 = n2 > n6;
                            continue;
                        }
                        if (string3.startsWith(string2)) {
                            if (n2 <= n6) continue;
                            bl4 = true;
                            continue;
                        }
                        if (bl4) {
                            object.add(string2 + "...");
                            bl5 = false;
                        } else {
                            object.add(string2);
                        }
                        string2 = string3.substring(0, n6);
                        bl4 = n2 > n6;
                    }
                    if (null != string2) {
                        if (bl4) {
                            object.add(string2 + "...");
                            bl5 = false;
                        } else {
                            object.add(string2);
                        }
                    }
                    if (object.size() > 1 || bl5) break;
                    columnFilter.prefixLength++;
                    object.clear();
                }
            }
            if (columnFilter.isFiltered) {
                columnFilter.filterMenu.addItem(columnFilter.filterMenuString);
                if (columnFilter.menuCollapsed && object.size() <= 30) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        columnFilter.filterMenu.addItem(string4);
                    }
                }
                columnFilter.filterMenu.setSelectedIndex(1);
                bl3 = true;
            } else {
                if ((columnFilter.menuCollapsed || object.size() > 1) && object.size() <= 30) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string5 = (String)iterator.next();
                        if (string5.length() <= 0) continue;
                        columnFilter.filterMenu.addItem(string5);
                    }
                }
                columnFilter.filterMenu.setSelectedIndex(0);
            }
            columnFilter.rowValues = null;
        }
        this.clearButton.setEnabled(bl3);
    }

    public void clearFilter() {
        for (int i = 0; i < this.columnCount; ++i) {
            this.columnFilters[i].isFiltered = false;
            this.columnFilters[i].filterString = null;
            this.columnFilters[i].menuCollapsed = false;
            this.columnFilters[i].prefixLength = 0;
        }
        this.updateFilter();
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = false;
        for (ColumnFilter columnFilter : this.columnFilters) {
            if (!columnFilter.doFilter) continue;
            AppController.setComponentEnabled(columnFilter.filterMenu, bl);
            if (!columnFilter.isFiltered) continue;
            bl2 = bl;
        }
        this.clearButton.setEnabled(bl2);
    }

    @Override
    public void clearFields() {
        this.clearFilter();
    }

    private static class ColumnFilter {
        private boolean doFilter;
        private boolean collapseChoices;
        private JComboBox<String> filterMenu;
        private String allItem;
        private boolean isFiltered;
        private String filterMenuString;
        private String filterString;
        private boolean menuCollapsed;
        private int prefixLength;
        private TreeSet<String> rowValues;

        private ColumnFilter() {
        }
    }
}

