/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbListener;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.OutputConfig;
import gov.fcc.tvstudy.core.StudyBuildIxCheck;
import gov.fcc.tvstudy.core.data.ChannelBand;
import gov.fcc.tvstudy.core.data.ChannelDelta;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.ServiceType;
import gov.fcc.tvstudy.core.data.SignalType;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.data.Template;
import gov.fcc.tvstudy.core.editdata.IxRuleEditData;
import gov.fcc.tvstudy.core.editdata.ParameterEditData;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.core.editdata.TemplateEditData;
import gov.fcc.tvstudy.core.geo.Geography;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.BackgroundWorker;
import gov.fcc.tvstudy.gui.DbController;
import gov.fcc.tvstudy.gui.EditMenu;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import gov.fcc.tvstudy.gui.OptionsPanel;
import gov.fcc.tvstudy.gui.OutputConfigDialog;
import gov.fcc.tvstudy.gui.PickExtDbDialog;
import gov.fcc.tvstudy.gui.RecordFind;
import gov.fcc.tvstudy.gui.RootEditor;
import gov.fcc.tvstudy.gui.StudyLockHolder;
import gov.fcc.tvstudy.gui.StudyManager;
import gov.fcc.tvstudy.gui.TemplateManager;
import gov.fcc.tvstudy.gui.TextInputDialog;
import gov.fcc.tvstudy.gui.editor.IxRuleEditor;
import gov.fcc.tvstudy.gui.editor.ParameterEditor;
import gov.fcc.tvstudy.gui.editor.ScenarioEditor;
import gov.fcc.tvstudy.gui.editor.TableFilterModel;
import gov.fcc.tvstudy.gui.editor.TableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class StudyEditor
extends RootEditor
implements StudyLockHolder,
ExtDbListener {
    public static final String WINDOW_TITLE = "Study";
    private StudyEditData study;
    private int studyType;
    private JTextField studyNameField;
    private JTextArea studyDescriptionArea;
    private KeyedRecordMenu extDbMenu;
    private KeyedRecordMenu studyModeMenu;
    private KeyedRecordMenu pointSetMenu;
    private JButton editPointGeoButton;
    private boolean pointGeographyEditPending;
    private KeyedRecordMenu propagationModelMenu;
    private KeyedRecordMenu studyAreaModeMenu;
    private KeyedRecordMenu studyAreaGeographyMenu;
    private JButton editAreaGeoButton;
    private boolean areaGeographyEditPending;
    private JComboBox<OutputConfig> fileOutputConfigMenu;
    private JComboBox<OutputConfig> mapOutputConfigMenu;
    private Path outDirectoryPath;
    private JLabel outDirectoryLabel;
    private JButton resetOutDirectoryButton;
    private ScenarioTableModel scenarioModel;
    private JTable scenarioTable;
    private ArrayList<ParameterEditor> parameterEditors;
    private boolean hasNewParameters;
    private IxRuleTableModel ixRuleModel;
    private JTable ixRuleTable;
    private HashMap<Integer, IxRuleEditor> ixRuleEditors;
    private HashMap<Integer, ScenarioEditor> scenarioEditors;
    private RecordFind newScenarioFinder;
    private JButton saveButton;
    private JButton saveCloseButton;
    private JMenuItem saveMenuItem;
    private JButton editIxRuleButton;
    private JButton enableIxRuleButton;
    private JButton disableIxRuleButton;
    private JMenuItem editIxRuleMenuItem;
    private JMenuItem deleteIxRuleMenuItem;
    private JMenuItem enableIxRuleMenuItem;
    private JMenuItem disableIxRuleMenuItem;
    private JButton openScenarioButton;
    private JButton exportScenarioButton;
    private JMenuItem duplicateScenarioMenuItem;
    private JMenuItem openScenarioMenuItem;
    private JMenuItem deleteScenarioMenuItem;
    private JMenuItem exportScenarioMenuItem;
    private JMenuItem revertAllParametersMenuItem;
    private JPopupMenu ixRuleTablePopupMenu;
    private JMenuItem cmEditIxRuleMenuItem;
    private JMenuItem cmDeleteIxRuleMenuItem;
    private JMenuItem cmEnableIxRuleMenuItem;
    private JMenuItem cmDisableIxRuleMenuItem;
    private JPopupMenu scenarioTablePopupMenu;
    private JMenuItem cmOpenScenarioMenuItem;
    private JMenuItem cmDuplicateScenarioMenuItem;
    private JMenuItem cmDeleteScenarioMenuItem;
    private static final String STUDY_TAB_NAME = "Study";
    private static final String SCENARIOS_TAB_NAME = "Scenarios";
    private static final String PARAMETERS_TAB_NAME = "Parameters";
    private static final String RULES_TAB_NAME = "Rules";
    private JTabbedPane editorTabPane;
    private String lastSelectedTabName;
    private boolean didEdit;
    private boolean dataChanged;
    private boolean confirmSave = true;
    private StudyEditor outerThis = this;

    public StudyEditor(AppEditor appEditor, StudyEditData studyEditData) {
        super(appEditor, "Study");
        Object object2;
        this.study = studyEditData;
        this.studyType = this.study.study.studyType;
        this.setTitleKey(this.study.study.key);
        this.studyNameField = new JTextField(30);
        AppController.fixKeyBindings(this.studyNameField);
        this.studyNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StudyEditor.this.blockActions()) {
                    String string = StudyEditor.this.studyNameField.getText().trim();
                    if (string.length() > 0 && !((StudyEditor)StudyEditor.this).study.name.equals(string)) {
                        boolean bl = false;
                        if (((StudyEditor)StudyEditor.this).study.name.equalsIgnoreCase(string)) {
                            bl = true;
                        } else {
                            StudyEditor.this.errorReporter.setTitle("Change Study Name");
                            bl = DbCore.checkStudyName((String)string, (StudyEditData)StudyEditor.this.study, (boolean)true, (ErrorLogger)StudyEditor.this.errorReporter);
                        }
                        if (bl) {
                            ((StudyEditor)StudyEditor.this).study.name = string;
                            StudyEditor.this.setDidEdit();
                        }
                    }
                    StudyEditor.this.blockActionsEnd();
                }
                StudyEditor.this.studyNameField.setText(((StudyEditor)StudyEditor.this).study.name);
            }
        });
        this.studyNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                StudyEditor.this.setCurrentField(StudyEditor.this.studyNameField);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    StudyEditor.this.studyNameField.postActionEvent();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Study Name"));
        jPanel.add(this.studyNameField);
        this.studyNameField.setText(this.study.name);
        JButton jButton = new JButton("Study Description");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doEditDescription();
            }
        });
        this.extDbMenu = new KeyedRecordMenu();
        this.extDbMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXyXyXyXyXyXyXy"));
        this.extDbMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StudyEditor.this.blockActions()) {
                    int n = StudyEditor.this.extDbMenu.getSelectedKey();
                    if (0 == n) {
                        if (null != ((StudyEditor)StudyEditor.this).study.extDbKey) {
                            ((StudyEditor)StudyEditor.this).study.extDbKey = null;
                            StudyEditor.this.setDidEdit();
                        }
                    } else if (null == ((StudyEditor)StudyEditor.this).study.extDbKey || n != ((StudyEditor)StudyEditor.this).study.extDbKey) {
                        ((StudyEditor)StudyEditor.this).study.extDbKey = n;
                        StudyEditor.this.setDidEdit();
                    }
                    StudyEditor.this.blockActionsEnd();
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Default Station Data"));
        jPanel2.add(this.extDbMenu);
        JPanel jPanel3 = null;
        JPanel jPanel4 = null;
        JPanel jPanel5 = null;
        JPanel jPanel6 = null;
        if (2 == this.studyType || 5 == this.studyType) {
            this.study.studyMode = 1;
            this.study.pointSetKey = 0;
            this.study.studyAreaMode = 1;
            this.study.studyAreaGeoKey = 0;
        } else {
            this.studyModeMenu = new KeyedRecordMenu();
            this.studyModeMenu.addItem(new KeyedRecord(1, "Grid"));
            this.studyModeMenu.addItem(new KeyedRecord(2, "Points"));
            this.studyModeMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (StudyEditor.this.blockActions()) {
                        if (2 == StudyEditor.this.studyModeMenu.getSelectedKey()) {
                            if (2 != ((StudyEditor)StudyEditor.this).study.studyMode) {
                                ((StudyEditor)StudyEditor.this).study.studyMode = 2;
                                StudyEditor.this.setDidEdit();
                            }
                            AppController.setComponentEnabled(StudyEditor.this.pointSetMenu, true);
                            StudyEditor.this.editPointGeoButton.setEnabled(true);
                            AppController.setComponentEnabled(StudyEditor.this.studyAreaModeMenu, false);
                            AppController.setComponentEnabled(StudyEditor.this.studyAreaGeographyMenu, false);
                            StudyEditor.this.editAreaGeoButton.setEnabled(false);
                        } else {
                            if (1 != ((StudyEditor)StudyEditor.this).study.studyMode) {
                                ((StudyEditor)StudyEditor.this).study.studyMode = 1;
                                StudyEditor.this.setDidEdit();
                            }
                            AppController.setComponentEnabled(StudyEditor.this.pointSetMenu, false);
                            StudyEditor.this.editPointGeoButton.setEnabled(false);
                            AppController.setComponentEnabled(StudyEditor.this.studyAreaModeMenu, true);
                            if (2 == ((StudyEditor)StudyEditor.this).study.studyAreaMode) {
                                AppController.setComponentEnabled(StudyEditor.this.studyAreaGeographyMenu, true);
                                StudyEditor.this.editAreaGeoButton.setEnabled(true);
                            } else {
                                AppController.setComponentEnabled(StudyEditor.this.studyAreaGeographyMenu, false);
                                StudyEditor.this.editAreaGeoButton.setEnabled(false);
                            }
                        }
                        StudyEditor.this.blockActionsEnd();
                    }
                }
            });
            jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createTitledBorder("Study Mode"));
            jPanel3.add(this.studyModeMenu);
            this.studyModeMenu.setSelectedKey(this.study.studyMode);
            this.pointSetMenu = new KeyedRecordMenu();
            this.pointSetMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXyXyXyXy"));
            this.pointSetMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (StudyEditor.this.blockActions()) {
                        int n = StudyEditor.this.pointSetMenu.getSelectedKey();
                        if (n != ((StudyEditor)StudyEditor.this).study.pointSetKey) {
                            ((StudyEditor)StudyEditor.this).study.pointSetKey = n;
                            StudyEditor.this.setDidEdit();
                        }
                        StudyEditor.this.blockActionsEnd();
                    }
                }
            });
            this.editPointGeoButton = new JButton("Edit");
            this.editPointGeoButton.setFocusable(false);
            this.editPointGeoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.pointGeographyEditPending = StudyManager.showGeographyEditor(StudyEditor.this.getDbID(), ((StudyEditor)StudyEditor.this).study.study.key, ((StudyEditor)StudyEditor.this).study.name, 0, "", 3, ((StudyEditor)StudyEditor.this).study.pointSetKey);
                }
            });
            jPanel4 = new JPanel();
            jPanel4.setBorder(BorderFactory.createTitledBorder("Point Set"));
            jPanel4.add(this.pointSetMenu);
            jPanel4.add(this.editPointGeoButton);
            if (2 == this.study.studyMode) {
                AppController.setComponentEnabled(this.pointSetMenu, true);
                this.editPointGeoButton.setEnabled(true);
            } else {
                AppController.setComponentEnabled(this.pointSetMenu, false);
                this.editPointGeoButton.setEnabled(false);
            }
            this.studyAreaModeMenu = new KeyedRecordMenu();
            this.studyAreaModeMenu.addItem(new KeyedRecord(1, "Individual service areas"));
            this.studyAreaModeMenu.addItem(new KeyedRecord(2, "Fixed geography"));
            this.studyAreaModeMenu.addItem(new KeyedRecord(3, "Unrestricted"));
            this.studyAreaModeMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (StudyEditor.this.blockActions()) {
                        int n = StudyEditor.this.studyAreaModeMenu.getSelectedKey();
                        if (n != ((StudyEditor)StudyEditor.this).study.studyAreaMode) {
                            ((StudyEditor)StudyEditor.this).study.studyAreaMode = n;
                            StudyEditor.this.setDidEdit();
                        }
                        if (2 == n) {
                            AppController.setComponentEnabled(StudyEditor.this.studyAreaGeographyMenu, true);
                            StudyEditor.this.editAreaGeoButton.setEnabled(true);
                        } else {
                            AppController.setComponentEnabled(StudyEditor.this.studyAreaGeographyMenu, false);
                            StudyEditor.this.editAreaGeoButton.setEnabled(false);
                        }
                        StudyEditor.this.blockActionsEnd();
                    }
                }
            });
            jPanel5 = new JPanel(new FlowLayout(0));
            jPanel5.setBorder(BorderFactory.createTitledBorder("Study Area Mode"));
            jPanel5.add(this.studyAreaModeMenu);
            this.studyAreaModeMenu.setSelectedKey(this.study.studyAreaMode);
            AppController.setComponentEnabled(this.studyAreaModeMenu, 1 == this.study.studyMode);
            this.studyAreaGeographyMenu = new KeyedRecordMenu();
            this.studyAreaGeographyMenu.setPrototypeDisplayValue(new KeyedRecord(0, "XyXyXyXyXyXyXyXyXyXyXyXy"));
            this.studyAreaGeographyMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (StudyEditor.this.blockActions()) {
                        int n = StudyEditor.this.studyAreaGeographyMenu.getSelectedKey();
                        if (n != ((StudyEditor)StudyEditor.this).study.studyAreaGeoKey) {
                            ((StudyEditor)StudyEditor.this).study.studyAreaGeoKey = n;
                            StudyEditor.this.setDidEdit();
                        }
                        StudyEditor.this.blockActionsEnd();
                    }
                }
            });
            this.editAreaGeoButton = new JButton("Edit");
            this.editAreaGeoButton.setFocusable(false);
            this.editAreaGeoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.areaGeographyEditPending = StudyManager.showGeographyEditor(StudyEditor.this.getDbID(), ((StudyEditor)StudyEditor.this).study.study.key, ((StudyEditor)StudyEditor.this).study.name, 0, "", 2, ((StudyEditor)StudyEditor.this).study.studyAreaGeoKey);
                }
            });
            jPanel6 = new JPanel(new FlowLayout(0));
            jPanel6.setBorder(BorderFactory.createTitledBorder("Area Geography"));
            jPanel6.add(this.studyAreaGeographyMenu);
            jPanel6.add(this.editAreaGeoButton);
            if (1 == this.study.studyMode && 2 == this.study.studyAreaMode) {
                AppController.setComponentEnabled(this.studyAreaGeographyMenu, true);
                this.editAreaGeoButton.setEnabled(true);
            } else {
                AppController.setComponentEnabled(this.studyAreaGeographyMenu, false);
                this.editAreaGeoButton.setEnabled(false);
            }
        }
        this.propagationModelMenu = new KeyedRecordMenu(AppCore.propagationModels);
        this.propagationModelMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StudyEditor.this.blockActions()) {
                    int n = StudyEditor.this.propagationModelMenu.getSelectedKey();
                    if (n != ((StudyEditor)StudyEditor.this).study.propagationModel) {
                        ((StudyEditor)StudyEditor.this).study.propagationModel = n;
                        StudyEditor.this.setDidEdit();
                    }
                    StudyEditor.this.blockActionsEnd();
                }
            }
        });
        this.propagationModelMenu.setSelectedItem(new KeyedRecord(this.study.propagationModel, "(unknown)"));
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(BorderFactory.createTitledBorder("Propagation Model"));
        jPanel7.add(this.propagationModelMenu);
        this.fileOutputConfigMenu = new JComboBox();
        this.fileOutputConfigMenu.setFocusable(false);
        OutputConfig outputConfig = new OutputConfig(1, "");
        outputConfig.name = "XyXyXyXyXyXyXyXyXy";
        this.fileOutputConfigMenu.setPrototypeDisplayValue(outputConfig);
        this.fileOutputConfigMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StudyEditor.this.blockActions()) {
                    OutputConfig outputConfig = (OutputConfig)StudyEditor.this.fileOutputConfigMenu.getSelectedItem();
                    if (!outputConfig.name.equals(((StudyEditor)StudyEditor.this).study.fileOutputConfig.name) || !outputConfig.matchesConfig(((StudyEditor)StudyEditor.this).study.fileOutputConfig)) {
                        ((StudyEditor)StudyEditor.this).study.fileOutputConfig = outputConfig;
                        StudyEditor.this.setDidEdit();
                    }
                    StudyEditor.this.blockActionsEnd();
                }
            }
        });
        this.mapOutputConfigMenu = new JComboBox();
        this.mapOutputConfigMenu.setFocusable(false);
        outputConfig = new OutputConfig(2, "");
        outputConfig.name = "XyXyXyXyXyXyXyXyXy";
        this.mapOutputConfigMenu.setPrototypeDisplayValue(outputConfig);
        this.mapOutputConfigMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StudyEditor.this.blockActions()) {
                    OutputConfig outputConfig = (OutputConfig)StudyEditor.this.mapOutputConfigMenu.getSelectedItem();
                    if (!outputConfig.name.equals(((StudyEditor)StudyEditor.this).study.mapOutputConfig.name) || !outputConfig.matchesConfig(((StudyEditor)StudyEditor.this).study.mapOutputConfig)) {
                        ((StudyEditor)StudyEditor.this).study.mapOutputConfig = outputConfig;
                        StudyEditor.this.setDidEdit();
                    }
                    StudyEditor.this.blockActionsEnd();
                }
            }
        });
        JButton jButton2 = new JButton("Edit");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doEditOutputConfigs();
            }
        });
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(BorderFactory.createTitledBorder("Default Output Settings"));
        jPanel8.add(new JLabel("File:"));
        jPanel8.add(this.fileOutputConfigMenu);
        jPanel8.add(new JLabel("Map:"));
        jPanel8.add(this.mapOutputConfigMenu);
        jPanel8.add(jButton2);
        this.outDirectoryLabel = new JLabel("XyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXyXy");
        JButton jButton3 = new JButton("Change");
        jButton3.setFocusable(false);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doChangeOutDirectory();
            }
        });
        this.resetOutDirectoryButton = new JButton("Reset");
        this.resetOutDirectoryButton.setFocusable(false);
        this.resetOutDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.outDirectoryPath = AppCore.outDirectoryPath;
                ((StudyEditor)StudyEditor.this).study.outDirectory = AppCore.studyOutDirectory;
                StudyEditor.this.setDidEdit();
                StudyEditor.this.updateOutDirectory();
            }
        });
        JPanel jPanel9 = new JPanel(new FlowLayout(0));
        jPanel9.add(this.outDirectoryLabel);
        JPanel jPanel10 = new JPanel(new FlowLayout(0));
        jPanel10.add(jButton3);
        jPanel10.add(this.resetOutDirectoryButton);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 1));
        jPanel11.setBorder(BorderFactory.createTitledBorder("Output Directory"));
        jPanel11.add(jPanel9);
        jPanel11.add(jPanel10);
        this.outDirectoryPath = Paths.get(this.study.outDirectory, new String[0]);
        if (!this.outDirectoryPath.isAbsolute()) {
            this.outDirectoryPath = AppCore.workingDirectoryPath.resolve(this.study.outDirectory);
        }
        this.parameterEditors = new ArrayList();
        JComponent jComponent = ParameterEditor.createEditorLayout(this, this.errorReporter, this.study.parameters, this.parameterEditors);
        for (Object object2 : this.study.parameters) {
            if (!((ParameterEditData)object2).parameter.defaultsApplied) continue;
            this.hasNewParameters = true;
        }
        JPanel jPanel12 = new JPanel(new BorderLayout());
        if (this.hasNewParameters) {
            jPanel12.setBorder(BorderFactory.createTitledBorder("Study Parameters (new in red)"));
        } else {
            jPanel12.setBorder(BorderFactory.createTitledBorder("Study Parameters"));
        }
        jPanel12.add((Component)jComponent, "Center");
        this.ixRuleModel = new IxRuleTableModel();
        this.ixRuleTable = this.ixRuleModel.createTable(this.editMenu);
        this.ixRuleTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 == mouseEvent.getClickCount()) {
                    StudyEditor.this.doOpenIxRule();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StudyEditor.this.ixRuleTablePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StudyEditor.this.ixRuleTablePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.ixRuleTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StudyEditor.this.updateRuleControls();
            }
        });
        object2 = new JPanel(new BorderLayout());
        ((JComponent)object2).setBorder(BorderFactory.createTitledBorder("Interference Rules"));
        ((Container)object2).add((Component)AppController.createScrollPane(this.ixRuleTable), "Center");
        ((Container)object2).add((Component)this.ixRuleModel.filterPanel, "South");
        this.ixRuleEditors = new HashMap();
        this.scenarioModel = new ScenarioTableModel();
        this.scenarioTable = this.scenarioModel.createTable(this.editMenu);
        this.scenarioTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 == mouseEvent.getClickCount()) {
                    StudyEditor.this.doOpenScenario();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StudyEditor.this.scenarioTablePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    StudyEditor.this.scenarioTablePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.scenarioTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                StudyEditor.this.updateScenarioControls();
            }
        });
        JPanel jPanel13 = new JPanel(new BorderLayout());
        jPanel13.setBorder(BorderFactory.createTitledBorder(SCENARIOS_TAB_NAME));
        jPanel13.add((Component)AppController.createScrollPane(this.scenarioTable), "Center");
        this.scenarioEditors = new HashMap();
        this.saveButton = new JButton("Save");
        this.saveButton.setFocusable(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.saveIfNeeded("Save Study", false);
            }
        });
        this.saveMenuItem = new JMenuItem("Save Study");
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, AppController.MENU_SHORTCUT_KEY_MASK));
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.saveIfNeeded("Save Study", false);
            }
        });
        this.saveCloseButton = new JButton("Close");
        this.saveCloseButton.setFocusable(false);
        this.saveCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.confirmSave = !StudyEditor.this.didEdit;
                if (StudyEditor.this.windowShouldClose()) {
                    AppController.hideWindow(StudyEditor.this.outerThis);
                }
            }
        });
        JButton jButton4 = new JButton("New");
        jButton4.setFocusable(false);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doNewIxRule();
            }
        });
        this.editIxRuleButton = !this.study.study.templateLocked ? new JButton("Edit") : new JButton("View");
        this.editIxRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doOpenIxRule();
            }
        });
        this.enableIxRuleButton = new JButton("Enable");
        this.enableIxRuleButton.setFocusable(false);
        this.enableIxRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doSetIxRuleActive(true);
            }
        });
        this.disableIxRuleButton = new JButton("Disable");
        this.disableIxRuleButton.setFocusable(false);
        this.disableIxRuleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doSetIxRuleActive(false);
            }
        });
        JButton jButton5 = new JButton("New");
        jButton5.setFocusable(false);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doNewScenario();
            }
        });
        JButton jButton6 = new JButton("Import");
        jButton6.setFocusable(false);
        jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doImportScenarios();
            }
        });
        this.exportScenarioButton = new JButton("Export");
        this.exportScenarioButton.setFocusable(false);
        this.exportScenarioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doExportScenarios();
            }
        });
        this.openScenarioButton = new JButton("Open");
        this.openScenarioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doOpenScenario();
            }
        });
        Box box = Box.createVerticalBox();
        JPanel jPanel14 = new JPanel(new FlowLayout(0));
        jPanel14.add(jPanel);
        jPanel14.add(jButton);
        box.add(jPanel14);
        jPanel14 = new JPanel(new FlowLayout(0));
        jPanel14.add(jPanel2);
        box.add(jPanel14);
        if (null != jPanel3) {
            jPanel14 = new JPanel(new FlowLayout(0));
            jPanel14.add(jPanel3);
            jPanel14.add(jPanel4);
            box.add(jPanel14);
        }
        if (null != jPanel5) {
            jPanel14 = new JPanel(new FlowLayout(0));
            jPanel14.add(jPanel5);
            jPanel14.add(jPanel6);
            box.add(jPanel14);
        }
        jPanel14 = new JPanel(new FlowLayout(0));
        jPanel14.add(jPanel7);
        box.add(jPanel14);
        jPanel14 = new JPanel(new FlowLayout(0));
        jPanel14.add(jPanel8);
        box.add(jPanel14);
        jPanel14 = new JPanel(new FlowLayout(0));
        jPanel14.add(jPanel11);
        box.add(jPanel14);
        JPanel jPanel15 = new JPanel(new FlowLayout(0));
        jPanel15.add(box);
        JPanel jPanel16 = new JPanel(new FlowLayout(0));
        jPanel16.add(jButton4);
        JPanel jPanel17 = new JPanel(new FlowLayout(2));
        jPanel17.add(this.enableIxRuleButton);
        jPanel17.add(this.disableIxRuleButton);
        jPanel17.add(this.editIxRuleButton);
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new BoxLayout(jPanel18, 0));
        jPanel18.add(jPanel16);
        jPanel18.add(jPanel17);
        JPanel jPanel19 = new JPanel(new BorderLayout());
        jPanel19.add((Component)object2, "Center");
        jPanel19.add((Component)jPanel18, "South");
        JPanel jPanel20 = new JPanel(new FlowLayout(0));
        jPanel20.add(jButton5);
        jPanel20.add(jButton6);
        jPanel20.add(this.exportScenarioButton);
        JPanel jPanel21 = new JPanel(new FlowLayout(2));
        jPanel21.add(this.openScenarioButton);
        JPanel jPanel22 = new JPanel();
        jPanel22.setLayout(new BoxLayout(jPanel22, 0));
        jPanel22.add(jPanel20);
        jPanel22.add(jPanel21);
        JPanel jPanel23 = new JPanel(new BorderLayout());
        jPanel23.add((Component)jPanel13, "Center");
        jPanel23.add((Component)jPanel22, "South");
        this.editorTabPane = new JTabbedPane();
        this.editorTabPane.addTab("Study", jPanel15);
        this.editorTabPane.addTab(SCENARIOS_TAB_NAME, jPanel23);
        this.editorTabPane.addTab(PARAMETERS_TAB_NAME, jPanel12);
        this.editorTabPane.addTab(RULES_TAB_NAME, jPanel19);
        this.editorTabPane.setSelectedIndex(1);
        this.editorTabPane.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                StudyEditor.this.updateFileMenu();
            }
        });
        JPanel jPanel24 = new JPanel(new FlowLayout(2));
        jPanel24.add(this.saveButton);
        jPanel24.add(this.saveCloseButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.editorTabPane, "Center");
        container.add((Component)jPanel24, "South");
        this.pack();
        Dimension dimension = new Dimension(980, 650);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.ixRuleTablePopupMenu = new JPopupMenu();
        this.cmEditIxRuleMenuItem = !this.study.study.templateLocked ? new JMenuItem("Edit") : new JMenuItem("View");
        this.cmEditIxRuleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doOpenIxRule();
            }
        });
        this.ixRuleTablePopupMenu.add(this.cmEditIxRuleMenuItem);
        this.cmDeleteIxRuleMenuItem = new JMenuItem("Delete");
        if (!this.study.study.templateLocked) {
            this.cmDeleteIxRuleMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doDeleteIxRule();
                }
            });
        } else {
            this.cmDeleteIxRuleMenuItem.setEnabled(false);
        }
        this.ixRuleTablePopupMenu.add(this.cmDeleteIxRuleMenuItem);
        this.cmEnableIxRuleMenuItem = new JMenuItem("Enable");
        this.cmEnableIxRuleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doSetIxRuleActive(true);
            }
        });
        this.ixRuleTablePopupMenu.add(this.cmEnableIxRuleMenuItem);
        this.cmDisableIxRuleMenuItem = new JMenuItem("Disable");
        this.cmDisableIxRuleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doSetIxRuleActive(false);
            }
        });
        this.ixRuleTablePopupMenu.add(this.cmDisableIxRuleMenuItem);
        this.scenarioTablePopupMenu = new JPopupMenu();
        this.cmOpenScenarioMenuItem = new JMenuItem("Open");
        this.cmOpenScenarioMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doOpenScenario();
            }
        });
        this.scenarioTablePopupMenu.add(this.cmOpenScenarioMenuItem);
        this.cmDuplicateScenarioMenuItem = new JMenuItem("Duplicate...");
        this.cmDuplicateScenarioMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doDuplicateScenario();
            }
        });
        this.scenarioTablePopupMenu.add(this.cmDuplicateScenarioMenuItem);
        this.cmDeleteScenarioMenuItem = new JMenuItem("Delete");
        this.cmDeleteScenarioMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doDeleteScenarios();
            }
        });
        this.scenarioTablePopupMenu.add(this.cmDeleteScenarioMenuItem);
        this.updateOutDirectory();
        this.updateFileMenu();
        this.updateDocumentName();
        this.updateGeographies(0, 0);
        this.updateOutputConfigMenus();
        if (this.study.isDataChanged()) {
            this.setDidEdit();
        } else {
            this.clearDidEdit();
        }
    }

    private void updateFileMenu() {
        String string = this.editorTabPane.getTitleAt(this.editorTabPane.getSelectedIndex());
        if (string.equals(this.lastSelectedTabName)) {
            return;
        }
        this.lastSelectedTabName = string;
        this.fileMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Save New Template...");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StudyEditor.this.doSaveNewTemplate();
            }
        });
        if (string.equals("Study")) {
            this.getRootPane().setDefaultButton(null);
            this.fileMenu.setText("Study");
            JMenuItem jMenuItem2 = new JMenuItem("Geography Editor");
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyManager.showGeographyEditor(StudyEditor.this.getDbID(), ((StudyEditor)StudyEditor.this).study.study.key, ((StudyEditor)StudyEditor.this).study.name, 0, "", 1, 0);
                }
            });
            this.fileMenu.add(jMenuItem2);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.saveMenuItem);
            return;
        }
        if (string.equals(PARAMETERS_TAB_NAME)) {
            this.getRootPane().setDefaultButton(null);
            this.fileMenu.setText("Parameter");
            this.revertAllParametersMenuItem = new JMenuItem("Revert All Parameters");
            if (this.study.study.templateLocked) {
                this.revertAllParametersMenuItem.setEnabled(false);
            } else {
                this.revertAllParametersMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doRevertAllParameters();
                    }
                });
            }
            this.fileMenu.add(this.revertAllParametersMenuItem);
            this.fileMenu.addSeparator();
            this.fileMenu.add(jMenuItem);
            this.fileMenu.add(this.saveMenuItem);
            return;
        }
        if (string.equals(RULES_TAB_NAME)) {
            this.getRootPane().setDefaultButton(this.editIxRuleButton);
            this.fileMenu.setText("Rule");
            JMenuItem jMenuItem3 = new JMenuItem("Previous");
            jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(38, AppController.MENU_SHORTCUT_KEY_MASK));
            jMenuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doPreviousRule();
                }
            });
            this.fileMenu.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("Next");
            jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(40, AppController.MENU_SHORTCUT_KEY_MASK));
            jMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doNextRule();
                }
            });
            this.fileMenu.add(jMenuItem4);
            this.fileMenu.addSeparator();
            JMenuItem jMenuItem5 = new JMenuItem("New...");
            jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(78, AppController.MENU_SHORTCUT_KEY_MASK));
            if (!this.study.study.templateLocked) {
                jMenuItem5.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doNewIxRule();
                    }
                });
            } else {
                jMenuItem5.setEnabled(false);
            }
            this.fileMenu.add(jMenuItem5);
            this.fileMenu.addSeparator();
            this.editIxRuleMenuItem = !this.study.study.templateLocked ? new JMenuItem("Edit") : new JMenuItem("View");
            this.editIxRuleMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppController.MENU_SHORTCUT_KEY_MASK));
            this.editIxRuleMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doOpenIxRule();
                }
            });
            this.fileMenu.add(this.editIxRuleMenuItem);
            this.deleteIxRuleMenuItem = new JMenuItem("Delete");
            if (!this.study.study.templateLocked) {
                this.deleteIxRuleMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StudyEditor.this.doDeleteIxRule();
                    }
                });
            } else {
                this.deleteIxRuleMenuItem.setEnabled(false);
            }
            this.fileMenu.add(this.deleteIxRuleMenuItem);
            this.fileMenu.addSeparator();
            this.enableIxRuleMenuItem = new JMenuItem("Enable");
            this.enableIxRuleMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, AppController.MENU_SHORTCUT_KEY_MASK));
            this.enableIxRuleMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doSetIxRuleActive(true);
                }
            });
            this.fileMenu.add(this.enableIxRuleMenuItem);
            this.disableIxRuleMenuItem = new JMenuItem("Disable");
            this.disableIxRuleMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, AppController.MENU_SHORTCUT_KEY_MASK));
            this.disableIxRuleMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doSetIxRuleActive(false);
                }
            });
            this.fileMenu.add(this.disableIxRuleMenuItem);
            JMenuItem jMenuItem6 = new JMenuItem("Enable/Disable by Type...");
            jMenuItem6.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doEnableDisableRules();
                }
            });
            this.fileMenu.add(jMenuItem6);
            this.fileMenu.addSeparator();
            this.fileMenu.add(jMenuItem);
            this.fileMenu.add(this.saveMenuItem);
            this.updateRuleControls();
            return;
        }
        if (string.equals(SCENARIOS_TAB_NAME)) {
            this.getRootPane().setDefaultButton(this.openScenarioButton);
            this.fileMenu.setText("Scenario");
            JMenuItem jMenuItem7 = new JMenuItem("Previous");
            jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(38, AppController.MENU_SHORTCUT_KEY_MASK));
            jMenuItem7.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doPreviousScenario();
                }
            });
            this.fileMenu.add(jMenuItem7);
            JMenuItem jMenuItem8 = new JMenuItem("Next");
            jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(40, AppController.MENU_SHORTCUT_KEY_MASK));
            jMenuItem8.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doNextScenario();
                }
            });
            this.fileMenu.add(jMenuItem8);
            this.fileMenu.addSeparator();
            JMenuItem jMenuItem9 = new JMenuItem("New...");
            jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(78, AppController.MENU_SHORTCUT_KEY_MASK));
            jMenuItem9.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doNewScenario();
                }
            });
            this.fileMenu.add(jMenuItem9);
            this.duplicateScenarioMenuItem = new JMenuItem("Duplicate...");
            this.duplicateScenarioMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doDuplicateScenario();
                }
            });
            this.fileMenu.add(this.duplicateScenarioMenuItem);
            this.fileMenu.addSeparator();
            JMenuItem jMenuItem10 = new JMenuItem("Import...");
            jMenuItem10.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doImportScenarios();
                }
            });
            this.fileMenu.add(jMenuItem10);
            this.exportScenarioMenuItem = new JMenuItem("Export...");
            this.exportScenarioMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doExportScenarios();
                }
            });
            this.fileMenu.add(this.exportScenarioMenuItem);
            this.fileMenu.addSeparator();
            this.openScenarioMenuItem = new JMenuItem("Open");
            this.openScenarioMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppController.MENU_SHORTCUT_KEY_MASK));
            this.openScenarioMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doOpenScenario();
                }
            });
            this.fileMenu.add(this.openScenarioMenuItem);
            this.deleteScenarioMenuItem = new JMenuItem("Delete");
            this.deleteScenarioMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doDeleteScenarios();
                }
            });
            this.fileMenu.add(this.deleteScenarioMenuItem);
            this.fileMenu.addSeparator();
            JMenuItem jMenuItem11 = new JMenuItem("Delete Unused Records");
            jMenuItem11.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyEditor.this.doDeleteUnusedSources();
                }
            });
            this.fileMenu.add(jMenuItem11);
            this.fileMenu.addSeparator();
            JMenuItem jMenuItem12 = new JMenuItem("Geography Editor");
            jMenuItem12.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StudyManager.showGeographyEditor(StudyEditor.this.getDbID(), ((StudyEditor)StudyEditor.this).study.study.key, ((StudyEditor)StudyEditor.this).study.name, 0, "", 1, 0);
                }
            });
            this.fileMenu.add(jMenuItem12);
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.saveMenuItem);
            this.updateScenarioControls();
            return;
        }
    }

    private void updateRuleControls() {
        int n = this.ixRuleTable.getSelectedRowCount();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (1 == n) {
            bl = true;
            bl2 = !this.study.study.templateLocked;
            IxRuleEditData ixRuleEditData = this.ixRuleModel.get(this.ixRuleTable.convertRowIndexToModel(this.ixRuleTable.getSelectedRow()));
            if (ixRuleEditData.isActive) {
                bl4 = true;
            } else {
                bl3 = true;
            }
        } else if (n > 1) {
            bl2 = !this.study.study.templateLocked;
            int[] nArray = this.ixRuleTable.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                IxRuleEditData ixRuleEditData = this.ixRuleModel.get(this.ixRuleTable.convertRowIndexToModel(nArray[i]));
                if (ixRuleEditData.isActive) {
                    bl4 = true;
                    if (!bl3) continue;
                    break;
                }
                bl3 = true;
                if (bl4) break;
            }
        }
        this.editIxRuleButton.setEnabled(bl);
        this.editIxRuleMenuItem.setEnabled(bl);
        this.cmEditIxRuleMenuItem.setEnabled(bl);
        this.deleteIxRuleMenuItem.setEnabled(bl2);
        this.cmDeleteIxRuleMenuItem.setEnabled(bl2);
        this.enableIxRuleButton.setEnabled(bl3);
        this.enableIxRuleMenuItem.setEnabled(bl3);
        this.cmEnableIxRuleMenuItem.setEnabled(bl3);
        this.disableIxRuleButton.setEnabled(bl4);
        this.disableIxRuleMenuItem.setEnabled(bl4);
        this.cmDisableIxRuleMenuItem.setEnabled(bl4);
    }

    private void updateScenarioControls() {
        int n = this.scenarioTable.getSelectedRowCount();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (1 == n) {
            ScenarioEditData scenarioEditData = this.study.scenarioData.get(this.scenarioTable.convertRowIndexToModel(this.scenarioTable.getSelectedRow()));
            bl = true;
            bl2 = !scenarioEditData.isPermanent;
            bl3 = true;
            bl4 = true;
            if (2 == this.studyType && 1 != scenarioEditData.scenarioType) {
                bl3 = false;
                if (2 == scenarioEditData.scenarioType) {
                    bl2 = false;
                }
            }
        } else if (n > 1) {
            bl2 = true;
            bl4 = true;
        }
        this.openScenarioButton.setEnabled(bl);
        this.openScenarioMenuItem.setEnabled(bl);
        this.cmOpenScenarioMenuItem.setEnabled(bl);
        this.deleteScenarioMenuItem.setEnabled(bl2);
        this.cmDeleteScenarioMenuItem.setEnabled(bl2);
        this.duplicateScenarioMenuItem.setEnabled(bl3);
        this.cmDuplicateScenarioMenuItem.setEnabled(bl3);
        this.exportScenarioButton.setEnabled(bl4);
        this.exportScenarioMenuItem.setEnabled(bl4);
    }

    @Override
    public void setDidEdit() {
        if (!this.didEdit) {
            this.didEdit = true;
            this.saveButton.setEnabled(true);
            this.saveCloseButton.setText("Save & Close");
            this.saveMenuItem.setEnabled(true);
        }
    }

    private void clearDidEdit() {
        this.didEdit = false;
        this.saveButton.setEnabled(false);
        this.saveCloseButton.setText("Close");
        this.saveMenuItem.setEnabled(false);
    }

    public boolean isGeographyInUse(int n) {
        return this.study.isGeographyInUse(n);
    }

    public void geographyChanged(int n, int n2, Integer n3, int n4) {
        int n5 = 0;
        if (this.pointGeographyEditPending && null != n3) {
            if (1 == n4 && n == this.study.study.key && 0 == n2) {
                n5 = n3;
            }
            this.pointGeographyEditPending = false;
        }
        int n6 = 0;
        if (this.areaGeographyEditPending && null != n3) {
            if (1 != n4 && n == this.study.study.key && 0 == n2) {
                n6 = n3;
            }
            this.areaGeographyEditPending = false;
        }
        this.updateGeographies(n5, n6);
        for (ScenarioEditor scenarioEditor : this.scenarioEditors.values()) {
            scenarioEditor.geographyChanged(n, n2, n3, n4);
        }
    }

    public void geographyScopeChanged(int n, int n2) {
        if (n != this.study.study.key || n2 != 0) {
            this.pointGeographyEditPending = false;
            this.areaGeographyEditPending = false;
        }
        for (ScenarioEditor scenarioEditor : this.scenarioEditors.values()) {
            scenarioEditor.geographyScopeChanged(n, n2);
        }
    }

    private void updateGeographies(int n, int n2) {
        ArrayList arrayList;
        this.blockActionsStart();
        if (null != this.pointSetMenu) {
            this.pointSetMenu.removeAllItems();
            arrayList = Geography.getGeographyList((String)this.getDbID(), (int)this.study.study.key, (int)0, (int)3);
            if (null != arrayList) {
                this.pointSetMenu.addAllItems(arrayList);
                if (n > 0 && n != this.study.pointSetKey) {
                    this.study.pointSetKey = n;
                    this.setDidEdit();
                }
                if (this.study.pointSetKey > 0 && this.pointSetMenu.containsKey(this.study.pointSetKey)) {
                    this.pointSetMenu.setSelectedKey(this.study.pointSetKey);
                } else {
                    this.study.pointSetKey = this.pointSetMenu.getSelectedKey();
                    if (2 == this.study.studyMode) {
                        this.setDidEdit();
                    }
                }
            }
        }
        if (null != this.studyAreaGeographyMenu) {
            this.studyAreaGeographyMenu.removeAllItems();
            arrayList = Geography.getGeographyList((String)this.getDbID(), (int)this.study.study.key, (int)0, (int)2);
            if (null != arrayList) {
                this.studyAreaGeographyMenu.addAllItems(arrayList);
                if (n2 > 0 && n2 != this.study.studyAreaGeoKey) {
                    this.study.studyAreaGeoKey = n2;
                    this.setDidEdit();
                }
                if (this.study.studyAreaGeoKey > 0 && this.studyAreaGeographyMenu.containsKey(this.study.studyAreaGeoKey)) {
                    this.studyAreaGeographyMenu.setSelectedKey(this.study.studyAreaGeoKey);
                } else {
                    this.study.studyAreaGeoKey = this.studyAreaGeographyMenu.getSelectedKey();
                    if (2 == this.study.studyAreaMode) {
                        this.setDidEdit();
                    }
                }
            }
        }
        this.blockActionsEnd();
    }

    public void updateExtDbList() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList = ExtDb.getExtDbList((String)StudyEditor.this.getDbID(), (int)Study.getDefaultRecordType((int)StudyEditor.this.studyType), (boolean)true, (boolean)false);
                if (null == arrayList) {
                    return;
                }
                StudyEditor.this.blockActionsStart();
                StudyEditor.this.extDbMenu.removeAllItems();
                if (!arrayList.isEmpty()) {
                    StudyEditor.this.extDbMenu.addAllItems(arrayList);
                }
                StudyEditor.this.extDbMenu.addItem(new KeyedRecord(0, "(none)"));
                int n = 0;
                if (null != ((StudyEditor)StudyEditor.this).study.extDbKey) {
                    n = ((StudyEditor)StudyEditor.this).study.extDbKey;
                    if (!StudyEditor.this.extDbMenu.containsKey(n)) {
                        StudyEditor.this.extDbMenu.addItem(new KeyedRecord(n, ExtDb.getExtDbDescription((String)StudyEditor.this.getDbID(), (Integer)((StudyEditor)StudyEditor.this).study.extDbKey)));
                    }
                }
                StudyEditor.this.extDbMenu.setSelectedKey(n);
                StudyEditor.this.blockActionsEnd();
            }
        });
    }

    @Override
    public String getDbID() {
        return this.study.dbID;
    }

    @Override
    public RootEditor getRootEditor() {
        return this;
    }

    @Override
    public void updateDocumentName() {
        String string = DbCore.getHostDbName((String)this.getDbID());
        if (null == string) {
            this.setDocumentName(this.study.name);
        } else {
            this.setDocumentName(string + "/" + this.study.name);
        }
        StudyManager.updateGeographyEditor(this.getDbID(), this.study.study.key, this.study.name, 0, "");
        for (IxRuleEditor window : this.ixRuleEditors.values()) {
            window.updateDocumentName();
        }
        for (ScenarioEditor scenarioEditor : this.scenarioEditors.values()) {
            scenarioEditor.updateDocumentName();
        }
        if (null != this.newScenarioFinder) {
            this.newScenarioFinder.updateDocumentName();
        }
    }

    @Override
    public int getStudyKey() {
        return this.study.study.key;
    }

    @Override
    public String getStudyName() {
        return this.study.name;
    }

    @Override
    public int getStudyLock() {
        return this.study.study.studyLock;
    }

    @Override
    public int getLockCount() {
        return this.study.study.lockCount;
    }

    @Override
    public void toFront() {
        super.toFront();
    }

    @Override
    public boolean studyManagerClosing() {
        return false;
    }

    @Override
    protected boolean isDataValid(String string) {
        if (!super.isDataValid(string)) {
            return false;
        }
        if (!this.commitCurrentField()) {
            return false;
        }
        for (ScenarioEditor scenarioEditor : this.scenarioEditors.values()) {
            if (!scenarioEditor.isVisible() || scenarioEditor.isDataValid(string)) continue;
            return false;
        }
        this.errorReporter.setTitle(string);
        return this.study.isDataValid((ErrorLogger)this.errorReporter);
    }

    @Override
    protected boolean isDataChanged() {
        this.dataChanged = this.study.isDataChanged();
        return this.dataChanged;
    }

    @Override
    protected boolean save(String string) {
        if (!super.save(string)) {
            this.dataChanged = false;
            return false;
        }
        if (!this.dataChanged) {
            this.clearDidEdit();
            return false;
        }
        this.dataChanged = false;
        this.errorReporter.setTitle(string);
        boolean bl = false;
        if (2 == this.studyType && this.study.scenarioData.getRowCount() > 0 && 2 == this.study.scenarioData.get((int)0).scenarioType) {
            Object object2;
            ScenarioEditData scenarioEditData = this.study.scenarioData.get(0);
            scenarioEditData.removeAllChildScenarios();
            boolean bl2 = scenarioEditData.sourceData.isScenarioChanged();
            final ArrayList<ScenarioEditData> arrayList = new ArrayList<ScenarioEditData>();
            for (Object object2 : this.study.scenarioData.getRows()) {
                if (1 != ((ScenarioEditData)object2).scenarioType || !bl2 && !object2.isScenarioChanged()) continue;
                arrayList.add((ScenarioEditData)object2);
            }
            BackgroundWorker<Boolean> backgroundWorker = new BackgroundWorker<Boolean>((Window)this, string){
                private StudyBuildIxCheck.ScenarioBuilder builder;

                @Override
                protected Boolean doBackgroundWork(ErrorLogger errorLogger) {
                    this.builder = new StudyBuildIxCheck.ScenarioBuilder();
                    for (ScenarioEditData scenarioEditData : arrayList) {
                        if (this.isCanceled()) {
                            return Boolean.FALSE;
                        }
                        SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)scenarioEditData.sourceData.getDesiredSource();
                        if (null == sourceEditDataTV) {
                            errorLogger.reportError("Cannot identify protected record in '" + scenarioEditData.name + "'");
                            return Boolean.FALSE;
                        }
                        this.setWaitMessage("Building scenarios for '" + scenarioEditData.name + "'...");
                        if (this.builder.buildFromScenario(scenarioEditData, null, errorLogger)) continue;
                        return Boolean.FALSE;
                    }
                    this.hideCancel();
                    if (!StudyEditor.this.study.isDataValid()) {
                        return Boolean.FALSE;
                    }
                    StudyEditor.this.study.isDataChanged();
                    this.setWaitMessage("Saving study, please wait...");
                    return StudyEditor.this.study.save(errorLogger, StudyBuildIxCheck.makeReportPreamble((StudyEditData)StudyEditor.this.study));
                }

                @Override
                public void cancelWork() {
                    if (null != this.builder) {
                        this.builder.cancel();
                    }
                }
            };
            backgroundWorker.showCancel();
            this.errorReporter.clearMessages();
            object2 = (Boolean)backgroundWorker.runWork("Building scenarios, please wait...                  ", this.errorReporter);
            if (null != object2) {
                bl = (Boolean)object2;
            }
        } else {
            BackgroundWorker<Boolean> backgroundWorker = new BackgroundWorker<Boolean>((Window)this, string){

                @Override
                protected Boolean doBackgroundWork(ErrorLogger errorLogger) {
                    return StudyEditor.this.study.save(errorLogger);
                }
            };
            this.errorReporter.clearMessages();
            Boolean bl3 = (Boolean)backgroundWorker.runWork("Saving study, please wait...", this.errorReporter);
            if (null != bl3) {
                bl = bl3;
            }
        }
        if (bl) {
            this.clearDidEdit();
            this.updateDocumentName();
            this.studyNameField.setText(this.study.name);
            this.parent.applyEditsFrom(this);
            this.errorReporter.showMessages();
            return true;
        }
        return false;
    }

    @Override
    public boolean saveIfNeeded(String string, boolean bl) {
        String string2 = null;
        DbConnection dbConnection = DbCore.connectDb((String)this.getDbID());
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT study_lock, lock_count FROM study WHERE study_key = " + this.study.study.key);
                if (dbConnection.next()) {
                    if (1 != dbConnection.getInt(1) || this.study.study.lockCount != dbConnection.getInt(2)) {
                        string2 = "The study database lock was modified";
                    }
                } else {
                    string2 = "The study does not exist";
                }
            }
            catch (SQLException sQLException) {
                string2 = "An operation cannot be completed due to a database error:\n" + sQLException;
                DbConnection.reportError((SQLException)sQLException);
            }
            DbCore.releaseDb((DbConnection)dbConnection);
        } else {
            string2 = "A connection to the database server cannot be established";
        }
        if (null != string2) {
            AppController.beep();
            return 0 != JOptionPane.showConfirmDialog(this, string2 + "\n\nThe study cannot be saved.  You may keep the window open to view data\nor save the study as a template.  Do you want to keep the window open?", string, 0, 0);
        }
        return super.saveIfNeeded(string, bl);
    }

    private void doPreviousRule() {
        int n = this.ixRuleTable.getRowCount();
        int n2 = this.ixRuleTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.ixRuleTable.setRowSelectionInterval(n2, n2);
            this.ixRuleTable.scrollRectToVisible(this.ixRuleTable.getCellRect(n2, 0, true));
        }
    }

    private void doNextRule() {
        int n = this.ixRuleTable.getRowCount();
        int n2 = this.ixRuleTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.ixRuleTable.setRowSelectionInterval(n2, n2);
            this.ixRuleTable.scrollRectToVisible(this.ixRuleTable.getCellRect(n2, 0, true));
        }
    }

    private void doNewIxRule() {
        if (this.study.study.templateLocked) {
            return;
        }
        int n = 1;
        if (4 == this.studyType) {
            n = 3;
        } else if (5 == this.studyType) {
            n = 0;
        }
        Integer n2 = this.study.getNewIxRuleKey();
        IxRuleEditor ixRuleEditor = new IxRuleEditor((AppEditor)this, n, new IxRuleEditData(n2));
        AppController.showWindow(ixRuleEditor);
        this.ixRuleEditors.put(n2, ixRuleEditor);
    }

    private void doOpenIxRule() {
        if (this.ixRuleTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.ixRuleTable.convertRowIndexToModel(this.ixRuleTable.getSelectedRow());
        IxRuleEditData ixRuleEditData = this.ixRuleModel.get(n);
        IxRuleEditor ixRuleEditor = this.ixRuleEditors.get(ixRuleEditData.key);
        if (null != ixRuleEditor) {
            if (ixRuleEditor.isVisible()) {
                ixRuleEditor.toFront();
                return;
            }
            this.ixRuleEditors.remove(ixRuleEditData.key);
        }
        ixRuleEditor = new IxRuleEditor((AppEditor)this, ixRuleEditData.serviceType.recordType, ixRuleEditData);
        AppController.showWindow(ixRuleEditor);
        this.ixRuleEditors.put(ixRuleEditData.key, ixRuleEditor);
    }

    private void doDeleteIxRule() {
        if (this.study.study.templateLocked) {
            return;
        }
        if (0 == this.ixRuleTable.getSelectedRowCount()) {
            return;
        }
        int[] nArray = this.ixRuleTable.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.ixRuleTable.convertRowIndexToModel(nArray[i]);
            IxRuleEditData ixRuleEditData = this.ixRuleModel.get(nArray2[i]);
            IxRuleEditor ixRuleEditor = this.ixRuleEditors.get(ixRuleEditData.key);
            if (null == ixRuleEditor) continue;
            if (ixRuleEditor.isVisible() && !ixRuleEditor.cancel()) {
                AppController.beep();
                ixRuleEditor.toFront();
                return;
            }
            this.ixRuleEditors.remove(ixRuleEditData.key);
        }
        if (this.ixRuleModel.remove(nArray2)) {
            this.setDidEdit();
        }
    }

    private void doSetIxRuleActive(boolean bl) {
        if (0 == this.ixRuleTable.getSelectedRowCount()) {
            return;
        }
        int[] nArray = this.ixRuleTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            IxRuleEditor ixRuleEditor;
            int n = this.ixRuleTable.convertRowIndexToModel(nArray[i]);
            if (this.ixRuleModel.setActive(n, bl)) {
                this.setDidEdit();
            }
            if (null == (ixRuleEditor = this.ixRuleEditors.get(((IxRuleTableModel)this.ixRuleModel).get((int)n).key))) continue;
            ixRuleEditor.updateDocumentName();
        }
        this.updateRuleControls();
    }

    private void doEnableDisableRules() {
        IxRuleEnableDisable ixRuleEnableDisable = new IxRuleEnableDisable();
        AppController.showWindow(ixRuleEnableDisable);
        if (ixRuleEnableDisable.canceled) {
            return;
        }
        this.ixRuleModel.dataWasChanged();
        if (ixRuleEnableDisable.didChange) {
            this.setDidEdit();
        }
        this.updateRuleControls();
    }

    private void doPreviousScenario() {
        int n = this.scenarioTable.getRowCount();
        int n2 = this.scenarioTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.scenarioTable.setRowSelectionInterval(n2, n2);
            this.scenarioTable.scrollRectToVisible(this.scenarioTable.getCellRect(n2, 0, true));
        }
    }

    private void doNextScenario() {
        int n = this.scenarioTable.getRowCount();
        int n2 = this.scenarioTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.scenarioTable.setRowSelectionInterval(n2, n2);
            this.scenarioTable.scrollRectToVisible(this.scenarioTable.getCellRect(n2, 0, true));
        }
    }

    private void doNewScenario() {
        if (null != this.newScenarioFinder && this.newScenarioFinder.isVisible()) {
            this.newScenarioFinder.toFront();
            return;
        }
        String string = "New Scenario";
        this.errorReporter.setTitle(string);
        if (2 == this.studyType || 3 == this.studyType || 5 == this.studyType) {
            this.newScenarioFinder = new RecordFind(this, string, 0, 1);
            this.newScenarioFinder.setDefaultExtDbKey(this.study.extDbKey);
            if (5 == this.studyType) {
                this.newScenarioFinder.setNote("Select desired TV channel 6 station for the new scenario");
            } else {
                this.newScenarioFinder.setNote("Select desired TV station for the new scenario");
            }
            this.newScenarioFinder.setAccessoryPanel(new OptionsPanel.NewScenario(this));
            this.newScenarioFinder.setApply(new String[]{"Create"}, new int[]{1}, true, true);
            this.newScenarioFinder.setStudy(this.study);
            AppController.showWindow(this.newScenarioFinder);
            return;
        }
        String string2 = "";
        do {
            if (null != (string2 = JOptionPane.showInputDialog(this, "Enter a name for the new scenario", string, 3))) continue;
            return;
        } while (!DbCore.checkScenarioName((String)(string2 = string2.trim()), (StudyEditData)this.study, (boolean)true, (ErrorLogger)this.errorReporter));
        ScenarioEditData scenarioEditData = new ScenarioEditData(this.study, string2);
        int n = this.scenarioModel.addOrReplace(scenarioEditData);
        this.setDidEdit();
        if (n >= 0) {
            n = this.scenarioTable.convertRowIndexToView(n);
            this.scenarioTable.setRowSelectionInterval(n, n);
            this.scenarioTable.scrollRectToVisible(this.scenarioTable.getCellRect(n, 0, true));
            this.doOpenScenario();
        }
    }

    private void doDuplicateScenario() {
        if (this.scenarioTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.scenarioTable.convertRowIndexToModel(this.scenarioTable.getSelectedRow());
        ScenarioEditData scenarioEditData = this.study.scenarioData.get(n);
        String string = "Duplicate Scenario";
        this.errorReporter.setTitle(string);
        String string2 = "";
        do {
            if (null != (string2 = (String)JOptionPane.showInputDialog(this, "Enter a name for the new scenario", string, 3, null, null, scenarioEditData.name))) continue;
            return;
        } while (!DbCore.checkScenarioName((String)(string2 = string2.trim()), (StudyEditData)this.study, (boolean)true, (ErrorLogger)this.errorReporter));
        if (null == (scenarioEditData = scenarioEditData.duplicate(string2, (ErrorLogger)this.errorReporter))) {
            return;
        }
        n = this.scenarioModel.addOrReplace(scenarioEditData);
        this.setDidEdit();
        if (n >= 0) {
            n = this.scenarioTable.convertRowIndexToView(n);
            this.scenarioTable.setRowSelectionInterval(n, n);
            this.scenarioTable.scrollRectToVisible(this.scenarioTable.getCellRect(n, 0, true));
            this.doOpenScenario();
        }
    }

    private void doImportScenarios() {
        Integer n;
        String string = "Import Scenarios";
        this.errorReporter.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XML (*.xml)", "xml"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (0 != jFileChooser.showDialog(this, "Import")) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        PickExtDbDialog pickExtDbDialog = new PickExtDbDialog(this.outerThis, string, this.study.extDbKey){

            @Override
            protected ArrayList<KeyedRecord> getExtDbList(ErrorReporter errorReporter) {
                ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
                ArrayList arrayList2 = null;
                if (Study.isRecordTypeAllowed((int)StudyEditor.this.studyType, (int)1)) {
                    arrayList2 = ExtDb.getExtDbList((String)this.getDbID(), (int)1, (boolean)false, (boolean)false, (ErrorLogger)errorReporter);
                    if (null == arrayList2) {
                        return null;
                    }
                    arrayList.addAll(arrayList2);
                }
                if (Study.isRecordTypeAllowed((int)StudyEditor.this.studyType, (int)3)) {
                    arrayList2 = ExtDb.getExtDbList((String)this.getDbID(), (int)3, (boolean)false, (boolean)false, (ErrorLogger)errorReporter);
                    if (null == arrayList2) {
                        return null;
                    }
                    for (KeyedRecord keyedRecord : arrayList2) {
                        if (arrayList.contains(keyedRecord)) continue;
                        arrayList.add(keyedRecord);
                    }
                }
                return arrayList;
            }
        };
        AppController.showWindow(pickExtDbDialog);
        if (pickExtDbDialog.canceled) {
            return;
        }
        int n2 = pickExtDbDialog.lookupExtDbKey;
        Integer n3 = n = n2 > 0 ? Integer.valueOf(n2) : null;
        if (n2 > 0) {
            n2 = pickExtDbDialog.alternateExtDbKey;
        }
        final Integer n4 = n2 > 0 ? Integer.valueOf(n2) : null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorReporter.reportError("Could not open the file:\n" + fileNotFoundException.getMessage());
            return;
        }
        final BufferedReader bufferedReader = new BufferedReader(fileReader);
        BackgroundWorker<Integer> backgroundWorker = new BackgroundWorker<Integer>((Window)this, string){

            @Override
            protected Integer doBackgroundWork(ErrorLogger errorLogger) {
                return StudyEditor.this.study.readScenariosFromXML(n, n4, (Reader)bufferedReader, errorLogger);
            }
        };
        this.errorReporter.clearMessages();
        Integer n5 = (Integer)backgroundWorker.runWork("Importing scenarios, please wait...", this.errorReporter);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null != n5) {
            this.scenarioModel.dataWasChanged();
            if (n5 > 0) {
                this.setDidEdit();
            }
            this.errorReporter.showMessages();
            this.errorReporter.reportMessage(String.valueOf(n5) + " scenarios imported");
        }
    }

    private void doExportScenarios() {
        if (0 == this.scenarioTable.getSelectedRowCount()) {
            return;
        }
        String string = "Export Scenarios";
        this.errorReporter.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XML (*.xml)", "xml"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File file = null;
        do {
            if (0 != jFileChooser.showDialog(this, "Export")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            String string2 = file.getName().toLowerCase();
            if (!string2.endsWith(".xml")) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            if (!file.exists()) continue;
            AppController.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return;
        }
        final BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        final ArrayList<ScenarioEditData> arrayList = new ArrayList<ScenarioEditData>();
        int[] nArray = this.scenarioTable.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.study.scenarioData.get(this.scenarioTable.convertRowIndexToModel(nArray[i])));
        }
        BackgroundWorker<Object> backgroundWorker = new BackgroundWorker<Object>((Window)this, string){

            @Override
            protected Object doBackgroundWork(ErrorLogger errorLogger) {
                StudyEditor.this.study.writeScenariosToXML((Writer)bufferedWriter, arrayList, errorLogger);
                return null;
            }
        };
        backgroundWorker.runWork("Exporting scenarios, please wait...", this.errorReporter);
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doOpenScenario() {
        if (this.scenarioTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.scenarioTable.convertRowIndexToModel(this.scenarioTable.getSelectedRow());
        ScenarioEditData scenarioEditData = this.study.scenarioData.get(n);
        ScenarioEditor scenarioEditor = this.scenarioEditors.get(scenarioEditData.key);
        if (null != scenarioEditor) {
            if (scenarioEditor.isVisible()) {
                scenarioEditor.toFront();
                return;
            }
            this.scenarioEditors.remove(scenarioEditData.key);
        }
        scenarioEditor = new ScenarioEditor((AppEditor)this, scenarioEditData);
        AppController.showWindow(scenarioEditor);
        this.scenarioEditors.put(scenarioEditData.key, scenarioEditor);
    }

    private void doDeleteScenarios() {
        int n;
        if (0 == this.scenarioTable.getSelectedRowCount()) {
            return;
        }
        String string = "Delete Scenarios";
        this.errorReporter.setTitle(string);
        int[] nArray = this.scenarioTable.getSelectedRows();
        if (nArray.length > 1) {
            AppController.beep();
            if (0 != JOptionPane.showConfirmDialog(this, "Are you sure you want to delete multiple scenarios?", string, 0, 2)) {
                return;
            }
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = false;
        for (n = 0; n < nArray.length; ++n) {
            int n2 = this.scenarioTable.convertRowIndexToModel(nArray[n]);
            ScenarioEditData scenarioEditData = this.study.scenarioData.get(n2);
            if (scenarioEditData.isPermanent || 2 == scenarioEditData.scenarioType) {
                bl = true;
                continue;
            }
            ScenarioEditor scenarioEditor = this.scenarioEditors.get(scenarioEditData.key);
            if (null != scenarioEditor) {
                if (scenarioEditor.isVisible() && !scenarioEditor.closeWithoutSave()) {
                    AppController.beep();
                    scenarioEditor.toFront();
                    return;
                }
                this.scenarioEditors.remove(scenarioEditData.key);
            }
            arrayList.add(n2);
        }
        if (bl) {
            this.errorReporter.reportWarning("Some scenarios cannot be deleted");
        }
        if (arrayList.isEmpty()) {
            return;
        }
        int[] nArray2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray2[n] = (Integer)arrayList.get(n);
        }
        if (this.scenarioModel.remove(nArray2)) {
            this.setDidEdit();
        }
    }

    private void doDeleteUnusedSources() {
        String string = "Delete Unused Records";
        this.errorReporter.setTitle(string);
        int n = this.study.getUnusedSourceCount();
        if (0 == n) {
            this.errorReporter.reportMessage("There are no unused records in the study");
            return;
        }
        AppController.beep();
        if (0 != JOptionPane.showConfirmDialog(this, "Station records in the study that do not appear in any existing scenario will be\ndeleted.  The records will be re-created if needed again, however any calculation\nresults for those records currently in cache files would have to be re-computed.\n\nAre you sure you want to delete unused records?", string, 0, 3)) {
            return;
        }
        this.study.removeAllUnusedSources();
        this.setDidEdit();
        this.errorReporter.reportMessage("Deleted " + n + " records from the study");
    }

    private void doRevertAllParameters() {
        if (this.study.study.templateLocked) {
            return;
        }
        AppController.beep();
        if (0 != JOptionPane.showConfirmDialog(this, "All unlocked study parameters will be set to default values\nfrom the study template.  Are you sure you want to do this?", "Revert All Parameters", 0, 3)) {
            return;
        }
        for (ParameterEditor parameterEditor : this.parameterEditors) {
            parameterEditor.setDefaultValue(true);
        }
    }

    private void doSaveNewTemplate() {
        String string = "Save New Template";
        this.errorReporter.setTitle(string);
        String string2 = "";
        int n = 0;
        do {
            if (null == (string2 = JOptionPane.showInputDialog(this, "Enter a name for the new template", string, 3))) {
                return;
            }
            if ((string2 = string2.trim()).length() <= 0) continue;
            n = Template.getTemplateKeyForName((String)this.getDbID(), (String)string2, (ErrorLogger)this.errorReporter);
            if (n < 0) {
                return;
            }
            if (n <= 0) continue;
            this.errorReporter.reportWarning("A template with that name already exists");
            string2 = "";
        } while (0 == string2.length());
        if (null != TemplateEditData.createNewTemplateFromStudy((String)string2, (StudyEditData)this.study, (ErrorLogger)this.errorReporter)) {
            TemplateManager.updateTemplates(this.getDbID());
        }
    }

    private void doEditDescription() {
        TextInputDialog textInputDialog = new TextInputDialog((AppEditor)this, "Study Description", "Study Description");
        textInputDialog.setInput(this.study.description);
        AppController.showWindow(textInputDialog);
        if (textInputDialog.canceled) {
            return;
        }
        String string = textInputDialog.getInput();
        if (!string.equals(this.study.description)) {
            this.study.description = string;
            this.setDidEdit();
        }
    }

    private void doEditOutputConfigs() {
        ArrayList<OutputConfig> arrayList = new ArrayList<OutputConfig>();
        arrayList.add(this.study.fileOutputConfig);
        arrayList.add(this.study.mapOutputConfig);
        OutputConfigDialog outputConfigDialog = new OutputConfigDialog((AppEditor)this, arrayList, true);
        AppController.showWindow(outputConfigDialog);
        for (OutputConfig outputConfig : outputConfigDialog.getConfigs()) {
            switch (outputConfig.type) {
                case 1: {
                    if (outputConfig.name.equals(this.study.fileOutputConfig.name) && outputConfig.matchesConfig(this.study.fileOutputConfig)) break;
                    this.study.fileOutputConfig = outputConfig;
                    this.setDidEdit();
                    break;
                }
                case 2: {
                    if (outputConfig.name.equals(this.study.mapOutputConfig.name) && outputConfig.matchesConfig(this.study.mapOutputConfig)) break;
                    this.study.mapOutputConfig = outputConfig;
                    this.setDidEdit();
                }
            }
        }
        this.updateOutputConfigMenus();
    }

    private void updateOutputConfigMenus() {
        this.blockActionsStart();
        ArrayList arrayList = OutputConfig.getConfigs((String)this.getDbID(), (int)1);
        if (!arrayList.contains(this.study.fileOutputConfig)) {
            arrayList.add(0, this.study.fileOutputConfig);
        }
        if (!this.study.fileOutputConfig.isNull()) {
            arrayList.add(0, OutputConfig.getNullObject((int)1));
        }
        this.fileOutputConfigMenu.removeAllItems();
        for (OutputConfig outputConfig : arrayList) {
            this.fileOutputConfigMenu.addItem(outputConfig);
        }
        this.fileOutputConfigMenu.setSelectedItem(this.study.fileOutputConfig);
        arrayList = OutputConfig.getConfigs((String)this.getDbID(), (int)2);
        if (!arrayList.contains(this.study.mapOutputConfig)) {
            arrayList.add(0, this.study.mapOutputConfig);
        }
        if (!this.study.mapOutputConfig.isNull()) {
            arrayList.add(0, OutputConfig.getNullObject((int)2));
        }
        this.mapOutputConfigMenu.removeAllItems();
        for (OutputConfig outputConfig : arrayList) {
            this.mapOutputConfigMenu.addItem(outputConfig);
        }
        this.mapOutputConfigMenu.setSelectedItem(this.study.mapOutputConfig);
        this.blockActionsEnd();
    }

    private void doChangeOutDirectory() {
        String string = "Set Output Directory";
        this.errorReporter.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(false);
        if (0 != jFileChooser.showDialog(this, "OK")) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (!file.exists()) {
            file = file.getParentFile();
        }
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        this.outDirectoryPath = file.getAbsoluteFile().toPath();
        String string2 = this.outDirectoryPath.startsWith(AppCore.workingDirectoryPath) ? AppCore.workingDirectoryPath.relativize(this.outDirectoryPath).toString() : this.outDirectoryPath.toString();
        if (!string2.equals(this.study.outDirectory)) {
            this.study.outDirectory = string2;
            this.setDidEdit();
        }
        this.updateOutDirectory();
    }

    private void updateOutDirectory() {
        this.outDirectoryLabel.setText(this.outDirectoryPath.toString());
        this.resetOutDirectoryButton.setEnabled(!this.study.outDirectory.equals(AppCore.studyOutDirectory));
    }

    @Override
    public AppEditor getEditorFor(Object object) {
        if (object instanceof ScenarioEditData) {
            return this.scenarioEditors.get(((ScenarioEditData)object).key);
        }
        if (object instanceof IxRuleEditData) {
            return this.ixRuleEditors.get(((IxRuleEditData)object).key);
        }
        return null;
    }

    @Override
    public boolean applyEditsFrom(AppEditor appEditor) {
        if (appEditor instanceof IxRuleEditor) {
            if (this.study.study.templateLocked) {
                return false;
            }
            IxRuleEditor ixRuleEditor = (IxRuleEditor)appEditor;
            IxRuleEditData ixRuleEditData = ixRuleEditor.getIxRule();
            if (ixRuleEditor != this.ixRuleEditors.get(ixRuleEditData.key)) {
                return false;
            }
            if (this.study.ixRuleData.isIxRuleUnique(ixRuleEditData, (ErrorLogger)ixRuleEditor.getErrorReporter())) {
                int n = this.ixRuleModel.addOrReplace(ixRuleEditData);
                if (ixRuleEditData.isDataChanged()) {
                    this.setDidEdit();
                }
                if (n >= 0) {
                    n = this.ixRuleTable.convertRowIndexToView(n);
                    this.ixRuleTable.setRowSelectionInterval(n, n);
                    this.ixRuleTable.scrollRectToVisible(this.ixRuleTable.getCellRect(n, 0, true));
                }
                return true;
            }
            return false;
        }
        if (appEditor instanceof ScenarioEditor) {
            ScenarioEditor scenarioEditor = (ScenarioEditor)appEditor;
            if (scenarioEditor != this.scenarioEditors.get(scenarioEditor.getScenario().key)) {
                return false;
            }
            ScenarioEditData scenarioEditData = scenarioEditor.getScenario();
            this.scenarioModel.scenarioWasEdited(scenarioEditData);
            if (scenarioEditData.isDataChanged()) {
                this.setDidEdit();
            }
            return true;
        }
        if (appEditor instanceof RecordFind) {
            int n;
            if ((RecordFind)appEditor != this.newScenarioFinder) {
                return false;
            }
            ErrorReporter errorReporter = this.newScenarioFinder.getErrorReporter();
            OptionsPanel optionsPanel = (OptionsPanel)this.newScenarioFinder.getAccessoryPanel();
            if (!DbCore.checkScenarioName((String)optionsPanel.name, (StudyEditData)this.study, (boolean)true, (ErrorLogger)errorReporter)) {
                return false;
            }
            SourceEditData sourceEditData = this.newScenarioFinder.source;
            ExtDbRecord extDbRecord = this.newScenarioFinder.record;
            int n2 = 0;
            if (null != sourceEditData) {
                n2 = sourceEditData.recordType;
            } else if (null != extDbRecord) {
                n2 = extDbRecord.recordType;
            }
            if (1 != n2) {
                errorReporter.reportError("That record type is not allowed here");
                return false;
            }
            boolean bl = optionsPanel.replicate;
            boolean bl2 = optionsPanel.changeChannel;
            int n3 = 0;
            int n4 = this.study.getMinimumChannel();
            int n5 = this.study.getMaximumChannel();
            if (bl || bl2) {
                n3 = optionsPanel.studyChannel;
            } else if (null != sourceEditData) {
                n3 = ((SourceEditDataTV)sourceEditData).channel;
            } else {
                n3 = ((ExtDbRecordTV)extDbRecord).replicateToChannel;
                if (0 == n3) {
                    n3 = ((ExtDbRecordTV)extDbRecord).channel;
                } else {
                    bl = true;
                }
            }
            if (n3 < n4 || n3 > n5) {
                errorReporter.reportWarning("The record must have a channel in the range " + n4 + " to " + n5);
                return false;
            }
            if (5 == this.studyType && 6 != n3) {
                errorReporter.reportWarning("The target TV record must be on channel 6");
                return false;
            }
            ScenarioEditData scenarioEditData = new ScenarioEditData(this.study, optionsPanel.name);
            SourceEditData sourceEditData2 = null;
            SourceEditDataTV sourceEditDataTV = null;
            errorReporter.clearErrors();
            errorReporter.clearMessages();
            if (null != sourceEditData) {
                if (null != sourceEditData.extDbKey && null != sourceEditData.extRecordID) {
                    sourceEditData2 = this.study.findSharedSource(sourceEditData.extDbKey, sourceEditData.extRecordID);
                } else if (null != sourceEditData.userRecordID) {
                    sourceEditData2 = this.study.findSharedSource(sourceEditData.userRecordID);
                }
                if (null == sourceEditData2) {
                    sourceEditData2 = sourceEditData.deriveSource(this.study, sourceEditData.isLocked, (ErrorLogger)errorReporter);
                }
                if (null != sourceEditData2) {
                    if (bl) {
                        sourceEditDataTV = (SourceEditDataTV)sourceEditData2;
                        sourceEditData2 = null;
                        if (sourceEditDataTV.isLocked) {
                            if (null != sourceEditDataTV.extDbKey && null != sourceEditDataTV.extRecordID) {
                                sourceEditData2 = this.study.findSharedReplicationSource(sourceEditDataTV.extDbKey, sourceEditDataTV.extRecordID, n3);
                            } else if (null != sourceEditDataTV.userRecordID) {
                                sourceEditData2 = this.study.findSharedReplicationSource(sourceEditDataTV.userRecordID, n3);
                            }
                        }
                        if (null == sourceEditData2) {
                            sourceEditData2 = sourceEditDataTV.replicate(n3, (ErrorLogger)errorReporter);
                        } else {
                            sourceEditDataTV = null;
                        }
                    } else if (bl2) {
                        if (sourceEditData2.isLocked) {
                            sourceEditDataTV = (SourceEditDataTV)sourceEditData2;
                            sourceEditData2 = sourceEditDataTV.deriveSource(this.study, false, (ErrorLogger)errorReporter);
                        }
                        if (null != sourceEditData2) {
                            ((SourceEditDataTV)sourceEditData2).channel = n3;
                        }
                    }
                }
            } else if (null != extDbRecord) {
                sourceEditData2 = this.study.findSharedSource(extDbRecord.extDb.key, extDbRecord.extRecordID);
                if (null == sourceEditData2) {
                    sourceEditData2 = SourceEditData.makeSource((ExtDbRecord)extDbRecord, (StudyEditData)this.study, (boolean)true, (ErrorLogger)errorReporter);
                }
                if (null != sourceEditData2) {
                    if (bl) {
                        sourceEditDataTV = (SourceEditDataTV)sourceEditData2;
                        sourceEditData2 = this.study.findSharedReplicationSource(extDbRecord.extDb.key, extDbRecord.extRecordID, n3);
                        if (null == sourceEditData2) {
                            sourceEditData2 = sourceEditDataTV.replicate(n3, (ErrorLogger)errorReporter);
                        } else {
                            sourceEditDataTV = null;
                        }
                    } else if (bl2 && null != (sourceEditData2 = (sourceEditDataTV = (SourceEditDataTV)sourceEditData2).deriveSource(this.study, false, (ErrorLogger)errorReporter))) {
                        ((SourceEditDataTV)sourceEditData2).channel = n3;
                    }
                }
            }
            if (null == sourceEditData2) {
                if (!errorReporter.hasErrors()) {
                    if (errorReporter.hasMessages()) {
                        errorReporter.reportError(errorReporter.getMessages());
                    } else {
                        errorReporter.reportError("The record could not be added due to an unknown error");
                    }
                }
                return false;
            }
            if (2 == this.studyType) {
                AppController.beep();
                n = JOptionPane.showConfirmDialog(this, "Should this be considered a pre-baseline facility record?", errorReporter.getTitle(), 1, 3);
                if (2 == n) {
                    return false;
                }
                if (0 == n) {
                    sourceEditData2.setAttribute("-isPreBaseline");
                    if (null != sourceEditDataTV) {
                        sourceEditDataTV.setAttribute("-isPreBaseline");
                    }
                }
            }
            errorReporter.showMessages();
            if (null != sourceEditDataTV) {
                this.study.addOrReplaceSource((SourceEditData)sourceEditDataTV);
            }
            scenarioEditData.sourceData.addOrReplace(sourceEditData2, true, false, true);
            n = this.scenarioModel.addOrReplace(scenarioEditData);
            this.setDidEdit();
            if (n >= 0) {
                n = this.scenarioTable.convertRowIndexToView(n);
                this.scenarioTable.setRowSelectionInterval(n, n);
                this.scenarioTable.scrollRectToVisible(this.scenarioTable.getCellRect(n, 0, true));
                this.doOpenScenario();
            }
            return true;
        }
        return false;
    }

    @Override
    public void editorClosing(AppEditor appEditor) {
        if (appEditor instanceof IxRuleEditor) {
            this.ixRuleEditors.remove(((IxRuleEditor)appEditor).getIxRule().key, (IxRuleEditor)appEditor);
            return;
        }
        if (appEditor instanceof ScenarioEditor) {
            this.scenarioEditors.remove(((ScenarioEditor)appEditor).getScenario().key, (ScenarioEditor)appEditor);
            return;
        }
        if (appEditor instanceof RecordFind && (RecordFind)appEditor == this.newScenarioFinder) {
            this.newScenarioFinder = null;
            return;
        }
    }

    @Override
    public boolean closeWithoutSave() {
        for (IxRuleEditor window : new ArrayList<IxRuleEditor>(this.ixRuleEditors.values())) {
            if (window.isVisible() && !window.cancel()) {
                AppController.beep();
                window.toFront();
                return false;
            }
            this.ixRuleEditors.remove(window.getIxRule().key);
        }
        for (ScenarioEditor scenarioEditor : new ArrayList<ScenarioEditor>(this.scenarioEditors.values())) {
            if (scenarioEditor.isVisible() && !scenarioEditor.closeWithoutSave()) {
                AppController.beep();
                scenarioEditor.toFront();
                return false;
            }
            this.scenarioEditors.remove(scenarioEditor.getScenario().key);
        }
        if (null != this.newScenarioFinder) {
            if (this.newScenarioFinder.isVisible() && !this.newScenarioFinder.closeWithoutSave()) {
                AppController.beep();
                this.newScenarioFinder.toFront();
                return false;
            }
            this.newScenarioFinder = null;
        }
        if (!StudyManager.closeGeographyScopeWithoutSave(this.getDbID(), this.study.study.key, 0)) {
            return false;
        }
        AppController.hideWindow(this);
        return true;
    }

    @Override
    public void windowWillOpen() {
        this.updateExtDbList();
        ExtDb.addListener((ExtDbListener)this);
        DbController.restoreColumnWidths(this.getDbID(), this.getKeyTitle() + ".Rules", this.ixRuleTable);
        DbController.restoreColumnWidths(this.getDbID(), this.getKeyTitle() + ".Scenarios", this.scenarioTable);
        this.blockActionsClear();
        if (this.hasNewParameters) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StudyEditor.this.errorReporter.setTitle("New Parameters");
                    AppController.beep();
                    StudyEditor.this.errorReporter.reportMessage("New parameters have been added to the study");
                }
            });
        }
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        boolean bl = this.confirmSave;
        this.confirmSave = true;
        boolean bl2 = this.study.study.templateLocked;
        for (IxRuleEditor window : new ArrayList<IxRuleEditor>(this.ixRuleEditors.values())) {
            if (!(!window.isVisible() || bl2 && window.cancel())) {
                AppController.beep();
                window.toFront();
                return false;
            }
            this.ixRuleEditors.remove(window.getIxRule().key);
        }
        for (ScenarioEditor scenarioEditor : new ArrayList<ScenarioEditor>(this.scenarioEditors.values())) {
            if (scenarioEditor.isVisible() && !scenarioEditor.closeIfPossible()) {
                AppController.beep();
                scenarioEditor.toFront();
                return false;
            }
            this.scenarioEditors.remove(scenarioEditor.getScenario().key);
        }
        if (null != this.newScenarioFinder) {
            if (this.newScenarioFinder.isVisible() && !this.newScenarioFinder.closeIfPossible()) {
                AppController.beep();
                this.newScenarioFinder.toFront();
                return false;
            }
            this.newScenarioFinder = null;
        }
        if (!StudyManager.closeGeographyScopeIfPossible(this.getDbID(), this.study.study.key, 0)) {
            return false;
        }
        if (!this.saveIfNeeded("Close Study", bl)) {
            this.toFront();
            return false;
        }
        return true;
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        ExtDb.removeListener((ExtDbListener)this);
        this.study.invalidate();
        DbController.saveColumnWidths(this.getDbID(), this.getKeyTitle() + ".Rules", this.ixRuleTable);
        DbController.saveColumnWidths(this.getDbID(), this.getKeyTitle() + ".Scenarios", this.scenarioTable);
        this.blockActionsSet();
        this.parent.editorClosing(this);
    }

    private class IxRuleEnableDisable
    extends AppDialog {
        private JComboBox<String> enableDisableMenu;
        private KeyedRecordMenu countryMenu;
        private KeyedRecordMenu serviceTypeMenu;
        private KeyedRecordMenu undesiredServiceTypeMenu;
        private KeyedRecordMenu channelDeltaMenu;
        private KeyedRecordMenu channelBandMenu;
        private JButton okButton;
        private JButton cancelButton;
        private boolean canceled;
        private boolean didChange;

        private IxRuleEnableDisable() {
            super(StudyEditor.this.outerThis, "Enable/Disable Interference Rules", Dialog.ModalityType.APPLICATION_MODAL);
            boolean bl = 4 != StudyEditor.this.studyType;
            int n = 1;
            if (4 == StudyEditor.this.studyType) {
                n = 3;
            } else if (5 == StudyEditor.this.studyType) {
                n = 0;
            }
            this.enableDisableMenu = new JComboBox();
            this.enableDisableMenu.setFocusable(false);
            this.enableDisableMenu.addItem("Disable");
            this.enableDisableMenu.addItem("Enable");
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel("Action"));
            jPanel.add(this.enableDisableMenu);
            ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
            arrayList.add(new KeyedRecord(-1, ""));
            arrayList.addAll(Country.getCountries());
            this.countryMenu = new KeyedRecordMenu(arrayList);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("Country"));
            jPanel2.add(this.countryMenu);
            arrayList.clear();
            arrayList.add(new KeyedRecord(-1, ""));
            arrayList.addAll(ServiceType.getServiceTypes((int)n));
            this.serviceTypeMenu = new KeyedRecordMenu(arrayList);
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createTitledBorder("Service"));
            jPanel3.add(this.serviceTypeMenu);
            this.undesiredServiceTypeMenu = new KeyedRecordMenu(arrayList);
            JPanel jPanel4 = new JPanel();
            jPanel4.setBorder(BorderFactory.createTitledBorder("Service"));
            jPanel4.add(this.undesiredServiceTypeMenu);
            arrayList.clear();
            arrayList.add(new KeyedRecord(-1, ""));
            arrayList.addAll(ChannelDelta.getChannelDeltas((int)n));
            this.channelDeltaMenu = new KeyedRecordMenu(arrayList);
            JPanel jPanel5 = new JPanel();
            jPanel5.setBorder(BorderFactory.createTitledBorder("Channel"));
            jPanel5.add(this.channelDeltaMenu);
            JPanel jPanel6 = null;
            if (bl) {
                arrayList.clear();
                arrayList.add(new KeyedRecord(-1, ""));
                arrayList.addAll(ChannelBand.getChannelBandsWithNull());
                this.channelBandMenu = new KeyedRecordMenu(arrayList);
                jPanel6 = new JPanel();
                jPanel6.setBorder(BorderFactory.createTitledBorder("Band"));
                jPanel6.add(this.channelBandMenu);
            }
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IxRuleEnableDisable.this.doOK();
                }
            });
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setFocusable(false);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IxRuleEnableDisable.this.cancel();
                }
            });
            JPanel jPanel7 = new JPanel();
            jPanel7.add(jPanel2);
            jPanel7.add(jPanel3);
            if (bl) {
                jPanel7.add(jPanel6);
            }
            jPanel7.setBorder(BorderFactory.createTitledBorder("Desired Station"));
            JPanel jPanel8 = new JPanel();
            jPanel8.add(jPanel4);
            jPanel8.add(jPanel5);
            jPanel8.setBorder(BorderFactory.createTitledBorder("Undesired Station"));
            JPanel jPanel9 = new JPanel();
            jPanel9.setLayout(new BoxLayout(jPanel9, 1));
            jPanel9.add(jPanel);
            jPanel9.add(jPanel7);
            jPanel9.add(jPanel8);
            JPanel jPanel10 = new JPanel(new FlowLayout(2));
            jPanel10.add(this.cancelButton);
            jPanel10.add(this.okButton);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)jPanel9, "Center");
            container.add((Component)jPanel10, "South");
            this.getRootPane().setDefaultButton(this.okButton);
            this.pack();
            this.setMinimumSize(this.getSize());
            this.setResizable(true);
            this.setLocationSaved(true);
        }

        @Override
        public void updateDocumentName() {
            this.setDocumentName(StudyEditor.this.outerThis.getDocumentName());
        }

        private void doOK() {
            boolean bl = false;
            if (this.enableDisableMenu.getSelectedIndex() > 0) {
                bl = true;
            }
            int n = this.countryMenu.getSelectedKey();
            int n2 = this.serviceTypeMenu.getSelectedKey();
            int n3 = this.undesiredServiceTypeMenu.getSelectedKey();
            int n4 = this.channelDeltaMenu.getSelectedKey();
            int n5 = -1;
            if (null != this.channelBandMenu) {
                this.channelBandMenu.getSelectedKey();
            }
            int n6 = ((StudyEditor)StudyEditor.this).study.ixRuleData.getRowCount();
            for (int i = 0; i < n6; ++i) {
                IxRuleEditData ixRuleEditData = ((StudyEditor)StudyEditor.this).study.ixRuleData.get(i);
                if (n >= 0 && ixRuleEditData.country.key != n || n2 >= 0 && ixRuleEditData.serviceType.key != n2 || n3 >= 0 && ixRuleEditData.undesiredServiceType.key != n3 || n4 >= 0 && ixRuleEditData.channelDelta.key != n4 || n5 >= 0 && ixRuleEditData.channelBand.key != n5 || !((StudyEditor)StudyEditor.this).study.ixRuleData.setActive(i, bl)) continue;
                this.didChange = true;
            }
            this.canceled = false;
            AppController.hideWindow(this);
        }

        @Override
        public boolean cancel() {
            this.canceled = true;
            AppController.hideWindow(this);
            return true;
        }

        @Override
        public void windowWillOpen() {
            this.enableDisableMenu.setSelectedIndex(0);
            this.countryMenu.setSelectedIndex(0);
            this.serviceTypeMenu.setSelectedIndex(0);
            this.undesiredServiceTypeMenu.setSelectedIndex(0);
            this.channelDeltaMenu.setSelectedIndex(0);
            if (null != this.channelBandMenu) {
                this.channelBandMenu.setSelectedIndex(0);
            }
            this.setLocationRelativeTo(StudyEditor.this.outerThis);
            this.canceled = false;
            this.blockActionsClear();
        }

        @Override
        public boolean windowShouldClose() {
            this.canceled = true;
            return true;
        }

        @Override
        public void windowWillClose() {
            this.blockActionsSet();
        }
    }

    private class ScenarioTableModel
    extends AbstractTableModel {
        private static final String SCENARIO_NAME_COLUMN = "Name";
        private static final String SCENARIO_DESCRIPTION_COLUMN = "Description";
        private String[] columnNames = new String[]{"Name", "Description"};
        private static final int SCENARIO_NAME_INDEX = 0;
        private static final int SCENARIO_DESCRIPTION_INDEX = 1;

        private ScenarioTableModel() {
        }

        private JTable createTable(EditMenu editMenu) {
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable, editMenu);
            jTable.setAutoCreateRowSorter(true);
            TableColumn tableColumn = jTable.getColumn(SCENARIO_NAME_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[15]);
            tableColumn = jTable.getColumn(SCENARIO_DESCRIPTION_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[30]);
            return jTable;
        }

        private int addOrReplace(ScenarioEditData scenarioEditData) {
            this.postChange(((StudyEditor)StudyEditor.this).study.scenarioData.addOrReplace(scenarioEditData));
            return ((StudyEditor)StudyEditor.this).study.scenarioData.getLastRowChanged();
        }

        private boolean remove(int n) {
            return this.postChange(((StudyEditor)StudyEditor.this).study.scenarioData.remove(n));
        }

        private boolean remove(int[] nArray) {
            return this.postChange(((StudyEditor)StudyEditor.this).study.scenarioData.remove(nArray));
        }

        private boolean postChange(boolean bl) {
            if (bl) {
                int n = ((StudyEditor)StudyEditor.this).study.scenarioData.getLastRowChanged();
                switch (((StudyEditor)StudyEditor.this).study.scenarioData.getLastChange()) {
                    default: {
                        break;
                    }
                    case 1: {
                        this.fireTableDataChanged();
                        break;
                    }
                    case 2: {
                        this.fireTableRowsInserted(n, n);
                        break;
                    }
                    case 3: {
                        this.fireTableRowsUpdated(n, n);
                        break;
                    }
                    case 4: {
                        this.fireTableRowsDeleted(n, n);
                    }
                }
            }
            return bl;
        }

        private void scenarioWasEdited(ScenarioEditData scenarioEditData) {
            int n = ((StudyEditor)StudyEditor.this).study.scenarioData.indexOf(scenarioEditData);
            if (n >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
        }

        private void dataWasChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return ((StudyEditor)StudyEditor.this).study.scenarioData.getRowCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ScenarioEditData scenarioEditData = ((StudyEditor)StudyEditor.this).study.scenarioData.get(n);
            switch (n2) {
                case 0: {
                    return scenarioEditData.name;
                }
                case 1: {
                    return scenarioEditData.description;
                }
            }
            return "";
        }
    }

    private class IxRuleTableModel
    extends AbstractTableModel
    implements TableFilterModel {
        private static final String IXRULE_COUNTRY_COLUMN = "Ctry D";
        private static final String IXRULE_SERVICE_COLUMN = "Service D";
        private static final String IXRULE_SIGTYPE_COLUMN = "Mod D";
        private static final String IXRULE_BAND_COLUMN = "Band D";
        private static final String IXRULE_USERVICE_COLUMN = "Service U";
        private static final String IXRULE_USIGTYPE_COLUMN = "Mod U";
        private static final String IXRULE_CHANNEL_COLUMN = "Channel U";
        private static final String IXRULE_MASK_COLUMN = "Mask U";
        private static final String IXRULE_OFFSET_COLUMN = "Offset";
        private static final String IXRULE_DISTANCE_COLUMN = "Distance";
        private static final String IXRULE_DU_COLUMN = "D/U";
        private static final String IXRULE_UTIME_COLUMN = "% Time U";
        private String[] columnNamesTVType = new String[]{"Ctry D", "Service D", "Mod D", "Band D", "Service U", "Mod U", "Channel U", "Mask U", "Offset", "Distance", "D/U", "% Time U"};
        private static final int IXRULE_TVT_COUNTRY_INDEX = 0;
        private static final int IXRULE_TVT_SERVICE_INDEX = 1;
        private static final int IXRULE_TVT_SIGTYPE_INDEX = 2;
        private static final int IXRULE_TVT_BAND_INDEX = 3;
        private static final int IXRULE_TVT_USERVICE_INDEX = 4;
        private static final int IXRULE_TVT_USIGTYPE_INDEX = 5;
        private static final int IXRULE_TVT_CHANNEL_INDEX = 6;
        private static final int IXRULE_TVT_MASK_INDEX = 7;
        private static final int IXRULE_TVT_OFFSET_INDEX = 8;
        private static final int IXRULE_TVT_DISTANCE_INDEX = 9;
        private static final int IXRULE_TVT_DU_INDEX = 10;
        private static final int IXRULE_TVT_UTIME_INDEX = 11;
        private String[] columnNamesTV = new String[]{"Ctry D", "Service D", "Band D", "Service U", "Channel U", "Mask U", "Offset", "Distance", "D/U", "% Time U"};
        private static final int IXRULE_TV_COUNTRY_INDEX = 0;
        private static final int IXRULE_TV_SERVICE_INDEX = 1;
        private static final int IXRULE_TV_BAND_INDEX = 2;
        private static final int IXRULE_TV_USERVICE_INDEX = 3;
        private static final int IXRULE_TV_CHANNEL_INDEX = 4;
        private static final int IXRULE_TV_MASK_INDEX = 5;
        private static final int IXRULE_TV_OFFSET_INDEX = 6;
        private static final int IXRULE_TV_DISTANCE_INDEX = 7;
        private static final int IXRULE_TV_DU_INDEX = 8;
        private static final int IXRULE_TV_UTIME_INDEX = 9;
        private String[] columnNamesFM = new String[]{"Ctry D", "Service D", "Service U", "Channel U", "Distance", "D/U", "% Time U"};
        private static final int IXRULE_FM_COUNTRY_INDEX = 0;
        private static final int IXRULE_FM_SERVICE_INDEX = 1;
        private static final int IXRULE_FM_USERVICE_INDEX = 2;
        private static final int IXRULE_FM_CHANNEL_INDEX = 3;
        private static final int IXRULE_FM_DISTANCE_INDEX = 4;
        private static final int IXRULE_FM_DU_INDEX = 5;
        private static final int IXRULE_FM_UTIME_INDEX = 6;
        private boolean hasTV;
        private boolean showType;
        private NumberFormat doubleFormatter;
        private TableFilterPanel filterPanel;

        private IxRuleTableModel() {
            boolean bl = this.hasTV = 4 != StudyEditor.this.studyType;
            if (this.hasTV) {
                this.showType = SignalType.hasMultipleOptions();
            }
            this.doubleFormatter = NumberFormat.getInstance(Locale.US);
            this.doubleFormatter.setMinimumFractionDigits(2);
            this.doubleFormatter.setMaximumFractionDigits(2);
            this.doubleFormatter.setMinimumIntegerDigits(1);
            this.filterPanel = new TableFilterPanel((AppEditor)StudyEditor.this.outerThis, this);
        }

        private JTable createTable(EditMenu editMenu) {
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable, editMenu);
            jTable.setAutoCreateRowSorter(true);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (!bl) {
                        if (((IxRuleTableModel)IxRuleTableModel.this).get((int)jTable.convertRowIndexToModel((int)n)).isActive) {
                            jLabel.setForeground(Color.BLACK);
                        } else {
                            jLabel.setForeground(Color.GRAY.brighter());
                        }
                    }
                    if (IxRuleTableModel.this.hasTV && IxRuleTableModel.this.showType && (9 == n2 || 10 == n2 || 11 == n2) || IxRuleTableModel.this.hasTV && !IxRuleTableModel.this.showType && (7 == n2 || 8 == n2 || 9 == n2) || !IxRuleTableModel.this.hasTV && (4 == n2 || 5 == n2 || 6 == n2)) {
                        jLabel.setHorizontalAlignment(4);
                    } else {
                        jLabel.setHorizontalAlignment(2);
                    }
                    return jLabel;
                }
            };
            DefaultTableCellRenderer defaultTableCellRenderer2 = (DefaultTableCellRenderer)new JTableHeader().getDefaultRenderer();
            defaultTableCellRenderer2.setHorizontalAlignment(4);
            TableColumn tableColumn = jTable.getColumn(IXRULE_COUNTRY_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[3]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[4]);
            tableColumn = jTable.getColumn(IXRULE_SERVICE_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[10]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[15]);
            if (this.hasTV && this.showType) {
                tableColumn = jTable.getColumn(IXRULE_SIGTYPE_COLUMN);
                tableColumn.setCellRenderer(defaultTableCellRenderer);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[4]);
            }
            if (this.hasTV) {
                tableColumn = jTable.getColumn(IXRULE_BAND_COLUMN);
                tableColumn.setCellRenderer(defaultTableCellRenderer);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[4]);
            }
            tableColumn = jTable.getColumn(IXRULE_USERVICE_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[10]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[15]);
            if (this.hasTV && this.showType) {
                tableColumn = jTable.getColumn(IXRULE_USIGTYPE_COLUMN);
                tableColumn.setCellRenderer(defaultTableCellRenderer);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[4]);
            }
            tableColumn = jTable.getColumn(IXRULE_CHANNEL_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[10]);
            if (this.hasTV) {
                tableColumn = jTable.getColumn(IXRULE_MASK_COLUMN);
                tableColumn.setCellRenderer(defaultTableCellRenderer);
                tableColumn.setMinWidth(AppController.textFieldWidth[5]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[10]);
            }
            if (this.hasTV) {
                tableColumn = jTable.getColumn(IXRULE_OFFSET_COLUMN);
                tableColumn.setCellRenderer(defaultTableCellRenderer);
                tableColumn.setMinWidth(AppController.textFieldWidth[5]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
            }
            tableColumn = jTable.getColumn(IXRULE_DISTANCE_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setHeaderRenderer(defaultTableCellRenderer2);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
            tableColumn = jTable.getColumn(IXRULE_DU_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setHeaderRenderer(defaultTableCellRenderer2);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
            tableColumn = jTable.getColumn(IXRULE_UTIME_COLUMN);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setHeaderRenderer(defaultTableCellRenderer2);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
            return jTable;
        }

        private int addOrReplace(IxRuleEditData ixRuleEditData) {
            this.postChange(((StudyEditor)StudyEditor.this).study.ixRuleData.addOrReplace(ixRuleEditData));
            int n = ((StudyEditor)StudyEditor.this).study.ixRuleData.getLastRowChanged();
            if (n >= 0) {
                return this.filterPanel.reverseIndex[n];
            }
            return n;
        }

        private IxRuleEditData get(int n) {
            return ((StudyEditor)StudyEditor.this).study.ixRuleData.get(this.filterPanel.forwardIndex[n]);
        }

        private boolean remove(int n) {
            return this.postChange(((StudyEditor)StudyEditor.this).study.ixRuleData.remove(this.filterPanel.forwardIndex[n]));
        }

        private boolean remove(int[] nArray) {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.filterPanel.forwardIndex[nArray[i]];
            }
            return this.postChange(((StudyEditor)StudyEditor.this).study.ixRuleData.remove(nArray2));
        }

        private boolean setActive(int n, boolean bl) {
            return this.postChange(((StudyEditor)StudyEditor.this).study.ixRuleData.setActive(this.filterPanel.forwardIndex[n], bl));
        }

        private boolean postChange(boolean bl) {
            if (bl) {
                int n = ((StudyEditor)StudyEditor.this).study.ixRuleData.getLastRowChanged();
                int n2 = -1;
                int n3 = -1;
                if (n >= 0 && n < this.filterPanel.reverseIndex.length) {
                    n2 = this.filterPanel.reverseIndex[n];
                }
                this.filterPanel.updateFilter();
                if (n >= 0 && n < this.filterPanel.reverseIndex.length) {
                    n3 = this.filterPanel.reverseIndex[n];
                }
                switch (((StudyEditor)StudyEditor.this).study.ixRuleData.getLastChange()) {
                    default: {
                        break;
                    }
                    case 1: {
                        this.fireTableDataChanged();
                        break;
                    }
                    case 2: {
                        if (n3 < 0) break;
                        this.fireTableRowsInserted(n3, n3);
                        break;
                    }
                    case 3: {
                        if (n2 >= 0) {
                            if (n3 >= 0) {
                                this.fireTableRowsUpdated(n2, n3);
                                break;
                            }
                            this.fireTableRowsDeleted(n2, n2);
                            break;
                        }
                        if (n3 < 0) break;
                        this.fireTableRowsInserted(n3, n3);
                        break;
                    }
                    case 4: {
                        if (n2 < 0) break;
                        this.fireTableRowsDeleted(n2, n2);
                    }
                }
            }
            return bl;
        }

        private void dataWasChanged() {
            this.filterPanel.updateFilter();
            this.fireTableDataChanged();
        }

        @Override
        public void filterDidChange() {
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            if (this.hasTV) {
                if (this.showType) {
                    return this.columnNamesTVType.length;
                }
                return this.columnNamesTV.length;
            }
            return this.columnNamesFM.length;
        }

        @Override
        public String getColumnName(int n) {
            if (this.hasTV) {
                if (this.showType) {
                    return this.columnNamesTVType[n];
                }
                return this.columnNamesTV[n];
            }
            return this.columnNamesFM[n];
        }

        @Override
        public boolean filterByColumn(int n) {
            if (this.hasTV) {
                if (this.showType) {
                    switch (n) {
                        case 0: 
                        case 1: 
                        case 3: 
                        case 4: 
                        case 6: {
                            return true;
                        }
                    }
                } else {
                    switch (n) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            return true;
                        }
                    }
                }
            } else {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public boolean collapseFilterChoices(int n) {
            return false;
        }

        @Override
        public int getRowCount() {
            return this.filterPanel.forwardIndex.length;
        }

        @Override
        public int getUnfilteredRowCount() {
            return ((StudyEditor)StudyEditor.this).study.ixRuleData.getRowCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.getUnfilteredValueAt(this.filterPanel.forwardIndex[n], n2);
        }

        @Override
        public String getUnfilteredValueAt(int n, int n2) {
            IxRuleEditData ixRuleEditData = ((StudyEditor)StudyEditor.this).study.ixRuleData.get(n);
            if (this.hasTV) {
                if (!this.showType) {
                    switch (n2) {
                        case 0: {
                            n2 = 0;
                            break;
                        }
                        case 1: {
                            n2 = 1;
                            break;
                        }
                        case 2: {
                            n2 = 3;
                            break;
                        }
                        case 3: {
                            n2 = 4;
                            break;
                        }
                        case 4: {
                            n2 = 6;
                            break;
                        }
                        case 5: {
                            n2 = 7;
                            break;
                        }
                        case 6: {
                            n2 = 8;
                            break;
                        }
                        case 7: {
                            n2 = 9;
                            break;
                        }
                        case 8: {
                            n2 = 10;
                            break;
                        }
                        case 9: {
                            n2 = 11;
                        }
                    }
                }
                switch (n2) {
                    case 0: {
                        return ixRuleEditData.country.countryCode;
                    }
                    case 1: {
                        return ixRuleEditData.serviceType.name;
                    }
                    case 2: {
                        if (1 == ixRuleEditData.serviceType.recordType) {
                            return ixRuleEditData.signalType.name;
                        }
                        return "";
                    }
                    case 3: {
                        if (1 == ixRuleEditData.serviceType.recordType) {
                            return ixRuleEditData.channelBand.name;
                        }
                        return "";
                    }
                    case 4: {
                        return ixRuleEditData.undesiredServiceType.name;
                    }
                    case 5: {
                        if (1 == ixRuleEditData.serviceType.recordType) {
                            return ixRuleEditData.undesiredSignalType.name;
                        }
                        return "";
                    }
                    case 6: {
                        return ixRuleEditData.channelDelta.name;
                    }
                    case 7: {
                        if (1 == ixRuleEditData.serviceType.recordType) {
                            return ixRuleEditData.emissionMask.name;
                        }
                        return "";
                    }
                    case 8: {
                        if (1 == ixRuleEditData.serviceType.recordType) {
                            switch (ixRuleEditData.frequencyOffset) {
                                default: {
                                    return "(any)";
                                }
                                case 1: {
                                    return "Without";
                                }
                                case 2: 
                            }
                            return "With";
                        }
                        return "";
                    }
                    case 9: {
                        return this.doubleFormatter.format(ixRuleEditData.distance);
                    }
                    case 10: {
                        return this.doubleFormatter.format(ixRuleEditData.requiredDU);
                    }
                    case 11: {
                        return this.doubleFormatter.format(ixRuleEditData.undesiredTime);
                    }
                }
            } else {
                switch (n2) {
                    case 0: {
                        return ixRuleEditData.country.name;
                    }
                    case 1: {
                        return ixRuleEditData.serviceType.name;
                    }
                    case 2: {
                        return ixRuleEditData.undesiredServiceType.name;
                    }
                    case 3: {
                        return ixRuleEditData.channelDelta.name;
                    }
                    case 4: {
                        return this.doubleFormatter.format(ixRuleEditData.distance);
                    }
                    case 5: {
                        return this.doubleFormatter.format(ixRuleEditData.requiredDU);
                    }
                    case 6: {
                        return this.doubleFormatter.format(ixRuleEditData.undesiredTime);
                    }
                }
            }
            return "";
        }
    }
}

