/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.ExtDb;
import gov.fcc.tvstudy.core.ExtDbRecord;
import gov.fcc.tvstudy.core.ExtDbRecordFM;
import gov.fcc.tvstudy.core.ExtDbRecordTV;
import gov.fcc.tvstudy.core.ExtDbSearch;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.Scenario;
import gov.fcc.tvstudy.core.data.Source;
import gov.fcc.tvstudy.core.data.Study;
import gov.fcc.tvstudy.core.editdata.ScenarioEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditData;
import gov.fcc.tvstudy.core.editdata.SourceEditDataFM;
import gov.fcc.tvstudy.core.editdata.SourceEditDataTV;
import gov.fcc.tvstudy.core.editdata.StudyEditData;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppFrame;
import gov.fcc.tvstudy.gui.BackgroundWorker;
import gov.fcc.tvstudy.gui.DbController;
import gov.fcc.tvstudy.gui.EditMenu;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.ExtDbSearchDialog;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import gov.fcc.tvstudy.gui.OptionsPanel;
import gov.fcc.tvstudy.gui.RecordFind;
import gov.fcc.tvstudy.gui.SourceCompare;
import gov.fcc.tvstudy.gui.TextInputDialog;
import gov.fcc.tvstudy.gui.editor.ParameterEditor;
import gov.fcc.tvstudy.gui.editor.SourceEditor;
import gov.fcc.tvstudy.gui.editor.TableFilterModel;
import gov.fcc.tvstudy.gui.editor.TableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;

public class ScenarioEditor
extends AppFrame {
    public static final String WINDOW_TITLE = "Scenario";
    private ScenarioEditData scenario;
    private int studyType;
    private JTextField scenarioNameField;
    private JTextArea scenarioDescriptionArea;
    private ArrayList<ParameterEditor> parameterEditors;
    private SourceTableModel sourceModel;
    private JTable sourceTable;
    private JButton addSourceButton;
    private JButton openSourceButton;
    private JButton removeSourceButton;
    private JMenuItem addSourceMenuItem;
    private JMenuItem addSourcesMenuItem;
    private JMenuItem importSourcesMenuItem;
    private JMenu importSourcesMenu;
    private JMenuItem openSourceMenuItem;
    private JMenuItem removeSourceMenuItem;
    private JMenuItem replicateSourceMenuItem;
    private JMenuItem unlockSourceMenuItem;
    private JMenuItem revertSourceMenuItem;
    private JMenuItem copyToScenarioMenuItem;
    private JMenuItem compareSourceMenuItem;
    private JMenuItem exportSourcesMenuItem;
    private JMenuItem saveAsUserRecordMenuItem;
    private JMenuItem setDesiredMenuItem;
    private JMenuItem clearDesiredMenuItem;
    private JMenuItem toggleDesiredMenuItem;
    private JMenuItem setUndesiredMenuItem;
    private JMenuItem clearUndesiredMenuItem;
    private JMenuItem toggleUndesiredMenuItem;
    private JComboBox<ExtDbSearch> addSourcesMenu;
    private JPopupMenu sourceTablePopupMenu;
    private JMenuItem cmOpenSourceMenuItem;
    private JMenuItem cmRemoveSourceMenuItem;
    private JMenuItem cmReplicateSourceMenuItem;
    private JMenuItem cmUnlockSourceMenuItem;
    private JMenuItem cmRevertSourceMenuItem;
    private JMenuItem cmSetDesiredMenuItem;
    private JMenuItem cmClearDesiredMenuItem;
    private JMenuItem cmToggleDesiredMenuItem;
    private JMenuItem cmSetUndesiredMenuItem;
    private JMenuItem cmClearUndesiredMenuItem;
    private JMenuItem cmToggleUndesiredMenuItem;
    private HashMap<Integer, SourceEditor> sourceEditors;
    private RecordFind addSourceFinder;
    private ExtDbSearchDialog addSourcesDialog;
    private ScenarioEditor outerThis = this;

    public ScenarioEditor(AppEditor appEditor, ScenarioEditData scenarioEditData) {
        super(appEditor, WINDOW_TITLE);
        JComponent jComponent;
        this.scenario = scenarioEditData;
        this.studyType = this.scenario.study.study.studyType;
        this.setTitleKey(this.scenario.key);
        this.scenarioNameField = new JTextField(30);
        AppController.fixKeyBindings(this.scenarioNameField);
        this.scenarioNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ScenarioEditor.this.blockActions()) {
                    String string = ScenarioEditor.this.scenarioNameField.getText().trim();
                    if (string.length() > 0 && !((ScenarioEditor)ScenarioEditor.this).scenario.name.equals(string)) {
                        boolean bl = false;
                        if (((ScenarioEditor)ScenarioEditor.this).scenario.name.equalsIgnoreCase(string)) {
                            bl = true;
                        } else {
                            ScenarioEditor.this.errorReporter.setTitle("Change Scenario Name");
                            bl = DbCore.checkScenarioName((String)string, (ScenarioEditData)ScenarioEditor.this.scenario, (boolean)true, (ErrorLogger)ScenarioEditor.this.errorReporter);
                        }
                        if (bl) {
                            ((ScenarioEditor)ScenarioEditor.this).scenario.name = string;
                            ScenarioEditor.this.setDidEdit();
                            ScenarioEditor.this.updateDocumentName();
                            ScenarioEditor.this.parent.applyEditsFrom(ScenarioEditor.this.outerThis);
                        }
                    }
                    ScenarioEditor.this.blockActionsEnd();
                }
                ScenarioEditor.this.scenarioNameField.setText(((ScenarioEditor)ScenarioEditor.this).scenario.name);
            }
        });
        this.scenarioNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ScenarioEditor.this.setCurrentField(ScenarioEditor.this.scenarioNameField);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    ScenarioEditor.this.scenarioNameField.postActionEvent();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Scenario Name"));
        jPanel.add(this.scenarioNameField);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel);
        this.scenarioNameField.setText(this.scenario.name);
        this.scenarioDescriptionArea = new JTextArea(6, 40);
        AppController.fixKeyBindings(this.scenarioDescriptionArea);
        this.scenarioDescriptionArea.setLineWrap(true);
        this.scenarioDescriptionArea.setWrapStyleWord(true);
        this.scenarioDescriptionArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                String string = ScenarioEditor.this.scenarioDescriptionArea.getText().trim();
                if (!string.equals(((ScenarioEditor)ScenarioEditor.this).scenario.description)) {
                    ((ScenarioEditor)ScenarioEditor.this).scenario.description = string;
                    ScenarioEditor.this.setDidEdit();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                String string = ScenarioEditor.this.scenarioDescriptionArea.getText().trim();
                if (!string.equals(((ScenarioEditor)ScenarioEditor.this).scenario.description)) {
                    ((ScenarioEditor)ScenarioEditor.this).scenario.description = string;
                    ScenarioEditor.this.setDidEdit();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.scenarioDescriptionArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    ScenarioEditor.this.parent.applyEditsFrom(ScenarioEditor.this.outerThis);
                }
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Scenario Description"));
        jPanel3.add((Component)AppController.createScrollPane(this.scenarioDescriptionArea), "Center");
        this.scenarioDescriptionArea.setText(this.scenario.description);
        this.scenario.description = this.scenarioDescriptionArea.getText().trim();
        JPanel jPanel4 = null;
        if (null != this.scenario.parameters) {
            this.parameterEditors = new ArrayList();
            jComponent = ParameterEditor.createEditorLayout(this, this.errorReporter, this.scenario.parameters, this.parameterEditors);
            jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(BorderFactory.createTitledBorder("Scenario Parameters"));
            jPanel4.add((Component)jComponent, "Center");
        }
        jComponent = new JPanel(new BorderLayout());
        this.sourceModel = new SourceTableModel((JPanel)jComponent);
        this.sourceTable = this.sourceModel.createTable(this.editMenu);
        this.sourceTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 == mouseEvent.getClickCount()) {
                    ScenarioEditor.this.doOpenSource();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ScenarioEditor.this.sourceTablePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ScenarioEditor.this.sourceTablePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.sourceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ScenarioEditor.this.updateControls();
            }
        });
        this.sourceModel.updateBorder();
        jComponent.add((Component)AppController.createScrollPane(this.sourceTable), "Center");
        jComponent.add((Component)this.sourceModel.filterPanel, "South");
        this.sourceEditors = new HashMap();
        this.addSourcesMenu = new JComboBox();
        this.addSourcesMenu.setFocusable(false);
        this.addSourcesMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ScenarioEditor.this.blockActions()) {
                    ExtDbSearch extDbSearch = (ExtDbSearch)ScenarioEditor.this.addSourcesMenu.getSelectedItem();
                    if (null != extDbSearch && extDbSearch.name.length() > 0) {
                        ScenarioEditor.this.doAddSources(extDbSearch);
                    }
                    ScenarioEditor.this.addSourcesMenu.setSelectedIndex(0);
                    ScenarioEditor.this.blockActionsEnd();
                }
            }
        });
        this.addSourceButton = new JButton("Add One");
        this.addSourceButton.setFocusable(false);
        this.addSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doAddSource();
            }
        });
        this.openSourceButton = new JButton("View");
        this.openSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doOpenSource();
            }
        });
        this.removeSourceButton = new JButton("Remove");
        this.removeSourceButton.setFocusable(false);
        this.removeSourceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doRemoveSource();
            }
        });
        JButton jButton = new JButton("Close");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ScenarioEditor.this.windowShouldClose()) {
                    AppController.hideWindow(ScenarioEditor.this.outerThis);
                }
            }
        });
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel2, "North");
        jPanel5.add((Component)jPanel3, "Center");
        JPanel jPanel6 = jPanel5;
        if (null != jPanel4) {
            jPanel6 = new JPanel(new BorderLayout());
            jPanel6.add((Component)jPanel5, "North");
            jPanel6.add((Component)jPanel4, "Center");
        }
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.add(this.addSourceButton);
        jPanel7.add(this.addSourcesMenu);
        JPanel jPanel8 = new JPanel();
        jPanel8.add(this.removeSourceButton);
        jPanel8.add(this.openSourceButton);
        JPanel jPanel9 = new JPanel(new FlowLayout(2));
        jPanel9.add(jButton);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BoxLayout(jPanel10, 0));
        jPanel10.add(jPanel7);
        jPanel10.add(jPanel8);
        jPanel10.add(jPanel9);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel6, "North");
        container.add((Component)jComponent, "Center");
        container.add((Component)jPanel10, "South");
        this.getRootPane().setDefaultButton(this.openSourceButton);
        this.pack();
        Dimension dimension = new Dimension(860, 650);
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.fileMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Previous");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doPrevious();
            }
        });
        this.fileMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Next");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(40, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doNext();
            }
        });
        this.fileMenu.add(jMenuItem2);
        this.fileMenu.addSeparator();
        this.addSourceMenuItem = new JMenuItem("Add One...");
        this.addSourceMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, AppController.MENU_SHORTCUT_KEY_MASK));
        this.addSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doAddSource();
            }
        });
        this.fileMenu.add(this.addSourceMenuItem);
        this.addSourcesMenuItem = new JMenuItem("Add Many...");
        this.addSourcesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doAddSources(null);
            }
        });
        this.fileMenu.add(this.addSourcesMenuItem);
        ArrayList arrayList = Source.getRecordTypes((int)this.studyType);
        if (1 == arrayList.size()) {
            final int n = ((KeyedRecord)arrayList.get((int)0)).key;
            this.importSourcesMenuItem = new JMenuItem("Import...");
            this.importSourcesMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ScenarioEditor.this.doImportSources(n);
                }
            });
            this.fileMenu.add(this.importSourcesMenuItem);
        } else {
            this.importSourcesMenu = new JMenu("Import");
            for (KeyedRecord keyedRecord : arrayList) {
                JMenuItem jMenuItem3 = new JMenuItem(keyedRecord.name);
                final int n = keyedRecord.key;
                jMenuItem3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ScenarioEditor.this.doImportSources(n);
                    }
                });
                this.importSourcesMenu.add(jMenuItem3);
            }
            this.fileMenu.add(this.importSourcesMenu);
        }
        this.fileMenu.addSeparator();
        this.openSourceMenuItem = new JMenuItem("View");
        this.openSourceMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppController.MENU_SHORTCUT_KEY_MASK));
        this.openSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doOpenSource();
            }
        });
        this.fileMenu.add(this.openSourceMenuItem);
        this.removeSourceMenuItem = new JMenuItem("Remove");
        this.removeSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doRemoveSource();
            }
        });
        this.fileMenu.add(this.removeSourceMenuItem);
        this.fileMenu.addSeparator();
        this.replicateSourceMenuItem = new JMenuItem("Replicate...");
        this.replicateSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doReplicateSource();
            }
        });
        this.fileMenu.add(this.replicateSourceMenuItem);
        this.unlockSourceMenuItem = new JMenuItem("Allow Editing");
        this.unlockSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doUnlockSource();
            }
        });
        this.fileMenu.add(this.unlockSourceMenuItem);
        this.revertSourceMenuItem = new JMenuItem("Revert");
        this.revertSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doRevertSource();
            }
        });
        this.fileMenu.add(this.revertSourceMenuItem);
        this.fileMenu.addSeparator();
        this.copyToScenarioMenuItem = new JMenuItem("Copy To Scenario...");
        this.copyToScenarioMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doCopyToScenario();
            }
        });
        this.fileMenu.add(this.copyToScenarioMenuItem);
        this.exportSourcesMenuItem = new JMenuItem("Export...");
        this.exportSourcesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doExportSources();
            }
        });
        this.fileMenu.add(this.exportSourcesMenuItem);
        this.saveAsUserRecordMenuItem = new JMenuItem("Save As User Record...");
        this.saveAsUserRecordMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSaveAsUserRecord();
            }
        });
        this.fileMenu.add(this.saveAsUserRecordMenuItem);
        this.fileMenu.addSeparator();
        this.compareSourceMenuItem = new JMenuItem("Compare");
        this.compareSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doCompareSource();
            }
        });
        this.fileMenu.add(this.compareSourceMenuItem);
        this.editMenu.addSeparator();
        this.setDesiredMenuItem = new JMenuItem("Set Desired");
        this.setDesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSetFlags(true, true);
            }
        });
        this.editMenu.add(this.setDesiredMenuItem);
        this.clearDesiredMenuItem = new JMenuItem("Clear Desired");
        this.clearDesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSetFlags(true, false);
            }
        });
        this.editMenu.add(this.clearDesiredMenuItem);
        this.toggleDesiredMenuItem = new JMenuItem("Toggle Desired");
        this.toggleDesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doToggleFlags(true);
            }
        });
        this.editMenu.add(this.toggleDesiredMenuItem);
        this.setUndesiredMenuItem = new JMenuItem("Set Undesired");
        this.setUndesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSetFlags(false, true);
            }
        });
        this.editMenu.add(this.setUndesiredMenuItem);
        this.clearUndesiredMenuItem = new JMenuItem("Clear Undesired");
        this.clearUndesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSetFlags(false, false);
            }
        });
        this.editMenu.add(this.clearUndesiredMenuItem);
        this.toggleUndesiredMenuItem = new JMenuItem("Toggle Undesired");
        this.toggleUndesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doToggleFlags(false);
            }
        });
        this.editMenu.add(this.toggleUndesiredMenuItem);
        this.sourceTablePopupMenu = new JPopupMenu();
        this.cmOpenSourceMenuItem = new JMenuItem("View");
        this.cmOpenSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doOpenSource();
            }
        });
        this.sourceTablePopupMenu.add(this.cmOpenSourceMenuItem);
        this.cmRemoveSourceMenuItem = new JMenuItem("Remove");
        this.cmRemoveSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doRemoveSource();
            }
        });
        this.sourceTablePopupMenu.add(this.cmRemoveSourceMenuItem);
        this.cmReplicateSourceMenuItem = new JMenuItem("Replicate...");
        this.cmReplicateSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doReplicateSource();
            }
        });
        this.sourceTablePopupMenu.add(this.cmReplicateSourceMenuItem);
        this.cmUnlockSourceMenuItem = new JMenuItem("Allow Editing");
        this.cmUnlockSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doUnlockSource();
            }
        });
        this.sourceTablePopupMenu.add(this.cmUnlockSourceMenuItem);
        this.cmRevertSourceMenuItem = new JMenuItem("Revert");
        this.cmRevertSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doRevertSource();
            }
        });
        this.sourceTablePopupMenu.add(this.cmRevertSourceMenuItem);
        this.cmSetDesiredMenuItem = new JMenuItem("Set Desired");
        this.cmSetDesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSetFlags(true, true);
            }
        });
        this.sourceTablePopupMenu.add(this.cmSetDesiredMenuItem);
        this.cmClearDesiredMenuItem = new JMenuItem("Clear Desired");
        this.cmClearDesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSetFlags(true, false);
            }
        });
        this.sourceTablePopupMenu.add(this.cmClearDesiredMenuItem);
        this.cmToggleDesiredMenuItem = new JMenuItem("Toggle Desired");
        this.cmToggleDesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doToggleFlags(true);
            }
        });
        this.sourceTablePopupMenu.add(this.cmToggleDesiredMenuItem);
        this.cmSetUndesiredMenuItem = new JMenuItem("Set Undesired");
        this.cmSetUndesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSetFlags(false, true);
            }
        });
        this.sourceTablePopupMenu.add(this.cmSetUndesiredMenuItem);
        this.cmClearUndesiredMenuItem = new JMenuItem("Clear Undesired");
        this.cmClearUndesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doSetFlags(false, false);
            }
        });
        this.sourceTablePopupMenu.add(this.cmClearUndesiredMenuItem);
        this.cmToggleUndesiredMenuItem = new JMenuItem("Toggle Undesired");
        this.cmToggleUndesiredMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScenarioEditor.this.doToggleFlags(false);
            }
        });
        this.sourceTablePopupMenu.add(this.cmToggleUndesiredMenuItem);
        this.updateControls();
        this.updateDocumentName();
    }

    private void updateControls() {
        int n = this.sourceTable.getSelectedRowCount();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        if (1 == n) {
            int n2 = this.sourceTable.convertRowIndexToModel(this.sourceTable.getSelectedRow());
            Scenario.SourceListItem sourceListItem = this.sourceModel.get(n2);
            SourceEditData sourceEditData = this.sourceModel.getSource(n2);
            SourceEditor sourceEditor = this.sourceEditors.get(sourceEditData.key);
            if (null != sourceEditor) {
                if (sourceEditor.isVisible()) {
                    bl = !sourceEditData.isLocked;
                } else {
                    this.sourceEditors.remove(sourceEditData.key);
                }
            }
            bl2 = sourceEditData.isLocked;
            bl3 = true;
            bl4 = true;
            bl5 = !sourceListItem.isPermanent;
            bl6 = 1 == sourceEditData.recordType && !bl;
            bl7 = sourceEditData.isLocked && !sourceEditData.isReplication();
            bl8 = sourceEditData.isReplication() || !sourceEditData.isLocked && sourceEditData.hasRecordID() && !bl;
            bl9 = !bl;
            bl10 = !bl;
            bl11 = !bl;
            bl12 = true;
            boolean bl14 = bl13 = !sourceEditData.isLocked && !bl;
            if (sourceListItem.isPermanent && (3 == this.studyType || 5 == this.studyType)) {
                bl6 = false;
                if (sourceEditData.isReplication()) {
                    bl8 = false;
                }
            }
        } else {
            bl2 = true;
            bl3 = true;
            if (n > 1) {
                bl5 = true;
                bl9 = true;
                if (n <= 3) {
                    bl10 = true;
                }
                bl11 = true;
                bl12 = true;
            }
        }
        if (3 == this.scenario.scenarioType) {
            bl3 = false;
            bl5 = false;
            bl6 = false;
            bl7 = false;
            bl8 = false;
            bl12 = false;
        } else if (2 == this.scenario.scenarioType) {
            bl3 = false;
            bl5 = false;
            bl12 = false;
        }
        this.addSourceButton.setEnabled(bl3);
        this.addSourcesMenu.setEnabled(bl3);
        this.addSourceMenuItem.setEnabled(bl3);
        this.addSourcesMenuItem.setEnabled(bl3);
        if (null != this.importSourcesMenuItem) {
            this.importSourcesMenuItem.setEnabled(bl3);
        }
        if (null != this.importSourcesMenu) {
            this.importSourcesMenu.setEnabled(bl3);
        }
        if (bl2) {
            this.openSourceButton.setText("View");
            this.openSourceMenuItem.setText("View");
            this.cmOpenSourceMenuItem.setText("View");
        } else {
            this.openSourceButton.setText("Edit");
            this.openSourceMenuItem.setText("Edit");
            this.cmOpenSourceMenuItem.setText("Edit");
        }
        this.openSourceButton.setEnabled(bl4);
        this.openSourceMenuItem.setEnabled(bl4);
        this.cmOpenSourceMenuItem.setEnabled(bl4);
        this.removeSourceButton.setEnabled(bl5);
        this.removeSourceMenuItem.setEnabled(bl5);
        this.cmRemoveSourceMenuItem.setEnabled(bl5);
        this.replicateSourceMenuItem.setEnabled(bl6);
        this.cmReplicateSourceMenuItem.setEnabled(bl6);
        this.unlockSourceMenuItem.setEnabled(bl7);
        this.cmUnlockSourceMenuItem.setEnabled(bl7);
        this.revertSourceMenuItem.setEnabled(bl8);
        this.cmRevertSourceMenuItem.setEnabled(bl8);
        this.copyToScenarioMenuItem.setEnabled(bl9);
        this.compareSourceMenuItem.setEnabled(bl10);
        this.exportSourcesMenuItem.setEnabled(bl11);
        this.saveAsUserRecordMenuItem.setEnabled(bl13);
        this.setDesiredMenuItem.setEnabled(bl12);
        this.cmSetDesiredMenuItem.setEnabled(bl12);
        this.clearDesiredMenuItem.setEnabled(bl12);
        this.cmClearDesiredMenuItem.setEnabled(bl12);
        this.toggleDesiredMenuItem.setEnabled(bl12);
        this.cmToggleDesiredMenuItem.setEnabled(bl12);
        this.setUndesiredMenuItem.setEnabled(bl12);
        this.cmSetUndesiredMenuItem.setEnabled(bl12);
        this.clearUndesiredMenuItem.setEnabled(bl12);
        this.cmClearUndesiredMenuItem.setEnabled(bl12);
        this.toggleUndesiredMenuItem.setEnabled(bl12);
        this.cmToggleUndesiredMenuItem.setEnabled(bl12);
    }

    public void geographyChanged(int n, int n2, Integer n3, int n4) {
        for (SourceEditor sourceEditor : this.sourceEditors.values()) {
            sourceEditor.geographyChanged(n, n2, n3, n4);
        }
    }

    public void geographyScopeChanged(int n, int n2) {
        for (SourceEditor sourceEditor : this.sourceEditors.values()) {
            sourceEditor.geographyScopeChanged(n, n2);
        }
    }

    @Override
    public void setDidEdit() {
        this.parent.setDidEdit();
    }

    @Override
    public String getKeyTitle() {
        Window window = this.parent.getWindow();
        if (window instanceof AppFrame) {
            return ((AppFrame)window).getKeyTitle() + "." + super.getKeyTitle();
        }
        return super.getKeyTitle();
    }

    @Override
    protected String getFileMenuName() {
        return "Station";
    }

    @Override
    public void updateDocumentName() {
        String string = this.parent.getDocumentName();
        if (null == string) {
            this.setDocumentName(this.scenario.name);
        } else {
            this.setDocumentName(string + "/" + this.scenario.name);
        }
        if (null != this.addSourcesDialog) {
            this.addSourcesDialog.updateDocumentName();
        }
        if (null != this.addSourceFinder) {
            this.addSourceFinder.updateDocumentName();
        }
        for (SourceEditor sourceEditor : this.sourceEditors.values()) {
            sourceEditor.updateDocumentName();
        }
    }

    public ScenarioEditData getScenario() {
        return this.scenario;
    }

    public boolean isDataValid(String string) {
        for (SourceEditor sourceEditor : this.sourceEditors.values()) {
            if (!sourceEditor.isVisible() || !sourceEditor.isEditing()) continue;
            AppController.beep();
            this.errorReporter.reportValidationError("Please commit or cancel record edits then re-try the operation");
            sourceEditor.toFront();
            return false;
        }
        return this.commitCurrentField();
    }

    private void doPrevious() {
        int n = this.sourceTable.getRowCount();
        int n2 = this.sourceTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.sourceTable.setRowSelectionInterval(n2, n2);
            this.sourceTable.scrollRectToVisible(this.sourceTable.getCellRect(n2, 0, true));
        }
    }

    private void doNext() {
        int n = this.sourceTable.getRowCount();
        int n2 = this.sourceTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.sourceTable.setRowSelectionInterval(n2, n2);
            this.sourceTable.scrollRectToVisible(this.sourceTable.getCellRect(n2, 0, true));
        }
    }

    private void doAddSource() {
        if (2 == this.scenario.scenarioType || 3 == this.scenario.scenarioType) {
            return;
        }
        if (null != this.addSourceFinder) {
            if (this.addSourceFinder.isVisible()) {
                this.addSourceFinder.toFront();
                return;
            }
            this.addSourceFinder = null;
        }
        RecordFind recordFind = new RecordFind(this, "Add Station", this.studyType, 0);
        recordFind.setDefaultExtDbKey(this.scenario.study.extDbKey);
        recordFind.setAccessoryPanel(new OptionsPanel.AddRecord(this));
        recordFind.setApply(new String[]{"Add"}, new int[]{1}, true, false);
        recordFind.setStudy(this.scenario.study);
        this.addSourceFinder = recordFind;
        AppController.showWindow(recordFind);
    }

    private void updateSearchMenu() {
        this.blockActionsStart();
        ArrayList arrayList = ExtDbSearch.getSearches((String)this.getDbID(), (int)this.studyType);
        this.addSourcesMenu.removeAllItems();
        ExtDbSearch extDbSearch = new ExtDbSearch(0);
        extDbSearch.name = "Add Many...";
        this.addSourcesMenu.addItem(extDbSearch);
        if (1 == this.studyType || 4 == this.studyType || 5 == this.studyType) {
            extDbSearch = new ExtDbSearch(this.studyType);
            extDbSearch.name = "Desireds";
            extDbSearch.searchType = 1;
            this.addSourcesMenu.addItem(extDbSearch);
            extDbSearch = new ExtDbSearch(this.studyType);
            extDbSearch.name = "Protecteds";
            extDbSearch.searchType = 3;
            this.addSourcesMenu.addItem(extDbSearch);
        }
        extDbSearch = new ExtDbSearch(this.studyType);
        extDbSearch.name = "Undesireds";
        extDbSearch.searchType = 2;
        extDbSearch.preferOperating = true;
        this.addSourcesMenu.addItem(extDbSearch);
        for (ExtDbSearch extDbSearch2 : arrayList) {
            this.addSourcesMenu.addItem(extDbSearch2);
        }
        this.blockActionsEnd();
    }

    private void doAddSources(ExtDbSearch extDbSearch) {
        ExtDbSearchDialog extDbSearchDialog;
        if (2 == this.scenario.scenarioType || 3 == this.scenario.scenarioType) {
            return;
        }
        if (null != extDbSearch && extDbSearch.autoRun) {
            extDbSearchDialog = null;
            if (null != this.scenario.study.extDbKey) {
                extDbSearchDialog = ExtDb.getExtDb((String)this.getDbID(), (Integer)this.scenario.study.extDbKey, (ErrorLogger)this.errorReporter);
            } else {
                ArrayList arrayList = ExtDb.getExtDbList((String)this.getDbID(), (int)Study.getDefaultRecordType((int)this.studyType), (ErrorLogger)this.errorReporter);
                if (null != arrayList) {
                    extDbSearchDialog = ExtDb.getExtDb((String)this.getDbID(), (Integer)((KeyedRecord)arrayList.get((int)0)).key, (ErrorLogger)this.errorReporter);
                }
            }
            if (null != extDbSearchDialog) {
                this.runExtDbSearch((ExtDb)extDbSearchDialog, false, extDbSearch, this.errorReporter);
                return;
            }
        }
        if (null != this.addSourcesDialog) {
            if (this.addSourcesDialog.isVisible()) {
                if (null != extDbSearch) {
                    this.addSourcesDialog.setSearch(extDbSearch);
                }
                this.addSourcesDialog.toFront();
                return;
            }
            this.addSourcesDialog = null;
        }
        extDbSearchDialog = new ExtDbSearchDialog((AppEditor)this, this.scenario.study.extDbKey, this.studyType);
        if (null != extDbSearch) {
            extDbSearchDialog.setSearch(extDbSearch);
        }
        this.addSourcesDialog = extDbSearchDialog;
        AppController.showWindow(extDbSearchDialog);
    }

    private boolean runExtDbSearch(ExtDb extDb, boolean bl, ExtDbSearch extDbSearch, ErrorReporter errorReporter) {
        if (extDbSearch.studyType != this.studyType || !Study.isRecordTypeAllowed((int)this.studyType, (int)extDbSearch.recordType) || (1 == extDbSearch.searchType || 3 == extDbSearch.searchType) && 1 != this.studyType && 4 != this.studyType && (5 != this.studyType || 3 != extDbSearch.recordType) || 2 == this.studyType && !extDbSearch.disableMX) {
            errorReporter.reportWarning("Search is not valid in this study, no stations were added");
            return false;
        }
        if (3 == extDbSearch.searchType) {
            if (!this.scenario.sourceData.hasUndesiredSources(extDbSearch.recordType)) {
                errorReporter.reportWarning("The scenario must have at least one undesired station\nbefore a search for protecteds can be performed");
                return false;
            }
        } else if (2 == extDbSearch.searchType) {
            int n = extDbSearch.recordType;
            if (2 == n) {
                n = 1;
            }
            if (!this.scenario.sourceData.hasDesiredSources(n)) {
                errorReporter.reportWarning("The scenario must have at least one desired station\nbefore a search for undesireds can be performed");
                return false;
            }
        }
        if (extDbSearch.disableMX && !extDbSearch.autoRun && 2 != this.studyType) {
            errorReporter.reportWarning("MX checks are disabled, new records will not be marked as undesireds\nRecords that should be undesireds must be identified manually");
        }
        final ExtDb extDb2 = extDb;
        final boolean bl2 = bl;
        final ExtDbSearch extDbSearch2 = extDbSearch;
        BackgroundWorker<Integer> backgroundWorker = new BackgroundWorker<Integer>(errorReporter.getWindow(), errorReporter.getTitle()){

            @Override
            public Integer doBackgroundWork(ErrorLogger errorLogger) {
                int n = ScenarioEditor.this.scenario.addRecords(extDb2, bl2, extDbSearch2, errorLogger);
                if (n < 0) {
                    return null;
                }
                return n;
            }
        };
        errorReporter.clearMessages();
        Integer n = (Integer)backgroundWorker.runWork("Searching for stations, please wait...", errorReporter);
        if (null == n) {
            return false;
        }
        errorReporter.showMessages();
        this.sourceModel.dataWasChanged();
        if (n > 0) {
            this.setDidEdit();
        }
        errorReporter.reportMessage(n.toString() + " records were added");
        return true;
    }

    private void doImportSources(int n) {
        if (2 == this.scenario.scenarioType || 3 == this.scenario.scenarioType) {
            return;
        }
        String string = "Import " + Source.getRecordTypeName((int)n) + " Records";
        this.errorReporter.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Text (*.csv,*.txt,*.dat)", "csv", "txt", "dat"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        JCheckBox jCheckBox = new JCheckBox("Separate pattern file");
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createTitledBorder("Text options"));
        jPanel.add(jCheckBox);
        JCheckBox jCheckBox2 = null;
        if (2 != this.studyType && 3 != this.studyType && 2 != n && (5 != this.studyType || 1 != n)) {
            jCheckBox2 = new JCheckBox("Desired");
        }
        JCheckBox jCheckBox3 = new JCheckBox("Undesired");
        Box box = Box.createVerticalBox();
        if (null != jCheckBox2) {
            box.add(jCheckBox2);
        }
        box.add(jCheckBox3);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Scenario flags"));
        jPanel2.add(box);
        Box box2 = Box.createVerticalBox();
        box2.add(jPanel);
        box2.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(box2);
        jFileChooser.setAccessory(jPanel3);
        if (0 != jFileChooser.showDialog(this, "Import")) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        boolean bl = false;
        if (null != jCheckBox2) {
            bl = jCheckBox2.isSelected();
        }
        boolean bl2 = jCheckBox3.isSelected();
        final int n2 = n;
        final File file2 = file;
        file = null;
        if (jCheckBox.isSelected()) {
            jFileChooser = new JFileChooser(file2.getParentFile().getAbsolutePath());
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle("Choose pattern data file");
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Text (*.csv,*.txt,*.dat)", "csv", "txt", "dat"));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            if (0 != jFileChooser.showDialog(this, "Import")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        }
        final File file3 = file;
        BackgroundWorker<ArrayList<SourceEditData>> backgroundWorker = new BackgroundWorker<ArrayList<SourceEditData>>((Window)this, string){

            @Override
            protected ArrayList<SourceEditData> doBackgroundWork(ErrorLogger errorLogger) {
                return SourceEditData.readFromText((StudyEditData)((ScenarioEditor)ScenarioEditor.this).scenario.study, (int)n2, (File)file2, (File)file3, (ErrorLogger)errorLogger);
            }
        };
        this.errorReporter.clearMessages();
        ArrayList arrayList = (ArrayList)backgroundWorker.runWork("Importing records, please wait...", this.errorReporter);
        if (null == arrayList) {
            return;
        }
        this.errorReporter.showMessages();
        int n3 = 0;
        int n4 = this.scenario.study.getMinimumChannel();
        int n5 = this.scenario.study.getMaximumChannel();
        for (SourceEditData sourceEditData : arrayList) {
            int n6;
            if (1 == sourceEditData.recordType && ((n6 = ((SourceEditDataTV)sourceEditData).channel) < n4 || n6 > n5)) continue;
            this.scenario.sourceData.addOrReplace(sourceEditData, bl, bl2);
            ++n3;
        }
        if (n3 > 0) {
            this.sourceModel.dataWasChanged();
            this.setDidEdit();
        }
        this.errorReporter.reportMessage(String.valueOf(n3) + " records were added");
    }

    private void doOpenSource() {
        if (this.sourceTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.sourceTable.convertRowIndexToModel(this.sourceTable.getSelectedRow());
        SourceEditData sourceEditData = this.sourceModel.getSource(n);
        SourceEditor sourceEditor = this.sourceEditors.get(sourceEditData.key);
        if (null != sourceEditor) {
            if (sourceEditor.isVisible()) {
                sourceEditor.toFront();
                return;
            }
            this.sourceEditors.remove(sourceEditData.key);
        }
        Scenario.SourceListItem sourceListItem = this.sourceModel.get(n);
        sourceEditor = new SourceEditor(this);
        sourceEditor.setSource(sourceEditData, sourceListItem.isPermanent);
        AppController.showWindow(sourceEditor);
        this.sourceEditors.put(sourceEditData.key, sourceEditor);
        this.updateControls();
    }

    private void doRemoveSource() {
        int n;
        if (2 == this.scenario.scenarioType || 3 == this.scenario.scenarioType) {
            return;
        }
        if (0 == this.sourceTable.getSelectedRowCount()) {
            return;
        }
        int[] nArray = this.sourceTable.getSelectedRows();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = false;
        for (n = 0; n < nArray.length; ++n) {
            int n2 = this.sourceTable.convertRowIndexToModel(nArray[n]);
            Scenario.SourceListItem sourceListItem = this.sourceModel.get(n2);
            if (sourceListItem.isPermanent) {
                bl = true;
                continue;
            }
            SourceEditor sourceEditor = this.sourceEditors.get(sourceListItem.key);
            if (null != sourceEditor) {
                if (sourceEditor.isVisible()) {
                    if (!sourceEditor.cancel()) {
                        AppController.beep();
                        sourceEditor.toFront();
                        return;
                    }
                } else {
                    this.sourceEditors.remove(sourceListItem.key);
                }
            }
            arrayList.add(n2);
        }
        if (bl) {
            this.errorReporter.reportMessage("Remove Stations", "Some records are permanent and cannot be removed");
        }
        if (arrayList.isEmpty()) {
            return;
        }
        int[] nArray2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray2[n] = (Integer)arrayList.get(n);
        }
        if (this.sourceModel.remove(nArray2)) {
            this.setDidEdit();
        }
        this.updateControls();
    }

    private void doUnlockSource() {
        if (3 == this.scenario.scenarioType) {
            return;
        }
        if (this.sourceTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.sourceTable.convertRowIndexToModel(this.sourceTable.getSelectedRow());
        SourceEditData sourceEditData = this.sourceModel.getSource(n);
        if (!sourceEditData.isLocked || sourceEditData.isReplication()) {
            return;
        }
        SourceEditor sourceEditor = this.sourceEditors.get(sourceEditData.key);
        if (null != sourceEditor) {
            if (sourceEditor.isVisible()) {
                if (!sourceEditor.cancel()) {
                    AppController.beep();
                    sourceEditor.toFront();
                    return;
                }
            } else {
                this.sourceEditors.remove(sourceEditData.key);
            }
        }
        this.errorReporter.setTitle("Allow Editing");
        SourceEditData sourceEditData2 = sourceEditData.deriveSource(false, (ErrorLogger)this.errorReporter);
        if (null == sourceEditData2) {
            return;
        }
        this.sourceModel.set(n, sourceEditData2);
        this.setDidEdit();
        this.doOpenSource();
    }

    private void doReplicateSource() {
        if (3 == this.scenario.scenarioType) {
            return;
        }
        if (this.sourceTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.sourceTable.convertRowIndexToModel(this.sourceTable.getSelectedRow());
        SourceEditData sourceEditData = this.sourceModel.getSource(n);
        if (1 != sourceEditData.recordType) {
            return;
        }
        SourceEditDataTV sourceEditDataTV = (SourceEditDataTV)sourceEditData;
        SourceEditor sourceEditor = this.sourceEditors.get(sourceEditData.key);
        if (null != sourceEditor) {
            if (sourceEditor.isVisible()) {
                if (!sourceEditData.isLocked || !sourceEditor.cancel()) {
                    AppController.beep();
                    sourceEditor.toFront();
                    return;
                }
            } else {
                this.sourceEditors.remove(sourceEditData.key);
            }
        }
        Scenario.SourceListItem sourceListItem = this.sourceModel.get(n);
        if (sourceListItem.isPermanent && (3 == this.studyType || 5 == this.studyType)) {
            return;
        }
        String string = "Replicate";
        this.errorReporter.setTitle(string);
        SourceEditDataTV sourceEditDataTV2 = sourceEditDataTV;
        if (null != sourceEditDataTV.originalSourceKey) {
            SourceEditData sourceEditData2 = this.scenario.study.getSource(sourceEditDataTV.originalSourceKey);
            if (null == sourceEditData2 || 1 != sourceEditData2.recordType) {
                this.errorReporter.reportError("The original record for replication does not exist");
                return;
            }
            sourceEditDataTV2 = (SourceEditDataTV)sourceEditData2;
        }
        int n2 = 0;
        int n3 = this.scenario.study.getMinimumChannel();
        int n4 = this.scenario.study.getMaximumChannel();
        do {
            String string2;
            if (null == (string2 = JOptionPane.showInputDialog(this, "Enter the replication channel", string, 3))) {
                return;
            }
            if ((string2 = string2.trim()).length() <= 0) continue;
            try {
                n2 = Integer.parseInt(string2);
                if (n2 < n3 || n2 > n4) {
                    this.errorReporter.reportWarning("The channel must be in the range " + n3 + " to " + n4);
                    n2 = 0;
                    continue;
                }
                if (!sourceEditDataTV2.service.serviceType.digital || n2 != sourceEditDataTV2.channel) continue;
                this.errorReporter.reportWarning("The channel must be different than the original");
                n2 = 0;
            }
            catch (NumberFormatException numberFormatException) {
                this.errorReporter.reportWarning("The channel must be a number");
                n2 = 0;
            }
        } while (false == n2);
        if (null != sourceEditDataTV.originalSourceKey && n2 == sourceEditDataTV.channel) {
            return;
        }
        this.errorReporter.clearMessages();
        SourceEditDataTV sourceEditDataTV3 = null;
        if (sourceEditDataTV2.isLocked) {
            if (null != sourceEditDataTV2.userRecordID) {
                sourceEditDataTV3 = this.scenario.study.findSharedReplicationSource(sourceEditDataTV2.userRecordID, n2);
            } else if (null != sourceEditDataTV2.extDbKey && null != sourceEditDataTV2.extRecordID) {
                sourceEditDataTV3 = this.scenario.study.findSharedReplicationSource(sourceEditDataTV2.extDbKey, sourceEditDataTV2.extRecordID, n2);
            }
        }
        if (null == sourceEditDataTV3 && null == (sourceEditDataTV3 = sourceEditDataTV2.replicate(n2, (ErrorLogger)this.errorReporter))) {
            return;
        }
        String string3 = sourceEditDataTV3.getSortChannel();
        for (SourceEditData sourceEditData3 : this.scenario.sourceData.getSources()) {
            if ((null == sourceEditDataTV3.userRecordID || !sourceEditDataTV3.userRecordID.equals(sourceEditData3.userRecordID)) && (null == sourceEditDataTV3.extDbKey || !sourceEditDataTV3.extDbKey.equals(sourceEditData3.extDbKey) || null == sourceEditDataTV3.extRecordID || !sourceEditDataTV3.extRecordID.equals(sourceEditData3.extRecordID)) || !string3.equals(sourceEditData3.getSortChannel())) continue;
            this.errorReporter.reportWarning("The original record is already replicated on that channel in the scenario");
            return;
        }
        this.errorReporter.showMessages();
        this.sourceModel.set(n, (SourceEditData)sourceEditDataTV3);
        this.setDidEdit();
        this.updateControls();
    }

    private void doRevertSource() {
        if (3 == this.scenario.scenarioType) {
            return;
        }
        if (this.sourceTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.sourceTable.convertRowIndexToModel(this.sourceTable.getSelectedRow());
        Scenario.SourceListItem sourceListItem = this.sourceModel.get(n);
        SourceEditData sourceEditData = this.sourceModel.getSource(n);
        SourceEditor sourceEditor = this.sourceEditors.get(sourceEditData.key);
        if (null != sourceEditor) {
            if (sourceEditor.isVisible()) {
                if (!sourceEditor.cancel()) {
                    AppController.beep();
                    sourceEditor.toFront();
                    return;
                }
            } else {
                this.sourceEditors.remove(sourceEditData.key);
            }
        }
        String string = "Revert";
        this.errorReporter.setTitle(string);
        SourceEditData sourceEditData2 = null;
        this.errorReporter.clearErrors();
        if (sourceEditData.isReplication()) {
            if (sourceListItem.isPermanent && (3 == this.studyType || 5 == this.studyType)) {
                return;
            }
            sourceEditData2 = this.scenario.study.getSource(((SourceEditDataTV)sourceEditData).originalSourceKey);
            if (null == sourceEditData2) {
                this.errorReporter.reportError("The original pre-replication record does not exist");
                return;
            }
            int n2 = ((SourceEditDataTV)sourceEditData2).channel;
            if (n2 < this.scenario.study.getMinimumChannel() || n2 > this.scenario.study.getMaximumChannel()) {
                this.errorReporter.reportWarning("Replication cannot be reverted, the original channel is out of range for the study");
                return;
            }
            String string2 = sourceEditData2.getSortChannel();
            for (SourceEditData sourceEditData3 : this.scenario.sourceData.getSources()) {
                if ((null == sourceEditData2.userRecordID || !sourceEditData2.userRecordID.equals(sourceEditData3.userRecordID)) && (null == sourceEditData2.extDbKey || !sourceEditData2.extDbKey.equals(sourceEditData3.extDbKey) || null == sourceEditData2.extRecordID || !sourceEditData2.extRecordID.equals(sourceEditData3.extRecordID)) || !string2.equals(sourceEditData3.getSortChannel())) continue;
                this.errorReporter.reportWarning("Replication cannot be reverted, the original record is already in the scenario");
                return;
            }
        } else {
            if (sourceEditData.isLocked || !sourceEditData.hasRecordID()) {
                return;
            }
            if (null != sourceEditData.userRecordID) {
                sourceEditData2 = this.scenario.study.findSharedSource(sourceEditData.userRecordID);
                if (null == sourceEditData2) {
                    sourceEditData2 = SourceEditData.findUserRecord((String)this.getDbID(), (StudyEditData)this.scenario.study, (Integer)sourceEditData.userRecordID, (ErrorLogger)this.errorReporter);
                    if (null == sourceEditData2) {
                        if (!this.errorReporter.hasErrors()) {
                            this.errorReporter.reportError("The original user record does not exist");
                        }
                        return;
                    }
                    sourceEditData2.copyTransientAttributes(sourceEditData);
                }
            } else {
                sourceEditData2 = this.scenario.study.findSharedSource(sourceEditData.extDbKey, sourceEditData.extRecordID);
                if (null == sourceEditData2) {
                    ExtDb extDb = ExtDb.getExtDb((String)this.getDbID(), (Integer)sourceEditData.extDbKey, (ErrorLogger)this.errorReporter);
                    if (null == extDb) {
                        return;
                    }
                    if (extDb.isGeneric()) {
                        sourceEditData2 = SourceEditData.findImportRecord((ExtDb)extDb, (int)sourceEditData.recordType, (StudyEditData)this.scenario.study, (String)sourceEditData.extRecordID, (ErrorLogger)this.errorReporter);
                        if (null == sourceEditData2) {
                            if (!this.errorReporter.hasErrors()) {
                                this.errorReporter.reportError("The original station data record does not exist");
                            }
                            return;
                        }
                    } else {
                        ExtDbRecordTV extDbRecordTV = null;
                        switch (sourceEditData.recordType) {
                            case 1: {
                                extDbRecordTV = ExtDbRecordTV.findRecordTV((ExtDb)extDb, (String)sourceEditData.extRecordID, (ErrorLogger)this.errorReporter);
                                break;
                            }
                            case 3: {
                                extDbRecordTV = ExtDbRecordFM.findRecordFM((ExtDb)extDb, (String)sourceEditData.extRecordID, (ErrorLogger)this.errorReporter);
                            }
                        }
                        if (null == extDbRecordTV) {
                            if (!this.errorReporter.hasErrors()) {
                                this.errorReporter.reportError("The original station data record does not exist");
                            }
                            return;
                        }
                        sourceEditData2 = SourceEditData.makeSource((ExtDbRecord)extDbRecordTV, (StudyEditData)this.scenario.study, (boolean)true, (ErrorLogger)this.errorReporter);
                    }
                    sourceEditData2.copyTransientAttributes(sourceEditData);
                }
            }
            if (sourceListItem.isPermanent && (3 == this.studyType || 5 == this.studyType) && ((SourceEditDataTV)sourceEditData2).channel != ((SourceEditDataTV)sourceEditData).channel) {
                this.errorReporter.reportWarning("The record cannot be reverted, the original has a different channel");
                return;
            }
        }
        if (this.scenario.sourceData.indexOfSourceKey(sourceEditData2.key) >= 0) {
            this.errorReporter.reportWarning("The record cannot be reverted, the original is already in the scenario");
            return;
        }
        this.sourceModel.set(n, sourceEditData2);
        this.setDidEdit();
        this.updateControls();
    }

    private void doCopyToScenario() {
        int n;
        int n2;
        int n3;
        if (0 == this.sourceTable.getSelectedRowCount()) {
            return;
        }
        String string = "Copy To Scenario";
        this.errorReporter.setTitle(string);
        ArrayList<KeyedRecord> arrayList = new ArrayList<KeyedRecord>();
        for (n3 = 0; n3 < this.scenario.study.scenarioData.getRowCount(); ++n3) {
            ScenarioEditData scenarioEditData = this.scenario.study.scenarioData.get(n3);
            if (this.scenario.key.equals(scenarioEditData.key) || 2 == scenarioEditData.scenarioType || 3 == scenarioEditData.scenarioType) continue;
            arrayList.add(new KeyedRecord(n3, scenarioEditData.name));
        }
        if (arrayList.isEmpty()) {
            this.errorReporter.reportWarning("No other scenarios are available for the copy");
            return;
        }
        class PromptDialog
        extends AppDialog {
            private KeyedRecordMenu scenarioMenu;
            private JCheckBox disableMXCheckBox;
            private JCheckBox mxFacilityIDOnlyCheckBox;
            private boolean canceled;

            PromptDialog(ArrayList<KeyedRecord> arrayList) {
                super(ScenarioEditor.this.outerThis, "Copy To Scenario", Dialog.ModalityType.APPLICATION_MODAL);
                this.scenarioMenu = new KeyedRecordMenu(arrayList);
                JPanel jPanel = new JPanel(new FlowLayout(0));
                jPanel.setBorder(BorderFactory.createTitledBorder("Copy To"));
                jPanel.add(this.scenarioMenu);
                this.disableMXCheckBox = new JCheckBox("Disable all MX checks");
                JPanel jPanel2 = new JPanel(new FlowLayout(0));
                jPanel2.add(this.disableMXCheckBox);
                this.mxFacilityIDOnlyCheckBox = new JCheckBox("Use only facility ID for MX check");
                JPanel jPanel3 = new JPanel(new FlowLayout(0));
                jPanel3.add(this.mxFacilityIDOnlyCheckBox);
                if (2 == ScenarioEditor.this.studyType) {
                    this.disableMXCheckBox.setSelected(true);
                    AppController.setComponentEnabled(this.disableMXCheckBox, false);
                    AppController.setComponentEnabled(this.mxFacilityIDOnlyCheckBox, false);
                } else {
                    this.disableMXCheckBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (this.blockActions()) {
                                if (disableMXCheckBox.isSelected()) {
                                    mxFacilityIDOnlyCheckBox.setSelected(false);
                                    AppController.setComponentEnabled(mxFacilityIDOnlyCheckBox, false);
                                } else {
                                    AppController.setComponentEnabled(mxFacilityIDOnlyCheckBox, true);
                                }
                                this.blockActionsEnd();
                            }
                        }
                    });
                }
                JButton jButton = new JButton("OK");
                jButton.setFocusable(false);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doOK();
                    }
                });
                JButton jButton2 = new JButton("Cancel");
                jButton2.setFocusable(false);
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doCancel();
                    }
                });
                Box box = Box.createVerticalBox();
                box.add(jPanel);
                box.add(jPanel2);
                box.add(jPanel3);
                this.add((Component)box, "Center");
                JPanel jPanel4 = new JPanel(new FlowLayout(2));
                jPanel4.add(jButton2);
                jPanel4.add(jButton);
                this.add((Component)jPanel4, "South");
                this.getRootPane().setDefaultButton(jButton);
                this.pack();
                this.setMinimumSize(this.getSize());
                this.setLocationRelativeTo(ScenarioEditor.this.outerThis);
            }

            private void doOK() {
                AppController.hideWindow(this);
            }

            private void doCancel() {
                this.canceled = true;
                AppController.hideWindow(this);
            }

            @Override
            public void windowWillOpen() {
                this.blockActionsClear();
            }

            @Override
            public boolean windowShouldClose() {
                this.canceled = true;
                return true;
            }

            @Override
            public void windowWillClose() {
                this.blockActionsSet();
            }
        }
        PromptDialog promptDialog = new PromptDialog(arrayList);
        AppController.showWindow(promptDialog);
        if (promptDialog.canceled) {
            return;
        }
        ScenarioEditData scenarioEditData = null;
        boolean bl = false;
        boolean bl2 = false;
        n3 = promptDialog.scenarioMenu.getSelectedKey();
        if (n3 < 0) {
            this.errorReporter.reportError("Invalid scenario selection");
            return;
        }
        scenarioEditData = this.scenario.study.scenarioData.get(n3);
        if (2 == this.studyType) {
            bl = true;
        } else {
            bl = promptDialog.disableMXCheckBox.isSelected();
            if (!bl) {
                bl2 = promptDialog.mxFacilityIDOnlyCheckBox.isSelected();
            }
            if (bl) {
                this.errorReporter.reportWarning("MX checks are disabled, copied records will not be marked as undesireds\nRecords that should be undesireds must be identified manually");
            }
        }
        class CopyItem {
            SourceEditData source;
            SourceEditData originalSource;
            boolean isDesired;
            boolean isUndesired;

            CopyItem() {
            }
        }
        ArrayList<CopyItem> arrayList2 = new ArrayList<CopyItem>();
        ArrayList arrayList3 = scenarioEditData.sourceData.getSources();
        double d = this.scenario.study.getCoChannelMxDistance();
        double d2 = this.scenario.study.getKilometersPerDegree();
        int[] nArray = this.sourceTable.getSelectedRows();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n3 = this.sourceTable.convertRowIndexToModel(nArray[n2]);
            CopyItem copyItem = new CopyItem();
            copyItem.source = this.sourceModel.getSource(n3);
            Scenario.SourceListItem sourceListItem = this.sourceModel.get(n3);
            copyItem.isDesired = 2 == this.studyType || 3 == this.studyType || 5 == this.studyType && 1 == copyItem.source.recordType || 2 == copyItem.source.recordType ? false : sourceListItem.isDesired;
            copyItem.isUndesired = 2 == this.studyType ? true : (bl ? false : sourceListItem.isUndesired);
            if (!copyItem.source.isLocked) {
                SourceEditor sourceEditor = this.sourceEditors.get(copyItem.source.key);
                if (null != sourceEditor) {
                    if (sourceEditor.isVisible()) {
                        AppController.beep();
                        this.errorReporter.reportWarning("Please commit or cancel record edits then re-try the operation");
                        sourceEditor.toFront();
                        return;
                    }
                    this.sourceEditors.remove(copyItem.source.key);
                }
                copyItem.source = copyItem.source.deriveSource(false, (ErrorLogger)this.errorReporter);
            }
            block0 : switch (copyItem.source.recordType) {
                case 1: {
                    SourceEditDataTV sourceEditDataTV;
                    SourceEditDataTV sourceEditDataTV2 = (SourceEditDataTV)copyItem.source;
                    if (sourceEditDataTV2.isReplication() && null != (sourceEditDataTV = (SourceEditDataTV)this.scenario.study.getSource(sourceEditDataTV2.originalSourceKey)) && !sourceEditDataTV.isLocked) {
                        if (null == (sourceEditDataTV = (SourceEditDataTV)sourceEditDataTV.deriveSource(false, (ErrorLogger)this.errorReporter))) {
                            return;
                        }
                        sourceEditDataTV2 = sourceEditDataTV.replicate(sourceEditDataTV2.channel, (ErrorLogger)this.errorReporter);
                        if (null == sourceEditDataTV2) {
                            return;
                        }
                        copyItem.source = sourceEditDataTV2;
                        copyItem.originalSource = sourceEditDataTV;
                    }
                    for (SourceEditData sourceEditData : arrayList3) {
                        if (1 != sourceEditData.recordType) continue;
                        if (copyItem.source.key.equals(sourceEditData.key)) {
                            copyItem = null;
                            break block0;
                        }
                        if (bl || !ExtDbRecordTV.areRecordsMX((SourceEditDataTV)sourceEditDataTV2, (SourceEditDataTV)((SourceEditDataTV)sourceEditData), (boolean)bl2, (double)d, (double)d2)) continue;
                        copyItem = null;
                        break block0;
                    }
                    break;
                }
                case 3: {
                    for (SourceEditData sourceEditData : arrayList3) {
                        if (3 != sourceEditData.recordType) continue;
                        if (copyItem.source.key.equals(sourceEditData.key)) {
                            copyItem = null;
                            break block0;
                        }
                        if (bl || !ExtDbRecordFM.areRecordsMX((SourceEditDataFM)((SourceEditDataFM)copyItem.source), (SourceEditDataFM)((SourceEditDataFM)sourceEditData), (boolean)bl2, (double)d, (double)d2)) continue;
                        copyItem = null;
                        break block0;
                    }
                    break;
                }
                case 2: {
                    for (SourceEditData sourceEditData : arrayList3) {
                        if (2 != sourceEditData.recordType || !copyItem.source.key.equals(sourceEditData.key)) continue;
                        copyItem = null;
                        break block0;
                    }
                    break;
                }
            }
            if (null == copyItem) continue;
            arrayList2.add(copyItem);
        }
        if (!arrayList2.isEmpty()) {
            for (CopyItem copyItem : arrayList2) {
                if (null != copyItem.originalSource) {
                    scenarioEditData.study.addOrReplaceSource(copyItem.originalSource);
                }
                scenarioEditData.sourceData.addOrReplace(copyItem.source, copyItem.isDesired, copyItem.isUndesired);
            }
            this.setDidEdit();
            ScenarioEditor scenarioEditor = (ScenarioEditor)this.parent.getEditorFor(scenarioEditData);
            if (null != scenarioEditor) {
                scenarioEditor.sourceModel.dataWasChanged();
            }
        }
        if ((n = nArray.length - (n2 = arrayList2.size())) > 0) {
            this.errorReporter.reportMessage(String.valueOf(n2) + " records copied,\n" + String.valueOf(n) + " MX records not copied");
        } else {
            this.errorReporter.reportMessage(String.valueOf(n2) + " records copied");
        }
    }

    private void doCompareSource() {
        if (0 == this.sourceTable.getSelectedRowCount()) {
            return;
        }
        this.errorReporter.setTitle("Compare Records");
        int[] nArray = this.sourceTable.getSelectedRows();
        for (int i = 0; i < nArray.length && i < 3; ++i) {
            if (SourceCompare.compare(this.sourceModel.getSource(this.sourceTable.convertRowIndexToModel(nArray[i])), this.errorReporter)) continue;
            return;
        }
    }

    private void doExportSources() {
        if (this.sourceTable.getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<SourceEditData> arrayList = new ArrayList<SourceEditData>();
        int n = 0;
        for (int string : this.sourceTable.getSelectedRows()) {
            SourceEditor sourceEditor;
            SourceEditData sourceEditData = this.sourceModel.getSource(this.sourceTable.convertRowIndexToModel(string));
            if (!sourceEditData.isLocked && null != (sourceEditor = this.sourceEditors.get(sourceEditData.key))) {
                if (sourceEditor.isVisible()) {
                    AppController.beep();
                    sourceEditor.toFront();
                    return;
                }
                this.sourceEditors.remove(sourceEditData.key);
            }
            if (0 == n) {
                n = sourceEditData.recordType;
            } else if (n != sourceEditData.recordType) {
                this.errorReporter.reportWarning("All selected records must be the same type");
                return;
            }
            arrayList.add(sourceEditData);
        }
        String string = "Export " + Source.getRecordTypeName((int)n) + " Records";
        this.errorReporter.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("CSV (*.csv)", "csv"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File file = null;
        do {
            if (0 != jFileChooser.showDialog(this, "Export")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            String string2 = file.getName();
            if (!string2.toLowerCase().endsWith(".csv")) {
                file = new File(file.getAbsolutePath() + ".csv");
            }
            if (!file.exists()) continue;
            AppController.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return;
        }
        try {
            SourceEditData.writeToCSV((BufferedWriter)bufferedWriter, (int)n, arrayList, (ErrorLogger)this.errorReporter);
        }
        catch (IOException iOException) {
            this.errorReporter.reportError(iOException.toString());
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doSaveAsUserRecord() {
        if (this.sourceTable.getSelectedRowCount() != 1) {
            return;
        }
        int n = this.sourceTable.convertRowIndexToModel(this.sourceTable.getSelectedRow());
        SourceEditData sourceEditData = this.sourceModel.getSource(n);
        if (sourceEditData.isLocked) {
            return;
        }
        SourceEditor sourceEditor = this.sourceEditors.get(sourceEditData.key);
        if (null != sourceEditor) {
            if (sourceEditor.isVisible()) {
                sourceEditor.toFront();
                return;
            }
            this.sourceEditors.remove(sourceEditData.key);
        }
        String string = "Save As User Record";
        this.errorReporter.setTitle(string);
        TextInputDialog textInputDialog = new TextInputDialog((AppEditor)this.outerThis, string, "Comment");
        JCheckBox jCheckBox = new JCheckBox("Replace record in scenario");
        textInputDialog.add((Component)jCheckBox, "North");
        textInputDialog.pack();
        AppController.showWindow(textInputDialog);
        if (textInputDialog.canceled) {
            return;
        }
        SourceEditData sourceEditData2 = sourceEditData.saveAsUserRecord(this.scenario.study, (ErrorLogger)this.errorReporter);
        if (null == sourceEditData2) {
            return;
        }
        String string2 = textInputDialog.getInput();
        if (string2.length() > 0) {
            SourceEditData.setSourceComment((SourceEditData)sourceEditData2, (String)string2);
        } else {
            string2 = null;
        }
        if (jCheckBox.isSelected()) {
            this.sourceModel.set(n, sourceEditData2);
            this.setDidEdit();
        } else {
            this.errorReporter.reportMessage("Saved as user record " + String.valueOf(sourceEditData2.userRecordID));
        }
    }

    private void doSetFlags(boolean bl, boolean bl2) {
        if (2 == this.scenario.scenarioType || 3 == this.scenario.scenarioType) {
            return;
        }
        if (0 == this.sourceTable.getSelectedRowCount()) {
            return;
        }
        for (int n : this.sourceTable.getSelectedRows()) {
            if (bl) {
                if (!this.sourceModel.setIsDesired(this.sourceTable.convertRowIndexToModel(n), bl2)) continue;
                this.setDidEdit();
                continue;
            }
            if (!this.sourceModel.setIsUndesired(this.sourceTable.convertRowIndexToModel(n), bl2)) continue;
            this.setDidEdit();
        }
    }

    private void doToggleFlags(boolean bl) {
        if (2 == this.scenario.scenarioType || 3 == this.scenario.scenarioType) {
            return;
        }
        if (0 == this.sourceTable.getSelectedRowCount()) {
            return;
        }
        for (int n : this.sourceTable.getSelectedRows()) {
            int n2 = this.sourceTable.convertRowIndexToModel(n);
            Scenario.SourceListItem sourceListItem = this.sourceModel.get(n2);
            if (bl) {
                if (!this.sourceModel.setIsDesired(n2, !sourceListItem.isDesired)) continue;
                this.setDidEdit();
                continue;
            }
            if (!this.sourceModel.setIsUndesired(n2, !sourceListItem.isUndesired)) continue;
            this.setDidEdit();
        }
    }

    @Override
    public boolean applyEditsFrom(AppEditor appEditor) {
        if (appEditor instanceof ExtDbSearchDialog) {
            if ((ExtDbSearchDialog)appEditor != this.addSourcesDialog) {
                return false;
            }
            return this.runExtDbSearch(this.addSourcesDialog.extDb, this.addSourcesDialog.useBaseline, this.addSourcesDialog.search, this.addSourcesDialog.getErrorReporter());
        }
        if (appEditor instanceof RecordFind) {
            int n;
            boolean bl;
            int n2;
            if ((RecordFind)appEditor != this.addSourceFinder) {
                return false;
            }
            ErrorReporter errorReporter = this.addSourceFinder.getErrorReporter();
            OptionsPanel optionsPanel = (OptionsPanel)this.addSourceFinder.getAccessoryPanel();
            SourceEditData sourceEditData = this.addSourceFinder.source;
            ExtDbRecord extDbRecord = this.addSourceFinder.record;
            int n3 = 0;
            if (null != sourceEditData) {
                n3 = sourceEditData.recordType;
            } else if (null != extDbRecord) {
                n3 = extDbRecord.recordType;
            }
            if (!Study.isRecordTypeAllowed((int)this.studyType, (int)n3)) {
                errorReporter.reportError("That record type is not allowed here");
                return false;
            }
            boolean bl2 = false;
            boolean bl3 = false;
            int n4 = 0;
            if (1 == n3) {
                bl2 = optionsPanel.replicate;
                bl3 = optionsPanel.changeChannel;
                if (bl2 || bl3) {
                    n4 = optionsPanel.studyChannel;
                } else if (null != sourceEditData) {
                    n4 = ((SourceEditDataTV)sourceEditData).channel;
                } else {
                    n4 = ((ExtDbRecordTV)extDbRecord).replicateToChannel;
                    if (0 == n4) {
                        n4 = ((ExtDbRecordTV)extDbRecord).channel;
                    } else {
                        bl2 = true;
                    }
                }
                int n5 = this.scenario.study.getMinimumChannel();
                int n6 = this.scenario.study.getMaximumChannel();
                if (n4 < n5 || n4 > n6) {
                    errorReporter.reportWarning("A TV record must have a channel in the range " + n5 + " to " + n6);
                    return false;
                }
            }
            SourceEditData sourceEditData2 = null;
            SourceEditDataTV sourceEditDataTV = null;
            boolean bl4 = true;
            boolean bl5 = true;
            errorReporter.clearErrors();
            errorReporter.clearMessages();
            if (null != sourceEditData) {
                bl4 = sourceEditData.isLocked;
                boolean bl6 = bl5 = bl4 && optionsPanel.isLocked;
                if (bl5) {
                    if (null != sourceEditData.extDbKey && null != sourceEditData.extRecordID) {
                        sourceEditData2 = this.scenario.study.findSharedSource(sourceEditData.extDbKey, sourceEditData.extRecordID);
                    } else if (null != sourceEditData.userRecordID) {
                        sourceEditData2 = this.scenario.study.findSharedSource(sourceEditData.userRecordID);
                    }
                }
                if (null == sourceEditData2) {
                    sourceEditData2 = sourceEditData.deriveSource(this.scenario.study, bl5, (ErrorLogger)errorReporter);
                }
                if (null != sourceEditData2) {
                    if (bl2) {
                        sourceEditDataTV = (SourceEditDataTV)sourceEditData2;
                        sourceEditData2 = null;
                        if (bl5) {
                            if (null != sourceEditDataTV.extDbKey && null != sourceEditDataTV.extRecordID) {
                                sourceEditData2 = this.scenario.study.findSharedReplicationSource(sourceEditDataTV.extDbKey, sourceEditDataTV.extRecordID, n4);
                            } else if (null != sourceEditDataTV.userRecordID) {
                                sourceEditData2 = this.scenario.study.findSharedReplicationSource(sourceEditDataTV.userRecordID, n4);
                            }
                        }
                        if (null == sourceEditData2) {
                            sourceEditData2 = sourceEditDataTV.replicate(n4, (ErrorLogger)errorReporter);
                        } else {
                            sourceEditDataTV = null;
                        }
                    } else if (bl3) {
                        if (bl5) {
                            sourceEditDataTV = (SourceEditDataTV)sourceEditData2;
                            sourceEditData2 = sourceEditDataTV.deriveSource(this.scenario.study, false, (ErrorLogger)errorReporter);
                        }
                        if (null != sourceEditData2) {
                            ((SourceEditDataTV)sourceEditData2).channel = n4;
                        }
                    }
                }
            } else if (null != extDbRecord) {
                bl5 = optionsPanel.isLocked;
                if (bl5) {
                    sourceEditData2 = this.scenario.study.findSharedSource(extDbRecord.extDb.key, extDbRecord.extRecordID);
                }
                if (null == sourceEditData2) {
                    sourceEditData2 = SourceEditData.makeSource((ExtDbRecord)extDbRecord, (StudyEditData)this.scenario.study, (boolean)bl5, (ErrorLogger)errorReporter);
                }
                if (null != sourceEditData2) {
                    if (bl2) {
                        sourceEditDataTV = (SourceEditDataTV)sourceEditData2;
                        sourceEditData2 = null;
                        if (bl5) {
                            sourceEditData2 = this.scenario.study.findSharedReplicationSource(sourceEditDataTV.extDbKey, sourceEditDataTV.extRecordID, n4);
                        }
                        if (null == sourceEditData2) {
                            sourceEditData2 = sourceEditDataTV.replicate(n4, (ErrorLogger)errorReporter);
                        } else {
                            sourceEditDataTV = null;
                        }
                    } else if (bl3) {
                        if (bl5) {
                            sourceEditDataTV = (SourceEditDataTV)sourceEditData2;
                            sourceEditData2 = sourceEditDataTV.deriveSource(this.scenario.study, false, (ErrorLogger)errorReporter);
                        }
                        if (null != sourceEditData2) {
                            ((SourceEditDataTV)sourceEditData2).channel = n4;
                        }
                    }
                }
            }
            if (null == sourceEditData2) {
                if (!errorReporter.hasErrors()) {
                    if (errorReporter.hasMessages()) {
                        errorReporter.reportError(errorReporter.getMessages());
                    } else {
                        errorReporter.reportError("The record could not be added due to an unknown error");
                    }
                }
                return false;
            }
            boolean bl7 = false;
            double d = this.scenario.study.getCoChannelMxDistance();
            double d2 = this.scenario.study.getKilometersPerDegree();
            String string = sourceEditData2.getSortChannel();
            for (n2 = 0; n2 < this.scenario.sourceData.getRowCount(); ++n2) {
                SourceEditData sourceEditData3 = this.scenario.sourceData.getSource(n2);
                if ((null != sourceEditData2.userRecordID && sourceEditData2.userRecordID.equals(sourceEditData3.userRecordID) || null != sourceEditData2.extDbKey && sourceEditData2.extDbKey.equals(sourceEditData3.extDbKey) && null != sourceEditData2.extRecordID && sourceEditData2.extRecordID.equals(sourceEditData3.extRecordID)) && string.equals(sourceEditData3.getSortChannel())) {
                    errorReporter.reportWarning("That record is already in the scenario");
                    return false;
                }
                if (bl7 || sourceEditData2.recordType != sourceEditData3.recordType) continue;
                if (1 == sourceEditData2.recordType && ExtDbRecordTV.areRecordsMX((SourceEditDataTV)((SourceEditDataTV)sourceEditData2), (SourceEditDataTV)((SourceEditDataTV)sourceEditData3), (boolean)false, (double)d, (double)d2)) {
                    if (2 == this.studyType) {
                        Scenario.SourceListItem sourceListItem = this.scenario.sourceData.get(n2);
                        if (sourceListItem.isDesired) {
                            bl7 = true;
                        }
                    } else {
                        bl7 = true;
                    }
                }
                if (3 != sourceEditData2.recordType || !ExtDbRecordFM.areRecordsMX((SourceEditDataFM)((SourceEditDataFM)sourceEditData2), (SourceEditDataFM)((SourceEditDataFM)sourceEditData3), (boolean)false, (double)d, (double)d2)) continue;
                bl7 = true;
            }
            if (!bl7 && 2 == this.studyType) {
                ScenarioEditData scenarioEditData = this.scenario.study.scenarioData.get(0);
                if (2 == scenarioEditData.scenarioType) {
                    SourceEditDataTV sourceEditDataTV2 = null;
                    for (SourceEditData sourceEditData4 : scenarioEditData.sourceData.getSources(1)) {
                        if (null == sourceEditData4.getAttribute("-isProposal")) continue;
                        sourceEditDataTV2 = (SourceEditDataTV)sourceEditData4;
                        break;
                    }
                    if (null != sourceEditDataTV2 && ExtDbRecordTV.areRecordsMX((SourceEditDataTV)((SourceEditDataTV)sourceEditData2), sourceEditDataTV2, (boolean)true, (double)0.0, (double)0.0)) {
                        bl7 = true;
                    }
                }
            }
            if (bl7) {
                AppController.beep();
                Object[] objectArray = new String[]{"No", "Yes"};
                if (2 == this.studyType) {
                    if (1 != JOptionPane.showOptionDialog(this.addSourceFinder, "The new record appears to be mutually-exclusive with the desired record in\nthis scenario, or with the proposal record for the study.  All records in\nthe scenario will be included as undesireds in the interference scenarios,\nregardless of the undesired flag.  Are you sure you want to add this record?", this.addSourceFinder.getBaseTitle(), 0, 2, null, objectArray, objectArray[0])) {
                        return false;
                    }
                } else {
                    if (1 != JOptionPane.showOptionDialog(this.addSourceFinder, "The new record appears to be mutually-exclusive with one already in the\nscenario.  The study will always consider all active undesired records as\npotential interference sources to all desireds, regardless of apparent MX\nrelationships.  Are you sure you want to add this record?", this.addSourceFinder.getBaseTitle(), 0, 2, null, objectArray, objectArray[0])) {
                        return false;
                    }
                    errorReporter.reportWarning("The new record will not be marked as an undesired");
                }
            }
            errorReporter.showMessages();
            if (null != sourceEditDataTV) {
                this.scenario.study.addOrReplaceSource((SourceEditData)sourceEditDataTV);
                this.setDidEdit();
            }
            n2 = 1 == this.studyType || 4 == this.studyType || 5 == this.studyType && 3 == sourceEditData2.recordType ? 1 : 0;
            boolean bl8 = bl = !bl7 || 2 == this.studyType;
            if (null != sourceEditData2.getAttribute("-isSharingGuest")) {
                n2 = 0;
                bl = false;
            }
            if ((n = this.sourceModel.addOrReplace(sourceEditData2, n2 != 0, bl)) < 0) {
                return false;
            }
            this.setDidEdit();
            n = this.sourceTable.convertRowIndexToView(n);
            this.sourceTable.setRowSelectionInterval(n, n);
            this.sourceTable.scrollRectToVisible(this.sourceTable.getCellRect(n, 0, true));
            if (!optionsPanel.isLocked && bl4) {
                this.doOpenSource();
            }
            return true;
        }
        if (appEditor instanceof SourceEditor) {
            SourceEditor sourceEditor = (SourceEditor)appEditor;
            Integer n = sourceEditor.getOriginalSourceKey();
            if (sourceEditor != this.sourceEditors.get(n)) {
                return false;
            }
            int n7 = this.scenario.sourceData.indexOfSourceKey(n);
            if (n7 < 0) {
                return false;
            }
            SourceEditData sourceEditData = this.scenario.sourceData.getSource(n7);
            if (sourceEditData.isLocked) {
                return false;
            }
            SourceEditData sourceEditData5 = sourceEditor.getSource();
            this.sourceModel.setUnfiltered(n7, sourceEditData5);
            if (!sourceEditData5.equals((Object)sourceEditData) || sourceEditData5.isDataChanged()) {
                this.setDidEdit();
            }
            return true;
        }
        return false;
    }

    @Override
    public void editorClosing(AppEditor appEditor) {
        if (appEditor instanceof ExtDbSearchDialog) {
            if ((ExtDbSearchDialog)appEditor == this.addSourcesDialog) {
                this.addSourcesDialog = null;
                this.updateSearchMenu();
            }
            return;
        }
        if (appEditor instanceof RecordFind) {
            if ((RecordFind)appEditor == this.addSourceFinder) {
                this.addSourceFinder = null;
            }
            return;
        }
        if (appEditor instanceof SourceEditor) {
            this.sourceEditors.remove(((SourceEditor)appEditor).getOriginalSourceKey(), (SourceEditor)appEditor);
            this.updateControls();
            return;
        }
    }

    @Override
    public boolean closeWithoutSave() {
        if (!this.sourceEditors.isEmpty()) {
            for (SourceEditor sourceEditor : new ArrayList<SourceEditor>(this.sourceEditors.values())) {
                if (sourceEditor.isVisible()) {
                    if (sourceEditor.cancel()) continue;
                    AppController.beep();
                    sourceEditor.toFront();
                    return false;
                }
                this.sourceEditors.remove(sourceEditor.getOriginalSourceKey());
            }
        }
        if (null != this.addSourceFinder) {
            if (this.addSourceFinder.isVisible() && !this.addSourceFinder.closeWithoutSave()) {
                AppController.beep();
                this.addSourceFinder.toFront();
                return false;
            }
            this.addSourceFinder = null;
        }
        if (null != this.addSourcesDialog) {
            if (this.addSourcesDialog.isVisible() && !this.addSourcesDialog.cancel()) {
                AppController.beep();
                this.addSourcesDialog.toFront();
                return false;
            }
            this.addSourcesDialog = null;
        }
        AppController.hideWindow(this);
        return true;
    }

    @Override
    public void windowWillOpen() {
        DbController.restoreColumnWidths(this.getDbID(), this.getKeyTitle(), this.sourceTable);
        this.updateSearchMenu();
        this.blockActionsClear();
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        if (!this.commitCurrentField()) {
            this.toFront();
            return false;
        }
        if (!this.sourceEditors.isEmpty()) {
            for (SourceEditor sourceEditor : new ArrayList<SourceEditor>(this.sourceEditors.values())) {
                if (sourceEditor.isVisible()) {
                    if (!sourceEditor.isEditing() && sourceEditor.cancel()) continue;
                    AppController.beep();
                    sourceEditor.toFront();
                    return false;
                }
                this.sourceEditors.remove(sourceEditor.getOriginalSourceKey());
            }
        }
        if (null != this.addSourceFinder) {
            if (this.addSourceFinder.isVisible() && !this.addSourceFinder.closeIfPossible()) {
                AppController.beep();
                this.addSourceFinder.toFront();
                return false;
            }
            this.addSourceFinder = null;
        }
        if (null != this.addSourcesDialog) {
            if (this.addSourcesDialog.isVisible() && !this.addSourcesDialog.cancel()) {
                AppController.beep();
                this.addSourcesDialog.toFront();
                return false;
            }
            this.addSourcesDialog = null;
        }
        return true;
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        DbController.saveColumnWidths(this.getDbID(), this.getKeyTitle(), this.sourceTable);
        this.blockActionsSet();
        this.parent.editorClosing(this);
    }

    private class SourceTableModel
    extends AbstractTableModel
    implements TableFilterModel {
        private static final String SOURCE_DESIRED_COLUMN = "Des";
        private static final String SOURCE_UNDESIRED_COLUMN = "Und";
        private static final String SOURCE_CALLSIGN_COLUMN = "Call Sign";
        private static final String SOURCE_CALLSIGN_COLUMN_WL = "Call/ID";
        private static final String SOURCE_CHANNEL_COLUMN = "Channel";
        private static final String SOURCE_SERVICE_COLUMN = "Svc";
        private static final String SOURCE_STATUS_COLUMN = "Status";
        private static final String SOURCE_CITY_COLUMN = "City";
        private static final String SOURCE_STATE_COLUMN = "State";
        private static final String SOURCE_COUNTRY_COLUMN = "Cntry";
        private static final String SOURCE_FACILITY_ID_COLUMN = "Facility ID";
        private static final String SOURCE_FILE_COLUMN = "File Number";
        private static final String SOURCE_FILE_COLUMN_WL = "File/Ref Number";
        private static final String SOURCE_DATE_COLUMN = "Date";
        private String[] columnNamesNoWL = new String[]{"Des", "Und", "Call Sign", "Channel", "Svc", "Status", "City", "State", "Cntry", "Facility ID", "File Number", "Date"};
        private String[] columnNamesWL = new String[]{"Des", "Und", "Call/ID", "Channel", "Svc", "Status", "City", "State", "Cntry", "Facility ID", "File/Ref Number", "Date"};
        private String[] columnNames;
        private static final int SOURCE_DESIRED_INDEX = 0;
        private static final int SOURCE_UNDESIRED_INDEX = 1;
        private static final int SOURCE_CALLSIGN_INDEX = 2;
        private static final int SOURCE_CHANNEL_INDEX = 3;
        private static final int SOURCE_SERVICE_INDEX = 4;
        private static final int SOURCE_STATUS_INDEX = 5;
        private static final int SOURCE_CITY_INDEX = 6;
        private static final int SOURCE_STATE_INDEX = 7;
        private static final int SOURCE_COUNTRY_INDEX = 8;
        private static final int SOURCE_FACILITY_ID_INDEX = 9;
        private static final int SOURCE_FILE_INDEX = 10;
        private static final int SOURCE_DATE_INDEX = 11;
        private JPanel panel;
        private TableFilterPanel filterPanel;

        private SourceTableModel(JPanel jPanel) {
            this.columnNames = Study.isRecordTypeAllowed((int)ScenarioEditor.this.studyType, (int)2) ? this.columnNamesWL : this.columnNamesNoWL;
            this.panel = jPanel;
            this.filterPanel = new TableFilterPanel((AppEditor)ScenarioEditor.this.outerThis, this);
        }

        private JTable createTable(EditMenu editMenu) {
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable, editMenu);
            TableRowSorter<SourceTableModel> tableRowSorter = new TableRowSorter<SourceTableModel>(this){

                @Override
                public void setSortKeys(List<? extends RowSorter.SortKey> list) {
                    Object object;
                    int n = 0;
                    SortOrder sortOrder = SortOrder.ASCENDING;
                    SortOrder sortOrder2 = SortOrder.DESCENDING;
                    if (null != list && list.size() > 0) {
                        object = list.get(0);
                        n = ((RowSorter.SortKey)object).getColumn();
                        if (0 == n || 1 == n) {
                            if (((RowSorter.SortKey)object).getSortOrder().equals((Object)SortOrder.ASCENDING)) {
                                sortOrder = SortOrder.DESCENDING;
                                sortOrder2 = SortOrder.ASCENDING;
                            }
                        } else if (((RowSorter.SortKey)object).getSortOrder().equals((Object)SortOrder.DESCENDING)) {
                            sortOrder = SortOrder.DESCENDING;
                            sortOrder2 = SortOrder.ASCENDING;
                        }
                    }
                    object = new ArrayList<RowSorter.SortKey>();
                    switch (n) {
                        default: {
                            ((ArrayList)object).add(new RowSorter.SortKey(0, sortOrder2));
                            ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            break;
                        }
                        case 1: {
                            ((ArrayList)object).add(new RowSorter.SortKey(1, sortOrder2));
                            ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            break;
                        }
                        case 2: {
                            ((ArrayList)object).add(new RowSorter.SortKey(2, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            break;
                        }
                        case 3: {
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            break;
                        }
                        case 4: {
                            ((ArrayList)object).add(new RowSorter.SortKey(4, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            break;
                        }
                        case 5: {
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            break;
                        }
                        case 6: {
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            break;
                        }
                        case 7: {
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            break;
                        }
                        case 8: {
                            ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            break;
                        }
                        case 9: {
                            ((ArrayList)object).add(new RowSorter.SortKey(9, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(5, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            break;
                        }
                        case 10: {
                            ((ArrayList)object).add(new RowSorter.SortKey(10, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                            break;
                        }
                        case 11: {
                            ((ArrayList)object).add(new RowSorter.SortKey(11, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(8, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(7, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(6, sortOrder));
                            ((ArrayList)object).add(new RowSorter.SortKey(3, sortOrder));
                        }
                    }
                    super.setSortKeys((List<RowSorter.SortKey>)object);
                }
            };
            TableStringConverter tableStringConverter = new TableStringConverter(){

                @Override
                public String toString(TableModel tableModel, int n, int n2) {
                    Scenario.SourceListItem sourceListItem = ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.get(((SourceTableModel)SourceTableModel.this).filterPanel.forwardIndex[n]);
                    SourceEditData sourceEditData = ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.getSource(((SourceTableModel)SourceTableModel.this).filterPanel.forwardIndex[n]);
                    switch (n2) {
                        case 0: {
                            return sourceListItem.isDesired ? "0" : "1";
                        }
                        case 1: {
                            return sourceListItem.isUndesired ? "0" : "1";
                        }
                        case 2: {
                            return sourceEditData.getCallSign();
                        }
                        case 3: {
                            return sourceEditData.getSortChannel();
                        }
                        case 4: {
                            return sourceEditData.getServiceCode();
                        }
                        case 5: {
                            return sourceEditData.getSortStatus();
                        }
                        case 6: {
                            return sourceEditData.getCity();
                        }
                        case 7: {
                            return sourceEditData.getState();
                        }
                        case 8: {
                            return sourceEditData.getSortCountry();
                        }
                        case 9: {
                            return sourceEditData.getSortFacilityID();
                        }
                        case 10: {
                            return sourceEditData.getFileNumber();
                        }
                        case 11: {
                            return sourceEditData.getSortSequenceDate();
                        }
                    }
                    return "";
                }
            };
            tableRowSorter.setStringConverter(tableStringConverter);
            jTable.setRowSorter((RowSorter<? extends TableModel>)tableRowSorter);
            tableRowSorter.setSortKeys(null);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    SourceEditData sourceEditData = ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.getSource(((SourceTableModel)SourceTableModel.this).filterPanel.forwardIndex[jTable.convertRowIndexToModel(n)]);
                    if (!bl) {
                        if (sourceEditData.isLocked) {
                            jLabel.setForeground(Color.BLACK);
                        } else {
                            jLabel.setForeground(Color.GREEN.darker());
                        }
                    }
                    if (2 == n2) {
                        String string = sourceEditData.makeCommentText();
                        if (null != string && string.length() > 0) {
                            if (!bl) {
                                jLabel.setForeground(Color.BLUE);
                            }
                            jLabel.setToolTipText(string);
                        } else {
                            jLabel.setToolTipText(null);
                        }
                    } else {
                        jLabel.setToolTipText(null);
                    }
                    return jLabel;
                }
            };
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            tableColumn.setMinWidth(AppController.textFieldWidth[3]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[3]);
            tableColumn = tableColumnModel.getColumn(1);
            tableColumn.setMinWidth(AppController.textFieldWidth[3]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[3]);
            tableColumn = tableColumnModel.getColumn(2);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[7]);
            tableColumn = tableColumnModel.getColumn(3);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[7]);
            tableColumn = tableColumnModel.getColumn(4);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[2]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[2]);
            tableColumn = tableColumnModel.getColumn(5);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[4]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[4]);
            tableColumn = tableColumnModel.getColumn(6);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[20]);
            tableColumn = tableColumnModel.getColumn(7);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[3]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[3]);
            tableColumn = tableColumnModel.getColumn(8);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[3]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[3]);
            tableColumn = tableColumnModel.getColumn(9);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[5]);
            tableColumn = tableColumnModel.getColumn(10);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[23]);
            tableColumn = tableColumnModel.getColumn(11);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
            return jTable;
        }

        private int addOrReplace(SourceEditData sourceEditData, boolean bl, boolean bl2) {
            this.postChange(((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.addOrReplace(sourceEditData, bl, bl2));
            int n = ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.getLastRowChanged();
            if (n >= 0) {
                return this.filterPanel.reverseIndex[n];
            }
            return n;
        }

        private boolean remove(int n) {
            return this.postChange(((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.remove(this.filterPanel.forwardIndex[n]));
        }

        private boolean remove(int[] nArray) {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.filterPanel.forwardIndex[nArray[i]];
            }
            return this.postChange(((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.remove(nArray2));
        }

        private boolean set(int n, SourceEditData sourceEditData) {
            return this.postChange(((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.set(this.filterPanel.forwardIndex[n], sourceEditData));
        }

        private boolean setUnfiltered(int n, SourceEditData sourceEditData) {
            return this.postChange(((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.set(n, sourceEditData));
        }

        private Scenario.SourceListItem get(int n) {
            return ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.get(this.filterPanel.forwardIndex[n]);
        }

        private SourceEditData getSource(int n) {
            return ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.getSource(this.filterPanel.forwardIndex[n]);
        }

        private boolean setIsDesired(int n, boolean bl) {
            if (this.isCellEditable(n, 0)) {
                return this.postChange(((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.setIsDesired(this.filterPanel.forwardIndex[n], bl));
            }
            return false;
        }

        private boolean setIsUndesired(int n, boolean bl) {
            if (this.isCellEditable(n, 1)) {
                return this.postChange(((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.setIsUndesired(this.filterPanel.forwardIndex[n], bl));
            }
            return false;
        }

        private boolean postChange(boolean bl) {
            if (bl) {
                int n = ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.getLastRowChanged();
                int n2 = -1;
                int n3 = -1;
                if (n >= 0 && n < this.filterPanel.reverseIndex.length) {
                    n2 = this.filterPanel.reverseIndex[n];
                }
                this.filterPanel.updateFilter();
                if (n >= 0 && n < this.filterPanel.reverseIndex.length) {
                    n3 = this.filterPanel.reverseIndex[n];
                }
                switch (((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.getLastChange()) {
                    default: {
                        break;
                    }
                    case 1: {
                        this.fireTableDataChanged();
                        this.updateBorder();
                        break;
                    }
                    case 2: {
                        if (n3 < 0) break;
                        this.fireTableRowsInserted(n3, n3);
                        this.updateBorder();
                        break;
                    }
                    case 3: {
                        if (n2 >= 0) {
                            if (n3 >= 0) {
                                this.fireTableRowsUpdated(n2, n3);
                                break;
                            }
                            this.fireTableRowsDeleted(n2, n2);
                            this.updateBorder();
                            break;
                        }
                        if (n3 < 0) break;
                        this.fireTableRowsInserted(n3, n3);
                        this.updateBorder();
                        break;
                    }
                    case 4: {
                        if (n2 < 0) break;
                        this.fireTableRowsDeleted(n2, n2);
                        this.updateBorder();
                    }
                }
            }
            return bl;
        }

        private void dataWasChanged() {
            this.filterPanel.updateFilter();
            this.fireTableDataChanged();
            this.updateBorder();
        }

        @Override
        public void filterDidChange() {
            this.fireTableDataChanged();
            this.updateBorder();
        }

        private void updateBorder() {
            int n = this.filterPanel.forwardIndex.length;
            if (n > 0) {
                this.panel.setBorder(BorderFactory.createTitledBorder(String.valueOf(n) + " stations"));
            } else {
                this.panel.setBorder(BorderFactory.createTitledBorder("Stations"));
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public boolean filterByColumn(int n) {
            switch (n) {
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean collapseFilterChoices(int n) {
            switch (n) {
                case 2: 
                case 3: 
                case 7: {
                    return true;
                }
            }
            return false;
        }

        public Class getColumnClass(int n) {
            if (0 == n || 1 == n) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public int getRowCount() {
            return this.filterPanel.forwardIndex.length;
        }

        @Override
        public int getUnfilteredRowCount() {
            return ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.getRowCount();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (2 == ((ScenarioEditor)ScenarioEditor.this).scenario.scenarioType || 3 == ((ScenarioEditor)ScenarioEditor.this).scenario.scenarioType) {
                return false;
            }
            n = this.filterPanel.forwardIndex[n];
            if (0 == n2) {
                Scenario.SourceListItem sourceListItem = ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.get(n);
                if (sourceListItem.isPermanent) {
                    return false;
                }
                if (2 == ScenarioEditor.this.studyType || 3 == ScenarioEditor.this.studyType) {
                    return false;
                }
                SourceEditData sourceEditData = ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.getSource(n);
                if (2 == sourceEditData.recordType) {
                    return false;
                }
                return 5 != ScenarioEditor.this.studyType || 1 != sourceEditData.recordType;
            }
            if (1 == n2) {
                Scenario.SourceListItem sourceListItem = ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.get(n);
                return !sourceListItem.isPermanent;
            }
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.getCellValue(this.filterPanel.forwardIndex[n], n2);
        }

        @Override
        public String getUnfilteredValueAt(int n, int n2) {
            return this.getCellValue(n, n2).toString();
        }

        private Object getCellValue(int n, int n2) {
            Scenario.SourceListItem sourceListItem = ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.get(n);
            SourceEditData sourceEditData = ((ScenarioEditor)ScenarioEditor.this).scenario.sourceData.getSource(n);
            switch (n2) {
                case 0: {
                    return sourceListItem.isDesired;
                }
                case 1: {
                    return sourceListItem.isUndesired;
                }
                case 2: {
                    return sourceEditData.getCallSign();
                }
                case 3: {
                    return sourceEditData.getChannel() + " " + sourceEditData.getFrequency();
                }
                case 4: {
                    return sourceEditData.getServiceCode();
                }
                case 5: {
                    return sourceEditData.getStatus();
                }
                case 6: {
                    return sourceEditData.getCity();
                }
                case 7: {
                    return sourceEditData.getState();
                }
                case 8: {
                    return sourceEditData.getCountryCode();
                }
                case 9: {
                    return sourceEditData.getFacilityID();
                }
                case 10: {
                    return sourceEditData.getFileNumber();
                }
                case 11: {
                    return sourceEditData.getSequenceDate();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    if (!this.setIsDesired(n, (Boolean)object)) break;
                    ScenarioEditor.this.setDidEdit();
                    break;
                }
                case 1: {
                    if (!this.setIsUndesired(n, (Boolean)object)) break;
                    ScenarioEditor.this.setDidEdit();
                }
            }
        }
    }
}

