/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.AntPattern;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbConnection;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppFrame;
import gov.fcc.tvstudy.gui.DbController;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.StudyManager;
import gov.fcc.tvstudy.gui.editor.PatternEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ReceiveAntennaEditor
extends AppFrame {
    public static final String WINDOW_TITLE = "Receive Antenna Editor";
    private AntennaListModel antennaModel = new AntennaListModel();
    private JTable antennaTable = AntennaListModel.access$100(this.antennaModel);
    private JButton duplicateAntennaButton;
    private JButton exportAntennaButton;
    private JButton openAntennaButton;
    private JMenuItem openAntennaMenuItem;
    private JMenuItem duplicateAntennaMenuItem;
    private JMenuItem deleteAntennaMenuItem;
    private JMenuItem exportAntennaMenuItem;
    private boolean ignoreSelectionChange;

    public ReceiveAntennaEditor(AppEditor appEditor) {
        super(appEditor, WINDOW_TITLE);
        this.antennaTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ReceiveAntennaEditor.this.ignoreSelectionChange) {
                    return;
                }
                ReceiveAntennaEditor.this.updateControls();
            }
        });
        this.antennaTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (2 == mouseEvent.getClickCount()) {
                    ReceiveAntennaEditor.this.doOpenAntenna();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Receive Antennas"));
        jPanel.add((Component)AppController.createScrollPane(this.antennaTable), "Center");
        JButton jButton = new JButton("New");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doNewAntenna();
            }
        });
        this.duplicateAntennaButton = new JButton("Duplicate");
        this.duplicateAntennaButton.setFocusable(false);
        this.duplicateAntennaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doDuplicateAntenna();
            }
        });
        JButton jButton2 = new JButton("Import");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doImportAntenna();
            }
        });
        this.exportAntennaButton = new JButton("Export");
        this.exportAntennaButton.setFocusable(false);
        this.exportAntennaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doExportAntenna();
            }
        });
        this.openAntennaButton = new JButton("Open");
        this.openAntennaButton.setFocusable(false);
        this.openAntennaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doOpenAntenna();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jButton);
        jPanel2.add(this.duplicateAntennaButton);
        jPanel2.add(jButton2);
        jPanel2.add(this.exportAntennaButton);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.add(this.openAntennaButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel4, "South");
        this.pack();
        Dimension dimension = new Dimension(500, 400);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.fileMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Previous");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doPrevious();
            }
        });
        this.fileMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Next");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(40, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doNext();
            }
        });
        this.fileMenu.add(jMenuItem2);
        this.fileMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("New");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(78, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doNewAntenna();
            }
        });
        this.fileMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Import...");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(73, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doImportAntenna();
            }
        });
        this.fileMenu.add(jMenuItem4);
        this.exportAntennaMenuItem = new JMenuItem("Export...");
        this.exportAntennaMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, AppController.MENU_SHORTCUT_KEY_MASK));
        this.exportAntennaMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doExportAntenna();
            }
        });
        this.fileMenu.add(this.exportAntennaMenuItem);
        this.fileMenu.addSeparator();
        this.openAntennaMenuItem = new JMenuItem("Open");
        this.openAntennaMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, AppController.MENU_SHORTCUT_KEY_MASK));
        this.openAntennaMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doOpenAntenna();
            }
        });
        this.fileMenu.add(this.openAntennaMenuItem);
        this.duplicateAntennaMenuItem = new JMenuItem("Duplicate...");
        this.duplicateAntennaMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doDuplicateAntenna();
            }
        });
        this.fileMenu.add(this.duplicateAntennaMenuItem);
        this.deleteAntennaMenuItem = new JMenuItem("Delete");
        this.deleteAntennaMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiveAntennaEditor.this.doDeleteAntenna();
            }
        });
        this.fileMenu.add(this.deleteAntennaMenuItem);
        this.updateControls();
        this.updateDocumentName();
    }

    @Override
    protected String getFileMenuName() {
        return "Antenna";
    }

    @Override
    protected boolean showsEditMenu() {
        return false;
    }

    @Override
    public void updateDocumentName() {
        this.setDocumentName(DbCore.getHostDbName((String)this.getDbID()));
    }

    private void updateControls() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = this.antennaTable.getSelectedRow();
        if (n >= 0) {
            bl = true;
            AntennaListItem antennaListItem = this.antennaModel.get(this.antennaTable.convertRowIndexToModel(n));
            if (null != antennaListItem.key && null == antennaListItem.patternEditor) {
                bl2 = true;
                bl3 = true;
            }
            bl4 = true;
        }
        this.openAntennaButton.setEnabled(bl);
        this.duplicateAntennaButton.setEnabled(bl2);
        this.exportAntennaButton.setEnabled(bl3);
        this.openAntennaMenuItem.setEnabled(bl);
        this.duplicateAntennaMenuItem.setEnabled(bl2);
        this.exportAntennaMenuItem.setEnabled(bl3);
        this.deleteAntennaMenuItem.setEnabled(bl4);
    }

    private ArrayList<AntennaListItem> getItems(ErrorReporter errorReporter) {
        ArrayList<AntennaListItem> arrayList = new ArrayList<AntennaListItem>();
        DbConnection dbConnection = DbCore.connectDb((String)this.getDbID(), (ErrorLogger)errorReporter);
        if (null != dbConnection) {
            try {
                dbConnection.query("SELECT receive_antenna_index.antenna_key, receive_antenna_index.name, MIN(receive_pattern.frequency), MAX(receive_pattern.frequency) FROM receive_antenna_index JOIN receive_pattern USING (antenna_key) GROUP BY 1,2 ORDER BY 1");
                while (dbConnection.next()) {
                    AntennaListItem antennaListItem = new AntennaListItem();
                    antennaListItem.key = dbConnection.getInt(1);
                    antennaListItem.name = dbConnection.getString(2);
                    antennaListItem.minFrequency = dbConnection.getDouble(3);
                    antennaListItem.maxFrequency = dbConnection.getDouble(4);
                    antennaListItem.isMatrix = antennaListItem.minFrequency != antennaListItem.maxFrequency;
                    arrayList.add(antennaListItem);
                }
                DbCore.releaseDb((DbConnection)dbConnection);
            }
            catch (SQLException sQLException) {
                DbCore.releaseDb((DbConnection)dbConnection);
                DbConnection.reportError((ErrorLogger)errorReporter, (SQLException)sQLException);
            }
        }
        return arrayList;
    }

    private void doPrevious() {
        int n = this.antennaTable.getRowCount();
        int n2 = this.antennaTable.getSelectedRow();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.antennaTable.setRowSelectionInterval(n2, n2);
            this.antennaTable.scrollRectToVisible(this.antennaTable.getCellRect(n2, 0, true));
        }
    }

    private void doNext() {
        int n = this.antennaTable.getRowCount();
        int n2 = this.antennaTable.getSelectedRow();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.antennaTable.setRowSelectionInterval(n2, n2);
            this.antennaTable.scrollRectToVisible(this.antennaTable.getCellRect(n2, 0, true));
        }
    }

    private void doOpenAntenna() {
        AntPattern antPattern;
        int n = this.antennaTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = "Open Antenna";
        this.errorReporter.setTitle(string);
        AntennaListItem antennaListItem = this.antennaModel.get(this.antennaTable.convertRowIndexToModel(n));
        if (null != antennaListItem.patternEditor) {
            if (antennaListItem.patternEditor.isVisible()) {
                antennaListItem.patternEditor.toFront();
                return;
            }
            antennaListItem.patternEditor = null;
        }
        if (null == (antPattern = AntPattern.getReceiveAntenna((String)this.getDbID(), (int)antennaListItem.key, (ErrorLogger)this.errorReporter))) {
            return;
        }
        antennaListItem.patternEditor = new PatternEditor((AppEditor)this, antPattern, true, "Edit Receive Pattern");
        AppController.showWindow(antennaListItem.patternEditor);
    }

    private void doImportAntenna() {
        String string = "Import Antenna";
        this.errorReporter.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Text (*.csv,*.txt,*.dat)", "csv", "txt", "dat"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (0 != jFileChooser.showDialog(this, "Import")) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        AntPattern antPattern = AntPattern.readFromText((String)this.getDbID(), (int)3, (File)file, (ErrorLogger)this.errorReporter);
        if (null == antPattern) {
            return;
        }
        AntennaListItem antennaListItem = new AntennaListItem();
        antennaListItem.name = antPattern.name;
        if (null == antennaListItem.name || 0 == antennaListItem.name.length()) {
            antennaListItem.name = "(new)";
        }
        antennaListItem.isMatrix = antPattern.isMatrix();
        antennaListItem.minFrequency = antPattern.minimumValue();
        antennaListItem.maxFrequency = antPattern.maximumValue();
        int n = this.antennaTable.convertRowIndexToView(this.antennaModel.add(antennaListItem));
        this.ignoreSelectionChange = true;
        this.antennaTable.setRowSelectionInterval(n, n);
        this.ignoreSelectionChange = false;
        this.antennaTable.scrollRectToVisible(this.antennaTable.getCellRect(n, 0, true));
        antennaListItem.patternEditor = new PatternEditor((AppEditor)this, antPattern, true, "Edit Receive Pattern");
        AppController.showWindow(antennaListItem.patternEditor);
        this.updateControls();
    }

    private void doExportAntenna() {
        int n = this.antennaTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = "Export Antenna";
        this.errorReporter.setTitle(string);
        AntennaListItem antennaListItem = this.antennaModel.get(this.antennaTable.convertRowIndexToModel(n));
        if (null == antennaListItem.key || null != antennaListItem.patternEditor) {
            return;
        }
        AntPattern antPattern = AntPattern.getReceiveAntenna((String)this.getDbID(), (int)antennaListItem.key, (ErrorLogger)this.errorReporter);
        if (null == antPattern) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("CSV (*.csv)", "csv"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File file = null;
        do {
            if (0 != jFileChooser.showDialog(this, "Export")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            String string2 = file.getName();
            if (!string2.toLowerCase().endsWith(".csv")) {
                file = new File(file.getAbsolutePath() + ".csv");
            }
            if (!file.exists()) continue;
            AppController.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        antPattern.export(file, (ErrorLogger)this.errorReporter);
    }

    private void doNewAntenna() {
        String string = "New Antenna";
        this.errorReporter.setTitle(string);
        AntPattern antPattern = new AntPattern(this.getDbID(), 3, "");
        AntennaListItem antennaListItem = new AntennaListItem();
        antennaListItem.name = "(new)";
        antennaListItem.isMatrix = antPattern.isMatrix();
        antennaListItem.minFrequency = antPattern.minimumValue();
        antennaListItem.maxFrequency = antPattern.maximumValue();
        int n = this.antennaTable.convertRowIndexToView(this.antennaModel.add(antennaListItem));
        this.ignoreSelectionChange = true;
        this.antennaTable.setRowSelectionInterval(n, n);
        this.ignoreSelectionChange = false;
        this.antennaTable.scrollRectToVisible(this.antennaTable.getCellRect(n, 0, true));
        antennaListItem.patternEditor = new PatternEditor((AppEditor)this, antPattern, true, "Edit Receive Pattern");
        AppController.showWindow(antennaListItem.patternEditor);
        this.updateControls();
    }

    private void doDuplicateAntenna() {
        int n = this.antennaTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = "Duplicate Antenna";
        this.errorReporter.setTitle(string);
        AntennaListItem antennaListItem = this.antennaModel.get(this.antennaTable.convertRowIndexToModel(n));
        if (null == antennaListItem.key) {
            return;
        }
        AntPattern antPattern = AntPattern.getReceiveAntenna((String)this.getDbID(), (int)antennaListItem.key, (ErrorLogger)this.errorReporter);
        if (null == antPattern) {
            return;
        }
        AntPattern antPattern2 = antPattern.duplicate();
        AntennaListItem antennaListItem2 = new AntennaListItem();
        antennaListItem2.name = "(new)";
        antennaListItem2.isMatrix = antPattern2.isMatrix();
        antennaListItem2.minFrequency = antPattern2.minimumValue();
        antennaListItem2.maxFrequency = antPattern2.maximumValue();
        n = this.antennaTable.convertRowIndexToView(this.antennaModel.add(antennaListItem2));
        this.ignoreSelectionChange = true;
        this.antennaTable.setRowSelectionInterval(n, n);
        this.ignoreSelectionChange = false;
        this.antennaTable.scrollRectToVisible(this.antennaTable.getCellRect(n, 0, true));
        antennaListItem2.patternEditor = new PatternEditor((AppEditor)this, antPattern2, true, "Edit Receive Pattern");
        AppController.showWindow(antennaListItem2.patternEditor);
        this.updateControls();
    }

    private void doDeleteAntenna() {
        int n = this.antennaTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = "Delete Antenna";
        this.errorReporter.setTitle(string);
        n = this.antennaTable.convertRowIndexToModel(n);
        AntennaListItem antennaListItem = this.antennaModel.get(n);
        if (null == antennaListItem.key) {
            antennaListItem.patternEditor.cancel();
            return;
        }
        AppController.beep();
        int n2 = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete antenna '" + antennaListItem.name + "'?", string, 0, 2);
        if (0 != n2) {
            return;
        }
        if (StudyManager.isReceiveAntennaInUse(this.getDbID(), antennaListItem.key)) {
            this.errorReporter.reportWarning("The antenna is in use and cannot be deleted");
            return;
        }
        if (!AntPattern.deleteReceiveAntenna((String)this.getDbID(), (int)antennaListItem.key, (ErrorLogger)this.errorReporter)) {
            return;
        }
        if (null != antennaListItem.patternEditor && !antennaListItem.patternEditor.cancel()) {
            return;
        }
        this.antennaModel.remove(n);
        StudyManager.updateReceiveAntennas(this.getDbID());
    }

    @Override
    public boolean applyEditsFrom(AppEditor appEditor) {
        if (appEditor instanceof PatternEditor) {
            PatternEditor patternEditor = (PatternEditor)appEditor;
            AntennaListItem antennaListItem = this.antennaModel.getItemForEditor(patternEditor);
            if (null == antennaListItem) {
                return true;
            }
            if (patternEditor.didEdit() || null == antennaListItem.key) {
                ErrorReporter errorReporter = patternEditor.getErrorReporter();
                AntPattern antPattern = patternEditor.getPattern();
                AntennaListItem antennaListItem2 = this.antennaModel.getItemForName(antPattern.name);
                if (null != antennaListItem2 && antennaListItem2 != antennaListItem) {
                    errorReporter.reportWarning("That antenna name already exists");
                    return false;
                }
                errorReporter.setTitle("Save Antenna");
                if (antPattern.save((ErrorLogger)errorReporter)) {
                    antennaListItem.key = antPattern.key;
                    antennaListItem.name = antPattern.name;
                    antennaListItem.isMatrix = antPattern.isMatrix();
                    antennaListItem.minFrequency = antPattern.minimumValue();
                    antennaListItem.maxFrequency = antPattern.maximumValue();
                    this.antennaModel.itemWasChanged(this.antennaModel.indexOf(antennaListItem));
                    StudyManager.updateReceiveAntennas(this.getDbID());
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void editorClosing(AppEditor appEditor) {
        if (appEditor instanceof PatternEditor) {
            AntennaListItem antennaListItem = this.antennaModel.getItemForEditor((PatternEditor)appEditor);
            if (null != antennaListItem) {
                antennaListItem.patternEditor = null;
                int n = this.antennaModel.indexOf(antennaListItem);
                if (null == antennaListItem.key) {
                    this.antennaModel.remove(n);
                } else {
                    this.antennaModel.itemWasChanged(n);
                    this.updateControls();
                }
            }
            return;
        }
    }

    @Override
    public void windowWillOpen() {
        DbController.restoreColumnWidths(this.getDbID(), this.getKeyTitle(), this.antennaTable);
        this.blockActionsClear();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReceiveAntennaEditor.this.errorReporter.setTitle("Load Antenna List");
                ReceiveAntennaEditor.this.antennaModel.setItems(ReceiveAntennaEditor.this.getItems(ReceiveAntennaEditor.this.errorReporter));
            }
        });
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        for (PatternEditor patternEditor : this.antennaModel.getEditors()) {
            if (!patternEditor.didEdit() && patternEditor.cancel()) continue;
            AppController.beep();
            patternEditor.toFront();
            return false;
        }
        return true;
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        DbController.saveColumnWidths(this.getDbID(), this.getKeyTitle(), this.antennaTable);
        this.blockActionsSet();
        this.parent.editorClosing(this);
    }

    @Override
    public boolean closeWithoutSave() {
        if (this.isVisible()) {
            for (PatternEditor patternEditor : this.antennaModel.getEditors()) {
                if (patternEditor.cancel()) continue;
                AppController.beep();
                patternEditor.toFront();
                return false;
            }
            AppController.hideWindow(this);
        }
        return true;
    }

    private class AntennaListModel
    extends AbstractTableModel {
        private static final String ANTENNA_NAME_COLUMN = "Name";
        private static final String ANTENNA_TYPE_COLUMN = "Type";
        private static final String ANTENNA_MIN_FREQ_COLUMN = "Min Freq.";
        private static final String ANTENNA_MAX_FREQ_COLUMN = "Max Freq.";
        private String[] columnNames = new String[]{"Name", "Type", "Min Freq.", "Max Freq."};
        private static final int ANTENNA_NAME_INDEX = 0;
        private static final int ANTENNA_TYPE_INDEX = 1;
        private static final int ANTENNA_MIN_FREQ_INDEX = 2;
        private static final int ANTENNA_MAX_FREQ_INDEX = 3;
        private ArrayList<AntennaListItem> modelRows = new ArrayList();

        private AntennaListModel() {
        }

        private JTable createTable() {
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable);
            TableColumn tableColumn = jTable.getColumn(ANTENNA_NAME_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[20]);
            tableColumn = jTable.getColumn(ANTENNA_TYPE_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
            tableColumn = jTable.getColumn(ANTENNA_MIN_FREQ_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
            tableColumn = jTable.getColumn(ANTENNA_MAX_FREQ_COLUMN);
            tableColumn.setMinWidth(AppController.textFieldWidth[5]);
            tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
            return jTable;
        }

        private void setItems(ArrayList<AntennaListItem> arrayList) {
            HashMap<Integer, AntennaListItem> hashMap = new HashMap<Integer, AntennaListItem>();
            ArrayList<AntennaListItem> arrayList2 = new ArrayList<AntennaListItem>();
            for (AntennaListItem object : new ArrayList<AntennaListItem>(this.modelRows)) {
                if (null != object.key) {
                    hashMap.put(object.key, object);
                    continue;
                }
                arrayList2.add(object);
            }
            this.modelRows.clear();
            if (null != arrayList) {
                for (AntennaListItem antennaListItem : arrayList) {
                    AntennaListItem antennaListItem2 = (AntennaListItem)hashMap.remove(antennaListItem.key);
                    if (null != antennaListItem2) {
                        antennaListItem2.name = antennaListItem.name;
                        antennaListItem2.isMatrix = antennaListItem.isMatrix;
                        antennaListItem2.minFrequency = antennaListItem.minFrequency;
                        antennaListItem2.maxFrequency = antennaListItem.maxFrequency;
                        this.modelRows.add(antennaListItem2);
                        continue;
                    }
                    this.modelRows.add(antennaListItem);
                }
            }
            for (AntennaListItem antennaListItem : hashMap.values()) {
                if (null == antennaListItem.patternEditor) continue;
                this.modelRows.add(antennaListItem);
            }
            this.modelRows.addAll(arrayList2);
            this.fireTableDataChanged();
        }

        private int add(AntennaListItem antennaListItem) {
            int n = this.modelRows.size();
            this.modelRows.add(antennaListItem);
            this.fireTableRowsInserted(n, n);
            return n;
        }

        private AntennaListItem get(int n) {
            return this.modelRows.get(n);
        }

        private void remove(int n) {
            this.modelRows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        private void itemWasChanged(int n) {
            this.fireTableRowsUpdated(n, n);
        }

        private int indexOf(AntennaListItem antennaListItem) {
            return this.modelRows.indexOf(antennaListItem);
        }

        private AntennaListItem getItemForEditor(PatternEditor patternEditor) {
            for (AntennaListItem antennaListItem : this.modelRows) {
                if (patternEditor != antennaListItem.patternEditor) continue;
                return antennaListItem;
            }
            return null;
        }

        private ArrayList<PatternEditor> getEditors() {
            ArrayList<PatternEditor> arrayList = new ArrayList<PatternEditor>();
            for (AntennaListItem antennaListItem : this.modelRows) {
                if (null == antennaListItem.patternEditor) continue;
                arrayList.add(antennaListItem.patternEditor);
            }
            return arrayList;
        }

        private AntennaListItem getItemForName(String string) {
            for (AntennaListItem antennaListItem : this.modelRows) {
                if (!antennaListItem.name.equalsIgnoreCase(string)) continue;
                return antennaListItem;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this.modelRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AntennaListItem antennaListItem = this.modelRows.get(n);
            switch (n2) {
                case 0: {
                    return antennaListItem.name;
                }
                case 1: {
                    return antennaListItem.isMatrix ? "Matrix" : "Simple";
                }
                case 2: {
                    return antennaListItem.isMatrix ? AppCore.formatDecimal((double)antennaListItem.minFrequency, (int)2) : "";
                }
                case 3: {
                    return antennaListItem.isMatrix ? AppCore.formatDecimal((double)antennaListItem.maxFrequency, (int)2) : "";
                }
            }
            return "";
        }

        static /* synthetic */ JTable access$100(AntennaListModel antennaListModel) {
            return antennaListModel.createTable();
        }
    }

    private class AntennaListItem {
        private Integer key;
        private String name;
        private boolean isMatrix;
        private double minFrequency;
        private double maxFrequency;
        private PatternEditor patternEditor;

        private AntennaListItem() {
        }
    }
}

