/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.editdata.ParameterEditData;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.DateSelectionPanel;
import gov.fcc.tvstudy.gui.ErrorReporter;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ParameterEditor {
    private AppEditor parent;
    private ErrorReporter errorReporter;
    private ParameterEditData parameter;
    public final JLabel label;
    public final JComponent editComponent;
    public final JLabel unitsLabel;
    public final JButton setDefaultButton;
    public final JComboBox<String> valueMenu;
    private int valueIndex;
    private NumberFormat doubleFormatter;
    private boolean canEdit;
    private TableParameterEditor tableEditor;
    private ArrayList<ParameterEditor> enablesEditors;

    public ParameterEditor(AppEditor appEditor, ErrorReporter errorReporter, ParameterEditData parameterEditData) {
        JComponent jComponent;
        this.parent = appEditor;
        this.errorReporter = errorReporter;
        this.parent.blockActionsStart();
        this.parameter = parameterEditData;
        int n = this.parameter.parameter.decimalPrecision;
        if (n < 0 || n > 8) {
            n = 8;
        }
        this.doubleFormatter = NumberFormat.getInstance(Locale.US);
        this.doubleFormatter.setMinimumFractionDigits(0);
        this.doubleFormatter.setMaximumFractionDigits(n);
        this.doubleFormatter.setMinimumIntegerDigits(1);
        this.doubleFormatter.setGroupingUsed(false);
        boolean bl = this.canEdit = !this.parameter.isLocked;
        if (this.parameter.parameter.isTable) {
            JButton jButton = this.canEdit ? new JButton("Edit") : new JButton("View");
            jComponent = jButton;
            this.tableEditor = new TableParameterEditor(this.parent);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AppController.showWindow(ParameterEditor.this.tableEditor);
                }
            });
        } else {
            switch (this.parameter.parameter.type) {
                default: {
                    JTextField jTextField = new JTextField(10);
                    jComponent = jTextField;
                    AppController.fixKeyBindings(jTextField);
                    jTextField.setText(this.parameter.value[this.valueIndex]);
                    jTextField.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            JTextField jTextField = (JTextField)ParameterEditor.this.editComponent;
                            if (ParameterEditor.this.parent.blockActions()) {
                                if (ParameterEditor.this.canEdit) {
                                    String string = jTextField.getText().trim();
                                    if (!string.equals(((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex])) {
                                        ((ParameterEditor)ParameterEditor.this).parameter.value[((ParameterEditor)ParameterEditor.this).valueIndex] = string;
                                        ParameterEditor.this.parent.setDidEdit();
                                    }
                                    ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex].equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue[ParameterEditor.this.valueIndex]));
                                }
                                ParameterEditor.this.parent.blockActionsEnd();
                            }
                            jTextField.setText(((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex]);
                        }
                    });
                    jTextField.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent focusEvent) {
                            ParameterEditor.this.parent.setCurrentField((JTextField)ParameterEditor.this.editComponent);
                        }

                        @Override
                        public void focusLost(FocusEvent focusEvent) {
                            if (!focusEvent.isTemporary()) {
                                ((JTextField)ParameterEditor.this.editComponent).postActionEvent();
                            }
                        }
                    });
                    break;
                }
                case 2: {
                    JTextField jTextField = new JTextField(10);
                    jComponent = jTextField;
                    AppController.fixKeyBindings(jTextField);
                    jTextField.setText(this.parameter.value[this.valueIndex]);
                    jTextField.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            JTextField jTextField = (JTextField)ParameterEditor.this.editComponent;
                            if (ParameterEditor.this.parent.blockActions()) {
                                String string = "Edit Parameter";
                                if (ParameterEditor.this.canEdit) {
                                    String string2 = jTextField.getText().trim();
                                    if (string2.length() > 0) {
                                        try {
                                            int n = Integer.parseInt(string2);
                                            if (n < ((ParameterEditor)ParameterEditor.this).parameter.parameter.minIntegerValue || n > ((ParameterEditor)ParameterEditor.this).parameter.parameter.maxIntegerValue) {
                                                ParameterEditor.this.errorReporter.reportValidationError(string, "The value must be in the range " + ((ParameterEditor)ParameterEditor.this).parameter.parameter.minIntegerValue + " to " + ((ParameterEditor)ParameterEditor.this).parameter.parameter.maxIntegerValue);
                                            } else if (n != ((ParameterEditor)ParameterEditor.this).parameter.integerValue[ParameterEditor.this.valueIndex]) {
                                                ((ParameterEditor)ParameterEditor.this).parameter.integerValue[((ParameterEditor)ParameterEditor.this).valueIndex] = n;
                                                ((ParameterEditor)ParameterEditor.this).parameter.value[((ParameterEditor)ParameterEditor.this).valueIndex] = String.valueOf(n);
                                                ParameterEditor.this.parent.setDidEdit();
                                            }
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            ParameterEditor.this.errorReporter.reportValidationError(string, "The value must be a number");
                                        }
                                    }
                                    ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex].equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue[ParameterEditor.this.valueIndex]));
                                }
                                ParameterEditor.this.parent.blockActionsEnd();
                            }
                            jTextField.setText(((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex]);
                        }
                    });
                    jTextField.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent focusEvent) {
                            ParameterEditor.this.parent.setCurrentField((JTextField)ParameterEditor.this.editComponent);
                        }

                        @Override
                        public void focusLost(FocusEvent focusEvent) {
                            if (!focusEvent.isTemporary()) {
                                ((JTextField)ParameterEditor.this.editComponent).postActionEvent();
                            }
                        }
                    });
                    break;
                }
                case 3: {
                    JTextField jTextField = new JTextField(10);
                    jComponent = jTextField;
                    AppController.fixKeyBindings(jTextField);
                    jTextField.setText(this.parameter.value[this.valueIndex]);
                    jTextField.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            JTextField jTextField = (JTextField)ParameterEditor.this.editComponent;
                            if (ParameterEditor.this.parent.blockActions()) {
                                String string = "Edit Parameter";
                                if (ParameterEditor.this.canEdit) {
                                    String string2 = jTextField.getText().trim();
                                    if (string2.length() > 0) {
                                        try {
                                            double d = Double.parseDouble(string2);
                                            string2 = ParameterEditor.this.doubleFormatter.format(d);
                                            d = Double.parseDouble(string2);
                                            if (d < ((ParameterEditor)ParameterEditor.this).parameter.parameter.minDecimalValue || d > ((ParameterEditor)ParameterEditor.this).parameter.parameter.maxDecimalValue) {
                                                ParameterEditor.this.errorReporter.reportValidationError(string, "The value must be in the range " + ((ParameterEditor)ParameterEditor.this).parameter.parameter.minDecimalValue + " to " + ((ParameterEditor)ParameterEditor.this).parameter.parameter.maxDecimalValue);
                                            } else if (d != ((ParameterEditor)ParameterEditor.this).parameter.decimalValue[ParameterEditor.this.valueIndex]) {
                                                ((ParameterEditor)ParameterEditor.this).parameter.decimalValue[((ParameterEditor)ParameterEditor.this).valueIndex] = d;
                                                ((ParameterEditor)ParameterEditor.this).parameter.value[((ParameterEditor)ParameterEditor.this).valueIndex] = string2;
                                                ParameterEditor.this.parent.setDidEdit();
                                            }
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            ParameterEditor.this.errorReporter.reportValidationError(string, "The value must be a number");
                                        }
                                    }
                                    ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex].equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue[ParameterEditor.this.valueIndex]));
                                }
                                ParameterEditor.this.parent.blockActionsEnd();
                            }
                            jTextField.setText(((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex]);
                        }
                    });
                    jTextField.addFocusListener(new FocusAdapter(){

                        @Override
                        public void focusGained(FocusEvent focusEvent) {
                            ParameterEditor.this.parent.setCurrentField((JTextField)ParameterEditor.this.editComponent);
                        }

                        @Override
                        public void focusLost(FocusEvent focusEvent) {
                            if (!focusEvent.isTemporary()) {
                                ((JTextField)ParameterEditor.this.editComponent).postActionEvent();
                            }
                        }
                    });
                    break;
                }
                case 4: {
                    JCheckBox jCheckBox = new JCheckBox();
                    jCheckBox.setFocusable(false);
                    jComponent = jCheckBox;
                    jCheckBox.setSelected(this.parameter.optionValue[this.valueIndex]);
                    jCheckBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (ParameterEditor.this.parent.blockActions()) {
                                if (ParameterEditor.this.canEdit) {
                                    ((ParameterEditor)ParameterEditor.this).parameter.optionValue[((ParameterEditor)ParameterEditor.this).valueIndex] = ((JCheckBox)ParameterEditor.this.editComponent).isSelected();
                                    ((ParameterEditor)ParameterEditor.this).parameter.value[((ParameterEditor)ParameterEditor.this).valueIndex] = ((ParameterEditor)ParameterEditor.this).parameter.optionValue[ParameterEditor.this.valueIndex] ? "1" : "0";
                                    ParameterEditor.this.parent.setDidEdit();
                                    ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex].equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue[ParameterEditor.this.valueIndex]));
                                    if (null != ParameterEditor.this.enablesEditors) {
                                        for (ParameterEditor parameterEditor : ParameterEditor.this.enablesEditors) {
                                            parameterEditor.setEnabled(((ParameterEditor)ParameterEditor.this).parameter.optionValue[ParameterEditor.this.valueIndex]);
                                        }
                                    }
                                } else {
                                    ((JCheckBox)ParameterEditor.this.editComponent).setSelected(((ParameterEditor)ParameterEditor.this).parameter.optionValue[ParameterEditor.this.valueIndex]);
                                }
                                ParameterEditor.this.parent.blockActionsEnd();
                            } else {
                                ((JCheckBox)ParameterEditor.this.editComponent).setSelected(((ParameterEditor)ParameterEditor.this).parameter.optionValue[ParameterEditor.this.valueIndex]);
                            }
                        }
                    });
                    break;
                }
                case 5: {
                    KeyedRecordMenu keyedRecordMenu = new KeyedRecordMenu(this.parameter.parameter.pickfromItems);
                    jComponent = keyedRecordMenu;
                    keyedRecordMenu.setSelectedIndex(this.parameter.pickfromIndex[this.valueIndex]);
                    keyedRecordMenu.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (ParameterEditor.this.parent.blockActions()) {
                                if (ParameterEditor.this.canEdit) {
                                    int n = ((KeyedRecordMenu)ParameterEditor.this.editComponent).getSelectedIndex();
                                    if (n != ((ParameterEditor)ParameterEditor.this).parameter.pickfromIndex[ParameterEditor.this.valueIndex]) {
                                        ((ParameterEditor)ParameterEditor.this).parameter.pickfromIndex[((ParameterEditor)ParameterEditor.this).valueIndex] = n;
                                        ((ParameterEditor)ParameterEditor.this).parameter.integerValue[((ParameterEditor)ParameterEditor.this).valueIndex] = ((KeyedRecordMenu)ParameterEditor.this.editComponent).getSelectedKey();
                                        ((ParameterEditor)ParameterEditor.this).parameter.value[((ParameterEditor)ParameterEditor.this).valueIndex] = String.valueOf(((ParameterEditor)ParameterEditor.this).parameter.integerValue[ParameterEditor.this.valueIndex]);
                                        ParameterEditor.this.parent.setDidEdit();
                                    }
                                    ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex].equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue[ParameterEditor.this.valueIndex]));
                                } else {
                                    ((KeyedRecordMenu)ParameterEditor.this.editComponent).setSelectedIndex(((ParameterEditor)ParameterEditor.this).parameter.pickfromIndex[ParameterEditor.this.valueIndex]);
                                }
                                ParameterEditor.this.parent.blockActionsEnd();
                            } else {
                                ((KeyedRecordMenu)ParameterEditor.this.editComponent).setSelectedIndex(((ParameterEditor)ParameterEditor.this).parameter.pickfromIndex[ParameterEditor.this.valueIndex]);
                            }
                        }
                    });
                    break;
                }
                case 6: {
                    DateSelectionPanel dateSelectionPanel = new DateSelectionPanel(this.parent, false, false, new Runnable(){

                        @Override
                        public void run() {
                            if (ParameterEditor.this.parent.blockActions()) {
                                if (ParameterEditor.this.canEdit) {
                                    Date date = ((DateSelectionPanel)ParameterEditor.this.editComponent).getDate();
                                    if (null == date && null != ((ParameterEditor)ParameterEditor.this).parameter.dateValue[ParameterEditor.this.valueIndex] || null != date && null == ((ParameterEditor)ParameterEditor.this).parameter.dateValue[ParameterEditor.this.valueIndex] || null != date && null != ((ParameterEditor)ParameterEditor.this).parameter.dateValue[ParameterEditor.this.valueIndex] && !date.equals(((ParameterEditor)ParameterEditor.this).parameter.dateValue[ParameterEditor.this.valueIndex])) {
                                        ((ParameterEditor)ParameterEditor.this).parameter.dateValue[((ParameterEditor)ParameterEditor.this).valueIndex] = date;
                                        ((ParameterEditor)ParameterEditor.this).parameter.value[((ParameterEditor)ParameterEditor.this).valueIndex] = null != date ? AppCore.formatDate((Date)date) : "";
                                        ParameterEditor.this.parent.setDidEdit();
                                    }
                                    ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex].equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue[ParameterEditor.this.valueIndex]));
                                }
                                ParameterEditor.this.parent.blockActionsEnd();
                            } else {
                                ((DateSelectionPanel)ParameterEditor.this.editComponent).setDate(((ParameterEditor)ParameterEditor.this).parameter.dateValue[ParameterEditor.this.valueIndex]);
                            }
                        }
                    });
                    jComponent = dateSelectionPanel;
                    dateSelectionPanel.setFutureAllowed(true);
                    dateSelectionPanel.setDate(this.parameter.dateValue[this.valueIndex]);
                    break;
                }
            }
        }
        jComponent.setToolTipText(this.parameter.parameter.description);
        this.label = new JLabel(this.parameter.parameter.name);
        if (this.parameter.parameter.defaultsApplied && !this.parameter.parameter.isScenario) {
            this.label.setForeground(Color.RED.darker());
        }
        this.editComponent = jComponent;
        this.unitsLabel = new JLabel(this.parameter.parameter.units);
        this.setDefaultButton = new JButton("Revert");
        this.setDefaultButton.setFocusable(false);
        this.setDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParameterEditor.this.setDefaultValue(false);
            }
        });
        if (this.parameter.parameter.valueCount > 1) {
            this.valueMenu = new JComboBox<String>(this.parameter.parameter.valueName);
            this.valueMenu.setFocusable(false);
            this.valueMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ParameterEditor.this.parent.blockActions()) {
                        int n = ParameterEditor.this.valueMenu.getSelectedIndex();
                        if (n != ParameterEditor.this.valueIndex) {
                            if (ParameterEditor.this.canEdit && ParameterEditor.this.editComponent instanceof JTextField) {
                                ParameterEditor.this.errorReporter.clearErrors();
                                ((JTextField)ParameterEditor.this.editComponent).postActionEvent();
                                if (ParameterEditor.this.errorReporter.hasErrors()) {
                                    ParameterEditor.this.valueMenu.setSelectedIndex(ParameterEditor.this.valueIndex);
                                    ParameterEditor.this.parent.blockActionsEnd();
                                    return;
                                }
                            }
                            ParameterEditor.this.valueIndex = n;
                            if (!((ParameterEditor)ParameterEditor.this).parameter.parameter.isTable) {
                                switch (((ParameterEditor)ParameterEditor.this).parameter.parameter.type) {
                                    default: {
                                        ((JTextField)ParameterEditor.this.editComponent).setText(((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex]);
                                        break;
                                    }
                                    case 4: {
                                        ((JCheckBox)ParameterEditor.this.editComponent).setSelected(((ParameterEditor)ParameterEditor.this).parameter.optionValue[ParameterEditor.this.valueIndex]);
                                        break;
                                    }
                                    case 5: {
                                        ((KeyedRecordMenu)ParameterEditor.this.editComponent).setSelectedIndex(((ParameterEditor)ParameterEditor.this).parameter.pickfromIndex[ParameterEditor.this.valueIndex]);
                                    }
                                }
                            }
                            if (ParameterEditor.this.canEdit) {
                                ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex].equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue[ParameterEditor.this.valueIndex]));
                            } else {
                                ParameterEditor.this.setDefaultButton.setEnabled(false);
                            }
                        }
                        ParameterEditor.this.parent.blockActionsEnd();
                    }
                }
            });
        } else {
            this.valueMenu = null;
        }
        this.setEnabled(true);
        this.parent.blockActionsEnd();
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.label.setEnabled(true);
            this.editComponent.setEnabled(true);
            this.unitsLabel.setEnabled(true);
            if (this.canEdit) {
                if (!this.parameter.parameter.isTable) {
                    AppController.setComponentEnabled(this.editComponent, true);
                }
                this.setDefaultButton.setEnabled(!this.parameter.value[this.valueIndex].equals(this.parameter.parameter.defaultValue[this.valueIndex]));
            } else {
                if (!this.parameter.parameter.isTable) {
                    AppController.setComponentEnabled(this.editComponent, false);
                }
                this.setDefaultButton.setEnabled(false);
            }
            if (null != this.valueMenu) {
                this.valueMenu.setEnabled(true);
            }
        } else {
            this.label.setEnabled(false);
            this.editComponent.setEnabled(false);
            this.unitsLabel.setEnabled(false);
            this.setDefaultButton.setEnabled(false);
            if (null != this.valueMenu) {
                this.valueMenu.setEnabled(false);
            }
        }
    }

    public void setDefaultValue(boolean bl) {
        if (!this.canEdit) {
            return;
        }
        this.parent.blockActionsStart();
        if (bl) {
            for (int i = 0; i < this.parameter.parameter.valueCount; ++i) {
                if (!this.parameter.setDefaultValue(i)) continue;
                this.parent.setDidEdit();
            }
        } else if (this.parameter.setDefaultValue(this.valueIndex)) {
            this.parent.setDidEdit();
        }
        if (!this.parameter.parameter.isTable) {
            switch (this.parameter.parameter.type) {
                case 1: 
                case 2: 
                case 3: {
                    ((JTextField)this.editComponent).setText(this.parameter.value[this.valueIndex]);
                    break;
                }
                case 4: {
                    ((JCheckBox)this.editComponent).setSelected(this.parameter.optionValue[this.valueIndex]);
                    if (null == this.enablesEditors) break;
                    for (ParameterEditor parameterEditor : this.enablesEditors) {
                        parameterEditor.setEnabled(this.parameter.optionValue[this.valueIndex]);
                    }
                    break;
                }
                case 5: {
                    ((KeyedRecordMenu)this.editComponent).setSelectedIndex(this.parameter.pickfromIndex[this.valueIndex]);
                    break;
                }
                case 6: {
                    ((DateSelectionPanel)this.editComponent).setDate(this.parameter.dateValue[this.valueIndex]);
                }
            }
        }
        this.setDefaultButton.setEnabled(false);
        this.parent.blockActionsEnd();
    }

    public static JComponent createEditorLayout(AppEditor appEditor, ErrorReporter errorReporter, ArrayList<ParameterEditData> arrayList, ArrayList<ParameterEditor> arrayList2) {
        if (arrayList.isEmpty()) {
            return new JPanel();
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<ParameterEditorGroup> arrayList4 = new ArrayList<ParameterEditorGroup>();
        for (ParameterEditData parameterEditData : arrayList) {
            ParameterEditorGroup parameterEditorGroup;
            int n = arrayList3.indexOf(parameterEditData.parameter.groupName);
            if (n < 0) {
                parameterEditorGroup = new ParameterEditorGroup();
                arrayList3.add(parameterEditData.parameter.groupName);
                arrayList4.add(parameterEditorGroup);
            } else {
                parameterEditorGroup = (ParameterEditorGroup)arrayList4.get(n);
            }
            ParameterEditor parameterEditor = new ParameterEditor(appEditor, errorReporter, parameterEditData);
            parameterEditorGroup.addEditor(parameterEditor);
            if (null == arrayList2) continue;
            arrayList2.add(parameterEditor);
        }
        if (1 == arrayList3.size()) {
            return AppController.createScrollPane(((ParameterEditorGroup)arrayList4.get(0)).panel);
        }
        return new ParameterPanel(arrayList3, arrayList4);
    }

    private static class ParameterPanel
    extends JPanel {
        private JComboBox<String> groupMenu = new JComboBox();
        private ArrayList<Container> groupPanes;

        private ParameterPanel(ArrayList<String> arrayList, ArrayList<ParameterEditorGroup> arrayList2) {
            this.groupMenu.setFocusable(false);
            this.groupMenu.setMaximumRowCount(arrayList.size());
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(this.groupMenu);
            this.groupPanes = new ArrayList();
            for (int i = 0; i < arrayList.size(); ++i) {
                this.groupMenu.addItem(arrayList.get(i));
                this.groupPanes.add(AppController.createScrollPane(arrayList2.get(i).panel));
            }
            this.groupMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.remove(1);
                    this.add((Component)groupPanes.get(groupMenu.getSelectedIndex()), "Center");
                    this.revalidate();
                    this.repaint();
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "North");
            this.add((Component)this.groupPanes.get(0), "Center");
        }
    }

    private static class ParameterEditorGroup {
        private ParameterEditor enablingEditor;
        private JPanel panel;
        private GroupLayout layout;
        private GroupLayout.ParallelGroup labelGroup;
        private GroupLayout.ParallelGroup menuGroup;
        private GroupLayout.ParallelGroup componentGroup;
        private GroupLayout.ParallelGroup unitsLabelGroup;
        private GroupLayout.ParallelGroup buttonGroup;
        private GroupLayout.SequentialGroup verticalGroup;
        private boolean hasNewParameters;

        private ParameterEditorGroup() {
            JPanel jPanel = new JPanel();
            this.layout = new GroupLayout(jPanel);
            jPanel.setLayout(this.layout);
            this.layout.setAutoCreateGaps(true);
            this.layout.setAutoCreateContainerGaps(true);
            this.labelGroup = this.layout.createParallelGroup(GroupLayout.Alignment.TRAILING);
            this.menuGroup = this.layout.createParallelGroup();
            this.componentGroup = this.layout.createParallelGroup();
            this.unitsLabelGroup = this.layout.createParallelGroup();
            this.buttonGroup = this.layout.createParallelGroup();
            this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addGroup(this.labelGroup).addGroup(this.menuGroup).addGroup(this.componentGroup).addGroup(this.unitsLabelGroup).addGroup(this.buttonGroup));
            this.verticalGroup = this.layout.createSequentialGroup();
            this.layout.setVerticalGroup(this.verticalGroup);
            this.panel = new JPanel();
            this.panel.add(jPanel);
        }

        private void addEditor(ParameterEditor parameterEditor) {
            if (4 == ((ParameterEditor)parameterEditor).parameter.parameter.type && ((ParameterEditor)parameterEditor).parameter.parameter.enablesGroup) {
                this.enablingEditor = parameterEditor;
                parameterEditor.enablesEditors = new ArrayList();
            } else if (null != this.enablingEditor) {
                this.enablingEditor.enablesEditors.add(parameterEditor);
                parameterEditor.setEnabled(((ParameterEditor)this.enablingEditor).parameter.optionValue[0]);
            }
            this.labelGroup.addComponent(parameterEditor.label);
            this.componentGroup.addComponent(parameterEditor.editComponent);
            this.unitsLabelGroup.addComponent(parameterEditor.unitsLabel);
            if (((ParameterEditor)parameterEditor).parameter.parameter.isScenario) {
                if (null != parameterEditor.valueMenu) {
                    this.menuGroup.addComponent(parameterEditor.valueMenu);
                    this.verticalGroup.addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(parameterEditor.label).addComponent(parameterEditor.valueMenu).addComponent(parameterEditor.editComponent).addComponent(parameterEditor.unitsLabel));
                } else {
                    this.verticalGroup.addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(parameterEditor.label).addComponent(parameterEditor.editComponent).addComponent(parameterEditor.unitsLabel));
                }
            } else {
                this.buttonGroup.addComponent(parameterEditor.setDefaultButton);
                if (null != parameterEditor.valueMenu) {
                    this.menuGroup.addComponent(parameterEditor.valueMenu);
                    this.verticalGroup.addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(parameterEditor.label).addComponent(parameterEditor.valueMenu).addComponent(parameterEditor.editComponent).addComponent(parameterEditor.unitsLabel).addComponent(parameterEditor.setDefaultButton));
                } else {
                    this.verticalGroup.addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(parameterEditor.label).addComponent(parameterEditor.editComponent).addComponent(parameterEditor.unitsLabel).addComponent(parameterEditor.setDefaultButton));
                }
                if (((ParameterEditor)parameterEditor).parameter.parameter.defaultsApplied) {
                    this.hasNewParameters = true;
                }
            }
        }
    }

    private class TableParameterModel
    extends AbstractTableModel {
        private int rowCount;
        private int columnCount;
        private boolean isDecimal;
        private int[][] integerValues;
        private double[][] decimalValues;
        private boolean didEdit;

        private TableParameterModel() {
            this.rowCount = ((ParameterEditor)ParameterEditor.this).parameter.parameter.tableRowLabels.length;
            this.columnCount = ((ParameterEditor)ParameterEditor.this).parameter.parameter.tableColumnLabels.length;
            boolean bl = this.isDecimal = 3 == ((ParameterEditor)ParameterEditor.this).parameter.parameter.type;
            if (this.isDecimal) {
                this.decimalValues = new double[this.rowCount][this.columnCount];
            } else {
                this.integerValues = new int[this.rowCount][this.columnCount];
            }
        }

        private JTable createTable() {
            int n;
            int n2;
            JTable jTable = new JTable(this);
            AppController.configureTable(jTable);
            jTable.setAutoResizeMode(0);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    jLabel.setHorizontalAlignment(4);
                    return jLabel;
                }
            };
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            for (n2 = 0; n2 < tableColumnModel.getColumnCount(); ++n2) {
                TableColumn tableColumn = tableColumnModel.getColumn(n2);
                tableColumn.setHeaderRenderer(defaultTableCellRenderer);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[4]);
            }
            n2 = jTable.getPreferredSize().width;
            if (n2 > 500) {
                n2 = 500;
            }
            if ((n = jTable.getRowHeight() * this.rowCount) > 400) {
                n = 400;
            }
            jTable.setPreferredScrollableViewportSize(new Dimension(n2, n));
            return jTable;
        }

        private void load() {
            int n = 0;
            for (int i = 0; i < this.rowCount; ++i) {
                int n2 = 0;
                while (n2 < this.columnCount) {
                    if (this.isDecimal) {
                        this.decimalValues[i][n2] = ((ParameterEditor)ParameterEditor.this).parameter.decimalTableValue[ParameterEditor.this.valueIndex][n];
                    } else {
                        this.integerValues[i][n2] = ((ParameterEditor)ParameterEditor.this).parameter.integerTableValue[ParameterEditor.this.valueIndex][n];
                    }
                    ++n2;
                    ++n;
                }
            }
            this.fireTableDataChanged();
            this.didEdit = false;
        }

        private void save() {
            if (!ParameterEditor.this.canEdit || !this.didEdit) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            int n = 0;
            for (int i = 0; i < this.rowCount; ++i) {
                int n2 = 0;
                while (n2 < this.columnCount) {
                    stringBuilder.append(string);
                    string = ",";
                    if (this.isDecimal) {
                        ((ParameterEditor)ParameterEditor.this).parameter.decimalTableValue[((ParameterEditor)ParameterEditor.this).valueIndex][n] = this.decimalValues[i][n2];
                        stringBuilder.append(ParameterEditor.this.doubleFormatter.format(this.decimalValues[i][n2]));
                    } else {
                        ((ParameterEditor)ParameterEditor.this).parameter.integerTableValue[((ParameterEditor)ParameterEditor.this).valueIndex][n] = this.integerValues[i][n2];
                        stringBuilder.append(String.valueOf(this.integerValues[i][n2]));
                    }
                    ++n2;
                    ++n;
                }
            }
            String string2 = stringBuilder.toString();
            if (!string2.equals(((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex])) {
                ((ParameterEditor)ParameterEditor.this).parameter.value[((ParameterEditor)ParameterEditor.this).valueIndex] = string2;
                ParameterEditor.this.parent.setDidEdit();
            }
            ParameterEditor.this.setDefaultButton.setEnabled(!((ParameterEditor)ParameterEditor.this).parameter.value[ParameterEditor.this.valueIndex].equals(((ParameterEditor)ParameterEditor.this).parameter.parameter.defaultValue[ParameterEditor.this.valueIndex]));
            this.didEdit = false;
        }

        @Override
        public int getColumnCount() {
            return this.columnCount + 1;
        }

        @Override
        public String getColumnName(int n) {
            if (0 == n) {
                return "";
            }
            return ((ParameterEditor)ParameterEditor.this).parameter.parameter.tableColumnLabels[n - 1];
        }

        public Class getColumnClass(int n) {
            if (0 == n) {
                return String.class;
            }
            if (this.isDecimal) {
                return Double.class;
            }
            return Integer.class;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!ParameterEditor.this.canEdit) {
                return false;
            }
            return 0 != n2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (0 == n2) {
                return ((ParameterEditor)ParameterEditor.this).parameter.parameter.tableRowLabels[n];
            }
            if (this.isDecimal) {
                return this.decimalValues[n][n2 - 1];
            }
            return this.integerValues[n][n2 - 1];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (!ParameterEditor.this.canEdit || 0 == n2) {
                return;
            }
            if (this.isDecimal) {
                double d = (Double)object;
                if (d < ((ParameterEditor)ParameterEditor.this).parameter.parameter.minDecimalValue || d > ((ParameterEditor)ParameterEditor.this).parameter.parameter.maxDecimalValue) {
                    ParameterEditor.this.errorReporter.reportValidationError("Edit Parameter", "The value must be in the range " + ((ParameterEditor)ParameterEditor.this).parameter.parameter.minDecimalValue + " to " + ((ParameterEditor)ParameterEditor.this).parameter.parameter.maxDecimalValue);
                } else if (d != this.decimalValues[n][n2 - 1]) {
                    this.decimalValues[n][n2 - 1] = d;
                    this.didEdit = true;
                }
            } else {
                int n3 = (Integer)object;
                if (n3 < ((ParameterEditor)ParameterEditor.this).parameter.parameter.minIntegerValue || n3 > ((ParameterEditor)ParameterEditor.this).parameter.parameter.maxIntegerValue) {
                    ParameterEditor.this.errorReporter.reportValidationError("Edit Parameter", "The value must be in the range " + ((ParameterEditor)ParameterEditor.this).parameter.parameter.minIntegerValue + " to " + ((ParameterEditor)ParameterEditor.this).parameter.parameter.maxIntegerValue);
                } else if (n3 != this.integerValues[n][n2 - 1]) {
                    this.integerValues[n][n2 - 1] = n3;
                    this.didEdit = true;
                }
            }
        }
    }

    private class TableParameterEditor
    extends AppDialog {
        private TableParameterModel model;
        private JTable table;
        private JButton okButton;
        private JButton cancelButton;

        private TableParameterEditor(AppEditor appEditor) {
            super(appEditor, ((ParameterEditor)ParameterEditor.this).parameter.parameter.name, Dialog.ModalityType.APPLICATION_MODAL);
            this.setDisposeOnClose(false);
            this.model = new TableParameterModel();
            this.table = this.model.createTable();
            if (ParameterEditor.this.canEdit) {
                this.okButton = new JButton("OK");
                this.okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableParameterEditor.this.doOK();
                    }
                });
                this.cancelButton = new JButton("Cancel");
                this.cancelButton.setFocusable(false);
                this.cancelButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableParameterEditor.this.doCancel();
                    }
                });
            } else {
                this.okButton = new JButton("Close");
                this.okButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableParameterEditor.this.doCancel();
                    }
                });
            }
            JPanel jPanel = new JPanel(new FlowLayout(2));
            if (ParameterEditor.this.canEdit) {
                jPanel.add(this.cancelButton);
            }
            jPanel.add(this.okButton);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)AppController.createScrollPane(this.table, 22, 30), "Center");
            container.add((Component)jPanel, "South");
            this.getRootPane().setDefaultButton(this.okButton);
            this.pack();
            this.setMinimumSize(this.getSize());
            this.setResizable(true);
        }

        private void doOK() {
            if (this.table.isEditing() && !this.table.getCellEditor().stopCellEditing()) {
                return;
            }
            this.model.save();
            AppController.hideWindow(this);
        }

        private void doCancel() {
            if (this.windowShouldClose()) {
                AppController.hideWindow(this);
            }
        }

        @Override
        public void windowWillOpen() {
            this.model.load();
            this.setDocumentName(((ParameterEditor)ParameterEditor.this).parameter.parameter.valueName[ParameterEditor.this.valueIndex]);
            this.setLocationRelativeTo(ParameterEditor.this.editComponent);
            this.blockActionsClear();
        }

        @Override
        public void windowWillClose() {
            if (this.table.isEditing()) {
                this.table.getCellEditor().cancelCellEditing();
            }
            this.blockActionsSet();
        }
    }
}

