/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.data.ChannelBand;
import gov.fcc.tvstudy.core.data.ChannelDelta;
import gov.fcc.tvstudy.core.data.Country;
import gov.fcc.tvstudy.core.data.EmissionMask;
import gov.fcc.tvstudy.core.data.ServiceType;
import gov.fcc.tvstudy.core.data.SignalType;
import gov.fcc.tvstudy.core.editdata.IxRuleEditData;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IxRuleEditor
extends AppDialog {
    public static final String WINDOW_TITLE = "Interference Rule";
    private IxRuleEditData ixRule;
    private boolean canEdit;
    private KeyedRecordMenu countryMenu;
    private KeyedRecordMenu serviceTypeMenu;
    private KeyedRecordMenu signalTypeMenu;
    private KeyedRecordMenu undesiredServiceTypeMenu;
    private KeyedRecordMenu undesiredSignalTypeMenu;
    private KeyedRecordMenu channelDeltaMenu;
    private KeyedRecordMenu channelBandMenu;
    private KeyedRecordMenu frequencyOffsetMenu;
    private KeyedRecordMenu emissionMaskMenu;
    private JTextField distanceField;
    private JTextField requiredDUField;
    private JTextField undesiredTimeField;
    private JButton closeButton;
    private JButton applyButton;

    public IxRuleEditor(AppEditor appEditor, int n, IxRuleEditData ixRuleEditData) {
        super(appEditor, WINDOW_TITLE, Dialog.ModalityType.MODELESS);
        Serializable serializable;
        this.ixRule = ixRuleEditData.copy();
        this.canEdit = !this.ixRule.isLocked;
        boolean bl = 0 == n || 1 == n;
        this.countryMenu = new KeyedRecordMenu(Country.getCountries());
        this.countryMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.blockActions()) {
                    ((IxRuleEditor)IxRuleEditor.this).ixRule.country = (Country)IxRuleEditor.this.countryMenu.getSelectedItem();
                    IxRuleEditor.this.blockActionsEnd();
                } else {
                    IxRuleEditor.this.countryMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.country);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Country"));
        jPanel.add(this.countryMenu);
        this.serviceTypeMenu = new KeyedRecordMenu(ServiceType.getServiceTypes((int)n));
        this.serviceTypeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.blockActions()) {
                    ServiceType serviceType = (ServiceType)IxRuleEditor.this.serviceTypeMenu.getSelectedItem();
                    if (serviceType.digital && ((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta.key > 0 && ((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta.analogOnly) {
                        IxRuleEditor.this.errorReporter.reportValidationError("Edit Service Type", "That service type cannot be used with the selected channel");
                        IxRuleEditor.this.serviceTypeMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.serviceType);
                    } else {
                        ((IxRuleEditor)IxRuleEditor.this).ixRule.serviceType = serviceType;
                        if (serviceType.digital) {
                            if (0 == ((IxRuleEditor)IxRuleEditor.this).ixRule.signalType.key) {
                                ((IxRuleEditor)IxRuleEditor.this).ixRule.signalType = SignalType.getDefaultObject();
                            }
                        } else if (((IxRuleEditor)IxRuleEditor.this).ixRule.signalType.key > 0) {
                            ((IxRuleEditor)IxRuleEditor.this).ixRule.signalType = SignalType.getNullObject();
                        }
                        if (null != IxRuleEditor.this.signalTypeMenu) {
                            AppController.setComponentEnabled(IxRuleEditor.this.signalTypeMenu, serviceType.digital);
                            IxRuleEditor.this.signalTypeMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.signalType);
                        }
                    }
                    IxRuleEditor.this.blockActionsEnd();
                } else {
                    IxRuleEditor.this.serviceTypeMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.serviceType);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Service"));
        jPanel2.add(this.serviceTypeMenu);
        JPanel jPanel3 = null;
        if (bl) {
            if (SignalType.hasMultipleOptions()) {
                this.signalTypeMenu = new KeyedRecordMenu(SignalType.getSignalTypes());
                this.signalTypeMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (IxRuleEditor.this.blockActions()) {
                            if (((IxRuleEditor)IxRuleEditor.this).ixRule.serviceType.digital) {
                                ((IxRuleEditor)IxRuleEditor.this).ixRule.signalType = (SignalType)IxRuleEditor.this.signalTypeMenu.getSelectedItem();
                            } else {
                                IxRuleEditor.this.signalTypeMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.signalType);
                            }
                            IxRuleEditor.this.blockActionsEnd();
                        } else {
                            IxRuleEditor.this.signalTypeMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.signalType);
                        }
                    }
                });
                jPanel3 = new JPanel();
                jPanel3.setBorder(BorderFactory.createTitledBorder("Mod. Type"));
                jPanel3.add(this.signalTypeMenu);
            }
        } else if (this.canEdit) {
            this.ixRule.signalType = SignalType.getNullObject();
        }
        this.undesiredServiceTypeMenu = new KeyedRecordMenu(ServiceType.getServiceTypes((int)n));
        this.undesiredServiceTypeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.blockActions()) {
                    ((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredServiceType = (ServiceType)IxRuleEditor.this.undesiredServiceTypeMenu.getSelectedItem();
                    if (null != IxRuleEditor.this.emissionMaskMenu) {
                        if (((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredServiceType.needsEmissionMask && 1 == Math.abs(((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta.delta)) {
                            AppController.setComponentEnabled(IxRuleEditor.this.emissionMaskMenu, true);
                            if (0 == ((IxRuleEditor)IxRuleEditor.this).ixRule.emissionMask.key) {
                                IxRuleEditor.this.emissionMaskMenu.setSelectedItem((KeyedRecord)EmissionMask.getInvalidObject());
                            }
                        } else {
                            AppController.setComponentEnabled(IxRuleEditor.this.emissionMaskMenu, false);
                            if (((IxRuleEditor)IxRuleEditor.this).ixRule.emissionMask.key != 0) {
                                IxRuleEditor.this.emissionMaskMenu.setSelectedItem((KeyedRecord)EmissionMask.getNullObject());
                            }
                        }
                    }
                    if (((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredServiceType.digital) {
                        if (0 == ((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredSignalType.key) {
                            ((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredSignalType = SignalType.getDefaultObject();
                        }
                    } else if (((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredSignalType.key > 0) {
                        ((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredSignalType = SignalType.getNullObject();
                    }
                    if (null != IxRuleEditor.this.undesiredSignalTypeMenu) {
                        AppController.setComponentEnabled(IxRuleEditor.this.undesiredSignalTypeMenu, ((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredServiceType.digital);
                        IxRuleEditor.this.undesiredSignalTypeMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredSignalType);
                    }
                    IxRuleEditor.this.blockActionsEnd();
                } else {
                    IxRuleEditor.this.undesiredServiceTypeMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredServiceType);
                }
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder("Service"));
        jPanel4.add(this.undesiredServiceTypeMenu);
        JPanel jPanel5 = null;
        if (bl) {
            if (SignalType.hasMultipleOptions()) {
                this.undesiredSignalTypeMenu = new KeyedRecordMenu(SignalType.getSignalTypes());
                this.undesiredSignalTypeMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (IxRuleEditor.this.blockActions()) {
                            if (((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredServiceType.digital) {
                                ((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredSignalType = (SignalType)IxRuleEditor.this.undesiredSignalTypeMenu.getSelectedItem();
                            } else {
                                IxRuleEditor.this.undesiredSignalTypeMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredSignalType);
                            }
                            IxRuleEditor.this.blockActionsEnd();
                        } else {
                            IxRuleEditor.this.undesiredSignalTypeMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredSignalType);
                        }
                    }
                });
                jPanel5 = new JPanel();
                jPanel5.setBorder(BorderFactory.createTitledBorder("Mod. Type"));
                jPanel5.add(this.undesiredSignalTypeMenu);
            }
        } else if (this.canEdit) {
            this.ixRule.undesiredSignalType = SignalType.getNullObject();
        }
        this.channelDeltaMenu = new KeyedRecordMenu(ChannelDelta.getChannelDeltas((int)n));
        this.channelDeltaMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.blockActions()) {
                    ChannelDelta channelDelta = (ChannelDelta)IxRuleEditor.this.channelDeltaMenu.getSelectedItem();
                    if (channelDelta.analogOnly && ((IxRuleEditor)IxRuleEditor.this).ixRule.serviceType.key > 0 && ((IxRuleEditor)IxRuleEditor.this).ixRule.serviceType.digital) {
                        IxRuleEditor.this.errorReporter.reportValidationError("Edit Channel", "That channel cannot be used with the selected desired service type");
                        IxRuleEditor.this.channelDeltaMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta);
                    } else {
                        ((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta = channelDelta;
                        if (null != IxRuleEditor.this.emissionMaskMenu) {
                            if (((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredServiceType.needsEmissionMask && 1 == Math.abs(channelDelta.delta)) {
                                AppController.setComponentEnabled(IxRuleEditor.this.emissionMaskMenu, true);
                                if (0 == ((IxRuleEditor)IxRuleEditor.this).ixRule.emissionMask.key) {
                                    IxRuleEditor.this.emissionMaskMenu.setSelectedItem((KeyedRecord)EmissionMask.getInvalidObject());
                                }
                            } else {
                                AppController.setComponentEnabled(IxRuleEditor.this.emissionMaskMenu, false);
                                if (((IxRuleEditor)IxRuleEditor.this).ixRule.emissionMask.key != 0) {
                                    IxRuleEditor.this.emissionMaskMenu.setSelectedItem((KeyedRecord)EmissionMask.getNullObject());
                                }
                            }
                        }
                    }
                    IxRuleEditor.this.blockActionsEnd();
                } else {
                    IxRuleEditor.this.channelDeltaMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.channelDelta);
                }
            }
        });
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createTitledBorder("Channel"));
        jPanel6.add(this.channelDeltaMenu);
        JPanel jPanel7 = null;
        if (bl) {
            this.channelBandMenu = new KeyedRecordMenu(ChannelBand.getChannelBandsWithNull());
            this.channelBandMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (IxRuleEditor.this.blockActions()) {
                        ((IxRuleEditor)IxRuleEditor.this).ixRule.channelBand = (ChannelBand)IxRuleEditor.this.channelBandMenu.getSelectedItem();
                        IxRuleEditor.this.blockActionsEnd();
                    } else {
                        IxRuleEditor.this.channelBandMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.channelBand);
                    }
                }
            });
            jPanel7 = new JPanel();
            jPanel7.setBorder(BorderFactory.createTitledBorder("Band"));
            jPanel7.add(this.channelBandMenu);
        } else if (this.canEdit) {
            this.ixRule.channelBand = ChannelBand.getNullObject();
        }
        JPanel jPanel8 = null;
        if (bl) {
            serializable = new ArrayList<KeyedRecord>();
            ((ArrayList)serializable).add(new KeyedRecord(0, "(any)"));
            ((ArrayList)serializable).add(new KeyedRecord(2, "With"));
            ((ArrayList)serializable).add(new KeyedRecord(1, "Without"));
            this.frequencyOffsetMenu = new KeyedRecordMenu((ArrayList<KeyedRecord>)serializable);
            this.frequencyOffsetMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (IxRuleEditor.this.blockActions()) {
                        ((IxRuleEditor)IxRuleEditor.this).ixRule.frequencyOffset = IxRuleEditor.this.frequencyOffsetMenu.getSelectedKey();
                        IxRuleEditor.this.blockActionsEnd();
                    } else {
                        IxRuleEditor.this.frequencyOffsetMenu.setSelectedKey(((IxRuleEditor)IxRuleEditor.this).ixRule.frequencyOffset);
                    }
                }
            });
            jPanel8 = new JPanel();
            jPanel8.setBorder(BorderFactory.createTitledBorder("Frequency Offset"));
            jPanel8.add(this.frequencyOffsetMenu);
        } else if (this.canEdit) {
            this.ixRule.frequencyOffset = 0;
        }
        serializable = null;
        if (bl) {
            this.emissionMaskMenu = new KeyedRecordMenu(EmissionMask.getEmissionMasksWithNull());
            this.emissionMaskMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (IxRuleEditor.this.blockActions()) {
                        ((IxRuleEditor)IxRuleEditor.this).ixRule.emissionMask = (EmissionMask)IxRuleEditor.this.emissionMaskMenu.getSelectedItem();
                        IxRuleEditor.this.blockActionsEnd();
                    } else {
                        IxRuleEditor.this.emissionMaskMenu.setSelectedItem((KeyedRecord)((IxRuleEditor)IxRuleEditor.this).ixRule.emissionMask);
                    }
                }
            });
            serializable = new JPanel();
            ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder("Emission Mask"));
            ((Container)serializable).add(this.emissionMaskMenu);
            AppController.setComponentEnabled(this.emissionMaskMenu, false);
        } else if (this.canEdit) {
            this.ixRule.emissionMask = EmissionMask.getNullObject();
        }
        this.distanceField = new JTextField(10);
        AppController.fixKeyBindings(this.distanceField);
        this.distanceField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.blockActions()) {
                    String string = "Edit Distance Limit";
                    String string2 = IxRuleEditor.this.distanceField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            double d = Double.parseDouble(string2);
                            if (d < 1.0 || d > 500.0) {
                                IxRuleEditor.this.errorReporter.reportValidationError(string, "The value must be in the range 1.0 to 500.0");
                            } else {
                                ((IxRuleEditor)IxRuleEditor.this).ixRule.distance = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            IxRuleEditor.this.errorReporter.reportValidationError(string, "The value must be a number");
                        }
                    }
                    IxRuleEditor.this.blockActionsEnd();
                }
                IxRuleEditor.this.distanceField.setText(AppCore.formatDistance((double)((IxRuleEditor)IxRuleEditor.this).ixRule.distance));
            }
        });
        this.distanceField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                IxRuleEditor.this.setCurrentField(IxRuleEditor.this.distanceField);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    IxRuleEditor.this.distanceField.postActionEvent();
                }
            }
        });
        JPanel jPanel9 = new JPanel();
        jPanel9.setBorder(BorderFactory.createTitledBorder("Distance Limit"));
        jPanel9.add(this.distanceField);
        this.requiredDUField = new JTextField(10);
        AppController.fixKeyBindings(this.requiredDUField);
        this.requiredDUField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.blockActions()) {
                    String string = "Edit Required D/U";
                    String string2 = IxRuleEditor.this.requiredDUField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            double d = Double.parseDouble(string2);
                            if (d < -60.0 || d > 60.0) {
                                IxRuleEditor.this.errorReporter.reportValidationError(string, "The value must be in the range -60.0  to 60.0");
                            } else {
                                ((IxRuleEditor)IxRuleEditor.this).ixRule.requiredDU = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            IxRuleEditor.this.errorReporter.reportValidationError(string, "The value must be a number");
                        }
                    }
                    IxRuleEditor.this.blockActionsEnd();
                }
                IxRuleEditor.this.requiredDUField.setText(AppCore.formatDU((double)((IxRuleEditor)IxRuleEditor.this).ixRule.requiredDU));
            }
        });
        this.requiredDUField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                IxRuleEditor.this.setCurrentField(IxRuleEditor.this.requiredDUField);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    IxRuleEditor.this.requiredDUField.postActionEvent();
                }
            }
        });
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(BorderFactory.createTitledBorder("Required D/U"));
        jPanel10.add(this.requiredDUField);
        this.undesiredTimeField = new JTextField(10);
        AppController.fixKeyBindings(this.undesiredTimeField);
        this.undesiredTimeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (IxRuleEditor.this.blockActions()) {
                    String string = "Edit Undesired % Time";
                    String string2 = IxRuleEditor.this.undesiredTimeField.getText().trim();
                    if (string2.length() > 0) {
                        try {
                            double d = Double.parseDouble(string2);
                            if (d < 0.01 || d > 99.99) {
                                IxRuleEditor.this.errorReporter.reportValidationError(string, "The value must be in the range 0.01 to 99.99");
                            } else {
                                ((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredTime = d;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            IxRuleEditor.this.errorReporter.reportValidationError(string, "The value must be a number");
                        }
                    }
                    IxRuleEditor.this.blockActionsEnd();
                }
                IxRuleEditor.this.undesiredTimeField.setText(AppCore.formatPercent((double)((IxRuleEditor)IxRuleEditor.this).ixRule.undesiredTime));
            }
        });
        this.undesiredTimeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                IxRuleEditor.this.setCurrentField(IxRuleEditor.this.undesiredTimeField);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    IxRuleEditor.this.undesiredTimeField.postActionEvent();
                }
            }
        });
        JPanel jPanel11 = new JPanel();
        jPanel11.setBorder(BorderFactory.createTitledBorder("Undesired % Time"));
        jPanel11.add(this.undesiredTimeField);
        this.closeButton = new JButton("Cancel");
        this.closeButton.setFocusable(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IxRuleEditor.this.cancel();
            }
        });
        this.applyButton = new JButton("Save");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IxRuleEditor.this.doApply();
            }
        });
        JPanel jPanel12 = new JPanel();
        jPanel12.setBorder(BorderFactory.createTitledBorder("Desired Station"));
        jPanel12.add(jPanel);
        jPanel12.add(jPanel2);
        if (null != jPanel3) {
            jPanel12.add(jPanel3);
        }
        if (null != jPanel7) {
            jPanel12.add(jPanel7);
        }
        JPanel jPanel13 = new JPanel();
        jPanel13.setBorder(BorderFactory.createTitledBorder("Undesired Station"));
        jPanel13.add(jPanel4);
        if (null != jPanel5) {
            jPanel13.add(jPanel5);
        }
        jPanel13.add(jPanel6);
        if (null != serializable) {
            jPanel13.add((Component)serializable);
        }
        JPanel jPanel14 = new JPanel();
        jPanel14.setBorder(BorderFactory.createTitledBorder("Conditions"));
        if (null != jPanel8) {
            jPanel14.add(jPanel8);
        }
        jPanel14.add(jPanel9);
        jPanel14.add(jPanel10);
        jPanel14.add(jPanel11);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new BoxLayout(jPanel15, 1));
        jPanel15.add(jPanel12);
        jPanel15.add(jPanel13);
        jPanel15.add(jPanel14);
        JPanel jPanel16 = new JPanel(new FlowLayout(2));
        jPanel16.add(this.closeButton);
        jPanel16.add(this.applyButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel15, "Center");
        container.add((Component)jPanel16, "South");
        this.getRootPane().setDefaultButton(this.applyButton);
        this.pack();
        this.setMinimumSize(this.getSize());
        this.setResizable(true);
        this.setLocationSaved(true);
        this.countryMenu.setSelectedItem((KeyedRecord)this.ixRule.country);
        AppController.setComponentEnabled(this.countryMenu, this.canEdit);
        this.serviceTypeMenu.setSelectedItem((KeyedRecord)this.ixRule.serviceType);
        AppController.setComponentEnabled(this.serviceTypeMenu, this.canEdit);
        if (null != this.signalTypeMenu) {
            this.signalTypeMenu.setSelectedItem((KeyedRecord)this.ixRule.signalType);
            if (this.ixRule.serviceType.digital) {
                AppController.setComponentEnabled(this.signalTypeMenu, this.canEdit);
            } else {
                AppController.setComponentEnabled(this.signalTypeMenu, false);
            }
        }
        if (null != this.channelBandMenu) {
            this.channelBandMenu.setSelectedItem((KeyedRecord)this.ixRule.channelBand);
            AppController.setComponentEnabled(this.channelBandMenu, this.canEdit);
        }
        this.undesiredServiceTypeMenu.setSelectedItem((KeyedRecord)this.ixRule.undesiredServiceType);
        AppController.setComponentEnabled(this.undesiredServiceTypeMenu, this.canEdit);
        if (null != this.undesiredSignalTypeMenu) {
            this.undesiredSignalTypeMenu.setSelectedItem((KeyedRecord)this.ixRule.undesiredSignalType);
            if (this.ixRule.undesiredServiceType.digital) {
                AppController.setComponentEnabled(this.undesiredSignalTypeMenu, this.canEdit);
            } else {
                AppController.setComponentEnabled(this.undesiredSignalTypeMenu, false);
            }
        }
        this.channelDeltaMenu.setSelectedItem((KeyedRecord)this.ixRule.channelDelta);
        AppController.setComponentEnabled(this.channelDeltaMenu, this.canEdit);
        if (null != this.emissionMaskMenu) {
            this.emissionMaskMenu.setSelectedItem((KeyedRecord)this.ixRule.emissionMask);
            if (this.ixRule.undesiredServiceType.needsEmissionMask && 1 == Math.abs(this.ixRule.channelDelta.delta)) {
                AppController.setComponentEnabled(this.emissionMaskMenu, this.canEdit);
            } else {
                AppController.setComponentEnabled(this.emissionMaskMenu, false);
            }
        }
        if (null != this.frequencyOffsetMenu) {
            this.frequencyOffsetMenu.setSelectedKey(this.ixRule.frequencyOffset);
            AppController.setComponentEnabled(this.frequencyOffsetMenu, this.canEdit);
        }
        this.distanceField.setText(AppCore.formatDistance((double)this.ixRule.distance));
        AppController.setComponentEnabled(this.distanceField, this.canEdit);
        this.requiredDUField.setText(AppCore.formatDU((double)this.ixRule.requiredDU));
        AppController.setComponentEnabled(this.requiredDUField, this.canEdit);
        this.undesiredTimeField.setText(AppCore.formatPercent((double)this.ixRule.undesiredTime));
        AppController.setComponentEnabled(this.undesiredTimeField, this.canEdit);
        this.updateDocumentName();
    }

    @Override
    public void updateDocumentName() {
        String string = this.parent.getDocumentName();
        if (null != this.ixRule && !this.ixRule.isActive) {
            string = null == string ? "disabled" : string + "/disabled";
        }
        this.setDocumentName(string);
    }

    private void doApply() {
        if (!this.canEdit) {
            this.cancel();
            return;
        }
        if (!this.commitCurrentField()) {
            return;
        }
        this.errorReporter.clearTitle();
        if (!this.ixRule.isDataValid((ErrorLogger)this.errorReporter)) {
            return;
        }
        if (this.parent.applyEditsFrom(this)) {
            AppController.hideWindow(this);
        }
    }

    public IxRuleEditData getIxRule() {
        return this.ixRule;
    }

    @Override
    public boolean cancel() {
        if (this.windowShouldClose()) {
            AppController.hideWindow(this);
            return true;
        }
        return false;
    }

    @Override
    public void windowWillOpen() {
        this.setLocationRelativeTo(this.getOwner());
        this.blockActionsClear();
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        this.blockActionsSet();
        this.parent.editorClosing(this);
    }
}

