/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.AntPattern;
import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.DbCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.geo.GeoBox;
import gov.fcc.tvstudy.core.geo.GeoCircle;
import gov.fcc.tvstudy.core.geo.GeoPointSet;
import gov.fcc.tvstudy.core.geo.GeoPolygon;
import gov.fcc.tvstudy.core.geo.GeoSectors;
import gov.fcc.tvstudy.core.geo.Geography;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppDialog;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.BackgroundWorker;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import gov.fcc.tvstudy.gui.RootEditor;
import gov.fcc.tvstudy.gui.StudyManager;
import gov.fcc.tvstudy.gui.editor.GeoEditPanel;
import gov.fcc.tvstudy.gui.editor.GeoPlotPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GeographyEditor
extends RootEditor {
    public static final String WINDOW_TITLE = "Geography Editor";
    private KeyedRecordMenu geoTypeMenu;
    private int geoType;
    private int studyKey = 0;
    private String studyName;
    private int sourceKey = 0;
    private String sourceName;
    private int typeMode = 1;
    private GeoListModel geoModel;
    private JList<String> geoList;
    private Geography currentGeo;
    private int currentIndex = -1;
    private boolean didEdit;
    private boolean ignoreSelectionChange;
    private JTextField nameField;
    private JPanel namePanel;
    private GeoEditPanel currentPanel;
    private JPanel editorPanel;
    private GeoPlotPanel plotPanel;
    private JTabbedPane tabPane;
    private JButton exportButton;
    private JButton duplicateButton;
    private JButton importDataButton;
    private JButton exportDataButton;
    private JButton saveButton;
    private JComboBox<String> scopeMenu;
    private JMenuItem exportMenuItem;
    private JMenuItem duplicateMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem importDataMenuItem;
    private JMenuItem exportDataMenuItem;
    private JMenuItem saveMenuItem;
    private int showGeoKey;
    private GeographyEditor outerThis = this;

    public GeographyEditor(AppEditor appEditor) {
        super(appEditor, WINDOW_TITLE);
        this.geoTypeMenu = new KeyedRecordMenu(Geography.getTypes((int)this.typeMode));
        this.geoTypeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GeographyEditor.this.blockActions()) {
                    GeographyEditor.this.doSelectionChange();
                    GeographyEditor.this.blockActionsEnd();
                }
            }
        });
        this.geoType = this.geoTypeMenu.getSelectedKey();
        this.geoModel = new GeoListModel();
        this.geoList = this.geoModel.createList();
        this.geoList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && GeographyEditor.this.blockActions()) {
                    GeographyEditor.this.doSelectionChange();
                    GeographyEditor.this.blockActionsEnd();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        jPanel.add((Component)AppController.createScrollPane(this.geoList), "Center");
        this.nameField = new JTextField(30);
        AppController.fixKeyBindings(this.nameField);
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (null == GeographyEditor.this.currentGeo) {
                    return;
                }
                if (GeographyEditor.this.blockActions()) {
                    String string = GeographyEditor.this.nameField.getText().trim();
                    if (string.length() > 0 && !((GeographyEditor)GeographyEditor.this).currentGeo.name.equals(string) && Geography.checkGeographyName((String)GeographyEditor.this.getDbID(), (String)string, (String)((GeographyEditor)GeographyEditor.this).currentGeo.name, (ErrorLogger)GeographyEditor.this.errorReporter)) {
                        ((GeographyEditor)GeographyEditor.this).currentGeo.name = string;
                        GeographyEditor.this.setDidEdit();
                        GeographyEditor.this.geoModel.dataChanged(GeographyEditor.this.currentIndex);
                    }
                    GeographyEditor.this.blockActionsEnd();
                }
                GeographyEditor.this.nameField.setText(((GeographyEditor)GeographyEditor.this).currentGeo.name);
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Component component = focusEvent.getComponent();
                if (component instanceof JTextField) {
                    GeographyEditor.this.setCurrentField((JTextField)component);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Component component;
                if (!focusEvent.isTemporary() && (component = focusEvent.getComponent()) instanceof JTextField) {
                    ((JTextField)component).postActionEvent();
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Geography Name"));
        jPanel2.add(this.nameField);
        this.namePanel = new JPanel(new FlowLayout(0));
        this.namePanel.add(jPanel2);
        this.editorPanel = new JPanel();
        this.editorPanel.setLayout(new BorderLayout());
        this.plotPanel = new GeoPlotPanel();
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Data", this.editorPanel);
        this.tabPane.addTab("Plot", this.plotPanel);
        JButton jButton = new JButton("New");
        jButton.setFocusable(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doCreateNew();
            }
        });
        this.duplicateButton = new JButton("Duplicate");
        this.duplicateButton.setFocusable(false);
        this.duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doDuplicate();
            }
        });
        JButton jButton2 = new JButton("Import");
        jButton2.setFocusable(false);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doImport();
            }
        });
        this.exportButton = new JButton("Export");
        this.exportButton.setFocusable(false);
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doExport();
            }
        });
        this.saveButton = new JButton("Save");
        this.saveButton.setFocusable(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doSave();
            }
        });
        this.importDataButton = new JButton("Import Data");
        this.importDataButton.setFocusable(false);
        this.importDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doImportData();
            }
        });
        this.exportDataButton = new JButton("Export Data");
        this.exportDataButton.setFocusable(false);
        this.exportDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doExportData();
            }
        });
        this.scopeMenu = new JComboBox();
        this.scopeMenu.setFocusable(false);
        this.scopeMenu.setPrototypeDisplayValue("XyXyXyXyXy");
        this.scopeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GeographyEditor.this.blockActions()) {
                    if (null != GeographyEditor.this.currentGeo) {
                        switch (GeographyEditor.this.scopeMenu.getSelectedIndex()) {
                            case 0: {
                                ((GeographyEditor)GeographyEditor.this).currentGeo.studyKey = 0;
                                ((GeographyEditor)GeographyEditor.this).currentGeo.sourceKey = 0;
                                break;
                            }
                            case 1: {
                                ((GeographyEditor)GeographyEditor.this).currentGeo.studyKey = GeographyEditor.this.studyKey;
                                ((GeographyEditor)GeographyEditor.this).currentGeo.sourceKey = 0;
                                break;
                            }
                            case 2: {
                                ((GeographyEditor)GeographyEditor.this).currentGeo.studyKey = GeographyEditor.this.studyKey;
                                ((GeographyEditor)GeographyEditor.this).currentGeo.sourceKey = GeographyEditor.this.sourceKey;
                            }
                        }
                        GeographyEditor.this.setDidEdit();
                    }
                    GeographyEditor.this.blockActionsEnd();
                }
            }
        });
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(new JLabel("Geography type"));
        jPanel3.add(this.geoTypeMenu);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(jButton);
        jPanel4.add(this.duplicateButton);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel5.add(jButton2);
        jPanel5.add(this.exportButton);
        Box box = Box.createVerticalBox();
        box.add(jPanel3);
        box.add(jPanel4);
        box.add(jPanel5);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)box, "North");
        jPanel6.add((Component)jPanel, "Center");
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        jPanel7.add(this.importDataButton);
        jPanel7.add(this.exportDataButton);
        JPanel jPanel8 = new JPanel();
        jPanel8.add(new JLabel("Scope:"));
        jPanel8.add(this.scopeMenu);
        JPanel jPanel9 = new JPanel(new FlowLayout(2));
        jPanel9.add(this.saveButton);
        Box box2 = Box.createHorizontalBox();
        box2.add(jPanel7);
        box2.add(jPanel8);
        box2.add(jPanel9);
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.add((Component)this.tabPane, "Center");
        jPanel10.add((Component)box2, "South");
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel6, "West");
        container.add((Component)jPanel10, "Center");
        this.pack();
        Dimension dimension = new Dimension(1070, 600);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.fileMenu.removeAll();
        JMenuItem jMenuItem = new JMenuItem("Previous");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doPrevious();
            }
        });
        this.fileMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Next");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(40, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doNext();
            }
        });
        this.fileMenu.add(jMenuItem2);
        this.fileMenu.addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem("New");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(78, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doCreateNew();
            }
        });
        this.fileMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Import...");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(73, AppController.MENU_SHORTCUT_KEY_MASK));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doImport();
            }
        });
        this.fileMenu.add(jMenuItem4);
        this.fileMenu.addSeparator();
        this.duplicateMenuItem = new JMenuItem("Duplicate");
        this.duplicateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doDuplicate();
            }
        });
        this.fileMenu.add(this.duplicateMenuItem);
        this.exportMenuItem = new JMenuItem("Export...");
        this.exportMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, AppController.MENU_SHORTCUT_KEY_MASK));
        this.exportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doExport();
            }
        });
        this.fileMenu.add(this.exportMenuItem);
        this.deleteMenuItem = new JMenuItem("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doDelete();
            }
        });
        this.fileMenu.add(this.deleteMenuItem);
        this.fileMenu.addSeparator();
        this.importDataMenuItem = new JMenuItem("Import Data...");
        this.importDataMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doImportData();
            }
        });
        this.fileMenu.add(this.importDataMenuItem);
        this.exportDataMenuItem = new JMenuItem("Export Data...");
        this.exportDataMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doExportData();
            }
        });
        this.fileMenu.add(this.exportDataMenuItem);
        this.fileMenu.addSeparator();
        this.saveMenuItem = new JMenuItem("Save");
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, AppController.MENU_SHORTCUT_KEY_MASK));
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeographyEditor.this.doSave();
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.updateDocumentName();
        this.updateControls();
    }

    @Override
    protected String getFileMenuName() {
        return "Geography";
    }

    @Override
    protected boolean showsEditMenu() {
        return false;
    }

    @Override
    public void updateDocumentName() {
        String string = DbCore.getHostDbName((String)this.getDbID());
        if (0 != this.studyKey) {
            string = null == string ? this.studyName : string + "/" + this.studyName;
            if (0 != this.sourceKey) {
                string = string + "/" + this.sourceName;
            }
        }
        this.setDocumentName(string);
    }

    private void updateControls() {
        boolean bl = null != this.currentGeo;
        boolean bl2 = bl && null != this.currentGeo.key;
        this.duplicateButton.setEnabled(bl2);
        this.duplicateMenuItem.setEnabled(bl2);
        this.exportButton.setEnabled(bl);
        this.exportMenuItem.setEnabled(bl);
        boolean bl3 = bl && (1 == this.geoType || 5 == this.geoType || 4 == this.geoType);
        this.importDataButton.setEnabled(bl3);
        this.importDataMenuItem.setEnabled(bl3);
        this.exportDataButton.setEnabled(bl3);
        this.exportDataMenuItem.setEnabled(bl3);
        this.deleteMenuItem.setEnabled(bl);
        this.scopeMenu.setEnabled(bl);
        this.saveButton.setEnabled(bl && this.didEdit);
        this.saveMenuItem.setEnabled(bl && this.didEdit);
    }

    public boolean isReceiveAntennaInUse(int n) {
        if (null != this.currentPanel && this.currentPanel instanceof GeoEditPanel.PointSetPanel) {
            return ((GeoEditPanel.PointSetPanel)this.currentPanel).isReceiveAntennaInUse(n);
        }
        return false;
    }

    public void updateReceiveAntennas() {
        if (null != this.currentPanel && this.currentPanel instanceof GeoEditPanel.PointSetPanel) {
            ((GeoEditPanel.PointSetPanel)this.currentPanel).updateReceiveAntennas();
        }
    }

    public boolean setScope(int n, String string, int n2, String string2, int n3, int n4) {
        int n5;
        if (n == this.studyKey && n2 == this.sourceKey && n3 == this.typeMode && (0 == n4 || null != this.currentGeo && null != this.currentGeo.key && n4 == this.currentGeo.key)) {
            this.studyName = string;
            this.sourceName = string2;
            this.updateDocumentName();
            return true;
        }
        this.ignoreSelectionChange = true;
        if (null != this.currentGeo) {
            if (this.saveIfNeeded("Save Geography", true)) {
                if (null == this.currentGeo.key) {
                    this.geoModel.remove(this.currentIndex);
                }
                this.clearCurrentGeo();
            } else {
                this.geoTypeMenu.setSelectedKey(this.geoType);
                this.geoList.scrollRectToVisible(this.geoList.getCellBounds(this.currentIndex, this.currentIndex));
                this.geoList.setSelectedIndex(this.currentIndex);
                this.ignoreSelectionChange = false;
                return false;
            }
        }
        this.studyKey = n;
        this.studyName = string;
        this.sourceKey = n2;
        this.sourceName = string2;
        this.typeMode = n3;
        this.updateDocumentName();
        if (n4 > 0) {
            n5 = Geography.getTypeForKey((String)this.getDbID(), (int)n4);
            if (n5 > 0) {
                this.geoType = n5;
            } else {
                n4 = 0;
            }
        }
        this.geoTypeMenu.removeAllItems();
        this.geoTypeMenu.addAllItems(Geography.getTypes((int)this.typeMode));
        if (this.geoTypeMenu.containsKey(this.geoType)) {
            this.geoTypeMenu.setSelectedKey(this.geoType);
        } else {
            this.geoType = this.geoTypeMenu.getSelectedKey();
        }
        if (this.isVisible()) {
            this.geoModel.setRows(Geography.getGeographies((String)this.getDbID(), (int)this.geoType, (int)this.studyKey, (int)this.sourceKey, (ErrorLogger)this.errorReporter));
            if (n4 > 0) {
                n5 = this.geoModel.indexOfKey(n4);
                if (n5 >= 0) {
                    this.geoList.scrollRectToVisible(this.geoList.getCellBounds(n5, n5));
                    this.geoList.setSelectedIndex(n5);
                    this.loadCurrentGeo();
                    this.tabPane.setSelectedIndex(0);
                } else {
                    this.updateControls();
                }
            } else {
                this.updateControls();
            }
        } else {
            this.showGeoKey = n4;
        }
        StudyManager.geographyScopeChanged(this.getDbID(), this.studyKey, this.sourceKey);
        this.ignoreSelectionChange = false;
        return true;
    }

    public void updateScope(int n, String string, int n2, String string2) {
        if (this.isVisible() && n == this.studyKey) {
            this.studyName = string;
            if (n2 == this.sourceKey) {
                this.sourceName = string2;
            }
            this.updateDocumentName();
        }
    }

    public boolean closeScopeIfPossible(int n, int n2) {
        if (n == this.studyKey && n2 == this.sourceKey) {
            return this.closeIfPossible();
        }
        return true;
    }

    public boolean closeScopeWithoutSave(int n, int n2) {
        if (n == this.studyKey && n2 == this.sourceKey) {
            return this.closeWithoutSave();
        }
        return true;
    }

    private void doSelectionChange() {
        int n;
        if (this.ignoreSelectionChange) {
            return;
        }
        this.ignoreSelectionChange = true;
        if (null != this.currentGeo) {
            if (this.saveIfNeeded("Save Geography", true)) {
                if (null == this.currentGeo.key) {
                    this.geoModel.remove(this.currentIndex);
                }
                this.clearCurrentGeo();
            } else {
                this.geoTypeMenu.setSelectedKey(this.geoType);
                this.geoList.scrollRectToVisible(this.geoList.getCellBounds(this.currentIndex, this.currentIndex));
                this.geoList.setSelectedIndex(this.currentIndex);
                this.ignoreSelectionChange = false;
                return;
            }
        }
        if ((n = this.geoTypeMenu.getSelectedKey()) != this.geoType) {
            this.geoType = n;
            this.geoModel.setRows(Geography.getGeographies((String)this.getDbID(), (int)this.geoType, (int)this.studyKey, (int)this.sourceKey, (ErrorLogger)this.errorReporter));
            this.updateControls();
        } else {
            this.loadCurrentGeo();
        }
        this.ignoreSelectionChange = false;
    }

    private void clearCurrentGeo() {
        this.currentGeo = null;
        this.currentIndex = -1;
        this.didEdit = false;
        this.currentPanel = null;
        this.editorPanel.removeAll();
        this.editorPanel.repaint();
        this.plotPanel.setGeography(this.currentGeo);
        this.updateControls();
    }

    private void loadCurrentGeo() {
        if (null != this.currentGeo) {
            return;
        }
        int n = this.geoList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        String string = this.errorReporter.getTitle();
        this.errorReporter.setTitle("Load Geography Data");
        this.currentIndex = n;
        this.currentGeo = this.geoModel.get(this.currentIndex);
        if (null != this.currentGeo.key && !this.currentGeo.loadData((ErrorLogger)this.errorReporter)) {
            this.setDidEdit();
        }
        try {
            GeoEditPanel geoEditPanel;
            switch (this.currentGeo.type) {
                case 1: {
                    geoEditPanel = new GeoEditPanel.PointSetPanel(this.outerThis, this.currentGeo, true);
                    break;
                }
                case 3: {
                    geoEditPanel = new GeoEditPanel.BoxPanel(this.outerThis, this.currentGeo, true);
                    break;
                }
                case 2: {
                    geoEditPanel = new GeoEditPanel.CirclePanel(this.outerThis, this.currentGeo, true);
                    break;
                }
                case 5: {
                    geoEditPanel = new GeoEditPanel.SectorsPanel(this.outerThis, this.currentGeo, true);
                    break;
                }
                case 4: {
                    geoEditPanel = new GeoEditPanel.PolygonPanel(this.outerThis, this.currentGeo, true);
                    break;
                }
                default: {
                    this.errorReporter.setTitle(string);
                    throw new Exception("Unknown geography type");
                }
            }
            this.editorPanel.add((Component)this.namePanel, "North");
            this.nameField.setText(this.currentGeo.name);
            this.editorPanel.add((Component)geoEditPanel, "Center");
            this.currentPanel = geoEditPanel;
            this.currentPanel.revalidate();
            this.editorPanel.repaint();
            this.updateControls();
            this.blockActionsStart();
            this.scopeMenu.removeAllItems();
            this.scopeMenu.addItem("Global");
            int n2 = 0;
            if (this.currentGeo.studyKey > 0) {
                this.scopeMenu.addItem("Study");
                n2 = 1;
                if (this.currentGeo.sourceKey > 0) {
                    this.scopeMenu.addItem("Record");
                    n2 = 2;
                }
            }
            this.scopeMenu.setSelectedIndex(n2);
            this.blockActionsEnd();
            if (null == this.currentGeo.key) {
                this.setDidEdit();
            } else {
                this.plotPanel.setGeography(this.currentGeo);
            }
        }
        catch (Throwable throwable) {
            AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
            this.errorReporter.reportError("Unexpected error: " + throwable);
            this.setDidEdit();
        }
        this.errorReporter.setTitle(string);
    }

    @Override
    public void setDidEdit() {
        if (null == this.currentGeo) {
            return;
        }
        this.didEdit = true;
        this.saveButton.setEnabled(true);
        this.saveMenuItem.setEnabled(true);
        this.plotPanel.setGeography(this.currentGeo);
    }

    @Override
    protected boolean isDataValid(String string) {
        if (!super.isDataValid(string)) {
            return false;
        }
        if (null == this.currentGeo) {
            return true;
        }
        if (!this.commitCurrentField() || !this.currentPanel.commitTableEdits()) {
            return false;
        }
        this.errorReporter.setTitle(string);
        return this.currentGeo.isDataValid((ErrorLogger)this.errorReporter);
    }

    @Override
    protected boolean isDataChanged() {
        if (null == this.currentGeo) {
            return false;
        }
        return this.didEdit;
    }

    @Override
    protected boolean save(String string) {
        if (!super.save(string)) {
            return false;
        }
        if (null == this.currentGeo) {
            return true;
        }
        this.errorReporter.setTitle(string);
        boolean bl = this.currentGeo.save((ErrorLogger)this.errorReporter);
        if (bl) {
            this.didEdit = false;
            this.updateControls();
            StudyManager.geographyChanged(this.getDbID(), this.studyKey, this.sourceKey, this.currentGeo.key, this.currentGeo.type);
            if (1 == this.currentGeo.type) {
                StudyManager.updateReceiveAntennas(this.getDbID());
                this.currentPanel.dataChanged();
            }
        }
        return bl;
    }

    private void doPrevious() {
        int n = this.geoModel.getSize();
        int n2 = this.geoList.getSelectedIndex();
        if (n > 0 && n2 != 0) {
            n2 = n2 < 0 ? n - 1 : --n2;
            this.geoList.scrollRectToVisible(this.geoList.getCellBounds(n2, n2));
            this.geoList.setSelectedIndex(n2);
        }
    }

    private void doNext() {
        int n = this.geoModel.getSize();
        int n2 = this.geoList.getSelectedIndex();
        if (n > 0 && n2 < n - 1) {
            n2 = n2 < 0 ? 0 : ++n2;
            this.geoList.scrollRectToVisible(this.geoList.getCellBounds(n2, n2));
            this.geoList.setSelectedIndex(n2);
        }
    }

    private void doSave() {
        if (null == this.currentGeo) {
            return;
        }
        if (this.saveIfNeeded("Save Geography", false)) {
            this.nameField.setText(this.currentGeo.name);
            this.geoModel.dataChanged(this.currentIndex);
        }
    }

    private void doCreateNew() {
        GeoPointSet geoPointSet = null;
        switch (this.geoType) {
            case 1: {
                geoPointSet = new GeoPointSet(this.getDbID());
                break;
            }
            case 3: {
                geoPointSet = new GeoBox(this.getDbID());
                break;
            }
            case 2: {
                geoPointSet = new GeoCircle(this.getDbID());
                break;
            }
            case 5: {
                geoPointSet = new GeoSectors(this.getDbID());
                break;
            }
            case 4: {
                geoPointSet = new GeoPolygon(this.getDbID());
                break;
            }
            default: {
                return;
            }
        }
        geoPointSet.studyKey = this.studyKey;
        geoPointSet.sourceKey = this.sourceKey;
        this.addNewGeography((Geography)geoPointSet);
    }

    private void doImport() {
        String string = "Import Geography";
        this.errorReporter.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XML (*.xml)", "xml"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (0 != jFileChooser.showDialog(this, "Import")) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorReporter.reportError("Could not open the file:\n" + fileNotFoundException.getMessage());
            return;
        }
        final BufferedReader bufferedReader = new BufferedReader(fileReader);
        BackgroundWorker<Geography> backgroundWorker = new BackgroundWorker<Geography>((Window)this, string){

            @Override
            protected Geography doBackgroundWork(ErrorLogger errorLogger) {
                return Geography.readGeographyFromXML((String)GeographyEditor.this.getDbID(), (Reader)bufferedReader, (ErrorLogger)errorLogger);
            }
        };
        this.errorReporter.clearMessages();
        Geography geography = (Geography)backgroundWorker.runWork("Importing geography, please wait...", this.errorReporter);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null == geography) {
            return;
        }
        this.errorReporter.showMessages();
        geography.studyKey = this.studyKey;
        geography.sourceKey = this.sourceKey;
        this.addNewGeography(geography);
    }

    private void doDuplicate() {
        if (null == this.currentGeo || null == this.currentGeo.key) {
            return;
        }
        this.addNewGeography(this.currentGeo.duplicate());
    }

    private void addNewGeography(Geography geography) {
        this.ignoreSelectionChange = true;
        if (null != this.currentGeo) {
            if (this.saveIfNeeded("Save Geography", true)) {
                if (null == this.currentGeo.key) {
                    this.geoModel.remove(this.currentIndex);
                }
                this.clearCurrentGeo();
            } else {
                this.geoList.scrollRectToVisible(this.geoList.getCellBounds(this.currentIndex, this.currentIndex));
                this.geoList.setSelectedIndex(this.currentIndex);
                this.ignoreSelectionChange = false;
                return;
            }
        }
        int n = this.geoModel.add(geography);
        this.geoList.scrollRectToVisible(this.geoList.getCellBounds(n, n));
        this.geoList.setSelectedIndex(n);
        this.loadCurrentGeo();
        this.tabPane.setSelectedIndex(0);
        this.ignoreSelectionChange = false;
    }

    private void doExport() {
        Object object;
        Object object2;
        if (null == this.currentGeo) {
            return;
        }
        String string = "Export " + Geography.getTypeName((int)this.currentGeo.type);
        this.errorReporter.setTitle(string);
        if (!this.currentGeo.isDataValid((ErrorLogger)this.errorReporter)) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("XML (*.xml)", "xml"));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        JCheckBox jCheckBox = null;
        if (1 == this.currentGeo.type) {
            for (Object object3 : ((GeoPointSet)this.currentGeo).points) {
                if (null == ((GeoPointSet.StudyPoint)object3).antenna || 0 == ((GeoPointSet.StudyPoint)object3).antenna.key) continue;
                jCheckBox = new JCheckBox("Include receive antennas");
                object2 = new JPanel(new FlowLayout(0));
                ((JComponent)object2).setBorder(BorderFactory.createTitledBorder("Export options"));
                ((Container)object2).add(jCheckBox);
                object = new JPanel(new FlowLayout(0));
                ((Container)object).add((Component)object2);
                jFileChooser.setAccessory((JComponent)object);
                break;
            }
        }
        Object object4 = null;
        do {
            Object object3;
            if (0 != jFileChooser.showDialog(this, "Export")) {
                return;
            }
            object4 = jFileChooser.getSelectedFile();
            object3 = ((File)object4).getName().toLowerCase();
            if (!((String)object3).endsWith(".xml")) {
                object4 = new File(((File)object4).getAbsolutePath() + ".xml");
            }
            if (!((File)object4).exists()) continue;
            AppController.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            object4 = null;
        } while (null == object4);
        AppCore.setProperty((String)"last_file_directory", (String)((File)object4).getParentFile().getAbsolutePath());
        object2 = null;
        try {
            object2 = new BufferedWriter(new FileWriter((File)object4));
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return;
        }
        object = new BufferedWriter((Writer)object2);
        boolean bl = null != jCheckBox ? jCheckBox.isSelected() : false;
        BackgroundWorker<Object> backgroundWorker = new BackgroundWorker<Object>((Window)this, string, (BufferedWriter)object, bl){
            final /* synthetic */ BufferedWriter val$xml;
            final /* synthetic */ boolean val$exportAntennas;
            {
                this.val$xml = bufferedWriter;
                this.val$exportAntennas = bl;
                super(window, string);
            }

            @Override
            protected Object doBackgroundWork(ErrorLogger errorLogger) {
                if (1 == ((GeographyEditor)GeographyEditor.this).currentGeo.type) {
                    ((GeoPointSet)GeographyEditor.this.currentGeo).writeToXML((Writer)this.val$xml, this.val$exportAntennas, errorLogger);
                } else {
                    GeographyEditor.this.currentGeo.writeToXML((Writer)this.val$xml, errorLogger);
                }
                return null;
            }
        };
        backgroundWorker.runWork("Exporting geography, please wait...", this.errorReporter);
        try {
            ((BufferedWriter)object).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void doDelete() {
        if (null == this.currentGeo) {
            return;
        }
        String string = "Delete Geography";
        this.errorReporter.setTitle(string);
        AppController.beep();
        int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete geography '" + this.currentGeo.name + "'?", string, 0, 2);
        if (0 != n) {
            return;
        }
        if (null != this.currentGeo.key && StudyManager.isGeographyInUse(this.getDbID(), this.currentGeo.key)) {
            this.errorReporter.reportWarning("The geography is in use and cannot be deleted");
            return;
        }
        if (null != this.currentGeo.key && !Geography.deleteGeography((String)this.getDbID(), (int)this.currentGeo.key, (ErrorLogger)this.errorReporter)) {
            return;
        }
        this.ignoreSelectionChange = true;
        int n2 = this.currentIndex;
        this.clearCurrentGeo();
        if (n2 >= 0) {
            this.geoModel.remove(n2);
            if (n2 >= this.geoModel.getSize()) {
                --n2;
            }
        } else {
            n2 = 0;
        }
        if (n2 >= 0 && n2 < this.geoModel.getSize()) {
            this.geoList.scrollRectToVisible(this.geoList.getCellBounds(n2, n2));
            this.geoList.setSelectedIndex(n2);
            this.loadCurrentGeo();
        }
        this.ignoreSelectionChange = false;
        StudyManager.geographyChanged(this.getDbID(), this.studyKey, this.sourceKey, null, 0);
    }

    private void doImportData() {
        if (null == this.currentGeo || 1 != this.geoType && 5 != this.geoType && 4 != this.geoType) {
            return;
        }
        String string = "Import " + Geography.getTypeName((int)this.geoType) + " Data";
        this.errorReporter.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        switch (this.geoType) {
            case 1: {
                jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Points (*.csv,*.txt,*.dat)", "csv", "txt", "dat"));
                break;
            }
            case 5: {
                jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Sectors (*.csv,*.txt,*.dat)", "csv", "txt", "dat"));
                break;
            }
            case 4: {
                jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Polygon (*.csv,*.txt,*.dat,*.shp)", "csv", "txt", "dat", "shp"));
            }
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (0 != jFileChooser.showDialog(this, "Import")) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        Geography geography = null;
        geography = file.getName().toLowerCase().endsWith(".shp") && 4 == this.geoType ? this.importShapefile(string, file) : this.importText(string, file);
        if (null != geography) {
            switch (this.geoType) {
                case 1: {
                    KeyedRecord keyedRecord = GeoPointSet.GENERIC_ANTENNA;
                    ArrayList arrayList = AntPattern.getReceiveAntennaList((String)this.getDbID());
                    if (null != arrayList && !arrayList.isEmpty()) {
                        arrayList.add(0, GeoPointSet.GENERIC_ANTENNA);
                        Object[] objectArray = arrayList.toArray();
                        keyedRecord = (KeyedRecord)JOptionPane.showInputDialog(this, "Select receive antenna for imported points", "Select Receive Antenna", 1, null, objectArray, objectArray[0]);
                        if (null == keyedRecord) {
                            return;
                        }
                    }
                    for (GeoPointSet.StudyPoint studyPoint : ((GeoPointSet)geography).points) {
                        studyPoint.antenna = keyedRecord;
                        ((GeoPointSet)this.currentGeo).points.add(studyPoint);
                    }
                    this.currentPanel.dataChanged();
                    this.setDidEdit();
                    break;
                }
                case 5: {
                    ((GeoSectors)this.currentGeo).sectors = ((GeoSectors)geography).sectors;
                    this.currentPanel.dataChanged();
                    this.setDidEdit();
                    break;
                }
                case 4: {
                    ((GeoPolygon)this.currentGeo).points = ((GeoPolygon)geography).points;
                    ((GeoPolygon)this.currentGeo).reference.setLatLon(((GeoPolygon)geography).reference);
                    this.currentPanel.dataChanged();
                    this.setDidEdit();
                }
            }
        }
    }

    private Geography importText(String string, File file) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return null;
        }
        GeoSectors geoSectors = null;
        String string2 = file.getName();
        String string3 = null;
        AppCore.LineCounter lineCounter = new AppCore.LineCounter();
        lineCounter.setDelimiterForFile(file);
        try {
            block8 : switch (this.geoType) {
                case 5: {
                    String string4;
                    GeoSectors geoSectors2;
                    geoSectors = geoSectors2 = new GeoSectors(this.getDbID());
                    geoSectors.studyKey = this.studyKey;
                    geoSectors.sourceKey = this.sourceKey;
                    while (null != (string4 = AppCore.readLineSkipComments((BufferedReader)bufferedReader, (AppCore.LineCounter)lineCounter))) {
                        if (0 == string4.trim().length()) continue;
                        string3 = geoSectors2.decodeFromString(string4);
                        break block8;
                    }
                    break;
                }
                case 1: {
                    String[] stringArray;
                    GeoPointSet geoPointSet = new GeoPointSet(this.getDbID());
                    geoSectors = geoPointSet;
                    geoSectors.studyKey = this.studyKey;
                    geoSectors.sourceKey = this.sourceKey;
                    StringBuilder stringBuilder = new StringBuilder();
                    GeoPointSet.StudyPoint studyPoint = null;
                    while (null != (stringArray = AppCore.readAndParseLine((BufferedReader)bufferedReader, (AppCore.LineCounter)lineCounter))) {
                        String string5;
                        int n;
                        if (0 == stringArray.length) continue;
                        if (stringArray.length > 4) {
                            n = stringArray.length - 4;
                            stringBuilder.setLength(0);
                            for (int i = 0; i <= n; ++i) {
                                stringBuilder.append(stringArray[i]);
                                if (i >= n) continue;
                                stringBuilder.append(',');
                            }
                            string5 = stringBuilder.toString().trim();
                        } else {
                            n = 0;
                            string5 = stringArray[0].trim();
                        }
                        if (string5.startsWith("\"") && string5.endsWith("\"")) {
                            string5 = string5.substring(1, string5.length() - 1).trim();
                        } else {
                            n = 0;
                        }
                        if (stringArray.length < 4 || stringArray.length - n > 4) {
                            string3 = "Bad field count in '" + string2 + "' at line " + lineCounter;
                            break block8;
                        }
                        if (string5.length() > 245) {
                            string5 = string5.substring(0, 245);
                        }
                        double d = -74.0;
                        String string6 = stringArray[n + 1].trim();
                        if (string6.length() > 0) {
                            try {
                                d = Double.parseDouble(string6);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (d < -73.0 || d > 73.5) {
                            string3 = "Missing or bad latitude in '" + string2 + "' at line " + lineCounter;
                            break block8;
                        }
                        double d2 = -181.0;
                        string6 = stringArray[n + 2].trim();
                        if (string6.length() > 0) {
                            try {
                                d2 = -Double.parseDouble(string6);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (d2 < -180.0 || d2 > 180.0) {
                            string3 = "Missing or bad longitude in '" + string2 + "' at line " + lineCounter;
                            break block8;
                        }
                        double d3 = -1.0;
                        string6 = stringArray[n + 3].trim();
                        if (string6.length() > 0) {
                            try {
                                d3 = Double.parseDouble(string6);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (d3 < 0.0 || d3 > 1000.0) {
                            string3 = "Missing or bad receiver height in '" + string2 + "' at line " + lineCounter;
                            break block8;
                        }
                        studyPoint = new GeoPointSet.StudyPoint();
                        studyPoint.name = string5;
                        studyPoint.setLatLon(d, d2);
                        studyPoint.receiveHeight = d3;
                        studyPoint.antenna = GeoPointSet.GENERIC_ANTENNA;
                        geoPointSet.points.add(studyPoint);
                    }
                    break;
                }
                case 4: {
                    String[] stringArray;
                    GeoPolygon geoPolygon = new GeoPolygon(this.getDbID());
                    geoSectors = geoPolygon;
                    geoSectors.studyKey = this.studyKey;
                    geoSectors.sourceKey = this.sourceKey;
                    double d = 999.0;
                    double d4 = -999.0;
                    double d5 = 999.0;
                    double d6 = -999.0;
                    GeoPolygon.VertexPoint vertexPoint = null;
                    while (null != (stringArray = AppCore.readAndParseLine((BufferedReader)bufferedReader, (AppCore.LineCounter)lineCounter))) {
                        if (0 == stringArray.length) continue;
                        if (2 != stringArray.length) {
                            string3 = "Bad field count in '" + string2 + "' at line " + lineCounter;
                            break;
                        }
                        double d7 = -74.0;
                        String string7 = stringArray[0].trim();
                        if (string7.length() > 0) {
                            try {
                                d7 = Double.parseDouble(string7);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (d7 < -73.0 || d7 > 73.5) {
                            string3 = "Missing or bad latitude in '" + string2 + "' at line " + lineCounter;
                            break;
                        }
                        double d8 = -181.0;
                        string7 = stringArray[1].trim();
                        if (string7.length() > 0) {
                            try {
                                d8 = -Double.parseDouble(string7);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (d8 < -180.0 || d8 > 180.0) {
                            string3 = "Missing or bad longitude in '" + string2 + "' at line " + lineCounter;
                            break;
                        }
                        vertexPoint = new GeoPolygon.VertexPoint();
                        vertexPoint.setLatLon(d7, d8);
                        geoPolygon.points.add(vertexPoint);
                        if (d7 < d) {
                            d = d7;
                        }
                        if (d7 > d4) {
                            d4 = d7;
                        }
                        if (d8 < d5) {
                            d5 = d8;
                        }
                        if (!(d8 > d6)) continue;
                        d6 = d8;
                    }
                    if (null != string3 || geoPolygon.points.size() <= 0) break;
                    geoPolygon.reference.setLatLon((d + d4) / 2.0, (d5 + d6) / 2.0);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            string3 = "An I/O error occurred in '" + string2 + "' at line " + lineCounter + ":\n" + iOException;
        }
        catch (Throwable throwable) {
            string3 = "An unexpected error occurred in '" + string2 + "' at line " + lineCounter + ":\n" + throwable;
            AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null != string3) {
            this.errorReporter.reportError(string3);
            return null;
        }
        return geoSectors;
    }

    private Geography importShapefile(String string, File file) {
        final File file2 = file;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return null;
        }
        final BufferedInputStream bufferedInputStream2 = bufferedInputStream;
        final Vector vector = new Vector();
        final ArrayList arrayList = new ArrayList();
        BackgroundWorker<String> backgroundWorker = new BackgroundWorker<String>((Window)this, string){

            @Override
            protected String doBackgroundWork(ErrorLogger errorLogger) {
                String string = file2.getName();
                String string2 = file2.getAbsolutePath();
                AppCore.DBFData dBFData = AppCore.readDBFData((File)new File(string2 = string2.substring(0, string2.length() - 4) + ".dbf"), (boolean)false, null);
                boolean bl = null != dBFData;
                ArrayList<GeoPolygon.VertexPoint> arrayList2 = null;
                byte[] byArray = new byte[65536];
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int[] nArray = null;
                int[] nArray2 = null;
                StringBuilder stringBuilder = new StringBuilder();
                String[] stringArray = null;
                String string3 = null;
                GeoPolygon.VertexPoint vertexPoint = null;
                try {
                    int n5;
                    if (100 != bufferedInputStream2.read(byArray, 0, 100)) {
                        return "Unexpected end of file reading '" + string + "'";
                    }
                    int n6 = byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | (byArray[0] & 0xFF) << 24;
                    if (9994 != n6) {
                        return "File '" + string + "' is not a shapefile";
                    }
                    int n7 = byArray[32] & 0xFF | (byArray[33] & 0xFF) << 8 | (byArray[34] & 0xFF) << 16 | (byArray[35] & 0xFF) << 24;
                    if (3 != n7 && 5 != n7) {
                        return "File '" + string + "' does not contain polygon shapes";
                    }
                    String string4 = "Poly  Part   # pts  ";
                    if (bl) {
                        stringBuilder.setLength(0);
                        stringBuilder.append(string4);
                        nArray2 = new int[dBFData.fieldCount];
                        for (n6 = 0; n6 < dBFData.fieldCount; ++n6) {
                            stringBuilder.append(dBFData.fieldName[n6]);
                            int n8 = (dBFData.fieldLength[n6] > n5 ? dBFData.fieldLength[n6] : n5) + 2;
                            for (n5 = dBFData.fieldName[n6].length(); n5 < n8; ++n5) {
                                stringBuilder.append(' ');
                            }
                            nArray2[n6] = n8 - dBFData.fieldLength[n6];
                        }
                        vector.add(stringBuilder.toString());
                    } else {
                        vector.add(string4);
                    }
                    while (12 == bufferedInputStream2.read(byArray, 0, 12)) {
                        int n9 = byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | (byArray[0] & 0xFF) << 24;
                        n7 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
                        if (0 == n7) {
                            if (!bl) continue;
                            ++n4;
                            continue;
                        }
                        if (3 != n7 && 5 != n7) {
                            return "File '" + string + "' does not contain polygon shapes";
                        }
                        if (40 != bufferedInputStream2.read(byArray, 0, 40)) {
                            return "Unexpected end of file reading '" + string + "'";
                        }
                        n = byArray[32] & 0xFF | (byArray[33] & 0xFF) << 8 | (byArray[34] & 0xFF) << 16 | (byArray[35] & 0xFF) << 24;
                        n2 = byArray[36] & 0xFF | (byArray[37] & 0xFF) << 8 | (byArray[38] & 0xFF) << 16 | (byArray[39] & 0xFF) << 24;
                        if (n > n3) {
                            n3 = n + 10;
                            nArray = new int[n3];
                        }
                        for (n6 = 0; n6 < n && 4 == bufferedInputStream2.read(byArray, 0, 4); ++n6) {
                            nArray[n6] = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
                        }
                        if (n6 < n) {
                            return "Unexpected end of file reading '" + string + "'";
                        }
                        if (bl) {
                            stringArray = (String[])dBFData.fieldData.get(n4++);
                            stringBuilder.setLength(0);
                            for (n6 = 0; n6 < dBFData.fieldCount; ++n6) {
                                stringBuilder.append(stringArray[n6]);
                                for (n5 = 0; n5 < nArray2[n6]; ++n5) {
                                    stringBuilder.append(' ');
                                }
                            }
                            string3 = stringBuilder.toString();
                            if (n4 >= dBFData.fieldData.size()) {
                                bl = false;
                            }
                        } else {
                            string3 = "";
                        }
                        for (n6 = 0; n6 < n; ++n6) {
                            arrayList2 = new ArrayList<GeoPolygon.VertexPoint>();
                            arrayList.add(arrayList2);
                            int n10 = n6 < n - 1 ? nArray[n6 + 1] : n2;
                            vector.add(String.format(Locale.US, "%4d  %4d  %6d  %s", n9, n6 + 1, n10 - nArray[n6], string3));
                            for (n5 = nArray[n6]; n5 < n10; ++n5) {
                                vertexPoint = new GeoPolygon.VertexPoint();
                                arrayList2.add(vertexPoint);
                                if (8 != bufferedInputStream2.read(byArray, 0, 8)) break;
                                long l = (long)(byArray[0] & 0xFF) | (long)(byArray[1] & 0xFF) << 8 | (long)(byArray[2] & 0xFF) << 16 | (long)(byArray[3] & 0xFF) << 24 | (long)(byArray[4] & 0xFF) << 32 | (long)(byArray[5] & 0xFF) << 40 | (long)(byArray[6] & 0xFF) << 48 | (long)(byArray[7] & 0xFF) << 56;
                                vertexPoint.longitude = -Double.longBitsToDouble(l);
                                if (8 != bufferedInputStream2.read(byArray, 0, 8)) break;
                                l = (long)(byArray[0] & 0xFF) | (long)(byArray[1] & 0xFF) << 8 | (long)(byArray[2] & 0xFF) << 16 | (long)(byArray[3] & 0xFF) << 24 | (long)(byArray[4] & 0xFF) << 32 | (long)(byArray[5] & 0xFF) << 40 | (long)(byArray[6] & 0xFF) << 48 | (long)(byArray[7] & 0xFF) << 56;
                                vertexPoint.latitude = Double.longBitsToDouble(l);
                                vertexPoint.updateDMS();
                            }
                            if (n5 >= n10) continue;
                            return "Unexpected end of file reading '" + string + "'";
                        }
                        if (n6 >= n) continue;
                        return "Unexpected end of file reading '" + string + "'";
                    }
                }
                catch (IOException iOException) {
                    return "An I/O error occurred reading '" + string + "':\n" + iOException;
                }
                catch (Throwable throwable) {
                    AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
                    return "An unexpected error occurred reading '" + string + "':\n" + throwable;
                }
                return null;
            }
        };
        String string2 = (String)backgroundWorker.runWork("Reading shapefile, please wait...", this.errorReporter);
        try {
            bufferedInputStream2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null != string2) {
            this.errorReporter.reportError(string2);
            return null;
        }
        if (arrayList.isEmpty()) {
            this.errorReporter.reportWarning("File '" + file.getName() + "' does not contain any non-null shapes");
            return null;
        }
        GeoPolygon geoPolygon = new GeoPolygon(this.getDbID());
        geoPolygon.studyKey = this.studyKey;
        geoPolygon.sourceKey = this.sourceKey;
        if (arrayList.size() > 1) {
            PickPolyDialog pickPolyDialog = new PickPolyDialog("Choose Polygon", vector, arrayList);
            AppController.showWindow(pickPolyDialog);
            if (pickPolyDialog.canceled) {
                return null;
            }
            geoPolygon.points = (ArrayList)arrayList.get(pickPolyDialog.index);
        } else {
            geoPolygon.points = (ArrayList)arrayList.get(0);
        }
        double d = 999.0;
        double d2 = -999.0;
        double d3 = 999.0;
        double d4 = -999.0;
        for (GeoPolygon.VertexPoint vertexPoint : geoPolygon.points) {
            if (vertexPoint.latitude < d) {
                d = vertexPoint.latitude;
            }
            if (vertexPoint.latitude > d2) {
                d2 = vertexPoint.latitude;
            }
            if (vertexPoint.longitude < d3) {
                d3 = vertexPoint.longitude;
            }
            if (!(vertexPoint.longitude > d4)) continue;
            d4 = vertexPoint.longitude;
        }
        geoPolygon.reference.setLatLon((d + d2) / 2.0, (d3 + d4) / 2.0);
        return geoPolygon;
    }

    private void doExportData() {
        if (null == this.currentGeo || 1 != this.currentGeo.type && 5 != this.currentGeo.type && 4 != this.currentGeo.type) {
            return;
        }
        String string = "Export " + Geography.getTypeName((int)this.currentGeo.type) + " Data";
        this.errorReporter.setTitle(string);
        if (!this.currentGeo.isDataValid((ErrorLogger)this.errorReporter)) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser(AppCore.getProperty((String)"last_file_directory"));
        jFileChooser.setDialogType(1);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        switch (this.currentGeo.type) {
            case 1: {
                jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Points (*.csv)", "csv"));
                break;
            }
            case 5: {
                jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Sectors (*.csv)", "csv"));
                break;
            }
            case 4: {
                jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Polygon (*.csv)", "csv"));
            }
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        File file = null;
        do {
            if (0 != jFileChooser.showDialog(this, "Export Data")) {
                return;
            }
            file = jFileChooser.getSelectedFile();
            String string2 = file.getName().toLowerCase();
            if (!string2.endsWith(".csv")) {
                file = new File(file.getAbsolutePath() + ".csv");
            }
            if (!file.exists()) continue;
            AppController.beep();
            if (0 == JOptionPane.showConfirmDialog(this, "The file exists, do you want to replace it?", string, 0, 2)) continue;
            file = null;
        } while (null == file);
        AppCore.setProperty((String)"last_file_directory", (String)file.getParentFile().getAbsolutePath());
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException iOException) {
            this.errorReporter.reportError("Could not open the file:\n" + iOException.getMessage());
            return;
        }
        String string3 = file.getName();
        String string4 = null;
        try {
            switch (this.currentGeo.type) {
                case 1: {
                    for (GeoPointSet.StudyPoint studyPoint : ((GeoPointSet)this.currentGeo).points) {
                        bufferedWriter.write(String.format(Locale.US, "\"%s\",%f,%f,%f\n", studyPoint.name, studyPoint.latitude, -studyPoint.longitude, studyPoint.receiveHeight));
                    }
                    break;
                }
                case 5: {
                    bufferedWriter.write(((GeoSectors)this.currentGeo).encodeAsString());
                    bufferedWriter.write("\n");
                    break;
                }
                case 4: {
                    for (GeoPolygon.VertexPoint vertexPoint : ((GeoPolygon)this.currentGeo).points) {
                        bufferedWriter.write(String.format(Locale.US, "%f,%f\n", vertexPoint.latitude, -vertexPoint.longitude));
                    }
                    break;
                }
            }
        }
        catch (IOException iOException) {
            string4 = "An I/O error occurred writing to '" + string3 + "':\n" + iOException;
        }
        catch (Throwable throwable) {
            string4 = "An unexpected error occurred writing to '" + string3 + "':\n" + throwable;
            AppCore.log((int)3, (String)"Unexpected error", (Throwable)throwable);
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (null != string4) {
            this.errorReporter.reportError(string4);
        }
    }

    @Override
    public void windowWillOpen() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GeographyEditor.this.geoType = GeographyEditor.this.geoTypeMenu.getSelectedKey();
                GeographyEditor.this.geoModel.setRows(Geography.getGeographies((String)GeographyEditor.this.getDbID(), (int)GeographyEditor.this.geoType, (int)GeographyEditor.this.studyKey, (int)GeographyEditor.this.sourceKey, (ErrorLogger)GeographyEditor.this.errorReporter));
                if (GeographyEditor.this.showGeoKey > 0) {
                    int n = GeographyEditor.this.geoModel.indexOfKey(GeographyEditor.this.showGeoKey);
                    if (n >= 0) {
                        GeographyEditor.this.geoList.scrollRectToVisible(GeographyEditor.this.geoList.getCellBounds(n, n));
                        GeographyEditor.this.geoList.setSelectedIndex(n);
                        GeographyEditor.this.loadCurrentGeo();
                    }
                    GeographyEditor.this.showGeoKey = 0;
                }
            }
        });
        this.blockActionsClear();
    }

    @Override
    public boolean windowShouldClose() {
        if (!this.isVisible()) {
            return true;
        }
        if (!this.saveIfNeeded("Close Geography Editor", true)) {
            this.toFront();
            return false;
        }
        return true;
    }

    @Override
    public void windowWillClose() {
        if (!this.isVisible()) {
            return;
        }
        this.clearCurrentGeo();
        this.geoModel.setRows(null);
        this.blockActionsSet();
        this.parent.editorClosing(this);
        StudyManager.geographyScopeChanged(this.getDbID(), -1, -1);
    }

    @Override
    public boolean closeWithoutSave() {
        if (this.isVisible()) {
            AppController.hideWindow(this);
        }
        return true;
    }

    private class PickPolyDialog
    extends AppDialog {
        private ArrayList<ArrayList<GeoPolygon.VertexPoint>> polys;
        private JList<String> polyList;
        private int index;
        private GeoPlotPanel previewPlot;
        private JButton okButton;
        private boolean canceled;

        private PickPolyDialog(String string, Vector<String> vector, ArrayList<ArrayList<GeoPolygon.VertexPoint>> arrayList) {
            super(GeographyEditor.this.outerThis, string, Dialog.ModalityType.APPLICATION_MODAL);
            this.index = -1;
            this.polys = arrayList;
            this.polyList = new JList<String>(vector);
            this.polyList.setFont(new Font("Monospaced", 0, 12));
            this.polyList.setSelectionMode(0);
            this.polyList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        PickPolyDialog.this.index = PickPolyDialog.this.polyList.getSelectedIndex() - 1;
                        if (PickPolyDialog.this.index >= 0) {
                            PickPolyDialog.this.okButton.setEnabled(true);
                            PickPolyDialog.this.previewPlot.setVertexPoints((ArrayList)PickPolyDialog.this.polys.get(PickPolyDialog.this.index));
                        } else {
                            PickPolyDialog.this.okButton.setEnabled(false);
                            PickPolyDialog.this.previewPlot.setVertexPoints(null);
                        }
                    }
                }
            });
            this.previewPlot = new GeoPlotPanel();
            this.okButton = new JButton("OK");
            this.okButton.setFocusable(false);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PickPolyDialog.this.doOK();
                }
            });
            this.okButton.setEnabled(false);
            JButton jButton = new JButton("Cancel");
            jButton.setFocusable(false);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PickPolyDialog.this.doCancel();
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)AppController.createScrollPane(this.polyList, 22, 30), "Center");
            Dimension dimension = new Dimension(200, 0);
            jPanel.setMinimumSize(dimension);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.previewPlot, "Center");
            dimension = new Dimension(400, 0);
            jPanel2.setMinimumSize(dimension);
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            jPanel3.add(jButton);
            jPanel3.add(this.okButton);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)new JSplitPane(1, false, jPanel, jPanel2), "Center");
            container.add((Component)jPanel3, "South");
            this.pack();
            dimension = new Dimension(800, 500);
            this.setMinimumSize(dimension);
            this.setSize(dimension);
            this.setResizable(true);
            this.setLocationRelativeTo(GeographyEditor.this.outerThis);
        }

        private void doOK() {
            if (this.index < 0) {
                return;
            }
            AppController.hideWindow(this);
        }

        private void doCancel() {
            this.canceled = true;
            AppController.hideWindow(this);
        }

        @Override
        public void windowWillOpen() {
            this.blockActionsClear();
        }

        @Override
        public void windowWillClose() {
            this.blockActionsSet();
        }
    }

    private class GeoListModel
    extends AbstractListModel<String> {
        private ArrayList<Geography> modelRows = new ArrayList();

        private GeoListModel() {
        }

        private JList<String> createList() {
            JList<String> jList = new JList<String>(this);
            jList.setSelectionMode(0);
            return jList;
        }

        private void setRows(ArrayList<Geography> arrayList) {
            if (!this.modelRows.isEmpty()) {
                int n = this.modelRows.size() - 1;
                this.modelRows.clear();
                this.fireIntervalRemoved(this, 0, n);
            }
            if (null != arrayList && !arrayList.isEmpty()) {
                this.modelRows.addAll(arrayList);
                this.fireIntervalAdded(this, 0, this.modelRows.size() - 1);
            }
        }

        private void set(int n, Geography geography) {
            this.modelRows.set(n, geography);
            this.fireContentsChanged(this, n, n);
        }

        private int add(Geography geography) {
            this.modelRows.add(0, geography);
            this.fireIntervalAdded(this, 0, 0);
            return 0;
        }

        private Geography get(int n) {
            return this.modelRows.get(n);
        }

        private void remove(int n) {
            this.modelRows.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }

        private int indexOf(Geography geography) {
            return this.modelRows.indexOf(geography);
        }

        private int indexOfKey(int n) {
            for (int i = 0; i < this.modelRows.size(); ++i) {
                Geography geography = this.modelRows.get(i);
                if (null == geography.key || n != geography.key) continue;
                return i;
            }
            return -1;
        }

        private void dataChanged(int n) {
            this.fireContentsChanged(this, n, n);
        }

        @Override
        public int getSize() {
            return this.modelRows.size();
        }

        @Override
        public String getElementAt(int n) {
            String string = this.modelRows.get((int)n).name;
            if (null == string) {
                string = "";
            }
            if (0 == (string = string.trim()).length()) {
                string = "(new)";
            }
            return string;
        }
    }
}

