/*
 * Decompiled with CFR 0.152.
 */
package gov.fcc.tvstudy.gui.editor;

import gov.fcc.tvstudy.core.AppCore;
import gov.fcc.tvstudy.core.ErrorLogger;
import gov.fcc.tvstudy.core.KeyedRecord;
import gov.fcc.tvstudy.core.geo.GeoBox;
import gov.fcc.tvstudy.core.geo.GeoCircle;
import gov.fcc.tvstudy.core.geo.GeoPointSet;
import gov.fcc.tvstudy.core.geo.GeoPolygon;
import gov.fcc.tvstudy.core.geo.GeoSectors;
import gov.fcc.tvstudy.core.geo.Geography;
import gov.fcc.tvstudy.gui.AppController;
import gov.fcc.tvstudy.gui.AppEditor;
import gov.fcc.tvstudy.gui.AppPanel;
import gov.fcc.tvstudy.gui.CoordinateCopyPastePanel;
import gov.fcc.tvstudy.gui.KeyedRecordMenu;
import gov.fcc.tvstudy.gui.editor.CoordinatePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class GeoEditPanel
extends AppPanel {
    protected boolean canEdit;

    protected GeoEditPanel(AppEditor appEditor, boolean bl) {
        super(appEditor);
        this.canEdit = bl;
    }

    public void dataChanged() {
    }

    public boolean commitTableEdits() {
        return true;
    }

    protected void moveTableSelection(JTable jTable, int n, int n2, boolean bl) {
        int n3;
        boolean bl2 = n < 0 || n2 < 0;
        int n4 = jTable.getRowCount();
        int n5 = jTable.getColumnCount();
        if (0 == n4) {
            if (bl2) {
                jTable.transferFocusBackward();
            } else {
                jTable.transferFocus();
            }
            return;
        }
        int n6 = jTable.getEditingRow();
        if (n6 < 0) {
            n6 = jTable.getSelectedRow();
        }
        if ((n3 = jTable.getEditingColumn()) < 0) {
            n3 = jTable.getSelectedColumn();
        }
        if (n6 < 0 || n3 < 0) {
            if (bl && bl2) {
                n6 = n4 - 1 - n;
                n3 = n5 - 1 - n2;
            } else {
                n6 = -n;
                n3 = -n2;
            }
        }
        if (jTable.isEditing()) {
            if (this.canEdit) {
                jTable.getCellEditor().stopCellEditing();
            } else {
                jTable.getCellEditor().cancelCellEditing();
            }
        }
        n3 += n2;
        if ((n6 += n) < 0) {
            if (bl) {
                jTable.transferFocusBackward();
                return;
            }
            n6 = n4 - 1;
        }
        if (n6 >= n4) {
            if (bl) {
                jTable.transferFocus();
                return;
            }
            n6 = 0;
        }
        if (n3 < 0) {
            if (bl && --n6 < 0) {
                jTable.transferFocusBackward();
                return;
            }
            n3 = n5 - 1;
        }
        if (n3 >= n5) {
            if (bl && ++n6 >= n4) {
                jTable.transferFocus();
                return;
            }
            n3 = 0;
        }
        jTable.changeSelection(n6, n3, false, false);
        if (this.canEdit) {
            jTable.editCellAt(n6, n3);
            Component component = jTable.getEditorComponent();
            if (null != component) {
                component.requestFocusInWindow();
            }
        }
    }

    public static class PolygonPanel
    extends GeoEditPanel {
        private GeoPolygon polygon;
        private CoordinatePanel latitudePanel;
        private CoordinatePanel longitudePanel;
        private CoordinateCopyPastePanel copyPastePanel;
        private VertexPointsTableModel pointsModel;
        private JTable pointsTable;
        private JButton insertButton;
        private JButton deleteButton;
        private JButton setReferenceButton;

        public PolygonPanel(AppEditor appEditor, Geography geography, boolean bl) {
            super(appEditor, bl);
            JComponent jComponent;
            this.blockActionsStart();
            this.polygon = (GeoPolygon)geography;
            Runnable runnable = null;
            if (this.canEdit) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        this.setDidEdit();
                    }
                };
            }
            this.latitudePanel = new CoordinatePanel(this.parent, this.polygon.reference, false, runnable);
            this.latitudePanel.setEnabled(this.canEdit);
            this.longitudePanel = new CoordinatePanel(this.parent, this.polygon.reference, true, runnable);
            this.longitudePanel.setEnabled(this.canEdit);
            this.copyPastePanel = new CoordinateCopyPastePanel(this.latitudePanel, this.longitudePanel);
            this.copyPastePanel.setEnabled(this.canEdit);
            this.pointsModel = new VertexPointsTableModel();
            this.pointsTable = this.pointsModel.createTable();
            String string = "moveUp";
            String string2 = "moveDown";
            String string3 = "moveLeft";
            String string4 = "moveRight";
            String string5 = "tabForward";
            String string6 = "tabBackward";
            ActionMap actionMap = this.pointsTable.getActionMap();
            actionMap.put(string, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(pointsTable, -1, 0, false);
                }
            });
            actionMap.put(string2, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(pointsTable, 1, 0, false);
                }
            });
            actionMap.put(string3, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(pointsTable, 0, -1, false);
                }
            });
            actionMap.put(string4, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(pointsTable, 0, 1, false);
                }
            });
            actionMap.put(string5, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(pointsTable, 0, 1, true);
                }
            });
            actionMap.put(string6, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(pointsTable, 0, -1, true);
                }
            });
            KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(40, 0);
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke(37, 0);
            KeyStroke keyStroke4 = KeyStroke.getKeyStroke(39, 0);
            KeyStroke keyStroke5 = KeyStroke.getKeyStroke(9, 0);
            KeyStroke keyStroke6 = KeyStroke.getKeyStroke(9, 1);
            InputMap inputMap = this.pointsTable.getInputMap(0);
            inputMap.put(keyStroke, string);
            inputMap.put(keyStroke2, string2);
            inputMap.put(keyStroke3, string3);
            inputMap.put(keyStroke4, string4);
            inputMap.put(keyStroke5, string5);
            inputMap.put(keyStroke6, string6);
            inputMap = this.pointsTable.getInputMap(1);
            inputMap.put(keyStroke, string);
            inputMap.put(keyStroke2, string2);
            inputMap.put(keyStroke3, string3);
            inputMap.put(keyStroke4, string4);
            inputMap.put(keyStroke5, string5);
            inputMap.put(keyStroke6, string6);
            this.pointsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting() && canEdit) {
                        if (1 == pointsTable.getSelectedRowCount()) {
                            insertButton.setEnabled(true);
                            deleteButton.setEnabled(true);
                        } else {
                            insertButton.setEnabled(false);
                            deleteButton.setEnabled(false);
                        }
                    }
                }
            });
            JPanel jPanel = null;
            if (this.canEdit) {
                jComponent = new JButton("Add");
                jComponent.setFocusable(false);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doAddVertex();
                    }
                });
                this.insertButton = new JButton("Insert");
                this.insertButton.setFocusable(false);
                this.insertButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doInsertVertex();
                    }
                });
                this.insertButton.setEnabled(false);
                this.deleteButton = new JButton("Delete");
                this.deleteButton.setFocusable(false);
                this.deleteButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doDeleteVertex();
                    }
                });
                this.deleteButton.setEnabled(false);
                this.setReferenceButton = new JButton("Center");
                this.setReferenceButton.setFocusable(false);
                this.setReferenceButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doSetReferencePoint();
                    }
                });
                this.setReferenceButton.setEnabled(!this.polygon.points.isEmpty());
                jPanel = new JPanel(new FlowLayout(0));
                jPanel.add(jComponent);
                jPanel.add(this.insertButton);
                jPanel.add(this.deleteButton);
            }
            jComponent = new JPanel();
            jComponent.setBorder(BorderFactory.createTitledBorder("Reference Point"));
            jComponent.add(this.latitudePanel);
            jComponent.add(this.longitudePanel);
            jComponent.add(this.copyPastePanel);
            if (null != this.setReferenceButton) {
                jComponent.add(this.setReferenceButton);
            }
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)AppController.createScrollPane(this.pointsTable), "Center");
            AppController.setComponentEnabled(this.pointsTable, this.canEdit);
            if (null != jPanel) {
                jPanel2.add(jPanel, "South");
            }
            jPanel2.setBorder(BorderFactory.createTitledBorder("Vertex Points (NAD83)"));
            this.setLayout(new BorderLayout());
            this.add((Component)jComponent, "North");
            this.add(jPanel2);
            this.dataChanged();
            this.blockActionsEnd();
        }

        @Override
        public void dataChanged() {
            this.latitudePanel.updatePanel();
            this.longitudePanel.updatePanel();
            this.pointsModel.dataChanged();
        }

        private void doAddVertex() {
            if (!this.canEdit || !this.commitTableEdits()) {
                return;
            }
            GeoPolygon.VertexPoint vertexPoint = new GeoPolygon.VertexPoint();
            int n = this.pointsModel.add(vertexPoint);
            this.pointsTable.scrollRectToVisible(this.pointsTable.getCellRect(n, 0, true));
            this.pointsTable.setRowSelectionInterval(n, n);
        }

        private void doInsertVertex() {
            if (!this.canEdit || !this.commitTableEdits()) {
                return;
            }
            int n = this.pointsTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            GeoPolygon.VertexPoint vertexPoint = new GeoPolygon.VertexPoint();
            this.pointsModel.insert(n, vertexPoint);
            this.pointsTable.scrollRectToVisible(this.pointsTable.getCellRect(n, 0, true));
            this.pointsTable.setRowSelectionInterval(n, n);
        }

        private void doDeleteVertex() {
            if (!this.canEdit || !this.commitTableEdits()) {
                return;
            }
            int n = this.pointsTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            this.pointsModel.remove(n);
            if (n >= this.pointsModel.getRowCount()) {
                --n;
            }
            if (n >= 0 && n < this.pointsModel.getRowCount()) {
                this.pointsTable.scrollRectToVisible(this.pointsTable.getCellRect(n, 0, true));
                this.pointsTable.setRowSelectionInterval(n, n);
            }
        }

        @Override
        public boolean commitTableEdits() {
            if (this.pointsTable.isEditing()) {
                if (this.canEdit) {
                    this.errorReporter.clearErrors();
                    this.pointsTable.getCellEditor().stopCellEditing();
                    return !this.errorReporter.hasErrors();
                }
                this.pointsTable.getCellEditor().cancelCellEditing();
            }
            return true;
        }

        private void doSetReferencePoint() {
            double d;
            if (!this.canEdit || !this.commitTableEdits()) {
                return;
            }
            if (this.polygon.points.isEmpty()) {
                return;
            }
            double d2 = 999.0;
            double d3 = -999.0;
            double d4 = 999.0;
            double d5 = -999.0;
            for (GeoPolygon.VertexPoint vertexPoint : this.polygon.points) {
                if (vertexPoint.latitude < d2) {
                    d2 = vertexPoint.latitude;
                }
                if (vertexPoint.latitude > d3) {
                    d3 = vertexPoint.latitude;
                }
                if (vertexPoint.longitude < d4) {
                    d4 = vertexPoint.longitude;
                }
                if (!(vertexPoint.longitude > d5)) continue;
                d5 = vertexPoint.longitude;
            }
            boolean bl = false;
            double d6 = (d2 + d3) / 2.0;
            if (d6 != this.polygon.reference.latitude) {
                this.polygon.reference.latitude = d6;
                bl = true;
            }
            if ((d = (d4 + d5) / 2.0) != this.polygon.reference.longitude) {
                this.polygon.reference.longitude = d;
                bl = true;
            }
            if (bl) {
                this.setDidEdit();
                this.polygon.reference.updateDMS();
                this.latitudePanel.updatePanel();
                this.longitudePanel.updatePanel();
            }
        }

        private class VertexPointsTableModel
        extends AbstractTableModel {
            private static final String NS_COLUMN = "NS";
            private static final String LATD_COLUMN = "Lat D";
            private static final String LATM_COLUMN = "Lat M";
            private static final String LATS_COLUMN = "Lat S";
            private static final String WE_COLUMN = "WE";
            private static final String LOND_COLUMN = "Lon D";
            private static final String LONM_COLUMN = "Lon M";
            private static final String LONS_COLUMN = "Lon S";
            private String[] columnNames = new String[]{"NS", "Lat D", "Lat M", "Lat S", "WE", "Lon D", "Lon M", "Lon S"};
            private static final int NS_INDEX = 0;
            private static final int LATD_INDEX = 1;
            private static final int LATM_INDEX = 2;
            private static final int LATS_INDEX = 3;
            private static final int WE_INDEX = 4;
            private static final int LOND_INDEX = 5;
            private static final int LONM_INDEX = 6;
            private static final int LONS_INDEX = 7;

            private VertexPointsTableModel() {
            }

            private JTable createTable() {
                JTable jTable = new JTable(this);
                jTable.setColumnSelectionAllowed(false);
                jTable.getTableHeader().setReorderingAllowed(false);
                jTable.setSelectionMode(0);
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                KeyedRecordMenu keyedRecordMenu = new KeyedRecordMenu();
                keyedRecordMenu.addItem(new KeyedRecord(0, "N"));
                keyedRecordMenu.addItem(new KeyedRecord(1, "S"));
                DefaultCellEditor defaultCellEditor = new DefaultCellEditor(keyedRecordMenu);
                TableColumn tableColumn = tableColumnModel.getColumn(0);
                tableColumn.setCellEditor(defaultCellEditor);
                tableColumn.setMinWidth(AppController.textFieldWidth[2]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[3]);
                JTextField jTextField = new JTextField(8);
                AppController.fixKeyBindings(jTextField);
                jTextField.setBorder(new LineBorder(Color.BLACK));
                DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(jTextField);
                defaultCellEditor2.setClickCountToStart(1);
                tableColumn = tableColumnModel.getColumn(1);
                tableColumn.setCellEditor(defaultCellEditor2);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
                tableColumn = tableColumnModel.getColumn(2);
                tableColumn.setCellEditor(defaultCellEditor2);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
                tableColumn = tableColumnModel.getColumn(3);
                tableColumn.setCellEditor(defaultCellEditor2);
                tableColumn.setMinWidth(AppController.textFieldWidth[4]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
                KeyedRecordMenu keyedRecordMenu2 = new KeyedRecordMenu();
                keyedRecordMenu2.addItem(new KeyedRecord(0, "W"));
                keyedRecordMenu2.addItem(new KeyedRecord(1, "E"));
                DefaultCellEditor defaultCellEditor3 = new DefaultCellEditor(keyedRecordMenu2);
                tableColumn = tableColumnModel.getColumn(4);
                tableColumn.setCellEditor(defaultCellEditor3);
                tableColumn.setMinWidth(AppController.textFieldWidth[2]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[3]);
                tableColumn = tableColumnModel.getColumn(5);
                tableColumn.setCellEditor(defaultCellEditor2);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
                tableColumn = tableColumnModel.getColumn(6);
                tableColumn.setCellEditor(defaultCellEditor2);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
                tableColumn = tableColumnModel.getColumn(7);
                tableColumn.setCellEditor(defaultCellEditor2);
                tableColumn.setMinWidth(AppController.textFieldWidth[4]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
                return jTable;
            }

            private int add(GeoPolygon.VertexPoint vertexPoint) {
                if (!PolygonPanel.this.canEdit) {
                    return -1;
                }
                int n = ((PolygonPanel)PolygonPanel.this).polygon.points.size();
                ((PolygonPanel)PolygonPanel.this).polygon.points.add(vertexPoint);
                PolygonPanel.this.setDidEdit();
                this.fireTableRowsInserted(n, n);
                PolygonPanel.this.setReferenceButton.setEnabled(true);
                return n;
            }

            private void insert(int n, GeoPolygon.VertexPoint vertexPoint) {
                if (!PolygonPanel.this.canEdit) {
                    return;
                }
                ((PolygonPanel)PolygonPanel.this).polygon.points.add(n, vertexPoint);
                PolygonPanel.this.setDidEdit();
                this.fireTableRowsInserted(n, n);
                PolygonPanel.this.setReferenceButton.setEnabled(true);
            }

            private void remove(int n) {
                if (!PolygonPanel.this.canEdit) {
                    return;
                }
                ((PolygonPanel)PolygonPanel.this).polygon.points.remove(n);
                PolygonPanel.this.setDidEdit();
                this.fireTableRowsDeleted(n, n);
                PolygonPanel.this.setReferenceButton.setEnabled(!((PolygonPanel)PolygonPanel.this).polygon.points.isEmpty());
            }

            private void dataChanged() {
                this.fireTableDataChanged();
                PolygonPanel.this.setReferenceButton.setEnabled(!((PolygonPanel)PolygonPanel.this).polygon.points.isEmpty());
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public String getColumnName(int n) {
                return this.columnNames[n];
            }

            @Override
            public int getRowCount() {
                return ((PolygonPanel)PolygonPanel.this).polygon.points.size();
            }

            public Class getColumnClass(int n) {
                switch (n) {
                    case 0: 
                    case 4: {
                        return KeyedRecord.class;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return String.class;
                    }
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return PolygonPanel.this.canEdit;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                GeoPolygon.VertexPoint vertexPoint = (GeoPolygon.VertexPoint)((PolygonPanel)PolygonPanel.this).polygon.points.get(n);
                switch (n2) {
                    case 0: {
                        return new KeyedRecord(vertexPoint.latitudeNS, 0 == vertexPoint.latitudeNS ? "N" : "S");
                    }
                    case 1: {
                        return String.valueOf(vertexPoint.latitudeDegrees);
                    }
                    case 2: {
                        return String.valueOf(vertexPoint.latitudeMinutes);
                    }
                    case 3: {
                        return AppCore.formatSeconds((double)vertexPoint.latitudeSeconds);
                    }
                    case 4: {
                        return new KeyedRecord(vertexPoint.longitudeWE, 0 == vertexPoint.longitudeWE ? "W" : "E");
                    }
                    case 5: {
                        return String.valueOf(vertexPoint.longitudeDegrees);
                    }
                    case 6: {
                        return String.valueOf(vertexPoint.longitudeMinutes);
                    }
                    case 7: {
                        return AppCore.formatSeconds((double)vertexPoint.longitudeSeconds);
                    }
                }
                return "";
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!PolygonPanel.this.canEdit || n < 0 || n >= ((PolygonPanel)PolygonPanel.this).polygon.points.size()) {
                    return;
                }
                GeoPolygon.VertexPoint vertexPoint = (GeoPolygon.VertexPoint)((PolygonPanel)PolygonPanel.this).polygon.points.get(n);
                PolygonPanel.this.errorReporter.setTitle("Edit Vertex");
                switch (n2) {
                    case 0: {
                        int n3 = ((KeyedRecord)object).key;
                        if (n3 == vertexPoint.latitudeNS) break;
                        vertexPoint.latitudeNS = n3;
                        vertexPoint.updateLatLon();
                        PolygonPanel.this.setDidEdit();
                        break;
                    }
                    case 4: {
                        int n4 = ((KeyedRecord)object).key;
                        if (n4 == vertexPoint.longitudeWE) break;
                        vertexPoint.longitudeWE = n4;
                        vertexPoint.updateLatLon();
                        PolygonPanel.this.setDidEdit();
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.setVertexPointField(vertexPoint, n, n2, ((String)object).trim());
                        return;
                    }
                }
            }

            private void setVertexPointField(GeoPolygon.VertexPoint vertexPoint, int n, int n2, String string) {
                double d;
                double d2;
                int n3;
                int n4;
                double d3;
                if (!PolygonPanel.this.canEdit || 0 == string.length()) {
                    return;
                }
                String string2 = "";
                try {
                    d3 = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    PolygonPanel.this.errorReporter.reportValidationError("Input must be a number");
                    return;
                }
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: {
                        n4 = vertexPoint.latitudeDegrees;
                        n3 = vertexPoint.latitudeMinutes;
                        d2 = vertexPoint.latitudeSeconds;
                        d = 73.5;
                        string2 = "Latitude";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        n4 = vertexPoint.longitudeDegrees;
                        n3 = vertexPoint.longitudeMinutes;
                        d2 = vertexPoint.longitudeSeconds;
                        d = 180.0;
                        string2 = "Longitude";
                        break;
                    }
                    default: {
                        return;
                    }
                }
                int n5 = (int)Math.floor(d);
                switch (n2) {
                    case 1: 
                    case 5: {
                        n4 = (int)Math.floor(d3);
                        if (n4 < 0 || n4 > n5) {
                            PolygonPanel.this.errorReporter.reportValidationError(string2 + " must be in the range 0 to " + n5);
                            return;
                        }
                        if (!((d3 -= (double)n4) > 1.388888888888889E-6)) break;
                        n3 = (int)Math.floor(d3 *= 60.0);
                        d2 = (d3 -= (double)n3) * 60.0;
                        break;
                    }
                    case 2: 
                    case 6: {
                        n3 = (int)Math.floor(d3);
                        if (n3 < 0 || n3 > 59) {
                            PolygonPanel.this.errorReporter.reportValidationError("Minutes must be in the range 0 to 59");
                            return;
                        }
                        if (!((d3 -= (double)n3) > 8.333333333333333E-5)) break;
                        d2 = d3 * 60.0;
                        break;
                    }
                    case 3: 
                    case 7: {
                        d2 = d3;
                        if (!(d2 < 0.0) && !(d2 >= 60.0)) break;
                        PolygonPanel.this.errorReporter.reportValidationError("Seconds must be in the range 0 to less than 60");
                        return;
                    }
                }
                if (d2 > 59.995) {
                    d2 = 0.0;
                    if (++n3 > 59) {
                        n3 = 0;
                        ++n4;
                    }
                }
                if ((d3 = (double)n4 + (double)n3 / 60.0 + d2 / 3600.0) < 0.0 || d3 > d) {
                    PolygonPanel.this.errorReporter.reportValidationError(string2 + " must be in the range 0 to " + d);
                    return;
                }
                boolean bl = false;
                boolean bl2 = false;
                switch (n2) {
                    case 1: {
                        if (n4 != vertexPoint.latitudeDegrees) {
                            vertexPoint.latitudeDegrees = n4;
                            bl = true;
                        }
                        if (n3 != vertexPoint.latitudeMinutes) {
                            vertexPoint.latitudeMinutes = n3;
                            bl = true;
                            bl2 = true;
                        }
                        if (d2 == vertexPoint.latitudeSeconds) break;
                        vertexPoint.latitudeSeconds = d2;
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    case 2: {
                        if (n3 != vertexPoint.latitudeMinutes) {
                            vertexPoint.latitudeMinutes = n3;
                            bl = true;
                        }
                        if (d2 == vertexPoint.latitudeSeconds) break;
                        vertexPoint.latitudeSeconds = d2;
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    case 3: {
                        if (d2 == vertexPoint.latitudeSeconds) break;
                        vertexPoint.latitudeSeconds = d2;
                        bl = true;
                        break;
                    }
                    case 5: {
                        if (n4 != vertexPoint.longitudeDegrees) {
                            vertexPoint.longitudeDegrees = n4;
                            bl = true;
                        }
                        if (n3 != vertexPoint.longitudeMinutes) {
                            vertexPoint.longitudeMinutes = n3;
                            bl = true;
                            bl2 = true;
                        }
                        if (d2 == vertexPoint.longitudeSeconds) break;
                        vertexPoint.longitudeSeconds = d2;
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    case 6: {
                        if (n3 != vertexPoint.longitudeMinutes) {
                            vertexPoint.longitudeMinutes = n3;
                            bl = true;
                        }
                        if (d2 == vertexPoint.longitudeSeconds) break;
                        vertexPoint.longitudeSeconds = d2;
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    case 7: {
                        if (d2 == vertexPoint.longitudeSeconds) break;
                        vertexPoint.longitudeSeconds = d2;
                        bl = true;
                    }
                }
                if (bl) {
                    vertexPoint.updateLatLon();
                    PolygonPanel.this.setDidEdit();
                }
                if (bl2) {
                    this.fireTableRowsUpdated(n, n);
                }
            }
        }
    }

    public static class SectorsPanel
    extends GeoEditPanel {
        private GeoSectors sectors;
        private CoordinatePanel latitudePanel;
        private CoordinatePanel longitudePanel;
        private CoordinateCopyPastePanel copyPastePanel;
        private SectorsTableModel sectorsModel;
        private JTable sectorsTable;
        private JButton insertButton;
        private JButton deleteButton;

        public SectorsPanel(AppEditor appEditor, Geography geography, boolean bl) {
            super(appEditor, bl);
            this.doSetup(geography, true);
        }

        public SectorsPanel(AppEditor appEditor, Geography geography, boolean bl, boolean bl2) {
            super(appEditor, bl);
            this.doSetup(geography, bl2);
        }

        private void doSetup(Geography geography, boolean bl) {
            JComponent jComponent;
            Object object;
            this.sectors = (GeoSectors)geography;
            this.blockActionsStart();
            if (bl) {
                object = null;
                if (this.canEdit) {
                    object = new Runnable(){

                        @Override
                        public void run() {
                            this.setDidEdit();
                        }
                    };
                }
                this.latitudePanel = new CoordinatePanel(this.parent, this.sectors.center, false, (Runnable)object);
                this.latitudePanel.setEnabled(this.canEdit);
                this.longitudePanel = new CoordinatePanel(this.parent, this.sectors.center, true, (Runnable)object);
                this.longitudePanel.setEnabled(this.canEdit);
                this.copyPastePanel = new CoordinateCopyPastePanel(this.latitudePanel, this.longitudePanel);
                this.copyPastePanel.setEnabled(this.canEdit);
            }
            this.sectorsModel = new SectorsTableModel();
            this.sectorsTable = this.sectorsModel.createTable();
            object = "moveUp";
            String string = "moveDown";
            String string2 = "moveLeft";
            String string3 = "moveRight";
            String string4 = "tabForward";
            String string5 = "tabBackward";
            ActionMap actionMap = this.sectorsTable.getActionMap();
            actionMap.put(object, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(sectorsTable, -1, 0, false);
                }
            });
            actionMap.put(string, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(sectorsTable, 1, 0, false);
                }
            });
            actionMap.put(string2, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(sectorsTable, 0, -1, false);
                }
            });
            actionMap.put(string3, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(sectorsTable, 0, 1, false);
                }
            });
            actionMap.put(string4, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(sectorsTable, 0, 1, true);
                }
            });
            actionMap.put(string5, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(sectorsTable, 0, -1, true);
                }
            });
            KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(40, 0);
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke(37, 0);
            KeyStroke keyStroke4 = KeyStroke.getKeyStroke(39, 0);
            KeyStroke keyStroke5 = KeyStroke.getKeyStroke(9, 0);
            KeyStroke keyStroke6 = KeyStroke.getKeyStroke(9, 1);
            InputMap inputMap = this.sectorsTable.getInputMap(0);
            inputMap.put(keyStroke, object);
            inputMap.put(keyStroke2, string);
            inputMap.put(keyStroke3, string2);
            inputMap.put(keyStroke4, string3);
            inputMap.put(keyStroke5, string4);
            inputMap.put(keyStroke6, string5);
            inputMap = this.sectorsTable.getInputMap(1);
            inputMap.put(keyStroke, object);
            inputMap.put(keyStroke2, string);
            inputMap.put(keyStroke3, string2);
            inputMap.put(keyStroke4, string3);
            inputMap.put(keyStroke5, string4);
            inputMap.put(keyStroke6, string5);
            this.sectorsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting() && canEdit) {
                        if (1 == sectorsTable.getSelectedRowCount()) {
                            insertButton.setEnabled(true);
                            deleteButton.setEnabled(true);
                        } else {
                            insertButton.setEnabled(false);
                            deleteButton.setEnabled(false);
                        }
                    }
                }
            });
            JPanel jPanel = null;
            if (this.canEdit) {
                jComponent = new JButton("Add");
                jComponent.setFocusable(false);
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doAddSector();
                    }
                });
                this.insertButton = new JButton("Insert");
                this.insertButton.setFocusable(false);
                this.insertButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doInsertSector();
                    }
                });
                this.insertButton.setEnabled(false);
                this.deleteButton = new JButton("Delete");
                this.deleteButton.setFocusable(false);
                this.deleteButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doDeleteSector();
                    }
                });
                this.deleteButton.setEnabled(false);
                jPanel = new JPanel(new FlowLayout(0));
                jPanel.add(jComponent);
                jPanel.add(this.insertButton);
                jPanel.add(this.deleteButton);
            }
            jComponent = null;
            if (bl) {
                jComponent = new JPanel();
                jComponent.setBorder(BorderFactory.createTitledBorder("Center Point"));
                jComponent.add(this.latitudePanel);
                jComponent.add(this.longitudePanel);
                jComponent.add(this.copyPastePanel);
            }
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createTitledBorder("Sectors"));
            jPanel2.add((Component)AppController.createScrollPane(this.sectorsTable), "Center");
            AppController.setComponentEnabled(this.sectorsTable, this.canEdit);
            if (null != jPanel) {
                jPanel2.add(jPanel, "South");
            }
            this.setLayout(new BorderLayout());
            if (null != jComponent) {
                this.add((Component)jComponent, "North");
            }
            this.add((Component)jPanel2, "Center");
            this.dataChanged();
            this.blockActionsEnd();
        }

        @Override
        public void dataChanged() {
            if (null != this.latitudePanel) {
                this.latitudePanel.updatePanel();
                this.longitudePanel.updatePanel();
            }
            this.sectorsModel.dataChanged();
        }

        private void doAddSector() {
            if (!this.canEdit || !this.commitTableEdits()) {
                return;
            }
            double d = 0.0;
            double d2 = 0.0;
            if (this.sectorsModel.getRowCount() > 0) {
                d2 = ((GeoSectors.Sector)this.sectors.sectors.get((int)(this.sectorsModel.getRowCount() - 1))).azimuth;
                if (d2 <= 358.0) {
                    d = (d2 + 360.0) / 2.0;
                } else {
                    this.errorReporter.reportWarning("Add Sector", "Cannot add sector, must span at least 1 degree");
                    return;
                }
            }
            GeoSectors.Sector sector = new GeoSectors.Sector();
            sector.azimuth = d;
            sector.radius = 1.0;
            int n = this.sectorsModel.add(sector);
            this.sectorsTable.scrollRectToVisible(this.sectorsTable.getCellRect(n, 0, true));
            this.sectorsTable.setRowSelectionInterval(n, n);
        }

        private void doInsertSector() {
            if (!this.canEdit || !this.commitTableEdits()) {
                return;
            }
            int n = this.sectorsTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            double d = 0.0;
            double d2 = 0.0;
            double d3 = ((GeoSectors.Sector)this.sectors.sectors.get((int)n)).azimuth;
            if (n > 0) {
                d2 = ((GeoSectors.Sector)this.sectors.sectors.get((int)(n - 1))).azimuth;
            }
            if (!(d3 - d2 >= 2.0)) {
                this.errorReporter.reportWarning("Insert Sector", "Cannot insert sector, must span at least 1 degree");
                return;
            }
            d = (d3 + d2) / 2.0;
            GeoSectors.Sector sector = new GeoSectors.Sector();
            sector.azimuth = d;
            sector.radius = 1.0;
            this.sectorsModel.insert(n, sector);
            this.sectorsTable.scrollRectToVisible(this.sectorsTable.getCellRect(n, 0, true));
            this.sectorsTable.setRowSelectionInterval(n, n);
        }

        private void doDeleteSector() {
            if (!this.canEdit || !this.commitTableEdits()) {
                return;
            }
            int n = this.sectorsTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            this.sectorsModel.remove(n);
            if (n >= this.sectorsModel.getRowCount()) {
                --n;
            }
            if (n >= 0 && n < this.sectorsModel.getRowCount()) {
                this.sectorsTable.scrollRectToVisible(this.sectorsTable.getCellRect(n, 0, true));
                this.sectorsTable.setRowSelectionInterval(n, n);
            }
        }

        @Override
        public boolean commitTableEdits() {
            if (this.sectorsTable.isEditing()) {
                if (this.canEdit) {
                    this.errorReporter.clearErrors();
                    this.sectorsTable.getCellEditor().stopCellEditing();
                    return !this.errorReporter.hasErrors();
                }
                this.sectorsTable.getCellEditor().cancelCellEditing();
            }
            return true;
        }

        private class SectorsTableModel
        extends AbstractTableModel {
            private static final String AZIMUTH_COLUMN = "Azimuth";
            private static final String RADIUS_COLUMN = "Radius";
            private String[] columnNames = new String[]{"Azimuth", "Radius"};
            private static final int AZIMUTH_INDEX = 0;
            private static final int RADIUS_INDEX = 1;

            private SectorsTableModel() {
            }

            private JTable createTable() {
                JTable jTable = new JTable(this);
                jTable.setColumnSelectionAllowed(false);
                jTable.getTableHeader().setReorderingAllowed(false);
                jTable.setSelectionMode(0);
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                JTextField jTextField = new JTextField(8);
                AppController.fixKeyBindings(jTextField);
                jTextField.setBorder(new LineBorder(Color.BLACK));
                DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
                defaultCellEditor.setClickCountToStart(1);
                TableColumn tableColumn = tableColumnModel.getColumn(0);
                tableColumn.setCellEditor(defaultCellEditor);
                tableColumn.setMinWidth(AppController.textFieldWidth[4]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
                tableColumn = tableColumnModel.getColumn(1);
                tableColumn.setCellEditor(defaultCellEditor);
                tableColumn.setMinWidth(AppController.textFieldWidth[4]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
                return jTable;
            }

            private int add(GeoSectors.Sector sector) {
                if (!SectorsPanel.this.canEdit) {
                    return -1;
                }
                int n = ((SectorsPanel)SectorsPanel.this).sectors.sectors.size();
                ((SectorsPanel)SectorsPanel.this).sectors.sectors.add(sector);
                SectorsPanel.this.setDidEdit();
                this.fireTableRowsInserted(n, n);
                return n;
            }

            private void insert(int n, GeoSectors.Sector sector) {
                if (!SectorsPanel.this.canEdit) {
                    return;
                }
                ((SectorsPanel)SectorsPanel.this).sectors.sectors.add(n, sector);
                SectorsPanel.this.setDidEdit();
                this.fireTableRowsInserted(n, n);
            }

            private void remove(int n) {
                if (!SectorsPanel.this.canEdit) {
                    return;
                }
                ((SectorsPanel)SectorsPanel.this).sectors.sectors.remove(n);
                SectorsPanel.this.setDidEdit();
                this.fireTableRowsDeleted(n, n);
            }

            private void dataChanged() {
                this.fireTableDataChanged();
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public String getColumnName(int n) {
                return this.columnNames[n];
            }

            @Override
            public int getRowCount() {
                return ((SectorsPanel)SectorsPanel.this).sectors.sectors.size();
            }

            public Class getColumnClass(int n) {
                switch (n) {
                    case 0: 
                    case 1: {
                        return String.class;
                    }
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return SectorsPanel.this.canEdit;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                GeoSectors.Sector sector = (GeoSectors.Sector)((SectorsPanel)SectorsPanel.this).sectors.sectors.get(n);
                switch (n2) {
                    case 0: {
                        return AppCore.formatAzimuth((double)sector.azimuth);
                    }
                    case 1: {
                        return AppCore.formatDistance((double)sector.radius);
                    }
                }
                return "";
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!SectorsPanel.this.canEdit || n < 0 || n >= ((SectorsPanel)SectorsPanel.this).sectors.sectors.size()) {
                    return;
                }
                GeoSectors.Sector sector = (GeoSectors.Sector)((SectorsPanel)SectorsPanel.this).sectors.sectors.get(n);
                SectorsPanel.this.errorReporter.setTitle("Edit Sector");
                String string = ((String)object).trim();
                if (0 == string.length()) {
                    return;
                }
                switch (n2) {
                    case 0: {
                        double d = sector.azimuth;
                        try {
                            d = Double.parseDouble(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            SectorsPanel.this.errorReporter.reportValidationError("Azimuth must be a number");
                            return;
                        }
                        if (d < 0.0 || d >= 360.0) {
                            SectorsPanel.this.errorReporter.reportValidationError("Azimuth must be in the range 0 to less than 360");
                            return;
                        }
                        if (d == sector.azimuth) break;
                        double d2 = -1.0;
                        if (n > 0) {
                            d2 = ((GeoSectors.Sector)((SectorsPanel)SectorsPanel.this).sectors.sectors.get((int)(n - 1))).azimuth;
                        }
                        double d3 = 361.0;
                        if (n < ((SectorsPanel)SectorsPanel.this).sectors.sectors.size() - 1) {
                            d3 = ((GeoSectors.Sector)((SectorsPanel)SectorsPanel.this).sectors.sectors.get((int)(n + 1))).azimuth;
                        }
                        if (d < d2 || d > d3) {
                            SectorsPanel.this.errorReporter.reportValidationError("Azimuth out of sequence");
                            return;
                        }
                        if (d - d2 < 1.0 || d3 - d < 1.0) {
                            SectorsPanel.this.errorReporter.reportValidationError("Sectors must span at least 1 degree");
                            return;
                        }
                        sector.azimuth = d;
                        SectorsPanel.this.setDidEdit();
                        break;
                    }
                    case 1: {
                        double d = sector.radius;
                        try {
                            d = Double.parseDouble(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            SectorsPanel.this.errorReporter.reportValidationError("Radius must be a number");
                            return;
                        }
                        if (d < 1.0 || d > 3000.0) {
                            SectorsPanel.this.errorReporter.reportValidationError("Radius must be in the range 1.0 to 3000.0");
                            return;
                        }
                        if (d == sector.radius) break;
                        sector.radius = d;
                        SectorsPanel.this.setDidEdit();
                        break;
                    }
                }
            }
        }
    }

    public static class CirclePanel
    extends GeoEditPanel {
        private GeoCircle circle;
        private CoordinatePanel latitudePanel;
        private CoordinatePanel longitudePanel;
        private CoordinateCopyPastePanel copyPastePanel;
        private JTextField radiusField;

        public CirclePanel(AppEditor appEditor, Geography geography, boolean bl) {
            super(appEditor, bl);
            this.blockActionsStart();
            this.circle = (GeoCircle)geography;
            Runnable runnable = null;
            if (this.canEdit) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        this.setDidEdit();
                    }
                };
            }
            this.latitudePanel = new CoordinatePanel(this.parent, this.circle.center, false, runnable);
            this.latitudePanel.setEnabled(this.canEdit);
            this.longitudePanel = new CoordinatePanel(this.parent, this.circle.center, true, runnable);
            this.longitudePanel.setEnabled(this.canEdit);
            this.copyPastePanel = new CoordinateCopyPastePanel(this.latitudePanel, this.longitudePanel);
            this.copyPastePanel.setEnabled(this.canEdit);
            this.radiusField = new JTextField(7);
            AppController.fixKeyBindings(this.radiusField);
            if (this.canEdit) {
                this.radiusField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (this.blockActions()) {
                            String string = "Edit Radius";
                            String string2 = radiusField.getText().trim();
                            if (string2.length() > 0) {
                                double d = ((CirclePanel)this).circle.radius;
                                try {
                                    d = Double.parseDouble(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    errorReporter.reportValidationError(string, "The radius must be a number");
                                }
                                if (d != ((CirclePanel)this).circle.radius) {
                                    if (d < 1.0 || d > 3000.0) {
                                        errorReporter.reportValidationError(string, "The radius must be between 1.0 and 3000.0");
                                    } else {
                                        ((CirclePanel)this).circle.radius = d;
                                        this.setDidEdit();
                                    }
                                }
                            }
                            radiusField.setText(AppCore.formatDistance((double)((CirclePanel)this).circle.radius));
                            this.blockActionsEnd();
                        }
                    }
                });
            } else {
                AppController.setComponentEnabled(this.radiusField, false);
            }
            this.radiusField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Component component = focusEvent.getComponent();
                    if (component instanceof JTextField) {
                        this.setCurrentField((JTextField)component);
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Component component;
                    if (!focusEvent.isTemporary() && (component = focusEvent.getComponent()) instanceof JTextField) {
                        ((JTextField)component).postActionEvent();
                    }
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Radius, km"));
            jPanel.add(this.radiusField);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("Center Point"));
            jPanel2.add(this.latitudePanel);
            jPanel2.add(this.longitudePanel);
            jPanel2.add(this.copyPastePanel);
            JPanel jPanel3 = new JPanel();
            jPanel3.add(jPanel);
            this.setLayout(new BoxLayout(this, 1));
            this.add(jPanel2);
            this.add(jPanel3);
            this.add(Box.createVerticalGlue());
            this.dataChanged();
            this.blockActionsEnd();
        }

        @Override
        public void dataChanged() {
            this.latitudePanel.updatePanel();
            this.longitudePanel.updatePanel();
            this.radiusField.setText(AppCore.formatDistance((double)this.circle.radius));
        }
    }

    public static class BoxPanel
    extends GeoEditPanel {
        private GeoBox box;
        private CoordinatePanel latitudePanel;
        private CoordinatePanel longitudePanel;
        private CoordinateCopyPastePanel copyPastePanel;
        private JTextField widthField;
        private JTextField heightField;

        public BoxPanel(AppEditor appEditor, Geography geography, boolean bl) {
            super(appEditor, bl);
            this.blockActionsStart();
            this.box = (GeoBox)geography;
            Runnable runnable = null;
            if (this.canEdit) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        this.setDidEdit();
                    }
                };
            }
            this.latitudePanel = new CoordinatePanel(this.parent, this.box.center, false, runnable);
            this.latitudePanel.setEnabled(this.canEdit);
            this.longitudePanel = new CoordinatePanel(this.parent, this.box.center, true, runnable);
            this.longitudePanel.setEnabled(this.canEdit);
            this.copyPastePanel = new CoordinateCopyPastePanel(this.latitudePanel, this.longitudePanel);
            this.copyPastePanel.setEnabled(this.canEdit);
            this.widthField = new JTextField(7);
            AppController.fixKeyBindings(this.widthField);
            if (this.canEdit) {
                this.widthField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (this.blockActions()) {
                            String string = "Edit Width";
                            String string2 = widthField.getText().trim();
                            if (string2.length() > 0) {
                                double d = ((BoxPanel)this).box.width;
                                try {
                                    d = Double.parseDouble(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    errorReporter.reportValidationError(string, "The width must be a number");
                                }
                                if (d != ((BoxPanel)this).box.width) {
                                    if (d < 1.0 || d > 3000.0) {
                                        errorReporter.reportValidationError(string, "The width must be between 1.0 and 3000.0");
                                    } else {
                                        ((BoxPanel)this).box.width = d;
                                        this.setDidEdit();
                                    }
                                }
                            }
                            widthField.setText(AppCore.formatDistance((double)((BoxPanel)this).box.width));
                            this.blockActionsEnd();
                        }
                    }
                });
            } else {
                AppController.setComponentEnabled(this.widthField, false);
            }
            this.widthField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Component component = focusEvent.getComponent();
                    if (component instanceof JTextField) {
                        this.setCurrentField((JTextField)component);
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Component component;
                    if (!focusEvent.isTemporary() && (component = focusEvent.getComponent()) instanceof JTextField) {
                        ((JTextField)component).postActionEvent();
                    }
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Width, km"));
            jPanel.add(this.widthField);
            this.heightField = new JTextField(7);
            AppController.fixKeyBindings(this.heightField);
            if (this.canEdit) {
                this.heightField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (this.blockActions()) {
                            String string = "Edit Width";
                            String string2 = heightField.getText().trim();
                            if (string2.length() > 0) {
                                double d = ((BoxPanel)this).box.height;
                                try {
                                    d = Double.parseDouble(string2);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    errorReporter.reportValidationError(string, "The height must be a number");
                                }
                                if (d != ((BoxPanel)this).box.height) {
                                    if (d < 1.0 || d > 3000.0) {
                                        errorReporter.reportValidationError(string, "The height must be between 1.0 and 3000.0");
                                    } else {
                                        ((BoxPanel)this).box.height = d;
                                        this.setDidEdit();
                                    }
                                }
                            }
                            heightField.setText(AppCore.formatDistance((double)((BoxPanel)this).box.height));
                            this.blockActionsEnd();
                        }
                    }
                });
            } else {
                AppController.setComponentEnabled(this.heightField, false);
            }
            this.heightField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Component component = focusEvent.getComponent();
                    if (component instanceof JTextField) {
                        this.setCurrentField((JTextField)component);
                    }
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Component component;
                    if (!focusEvent.isTemporary() && (component = focusEvent.getComponent()) instanceof JTextField) {
                        ((JTextField)component).postActionEvent();
                    }
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("Height, km"));
            jPanel2.add(this.heightField);
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createTitledBorder("Center Point"));
            jPanel3.add(this.latitudePanel);
            jPanel3.add(this.longitudePanel);
            jPanel3.add(this.copyPastePanel);
            JPanel jPanel4 = new JPanel();
            jPanel4.add(jPanel);
            jPanel4.add(jPanel2);
            this.setLayout(new BoxLayout(this, 1));
            this.add(jPanel3);
            this.add(jPanel4);
            this.add(Box.createVerticalGlue());
            this.dataChanged();
            this.blockActionsEnd();
        }

        @Override
        public void dataChanged() {
            this.latitudePanel.updatePanel();
            this.longitudePanel.updatePanel();
            this.widthField.setText(AppCore.formatDistance((double)this.box.width));
            this.heightField.setText(AppCore.formatDistance((double)this.box.height));
        }
    }

    public static class PointSetPanel
    extends GeoEditPanel {
        private GeoPointSet pointSet;
        private KeyedRecordMenu antennaMenu;
        private StudyPointsTableModel pointsModel;
        private JTable pointsTable;
        private JButton duplicateButton;
        private JButton deleteButton;

        public PointSetPanel(AppEditor appEditor, Geography geography, boolean bl) {
            super(appEditor, bl);
            this.pointSet = (GeoPointSet)geography;
            this.antennaMenu = new KeyedRecordMenu();
            this.pointsModel = new StudyPointsTableModel();
            this.pointsTable = this.pointsModel.createTable();
            String string = "moveUp";
            String string2 = "moveDown";
            String string3 = "moveLeft";
            String string4 = "moveRight";
            String string5 = "tabForward";
            String string6 = "tabBackward";
            ActionMap actionMap = this.pointsTable.getActionMap();
            actionMap.put(string, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(pointsTable, -1, 0, false);
                }
            });
            actionMap.put(string2, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(pointsTable, 1, 0, false);
                }
            });
            actionMap.put(string3, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(pointsTable, 0, -1, false);
                }
            });
            actionMap.put(string4, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(pointsTable, 0, 1, false);
                }
            });
            actionMap.put(string5, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(pointsTable, 0, 1, true);
                }
            });
            actionMap.put(string6, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.moveTableSelection(pointsTable, 0, -1, true);
                }
            });
            KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 0);
            KeyStroke keyStroke2 = KeyStroke.getKeyStroke(40, 0);
            KeyStroke keyStroke3 = KeyStroke.getKeyStroke(37, 0);
            KeyStroke keyStroke4 = KeyStroke.getKeyStroke(39, 0);
            KeyStroke keyStroke5 = KeyStroke.getKeyStroke(9, 0);
            KeyStroke keyStroke6 = KeyStroke.getKeyStroke(9, 1);
            InputMap inputMap = this.pointsTable.getInputMap(0);
            inputMap.put(keyStroke, string);
            inputMap.put(keyStroke2, string2);
            inputMap.put(keyStroke3, string3);
            inputMap.put(keyStroke4, string4);
            inputMap.put(keyStroke5, string5);
            inputMap.put(keyStroke6, string6);
            inputMap = this.pointsTable.getInputMap(1);
            inputMap.put(keyStroke, string);
            inputMap.put(keyStroke2, string2);
            inputMap.put(keyStroke3, string3);
            inputMap.put(keyStroke4, string4);
            inputMap.put(keyStroke5, string5);
            inputMap.put(keyStroke6, string6);
            this.pointsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting() && canEdit) {
                        if (1 == pointsTable.getSelectedRowCount()) {
                            duplicateButton.setEnabled(true);
                            deleteButton.setEnabled(true);
                        } else {
                            duplicateButton.setEnabled(false);
                            deleteButton.setEnabled(false);
                        }
                    }
                }
            });
            JPanel jPanel = null;
            if (this.canEdit) {
                JButton jButton = new JButton("Add");
                jButton.setFocusable(false);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doAddPoint();
                    }
                });
                this.duplicateButton = new JButton("Duplicate");
                this.duplicateButton.setFocusable(false);
                this.duplicateButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doDuplicatePoint();
                    }
                });
                this.duplicateButton.setEnabled(false);
                this.deleteButton = new JButton("Delete");
                this.deleteButton.setFocusable(false);
                this.deleteButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.doDeletePoint();
                    }
                });
                this.deleteButton.setEnabled(false);
                jPanel = new JPanel(new FlowLayout(0));
                jPanel.add(jButton);
                jPanel.add(this.duplicateButton);
                jPanel.add(this.deleteButton);
            }
            this.setLayout(new BorderLayout());
            this.add((Component)AppController.createScrollPane(this.pointsTable), "Center");
            AppController.setComponentEnabled(this.pointsTable, this.canEdit);
            if (null != jPanel) {
                this.add(jPanel, "South");
            }
            this.setBorder(BorderFactory.createTitledBorder("Study Points (NAD83)"));
            this.updateReceiveAntennas();
        }

        public boolean isReceiveAntennaInUse(int n) {
            for (GeoPointSet.StudyPoint studyPoint : this.pointSet.points) {
                if (null == studyPoint.antenna || n != studyPoint.antenna.key) continue;
                return true;
            }
            return false;
        }

        public void updateReceiveAntennas() {
            ArrayList arrayList = this.pointSet.getReceiveAntennaList((ErrorLogger)this.errorReporter);
            if (null == arrayList) {
                return;
            }
            int n = this.antennaMenu.getSelectedKey();
            this.antennaMenu.removeAllItems();
            this.antennaMenu.addItem(GeoPointSet.GENERIC_ANTENNA);
            this.antennaMenu.addAllItems(arrayList);
            if (this.antennaMenu.containsKey(n)) {
                this.antennaMenu.setSelectedKey(n);
            }
        }

        @Override
        public void dataChanged() {
            this.pointsModel.dataChanged();
        }

        private void doAddPoint() {
            if (!this.canEdit || !this.commitTableEdits()) {
                return;
            }
            GeoPointSet.StudyPoint studyPoint = new GeoPointSet.StudyPoint();
            studyPoint.name = "";
            studyPoint.receiveHeight = 10.0;
            studyPoint.antenna = GeoPointSet.GENERIC_ANTENNA;
            int n = this.pointsModel.add(studyPoint);
            this.pointsTable.scrollRectToVisible(this.pointsTable.getCellRect(n, 0, true));
            this.pointsTable.setRowSelectionInterval(n, n);
        }

        private void doDuplicatePoint() {
            if (!this.canEdit || !this.commitTableEdits()) {
                return;
            }
            int n = this.pointsTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            GeoPointSet.StudyPoint studyPoint = ((GeoPointSet.StudyPoint)this.pointSet.points.get(n)).duplicate();
            studyPoint.name = "";
            n = this.pointsModel.add(studyPoint);
            this.pointsTable.scrollRectToVisible(this.pointsTable.getCellRect(n, 0, true));
            this.pointsTable.setRowSelectionInterval(n, n);
        }

        private void doDeletePoint() {
            if (!this.canEdit || !this.commitTableEdits()) {
                return;
            }
            int n = this.pointsTable.getSelectedRow();
            if (n < 0) {
                return;
            }
            this.pointsModel.remove(n);
            if (n >= this.pointsModel.getRowCount()) {
                --n;
            }
            if (n >= 0 && n < this.pointsModel.getRowCount()) {
                this.pointsTable.scrollRectToVisible(this.pointsTable.getCellRect(n, 0, true));
                this.pointsTable.setRowSelectionInterval(n, n);
            }
        }

        @Override
        public boolean commitTableEdits() {
            if (this.pointsTable.isEditing()) {
                if (this.canEdit) {
                    this.errorReporter.clearErrors();
                    this.pointsTable.getCellEditor().stopCellEditing();
                    return !this.errorReporter.hasErrors();
                }
                this.pointsTable.getCellEditor().cancelCellEditing();
            }
            return true;
        }

        private class StudyPointsTableModel
        extends AbstractTableModel {
            private static final String NAME_COLUMN = "Name";
            private static final String NS_COLUMN = "NS";
            private static final String LATD_COLUMN = "Lat D";
            private static final String LATM_COLUMN = "Lat M";
            private static final String LATS_COLUMN = "Lat S";
            private static final String WE_COLUMN = "WE";
            private static final String LOND_COLUMN = "Lon D";
            private static final String LONM_COLUMN = "Lon M";
            private static final String LONS_COLUMN = "Lon S";
            private static final String HEIGHT_COLUMN = "Recv Ht";
            private static final String ANT_COLUMN = "Recv Ant";
            private static final String USE_ANT_ORIENT_COLUMN = "Fix Dir";
            private static final String ANT_ORIENT_COLUMN = "Dir";
            private String[] columnNames = new String[]{"Name", "NS", "Lat D", "Lat M", "Lat S", "WE", "Lon D", "Lon M", "Lon S", "Recv Ht", "Recv Ant", "Fix Dir", "Dir"};
            private static final int NAME_INDEX = 0;
            private static final int NS_INDEX = 1;
            private static final int LATD_INDEX = 2;
            private static final int LATM_INDEX = 3;
            private static final int LATS_INDEX = 4;
            private static final int WE_INDEX = 5;
            private static final int LOND_INDEX = 6;
            private static final int LONM_INDEX = 7;
            private static final int LONS_INDEX = 8;
            private static final int HEIGHT_INDEX = 9;
            private static final int ANT_INDEX = 10;
            private static final int USE_ANT_ORIENT_INDEX = 11;
            private static final int ANT_ORIENT_INDEX = 12;

            private StudyPointsTableModel() {
            }

            private JTable createTable() {
                JTable jTable = new JTable(this);
                jTable.setColumnSelectionAllowed(false);
                jTable.getTableHeader().setReorderingAllowed(false);
                jTable.setSelectionMode(0);
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                JTextField jTextField = new JTextField(15);
                AppController.fixKeyBindings(jTextField);
                jTextField.setBorder(new LineBorder(Color.BLACK));
                DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
                defaultCellEditor.setClickCountToStart(1);
                TableColumn tableColumn = tableColumnModel.getColumn(0);
                tableColumn.setCellEditor(defaultCellEditor);
                tableColumn.setMinWidth(AppController.textFieldWidth[6]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[15]);
                KeyedRecordMenu keyedRecordMenu = new KeyedRecordMenu();
                keyedRecordMenu.addItem(new KeyedRecord(0, "N"));
                keyedRecordMenu.addItem(new KeyedRecord(1, "S"));
                DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(keyedRecordMenu);
                tableColumn = tableColumnModel.getColumn(1);
                tableColumn.setCellEditor(defaultCellEditor2);
                tableColumn.setMinWidth(AppController.textFieldWidth[2]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[3]);
                JTextField jTextField2 = new JTextField(8);
                AppController.fixKeyBindings(jTextField2);
                jTextField2.setBorder(new LineBorder(Color.BLACK));
                DefaultCellEditor defaultCellEditor3 = new DefaultCellEditor(jTextField2);
                defaultCellEditor3.setClickCountToStart(1);
                tableColumn = tableColumnModel.getColumn(2);
                tableColumn.setCellEditor(defaultCellEditor3);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
                tableColumn = tableColumnModel.getColumn(3);
                tableColumn.setCellEditor(defaultCellEditor3);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
                tableColumn = tableColumnModel.getColumn(4);
                tableColumn.setCellEditor(defaultCellEditor3);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[7]);
                KeyedRecordMenu keyedRecordMenu2 = new KeyedRecordMenu();
                keyedRecordMenu2.addItem(new KeyedRecord(0, "W"));
                keyedRecordMenu2.addItem(new KeyedRecord(1, "E"));
                DefaultCellEditor defaultCellEditor4 = new DefaultCellEditor(keyedRecordMenu2);
                tableColumn = tableColumnModel.getColumn(5);
                tableColumn.setCellEditor(defaultCellEditor4);
                tableColumn.setMinWidth(AppController.textFieldWidth[2]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[3]);
                tableColumn = tableColumnModel.getColumn(6);
                tableColumn.setCellEditor(defaultCellEditor3);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
                tableColumn = tableColumnModel.getColumn(7);
                tableColumn.setCellEditor(defaultCellEditor3);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[6]);
                tableColumn = tableColumnModel.getColumn(8);
                tableColumn.setCellEditor(defaultCellEditor3);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[7]);
                tableColumn = tableColumnModel.getColumn(9);
                tableColumn.setCellEditor(defaultCellEditor3);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[7]);
                DefaultCellEditor defaultCellEditor5 = new DefaultCellEditor(PointSetPanel.this.antennaMenu);
                defaultCellEditor5.setClickCountToStart(1);
                tableColumn = tableColumnModel.getColumn(10);
                tableColumn.setCellEditor(defaultCellEditor5);
                tableColumn.setMinWidth(AppController.textFieldWidth[5]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[8]);
                tableColumn = tableColumnModel.getColumn(11);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[3]);
                tableColumn = tableColumnModel.getColumn(12);
                tableColumn.setCellEditor(defaultCellEditor3);
                tableColumn.setMinWidth(AppController.textFieldWidth[3]);
                tableColumn.setPreferredWidth(AppController.textFieldWidth[7]);
                return jTable;
            }

            private int add(GeoPointSet.StudyPoint studyPoint) {
                if (!PointSetPanel.this.canEdit) {
                    return -1;
                }
                int n = ((PointSetPanel)PointSetPanel.this).pointSet.points.size();
                ((PointSetPanel)PointSetPanel.this).pointSet.points.add(studyPoint);
                PointSetPanel.this.setDidEdit();
                this.fireTableRowsInserted(n, n);
                return n;
            }

            private void remove(int n) {
                if (!PointSetPanel.this.canEdit) {
                    return;
                }
                ((PointSetPanel)PointSetPanel.this).pointSet.points.remove(n);
                PointSetPanel.this.setDidEdit();
                this.fireTableRowsDeleted(n, n);
            }

            private void dataChanged() {
                this.fireTableDataChanged();
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public String getColumnName(int n) {
                return this.columnNames[n];
            }

            @Override
            public int getRowCount() {
                return ((PointSetPanel)PointSetPanel.this).pointSet.points.size();
            }

            public Class getColumnClass(int n) {
                switch (n) {
                    case 1: 
                    case 5: 
                    case 10: {
                        return KeyedRecord.class;
                    }
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 12: {
                        return String.class;
                    }
                    case 11: {
                        return Boolean.class;
                    }
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                if (!PointSetPanel.this.canEdit) {
                    return false;
                }
                if (12 == n2) {
                    GeoPointSet.StudyPoint studyPoint = (GeoPointSet.StudyPoint)((PointSetPanel)PointSetPanel.this).pointSet.points.get(n);
                    return studyPoint.useAntennaOrientation;
                }
                return true;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                GeoPointSet.StudyPoint studyPoint = (GeoPointSet.StudyPoint)((PointSetPanel)PointSetPanel.this).pointSet.points.get(n);
                switch (n2) {
                    case 0: {
                        return studyPoint.name;
                    }
                    case 1: {
                        return new KeyedRecord(studyPoint.latitudeNS, 0 == studyPoint.latitudeNS ? "N" : "S");
                    }
                    case 2: {
                        return String.valueOf(studyPoint.latitudeDegrees);
                    }
                    case 3: {
                        return String.valueOf(studyPoint.latitudeMinutes);
                    }
                    case 4: {
                        return AppCore.formatSeconds((double)studyPoint.latitudeSeconds);
                    }
                    case 5: {
                        return new KeyedRecord(studyPoint.longitudeWE, 0 == studyPoint.longitudeWE ? "W" : "E");
                    }
                    case 6: {
                        return String.valueOf(studyPoint.longitudeDegrees);
                    }
                    case 7: {
                        return String.valueOf(studyPoint.longitudeMinutes);
                    }
                    case 8: {
                        return AppCore.formatSeconds((double)studyPoint.longitudeSeconds);
                    }
                    case 9: {
                        return AppCore.formatHeight((double)studyPoint.receiveHeight);
                    }
                    case 10: {
                        return null != studyPoint.antenna ? studyPoint.antenna : GeoPointSet.GENERIC_ANTENNA;
                    }
                    case 11: {
                        return studyPoint.useAntennaOrientation;
                    }
                    case 12: {
                        if (studyPoint.useAntennaOrientation) {
                            return AppCore.formatAzimuth((double)studyPoint.antennaOrientation);
                        }
                        return "";
                    }
                }
                return "";
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (!PointSetPanel.this.canEdit || n < 0 || n >= ((PointSetPanel)PointSetPanel.this).pointSet.points.size()) {
                    return;
                }
                GeoPointSet.StudyPoint studyPoint = (GeoPointSet.StudyPoint)((PointSetPanel)PointSetPanel.this).pointSet.points.get(n);
                PointSetPanel.this.errorReporter.setTitle("Edit Point");
                switch (n2) {
                    case 0: {
                        String string = (String)object;
                        if (!studyPoint.name.equals(string)) {
                            studyPoint.name = string;
                            PointSetPanel.this.setDidEdit();
                        }
                        return;
                    }
                    case 1: {
                        int n3 = ((KeyedRecord)object).key;
                        if (n3 == studyPoint.latitudeNS) break;
                        studyPoint.latitudeNS = n3;
                        studyPoint.updateLatLon();
                        PointSetPanel.this.setDidEdit();
                        break;
                    }
                    case 5: {
                        int n4 = ((KeyedRecord)object).key;
                        if (n4 == studyPoint.longitudeWE) break;
                        studyPoint.longitudeWE = n4;
                        studyPoint.updateLatLon();
                        PointSetPanel.this.setDidEdit();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 12: {
                        this.setStudyPointField(studyPoint, n, n2, ((String)object).trim());
                        return;
                    }
                    case 10: {
                        KeyedRecord keyedRecord = (KeyedRecord)object;
                        if (null == keyedRecord) {
                            keyedRecord = GeoPointSet.GENERIC_ANTENNA;
                        }
                        if (null == studyPoint.antenna) {
                            studyPoint.antenna = keyedRecord;
                            PointSetPanel.this.setDidEdit();
                        } else if (keyedRecord.key != studyPoint.antenna.key) {
                            studyPoint.antenna = keyedRecord;
                            PointSetPanel.this.setDidEdit();
                        }
                        return;
                    }
                    case 11: {
                        boolean bl = (Boolean)object;
                        if (bl != studyPoint.useAntennaOrientation) {
                            studyPoint.useAntennaOrientation = bl;
                            PointSetPanel.this.setDidEdit();
                            this.fireTableRowsUpdated(n, n);
                        }
                        return;
                    }
                }
            }

            private void setStudyPointField(GeoPointSet.StudyPoint studyPoint, int n, int n2, String string) {
                double d;
                double d2;
                int n3;
                int n4;
                double d3;
                if (!PointSetPanel.this.canEdit || 0 == string.length()) {
                    return;
                }
                String string2 = "";
                try {
                    d3 = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    PointSetPanel.this.errorReporter.reportValidationError("Input must be a number");
                    return;
                }
                switch (n2) {
                    case 9: {
                        if (d3 < 0.0 || d3 > 1000.0) {
                            PointSetPanel.this.errorReporter.reportValidationError("Height must be in the range 0.0 to 1000.0");
                            return;
                        }
                        if (d3 != studyPoint.receiveHeight) {
                            studyPoint.receiveHeight = d3;
                            PointSetPanel.this.setDidEdit();
                        }
                        return;
                    }
                    case 12: {
                        if (d3 < 0.0 || d3 > 359.999) {
                            PointSetPanel.this.errorReporter.reportValidationError("Antenna orientation must be in the range 0.0 to 359.999");
                            return;
                        }
                        if (d3 != studyPoint.antennaOrientation) {
                            studyPoint.antennaOrientation = d3;
                            PointSetPanel.this.setDidEdit();
                        }
                        return;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        n4 = studyPoint.latitudeDegrees;
                        n3 = studyPoint.latitudeMinutes;
                        d2 = studyPoint.latitudeSeconds;
                        d = 73.5;
                        string2 = "Latitude";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        n4 = studyPoint.longitudeDegrees;
                        n3 = studyPoint.longitudeMinutes;
                        d2 = studyPoint.longitudeSeconds;
                        d = 180.0;
                        string2 = "Longitude";
                        break;
                    }
                    default: {
                        return;
                    }
                }
                int n5 = (int)Math.floor(d);
                switch (n2) {
                    case 2: 
                    case 6: {
                        n4 = (int)Math.floor(d3);
                        if (n4 < 0 || n4 > n5) {
                            PointSetPanel.this.errorReporter.reportValidationError(string2 + " must be in the range 0 to " + n5);
                            return;
                        }
                        if (!((d3 -= (double)n4) > 1.388888888888889E-6)) break;
                        n3 = (int)Math.floor(d3 *= 60.0);
                        d2 = (d3 -= (double)n3) * 60.0;
                        break;
                    }
                    case 3: 
                    case 7: {
                        n3 = (int)Math.floor(d3);
                        if (n3 < 0 || n3 > 59) {
                            PointSetPanel.this.errorReporter.reportValidationError("Minutes must be in the range 0 to 59");
                            return;
                        }
                        if (!((d3 -= (double)n3) > 8.333333333333333E-5)) break;
                        d2 = d3 * 60.0;
                        break;
                    }
                    case 4: 
                    case 8: {
                        d2 = d3;
                        if (!(d2 < 0.0) && !(d2 >= 60.0)) break;
                        PointSetPanel.this.errorReporter.reportValidationError("Seconds must be in the range 0 to less than 60");
                        return;
                    }
                }
                if (d2 > 59.995) {
                    d2 = 0.0;
                    if (++n3 > 59) {
                        n3 = 0;
                        ++n4;
                    }
                }
                if ((d3 = (double)n4 + (double)n3 / 60.0 + d2 / 3600.0) < 0.0 || d3 > d) {
                    PointSetPanel.this.errorReporter.reportValidationError(string2 + " must be in the range 0 to " + d);
                    return;
                }
                boolean bl = false;
                boolean bl2 = false;
                switch (n2) {
                    case 2: {
                        if (n4 != studyPoint.latitudeDegrees) {
                            studyPoint.latitudeDegrees = n4;
                            bl = true;
                        }
                        if (n3 != studyPoint.latitudeMinutes) {
                            studyPoint.latitudeMinutes = n3;
                            bl = true;
                            bl2 = true;
                        }
                        if (d2 == studyPoint.latitudeSeconds) break;
                        studyPoint.latitudeSeconds = d2;
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    case 3: {
                        if (n3 != studyPoint.latitudeMinutes) {
                            studyPoint.latitudeMinutes = n3;
                            bl = true;
                        }
                        if (d2 == studyPoint.latitudeSeconds) break;
                        studyPoint.latitudeSeconds = d2;
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    case 4: {
                        if (d2 == studyPoint.latitudeSeconds) break;
                        studyPoint.latitudeSeconds = d2;
                        bl = true;
                        break;
                    }
                    case 6: {
                        if (n4 != studyPoint.longitudeDegrees) {
                            studyPoint.longitudeDegrees = n4;
                            bl = true;
                        }
                        if (n3 != studyPoint.longitudeMinutes) {
                            studyPoint.longitudeMinutes = n3;
                            bl = true;
                            bl2 = true;
                        }
                        if (d2 == studyPoint.longitudeSeconds) break;
                        studyPoint.longitudeSeconds = d2;
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    case 7: {
                        if (n3 != studyPoint.longitudeMinutes) {
                            studyPoint.longitudeMinutes = n3;
                            bl = true;
                        }
                        if (d2 == studyPoint.longitudeSeconds) break;
                        studyPoint.longitudeSeconds = d2;
                        bl = true;
                        bl2 = true;
                        break;
                    }
                    case 8: {
                        if (d2 == studyPoint.longitudeSeconds) break;
                        studyPoint.longitudeSeconds = d2;
                        bl = true;
                    }
                }
                if (bl) {
                    studyPoint.updateLatLon();
                    PointSetPanel.this.setDidEdit();
                }
                if (bl2) {
                    this.fireTableRowsUpdated(n, n);
                }
            }
        }
    }
}

